
module ol_vamp_1_ppvvv_uxdwwxwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_uxdwwxwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_uxdwwxwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv_uxdwwxwx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv_uxdwwxwx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,18) :: G0
  complex(REALKIND), dimension(4,5,4,54) :: G1
  complex(REALKIND), dimension(4,15,4,51) :: G2
  complex(REALKIND), dimension(4,35,4,16) :: G3
  complex(REALKIND), dimension(4,70,4,2) :: G4
  complex(REALKIND), dimension(5,12) :: G1tensor
  complex(REALKIND), dimension(15,29) :: G2tensor
  complex(REALKIND), dimension(35,12) :: G3tensor
  complex(REALKIND), dimension(70,2) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,2),ZERO,G1(:,:,:,1))
  call loop_QW_A(G1(:,:,:,1),wf(:,33),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,30),ZERO,G2(:,:,:,1))
  call check_last_QA_V(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,1))
  call loop_QW_A(G1(:,:,:,1),wf(:,94),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,30),ZERO,G2(:,:,:,2))
  call check_last_QA_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,2))
  call loop_QW_A(G1(:,:,:,1),wf(:,96),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,30),ZERO,G2(:,:,:,3))
  call check_last_QA_V(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,3))
  call loop_QW_A(G1(:,:,:,1),wf(:,98),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,30),ZERO,G2(:,:,:,4))
  call check_last_QA_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,6),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,14),ZERO,G2(:,:,:,5))
  call loop_QW_A(G2(:,:,:,5),wf(:,-4),G2(:,:,:,6))
  call loop_Q_A(G2(:,:,:,6),Q(:,30),ZERO,G3(:,:,:,1))
  call check_last_QA_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,8),G1(:,:,:,7),gZd)
  call loop_Q_A(G1(:,:,:,7),Q(:,14),ZERO,G2(:,:,:,7))
  call loop_QW_A(G2(:,:,:,7),wf(:,-4),G2(:,:,:,8))
  call loop_Q_A(G2(:,:,:,8),Q(:,30),ZERO,G3(:,:,:,2))
  call check_last_QA_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,2))
  call loop_QW_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,18),ZERO,G2(:,:,:,9))
  call loop_QV_A(G2(:,:,:,9),wf(:,6),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,30),ZERO,G3(:,:,:,3))
  call check_last_QA_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,3))
  call loop_QZ_A(G2(:,:,:,9),wf(:,8),G2(:,:,:,11),gZu)
  call loop_Q_A(G2(:,:,:,11),Q(:,30),ZERO,G3(:,:,:,4))
  call check_last_QA_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,4))
  call loop_QW_A(G2(:,:,:,9),wf(:,-2),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,22),ZERO,G3(:,:,:,5))
  call loop_QW_A(G3(:,:,:,5),wf(:,-3),G3(:,:,:,6))
  call loop_Q_A(G3(:,:,:,6),Q(:,30),ZERO,G4(:,:,:,1))
  call check_last_QA_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_QW_A(G1(:,:,:,1),wf(:,100),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,30),ZERO,G2(:,:,:,13))
  call check_last_QA_V(l_switch,G2(:,:,:,13),wf(:,0),G2tensor(:,5))
  call loop_QW_A(G1(:,:,:,1),wf(:,102),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,30),ZERO,G2(:,:,:,14))
  call check_last_QA_V(l_switch,G2(:,:,:,14),wf(:,0),G2tensor(:,6))
  call loop_QW_A(G1(:,:,:,1),wf(:,104),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,30),ZERO,G2(:,:,:,15))
  call check_last_QA_V(l_switch,G2(:,:,:,15),wf(:,0),G2tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,22),ZERO,G2(:,:,:,16))
  call loop_QW_A(G2(:,:,:,16),wf(:,-3),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,30),ZERO,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,5))
  call loop_QZ_A(G1(:,:,:,1),wf(:,13),G1(:,:,:,13),gZd)
  call loop_Q_A(G1(:,:,:,13),Q(:,22),ZERO,G2(:,:,:,18))
  call loop_QW_A(G2(:,:,:,18),wf(:,-3),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,30),ZERO,G3(:,:,:,8))
  call check_last_QA_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,6))
  call loop_QW_A(G1(:,:,:,1),wf(:,-3),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,10),ZERO,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,11),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,30),ZERO,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,20),wf(:,13),G2(:,:,:,22),gZu)
  call loop_Q_A(G2(:,:,:,22),Q(:,30),ZERO,G3(:,:,:,10))
  call check_last_QA_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,8))
  call loop_QW_A(G2(:,:,:,20),wf(:,-2),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,14),ZERO,G3(:,:,:,11))
  call loop_QW_A(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,30),ZERO,G4(:,:,:,2))
  call check_last_QA_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,17),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,18),ZERO,G1(:,:,:,15))
  call loop_QW_A(G1(:,:,:,15),wf(:,-2),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,22),ZERO,G2(:,:,:,24))
  call check_last_QA_V(l_switch,G2(:,:,:,24),wf(:,16),G2tensor(:,8))
  call loop_QW_A(G2(:,:,:,24),wf(:,-3),G2(:,:,:,25))
  call loop_Q_A(G2(:,:,:,25),Q(:,30),ZERO,G3(:,:,:,13))
  call check_last_QA_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,15),wf(:,6),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,30),ZERO,G2(:,:,:,26))
  call check_last_QA_V(l_switch,G2(:,:,:,26),wf(:,0),G2tensor(:,9))
  call loop_QZ_A(G1(:,:,:,15),wf(:,8),G1(:,:,:,18),gZu)
  call loop_Q_A(G1(:,:,:,18),Q(:,30),ZERO,G2(:,:,:,27))
  call check_last_QA_V(l_switch,G2(:,:,:,27),wf(:,0),G2tensor(:,10))
  call check_last_QA_V(l_switch,G1(:,:,:,15),wf(:,71),G1tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,15),wf(:,90),G1tensor(:,2))
  call check_last_QA_V(l_switch,G1(:,:,:,15),wf(:,92),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,9),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,11),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,29),ZERO,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,-1),G2tensor(:,11))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,13),G1(:,:,:,21),gZd)
  call loop_A_Q(G1(:,:,:,21),Q(:,29),ZERO,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,-1),G2tensor(:,12))
  call loop_AW_Q(G1(:,:,:,19),wf(:,-2),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,13),ZERO,G2(:,:,:,30))
  call loop_AW_Q(G2(:,:,:,30),wf(:,-4),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,29),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-1),G3tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,71),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,13),ZERO,G1(:,:,:,23))
  call loop_AW_Q(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,29),ZERO,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,-1),G2tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,23),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,17),ZERO,G1(:,:,:,25))
  call loop_AW_Q(G1(:,:,:,25),wf(:,-2),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,21),ZERO,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,24),G2tensor(:,14))
  call loop_AW_Q(G2(:,:,:,33),wf(:,-3),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,29),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-1),G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,25),wf(:,6),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,29),ZERO,G2(:,:,:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,35),wf(:,-1),G2tensor(:,15))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,8),G1(:,:,:,28),gZd)
  call loop_A_Q(G1(:,:,:,28),Q(:,29),ZERO,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,-1),G2tensor(:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,25),wf(:,78),G1tensor(:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,25),wf(:,86),G1tensor(:,5))
  call check_last_AQ_V(l_switch,G1(:,:,:,25),wf(:,88),G1tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,10),ZERO,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,11),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,30),ZERO,G2(:,:,:,37))
  call check_last_QA_V(l_switch,G2(:,:,:,37),wf(:,0),G2tensor(:,17))
  call loop_QZ_A(G1(:,:,:,29),wf(:,13),G1(:,:,:,31),gZu)
  call loop_Q_A(G1(:,:,:,31),Q(:,30),ZERO,G2(:,:,:,38))
  call check_last_QA_V(l_switch,G2(:,:,:,38),wf(:,0),G2tensor(:,18))
  call loop_QW_A(G1(:,:,:,29),wf(:,-2),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,14),ZERO,G2(:,:,:,39))
  call loop_QW_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,30),ZERO,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,0),G3tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,78),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,14),ZERO,G1(:,:,:,33))
  call loop_QW_A(G1(:,:,:,33),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,30),ZERO,G2(:,:,:,41))
  call check_last_QA_V(l_switch,G2(:,:,:,41),wf(:,0),G2tensor(:,19))
  call loop_VA_Q(G0(:,:,:,1),wf(:,90),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,13),ZERO,G1(:,:,:,35))
  call loop_AW_Q(G1(:,:,:,35),wf(:,-4),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,29),ZERO,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,-1),G2tensor(:,20))
  call loop_VA_Q(G0(:,:,:,1),wf(:,92),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,13),ZERO,G1(:,:,:,37))
  call loop_AW_Q(G1(:,:,:,37),wf(:,-4),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,29),ZERO,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,-1),G2tensor(:,21))
  call loop_VQ_A(G0(:,:,:,1),wf(:,86),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,14),ZERO,G1(:,:,:,39))
  call loop_QW_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,30),ZERO,G2(:,:,:,44))
  call check_last_QA_V(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,22))
  call loop_VQ_A(G0(:,:,:,1),wf(:,88),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,14),ZERO,G1(:,:,:,41))
  call loop_QW_A(G1(:,:,:,41),wf(:,-4),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,30),ZERO,G2(:,:,:,45))
  call check_last_QA_V(l_switch,G2(:,:,:,45),wf(:,0),G2tensor(:,23))
  call loop_VA_Q(G0(:,:,:,1),wf(:,80),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,21),ZERO,G1(:,:,:,43))
  call loop_AW_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,29),ZERO,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,-1),G2tensor(:,24))
  call check_last_AQ_V(l_switch,G1(:,:,:,43),wf(:,24),G1tensor(:,7))
  call loop_VQ_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,22),ZERO,G1(:,:,:,45))
  call loop_QW_A(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,30),ZERO,G2(:,:,:,47))
  call check_last_QA_V(l_switch,G2(:,:,:,47),wf(:,0),G2tensor(:,25))
  call check_last_QA_V(l_switch,G1(:,:,:,45),wf(:,16),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,82),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,21),ZERO,G1(:,:,:,47))
  call loop_AW_Q(G1(:,:,:,47),wf(:,-3),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,29),ZERO,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,-1),G2tensor(:,26))
  call check_last_AQ_V(l_switch,G1(:,:,:,47),wf(:,24),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,1),wf(:,84),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,21),ZERO,G1(:,:,:,49))
  call loop_AW_Q(G1(:,:,:,49),wf(:,-3),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,29),ZERO,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,-1),G2tensor(:,27))
  call check_last_AQ_V(l_switch,G1(:,:,:,49),wf(:,24),G1tensor(:,10))
  call loop_VQ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,22),ZERO,G1(:,:,:,51))
  call loop_QW_A(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,30),ZERO,G2(:,:,:,50))
  call check_last_QA_V(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,28))
  call check_last_QA_V(l_switch,G1(:,:,:,51),wf(:,16),G1tensor(:,11))
  call loop_VQ_A(G0(:,:,:,1),wf(:,75),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,22),ZERO,G1(:,:,:,53))
  call loop_QW_A(G1(:,:,:,53),wf(:,-3),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,30),ZERO,G2(:,:,:,51))
  call check_last_QA_V(l_switch,G2(:,:,:,51),wf(:,0),G2tensor(:,29))
  call check_last_QA_V(l_switch,G1(:,:,:,53),wf(:,16),G1tensor(:,12))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(1)*M(1)) * den(28)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(4)*M(1)) * den(16)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(6)*M(1))) * den(17)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(5)*M(1)) * den(18)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(4)*M(1)) * den(33)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(4)*M(1)) * den(14)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(4)*M(1)) * den(21)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(7)*M(1)) * den(22)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(5)*M(1)) * den(23)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(4)*M(1)) * den(40)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(4)*M(1)) * den(20)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(6)*M(1))) * den(24)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(5)*M(1)) * den(25)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(7)*M(1)) * den(26)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(5)*M(1)) * den(27)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(7)*M(1)) * den(53)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(5)*M(1)) * den(55)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(6)*M(1))) * den(49)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(5)*M(1)) * den(51)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(3)*M(1))) * den(57)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(8)*M(1)) * den(58)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(2)*M(1)) * den(59)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(6)*M(1))) * den(4)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(5)*M(1)) * den(6)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(7)*M(1)) * den(4)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(5)*M(1)) * den(6)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(4)*M(1)) * den(43)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(4)*M(1)) * den(19)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(4)*M(1)) * den(30)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(4)*M(1)) * den(15)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(7)*M(1)) * den(45)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(5)*M(1)) * den(47)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(6)*M(1))) * den(35)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(5)*M(1)) * den(37)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(3)*M(1))) * den(60)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(8)*M(1)) * den(61)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(2)*M(1)) * den(62)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(6)*M(1))) * den(10)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(5)*M(1)) * den(12)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(7)*M(1)) * den(10)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(5)*M(1)) * den(12)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(4)*M(1))
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(4)*M(1))
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(4)*M(1)) * den(34)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(4)*M(1)) * den(31)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(6)*M(1))) * den(36)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(5)*M(1)) * den(38)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(4)*M(1)) * den(44)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(4)*M(1)) * den(41)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(7)*M(1)) * den(46)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(5)*M(1)) * den(48)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(6)*M(1))) * den(50)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(5)*M(1)) * den(52)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(7)*M(1)) * den(54)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(5)*M(1)) * den(56)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,3)

end subroutine vamp_1

end module ol_vamp_1_ppvvv_uxdwwxwx_1_/**/REALKIND
