
module ol_vamp_1_ppvvv_uuxawwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_uuxawwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_uuxawwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv_uuxawwx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv_uuxawwx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,18) :: G0
  complex(REALKIND), dimension(4,5,4,52) :: G1
  complex(REALKIND), dimension(4,15,4,50) :: G2
  complex(REALKIND), dimension(4,35,4,18) :: G3
  complex(REALKIND), dimension(4,70,4,3) :: G4
  complex(REALKIND), dimension(5,12) :: G1tensor
  complex(REALKIND), dimension(15,27) :: G2tensor
  complex(REALKIND), dimension(35,12) :: G3tensor
  complex(REALKIND), dimension(70,3) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,2),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,30),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,34),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,30),ZERO,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,91),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,30),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,92),G1(:,:,:,5),gZu)
  call loop_A_Q(G1(:,:,:,5),Q(:,30),ZERO,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,4))
  call loop_AW_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,18),ZERO,G2(:,:,:,5))
  call loop_AW_Q(G2(:,:,:,5),wf(:,6),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,30),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_AW_Q(G2(:,:,:,5),wf(:,-3),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,26),ZERO,G3(:,:,:,2))
  call loop_AV_Q(G3(:,:,:,2),wf(:,-2),G3(:,:,:,3))
  call loop_A_Q(G3(:,:,:,3),Q(:,30),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,22),ZERO,G3(:,:,:,4))
  call loop_AW_Q(G3(:,:,:,4),wf(:,-3),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,30),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,93),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,30),ZERO,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,0),G2tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,94),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,30),ZERO,G2(:,:,:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,6))
  call loop_AW_Q(G1(:,:,:,1),wf(:,10),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,22),ZERO,G2(:,:,:,11))
  call loop_AW_Q(G2(:,:,:,11),wf(:,-3),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,30),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,0),G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,18),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,26),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,30),ZERO,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,20),G1(:,:,:,11),gZu)
  call loop_A_Q(G1(:,:,:,11),Q(:,26),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-2),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,30),ZERO,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,6),ZERO,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,18),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,30),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,17),wf(:,20),G2(:,:,:,19),gZu)
  call loop_A_Q(G2(:,:,:,19),Q(:,30),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,6))
  call loop_AW_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,22),ZERO,G3(:,:,:,11))
  call loop_AW_Q(G3(:,:,:,11),wf(:,-3),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,30),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,18),ZERO,G1(:,:,:,13))
  call loop_AW_Q(G1(:,:,:,13),wf(:,-3),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,26),ZERO,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,15),G2tensor(:,7))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-2),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,30),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,22),ZERO,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,24),G2tensor(:,8))
  call loop_AW_Q(G2(:,:,:,23),wf(:,-3),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,30),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,0),G3tensor(:,8))
  call loop_AW_Q(G1(:,:,:,13),wf(:,6),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,30),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,0),G2tensor(:,9))
  call check_last_AQ_V(l_switch,G1(:,:,:,13),wf(:,70),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,13),wf(:,86),G1tensor(:,2))
  call check_last_AQ_V(l_switch,G1(:,:,:,13),wf(:,90),G1tensor(:,3))
  call loop_VQ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,5),ZERO,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,18),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,29),ZERO,G2(:,:,:,26))
  call check_last_QA_V(l_switch,G2(:,:,:,26),wf(:,-1),G2tensor(:,10))
  call loop_QZ_A(G1(:,:,:,17),wf(:,20),G1(:,:,:,19),gZu)
  call loop_Q_A(G1(:,:,:,19),Q(:,29),ZERO,G2(:,:,:,27))
  call check_last_QA_V(l_switch,G2(:,:,:,27),wf(:,-1),G2tensor(:,11))
  call loop_QW_A(G1(:,:,:,17),wf(:,-3),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,13),ZERO,G2(:,:,:,28))
  call loop_QW_A(G2(:,:,:,28),wf(:,-4),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,29),ZERO,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-1),G3tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,13),ZERO,G1(:,:,:,21))
  call loop_QW_A(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,29),ZERO,G2(:,:,:,30))
  call check_last_QA_V(l_switch,G2(:,:,:,30),wf(:,-1),G2tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,24),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,9),ZERO,G1(:,:,:,23))
  call loop_QW_A(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,25),ZERO,G2(:,:,:,31))
  call check_last_QA_V(l_switch,G2(:,:,:,31),wf(:,25),G2tensor(:,13))
  call loop_QV_A(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,29),ZERO,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-1),G3tensor(:,10))
  call loop_QW_A(G1(:,:,:,23),wf(:,10),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,29),ZERO,G2(:,:,:,33))
  call check_last_QA_V(l_switch,G2(:,:,:,33),wf(:,-1),G2tensor(:,14))
  call loop_QV_A(G1(:,:,:,23),wf(:,-2),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,13),ZERO,G2(:,:,:,34))
  call loop_QW_A(G2(:,:,:,34),wf(:,-4),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,29),ZERO,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-1),G3tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,25),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,6),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,18),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,30),ZERO,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,0),G2tensor(:,15))
  call loop_AZ_Q(G1(:,:,:,27),wf(:,20),G1(:,:,:,29),gZu)
  call loop_A_Q(G1(:,:,:,29),Q(:,30),ZERO,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,0),G2tensor(:,16))
  call loop_AW_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,22),ZERO,G2(:,:,:,38))
  call loop_AW_Q(G2(:,:,:,38),wf(:,-3),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,30),ZERO,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,0),G3tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,77),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,22),ZERO,G1(:,:,:,31))
  call loop_AW_Q(G1(:,:,:,31),wf(:,-3),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,30),ZERO,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,17))
  call check_last_AQ_V(l_switch,G1(:,:,:,31),wf(:,24),G1tensor(:,4))
  call loop_VQ_A(G0(:,:,:,1),wf(:,86),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,13),ZERO,G1(:,:,:,33))
  call loop_QW_A(G1(:,:,:,33),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,29),ZERO,G2(:,:,:,41))
  call check_last_QA_V(l_switch,G2(:,:,:,41),wf(:,-1),G2tensor(:,18))
  call loop_VQ_A(G0(:,:,:,1),wf(:,79),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,25),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,-2),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,29),ZERO,G2(:,:,:,42))
  call check_last_QA_V(l_switch,G2(:,:,:,42),wf(:,-1),G2tensor(:,19))
  call check_last_QA_V(l_switch,G1(:,:,:,35),wf(:,25),G1tensor(:,5))
  call loop_VQ_A(G0(:,:,:,1),wf(:,90),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,13),ZERO,G1(:,:,:,37))
  call loop_QW_A(G1(:,:,:,37),wf(:,-4),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,29),ZERO,G2(:,:,:,43))
  call check_last_QA_V(l_switch,G2(:,:,:,43),wf(:,-1),G2tensor(:,20))
  call loop_VA_Q(G0(:,:,:,1),wf(:,85),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,22),ZERO,G1(:,:,:,39))
  call loop_AW_Q(G1(:,:,:,39),wf(:,-3),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,30),ZERO,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,39),wf(:,24),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,1),wf(:,68),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,26),ZERO,G1(:,:,:,41))
  call loop_AV_Q(G1(:,:,:,41),wf(:,-2),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,30),ZERO,G2(:,:,:,45))
  call check_last_AQ_V(l_switch,G2(:,:,:,45),wf(:,0),G2tensor(:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,41),wf(:,15),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,1),wf(:,88),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,22),ZERO,G1(:,:,:,43))
  call loop_AW_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,30),ZERO,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,0),G2tensor(:,23))
  call check_last_AQ_V(l_switch,G1(:,:,:,43),wf(:,24),G1tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,81),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,25),ZERO,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,-2),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,29),ZERO,G2(:,:,:,47))
  call check_last_QA_V(l_switch,G2(:,:,:,47),wf(:,-1),G2tensor(:,24))
  call check_last_QA_V(l_switch,G1(:,:,:,45),wf(:,25),G1tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,83),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,25),ZERO,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,-2),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,29),ZERO,G2(:,:,:,48))
  call check_last_QA_V(l_switch,G2(:,:,:,48),wf(:,-1),G2tensor(:,25))
  call check_last_QA_V(l_switch,G1(:,:,:,47),wf(:,25),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,72),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,26),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-2),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,30),ZERO,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,0),G2tensor(:,26))
  call check_last_AQ_V(l_switch,G1(:,:,:,49),wf(:,15),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,74),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,26),ZERO,G1(:,:,:,51))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-2),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,30),ZERO,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,27))
  call check_last_AQ_V(l_switch,G1(:,:,:,51),wf(:,15),G1tensor(:,12))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(2)*M(1))) * den(24)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(7)*M(1))) * den(25)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(4)*M(1)) * den(11)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(1)*M(1)) * den(13)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(6)*M(1)) * den(15)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(4)*M(1)) * den(30)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(4)*M(1)) * den(9)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(4)*M(1)) * den(18)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(1)*M(1)) * den(19)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(6)*M(1)) * den(20)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(4)*M(1)) * den(37)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(4)*M(1)) * den(17)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(3)*M(1))) * den(21)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(5)*M(1)) * den(22)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(3)*M(1))) * den(48)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(4)*M(1)) * den(40)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(4)*M(1)) * den(16)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(3)*M(1))) * den(16)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(5)*M(1)) * den(23)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(5)*M(1)) * den(52)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(2)*M(1)) * den(54)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(7)*M(1)) * den(55)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(5)*M(1)) * den(3)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(3)*M(1))) * den(46)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(4)*M(1)) * den(27)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(4)*M(1)) * den(10)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(3)*M(1))) * den(10)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(5)*M(1)) * den(50)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(2)*M(1)) * den(56)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(7)*M(1)) * den(57)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(5)*M(1)) * den(6)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(1)*M(1)) * den(42)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(6)*M(1)) * den(44)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(1)*M(1)) * den(32)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(6)*M(1)) * den(34)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(1)*M(1)) * den(12)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(6)*M(1)) * den(14)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(1)*M(1)) * den(12)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(6)*M(1)) * den(14)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(4)*M(1))
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(4)*M(1))
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(3)*M(1)))
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(4)*M(1)) * den(31)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(4)*M(1)) * den(28)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(1)*M(1)) * den(33)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(6)*M(1)) * den(35)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(4)*M(1)) * den(41)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(4)*M(1)) * den(38)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(1)*M(1)) * den(43)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(6)*M(1)) * den(45)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(3)*M(1))) * den(49)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(3)*M(1))) * den(47)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(5)*M(1)) * den(51)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(5)*M(1)) * den(53)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,3)

end subroutine vamp_1

end module ol_vamp_1_ppvvv_uuxawwx_1_/**/REALKIND
