
module ol_vamp_1_ppvvv_ddxzzz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_ddxzzz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_ddxzzz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv_ddxzzz_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv_ddxzzz_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,20) :: G0
  complex(REALKIND), dimension(4,5,4,49) :: G1
  complex(REALKIND), dimension(4,15,4,48) :: G2
  complex(REALKIND), dimension(4,35,4,24) :: G3
  complex(REALKIND), dimension(4,70,4,6) :: G4
  complex(REALKIND), dimension(5,12) :: G1tensor
  complex(REALKIND), dimension(15,21) :: G2tensor
  complex(REALKIND), dimension(35,12) :: G3tensor
  complex(REALKIND), dimension(70,6) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,10),ZERO,G1(:,:,:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2),gZd)
  call loop_A_Q(G1(:,:,:,2),Q(:,26),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,11),G2tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2),gZd)
  call loop_A_Q(G2(:,:,:,2),Q(:,30),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,3),gZd)
  call loop_A_Q(G1(:,:,:,3),Q(:,14),ZERO,G2(:,:,:,3))
  call loop_AZ_Q(G2(:,:,:,3),wf(:,-4),G2(:,:,:,4),gZd)
  call loop_A_Q(G2(:,:,:,4),Q(:,30),ZERO,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,18),ZERO,G1(:,:,:,4))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,-3),G1(:,:,:,5),gZd)
  call loop_A_Q(G1(:,:,:,5),Q(:,26),ZERO,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,11),G2tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6),gZd)
  call loop_A_Q(G2(:,:,:,6),Q(:,30),ZERO,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,-2),G1(:,:,:,6),gZd)
  call loop_A_Q(G1(:,:,:,6),Q(:,22),ZERO,G2(:,:,:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,7),wf(:,19),G2tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,7),wf(:,-3),G2(:,:,:,8),gZd)
  call loop_A_Q(G2(:,:,:,8),Q(:,30),ZERO,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,64),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,76),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,64),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,13),ZERO,G1(:,:,:,7))
  call loop_QZ_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8),gZd)
  call loop_Q_A(G1(:,:,:,8),Q(:,29),ZERO,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-1),G2tensor(:,4))
  call loop_VQ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,21),ZERO,G1(:,:,:,9))
  call loop_QZ_A(G1(:,:,:,9),wf(:,-3),G1(:,:,:,10),gZd)
  call loop_Q_A(G1(:,:,:,10),Q(:,29),ZERO,G2(:,:,:,10))
  call check_last_QA_V(l_switch,G2(:,:,:,10),wf(:,-1),G2tensor(:,5))
  call check_last_QA_V(l_switch,G1(:,:,:,9),wf(:,12),G1tensor(:,3))
  call loop_VQ_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,5),ZERO,G1(:,:,:,11))
  call loop_QZ_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,21),ZERO,G2(:,:,:,11))
  call loop_QZ_A(G2(:,:,:,11),wf(:,-3),G2(:,:,:,12),gZd)
  call loop_Q_A(G2(:,:,:,12),Q(:,29),ZERO,G3(:,:,:,5))
  call check_last_QA_V(l_switch,G3(:,:,:,5),wf(:,-1),G3tensor(:,5))
  call loop_QZ_A(G1(:,:,:,11),wf(:,-3),G1(:,:,:,13),gZd)
  call loop_Q_A(G1(:,:,:,13),Q(:,13),ZERO,G2(:,:,:,13))
  call loop_QZ_A(G2(:,:,:,13),wf(:,-4),G2(:,:,:,14),gZd)
  call loop_Q_A(G2(:,:,:,14),Q(:,29),ZERO,G3(:,:,:,6))
  call check_last_QA_V(l_switch,G3(:,:,:,6),wf(:,-1),G3tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,19),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,9),ZERO,G1(:,:,:,14))
  call loop_QZ_A(G1(:,:,:,14),wf(:,-4),G1(:,:,:,15),gZd)
  call loop_Q_A(G1(:,:,:,15),Q(:,25),ZERO,G2(:,:,:,15))
  call check_last_QA_V(l_switch,G2(:,:,:,15),wf(:,20),G2tensor(:,6))
  call loop_QZ_A(G2(:,:,:,15),wf(:,-2),G2(:,:,:,16),gZd)
  call loop_Q_A(G2(:,:,:,16),Q(:,29),ZERO,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,-1),G3tensor(:,7))
  call loop_QZ_A(G1(:,:,:,14),wf(:,-2),G1(:,:,:,16),gZd)
  call loop_Q_A(G1(:,:,:,16),Q(:,13),ZERO,G2(:,:,:,17))
  call loop_QZ_A(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18),gZd)
  call loop_Q_A(G2(:,:,:,18),Q(:,29),ZERO,G3(:,:,:,8))
  call check_last_QA_V(l_switch,G3(:,:,:,8),wf(:,-1),G3tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,17),ZERO,G1(:,:,:,17))
  call loop_QZ_A(G1(:,:,:,17),wf(:,-3),G1(:,:,:,18),gZd)
  call loop_Q_A(G1(:,:,:,18),Q(:,25),ZERO,G2(:,:,:,19))
  call check_last_QA_V(l_switch,G2(:,:,:,19),wf(:,20),G2tensor(:,7))
  call loop_QZ_A(G2(:,:,:,19),wf(:,-2),G2(:,:,:,20),gZd)
  call loop_Q_A(G2(:,:,:,20),Q(:,29),ZERO,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,-1),G3tensor(:,9))
  call loop_QZ_A(G1(:,:,:,17),wf(:,-2),G1(:,:,:,19),gZd)
  call loop_Q_A(G1(:,:,:,19),Q(:,21),ZERO,G2(:,:,:,21))
  call check_last_QA_V(l_switch,G2(:,:,:,21),wf(:,12),G2tensor(:,8))
  call loop_QZ_A(G2(:,:,:,21),wf(:,-3),G2(:,:,:,22),gZd)
  call loop_Q_A(G2(:,:,:,22),Q(:,29),ZERO,G3(:,:,:,10))
  call check_last_QA_V(l_switch,G3(:,:,:,10),wf(:,-1),G3tensor(:,10))
  call check_last_QA_V(l_switch,G1(:,:,:,17),wf(:,72),G1tensor(:,4))
  call check_last_QA_V(l_switch,G1(:,:,:,17),wf(:,78),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,72),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,14),ZERO,G1(:,:,:,20))
  call loop_AZ_Q(G1(:,:,:,20),wf(:,-4),G1(:,:,:,21),gZd)
  call loop_A_Q(G1(:,:,:,21),Q(:,30),ZERO,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,0),G2tensor(:,9))
  call loop_VA_Q(G0(:,:,:,1),wf(:,67),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,22),ZERO,G1(:,:,:,22))
  call loop_AZ_Q(G1(:,:,:,22),wf(:,-3),G1(:,:,:,23),gZd)
  call loop_A_Q(G1(:,:,:,23),Q(:,30),ZERO,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,0),G2tensor(:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,22),wf(:,19),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,1),wf(:,20),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,6),ZERO,G1(:,:,:,24))
  call loop_AZ_Q(G1(:,:,:,24),wf(:,-4),G1(:,:,:,25),gZd)
  call loop_A_Q(G1(:,:,:,25),Q(:,22),ZERO,G2(:,:,:,25))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,-3),G2(:,:,:,26),gZd)
  call loop_A_Q(G2(:,:,:,26),Q(:,30),ZERO,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,0),G3tensor(:,11))
  call loop_AZ_Q(G1(:,:,:,24),wf(:,-3),G1(:,:,:,26),gZd)
  call loop_A_Q(G1(:,:,:,26),Q(:,14),ZERO,G2(:,:,:,27))
  call loop_AZ_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,28),gZd)
  call loop_A_Q(G2(:,:,:,28),Q(:,30),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,76),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,13),ZERO,G1(:,:,:,27))
  call loop_QZ_A(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28),gZd)
  call loop_Q_A(G1(:,:,:,28),Q(:,29),ZERO,G2(:,:,:,29))
  call check_last_QA_V(l_switch,G2(:,:,:,29),wf(:,-1),G2tensor(:,11))
  call loop_VQ_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,25),ZERO,G1(:,:,:,29))
  call loop_QZ_A(G1(:,:,:,29),wf(:,-2),G1(:,:,:,30),gZd)
  call loop_Q_A(G1(:,:,:,30),Q(:,29),ZERO,G2(:,:,:,30))
  call check_last_QA_V(l_switch,G2(:,:,:,30),wf(:,-1),G2tensor(:,12))
  call check_last_QA_V(l_switch,G1(:,:,:,29),wf(:,20),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,1),wf(:,78),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,14),ZERO,G1(:,:,:,31))
  call loop_AZ_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,32),gZd)
  call loop_A_Q(G1(:,:,:,32),Q(:,30),ZERO,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,0),G2tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,58),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,26),ZERO,G1(:,:,:,33))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,-2),G1(:,:,:,34),gZd)
  call loop_A_Q(G1(:,:,:,34),Q(:,30),ZERO,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,0),G2tensor(:,14))
  call check_last_AQ_V(l_switch,G1(:,:,:,33),wf(:,11),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,2),ZERO,G1(:,:,:,35))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,81),G1(:,:,:,36),gZd)
  call loop_A_Q(G1(:,:,:,36),Q(:,30),ZERO,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,0),G2tensor(:,15))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,83),G1(:,:,:,37),gZd)
  call loop_A_Q(G1(:,:,:,37),Q(:,30),ZERO,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,0),G2tensor(:,16))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,85),G1(:,:,:,38),gZd)
  call loop_A_Q(G1(:,:,:,38),Q(:,30),ZERO,G2(:,:,:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,35),wf(:,0),G2tensor(:,17))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,-3),G1(:,:,:,39),gZd)
  call loop_A_Q(G1(:,:,:,39),Q(:,10),ZERO,G2(:,:,:,36))
  call loop_AZ_Q(G2(:,:,:,36),wf(:,-4),G2(:,:,:,37),gZd)
  call loop_A_Q(G2(:,:,:,37),Q(:,26),ZERO,G3(:,:,:,13))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14),gZd)
  call loop_A_Q(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,36),wf(:,-2),G2(:,:,:,38),gZd)
  call loop_A_Q(G2(:,:,:,38),Q(:,14),ZERO,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16),gZd)
  call loop_A_Q(G3(:,:,:,16),Q(:,30),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,-4),G1(:,:,:,40),gZd)
  call loop_A_Q(G1(:,:,:,40),Q(:,18),ZERO,G2(:,:,:,39))
  call loop_AZ_Q(G2(:,:,:,39),wf(:,-3),G2(:,:,:,40),gZd)
  call loop_A_Q(G2(:,:,:,40),Q(:,26),ZERO,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,-2),G3(:,:,:,18),gZd)
  call loop_A_Q(G3(:,:,:,18),Q(:,30),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,39),wf(:,-2),G2(:,:,:,41),gZd)
  call loop_A_Q(G2(:,:,:,41),Q(:,22),ZERO,G3(:,:,:,19))
  call loop_AZ_Q(G3(:,:,:,19),wf(:,-3),G3(:,:,:,20),gZd)
  call loop_A_Q(G3(:,:,:,20),Q(:,30),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,-2),G1(:,:,:,41),gZd)
  call loop_A_Q(G1(:,:,:,41),Q(:,6),ZERO,G2(:,:,:,42))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,-4),G2(:,:,:,43),gZd)
  call loop_A_Q(G2(:,:,:,43),Q(:,22),ZERO,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,-3),G3(:,:,:,22),gZd)
  call loop_A_Q(G3(:,:,:,22),Q(:,30),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,-3),G2(:,:,:,44),gZd)
  call loop_A_Q(G2(:,:,:,44),Q(:,14),ZERO,G3(:,:,:,23))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24),gZd)
  call loop_A_Q(G3(:,:,:,24),Q(:,30),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,79),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,21),ZERO,G1(:,:,:,42))
  call loop_QZ_A(G1(:,:,:,42),wf(:,-3),G1(:,:,:,43),gZd)
  call loop_Q_A(G1(:,:,:,43),Q(:,29),ZERO,G2(:,:,:,45))
  call check_last_QA_V(l_switch,G2(:,:,:,45),wf(:,-1),G2tensor(:,18))
  call check_last_QA_V(l_switch,G1(:,:,:,42),wf(:,12),G1tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,25),ZERO,G1(:,:,:,44))
  call loop_QZ_A(G1(:,:,:,44),wf(:,-2),G1(:,:,:,45),gZd)
  call loop_Q_A(G1(:,:,:,45),Q(:,29),ZERO,G2(:,:,:,46))
  call check_last_QA_V(l_switch,G2(:,:,:,46),wf(:,-1),G2tensor(:,19))
  call check_last_QA_V(l_switch,G1(:,:,:,44),wf(:,20),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,75),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,22),ZERO,G1(:,:,:,46))
  call loop_AZ_Q(G1(:,:,:,46),wf(:,-3),G1(:,:,:,47),gZd)
  call loop_A_Q(G1(:,:,:,47),Q(:,30),ZERO,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,0),G2tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,19),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,62),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,26),ZERO,G1(:,:,:,48))
  call loop_AZ_Q(G1(:,:,:,48),wf(:,-2),G1(:,:,:,49),gZd)
  call loop_A_Q(G1(:,:,:,49),Q(:,30),ZERO,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,48),wf(:,11),G1tensor(:,12))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(1)*M(1))) * den(10)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(1)*M(1))) * den(12)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(1)*M(1))) * den(29)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(1)*M(1))) * den(24)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(1)*M(1))) * den(8)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(1)*M(1))) * den(8)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(1)*M(1))) * den(15)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(1)*M(1))) * den(17)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(1)*M(1))) * den(38)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(32)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(1)*M(1))) * den(14)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(14)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(1)*M(1))) * den(18)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(44)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(35)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(1)*M(1))) * den(13)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(1)*M(1))) * den(13)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(1)*M(1))) * den(19)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(1)*M(1))) * den(46)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(1)*M(1))) * den(21)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(2)*M(1)) * den(51)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(1)*M(1))) * den(48)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(1)*M(1))) * den(40)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(1)*M(1))) * den(16)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(16)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(1)*M(1))) * den(42)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(1)*M(1))) * den(26)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(1)*M(1))) * den(11)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(11)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(2)*M(1)) * den(52)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(2)*M(1)) * den(53)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,5)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(1)*M(1))) * den(25)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(22)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(1)*M(1))) * den(30)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(1)*M(1))) * den(27)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(1)*M(1))) * den(36)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(1)*M(1))) * den(33)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(1)*M(1))) * den(41)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(1)*M(1))) * den(39)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(1)*M(1))) * den(45)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(1)*M(1))) * den(43)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(49)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(47)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,5)

end subroutine vamp_1

end module ol_vamp_1_ppvvv_ddxzzz_1_/**/REALKIND
