
module ol_vamp_1_ppvvv_bbxazz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_bbxazz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_bbxazz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv_bbxazz_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv_bbxazz_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,22) :: G0
  complex(REALKIND), dimension(4,5,4,53) :: G1
  complex(REALKIND), dimension(4,15,4,52) :: G2
  complex(REALKIND), dimension(4,35,4,26) :: G3
  complex(REALKIND), dimension(4,70,4,6) :: G4
  complex(REALKIND), dimension(5,14) :: G1tensor
  complex(REALKIND), dimension(15,22) :: G2tensor
  complex(REALKIND), dimension(35,14) :: G3tensor
  complex(REALKIND), dimension(70,6) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,10),MB,G1(:,:,:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2),gZd)
  call loop_A_Q(G1(:,:,:,2),Q(:,26),MB,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,3),G2tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,30),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,14),MB,G2(:,:,:,3))
  call loop_AZ_Q(G2(:,:,:,3),wf(:,-4),G2(:,:,:,4),gZd)
  call loop_A_Q(G2(:,:,:,4),Q(:,30),MB,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,18),MB,G1(:,:,:,4))
  call loop_AZ_Q(G1(:,:,:,4),wf(:,-3),G1(:,:,:,5),gZd)
  call loop_A_Q(G1(:,:,:,5),Q(:,26),MB,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,3),G2tensor(:,2))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-2),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,30),MB,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-2),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,22),MB,G2(:,:,:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,7),wf(:,13),G2tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,7),wf(:,-3),G2(:,:,:,8),gZd)
  call loop_A_Q(G2(:,:,:,8),Q(:,30),MB,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,58),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,74),G1tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,5),MB,G1(:,:,:,7))
  call loop_QS_A(G1(:,:,:,7),wf(:,9),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,29),MB,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-1),G2tensor(:,4))
  call loop_QZ_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,9),gZd)
  call loop_Q_A(G1(:,:,:,9),Q(:,21),MB,G2(:,:,:,10))
  call loop_QZ_A(G2(:,:,:,10),wf(:,-3),G2(:,:,:,11),gZd)
  call loop_Q_A(G2(:,:,:,11),Q(:,29),MB,G3(:,:,:,5))
  call check_last_QA_V(l_switch,G3(:,:,:,5),wf(:,-1),G3tensor(:,5))
  call loop_QZ_A(G1(:,:,:,7),wf(:,-3),G1(:,:,:,10),gZd)
  call loop_Q_A(G1(:,:,:,10),Q(:,13),MB,G2(:,:,:,12))
  call loop_QZ_A(G2(:,:,:,12),wf(:,-4),G2(:,:,:,13),gZd)
  call loop_Q_A(G2(:,:,:,13),Q(:,29),MB,G3(:,:,:,6))
  call check_last_QA_V(l_switch,G3(:,:,:,6),wf(:,-1),G3tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,13),MB,G1(:,:,:,11))
  call loop_QZ_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,29),MB,G2(:,:,:,14))
  call check_last_QA_V(l_switch,G2(:,:,:,14),wf(:,-1),G2tensor(:,5))
  call loop_VQ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,21),MB,G1(:,:,:,13))
  call loop_QZ_A(G1(:,:,:,13),wf(:,-3),G1(:,:,:,14),gZd)
  call loop_Q_A(G1(:,:,:,14),Q(:,29),MB,G2(:,:,:,15))
  call check_last_QA_V(l_switch,G2(:,:,:,15),wf(:,-1),G2tensor(:,6))
  call check_last_QA_V(l_switch,G1(:,:,:,13),wf(:,4),G1tensor(:,3))
  call loop_VQ_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,9),MB,G1(:,:,:,15))
  call loop_QZ_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,16),gZd)
  call loop_Q_A(G1(:,:,:,16),Q(:,25),MB,G2(:,:,:,16))
  call check_last_QA_V(l_switch,G2(:,:,:,16),wf(:,14),G2tensor(:,7))
  call loop_QV_A(G2(:,:,:,16),wf(:,-2),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,29),MB,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,-1),G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,15),wf(:,-2),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,13),MB,G2(:,:,:,18))
  call loop_QZ_A(G2(:,:,:,18),wf(:,-4),G2(:,:,:,19),gZd)
  call loop_Q_A(G2(:,:,:,19),Q(:,29),MB,G3(:,:,:,8))
  call check_last_QA_V(l_switch,G3(:,:,:,8),wf(:,-1),G3tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,17),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,17),MB,G1(:,:,:,18))
  call loop_QZ_A(G1(:,:,:,18),wf(:,-3),G1(:,:,:,19),gZd)
  call loop_Q_A(G1(:,:,:,19),Q(:,25),MB,G2(:,:,:,20))
  call check_last_QA_V(l_switch,G2(:,:,:,20),wf(:,14),G2tensor(:,8))
  call loop_QV_A(G2(:,:,:,20),wf(:,-2),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,29),MB,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,-1),G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,18),wf(:,-2),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,21),MB,G2(:,:,:,22))
  call check_last_QA_V(l_switch,G2(:,:,:,22),wf(:,4),G2tensor(:,9))
  call loop_QZ_A(G2(:,:,:,22),wf(:,-3),G2(:,:,:,23),gZd)
  call loop_Q_A(G2(:,:,:,23),Q(:,29),MB,G3(:,:,:,10))
  call check_last_QA_V(l_switch,G3(:,:,:,10),wf(:,-1),G3tensor(:,10))
  call check_last_QA_V(l_switch,G1(:,:,:,18),wf(:,68),G1tensor(:,4))
  call check_last_QA_V(l_switch,G1(:,:,:,18),wf(:,76),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,14),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,6),MB,G1(:,:,:,21))
  call loop_AS_Q(G1(:,:,:,21),wf(:,9),G1(:,:,:,22),gH)
  call loop_A_Q(G1(:,:,:,22),Q(:,30),MB,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,0),G2tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,23),gZd)
  call loop_A_Q(G1(:,:,:,23),Q(:,22),MB,G2(:,:,:,25))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,-3),G2(:,:,:,26),gZd)
  call loop_A_Q(G2(:,:,:,26),Q(:,30),MB,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,0),G3tensor(:,11))
  call loop_AZ_Q(G1(:,:,:,21),wf(:,-3),G1(:,:,:,24),gZd)
  call loop_A_Q(G1(:,:,:,24),Q(:,14),MB,G2(:,:,:,27))
  call loop_AZ_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,28),gZd)
  call loop_A_Q(G2(:,:,:,28),Q(:,30),MB,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,68),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,14),MB,G1(:,:,:,25))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,26),gZd)
  call loop_A_Q(G1(:,:,:,26),Q(:,30),MB,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,63),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,22),MB,G1(:,:,:,27))
  call loop_AZ_Q(G1(:,:,:,27),wf(:,-3),G1(:,:,:,28),gZd)
  call loop_A_Q(G1(:,:,:,28),Q(:,30),MB,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,0),G2tensor(:,12))
  call check_last_AQ_V(l_switch,G1(:,:,:,27),wf(:,13),G1tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,74),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,13),MB,G1(:,:,:,29))
  call loop_QZ_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,30),gZd)
  call loop_Q_A(G1(:,:,:,30),Q(:,29),MB,G2(:,:,:,31))
  call check_last_QA_V(l_switch,G2(:,:,:,31),wf(:,-1),G2tensor(:,13))
  call loop_VQ_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,25),MB,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,-2),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,29),MB,G2(:,:,:,32))
  call check_last_QA_V(l_switch,G2(:,:,:,32),wf(:,-1),G2tensor(:,14))
  call check_last_QA_V(l_switch,G1(:,:,:,31),wf(:,14),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,1),wf(:,76),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,14),MB,G1(:,:,:,33))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,-4),G1(:,:,:,34),gZd)
  call loop_A_Q(G1(:,:,:,34),Q(:,30),MB,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,0),G2tensor(:,15))
  call loop_VA_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,26),MB,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,-2),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,30),MB,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,0),G2tensor(:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,35),wf(:,3),G1tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,77),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,21),MB,G1(:,:,:,37))
  call loop_QZ_A(G1(:,:,:,37),wf(:,-3),G1(:,:,:,38),gZd)
  call loop_Q_A(G1(:,:,:,38),Q(:,29),MB,G2(:,:,:,35))
  call check_last_QA_V(l_switch,G2(:,:,:,35),wf(:,-1),G2tensor(:,17))
  call check_last_QA_V(l_switch,G1(:,:,:,37),wf(:,4),G1tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,25),MB,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,-2),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,29),MB,G2(:,:,:,36))
  call check_last_QA_V(l_switch,G2(:,:,:,36),wf(:,-1),G2tensor(:,18))
  call check_last_QA_V(l_switch,G1(:,:,:,39),wf(:,14),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,73),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,22),MB,G1(:,:,:,41))
  call loop_AZ_Q(G1(:,:,:,41),wf(:,-3),G1(:,:,:,42),gZd)
  call loop_A_Q(G1(:,:,:,42),Q(:,30),MB,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,0),G2tensor(:,19))
  call check_last_AQ_V(l_switch,G1(:,:,:,41),wf(:,13),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,56),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,26),MB,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-2),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,30),MB,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,0),G2tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,43),wf(:,3),G1tensor(:,12))
  call loop_VQ_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,25),MB,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,-2),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,29),MB,G2(:,:,:,39))
  call check_last_QA_V(l_switch,G2(:,:,:,39),wf(:,-1),G2tensor(:,21))
  call check_last_QA_V(l_switch,G1(:,:,:,45),wf(:,14),G1tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,60),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,26),MB,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-2),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,30),MB,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,47),wf(:,3),G1tensor(:,14))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,2),MB,G1(:,:,:,49))
  call loop_AS_Q(G1(:,:,:,49),wf(:,9),G1(:,:,:,50),gH)
  call loop_A_Q(G1(:,:,:,50),Q(:,26),MB,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,30),MB,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-2),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,6),MB,G2(:,:,:,43))
  call loop_AS_Q(G2(:,:,:,43),wf(:,9),G2(:,:,:,44),gH)
  call loop_A_Q(G2(:,:,:,44),Q(:,30),MB,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,0),G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,-4),G2(:,:,:,45),gZd)
  call loop_A_Q(G2(:,:,:,45),Q(:,22),MB,G3(:,:,:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,-3),G3(:,:,:,16),gZd)
  call loop_A_Q(G3(:,:,:,16),Q(:,30),MB,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,-3),G2(:,:,:,46),gZd)
  call loop_A_Q(G2(:,:,:,46),Q(:,14),MB,G3(:,:,:,17))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,-4),G3(:,:,:,18),gZd)
  call loop_A_Q(G3(:,:,:,18),Q(:,30),MB,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,49),wf(:,-3),G1(:,:,:,52),gZd)
  call loop_A_Q(G1(:,:,:,52),Q(:,10),MB,G2(:,:,:,47))
  call loop_AZ_Q(G2(:,:,:,47),wf(:,-4),G2(:,:,:,48),gZd)
  call loop_A_Q(G2(:,:,:,48),Q(:,26),MB,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-2),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,30),MB,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,14),MB,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,-4),G3(:,:,:,22),gZd)
  call loop_A_Q(G3(:,:,:,22),Q(:,30),MB,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,49),wf(:,-4),G1(:,:,:,53),gZd)
  call loop_A_Q(G1(:,:,:,53),Q(:,18),MB,G2(:,:,:,50))
  call loop_AZ_Q(G2(:,:,:,50),wf(:,-3),G2(:,:,:,51),gZd)
  call loop_A_Q(G2(:,:,:,51),Q(:,26),MB,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,30),MB,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,50),wf(:,-2),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,22),MB,G3(:,:,:,25))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,-3),G3(:,:,:,26),gZd)
  call loop_A_Q(G3(:,:,:,26),Q(:,30),MB,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,6))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(1)*M(1))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(1)*M(1))) * den(5)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(2)*M(1)) * den(7)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(1)*M(1))) * den(25)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(1)*M(1))) * den(20)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(1)*M(1))) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(1)*M(1))) * den(1)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(1)*M(1))) * den(10)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(1)*M(1))) * den(12)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(2)*M(1)) * den(13)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(1)*M(1))) * den(36)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(30)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(9)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(1)*M(1))) * den(14)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(44)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(1)*M(1))) * den(33)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(1)*M(1))) * den(8)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(1)*M(1))) * den(8)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(1)*M(1))) * den(15)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(46)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(1)*M(1))) * den(17)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(1)*M(1))) * den(2)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(1)*M(1))) * den(2)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(1)*M(1))) * den(48)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(1)*M(1))) * den(38)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(1)*M(1))) * den(11)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(11)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(1)*M(1))) * den(42)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(1)*M(1))) * den(22)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(1)*M(1))) * den(4)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(4)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(2)*M(1)) * den(40)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(2)*M(1)) * den(27)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(2)*M(1)) * den(6)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(2)*M(1)) * den(6)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,5)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(1)*M(1)))
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(1)*M(1))) * den(21)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(1)*M(1))) * den(18)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(1)*M(1))) * den(26)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(1)*M(1))) * den(23)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(2)*M(1)) * den(28)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(1)*M(1))) * den(34)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(1)*M(1))) * den(31)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(1)*M(1))) * den(39)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(1)*M(1))) * den(37)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*M(1)) * den(41)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(1)*M(1))) * den(45)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(1)*M(1))) * den(43)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(1)*M(1))) * den(49)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(1)*M(1))) * den(47)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,5)

end subroutine vamp_1

end module ol_vamp_1_ppvvv_bbxazz_1_/**/REALKIND
