
module ol_vamp_1_ppvvv_bbxawwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvv_bbxawwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvv_bbxawwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvv_bbxawwx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvv_bbxawwx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,20) :: G0
  complex(REALKIND), dimension(4,5,4,61) :: G1
  complex(REALKIND), dimension(4,15,4,59) :: G2
  complex(REALKIND), dimension(4,35,4,20) :: G3
  complex(REALKIND), dimension(4,70,4,3) :: G4
  complex(REALKIND), dimension(5,14) :: G1tensor
  complex(REALKIND), dimension(15,33) :: G2tensor
  complex(REALKIND), dimension(35,14) :: G3tensor
  complex(REALKIND), dimension(70,3) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,2),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,30),MB,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,40),G1(:,:,:,3),gZd)
  call loop_A_Q(G1(:,:,:,3),Q(:,30),MB,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,2))
  call loop_AS_Q(G1(:,:,:,1),wf(:,108),G1(:,:,:,4),gH)
  call loop_A_Q(G1(:,:,:,4),Q(:,30),MB,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,109),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,30),MB,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,110),G1(:,:,:,6),gZd)
  call loop_A_Q(G1(:,:,:,6),Q(:,30),MB,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,0),G2tensor(:,5))
  call loop_AW_Q(G1(:,:,:,1),wf(:,7),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,14),MT,G2(:,:,:,6))
  call loop_AW_Q(G2(:,:,:,6),wf(:,-4),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,30),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,111),G1(:,:,:,8),gH)
  call loop_A_Q(G1(:,:,:,8),Q(:,30),MB,G2(:,:,:,8))
  call check_last_AQ_V(l_switch,G2(:,:,:,8),wf(:,0),G2tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,112),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,30),MB,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,0),G2tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,113),G1(:,:,:,10),gZd)
  call loop_A_Q(G1(:,:,:,10),Q(:,30),MB,G2(:,:,:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,8))
  call loop_AW_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,10),MT,G2(:,:,:,11))
  call loop_AW_Q(G2(:,:,:,11),wf(:,12),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,30),MB,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,2))
  call loop_AW_Q(G2(:,:,:,11),wf(:,-4),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,26),MB,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,30),MB,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,14),MT,G3(:,:,:,5))
  call loop_AW_Q(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,30),MB,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AS_Q(G1(:,:,:,1),wf(:,21),G1(:,:,:,12),gH)
  call loop_A_Q(G1(:,:,:,12),Q(:,26),MB,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-2),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,30),MB,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,23),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,26),MB,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-2),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,30),MB,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,25),G1(:,:,:,14),gZd)
  call loop_A_Q(G1(:,:,:,14),Q(:,26),MB,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-2),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,30),MB,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,6),MB,G2(:,:,:,21))
  call loop_AS_Q(G2(:,:,:,21),wf(:,21),G2(:,:,:,22),gH)
  call loop_A_Q(G2(:,:,:,22),Q(:,30),MB,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,21),wf(:,23),G2(:,:,:,23))
  call loop_A_Q(G2(:,:,:,23),Q(:,30),MB,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,0),G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,25),G2(:,:,:,24),gZd)
  call loop_A_Q(G2(:,:,:,24),Q(:,30),MB,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,8))
  call loop_AW_Q(G2(:,:,:,21),wf(:,-3),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,14),MT,G3(:,:,:,13))
  call loop_AW_Q(G3(:,:,:,13),wf(:,-4),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,30),MB,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,10),MT,G1(:,:,:,16))
  call loop_AW_Q(G1(:,:,:,16),wf(:,-4),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,26),MB,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,18),G2tensor(:,9))
  call loop_AV_Q(G2(:,:,:,26),wf(:,-2),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,30),MB,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,0),G3tensor(:,9))
  call loop_AW_Q(G1(:,:,:,16),wf(:,12),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,30),MB,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,0),G2tensor(:,10))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-2),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,14),MT,G2(:,:,:,29))
  call loop_AW_Q(G2(:,:,:,29),wf(:,-4),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,30),MB,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,0),G3tensor(:,10))
  call loop_VQ_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,5),MB,G1(:,:,:,20))
  call loop_QS_A(G1(:,:,:,20),wf(:,21),G1(:,:,:,21),gH)
  call loop_Q_A(G1(:,:,:,21),Q(:,29),MB,G2(:,:,:,31))
  call check_last_QA_V(l_switch,G2(:,:,:,31),wf(:,-1),G2tensor(:,11))
  call loop_QV_A(G1(:,:,:,20),wf(:,23),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,29),MB,G2(:,:,:,32))
  call check_last_QA_V(l_switch,G2(:,:,:,32),wf(:,-1),G2tensor(:,12))
  call loop_QZ_A(G1(:,:,:,20),wf(:,25),G1(:,:,:,23),gZd)
  call loop_Q_A(G1(:,:,:,23),Q(:,29),MB,G2(:,:,:,33))
  call check_last_QA_V(l_switch,G2(:,:,:,33),wf(:,-1),G2tensor(:,13))
  call loop_QW_A(G1(:,:,:,20),wf(:,-4),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,21),MT,G2(:,:,:,34))
  call loop_QW_A(G2(:,:,:,34),wf(:,-3),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,29),MB,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-1),G3tensor(:,11))
  call loop_VQ_A(G0(:,:,:,1),wf(:,83),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,21),MT,G1(:,:,:,25))
  call loop_QW_A(G1(:,:,:,25),wf(:,-3),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,29),MB,G2(:,:,:,36))
  call check_last_QA_V(l_switch,G2(:,:,:,36),wf(:,-1),G2tensor(:,14))
  call check_last_QA_V(l_switch,G1(:,:,:,25),wf(:,19),G1tensor(:,1))
  call loop_VQ_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,17),MT,G1(:,:,:,27))
  call loop_QW_A(G1(:,:,:,27),wf(:,-3),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,25),MB,G2(:,:,:,37))
  call check_last_QA_V(l_switch,G2(:,:,:,37),wf(:,30),G2tensor(:,15))
  call loop_QV_A(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,29),MB,G3(:,:,:,18))
  call check_last_QA_V(l_switch,G3(:,:,:,18),wf(:,-1),G3tensor(:,12))
  call loop_QV_A(G1(:,:,:,27),wf(:,-2),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,21),MT,G2(:,:,:,39))
  call check_last_QA_V(l_switch,G2(:,:,:,39),wf(:,19),G2tensor(:,16))
  call loop_QW_A(G2(:,:,:,39),wf(:,-3),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,29),MB,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-1),G3tensor(:,13))
  call loop_QW_A(G1(:,:,:,27),wf(:,7),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,29),MB,G2(:,:,:,41))
  call check_last_QA_V(l_switch,G2(:,:,:,41),wf(:,-1),G2tensor(:,17))
  call check_last_QA_V(l_switch,G1(:,:,:,27),wf(:,92),G1tensor(:,2))
  call check_last_QA_V(l_switch,G1(:,:,:,27),wf(:,102),G1tensor(:,3))
  call check_last_QA_V(l_switch,G1(:,:,:,27),wf(:,107),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,6),MB,G1(:,:,:,31))
  call loop_AS_Q(G1(:,:,:,31),wf(:,21),G1(:,:,:,32),gH)
  call loop_A_Q(G1(:,:,:,32),Q(:,30),MB,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,0),G2tensor(:,18))
  call loop_AV_Q(G1(:,:,:,31),wf(:,23),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,30),MB,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,0),G2tensor(:,19))
  call loop_AZ_Q(G1(:,:,:,31),wf(:,25),G1(:,:,:,34),gZd)
  call loop_A_Q(G1(:,:,:,34),Q(:,30),MB,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,20))
  call loop_AW_Q(G1(:,:,:,31),wf(:,-3),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,14),MT,G2(:,:,:,45))
  call loop_AW_Q(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,30),MB,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,0),G3tensor(:,14))
  call loop_VA_Q(G0(:,:,:,1),wf(:,92),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,14),MT,G1(:,:,:,36))
  call loop_AW_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,30),MB,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,0),G2tensor(:,21))
  call loop_VA_Q(G0(:,:,:,1),wf(:,102),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,14),MT,G1(:,:,:,38))
  call loop_AW_Q(G1(:,:,:,38),wf(:,-4),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,30),MB,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,22))
  call loop_VA_Q(G0(:,:,:,1),wf(:,81),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,26),MB,G1(:,:,:,40))
  call loop_AV_Q(G1(:,:,:,40),wf(:,-2),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,30),MB,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,0),G2tensor(:,23))
  call check_last_AQ_V(l_switch,G1(:,:,:,40),wf(:,18),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,107),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,14),MT,G1(:,:,:,42))
  call loop_AW_Q(G1(:,:,:,42),wf(:,-4),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,30),MB,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,24))
  call loop_VQ_A(G0(:,:,:,1),wf(:,103),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,21),MT,G1(:,:,:,44))
  call loop_QW_A(G1(:,:,:,44),wf(:,-3),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,29),MB,G2(:,:,:,51))
  call check_last_QA_V(l_switch,G2(:,:,:,51),wf(:,-1),G2tensor(:,25))
  call check_last_QA_V(l_switch,G1(:,:,:,44),wf(:,19),G1tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,94),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,25),MB,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,-2),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,29),MB,G2(:,:,:,52))
  call check_last_QA_V(l_switch,G2(:,:,:,52),wf(:,-1),G2tensor(:,26))
  call check_last_QA_V(l_switch,G1(:,:,:,46),wf(:,30),G1tensor(:,7))
  call loop_VQ_A(G0(:,:,:,1),wf(:,105),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,21),MT,G1(:,:,:,48))
  call loop_QW_A(G1(:,:,:,48),wf(:,-3),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,29),MB,G2(:,:,:,53))
  call check_last_QA_V(l_switch,G2(:,:,:,53),wf(:,-1),G2tensor(:,27))
  call check_last_QA_V(l_switch,G1(:,:,:,48),wf(:,19),G1tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,25),MB,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,-2),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,29),MB,G2(:,:,:,54))
  call check_last_QA_V(l_switch,G2(:,:,:,54),wf(:,-1),G2tensor(:,28))
  call check_last_QA_V(l_switch,G1(:,:,:,50),wf(:,30),G1tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,98),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,25),MB,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,-2),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,29),MB,G2(:,:,:,55))
  call check_last_QA_V(l_switch,G2(:,:,:,55),wf(:,-1),G2tensor(:,29))
  call check_last_QA_V(l_switch,G1(:,:,:,52),wf(:,30),G1tensor(:,10))
  call loop_VQ_A(G0(:,:,:,1),wf(:,100),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,25),MB,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,-2),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,29),MB,G2(:,:,:,56))
  call check_last_QA_V(l_switch,G2(:,:,:,56),wf(:,-1),G2tensor(:,30))
  call check_last_QA_V(l_switch,G1(:,:,:,54),wf(:,30),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,85),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,26),MB,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-2),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,30),MB,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,0),G2tensor(:,31))
  call check_last_AQ_V(l_switch,G1(:,:,:,56),wf(:,18),G1tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,87),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,26),MB,G1(:,:,:,58))
  call loop_AV_Q(G1(:,:,:,58),wf(:,-2),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,30),MB,G2(:,:,:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,0),G2tensor(:,32))
  call check_last_AQ_V(l_switch,G1(:,:,:,58),wf(:,18),G1tensor(:,13))
  call loop_VA_Q(G0(:,:,:,1),wf(:,89),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,26),MB,G1(:,:,:,60))
  call loop_AV_Q(G1(:,:,:,60),wf(:,-2),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,30),MB,G2(:,:,:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,59),wf(:,0),G2tensor(:,33))
  call check_last_AQ_V(l_switch,G1(:,:,:,60),wf(:,18),G1tensor(:,14))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(2)*M(1)) * den(30)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(9)*M(1))) * den(31)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(3)*M(1))) * den(14)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(6)*M(1)) * den(16)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(1)*M(1)) * den(18)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(8)*M(1))) * den(20)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(3)*M(1))) * den(36)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(3)*M(1))) * den(12)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(3)*M(1))) * den(23)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(6)*M(1)) * den(24)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(1)*M(1)) * den(25)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(8)*M(1))) * den(26)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(3)*M(1))) * den(45)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(3)*M(1))) * den(22)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(4)*M(1)) * den(27)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(5)*M(1)) * den(28)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(4)*M(1)) * den(56)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(3)*M(1))) * den(33)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(3)*M(1))) * den(13)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(4)*M(1)) * den(13)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(5)*M(1)) * den(29)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(5)*M(1)) * den(62)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(7)*M(1))) * den(65)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(2)*M(1))) * den(66)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(9)*M(1)) * den(67)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(5)*M(1)) * den(4)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(4)*M(1)) * den(58)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(3)*M(1))) * den(48)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(3)*M(1))) * den(21)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(4)*M(1)) * den(21)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(5)*M(1)) * den(60)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(7)*M(1))) * den(68)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(2)*M(1))) * den(69)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(9)*M(1)) * den(70)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(5)*M(1)) * den(8)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(6)*M(1)) * den(50)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(1)*M(1)) * den(52)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(8)*M(1))) * den(54)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(6)*M(1)) * den(38)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(1)*M(1)) * den(40)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(8)*M(1))) * den(42)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(6)*M(1)) * den(15)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(1)*M(1)) * den(17)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(8)*M(1))) * den(19)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(6)*M(1)) * den(15)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(1)*M(1)) * den(17)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(8)*M(1))) * den(19)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(3)*M(1)))
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(3)*M(1)))
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(4)*M(1))
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(3)*M(1))) * den(37)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(3)*M(1))) * den(34)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(6)*M(1)) * den(39)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(1)*M(1)) * den(41)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(8)*M(1))) * den(43)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(3)*M(1))) * den(49)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(3)*M(1))) * den(46)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(6)*M(1)) * den(51)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(1)*M(1)) * den(53)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(8)*M(1))) * den(55)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(4)*M(1)) * den(59)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(4)*M(1)) * den(57)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(5)*M(1)) * den(61)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(5)*M(1)) * den(63)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,4)

end subroutine vamp_1

end module ol_vamp_1_ppvvv_bbxawwx_1_/**/REALKIND
