
module ol_colourmatrix_ppvvv_udxzzw_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  3]
  K1( 2,:) = [  4]
  K1( 3,:) = [ -4]
  K1( 4,:) = [  4]
  K1( 5,:) = [  0]
  K1( 6,:) = [  0]
  K1( 7,:) = [  0]
  K1( 8,:) = [  0]
  K1( 9,:) = [  0]
  K1(10,:) = [  0]
  K1(11,:) = [  0]
  K1(12,:) = [  0]
  K1(13,:) = [  0]
  K1(14,:) = [  0]
  K1(15,:) = [  0]
  K1(16,:) = [  0]
  K1(17,:) = [  0]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvv_udxzzw_1_/**/REALKIND



module ol_forced_parameters_ppvvv_udxzzw_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvv_udxzzw_1_/**/REALKIND

module ol_loop_ppvvv_udxzzw_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(14), c(4)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:109)
  ! denominators
  complex(REALKIND), save :: den(65)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,108)
  ! zero helicity identifier
  logical,           save :: zerohel(108) = .true., zerohel_ct(108) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*cw**2*eQED**3)/(sqrt2*sw**3)
    f( 2) = (CI*countertermnorm*ctVqq*cw**2*eQED**3*gQCD**2)/(sqrt2*sw**3)
    f( 3) = (CI*eQED**3*MW**2)/(cw**2*sqrt2*sw**3)
    f( 4) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW**2)/(cw**2*sqrt2*sw**3)
    f( 5) = (CI*cw*eQED**3)/(sqrt2*sw**2)
    f( 6) = (CI*countertermnorm*cw*eQED**3*gQCD**2)/(sqrt2*sw**2)
    f( 7) = (CI*countertermnorm*ctVqq*cw*eQED**3*gQCD**2)/(sqrt2*sw**2)
    f( 8) = (CI*eQED**3)/(sqrt2*sw)
    f( 9) = (CI*countertermnorm*eQED**3*gQCD**2)/(sqrt2*sw)
    f(10) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(sqrt2*sw)
    f(11) = (cw**2*eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw**3)
    f(12) = (eQED**3*gQCD**2*integralnorm*MW**2*SwB)/(cw**2*sqrt2*sw**3)
    f(13) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw**2)
    f(14) = (eQED**3*gQCD**2*integralnorm*SwB)/(sqrt2*sw)

  c = [ 4*f(11), 4*f(12), 4*f(13), 4*f(14) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(60)
  ! external WFs
  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_V(P(:,3), rMZ, H(3), wf(:,-2))
  call wf_V(P(:,4), rMZ, H(4), wf(:,-3))
  call wf_V(P(:,5), rMW, H(5), wf(:,-4))

  ! internal WFs
  call vert_QA_W(wf(:,0),wf(:,-1),wf(:,1))
  call vert_WWV_V(wf(:,-2),wf(:,-3),wf(:,-4),wf(:,2))
  call prop_W_W(wf(:,1),Q(:,3),MW,1_intkind1,wf(:,3))
  call vert_VV_S(wf(:,-2),wf(:,-3),wf(:,4))
  call vert_VV_S(wf(:,3),wf(:,-4),wf(:,5))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-2),Q(:,4),wf(:,6))
  call prop_W_W(wf(:,6),Q(:,20),MW,1_intkind1,wf(:,7))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,3),Q(:,3),wf(:,8))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-3),Q(:,8),wf(:,9))
  call prop_W_W(wf(:,9),Q(:,24),MW,1_intkind1,wf(:,10))
  call vert_UV_W(wf(:,-2),Q(:,4),wf(:,3),Q(:,3),wf(:,11))
  call vert_ZQ_A(gZu,wf(:,-2),wf(:,0),wf(:,12))
  call vert_AZ_Q(gZd,wf(:,-1),wf(:,-3),wf(:,13))
  call prop_Q_A(wf(:,12),Q(:,5),ZERO,0_intkind1,wf(:,14))
  call prop_A_Q(wf(:,13),Q(:,10),ZERO,0_intkind1,wf(:,15))
  call vert_WQ_A(wf(:,-4),wf(:,14),wf(:,16))
  call vert_AW_Q(wf(:,-1),wf(:,-4),wf(:,17))
  call prop_A_Q(wf(:,17),Q(:,18),ZERO,0_intkind1,wf(:,18))
  call vert_ZQ_A(gZu,wf(:,-3),wf(:,14),wf(:,19))
  call vert_QA_W(wf(:,14),wf(:,-1),wf(:,20))
  call vert_ZQ_A(gZu,wf(:,-3),wf(:,0),wf(:,21))
  call vert_AZ_Q(gZd,wf(:,-1),wf(:,-2),wf(:,22))
  call prop_Q_A(wf(:,21),Q(:,9),ZERO,0_intkind1,wf(:,23))
  call prop_A_Q(wf(:,22),Q(:,6),ZERO,0_intkind1,wf(:,24))
  call vert_WQ_A(wf(:,-4),wf(:,23),wf(:,25))
  call vert_WQ_A(wf(:,-4),wf(:,0),wf(:,26))
  call prop_Q_A(wf(:,26),Q(:,17),ZERO,0_intkind1,wf(:,27))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,27),wf(:,28))
  call vert_QA_W(wf(:,0),wf(:,24),wf(:,29))
  call vert_ZQ_A(gZu,wf(:,-2),wf(:,23),wf(:,30))
  call vert_QA_W(wf(:,23),wf(:,-1),wf(:,31))
  call vert_ZQ_A(gZd,wf(:,-2),wf(:,27),wf(:,32))
  call vert_QA_W(wf(:,0),wf(:,15),wf(:,33))
  call counter_QA_W(wf(:,0),wf(:,-1),wf(:,34))
  call prop_W_W(wf(:,2),Q(:,28),MW,1_intkind1,wf(:,35))
  call counter_WQ_A(wf(:,-4),wf(:,14),wf(:,36))
  call counter_ZQ_A(gZu,wf(:,-3),wf(:,14),wf(:,37))
  call counter_WQ_A(wf(:,-4),wf(:,23),wf(:,38))
  call counter_ZQ_A(gZd,wf(:,-3),wf(:,27),wf(:,39))
  call counter_ZQ_A(gZu,wf(:,-2),wf(:,23),wf(:,40))
  call counter_ZQ_A(gZd,wf(:,-2),wf(:,27),wf(:,41))
  call counter_QA_W(wf(:,14),wf(:,-1),wf(:,42))
  call counter_AW_Q(wf(:,-1),wf(:,-4),wf(:,43))
  call prop_A_Q(wf(:,43),Q(:,18),ZERO,0_intkind1,wf(:,44))
  call counter_AZ_Q(gZd,wf(:,-1),wf(:,-3),wf(:,45))
  call prop_A_Q(wf(:,45),Q(:,10),ZERO,0_intkind1,wf(:,46))
  call counter_QA_W(wf(:,23),wf(:,-1),wf(:,47))
  call vert_QA_W(wf(:,0),wf(:,46),wf(:,48))
  call counter_AZ_Q(gZd,wf(:,-1),wf(:,-2),wf(:,49))
  call prop_A_Q(wf(:,49),Q(:,6),ZERO,0_intkind1,wf(:,50))
  call vert_QA_W(wf(:,0),wf(:,50),wf(:,51))
  call counter_QA_W(wf(:,0),wf(:,24),wf(:,52))
  call counter_WQ_A(wf(:,-4),wf(:,0),wf(:,53))
  call prop_Q_A(wf(:,53),Q(:,17),ZERO,0_intkind1,wf(:,54))
  call vert_ZQ_A(gZd,wf(:,-3),wf(:,54),wf(:,55))
  call counter_ZQ_A(gZu,wf(:,-3),wf(:,0),wf(:,56))
  call prop_Q_A(wf(:,56),Q(:,9),ZERO,0_intkind1,wf(:,57))
  call vert_WQ_A(wf(:,-4),wf(:,57),wf(:,58))
  call counter_QA_W(wf(:,0),wf(:,15),wf(:,59))
  call vert_ZQ_A(gZd,wf(:,-2),wf(:,54),wf(:,60))
  call vert_ZQ_A(gZu,wf(:,-2),wf(:,57),wf(:,61))
  call vert_QA_W(wf(:,57),wf(:,-1),wf(:,62))
  call counter_ZQ_A(gZu,wf(:,-2),wf(:,0),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,5),ZERO,0_intkind1,wf(:,64))
  call vert_WQ_A(wf(:,-4),wf(:,64),wf(:,65))
  call vert_ZQ_A(gZu,wf(:,-3),wf(:,64),wf(:,66))
  call vert_QA_W(wf(:,64),wf(:,-1),wf(:,67))
  call prop_W_W(wf(:,34),Q(:,3),MW,1_intkind1,wf(:,68))
  call vert_VV_S(wf(:,68),wf(:,-4),wf(:,69))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,68),Q(:,3),wf(:,70))
  call vert_UV_W(wf(:,-2),Q(:,4),wf(:,68),Q(:,3),wf(:,71))
  call vert_AW_Q(wf(:,15),wf(:,-4),wf(:,72))
  call counter_Q_A(ctqq,wf(:,14),Q(:,5),wf(:,73))
  call prop_A_Q(wf(:,72),Q(:,26),ZERO,0_intkind1,wf(:,74))
  call counter_A_Q(ctqq,wf(:,15),Q(:,10),wf(:,75))
  call prop_Q_A(wf(:,16),Q(:,21),ZERO,0_intkind1,wf(:,76))
  call vert_AZ_Q(gZu,wf(:,18),wf(:,-3),wf(:,77))
  call prop_A_Q(wf(:,77),Q(:,26),ZERO,0_intkind1,wf(:,78))
  call counter_A_Q(ctqq,wf(:,18),Q(:,18),wf(:,79))
  call prop_Q_A(wf(:,19),Q(:,13),ZERO,0_intkind1,wf(:,80))
  call vert_AW_Q(wf(:,-1),wf(:,10),wf(:,81))
  call prop_A_Q(wf(:,81),Q(:,26),ZERO,0_intkind1,wf(:,82))
  call vert_AW_Q(wf(:,24),wf(:,-4),wf(:,83))
  call counter_Q_A(ctqq,wf(:,23),Q(:,9),wf(:,84))
  call prop_A_Q(wf(:,83),Q(:,22),ZERO,0_intkind1,wf(:,85))
  call counter_A_Q(ctqq,wf(:,24),Q(:,6),wf(:,86))
  call prop_Q_A(wf(:,25),Q(:,25),ZERO,0_intkind1,wf(:,87))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,-3),wf(:,88))
  call counter_Q_A(ctqq,wf(:,27),Q(:,17),wf(:,89))
  call prop_A_Q(wf(:,88),Q(:,14),ZERO,0_intkind1,wf(:,90))
  call prop_Q_A(wf(:,28),Q(:,25),ZERO,0_intkind1,wf(:,91))
  call vert_WQ_A(wf(:,10),wf(:,0),wf(:,92))
  call prop_Q_A(wf(:,92),Q(:,25),ZERO,0_intkind1,wf(:,93))
  call vert_AZ_Q(gZu,wf(:,18),wf(:,-2),wf(:,94))
  call prop_A_Q(wf(:,94),Q(:,22),ZERO,0_intkind1,wf(:,95))
  call prop_Q_A(wf(:,30),Q(:,13),ZERO,0_intkind1,wf(:,96))
  call vert_AW_Q(wf(:,-1),wf(:,7),wf(:,97))
  call prop_A_Q(wf(:,97),Q(:,22),ZERO,0_intkind1,wf(:,98))
  call vert_AZ_Q(gZd,wf(:,15),wf(:,-2),wf(:,99))
  call prop_A_Q(wf(:,99),Q(:,14),ZERO,0_intkind1,wf(:,100))
  call prop_Q_A(wf(:,32),Q(:,21),ZERO,0_intkind1,wf(:,101))
  call vert_WQ_A(wf(:,7),wf(:,0),wf(:,102))
  call prop_Q_A(wf(:,102),Q(:,21),ZERO,0_intkind1,wf(:,103))
  call vert_SV_V(wf(:,4),wf(:,-4),wf(:,104))
  call prop_W_W(wf(:,104),Q(:,28),MW,1_intkind1,wf(:,105))
  call vert_UV_W(wf(:,7),Q(:,20),wf(:,-3),Q(:,8),wf(:,106))
  call prop_W_W(wf(:,106),Q(:,28),MW,1_intkind1,wf(:,107))
  call vert_UV_W(wf(:,10),Q(:,24),wf(:,-2),Q(:,4),wf(:,108))
  call prop_W_W(wf(:,108),Q(:,28),MW,1_intkind1,wf(:,109))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MW2)
  den(2) = 1 / (Q(5,12) - MH2)
  den(4) = 1 / (Q(5,20) - MW2)
  den(6) = 1 / (Q(5,24) - MW2)
  den(8) = 1 / (Q(5,5))
  den(9) = 1 / (Q(5,10))
  den(11) = 1 / (Q(5,18))
  den(14) = 1 / (Q(5,9))
  den(15) = 1 / (Q(5,6))
  den(17) = 1 / (Q(5,17))
  den(24) = 1 / (Q(5,28) - MW2)
  den(25) = 1 / (Q(5,26))
  den(28) = 1 / (Q(5,21))
  den(33) = 1 / (Q(5,13))
  den(38) = 1 / (Q(5,22))
  den(41) = 1 / (Q(5,25))
  den(44) = 1 / (Q(5,14))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(10) = den(8)*den(9)
  den(12) = den(8)*den(11)
  den(13) = den(6)*den(8)
  den(16) = den(14)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(6)*den(15)
  den(20) = den(11)*den(14)
  den(21) = den(4)*den(14)
  den(22) = den(9)*den(17)
  den(23) = den(4)*den(9)
  den(26) = den(9)*den(25)
  den(27) = den(8)*den(26)
  den(29) = den(8)*den(28)
  den(30) = den(9)*den(29)
  den(31) = den(11)*den(25)
  den(32) = den(8)*den(31)
  den(34) = den(8)*den(33)
  den(35) = den(11)*den(34)
  den(36) = den(6)*den(25)
  den(37) = den(8)*den(36)
  den(39) = den(15)*den(38)
  den(40) = den(14)*den(39)
  den(42) = den(14)*den(41)
  den(43) = den(15)*den(42)
  den(45) = den(15)*den(44)
  den(46) = den(17)*den(45)
  den(47) = den(17)*den(41)
  den(48) = den(15)*den(47)
  den(49) = den(6)*den(41)
  den(50) = den(15)*den(49)
  den(51) = den(11)*den(38)
  den(52) = den(14)*den(51)
  den(53) = den(14)*den(33)
  den(54) = den(11)*den(53)
  den(55) = den(4)*den(38)
  den(56) = den(14)*den(55)
  den(57) = den(9)*den(44)
  den(58) = den(17)*den(57)
  den(59) = den(17)*den(28)
  den(60) = den(9)*den(59)
  den(61) = den(4)*den(28)
  den(62) = den(9)*den(61)
  den(63) = den(2)*den(24)
  den(64) = den(4)*den(24)
  den(65) = den(6)*den(24)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(60)

  A(1) = cont_VV(wf(:,2),wf(:,3)) * den(1)
  A(2) = cont_SS(wf(:,4),wf(:,5)) * den(3)
  A(3) = cont_VV(wf(:,7),wf(:,8)) * den(5)
  A(4) = cont_VV(wf(:,10),wf(:,11)) * den(7)
  A(5) = cont_QA(wf(:,15),wf(:,16)) * den(10)
  A(6) = cont_QA(wf(:,18),wf(:,19)) * den(12)
  A(7) = cont_VV(wf(:,10),wf(:,20)) * den(13)
  A(8) = cont_QA(wf(:,24),wf(:,25)) * den(16)
  A(9) = cont_QA(wf(:,24),wf(:,28)) * den(18)
  A(10) = cont_VV(wf(:,10),wf(:,29)) * den(19)
  A(11) = cont_QA(wf(:,18),wf(:,30)) * den(20)
  A(12) = cont_VV(wf(:,7),wf(:,31)) * den(21)
  A(13) = cont_QA(wf(:,15),wf(:,32)) * den(22)
  A(14) = cont_VV(wf(:,7),wf(:,33)) * den(23)

  A(15) = cont_VV(wf(:,34),wf(:,35)) * den(24)
  A(16) = cont_QA(wf(:,15),wf(:,36)) * den(10)
  A(17) = cont_QA(wf(:,18),wf(:,37)) * den(12)
  A(18) = cont_QA(wf(:,24),wf(:,38)) * den(16)
  A(19) = cont_QA(wf(:,24),wf(:,39)) * den(18)
  A(20) = cont_QA(wf(:,18),wf(:,40)) * den(20)
  A(21) = cont_QA(wf(:,15),wf(:,41)) * den(22)
  A(22) = cont_VV(wf(:,10),wf(:,42)) * den(13)
  A(23) = cont_QA(wf(:,19),wf(:,44)) * den(12)
  A(24) = cont_QA(wf(:,16),wf(:,46)) * den(10)
  A(25) = cont_VV(wf(:,7),wf(:,47)) * den(21)
  A(26) = cont_QA(wf(:,30),wf(:,44)) * den(20)
  A(27) = cont_QA(wf(:,32),wf(:,46)) * den(22)
  A(28) = cont_VV(wf(:,7),wf(:,48)) * den(23)
  A(29) = cont_QA(wf(:,25),wf(:,50)) * den(16)
  A(30) = cont_QA(wf(:,28),wf(:,50)) * den(18)
  A(31) = cont_VV(wf(:,10),wf(:,51)) * den(19)
  A(32) = cont_VV(wf(:,10),wf(:,52)) * den(19)
  A(33) = cont_QA(wf(:,24),wf(:,55)) * den(18)
  A(34) = cont_QA(wf(:,24),wf(:,58)) * den(16)
  A(35) = cont_VV(wf(:,7),wf(:,59)) * den(23)
  A(36) = cont_QA(wf(:,15),wf(:,60)) * den(22)
  A(37) = cont_QA(wf(:,18),wf(:,61)) * den(20)
  A(38) = cont_VV(wf(:,7),wf(:,62)) * den(21)
  A(39) = cont_QA(wf(:,15),wf(:,65)) * den(10)
  A(40) = cont_QA(wf(:,18),wf(:,66)) * den(12)
  A(41) = cont_VV(wf(:,10),wf(:,67)) * den(13)
  A(42) = cont_SS(wf(:,4),wf(:,69)) * den(3)
  A(43) = cont_VV(wf(:,7),wf(:,70)) * den(5)
  A(44) = cont_VV(wf(:,10),wf(:,71)) * den(7)
  A(45) = cont_QA(wf(:,73),wf(:,74)) * den(27)
  A(46) = cont_QA(wf(:,75),wf(:,76)) * den(30)
  A(47) = cont_QA(wf(:,73),wf(:,78)) * den(32)
  A(48) = cont_QA(wf(:,79),wf(:,80)) * den(35)
  A(49) = cont_QA(wf(:,73),wf(:,82)) * den(37)
  A(50) = cont_QA(wf(:,84),wf(:,85)) * den(40)
  A(51) = cont_QA(wf(:,86),wf(:,87)) * den(43)
  A(52) = cont_QA(wf(:,89),wf(:,90)) * den(46)
  A(53) = cont_QA(wf(:,86),wf(:,91)) * den(48)
  A(54) = cont_QA(wf(:,86),wf(:,93)) * den(50)
  A(55) = cont_QA(wf(:,84),wf(:,95)) * den(52)
  A(56) = cont_QA(wf(:,79),wf(:,96)) * den(54)
  A(57) = cont_QA(wf(:,84),wf(:,98)) * den(56)
  A(58) = cont_QA(wf(:,89),wf(:,100)) * den(58)
  A(59) = cont_QA(wf(:,75),wf(:,101)) * den(60)
  A(60) = cont_QA(wf(:,75),wf(:,103)) * den(62)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(60)
  complex(REALKIND), intent(out) :: M1(1), M2(1)

  M1(1) = (A(1)-A(3)-A(4))*f(1)+A(2)*f(3)+(-A(7)-A(10)-A(12)-A(14))*f(5)+(-A(5)-A(6)-A(8)-A(9)-A(11)-A(13))*f(8)

  M2(1) = (A(15)-A(43)-A(44))*f(2)+A(42)*f(4)+(A(49)+A(54)+A(57)+A(60))*f(6)+(-A(22)-A(25)-A(28)-A(31)-A(32)-A(35)-A(38) &
       -A(41))*f(7)+(A(45)+A(46)+A(47)+A(48)+A(50)+A(51)+A(52)+A(53)+A(55)+A(56)+A(58)+A(59))*f(9)+(-A(16)-A(17)-A(18)-A(19)-A(20) &
       -A(21)-A(23)-A(24)-A(26)-A(27)-A(29)-A(30)-A(33)-A(34)-A(36)-A(37)-A(39)-A(40))*f(10)

end subroutine colourvectors

end module ol_loop_ppvvv_udxzzw_1_/**/REALKIND
