
module ol_vamp_1_pptt_ttxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptt_ttxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptt_ttxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptt_ttxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptt_ttxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(3)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,24) :: G0
  complex(REALKIND), dimension(4,5,4,46) :: G1
  complex(REALKIND), dimension(4,15,4,36) :: G2
  complex(REALKIND), dimension(4,35,4,6) :: G3
  complex(REALKIND), dimension(5,14) :: G1tensor
  complex(REALKIND), dimension(15,15) :: G2tensor
  complex(REALKIND), dimension(35,15) :: G3tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,-2),G0(:,:,:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-1),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,14),MT,G1(:,:,:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,1),wf(:,0),G1tensor(:,1))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,12),wf(:,1),Q(:,3),G1tensor(:,2))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-2),wf(:,-3),G0(:,:,:,4))
  call loop_VA_Q(G0(:,:,:,4),wf(:,-1),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,14),MT,G1(:,:,:,2))
  call check_last_AQ_V(l_switch,G1(:,:,:,2),wf(:,0),G1tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,12),wf(:,1),Q(:,3),G1tensor(:,4))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,-2),G0(:,:,:,6))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-1),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,14),MT,G1(:,:,:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,3),wf(:,0),G1tensor(:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,12),wf(:,1),Q(:,3),G1tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,4),ZERO,G1(:,:,:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-3),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,12),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,15),ZERO,G3tensor(:,1))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,4),MT,G1(:,:,:,6))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-3),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,12),MT,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,15),MT,G3tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,4),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,-3),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,12),ZERO,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,15),ZERO,G3tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,4),MT,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-3),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,12),MT,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,15),MT,G3tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,4),MB,G1(:,:,:,12))
  call loop_AV_Q(G1(:,:,:,12),wf(:,-3),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,12),MB,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,15),MB,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,4),MB,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,-3),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,12),MB,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,1),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,15),MB,G3tensor(:,6))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-2),G1(:,:,:,16))
  call loop_DV_C(G1(:,:,:,16),Q(:,4),wf(:,-3),G2(:,:,:,13))
  call check_last_DV_C(l_switch,G2(:,:,:,13),Q(:,12),wf(:,1),G3tensor(:,7))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-2),Q(:,4),G1(:,:,:,17))
  call loop_CV_D(G1(:,:,:,17),Q(:,4),wf(:,-3),Q(:,8),G2(:,:,:,14))
  call check_last_CV_D(l_switch,G2(:,:,:,14),Q(:,12),wf(:,1),Q(:,3),G3tensor(:,8))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-2),Q(:,4),G1(:,:,:,18))
  call loop_UV_W(G1(:,:,:,18),Q(:,4),wf(:,-3),Q(:,8),G2(:,:,:,15))
  call check_last_UV_W(l_switch,G2(:,:,:,15),Q(:,12),wf(:,1),Q(:,3),G3tensor(:,9))
  call loop_VA_Q(G2(:,:,:,15),wf(:,-1),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,14),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,10))
  call loop_VQ_A(G1(:,:,:,18),wf(:,8),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,13),MT,G2(:,:,:,17))
  call check_last_QA_V(l_switch,G2(:,:,:,17),wf(:,-1),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,18),wf(:,15),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,14),MT,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,0),G2tensor(:,2))
  call loop_VA_Q(G1(:,:,:,18),wf(:,-1),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,6),MT,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-3),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,14),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,11))
  call loop_VQ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,5),MT,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,-3),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,13),MT,G2(:,:,:,21))
  call check_last_QA_V(l_switch,G2(:,:,:,21),wf(:,-1),G2tensor(:,3))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-3),Q(:,8),G1(:,:,:,24))
  call loop_VQ_A(G1(:,:,:,24),wf(:,5),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,13),MT,G2(:,:,:,22))
  call check_last_QA_V(l_switch,G2(:,:,:,22),wf(:,-1),G2tensor(:,4))
  call loop_VA_Q(G1(:,:,:,24),wf(:,13),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,14),MT,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,0),G2tensor(:,5))
  call loop_UV_W(G1(:,:,:,24),Q(:,8),wf(:,-2),Q(:,4),G2(:,:,:,24))
  call loop_VA_Q(G2(:,:,:,24),wf(:,-1),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,14),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,12))
  call loop_VA_Q(G1(:,:,:,24),wf(:,-1),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,10),MT,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,-2),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,14),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,13))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,24),wf(:,-2),wf(:,1),G1tensor(:,7))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,24),wf(:,1),wf(:,-2),G1tensor(:,8))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,24),wf(:,-2),wf(:,1),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,1),wf(:,13),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,6),MT,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-3),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,14),MT,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,0),G2tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,9),MT,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,-2),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,13),MT,G2(:,:,:,29))
  call check_last_QA_V(l_switch,G2(:,:,:,29),wf(:,-1),G2tensor(:,7))
  call check_last_QA_V(l_switch,G1(:,:,:,30),wf(:,13),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,10),MT,G1(:,:,:,32))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-2),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,14),MT,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,0),G2tensor(:,8))
  call check_last_AQ_V(l_switch,G1(:,:,:,32),wf(:,5),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,2),MT,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,2),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,14),MT,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,0),G2tensor(:,9))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-3),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,10),MT,G2(:,:,:,32))
  call loop_AV_Q(G2(:,:,:,32),wf(:,-2),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,14),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,0),G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-2),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,6),MT,G2(:,:,:,34))
  call loop_AV_Q(G2(:,:,:,34),wf(:,-3),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,14),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,0),G3tensor(:,15))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,38))
  call loop_VA_Q(G1(:,:,:,38),wf(:,-1),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,14),MT,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,0),G2tensor(:,10))
  call check_last_UV_W(l_switch,G1(:,:,:,38),Q(:,12),wf(:,1),Q(:,3),G2tensor(:,11))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-3),wf(:,1),G0(:,:,:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-3),G0(:,:,:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,13))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-3),wf(:,1),G0(:,:,:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,11),wf(:,-2),Q(:,4),G1tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,12),ZERO,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,1),G1(:,:,:,41))
  call check_last_Q_A(l_switch,G1(:,:,:,41),Q(:,15),ZERO,G2tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,12),MT,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,1),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,15),MT,G2tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,12),MB,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,1),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,15),MB,G2tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,46))
  call check_last_CV_D(l_switch,G1(:,:,:,46),Q(:,12),wf(:,1),Q(:,3),G2tensor(:,15))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(8)*M(1)+c(10)*M(2))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(8)*M(1)+c(10)*M(3))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(10)*(-M(2)+M(3)))
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(15)*M(1)-c(16)*M(2)) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(13)*M(1)-c(14)*M(2)) * den(1)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(15)*M(1)-c(16)*M(3)) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(13)*M(1)-c(14)*M(3)) * den(1)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(15)*M(1)-c(16)*M(2)) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(13)*M(1)-c(14)*M(2)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(15)*M(1)-c(16)*M(3)) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(13)*M(1)-c(14)*M(3)) * den(1)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(5)*(M(2)-M(3))) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(5)*(-M(2)+M(3))) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(5)*(-M(2)+M(3))) * den(1)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(7)*M(3))) * den(2)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(5)*M(3))) * den(2)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(7)*M(2))) * den(4)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(5)*M(2)) * den(4)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(7)*M(2))) * den(3)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(5)*M(2))) * den(3)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(7)*M(3))) * den(5)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(5)*M(3)) * den(5)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(3)*(M(2)-M(3))) * den(6)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(10)*(-M(2)+M(3))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(8)*M(1)-c(7)*M(3))
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(8)*M(1)+c(10)*M(3))
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(8)*M(1)-c(7)*M(2))
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(8)*M(1)+c(10)*M(2))
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(4)*M(1)))
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(4)*M(1)))
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(1)*(-M(2)+M(3))) * den(1)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(1)*(M(2)-M(3))) * den(1)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(2)*(M(2)-M(3))) * den(1)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(1)*(M(2)-M(3))) * den(1)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(1)*(-M(2)+M(3))) * den(1)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(2)*(-M(2)+M(3))) * den(1)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(1)*(M(2)-M(3))) * den(1)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(1)*(-M(2)+M(3))) * den(1)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(2)*(-M(2)+M(3))) * den(1)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(12)*(M(2)-M(3))) * den(7)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(11)*(M(2)-M(3))) * den(7)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(12)*(M(2)-M(3))) * den(7)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(11)*(M(2)-M(3))) * den(7)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(6)*(M(2)-M(3))) * den(7)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(2)*(-M(2)+M(3))) * den(7)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(9)*M(3)) * den(8)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(9)*M(2)) * den(9)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,10)

end subroutine vamp_1

end module ol_vamp_1_pptt_ttxgg_1_/**/REALKIND
