
FeynArtsProcess = {F[3, {3}], -F[3, {3}]} -> {-F[4, {1}], F[4, {1}]};

SortExternal = True;

OpenLoopsModel = "SM";

CreateTopologiesOptions = {
  ExcludeTopologies -> {Snails, WFCorrectionCTs, TadpoleCTs}
};

InsertFieldsOptions = {
  Model -> {"SMQCD", "SMQCDR2"},
  InsertionLevel -> {Particles},
  Restrictions -> {ExcludeParticles -> {S[2 | 3]}, NoQuarkMixing}
};

UnitaryGauge = True;

ColourCorrelations = Automatic;

SubProcessName = Automatic;

SelectCoupling = Exponent[#1, gQCD] == 2 + 2*#2 & ;

SelectInterference = {
  eQED -> 0
};

SelectTreeDiagrams = True & ;

SelectLoopDiagrams = True & ;

SelectCTDiagrams = True & ;

ReplaceOSw = False;

SetParameters = {
  nc -> 3,
  nf -> 6,
  MU -> 0,
  MD -> 0,
  MS -> 0,
  MC -> 0,
  LeadingColour -> 0
};

ChannelMap = {
  {"uuxttx<3,4,1,2>"},
  {"ttxbbx", "MB=0"}
};

Approximation = "";

NonZeroHels = Null;
