
module ol_vamp_1_pptllj_nenexuxtdbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptllj_nenexuxtdbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptllj_nenexuxtdbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptllj_nenexuxtdbx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptllj_nenexuxtdbx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,13) :: G0
  complex(REALKIND), dimension(4,5,4,117) :: G1
  complex(REALKIND), dimension(4,15,4,125) :: G2
  complex(REALKIND), dimension(4,35,4,32) :: G3
  complex(REALKIND), dimension(5,8) :: G1tensor
  complex(REALKIND), dimension(15,80) :: G2tensor
  complex(REALKIND), dimension(35,32) :: G3tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,32),MB,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2),gPbt)
  call loop_A_Q(G1(:,:,:,2),Q(:,52),MT,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,12),G2tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2),gZu)
  call loop_A_Q(G2(:,:,:,2),Q(:,55),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-3),G3tensor(:,1))
  call loop_AW_Q(G1(:,:,:,1),wf(:,7),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,52),MT,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,12),G2tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,3),wf(:,1),G2(:,:,:,4),gZu)
  call loop_A_Q(G2(:,:,:,4),Q(:,55),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-3),G3tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,35),MB,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,16),G2tensor(:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,18),G2tensor(:,4))
  call loop_AS_Q(G2(:,:,:,5),wf(:,2),G2(:,:,:,6),gPbt)
  call loop_A_Q(G2(:,:,:,6),Q(:,55),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-3),G3tensor(:,3))
  call loop_AW_Q(G2(:,:,:,5),wf(:,7),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,55),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-3),G3tensor(:,4))
  call loop_AQ_S(G2(:,:,:,5),wf(:,-3),G2(:,:,:,8),gPbt)
  call loop_SA_Q(G2(:,:,:,8),wf(:,-2),G2(:,:,:,9),gPud)
  call loop_A_Q(G2(:,:,:,9),Q(:,47),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-4),G3tensor(:,5))
  call loop_SQ_A(G2(:,:,:,8),wf(:,-4),G2(:,:,:,10),gPud)
  call loop_Q_A(G2(:,:,:,10),Q(:,59),ZERO,G3(:,:,:,6))
  call check_last_QA_V(l_switch,G3(:,:,:,6),wf(:,-2),G3tensor(:,6))
  call loop_AQ_W(G2(:,:,:,5),wf(:,-3),G2(:,:,:,11))
  call loop_WA_Q(G2(:,:,:,11),wf(:,-2),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,47),ZERO,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-4),G3tensor(:,7))
  call loop_WQ_A(G2(:,:,:,11),wf(:,-4),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,59),ZERO,G3(:,:,:,8))
  call check_last_QA_V(l_switch,G3(:,:,:,8),wf(:,-2),G3tensor(:,8))
  call loop_AS_Q(G1(:,:,:,1),wf(:,4),G1(:,:,:,5),gPbt)
  call loop_A_Q(G1(:,:,:,5),Q(:,55),MT,G2(:,:,:,14))
  call check_last_AQ_V(l_switch,G2(:,:,:,14),wf(:,-3),G2tensor(:,5))
  call loop_AW_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,55),MT,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,-3),G2tensor(:,6))
  call loop_AS_Q(G1(:,:,:,1),wf(:,8),G1(:,:,:,7),gPbt)
  call loop_A_Q(G1(:,:,:,7),Q(:,55),MT,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,-3),G2tensor(:,7))
  call loop_AW_Q(G1(:,:,:,1),wf(:,9),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,55),MT,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,-3),G2tensor(:,8))
  call loop_AS_Q(G1(:,:,:,1),wf(:,88),G1(:,:,:,9),gPbt)
  call loop_A_Q(G1(:,:,:,9),Q(:,55),MT,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-3),G2tensor(:,9))
  call loop_AW_Q(G1(:,:,:,1),wf(:,89),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,55),MT,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,-3),G2tensor(:,10))
  call loop_AQ_S(G1(:,:,:,1),wf(:,-3),G1(:,:,:,11),gPbt)
  call loop_SQ_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12),gPud)
  call loop_Q_A(G1(:,:,:,12),Q(:,56),ZERO,G2(:,:,:,20))
  call check_last_QA_V(l_switch,G2(:,:,:,20),wf(:,21),G2tensor(:,11))
  call loop_QZ_A(G2(:,:,:,20),wf(:,1),G2(:,:,:,21),gZu)
  call loop_Q_A(G2(:,:,:,21),Q(:,59),ZERO,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,-2),G3tensor(:,9))
  call loop_SA_Q(G1(:,:,:,11),wf(:,21),G1(:,:,:,13),gPud)
  call loop_A_Q(G1(:,:,:,13),Q(:,47),ZERO,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,-4),G2tensor(:,12))
  call loop_SA_Q(G1(:,:,:,11),wf(:,-2),G1(:,:,:,14),gPud)
  call loop_A_Q(G1(:,:,:,14),Q(:,44),ZERO,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,55),G2tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,1),G2(:,:,:,24),gZd)
  call loop_A_Q(G2(:,:,:,24),Q(:,47),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-4),G3tensor(:,10))
  call loop_SQ_A(G1(:,:,:,11),wf(:,55),G1(:,:,:,15),gPud)
  call loop_Q_A(G1(:,:,:,15),Q(:,59),ZERO,G2(:,:,:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,25),wf(:,-2),G2tensor(:,14))
  call loop_SV_T(G1(:,:,:,11),Q(:,40),wf(:,1),Q(:,3),G2(:,:,:,26))
  call loop_SQ_A(G2(:,:,:,26),wf(:,-4),G2(:,:,:,27),gPud)
  call loop_Q_A(G2(:,:,:,27),Q(:,59),ZERO,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,11))
  call loop_SA_Q(G2(:,:,:,26),wf(:,-2),G2(:,:,:,28),gPud)
  call loop_A_Q(G2(:,:,:,28),Q(:,47),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-4),G3tensor(:,12))
  call loop_SV_V(G1(:,:,:,11),wf(:,1),G1(:,:,:,16))
  call loop_WQ_A(G1(:,:,:,16),wf(:,-4),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,59),ZERO,G2(:,:,:,29))
  call check_last_QA_V(l_switch,G2(:,:,:,29),wf(:,-2),G2tensor(:,15))
  call loop_WA_Q(G1(:,:,:,16),wf(:,-2),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,47),ZERO,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,-4),G2tensor(:,16))
  call loop_AQ_W(G1(:,:,:,1),wf(:,-3),G1(:,:,:,19))
  call loop_WQ_A(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,56),ZERO,G2(:,:,:,31))
  call check_last_QA_V(l_switch,G2(:,:,:,31),wf(:,21),G2tensor(:,17))
  call loop_QZ_A(G2(:,:,:,31),wf(:,1),G2(:,:,:,32),gZu)
  call loop_Q_A(G2(:,:,:,32),Q(:,59),ZERO,G3(:,:,:,13))
  call check_last_QA_V(l_switch,G3(:,:,:,13),wf(:,-2),G3tensor(:,13))
  call loop_WA_Q(G1(:,:,:,19),wf(:,21),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,47),ZERO,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,-4),G2tensor(:,18))
  call loop_WA_Q(G1(:,:,:,19),wf(:,-2),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,44),ZERO,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,55),G2tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,34),wf(:,1),G2(:,:,:,35),gZd)
  call loop_A_Q(G2(:,:,:,35),Q(:,47),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-4),G3tensor(:,14))
  call loop_WQ_A(G1(:,:,:,19),wf(:,55),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,59),ZERO,G2(:,:,:,36))
  call check_last_QA_V(l_switch,G2(:,:,:,36),wf(:,-2),G2tensor(:,20))
  call loop_VV_S(G1(:,:,:,19),wf(:,1),G1(:,:,:,24))
  call loop_SQ_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,25),gPud)
  call loop_Q_A(G1(:,:,:,25),Q(:,59),ZERO,G2(:,:,:,37))
  call check_last_QA_V(l_switch,G2(:,:,:,37),wf(:,-2),G2tensor(:,21))
  call loop_SA_Q(G1(:,:,:,24),wf(:,-2),G1(:,:,:,26),gPud)
  call loop_A_Q(G1(:,:,:,26),Q(:,47),ZERO,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,-4),G2tensor(:,22))
  call loop_UW_V(G1(:,:,:,19),Q(:,40),wf(:,1),Q(:,3),G2(:,:,:,39))
  call loop_WQ_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,59),ZERO,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,15))
  call loop_WA_Q(G2(:,:,:,39),wf(:,-2),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,47),ZERO,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-4),G3tensor(:,16))
  call loop_AQ_S(G1(:,:,:,1),wf(:,12),G1(:,:,:,27),gPbt)
  call loop_SQ_A(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28),gPud)
  call loop_Q_A(G1(:,:,:,28),Q(:,59),ZERO,G2(:,:,:,42))
  call check_last_QA_V(l_switch,G2(:,:,:,42),wf(:,-2),G2tensor(:,23))
  call loop_SA_Q(G1(:,:,:,27),wf(:,-2),G1(:,:,:,29),gPud)
  call loop_A_Q(G1(:,:,:,29),Q(:,47),ZERO,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,-4),G2tensor(:,24))
  call loop_AQ_W(G1(:,:,:,1),wf(:,12),G1(:,:,:,30))
  call loop_WQ_A(G1(:,:,:,30),wf(:,-4),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,59),ZERO,G2(:,:,:,44))
  call check_last_QA_V(l_switch,G2(:,:,:,44),wf(:,-2),G2tensor(:,25))
  call loop_WA_Q(G1(:,:,:,30),wf(:,-2),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,47),ZERO,G2(:,:,:,45))
  call check_last_AQ_V(l_switch,G2(:,:,:,45),wf(:,-4),G2tensor(:,26))
  call loop_AS_Q(G1(:,:,:,1),wf(:,92),G1(:,:,:,33),gPbt)
  call loop_A_Q(G1(:,:,:,33),Q(:,55),MT,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,-3),G2tensor(:,27))
  call loop_AW_Q(G1(:,:,:,1),wf(:,93),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,55),MT,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,-3),G2tensor(:,28))
  call loop_AS_Q(G1(:,:,:,1),wf(:,96),G1(:,:,:,35),gPbt)
  call loop_A_Q(G1(:,:,:,35),Q(:,55),MT,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,-3),G2tensor(:,29))
  call loop_AW_Q(G1(:,:,:,1),wf(:,97),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,55),MT,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,-3),G2tensor(:,30))
  call loop_AS_Q(G1(:,:,:,1),wf(:,98),G1(:,:,:,37),gPbt)
  call loop_A_Q(G1(:,:,:,37),Q(:,55),MT,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,-3),G2tensor(:,31))
  call loop_AW_Q(G1(:,:,:,1),wf(:,99),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,55),MT,G2(:,:,:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,-3),G2tensor(:,32))
  call loop_VA_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,35),MB,G1(:,:,:,39))
  call loop_AS_Q(G1(:,:,:,39),wf(:,2),G1(:,:,:,40),gPbt)
  call loop_A_Q(G1(:,:,:,40),Q(:,55),MT,G2(:,:,:,52))
  call check_last_AQ_V(l_switch,G2(:,:,:,52),wf(:,-3),G2tensor(:,33))
  call loop_AW_Q(G1(:,:,:,39),wf(:,7),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,55),MT,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,-3),G2tensor(:,34))
  call loop_AQ_S(G1(:,:,:,39),wf(:,-3),G1(:,:,:,42),gPbt)
  call loop_SA_Q(G1(:,:,:,42),wf(:,-2),G1(:,:,:,43),gPud)
  call loop_A_Q(G1(:,:,:,43),Q(:,47),ZERO,G2(:,:,:,54))
  call check_last_AQ_V(l_switch,G2(:,:,:,54),wf(:,-4),G2tensor(:,35))
  call loop_SQ_A(G1(:,:,:,42),wf(:,-4),G1(:,:,:,44),gPud)
  call loop_Q_A(G1(:,:,:,44),Q(:,59),ZERO,G2(:,:,:,55))
  call check_last_QA_V(l_switch,G2(:,:,:,55),wf(:,-2),G2tensor(:,36))
  call loop_AQ_W(G1(:,:,:,39),wf(:,-3),G1(:,:,:,45))
  call loop_WA_Q(G1(:,:,:,45),wf(:,-2),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,47),ZERO,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,-4),G2tensor(:,37))
  call loop_WQ_A(G1(:,:,:,45),wf(:,-4),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,59),ZERO,G2(:,:,:,57))
  call check_last_QA_V(l_switch,G2(:,:,:,57),wf(:,-2),G2tensor(:,38))
  call check_last_AQ_V(l_switch,G1(:,:,:,39),wf(:,16),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,39),wf(:,18),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,52),MT,G1(:,:,:,48))
  call loop_AZ_Q(G1(:,:,:,48),wf(:,1),G1(:,:,:,49),gZu)
  call loop_A_Q(G1(:,:,:,49),Q(:,55),MT,G2(:,:,:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,-3),G2tensor(:,39))
  call check_last_AQ_V(l_switch,G1(:,:,:,48),wf(:,12),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,52),MT,G1(:,:,:,50))
  call loop_AZ_Q(G1(:,:,:,50),wf(:,1),G1(:,:,:,51),gZu)
  call loop_A_Q(G1(:,:,:,51),Q(:,55),MT,G2(:,:,:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,59),wf(:,-3),G2tensor(:,40))
  call check_last_AQ_V(l_switch,G1(:,:,:,50),wf(:,12),G1tensor(:,4))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,16),ZERO,G1(:,:,:,52))
  call loop_QS_A(G1(:,:,:,52),wf(:,3),G1(:,:,:,53),gPud)
  call loop_Q_A(G1(:,:,:,53),Q(:,56),ZERO,G2(:,:,:,60))
  call check_last_QA_V(l_switch,G2(:,:,:,60),wf(:,21),G2tensor(:,41))
  call loop_QZ_A(G2(:,:,:,60),wf(:,1),G2(:,:,:,61),gZu)
  call loop_Q_A(G2(:,:,:,61),Q(:,59),ZERO,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-2),G3tensor(:,17))
  call loop_QW_A(G1(:,:,:,52),wf(:,5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,56),ZERO,G2(:,:,:,62))
  call check_last_QA_V(l_switch,G2(:,:,:,62),wf(:,21),G2tensor(:,42))
  call loop_QZ_A(G2(:,:,:,62),wf(:,1),G2(:,:,:,63),gZu)
  call loop_Q_A(G2(:,:,:,63),Q(:,59),ZERO,G3(:,:,:,18))
  call check_last_QA_V(l_switch,G3(:,:,:,18),wf(:,-2),G3tensor(:,18))
  call loop_QS_A(G1(:,:,:,52),wf(:,84),G1(:,:,:,55),gPud)
  call loop_Q_A(G1(:,:,:,55),Q(:,59),ZERO,G2(:,:,:,64))
  call check_last_QA_V(l_switch,G2(:,:,:,64),wf(:,-2),G2tensor(:,43))
  call loop_QW_A(G1(:,:,:,52),wf(:,85),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,59),ZERO,G2(:,:,:,65))
  call check_last_QA_V(l_switch,G2(:,:,:,65),wf(:,-2),G2tensor(:,44))
  call loop_QS_A(G1(:,:,:,52),wf(:,86),G1(:,:,:,57),gPud)
  call loop_Q_A(G1(:,:,:,57),Q(:,59),ZERO,G2(:,:,:,66))
  call check_last_QA_V(l_switch,G2(:,:,:,66),wf(:,-2),G2tensor(:,45))
  call loop_QW_A(G1(:,:,:,52),wf(:,87),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,59),ZERO,G2(:,:,:,67))
  call check_last_QA_V(l_switch,G2(:,:,:,67),wf(:,-2),G2tensor(:,46))
  call loop_QZ_A(G1(:,:,:,52),wf(:,1),G1(:,:,:,59),gZd)
  call loop_Q_A(G1(:,:,:,59),Q(:,19),ZERO,G2(:,:,:,68))
  call loop_QS_A(G2(:,:,:,68),wf(:,3),G2(:,:,:,69),gPud)
  call loop_Q_A(G2(:,:,:,69),Q(:,59),ZERO,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-2),G3tensor(:,19))
  call loop_QW_A(G2(:,:,:,68),wf(:,5),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,59),ZERO,G3(:,:,:,20))
  call check_last_QA_V(l_switch,G3(:,:,:,20),wf(:,-2),G3tensor(:,20))
  call loop_QA_S(G2(:,:,:,68),wf(:,-2),G2(:,:,:,71),gPud)
  call loop_SA_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72),gPbt)
  call loop_A_Q(G2(:,:,:,72),Q(:,55),MT,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,-3),G3tensor(:,21))
  call loop_QA_W(G2(:,:,:,68),wf(:,-2),G2(:,:,:,73))
  call loop_WA_Q(G2(:,:,:,73),wf(:,-5),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,55),MT,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-3),G3tensor(:,22))
  call loop_QA_S(G1(:,:,:,52),wf(:,21),G1(:,:,:,60),gPud)
  call loop_SA_Q(G1(:,:,:,60),wf(:,-5),G1(:,:,:,61),gPbt)
  call loop_A_Q(G1(:,:,:,61),Q(:,55),MT,G2(:,:,:,75))
  call check_last_AQ_V(l_switch,G2(:,:,:,75),wf(:,-3),G2tensor(:,47))
  call loop_QA_W(G1(:,:,:,52),wf(:,21),G1(:,:,:,62))
  call loop_WA_Q(G1(:,:,:,62),wf(:,-5),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,55),MT,G2(:,:,:,76))
  call check_last_AQ_V(l_switch,G2(:,:,:,76),wf(:,-3),G2tensor(:,48))
  call loop_QS_A(G1(:,:,:,52),wf(:,90),G1(:,:,:,64),gPud)
  call loop_Q_A(G1(:,:,:,64),Q(:,59),ZERO,G2(:,:,:,77))
  call check_last_QA_V(l_switch,G2(:,:,:,77),wf(:,-2),G2tensor(:,49))
  call loop_QW_A(G1(:,:,:,52),wf(:,91),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,59),ZERO,G2(:,:,:,78))
  call check_last_QA_V(l_switch,G2(:,:,:,78),wf(:,-2),G2tensor(:,50))
  call loop_QA_S(G1(:,:,:,52),wf(:,-2),G1(:,:,:,66),gPud)
  call loop_SA_Q(G1(:,:,:,66),wf(:,-5),G1(:,:,:,67),gPbt)
  call loop_A_Q(G1(:,:,:,67),Q(:,52),MT,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,12),G2tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,79),wf(:,1),G2(:,:,:,80),gZu)
  call loop_A_Q(G2(:,:,:,80),Q(:,55),MT,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,-3),G3tensor(:,23))
  call loop_SA_Q(G1(:,:,:,66),wf(:,41),G1(:,:,:,68),gPbt)
  call loop_A_Q(G1(:,:,:,68),Q(:,55),MT,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,-3),G2tensor(:,52))
  call loop_TV_S(G1(:,:,:,66),Q(:,20),wf(:,1),Q(:,3),G2(:,:,:,82))
  call loop_SA_Q(G2(:,:,:,82),wf(:,-5),G2(:,:,:,83),gPbt)
  call loop_A_Q(G2(:,:,:,83),Q(:,55),MT,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,-3),G3tensor(:,24))
  call loop_SV_V(G1(:,:,:,66),wf(:,1),G1(:,:,:,69))
  call loop_WA_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,55),MT,G2(:,:,:,84))
  call check_last_AQ_V(l_switch,G2(:,:,:,84),wf(:,-3),G2tensor(:,53))
  call loop_QA_W(G1(:,:,:,52),wf(:,-2),G1(:,:,:,71))
  call loop_WA_Q(G1(:,:,:,71),wf(:,-5),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,52),MT,G2(:,:,:,85))
  call check_last_AQ_V(l_switch,G2(:,:,:,85),wf(:,12),G2tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,85),wf(:,1),G2(:,:,:,86),gZu)
  call loop_A_Q(G2(:,:,:,86),Q(:,55),MT,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-3),G3tensor(:,25))
  call loop_WA_Q(G1(:,:,:,71),wf(:,41),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,55),MT,G2(:,:,:,87))
  call check_last_AQ_V(l_switch,G2(:,:,:,87),wf(:,-3),G2tensor(:,55))
  call loop_VV_S(G1(:,:,:,71),wf(:,1),G1(:,:,:,74))
  call loop_SA_Q(G1(:,:,:,74),wf(:,-5),G1(:,:,:,75),gPbt)
  call loop_A_Q(G1(:,:,:,75),Q(:,55),MT,G2(:,:,:,88))
  call check_last_AQ_V(l_switch,G2(:,:,:,88),wf(:,-3),G2tensor(:,56))
  call loop_UV_W(G1(:,:,:,71),Q(:,20),wf(:,1),Q(:,3),G2(:,:,:,89))
  call loop_WA_Q(G2(:,:,:,89),wf(:,-5),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,55),MT,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,-3),G3tensor(:,26))
  call loop_QS_A(G1(:,:,:,52),wf(:,94),G1(:,:,:,76),gPud)
  call loop_Q_A(G1(:,:,:,76),Q(:,59),ZERO,G2(:,:,:,91))
  call check_last_QA_V(l_switch,G2(:,:,:,91),wf(:,-2),G2tensor(:,57))
  call loop_QW_A(G1(:,:,:,52),wf(:,95),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,59),ZERO,G2(:,:,:,92))
  call check_last_QA_V(l_switch,G2(:,:,:,92),wf(:,-2),G2tensor(:,58))
  call loop_QS_A(G1(:,:,:,52),wf(:,101),G1(:,:,:,78),gPud)
  call loop_Q_A(G1(:,:,:,78),Q(:,59),ZERO,G2(:,:,:,93))
  call check_last_QA_V(l_switch,G2(:,:,:,93),wf(:,-2),G2tensor(:,59))
  call loop_QS_A(G1(:,:,:,52),wf(:,103),G1(:,:,:,79),gPud)
  call loop_Q_A(G1(:,:,:,79),Q(:,59),ZERO,G2(:,:,:,94))
  call check_last_QA_V(l_switch,G2(:,:,:,94),wf(:,-2),G2tensor(:,60))
  call loop_QW_A(G1(:,:,:,52),wf(:,104),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,59),ZERO,G2(:,:,:,95))
  call check_last_QA_V(l_switch,G2(:,:,:,95),wf(:,-2),G2tensor(:,61))
  call loop_QW_A(G1(:,:,:,52),wf(:,105),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,59),ZERO,G2(:,:,:,96))
  call check_last_QA_V(l_switch,G2(:,:,:,96),wf(:,-2),G2tensor(:,62))
  call loop_VQ_A(G0(:,:,:,1),wf(:,55),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,19),ZERO,G1(:,:,:,82))
  call loop_QS_A(G1(:,:,:,82),wf(:,3),G1(:,:,:,83),gPud)
  call loop_Q_A(G1(:,:,:,83),Q(:,59),ZERO,G2(:,:,:,97))
  call check_last_QA_V(l_switch,G2(:,:,:,97),wf(:,-2),G2tensor(:,63))
  call loop_QW_A(G1(:,:,:,82),wf(:,5),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,59),ZERO,G2(:,:,:,98))
  call check_last_QA_V(l_switch,G2(:,:,:,98),wf(:,-2),G2tensor(:,64))
  call loop_QA_S(G1(:,:,:,82),wf(:,-2),G1(:,:,:,85),gPud)
  call loop_SA_Q(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86),gPbt)
  call loop_A_Q(G1(:,:,:,86),Q(:,55),MT,G2(:,:,:,99))
  call check_last_AQ_V(l_switch,G2(:,:,:,99),wf(:,-3),G2tensor(:,65))
  call loop_QA_W(G1(:,:,:,82),wf(:,-2),G1(:,:,:,87))
  call loop_WA_Q(G1(:,:,:,87),wf(:,-5),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,55),MT,G2(:,:,:,100))
  call check_last_AQ_V(l_switch,G2(:,:,:,100),wf(:,-3),G2tensor(:,66))
  call loop_VA_Q(G0(:,:,:,1),wf(:,25),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,44),ZERO,G1(:,:,:,89))
  call loop_AZ_Q(G1(:,:,:,89),wf(:,1),G1(:,:,:,90),gZd)
  call loop_A_Q(G1(:,:,:,90),Q(:,47),ZERO,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,-4),G2tensor(:,67))
  call check_last_AQ_V(l_switch,G1(:,:,:,89),wf(:,55),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,1),wf(:,27),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,44),ZERO,G1(:,:,:,91))
  call loop_AZ_Q(G1(:,:,:,91),wf(:,1),G1(:,:,:,92),gZd)
  call loop_A_Q(G1(:,:,:,92),Q(:,47),ZERO,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,-4),G2tensor(:,68))
  call check_last_AQ_V(l_switch,G1(:,:,:,91),wf(:,55),G1tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,56),ZERO,G1(:,:,:,93))
  call loop_QZ_A(G1(:,:,:,93),wf(:,1),G1(:,:,:,94),gZu)
  call loop_Q_A(G1(:,:,:,94),Q(:,59),ZERO,G2(:,:,:,103))
  call check_last_QA_V(l_switch,G2(:,:,:,103),wf(:,-2),G2tensor(:,69))
  call check_last_QA_V(l_switch,G1(:,:,:,93),wf(:,21),G1tensor(:,7))
  call loop_VQ_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,56),ZERO,G1(:,:,:,95))
  call loop_QZ_A(G1(:,:,:,95),wf(:,1),G1(:,:,:,96),gZu)
  call loop_Q_A(G1(:,:,:,96),Q(:,59),ZERO,G2(:,:,:,104))
  call check_last_QA_V(l_switch,G2(:,:,:,104),wf(:,-2),G2tensor(:,70))
  call check_last_QA_V(l_switch,G1(:,:,:,95),wf(:,21),G1tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,8),MT,G1(:,:,:,97))
  call loop_QA_S(G1(:,:,:,97),wf(:,-5),G1(:,:,:,98),gPbt)
  call loop_SQ_A(G1(:,:,:,98),wf(:,-4),G1(:,:,:,99),gPud)
  call loop_Q_A(G1(:,:,:,99),Q(:,56),ZERO,G2(:,:,:,105))
  call check_last_QA_V(l_switch,G2(:,:,:,105),wf(:,21),G2tensor(:,71))
  call loop_QZ_A(G2(:,:,:,105),wf(:,1),G2(:,:,:,106),gZu)
  call loop_Q_A(G2(:,:,:,106),Q(:,59),ZERO,G3(:,:,:,27))
  call check_last_QA_V(l_switch,G3(:,:,:,27),wf(:,-2),G3tensor(:,27))
  call loop_SQ_A(G1(:,:,:,98),wf(:,55),G1(:,:,:,100),gPud)
  call loop_Q_A(G1(:,:,:,100),Q(:,59),ZERO,G2(:,:,:,107))
  call check_last_QA_V(l_switch,G2(:,:,:,107),wf(:,-2),G2tensor(:,72))
  call loop_SV_T(G1(:,:,:,98),Q(:,40),wf(:,1),Q(:,3),G2(:,:,:,108))
  call loop_SQ_A(G2(:,:,:,108),wf(:,-4),G2(:,:,:,109),gPud)
  call loop_Q_A(G2(:,:,:,109),Q(:,59),ZERO,G3(:,:,:,28))
  call check_last_QA_V(l_switch,G3(:,:,:,28),wf(:,-2),G3tensor(:,28))
  call loop_SV_V(G1(:,:,:,98),wf(:,1),G1(:,:,:,101))
  call loop_WQ_A(G1(:,:,:,101),wf(:,-4),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,59),ZERO,G2(:,:,:,110))
  call check_last_QA_V(l_switch,G2(:,:,:,110),wf(:,-2),G2tensor(:,73))
  call loop_QA_W(G1(:,:,:,97),wf(:,-5),G1(:,:,:,103))
  call loop_WQ_A(G1(:,:,:,103),wf(:,-4),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,56),ZERO,G2(:,:,:,111))
  call check_last_QA_V(l_switch,G2(:,:,:,111),wf(:,21),G2tensor(:,74))
  call loop_QZ_A(G2(:,:,:,111),wf(:,1),G2(:,:,:,112),gZu)
  call loop_Q_A(G2(:,:,:,112),Q(:,59),ZERO,G3(:,:,:,29))
  call check_last_QA_V(l_switch,G3(:,:,:,29),wf(:,-2),G3tensor(:,29))
  call loop_WQ_A(G1(:,:,:,103),wf(:,55),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,59),ZERO,G2(:,:,:,113))
  call check_last_QA_V(l_switch,G2(:,:,:,113),wf(:,-2),G2tensor(:,75))
  call loop_VV_S(G1(:,:,:,103),wf(:,1),G1(:,:,:,106))
  call loop_SQ_A(G1(:,:,:,106),wf(:,-4),G1(:,:,:,107),gPud)
  call loop_Q_A(G1(:,:,:,107),Q(:,59),ZERO,G2(:,:,:,114))
  call check_last_QA_V(l_switch,G2(:,:,:,114),wf(:,-2),G2tensor(:,76))
  call loop_UW_V(G1(:,:,:,103),Q(:,40),wf(:,1),Q(:,3),G2(:,:,:,115))
  call loop_WQ_A(G2(:,:,:,115),wf(:,-4),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,59),ZERO,G3(:,:,:,30))
  call check_last_QA_V(l_switch,G3(:,:,:,30),wf(:,-2),G3tensor(:,30))
  call loop_QA_S(G1(:,:,:,97),wf(:,41),G1(:,:,:,108),gPbt)
  call loop_SQ_A(G1(:,:,:,108),wf(:,-4),G1(:,:,:,109),gPud)
  call loop_Q_A(G1(:,:,:,109),Q(:,59),ZERO,G2(:,:,:,117))
  call check_last_QA_V(l_switch,G2(:,:,:,117),wf(:,-2),G2tensor(:,77))
  call loop_QA_W(G1(:,:,:,97),wf(:,41),G1(:,:,:,110))
  call loop_WQ_A(G1(:,:,:,110),wf(:,-4),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,59),ZERO,G2(:,:,:,118))
  call check_last_QA_V(l_switch,G2(:,:,:,118),wf(:,-2),G2tensor(:,78))
  call loop_QZ_A(G1(:,:,:,97),wf(:,1),G1(:,:,:,112),gZu)
  call loop_Q_A(G1(:,:,:,112),Q(:,11),MT,G2(:,:,:,119))
  call loop_QA_S(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120),gPbt)
  call loop_SQ_A(G2(:,:,:,120),wf(:,-4),G2(:,:,:,121),gPud)
  call loop_Q_A(G2(:,:,:,121),Q(:,59),ZERO,G3(:,:,:,31))
  call check_last_QA_V(l_switch,G3(:,:,:,31),wf(:,-2),G3tensor(:,31))
  call loop_QA_W(G2(:,:,:,119),wf(:,-5),G2(:,:,:,122))
  call loop_WQ_A(G2(:,:,:,122),wf(:,-4),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,59),ZERO,G3(:,:,:,32))
  call check_last_QA_V(l_switch,G3(:,:,:,32),wf(:,-2),G3tensor(:,32))
  call loop_VQ_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,11),MT,G1(:,:,:,113))
  call loop_QA_S(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114),gPbt)
  call loop_SQ_A(G1(:,:,:,114),wf(:,-4),G1(:,:,:,115),gPud)
  call loop_Q_A(G1(:,:,:,115),Q(:,59),ZERO,G2(:,:,:,124))
  call check_last_QA_V(l_switch,G2(:,:,:,124),wf(:,-2),G2tensor(:,79))
  call loop_QA_W(G1(:,:,:,113),wf(:,-5),G1(:,:,:,116))
  call loop_WQ_A(G1(:,:,:,116),wf(:,-4),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,59),ZERO,G2(:,:,:,125))
  call check_last_QA_V(l_switch,G2(:,:,:,125),wf(:,-2),G2tensor(:,80))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(12)*M(1)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(9)*M(1)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(12)*M(1)) * den(23)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(9)*M(1)) * den(23)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(12)*M(1)) * den(11)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(9)*M(1)) * den(11)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(12)*M(1)) * den(26)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(9)*M(1)) * den(26)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(18)*M(1))) * den(38)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(15)*M(1))) * den(38)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(15)*M(1)) * den(38)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(6)*M(1)) * den(38)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(12)*M(1)) * den(4)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(9)*M(1)) * den(4)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(12)*M(1)) * den(4)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(9)*M(1)) * den(4)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(12)*M(1)) * den(14)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(9)*M(1)) * den(14)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(12)*M(1)) * den(29)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(9)*M(1)) * den(29)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(12)*M(1)) * den(17)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(9)*M(1)) * den(17)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(12)*M(1)) * den(32)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(9)*M(1)) * den(32)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(18)*M(1))) * den(41)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(15)*M(1)) * den(41)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(15)*M(1))) * den(41)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(6)*M(1)) * den(41)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(12)*M(1)) * den(39)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(9)*M(1)) * den(39)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(12)*M(1)) * den(39)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(9)*M(1)) * den(39)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(12)*M(1)) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(9)*M(1)) * den(42)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(13)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(13)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(13)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(13)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(13)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(13)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(13)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(13)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(12)*M(1)) * den(43)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(9)*M(1)) * den(43)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(7)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(7)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(7)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(7)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(7)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(7)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(7)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(7)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(12)*M(1)) * den(44)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(9)*M(1)) * den(44)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(28)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(28)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(28)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(28)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(28)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(28)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(28)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(28)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(12)*M(1)) * den(45)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(9)*M(1)) * den(45)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(22)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(22)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(22)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(22)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(22)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(22)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(22)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(22)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(1)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(13)*M(1)-c(14)*M(2)) * den(1)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(13)*M(1))+c(14)*M(2)) * den(1)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(4)*M(1))+c(5)*M(2)) * den(1)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,32)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,29)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(1)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(13)*M(1))+c(14)*M(2)) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(13)*M(1)-c(14)*M(2)) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(4)*M(1))+c(5)*M(2)) * den(1)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(1)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(13)*M(1)-c(14)*M(2)) * den(1)
  T3sum(1:15,13) = T3sum(1:15,13) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(13)*M(1))+c(14)*M(2)) * den(1)
  T3sum(1:15,13) = T3sum(1:15,13) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(4)*M(1))+c(5)*M(2)) * den(1)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(16)*M(1)-c(17)*M(2)) * den(1)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(13)*M(1)-c(14)*M(2)) * den(1)
  T3sum(1:15,14) = T3sum(1:15,14) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(13)*M(1))+c(14)*M(2)) * den(1)
  T3sum(1:15,14) = T3sum(1:15,14) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(4)*M(1))+c(5)*M(2)) * den(1)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,16)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(10)*M(1))+c(11)*M(2)) * den(1)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(7)*M(1))+c(8)*M(2)) * den(1)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,22)
  Gcoeff = (-(c(2)*M(1))) * den(46)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(3)*M(1)) * den(46)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(3)*M(1))) * den(46)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(1)*M(1)) * den(46)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(2)*M(1))) * den(49)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(3)*M(1)) * den(49)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(3)*M(1))) * den(49)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(1)*M(1)) * den(49)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(12)*M(1)) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(9)*M(1)) * den(33)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(12)*M(1)) * den(34)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(9)*M(1)) * den(34)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(12)*M(1)) * den(35)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(9)*M(1)) * den(35)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(12)*M(1)) * den(36)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(9)*M(1)) * den(36)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)

end subroutine vamp_1

end module ol_vamp_1_pptllj_nenexuxtdbx_1_/**/REALKIND
