
module ol_colourmatrix_pptllj_nenexuxtdbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(22,1), K2(1,1), KL(1,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [  12]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [  12]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [ -12]
  K1(15,:) = [   0]
  K1(16,:) = [  12]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [ -12]
  K1(21,:) = [   0]
  K1(22,:) = [  12]

  K2(1,:) = [ 9]

  KL(1,:) = [ 9, 3]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pptllj_nenexuxtdbx_1_/**/REALKIND



module ol_forced_parameters_pptllj_nenexuxtdbx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptllj_nenexuxtdbx_1_/**/REALKIND

module ol_loop_pptllj_nenexuxtdbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(42), c(18)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:105)
  ! denominators
  complex(REALKIND), save :: den(49)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = -(CI*eQED**4*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 2) = -(CI*countertermnorm*eQED**4*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 3) = -(CI*countertermnorm*ctSqq*eQED**4*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 4) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f( 5) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 6) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 7) = (CI*eQED**4*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f( 8) = (CI*countertermnorm*eQED**4*gQCD**2*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f( 9) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f(10) = (CI*eQED**4*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(11) = (CI*countertermnorm*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(12) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(13) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(14) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(15) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f(16) = (CI*countertermnorm*ctVbt*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(17) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(18) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f(19) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(20) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(21) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(22) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(23) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(24) = (CI*eQED**4)/(2._/**/REALKIND*MW**2*sw**2)
    f(25) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(26) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(27) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(28) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(29) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(30) = (CI*eQED**4)/(2._/**/REALKIND*cw*sw)
    f(31) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(32) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(33) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(34) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(35) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(36) = (eQED**4*gQCD**2*integralnorm*ME**2*SwB)/(MW**4*sw**4*4._/**/REALKIND)
    f(37) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(38) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(39) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(40) = (eQED**4*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(41) = (eQED**4*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(42) = -((eQED**4*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))

  c = [ 8*f(35), 8*f(36), 8*f(37), f(38), 3*f(38), 8*f(38), f(39), 3*f(39), 8*f(39), f(40), 3*f(40), 8*f(40), f(41), 3*f(41) &
    , 8*f(41), f(42), 3*f(42), 8*f(42) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(64)
  ! external WFs
  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_A(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_Q(P(:,4), rMT, H(4), wf(:,-3))
  call wf_Q(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_A(P(:,6), rMB, H(6), wf(:,-5))

  ! internal WFs
  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_AQ_S(gPud,wf(:,-2),wf(:,-4),wf(:,2))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,-3),wf(:,3))
  call vert_TV_S(wf(:,2),Q(:,20),wf(:,1),Q(:,3),wf(:,4))
  call vert_QA_W(wf(:,-3),wf(:,-5),wf(:,5))
  call vert_SV_V(wf(:,2),wf(:,1),wf(:,6))
  call vert_QA_W(wf(:,-4),wf(:,-2),wf(:,7))
  call vert_VV_S(wf(:,1),wf(:,7),wf(:,8))
  call vert_UV_W(wf(:,7),Q(:,20),wf(:,1),Q(:,3),wf(:,9))
  call vert_ZQ_A(gZu,wf(:,1),wf(:,-3),wf(:,10))
  call vert_SA_Q(gPbt,wf(:,2),wf(:,-5),wf(:,11))
  call prop_Q_A(wf(:,10),Q(:,11),MT,1_intkind1,wf(:,12))
  call vert_AW_Q(wf(:,-5),wf(:,7),wf(:,13))
  call vert_QS_A(gPbt,wf(:,-3),wf(:,2),wf(:,14))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,1),wf(:,15))
  call prop_Q_A(wf(:,14),Q(:,28),MB,1_intkind1,wf(:,16))
  call vert_WQ_A(wf(:,7),wf(:,-3),wf(:,17))
  call prop_Q_A(wf(:,17),Q(:,28),MB,1_intkind1,wf(:,18))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,1),wf(:,19))
  call vert_QS_A(gPud,wf(:,-4),wf(:,3),wf(:,20))
  call prop_A_Q(wf(:,19),Q(:,7),ZERO,0_intkind1,wf(:,21))
  call vert_WQ_A(wf(:,5),wf(:,-4),wf(:,22))
  call vert_SA_Q(gPud,wf(:,3),wf(:,-2),wf(:,23))
  call vert_ZQ_A(gZd,wf(:,1),wf(:,-4),wf(:,24))
  call prop_A_Q(wf(:,23),Q(:,44),ZERO,0_intkind1,wf(:,25))
  call vert_AW_Q(wf(:,-2),wf(:,5),wf(:,26))
  call prop_A_Q(wf(:,26),Q(:,44),ZERO,0_intkind1,wf(:,27))
  call vert_QS_A(gPln,wf(:,0),wf(:,2),wf(:,28))
  call vert_SA_Q(gPnl,wf(:,3),wf(:,-1),wf(:,29))
  call prop_Q_A(wf(:,28),Q(:,21),ME,1_intkind1,wf(:,30))
  call vert_AW_Q(wf(:,-1),wf(:,5),wf(:,31))
  call vert_WQ_A(wf(:,7),wf(:,0),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,21),ME,1_intkind1,wf(:,33))
  call counter_SA_Q(ctSbt,wf(:,2),wf(:,-5),wf(:,34))
  call counter_AW_Q(wf(:,-5),wf(:,7),wf(:,35))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,1),wf(:,36))
  call counter_QS_A(gPud,wf(:,-4),wf(:,3),wf(:,37))
  call counter_WQ_A(wf(:,5),wf(:,-4),wf(:,38))
  call counter_ZQ_A(gZd,wf(:,1),wf(:,-4),wf(:,39))
  call counter_QS_A(ctSbt,wf(:,-3),wf(:,2),wf(:,40))
  call prop_A_Q(wf(:,15),Q(:,35),MB,1_intkind1,wf(:,41))
  call counter_WQ_A(wf(:,7),wf(:,-3),wf(:,42))
  call counter_ZQ_A(gZu,wf(:,1),wf(:,-3),wf(:,43))
  call prop_A_Q(wf(:,11),Q(:,52),MT,1_intkind1,wf(:,44))
  call prop_A_Q(wf(:,13),Q(:,52),MT,1_intkind1,wf(:,45))
  call counter_AQ_S(ctSbt,wf(:,-5),wf(:,-3),wf(:,46))
  call counter_QA_W(wf(:,-3),wf(:,-5),wf(:,47))
  call vert_QS_A(gPud,wf(:,-4),wf(:,46),wf(:,48))
  call vert_WQ_A(wf(:,47),wf(:,-4),wf(:,49))
  call vert_SA_Q(gPud,wf(:,46),wf(:,-2),wf(:,50))
  call prop_A_Q(wf(:,50),Q(:,44),ZERO,0_intkind1,wf(:,51))
  call vert_AW_Q(wf(:,-2),wf(:,47),wf(:,52))
  call prop_A_Q(wf(:,52),Q(:,44),ZERO,0_intkind1,wf(:,53))
  call counter_SA_Q(gPud,wf(:,3),wf(:,-2),wf(:,54))
  call prop_Q_A(wf(:,24),Q(:,19),ZERO,0_intkind1,wf(:,55))
  call counter_AW_Q(wf(:,-2),wf(:,5),wf(:,56))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,1),wf(:,57))
  call prop_Q_A(wf(:,20),Q(:,56),ZERO,0_intkind1,wf(:,58))
  call prop_Q_A(wf(:,22),Q(:,56),ZERO,0_intkind1,wf(:,59))
  call counter_AQ_S(gPud,wf(:,-2),wf(:,-4),wf(:,60))
  call vert_TV_S(wf(:,60),Q(:,20),wf(:,1),Q(:,3),wf(:,61))
  call vert_SV_V(wf(:,60),wf(:,1),wf(:,62))
  call counter_QA_W(wf(:,-4),wf(:,-2),wf(:,63))
  call vert_VV_S(wf(:,1),wf(:,63),wf(:,64))
  call vert_UV_W(wf(:,63),Q(:,20),wf(:,1),Q(:,3),wf(:,65))
  call vert_SA_Q(gPbt,wf(:,60),wf(:,-5),wf(:,66))
  call vert_AW_Q(wf(:,-5),wf(:,63),wf(:,67))
  call vert_QS_A(gPbt,wf(:,-3),wf(:,60),wf(:,68))
  call prop_Q_A(wf(:,68),Q(:,28),MB,1_intkind1,wf(:,69))
  call vert_WQ_A(wf(:,63),wf(:,-3),wf(:,70))
  call prop_Q_A(wf(:,70),Q(:,28),MB,1_intkind1,wf(:,71))
  call vert_SA_Q(gPnl,wf(:,46),wf(:,-1),wf(:,72))
  call vert_AW_Q(wf(:,-1),wf(:,47),wf(:,73))
  call vert_QS_A(gPln,wf(:,0),wf(:,60),wf(:,74))
  call prop_Q_A(wf(:,74),Q(:,21),ME,1_intkind1,wf(:,75))
  call vert_WQ_A(wf(:,63),wf(:,0),wf(:,76))
  call prop_Q_A(wf(:,76),Q(:,21),ME,1_intkind1,wf(:,77))
  call counter_Q_A(cttt,wf(:,12),Q(:,11),wf(:,78))
  call counter_Q_A(ctbb,wf(:,16),Q(:,28),wf(:,79))
  call counter_Q_A(ctbb,wf(:,18),Q(:,28),wf(:,80))
  call counter_A_Q(ctqq,wf(:,21),Q(:,7),wf(:,81))
  call counter_A_Q(ctqq,wf(:,25),Q(:,44),wf(:,82))
  call counter_A_Q(ctqq,wf(:,27),Q(:,44),wf(:,83))
  call vert_VS_T(wf(:,1),Q(:,3),wf(:,3),Q(:,40),wf(:,84))
  call vert_SV_V(wf(:,3),wf(:,1),wf(:,85))
  call vert_VV_S(wf(:,1),wf(:,5),wf(:,86))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,5),Q(:,40),wf(:,87))
  call vert_AQ_S(gPud,wf(:,21),wf(:,-4),wf(:,88))
  call vert_QA_W(wf(:,-4),wf(:,21),wf(:,89))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,12),wf(:,90))
  call vert_QA_W(wf(:,12),wf(:,-5),wf(:,91))
  call vert_AQ_S(gPud,wf(:,-2),wf(:,55),wf(:,92))
  call vert_QA_W(wf(:,55),wf(:,-2),wf(:,93))
  call vert_AQ_S(gPbt,wf(:,41),wf(:,-3),wf(:,94))
  call vert_QA_W(wf(:,-3),wf(:,41),wf(:,95))
  call vert_AQ_S(gPnl,wf(:,-1),wf(:,30),wf(:,96))
  call vert_QA_W(wf(:,30),wf(:,-1),wf(:,97))
  call vert_AQ_S(gPnl,wf(:,-1),wf(:,33),wf(:,98))
  call vert_QA_W(wf(:,33),wf(:,-1),wf(:,99))
  call prop_A_Q(wf(:,29),Q(:,42),ME,1_intkind1,wf(:,100))
  call vert_AQ_S(gPln,wf(:,100),wf(:,0),wf(:,101))
  call prop_A_Q(wf(:,31),Q(:,42),ME,1_intkind1,wf(:,102))
  call vert_AQ_S(gPln,wf(:,102),wf(:,0),wf(:,103))
  call vert_QA_W(wf(:,0),wf(:,100),wf(:,104))
  call vert_QA_W(wf(:,0),wf(:,102),wf(:,105))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,20) - MW2)
  den(3) = 1 / (Q(5,40) - MW2)
  den(6) = 1 / (Q(5,11) - MT2)
  den(9) = 1 / (Q(5,28) - MB2)
  den(12) = 1 / (Q(5,7))
  den(15) = 1 / (Q(5,44))
  den(18) = 1 / (Q(5,21) - ME2)
  den(21) = 1 / (Q(5,35) - MB2)
  den(24) = 1 / (Q(5,52) - MT2)
  den(27) = 1 / (Q(5,19))
  den(30) = 1 / (Q(5,56))
  den(37) = 1 / (Q(5,23) - MW2)
  den(40) = 1 / (Q(5,43) - MW2)
  den(47) = 1 / (Q(5,42) - ME2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(3)*den(13)
  den(16) = den(3)*den(15)
  den(17) = den(1)*den(16)
  den(19) = den(2)*den(18)
  den(20) = den(3)*den(19)
  den(22) = den(1)*den(21)
  den(23) = den(2)*den(22)
  den(25) = den(2)*den(24)
  den(26) = den(1)*den(25)
  den(28) = den(1)*den(27)
  den(29) = den(3)*den(28)
  den(31) = den(3)*den(30)
  den(32) = den(1)*den(31)
  den(33) = den(7)*den(25)
  den(34) = den(10)*den(22)
  den(35) = den(13)*den(31)
  den(36) = den(16)*den(28)
  den(38) = den(4)*den(37)
  den(39) = den(1)*den(3)
  den(41) = den(39)*den(40)
  den(42) = den(13)*den(37)
  den(43) = den(7)*den(40)
  den(44) = den(28)*den(37)
  den(45) = den(22)*den(40)
  den(46) = den(19)*den(37)
  den(48) = den(3)*den(47)
  den(49) = den(40)*den(48)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(64)

  A(1) = cont_SS(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_VV(wf(:,5),wf(:,6)) * den(5)
  A(3) = cont_SS(wf(:,3),wf(:,8)) * den(5)
  A(4) = cont_VV(wf(:,5),wf(:,9)) * den(5)
  A(5) = cont_QA(wf(:,11),wf(:,12)) * den(8)
  A(6) = cont_QA(wf(:,12),wf(:,13)) * den(8)
  A(7) = cont_QA(wf(:,15),wf(:,16)) * den(11)
  A(8) = cont_QA(wf(:,15),wf(:,18)) * den(11)
  A(9) = cont_QA(wf(:,20),wf(:,21)) * den(14)
  A(10) = cont_QA(wf(:,21),wf(:,22)) * den(14)
  A(11) = cont_QA(wf(:,24),wf(:,25)) * den(17)
  A(12) = cont_QA(wf(:,24),wf(:,27)) * den(17)
  A(13) = cont_QA(wf(:,29),wf(:,30)) * den(20)
  A(14) = cont_QA(wf(:,30),wf(:,31)) * den(20)
  A(15) = cont_QA(wf(:,29),wf(:,33)) * den(20)
  A(16) = cont_QA(wf(:,31),wf(:,33)) * den(20)

  A(17) = cont_QA(wf(:,12),wf(:,34)) * den(8)
  A(18) = cont_QA(wf(:,12),wf(:,35)) * den(8)
  A(19) = cont_QA(wf(:,16),wf(:,36)) * den(11)
  A(20) = cont_QA(wf(:,18),wf(:,36)) * den(11)
  A(21) = cont_QA(wf(:,21),wf(:,37)) * den(14)
  A(22) = cont_QA(wf(:,21),wf(:,38)) * den(14)
  A(23) = cont_QA(wf(:,25),wf(:,39)) * den(17)
  A(24) = cont_QA(wf(:,27),wf(:,39)) * den(17)
  A(25) = cont_QA(wf(:,40),wf(:,41)) * den(23)
  A(26) = cont_QA(wf(:,41),wf(:,42)) * den(23)
  A(27) = cont_QA(wf(:,43),wf(:,44)) * den(26)
  A(28) = cont_QA(wf(:,43),wf(:,45)) * den(26)
  A(29) = cont_SS(wf(:,4),wf(:,46)) * den(5)
  A(30) = cont_VV(wf(:,6),wf(:,47)) * den(5)
  A(31) = cont_SS(wf(:,8),wf(:,46)) * den(5)
  A(32) = cont_VV(wf(:,9),wf(:,47)) * den(5)
  A(33) = cont_QA(wf(:,21),wf(:,48)) * den(14)
  A(34) = cont_QA(wf(:,21),wf(:,49)) * den(14)
  A(35) = cont_QA(wf(:,24),wf(:,51)) * den(17)
  A(36) = cont_QA(wf(:,24),wf(:,53)) * den(17)
  A(37) = cont_QA(wf(:,54),wf(:,55)) * den(29)
  A(38) = cont_QA(wf(:,55),wf(:,56)) * den(29)
  A(39) = cont_QA(wf(:,57),wf(:,58)) * den(32)
  A(40) = cont_QA(wf(:,57),wf(:,59)) * den(32)
  A(41) = cont_SS(wf(:,3),wf(:,61)) * den(5)
  A(42) = cont_VV(wf(:,5),wf(:,62)) * den(5)
  A(43) = cont_SS(wf(:,3),wf(:,64)) * den(5)
  A(44) = cont_VV(wf(:,5),wf(:,65)) * den(5)
  A(45) = cont_QA(wf(:,12),wf(:,66)) * den(8)
  A(46) = cont_QA(wf(:,12),wf(:,67)) * den(8)
  A(47) = cont_QA(wf(:,15),wf(:,69)) * den(11)
  A(48) = cont_QA(wf(:,15),wf(:,71)) * den(11)
  A(49) = cont_QA(wf(:,30),wf(:,72)) * den(20)
  A(50) = cont_QA(wf(:,30),wf(:,73)) * den(20)
  A(51) = cont_QA(wf(:,33),wf(:,72)) * den(20)
  A(52) = cont_QA(wf(:,33),wf(:,73)) * den(20)
  A(53) = cont_QA(wf(:,29),wf(:,75)) * den(20)
  A(54) = cont_QA(wf(:,31),wf(:,75)) * den(20)
  A(55) = cont_QA(wf(:,29),wf(:,77)) * den(20)
  A(56) = cont_QA(wf(:,31),wf(:,77)) * den(20)
  A(57) = cont_QA(wf(:,44),wf(:,78)) * den(33)
  A(58) = cont_QA(wf(:,45),wf(:,78)) * den(33)
  A(59) = cont_QA(wf(:,41),wf(:,79)) * den(34)
  A(60) = cont_QA(wf(:,41),wf(:,80)) * den(34)
  A(61) = cont_QA(wf(:,58),wf(:,81)) * den(35)
  A(62) = cont_QA(wf(:,59),wf(:,81)) * den(35)
  A(63) = cont_QA(wf(:,55),wf(:,82)) * den(36)
  A(64) = cont_QA(wf(:,55),wf(:,83)) * den(36)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(64)
  complex(REALKIND), intent(out) :: M1(1), M2(1)

  M1(1) = -(A(1)*f(1))+A(16)*f(4)-A(13)*f(7)+(A(14)-A(15))*f(10)+A(4)*f(15)+(A(6)+A(8)+A(10)+A(12))*f(18)+(A(5)+A(7)+A(9) &
       +A(11))*f(24)+(-A(2)+A(3))*f(30)

  M2(1) = -(A(29)*f(2))-A(41)*f(3)+A(52)*f(5)+A(56)*f(6)-A(49)*f(8)-A(53)*f(9)-A(51)*f(11)+A(54)*f(12)+A(50)*f(13)-A(55)*f(14) &
       +A(32)*f(16)+A(44)*f(17)+(-A(58)-A(60)-A(62)-A(64))*f(19)+A(20)*f(20)+(A(18)+A(26)+A(34)+A(36))*f(21)+(A(22)+A(24)+A(38) &
       +A(40)+A(46)+A(48))*f(22)+A(28)*f(23)+(A(17)+A(25)+A(33)+A(35)-A(57)-A(59)-A(61)-A(63))*f(25)+(A(21)+A(37)+A(45) &
       +A(47))*f(26)+A(19)*f(27)+(A(23)+A(39))*f(28)+A(27)*f(29)+A(31)*f(31)-A(42)*f(32)-A(30)*f(33)+A(43)*f(34)

end subroutine colourvectors

end module ol_loop_pptllj_nenexuxtdbx_1_/**/REALKIND
