
module ol_colourmatrix_pptllj_eexutxdxb_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(22,1), K2(1,1), KL(1,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [  12]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [  12]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [ -12]
  K1(15,:) = [   0]
  K1(16,:) = [  12]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [ -12]
  K1(21,:) = [   0]
  K1(22,:) = [  12]

  K2(1,:) = [ 9]

  KL(1,:) = [ 9, 3]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pptllj_eexutxdxb_1_/**/REALKIND



module ol_forced_parameters_pptllj_eexutxdxb_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wME /= 0) write(*,101) 'wME = 0'
  if (wME /= 0) write(*,101) 'wME = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptllj_eexutxdxb_1_/**/REALKIND

module ol_loop_pptllj_eexutxdxb_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(103), c(51)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:182)
  ! denominators
  complex(REALKIND), save :: den(91)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = -(CI*eQED**4*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f(  2) = -(CI*countertermnorm*eQED**4*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f(  3) = -(CI*countertermnorm*ctSqq*eQED**4*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f(  4) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f(  5) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(  6) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f(  7) = (CI*eQED**4*ME)/(4._/**/REALKIND*sw**4)
    f(  8) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*sw**4)
    f(  9) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*sw**4)
    f( 10) = (CI*eQED**4*MB*ME)/(8._/**/REALKIND*MW**4*sw**4)
    f( 11) = (CI*countertermnorm*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**4*sw**4)
    f( 12) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**4*sw**4)
    f( 13) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**4*sw**4)
    f( 14) = (CI*eQED**4*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f( 15) = (CI*countertermnorm*eQED**4*gQCD**2*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f( 16) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f( 17) = (CI*eQED**4*ME*MH**2)/(8._/**/REALKIND*MW**4*sw**4)
    f( 18) = (CI*countertermnorm*eQED**4*gQCD**2*ME*MH**2)/(8._/**/REALKIND*MW**4*sw**4)
    f( 19) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME*MH**2)/(8._/**/REALKIND*MW**4*sw**4)
    f( 20) = (CI*eQED**4*ME*MT)/(8._/**/REALKIND*MW**4*sw**4)
    f( 21) = (CI*countertermnorm*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**4*sw**4)
    f( 22) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**4*sw**4)
    f( 23) = (CI*countertermnorm*ctStt*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**4*sw**4)
    f( 24) = (CI*eQED**4*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 25) = (CI*eQED**4*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 26) = (CI*countertermnorm*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 27) = (CI*countertermnorm*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 28) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 29) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 30) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 31) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 32) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 33) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 34) = (CI*eQED**4*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 35) = (CI*countertermnorm*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 36) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 37) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 38) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f( 39) = (CI*eQED**4*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f( 40) = (CI*countertermnorm*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f( 41) = (CI*countertermnorm*ctStt*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f( 42) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f( 43) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f( 44) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f( 45) = (CI*countertermnorm*ctVbt*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 46) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 47) = (CI*eQED**4)/(6._/**/REALKIND*sw**2)
    f( 48) = (CI*eQED**4)/(3._/**/REALKIND*sw**2)
    f( 49) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f( 50) = (CI*countertermnorm*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 51) = (CI*countertermnorm*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 52) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 53) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 54) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 55) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 56) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 57) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 58) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 59) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f( 60) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 61) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 62) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f( 63) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 64) = (CI*eQED**4)/(6._/**/REALKIND*MW**2*sw**2)
    f( 65) = (CI*eQED**4)/(3._/**/REALKIND*MW**2*sw**2)
    f( 66) = (CI*eQED**4)/(2._/**/REALKIND*MW**2*sw**2)
    f( 67) = (CI*countertermnorm*eQED**4*gQCD**2)/(6._/**/REALKIND*MW**2*sw**2)
    f( 68) = (CI*countertermnorm*eQED**4*gQCD**2)/(3._/**/REALKIND*MW**2*sw**2)
    f( 69) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 70) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(6._/**/REALKIND*MW**2*sw**2)
    f( 71) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(3._/**/REALKIND*MW**2*sw**2)
    f( 72) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 73) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(6._/**/REALKIND*MW**2*sw**2)
    f( 74) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 75) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(6._/**/REALKIND*MW**2*sw**2)
    f( 76) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(3._/**/REALKIND*MW**2*sw**2)
    f( 77) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 78) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(3._/**/REALKIND*MW**2*sw**2)
    f( 79) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 80) = (CI*eQED**4)/(2._/**/REALKIND*cw*sw)
    f( 81) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 82) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 83) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 84) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f( 85) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 86) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(sw**4*4._/**/REALKIND)
    f( 87) = (eQED**4*gQCD**2*integralnorm*MB*ME*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 88) = (eQED**4*gQCD**2*integralnorm*ME**2*SwB)/(MW**4*sw**4*4._/**/REALKIND)
    f( 89) = (eQED**4*gQCD**2*integralnorm*ME*MH**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 90) = (eQED**4*gQCD**2*integralnorm*ME*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 91) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 92) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f( 93) = (eQED**4*gQCD**2*integralnorm*MB*ME*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 94) = (eQED**4*gQCD**2*integralnorm*ME*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 95) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 96) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 97) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 98) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 99) = (eQED**4*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(100) = (eQED**4*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(101) = (eQED**4*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(102) = (eQED**4*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(103) = -((eQED**4*gQCD**2*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))

  c = [ 8*f(85), f(86), 3*f(86), 8*f(86), f(87), 3*f(87), 8*f(87), 8*f(88), f(89), 3*f(89), 8*f(89), f(90), 3*f(90), 8*f(90) &
    , f(91), 3*f(91), 8*f(91), 8*f(92), f(93), 3*f(93), 8*f(93), f(94), 3*f(94), 8*f(94), f(95), 3*f(95), 8*f(95), f(96), 3*f(96) &
    , 8*f(96), f(97), 3*f(97), 8*f(97), f(98), 3*f(98), 8*f(98), f(99), 3*f(99), 8*f(99), f(100), 3*f(100), 8*f(100), f(101) &
    , 3*f(101), 8*f(101), f(102), 3*f(102), 8*f(102), f(103), 3*f(103), 8*f(103) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(174)
  ! external WFs
  call wf_Q(P(:,1), rME, H(1), wf(:,0))
  call wf_A(P(:,2), rME, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rMT, H(4), wf(:,-3))
  call wf_A(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_Q(P(:,6), rMB, H(6), wf(:,-5))

  ! internal WFs
  call vert_AQ_S(gH,wf(:,-1),wf(:,0),wf(:,1))
  call vert_AQ_S(gPdu,wf(:,-4),wf(:,-2),wf(:,2))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,-5),wf(:,3))
  call vert_SS_S(wf(:,1),wf(:,2),wf(:,4))
  call vert_QA_W(wf(:,-5),wf(:,-3),wf(:,5))
  call vert_ST_V(wf(:,2),Q(:,20),wf(:,1),Q(:,3),wf(:,6))
  call vert_AQ_S(gX,wf(:,-1),wf(:,0),wf(:,7))
  call vert_ST_V(wf(:,2),Q(:,20),wf(:,7),Q(:,3),wf(:,8))
  call vert_QA_W(wf(:,-2),wf(:,-4),wf(:,9))
  call vert_TV_S(wf(:,1),Q(:,3),wf(:,9),Q(:,20),wf(:,10))
  call vert_TV_S(wf(:,7),Q(:,3),wf(:,9),Q(:,20),wf(:,11))
  call vert_SV_V(wf(:,1),wf(:,9),wf(:,12))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,13))
  call vert_VS_T(wf(:,13),Q(:,3),wf(:,2),Q(:,20),wf(:,14))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,15))
  call vert_VS_T(wf(:,15),Q(:,3),wf(:,2),Q(:,20),wf(:,16))
  call vert_SV_V(wf(:,2),wf(:,13),wf(:,17))
  call vert_SV_V(wf(:,2),wf(:,15),wf(:,18))
  call vert_VV_S(wf(:,13),wf(:,9),wf(:,19))
  call vert_VV_S(wf(:,15),wf(:,9),wf(:,20))
  call vert_UV_W(wf(:,13),Q(:,3),wf(:,9),Q(:,20),wf(:,21))
  call vert_UV_W(wf(:,15),Q(:,3),wf(:,9),Q(:,20),wf(:,22))
  call vert_SA_Q(gH,wf(:,1),wf(:,-3),wf(:,23))
  call vert_QS_A(gPtb,wf(:,-5),wf(:,2),wf(:,24))
  call prop_A_Q(wf(:,23),Q(:,11),MT,1_intkind1,wf(:,25))
  call vert_SA_Q(gX,wf(:,7),wf(:,-3),wf(:,26))
  call prop_A_Q(wf(:,26),Q(:,11),MT,1_intkind1,wf(:,27))
  call vert_WQ_A(wf(:,9),wf(:,-5),wf(:,28))
  call vert_AV_Q(wf(:,-3),wf(:,13),wf(:,29))
  call prop_A_Q(wf(:,29),Q(:,11),MT,1_intkind1,wf(:,30))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,15),wf(:,31))
  call prop_A_Q(wf(:,31),Q(:,11),MT,1_intkind1,wf(:,32))
  call vert_SA_Q(gPtb,wf(:,2),wf(:,-3),wf(:,33))
  call vert_QS_A(gH,wf(:,-5),wf(:,1),wf(:,34))
  call prop_A_Q(wf(:,33),Q(:,28),MB,1_intkind1,wf(:,35))
  call vert_QS_A(gX,wf(:,-5),wf(:,7),wf(:,36))
  call vert_AW_Q(wf(:,-3),wf(:,9),wf(:,37))
  call prop_A_Q(wf(:,37),Q(:,28),MB,1_intkind1,wf(:,38))
  call vert_VQ_A(wf(:,13),wf(:,-5),wf(:,39))
  call vert_ZQ_A(gZd,wf(:,15),wf(:,-5),wf(:,40))
  call vert_VQ_A(wf(:,13),wf(:,-2),wf(:,41))
  call vert_SA_Q(gPdu,wf(:,3),wf(:,-4),wf(:,42))
  call prop_Q_A(wf(:,41),Q(:,7),ZERO,0_intkind1,wf(:,43))
  call vert_ZQ_A(gZu,wf(:,15),wf(:,-2),wf(:,44))
  call prop_Q_A(wf(:,44),Q(:,7),ZERO,0_intkind1,wf(:,45))
  call vert_AW_Q(wf(:,-4),wf(:,5),wf(:,46))
  call vert_QS_A(gPdu,wf(:,-2),wf(:,3),wf(:,47))
  call vert_AV_Q(wf(:,-4),wf(:,13),wf(:,48))
  call prop_Q_A(wf(:,47),Q(:,44),ZERO,0_intkind1,wf(:,49))
  call vert_AZ_Q(gZd,wf(:,-4),wf(:,15),wf(:,50))
  call vert_WQ_A(wf(:,5),wf(:,-2),wf(:,51))
  call prop_Q_A(wf(:,51),Q(:,44),ZERO,0_intkind1,wf(:,52))
  call vert_QS_A(gPnl,wf(:,0),wf(:,2),wf(:,53))
  call vert_SA_Q(gPln,wf(:,3),wf(:,-1),wf(:,54))
  call prop_Q_A(wf(:,53),Q(:,21),ZERO,0_intkind1,wf(:,55))
  call vert_AW_Q(wf(:,-1),wf(:,5),wf(:,56))
  call vert_WQ_A(wf(:,9),wf(:,0),wf(:,57))
  call prop_Q_A(wf(:,57),Q(:,21),ZERO,0_intkind1,wf(:,58))
  call counter_QS_A(ctStb,wf(:,-5),wf(:,2),wf(:,59))
  call counter_WQ_A(wf(:,9),wf(:,-5),wf(:,60))
  call counter_QS_A(gH,wf(:,-5),wf(:,1),wf(:,61))
  call counter_QS_A(gX,wf(:,-5),wf(:,7),wf(:,62))
  call counter_VQ_A(wf(:,13),wf(:,-5),wf(:,63))
  call counter_ZQ_A(gZd,wf(:,15),wf(:,-5),wf(:,64))
  call counter_SA_Q(gPdu,wf(:,3),wf(:,-4),wf(:,65))
  call counter_AW_Q(wf(:,-4),wf(:,5),wf(:,66))
  call counter_AV_Q(wf(:,-4),wf(:,13),wf(:,67))
  call counter_AZ_Q(gZd,wf(:,-4),wf(:,15),wf(:,68))
  call counter_SA_Q(ctStb,wf(:,2),wf(:,-3),wf(:,69))
  call prop_Q_A(wf(:,34),Q(:,35),MB,1_intkind1,wf(:,70))
  call prop_Q_A(wf(:,36),Q(:,35),MB,1_intkind1,wf(:,71))
  call counter_AW_Q(wf(:,-3),wf(:,9),wf(:,72))
  call prop_Q_A(wf(:,39),Q(:,35),MB,1_intkind1,wf(:,73))
  call prop_Q_A(wf(:,40),Q(:,35),MB,1_intkind1,wf(:,74))
  call counter_SA_Q(gH,wf(:,1),wf(:,-3),wf(:,75))
  call prop_Q_A(wf(:,24),Q(:,52),MT,1_intkind1,wf(:,76))
  call counter_SA_Q(gX,wf(:,7),wf(:,-3),wf(:,77))
  call prop_Q_A(wf(:,28),Q(:,52),MT,1_intkind1,wf(:,78))
  call counter_AV_Q(wf(:,-3),wf(:,13),wf(:,79))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,15),wf(:,80))
  call counter_AQ_S(ctStb,wf(:,-3),wf(:,-5),wf(:,81))
  call counter_QA_W(wf(:,-5),wf(:,-3),wf(:,82))
  call vert_SA_Q(gPdu,wf(:,81),wf(:,-4),wf(:,83))
  call vert_AW_Q(wf(:,-4),wf(:,82),wf(:,84))
  call vert_QS_A(gPdu,wf(:,-2),wf(:,81),wf(:,85))
  call prop_Q_A(wf(:,85),Q(:,44),ZERO,0_intkind1,wf(:,86))
  call vert_WQ_A(wf(:,82),wf(:,-2),wf(:,87))
  call prop_Q_A(wf(:,87),Q(:,44),ZERO,0_intkind1,wf(:,88))
  call counter_QS_A(gPdu,wf(:,-2),wf(:,3),wf(:,89))
  call prop_A_Q(wf(:,48),Q(:,19),ZERO,0_intkind1,wf(:,90))
  call prop_A_Q(wf(:,50),Q(:,19),ZERO,0_intkind1,wf(:,91))
  call counter_WQ_A(wf(:,5),wf(:,-2),wf(:,92))
  call counter_VQ_A(wf(:,13),wf(:,-2),wf(:,93))
  call prop_A_Q(wf(:,42),Q(:,56),ZERO,0_intkind1,wf(:,94))
  call counter_ZQ_A(gZu,wf(:,15),wf(:,-2),wf(:,95))
  call prop_A_Q(wf(:,46),Q(:,56),ZERO,0_intkind1,wf(:,96))
  call counter_AQ_S(gPdu,wf(:,-4),wf(:,-2),wf(:,97))
  call vert_SS_S(wf(:,1),wf(:,97),wf(:,98))
  call vert_ST_V(wf(:,97),Q(:,20),wf(:,1),Q(:,3),wf(:,99))
  call vert_ST_V(wf(:,97),Q(:,20),wf(:,7),Q(:,3),wf(:,100))
  call counter_QA_W(wf(:,-2),wf(:,-4),wf(:,101))
  call vert_TV_S(wf(:,1),Q(:,3),wf(:,101),Q(:,20),wf(:,102))
  call vert_TV_S(wf(:,7),Q(:,3),wf(:,101),Q(:,20),wf(:,103))
  call vert_SV_V(wf(:,1),wf(:,101),wf(:,104))
  call vert_VS_T(wf(:,13),Q(:,3),wf(:,97),Q(:,20),wf(:,105))
  call vert_VS_T(wf(:,15),Q(:,3),wf(:,97),Q(:,20),wf(:,106))
  call vert_SV_V(wf(:,97),wf(:,13),wf(:,107))
  call vert_SV_V(wf(:,97),wf(:,15),wf(:,108))
  call vert_VV_S(wf(:,13),wf(:,101),wf(:,109))
  call vert_VV_S(wf(:,15),wf(:,101),wf(:,110))
  call vert_UV_W(wf(:,13),Q(:,3),wf(:,101),Q(:,20),wf(:,111))
  call vert_UV_W(wf(:,15),Q(:,3),wf(:,101),Q(:,20),wf(:,112))
  call vert_QS_A(gPtb,wf(:,-5),wf(:,97),wf(:,113))
  call vert_WQ_A(wf(:,101),wf(:,-5),wf(:,114))
  call vert_SA_Q(gPtb,wf(:,97),wf(:,-3),wf(:,115))
  call prop_A_Q(wf(:,115),Q(:,28),MB,1_intkind1,wf(:,116))
  call vert_AW_Q(wf(:,-3),wf(:,101),wf(:,117))
  call prop_A_Q(wf(:,117),Q(:,28),MB,1_intkind1,wf(:,118))
  call vert_SA_Q(gPln,wf(:,81),wf(:,-1),wf(:,119))
  call vert_AW_Q(wf(:,-1),wf(:,82),wf(:,120))
  call vert_QS_A(gPnl,wf(:,0),wf(:,97),wf(:,121))
  call prop_Q_A(wf(:,121),Q(:,21),ZERO,0_intkind1,wf(:,122))
  call vert_WQ_A(wf(:,101),wf(:,0),wf(:,123))
  call prop_Q_A(wf(:,123),Q(:,21),ZERO,0_intkind1,wf(:,124))
  call counter_A_Q(cttt,wf(:,25),Q(:,11),wf(:,125))
  call counter_A_Q(cttt,wf(:,27),Q(:,11),wf(:,126))
  call counter_A_Q(cttt,wf(:,30),Q(:,11),wf(:,127))
  call counter_A_Q(cttt,wf(:,32),Q(:,11),wf(:,128))
  call counter_A_Q(ctbb,wf(:,35),Q(:,28),wf(:,129))
  call counter_A_Q(ctbb,wf(:,38),Q(:,28),wf(:,130))
  call counter_Q_A(ctqq,wf(:,43),Q(:,7),wf(:,131))
  call counter_Q_A(ctqq,wf(:,45),Q(:,7),wf(:,132))
  call counter_Q_A(ctqq,wf(:,49),Q(:,44),wf(:,133))
  call counter_Q_A(ctqq,wf(:,52),Q(:,44),wf(:,134))
  call vert_SS_S(wf(:,1),wf(:,3),wf(:,135))
  call vert_ST_V(wf(:,3),Q(:,40),wf(:,1),Q(:,3),wf(:,136))
  call vert_ST_V(wf(:,3),Q(:,40),wf(:,7),Q(:,3),wf(:,137))
  call vert_TV_S(wf(:,1),Q(:,3),wf(:,5),Q(:,40),wf(:,138))
  call vert_TV_S(wf(:,7),Q(:,3),wf(:,5),Q(:,40),wf(:,139))
  call vert_SV_V(wf(:,1),wf(:,5),wf(:,140))
  call vert_TV_S(wf(:,3),Q(:,40),wf(:,13),Q(:,3),wf(:,141))
  call vert_TV_S(wf(:,3),Q(:,40),wf(:,15),Q(:,3),wf(:,142))
  call vert_SV_V(wf(:,3),wf(:,13),wf(:,143))
  call vert_SV_V(wf(:,3),wf(:,15),wf(:,144))
  call vert_VV_S(wf(:,13),wf(:,5),wf(:,145))
  call vert_VV_S(wf(:,15),wf(:,5),wf(:,146))
  call vert_UV_W(wf(:,5),Q(:,40),wf(:,13),Q(:,3),wf(:,147))
  call vert_UV_W(wf(:,5),Q(:,40),wf(:,15),Q(:,3),wf(:,148))
  call vert_AQ_S(gPdu,wf(:,-4),wf(:,43),wf(:,149))
  call vert_AQ_S(gPdu,wf(:,-4),wf(:,45),wf(:,150))
  call vert_QA_W(wf(:,43),wf(:,-4),wf(:,151))
  call vert_QA_W(wf(:,45),wf(:,-4),wf(:,152))
  call vert_AQ_S(gPtb,wf(:,25),wf(:,-5),wf(:,153))
  call vert_AQ_S(gPtb,wf(:,27),wf(:,-5),wf(:,154))
  call vert_QA_W(wf(:,-5),wf(:,25),wf(:,155))
  call vert_QA_W(wf(:,-5),wf(:,27),wf(:,156))
  call vert_AQ_S(gPtb,wf(:,30),wf(:,-5),wf(:,157))
  call vert_AQ_S(gPtb,wf(:,32),wf(:,-5),wf(:,158))
  call vert_QA_W(wf(:,-5),wf(:,30),wf(:,159))
  call vert_QA_W(wf(:,-5),wf(:,32),wf(:,160))
  call vert_AQ_S(gPdu,wf(:,90),wf(:,-2),wf(:,161))
  call vert_AQ_S(gPdu,wf(:,91),wf(:,-2),wf(:,162))
  call vert_QA_W(wf(:,-2),wf(:,90),wf(:,163))
  call vert_QA_W(wf(:,-2),wf(:,91),wf(:,164))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,70),wf(:,165))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,71),wf(:,166))
  call vert_QA_W(wf(:,70),wf(:,-3),wf(:,167))
  call vert_QA_W(wf(:,71),wf(:,-3),wf(:,168))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,73),wf(:,169))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,74),wf(:,170))
  call vert_QA_W(wf(:,73),wf(:,-3),wf(:,171))
  call vert_QA_W(wf(:,74),wf(:,-3),wf(:,172))
  call vert_AQ_S(gPln,wf(:,-1),wf(:,55),wf(:,173))
  call vert_QA_W(wf(:,55),wf(:,-1),wf(:,174))
  call vert_AQ_S(gPln,wf(:,-1),wf(:,58),wf(:,175))
  call vert_QA_W(wf(:,58),wf(:,-1),wf(:,176))
  call prop_A_Q(wf(:,54),Q(:,42),ZERO,0_intkind1,wf(:,177))
  call vert_AQ_S(gPnl,wf(:,177),wf(:,0),wf(:,178))
  call prop_A_Q(wf(:,56),Q(:,42),ZERO,0_intkind1,wf(:,179))
  call vert_AQ_S(gPnl,wf(:,179),wf(:,0),wf(:,180))
  call vert_QA_W(wf(:,0),wf(:,177),wf(:,181))
  call vert_QA_W(wf(:,0),wf(:,179),wf(:,182))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MH2)
  den(2) = 1 / (Q(5,20) - MW2)
  den(3) = 1 / (Q(5,40) - MW2)
  den(6) = 1 / (Q(5,3) - MZ2)
  den(9) = 1 / (Q(5,3))
  den(12) = 1 / (Q(5,11) - MT2)
  den(19) = 1 / (Q(5,28) - MB2)
  den(24) = 1 / (Q(5,7))
  den(29) = 1 / (Q(5,44))
  den(33) = 1 / (Q(5,21))
  den(36) = 1 / (Q(5,35) - MB2)
  den(43) = 1 / (Q(5,52) - MT2)
  den(48) = 1 / (Q(5,19))
  den(53) = 1 / (Q(5,56))
  den(67) = 1 / (Q(5,23) - MW2)
  den(72) = 1 / (Q(5,43) - MW2)
  den(89) = 1 / (Q(5,42))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(3)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(2)*den(13)
  den(15) = den(6)*den(12)
  den(16) = den(2)*den(15)
  den(17) = den(9)*den(12)
  den(18) = den(2)*den(17)
  den(20) = den(2)*den(19)
  den(21) = den(1)*den(20)
  den(22) = den(6)*den(20)
  den(23) = den(9)*den(20)
  den(25) = den(9)*den(24)
  den(26) = den(3)*den(25)
  den(27) = den(6)*den(24)
  den(28) = den(3)*den(27)
  den(30) = den(3)*den(29)
  den(31) = den(9)*den(30)
  den(32) = den(6)*den(30)
  den(34) = den(2)*den(33)
  den(35) = den(3)*den(34)
  den(37) = den(1)*den(36)
  den(38) = den(2)*den(37)
  den(39) = den(6)*den(36)
  den(40) = den(2)*den(39)
  den(41) = den(9)*den(36)
  den(42) = den(2)*den(41)
  den(44) = den(2)*den(43)
  den(45) = den(1)*den(44)
  den(46) = den(6)*den(44)
  den(47) = den(9)*den(44)
  den(49) = den(9)*den(48)
  den(50) = den(3)*den(49)
  den(51) = den(6)*den(48)
  den(52) = den(3)*den(51)
  den(54) = den(3)*den(53)
  den(55) = den(9)*den(54)
  den(56) = den(6)*den(54)
  den(57) = den(13)*den(44)
  den(58) = den(15)*den(44)
  den(59) = den(17)*den(44)
  den(60) = den(20)*den(37)
  den(61) = den(20)*den(39)
  den(62) = den(20)*den(41)
  den(63) = den(25)*den(54)
  den(64) = den(27)*den(54)
  den(65) = den(30)*den(49)
  den(66) = den(30)*den(51)
  den(68) = den(4)*den(67)
  den(69) = den(7)*den(67)
  den(70) = den(10)*den(67)
  den(71) = den(1)*den(3)
  den(73) = den(71)*den(72)
  den(74) = den(3)*den(6)
  den(75) = den(72)*den(74)
  den(76) = den(3)*den(9)
  den(77) = den(72)*den(76)
  den(78) = den(25)*den(67)
  den(79) = den(27)*den(67)
  den(80) = den(13)*den(72)
  den(81) = den(15)*den(72)
  den(82) = den(17)*den(72)
  den(83) = den(49)*den(67)
  den(84) = den(51)*den(67)
  den(85) = den(37)*den(72)
  den(86) = den(39)*den(72)
  den(87) = den(41)*den(72)
  den(88) = den(34)*den(67)
  den(90) = den(3)*den(89)
  den(91) = den(72)*den(90)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(174)

  A(1) = cont_SS(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_VV(wf(:,5),wf(:,6)) * den(5)
  A(3) = cont_VV(wf(:,5),wf(:,8)) * den(8)
  A(4) = cont_SS(wf(:,3),wf(:,10)) * den(5)
  A(5) = cont_SS(wf(:,3),wf(:,11)) * den(8)
  A(6) = cont_VV(wf(:,5),wf(:,12)) * den(5)
  A(7) = cont_SS(wf(:,3),wf(:,14)) * den(11)
  A(8) = cont_SS(wf(:,3),wf(:,16)) * den(8)
  A(9) = cont_VV(wf(:,5),wf(:,17)) * den(11)
  A(10) = cont_VV(wf(:,5),wf(:,18)) * den(8)
  A(11) = cont_SS(wf(:,3),wf(:,19)) * den(11)
  A(12) = cont_SS(wf(:,3),wf(:,20)) * den(8)
  A(13) = cont_VV(wf(:,5),wf(:,21)) * den(11)
  A(14) = cont_VV(wf(:,5),wf(:,22)) * den(8)
  A(15) = cont_QA(wf(:,24),wf(:,25)) * den(14)
  A(16) = cont_QA(wf(:,24),wf(:,27)) * den(16)
  A(17) = cont_QA(wf(:,25),wf(:,28)) * den(14)
  A(18) = cont_QA(wf(:,27),wf(:,28)) * den(16)
  A(19) = cont_QA(wf(:,24),wf(:,30)) * den(18)
  A(20) = cont_QA(wf(:,24),wf(:,32)) * den(16)
  A(21) = cont_QA(wf(:,28),wf(:,30)) * den(18)
  A(22) = cont_QA(wf(:,28),wf(:,32)) * den(16)
  A(23) = cont_QA(wf(:,34),wf(:,35)) * den(21)
  A(24) = cont_QA(wf(:,35),wf(:,36)) * den(22)
  A(25) = cont_QA(wf(:,34),wf(:,38)) * den(21)
  A(26) = cont_QA(wf(:,36),wf(:,38)) * den(22)
  A(27) = cont_QA(wf(:,35),wf(:,39)) * den(23)
  A(28) = cont_QA(wf(:,35),wf(:,40)) * den(22)
  A(29) = cont_QA(wf(:,38),wf(:,39)) * den(23)
  A(30) = cont_QA(wf(:,38),wf(:,40)) * den(22)
  A(31) = cont_QA(wf(:,42),wf(:,43)) * den(26)
  A(32) = cont_QA(wf(:,42),wf(:,45)) * den(28)
  A(33) = cont_QA(wf(:,43),wf(:,46)) * den(26)
  A(34) = cont_QA(wf(:,45),wf(:,46)) * den(28)
  A(35) = cont_QA(wf(:,48),wf(:,49)) * den(31)
  A(36) = cont_QA(wf(:,49),wf(:,50)) * den(32)
  A(37) = cont_QA(wf(:,48),wf(:,52)) * den(31)
  A(38) = cont_QA(wf(:,50),wf(:,52)) * den(32)
  A(39) = cont_QA(wf(:,54),wf(:,55)) * den(35)
  A(40) = cont_QA(wf(:,55),wf(:,56)) * den(35)
  A(41) = cont_QA(wf(:,54),wf(:,58)) * den(35)
  A(42) = cont_QA(wf(:,56),wf(:,58)) * den(35)

  A(43) = cont_QA(wf(:,25),wf(:,59)) * den(14)
  A(44) = cont_QA(wf(:,27),wf(:,59)) * den(16)
  A(45) = cont_QA(wf(:,25),wf(:,60)) * den(14)
  A(46) = cont_QA(wf(:,27),wf(:,60)) * den(16)
  A(47) = cont_QA(wf(:,30),wf(:,59)) * den(18)
  A(48) = cont_QA(wf(:,32),wf(:,59)) * den(16)
  A(49) = cont_QA(wf(:,30),wf(:,60)) * den(18)
  A(50) = cont_QA(wf(:,32),wf(:,60)) * den(16)
  A(51) = cont_QA(wf(:,35),wf(:,61)) * den(21)
  A(52) = cont_QA(wf(:,35),wf(:,62)) * den(22)
  A(53) = cont_QA(wf(:,38),wf(:,61)) * den(21)
  A(54) = cont_QA(wf(:,38),wf(:,62)) * den(22)
  A(55) = cont_QA(wf(:,35),wf(:,63)) * den(23)
  A(56) = cont_QA(wf(:,35),wf(:,64)) * den(22)
  A(57) = cont_QA(wf(:,38),wf(:,63)) * den(23)
  A(58) = cont_QA(wf(:,38),wf(:,64)) * den(22)
  A(59) = cont_QA(wf(:,43),wf(:,65)) * den(26)
  A(60) = cont_QA(wf(:,45),wf(:,65)) * den(28)
  A(61) = cont_QA(wf(:,43),wf(:,66)) * den(26)
  A(62) = cont_QA(wf(:,45),wf(:,66)) * den(28)
  A(63) = cont_QA(wf(:,49),wf(:,67)) * den(31)
  A(64) = cont_QA(wf(:,49),wf(:,68)) * den(32)
  A(65) = cont_QA(wf(:,52),wf(:,67)) * den(31)
  A(66) = cont_QA(wf(:,52),wf(:,68)) * den(32)
  A(67) = cont_QA(wf(:,69),wf(:,70)) * den(38)
  A(68) = cont_QA(wf(:,69),wf(:,71)) * den(40)
  A(69) = cont_QA(wf(:,70),wf(:,72)) * den(38)
  A(70) = cont_QA(wf(:,71),wf(:,72)) * den(40)
  A(71) = cont_QA(wf(:,69),wf(:,73)) * den(42)
  A(72) = cont_QA(wf(:,69),wf(:,74)) * den(40)
  A(73) = cont_QA(wf(:,72),wf(:,73)) * den(42)
  A(74) = cont_QA(wf(:,72),wf(:,74)) * den(40)
  A(75) = cont_QA(wf(:,75),wf(:,76)) * den(45)
  A(76) = cont_QA(wf(:,76),wf(:,77)) * den(46)
  A(77) = cont_QA(wf(:,75),wf(:,78)) * den(45)
  A(78) = cont_QA(wf(:,77),wf(:,78)) * den(46)
  A(79) = cont_QA(wf(:,76),wf(:,79)) * den(47)
  A(80) = cont_QA(wf(:,76),wf(:,80)) * den(46)
  A(81) = cont_QA(wf(:,78),wf(:,79)) * den(47)
  A(82) = cont_QA(wf(:,78),wf(:,80)) * den(46)
  A(83) = cont_SS(wf(:,4),wf(:,81)) * den(5)
  A(84) = cont_VV(wf(:,6),wf(:,82)) * den(5)
  A(85) = cont_VV(wf(:,8),wf(:,82)) * den(8)
  A(86) = cont_SS(wf(:,10),wf(:,81)) * den(5)
  A(87) = cont_SS(wf(:,11),wf(:,81)) * den(8)
  A(88) = cont_VV(wf(:,12),wf(:,82)) * den(5)
  A(89) = cont_SS(wf(:,14),wf(:,81)) * den(11)
  A(90) = cont_SS(wf(:,16),wf(:,81)) * den(8)
  A(91) = cont_VV(wf(:,17),wf(:,82)) * den(11)
  A(92) = cont_VV(wf(:,18),wf(:,82)) * den(8)
  A(93) = cont_SS(wf(:,19),wf(:,81)) * den(11)
  A(94) = cont_SS(wf(:,20),wf(:,81)) * den(8)
  A(95) = cont_VV(wf(:,21),wf(:,82)) * den(11)
  A(96) = cont_VV(wf(:,22),wf(:,82)) * den(8)
  A(97) = cont_QA(wf(:,43),wf(:,83)) * den(26)
  A(98) = cont_QA(wf(:,45),wf(:,83)) * den(28)
  A(99) = cont_QA(wf(:,43),wf(:,84)) * den(26)
  A(100) = cont_QA(wf(:,45),wf(:,84)) * den(28)
  A(101) = cont_QA(wf(:,48),wf(:,86)) * den(31)
  A(102) = cont_QA(wf(:,50),wf(:,86)) * den(32)
  A(103) = cont_QA(wf(:,48),wf(:,88)) * den(31)
  A(104) = cont_QA(wf(:,50),wf(:,88)) * den(32)
  A(105) = cont_QA(wf(:,89),wf(:,90)) * den(50)
  A(106) = cont_QA(wf(:,89),wf(:,91)) * den(52)
  A(107) = cont_QA(wf(:,90),wf(:,92)) * den(50)
  A(108) = cont_QA(wf(:,91),wf(:,92)) * den(52)
  A(109) = cont_QA(wf(:,93),wf(:,94)) * den(55)
  A(110) = cont_QA(wf(:,94),wf(:,95)) * den(56)
  A(111) = cont_QA(wf(:,93),wf(:,96)) * den(55)
  A(112) = cont_QA(wf(:,95),wf(:,96)) * den(56)
  A(113) = cont_SS(wf(:,3),wf(:,98)) * den(5)
  A(114) = cont_VV(wf(:,5),wf(:,99)) * den(5)
  A(115) = cont_VV(wf(:,5),wf(:,100)) * den(8)
  A(116) = cont_SS(wf(:,3),wf(:,102)) * den(5)
  A(117) = cont_SS(wf(:,3),wf(:,103)) * den(8)
  A(118) = cont_VV(wf(:,5),wf(:,104)) * den(5)
  A(119) = cont_SS(wf(:,3),wf(:,105)) * den(11)
  A(120) = cont_SS(wf(:,3),wf(:,106)) * den(8)
  A(121) = cont_VV(wf(:,5),wf(:,107)) * den(11)
  A(122) = cont_VV(wf(:,5),wf(:,108)) * den(8)
  A(123) = cont_SS(wf(:,3),wf(:,109)) * den(11)
  A(124) = cont_SS(wf(:,3),wf(:,110)) * den(8)
  A(125) = cont_VV(wf(:,5),wf(:,111)) * den(11)
  A(126) = cont_VV(wf(:,5),wf(:,112)) * den(8)
  A(127) = cont_QA(wf(:,25),wf(:,113)) * den(14)
  A(128) = cont_QA(wf(:,27),wf(:,113)) * den(16)
  A(129) = cont_QA(wf(:,25),wf(:,114)) * den(14)
  A(130) = cont_QA(wf(:,27),wf(:,114)) * den(16)
  A(131) = cont_QA(wf(:,30),wf(:,113)) * den(18)
  A(132) = cont_QA(wf(:,32),wf(:,113)) * den(16)
  A(133) = cont_QA(wf(:,30),wf(:,114)) * den(18)
  A(134) = cont_QA(wf(:,32),wf(:,114)) * den(16)
  A(135) = cont_QA(wf(:,34),wf(:,116)) * den(21)
  A(136) = cont_QA(wf(:,36),wf(:,116)) * den(22)
  A(137) = cont_QA(wf(:,34),wf(:,118)) * den(21)
  A(138) = cont_QA(wf(:,36),wf(:,118)) * den(22)
  A(139) = cont_QA(wf(:,39),wf(:,116)) * den(23)
  A(140) = cont_QA(wf(:,40),wf(:,116)) * den(22)
  A(141) = cont_QA(wf(:,39),wf(:,118)) * den(23)
  A(142) = cont_QA(wf(:,40),wf(:,118)) * den(22)
  A(143) = cont_QA(wf(:,55),wf(:,119)) * den(35)
  A(144) = cont_QA(wf(:,55),wf(:,120)) * den(35)
  A(145) = cont_QA(wf(:,58),wf(:,119)) * den(35)
  A(146) = cont_QA(wf(:,58),wf(:,120)) * den(35)
  A(147) = cont_QA(wf(:,54),wf(:,122)) * den(35)
  A(148) = cont_QA(wf(:,56),wf(:,122)) * den(35)
  A(149) = cont_QA(wf(:,54),wf(:,124)) * den(35)
  A(150) = cont_QA(wf(:,56),wf(:,124)) * den(35)
  A(151) = cont_QA(wf(:,76),wf(:,125)) * den(57)
  A(152) = cont_QA(wf(:,76),wf(:,126)) * den(58)
  A(153) = cont_QA(wf(:,78),wf(:,125)) * den(57)
  A(154) = cont_QA(wf(:,78),wf(:,126)) * den(58)
  A(155) = cont_QA(wf(:,76),wf(:,127)) * den(59)
  A(156) = cont_QA(wf(:,76),wf(:,128)) * den(58)
  A(157) = cont_QA(wf(:,78),wf(:,127)) * den(59)
  A(158) = cont_QA(wf(:,78),wf(:,128)) * den(58)
  A(159) = cont_QA(wf(:,70),wf(:,129)) * den(60)
  A(160) = cont_QA(wf(:,71),wf(:,129)) * den(61)
  A(161) = cont_QA(wf(:,70),wf(:,130)) * den(60)
  A(162) = cont_QA(wf(:,71),wf(:,130)) * den(61)
  A(163) = cont_QA(wf(:,73),wf(:,129)) * den(62)
  A(164) = cont_QA(wf(:,74),wf(:,129)) * den(61)
  A(165) = cont_QA(wf(:,73),wf(:,130)) * den(62)
  A(166) = cont_QA(wf(:,74),wf(:,130)) * den(61)
  A(167) = cont_QA(wf(:,94),wf(:,131)) * den(63)
  A(168) = cont_QA(wf(:,94),wf(:,132)) * den(64)
  A(169) = cont_QA(wf(:,96),wf(:,131)) * den(63)
  A(170) = cont_QA(wf(:,96),wf(:,132)) * den(64)
  A(171) = cont_QA(wf(:,90),wf(:,133)) * den(65)
  A(172) = cont_QA(wf(:,91),wf(:,133)) * den(66)
  A(173) = cont_QA(wf(:,90),wf(:,134)) * den(65)
  A(174) = cont_QA(wf(:,91),wf(:,134)) * den(66)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(174)
  complex(REALKIND), intent(out) :: M1(1), M2(1)

  M1(1) = -(A(8)*f(1))+A(42)*f(4)-A(6)*f(7)+(-A(23)+A(24))*f(10)-A(39)*f(14)-A(1)*f(17)+(-A(15)-A(16))*f(20)+(-A(2)+A(3)-A(4) &
       -A(5))*f(24)+(-A(40)+A(41))*f(25)+(-A(25)+A(26))*f(34)+(-A(17)-A(18))*f(39)+A(14)*f(44)+(A(29)+A(37))*f(47)+(-A(21) &
       -A(33))*f(48)+(A(9)-A(11)-A(13)+A(22)+A(30)+A(34)+A(38))*f(49)+(A(27)+A(35))*f(64)+(-A(19)-A(31))*f(65)+(-A(7)+A(20)+A(28) &
       +A(32)+A(36))*f(66)+(A(10)-A(12))*f(80)

  M2(1) = -(A(90)*f(2))-A(120)*f(3)+A(146)*f(5)+A(150)*f(6)-A(88)*f(8)-A(118)*f(9)+(-A(67)+A(68)+A(159)-A(160))*f(11)+(-A(51) &
       +A(52))*f(12)+(-A(135)+A(136))*f(13)-A(143)*f(15)-A(147)*f(16)-A(83)*f(18)-A(113)*f(19)+(-A(43)-A(44)+A(151)+A(152))*f(21) &
       +(-A(127)-A(128))*f(22)+(-A(75)-A(76))*f(23)+(-A(86)-A(87))*f(26)+A(145)*f(27)+(-A(114)+A(115))*f(28)-A(148)*f(29)+(-A(84) &
       +A(85))*f(30)-A(144)*f(31)+(-A(116)-A(117))*f(32)+A(149)*f(33)+(A(161)-A(162))*f(35)+(-A(53)+A(54))*f(36)+(-A(69) &
       +A(70))*f(37)+(-A(137)+A(138))*f(38)+(A(153)+A(154))*f(40)+(-A(77)-A(78))*f(41)+(-A(45)-A(46))*f(42)+(-A(129)-A(130))*f(43) &
       +A(96)*f(45)+A(126)*f(46)+(-A(165)-A(173))*f(50)+(A(157)+A(169))*f(51)+(-A(93)-A(158)-A(166)-A(170)-A(174))*f(52) &
       +A(121)*f(53)+A(57)*f(54)+A(58)*f(55)+(A(73)+A(103))*f(56)+(-A(49)-A(99))*f(57)+(A(50)+A(74)+A(91)-A(95)+A(100) &
       +A(104))*f(58)+(A(65)+A(107)+A(141))*f(59)+(-A(61)-A(111)-A(133))*f(60)+(A(62)+A(66)+A(108)+A(112)-A(123)-A(125)+A(134) &
       +A(142))*f(61)-A(81)*f(62)+A(82)*f(63)+(A(71)+A(101)-A(163)-A(171))*f(67)+(-A(47)-A(97)+A(155)+A(167))*f(68)+(A(48)+A(72) &
       -A(89)+A(98)+A(102)-A(156)-A(164)-A(168)-A(172))*f(69)+(A(105)+A(139))*f(70)+(-A(59)-A(131))*f(71)+(A(60)+A(106)-A(119) &
       +A(132)+A(140))*f(72)+A(55)*f(73)+A(56)*f(74)+A(63)*f(75)-A(109)*f(76)+(A(64)+A(110))*f(77)-A(79)*f(78)+A(80)*f(79) &
       -A(94)*f(81)+A(122)*f(82)+A(92)*f(83)-A(124)*f(84)

end subroutine colourvectors

end module ol_loop_pptllj_eexutxdxb_1_/**/REALKIND
