
FeynArtsProcess = {F[3, {1}], -F[3, {3}]} -> {F[4, {1}], -F[4, {3}], S[1], V[5]};

SortExternal = True;

OpenLoopsModel = "SM";

CreateTopologiesOptions = {
  ExcludeTopologies -> {Snails, WFCorrectionCTs, TadpoleCTs}
};

InsertFieldsOptions = {
  Restrictions -> {NoQuarkMixing},
  Model -> {"SMQCD", "SMQCDR2"},
  InsertionLevel -> {Particles}
};

UnitaryGauge = False;

ColourCorrelations = Automatic;

SubProcessName = Automatic;

SelectCoupling = Exponent[#1, gQCD] == 1 + 2*#2 & ;

SelectInterference = {
  eQED -> {6}
};

SelectTreeDiagrams = True & ;

SelectLoopDiagrams = True & ;

SelectCTDiagrams = True & ;

ReplaceOSw = False;

SetParameters = {
  nc -> 3,
  nf -> 6,
  MU -> 0,
  MD -> 0,
  MS -> 0,
  MC -> 0,
  LeadingColour -> 0
};

ChannelMap = {};

Approximation = "";

ForceLoops = Automatic;

NonZeroHels = Null;
