
module ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(44,2), K2(2,2), KL(2,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12,   0]
  K1( 2,:) = [   0,  12]
  K1( 3,:) = [  16,   0]
  K1( 4,:) = [   0,  16]
  K1( 5,:) = [   0,  -2]
  K1( 6,:) = [  -2,   0]
  K1( 7,:) = [  16,   0]
  K1( 8,:) = [   0,  16]
  K1( 9,:) = [   2,   0]
  K1(10,:) = [   0, -16]
  K1(11,:) = [   0,   2]
  K1(12,:) = [   2,   0]
  K1(13,:) = [  16,   0]
  K1(14,:) = [   0,  16]
  K1(15,:) = [   0,   2]
  K1(16,:) = [   2,   0]
  K1(17,:) = [ -16,   0]
  K1(18,:) = [   0,   2]
  K1(19,:) = [   0,  -2]
  K1(20,:) = [  -2,   0]
  K1(21,:) = [  16,   0]
  K1(22,:) = [   0,  16]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [ -18,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0, -18]
  K1(37,:) = [ -18,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0, -18]
  K1(41,:) = [   0,   0]
  K1(42,:) = [   0,   0]
  K1(43,:) = [  36,   0]
  K1(44,:) = [   0,  36]

  K2(1,:) = [ 12,  0]
  K2(2,:) = [  0, 12]

  KL(1,:) = [  4, 12,  0,  4]
  KL(2,:) = [  4,  0, 12,  4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND



module ol_forced_parameters_ppthjj_uxtdbxhg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppthjj_uxtdbxhg_1_/**/REALKIND

module ol_loop_ppthjj_uxtdbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(71), c(39)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:311)
  ! denominators
  complex(REALKIND), save :: den(169)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(2,32)
  ! zero helicity identifier
  logical,           save :: zerohel(32) = .true., zerohel_ct(32) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**3*gQCD*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 2) = (CI*countertermnorm*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 3) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 4) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 5) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 6) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 7) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 8) = (CI*eQED**3*gQCD*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f( 9) = (CI*countertermnorm*eQED**3*gQCD**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(10) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(11) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(12) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(13) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(14) = (CI*eQED**3*gQCD*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(15) = (CI*countertermnorm*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(16) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(17) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(18) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(19) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(20) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f(21) = (CI*eQED**3*gQCD)/(4._/**/REALKIND*MW*sw**3)
    f(22) = (CI*countertermnorm*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(23) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(24) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(25) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(26) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(27) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(28) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f(29) = (CI*eQED**3*gQCD*MB)/(4._/**/REALKIND*MW*sw**3)
    f(30) = (CI*countertermnorm*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(31) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(32) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(33) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(34) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(35) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(36) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f(37) = (CI*eQED**3*gQCD*MT)/(4._/**/REALKIND*MW*sw**3)
    f(38) = (CI*countertermnorm*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(39) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(40) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(41) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(42) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(43) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(44) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f(45) = (CI*eQED**3*gQCD*MW)/(2._/**/REALKIND*sw**3)
    f(46) = (CI*countertermnorm*eQED**3*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(47) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(48) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(49) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(50) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(51) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(52) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(53) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3)/(2._/**/REALKIND*MW**2*sw**2)
    f(54) = (CI*eQED**3*gQCD**3*integralnorm*MB*SwB)/(4._/**/REALKIND*MW**3*sw**3)
    f(55) = (eQED**3*gQCD**3*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(56) = (CI*eQED**3*gQCD**3*integralnorm*MH**2*SwB)/(4._/**/REALKIND*MW**3*sw**3)
    f(57) = (eQED**3*gQCD**3*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(58) = (CI*eQED**3*gQCD**3*integralnorm*MT*SwB)/(4._/**/REALKIND*MW**3*sw**3)
    f(59) = (eQED**3*gQCD**3*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(60) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(4._/**/REALKIND*MW*sw**3)
    f(61) = (eQED**3*gQCD**3*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(62) = (CI*eQED**3*gQCD**3*integralnorm*MB*SwB)/(4._/**/REALKIND*MW*sw**3)
    f(63) = (eQED**3*gQCD**3*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(64) = (CI*eQED**3*gQCD**3*integralnorm*MT*SwB)/(4._/**/REALKIND*MW*sw**3)
    f(65) = (eQED**3*gQCD**3*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(66) = (CI*eQED**3*gQCD**3*integralnorm*MW*SwB)/(2._/**/REALKIND*sw**3)
    f(67) = (eQED**3*gQCD**3*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(68) = (eQED**3*gQCD**3*integralnorm*MB*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(69) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(70) = (eQED**3*gQCD**3*integralnorm*MB*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(71) = (eQED**3*gQCD**3*integralnorm*MT*SwF)/(MW*sw**3*4._/**/REALKIND)

  c = [ 3*CI*f(54), 9*CI*f(54), f(55), 3*f(55), 8*f(55), 3*CI*f(56), 9*CI*f(56), f(57), 3*f(57), 8*f(57), 3*CI*f(58), 9*CI*f(58) &
    , f(59), 3*f(59), 8*f(59), 3*CI*f(60), 9*CI*f(60), f(61), 3*f(61), 8*f(61), 3*CI*f(62), 9*CI*f(62), f(63), 3*f(63), 8*f(63) &
    , 3*CI*f(64), 9*CI*f(64), f(65), 3*f(65), 8*f(65), 3*CI*f(66), 9*CI*f(66), f(67), 3*f(67), 8*f(67), 3*f(68), 3*f(69), 3*f(70) &
    , 3*f(71) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  complex(REALKIND), intent(out) :: M1(2), M2(2)
  complex(REALKIND) :: A(228)
  ! external WFs
  call wf_A(P(:,1), rZERO, H(1), wf(:,0))
  call wf_Q(P(:,2), rMT, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rMB, H(4), wf(:,-3))
  call wf_S(P(:,5), rMH, H(5), wf(:,-4))
  call wf_V(P(:,6), rZERO, H(6), wf(:,-5))

  ! internal WFs
  call vert_AQ_S(gPud,wf(:,0),wf(:,-2),wf(:,1))
  call vert_QS_A(gH,wf(:,-1),wf(:,-4),wf(:,2))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,3))
  call prop_Q_A(wf(:,2),Q(:,18),MT,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,3),Q(:,40),MB,1_intkind1,wf(:,5))
  call vert_QS_A(gPbt,wf(:,4),wf(:,1),wf(:,6))
  call vert_QA_W(wf(:,-2),wf(:,0),wf(:,7))
  call vert_WQ_A(wf(:,7),wf(:,4),wf(:,8))
  call vert_SA_Q(gPbt,wf(:,1),wf(:,-3),wf(:,9))
  call vert_VQ_A(wf(:,-5),wf(:,4),wf(:,10))
  call prop_A_Q(wf(:,9),Q(:,13),MT,1_intkind1,wf(:,11))
  call vert_AW_Q(wf(:,-3),wf(:,7),wf(:,12))
  call prop_A_Q(wf(:,12),Q(:,13),MT,1_intkind1,wf(:,13))
  call vert_VQ_A(wf(:,-5),wf(:,-1),wf(:,14))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,15))
  call prop_Q_A(wf(:,14),Q(:,34),MT,1_intkind1,wf(:,16))
  call prop_A_Q(wf(:,15),Q(:,24),MB,1_intkind1,wf(:,17))
  call vert_QS_A(gPbt,wf(:,16),wf(:,1),wf(:,18))
  call vert_WQ_A(wf(:,7),wf(:,16),wf(:,19))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,1),wf(:,20))
  call vert_AV_Q(wf(:,17),wf(:,-5),wf(:,21))
  call prop_Q_A(wf(:,20),Q(:,7),MB,1_intkind1,wf(:,22))
  call vert_WQ_A(wf(:,7),wf(:,-1),wf(:,23))
  call prop_Q_A(wf(:,23),Q(:,7),MB,1_intkind1,wf(:,24))
  call vert_QS_A(gH,wf(:,16),wf(:,-4),wf(:,25))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,16),wf(:,26))
  call vert_SS_S(wf(:,1),wf(:,-4),wf(:,27))
  call vert_QA_W(wf(:,16),wf(:,-3),wf(:,28))
  call vert_ST_V(wf(:,1),Q(:,5),wf(:,-4),Q(:,16),wf(:,29))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,7),Q(:,5),wf(:,30))
  call vert_SV_V(wf(:,-4),wf(:,7),wf(:,31))
  call vert_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,32))
  call vert_AQ_S(gPbt,wf(:,5),wf(:,-1),wf(:,33))
  call vert_QA_W(wf(:,-1),wf(:,5),wf(:,34))
  call vert_AV_Q(wf(:,0),wf(:,-5),wf(:,35))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,-1),wf(:,36))
  call prop_A_Q(wf(:,35),Q(:,33),ZERO,0_intkind1,wf(:,37))
  call vert_AQ_S(gPud,wf(:,37),wf(:,-2),wf(:,38))
  call vert_SS_S(wf(:,36),wf(:,-4),wf(:,39))
  call vert_QA_W(wf(:,-2),wf(:,37),wf(:,40))
  call vert_ST_V(wf(:,36),Q(:,10),wf(:,-4),Q(:,16),wf(:,41))
  call vert_QA_W(wf(:,-1),wf(:,-3),wf(:,42))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,42),Q(:,10),wf(:,43))
  call vert_SV_V(wf(:,-4),wf(:,42),wf(:,44))
  call vert_VQ_A(wf(:,-5),wf(:,-2),wf(:,45))
  call prop_Q_A(wf(:,45),Q(:,36),ZERO,0_intkind1,wf(:,46))
  call vert_AQ_S(gPud,wf(:,0),wf(:,46),wf(:,47))
  call vert_QA_W(wf(:,46),wf(:,0),wf(:,48))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,4),wf(:,49))
  call vert_QA_W(wf(:,4),wf(:,-3),wf(:,50))
  call vert_AQ_S(gPbt,wf(:,17),wf(:,-1),wf(:,51))
  call vert_QA_W(wf(:,-1),wf(:,17),wf(:,52))
  call counter_QS_A(ctSbt,wf(:,4),wf(:,1),wf(:,53))
  call counter_WQ_A(wf(:,7),wf(:,4),wf(:,54))
  call counter_VQ_A(wf(:,-5),wf(:,4),wf(:,55))
  call counter_QS_A(ctSbt,wf(:,16),wf(:,1),wf(:,56))
  call counter_WQ_A(wf(:,7),wf(:,16),wf(:,57))
  call counter_AV_Q(wf(:,17),wf(:,-5),wf(:,58))
  call counter_QS_A(gH,wf(:,16),wf(:,-4),wf(:,59))
  call counter_SA_Q(gH,wf(:,-4),wf(:,5),wf(:,60))
  call counter_SG_G(wf(:,-4),wf(:,-5),wf(:,61))
  call vert_AV_Q(wf(:,-3),wf(:,61),wf(:,62))
  call vert_VQ_A(wf(:,61),wf(:,-1),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,50),MT,1_intkind1,wf(:,64))
  call counter_SA_Q(ctSbt,wf(:,1),wf(:,-3),wf(:,65))
  call prop_Q_A(wf(:,10),Q(:,50),MT,1_intkind1,wf(:,66))
  call counter_AW_Q(wf(:,-3),wf(:,7),wf(:,67))
  call counter_AV_Q(wf(:,-3),wf(:,-5),wf(:,68))
  call prop_A_Q(wf(:,68),Q(:,40),MB,1_intkind1,wf(:,69))
  call counter_AQ_S(ctSbt,wf(:,-3),wf(:,16),wf(:,70))
  call counter_QA_W(wf(:,16),wf(:,-3),wf(:,71))
  call prop_Q_A(wf(:,25),Q(:,50),MT,1_intkind1,wf(:,72))
  call vert_SA_Q(gH,wf(:,-4),wf(:,69),wf(:,73))
  call vert_AQ_S(gPbt,wf(:,69),wf(:,-1),wf(:,74))
  call vert_QA_W(wf(:,-1),wf(:,69),wf(:,75))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,76))
  call prop_A_Q(wf(:,76),Q(:,24),MB,1_intkind1,wf(:,77))
  call vert_AV_Q(wf(:,77),wf(:,-5),wf(:,78))
  call vert_SA_Q(gPud,wf(:,36),wf(:,0),wf(:,79))
  call vert_VQ_A(wf(:,61),wf(:,-2),wf(:,80))
  call prop_A_Q(wf(:,79),Q(:,11),ZERO,0_intkind1,wf(:,81))
  call vert_AW_Q(wf(:,0),wf(:,42),wf(:,82))
  call prop_A_Q(wf(:,82),Q(:,11),ZERO,0_intkind1,wf(:,83))
  call vert_AV_Q(wf(:,0),wf(:,61),wf(:,84))
  call vert_QS_A(gPud,wf(:,-2),wf(:,36),wf(:,85))
  call prop_A_Q(wf(:,84),Q(:,49),ZERO,0_intkind1,wf(:,86))
  call vert_WQ_A(wf(:,42),wf(:,-2),wf(:,87))
  call counter_AQ_S(ctSbt,wf(:,-3),wf(:,4),wf(:,88))
  call counter_QA_W(wf(:,4),wf(:,-3),wf(:,89))
  call vert_AQ_S(gPbt,wf(:,77),wf(:,-1),wf(:,90))
  call vert_QA_W(wf(:,-1),wf(:,77),wf(:,91))
  call counter_AQ_S(gPud,wf(:,37),wf(:,-2),wf(:,92))
  call counter_QA_W(wf(:,-2),wf(:,37),wf(:,93))
  call counter_VQ_A(wf(:,-5),wf(:,-2),wf(:,94))
  call prop_Q_A(wf(:,94),Q(:,36),ZERO,0_intkind1,wf(:,95))
  call vert_AQ_S(gPud,wf(:,0),wf(:,95),wf(:,96))
  call vert_QA_W(wf(:,95),wf(:,0),wf(:,97))
  call counter_QS_A(ctSbt,wf(:,-1),wf(:,1),wf(:,98))
  call prop_A_Q(wf(:,21),Q(:,56),MB,1_intkind1,wf(:,99))
  call counter_WQ_A(wf(:,7),wf(:,-1),wf(:,100))
  call counter_VQ_A(wf(:,-5),wf(:,-1),wf(:,101))
  call prop_Q_A(wf(:,101),Q(:,34),MT,1_intkind1,wf(:,102))
  call vert_QS_A(gPbt,wf(:,102),wf(:,1),wf(:,103))
  call vert_WQ_A(wf(:,7),wf(:,102),wf(:,104))
  call counter_AQ_S(ctSbt,wf(:,5),wf(:,-1),wf(:,105))
  call counter_QA_W(wf(:,-1),wf(:,5),wf(:,106))
  call prop_A_Q(wf(:,32),Q(:,56),MB,1_intkind1,wf(:,107))
  call vert_QS_A(gH,wf(:,102),wf(:,-4),wf(:,108))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,102),wf(:,109))
  call vert_QA_W(wf(:,102),wf(:,-3),wf(:,110))
  call counter_QS_A(gH,wf(:,-1),wf(:,-4),wf(:,111))
  call prop_Q_A(wf(:,111),Q(:,18),MT,1_intkind1,wf(:,112))
  call vert_QS_A(gPbt,wf(:,112),wf(:,1),wf(:,113))
  call vert_WQ_A(wf(:,7),wf(:,112),wf(:,114))
  call vert_VQ_A(wf(:,-5),wf(:,112),wf(:,115))
  call counter_AQ_S(ctSbt,wf(:,17),wf(:,-1),wf(:,116))
  call counter_QA_W(wf(:,-1),wf(:,17),wf(:,117))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,112),wf(:,118))
  call vert_QA_W(wf(:,112),wf(:,-3),wf(:,119))
  call counter_AQ_S(ctSbt,wf(:,-3),wf(:,-1),wf(:,120))
  call vert_SS_S(wf(:,120),wf(:,-4),wf(:,121))
  call vert_ST_V(wf(:,120),Q(:,10),wf(:,-4),Q(:,16),wf(:,122))
  call counter_QA_W(wf(:,-1),wf(:,-3),wf(:,123))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,123),Q(:,10),wf(:,124))
  call vert_SV_V(wf(:,-4),wf(:,123),wf(:,125))
  call counter_AQ_S(gPud,wf(:,0),wf(:,46),wf(:,126))
  call counter_QA_W(wf(:,46),wf(:,0),wf(:,127))
  call counter_AV_Q(wf(:,0),wf(:,-5),wf(:,128))
  call prop_A_Q(wf(:,128),Q(:,33),ZERO,0_intkind1,wf(:,129))
  call vert_AQ_S(gPud,wf(:,129),wf(:,-2),wf(:,130))
  call vert_QA_W(wf(:,-2),wf(:,129),wf(:,131))
  call counter_AQ_S(gPud,wf(:,0),wf(:,-2),wf(:,132))
  call vert_QS_A(gPbt,wf(:,4),wf(:,132),wf(:,133))
  call counter_QA_W(wf(:,-2),wf(:,0),wf(:,134))
  call vert_WQ_A(wf(:,134),wf(:,4),wf(:,135))
  call vert_SA_Q(gPbt,wf(:,132),wf(:,-3),wf(:,136))
  call prop_A_Q(wf(:,136),Q(:,13),MT,1_intkind1,wf(:,137))
  call vert_AW_Q(wf(:,-3),wf(:,134),wf(:,138))
  call prop_A_Q(wf(:,138),Q(:,13),MT,1_intkind1,wf(:,139))
  call vert_QS_A(gPbt,wf(:,16),wf(:,132),wf(:,140))
  call vert_WQ_A(wf(:,134),wf(:,16),wf(:,141))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,132),wf(:,142))
  call prop_Q_A(wf(:,142),Q(:,7),MB,1_intkind1,wf(:,143))
  call vert_WQ_A(wf(:,134),wf(:,-1),wf(:,144))
  call prop_Q_A(wf(:,144),Q(:,7),MB,1_intkind1,wf(:,145))
  call vert_SS_S(wf(:,132),wf(:,-4),wf(:,146))
  call vert_ST_V(wf(:,132),Q(:,5),wf(:,-4),Q(:,16),wf(:,147))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,134),Q(:,5),wf(:,148))
  call vert_SV_V(wf(:,-4),wf(:,134),wf(:,149))
  call vert_SA_Q(gPbt,wf(:,1),wf(:,5),wf(:,150))
  call counter_Q_A(cttt,wf(:,4),Q(:,18),wf(:,151))
  call prop_A_Q(wf(:,150),Q(:,45),MT,1_intkind1,wf(:,152))
  call vert_AW_Q(wf(:,5),wf(:,7),wf(:,153))
  call prop_A_Q(wf(:,153),Q(:,45),MT,1_intkind1,wf(:,154))
  call counter_A_Q(ctbb,wf(:,5),Q(:,40),wf(:,155))
  call prop_Q_A(wf(:,6),Q(:,23),MB,1_intkind1,wf(:,156))
  call prop_Q_A(wf(:,8),Q(:,23),MB,1_intkind1,wf(:,157))
  call prop_Q_A(wf(:,151),Q(:,18),MT,1_intkind1,wf(:,158))
  call vert_VQ_A(wf(:,-5),wf(:,158),wf(:,159))
  call counter_A_Q(cttt,wf(:,11),Q(:,13),wf(:,160))
  call counter_A_Q(cttt,wf(:,13),Q(:,13),wf(:,161))
  call vert_SA_Q(gPbt,wf(:,1),wf(:,17),wf(:,162))
  call counter_Q_A(cttt,wf(:,16),Q(:,34),wf(:,163))
  call prop_A_Q(wf(:,162),Q(:,29),MT,1_intkind1,wf(:,164))
  call vert_AW_Q(wf(:,17),wf(:,7),wf(:,165))
  call prop_A_Q(wf(:,165),Q(:,29),MT,1_intkind1,wf(:,166))
  call counter_A_Q(ctbb,wf(:,17),Q(:,24),wf(:,167))
  call prop_Q_A(wf(:,18),Q(:,39),MB,1_intkind1,wf(:,168))
  call prop_Q_A(wf(:,19),Q(:,39),MB,1_intkind1,wf(:,169))
  call counter_Q_A(ctbb,wf(:,22),Q(:,7),wf(:,170))
  call counter_Q_A(ctbb,wf(:,24),Q(:,7),wf(:,171))
  call prop_A_Q(wf(:,167),Q(:,24),MB,1_intkind1,wf(:,172))
  call vert_AV_Q(wf(:,172),wf(:,-5),wf(:,173))
  call prop_Q_A(wf(:,163),Q(:,34),MT,1_intkind1,wf(:,174))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,174),wf(:,175))
  call vert_QA_W(wf(:,174),wf(:,-3),wf(:,176))
  call vert_QS_A(gH,wf(:,174),wf(:,-4),wf(:,177))
  call prop_A_Q(wf(:,155),Q(:,40),MB,1_intkind1,wf(:,178))
  call vert_AQ_S(gPbt,wf(:,178),wf(:,-1),wf(:,179))
  call vert_QA_W(wf(:,-1),wf(:,178),wf(:,180))
  call vert_SA_Q(gH,wf(:,-4),wf(:,178),wf(:,181))
  call counter_A_Q(ctqq,wf(:,37),Q(:,33),wf(:,182))
  call prop_A_Q(wf(:,182),Q(:,33),ZERO,0_intkind1,wf(:,183))
  call vert_AQ_S(gPud,wf(:,183),wf(:,-2),wf(:,184))
  call vert_QA_W(wf(:,-2),wf(:,183),wf(:,185))
  call counter_Q_A(ctqq,wf(:,46),Q(:,36),wf(:,186))
  call prop_Q_A(wf(:,186),Q(:,36),ZERO,0_intkind1,wf(:,187))
  call vert_AQ_S(gPud,wf(:,0),wf(:,187),wf(:,188))
  call vert_QA_W(wf(:,187),wf(:,0),wf(:,189))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,158),wf(:,190))
  call vert_QA_W(wf(:,158),wf(:,-3),wf(:,191))
  call vert_AQ_S(gPbt,wf(:,172),wf(:,-1),wf(:,192))
  call vert_QA_W(wf(:,-1),wf(:,172),wf(:,193))
  call vert_QA_V(wf(:,22),wf(:,-3),wf(:,194))
  call vert_QA_V(wf(:,24),wf(:,-3),wf(:,195))
  call vert_QS_A(gH,wf(:,22),wf(:,-4),wf(:,196))
  call prop_Q_A(wf(:,196),Q(:,23),MB,1_intkind1,wf(:,197))
  call vert_QS_A(gH,wf(:,24),wf(:,-4),wf(:,198))
  call prop_Q_A(wf(:,198),Q(:,23),MB,1_intkind1,wf(:,199))
  call vert_VQ_A(wf(:,-5),wf(:,22),wf(:,200))
  call prop_Q_A(wf(:,200),Q(:,39),MB,1_intkind1,wf(:,201))
  call vert_VQ_A(wf(:,-5),wf(:,24),wf(:,202))
  call prop_Q_A(wf(:,202),Q(:,39),MB,1_intkind1,wf(:,203))
  call vert_QA_V(wf(:,-1),wf(:,11),wf(:,204))
  call vert_QA_V(wf(:,-1),wf(:,13),wf(:,205))
  call vert_SA_Q(gH,wf(:,-4),wf(:,11),wf(:,206))
  call prop_A_Q(wf(:,206),Q(:,29),MT,1_intkind1,wf(:,207))
  call vert_SA_Q(gH,wf(:,-4),wf(:,13),wf(:,208))
  call prop_A_Q(wf(:,208),Q(:,29),MT,1_intkind1,wf(:,209))
  call vert_AV_Q(wf(:,11),wf(:,-5),wf(:,210))
  call prop_A_Q(wf(:,210),Q(:,45),MT,1_intkind1,wf(:,211))
  call vert_AV_Q(wf(:,13),wf(:,-5),wf(:,212))
  call prop_A_Q(wf(:,212),Q(:,45),MT,1_intkind1,wf(:,213))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,27),wf(:,214))
  call prop_Q_A(wf(:,214),Q(:,23),MB,1_intkind1,wf(:,215))
  call vert_WQ_A(wf(:,29),wf(:,-1),wf(:,216))
  call prop_Q_A(wf(:,216),Q(:,23),MB,1_intkind1,wf(:,217))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,30),wf(:,218))
  call prop_Q_A(wf(:,218),Q(:,23),MB,1_intkind1,wf(:,219))
  call vert_WQ_A(wf(:,31),wf(:,-1),wf(:,220))
  call prop_Q_A(wf(:,220),Q(:,23),MB,1_intkind1,wf(:,221))
  call vert_SA_Q(gPbt,wf(:,27),wf(:,-3),wf(:,222))
  call prop_A_Q(wf(:,222),Q(:,29),MT,1_intkind1,wf(:,223))
  call vert_AW_Q(wf(:,-3),wf(:,29),wf(:,224))
  call prop_A_Q(wf(:,224),Q(:,29),MT,1_intkind1,wf(:,225))
  call vert_SA_Q(gPbt,wf(:,30),wf(:,-3),wf(:,226))
  call prop_A_Q(wf(:,226),Q(:,29),MT,1_intkind1,wf(:,227))
  call vert_AW_Q(wf(:,-3),wf(:,31),wf(:,228))
  call prop_A_Q(wf(:,228),Q(:,29),MT,1_intkind1,wf(:,229))
  call vert_QA_V(wf(:,-2),wf(:,81),wf(:,230))
  call vert_QA_V(wf(:,-2),wf(:,83),wf(:,231))
  call prop_Q_A(wf(:,85),Q(:,14),ZERO,0_intkind1,wf(:,232))
  call vert_QA_V(wf(:,232),wf(:,0),wf(:,233))
  call prop_Q_A(wf(:,87),Q(:,14),ZERO,0_intkind1,wf(:,234))
  call vert_QA_V(wf(:,234),wf(:,0),wf(:,235))
  call vert_SA_Q(gPud,wf(:,39),wf(:,0),wf(:,236))
  call prop_A_Q(wf(:,236),Q(:,27),ZERO,0_intkind1,wf(:,237))
  call vert_SA_Q(gPud,wf(:,43),wf(:,0),wf(:,238))
  call prop_A_Q(wf(:,238),Q(:,27),ZERO,0_intkind1,wf(:,239))
  call vert_AW_Q(wf(:,0),wf(:,41),wf(:,240))
  call prop_A_Q(wf(:,240),Q(:,27),ZERO,0_intkind1,wf(:,241))
  call vert_AW_Q(wf(:,0),wf(:,44),wf(:,242))
  call prop_A_Q(wf(:,242),Q(:,27),ZERO,0_intkind1,wf(:,243))
  call vert_QS_A(gPud,wf(:,-2),wf(:,39),wf(:,244))
  call prop_Q_A(wf(:,244),Q(:,30),ZERO,0_intkind1,wf(:,245))
  call vert_WQ_A(wf(:,41),wf(:,-2),wf(:,246))
  call prop_Q_A(wf(:,246),Q(:,30),ZERO,0_intkind1,wf(:,247))
  call vert_QS_A(gPud,wf(:,-2),wf(:,43),wf(:,248))
  call prop_Q_A(wf(:,248),Q(:,30),ZERO,0_intkind1,wf(:,249))
  call vert_WQ_A(wf(:,44),wf(:,-2),wf(:,250))
  call prop_Q_A(wf(:,250),Q(:,30),ZERO,0_intkind1,wf(:,251))
  call vert_AQ_S(gPbt,wf(:,5),wf(:,4),wf(:,252))
  call vert_QA_W(wf(:,4),wf(:,5),wf(:,253))
  call vert_SA_Q(gPud,wf(:,49),wf(:,0),wf(:,254))
  call prop_A_Q(wf(:,254),Q(:,27),ZERO,0_intkind1,wf(:,255))
  call vert_AW_Q(wf(:,0),wf(:,50),wf(:,256))
  call prop_A_Q(wf(:,256),Q(:,27),ZERO,0_intkind1,wf(:,257))
  call vert_QS_A(gPud,wf(:,-2),wf(:,49),wf(:,258))
  call prop_Q_A(wf(:,258),Q(:,30),ZERO,0_intkind1,wf(:,259))
  call vert_WQ_A(wf(:,50),wf(:,-2),wf(:,260))
  call prop_Q_A(wf(:,260),Q(:,30),ZERO,0_intkind1,wf(:,261))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,66),wf(:,262))
  call vert_QA_W(wf(:,66),wf(:,-3),wf(:,263))
  call vert_AQ_S(gPbt,wf(:,17),wf(:,16),wf(:,264))
  call vert_QA_W(wf(:,16),wf(:,17),wf(:,265))
  call vert_SA_Q(gPud,wf(:,51),wf(:,0),wf(:,266))
  call prop_A_Q(wf(:,266),Q(:,27),ZERO,0_intkind1,wf(:,267))
  call vert_AW_Q(wf(:,0),wf(:,52),wf(:,268))
  call prop_A_Q(wf(:,268),Q(:,27),ZERO,0_intkind1,wf(:,269))
  call vert_QS_A(gPud,wf(:,-2),wf(:,51),wf(:,270))
  call prop_Q_A(wf(:,270),Q(:,30),ZERO,0_intkind1,wf(:,271))
  call vert_WQ_A(wf(:,52),wf(:,-2),wf(:,272))
  call prop_Q_A(wf(:,272),Q(:,30),ZERO,0_intkind1,wf(:,273))
  call vert_AQ_S(gPbt,wf(:,99),wf(:,-1),wf(:,274))
  call vert_QA_W(wf(:,-1),wf(:,99),wf(:,275))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,38),wf(:,276))
  call prop_Q_A(wf(:,276),Q(:,39),MB,1_intkind1,wf(:,277))
  call vert_WQ_A(wf(:,40),wf(:,-1),wf(:,278))
  call prop_Q_A(wf(:,278),Q(:,39),MB,1_intkind1,wf(:,279))
  call vert_SA_Q(gPbt,wf(:,38),wf(:,-3),wf(:,280))
  call prop_A_Q(wf(:,280),Q(:,45),MT,1_intkind1,wf(:,281))
  call vert_AW_Q(wf(:,-3),wf(:,40),wf(:,282))
  call prop_A_Q(wf(:,282),Q(:,45),MT,1_intkind1,wf(:,283))
  call vert_SS_S(wf(:,-4),wf(:,38),wf(:,284))
  call vert_ST_V(wf(:,38),Q(:,37),wf(:,-4),Q(:,16),wf(:,285))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,40),Q(:,37),wf(:,286))
  call vert_SV_V(wf(:,-4),wf(:,40),wf(:,287))
  call vert_SS_S(wf(:,-4),wf(:,26),wf(:,288))
  call vert_ST_V(wf(:,26),Q(:,42),wf(:,-4),Q(:,16),wf(:,289))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,28),Q(:,42),wf(:,290))
  call vert_SV_V(wf(:,-4),wf(:,28),wf(:,291))
  call vert_AQ_S(gPbt,wf(:,-3),wf(:,72),wf(:,292))
  call vert_QA_W(wf(:,72),wf(:,-3),wf(:,293))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,47),wf(:,294))
  call prop_Q_A(wf(:,294),Q(:,39),MB,1_intkind1,wf(:,295))
  call vert_WQ_A(wf(:,48),wf(:,-1),wf(:,296))
  call prop_Q_A(wf(:,296),Q(:,39),MB,1_intkind1,wf(:,297))
  call vert_SA_Q(gPbt,wf(:,47),wf(:,-3),wf(:,298))
  call prop_A_Q(wf(:,298),Q(:,45),MT,1_intkind1,wf(:,299))
  call vert_AW_Q(wf(:,-3),wf(:,48),wf(:,300))
  call prop_A_Q(wf(:,300),Q(:,45),MT,1_intkind1,wf(:,301))
  call vert_SS_S(wf(:,-4),wf(:,47),wf(:,302))
  call vert_ST_V(wf(:,47),Q(:,37),wf(:,-4),Q(:,16),wf(:,303))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,48),Q(:,37),wf(:,304))
  call vert_SV_V(wf(:,-4),wf(:,48),wf(:,305))
  call vert_SS_S(wf(:,-4),wf(:,33),wf(:,306))
  call vert_ST_V(wf(:,33),Q(:,42),wf(:,-4),Q(:,16),wf(:,307))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,34),Q(:,42),wf(:,308))
  call vert_SV_V(wf(:,-4),wf(:,34),wf(:,309))
  call vert_AQ_S(gPbt,wf(:,107),wf(:,-1),wf(:,310))
  call vert_QA_W(wf(:,-1),wf(:,107),wf(:,311))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5) - MW2)
  den(2) = 1 / (Q(5,18) - MT2)
  den(3) = 1 / (Q(5,40) - MB2)
  den(6) = 1 / (Q(5,13) - MT2)
  den(9) = 1 / (Q(5,34) - MT2)
  den(10) = 1 / (Q(5,24) - MB2)
  den(13) = 1 / (Q(5,7) - MB2)
  den(17) = 1 / (Q(5,42) - MW2)
  den(23) = 1 / (Q(5,33))
  den(24) = 1 / (Q(5,10) - MW2)
  den(25) = 1 / (Q(5,37) - MW2)
  den(28) = 1 / (Q(5,36))
  den(33) = 1 / (Q(5,26) - MW2)
  den(37) = 1 / (Q(5,48))
  den(39) = 1 / (Q(5,50) - MT2)
  den(44) = 1 / (Q(5,21) - MW2)
  den(49) = 1 / (Q(5,11))
  den(52) = 1 / (Q(5,49))
  den(59) = 1 / (Q(5,56) - MB2)
  den(70) = 1 / (Q(5,45) - MT2)
  den(73) = 1 / (Q(5,23) - MB2)
  den(80) = 1 / (Q(5,29) - MT2)
  den(83) = 1 / (Q(5,39) - MB2)
  den(109) = 1 / (Q(5,15))
  den(119) = 1 / (Q(5,14))
  den(122) = 1 / (Q(5,27))
  den(124) = 1 / (Q(5,30))
  den(127) = 1 / (Q(5,58) - MW2)
  den(139) = 1 / (Q(5,53) - MW2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(18) = den(9)*den(17)
  den(19) = den(1)*den(18)
  den(20) = den(3)*den(14)
  den(21) = den(3)*den(17)
  den(22) = den(1)*den(21)
  den(26) = den(23)*den(25)
  den(27) = den(24)*den(26)
  den(29) = den(25)*den(28)
  den(30) = den(24)*den(29)
  den(31) = den(2)*den(26)
  den(32) = den(2)*den(29)
  den(34) = den(10)*den(33)
  den(35) = den(23)*den(34)
  den(36) = den(10)*den(29)
  den(38) = den(14)*den(37)
  den(40) = den(37)*den(39)
  den(41) = den(1)*den(40)
  den(42) = den(2)*den(39)
  den(43) = den(1)*den(42)
  den(45) = den(1)*den(44)
  den(46) = den(9)*den(45)
  den(47) = den(9)*den(39)
  den(48) = den(1)*den(47)
  den(50) = den(24)*den(49)
  den(51) = den(37)*den(50)
  den(53) = den(37)*den(52)
  den(54) = den(24)*den(53)
  den(55) = den(24)*den(33)
  den(56) = den(23)*den(55)
  den(57) = den(2)*den(33)
  den(58) = den(23)*den(57)
  den(60) = den(10)*den(59)
  den(61) = den(1)*den(60)
  den(62) = den(3)*den(45)
  den(63) = den(3)*den(59)
  den(64) = den(1)*den(63)
  den(65) = den(10)*den(26)
  den(66) = den(28)*den(55)
  den(67) = den(28)*den(57)
  den(68) = den(28)*den(34)
  den(69) = den(1)*den(3)
  den(71) = den(69)*den(70)
  den(72) = den(2)*den(71)
  den(74) = den(4)*den(73)
  den(75) = den(3)*den(74)
  den(76) = den(2)**2
  den(77) = den(7)*den(76)
  den(78) = den(7)*den(42)
  den(79) = den(1)*den(10)
  den(81) = den(79)*den(80)
  den(82) = den(9)*den(81)
  den(84) = den(11)*den(83)
  den(85) = den(10)*den(84)
  den(86) = den(14)*den(60)
  den(87) = den(10)**2
  den(88) = den(14)*den(87)
  den(89) = den(9)**2
  den(90) = den(45)*den(89)
  den(91) = den(7)*den(89)
  den(92) = den(7)*den(47)
  den(93) = den(3)**2
  den(94) = den(45)*den(93)
  den(95) = den(14)*den(63)
  den(96) = den(14)*den(93)
  den(97) = den(23)**2
  den(98) = den(55)*den(97)
  den(99) = den(28)**2
  den(100) = den(55)*den(99)
  den(101) = den(57)*den(97)
  den(102) = den(26)*den(76)
  den(103) = den(57)*den(99)
  den(104) = den(29)*den(76)
  den(105) = den(34)*den(97)
  den(106) = den(26)*den(87)
  den(107) = den(34)*den(99)
  den(108) = den(29)*den(87)
  den(110) = den(14)*den(109)
  den(111) = den(14)*den(73)
  den(112) = den(14)*den(83)
  den(113) = den(7)*den(109)
  den(114) = den(7)*den(80)
  den(115) = den(7)*den(70)
  den(116) = den(45)*den(73)
  den(117) = den(45)*den(80)
  den(118) = den(50)*den(109)
  den(120) = den(24)*den(119)
  den(121) = den(109)*den(120)
  den(123) = den(55)*den(122)
  den(125) = den(55)*den(124)
  den(126) = den(2)*den(3)
  den(128) = den(126)*den(127)
  den(129) = den(57)*den(122)
  den(130) = den(57)*den(124)
  den(131) = den(42)*den(127)
  den(132) = den(9)*den(10)
  den(133) = den(127)*den(132)
  den(134) = den(34)*den(122)
  den(135) = den(34)*den(124)
  den(136) = den(60)*den(127)
  den(137) = den(26)*den(83)
  den(138) = den(26)*den(70)
  den(140) = den(26)*den(139)
  den(141) = den(18)*den(127)
  den(142) = den(47)*den(127)
  den(143) = den(29)*den(83)
  den(144) = den(29)*den(70)
  den(145) = den(29)*den(139)
  den(146) = den(21)*den(127)
  den(147) = den(63)*den(127)
  den(148) = den(1)*den(2)*den(3)
  den(149) = den(1)*den(9)*den(10)
  den(150) = den(2)*den(23)
  den(151) = den(2)*den(28)
  den(152) = den(10)*den(23)
  den(153) = den(10)*den(28)
  den(154) = den(2)*den(115)
  den(155) = den(10)*den(112)
  den(156) = den(9)*den(114)
  den(157) = den(9)*den(117)
  den(158) = den(3)*den(111)
  den(159) = den(3)*den(116)
  den(160) = den(23)*den(125)
  den(161) = den(28)*den(123)
  den(162) = den(2)*den(138)
  den(163) = den(23)*den(130)
  den(164) = den(2)*den(144)
  den(165) = den(28)*den(129)
  den(166) = den(10)*den(137)
  den(167) = den(23)*den(135)
  den(168) = den(10)*den(143)
  den(169) = den(28)*den(134)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(228)

  A(1) = cont_QA(wf(:,5),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,5),wf(:,8)) * den(5)
  A(3) = cont_QA(wf(:,10),wf(:,11)) * den(8)
  A(4) = cont_QA(wf(:,10),wf(:,13)) * den(8)
  A(5) = cont_QA(wf(:,17),wf(:,18)) * den(12)
  A(6) = cont_QA(wf(:,17),wf(:,19)) * den(12)
  A(7) = cont_QA(wf(:,21),wf(:,22)) * den(15)
  A(8) = cont_QA(wf(:,21),wf(:,24)) * den(15)
  A(9) = cont_QA(wf(:,11),wf(:,25)) * den(16)
  A(10) = cont_QA(wf(:,13),wf(:,25)) * den(16)
  A(11) = cont_SS(wf(:,26),wf(:,27)) * den(19)
  A(12) = cont_VV(wf(:,28),wf(:,29)) * den(19)
  A(13) = cont_SS(wf(:,26),wf(:,30)) * den(19)
  A(14) = cont_VV(wf(:,28),wf(:,31)) * den(19)
  A(15) = cont_QA(wf(:,22),wf(:,32)) * den(20)
  A(16) = cont_QA(wf(:,24),wf(:,32)) * den(20)
  A(17) = cont_SS(wf(:,27),wf(:,33)) * den(22)
  A(18) = cont_VV(wf(:,29),wf(:,34)) * den(22)
  A(19) = cont_SS(wf(:,30),wf(:,33)) * den(22)
  A(20) = cont_VV(wf(:,31),wf(:,34)) * den(22)
  A(21) = cont_SS(wf(:,38),wf(:,39)) * den(27)
  A(22) = cont_VV(wf(:,40),wf(:,41)) * den(27)
  A(23) = cont_SS(wf(:,38),wf(:,43)) * den(27)
  A(24) = cont_VV(wf(:,40),wf(:,44)) * den(27)
  A(25) = cont_SS(wf(:,39),wf(:,47)) * den(30)
  A(26) = cont_SS(wf(:,43),wf(:,47)) * den(30)
  A(27) = cont_VV(wf(:,41),wf(:,48)) * den(30)
  A(28) = cont_VV(wf(:,44),wf(:,48)) * den(30)
  A(29) = cont_SS(wf(:,38),wf(:,49)) * den(31)
  A(30) = cont_VV(wf(:,40),wf(:,50)) * den(31)
  A(31) = cont_SS(wf(:,47),wf(:,49)) * den(32)
  A(32) = cont_VV(wf(:,48),wf(:,50)) * den(32)
  A(33) = cont_SS(wf(:,38),wf(:,51)) * den(35)
  A(34) = cont_VV(wf(:,40),wf(:,52)) * den(35)
  A(35) = cont_SS(wf(:,47),wf(:,51)) * den(36)
  A(36) = cont_VV(wf(:,48),wf(:,52)) * den(36)

  A(37) = cont_QA(wf(:,5),wf(:,53)) * den(5)
  A(38) = cont_QA(wf(:,5),wf(:,54)) * den(5)
  A(39) = cont_QA(wf(:,11),wf(:,55)) * den(8)
  A(40) = cont_QA(wf(:,13),wf(:,55)) * den(8)
  A(41) = cont_QA(wf(:,17),wf(:,56)) * den(12)
  A(42) = cont_QA(wf(:,17),wf(:,57)) * den(12)
  A(43) = cont_QA(wf(:,22),wf(:,58)) * den(15)
  A(44) = cont_QA(wf(:,24),wf(:,58)) * den(15)
  A(45) = cont_QA(wf(:,11),wf(:,59)) * den(16)
  A(46) = cont_QA(wf(:,13),wf(:,59)) * den(16)
  A(47) = cont_QA(wf(:,22),wf(:,60)) * den(20)
  A(48) = cont_QA(wf(:,24),wf(:,60)) * den(20)
  A(49) = cont_QA(wf(:,22),wf(:,62)) * den(38)
  A(50) = cont_QA(wf(:,24),wf(:,62)) * den(38)
  A(51) = cont_QA(wf(:,9),wf(:,64)) * den(41)
  A(52) = cont_QA(wf(:,12),wf(:,64)) * den(41)
  A(53) = cont_QA(wf(:,65),wf(:,66)) * den(43)
  A(54) = cont_QA(wf(:,66),wf(:,67)) * den(43)
  A(55) = cont_QA(wf(:,6),wf(:,69)) * den(5)
  A(56) = cont_QA(wf(:,8),wf(:,69)) * den(5)
  A(57) = cont_SS(wf(:,27),wf(:,70)) * den(46)
  A(58) = cont_VV(wf(:,29),wf(:,71)) * den(46)
  A(59) = cont_SS(wf(:,30),wf(:,70)) * den(46)
  A(60) = cont_VV(wf(:,31),wf(:,71)) * den(46)
  A(61) = cont_QA(wf(:,65),wf(:,72)) * den(48)
  A(62) = cont_QA(wf(:,67),wf(:,72)) * den(48)
  A(63) = cont_QA(wf(:,22),wf(:,73)) * den(20)
  A(64) = cont_QA(wf(:,24),wf(:,73)) * den(20)
  A(65) = cont_SS(wf(:,27),wf(:,74)) * den(22)
  A(66) = cont_VV(wf(:,29),wf(:,75)) * den(22)
  A(67) = cont_SS(wf(:,30),wf(:,74)) * den(22)
  A(68) = cont_VV(wf(:,31),wf(:,75)) * den(22)
  A(69) = cont_QA(wf(:,18),wf(:,77)) * den(12)
  A(70) = cont_QA(wf(:,19),wf(:,77)) * den(12)
  A(71) = cont_QA(wf(:,22),wf(:,78)) * den(15)
  A(72) = cont_QA(wf(:,24),wf(:,78)) * den(15)
  A(73) = cont_QA(wf(:,80),wf(:,81)) * den(51)
  A(74) = cont_QA(wf(:,80),wf(:,83)) * den(51)
  A(75) = cont_QA(wf(:,85),wf(:,86)) * den(54)
  A(76) = cont_QA(wf(:,86),wf(:,87)) * den(54)
  A(77) = cont_SS(wf(:,38),wf(:,88)) * den(31)
  A(78) = cont_VV(wf(:,40),wf(:,89)) * den(31)
  A(79) = cont_SS(wf(:,47),wf(:,88)) * den(32)
  A(80) = cont_VV(wf(:,48),wf(:,89)) * den(32)
  A(81) = cont_SS(wf(:,38),wf(:,90)) * den(35)
  A(82) = cont_VV(wf(:,40),wf(:,91)) * den(35)
  A(83) = cont_SS(wf(:,47),wf(:,90)) * den(36)
  A(84) = cont_VV(wf(:,48),wf(:,91)) * den(36)
  A(85) = cont_SS(wf(:,39),wf(:,92)) * den(56)
  A(86) = cont_VV(wf(:,41),wf(:,93)) * den(56)
  A(87) = cont_SS(wf(:,43),wf(:,92)) * den(56)
  A(88) = cont_VV(wf(:,44),wf(:,93)) * den(56)
  A(89) = cont_SS(wf(:,39),wf(:,96)) * den(30)
  A(90) = cont_SS(wf(:,43),wf(:,96)) * den(30)
  A(91) = cont_VV(wf(:,41),wf(:,97)) * den(30)
  A(92) = cont_VV(wf(:,44),wf(:,97)) * den(30)
  A(93) = cont_SS(wf(:,49),wf(:,92)) * den(58)
  A(94) = cont_VV(wf(:,50),wf(:,93)) * den(58)
  A(95) = cont_SS(wf(:,49),wf(:,96)) * den(32)
  A(96) = cont_VV(wf(:,50),wf(:,97)) * den(32)
  A(97) = cont_SS(wf(:,51),wf(:,92)) * den(35)
  A(98) = cont_VV(wf(:,52),wf(:,93)) * den(35)
  A(99) = cont_SS(wf(:,51),wf(:,96)) * den(36)
  A(100) = cont_VV(wf(:,52),wf(:,97)) * den(36)
  A(101) = cont_QA(wf(:,98),wf(:,99)) * den(61)
  A(102) = cont_QA(wf(:,99),wf(:,100)) * den(61)
  A(103) = cont_QA(wf(:,17),wf(:,103)) * den(12)
  A(104) = cont_QA(wf(:,17),wf(:,104)) * den(12)
  A(105) = cont_SS(wf(:,27),wf(:,105)) * den(62)
  A(106) = cont_VV(wf(:,29),wf(:,106)) * den(62)
  A(107) = cont_SS(wf(:,30),wf(:,105)) * den(62)
  A(108) = cont_VV(wf(:,31),wf(:,106)) * den(62)
  A(109) = cont_QA(wf(:,98),wf(:,107)) * den(64)
  A(110) = cont_QA(wf(:,100),wf(:,107)) * den(64)
  A(111) = cont_QA(wf(:,11),wf(:,108)) * den(16)
  A(112) = cont_QA(wf(:,13),wf(:,108)) * den(16)
  A(113) = cont_SS(wf(:,27),wf(:,109)) * den(19)
  A(114) = cont_VV(wf(:,29),wf(:,110)) * den(19)
  A(115) = cont_SS(wf(:,30),wf(:,109)) * den(19)
  A(116) = cont_VV(wf(:,31),wf(:,110)) * den(19)
  A(117) = cont_QA(wf(:,5),wf(:,113)) * den(5)
  A(118) = cont_QA(wf(:,5),wf(:,114)) * den(5)
  A(119) = cont_QA(wf(:,11),wf(:,115)) * den(8)
  A(120) = cont_QA(wf(:,13),wf(:,115)) * den(8)
  A(121) = cont_SS(wf(:,38),wf(:,116)) * den(65)
  A(122) = cont_VV(wf(:,40),wf(:,117)) * den(65)
  A(123) = cont_SS(wf(:,47),wf(:,116)) * den(36)
  A(124) = cont_VV(wf(:,48),wf(:,117)) * den(36)
  A(125) = cont_SS(wf(:,38),wf(:,118)) * den(31)
  A(126) = cont_VV(wf(:,40),wf(:,119)) * den(31)
  A(127) = cont_SS(wf(:,47),wf(:,118)) * den(32)
  A(128) = cont_VV(wf(:,48),wf(:,119)) * den(32)
  A(129) = cont_SS(wf(:,38),wf(:,121)) * den(27)
  A(130) = cont_VV(wf(:,40),wf(:,122)) * den(27)
  A(131) = cont_SS(wf(:,38),wf(:,124)) * den(27)
  A(132) = cont_VV(wf(:,40),wf(:,125)) * den(27)
  A(133) = cont_SS(wf(:,47),wf(:,121)) * den(30)
  A(134) = cont_SS(wf(:,47),wf(:,124)) * den(30)
  A(135) = cont_VV(wf(:,48),wf(:,122)) * den(30)
  A(136) = cont_VV(wf(:,48),wf(:,125)) * den(30)
  A(137) = cont_SS(wf(:,39),wf(:,126)) * den(66)
  A(138) = cont_SS(wf(:,43),wf(:,126)) * den(66)
  A(139) = cont_VV(wf(:,41),wf(:,127)) * den(66)
  A(140) = cont_VV(wf(:,44),wf(:,127)) * den(66)
  A(141) = cont_SS(wf(:,39),wf(:,130)) * den(27)
  A(142) = cont_VV(wf(:,41),wf(:,131)) * den(27)
  A(143) = cont_SS(wf(:,43),wf(:,130)) * den(27)
  A(144) = cont_VV(wf(:,44),wf(:,131)) * den(27)
  A(145) = cont_SS(wf(:,49),wf(:,126)) * den(67)
  A(146) = cont_VV(wf(:,50),wf(:,127)) * den(67)
  A(147) = cont_SS(wf(:,49),wf(:,130)) * den(31)
  A(148) = cont_VV(wf(:,50),wf(:,131)) * den(31)
  A(149) = cont_SS(wf(:,51),wf(:,126)) * den(68)
  A(150) = cont_VV(wf(:,52),wf(:,127)) * den(68)
  A(151) = cont_SS(wf(:,51),wf(:,130)) * den(35)
  A(152) = cont_VV(wf(:,52),wf(:,131)) * den(35)
  A(153) = cont_QA(wf(:,5),wf(:,133)) * den(5)
  A(154) = cont_QA(wf(:,5),wf(:,135)) * den(5)
  A(155) = cont_QA(wf(:,10),wf(:,137)) * den(8)
  A(156) = cont_QA(wf(:,10),wf(:,139)) * den(8)
  A(157) = cont_QA(wf(:,17),wf(:,140)) * den(12)
  A(158) = cont_QA(wf(:,17),wf(:,141)) * den(12)
  A(159) = cont_QA(wf(:,21),wf(:,143)) * den(15)
  A(160) = cont_QA(wf(:,21),wf(:,145)) * den(15)
  A(161) = cont_QA(wf(:,25),wf(:,137)) * den(16)
  A(162) = cont_QA(wf(:,25),wf(:,139)) * den(16)
  A(163) = cont_SS(wf(:,26),wf(:,146)) * den(19)
  A(164) = cont_VV(wf(:,28),wf(:,147)) * den(19)
  A(165) = cont_SS(wf(:,26),wf(:,148)) * den(19)
  A(166) = cont_VV(wf(:,28),wf(:,149)) * den(19)
  A(167) = cont_QA(wf(:,32),wf(:,143)) * den(20)
  A(168) = cont_QA(wf(:,32),wf(:,145)) * den(20)
  A(169) = cont_SS(wf(:,33),wf(:,146)) * den(22)
  A(170) = cont_VV(wf(:,34),wf(:,147)) * den(22)
  A(171) = cont_SS(wf(:,33),wf(:,148)) * den(22)
  A(172) = cont_VV(wf(:,34),wf(:,149)) * den(22)
  A(173) = cont_QA(wf(:,151),wf(:,152)) * den(72)
  A(174) = cont_QA(wf(:,151),wf(:,154)) * den(72)
  A(175) = cont_QA(wf(:,155),wf(:,156)) * den(75)
  A(176) = cont_QA(wf(:,155),wf(:,157)) * den(75)
  A(177) = cont_QA(wf(:,11),wf(:,159)) * den(77)
  A(178) = cont_QA(wf(:,13),wf(:,159)) * den(77)
  A(179) = cont_QA(wf(:,66),wf(:,160)) * den(78)
  A(180) = cont_QA(wf(:,66),wf(:,161)) * den(78)
  A(181) = cont_QA(wf(:,163),wf(:,164)) * den(82)
  A(182) = cont_QA(wf(:,163),wf(:,166)) * den(82)
  A(183) = cont_QA(wf(:,167),wf(:,168)) * den(85)
  A(184) = cont_QA(wf(:,167),wf(:,169)) * den(85)
  A(185) = cont_QA(wf(:,99),wf(:,170)) * den(86)
  A(186) = cont_QA(wf(:,99),wf(:,171)) * den(86)
  A(187) = cont_QA(wf(:,22),wf(:,173)) * den(88)
  A(188) = cont_QA(wf(:,24),wf(:,173)) * den(88)
  A(189) = cont_SS(wf(:,27),wf(:,175)) * den(90)
  A(190) = cont_VV(wf(:,29),wf(:,176)) * den(90)
  A(191) = cont_SS(wf(:,30),wf(:,175)) * den(90)
  A(192) = cont_VV(wf(:,31),wf(:,176)) * den(90)
  A(193) = cont_QA(wf(:,11),wf(:,177)) * den(91)
  A(194) = cont_QA(wf(:,13),wf(:,177)) * den(91)
  A(195) = cont_QA(wf(:,72),wf(:,160)) * den(92)
  A(196) = cont_QA(wf(:,72),wf(:,161)) * den(92)
  A(197) = cont_SS(wf(:,27),wf(:,179)) * den(94)
  A(198) = cont_VV(wf(:,29),wf(:,180)) * den(94)
  A(199) = cont_SS(wf(:,30),wf(:,179)) * den(94)
  A(200) = cont_VV(wf(:,31),wf(:,180)) * den(94)
  A(201) = cont_QA(wf(:,107),wf(:,170)) * den(95)
  A(202) = cont_QA(wf(:,107),wf(:,171)) * den(95)
  A(203) = cont_QA(wf(:,22),wf(:,181)) * den(96)
  A(204) = cont_QA(wf(:,24),wf(:,181)) * den(96)
  A(205) = cont_SS(wf(:,39),wf(:,184)) * den(98)
  A(206) = cont_VV(wf(:,41),wf(:,185)) * den(98)
  A(207) = cont_SS(wf(:,43),wf(:,184)) * den(98)
  A(208) = cont_VV(wf(:,44),wf(:,185)) * den(98)
  A(209) = cont_SS(wf(:,39),wf(:,188)) * den(100)
  A(210) = cont_SS(wf(:,43),wf(:,188)) * den(100)
  A(211) = cont_VV(wf(:,41),wf(:,189)) * den(100)
  A(212) = cont_VV(wf(:,44),wf(:,189)) * den(100)
  A(213) = cont_SS(wf(:,49),wf(:,184)) * den(101)
  A(214) = cont_VV(wf(:,50),wf(:,185)) * den(101)
  A(215) = cont_SS(wf(:,38),wf(:,190)) * den(102)
  A(216) = cont_VV(wf(:,40),wf(:,191)) * den(102)
  A(217) = cont_SS(wf(:,49),wf(:,188)) * den(103)
  A(218) = cont_VV(wf(:,50),wf(:,189)) * den(103)
  A(219) = cont_SS(wf(:,47),wf(:,190)) * den(104)
  A(220) = cont_VV(wf(:,48),wf(:,191)) * den(104)
  A(221) = cont_SS(wf(:,51),wf(:,184)) * den(105)
  A(222) = cont_VV(wf(:,52),wf(:,185)) * den(105)
  A(223) = cont_SS(wf(:,38),wf(:,192)) * den(106)
  A(224) = cont_VV(wf(:,40),wf(:,193)) * den(106)
  A(225) = cont_SS(wf(:,51),wf(:,188)) * den(107)
  A(226) = cont_VV(wf(:,52),wf(:,189)) * den(107)
  A(227) = cont_SS(wf(:,47),wf(:,192)) * den(108)
  A(228) = cont_VV(wf(:,48),wf(:,193)) * den(108)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(228)
  complex(REALKIND), intent(out) :: M1(2), M2(2)

  M1(1) = (A(33)+A(35))*f(1)+(A(21)+A(25))*f(8)+(A(29)+A(31))*f(14)+(A(22)+A(23)+A(26)+A(27))*f(21)+(A(34)+A(36))*f(29)+(A(30) &
       +A(32))*f(37)+(A(24)+A(28))*f(45)
  M1(2) = (A(5)+A(7)+A(15))*f(1)+(A(11)+A(17))*f(8)+(A(1)+A(3)+A(9))*f(14)+(A(12)+A(13)+A(18)+A(19))*f(21)+(A(6)+A(8)+A(16))*f(29) &
       +(A(2)+A(4)+A(10))*f(37)+(A(14)+A(20))*f(45)

  M2(1) = (A(121)+A(123)-A(221)-A(223)-A(225)-A(227))*f(2)+(A(99)+A(151))*f(4)+(A(81)+A(83))*f(6)+(A(97)+A(149))*f(7)+(A(129) &
       +A(133)-A(205)-A(209))*f(9)+(A(89)+A(141))*f(11)+(A(85)+A(137))*f(13)+(A(77)+A(79)-A(213)-A(215)-A(217)-A(219))*f(15) &
       +(A(95)+A(147))*f(17)+(A(93)+A(145))*f(19)+(A(125)+A(127))*f(20)+(A(130)+A(135)-A(206)-A(207)-A(210)-A(211))*f(22)+(A(90) &
       +A(91)+A(142)+A(143))*f(24)+(A(87)+A(138))*f(26)+(A(131)+A(134))*f(27)+(A(86)+A(139))*f(28)+(-A(222)-A(224)-A(226) &
       -A(228))*f(30)+(A(100)+A(152))*f(32)+(A(82)+A(84))*f(34)+(A(122)+A(124))*f(35)+(A(98)+A(150))*f(36)+(-A(214)-A(216)-A(218) &
       -A(220))*f(38)+(A(96)+A(148))*f(40)+(A(126)+A(128))*f(42)+(A(78)+A(80))*f(43)+(A(94)+A(146))*f(44)+(-A(208)-A(212))*f(46) &
       +(A(92)+A(144))*f(48)+(A(132)+A(136))*f(50)+(A(88)+A(140))*f(51)+(A(74)+A(76))*f(52)+(A(73)+A(75))*f(53)
  M2(2) = (A(41)+A(101)+A(109)-A(181)-A(183)-A(185)-A(187)-A(201)-A(203))*f(2)+(A(43)+A(63))*f(3)+A(103)*f(5)+(A(47)+A(69) &
       +A(71))*f(6)+(A(157)+A(159)+A(167))*f(7)+(A(57)+A(105)-A(189)-A(197))*f(9)+A(65)*f(10)+A(113)*f(12)+(A(163)+A(169))*f(13) &
       +(A(37)+A(53)+A(61)-A(173)-A(175)-A(177)-A(179)-A(193)-A(195))*f(15)+A(55)*f(16)+(A(39)+A(111))*f(18)+(A(153)+A(155) &
       +A(161))*f(19)+(A(45)+A(117)+A(119))*f(20)+(A(59)+A(107)-A(190)-A(191)-A(198)-A(199))*f(22)+(A(66)+A(67))*f(23)+(A(114) &
       +A(115))*f(25)+(A(164)+A(170))*f(26)+(A(58)+A(106))*f(27)+(A(165)+A(171))*f(28)+(-A(182)-A(184)-A(186)-A(188)-A(202) &
       -A(204))*f(30)+(A(44)+A(64))*f(31)+A(104)*f(33)+(A(48)+A(70)+A(72))*f(34)+(A(42)+A(102)+A(110))*f(35)+(A(158)+A(160) &
       +A(168))*f(36)+(-A(174)-A(176)-A(178)-A(180)-A(194)-A(196))*f(38)+A(56)*f(39)+(A(40)+A(112))*f(41)+(A(46)+A(118) &
       +A(120))*f(42)+(A(38)+A(54)+A(62))*f(43)+(A(154)+A(156)+A(162))*f(44)+(-A(192)-A(200))*f(46)+A(68)*f(47)+A(116)*f(49) &
       +(A(60)+A(108))*f(50)+(A(166)+A(172))*f(51)+(A(50)+A(52))*f(52)+(A(49)+A(51))*f(53)

end subroutine colourvectors

end module ol_loop_ppthjj_uxtdbxhg_1_/**/REALKIND
