
! What is Hel(32) in AMP2_... good for? It is set by helsync and not used again.

module ol_factors_decl_pplnj_neexuxdg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(1)
  contains
  subroutine factors_init
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
    use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
    implicit none
    if (parameters_status == 0) call parameters_init()
    if (loop_parameters_status == 0) call loop_parameters_init()
    factors_status = parameters_status
    ! factors of the diagrams
    f(1) = (CI*eQED**2*gQCD)/(2._/**/REALKIND*sw**2)

  end subroutine factors_init
end module ol_factors_decl_pplnj_neexuxdg_1_/**/REALKIND



module ol_born_denominators_pplnj_neexuxdg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  complex(REALKIND), save :: den(5)
  contains
  subroutine born_denominators_init()
    implicit none

    ! propagators

    den(1) = 1 / (Q(5,3) - MW2)
    den(2) = 1 / (Q(5,20))
    den(4) = 1 / (Q(5,24))

    ! denominators

    den(3) = den(1)*den(2)
    den(5) = den(1)*den(4)

  end subroutine born_denominators_init
end module ol_born_denominators_pplnj_neexuxdg_1_/**/REALKIND



module ol_tree_pplnj_neexuxdg_1_/**/REALKIND

contains

! **********************************************************************
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs)
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e e+ anti-up down glue -> 0
! I   = emitter, 0._/**/REALKIND means none (replace wave function I in the current crossing by the momentum MOM)
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_permutations_pplnj_neexuxdg_1, only: external_perm_pplnj_neexuxdg_1, &
    & external_perm_inv_pplnj_neexuxdg_1, extcomb_perm_pplnj_neexuxdg_1, &
    & average_factor_pplnj_neexuxdg_1
  use ol_hel_decl_pplnj_neexuxdg_1, only: H, hel_not_initialised, hel_init
  use ol_colourmatrix_pplnj_neexuxdg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_factors_decl_pplnj_neexuxdg_1_/**/REALKIND, only: factors_status, factors_init, f
  use ol_forced_parameters_pplnj_neexuxdg_1_/**/REALKIND, only: check_forced_parameters
  use ol_born_denominators_pplnj_neexuxdg_1_/**/REALKIND, only: born_denominators_init, den
  use ol_heltables_pplnj_neexuxdg_1
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2(0:17-1)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, extcombs_permuted(nextcombs), shift, k, r
  real(REALKIND)    :: P(0:3,5)
  real(REALKIND)    :: extmasses2(5)
  real(REALKIND)    :: M2add(0:17-1)
  complex(REALKIND) :: MOM_LC(4), M1(1), M1helarray(1,32)

  integer(intkind1), save :: ntry = 1
  integer(intkind1)       :: nsync
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
  real(REALKIND),    save :: scalebackfactor, old_scalefactor = 0

  type(wfun) :: & ! ex1(nhel1), ...
    ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! Declarations of wave functions for all possible helicity configurations from which they are built.
  ! type(wfun), dimension(nhel) :: wf1, ...

  type(wfun), dimension(4) :: &
    wf1, wf2, wf3, wf4, wf6, wf7

  type(wfun), dimension(8) :: &
    wf5, wf8

  type(wfun), dimension(32) :: &
    wf9, wf10


  type(polcont) :: A(32,2)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call ensure_mp_init()

  if (hel_not_initialised) call hel_init
  if (colmat_not_initialised) call colourmatrix_init
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters
    call factors_init
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rZERO2, rZERO2, rZERO2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, external_perm_inv_pplnj_neexuxdg_1,5)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,5)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  if (I > 0) ReplacePol = external_perm_pplnj_neexuxdg_1(I)

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pplnj_neexuxdg_1(extcombs(k))
  end do

  if (heltables_not_init_pplnj_neexuxdg_1) call init_heltables

  ! external WFs
  call wf_Q(P(:,1), rZERO, H1, ex1)
  call wf_A(P(:,2), rZERO, H2, ex2)
  call wf_A(P(:,3), rZERO, H3, ex3)
  call wf_Q(P(:,4), rZERO, H4, ex4)
  call wf_V(P(:,5), rZERO, H5, ex5)


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_wf(H1, ex1, shift) ...
  call helbookkeeping_wf(H1, ex1, shift)
  call helbookkeeping_wf(H2, ex2, shift)
  call helbookkeeping_wf(H3, ex3, shift)
  call helbookkeeping_wf(H4, ex4, shift)
  call helbookkeeping_wf(H5, ex5, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1, ex2, wf1, n1, t1)
  call vert_AV_Q(ntry, ex3, ex5, wf2, n2, t2)
  call prop_W_W(ntry, wf1, Q(:,3), MW, 1_intkind1, wf3, n3)
  call prop_A_Q(ntry, wf2, Q(:,20), ZERO, 0_intkind1, wf4, n4)
  call vert_WQ_A(ntry, wf3, ex4, wf5, n5, t5)
  call vert_VQ_A(ntry, ex5, ex4, wf6, n6, t6)
  call prop_Q_A(ntry, wf6, Q(:,24), ZERO, 0_intkind1, wf7, n7)
  call vert_AW_Q(ntry, ex3, wf3, wf8, n8, t8)


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later

    ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf4, wf5, A(:,1), n9, t9, nhel, den(3))
    call cont_QA(nsync, wf7, wf8, A(:,2), n10, t10, nhel, den(5))


    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if

  end do

  M2 = 0
  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do

  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it doesn't vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint(M1, M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.25_/**/REALKIND * M2

  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_pplnj_neexuxdg_1

  do k = 0, 17-1
    M2(k) = M2add(extcomb_perm_pplnj_neexuxdg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*5-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont),     intent(in)  :: A(32,2)
  integer,           intent(in)  :: j
  complex(REALKIND), intent(out) :: M1(1) ! M1helarray(1,32)

  M1(1) = (-A(j,1)%j-A(j,2)%j)*f(1)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, nextcombs, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_colourmatrix_pplnj_neexuxdg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint(0:17-1)
  integer,           intent(in)  :: nextcombs
  integer,           intent(in)  :: extcombs(nextcombs)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, nextcombs
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint

end subroutine amp2



! =================================================== !
! Only interfaces for easier usage of AMP2_[procname] !
! =================================================== !

subroutine amp2tree(P, M2)
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:17-1)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ])
  M2 = M2tmp(0)
end subroutine amp2tree



subroutine amp2ccone(P, M2, I, J)
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:17-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2ccone



subroutine amp2ccall(P, M2)
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2(0:17-1)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    17, [ (k, k = 0, 17-1) ])
end subroutine amp2ccall



subroutine amp2hcone(P, M2, I, J, MOM)
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:17-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2hcone



subroutine amp2hcall(P, M2, I, MOM)
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(REALKIND),  intent(out) :: M2(5)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:17-1)
  integer        :: J, extcombs(5)
  do J = 1, 5
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 5, extcombs)
  do J = 1, 5
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall

end module ol_tree_pplnj_neexuxdg_1_/**/REALKIND



! Top-level interfaces

#ifdef PRECISION_dp

subroutine ol_amp2tree_pplnj_neexuxdg_1(P, M2)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2
  call amp2tree(P, M2)
end subroutine ol_amp2tree_pplnj_neexuxdg_1



subroutine ol_amp2ccone_pplnj_neexuxdg_1(P, M2, I, J)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2ccone
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2
  integer,         intent(in)  :: I, J
  call amp2ccone(P, M2, I, J)
end subroutine ol_amp2ccone_pplnj_neexuxdg_1



subroutine ol_amp2ccall_pplnj_neexuxdg_1(P, M2)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2ccall
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2(0:17-1)
  call amp2ccall(P, M2)
end subroutine ol_amp2ccall_pplnj_neexuxdg_1



subroutine ol_amp2hcone_pplnj_neexuxdg_1(P, M2, I, J, MOM)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2hcone
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(DREALKIND), intent(in)  :: MOM(0:3)
  call amp2hcone(P, M2, I, J, MOM)
end subroutine ol_amp2hcone_pplnj_neexuxdg_1



subroutine ol_amp2hcall_pplnj_neexuxdg_1(P, M2, I, MOM)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2hcall
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2(5)
  integer,         intent(in)  :: I
  real(DREALKIND), intent(in)  :: MOM(0:3)
  call amp2hcall(P, M2, I, MOM)
end subroutine ol_amp2hcall_pplnj_neexuxdg_1



! Only for compatibility with the old interface

subroutine amp2tree_pplnj_neexuxdg_1(P, M2)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2
  call amp2tree(P, M2)
end subroutine amp2tree_pplnj_neexuxdg_1



subroutine amp2ccone_pplnj_neexuxdg_1(P, M2, I, J)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2ccone
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2
  integer,         intent(in)  :: I, J
  call amp2ccone(P, M2, I, J)
end subroutine amp2ccone_pplnj_neexuxdg_1



subroutine amp2ccall_pplnj_neexuxdg_1(P, M2)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2ccall
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2(0:17-1)
  call amp2ccall(P, M2)
end subroutine amp2ccall_pplnj_neexuxdg_1



subroutine amp2hcone_pplnj_neexuxdg_1(P, M2, I, J, MOM)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2hcone
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(DREALKIND), intent(in)  :: MOM(0:3)
  call amp2hcone(P, M2, I, J, MOM)
end subroutine amp2hcone_pplnj_neexuxdg_1



subroutine amp2hcall_pplnj_neexuxdg_1(P, M2, I, MOM)
  use KIND_TYPES, only: DREALKIND
  use ol_tree_pplnj_neexuxdg_1_/**/DREALKIND, only: amp2hcall
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,5)
  real(DREALKIND), intent(out) :: M2(5)
  integer,         intent(in)  :: I
  real(DREALKIND), intent(in)  :: MOM(0:3)
  call amp2hcall(P, M2, I, MOM)
end subroutine amp2hcall_pplnj_neexuxdg_1

#endif
