
module ol_vamp_5_ppllttj_eexttxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_5(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllttj_eexttxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllttj_eexttxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllttj_eexttxbbxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllttj_eexttxbbxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(4)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,39) :: G0
  complex(REALKIND), dimension(4,5,4,134) :: G1
  complex(REALKIND), dimension(15,111) :: G2tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,378),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,79),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,36),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,127),MT,G2tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,378),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,79),MB,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,36),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,127),MB,G2tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,379),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,79),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,36),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,127),ZERO,G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,379),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,79),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,36),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,127),MT,G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,379),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,79),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,36),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,127),MB,G2tensor(:,5))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,378),Q(:,79),G1(:,:,:,11))
  call check_last_CV_D(l_switch,G1(:,:,:,11),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,6))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,379),Q(:,79),G1(:,:,:,12))
  call check_last_CV_D(l_switch,G1(:,:,:,12),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,112),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,59),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,127),ZERO,G2tensor(:,8))
  call loop_QV_A(G1(:,:,:,13),wf(:,60),G1(:,:,:,15))
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,127),ZERO,G2tensor(:,9))
  call loop_QV_A(G1(:,:,:,13),wf(:,63),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,127),ZERO,G2tensor(:,10))
  call loop_QV_A(G1(:,:,:,13),wf(:,64),G1(:,:,:,17))
  call check_last_Q_A(l_switch,G1(:,:,:,17),Q(:,127),ZERO,G2tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,112),MT,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,59),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,127),MT,G2tensor(:,12))
  call loop_QV_A(G1(:,:,:,18),wf(:,60),G1(:,:,:,20))
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,127),MT,G2tensor(:,13))
  call loop_QV_A(G1(:,:,:,18),wf(:,63),G1(:,:,:,21))
  call check_last_Q_A(l_switch,G1(:,:,:,21),Q(:,127),MT,G2tensor(:,14))
  call loop_QV_A(G1(:,:,:,18),wf(:,64),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,127),MT,G2tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,112),MB,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,59),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,127),MB,G2tensor(:,16))
  call loop_QV_A(G1(:,:,:,23),wf(:,60),G1(:,:,:,25))
  call check_last_Q_A(l_switch,G1(:,:,:,25),Q(:,127),MB,G2tensor(:,17))
  call loop_QV_A(G1(:,:,:,23),wf(:,63),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,127),MB,G2tensor(:,18))
  call loop_QV_A(G1(:,:,:,23),wf(:,64),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,127),MB,G2tensor(:,19))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,58),Q(:,112),G1(:,:,:,28))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,112),wf(:,59),Q(:,15),G2tensor(:,20))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,112),wf(:,60),Q(:,15),G2tensor(:,21))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,112),wf(:,63),Q(:,15),G2tensor(:,22))
  call check_last_CV_D(l_switch,G1(:,:,:,28),Q(:,112),wf(:,64),Q(:,15),G2tensor(:,23))
  call loop_QV_A(G0(:,:,:,1),wf(:,380),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,79),ZERO,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,36),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,127),ZERO,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,380),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,79),MT,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,36),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,127),MT,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,380),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,79),MB,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,36),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,127),MB,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,381),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,79),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,36),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,127),ZERO,G2tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,381),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,79),MT,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,36),G1(:,:,:,38))
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,127),MT,G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,381),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,79),MB,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,36),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,127),MB,G2tensor(:,29))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,380),Q(:,79),G1(:,:,:,41))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,30))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,381),Q(:,79),G1(:,:,:,42))
  call check_last_CV_D(l_switch,G1(:,:,:,42),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,390),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,79),ZERO,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,36),G1(:,:,:,44))
  call check_last_Q_A(l_switch,G1(:,:,:,44),Q(:,127),ZERO,G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,390),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,79),MT,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,36),G1(:,:,:,46))
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,127),MT,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,390),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,79),MB,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,36),G1(:,:,:,48))
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,127),MB,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,391),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,79),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,36),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,127),ZERO,G2tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,391),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,79),MT,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,36),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,127),MT,G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,391),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,79),MB,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,36),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,127),MB,G2tensor(:,37))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,390),Q(:,79),G1(:,:,:,55))
  call check_last_CV_D(l_switch,G1(:,:,:,55),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,38))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,391),Q(:,79),G1(:,:,:,56))
  call check_last_CV_D(l_switch,G1(:,:,:,56),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,392),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,79),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,36),G1(:,:,:,58))
  call check_last_Q_A(l_switch,G1(:,:,:,58),Q(:,127),ZERO,G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,392),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,79),MT,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,36),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,127),MT,G2tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,392),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,79),MB,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,36),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,127),MB,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,393),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,79),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,36),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,127),ZERO,G2tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,393),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,79),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,36),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,127),MT,G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,393),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,79),MB,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,36),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,127),MB,G2tensor(:,45))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,392),Q(:,79),G1(:,:,:,69))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,46))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,393),Q(:,79),G1(:,:,:,70))
  call check_last_CV_D(l_switch,G1(:,:,:,70),Q(:,79),wf(:,36),Q(:,48),G2tensor(:,47))
  call loop_QV_A(G0(:,:,:,1),wf(:,66),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,76),ZERO,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,30),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,127),ZERO,G2tensor(:,48))
  call loop_QV_A(G1(:,:,:,71),wf(:,31),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,127),ZERO,G2tensor(:,49))
  call loop_QV_A(G1(:,:,:,71),wf(:,33),G1(:,:,:,74))
  call check_last_Q_A(l_switch,G1(:,:,:,74),Q(:,127),ZERO,G2tensor(:,50))
  call loop_QV_A(G1(:,:,:,71),wf(:,34),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,127),ZERO,G2tensor(:,51))
  call loop_QV_A(G0(:,:,:,1),wf(:,66),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,76),MT,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,30),G1(:,:,:,77))
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,127),MT,G2tensor(:,52))
  call loop_QV_A(G1(:,:,:,76),wf(:,31),G1(:,:,:,78))
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,127),MT,G2tensor(:,53))
  call loop_QV_A(G1(:,:,:,76),wf(:,33),G1(:,:,:,79))
  call check_last_Q_A(l_switch,G1(:,:,:,79),Q(:,127),MT,G2tensor(:,54))
  call loop_QV_A(G1(:,:,:,76),wf(:,34),G1(:,:,:,80))
  call check_last_Q_A(l_switch,G1(:,:,:,80),Q(:,127),MT,G2tensor(:,55))
  call loop_QV_A(G0(:,:,:,1),wf(:,66),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,76),MB,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,30),G1(:,:,:,82))
  call check_last_Q_A(l_switch,G1(:,:,:,82),Q(:,127),MB,G2tensor(:,56))
  call loop_QV_A(G1(:,:,:,81),wf(:,31),G1(:,:,:,83))
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,127),MB,G2tensor(:,57))
  call loop_QV_A(G1(:,:,:,81),wf(:,33),G1(:,:,:,84))
  call check_last_Q_A(l_switch,G1(:,:,:,84),Q(:,127),MB,G2tensor(:,58))
  call loop_QV_A(G1(:,:,:,81),wf(:,34),G1(:,:,:,85))
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,127),MB,G2tensor(:,59))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,66),Q(:,76),G1(:,:,:,86))
  call check_last_CV_D(l_switch,G1(:,:,:,86),Q(:,76),wf(:,30),Q(:,51),G2tensor(:,60))
  call check_last_CV_D(l_switch,G1(:,:,:,86),Q(:,76),wf(:,31),Q(:,51),G2tensor(:,61))
  call check_last_CV_D(l_switch,G1(:,:,:,86),Q(:,76),wf(:,33),Q(:,51),G2tensor(:,62))
  call check_last_CV_D(l_switch,G1(:,:,:,86),Q(:,76),wf(:,34),Q(:,51),G2tensor(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,76),ZERO,G1(:,:,:,87))
  call loop_QV_A(G1(:,:,:,87),wf(:,30),G1(:,:,:,88))
  call check_last_Q_A(l_switch,G1(:,:,:,88),Q(:,127),ZERO,G2tensor(:,64))
  call loop_QV_A(G1(:,:,:,87),wf(:,31),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,127),ZERO,G2tensor(:,65))
  call loop_QV_A(G1(:,:,:,87),wf(:,33),G1(:,:,:,90))
  call check_last_Q_A(l_switch,G1(:,:,:,90),Q(:,127),ZERO,G2tensor(:,66))
  call loop_QV_A(G1(:,:,:,87),wf(:,34),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,127),ZERO,G2tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,76),MT,G1(:,:,:,92))
  call loop_QV_A(G1(:,:,:,92),wf(:,30),G1(:,:,:,93))
  call check_last_Q_A(l_switch,G1(:,:,:,93),Q(:,127),MT,G2tensor(:,68))
  call loop_QV_A(G1(:,:,:,92),wf(:,31),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,127),MT,G2tensor(:,69))
  call loop_QV_A(G1(:,:,:,92),wf(:,33),G1(:,:,:,95))
  call check_last_Q_A(l_switch,G1(:,:,:,95),Q(:,127),MT,G2tensor(:,70))
  call loop_QV_A(G1(:,:,:,92),wf(:,34),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,127),MT,G2tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,76),MB,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,30),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,127),MB,G2tensor(:,72))
  call loop_QV_A(G1(:,:,:,97),wf(:,31),G1(:,:,:,99))
  call check_last_Q_A(l_switch,G1(:,:,:,99),Q(:,127),MB,G2tensor(:,73))
  call loop_QV_A(G1(:,:,:,97),wf(:,33),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,127),MB,G2tensor(:,74))
  call loop_QV_A(G1(:,:,:,97),wf(:,34),G1(:,:,:,101))
  call check_last_Q_A(l_switch,G1(:,:,:,101),Q(:,127),MB,G2tensor(:,75))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,69),Q(:,76),G1(:,:,:,102))
  call check_last_CV_D(l_switch,G1(:,:,:,102),Q(:,76),wf(:,30),Q(:,51),G2tensor(:,76))
  call check_last_CV_D(l_switch,G1(:,:,:,102),Q(:,76),wf(:,31),Q(:,51),G2tensor(:,77))
  call check_last_CV_D(l_switch,G1(:,:,:,102),Q(:,76),wf(:,33),Q(:,51),G2tensor(:,78))
  call check_last_CV_D(l_switch,G1(:,:,:,102),Q(:,76),wf(:,34),Q(:,51),G2tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,112),ZERO,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,59),G1(:,:,:,104))
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,127),ZERO,G2tensor(:,80))
  call loop_QV_A(G1(:,:,:,103),wf(:,60),G1(:,:,:,105))
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,127),ZERO,G2tensor(:,81))
  call loop_QV_A(G1(:,:,:,103),wf(:,63),G1(:,:,:,106))
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,127),ZERO,G2tensor(:,82))
  call loop_QV_A(G1(:,:,:,103),wf(:,64),G1(:,:,:,107))
  call check_last_Q_A(l_switch,G1(:,:,:,107),Q(:,127),ZERO,G2tensor(:,83))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,112),MT,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,59),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,127),MT,G2tensor(:,84))
  call loop_QV_A(G1(:,:,:,108),wf(:,60),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,127),MT,G2tensor(:,85))
  call loop_QV_A(G1(:,:,:,108),wf(:,63),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,127),MT,G2tensor(:,86))
  call loop_QV_A(G1(:,:,:,108),wf(:,64),G1(:,:,:,112))
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,127),MT,G2tensor(:,87))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,112),MB,G1(:,:,:,113))
  call loop_QV_A(G1(:,:,:,113),wf(:,59),G1(:,:,:,114))
  call check_last_Q_A(l_switch,G1(:,:,:,114),Q(:,127),MB,G2tensor(:,88))
  call loop_QV_A(G1(:,:,:,113),wf(:,60),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,127),MB,G2tensor(:,89))
  call loop_QV_A(G1(:,:,:,113),wf(:,63),G1(:,:,:,116))
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,127),MB,G2tensor(:,90))
  call loop_QV_A(G1(:,:,:,113),wf(:,64),G1(:,:,:,117))
  call check_last_Q_A(l_switch,G1(:,:,:,117),Q(:,127),MB,G2tensor(:,91))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,72),Q(:,112),G1(:,:,:,118))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,112),wf(:,59),Q(:,15),G2tensor(:,92))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,112),wf(:,60),Q(:,15),G2tensor(:,93))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,112),wf(:,63),Q(:,15),G2tensor(:,94))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,112),wf(:,64),Q(:,15),G2tensor(:,95))
  call loop_QV_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,112),ZERO,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,59),G1(:,:,:,120))
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,127),ZERO,G2tensor(:,96))
  call loop_QV_A(G1(:,:,:,119),wf(:,60),G1(:,:,:,121))
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,127),ZERO,G2tensor(:,97))
  call loop_QV_A(G1(:,:,:,119),wf(:,63),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,127),ZERO,G2tensor(:,98))
  call loop_QV_A(G1(:,:,:,119),wf(:,64),G1(:,:,:,123))
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,127),ZERO,G2tensor(:,99))
  call loop_QV_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,112),MT,G1(:,:,:,124))
  call loop_QV_A(G1(:,:,:,124),wf(:,59),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,127),MT,G2tensor(:,100))
  call loop_QV_A(G1(:,:,:,124),wf(:,60),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,127),MT,G2tensor(:,101))
  call loop_QV_A(G1(:,:,:,124),wf(:,63),G1(:,:,:,127))
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,127),MT,G2tensor(:,102))
  call loop_QV_A(G1(:,:,:,124),wf(:,64),G1(:,:,:,128))
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,127),MT,G2tensor(:,103))
  call loop_QV_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,112),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,59),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,127),MB,G2tensor(:,104))
  call loop_QV_A(G1(:,:,:,129),wf(:,60),G1(:,:,:,131))
  call check_last_Q_A(l_switch,G1(:,:,:,131),Q(:,127),MB,G2tensor(:,105))
  call loop_QV_A(G1(:,:,:,129),wf(:,63),G1(:,:,:,132))
  call check_last_Q_A(l_switch,G1(:,:,:,132),Q(:,127),MB,G2tensor(:,106))
  call loop_QV_A(G1(:,:,:,129),wf(:,64),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,127),MB,G2tensor(:,107))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,73),Q(:,112),G1(:,:,:,134))
  call check_last_CV_D(l_switch,G1(:,:,:,134),Q(:,112),wf(:,59),Q(:,15),G2tensor(:,108))
  call check_last_CV_D(l_switch,G1(:,:,:,134),Q(:,112),wf(:,60),Q(:,15),G2tensor(:,109))
  call check_last_CV_D(l_switch,G1(:,:,:,134),Q(:,112),wf(:,63),Q(:,15),G2tensor(:,110))
  call check_last_CV_D(l_switch,G1(:,:,:,134),Q(:,112),wf(:,64),Q(:,15),G2tensor(:,111))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(58)*(-M(2)+M(3))) * den(642)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(58)*(-M(2)+M(3))) * den(642)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(61)*(M(2)-M(3))) * den(643)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(59)*(M(2)-M(3))) * den(643)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(61)*(M(2)-M(3))) * den(643)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(59)*(M(2)-M(3))) * den(643)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(14)*(-M(2)+M(3))) * den(642)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(19)*(M(2)-M(3))) * den(643)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(60)*(M(2)-M(3))) * den(292)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(58)*(M(2)-M(3))) * den(292)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(60)*(M(2)-M(3))) * den(292)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(58)*(M(2)-M(3))) * den(292)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(61)*(-M(2)+M(3))) * den(294)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(59)*(-M(2)+M(3))) * den(294)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(61)*(-M(2)+M(3))) * den(294)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(59)*(-M(2)+M(3))) * den(294)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(14)*(M(2)-M(3))) * den(292)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(19)*(-M(2)+M(3))) * den(294)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(3)) * den(644)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(64)*M(1))+c(65)*M(3)) * den(644)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(3)) * den(644)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(64)*M(1))+c(65)*M(3)) * den(644)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(70)*M(1)-c(71)*M(3)) * den(645)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(66)*M(1)-c(67)*M(3)) * den(645)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(70)*M(1)-c(71)*M(3)) * den(645)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(66)*M(1)-c(67)*M(3)) * den(645)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(41)*M(1))+c(45)*M(3)) * den(644)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(52)*M(1)-c(56)*M(3)) * den(645)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(60)*(-M(2)+M(3))) * den(646)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(58)*(-M(2)+M(3))) * den(646)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(60)*(-M(2)+M(3))) * den(646)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(58)*(-M(2)+M(3))) * den(646)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(61)*(M(2)-M(3))) * den(647)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(59)*(M(2)-M(3))) * den(647)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(61)*(M(2)-M(3))) * den(647)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(59)*(M(2)-M(3))) * den(647)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(14)*(-M(2)+M(3))) * den(646)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(19)*(M(2)-M(3))) * den(647)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(60)*(M(2)-M(3))) * den(281)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(58)*(M(2)-M(3))) * den(281)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(60)*(M(2)-M(3))) * den(281)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(58)*(M(2)-M(3))) * den(281)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(61)*(-M(2)+M(3))) * den(283)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(59)*(-M(2)+M(3))) * den(283)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(61)*(-M(2)+M(3))) * den(283)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(59)*(-M(2)+M(3))) * den(283)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(14)*(M(2)-M(3))) * den(281)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(19)*(-M(2)+M(3))) * den(283)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(2)) * den(648)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(64)*M(1))+c(65)*M(2)) * den(648)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(2)) * den(648)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(64)*M(1))+c(65)*M(2)) * den(648)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(70)*M(1)-c(71)*M(2)) * den(649)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(66)*M(1)-c(67)*M(2)) * den(649)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(70)*M(1)-c(71)*M(2)) * den(649)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(66)*M(1)-c(67)*M(2)) * den(649)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(41)*M(1))+c(45)*M(2)) * den(648)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(52)*M(1)-c(56)*M(2)) * den(649)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(64)*M(1)-c(65)*M(3)) * den(313)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(62)*M(1)-c(63)*M(3)) * den(313)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(64)*M(1)-c(65)*M(3)) * den(313)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(62)*M(1)-c(63)*M(3)) * den(313)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(70)*M(1)-c(71)*M(3)) * den(314)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(66)*M(1)-c(67)*M(3)) * den(314)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(70)*M(1)-c(71)*M(3)) * den(314)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(66)*M(1)-c(67)*M(3)) * den(314)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(28)*M(1)-c(32)*M(3)) * den(313)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(52)*M(1)-c(56)*M(3)) * den(314)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(64)*M(1)-c(65)*M(3)) * den(311)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(62)*M(1)-c(63)*M(3)) * den(311)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(64)*M(1)-c(65)*M(3)) * den(311)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(62)*M(1)-c(63)*M(3)) * den(311)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(70)*M(1)-c(71)*M(3)) * den(312)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(66)*M(1)-c(67)*M(3)) * den(312)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(70)*M(1)-c(71)*M(3)) * den(312)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(66)*M(1)-c(67)*M(3)) * den(312)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(28)*M(1)-c(32)*M(3)) * den(311)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(52)*M(1)-c(56)*M(3)) * den(312)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(64)*M(1)-c(65)*M(2)) * den(328)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(62)*M(1)-c(63)*M(2)) * den(328)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(64)*M(1)-c(65)*M(2)) * den(328)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(62)*M(1)-c(63)*M(2)) * den(328)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(70)*M(1)-c(71)*M(2)) * den(329)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(66)*M(1)-c(67)*M(2)) * den(329)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(70)*M(1)-c(71)*M(2)) * den(329)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(66)*M(1)-c(67)*M(2)) * den(329)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(28)*M(1)-c(32)*M(2)) * den(328)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(52)*M(1)-c(56)*M(2)) * den(329)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(64)*M(1)-c(65)*M(2)) * den(326)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(62)*M(1)-c(63)*M(2)) * den(326)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(64)*M(1)-c(65)*M(2)) * den(326)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(62)*M(1)-c(63)*M(2)) * den(326)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(70)*M(1)-c(71)*M(2)) * den(327)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(66)*M(1)-c(67)*M(2)) * den(327)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(70)*M(1)-c(71)*M(2)) * den(327)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(66)*M(1)-c(67)*M(2)) * den(327)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(28)*M(1)-c(32)*M(2)) * den(326)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(52)*M(1)-c(56)*M(2)) * den(327)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(69)*M(2)-c(68)*M(4)) * den(344)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(65)*M(2)-c(64)*M(4)) * den(344)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(69)*M(2)-c(68)*M(4)) * den(344)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(65)*M(2)-c(64)*M(4)) * den(344)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(71)*M(2))+c(70)*M(4)) * den(345)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(67)*M(2))+c(66)*M(4)) * den(345)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(71)*M(2))+c(70)*M(4)) * den(345)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(67)*M(2))+c(66)*M(4)) * den(345)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(45)*M(2)-c(41)*M(4)) * den(344)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(56)*M(2))+c(52)*M(4)) * den(345)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(69)*M(2)-c(68)*M(4)) * den(342)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(65)*M(2)-c(64)*M(4)) * den(342)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(69)*M(2)-c(68)*M(4)) * den(342)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(65)*M(2)-c(64)*M(4)) * den(342)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(71)*M(2))+c(70)*M(4)) * den(343)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(67)*M(2))+c(66)*M(4)) * den(343)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(71)*M(2))+c(70)*M(4)) * den(343)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(67)*M(2))+c(66)*M(4)) * den(343)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(45)*M(2)-c(41)*M(4)) * den(342)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(56)*M(2))+c(52)*M(4)) * den(343)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(69)*M(3)-c(68)*M(4)) * den(358)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(65)*M(3)-c(64)*M(4)) * den(358)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(69)*M(3)-c(68)*M(4)) * den(358)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(65)*M(3)-c(64)*M(4)) * den(358)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,104)
  Gcoeff = (-(c(71)*M(3))+c(70)*M(4)) * den(359)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(67)*M(3))+c(66)*M(4)) * den(359)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,101)
  Gcoeff = (-(c(71)*M(3))+c(70)*M(4)) * den(359)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(67)*M(3))+c(66)*M(4)) * den(359)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(45)*M(3)-c(41)*M(4)) * den(358)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,108)
  Gcoeff = (-(c(56)*M(3))+c(52)*M(4)) * den(359)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(69)*M(3)-c(68)*M(4)) * den(356)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(65)*M(3)-c(64)*M(4)) * den(356)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(69)*M(3)-c(68)*M(4)) * den(356)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(65)*M(3)-c(64)*M(4)) * den(356)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(71)*M(3))+c(70)*M(4)) * den(357)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,99)
  Gcoeff = (-(c(67)*M(3))+c(66)*M(4)) * den(357)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,103)
  Gcoeff = (-(c(71)*M(3))+c(70)*M(4)) * den(357)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,99)
  Gcoeff = (-(c(67)*M(3))+c(66)*M(4)) * den(357)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(45)*M(3)-c(41)*M(4)) * den(356)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(56)*M(3))+c(52)*M(4)) * den(357)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,111)

end subroutine vamp_5

end module ol_vamp_5_ppllttj_eexttxbbxg_1_/**/REALKIND
