
module ol_vamp_3_ppllttj_nenexuuxttxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllttj_nenexuuxttxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllttj_nenexuuxttxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllttj_nenexuuxttxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllttj_nenexuuxttxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(4)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,25) :: G0
  complex(REALKIND), dimension(4,5,4,71) :: G1
  complex(REALKIND), dimension(15,52) :: G2tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,112),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,43),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,127),ZERO,G2tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,45),G1(:,:,:,3))
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,127),ZERO,G2tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,112),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,43),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,127),MT,G2tensor(:,3))
  call loop_QV_A(G1(:,:,:,4),wf(:,45),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,127),MT,G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,112),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,43),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,127),MB,G2tensor(:,5))
  call loop_QV_A(G1(:,:,:,7),wf(:,45),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,127),MB,G2tensor(:,6))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,112),G1(:,:,:,10))
  call check_last_CV_D(l_switch,G1(:,:,:,10),Q(:,112),wf(:,43),Q(:,15),G2tensor(:,7))
  call check_last_CV_D(l_switch,G1(:,:,:,10),Q(:,112),wf(:,45),Q(:,15),G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,280),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,79),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,26),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,127),ZERO,G2tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,280),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,79),MT,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,26),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,127),MT,G2tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,280),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,79),MB,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,26),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,127),MB,G2tensor(:,11))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,280),Q(:,79),G1(:,:,:,17))
  call check_last_CV_D(l_switch,G1(:,:,:,17),Q(:,79),wf(:,26),Q(:,48),G2tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,285),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,79),ZERO,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,26),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,127),ZERO,G2tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,285),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,79),MT,G1(:,:,:,20))
  call loop_QV_A(G1(:,:,:,20),wf(:,26),G1(:,:,:,21))
  call check_last_Q_A(l_switch,G1(:,:,:,21),Q(:,127),MT,G2tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,285),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,79),MB,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,26),G1(:,:,:,23))
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,127),MB,G2tensor(:,15))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,285),Q(:,79),G1(:,:,:,24))
  call check_last_CV_D(l_switch,G1(:,:,:,24),Q(:,79),wf(:,26),Q(:,48),G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,286),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,79),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,26),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,127),ZERO,G2tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,286),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,79),MT,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,26),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,127),MT,G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,286),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,79),MB,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,26),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,127),MB,G2tensor(:,19))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,286),Q(:,79),G1(:,:,:,31))
  call check_last_CV_D(l_switch,G1(:,:,:,31),Q(:,79),wf(:,26),Q(:,48),G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,76),ZERO,G1(:,:,:,32))
  call loop_QV_A(G1(:,:,:,32),wf(:,22),G1(:,:,:,33))
  call check_last_Q_A(l_switch,G1(:,:,:,33),Q(:,127),ZERO,G2tensor(:,21))
  call loop_QV_A(G1(:,:,:,32),wf(:,24),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,127),ZERO,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,76),MT,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,22),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,127),MT,G2tensor(:,23))
  call loop_QV_A(G1(:,:,:,35),wf(:,24),G1(:,:,:,37))
  call check_last_Q_A(l_switch,G1(:,:,:,37),Q(:,127),MT,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,47),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,76),MB,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,22),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,127),MB,G2tensor(:,25))
  call loop_QV_A(G1(:,:,:,38),wf(:,24),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,127),MB,G2tensor(:,26))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,47),Q(:,76),G1(:,:,:,41))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,76),wf(:,22),Q(:,51),G2tensor(:,27))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,76),wf(:,24),Q(:,51),G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,50),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,76),ZERO,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,22),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,127),ZERO,G2tensor(:,29))
  call loop_QV_A(G1(:,:,:,42),wf(:,24),G1(:,:,:,44))
  call check_last_Q_A(l_switch,G1(:,:,:,44),Q(:,127),ZERO,G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,50),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,76),MT,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,22),G1(:,:,:,46))
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,127),MT,G2tensor(:,31))
  call loop_QV_A(G1(:,:,:,45),wf(:,24),G1(:,:,:,47))
  call check_last_Q_A(l_switch,G1(:,:,:,47),Q(:,127),MT,G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,50),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,76),MB,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,22),G1(:,:,:,49))
  call check_last_Q_A(l_switch,G1(:,:,:,49),Q(:,127),MB,G2tensor(:,33))
  call loop_QV_A(G1(:,:,:,48),wf(:,24),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,127),MB,G2tensor(:,34))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,50),Q(:,76),G1(:,:,:,51))
  call check_last_CV_D(l_switch,G1(:,:,:,51),Q(:,76),wf(:,22),Q(:,51),G2tensor(:,35))
  call check_last_CV_D(l_switch,G1(:,:,:,51),Q(:,76),wf(:,24),Q(:,51),G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,112),ZERO,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,43),G1(:,:,:,53))
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,127),ZERO,G2tensor(:,37))
  call loop_QV_A(G1(:,:,:,52),wf(:,45),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,127),ZERO,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,112),MT,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,43),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,127),MT,G2tensor(:,39))
  call loop_QV_A(G1(:,:,:,55),wf(:,45),G1(:,:,:,57))
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,127),MT,G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,112),MB,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,43),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,127),MB,G2tensor(:,41))
  call loop_QV_A(G1(:,:,:,58),wf(:,45),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,127),MB,G2tensor(:,42))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,53),Q(:,112),G1(:,:,:,61))
  call check_last_CV_D(l_switch,G1(:,:,:,61),Q(:,112),wf(:,43),Q(:,15),G2tensor(:,43))
  call check_last_CV_D(l_switch,G1(:,:,:,61),Q(:,112),wf(:,45),Q(:,15),G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,112),ZERO,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,43),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,127),ZERO,G2tensor(:,45))
  call loop_QV_A(G1(:,:,:,62),wf(:,45),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,127),ZERO,G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,112),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,43),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,127),MT,G2tensor(:,47))
  call loop_QV_A(G1(:,:,:,65),wf(:,45),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,127),MT,G2tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,112),MB,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,43),G1(:,:,:,69))
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,127),MB,G2tensor(:,49))
  call loop_QV_A(G1(:,:,:,68),wf(:,45),G1(:,:,:,70))
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,127),MB,G2tensor(:,50))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,112),G1(:,:,:,71))
  call check_last_CV_D(l_switch,G1(:,:,:,71),Q(:,112),wf(:,43),Q(:,15),G2tensor(:,51))
  call check_last_CV_D(l_switch,G1(:,:,:,71),Q(:,112),wf(:,45),Q(:,15),G2tensor(:,52))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(22)*(-M(2)+M(3))) * den(188)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(21)*(-M(2)+M(3))) * den(188)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(22)*(-M(2)+M(3))) * den(188)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(21)*(-M(2)+M(3))) * den(188)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(7)*(-M(2)+M(3))) * den(188)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(25)*M(1)-c(26)*M(3)) * den(373)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(23)*M(1)-c(24)*M(3)) * den(373)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(25)*M(1)-c(26)*M(3)) * den(373)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(23)*M(1)-c(24)*M(3)) * den(373)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(16)*M(1)-c(20)*M(3)) * den(373)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(22)*(M(2)-M(3))) * den(374)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(21)*(M(2)-M(3))) * den(374)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(22)*(M(2)-M(3))) * den(374)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(21)*(M(2)-M(3))) * den(374)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(7)*(M(2)-M(3))) * den(374)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(22)*(-M(2)+M(3))) * den(182)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(21)*(-M(2)+M(3))) * den(182)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(22)*(-M(2)+M(3))) * den(182)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(21)*(-M(2)+M(3))) * den(182)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(7)*(-M(2)+M(3))) * den(182)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(25)*M(1)-c(26)*M(2)) * den(375)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(23)*M(1)-c(24)*M(2)) * den(375)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(25)*M(1)-c(26)*M(2)) * den(375)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(23)*M(1)-c(24)*M(2)) * den(375)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(16)*M(1)-c(20)*M(2)) * den(375)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(25)*M(1)-c(26)*M(3)) * den(199)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(23)*M(1)-c(24)*M(3)) * den(199)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(25)*M(1)-c(26)*M(3)) * den(199)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(23)*M(1)-c(24)*M(3)) * den(199)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(16)*M(1)-c(20)*M(3)) * den(199)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(25)*M(1)-c(26)*M(3)) * den(198)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(23)*M(1)-c(24)*M(3)) * den(198)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(25)*M(1)-c(26)*M(3)) * den(198)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(23)*M(1)-c(24)*M(3)) * den(198)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(16)*M(1)-c(20)*M(3)) * den(198)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(25)*M(1)-c(26)*M(2)) * den(208)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(23)*M(1)-c(24)*M(2)) * den(208)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(25)*M(1)-c(26)*M(2)) * den(208)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(23)*M(1)-c(24)*M(2)) * den(208)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(16)*M(1)-c(20)*M(2)) * den(208)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(25)*M(1)-c(26)*M(2)) * den(207)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(23)*M(1)-c(24)*M(2)) * den(207)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(25)*M(1)-c(26)*M(2)) * den(207)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(23)*M(1)-c(24)*M(2)) * den(207)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(16)*M(1)-c(20)*M(2)) * den(207)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(26)*M(2))+c(25)*M(4)) * den(218)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(24)*M(2))+c(23)*M(4)) * den(218)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(26)*M(2))+c(25)*M(4)) * den(218)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(24)*M(2))+c(23)*M(4)) * den(218)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(20)*M(2))+c(16)*M(4)) * den(218)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(26)*M(2))+c(25)*M(4)) * den(217)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(24)*M(2))+c(23)*M(4)) * den(217)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(26)*M(2))+c(25)*M(4)) * den(217)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(24)*M(2))+c(23)*M(4)) * den(217)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(20)*M(2))+c(16)*M(4)) * den(217)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(26)*M(3))+c(25)*M(4)) * den(226)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(4)) * den(226)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(26)*M(3))+c(25)*M(4)) * den(226)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(4)) * den(226)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(20)*M(3))+c(16)*M(4)) * den(226)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(26)*M(3))+c(25)*M(4)) * den(225)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(4)) * den(225)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(26)*M(3))+c(25)*M(4)) * den(225)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(4)) * den(225)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(20)*M(3))+c(16)*M(4)) * den(225)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,52)

end subroutine vamp_3

end module ol_vamp_3_ppllttj_nenexuuxttxg_1_/**/REALKIND
