
module ol_vamp_3_ppllttj_eexttxggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllttj_eexttxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllttj_eexttxggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllttj_eexttxggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllttj_eexttxggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(11)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,19) :: G0
  complex(REALKIND), dimension(4,5,4,196) :: G1
  complex(REALKIND), dimension(4,15,4,558) :: G2
  complex(REALKIND), dimension(4,35,4,127) :: G3
  complex(REALKIND), dimension(4,70,4,26) :: G4
  complex(REALKIND), dimension(35,340) :: G3tensor
  complex(REALKIND), dimension(70,79) :: G4tensor
  complex(REALKIND), dimension(126,18) :: G5tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,32),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,134),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,124),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,127),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,11),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,127),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,11),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,127),ZERO,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,136),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,124),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,127),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,11),G2(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,127),ZERO,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,5),wf(:,11),G2(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,127),ZERO,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,137),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,124),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,127),ZERO,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,11),G2(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,127),ZERO,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,11),G2(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,127),ZERO,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,193),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,124),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,1),G2(:,:,:,14))
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),ZERO,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,11),G2(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,127),ZERO,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,11),G2(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),ZERO,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,115),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,44),ZERO,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,83),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,124),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,11),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),ZERO,G4tensor(:,2))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,11),G3(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,60),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-6),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,11),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,11),G4(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,194),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,124),ZERO,G2(:,:,:,20))
  call loop_AV_Q(G2(:,:,:,20),wf(:,1),G2(:,:,:,21))
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,127),ZERO,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,11),G2(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,127),ZERO,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,11),G2(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),ZERO,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,124),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,60),ZERO,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-6),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,124),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),ZERO,G4tensor(:,4))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,11),G3(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,11),G3(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,607),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,124),ZERO,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,1),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),ZERO,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,11),G2(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),ZERO,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,11),G2(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),ZERO,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,48),ZERO,G2(:,:,:,30))
  call loop_AV_Q(G2(:,:,:,30),wf(:,151),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,124),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),ZERO,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,11),G3(:,:,:,13),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,127),ZERO,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,11),G3(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AV_Q(G2(:,:,:,30),wf(:,115),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,60),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,-6),G3(:,:,:,16))
  call loop_A_Q(G3(:,:,:,16),Q(:,124),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,1),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,11),G4(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,7),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,11),G4(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AV_Q(G2(:,:,:,30),wf(:,160),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,124),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,11),G3(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,19),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,11),G3(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,30),wf(:,161),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,124),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,11),G3(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,11),G3(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),ZERO,G4tensor(:,15))
  call loop_AV_Q(G2(:,:,:,30),wf(:,-6),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,112),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,106),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,16))
  call loop_AV_Q(G3(:,:,:,25),wf(:,107),G3(:,:,:,27))
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AV_Q(G3(:,:,:,25),wf(:,108),G3(:,:,:,28))
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AV_Q(G3(:,:,:,25),wf(:,109),G3(:,:,:,29))
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,1),wf(:,222),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,124),ZERO,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,1),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),ZERO,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,36),wf(:,11),G2(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),ZERO,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,36),wf(:,11),G2(:,:,:,39),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),ZERO,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,96),ZERO,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,609),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),ZERO,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,40),wf(:,610),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),ZERO,G3tensor(:,23))
  call loop_AV_Q(G2(:,:,:,40),wf(:,620),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),ZERO,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,40),wf(:,621),G2(:,:,:,44))
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),ZERO,G3tensor(:,25))
  call loop_AV_Q(G2(:,:,:,40),wf(:,630),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,127),ZERO,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,40),wf(:,631),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,127),ZERO,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,40),wf(:,633),G2(:,:,:,47))
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,127),ZERO,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,40),wf(:,634),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,127),ZERO,G3tensor(:,29))
  call loop_AV_Q(G2(:,:,:,40),wf(:,783),G2(:,:,:,49))
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,127),ZERO,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,40),wf(:,784),G2(:,:,:,50))
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,127),ZERO,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,40),wf(:,789),G2(:,:,:,51))
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,127),ZERO,G3tensor(:,32))
  call loop_AV_Q(G2(:,:,:,40),wf(:,790),G2(:,:,:,52))
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,127),ZERO,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,40),wf(:,819),G2(:,:,:,53))
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,127),ZERO,G3tensor(:,34))
  call loop_AV_Q(G2(:,:,:,40),wf(:,820),G2(:,:,:,54))
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,127),ZERO,G3tensor(:,35))
  call loop_AV_Q(G2(:,:,:,40),wf(:,825),G2(:,:,:,55))
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,127),ZERO,G3tensor(:,36))
  call loop_AV_Q(G2(:,:,:,40),wf(:,826),G2(:,:,:,56))
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),ZERO,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,1),wf(:,226),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,124),ZERO,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,1),G2(:,:,:,58))
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,127),ZERO,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,57),wf(:,11),G2(:,:,:,59),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,127),ZERO,G3tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,57),wf(:,11),G2(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,127),ZERO,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,1),wf(:,156),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,60),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-6),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,124),ZERO,G3(:,:,:,30))
  call loop_AV_Q(G3(:,:,:,30),wf(:,1),G3(:,:,:,31))
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,30),wf(:,11),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,30),wf(:,11),G3(:,:,:,33),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,1),wf(:,615),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,124),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,1),G2(:,:,:,64))
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),ZERO,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,11),G2(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),ZERO,G3tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,11),G2(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,1),wf(:,255),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,124),ZERO,G2(:,:,:,67))
  call loop_AV_Q(G2(:,:,:,67),wf(:,1),G2(:,:,:,68))
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,11),G2(:,:,:,69),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,11),G2(:,:,:,70),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,1),wf(:,259),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,124),ZERO,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,1),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,71),wf(:,11),G2(:,:,:,73),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,71),wf(:,11),G2(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,1),wf(:,157),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,60),ZERO,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-6),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,124),ZERO,G3(:,:,:,34))
  call loop_AV_Q(G3(:,:,:,34),wf(:,1),G3(:,:,:,35))
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,11),G3(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,24))
  call loop_AZ_Q(G3(:,:,:,34),wf(:,11),G3(:,:,:,37),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,127),ZERO,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,632),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,124),ZERO,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,1),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,77),wf(:,11),G2(:,:,:,79),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,77),wf(:,11),G2(:,:,:,80),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,1),wf(:,709),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,111),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-4),G2(:,:,:,82))
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,1),wf(:,710),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,111),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-4),G2(:,:,:,84))
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,1),wf(:,279),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,124),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,1),G2(:,:,:,86))
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,85),wf(:,11),G2(:,:,:,87),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,87),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G2(:,:,:,85),wf(:,11),G2(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,127),ZERO,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,1),wf(:,280),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,124),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,1),G2(:,:,:,90))
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,127),ZERO,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,89),wf(:,11),G2(:,:,:,91),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,91),Q(:,127),ZERO,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,89),wf(:,11),G2(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,92),Q(:,127),ZERO,G3tensor(:,60))
  call loop_AV_Q(G1(:,:,:,1),wf(:,720),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,111),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-4),G2(:,:,:,94))
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,127),ZERO,G3tensor(:,61))
  call loop_AV_Q(G1(:,:,:,1),wf(:,721),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,111),ZERO,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-4),G2(:,:,:,96))
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,127),ZERO,G3tensor(:,62))
  call loop_AV_Q(G1(:,:,:,1),wf(:,730),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,111),ZERO,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-4),G2(:,:,:,98))
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,127),ZERO,G3tensor(:,63))
  call loop_AV_Q(G1(:,:,:,1),wf(:,731),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,111),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,127),ZERO,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,1),wf(:,282),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,124),ZERO,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,1),G2(:,:,:,102))
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,127),ZERO,G3tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,101),wf(:,11),G2(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,103),Q(:,127),ZERO,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,101),wf(:,11),G2(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,127),ZERO,G3tensor(:,67))
  call loop_AV_Q(G1(:,:,:,1),wf(:,283),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,124),ZERO,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,1),G2(:,:,:,106))
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,127),ZERO,G3tensor(:,68))
  call loop_AZ_Q(G2(:,:,:,105),wf(:,11),G2(:,:,:,107),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,105),wf(:,11),G2(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AV_Q(G1(:,:,:,1),wf(:,733),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,111),ZERO,G2(:,:,:,109))
  call loop_AV_Q(G2(:,:,:,109),wf(:,-4),G2(:,:,:,110))
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AV_Q(G1(:,:,:,1),wf(:,734),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,111),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AV_Q(G1(:,:,:,1),wf(:,83),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,112),ZERO,G2(:,:,:,113))
  call loop_AV_Q(G2(:,:,:,113),wf(:,106),G2(:,:,:,114))
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,127),ZERO,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,113),wf(:,107),G2(:,:,:,115))
  call check_last_A_Q(l_switch,G2(:,:,:,115),Q(:,127),ZERO,G3tensor(:,74))
  call loop_AV_Q(G2(:,:,:,113),wf(:,108),G2(:,:,:,116))
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,127),ZERO,G3tensor(:,75))
  call loop_AV_Q(G2(:,:,:,113),wf(:,109),G2(:,:,:,117))
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,127),ZERO,G3tensor(:,76))
  call loop_AV_Q(G1(:,:,:,1),wf(:,286),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,124),ZERO,G2(:,:,:,118))
  call loop_AV_Q(G2(:,:,:,118),wf(:,1),G2(:,:,:,119))
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,127),ZERO,G3tensor(:,77))
  call loop_AZ_Q(G2(:,:,:,118),wf(:,11),G2(:,:,:,120),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,120),Q(:,127),ZERO,G3tensor(:,78))
  call loop_AZ_Q(G2(:,:,:,118),wf(:,11),G2(:,:,:,121),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,121),Q(:,127),ZERO,G3tensor(:,79))
  call loop_AV_Q(G1(:,:,:,1),wf(:,287),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,124),ZERO,G2(:,:,:,122))
  call loop_AV_Q(G2(:,:,:,122),wf(:,1),G2(:,:,:,123))
  call check_last_A_Q(l_switch,G2(:,:,:,123),Q(:,127),ZERO,G3tensor(:,80))
  call loop_AZ_Q(G2(:,:,:,122),wf(:,11),G2(:,:,:,124),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,127),ZERO,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,122),wf(:,11),G2(:,:,:,125),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,125),Q(:,127),ZERO,G3tensor(:,82))
  call loop_AV_Q(G1(:,:,:,1),wf(:,787),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,111),ZERO,G2(:,:,:,126))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-4),G2(:,:,:,127))
  call check_last_A_Q(l_switch,G2(:,:,:,127),Q(:,127),ZERO,G3tensor(:,83))
  call loop_AV_Q(G1(:,:,:,1),wf(:,788),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,111),ZERO,G2(:,:,:,128))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-4),G2(:,:,:,129))
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,84))
  call loop_AV_Q(G1(:,:,:,1),wf(:,809),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,111),ZERO,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-4),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,85))
  call loop_AV_Q(G1(:,:,:,1),wf(:,810),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,111),ZERO,G2(:,:,:,132))
  call loop_AV_Q(G2(:,:,:,132),wf(:,-4),G2(:,:,:,133))
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,1),wf(:,823),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,111),ZERO,G2(:,:,:,134))
  call loop_AV_Q(G2(:,:,:,134),wf(:,-4),G2(:,:,:,135))
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,1),wf(:,824),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,111),ZERO,G2(:,:,:,136))
  call loop_AV_Q(G2(:,:,:,136),wf(:,-4),G2(:,:,:,137))
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,1),wf(:,829),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,111),ZERO,G2(:,:,:,138))
  call loop_AV_Q(G2(:,:,:,138),wf(:,-4),G2(:,:,:,139))
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,89))
  call loop_AV_Q(G1(:,:,:,1),wf(:,830),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,111),ZERO,G2(:,:,:,140))
  call loop_AV_Q(G2(:,:,:,140),wf(:,-4),G2(:,:,:,141))
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,90))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,32),MT,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,134),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,124),MT,G2(:,:,:,142))
  call loop_AV_Q(G2(:,:,:,142),wf(:,1),G2(:,:,:,143))
  call check_last_A_Q(l_switch,G2(:,:,:,143),Q(:,127),MT,G3tensor(:,91))
  call loop_AZ_Q(G2(:,:,:,142),wf(:,11),G2(:,:,:,144),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,127),MT,G3tensor(:,92))
  call loop_AV_Q(G1(:,:,:,43),wf(:,136),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,124),MT,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,1),G2(:,:,:,146))
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,127),MT,G3tensor(:,93))
  call loop_AZ_Q(G2(:,:,:,145),wf(:,11),G2(:,:,:,147),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,147),Q(:,127),MT,G3tensor(:,94))
  call loop_AV_Q(G1(:,:,:,43),wf(:,137),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,124),MT,G2(:,:,:,148))
  call loop_AV_Q(G2(:,:,:,148),wf(:,1),G2(:,:,:,149))
  call check_last_A_Q(l_switch,G2(:,:,:,149),Q(:,127),MT,G3tensor(:,95))
  call loop_AZ_Q(G2(:,:,:,148),wf(:,11),G2(:,:,:,150),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,127),MT,G3tensor(:,96))
  call loop_AV_Q(G1(:,:,:,43),wf(:,193),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,124),MT,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,1),G2(:,:,:,152))
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,127),MT,G3tensor(:,97))
  call loop_AZ_Q(G2(:,:,:,151),wf(:,11),G2(:,:,:,153),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,127),MT,G3tensor(:,98))
  call loop_AV_Q(G1(:,:,:,43),wf(:,115),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,44),MT,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,83),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,124),MT,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,1),G3(:,:,:,39))
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),MT,G4tensor(:,26))
  call loop_AZ_Q(G3(:,:,:,38),wf(:,11),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),MT,G4tensor(:,27))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-4),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,60),MT,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,-6),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,124),MT,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,1),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),MT,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,11),G4(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),MT,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,43),wf(:,194),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,124),MT,G2(:,:,:,157))
  call loop_AV_Q(G2(:,:,:,157),wf(:,1),G2(:,:,:,158))
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,127),MT,G3tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,157),wf(:,11),G2(:,:,:,159),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,127),MT,G3tensor(:,100))
  call loop_AV_Q(G1(:,:,:,43),wf(:,124),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,60),MT,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-6),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,124),MT,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,1),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),MT,G4tensor(:,28))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,11),G3(:,:,:,45),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),MT,G4tensor(:,29))
  call loop_AV_Q(G1(:,:,:,43),wf(:,607),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,124),MT,G2(:,:,:,162))
  call loop_AV_Q(G2(:,:,:,162),wf(:,1),G2(:,:,:,163))
  call check_last_A_Q(l_switch,G2(:,:,:,163),Q(:,127),MT,G3tensor(:,101))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,11),G2(:,:,:,164),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,127),MT,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,48),MT,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,151),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,124),MT,G3(:,:,:,46))
  call loop_AV_Q(G3(:,:,:,46),wf(:,1),G3(:,:,:,47))
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),MT,G4tensor(:,30))
  call loop_AZ_Q(G3(:,:,:,46),wf(:,11),G3(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),MT,G4tensor(:,31))
  call loop_AV_Q(G2(:,:,:,165),wf(:,115),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,60),MT,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,-6),G3(:,:,:,50))
  call loop_A_Q(G3(:,:,:,50),Q(:,124),MT,G4(:,:,:,12))
  call loop_AV_Q(G4(:,:,:,12),wf(:,1),G4(:,:,:,13))
  call check_last_A_Q(l_switch,G4(:,:,:,13),Q(:,127),MT,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,12),wf(:,11),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),MT,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,165),wf(:,160),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,124),MT,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,1),G3(:,:,:,52))
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),MT,G4tensor(:,32))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,11),G3(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,127),MT,G4tensor(:,33))
  call loop_AV_Q(G2(:,:,:,165),wf(:,161),G2(:,:,:,169))
  call loop_A_Q(G2(:,:,:,169),Q(:,124),MT,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,1),G3(:,:,:,55))
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,127),MT,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,54),wf(:,11),G3(:,:,:,56),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,127),MT,G4tensor(:,35))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-6),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,112),MT,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,106),G3(:,:,:,58))
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,36))
  call loop_AV_Q(G3(:,:,:,57),wf(:,107),G3(:,:,:,59))
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,127),MT,G4tensor(:,37))
  call loop_AV_Q(G3(:,:,:,57),wf(:,108),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MT,G4tensor(:,38))
  call loop_AV_Q(G3(:,:,:,57),wf(:,109),G3(:,:,:,61))
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),MT,G4tensor(:,39))
  call loop_AV_Q(G1(:,:,:,43),wf(:,222),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,124),MT,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,1),G2(:,:,:,172))
  call check_last_A_Q(l_switch,G2(:,:,:,172),Q(:,127),MT,G3tensor(:,103))
  call loop_AZ_Q(G2(:,:,:,171),wf(:,11),G2(:,:,:,173),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,173),Q(:,127),MT,G3tensor(:,104))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-6),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,96),MT,G2(:,:,:,174))
  call loop_AV_Q(G2(:,:,:,174),wf(:,609),G2(:,:,:,175))
  call check_last_A_Q(l_switch,G2(:,:,:,175),Q(:,127),MT,G3tensor(:,105))
  call loop_AV_Q(G2(:,:,:,174),wf(:,610),G2(:,:,:,176))
  call check_last_A_Q(l_switch,G2(:,:,:,176),Q(:,127),MT,G3tensor(:,106))
  call loop_AV_Q(G2(:,:,:,174),wf(:,620),G2(:,:,:,177))
  call check_last_A_Q(l_switch,G2(:,:,:,177),Q(:,127),MT,G3tensor(:,107))
  call loop_AV_Q(G2(:,:,:,174),wf(:,621),G2(:,:,:,178))
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,127),MT,G3tensor(:,108))
  call loop_AV_Q(G2(:,:,:,174),wf(:,630),G2(:,:,:,179))
  call check_last_A_Q(l_switch,G2(:,:,:,179),Q(:,127),MT,G3tensor(:,109))
  call loop_AV_Q(G2(:,:,:,174),wf(:,631),G2(:,:,:,180))
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,127),MT,G3tensor(:,110))
  call loop_AV_Q(G2(:,:,:,174),wf(:,633),G2(:,:,:,181))
  call check_last_A_Q(l_switch,G2(:,:,:,181),Q(:,127),MT,G3tensor(:,111))
  call loop_AV_Q(G2(:,:,:,174),wf(:,634),G2(:,:,:,182))
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,127),MT,G3tensor(:,112))
  call loop_AV_Q(G2(:,:,:,174),wf(:,783),G2(:,:,:,183))
  call check_last_A_Q(l_switch,G2(:,:,:,183),Q(:,127),MT,G3tensor(:,113))
  call loop_AV_Q(G2(:,:,:,174),wf(:,784),G2(:,:,:,184))
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,127),MT,G3tensor(:,114))
  call loop_AV_Q(G2(:,:,:,174),wf(:,789),G2(:,:,:,185))
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,127),MT,G3tensor(:,115))
  call loop_AV_Q(G2(:,:,:,174),wf(:,790),G2(:,:,:,186))
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,127),MT,G3tensor(:,116))
  call loop_AV_Q(G2(:,:,:,174),wf(:,819),G2(:,:,:,187))
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,127),MT,G3tensor(:,117))
  call loop_AV_Q(G2(:,:,:,174),wf(:,820),G2(:,:,:,188))
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,127),MT,G3tensor(:,118))
  call loop_AV_Q(G2(:,:,:,174),wf(:,825),G2(:,:,:,189))
  call check_last_A_Q(l_switch,G2(:,:,:,189),Q(:,127),MT,G3tensor(:,119))
  call loop_AV_Q(G2(:,:,:,174),wf(:,826),G2(:,:,:,190))
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,127),MT,G3tensor(:,120))
  call loop_AV_Q(G1(:,:,:,43),wf(:,226),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,124),MT,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,1),G2(:,:,:,192))
  call check_last_A_Q(l_switch,G2(:,:,:,192),Q(:,127),MT,G3tensor(:,121))
  call loop_AZ_Q(G2(:,:,:,191),wf(:,11),G2(:,:,:,193),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,193),Q(:,127),MT,G3tensor(:,122))
  call loop_AV_Q(G1(:,:,:,43),wf(:,156),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,60),MT,G2(:,:,:,194))
  call loop_AV_Q(G2(:,:,:,194),wf(:,-6),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,124),MT,G3(:,:,:,62))
  call loop_AV_Q(G3(:,:,:,62),wf(:,1),G3(:,:,:,63))
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,127),MT,G4tensor(:,40))
  call loop_AZ_Q(G3(:,:,:,62),wf(:,11),G3(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),MT,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,43),wf(:,615),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,124),MT,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,1),G2(:,:,:,197))
  call check_last_A_Q(l_switch,G2(:,:,:,197),Q(:,127),MT,G3tensor(:,123))
  call loop_AZ_Q(G2(:,:,:,196),wf(:,11),G2(:,:,:,198),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,198),Q(:,127),MT,G3tensor(:,124))
  call loop_AV_Q(G1(:,:,:,43),wf(:,255),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,124),MT,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,1),G2(:,:,:,200))
  call check_last_A_Q(l_switch,G2(:,:,:,200),Q(:,127),MT,G3tensor(:,125))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,11),G2(:,:,:,201),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,201),Q(:,127),MT,G3tensor(:,126))
  call loop_AV_Q(G1(:,:,:,43),wf(:,259),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,124),MT,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,1),G2(:,:,:,203))
  call check_last_A_Q(l_switch,G2(:,:,:,203),Q(:,127),MT,G3tensor(:,127))
  call loop_AZ_Q(G2(:,:,:,202),wf(:,11),G2(:,:,:,204),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,127),MT,G3tensor(:,128))
  call loop_AV_Q(G1(:,:,:,43),wf(:,157),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,60),MT,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,-6),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,124),MT,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,1),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),MT,G4tensor(:,42))
  call loop_AZ_Q(G3(:,:,:,65),wf(:,11),G3(:,:,:,67),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,127),MT,G4tensor(:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,632),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,124),MT,G2(:,:,:,207))
  call loop_AV_Q(G2(:,:,:,207),wf(:,1),G2(:,:,:,208))
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,127),MT,G3tensor(:,129))
  call loop_AZ_Q(G2(:,:,:,207),wf(:,11),G2(:,:,:,209),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,209),Q(:,127),MT,G3tensor(:,130))
  call loop_AV_Q(G1(:,:,:,43),wf(:,709),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,111),MT,G2(:,:,:,210))
  call loop_AV_Q(G2(:,:,:,210),wf(:,-4),G2(:,:,:,211))
  call check_last_A_Q(l_switch,G2(:,:,:,211),Q(:,127),MT,G3tensor(:,131))
  call loop_AV_Q(G1(:,:,:,43),wf(:,710),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,111),MT,G2(:,:,:,212))
  call loop_AV_Q(G2(:,:,:,212),wf(:,-4),G2(:,:,:,213))
  call check_last_A_Q(l_switch,G2(:,:,:,213),Q(:,127),MT,G3tensor(:,132))
  call loop_AV_Q(G1(:,:,:,43),wf(:,279),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,124),MT,G2(:,:,:,214))
  call loop_AV_Q(G2(:,:,:,214),wf(:,1),G2(:,:,:,215))
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,127),MT,G3tensor(:,133))
  call loop_AZ_Q(G2(:,:,:,214),wf(:,11),G2(:,:,:,216),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,216),Q(:,127),MT,G3tensor(:,134))
  call loop_AV_Q(G1(:,:,:,43),wf(:,280),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,124),MT,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,1),G2(:,:,:,218))
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,127),MT,G3tensor(:,135))
  call loop_AZ_Q(G2(:,:,:,217),wf(:,11),G2(:,:,:,219),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,219),Q(:,127),MT,G3tensor(:,136))
  call loop_AV_Q(G1(:,:,:,43),wf(:,720),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,111),MT,G2(:,:,:,220))
  call loop_AV_Q(G2(:,:,:,220),wf(:,-4),G2(:,:,:,221))
  call check_last_A_Q(l_switch,G2(:,:,:,221),Q(:,127),MT,G3tensor(:,137))
  call loop_AV_Q(G1(:,:,:,43),wf(:,721),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,111),MT,G2(:,:,:,222))
  call loop_AV_Q(G2(:,:,:,222),wf(:,-4),G2(:,:,:,223))
  call check_last_A_Q(l_switch,G2(:,:,:,223),Q(:,127),MT,G3tensor(:,138))
  call loop_AV_Q(G1(:,:,:,43),wf(:,730),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,111),MT,G2(:,:,:,224))
  call loop_AV_Q(G2(:,:,:,224),wf(:,-4),G2(:,:,:,225))
  call check_last_A_Q(l_switch,G2(:,:,:,225),Q(:,127),MT,G3tensor(:,139))
  call loop_AV_Q(G1(:,:,:,43),wf(:,731),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,111),MT,G2(:,:,:,226))
  call loop_AV_Q(G2(:,:,:,226),wf(:,-4),G2(:,:,:,227))
  call check_last_A_Q(l_switch,G2(:,:,:,227),Q(:,127),MT,G3tensor(:,140))
  call loop_AV_Q(G1(:,:,:,43),wf(:,282),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,124),MT,G2(:,:,:,228))
  call loop_AV_Q(G2(:,:,:,228),wf(:,1),G2(:,:,:,229))
  call check_last_A_Q(l_switch,G2(:,:,:,229),Q(:,127),MT,G3tensor(:,141))
  call loop_AZ_Q(G2(:,:,:,228),wf(:,11),G2(:,:,:,230),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,230),Q(:,127),MT,G3tensor(:,142))
  call loop_AV_Q(G1(:,:,:,43),wf(:,283),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,124),MT,G2(:,:,:,231))
  call loop_AV_Q(G2(:,:,:,231),wf(:,1),G2(:,:,:,232))
  call check_last_A_Q(l_switch,G2(:,:,:,232),Q(:,127),MT,G3tensor(:,143))
  call loop_AZ_Q(G2(:,:,:,231),wf(:,11),G2(:,:,:,233),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,233),Q(:,127),MT,G3tensor(:,144))
  call loop_AV_Q(G1(:,:,:,43),wf(:,733),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,111),MT,G2(:,:,:,234))
  call loop_AV_Q(G2(:,:,:,234),wf(:,-4),G2(:,:,:,235))
  call check_last_A_Q(l_switch,G2(:,:,:,235),Q(:,127),MT,G3tensor(:,145))
  call loop_AV_Q(G1(:,:,:,43),wf(:,734),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,111),MT,G2(:,:,:,236))
  call loop_AV_Q(G2(:,:,:,236),wf(:,-4),G2(:,:,:,237))
  call check_last_A_Q(l_switch,G2(:,:,:,237),Q(:,127),MT,G3tensor(:,146))
  call loop_AV_Q(G1(:,:,:,43),wf(:,83),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,112),MT,G2(:,:,:,238))
  call loop_AV_Q(G2(:,:,:,238),wf(:,106),G2(:,:,:,239))
  call check_last_A_Q(l_switch,G2(:,:,:,239),Q(:,127),MT,G3tensor(:,147))
  call loop_AV_Q(G2(:,:,:,238),wf(:,107),G2(:,:,:,240))
  call check_last_A_Q(l_switch,G2(:,:,:,240),Q(:,127),MT,G3tensor(:,148))
  call loop_AV_Q(G2(:,:,:,238),wf(:,108),G2(:,:,:,241))
  call check_last_A_Q(l_switch,G2(:,:,:,241),Q(:,127),MT,G3tensor(:,149))
  call loop_AV_Q(G2(:,:,:,238),wf(:,109),G2(:,:,:,242))
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,127),MT,G3tensor(:,150))
  call loop_AV_Q(G1(:,:,:,43),wf(:,286),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,124),MT,G2(:,:,:,243))
  call loop_AV_Q(G2(:,:,:,243),wf(:,1),G2(:,:,:,244))
  call check_last_A_Q(l_switch,G2(:,:,:,244),Q(:,127),MT,G3tensor(:,151))
  call loop_AZ_Q(G2(:,:,:,243),wf(:,11),G2(:,:,:,245),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,245),Q(:,127),MT,G3tensor(:,152))
  call loop_AV_Q(G1(:,:,:,43),wf(:,287),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,124),MT,G2(:,:,:,246))
  call loop_AV_Q(G2(:,:,:,246),wf(:,1),G2(:,:,:,247))
  call check_last_A_Q(l_switch,G2(:,:,:,247),Q(:,127),MT,G3tensor(:,153))
  call loop_AZ_Q(G2(:,:,:,246),wf(:,11),G2(:,:,:,248),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,127),MT,G3tensor(:,154))
  call loop_AV_Q(G1(:,:,:,43),wf(:,787),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,111),MT,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-4),G2(:,:,:,250))
  call check_last_A_Q(l_switch,G2(:,:,:,250),Q(:,127),MT,G3tensor(:,155))
  call loop_AV_Q(G1(:,:,:,43),wf(:,788),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,111),MT,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,-4),G2(:,:,:,252))
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,127),MT,G3tensor(:,156))
  call loop_AV_Q(G1(:,:,:,43),wf(:,809),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,111),MT,G2(:,:,:,253))
  call loop_AV_Q(G2(:,:,:,253),wf(:,-4),G2(:,:,:,254))
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,127),MT,G3tensor(:,157))
  call loop_AV_Q(G1(:,:,:,43),wf(:,810),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,111),MT,G2(:,:,:,255))
  call loop_AV_Q(G2(:,:,:,255),wf(:,-4),G2(:,:,:,256))
  call check_last_A_Q(l_switch,G2(:,:,:,256),Q(:,127),MT,G3tensor(:,158))
  call loop_AV_Q(G1(:,:,:,43),wf(:,823),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,111),MT,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-4),G2(:,:,:,258))
  call check_last_A_Q(l_switch,G2(:,:,:,258),Q(:,127),MT,G3tensor(:,159))
  call loop_AV_Q(G1(:,:,:,43),wf(:,824),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,111),MT,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-4),G2(:,:,:,260))
  call check_last_A_Q(l_switch,G2(:,:,:,260),Q(:,127),MT,G3tensor(:,160))
  call loop_AV_Q(G1(:,:,:,43),wf(:,829),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,111),MT,G2(:,:,:,261))
  call loop_AV_Q(G2(:,:,:,261),wf(:,-4),G2(:,:,:,262))
  call check_last_A_Q(l_switch,G2(:,:,:,262),Q(:,127),MT,G3tensor(:,161))
  call loop_AV_Q(G1(:,:,:,43),wf(:,830),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,111),MT,G2(:,:,:,263))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-4),G2(:,:,:,264))
  call check_last_A_Q(l_switch,G2(:,:,:,264),Q(:,127),MT,G3tensor(:,162))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,32),MB,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,134),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,124),MB,G2(:,:,:,265))
  call loop_QV_A(G2(:,:,:,265),wf(:,1),G2(:,:,:,266))
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,127),MB,G3tensor(:,163))
  call loop_QZ_A(G2(:,:,:,265),wf(:,11),G2(:,:,:,267),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,267),Q(:,127),MB,G3tensor(:,164))
  call loop_QV_A(G1(:,:,:,85),wf(:,136),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,124),MB,G2(:,:,:,268))
  call loop_QV_A(G2(:,:,:,268),wf(:,1),G2(:,:,:,269))
  call check_last_Q_A(l_switch,G2(:,:,:,269),Q(:,127),MB,G3tensor(:,165))
  call loop_QZ_A(G2(:,:,:,268),wf(:,11),G2(:,:,:,270),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,270),Q(:,127),MB,G3tensor(:,166))
  call loop_QV_A(G1(:,:,:,85),wf(:,137),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,124),MB,G2(:,:,:,271))
  call loop_QV_A(G2(:,:,:,271),wf(:,1),G2(:,:,:,272))
  call check_last_Q_A(l_switch,G2(:,:,:,272),Q(:,127),MB,G3tensor(:,167))
  call loop_QZ_A(G2(:,:,:,271),wf(:,11),G2(:,:,:,273),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,273),Q(:,127),MB,G3tensor(:,168))
  call loop_QV_A(G1(:,:,:,85),wf(:,193),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,124),MB,G2(:,:,:,274))
  call loop_QV_A(G2(:,:,:,274),wf(:,1),G2(:,:,:,275))
  call check_last_Q_A(l_switch,G2(:,:,:,275),Q(:,127),MB,G3tensor(:,169))
  call loop_QZ_A(G2(:,:,:,274),wf(:,11),G2(:,:,:,276),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,276),Q(:,127),MB,G3tensor(:,170))
  call loop_QV_A(G1(:,:,:,85),wf(:,115),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,44),MB,G2(:,:,:,277))
  call loop_QV_A(G2(:,:,:,277),wf(:,83),G2(:,:,:,278))
  call loop_Q_A(G2(:,:,:,278),Q(:,124),MB,G3(:,:,:,68))
  call loop_QV_A(G3(:,:,:,68),wf(:,1),G3(:,:,:,69))
  call check_last_Q_A(l_switch,G3(:,:,:,69),Q(:,127),MB,G4tensor(:,44))
  call loop_QZ_A(G3(:,:,:,68),wf(:,11),G3(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),MB,G4tensor(:,45))
  call loop_QV_A(G2(:,:,:,277),wf(:,-4),G2(:,:,:,279))
  call loop_Q_A(G2(:,:,:,279),Q(:,60),MB,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-6),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,124),MB,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,1),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,127),MB,G5tensor(:,11))
  call loop_QZ_A(G4(:,:,:,15),wf(:,11),G4(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,17),Q(:,127),MB,G5tensor(:,12))
  call loop_QV_A(G1(:,:,:,85),wf(:,194),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,124),MB,G2(:,:,:,280))
  call loop_QV_A(G2(:,:,:,280),wf(:,1),G2(:,:,:,281))
  call check_last_Q_A(l_switch,G2(:,:,:,281),Q(:,127),MB,G3tensor(:,171))
  call loop_QZ_A(G2(:,:,:,280),wf(:,11),G2(:,:,:,282),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,282),Q(:,127),MB,G3tensor(:,172))
  call loop_QV_A(G1(:,:,:,85),wf(:,124),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,60),MB,G2(:,:,:,283))
  call loop_QV_A(G2(:,:,:,283),wf(:,-6),G2(:,:,:,284))
  call loop_Q_A(G2(:,:,:,284),Q(:,124),MB,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,1),G3(:,:,:,74))
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,127),MB,G4tensor(:,46))
  call loop_QZ_A(G3(:,:,:,73),wf(:,11),G3(:,:,:,75),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,127),MB,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,85),wf(:,607),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,124),MB,G2(:,:,:,285))
  call loop_QV_A(G2(:,:,:,285),wf(:,1),G2(:,:,:,286))
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,127),MB,G3tensor(:,173))
  call loop_QZ_A(G2(:,:,:,285),wf(:,11),G2(:,:,:,287),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,287),Q(:,127),MB,G3tensor(:,174))
  call loop_QV_A(G1(:,:,:,85),wf(:,-4),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,48),MB,G2(:,:,:,288))
  call loop_QV_A(G2(:,:,:,288),wf(:,151),G2(:,:,:,289))
  call loop_Q_A(G2(:,:,:,289),Q(:,124),MB,G3(:,:,:,76))
  call loop_QV_A(G3(:,:,:,76),wf(:,1),G3(:,:,:,77))
  call check_last_Q_A(l_switch,G3(:,:,:,77),Q(:,127),MB,G4tensor(:,48))
  call loop_QZ_A(G3(:,:,:,76),wf(:,11),G3(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,127),MB,G4tensor(:,49))
  call loop_QV_A(G2(:,:,:,288),wf(:,115),G2(:,:,:,290))
  call loop_Q_A(G2(:,:,:,290),Q(:,60),MB,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-6),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,124),MB,G4(:,:,:,18))
  call loop_QV_A(G4(:,:,:,18),wf(:,1),G4(:,:,:,19))
  call check_last_Q_A(l_switch,G4(:,:,:,19),Q(:,127),MB,G5tensor(:,13))
  call loop_QZ_A(G4(:,:,:,18),wf(:,11),G4(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,127),MB,G5tensor(:,14))
  call loop_QV_A(G2(:,:,:,288),wf(:,160),G2(:,:,:,291))
  call loop_Q_A(G2(:,:,:,291),Q(:,124),MB,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,1),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),MB,G4tensor(:,50))
  call loop_QZ_A(G3(:,:,:,81),wf(:,11),G3(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,127),MB,G4tensor(:,51))
  call loop_QV_A(G2(:,:,:,288),wf(:,161),G2(:,:,:,292))
  call loop_Q_A(G2(:,:,:,292),Q(:,124),MB,G3(:,:,:,84))
  call loop_QV_A(G3(:,:,:,84),wf(:,1),G3(:,:,:,85))
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,127),MB,G4tensor(:,52))
  call loop_QZ_A(G3(:,:,:,84),wf(:,11),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,127),MB,G4tensor(:,53))
  call loop_QV_A(G2(:,:,:,288),wf(:,-6),G2(:,:,:,293))
  call loop_Q_A(G2(:,:,:,293),Q(:,112),MB,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,106),G3(:,:,:,88))
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,127),MB,G4tensor(:,54))
  call loop_QV_A(G3(:,:,:,87),wf(:,107),G3(:,:,:,89))
  call check_last_Q_A(l_switch,G3(:,:,:,89),Q(:,127),MB,G4tensor(:,55))
  call loop_QV_A(G3(:,:,:,87),wf(:,108),G3(:,:,:,90))
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,127),MB,G4tensor(:,56))
  call loop_QV_A(G3(:,:,:,87),wf(:,109),G3(:,:,:,91))
  call check_last_Q_A(l_switch,G3(:,:,:,91),Q(:,127),MB,G4tensor(:,57))
  call loop_QV_A(G1(:,:,:,85),wf(:,222),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,124),MB,G2(:,:,:,294))
  call loop_QV_A(G2(:,:,:,294),wf(:,1),G2(:,:,:,295))
  call check_last_Q_A(l_switch,G2(:,:,:,295),Q(:,127),MB,G3tensor(:,175))
  call loop_QZ_A(G2(:,:,:,294),wf(:,11),G2(:,:,:,296),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,296),Q(:,127),MB,G3tensor(:,176))
  call loop_QV_A(G1(:,:,:,85),wf(:,-6),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,96),MB,G2(:,:,:,297))
  call loop_QV_A(G2(:,:,:,297),wf(:,609),G2(:,:,:,298))
  call check_last_Q_A(l_switch,G2(:,:,:,298),Q(:,127),MB,G3tensor(:,177))
  call loop_QV_A(G2(:,:,:,297),wf(:,610),G2(:,:,:,299))
  call check_last_Q_A(l_switch,G2(:,:,:,299),Q(:,127),MB,G3tensor(:,178))
  call loop_QV_A(G2(:,:,:,297),wf(:,620),G2(:,:,:,300))
  call check_last_Q_A(l_switch,G2(:,:,:,300),Q(:,127),MB,G3tensor(:,179))
  call loop_QV_A(G2(:,:,:,297),wf(:,621),G2(:,:,:,301))
  call check_last_Q_A(l_switch,G2(:,:,:,301),Q(:,127),MB,G3tensor(:,180))
  call loop_QV_A(G2(:,:,:,297),wf(:,630),G2(:,:,:,302))
  call check_last_Q_A(l_switch,G2(:,:,:,302),Q(:,127),MB,G3tensor(:,181))
  call loop_QV_A(G2(:,:,:,297),wf(:,631),G2(:,:,:,303))
  call check_last_Q_A(l_switch,G2(:,:,:,303),Q(:,127),MB,G3tensor(:,182))
  call loop_QV_A(G2(:,:,:,297),wf(:,633),G2(:,:,:,304))
  call check_last_Q_A(l_switch,G2(:,:,:,304),Q(:,127),MB,G3tensor(:,183))
  call loop_QV_A(G2(:,:,:,297),wf(:,634),G2(:,:,:,305))
  call check_last_Q_A(l_switch,G2(:,:,:,305),Q(:,127),MB,G3tensor(:,184))
  call loop_QV_A(G2(:,:,:,297),wf(:,783),G2(:,:,:,306))
  call check_last_Q_A(l_switch,G2(:,:,:,306),Q(:,127),MB,G3tensor(:,185))
  call loop_QV_A(G2(:,:,:,297),wf(:,784),G2(:,:,:,307))
  call check_last_Q_A(l_switch,G2(:,:,:,307),Q(:,127),MB,G3tensor(:,186))
  call loop_QV_A(G2(:,:,:,297),wf(:,789),G2(:,:,:,308))
  call check_last_Q_A(l_switch,G2(:,:,:,308),Q(:,127),MB,G3tensor(:,187))
  call loop_QV_A(G2(:,:,:,297),wf(:,790),G2(:,:,:,309))
  call check_last_Q_A(l_switch,G2(:,:,:,309),Q(:,127),MB,G3tensor(:,188))
  call loop_QV_A(G2(:,:,:,297),wf(:,819),G2(:,:,:,310))
  call check_last_Q_A(l_switch,G2(:,:,:,310),Q(:,127),MB,G3tensor(:,189))
  call loop_QV_A(G2(:,:,:,297),wf(:,820),G2(:,:,:,311))
  call check_last_Q_A(l_switch,G2(:,:,:,311),Q(:,127),MB,G3tensor(:,190))
  call loop_QV_A(G2(:,:,:,297),wf(:,825),G2(:,:,:,312))
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,127),MB,G3tensor(:,191))
  call loop_QV_A(G2(:,:,:,297),wf(:,826),G2(:,:,:,313))
  call check_last_Q_A(l_switch,G2(:,:,:,313),Q(:,127),MB,G3tensor(:,192))
  call loop_QV_A(G1(:,:,:,85),wf(:,226),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,124),MB,G2(:,:,:,314))
  call loop_QV_A(G2(:,:,:,314),wf(:,1),G2(:,:,:,315))
  call check_last_Q_A(l_switch,G2(:,:,:,315),Q(:,127),MB,G3tensor(:,193))
  call loop_QZ_A(G2(:,:,:,314),wf(:,11),G2(:,:,:,316),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,316),Q(:,127),MB,G3tensor(:,194))
  call loop_QV_A(G1(:,:,:,85),wf(:,156),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,60),MB,G2(:,:,:,317))
  call loop_QV_A(G2(:,:,:,317),wf(:,-6),G2(:,:,:,318))
  call loop_Q_A(G2(:,:,:,318),Q(:,124),MB,G3(:,:,:,92))
  call loop_QV_A(G3(:,:,:,92),wf(:,1),G3(:,:,:,93))
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,127),MB,G4tensor(:,58))
  call loop_QZ_A(G3(:,:,:,92),wf(:,11),G3(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,127),MB,G4tensor(:,59))
  call loop_QV_A(G1(:,:,:,85),wf(:,615),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,124),MB,G2(:,:,:,319))
  call loop_QV_A(G2(:,:,:,319),wf(:,1),G2(:,:,:,320))
  call check_last_Q_A(l_switch,G2(:,:,:,320),Q(:,127),MB,G3tensor(:,195))
  call loop_QZ_A(G2(:,:,:,319),wf(:,11),G2(:,:,:,321),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,321),Q(:,127),MB,G3tensor(:,196))
  call loop_QV_A(G1(:,:,:,85),wf(:,255),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,124),MB,G2(:,:,:,322))
  call loop_QV_A(G2(:,:,:,322),wf(:,1),G2(:,:,:,323))
  call check_last_Q_A(l_switch,G2(:,:,:,323),Q(:,127),MB,G3tensor(:,197))
  call loop_QZ_A(G2(:,:,:,322),wf(:,11),G2(:,:,:,324),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,324),Q(:,127),MB,G3tensor(:,198))
  call loop_QV_A(G1(:,:,:,85),wf(:,259),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,124),MB,G2(:,:,:,325))
  call loop_QV_A(G2(:,:,:,325),wf(:,1),G2(:,:,:,326))
  call check_last_Q_A(l_switch,G2(:,:,:,326),Q(:,127),MB,G3tensor(:,199))
  call loop_QZ_A(G2(:,:,:,325),wf(:,11),G2(:,:,:,327),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,327),Q(:,127),MB,G3tensor(:,200))
  call loop_QV_A(G1(:,:,:,85),wf(:,157),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,60),MB,G2(:,:,:,328))
  call loop_QV_A(G2(:,:,:,328),wf(:,-6),G2(:,:,:,329))
  call loop_Q_A(G2(:,:,:,329),Q(:,124),MB,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,1),G3(:,:,:,96))
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,127),MB,G4tensor(:,60))
  call loop_QZ_A(G3(:,:,:,95),wf(:,11),G3(:,:,:,97),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,127),MB,G4tensor(:,61))
  call loop_QV_A(G1(:,:,:,85),wf(:,632),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,124),MB,G2(:,:,:,330))
  call loop_QV_A(G2(:,:,:,330),wf(:,1),G2(:,:,:,331))
  call check_last_Q_A(l_switch,G2(:,:,:,331),Q(:,127),MB,G3tensor(:,201))
  call loop_QZ_A(G2(:,:,:,330),wf(:,11),G2(:,:,:,332),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,332),Q(:,127),MB,G3tensor(:,202))
  call loop_QV_A(G1(:,:,:,85),wf(:,709),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,111),MB,G2(:,:,:,333))
  call loop_QV_A(G2(:,:,:,333),wf(:,-4),G2(:,:,:,334))
  call check_last_Q_A(l_switch,G2(:,:,:,334),Q(:,127),MB,G3tensor(:,203))
  call loop_QV_A(G1(:,:,:,85),wf(:,710),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,111),MB,G2(:,:,:,335))
  call loop_QV_A(G2(:,:,:,335),wf(:,-4),G2(:,:,:,336))
  call check_last_Q_A(l_switch,G2(:,:,:,336),Q(:,127),MB,G3tensor(:,204))
  call loop_QV_A(G1(:,:,:,85),wf(:,279),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,124),MB,G2(:,:,:,337))
  call loop_QV_A(G2(:,:,:,337),wf(:,1),G2(:,:,:,338))
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,127),MB,G3tensor(:,205))
  call loop_QZ_A(G2(:,:,:,337),wf(:,11),G2(:,:,:,339),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,339),Q(:,127),MB,G3tensor(:,206))
  call loop_QV_A(G1(:,:,:,85),wf(:,280),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,124),MB,G2(:,:,:,340))
  call loop_QV_A(G2(:,:,:,340),wf(:,1),G2(:,:,:,341))
  call check_last_Q_A(l_switch,G2(:,:,:,341),Q(:,127),MB,G3tensor(:,207))
  call loop_QZ_A(G2(:,:,:,340),wf(:,11),G2(:,:,:,342),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,342),Q(:,127),MB,G3tensor(:,208))
  call loop_QV_A(G1(:,:,:,85),wf(:,720),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,111),MB,G2(:,:,:,343))
  call loop_QV_A(G2(:,:,:,343),wf(:,-4),G2(:,:,:,344))
  call check_last_Q_A(l_switch,G2(:,:,:,344),Q(:,127),MB,G3tensor(:,209))
  call loop_QV_A(G1(:,:,:,85),wf(:,721),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,111),MB,G2(:,:,:,345))
  call loop_QV_A(G2(:,:,:,345),wf(:,-4),G2(:,:,:,346))
  call check_last_Q_A(l_switch,G2(:,:,:,346),Q(:,127),MB,G3tensor(:,210))
  call loop_QV_A(G1(:,:,:,85),wf(:,730),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,111),MB,G2(:,:,:,347))
  call loop_QV_A(G2(:,:,:,347),wf(:,-4),G2(:,:,:,348))
  call check_last_Q_A(l_switch,G2(:,:,:,348),Q(:,127),MB,G3tensor(:,211))
  call loop_QV_A(G1(:,:,:,85),wf(:,731),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,111),MB,G2(:,:,:,349))
  call loop_QV_A(G2(:,:,:,349),wf(:,-4),G2(:,:,:,350))
  call check_last_Q_A(l_switch,G2(:,:,:,350),Q(:,127),MB,G3tensor(:,212))
  call loop_QV_A(G1(:,:,:,85),wf(:,282),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,124),MB,G2(:,:,:,351))
  call loop_QV_A(G2(:,:,:,351),wf(:,1),G2(:,:,:,352))
  call check_last_Q_A(l_switch,G2(:,:,:,352),Q(:,127),MB,G3tensor(:,213))
  call loop_QZ_A(G2(:,:,:,351),wf(:,11),G2(:,:,:,353),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,353),Q(:,127),MB,G3tensor(:,214))
  call loop_QV_A(G1(:,:,:,85),wf(:,283),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,124),MB,G2(:,:,:,354))
  call loop_QV_A(G2(:,:,:,354),wf(:,1),G2(:,:,:,355))
  call check_last_Q_A(l_switch,G2(:,:,:,355),Q(:,127),MB,G3tensor(:,215))
  call loop_QZ_A(G2(:,:,:,354),wf(:,11),G2(:,:,:,356),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,356),Q(:,127),MB,G3tensor(:,216))
  call loop_QV_A(G1(:,:,:,85),wf(:,733),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,111),MB,G2(:,:,:,357))
  call loop_QV_A(G2(:,:,:,357),wf(:,-4),G2(:,:,:,358))
  call check_last_Q_A(l_switch,G2(:,:,:,358),Q(:,127),MB,G3tensor(:,217))
  call loop_QV_A(G1(:,:,:,85),wf(:,734),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,111),MB,G2(:,:,:,359))
  call loop_QV_A(G2(:,:,:,359),wf(:,-4),G2(:,:,:,360))
  call check_last_Q_A(l_switch,G2(:,:,:,360),Q(:,127),MB,G3tensor(:,218))
  call loop_QV_A(G1(:,:,:,85),wf(:,83),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,112),MB,G2(:,:,:,361))
  call loop_QV_A(G2(:,:,:,361),wf(:,106),G2(:,:,:,362))
  call check_last_Q_A(l_switch,G2(:,:,:,362),Q(:,127),MB,G3tensor(:,219))
  call loop_QV_A(G2(:,:,:,361),wf(:,107),G2(:,:,:,363))
  call check_last_Q_A(l_switch,G2(:,:,:,363),Q(:,127),MB,G3tensor(:,220))
  call loop_QV_A(G2(:,:,:,361),wf(:,108),G2(:,:,:,364))
  call check_last_Q_A(l_switch,G2(:,:,:,364),Q(:,127),MB,G3tensor(:,221))
  call loop_QV_A(G2(:,:,:,361),wf(:,109),G2(:,:,:,365))
  call check_last_Q_A(l_switch,G2(:,:,:,365),Q(:,127),MB,G3tensor(:,222))
  call loop_QV_A(G1(:,:,:,85),wf(:,286),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,124),MB,G2(:,:,:,366))
  call loop_QV_A(G2(:,:,:,366),wf(:,1),G2(:,:,:,367))
  call check_last_Q_A(l_switch,G2(:,:,:,367),Q(:,127),MB,G3tensor(:,223))
  call loop_QZ_A(G2(:,:,:,366),wf(:,11),G2(:,:,:,368),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,368),Q(:,127),MB,G3tensor(:,224))
  call loop_QV_A(G1(:,:,:,85),wf(:,287),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,124),MB,G2(:,:,:,369))
  call loop_QV_A(G2(:,:,:,369),wf(:,1),G2(:,:,:,370))
  call check_last_Q_A(l_switch,G2(:,:,:,370),Q(:,127),MB,G3tensor(:,225))
  call loop_QZ_A(G2(:,:,:,369),wf(:,11),G2(:,:,:,371),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,371),Q(:,127),MB,G3tensor(:,226))
  call loop_QV_A(G1(:,:,:,85),wf(:,787),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,111),MB,G2(:,:,:,372))
  call loop_QV_A(G2(:,:,:,372),wf(:,-4),G2(:,:,:,373))
  call check_last_Q_A(l_switch,G2(:,:,:,373),Q(:,127),MB,G3tensor(:,227))
  call loop_QV_A(G1(:,:,:,85),wf(:,788),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,111),MB,G2(:,:,:,374))
  call loop_QV_A(G2(:,:,:,374),wf(:,-4),G2(:,:,:,375))
  call check_last_Q_A(l_switch,G2(:,:,:,375),Q(:,127),MB,G3tensor(:,228))
  call loop_QV_A(G1(:,:,:,85),wf(:,809),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,111),MB,G2(:,:,:,376))
  call loop_QV_A(G2(:,:,:,376),wf(:,-4),G2(:,:,:,377))
  call check_last_Q_A(l_switch,G2(:,:,:,377),Q(:,127),MB,G3tensor(:,229))
  call loop_QV_A(G1(:,:,:,85),wf(:,810),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,111),MB,G2(:,:,:,378))
  call loop_QV_A(G2(:,:,:,378),wf(:,-4),G2(:,:,:,379))
  call check_last_Q_A(l_switch,G2(:,:,:,379),Q(:,127),MB,G3tensor(:,230))
  call loop_QV_A(G1(:,:,:,85),wf(:,823),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,111),MB,G2(:,:,:,380))
  call loop_QV_A(G2(:,:,:,380),wf(:,-4),G2(:,:,:,381))
  call check_last_Q_A(l_switch,G2(:,:,:,381),Q(:,127),MB,G3tensor(:,231))
  call loop_QV_A(G1(:,:,:,85),wf(:,824),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,111),MB,G2(:,:,:,382))
  call loop_QV_A(G2(:,:,:,382),wf(:,-4),G2(:,:,:,383))
  call check_last_Q_A(l_switch,G2(:,:,:,383),Q(:,127),MB,G3tensor(:,232))
  call loop_QV_A(G1(:,:,:,85),wf(:,829),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,111),MB,G2(:,:,:,384))
  call loop_QV_A(G2(:,:,:,384),wf(:,-4),G2(:,:,:,385))
  call check_last_Q_A(l_switch,G2(:,:,:,385),Q(:,127),MB,G3tensor(:,233))
  call loop_QV_A(G1(:,:,:,85),wf(:,830),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,111),MB,G2(:,:,:,386))
  call loop_QV_A(G2(:,:,:,386),wf(:,-4),G2(:,:,:,387))
  call check_last_Q_A(l_switch,G2(:,:,:,387),Q(:,127),MB,G3tensor(:,234))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,32),MB,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,134),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,124),MB,G2(:,:,:,388))
  call loop_AV_Q(G2(:,:,:,388),wf(:,1),G2(:,:,:,389))
  call check_last_A_Q(l_switch,G2(:,:,:,389),Q(:,127),MB,G3tensor(:,235))
  call loop_AZ_Q(G2(:,:,:,388),wf(:,11),G2(:,:,:,390),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,390),Q(:,127),MB,G3tensor(:,236))
  call loop_AV_Q(G1(:,:,:,127),wf(:,136),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,124),MB,G2(:,:,:,391))
  call loop_AV_Q(G2(:,:,:,391),wf(:,1),G2(:,:,:,392))
  call check_last_A_Q(l_switch,G2(:,:,:,392),Q(:,127),MB,G3tensor(:,237))
  call loop_AZ_Q(G2(:,:,:,391),wf(:,11),G2(:,:,:,393),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,393),Q(:,127),MB,G3tensor(:,238))
  call loop_AV_Q(G1(:,:,:,127),wf(:,137),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,124),MB,G2(:,:,:,394))
  call loop_AV_Q(G2(:,:,:,394),wf(:,1),G2(:,:,:,395))
  call check_last_A_Q(l_switch,G2(:,:,:,395),Q(:,127),MB,G3tensor(:,239))
  call loop_AZ_Q(G2(:,:,:,394),wf(:,11),G2(:,:,:,396),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,396),Q(:,127),MB,G3tensor(:,240))
  call loop_AV_Q(G1(:,:,:,127),wf(:,193),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,124),MB,G2(:,:,:,397))
  call loop_AV_Q(G2(:,:,:,397),wf(:,1),G2(:,:,:,398))
  call check_last_A_Q(l_switch,G2(:,:,:,398),Q(:,127),MB,G3tensor(:,241))
  call loop_AZ_Q(G2(:,:,:,397),wf(:,11),G2(:,:,:,399),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,399),Q(:,127),MB,G3tensor(:,242))
  call loop_AV_Q(G1(:,:,:,127),wf(:,115),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,44),MB,G2(:,:,:,400))
  call loop_AV_Q(G2(:,:,:,400),wf(:,83),G2(:,:,:,401))
  call loop_A_Q(G2(:,:,:,401),Q(:,124),MB,G3(:,:,:,98))
  call loop_AV_Q(G3(:,:,:,98),wf(:,1),G3(:,:,:,99))
  call check_last_A_Q(l_switch,G3(:,:,:,99),Q(:,127),MB,G4tensor(:,62))
  call loop_AZ_Q(G3(:,:,:,98),wf(:,11),G3(:,:,:,100),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,127),MB,G4tensor(:,63))
  call loop_AV_Q(G2(:,:,:,400),wf(:,-4),G2(:,:,:,402))
  call loop_A_Q(G2(:,:,:,402),Q(:,60),MB,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-6),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,124),MB,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,1),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),MB,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,11),G4(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),MB,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,127),wf(:,194),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,124),MB,G2(:,:,:,403))
  call loop_AV_Q(G2(:,:,:,403),wf(:,1),G2(:,:,:,404))
  call check_last_A_Q(l_switch,G2(:,:,:,404),Q(:,127),MB,G3tensor(:,243))
  call loop_AZ_Q(G2(:,:,:,403),wf(:,11),G2(:,:,:,405),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,405),Q(:,127),MB,G3tensor(:,244))
  call loop_AV_Q(G1(:,:,:,127),wf(:,124),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,60),MB,G2(:,:,:,406))
  call loop_AV_Q(G2(:,:,:,406),wf(:,-6),G2(:,:,:,407))
  call loop_A_Q(G2(:,:,:,407),Q(:,124),MB,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,1),G3(:,:,:,104))
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,127),MB,G4tensor(:,64))
  call loop_AZ_Q(G3(:,:,:,103),wf(:,11),G3(:,:,:,105),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,105),Q(:,127),MB,G4tensor(:,65))
  call loop_AV_Q(G1(:,:,:,127),wf(:,607),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,124),MB,G2(:,:,:,408))
  call loop_AV_Q(G2(:,:,:,408),wf(:,1),G2(:,:,:,409))
  call check_last_A_Q(l_switch,G2(:,:,:,409),Q(:,127),MB,G3tensor(:,245))
  call loop_AZ_Q(G2(:,:,:,408),wf(:,11),G2(:,:,:,410),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,410),Q(:,127),MB,G3tensor(:,246))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-4),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,48),MB,G2(:,:,:,411))
  call loop_AV_Q(G2(:,:,:,411),wf(:,151),G2(:,:,:,412))
  call loop_A_Q(G2(:,:,:,412),Q(:,124),MB,G3(:,:,:,106))
  call loop_AV_Q(G3(:,:,:,106),wf(:,1),G3(:,:,:,107))
  call check_last_A_Q(l_switch,G3(:,:,:,107),Q(:,127),MB,G4tensor(:,66))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,11),G3(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,127),MB,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,411),wf(:,115),G2(:,:,:,413))
  call loop_A_Q(G2(:,:,:,413),Q(:,60),MB,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-6),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,124),MB,G4(:,:,:,24))
  call loop_AV_Q(G4(:,:,:,24),wf(:,1),G4(:,:,:,25))
  call check_last_A_Q(l_switch,G4(:,:,:,25),Q(:,127),MB,G5tensor(:,17))
  call loop_AZ_Q(G4(:,:,:,24),wf(:,11),G4(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MB,G5tensor(:,18))
  call loop_AV_Q(G2(:,:,:,411),wf(:,160),G2(:,:,:,414))
  call loop_A_Q(G2(:,:,:,414),Q(:,124),MB,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,1),G3(:,:,:,112))
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,127),MB,G4tensor(:,68))
  call loop_AZ_Q(G3(:,:,:,111),wf(:,11),G3(:,:,:,113),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,113),Q(:,127),MB,G4tensor(:,69))
  call loop_AV_Q(G2(:,:,:,411),wf(:,161),G2(:,:,:,415))
  call loop_A_Q(G2(:,:,:,415),Q(:,124),MB,G3(:,:,:,114))
  call loop_AV_Q(G3(:,:,:,114),wf(:,1),G3(:,:,:,115))
  call check_last_A_Q(l_switch,G3(:,:,:,115),Q(:,127),MB,G4tensor(:,70))
  call loop_AZ_Q(G3(:,:,:,114),wf(:,11),G3(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),MB,G4tensor(:,71))
  call loop_AV_Q(G2(:,:,:,411),wf(:,-6),G2(:,:,:,416))
  call loop_A_Q(G2(:,:,:,416),Q(:,112),MB,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,106),G3(:,:,:,118))
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,127),MB,G4tensor(:,72))
  call loop_AV_Q(G3(:,:,:,117),wf(:,107),G3(:,:,:,119))
  call check_last_A_Q(l_switch,G3(:,:,:,119),Q(:,127),MB,G4tensor(:,73))
  call loop_AV_Q(G3(:,:,:,117),wf(:,108),G3(:,:,:,120))
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,127),MB,G4tensor(:,74))
  call loop_AV_Q(G3(:,:,:,117),wf(:,109),G3(:,:,:,121))
  call check_last_A_Q(l_switch,G3(:,:,:,121),Q(:,127),MB,G4tensor(:,75))
  call loop_AV_Q(G1(:,:,:,127),wf(:,222),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,124),MB,G2(:,:,:,417))
  call loop_AV_Q(G2(:,:,:,417),wf(:,1),G2(:,:,:,418))
  call check_last_A_Q(l_switch,G2(:,:,:,418),Q(:,127),MB,G3tensor(:,247))
  call loop_AZ_Q(G2(:,:,:,417),wf(:,11),G2(:,:,:,419),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,419),Q(:,127),MB,G3tensor(:,248))
  call loop_AV_Q(G1(:,:,:,127),wf(:,-6),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,96),MB,G2(:,:,:,420))
  call loop_AV_Q(G2(:,:,:,420),wf(:,609),G2(:,:,:,421))
  call check_last_A_Q(l_switch,G2(:,:,:,421),Q(:,127),MB,G3tensor(:,249))
  call loop_AV_Q(G2(:,:,:,420),wf(:,610),G2(:,:,:,422))
  call check_last_A_Q(l_switch,G2(:,:,:,422),Q(:,127),MB,G3tensor(:,250))
  call loop_AV_Q(G2(:,:,:,420),wf(:,620),G2(:,:,:,423))
  call check_last_A_Q(l_switch,G2(:,:,:,423),Q(:,127),MB,G3tensor(:,251))
  call loop_AV_Q(G2(:,:,:,420),wf(:,621),G2(:,:,:,424))
  call check_last_A_Q(l_switch,G2(:,:,:,424),Q(:,127),MB,G3tensor(:,252))
  call loop_AV_Q(G2(:,:,:,420),wf(:,630),G2(:,:,:,425))
  call check_last_A_Q(l_switch,G2(:,:,:,425),Q(:,127),MB,G3tensor(:,253))
  call loop_AV_Q(G2(:,:,:,420),wf(:,631),G2(:,:,:,426))
  call check_last_A_Q(l_switch,G2(:,:,:,426),Q(:,127),MB,G3tensor(:,254))
  call loop_AV_Q(G2(:,:,:,420),wf(:,633),G2(:,:,:,427))
  call check_last_A_Q(l_switch,G2(:,:,:,427),Q(:,127),MB,G3tensor(:,255))
  call loop_AV_Q(G2(:,:,:,420),wf(:,634),G2(:,:,:,428))
  call check_last_A_Q(l_switch,G2(:,:,:,428),Q(:,127),MB,G3tensor(:,256))
  call loop_AV_Q(G2(:,:,:,420),wf(:,783),G2(:,:,:,429))
  call check_last_A_Q(l_switch,G2(:,:,:,429),Q(:,127),MB,G3tensor(:,257))
  call loop_AV_Q(G2(:,:,:,420),wf(:,784),G2(:,:,:,430))
  call check_last_A_Q(l_switch,G2(:,:,:,430),Q(:,127),MB,G3tensor(:,258))
  call loop_AV_Q(G2(:,:,:,420),wf(:,789),G2(:,:,:,431))
  call check_last_A_Q(l_switch,G2(:,:,:,431),Q(:,127),MB,G3tensor(:,259))
  call loop_AV_Q(G2(:,:,:,420),wf(:,790),G2(:,:,:,432))
  call check_last_A_Q(l_switch,G2(:,:,:,432),Q(:,127),MB,G3tensor(:,260))
  call loop_AV_Q(G2(:,:,:,420),wf(:,819),G2(:,:,:,433))
  call check_last_A_Q(l_switch,G2(:,:,:,433),Q(:,127),MB,G3tensor(:,261))
  call loop_AV_Q(G2(:,:,:,420),wf(:,820),G2(:,:,:,434))
  call check_last_A_Q(l_switch,G2(:,:,:,434),Q(:,127),MB,G3tensor(:,262))
  call loop_AV_Q(G2(:,:,:,420),wf(:,825),G2(:,:,:,435))
  call check_last_A_Q(l_switch,G2(:,:,:,435),Q(:,127),MB,G3tensor(:,263))
  call loop_AV_Q(G2(:,:,:,420),wf(:,826),G2(:,:,:,436))
  call check_last_A_Q(l_switch,G2(:,:,:,436),Q(:,127),MB,G3tensor(:,264))
  call loop_AV_Q(G1(:,:,:,127),wf(:,226),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,124),MB,G2(:,:,:,437))
  call loop_AV_Q(G2(:,:,:,437),wf(:,1),G2(:,:,:,438))
  call check_last_A_Q(l_switch,G2(:,:,:,438),Q(:,127),MB,G3tensor(:,265))
  call loop_AZ_Q(G2(:,:,:,437),wf(:,11),G2(:,:,:,439),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,439),Q(:,127),MB,G3tensor(:,266))
  call loop_AV_Q(G1(:,:,:,127),wf(:,156),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,60),MB,G2(:,:,:,440))
  call loop_AV_Q(G2(:,:,:,440),wf(:,-6),G2(:,:,:,441))
  call loop_A_Q(G2(:,:,:,441),Q(:,124),MB,G3(:,:,:,122))
  call loop_AV_Q(G3(:,:,:,122),wf(:,1),G3(:,:,:,123))
  call check_last_A_Q(l_switch,G3(:,:,:,123),Q(:,127),MB,G4tensor(:,76))
  call loop_AZ_Q(G3(:,:,:,122),wf(:,11),G3(:,:,:,124),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,124),Q(:,127),MB,G4tensor(:,77))
  call loop_AV_Q(G1(:,:,:,127),wf(:,615),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,124),MB,G2(:,:,:,442))
  call loop_AV_Q(G2(:,:,:,442),wf(:,1),G2(:,:,:,443))
  call check_last_A_Q(l_switch,G2(:,:,:,443),Q(:,127),MB,G3tensor(:,267))
  call loop_AZ_Q(G2(:,:,:,442),wf(:,11),G2(:,:,:,444),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,444),Q(:,127),MB,G3tensor(:,268))
  call loop_AV_Q(G1(:,:,:,127),wf(:,255),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,124),MB,G2(:,:,:,445))
  call loop_AV_Q(G2(:,:,:,445),wf(:,1),G2(:,:,:,446))
  call check_last_A_Q(l_switch,G2(:,:,:,446),Q(:,127),MB,G3tensor(:,269))
  call loop_AZ_Q(G2(:,:,:,445),wf(:,11),G2(:,:,:,447),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,447),Q(:,127),MB,G3tensor(:,270))
  call loop_AV_Q(G1(:,:,:,127),wf(:,259),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,124),MB,G2(:,:,:,448))
  call loop_AV_Q(G2(:,:,:,448),wf(:,1),G2(:,:,:,449))
  call check_last_A_Q(l_switch,G2(:,:,:,449),Q(:,127),MB,G3tensor(:,271))
  call loop_AZ_Q(G2(:,:,:,448),wf(:,11),G2(:,:,:,450),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,450),Q(:,127),MB,G3tensor(:,272))
  call loop_AV_Q(G1(:,:,:,127),wf(:,157),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,60),MB,G2(:,:,:,451))
  call loop_AV_Q(G2(:,:,:,451),wf(:,-6),G2(:,:,:,452))
  call loop_A_Q(G2(:,:,:,452),Q(:,124),MB,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,1),G3(:,:,:,126))
  call check_last_A_Q(l_switch,G3(:,:,:,126),Q(:,127),MB,G4tensor(:,78))
  call loop_AZ_Q(G3(:,:,:,125),wf(:,11),G3(:,:,:,127),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,127),Q(:,127),MB,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,127),wf(:,632),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,124),MB,G2(:,:,:,453))
  call loop_AV_Q(G2(:,:,:,453),wf(:,1),G2(:,:,:,454))
  call check_last_A_Q(l_switch,G2(:,:,:,454),Q(:,127),MB,G3tensor(:,273))
  call loop_AZ_Q(G2(:,:,:,453),wf(:,11),G2(:,:,:,455),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,455),Q(:,127),MB,G3tensor(:,274))
  call loop_AV_Q(G1(:,:,:,127),wf(:,709),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,111),MB,G2(:,:,:,456))
  call loop_AV_Q(G2(:,:,:,456),wf(:,-4),G2(:,:,:,457))
  call check_last_A_Q(l_switch,G2(:,:,:,457),Q(:,127),MB,G3tensor(:,275))
  call loop_AV_Q(G1(:,:,:,127),wf(:,710),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,111),MB,G2(:,:,:,458))
  call loop_AV_Q(G2(:,:,:,458),wf(:,-4),G2(:,:,:,459))
  call check_last_A_Q(l_switch,G2(:,:,:,459),Q(:,127),MB,G3tensor(:,276))
  call loop_AV_Q(G1(:,:,:,127),wf(:,279),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,124),MB,G2(:,:,:,460))
  call loop_AV_Q(G2(:,:,:,460),wf(:,1),G2(:,:,:,461))
  call check_last_A_Q(l_switch,G2(:,:,:,461),Q(:,127),MB,G3tensor(:,277))
  call loop_AZ_Q(G2(:,:,:,460),wf(:,11),G2(:,:,:,462),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,462),Q(:,127),MB,G3tensor(:,278))
  call loop_AV_Q(G1(:,:,:,127),wf(:,280),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,124),MB,G2(:,:,:,463))
  call loop_AV_Q(G2(:,:,:,463),wf(:,1),G2(:,:,:,464))
  call check_last_A_Q(l_switch,G2(:,:,:,464),Q(:,127),MB,G3tensor(:,279))
  call loop_AZ_Q(G2(:,:,:,463),wf(:,11),G2(:,:,:,465),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,465),Q(:,127),MB,G3tensor(:,280))
  call loop_AV_Q(G1(:,:,:,127),wf(:,720),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,111),MB,G2(:,:,:,466))
  call loop_AV_Q(G2(:,:,:,466),wf(:,-4),G2(:,:,:,467))
  call check_last_A_Q(l_switch,G2(:,:,:,467),Q(:,127),MB,G3tensor(:,281))
  call loop_AV_Q(G1(:,:,:,127),wf(:,721),G1(:,:,:,151))
  call loop_A_Q(G1(:,:,:,151),Q(:,111),MB,G2(:,:,:,468))
  call loop_AV_Q(G2(:,:,:,468),wf(:,-4),G2(:,:,:,469))
  call check_last_A_Q(l_switch,G2(:,:,:,469),Q(:,127),MB,G3tensor(:,282))
  call loop_AV_Q(G1(:,:,:,127),wf(:,730),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,111),MB,G2(:,:,:,470))
  call loop_AV_Q(G2(:,:,:,470),wf(:,-4),G2(:,:,:,471))
  call check_last_A_Q(l_switch,G2(:,:,:,471),Q(:,127),MB,G3tensor(:,283))
  call loop_AV_Q(G1(:,:,:,127),wf(:,731),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,111),MB,G2(:,:,:,472))
  call loop_AV_Q(G2(:,:,:,472),wf(:,-4),G2(:,:,:,473))
  call check_last_A_Q(l_switch,G2(:,:,:,473),Q(:,127),MB,G3tensor(:,284))
  call loop_AV_Q(G1(:,:,:,127),wf(:,282),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,124),MB,G2(:,:,:,474))
  call loop_AV_Q(G2(:,:,:,474),wf(:,1),G2(:,:,:,475))
  call check_last_A_Q(l_switch,G2(:,:,:,475),Q(:,127),MB,G3tensor(:,285))
  call loop_AZ_Q(G2(:,:,:,474),wf(:,11),G2(:,:,:,476),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,476),Q(:,127),MB,G3tensor(:,286))
  call loop_AV_Q(G1(:,:,:,127),wf(:,283),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,124),MB,G2(:,:,:,477))
  call loop_AV_Q(G2(:,:,:,477),wf(:,1),G2(:,:,:,478))
  call check_last_A_Q(l_switch,G2(:,:,:,478),Q(:,127),MB,G3tensor(:,287))
  call loop_AZ_Q(G2(:,:,:,477),wf(:,11),G2(:,:,:,479),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,479),Q(:,127),MB,G3tensor(:,288))
  call loop_AV_Q(G1(:,:,:,127),wf(:,733),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,111),MB,G2(:,:,:,480))
  call loop_AV_Q(G2(:,:,:,480),wf(:,-4),G2(:,:,:,481))
  call check_last_A_Q(l_switch,G2(:,:,:,481),Q(:,127),MB,G3tensor(:,289))
  call loop_AV_Q(G1(:,:,:,127),wf(:,734),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,111),MB,G2(:,:,:,482))
  call loop_AV_Q(G2(:,:,:,482),wf(:,-4),G2(:,:,:,483))
  call check_last_A_Q(l_switch,G2(:,:,:,483),Q(:,127),MB,G3tensor(:,290))
  call loop_AV_Q(G1(:,:,:,127),wf(:,83),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,112),MB,G2(:,:,:,484))
  call loop_AV_Q(G2(:,:,:,484),wf(:,106),G2(:,:,:,485))
  call check_last_A_Q(l_switch,G2(:,:,:,485),Q(:,127),MB,G3tensor(:,291))
  call loop_AV_Q(G2(:,:,:,484),wf(:,107),G2(:,:,:,486))
  call check_last_A_Q(l_switch,G2(:,:,:,486),Q(:,127),MB,G3tensor(:,292))
  call loop_AV_Q(G2(:,:,:,484),wf(:,108),G2(:,:,:,487))
  call check_last_A_Q(l_switch,G2(:,:,:,487),Q(:,127),MB,G3tensor(:,293))
  call loop_AV_Q(G2(:,:,:,484),wf(:,109),G2(:,:,:,488))
  call check_last_A_Q(l_switch,G2(:,:,:,488),Q(:,127),MB,G3tensor(:,294))
  call loop_AV_Q(G1(:,:,:,127),wf(:,286),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,124),MB,G2(:,:,:,489))
  call loop_AV_Q(G2(:,:,:,489),wf(:,1),G2(:,:,:,490))
  call check_last_A_Q(l_switch,G2(:,:,:,490),Q(:,127),MB,G3tensor(:,295))
  call loop_AZ_Q(G2(:,:,:,489),wf(:,11),G2(:,:,:,491),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,491),Q(:,127),MB,G3tensor(:,296))
  call loop_AV_Q(G1(:,:,:,127),wf(:,287),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,124),MB,G2(:,:,:,492))
  call loop_AV_Q(G2(:,:,:,492),wf(:,1),G2(:,:,:,493))
  call check_last_A_Q(l_switch,G2(:,:,:,493),Q(:,127),MB,G3tensor(:,297))
  call loop_AZ_Q(G2(:,:,:,492),wf(:,11),G2(:,:,:,494),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,494),Q(:,127),MB,G3tensor(:,298))
  call loop_AV_Q(G1(:,:,:,127),wf(:,787),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,111),MB,G2(:,:,:,495))
  call loop_AV_Q(G2(:,:,:,495),wf(:,-4),G2(:,:,:,496))
  call check_last_A_Q(l_switch,G2(:,:,:,496),Q(:,127),MB,G3tensor(:,299))
  call loop_AV_Q(G1(:,:,:,127),wf(:,788),G1(:,:,:,162))
  call loop_A_Q(G1(:,:,:,162),Q(:,111),MB,G2(:,:,:,497))
  call loop_AV_Q(G2(:,:,:,497),wf(:,-4),G2(:,:,:,498))
  call check_last_A_Q(l_switch,G2(:,:,:,498),Q(:,127),MB,G3tensor(:,300))
  call loop_AV_Q(G1(:,:,:,127),wf(:,809),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,111),MB,G2(:,:,:,499))
  call loop_AV_Q(G2(:,:,:,499),wf(:,-4),G2(:,:,:,500))
  call check_last_A_Q(l_switch,G2(:,:,:,500),Q(:,127),MB,G3tensor(:,301))
  call loop_AV_Q(G1(:,:,:,127),wf(:,810),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,111),MB,G2(:,:,:,501))
  call loop_AV_Q(G2(:,:,:,501),wf(:,-4),G2(:,:,:,502))
  call check_last_A_Q(l_switch,G2(:,:,:,502),Q(:,127),MB,G3tensor(:,302))
  call loop_AV_Q(G1(:,:,:,127),wf(:,823),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,111),MB,G2(:,:,:,503))
  call loop_AV_Q(G2(:,:,:,503),wf(:,-4),G2(:,:,:,504))
  call check_last_A_Q(l_switch,G2(:,:,:,504),Q(:,127),MB,G3tensor(:,303))
  call loop_AV_Q(G1(:,:,:,127),wf(:,824),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,111),MB,G2(:,:,:,505))
  call loop_AV_Q(G2(:,:,:,505),wf(:,-4),G2(:,:,:,506))
  call check_last_A_Q(l_switch,G2(:,:,:,506),Q(:,127),MB,G3tensor(:,304))
  call loop_AV_Q(G1(:,:,:,127),wf(:,829),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,111),MB,G2(:,:,:,507))
  call loop_AV_Q(G2(:,:,:,507),wf(:,-4),G2(:,:,:,508))
  call check_last_A_Q(l_switch,G2(:,:,:,508),Q(:,127),MB,G3tensor(:,305))
  call loop_AV_Q(G1(:,:,:,127),wf(:,830),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,111),MB,G2(:,:,:,509))
  call loop_AV_Q(G2(:,:,:,509),wf(:,-4),G2(:,:,:,510))
  call check_last_A_Q(l_switch,G2(:,:,:,510),Q(:,127),MB,G3tensor(:,306))
  call loop_AV_Q(G0(:,:,:,1),wf(:,130),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,60),ZERO,G1(:,:,:,169))
  call loop_AV_Q(G1(:,:,:,169),wf(:,-6),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,124),ZERO,G2(:,:,:,511))
  call loop_AV_Q(G2(:,:,:,511),wf(:,1),G2(:,:,:,512))
  call check_last_A_Q(l_switch,G2(:,:,:,512),Q(:,127),ZERO,G3tensor(:,307))
  call loop_AZ_Q(G2(:,:,:,511),wf(:,11),G2(:,:,:,513),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,513),Q(:,127),ZERO,G3tensor(:,308))
  call loop_AZ_Q(G2(:,:,:,511),wf(:,11),G2(:,:,:,514),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,514),Q(:,127),ZERO,G3tensor(:,309))
  call loop_AV_Q(G0(:,:,:,1),wf(:,132),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,60),ZERO,G1(:,:,:,171))
  call loop_AV_Q(G1(:,:,:,171),wf(:,-6),G1(:,:,:,172))
  call loop_A_Q(G1(:,:,:,172),Q(:,124),ZERO,G2(:,:,:,515))
  call loop_AV_Q(G2(:,:,:,515),wf(:,1),G2(:,:,:,516))
  call check_last_A_Q(l_switch,G2(:,:,:,516),Q(:,127),ZERO,G3tensor(:,310))
  call loop_AZ_Q(G2(:,:,:,515),wf(:,11),G2(:,:,:,517),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,517),Q(:,127),ZERO,G3tensor(:,311))
  call loop_AZ_Q(G2(:,:,:,515),wf(:,11),G2(:,:,:,518),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,518),Q(:,127),ZERO,G3tensor(:,312))
  call loop_AV_Q(G0(:,:,:,1),wf(:,133),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,60),ZERO,G1(:,:,:,173))
  call loop_AV_Q(G1(:,:,:,173),wf(:,-6),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,124),ZERO,G2(:,:,:,519))
  call loop_AV_Q(G2(:,:,:,519),wf(:,1),G2(:,:,:,520))
  call check_last_A_Q(l_switch,G2(:,:,:,520),Q(:,127),ZERO,G3tensor(:,313))
  call loop_AZ_Q(G2(:,:,:,519),wf(:,11),G2(:,:,:,521),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,521),Q(:,127),ZERO,G3tensor(:,314))
  call loop_AZ_Q(G2(:,:,:,519),wf(:,11),G2(:,:,:,522),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,522),Q(:,127),ZERO,G3tensor(:,315))
  call loop_AV_Q(G0(:,:,:,1),wf(:,130),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,60),MT,G1(:,:,:,175))
  call loop_AV_Q(G1(:,:,:,175),wf(:,-6),G1(:,:,:,176))
  call loop_A_Q(G1(:,:,:,176),Q(:,124),MT,G2(:,:,:,523))
  call loop_AV_Q(G2(:,:,:,523),wf(:,1),G2(:,:,:,524))
  call check_last_A_Q(l_switch,G2(:,:,:,524),Q(:,127),MT,G3tensor(:,316))
  call loop_AZ_Q(G2(:,:,:,523),wf(:,11),G2(:,:,:,525),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,525),Q(:,127),MT,G3tensor(:,317))
  call loop_AV_Q(G0(:,:,:,1),wf(:,132),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,60),MT,G1(:,:,:,177))
  call loop_AV_Q(G1(:,:,:,177),wf(:,-6),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,124),MT,G2(:,:,:,526))
  call loop_AV_Q(G2(:,:,:,526),wf(:,1),G2(:,:,:,527))
  call check_last_A_Q(l_switch,G2(:,:,:,527),Q(:,127),MT,G3tensor(:,318))
  call loop_AZ_Q(G2(:,:,:,526),wf(:,11),G2(:,:,:,528),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,528),Q(:,127),MT,G3tensor(:,319))
  call loop_AV_Q(G0(:,:,:,1),wf(:,133),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,60),MT,G1(:,:,:,179))
  call loop_AV_Q(G1(:,:,:,179),wf(:,-6),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,124),MT,G2(:,:,:,529))
  call loop_AV_Q(G2(:,:,:,529),wf(:,1),G2(:,:,:,530))
  call check_last_A_Q(l_switch,G2(:,:,:,530),Q(:,127),MT,G3tensor(:,320))
  call loop_AZ_Q(G2(:,:,:,529),wf(:,11),G2(:,:,:,531),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,531),Q(:,127),MT,G3tensor(:,321))
  call loop_QV_A(G0(:,:,:,1),wf(:,130),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,60),ZERO,G1(:,:,:,181))
  call loop_QV_A(G1(:,:,:,181),wf(:,-6),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,124),ZERO,G2(:,:,:,532))
  call loop_QV_A(G2(:,:,:,532),wf(:,1),G2(:,:,:,533))
  call check_last_Q_A(l_switch,G2(:,:,:,533),Q(:,127),ZERO,G3tensor(:,322))
  call loop_QZ_A(G2(:,:,:,532),wf(:,11),G2(:,:,:,534),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,534),Q(:,127),ZERO,G3tensor(:,323))
  call loop_QZ_A(G2(:,:,:,532),wf(:,11),G2(:,:,:,535),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,535),Q(:,127),ZERO,G3tensor(:,324))
  call loop_QV_A(G0(:,:,:,1),wf(:,132),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,60),ZERO,G1(:,:,:,183))
  call loop_QV_A(G1(:,:,:,183),wf(:,-6),G1(:,:,:,184))
  call loop_Q_A(G1(:,:,:,184),Q(:,124),ZERO,G2(:,:,:,536))
  call loop_QV_A(G2(:,:,:,536),wf(:,1),G2(:,:,:,537))
  call check_last_Q_A(l_switch,G2(:,:,:,537),Q(:,127),ZERO,G3tensor(:,325))
  call loop_QZ_A(G2(:,:,:,536),wf(:,11),G2(:,:,:,538),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,538),Q(:,127),ZERO,G3tensor(:,326))
  call loop_QZ_A(G2(:,:,:,536),wf(:,11),G2(:,:,:,539),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,539),Q(:,127),ZERO,G3tensor(:,327))
  call loop_QV_A(G0(:,:,:,1),wf(:,133),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,60),ZERO,G1(:,:,:,185))
  call loop_QV_A(G1(:,:,:,185),wf(:,-6),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,124),ZERO,G2(:,:,:,540))
  call loop_QV_A(G2(:,:,:,540),wf(:,1),G2(:,:,:,541))
  call check_last_Q_A(l_switch,G2(:,:,:,541),Q(:,127),ZERO,G3tensor(:,328))
  call loop_QZ_A(G2(:,:,:,540),wf(:,11),G2(:,:,:,542),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,542),Q(:,127),ZERO,G3tensor(:,329))
  call loop_QZ_A(G2(:,:,:,540),wf(:,11),G2(:,:,:,543),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,543),Q(:,127),ZERO,G3tensor(:,330))
  call loop_QV_A(G0(:,:,:,1),wf(:,130),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,60),MT,G1(:,:,:,187))
  call loop_QV_A(G1(:,:,:,187),wf(:,-6),G1(:,:,:,188))
  call loop_Q_A(G1(:,:,:,188),Q(:,124),MT,G2(:,:,:,544))
  call loop_QV_A(G2(:,:,:,544),wf(:,1),G2(:,:,:,545))
  call check_last_Q_A(l_switch,G2(:,:,:,545),Q(:,127),MT,G3tensor(:,331))
  call loop_QZ_A(G2(:,:,:,544),wf(:,11),G2(:,:,:,546),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,546),Q(:,127),MT,G3tensor(:,332))
  call loop_QV_A(G0(:,:,:,1),wf(:,132),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,60),MT,G1(:,:,:,189))
  call loop_QV_A(G1(:,:,:,189),wf(:,-6),G1(:,:,:,190))
  call loop_Q_A(G1(:,:,:,190),Q(:,124),MT,G2(:,:,:,547))
  call loop_QV_A(G2(:,:,:,547),wf(:,1),G2(:,:,:,548))
  call check_last_Q_A(l_switch,G2(:,:,:,548),Q(:,127),MT,G3tensor(:,333))
  call loop_QZ_A(G2(:,:,:,547),wf(:,11),G2(:,:,:,549),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,549),Q(:,127),MT,G3tensor(:,334))
  call loop_QV_A(G0(:,:,:,1),wf(:,133),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,60),MT,G1(:,:,:,191))
  call loop_QV_A(G1(:,:,:,191),wf(:,-6),G1(:,:,:,192))
  call loop_Q_A(G1(:,:,:,192),Q(:,124),MT,G2(:,:,:,550))
  call loop_QV_A(G2(:,:,:,550),wf(:,1),G2(:,:,:,551))
  call check_last_Q_A(l_switch,G2(:,:,:,551),Q(:,127),MT,G3tensor(:,335))
  call loop_QZ_A(G2(:,:,:,550),wf(:,11),G2(:,:,:,552),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,552),Q(:,127),MT,G3tensor(:,336))
  call loop_AV_Q(G0(:,:,:,1),wf(:,130),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,60),MB,G1(:,:,:,193))
  call loop_AV_Q(G1(:,:,:,193),wf(:,-6),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,124),MB,G2(:,:,:,553))
  call loop_AV_Q(G2(:,:,:,553),wf(:,1),G2(:,:,:,554))
  call check_last_A_Q(l_switch,G2(:,:,:,554),Q(:,127),MB,G3tensor(:,337))
  call loop_AZ_Q(G2(:,:,:,553),wf(:,11),G2(:,:,:,555),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,555),Q(:,127),MB,G3tensor(:,338))
  call loop_AV_Q(G0(:,:,:,1),wf(:,132),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,60),MB,G1(:,:,:,195))
  call loop_AV_Q(G1(:,:,:,195),wf(:,-6),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,124),MB,G2(:,:,:,556))
  call loop_AV_Q(G2(:,:,:,556),wf(:,1),G2(:,:,:,557))
  call check_last_A_Q(l_switch,G2(:,:,:,557),Q(:,127),MB,G3tensor(:,339))
  call loop_AZ_Q(G2(:,:,:,556),wf(:,11),G2(:,:,:,558),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,558),Q(:,127),MB,G3tensor(:,340))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(52)*(-M(1)+M(2)+M(4)-M(6))) * den(1019)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(52)*(-M(2)+M(3)-M(4)+M(5))) * den(1019)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(52)*(M(1)-M(3)-M(5)+M(6))) * den(1019)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(48)*(-M(1)+M(2)+M(4)-M(6))) * den(1019)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(48)*(-M(2)+M(3)-M(4)+M(5))) * den(1019)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(48)*(M(1)-M(3)-M(5)+M(6))) * den(1019)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(46)*(M(1)-M(2)-M(4)+M(6))) * den(1019)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,163)
  Gcoeff = (c(46)*(M(2)-M(3)+M(4)-M(5))) * den(1019)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,165)
  Gcoeff = (c(46)*(-M(1)+M(3)+M(5)-M(6))) * den(1019)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,167)
  Gcoeff = (c(48)*(M(1)-M(2)-M(4)+M(6))) * den(1019)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(48)*(M(2)-M(3)+M(4)-M(5))) * den(1019)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(48)*(-M(1)+M(3)+M(5)-M(6))) * den(1019)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(46)*(M(1)-M(2)-M(4)+M(6))) * den(1019)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,235)
  Gcoeff = (c(46)*(M(2)-M(3)+M(4)-M(5))) * den(1019)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,237)
  Gcoeff = (c(46)*(-M(1)+M(3)+M(5)-M(6))) * den(1019)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,239)
  Gcoeff = (c(54)*(M(1)-M(2)-M(4)+M(6))) * den(183)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(54)*(M(2)-M(3)+M(4)-M(5))) * den(183)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(54)*(-M(1)+M(3)+M(5)-M(6))) * den(183)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(50)*(M(1)-M(2)-M(4)+M(6))) * den(183)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,92)
  Gcoeff = (c(50)*(M(2)-M(3)+M(4)-M(5))) * den(183)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(50)*(-M(1)+M(3)+M(5)-M(6))) * den(183)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(50)*(M(1)-M(2)-M(4)+M(6))) * den(183)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,164)
  Gcoeff = (c(50)*(M(2)-M(3)+M(4)-M(5))) * den(183)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,166)
  Gcoeff = (c(50)*(-M(1)+M(3)+M(5)-M(6))) * den(183)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,168)
  Gcoeff = (c(54)*(M(1)-M(2)-M(4)+M(6))) * den(183)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(54)*(M(2)-M(3)+M(4)-M(5))) * den(183)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(54)*(-M(1)+M(3)+M(5)-M(6))) * den(183)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(50)*(M(1)-M(2)-M(4)+M(6))) * den(183)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,236)
  Gcoeff = (c(50)*(M(2)-M(3)+M(4)-M(5))) * den(183)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,238)
  Gcoeff = (c(50)*(-M(1)+M(3)+M(5)-M(6))) * den(183)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,240)
  Gcoeff = (c(52)*(M(1)-M(2)-M(4)+M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,307)
  Gcoeff = (c(52)*(-M(1)+M(3)+M(5)-M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,310)
  Gcoeff = (c(52)*(M(2)-M(3)+M(4)-M(5))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,313)
  Gcoeff = (c(48)*(M(1)-M(2)-M(4)+M(6))) * den(1020)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,316)
  Gcoeff = (c(48)*(-M(1)+M(3)+M(5)-M(6))) * den(1020)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,318)
  Gcoeff = (c(48)*(M(2)-M(3)+M(4)-M(5))) * den(1020)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,320)
  Gcoeff = (c(52)*(M(1)-M(2)-M(4)+M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,322)
  Gcoeff = (c(52)*(-M(1)+M(3)+M(5)-M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,325)
  Gcoeff = (c(52)*(M(2)-M(3)+M(4)-M(5))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,328)
  Gcoeff = (c(48)*(M(1)-M(2)-M(4)+M(6))) * den(1020)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,331)
  Gcoeff = (c(48)*(-M(1)+M(3)+M(5)-M(6))) * den(1020)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,333)
  Gcoeff = (c(48)*(M(2)-M(3)+M(4)-M(5))) * den(1020)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,335)
  Gcoeff = (c(48)*(-M(1)+M(2)+M(4)-M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,307)
  Gcoeff = (c(48)*(M(1)-M(3)-M(5)+M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,310)
  Gcoeff = (c(48)*(-M(2)+M(3)-M(4)+M(5))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,313)
  Gcoeff = (c(46)*(-M(1)+M(2)+M(4)-M(6))) * den(1020)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,337)
  Gcoeff = (c(46)*(M(1)-M(3)-M(5)+M(6))) * den(1020)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,339)
  Gcoeff = (c(48)*(-M(1)+M(2)+M(4)-M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,322)
  Gcoeff = (c(48)*(M(1)-M(3)-M(5)+M(6))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,325)
  Gcoeff = (c(48)*(-M(2)+M(3)-M(4)+M(5))) * den(1020)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,328)
  Gcoeff = (c(54)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,308)
  Gcoeff = (c(54)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,311)
  Gcoeff = (c(54)*(-M(2)+M(3)-M(4)+M(5))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,314)
  Gcoeff = (c(50)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,317)
  Gcoeff = (c(50)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,319)
  Gcoeff = (c(50)*(-M(2)+M(3)-M(4)+M(5))) * den(180)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,321)
  Gcoeff = (c(54)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,323)
  Gcoeff = (c(54)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,326)
  Gcoeff = (c(54)*(-M(2)+M(3)-M(4)+M(5))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,329)
  Gcoeff = (c(50)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,332)
  Gcoeff = (c(50)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,334)
  Gcoeff = (c(50)*(-M(2)+M(3)-M(4)+M(5))) * den(180)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,336)
  Gcoeff = (c(54)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,309)
  Gcoeff = (c(54)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,312)
  Gcoeff = (c(54)*(-M(2)+M(3)-M(4)+M(5))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,315)
  Gcoeff = (c(50)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,338)
  Gcoeff = (c(50)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,340)
  Gcoeff = (c(54)*(-M(1)+M(2)+M(4)-M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,324)
  Gcoeff = (c(54)*(M(1)-M(3)-M(5)+M(6))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,327)
  Gcoeff = (c(54)*(-M(2)+M(3)-M(4)+M(5))) * den(180)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,330)
  Gcoeff = (c(52)*(M(2)-M(3)+M(4)-M(5))) * den(1039)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(48)*(M(2)-M(3)+M(4)-M(5))) * den(1039)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(46)*(-M(2)+M(3)-M(4)+M(5))) * den(1039)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,169)
  Gcoeff = (c(48)*(-M(2)+M(3)-M(4)+M(5))) * den(1039)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(46)*(-M(2)+M(3)-M(4)+M(5))) * den(1039)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,241)
  Gcoeff = (c(54)*(-M(2)+M(3)-M(4)+M(5))) * den(239)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(50)*(-M(2)+M(3)-M(4)+M(5))) * den(239)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(50)*(-M(2)+M(3)-M(4)+M(5))) * den(239)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,170)
  Gcoeff = (c(54)*(-M(2)+M(3)-M(4)+M(5))) * den(239)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(50)*(-M(2)+M(3)-M(4)+M(5))) * den(239)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,242)
  Gcoeff = (c(42)*(-M(2)+M(5))+c(41)*(-M(10)+M(11))) * den(1040)
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(38)*(-M(2)+M(5))+c(37)*(-M(10)+M(11))) * den(1040)
  T4sum(1:70,23) = T4sum(1:70,23) + Gcoeff * G4tensor(:,26)
  Gcoeff = (c(36)*(M(3)-M(4))+c(35)*(M(10)-M(11))) * den(1040)
  T4sum(1:70,24) = T4sum(1:70,24) + Gcoeff * G4tensor(:,44)
  Gcoeff = (c(38)*(M(2)-M(5))+c(37)*(M(10)-M(11))) * den(1040)
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(36)*(M(2)-M(5))+c(35)*(M(10)-M(11))) * den(1040)
  T4sum(1:70,24) = T4sum(1:70,24) + Gcoeff * G4tensor(:,62)
  Gcoeff = (c(44)*(M(2)-M(5))+c(43)*(M(10)-M(11))) * den(1041)
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(40)*(M(2)-M(5))+c(39)*(M(10)-M(11))) * den(1041)
  T4sum(1:70,23) = T4sum(1:70,23) + Gcoeff * G4tensor(:,27)
  Gcoeff = (c(40)*(M(3)-M(4))+c(39)*(M(10)-M(11))) * den(1041)
  T4sum(1:70,24) = T4sum(1:70,24) + Gcoeff * G4tensor(:,45)
  Gcoeff = (c(44)*(M(2)-M(5))+c(43)*(M(10)-M(11))) * den(1041)
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(40)*(M(2)-M(5))+c(39)*(M(10)-M(11))) * den(1041)
  T4sum(1:70,24) = T4sum(1:70,24) + Gcoeff * G4tensor(:,63)
  Gcoeff = (c(52)*(-M(1)+M(2)+M(4)-M(6))) * den(1051)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(48)*(-M(1)+M(2)+M(4)-M(6))) * den(1051)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(46)*(M(1)-M(2)-M(4)+M(6))) * den(1051)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,171)
  Gcoeff = (c(48)*(M(1)-M(2)-M(4)+M(6))) * den(1051)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(46)*(M(1)-M(2)-M(4)+M(6))) * den(1051)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,243)
  Gcoeff = (c(54)*(M(1)-M(2)-M(4)+M(6))) * den(1052)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(50)*(M(1)-M(2)-M(4)+M(6))) * den(1052)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(50)*(M(1)-M(2)-M(4)+M(6))) * den(1052)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,172)
  Gcoeff = (c(54)*(M(1)-M(2)-M(4)+M(6))) * den(1052)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(50)*(M(1)-M(2)-M(4)+M(6))) * den(1052)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,244)
  Gcoeff = (c(42)*(-M(2)+M(6))) * den(175)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(38)*(-M(2)+M(6))) * den(175)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,28)
  Gcoeff = (c(36)*(M(1)-M(4))) * den(175)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,46)
  Gcoeff = (c(38)*(M(2)-M(6))) * den(175)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(36)*(M(2)-M(6))) * den(175)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,64)
  Gcoeff = (c(44)*(M(2)-M(6))) * den(176)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(40)*(M(2)-M(6))) * den(176)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(40)*(M(1)-M(4))) * den(176)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,47)
  Gcoeff = (c(44)*(M(2)-M(6))) * den(176)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(40)*(M(2)-M(6))) * den(176)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,65)
  Gcoeff = (c(52)*(M(1)-M(3)-M(5)+M(6))) * den(1057)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(48)*(M(1)-M(3)-M(5)+M(6))) * den(1057)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,101)
  Gcoeff = (c(46)*(-M(1)+M(3)+M(5)-M(6))) * den(1057)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,173)
  Gcoeff = (c(48)*(-M(1)+M(3)+M(5)-M(6))) * den(1057)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(46)*(-M(1)+M(3)+M(5)-M(6))) * den(1057)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,245)
  Gcoeff = (c(54)*(-M(1)+M(3)+M(5)-M(6))) * den(1058)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(50)*(-M(1)+M(3)+M(5)-M(6))) * den(1058)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(50)*(-M(1)+M(3)+M(5)-M(6))) * den(1058)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,174)
  Gcoeff = (c(54)*(-M(1)+M(3)+M(5)-M(6))) * den(1058)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(50)*(-M(1)+M(3)+M(5)-M(6))) * den(1058)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,246)
  Gcoeff = (c(42)*(M(3)-M(6))) * den(195)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(38)*(M(3)-M(6))) * den(195)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,30)
  Gcoeff = (c(36)*(-M(1)+M(5))) * den(195)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,48)
  Gcoeff = (c(38)*(-M(3)+M(6))) * den(195)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(36)*(-M(3)+M(6))) * den(195)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,66)
  Gcoeff = (c(44)*(-M(3)+M(6))) * den(196)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(40)*(-M(3)+M(6))) * den(196)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,31)
  Gcoeff = (c(40)*(-M(1)+M(5))) * den(196)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,49)
  Gcoeff = (c(44)*(-M(3)+M(6))) * den(196)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(40)*(-M(3)+M(6))) * den(196)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,67)
  Gcoeff = (c(52)*M(6)-c(51)*M(11)) * den(167)
  T5sum(1:126,16) = T5sum(1:126,16) + Gcoeff * G5tensor(:,4)
  Gcoeff = (c(48)*M(6)-c(47)*M(11)) * den(167)
  T5sum(1:126,17) = T5sum(1:126,17) + Gcoeff * G5tensor(:,9)
  Gcoeff = (-(c(46)*M(1))+c(45)*M(10)) * den(167)
  T5sum(1:126,18) = T5sum(1:126,18) + Gcoeff * G5tensor(:,13)
  Gcoeff = (-(c(48)*M(6))+c(47)*M(11)) * den(167)
  T5sum(1:126,16) = T5sum(1:126,16) + Gcoeff * G5tensor(:,4)
  Gcoeff = (-(c(46)*M(6))+c(45)*M(11)) * den(167)
  T5sum(1:126,18) = T5sum(1:126,18) + Gcoeff * G5tensor(:,17)
  Gcoeff = (-(c(54)*M(6))+c(53)*M(11)) * den(169)
  T5sum(1:126,16) = T5sum(1:126,16) + Gcoeff * G5tensor(:,5)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(11)) * den(169)
  T5sum(1:126,17) = T5sum(1:126,17) + Gcoeff * G5tensor(:,10)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(10)) * den(169)
  T5sum(1:126,18) = T5sum(1:126,18) + Gcoeff * G5tensor(:,14)
  Gcoeff = (-(c(54)*M(6))+c(53)*M(11)) * den(169)
  T5sum(1:126,16) = T5sum(1:126,16) + Gcoeff * G5tensor(:,6)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(11)) * den(169)
  T5sum(1:126,18) = T5sum(1:126,18) + Gcoeff * G5tensor(:,18)
  Gcoeff = (c(52)*M(2)-c(51)*M(11)) * den(167)
  T5sum(1:126,28) = T5sum(1:126,28) + Gcoeff * G5tensor(:,1)
  Gcoeff = (c(48)*M(2)-c(47)*M(11)) * den(167)
  T5sum(1:126,29) = T5sum(1:126,29) + Gcoeff * G5tensor(:,7)
  Gcoeff = (-(c(48)*M(2))+c(47)*M(11)) * den(167)
  T5sum(1:126,28) = T5sum(1:126,28) + Gcoeff * G5tensor(:,1)
  Gcoeff = (-(c(46)*M(2))+c(45)*M(11)) * den(167)
  T5sum(1:126,30) = T5sum(1:126,30) + Gcoeff * G5tensor(:,15)
  Gcoeff = (-(c(46)*M(4))+c(45)*M(10)) * den(167)
  T5sum(1:126,30) = T5sum(1:126,30) + Gcoeff * G5tensor(:,11)
  Gcoeff = (-(c(54)*M(2))+c(53)*M(11)) * den(169)
  T5sum(1:126,28) = T5sum(1:126,28) + Gcoeff * G5tensor(:,2)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(11)) * den(169)
  T5sum(1:126,29) = T5sum(1:126,29) + Gcoeff * G5tensor(:,8)
  Gcoeff = (-(c(54)*M(2))+c(53)*M(11)) * den(169)
  T5sum(1:126,28) = T5sum(1:126,28) + Gcoeff * G5tensor(:,3)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(11)) * den(169)
  T5sum(1:126,30) = T5sum(1:126,30) + Gcoeff * G5tensor(:,16)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(10)) * den(169)
  T5sum(1:126,30) = T5sum(1:126,30) + Gcoeff * G5tensor(:,12)
  Gcoeff = (c(52)*M(6)) * den(1072)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(48)*M(6)) * den(1072)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,103)
  Gcoeff = (-(c(46)*M(6))) * den(1072)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,175)
  Gcoeff = (-(c(48)*M(6))) * den(1072)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,19)
  Gcoeff = (-(c(46)*M(6))) * den(1072)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,247)
  Gcoeff = (-(c(54)*M(6))) * den(276)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(50)*M(6))) * den(276)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,104)
  Gcoeff = (-(c(50)*M(6))) * den(276)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,176)
  Gcoeff = (-(c(54)*M(6))) * den(276)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(50)*M(6))) * den(276)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,248)
  Gcoeff = (c(52)*M(4)-c(51)*M(9)) * den(777)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(48)*M(4)-c(47)*M(9)) * den(777)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(52)*M(4)-c(51)*M(9)) * den(777)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(48)*M(4)-c(47)*M(9)) * den(777)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,249)
  Gcoeff = (c(48)*M(6)-c(47)*M(9)) * den(777)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,177)
  Gcoeff = (-(c(54)*M(4))+c(53)*M(9)) * den(779)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(779)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,106)
  Gcoeff = (-(c(54)*M(4))+c(53)*M(9)) * den(779)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(779)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,250)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(9)) * den(779)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,178)
  Gcoeff = (c(42)*(M(4)-M(6))) * den(1089)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(38)*(M(4)-M(6))) * den(1089)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,121)
  Gcoeff = (c(36)*(-M(4)+M(6))) * den(1089)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,193)
  Gcoeff = (c(38)*(-M(4)+M(6))) * den(1089)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(36)*(-M(4)+M(6))) * den(1089)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,265)
  Gcoeff = (c(44)*(-M(4)+M(6))) * den(1090)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(40)*(-M(4)+M(6))) * den(1090)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(40)*(-M(4)+M(6))) * den(1090)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,194)
  Gcoeff = (c(44)*(-M(4)+M(6))) * den(1090)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(40)*(-M(4)+M(6))) * den(1090)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,266)
  Gcoeff = (c(52)*M(6)-c(51)*M(9)) * den(198)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(48)*M(6)-c(47)*M(9)) * den(198)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,40)
  Gcoeff = (-(c(46)*M(4))+c(45)*M(9)) * den(198)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,58)
  Gcoeff = (-(c(48)*M(6))+c(47)*M(9)) * den(198)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,20)
  Gcoeff = (-(c(46)*M(6))+c(45)*M(9)) * den(198)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,76)
  Gcoeff = (-(c(54)*M(6))+c(53)*M(9)) * den(199)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,21)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(9)) * den(199)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,41)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(199)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,59)
  Gcoeff = (-(c(54)*M(6))+c(53)*M(9)) * den(199)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,22)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(9)) * den(199)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,77)
  Gcoeff = (c(52)*M(4)) * den(1095)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(48)*M(4)) * den(1095)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,123)
  Gcoeff = (-(c(46)*M(4))) * den(1095)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,195)
  Gcoeff = (-(c(48)*M(4))) * den(1095)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,41)
  Gcoeff = (-(c(46)*M(4))) * den(1095)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,267)
  Gcoeff = (-(c(54)*M(4))) * den(1096)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,42)
  Gcoeff = (-(c(50)*M(4))) * den(1096)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,124)
  Gcoeff = (-(c(50)*M(4))) * den(1096)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,196)
  Gcoeff = (-(c(54)*M(4))) * den(1096)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(50)*M(4))) * den(1096)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,268)
  Gcoeff = (c(52)*M(4)-c(51)*M(9)) * den(794)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(48)*M(4)-c(47)*M(9)) * den(794)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,107)
  Gcoeff = (c(52)*M(4)-c(51)*M(9)) * den(794)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(48)*M(4)-c(47)*M(9)) * den(794)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,251)
  Gcoeff = (c(48)*M(6)-c(47)*M(9)) * den(794)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,179)
  Gcoeff = (-(c(54)*M(4))+c(53)*M(9)) * den(795)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(795)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,108)
  Gcoeff = (-(c(54)*M(4))+c(53)*M(9)) * den(795)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(795)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,252)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(9)) * den(795)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,180)
  Gcoeff = (c(52)*M(1)) * den(1110)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(48)*M(1)) * den(1110)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,125)
  Gcoeff = (-(c(46)*M(1))) * den(1110)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,197)
  Gcoeff = (-(c(48)*M(1))) * den(1110)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,44)
  Gcoeff = (-(c(46)*M(1))) * den(1110)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,269)
  Gcoeff = (-(c(54)*M(1))) * den(304)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,45)
  Gcoeff = (-(c(50)*M(1))) * den(304)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,126)
  Gcoeff = (-(c(50)*M(1))) * den(304)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,198)
  Gcoeff = (-(c(54)*M(1))) * den(304)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,46)
  Gcoeff = (-(c(50)*M(1))) * den(304)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,270)
  Gcoeff = (c(52)*M(1)-c(51)*M(9)) * den(801)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(48)*M(1)-c(47)*M(9)) * den(801)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,109)
  Gcoeff = (c(52)*M(1)-c(51)*M(9)) * den(801)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(48)*M(1)-c(47)*M(9)) * den(801)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,253)
  Gcoeff = (c(48)*M(2)-c(47)*M(9)) * den(801)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,181)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(9)) * den(803)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(803)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,110)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(9)) * den(803)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(803)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,254)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(9)) * den(803)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,182)
  Gcoeff = (c(42)*(M(1)-M(2))) * den(1127)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(38)*(M(1)-M(2))) * den(1127)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,127)
  Gcoeff = (c(36)*(-M(1)+M(2))) * den(1127)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,199)
  Gcoeff = (c(38)*(-M(1)+M(2))) * den(1127)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(36)*(-M(1)+M(2))) * den(1127)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,271)
  Gcoeff = (c(44)*(-M(1)+M(2))) * den(1128)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(40)*(-M(1)+M(2))) * den(1128)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,128)
  Gcoeff = (c(40)*(-M(1)+M(2))) * den(1128)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,200)
  Gcoeff = (c(44)*(-M(1)+M(2))) * den(1128)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(40)*(-M(1)+M(2))) * den(1128)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,272)
  Gcoeff = (c(52)*M(2)-c(51)*M(9)) * den(201)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,23)
  Gcoeff = (c(48)*M(2)-c(47)*M(9)) * den(201)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,42)
  Gcoeff = (-(c(46)*M(1))+c(45)*M(9)) * den(201)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,60)
  Gcoeff = (-(c(48)*M(2))+c(47)*M(9)) * den(201)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,23)
  Gcoeff = (-(c(46)*M(2))+c(45)*M(9)) * den(201)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,78)
  Gcoeff = (-(c(54)*M(2))+c(53)*M(9)) * den(202)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,24)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(9)) * den(202)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,43)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(202)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,61)
  Gcoeff = (-(c(54)*M(2))+c(53)*M(9)) * den(202)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,25)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(9)) * den(202)
  T4sum(1:70,48) = T4sum(1:70,48) + Gcoeff * G4tensor(:,79)
  Gcoeff = (c(52)*M(2)) * den(1131)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(48)*M(2)) * den(1131)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,129)
  Gcoeff = (-(c(46)*M(2))) * den(1131)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,201)
  Gcoeff = (-(c(48)*M(2))) * den(1131)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,50)
  Gcoeff = (-(c(46)*M(2))) * den(1131)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,273)
  Gcoeff = (-(c(54)*M(2))) * den(1132)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,51)
  Gcoeff = (-(c(50)*M(2))) * den(1132)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,130)
  Gcoeff = (-(c(50)*M(2))) * den(1132)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,202)
  Gcoeff = (-(c(54)*M(2))) * den(1132)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(50)*M(2))) * den(1132)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,274)
  Gcoeff = (c(52)*M(1)-c(51)*M(9)) * den(808)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(48)*M(1)-c(47)*M(9)) * den(808)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(52)*M(1)-c(51)*M(9)) * den(808)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(48)*M(1)-c(47)*M(9)) * den(808)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,255)
  Gcoeff = (c(48)*M(2)-c(47)*M(9)) * den(808)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,183)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(9)) * den(809)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,29)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(809)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,112)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(9)) * den(809)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,29)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(809)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,256)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(9)) * den(809)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,184)
  Gcoeff = (c(52)*M(1)-c(51)*M(7)) * den(891)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(48)*M(1)-c(47)*M(7)) * den(891)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,131)
  Gcoeff = (c(52)*M(1)-c(51)*M(7)) * den(891)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(48)*M(1)-c(47)*M(7)) * den(891)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,275)
  Gcoeff = (c(48)*M(3)-c(47)*M(7)) * den(891)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,203)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(7)) * den(893)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,54)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(893)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,132)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(7)) * den(893)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,54)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(893)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,276)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(7)) * den(893)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,204)
  Gcoeff = (c(42)*(M(1)-M(3))) * den(1241)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(38)*(M(1)-M(3))) * den(1241)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,133)
  Gcoeff = (c(36)*(-M(1)+M(3))) * den(1241)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,205)
  Gcoeff = (c(38)*(-M(1)+M(3))) * den(1241)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(36)*(-M(1)+M(3))) * den(1241)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,277)
  Gcoeff = (c(44)*(-M(1)+M(3))) * den(1242)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(40)*(-M(1)+M(3))) * den(1242)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,134)
  Gcoeff = (c(40)*(-M(1)+M(3))) * den(1242)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,206)
  Gcoeff = (c(44)*(-M(1)+M(3))) * den(1242)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(40)*(-M(1)+M(3))) * den(1242)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,278)
  Gcoeff = (c(52)*M(3)-c(51)*M(7)) * den(210)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(48)*M(3)-c(47)*M(7)) * den(210)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,32)
  Gcoeff = (-(c(46)*M(1))+c(45)*M(7)) * den(210)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,50)
  Gcoeff = (-(c(48)*M(3))+c(47)*M(7)) * den(210)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,10)
  Gcoeff = (-(c(46)*M(3))+c(45)*M(7)) * den(210)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,68)
  Gcoeff = (-(c(54)*M(3))+c(53)*M(7)) * den(211)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,11)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(7)) * den(211)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,33)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(211)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,51)
  Gcoeff = (-(c(54)*M(3))+c(53)*M(7)) * den(211)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,12)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(7)) * den(211)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,69)
  Gcoeff = (c(52)*M(3)) * den(1245)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,58)
  Gcoeff = (c(48)*M(3)) * den(1245)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,135)
  Gcoeff = (-(c(46)*M(3))) * den(1245)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,207)
  Gcoeff = (-(c(48)*M(3))) * den(1245)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(46)*M(3))) * den(1245)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,279)
  Gcoeff = (-(c(54)*M(3))) * den(1246)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,59)
  Gcoeff = (-(c(50)*M(3))) * den(1246)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,136)
  Gcoeff = (-(c(50)*M(3))) * den(1246)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,208)
  Gcoeff = (-(c(54)*M(3))) * den(1246)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,60)
  Gcoeff = (-(c(50)*M(3))) * den(1246)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,280)
  Gcoeff = (c(52)*M(1)-c(51)*M(7)) * den(906)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(48)*M(1)-c(47)*M(7)) * den(906)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,137)
  Gcoeff = (c(52)*M(1)-c(51)*M(7)) * den(906)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(48)*M(1)-c(47)*M(7)) * den(906)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,281)
  Gcoeff = (c(48)*M(3)-c(47)*M(7)) * den(906)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,209)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(7)) * den(907)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,62)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(907)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,138)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(7)) * den(907)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,62)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(907)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,282)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(7)) * den(907)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,210)
  Gcoeff = (c(52)*M(5)-c(51)*M(7)) * den(913)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(48)*M(5)-c(47)*M(7)) * den(913)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,139)
  Gcoeff = (c(52)*M(5)-c(51)*M(7)) * den(913)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(48)*M(5)-c(47)*M(7)) * den(913)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,283)
  Gcoeff = (c(48)*M(6)-c(47)*M(7)) * den(913)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,211)
  Gcoeff = (-(c(54)*M(5))+c(53)*M(7)) * den(915)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,64)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(915)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,140)
  Gcoeff = (-(c(54)*M(5))+c(53)*M(7)) * den(915)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,64)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(915)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,284)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(7)) * den(915)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,212)
  Gcoeff = (c(42)*(M(5)-M(6))) * den(1257)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(38)*(M(5)-M(6))) * den(1257)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,141)
  Gcoeff = (c(36)*(-M(5)+M(6))) * den(1257)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,213)
  Gcoeff = (c(38)*(-M(5)+M(6))) * den(1257)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(36)*(-M(5)+M(6))) * den(1257)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,285)
  Gcoeff = (c(44)*(-M(5)+M(6))) * den(1258)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(40)*(-M(5)+M(6))) * den(1258)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(40)*(-M(5)+M(6))) * den(1258)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,214)
  Gcoeff = (c(44)*(-M(5)+M(6))) * den(1258)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(40)*(-M(5)+M(6))) * den(1258)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,286)
  Gcoeff = (c(52)*M(6)-c(51)*M(7)) * den(213)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(48)*M(6)-c(47)*M(7)) * den(213)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,34)
  Gcoeff = (-(c(46)*M(5))+c(45)*M(7)) * den(213)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,52)
  Gcoeff = (-(c(48)*M(6))+c(47)*M(7)) * den(213)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,13)
  Gcoeff = (-(c(46)*M(6))+c(45)*M(7)) * den(213)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,70)
  Gcoeff = (-(c(54)*M(6))+c(53)*M(7)) * den(214)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,14)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(7)) * den(214)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,35)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(214)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,53)
  Gcoeff = (-(c(54)*M(6))+c(53)*M(7)) * den(214)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,15)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(7)) * den(214)
  T4sum(1:70,63) = T4sum(1:70,63) + Gcoeff * G4tensor(:,71)
  Gcoeff = (c(52)*M(5)) * den(1261)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(48)*M(5)) * den(1261)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,143)
  Gcoeff = (-(c(46)*M(5))) * den(1261)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,215)
  Gcoeff = (-(c(48)*M(5))) * den(1261)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,68)
  Gcoeff = (-(c(46)*M(5))) * den(1261)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,287)
  Gcoeff = (-(c(54)*M(5))) * den(1262)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,69)
  Gcoeff = (-(c(50)*M(5))) * den(1262)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,144)
  Gcoeff = (-(c(50)*M(5))) * den(1262)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,216)
  Gcoeff = (-(c(54)*M(5))) * den(1262)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,70)
  Gcoeff = (-(c(50)*M(5))) * den(1262)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,288)
  Gcoeff = (c(52)*M(5)-c(51)*M(7)) * den(920)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(48)*M(5)-c(47)*M(7)) * den(920)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,145)
  Gcoeff = (c(52)*M(5)-c(51)*M(7)) * den(920)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(48)*M(5)-c(47)*M(7)) * den(920)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,289)
  Gcoeff = (c(48)*M(6)-c(47)*M(7)) * den(920)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,217)
  Gcoeff = (-(c(54)*M(5))+c(53)*M(7)) * den(921)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,72)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(921)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(54)*M(5))+c(53)*M(7)) * den(921)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,72)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(921)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,290)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(7)) * den(921)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,218)
  Gcoeff = (c(42)*(-M(3)+M(4))+c(41)*(-M(10)+M(11))) * den(1269)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(38)*(-M(3)+M(4))+c(37)*(-M(10)+M(11))) * den(1269)
  T3sum(1:35,189) = T3sum(1:35,189) + Gcoeff * G3tensor(:,147)
  Gcoeff = (c(38)*(-M(2)+M(5))+c(37)*(-M(10)+M(11))) * den(1269)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,219)
  Gcoeff = (c(42)*(-M(3)+M(4))+c(41)*(-M(10)+M(11))) * den(1269)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(38)*(-M(3)+M(4))+c(37)*(-M(10)+M(11))) * den(1269)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,291)
  Gcoeff = (c(44)*(M(3)-M(4))+c(43)*(M(10)-M(11))) * den(1270)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(40)*(M(3)-M(4))+c(39)*(M(10)-M(11))) * den(1270)
  T3sum(1:35,189) = T3sum(1:35,189) + Gcoeff * G3tensor(:,148)
  Gcoeff = (c(40)*(M(2)-M(5))+c(39)*(M(10)-M(11))) * den(1270)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,220)
  Gcoeff = (c(44)*(M(3)-M(4))+c(43)*(M(10)-M(11))) * den(1270)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(40)*(M(3)-M(4))+c(39)*(M(10)-M(11))) * den(1270)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,292)
  Gcoeff = (c(42)*(-M(3)+M(4))+c(41)*(-M(10)+M(11))) * den(1273)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(38)*(-M(3)+M(4))+c(37)*(-M(10)+M(11))) * den(1273)
  T3sum(1:35,189) = T3sum(1:35,189) + Gcoeff * G3tensor(:,149)
  Gcoeff = (c(38)*(-M(2)+M(5))+c(37)*(-M(10)+M(11))) * den(1273)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,221)
  Gcoeff = (c(42)*(-M(3)+M(4))+c(41)*(-M(10)+M(11))) * den(1273)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(38)*(-M(3)+M(4))+c(37)*(-M(10)+M(11))) * den(1273)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,293)
  Gcoeff = (c(44)*(M(3)-M(4))+c(43)*(M(10)-M(11))) * den(1274)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(40)*(M(3)-M(4))+c(39)*(M(10)-M(11))) * den(1274)
  T3sum(1:35,189) = T3sum(1:35,189) + Gcoeff * G3tensor(:,150)
  Gcoeff = (c(40)*(M(2)-M(5))+c(39)*(M(10)-M(11))) * den(1274)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,222)
  Gcoeff = (c(44)*(M(3)-M(4))+c(43)*(M(10)-M(11))) * den(1274)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(40)*(M(3)-M(4))+c(39)*(M(10)-M(11))) * den(1274)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,294)
  Gcoeff = (c(42)*(-M(3)+M(4))) * den(1277)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(38)*(-M(3)+M(4))) * den(1277)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,151)
  Gcoeff = (c(36)*(M(3)-M(4))) * den(1277)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,223)
  Gcoeff = (c(38)*(M(3)-M(4))) * den(1277)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(36)*(M(3)-M(4))) * den(1277)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,295)
  Gcoeff = (c(44)*(M(3)-M(4))) * den(1278)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(40)*(M(3)-M(4))) * den(1278)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,152)
  Gcoeff = (c(40)*(M(3)-M(4))) * den(1278)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,224)
  Gcoeff = (c(44)*(M(3)-M(4))) * den(1278)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(40)*(M(3)-M(4))) * den(1278)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,296)
  Gcoeff = (c(42)*(-M(2)+M(5))) * den(1279)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(38)*(-M(2)+M(5))) * den(1279)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,153)
  Gcoeff = (c(36)*(M(2)-M(5))) * den(1279)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,225)
  Gcoeff = (c(38)*(M(2)-M(5))) * den(1279)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(36)*(M(2)-M(5))) * den(1279)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,297)
  Gcoeff = (c(44)*(M(2)-M(5))) * den(1280)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(40)*(M(2)-M(5))) * den(1280)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,154)
  Gcoeff = (c(40)*(M(2)-M(5))) * den(1280)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,226)
  Gcoeff = (c(44)*(M(2)-M(5))) * den(1280)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(40)*(M(2)-M(5))) * den(1280)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,298)
  Gcoeff = (c(42)*(-M(1)+M(4))) * den(970)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(38)*(-M(1)+M(4))) * den(970)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(42)*(-M(1)+M(4))) * den(970)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(38)*(-M(1)+M(4))) * den(970)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,257)
  Gcoeff = (c(38)*(-M(2)+M(6))) * den(970)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,185)
  Gcoeff = (c(44)*(M(1)-M(4))) * den(971)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(40)*(M(1)-M(4))) * den(971)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(44)*(M(1)-M(4))) * den(971)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(40)*(M(1)-M(4))) * den(971)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,258)
  Gcoeff = (c(40)*(M(2)-M(6))) * den(971)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,186)
  Gcoeff = (c(42)*(M(1)-M(5))) * den(974)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(38)*(M(1)-M(5))) * den(974)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,155)
  Gcoeff = (c(42)*(M(1)-M(5))) * den(974)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(38)*(M(1)-M(5))) * den(974)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,299)
  Gcoeff = (c(38)*(M(3)-M(6))) * den(974)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,227)
  Gcoeff = (c(44)*(-M(1)+M(5))) * den(975)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(40)*(-M(1)+M(5))) * den(975)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,156)
  Gcoeff = (c(44)*(-M(1)+M(5))) * den(975)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(40)*(-M(1)+M(5))) * den(975)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,300)
  Gcoeff = (c(40)*(-M(3)+M(6))) * den(975)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,228)
  Gcoeff = (c(52)*M(3)-c(51)*M(11)) * den(666)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(48)*M(3)-c(47)*M(11)) * den(666)
  T4sum(1:70,164) = T4sum(1:70,164) + Gcoeff * G4tensor(:,36)
  Gcoeff = (c(48)*M(5)-c(47)*M(10)) * den(666)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,54)
  Gcoeff = (c(52)*M(3)-c(51)*M(11)) * den(666)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(48)*M(3)-c(47)*M(11)) * den(666)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,72)
  Gcoeff = (-(c(54)*M(3))+c(53)*M(11)) * den(668)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,17)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(11)) * den(668)
  T4sum(1:70,164) = T4sum(1:70,164) + Gcoeff * G4tensor(:,37)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(10)) * den(668)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,55)
  Gcoeff = (-(c(54)*M(3))+c(53)*M(11)) * den(668)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,17)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(11)) * den(668)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,73)
  Gcoeff = (c(52)*M(4)-c(51)*M(9)) * den(976)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(48)*M(4)-c(47)*M(9)) * den(976)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(52)*M(4)-c(51)*M(9)) * den(976)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(48)*M(4)-c(47)*M(9)) * den(976)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,259)
  Gcoeff = (c(48)*M(6)-c(47)*M(9)) * den(976)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,187)
  Gcoeff = (-(c(54)*M(4))+c(53)*M(9)) * den(977)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(977)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,116)
  Gcoeff = (-(c(54)*M(4))+c(53)*M(9)) * den(977)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(50)*M(4))+c(49)*M(9)) * den(977)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,260)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(9)) * den(977)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,188)
  Gcoeff = (c(52)*M(1)-c(51)*M(7)) * den(988)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(48)*M(1)-c(47)*M(7)) * den(988)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,157)
  Gcoeff = (c(52)*M(1)-c(51)*M(7)) * den(988)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(48)*M(1)-c(47)*M(7)) * den(988)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,301)
  Gcoeff = (c(48)*M(3)-c(47)*M(7)) * den(988)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,229)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(7)) * den(989)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,86)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(989)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,158)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(7)) * den(989)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,86)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(7)) * den(989)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,302)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(7)) * den(989)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,230)
  Gcoeff = (c(42)*(-M(1)+M(4))) * den(994)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(38)*(-M(1)+M(4))) * den(994)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,117)
  Gcoeff = (c(42)*(-M(1)+M(4))) * den(994)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(38)*(-M(1)+M(4))) * den(994)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,261)
  Gcoeff = (c(38)*(-M(2)+M(6))) * den(994)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,189)
  Gcoeff = (c(44)*(M(1)-M(4))) * den(995)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(40)*(M(1)-M(4))) * den(995)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(44)*(M(1)-M(4))) * den(995)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(40)*(M(1)-M(4))) * den(995)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,262)
  Gcoeff = (c(40)*(M(2)-M(6))) * den(995)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,190)
  Gcoeff = (c(42)*(M(1)-M(5))) * den(998)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(38)*(M(1)-M(5))) * den(998)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,159)
  Gcoeff = (c(42)*(M(1)-M(5))) * den(998)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(38)*(M(1)-M(5))) * den(998)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,303)
  Gcoeff = (c(38)*(M(3)-M(6))) * den(998)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,231)
  Gcoeff = (c(44)*(-M(1)+M(5))) * den(999)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(40)*(-M(1)+M(5))) * den(999)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,160)
  Gcoeff = (c(44)*(-M(1)+M(5))) * den(999)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(40)*(-M(1)+M(5))) * den(999)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,304)
  Gcoeff = (c(40)*(-M(3)+M(6))) * den(999)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,232)
  Gcoeff = (c(52)*M(3)-c(51)*M(11)) * den(657)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(48)*M(3)-c(47)*M(11)) * den(657)
  T4sum(1:70,164) = T4sum(1:70,164) + Gcoeff * G4tensor(:,38)
  Gcoeff = (c(48)*M(5)-c(47)*M(10)) * den(657)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,56)
  Gcoeff = (c(52)*M(3)-c(51)*M(11)) * den(657)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(48)*M(3)-c(47)*M(11)) * den(657)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,74)
  Gcoeff = (-(c(54)*M(3))+c(53)*M(11)) * den(659)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,19)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(11)) * den(659)
  T4sum(1:70,164) = T4sum(1:70,164) + Gcoeff * G4tensor(:,39)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(10)) * den(659)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,57)
  Gcoeff = (-(c(54)*M(3))+c(53)*M(11)) * den(659)
  T4sum(1:70,163) = T4sum(1:70,163) + Gcoeff * G4tensor(:,19)
  Gcoeff = (-(c(50)*M(3))+c(49)*M(11)) * den(659)
  T4sum(1:70,165) = T4sum(1:70,165) + Gcoeff * G4tensor(:,75)
  Gcoeff = (c(52)*M(1)-c(51)*M(9)) * den(1000)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(48)*M(1)-c(47)*M(9)) * den(1000)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(52)*M(1)-c(51)*M(9)) * den(1000)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(48)*M(1)-c(47)*M(9)) * den(1000)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,263)
  Gcoeff = (c(48)*M(2)-c(47)*M(9)) * den(1000)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,191)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(9)) * den(1001)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,37)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(1001)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,120)
  Gcoeff = (-(c(54)*M(1))+c(53)*M(9)) * den(1001)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,37)
  Gcoeff = (-(c(50)*M(1))+c(49)*M(9)) * den(1001)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,264)
  Gcoeff = (-(c(50)*M(2))+c(49)*M(9)) * den(1001)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,192)
  Gcoeff = (c(52)*M(5)-c(51)*M(7)) * den(1004)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(48)*M(5)-c(47)*M(7)) * den(1004)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,161)
  Gcoeff = (c(52)*M(5)-c(51)*M(7)) * den(1004)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(48)*M(5)-c(47)*M(7)) * den(1004)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,305)
  Gcoeff = (c(48)*M(6)-c(47)*M(7)) * den(1004)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,233)
  Gcoeff = (-(c(54)*M(5))+c(53)*M(7)) * den(1005)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,90)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(1005)
  T3sum(1:35,163) = T3sum(1:35,163) + Gcoeff * G3tensor(:,162)
  Gcoeff = (-(c(54)*M(5))+c(53)*M(7)) * den(1005)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,90)
  Gcoeff = (-(c(50)*M(5))+c(49)*M(7)) * den(1005)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,306)
  Gcoeff = (-(c(50)*M(6))+c(49)*M(7)) * den(1005)
  T3sum(1:35,164) = T3sum(1:35,164) + Gcoeff * G3tensor(:,234)

end subroutine vamp_3

end module ol_vamp_3_ppllttj_eexttxggg_1_/**/REALKIND
