
module ol_colourmatrix_ppllttj_nenexttxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(180,6), K2(6,11), KL(6,11)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  384,  -48,  -48,    6,    6,   60]
  K1(  2,:) = [  -48,  384,    6,   60,  -48,    6]
  K1(  3,:) = [  -48,    6,  384,  -48,   60,    6]
  K1(  4,:) = [    6,   60,  -48,  384,    6,  -48]
  K1(  5,:) = [    6,  -48,   60,    6,  384,  -48]
  K1(  6,:) = [   60,    6,    6,  -48,  -48,  384]
  K1(  7,:) = [    0,    0,    0,    0,    0,    0]
  K1(  8,:) = [    0,    0,    0,    0,    0,    0]
  K1(  9,:) = [    0,    0,    0,    0,    0,    0]
  K1( 10,:) = [    0,    0,    0,    0,    0,    0]
  K1( 11,:) = [    0,    0,    0,    0,    0,    0]
  K1( 12,:) = [    0,    0,    0,    0,    0,    0]
  K1( 13,:) = [    0,    0,    0,    0,    0,    0]
  K1( 14,:) = [    0,    0,    0,    0,    0,    0]
  K1( 15,:) = [    0,    0,    0,    0,    0,    0]
  K1( 16,:) = [    0,    0,    0,    0,    0,    0]
  K1( 17,:) = [    0,    0,    0,    0,    0,    0]
  K1( 18,:) = [    0,    0,    0,    0,    0,    0]
  K1( 19,:) = [    0,    0,    0,    0,    0,    0]
  K1( 20,:) = [    0,    0,    0,    0,    0,    0]
  K1( 21,:) = [    0,    0,    0,    0,    0,    0]
  K1( 22,:) = [    0,    0,    0,    0,    0,    0]
  K1( 23,:) = [    0,    0,    0,    0,    0,    0]
  K1( 24,:) = [    0,    0,    0,    0,    0,    0]
  K1( 25,:) = [    0,    0,    0,    0,    0,    0]
  K1( 26,:) = [    0,    0,    0,    0,    0,    0]
  K1( 27,:) = [    0,    0,    0,    0,    0,    0]
  K1( 28,:) = [    0,    0,    0,    0,    0,    0]
  K1( 29,:) = [    0,    0,    0,    0,    0,    0]
  K1( 30,:) = [    0,    0,    0,    0,    0,    0]
  K1( 31,:) = [    0,    0,    0,    0,    0,    0]
  K1( 32,:) = [    0,    0,    0,    0,    0,    0]
  K1( 33,:) = [    0,    0,    0,    0,    0,    0]
  K1( 34,:) = [    0,    0,    0,    0,    0,    0]
  K1( 35,:) = [    0,    0,    0,    0,    0,    0]
  K1( 36,:) = [    0,    0,    0,    0,    0,    0]
  K1( 37,:) = [  512,  -64,  -64,    8,    8,   80]
  K1( 38,:) = [  -64,  512,    8,   80,  -64,    8]
  K1( 39,:) = [  -64,    8,  512,  -64,   80,    8]
  K1( 40,:) = [    8,   80,  -64,  512,    8,  -64]
  K1( 41,:) = [    8,  -64,   80,    8,  512,  -64]
  K1( 42,:) = [   80,    8,    8,  -64,  -64,  512]
  K1( 43,:) = [    0,    0,    0,    0,    0,    0]
  K1( 44,:) = [    0,    0,    0,    0,    0,    0]
  K1( 45,:) = [    0,    0,    0,    0,    0,    0]
  K1( 46,:) = [    0,    0,    0,    0,    0,    0]
  K1( 47,:) = [    0,    0,    0,    0,    0,    0]
  K1( 48,:) = [    0,    0,    0,    0,    0,    0]
  K1( 49,:) = [    0,    0,    0,    0,    0,    0]
  K1( 50,:) = [    0,    0,    0,    0,    0,    0]
  K1( 51,:) = [    0,    0,    0,    0,    0,    0]
  K1( 52,:) = [    0,    0,    0,    0,    0,    0]
  K1( 53,:) = [    0,    0,    0,    0,    0,    0]
  K1( 54,:) = [    0,    0,    0,    0,    0,    0]
  K1( 55,:) = [    1,   10,   10,  -62,  -62,   28]
  K1( 56,:) = [   10,    1,  -62,   28,   10,  -62]
  K1( 57,:) = [   10,  -62,    1,   10,   28,  -62]
  K1( 58,:) = [  -62,   28,   10,    1,  -62,   10]
  K1( 59,:) = [  -62,   10,   28,  -62,    1,   10]
  K1( 60,:) = [   28,  -62,  -62,   10,   10,    1]
  K1( 61,:) = [  512,  -64,  -64,    8,    8,   80]
  K1( 62,:) = [  -64,  512,    8,   80,  -64,    8]
  K1( 63,:) = [  -64,    8,  512,  -64,   80,    8]
  K1( 64,:) = [    8,   80,  -64,  512,    8,  -64]
  K1( 65,:) = [    8,  -64,   80,    8,  512,  -64]
  K1( 66,:) = [   80,    8,    8,  -64,  -64,  512]
  K1( 67,:) = [    0,    0,    0,    0,    0,    0]
  K1( 68,:) = [    0,    0,    0,    0,    0,    0]
  K1( 69,:) = [    0,    0,    0,    0,    0,    0]
  K1( 70,:) = [    0,    0,    0,    0,    0,    0]
  K1( 71,:) = [    0,    0,    0,    0,    0,    0]
  K1( 72,:) = [    0,    0,    0,    0,    0,    0]
  K1( 73,:) = [    0,    0,    0,    0,    0,    0]
  K1( 74,:) = [    0,    0,    0,    0,    0,    0]
  K1( 75,:) = [    0,    0,    0,    0,    0,    0]
  K1( 76,:) = [    0,    0,    0,    0,    0,    0]
  K1( 77,:) = [    0,    0,    0,    0,    0,    0]
  K1( 78,:) = [    0,    0,    0,    0,    0,    0]
  K1( 79,:) = [   -9,  -90,   -9,   -9,   72,  -90]
  K1( 80,:) = [  -90,   -9,   72,  -90,   -9,   -9]
  K1( 81,:) = [   -9,   72,   72,   72,   72,   -9]
  K1( 82,:) = [   -9,  -90,   72, -576,   -9,   72]
  K1( 83,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 84,:) = [  -90,   -9,   -9,   72,   72, -576]
  K1( 85,:) = [ -576,   72,   72,   -9,   -9,  -90]
  K1( 86,:) = [   72, -576,   -9,  -90,   72,   -9]
  K1( 87,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 88,:) = [   -9,  -90,   -9,   -9,   72,  -90]
  K1( 89,:) = [   -9,   72,   72,   72,   72,   -9]
  K1( 90,:) = [  -90,   -9,   72,  -90,   -9,   -9]
  K1( 91,:) = [ 1152, -144, -144,   18,   18,  180]
  K1( 92,:) = [ -144, 1152,   18,  180, -144,   18]
  K1( 93,:) = [ -144,   18, 1152, -144,  180,   18]
  K1( 94,:) = [   18,  180, -144, 1152,   18, -144]
  K1( 95,:) = [   18, -144,  180,   18, 1152, -144]
  K1( 96,:) = [  180,   18,   18, -144, -144, 1152]
  K1( 97,:) = [    0,    0,    0,    0,    0,    0]
  K1( 98,:) = [    0,    0,    0,    0,    0,    0]
  K1( 99,:) = [    0,    0,    0,    0,    0,    0]
  K1(100,:) = [    0,    0,    0,    0,    0,    0]
  K1(101,:) = [    0,    0,    0,    0,    0,    0]
  K1(102,:) = [    0,    0,    0,    0,    0,    0]
  K1(103,:) = [    0,    0,    0,    0,    0,    0]
  K1(104,:) = [    0,    0,    0,    0,    0,    0]
  K1(105,:) = [    0,    0,    0,    0,    0,    0]
  K1(106,:) = [    0,    0,    0,    0,    0,    0]
  K1(107,:) = [    0,    0,    0,    0,    0,    0]
  K1(108,:) = [    0,    0,    0,    0,    0,    0]
  K1(109,:) = [   72,   72,   -9,   72,   -9,   72]
  K1(110,:) = [   72, -576,   -9,  -90,   72,   -9]
  K1(111,:) = [   -9,   -9,   -9,  -90,  -90,   72]
  K1(112,:) = [   72,  -90,  -90,   -9,   -9,   -9]
  K1(113,:) = [   -9,   72,  -90,   -9, -576,   72]
  K1(114,:) = [   72,   -9,   72,   -9,   72,   72]
  K1(115,:) = [   72,   -9,   72,   -9,   72,   72]
  K1(116,:) = [   -9,   -9,   -9,  -90,  -90,   72]
  K1(117,:) = [   72,   -9, -576,   72,  -90,   -9]
  K1(118,:) = [   -9,  -90,   72, -576,   -9,   72]
  K1(119,:) = [   72,  -90,  -90,   -9,   -9,   -9]
  K1(120,:) = [   72,   72,   -9,   72,   -9,   72]
  K1(121,:) = [ -648,   81,    0,    0,  -81, -162]
  K1(122,:) = [   81,   81,    0,  162,   81,    0]
  K1(123,:) = [    0,    0, -648,   81, -162,  -81]
  K1(124,:) = [    0,  162,   81,   81,    0,   81]
  K1(125,:) = [  -81,   81, -162,    0, -648,    0]
  K1(126,:) = [ -162,    0,  -81,   81,    0, -648]
  K1(127,:) = [ 1152, -144, -144,   18,   18,  180]
  K1(128,:) = [ -144, 1152,   18,  180, -144,   18]
  K1(129,:) = [ -144,   18, 1152, -144,  180,   18]
  K1(130,:) = [   18,  180, -144, 1152,   18, -144]
  K1(131,:) = [   18, -144,  180,   18, 1152, -144]
  K1(132,:) = [  180,   18,   18, -144, -144, 1152]
  K1(133,:) = [    0,    0,    0,    0,    0,    0]
  K1(134,:) = [    0,    0,    0,    0,    0,    0]
  K1(135,:) = [    0,    0,    0,    0,    0,    0]
  K1(136,:) = [    0,    0,    0,    0,    0,    0]
  K1(137,:) = [    0,    0,    0,    0,    0,    0]
  K1(138,:) = [    0,    0,    0,    0,    0,    0]
  K1(139,:) = [    0,    0,    0,    0,    0,    0]
  K1(140,:) = [    0,    0,    0,    0,    0,    0]
  K1(141,:) = [    0,    0,    0,    0,    0,    0]
  K1(142,:) = [    0,    0,    0,    0,    0,    0]
  K1(143,:) = [    0,    0,    0,    0,    0,    0]
  K1(144,:) = [    0,    0,    0,    0,    0,    0]
  K1(145,:) = [ -576,   72,   72,   -9,   -9,  -90]
  K1(146,:) = [   72,   72,   -9,   72,   -9,   72]
  K1(147,:) = [   72,   -9, -576,   72,  -90,   -9]
  K1(148,:) = [   -9,   72,   72,   72,   72,   -9]
  K1(149,:) = [   -9,   -9,  -90,   72,   -9,  -90]
  K1(150,:) = [  -90,   72,   -9,   -9,  -90,   -9]
  K1(151,:) = [   -9,   -9,  -90,   72,   -9,  -90]
  K1(152,:) = [   -9,   72,   72,   72,   72,   -9]
  K1(153,:) = [  -90,   72,   -9,   -9,  -90,   -9]
  K1(154,:) = [   72,   72,   -9,   72,   -9,   72]
  K1(155,:) = [   -9,   72,  -90,   -9, -576,   72]
  K1(156,:) = [  -90,   -9,   -9,   72,   72, -576]
  K1(157,:) = [   81,   81,   81,    0,    0,  162]
  K1(158,:) = [   81, -648,  -81, -162,    0,    0]
  K1(159,:) = [   81,  -81, -648,    0, -162,    0]
  K1(160,:) = [    0, -162,    0, -648,  -81,   81]
  K1(161,:) = [    0,    0, -162,  -81, -648,   81]
  K1(162,:) = [  162,    0,    0,   81,   81,   81]
  K1(163,:) = [ -648,    0,   81,  -81,    0, -162]
  K1(164,:) = [    0, -648,    0, -162,   81,  -81]
  K1(165,:) = [   81,    0,   81,   81,  162,    0]
  K1(166,:) = [  -81, -162,   81, -648,    0,    0]
  K1(167,:) = [    0,   81,  162,    0,   81,   81]
  K1(168,:) = [ -162,  -81,    0,    0,   81, -648]
  K1(169,:) = [ 1152, -144, -144,   18,   18,  180]
  K1(170,:) = [ -144, 1152,   18,  180, -144,   18]
  K1(171,:) = [ -144,   18, 1152, -144,  180,   18]
  K1(172,:) = [   18,  180, -144, 1152,   18, -144]
  K1(173,:) = [   18, -144,  180,   18, 1152, -144]
  K1(174,:) = [  180,   18,   18, -144, -144, 1152]
  K1(175,:) = [    0,    0,    0,    0,    0,    0]
  K1(176,:) = [    0,    0,    0,    0,    0,    0]
  K1(177,:) = [    0,    0,    0,    0,    0,    0]
  K1(178,:) = [    0,    0,    0,    0,    0,    0]
  K1(179,:) = [    0,    0,    0,    0,    0,    0]
  K1(180,:) = [    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 54) * K1

  K2(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  K2(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  K2(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  K2(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  K2(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  K2(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  K2 = (1._/**/REALKIND / 9) * K2

  KL(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  KL(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  KL(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  KL(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  KL(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  KL(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  KL = (1._/**/REALKIND / 9) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllttj_nenexttxggg_1_/**/REALKIND



module ol_forced_parameters_ppllttj_nenexttxggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllttj_nenexttxggg_1_/**/REALKIND

module ol_loop_ppllttj_nenexttxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(22), c(25)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:642)
  ! denominators
  complex(REALKIND), save :: den(854)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(6,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**2*gQCD**3
    f( 2) = eQED**2*gQCD**3
    f( 3) = CI*countertermnorm*eQED**2*gQCD**5
    f( 4) = countertermnorm*eQED**2*gQCD**5
    f( 5) = CI*countertermnorm*ctGtt*eQED**2*gQCD**5
    f( 6) = countertermnorm*ctGtt*eQED**2*gQCD**5
    f( 7) = CI*countertermnorm*ctVtt*eQED**2*gQCD**5
    f( 8) = countertermnorm*ctVtt*eQED**2*gQCD**5
    f( 9) = CI*countertermnorm*ctVVV*eQED**2*gQCD**5
    f(10) = countertermnorm*ctVVV*eQED**2*gQCD**5
    f(11) = CI*countertermnorm*ctVVVV*eQED**2*gQCD**5
    f(12) = CI*countertermnorm*ctZGG*eQED**2*gQCD**5
    f(13) = countertermnorm*ctZGG*eQED**2*gQCD**5
    f(14) = CI*countertermnorm*eQED**2*gQCD**5*R2GGGG
    f(15) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(16) = CI*eQED**2*gQCD**5*integralnorm*SwB
    f(17) = (eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(18) = eQED**2*gQCD**5*integralnorm*SwB
    f(19) = CI*eQED**2*gQCD**5*integralnorm*SwF
    f(20) = 2*CI*eQED**2*gQCD**5*integralnorm*SwF
    f(21) = eQED**2*gQCD**5*integralnorm*SwF
    f(22) = 2*eQED**2*gQCD**5*integralnorm*SwF

  c = [ 9*CI*f(15), 18*CI*f(15), CI*f(16), 3*CI*f(16), 8*CI*f(16), 9*CI*f(16), 18*CI*f(16), 3*f(17), 6*f(17), 9*f(17), 18*f(17) &
    , f(18), 3*f(18), 6*f(18), 8*f(18), 9*f(18), 18*f(18), CI*f(19), 3*CI*f(19), CI*f(20), 3*CI*f(20), f(21), 3*f(21), f(22) &
    , 3*f(22) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(6), M2(11)
  complex(REALKIND) :: A(519)
  ! external WFs
  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rMT, H(3), wf(:,-2))
  call wf_A(P(:,4), rMT, H(4), wf(:,-3))
  call wf_V(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_V(P(:,6), rZERO, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))

  ! internal WFs
  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,-6),wf(:,2))
  call prop_W_W(wf(:,1),Q(:,3),MZ,1_intkind1,wf(:,3))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,-2),wf(:,4))
  call vert_AV_Q(wf(:,-3),wf(:,2),wf(:,5))
  call prop_Q_A(wf(:,4),Q(:,7),MT,1_intkind1,wf(:,6))
  call vert_GGG_G(wf(:,-5),wf(:,-6),wf(:,-4),wf(:,7))
  call vert_AV_Q(wf(:,-3),wf(:,7),wf(:,8))
  call vert_GGG_G(wf(:,-6),wf(:,-4),wf(:,-5),wf(:,9))
  call vert_AV_Q(wf(:,-3),wf(:,9),wf(:,10))
  call vert_VQ_A(wf(:,2),wf(:,-2),wf(:,11))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,3),wf(:,12))
  call prop_Q_A(wf(:,11),Q(:,116),MT,1_intkind1,wf(:,13))
  call vert_VQ_A(wf(:,7),wf(:,-2),wf(:,14))
  call prop_Q_A(wf(:,14),Q(:,116),MT,1_intkind1,wf(:,15))
  call vert_VQ_A(wf(:,9),wf(:,-2),wf(:,16))
  call prop_Q_A(wf(:,16),Q(:,116),MT,1_intkind1,wf(:,17))
  call vert_VQ_A(wf(:,-4),wf(:,-2),wf(:,18))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,19))
  call prop_Q_A(wf(:,18),Q(:,20),MT,1_intkind1,wf(:,20))
  call prop_A_Q(wf(:,19),Q(:,40),MT,1_intkind1,wf(:,21))
  call vert_VQ_A(wf(:,-6),wf(:,20),wf(:,22))
  call vert_AZ_Q(gZu,wf(:,21),wf(:,3),wf(:,23))
  call prop_Q_A(wf(:,22),Q(:,84),MT,1_intkind1,wf(:,24))
  call vert_AV_Q(wf(:,21),wf(:,-6),wf(:,25))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,20),wf(:,26))
  call prop_A_Q(wf(:,25),Q(:,104),MT,1_intkind1,wf(:,27))
  call vert_AV_Q(wf(:,-3),wf(:,-6),wf(:,28))
  call prop_A_Q(wf(:,28),Q(:,72),MT,1_intkind1,wf(:,29))
  call vert_VQ_A(wf(:,-5),wf(:,20),wf(:,30))
  call vert_AZ_Q(gZu,wf(:,29),wf(:,3),wf(:,31))
  call prop_Q_A(wf(:,30),Q(:,52),MT,1_intkind1,wf(:,32))
  call vert_AV_Q(wf(:,29),wf(:,-5),wf(:,33))
  call prop_A_Q(wf(:,33),Q(:,104),MT,1_intkind1,wf(:,34))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,-6),Q(:,64),wf(:,35))
  call vert_VQ_A(wf(:,35),wf(:,20),wf(:,36))
  call prop_A_Q(wf(:,12),Q(:,11),MT,1_intkind1,wf(:,37))
  call vert_AV_Q(wf(:,-3),wf(:,35),wf(:,38))
  call prop_A_Q(wf(:,38),Q(:,104),MT,1_intkind1,wf(:,39))
  call vert_AV_Q(wf(:,37),wf(:,-6),wf(:,40))
  call vert_AV_Q(wf(:,37),wf(:,-5),wf(:,41))
  call vert_VQ_A(wf(:,-5),wf(:,-2),wf(:,42))
  call vert_AV_Q(wf(:,-3),wf(:,-4),wf(:,43))
  call prop_Q_A(wf(:,42),Q(:,36),MT,1_intkind1,wf(:,44))
  call prop_A_Q(wf(:,43),Q(:,24),MT,1_intkind1,wf(:,45))
  call vert_VQ_A(wf(:,-6),wf(:,44),wf(:,46))
  call vert_AZ_Q(gZu,wf(:,45),wf(:,3),wf(:,47))
  call prop_Q_A(wf(:,46),Q(:,100),MT,1_intkind1,wf(:,48))
  call vert_AV_Q(wf(:,45),wf(:,-6),wf(:,49))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,44),wf(:,50))
  call prop_A_Q(wf(:,49),Q(:,88),MT,1_intkind1,wf(:,51))
  call vert_VQ_A(wf(:,-6),wf(:,-2),wf(:,52))
  call prop_Q_A(wf(:,52),Q(:,68),MT,1_intkind1,wf(:,53))
  call vert_VQ_A(wf(:,-5),wf(:,53),wf(:,54))
  call prop_Q_A(wf(:,54),Q(:,100),MT,1_intkind1,wf(:,55))
  call vert_AV_Q(wf(:,45),wf(:,-5),wf(:,56))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,53),wf(:,57))
  call prop_A_Q(wf(:,56),Q(:,56),MT,1_intkind1,wf(:,58))
  call vert_AV_Q(wf(:,45),wf(:,35),wf(:,59))
  call vert_VQ_A(wf(:,35),wf(:,-2),wf(:,60))
  call prop_Q_A(wf(:,60),Q(:,100),MT,1_intkind1,wf(:,61))
  call vert_VQ_A(wf(:,-5),wf(:,6),wf(:,62))
  call vert_VQ_A(wf(:,-6),wf(:,6),wf(:,63))
  call vert_VQ_A(wf(:,-4),wf(:,44),wf(:,64))
  call prop_Q_A(wf(:,64),Q(:,52),MT,1_intkind1,wf(:,65))
  call vert_AV_Q(wf(:,29),wf(:,-4),wf(:,66))
  call prop_A_Q(wf(:,66),Q(:,88),MT,1_intkind1,wf(:,67))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-6),Q(:,64),wf(:,68))
  call vert_VQ_A(wf(:,68),wf(:,44),wf(:,69))
  call vert_AV_Q(wf(:,-3),wf(:,68),wf(:,70))
  call prop_A_Q(wf(:,70),Q(:,88),MT,1_intkind1,wf(:,71))
  call vert_AV_Q(wf(:,37),wf(:,-4),wf(:,72))
  call vert_VQ_A(wf(:,-4),wf(:,53),wf(:,73))
  call prop_Q_A(wf(:,73),Q(:,84),MT,1_intkind1,wf(:,74))
  call vert_AV_Q(wf(:,21),wf(:,-4),wf(:,75))
  call prop_A_Q(wf(:,75),Q(:,56),MT,1_intkind1,wf(:,76))
  call vert_AV_Q(wf(:,21),wf(:,68),wf(:,77))
  call vert_VQ_A(wf(:,68),wf(:,-2),wf(:,78))
  call prop_Q_A(wf(:,78),Q(:,84),MT,1_intkind1,wf(:,79))
  call vert_VQ_A(wf(:,-4),wf(:,6),wf(:,80))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,81))
  call vert_VQ_A(wf(:,81),wf(:,53),wf(:,82))
  call vert_AV_Q(wf(:,-3),wf(:,81),wf(:,83))
  call prop_A_Q(wf(:,83),Q(:,56),MT,1_intkind1,wf(:,84))
  call vert_AV_Q(wf(:,29),wf(:,81),wf(:,85))
  call vert_VQ_A(wf(:,81),wf(:,-2),wf(:,86))
  call prop_Q_A(wf(:,86),Q(:,52),MT,1_intkind1,wf(:,87))
  call vert_UV_W(wf(:,81),Q(:,48),wf(:,-6),Q(:,64),wf(:,88))
  call vert_QA_V(wf(:,6),wf(:,-3),wf(:,89))
  call vert_QA_V(wf(:,-2),wf(:,37),wf(:,90))
  call vert_VQ_A(wf(:,-6),wf(:,87),wf(:,91))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,68),Q(:,80),wf(:,92))
  call vert_VQ_A(wf(:,-5),wf(:,79),wf(:,93))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,35),Q(:,96),wf(:,94))
  call vert_VQ_A(wf(:,-4),wf(:,61),wf(:,95))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,96))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,96),wf(:,-6),wf(:,97))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-6),wf(:,96),wf(:,98))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,96),wf(:,-5),wf(:,99))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-5),wf(:,96),wf(:,100))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,-4),Q(:,16),wf(:,101))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-5),wf(:,-6),wf(:,102))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-6),wf(:,-5),wf(:,103))
  call counter_VG_G(wf(:,3),wf(:,96),Q(:,12),wf(:,104),Q(:,15))
  call vert_GGG_G(wf(:,96),wf(:,-4),wf(:,-5),wf(:,105))
  call counter_VG_G(wf(:,3),wf(:,-6),Q(:,64),wf(:,106),Q(:,67))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,96),wf(:,107))
  call vert_GGG_G(wf(:,-5),wf(:,96),wf(:,-4),wf(:,108))
  call vert_GGG_G(wf(:,96),wf(:,-4),wf(:,-6),wf(:,109))
  call counter_VG_G(wf(:,3),wf(:,-5),Q(:,32),wf(:,110),Q(:,35))
  call vert_GGG_G(wf(:,-4),wf(:,-6),wf(:,96),wf(:,111))
  call vert_GGG_G(wf(:,-6),wf(:,96),wf(:,-4),wf(:,112))
  call vert_GGG_G(wf(:,96),wf(:,-5),wf(:,-6),wf(:,113))
  call counter_VG_G(wf(:,3),wf(:,-4),Q(:,16),wf(:,114),Q(:,19))
  call vert_GGG_G(wf(:,-5),wf(:,-6),wf(:,96),wf(:,115))
  call vert_GGG_G(wf(:,-6),wf(:,96),wf(:,-5),wf(:,116))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,96),wf(:,-4),wf(:,117))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-4),wf(:,96),wf(:,118))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,-5),Q(:,32),wf(:,119))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-4),wf(:,-6),wf(:,120))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-6),wf(:,-4),wf(:,121))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,-6),Q(:,64),wf(:,122))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-4),wf(:,-5),wf(:,123))
  call counter_VGG_G(ctZGGG,wf(:,3),wf(:,-5),wf(:,-4),wf(:,124))
  call vert_QA_V(wf(:,20),wf(:,-3),wf(:,125))
  call vert_QA_V(wf(:,-2),wf(:,45),wf(:,126))
  call vert_QA_V(wf(:,44),wf(:,-3),wf(:,127))
  call vert_QA_V(wf(:,-2),wf(:,21),wf(:,128))
  call vert_QA_V(wf(:,53),wf(:,-3),wf(:,129))
  call vert_QA_V(wf(:,-2),wf(:,29),wf(:,130))
  call counter_GGG_G(wf(:,-4),wf(:,-5),wf(:,-6),wf(:,131))
  call vert_AV_Q(wf(:,-3),wf(:,131),wf(:,132))
  call counter_GGG_G(wf(:,-5),wf(:,-6),wf(:,-4),wf(:,133))
  call vert_AV_Q(wf(:,-3),wf(:,133),wf(:,134))
  call counter_GGG_G(wf(:,-6),wf(:,-4),wf(:,-5),wf(:,135))
  call vert_AV_Q(wf(:,-3),wf(:,135),wf(:,136))
  call vert_VQ_A(wf(:,131),wf(:,-2),wf(:,137))
  call prop_Q_A(wf(:,137),Q(:,116),MT,1_intkind1,wf(:,138))
  call vert_VQ_A(wf(:,133),wf(:,-2),wf(:,139))
  call prop_Q_A(wf(:,139),Q(:,116),MT,1_intkind1,wf(:,140))
  call vert_VQ_A(wf(:,135),wf(:,-2),wf(:,141))
  call prop_Q_A(wf(:,141),Q(:,116),MT,1_intkind1,wf(:,142))
  call counter_AV_Q(wf(:,-3),wf(:,2),wf(:,143))
  call counter_AV_Q(wf(:,-3),wf(:,7),wf(:,144))
  call counter_AV_Q(wf(:,-3),wf(:,9),wf(:,145))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,3),wf(:,146))
  call counter_VQ_A(wf(:,2),wf(:,-2),wf(:,147))
  call counter_VQ_A(wf(:,7),wf(:,-2),wf(:,148))
  call counter_VQ_A(wf(:,9),wf(:,-2),wf(:,149))
  call counter_ZQ_A(gZu,wf(:,3),wf(:,-2),wf(:,150))
  call prop_A_Q(wf(:,5),Q(:,120),MT,1_intkind1,wf(:,151))
  call prop_A_Q(wf(:,8),Q(:,120),MT,1_intkind1,wf(:,152))
  call prop_A_Q(wf(:,10),Q(:,120),MT,1_intkind1,wf(:,153))
  call counter_VG_G(wf(:,3),wf(:,81),Q(:,48),wf(:,154),Q(:,51))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,81),Q(:,48),wf(:,155))
  call counter_VG_G(wf(:,3),wf(:,68),Q(:,80),wf(:,156),Q(:,83))
  call counter_VG_G(wf(:,3),wf(:,35),Q(:,96),wf(:,157),Q(:,99))
  call vert_UV_W(wf(:,101),Q(:,28),wf(:,-5),Q(:,32),wf(:,158))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,119),Q(:,44),wf(:,159))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,68),Q(:,80),wf(:,160))
  call vert_UV_W(wf(:,101),Q(:,28),wf(:,-6),Q(:,64),wf(:,161))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,110),Q(:,35),wf(:,162))
  call vert_UV_W(wf(:,96),Q(:,12),wf(:,35),Q(:,96),wf(:,163))
  call vert_UV_W(wf(:,114),Q(:,19),wf(:,-6),Q(:,64),wf(:,164))
  call vert_UV_W(wf(:,114),Q(:,19),wf(:,-5),Q(:,32),wf(:,165))
  call counter_AZ_Q(gZu,wf(:,21),wf(:,3),wf(:,166))
  call counter_ZQ_A(gZu,wf(:,3),wf(:,20),wf(:,167))
  call counter_AV_Q(wf(:,21),wf(:,-6),wf(:,168))
  call prop_Q_A(wf(:,26),Q(:,23),MT,1_intkind1,wf(:,169))
  call counter_VQ_A(wf(:,-6),wf(:,20),wf(:,170))
  call prop_A_Q(wf(:,23),Q(:,43),MT,1_intkind1,wf(:,171))
  call vert_QA_V(wf(:,20),wf(:,21),wf(:,172))
  call counter_AZ_Q(gZu,wf(:,29),wf(:,3),wf(:,173))
  call counter_VQ_A(wf(:,35),wf(:,20),wf(:,174))
  call counter_AV_Q(wf(:,37),wf(:,-6),wf(:,175))
  call prop_Q_A(wf(:,170),Q(:,84),MT,1_intkind1,wf(:,176))
  call vert_UV_W(wf(:,125),Q(:,28),wf(:,-5),Q(:,32),wf(:,177))
  call vert_QA_V(wf(:,32),wf(:,-3),wf(:,178))
  call counter_AV_Q(wf(:,29),wf(:,-5),wf(:,179))
  call counter_VQ_A(wf(:,-5),wf(:,20),wf(:,180))
  call prop_A_Q(wf(:,31),Q(:,75),MT,1_intkind1,wf(:,181))
  call vert_QA_V(wf(:,20),wf(:,29),wf(:,182))
  call counter_AV_Q(wf(:,37),wf(:,-5),wf(:,183))
  call prop_Q_A(wf(:,180),Q(:,52),MT,1_intkind1,wf(:,184))
  call vert_UV_W(wf(:,125),Q(:,28),wf(:,-6),Q(:,64),wf(:,185))
  call vert_AV_Q(wf(:,-3),wf(:,110),wf(:,186))
  call counter_UV_W(wf(:,-5),Q(:,32),wf(:,-6),Q(:,64),wf(:,187))
  call vert_VQ_A(wf(:,187),wf(:,20),wf(:,188))
  call vert_AV_Q(wf(:,-3),wf(:,187),wf(:,189))
  call prop_A_Q(wf(:,189),Q(:,104),MT,1_intkind1,wf(:,190))
  call counter_AZ_Q(gZu,wf(:,45),wf(:,3),wf(:,191))
  call counter_ZQ_A(gZu,wf(:,3),wf(:,44),wf(:,192))
  call counter_AV_Q(wf(:,45),wf(:,-6),wf(:,193))
  call prop_Q_A(wf(:,50),Q(:,39),MT,1_intkind1,wf(:,194))
  call counter_VQ_A(wf(:,-6),wf(:,44),wf(:,195))
  call prop_A_Q(wf(:,47),Q(:,27),MT,1_intkind1,wf(:,196))
  call vert_QA_V(wf(:,44),wf(:,45),wf(:,197))
  call counter_ZQ_A(gZu,wf(:,3),wf(:,53),wf(:,198))
  call counter_AV_Q(wf(:,45),wf(:,35),wf(:,199))
  call prop_A_Q(wf(:,193),Q(:,88),MT,1_intkind1,wf(:,200))
  call counter_VQ_A(wf(:,-6),wf(:,6),wf(:,201))
  call vert_UV_W(wf(:,126),Q(:,28),wf(:,-5),Q(:,32),wf(:,202))
  call vert_QA_V(wf(:,-2),wf(:,58),wf(:,203))
  call counter_AV_Q(wf(:,45),wf(:,-5),wf(:,204))
  call prop_Q_A(wf(:,57),Q(:,71),MT,1_intkind1,wf(:,205))
  call counter_VQ_A(wf(:,-5),wf(:,53),wf(:,206))
  call vert_QA_V(wf(:,53),wf(:,45),wf(:,207))
  call prop_A_Q(wf(:,204),Q(:,56),MT,1_intkind1,wf(:,208))
  call counter_VQ_A(wf(:,-5),wf(:,6),wf(:,209))
  call vert_UV_W(wf(:,126),Q(:,28),wf(:,-6),Q(:,64),wf(:,210))
  call vert_VQ_A(wf(:,110),wf(:,-2),wf(:,211))
  call vert_AV_Q(wf(:,45),wf(:,187),wf(:,212))
  call vert_VQ_A(wf(:,187),wf(:,-2),wf(:,213))
  call prop_Q_A(wf(:,213),Q(:,100),MT,1_intkind1,wf(:,214))
  call counter_VQ_A(wf(:,68),wf(:,44),wf(:,215))
  call prop_Q_A(wf(:,195),Q(:,100),MT,1_intkind1,wf(:,216))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,127),Q(:,44),wf(:,217))
  call vert_QA_V(wf(:,65),wf(:,-3),wf(:,218))
  call counter_AV_Q(wf(:,21),wf(:,68),wf(:,219))
  call prop_A_Q(wf(:,168),Q(:,104),MT,1_intkind1,wf(:,220))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,128),Q(:,44),wf(:,221))
  call vert_QA_V(wf(:,-2),wf(:,76),wf(:,222))
  call counter_VQ_A(wf(:,81),wf(:,53),wf(:,223))
  call counter_AV_Q(wf(:,29),wf(:,81),wf(:,224))
  call counter_UV_W(wf(:,81),Q(:,48),wf(:,-6),Q(:,64),wf(:,225))
  call counter_VQ_A(wf(:,-6),wf(:,87),wf(:,226))
  call vert_QA_V(wf(:,87),wf(:,-3),wf(:,227))
  call vert_QA_V(wf(:,-2),wf(:,84),wf(:,228))
  call prop_Q_A(wf(:,206),Q(:,100),MT,1_intkind1,wf(:,229))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,129),Q(:,76),wf(:,230))
  call vert_QA_V(wf(:,74),wf(:,-3),wf(:,231))
  call prop_A_Q(wf(:,179),Q(:,104),MT,1_intkind1,wf(:,232))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,130),Q(:,76),wf(:,233))
  call vert_QA_V(wf(:,-2),wf(:,67),wf(:,234))
  call counter_UV_W(wf(:,-5),Q(:,32),wf(:,68),Q(:,80),wf(:,235))
  call counter_VQ_A(wf(:,-5),wf(:,79),wf(:,236))
  call vert_QA_V(wf(:,79),wf(:,-3),wf(:,237))
  call vert_QA_V(wf(:,-2),wf(:,71),wf(:,238))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,187),Q(:,96),wf(:,239))
  call vert_VQ_A(wf(:,-4),wf(:,214),wf(:,240))
  call counter_Q_A(cttt,wf(:,6),Q(:,7),wf(:,241))
  call counter_Q_A(cttt,wf(:,13),Q(:,116),wf(:,242))
  call counter_Q_A(cttt,wf(:,15),Q(:,116),wf(:,243))
  call counter_Q_A(cttt,wf(:,17),Q(:,116),wf(:,244))
  call counter_V_V(ctGG,wf(:,2),Q(:,112),wf(:,245))
  call vert_VQ_A(wf(:,245),wf(:,-2),wf(:,246))
  call counter_V_V(ctGG,wf(:,7),Q(:,112),wf(:,247))
  call vert_VQ_A(wf(:,247),wf(:,-2),wf(:,248))
  call counter_V_V(ctGG,wf(:,9),Q(:,112),wf(:,249))
  call vert_VQ_A(wf(:,249),wf(:,-2),wf(:,250))
  call vert_AV_Q(wf(:,-3),wf(:,245),wf(:,251))
  call vert_AV_Q(wf(:,-3),wf(:,247),wf(:,252))
  call vert_AV_Q(wf(:,-3),wf(:,249),wf(:,253))
  call counter_AV_Q(wf(:,29),wf(:,-4),wf(:,254))
  call counter_VQ_A(wf(:,-4),wf(:,44),wf(:,255))
  call vert_QA_V(wf(:,44),wf(:,29),wf(:,256))
  call counter_AV_Q(wf(:,37),wf(:,-4),wf(:,257))
  call prop_Q_A(wf(:,255),Q(:,52),MT,1_intkind1,wf(:,258))
  call vert_UV_W(wf(:,127),Q(:,44),wf(:,-6),Q(:,64),wf(:,259))
  call vert_AV_Q(wf(:,-3),wf(:,114),wf(:,260))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,-6),Q(:,64),wf(:,261))
  call vert_VQ_A(wf(:,261),wf(:,44),wf(:,262))
  call vert_AV_Q(wf(:,-3),wf(:,261),wf(:,263))
  call prop_A_Q(wf(:,263),Q(:,88),MT,1_intkind1,wf(:,264))
  call counter_AV_Q(wf(:,21),wf(:,-4),wf(:,265))
  call counter_VQ_A(wf(:,-4),wf(:,53),wf(:,266))
  call vert_QA_V(wf(:,53),wf(:,21),wf(:,267))
  call prop_A_Q(wf(:,265),Q(:,56),MT,1_intkind1,wf(:,268))
  call counter_VQ_A(wf(:,-4),wf(:,6),wf(:,269))
  call vert_UV_W(wf(:,128),Q(:,44),wf(:,-6),Q(:,64),wf(:,270))
  call vert_VQ_A(wf(:,114),wf(:,-2),wf(:,271))
  call vert_AV_Q(wf(:,21),wf(:,261),wf(:,272))
  call vert_VQ_A(wf(:,261),wf(:,-2),wf(:,273))
  call prop_Q_A(wf(:,273),Q(:,84),MT,1_intkind1,wf(:,274))
  call prop_Q_A(wf(:,266),Q(:,84),MT,1_intkind1,wf(:,275))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,129),Q(:,76),wf(:,276))
  call prop_A_Q(wf(:,254),Q(:,88),MT,1_intkind1,wf(:,277))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,130),Q(:,76),wf(:,278))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,35),Q(:,96),wf(:,279))
  call counter_VQ_A(wf(:,-4),wf(:,61),wf(:,280))
  call vert_QA_V(wf(:,61),wf(:,-3),wf(:,281))
  call vert_QA_V(wf(:,-2),wf(:,39),wf(:,282))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,261),Q(:,80),wf(:,283))
  call vert_VQ_A(wf(:,-5),wf(:,274),wf(:,284))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,285))
  call vert_VQ_A(wf(:,285),wf(:,53),wf(:,286))
  call vert_AV_Q(wf(:,-3),wf(:,285),wf(:,287))
  call prop_A_Q(wf(:,287),Q(:,56),MT,1_intkind1,wf(:,288))
  call vert_AV_Q(wf(:,29),wf(:,285),wf(:,289))
  call vert_VQ_A(wf(:,285),wf(:,-2),wf(:,290))
  call prop_Q_A(wf(:,290),Q(:,52),MT,1_intkind1,wf(:,291))
  call vert_UV_W(wf(:,285),Q(:,48),wf(:,-6),Q(:,64),wf(:,292))
  call vert_VQ_A(wf(:,-6),wf(:,291),wf(:,293))
  call counter_AV_Q(wf(:,-3),wf(:,35),wf(:,294))
  call prop_Q_A(wf(:,36),Q(:,116),MT,1_intkind1,wf(:,295))
  call prop_A_Q(wf(:,146),Q(:,11),MT,1_intkind1,wf(:,296))
  call vert_AV_Q(wf(:,296),wf(:,-6),wf(:,297))
  call vert_AV_Q(wf(:,296),wf(:,-5),wf(:,298))
  call counter_AV_Q(wf(:,-3),wf(:,-6),wf(:,299))
  call prop_A_Q(wf(:,299),Q(:,72),MT,1_intkind1,wf(:,300))
  call vert_AZ_Q(gZu,wf(:,300),wf(:,3),wf(:,301))
  call vert_AV_Q(wf(:,300),wf(:,-5),wf(:,302))
  call prop_A_Q(wf(:,302),Q(:,104),MT,1_intkind1,wf(:,303))
  call counter_AV_Q(wf(:,-3),wf(:,-5),wf(:,304))
  call prop_A_Q(wf(:,304),Q(:,40),MT,1_intkind1,wf(:,305))
  call vert_AZ_Q(gZu,wf(:,305),wf(:,3),wf(:,306))
  call vert_AV_Q(wf(:,305),wf(:,-6),wf(:,307))
  call prop_A_Q(wf(:,307),Q(:,104),MT,1_intkind1,wf(:,308))
  call counter_AV_Q(wf(:,-3),wf(:,68),wf(:,309))
  call prop_Q_A(wf(:,69),Q(:,116),MT,1_intkind1,wf(:,310))
  call vert_AV_Q(wf(:,296),wf(:,-4),wf(:,311))
  call vert_AV_Q(wf(:,300),wf(:,-4),wf(:,312))
  call prop_A_Q(wf(:,312),Q(:,88),MT,1_intkind1,wf(:,313))
  call counter_AV_Q(wf(:,-3),wf(:,81),wf(:,314))
  call prop_Q_A(wf(:,82),Q(:,116),MT,1_intkind1,wf(:,315))
  call prop_A_Q(wf(:,314),Q(:,56),MT,1_intkind1,wf(:,316))
  call counter_QA_V(wf(:,6),wf(:,-3),wf(:,317))
  call vert_QA_V(wf(:,-2),wf(:,296),wf(:,318))
  call vert_AV_Q(wf(:,300),wf(:,81),wf(:,319))
  call prop_A_Q(wf(:,309),Q(:,88),MT,1_intkind1,wf(:,320))
  call prop_A_Q(wf(:,294),Q(:,104),MT,1_intkind1,wf(:,321))
  call vert_AV_Q(wf(:,305),wf(:,-4),wf(:,322))
  call prop_A_Q(wf(:,322),Q(:,56),MT,1_intkind1,wf(:,323))
  call vert_AV_Q(wf(:,305),wf(:,68),wf(:,324))
  call counter_AV_Q(wf(:,-3),wf(:,-4),wf(:,325))
  call prop_A_Q(wf(:,325),Q(:,24),MT,1_intkind1,wf(:,326))
  call vert_AZ_Q(gZu,wf(:,326),wf(:,3),wf(:,327))
  call vert_AV_Q(wf(:,326),wf(:,-6),wf(:,328))
  call prop_A_Q(wf(:,328),Q(:,88),MT,1_intkind1,wf(:,329))
  call vert_AV_Q(wf(:,326),wf(:,-5),wf(:,330))
  call prop_A_Q(wf(:,330),Q(:,56),MT,1_intkind1,wf(:,331))
  call vert_AV_Q(wf(:,326),wf(:,35),wf(:,332))
  call counter_VQ_A(wf(:,35),wf(:,-2),wf(:,333))
  call prop_A_Q(wf(:,59),Q(:,120),MT,1_intkind1,wf(:,334))
  call prop_Q_A(wf(:,150),Q(:,7),MT,1_intkind1,wf(:,335))
  call vert_VQ_A(wf(:,-5),wf(:,335),wf(:,336))
  call vert_VQ_A(wf(:,-6),wf(:,335),wf(:,337))
  call counter_VQ_A(wf(:,-6),wf(:,-2),wf(:,338))
  call prop_Q_A(wf(:,338),Q(:,68),MT,1_intkind1,wf(:,339))
  call vert_VQ_A(wf(:,-5),wf(:,339),wf(:,340))
  call prop_Q_A(wf(:,340),Q(:,100),MT,1_intkind1,wf(:,341))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,339),wf(:,342))
  call counter_VQ_A(wf(:,-5),wf(:,-2),wf(:,343))
  call prop_Q_A(wf(:,343),Q(:,36),MT,1_intkind1,wf(:,344))
  call vert_VQ_A(wf(:,-6),wf(:,344),wf(:,345))
  call prop_Q_A(wf(:,345),Q(:,100),MT,1_intkind1,wf(:,346))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,344),wf(:,347))
  call counter_VQ_A(wf(:,68),wf(:,-2),wf(:,348))
  call prop_A_Q(wf(:,77),Q(:,120),MT,1_intkind1,wf(:,349))
  call vert_VQ_A(wf(:,-4),wf(:,335),wf(:,350))
  call vert_VQ_A(wf(:,-4),wf(:,339),wf(:,351))
  call prop_Q_A(wf(:,351),Q(:,84),MT,1_intkind1,wf(:,352))
  call counter_VQ_A(wf(:,81),wf(:,-2),wf(:,353))
  call prop_A_Q(wf(:,85),Q(:,120),MT,1_intkind1,wf(:,354))
  call counter_QA_V(wf(:,-2),wf(:,37),wf(:,355))
  call prop_Q_A(wf(:,353),Q(:,52),MT,1_intkind1,wf(:,356))
  call vert_VQ_A(wf(:,-6),wf(:,356),wf(:,357))
  call vert_QA_V(wf(:,335),wf(:,-3),wf(:,358))
  call vert_VQ_A(wf(:,81),wf(:,339),wf(:,359))
  call prop_Q_A(wf(:,348),Q(:,84),MT,1_intkind1,wf(:,360))
  call vert_VQ_A(wf(:,-5),wf(:,360),wf(:,361))
  call prop_Q_A(wf(:,333),Q(:,100),MT,1_intkind1,wf(:,362))
  call vert_VQ_A(wf(:,-4),wf(:,362),wf(:,363))
  call vert_VQ_A(wf(:,-4),wf(:,344),wf(:,364))
  call prop_Q_A(wf(:,364),Q(:,52),MT,1_intkind1,wf(:,365))
  call vert_VQ_A(wf(:,68),wf(:,344),wf(:,366))
  call counter_VQ_A(wf(:,-4),wf(:,-2),wf(:,367))
  call prop_Q_A(wf(:,367),Q(:,20),MT,1_intkind1,wf(:,368))
  call vert_VQ_A(wf(:,-6),wf(:,368),wf(:,369))
  call prop_Q_A(wf(:,369),Q(:,84),MT,1_intkind1,wf(:,370))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,368),wf(:,371))
  call vert_VQ_A(wf(:,-5),wf(:,368),wf(:,372))
  call prop_Q_A(wf(:,372),Q(:,52),MT,1_intkind1,wf(:,373))
  call vert_VQ_A(wf(:,35),wf(:,368),wf(:,374))
  call counter_Q_A(cttt,wf(:,20),Q(:,20),wf(:,375))
  call prop_Q_A(wf(:,375),Q(:,20),MT,1_intkind1,wf(:,376))
  call vert_VQ_A(wf(:,-6),wf(:,376),wf(:,377))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,376),wf(:,378))
  call counter_A_Q(cttt,wf(:,21),Q(:,40),wf(:,379))
  call prop_A_Q(wf(:,379),Q(:,40),MT,1_intkind1,wf(:,380))
  call vert_AV_Q(wf(:,380),wf(:,-6),wf(:,381))
  call vert_AZ_Q(gZu,wf(:,380),wf(:,3),wf(:,382))
  call counter_Q_A(cttt,wf(:,24),Q(:,84),wf(:,383))
  call counter_A_Q(cttt,wf(:,27),Q(:,104),wf(:,384))
  call vert_VQ_A(wf(:,-5),wf(:,376),wf(:,385))
  call counter_A_Q(cttt,wf(:,29),Q(:,72),wf(:,386))
  call prop_A_Q(wf(:,386),Q(:,72),MT,1_intkind1,wf(:,387))
  call vert_AV_Q(wf(:,387),wf(:,-5),wf(:,388))
  call vert_AZ_Q(gZu,wf(:,387),wf(:,3),wf(:,389))
  call counter_Q_A(cttt,wf(:,32),Q(:,52),wf(:,390))
  call counter_A_Q(cttt,wf(:,34),Q(:,104),wf(:,391))
  call vert_QA_V(wf(:,376),wf(:,37),wf(:,392))
  call counter_V_V(ctGG,wf(:,35),Q(:,96),wf(:,393))
  call vert_AV_Q(wf(:,-3),wf(:,393),wf(:,394))
  call counter_A_Q(cttt,wf(:,37),Q(:,11),wf(:,395))
  call counter_A_Q(cttt,wf(:,39),Q(:,104),wf(:,396))
  call vert_VQ_A(wf(:,393),wf(:,20),wf(:,397))
  call prop_Q_A(wf(:,385),Q(:,52),MT,1_intkind1,wf(:,398))
  call prop_A_Q(wf(:,41),Q(:,43),MT,1_intkind1,wf(:,399))
  call vert_VQ_A(wf(:,-5),wf(:,24),wf(:,400))
  call prop_Q_A(wf(:,400),Q(:,116),MT,1_intkind1,wf(:,401))
  call vert_VQ_A(wf(:,-6),wf(:,32),wf(:,402))
  call prop_Q_A(wf(:,402),Q(:,116),MT,1_intkind1,wf(:,403))
  call prop_A_Q(wf(:,40),Q(:,75),MT,1_intkind1,wf(:,404))
  call counter_Q_A(cttt,wf(:,44),Q(:,36),wf(:,405))
  call prop_Q_A(wf(:,405),Q(:,36),MT,1_intkind1,wf(:,406))
  call vert_VQ_A(wf(:,-6),wf(:,406),wf(:,407))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,406),wf(:,408))
  call counter_A_Q(cttt,wf(:,45),Q(:,24),wf(:,409))
  call prop_A_Q(wf(:,409),Q(:,24),MT,1_intkind1,wf(:,410))
  call vert_AV_Q(wf(:,410),wf(:,-6),wf(:,411))
  call vert_AZ_Q(gZu,wf(:,410),wf(:,3),wf(:,412))
  call counter_Q_A(cttt,wf(:,48),Q(:,100),wf(:,413))
  call counter_A_Q(cttt,wf(:,51),Q(:,88),wf(:,414))
  call counter_Q_A(cttt,wf(:,53),Q(:,68),wf(:,415))
  call prop_Q_A(wf(:,415),Q(:,68),MT,1_intkind1,wf(:,416))
  call vert_VQ_A(wf(:,-5),wf(:,416),wf(:,417))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,416),wf(:,418))
  call vert_AV_Q(wf(:,410),wf(:,-5),wf(:,419))
  call counter_Q_A(cttt,wf(:,55),Q(:,100),wf(:,420))
  call counter_A_Q(cttt,wf(:,58),Q(:,56),wf(:,421))
  call vert_VQ_A(wf(:,393),wf(:,-2),wf(:,422))
  call counter_Q_A(cttt,wf(:,61),Q(:,100),wf(:,423))
  call vert_QA_V(wf(:,6),wf(:,410),wf(:,424))
  call vert_VQ_A(wf(:,393),wf(:,6),wf(:,425))
  call vert_AV_Q(wf(:,51),wf(:,-5),wf(:,426))
  call prop_A_Q(wf(:,426),Q(:,120),MT,1_intkind1,wf(:,427))
  call vert_AV_Q(wf(:,58),wf(:,-6),wf(:,428))
  call prop_A_Q(wf(:,428),Q(:,120),MT,1_intkind1,wf(:,429))
  call prop_A_Q(wf(:,419),Q(:,56),MT,1_intkind1,wf(:,430))
  call prop_Q_A(wf(:,62),Q(:,39),MT,1_intkind1,wf(:,431))
  call prop_Q_A(wf(:,63),Q(:,71),MT,1_intkind1,wf(:,432))
  call vert_VQ_A(wf(:,-4),wf(:,406),wf(:,433))
  call vert_AV_Q(wf(:,387),wf(:,-4),wf(:,434))
  call counter_Q_A(cttt,wf(:,65),Q(:,52),wf(:,435))
  call counter_A_Q(cttt,wf(:,67),Q(:,88),wf(:,436))
  call vert_QA_V(wf(:,406),wf(:,37),wf(:,437))
  call counter_V_V(ctGG,wf(:,68),Q(:,80),wf(:,438))
  call vert_AV_Q(wf(:,-3),wf(:,438),wf(:,439))
  call counter_A_Q(cttt,wf(:,71),Q(:,88),wf(:,440))
  call vert_VQ_A(wf(:,438),wf(:,44),wf(:,441))
  call prop_Q_A(wf(:,433),Q(:,52),MT,1_intkind1,wf(:,442))
  call prop_A_Q(wf(:,72),Q(:,27),MT,1_intkind1,wf(:,443))
  call vert_VQ_A(wf(:,-4),wf(:,48),wf(:,444))
  call prop_Q_A(wf(:,444),Q(:,116),MT,1_intkind1,wf(:,445))
  call vert_VQ_A(wf(:,-6),wf(:,65),wf(:,446))
  call prop_Q_A(wf(:,446),Q(:,116),MT,1_intkind1,wf(:,447))
  call vert_VQ_A(wf(:,-4),wf(:,416),wf(:,448))
  call vert_AV_Q(wf(:,380),wf(:,-4),wf(:,449))
  call counter_Q_A(cttt,wf(:,74),Q(:,84),wf(:,450))
  call counter_A_Q(cttt,wf(:,76),Q(:,56),wf(:,451))
  call vert_VQ_A(wf(:,438),wf(:,-2),wf(:,452))
  call counter_Q_A(cttt,wf(:,79),Q(:,84),wf(:,453))
  call vert_QA_V(wf(:,6),wf(:,380),wf(:,454))
  call vert_VQ_A(wf(:,438),wf(:,6),wf(:,455))
  call vert_AV_Q(wf(:,27),wf(:,-4),wf(:,456))
  call prop_A_Q(wf(:,456),Q(:,120),MT,1_intkind1,wf(:,457))
  call vert_AV_Q(wf(:,76),wf(:,-6),wf(:,458))
  call prop_A_Q(wf(:,458),Q(:,120),MT,1_intkind1,wf(:,459))
  call prop_A_Q(wf(:,449),Q(:,56),MT,1_intkind1,wf(:,460))
  call prop_Q_A(wf(:,80),Q(:,23),MT,1_intkind1,wf(:,461))
  call vert_QA_V(wf(:,416),wf(:,37),wf(:,462))
  call counter_V_V(ctGG,wf(:,81),Q(:,48),wf(:,463))
  call vert_AV_Q(wf(:,-3),wf(:,463),wf(:,464))
  call counter_A_Q(cttt,wf(:,84),Q(:,56),wf(:,465))
  call vert_VQ_A(wf(:,463),wf(:,53),wf(:,466))
  call vert_VQ_A(wf(:,463),wf(:,-2),wf(:,467))
  call counter_Q_A(cttt,wf(:,87),Q(:,52),wf(:,468))
  call vert_QA_V(wf(:,6),wf(:,387),wf(:,469))
  call vert_VQ_A(wf(:,463),wf(:,6),wf(:,470))
  call vert_AV_Q(wf(:,-3),wf(:,88),wf(:,471))
  call prop_A_Q(wf(:,471),Q(:,120),MT,1_intkind1,wf(:,472))
  call vert_VQ_A(wf(:,88),wf(:,-2),wf(:,473))
  call prop_Q_A(wf(:,473),Q(:,116),MT,1_intkind1,wf(:,474))
  call prop_Q_A(wf(:,467),Q(:,52),MT,1_intkind1,wf(:,475))
  call vert_AV_Q(wf(:,84),wf(:,-6),wf(:,476))
  call prop_A_Q(wf(:,476),Q(:,120),MT,1_intkind1,wf(:,477))
  call counter_V_V(ctGG,wf(:,88),Q(:,112),wf(:,478))
  call prop_A_Q(wf(:,464),Q(:,56),MT,1_intkind1,wf(:,479))
  call prop_Q_A(wf(:,91),Q(:,116),MT,1_intkind1,wf(:,480))
  call vert_UV_W(wf(:,463),Q(:,48),wf(:,-6),Q(:,64),wf(:,481))
  call prop_Q_A(wf(:,448),Q(:,84),MT,1_intkind1,wf(:,482))
  call vert_VQ_A(wf(:,-4),wf(:,55),wf(:,483))
  call prop_Q_A(wf(:,483),Q(:,116),MT,1_intkind1,wf(:,484))
  call vert_VQ_A(wf(:,-5),wf(:,74),wf(:,485))
  call prop_Q_A(wf(:,485),Q(:,116),MT,1_intkind1,wf(:,486))
  call vert_AV_Q(wf(:,34),wf(:,-4),wf(:,487))
  call prop_A_Q(wf(:,487),Q(:,120),MT,1_intkind1,wf(:,488))
  call vert_AV_Q(wf(:,67),wf(:,-5),wf(:,489))
  call prop_A_Q(wf(:,489),Q(:,120),MT,1_intkind1,wf(:,490))
  call prop_A_Q(wf(:,434),Q(:,88),MT,1_intkind1,wf(:,491))
  call vert_AV_Q(wf(:,-3),wf(:,92),wf(:,492))
  call prop_A_Q(wf(:,492),Q(:,120),MT,1_intkind1,wf(:,493))
  call vert_VQ_A(wf(:,92),wf(:,-2),wf(:,494))
  call prop_Q_A(wf(:,494),Q(:,116),MT,1_intkind1,wf(:,495))
  call prop_Q_A(wf(:,452),Q(:,84),MT,1_intkind1,wf(:,496))
  call vert_AV_Q(wf(:,71),wf(:,-5),wf(:,497))
  call prop_A_Q(wf(:,497),Q(:,120),MT,1_intkind1,wf(:,498))
  call counter_V_V(ctGG,wf(:,92),Q(:,112),wf(:,499))
  call prop_A_Q(wf(:,439),Q(:,88),MT,1_intkind1,wf(:,500))
  call prop_Q_A(wf(:,93),Q(:,116),MT,1_intkind1,wf(:,501))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,438),Q(:,80),wf(:,502))
  call vert_AV_Q(wf(:,-3),wf(:,94),wf(:,503))
  call prop_A_Q(wf(:,503),Q(:,120),MT,1_intkind1,wf(:,504))
  call vert_VQ_A(wf(:,94),wf(:,-2),wf(:,505))
  call prop_Q_A(wf(:,505),Q(:,116),MT,1_intkind1,wf(:,506))
  call vert_AV_Q(wf(:,39),wf(:,-4),wf(:,507))
  call prop_A_Q(wf(:,507),Q(:,120),MT,1_intkind1,wf(:,508))
  call counter_V_V(ctGG,wf(:,94),Q(:,112),wf(:,509))
  call prop_Q_A(wf(:,422),Q(:,100),MT,1_intkind1,wf(:,510))
  call prop_Q_A(wf(:,95),Q(:,116),MT,1_intkind1,wf(:,511))
  call prop_A_Q(wf(:,394),Q(:,104),MT,1_intkind1,wf(:,512))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,393),Q(:,96),wf(:,513))
  call vert_UV_W(wf(:,119),Q(:,44),wf(:,-6),Q(:,64),wf(:,514))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,122),Q(:,76),wf(:,515))
  call vert_UV_W(wf(:,-5),Q(:,32),wf(:,122),Q(:,76),wf(:,516))
  call vert_QA_V(wf(:,20),wf(:,37),wf(:,517))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,32),wf(:,518))
  call prop_Q_A(wf(:,518),Q(:,55),MT,1_intkind1,wf(:,519))
  call vert_QA_V(wf(:,24),wf(:,-3),wf(:,520))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,24),wf(:,521))
  call prop_Q_A(wf(:,521),Q(:,87),MT,1_intkind1,wf(:,522))
  call vert_QA_V(wf(:,169),wf(:,-3),wf(:,523))
  call vert_VQ_A(wf(:,-5),wf(:,169),wf(:,524))
  call prop_Q_A(wf(:,524),Q(:,55),MT,1_intkind1,wf(:,525))
  call vert_VQ_A(wf(:,-6),wf(:,169),wf(:,526))
  call prop_Q_A(wf(:,526),Q(:,87),MT,1_intkind1,wf(:,527))
  call vert_QA_V(wf(:,6),wf(:,45),wf(:,528))
  call vert_QA_V(wf(:,-2),wf(:,51),wf(:,529))
  call vert_QA_V(wf(:,-2),wf(:,196),wf(:,530))
  call vert_AZ_Q(gZu,wf(:,58),wf(:,3),wf(:,531))
  call prop_A_Q(wf(:,531),Q(:,59),MT,1_intkind1,wf(:,532))
  call vert_AZ_Q(gZu,wf(:,51),wf(:,3),wf(:,533))
  call prop_A_Q(wf(:,533),Q(:,91),MT,1_intkind1,wf(:,534))
  call vert_AV_Q(wf(:,196),wf(:,-5),wf(:,535))
  call prop_A_Q(wf(:,535),Q(:,59),MT,1_intkind1,wf(:,536))
  call vert_AV_Q(wf(:,196),wf(:,-6),wf(:,537))
  call prop_A_Q(wf(:,537),Q(:,91),MT,1_intkind1,wf(:,538))
  call vert_QA_V(wf(:,44),wf(:,37),wf(:,539))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,65),wf(:,540))
  call prop_Q_A(wf(:,540),Q(:,55),MT,1_intkind1,wf(:,541))
  call vert_QA_V(wf(:,48),wf(:,-3),wf(:,542))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,48),wf(:,543))
  call prop_Q_A(wf(:,543),Q(:,103),MT,1_intkind1,wf(:,544))
  call vert_QA_V(wf(:,194),wf(:,-3),wf(:,545))
  call vert_VQ_A(wf(:,-4),wf(:,194),wf(:,546))
  call prop_Q_A(wf(:,546),Q(:,55),MT,1_intkind1,wf(:,547))
  call vert_VQ_A(wf(:,-6),wf(:,194),wf(:,548))
  call prop_Q_A(wf(:,548),Q(:,103),MT,1_intkind1,wf(:,549))
  call vert_QA_V(wf(:,6),wf(:,21),wf(:,550))
  call vert_QA_V(wf(:,-2),wf(:,27),wf(:,551))
  call vert_QA_V(wf(:,-2),wf(:,171),wf(:,552))
  call vert_AZ_Q(gZu,wf(:,76),wf(:,3),wf(:,553))
  call prop_A_Q(wf(:,553),Q(:,59),MT,1_intkind1,wf(:,554))
  call vert_AZ_Q(gZu,wf(:,27),wf(:,3),wf(:,555))
  call prop_A_Q(wf(:,555),Q(:,107),MT,1_intkind1,wf(:,556))
  call vert_AV_Q(wf(:,171),wf(:,-4),wf(:,557))
  call prop_A_Q(wf(:,557),Q(:,59),MT,1_intkind1,wf(:,558))
  call vert_AV_Q(wf(:,171),wf(:,-6),wf(:,559))
  call prop_A_Q(wf(:,559),Q(:,107),MT,1_intkind1,wf(:,560))
  call vert_VQ_A(wf(:,81),wf(:,6),wf(:,561))
  call prop_Q_A(wf(:,561),Q(:,55),MT,1_intkind1,wf(:,562))
  call vert_AV_Q(wf(:,37),wf(:,81),wf(:,563))
  call prop_A_Q(wf(:,563),Q(:,59),MT,1_intkind1,wf(:,564))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,87),wf(:,565))
  call prop_Q_A(wf(:,565),Q(:,55),MT,1_intkind1,wf(:,566))
  call vert_AZ_Q(gZu,wf(:,84),wf(:,3),wf(:,567))
  call prop_A_Q(wf(:,567),Q(:,59),MT,1_intkind1,wf(:,568))
  call vert_QA_V(wf(:,53),wf(:,37),wf(:,569))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,74),wf(:,570))
  call prop_Q_A(wf(:,570),Q(:,87),MT,1_intkind1,wf(:,571))
  call vert_QA_V(wf(:,55),wf(:,-3),wf(:,572))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,55),wf(:,573))
  call prop_Q_A(wf(:,573),Q(:,103),MT,1_intkind1,wf(:,574))
  call vert_QA_V(wf(:,205),wf(:,-3),wf(:,575))
  call vert_VQ_A(wf(:,-4),wf(:,205),wf(:,576))
  call prop_Q_A(wf(:,576),Q(:,87),MT,1_intkind1,wf(:,577))
  call vert_VQ_A(wf(:,-5),wf(:,205),wf(:,578))
  call prop_Q_A(wf(:,578),Q(:,103),MT,1_intkind1,wf(:,579))
  call vert_QA_V(wf(:,6),wf(:,29),wf(:,580))
  call vert_QA_V(wf(:,-2),wf(:,34),wf(:,581))
  call vert_QA_V(wf(:,-2),wf(:,181),wf(:,582))
  call vert_AZ_Q(gZu,wf(:,67),wf(:,3),wf(:,583))
  call prop_A_Q(wf(:,583),Q(:,91),MT,1_intkind1,wf(:,584))
  call vert_AZ_Q(gZu,wf(:,34),wf(:,3),wf(:,585))
  call prop_A_Q(wf(:,585),Q(:,107),MT,1_intkind1,wf(:,586))
  call vert_AV_Q(wf(:,181),wf(:,-4),wf(:,587))
  call prop_A_Q(wf(:,587),Q(:,91),MT,1_intkind1,wf(:,588))
  call vert_AV_Q(wf(:,181),wf(:,-5),wf(:,589))
  call prop_A_Q(wf(:,589),Q(:,107),MT,1_intkind1,wf(:,590))
  call vert_VQ_A(wf(:,68),wf(:,6),wf(:,591))
  call prop_Q_A(wf(:,591),Q(:,87),MT,1_intkind1,wf(:,592))
  call vert_AV_Q(wf(:,37),wf(:,68),wf(:,593))
  call prop_A_Q(wf(:,593),Q(:,91),MT,1_intkind1,wf(:,594))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,79),wf(:,595))
  call prop_Q_A(wf(:,595),Q(:,87),MT,1_intkind1,wf(:,596))
  call vert_AZ_Q(gZu,wf(:,71),wf(:,3),wf(:,597))
  call prop_A_Q(wf(:,597),Q(:,91),MT,1_intkind1,wf(:,598))
  call vert_VQ_A(wf(:,35),wf(:,6),wf(:,599))
  call prop_Q_A(wf(:,599),Q(:,103),MT,1_intkind1,wf(:,600))
  call vert_AV_Q(wf(:,37),wf(:,35),wf(:,601))
  call prop_A_Q(wf(:,601),Q(:,107),MT,1_intkind1,wf(:,602))
  call vert_ZQ_A(gZu,wf(:,3),wf(:,61),wf(:,603))
  call prop_Q_A(wf(:,603),Q(:,103),MT,1_intkind1,wf(:,604))
  call vert_AZ_Q(gZu,wf(:,39),wf(:,3),wf(:,605))
  call prop_A_Q(wf(:,605),Q(:,107),MT,1_intkind1,wf(:,606))
  call vert_UV_W(wf(:,89),Q(:,15),wf(:,-4),Q(:,16),wf(:,607))
  call vert_UV_W(wf(:,89),Q(:,15),wf(:,-5),Q(:,32),wf(:,608))
  call vert_UV_W(wf(:,89),Q(:,15),wf(:,-6),Q(:,64),wf(:,609))
  call vert_QA_V(wf(:,461),wf(:,-3),wf(:,610))
  call vert_VQ_A(wf(:,-5),wf(:,461),wf(:,611))
  call prop_Q_A(wf(:,611),Q(:,55),MT,1_intkind1,wf(:,612))
  call vert_VQ_A(wf(:,-6),wf(:,461),wf(:,613))
  call prop_Q_A(wf(:,613),Q(:,87),MT,1_intkind1,wf(:,614))
  call vert_QA_V(wf(:,431),wf(:,-3),wf(:,615))
  call vert_VQ_A(wf(:,-4),wf(:,431),wf(:,616))
  call prop_Q_A(wf(:,616),Q(:,55),MT,1_intkind1,wf(:,617))
  call vert_VQ_A(wf(:,-6),wf(:,431),wf(:,618))
  call prop_Q_A(wf(:,618),Q(:,103),MT,1_intkind1,wf(:,619))
  call vert_QA_V(wf(:,432),wf(:,-3),wf(:,620))
  call vert_VQ_A(wf(:,-4),wf(:,432),wf(:,621))
  call prop_Q_A(wf(:,621),Q(:,87),MT,1_intkind1,wf(:,622))
  call vert_VQ_A(wf(:,-5),wf(:,432),wf(:,623))
  call prop_Q_A(wf(:,623),Q(:,103),MT,1_intkind1,wf(:,624))
  call vert_UV_W(wf(:,90),Q(:,15),wf(:,-4),Q(:,16),wf(:,625))
  call vert_UV_W(wf(:,90),Q(:,15),wf(:,-5),Q(:,32),wf(:,626))
  call vert_UV_W(wf(:,90),Q(:,15),wf(:,-6),Q(:,64),wf(:,627))
  call vert_QA_V(wf(:,-2),wf(:,443),wf(:,628))
  call vert_QA_V(wf(:,-2),wf(:,399),wf(:,629))
  call vert_QA_V(wf(:,-2),wf(:,404),wf(:,630))
  call vert_AV_Q(wf(:,443),wf(:,-5),wf(:,631))
  call prop_A_Q(wf(:,631),Q(:,59),MT,1_intkind1,wf(:,632))
  call vert_AV_Q(wf(:,443),wf(:,-6),wf(:,633))
  call prop_A_Q(wf(:,633),Q(:,91),MT,1_intkind1,wf(:,634))
  call vert_AV_Q(wf(:,399),wf(:,-4),wf(:,635))
  call prop_A_Q(wf(:,635),Q(:,59),MT,1_intkind1,wf(:,636))
  call vert_AV_Q(wf(:,399),wf(:,-6),wf(:,637))
  call prop_A_Q(wf(:,637),Q(:,107),MT,1_intkind1,wf(:,638))
  call vert_AV_Q(wf(:,404),wf(:,-4),wf(:,639))
  call prop_A_Q(wf(:,639),Q(:,91),MT,1_intkind1,wf(:,640))
  call vert_AV_Q(wf(:,404),wf(:,-5),wf(:,641))
  call prop_A_Q(wf(:,641),Q(:,107),MT,1_intkind1,wf(:,642))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,112))
  den(3) = 1 / (Q(5,7) - MT2)
  den(6) = 1 / (Q(5,116) - MT2)
  den(9) = 1 / (Q(5,20) - MT2)
  den(10) = 1 / (Q(5,40) - MT2)
  den(12) = 1 / (Q(5,84) - MT2)
  den(16) = 1 / (Q(5,104) - MT2)
  den(19) = 1 / (Q(5,72) - MT2)
  den(21) = 1 / (Q(5,52) - MT2)
  den(26) = 1 / (Q(5,96))
  den(28) = 1 / (Q(5,11) - MT2)
  den(35) = 1 / (Q(5,36) - MT2)
  den(36) = 1 / (Q(5,24) - MT2)
  den(38) = 1 / (Q(5,100) - MT2)
  den(42) = 1 / (Q(5,88) - MT2)
  den(45) = 1 / (Q(5,68) - MT2)
  den(49) = 1 / (Q(5,56) - MT2)
  den(62) = 1 / (Q(5,80))
  den(79) = 1 / (Q(5,48))
  den(107) = 1 / (Q(5,12))
  den(111) = 1 / (Q(5,28))
  den(115) = 1 / (Q(5,60))
  den(118) = 1 / (Q(5,92))
  den(121) = 1 / (Q(5,108))
  den(125) = 1 / (Q(5,44))
  den(128) = 1 / (Q(5,76))
  den(144) = 1 / (Q(5,120) - MT2)
  den(159) = 1 / (Q(5,67))
  den(166) = 1 / (Q(5,35))
  den(173) = 1 / (Q(5,19))
  den(177) = 1 / (Q(5,23) - MT2)
  den(180) = 1 / (Q(5,43) - MT2)
  den(190) = 1 / (Q(5,75) - MT2)
  den(198) = 1 / (Q(5,39) - MT2)
  den(201) = 1 / (Q(5,27) - MT2)
  den(210) = 1 / (Q(5,71) - MT2)
  den(427) = 1 / (Q(5,15))
  den(501) = 1 / (Q(5,31))
  den(507) = 1 / (Q(5,55) - MT2)
  den(511) = 1 / (Q(5,87) - MT2)
  den(524) = 1 / (Q(5,59) - MT2)
  den(527) = 1 / (Q(5,91) - MT2)
  den(532) = 1 / (Q(5,47))
  den(541) = 1 / (Q(5,103) - MT2)
  den(556) = 1 / (Q(5,107) - MT2)
  den(571) = 1 / (Q(5,79))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(1)*den(7)
  den(11) = den(1)*den(10)
  den(13) = den(9)*den(12)
  den(14) = den(11)*den(13)
  den(15) = den(1)*den(9)
  den(17) = den(10)*den(16)
  den(18) = den(15)*den(17)
  den(20) = den(1)*den(19)
  den(22) = den(9)*den(21)
  den(23) = den(20)*den(22)
  den(24) = den(16)*den(19)
  den(25) = den(15)*den(24)
  den(27) = den(9)*den(26)
  den(29) = den(1)*den(28)
  den(30) = den(27)*den(29)
  den(31) = den(16)*den(26)
  den(32) = den(15)*den(31)
  den(33) = den(22)*den(29)
  den(34) = den(13)*den(29)
  den(37) = den(1)*den(36)
  den(39) = den(35)*den(38)
  den(40) = den(37)*den(39)
  den(41) = den(1)*den(35)
  den(43) = den(36)*den(42)
  den(44) = den(41)*den(43)
  den(46) = den(38)*den(45)
  den(47) = den(37)*den(46)
  den(48) = den(1)*den(45)
  den(50) = den(36)*den(49)
  den(51) = den(48)*den(50)
  den(52) = den(26)*den(36)
  den(53) = den(4)*den(52)
  den(54) = den(26)*den(38)
  den(55) = den(37)*den(54)
  den(56) = den(4)*den(43)
  den(57) = den(4)*den(50)
  den(58) = den(21)*den(35)
  den(59) = den(20)*den(58)
  den(60) = den(19)*den(42)
  den(61) = den(41)*den(60)
  den(63) = den(35)*den(62)
  den(64) = den(29)*den(63)
  den(65) = den(42)*den(62)
  den(66) = den(41)*den(65)
  den(67) = den(29)*den(58)
  den(68) = den(29)*den(39)
  den(69) = den(12)*den(45)
  den(70) = den(11)*den(69)
  den(71) = den(10)*den(49)
  den(72) = den(48)*den(71)
  den(73) = den(10)*den(62)
  den(74) = den(4)*den(73)
  den(75) = den(12)*den(62)
  den(76) = den(11)*den(75)
  den(77) = den(4)*den(17)
  den(78) = den(4)*den(71)
  den(80) = den(45)*den(79)
  den(81) = den(29)*den(80)
  den(82) = den(49)*den(79)
  den(83) = den(48)*den(82)
  den(84) = den(19)*den(79)
  den(85) = den(4)*den(84)
  den(86) = den(21)*den(79)
  den(87) = den(20)*den(86)
  den(88) = den(2)*den(79)
  den(89) = den(4)*den(88)
  den(90) = den(4)*den(82)
  den(91) = den(29)*den(88)
  den(92) = den(29)*den(86)
  den(93) = den(29)*den(69)
  den(94) = den(29)*den(46)
  den(95) = den(4)*den(24)
  den(96) = den(4)*den(60)
  den(97) = den(2)*den(62)
  den(98) = den(4)*den(97)
  den(99) = den(4)*den(65)
  den(100) = den(29)*den(97)
  den(101) = den(29)*den(75)
  den(102) = den(2)*den(26)
  den(103) = den(4)*den(102)
  den(104) = den(4)*den(31)
  den(105) = den(29)*den(102)
  den(106) = den(29)*den(54)
  den(108) = den(1)*den(107)
  den(109) = den(79)*den(108)
  den(110) = den(62)*den(108)
  den(112) = den(107)*den(111)
  den(113) = den(1)*den(112)
  den(114) = den(2)*den(108)
  den(116) = den(107)*den(115)
  den(117) = den(1)*den(116)
  den(119) = den(107)*den(118)
  den(120) = den(1)*den(119)
  den(122) = den(107)*den(121)
  den(123) = den(1)*den(122)
  den(124) = den(26)*den(108)
  den(126) = den(107)*den(125)
  den(127) = den(1)*den(126)
  den(129) = den(107)*den(128)
  den(130) = den(1)*den(129)
  den(131) = den(9)*den(111)
  den(132) = den(1)*den(131)
  den(133) = den(36)*den(111)
  den(134) = den(1)*den(133)
  den(135) = den(35)*den(125)
  den(136) = den(1)*den(135)
  den(137) = den(10)*den(125)
  den(138) = den(1)*den(137)
  den(139) = den(45)*den(128)
  den(140) = den(1)*den(139)
  den(141) = den(19)*den(128)
  den(142) = den(1)*den(141)
  den(143) = den(2)*den(29)
  den(145) = den(2)*den(144)
  den(146) = den(1)*den(145)
  den(147) = den(1)*den(79)
  den(148) = den(129)*den(147)
  den(149) = den(88)*den(108)
  den(150) = den(79)*den(107)
  den(151) = den(115)*den(150)
  den(152) = den(1)*den(151)
  den(153) = den(1)*den(62)
  den(154) = den(126)*den(153)
  den(155) = den(97)*den(108)
  den(156) = den(1)*den(26)
  den(157) = den(112)*den(156)
  den(158) = den(102)*den(108)
  den(160) = den(1)*den(159)
  den(161) = den(112)*den(160)
  den(162) = den(126)*den(160)
  den(163) = den(62)*den(107)
  den(164) = den(118)*den(163)
  den(165) = den(1)*den(164)
  den(167) = den(1)*den(166)
  den(168) = den(112)*den(167)
  den(169) = den(129)*den(167)
  den(170) = den(26)*den(107)
  den(171) = den(121)*den(170)
  den(172) = den(1)*den(171)
  den(174) = den(1)*den(173)
  den(175) = den(126)*den(174)
  den(176) = den(129)*den(174)
  den(178) = den(15)*den(177)
  den(179) = den(10)*den(178)
  den(181) = den(11)*den(180)
  den(182) = den(9)*den(181)
  den(183) = den(9)*den(10)
  den(184) = den(115)*den(183)
  den(185) = den(1)*den(184)
  den(186) = den(131)*den(156)
  den(187) = den(131)*den(160)
  den(188) = den(22)*den(160)
  den(189) = den(19)*den(178)
  den(191) = den(20)*den(190)
  den(192) = den(9)*den(191)
  den(193) = den(9)*den(19)
  den(194) = den(118)*den(193)
  den(195) = den(1)*den(194)
  den(196) = den(131)*den(167)
  den(197) = den(13)*den(167)
  den(199) = den(41)*den(198)
  den(200) = den(36)*den(199)
  den(202) = den(37)*den(201)
  den(203) = den(35)*den(202)
  den(204) = den(35)*den(36)
  den(205) = den(115)*den(204)
  den(206) = den(1)*den(205)
  den(207) = den(133)*den(156)
  den(208) = den(133)*den(160)
  den(209) = den(50)*den(160)
  den(211) = den(48)*den(210)
  den(212) = den(36)*den(211)
  den(213) = den(45)*den(202)
  den(214) = den(36)*den(45)
  den(215) = den(118)*den(214)
  den(216) = den(1)*den(215)
  den(217) = den(133)*den(167)
  den(218) = den(43)*den(167)
  den(219) = den(135)*den(153)
  den(220) = den(135)*den(160)
  den(221) = den(58)*den(160)
  den(222) = den(137)*den(153)
  den(223) = den(137)*den(160)
  den(224) = den(71)*den(160)
  den(225) = den(139)*den(147)
  den(226) = den(141)*den(147)
  den(227) = den(86)*den(160)
  den(228) = den(82)*den(160)
  den(229) = den(139)*den(167)
  den(230) = den(69)*den(167)
  den(231) = den(141)*den(167)
  den(232) = den(60)*den(167)
  den(233) = den(75)*den(167)
  den(234) = den(65)*den(167)
  den(235) = den(4)*den(145)
  den(236) = den(7)*den(29)
  den(237) = den(2)**2
  den(238) = den(29)*den(237)
  den(239) = den(4)*den(237)
  den(240) = den(19)*den(199)
  den(241) = den(35)*den(191)
  den(242) = den(19)*den(35)
  den(243) = den(121)*den(242)
  den(244) = den(1)*den(243)
  den(245) = den(135)*den(174)
  den(246) = den(39)*den(174)
  den(247) = den(10)*den(211)
  den(248) = den(45)*den(181)
  den(249) = den(10)*den(45)
  den(250) = den(121)*den(249)
  den(251) = den(1)*den(250)
  den(252) = den(137)*den(174)
  den(253) = den(17)*den(174)
  den(254) = den(139)*den(174)
  den(255) = den(46)*den(174)
  den(256) = den(141)*den(174)
  den(257) = den(24)*den(174)
  den(258) = den(54)*den(174)
  den(259) = den(31)*den(174)
  den(260) = den(26)*den(178)
  den(261) = den(6)*den(27)
  den(262) = den(1)*den(261)
  den(263) = den(62)*den(199)
  den(264) = den(6)*den(63)
  den(265) = den(1)*den(264)
  den(266) = den(79)*den(211)
  den(267) = den(6)*den(80)
  den(268) = den(1)*den(267)
  den(269) = den(26)*den(202)
  den(270) = den(52)*den(144)
  den(271) = den(1)*den(270)
  den(272) = den(62)*den(181)
  den(273) = den(73)*den(144)
  den(274) = den(1)*den(273)
  den(275) = den(79)*den(191)
  den(276) = den(84)*den(144)
  den(277) = den(1)*den(276)
  den(278) = den(9)**2
  den(279) = den(181)*den(278)
  den(280) = den(1)*den(278)
  den(281) = den(17)*den(280)
  den(282) = den(10)**2
  den(283) = den(178)*den(282)
  den(284) = den(1)*den(282)
  den(285) = den(13)*den(284)
  den(286) = den(13)*den(181)
  den(287) = den(17)*den(178)
  den(288) = den(191)*den(278)
  den(289) = den(24)*den(280)
  den(290) = den(19)**2
  den(291) = den(178)*den(290)
  den(292) = den(1)*den(290)
  den(293) = den(22)*den(292)
  den(294) = den(22)*den(191)
  den(295) = den(24)*den(178)
  den(296) = den(29)*den(278)
  den(297) = den(26)*den(296)
  den(298) = den(31)*den(280)
  den(299) = den(26)**2
  den(300) = den(178)*den(299)
  den(301) = den(29)*den(261)
  den(302) = den(31)*den(178)
  den(303) = den(9)*den(299)
  den(304) = den(29)*den(303)
  den(305) = den(21)*den(278)
  den(306) = den(29)*den(305)
  den(307) = den(29)*den(180)
  den(308) = den(278)*den(307)
  den(309) = den(6)*den(13)
  den(310) = den(29)*den(309)
  den(311) = den(6)*den(22)
  den(312) = den(29)*den(311)
  den(313) = den(29)*den(190)
  den(314) = den(22)*den(313)
  den(315) = den(13)*den(307)
  den(316) = den(35)**2
  den(317) = den(202)*den(316)
  den(318) = den(1)*den(316)
  den(319) = den(43)*den(318)
  den(320) = den(36)**2
  den(321) = den(199)*den(320)
  den(322) = den(1)*den(320)
  den(323) = den(39)*den(322)
  den(324) = den(39)*den(202)
  den(325) = den(43)*den(199)
  den(326) = den(45)**2
  den(327) = den(202)*den(326)
  den(328) = den(1)*den(326)
  den(329) = den(50)*den(328)
  den(330) = den(211)*den(320)
  den(331) = den(46)*den(322)
  den(332) = den(46)*den(202)
  den(333) = den(50)*den(211)
  den(334) = den(202)*den(299)
  den(335) = den(4)*den(270)
  den(336) = den(54)*den(202)
  den(337) = den(4)*den(320)
  den(338) = den(26)*den(337)
  den(339) = den(54)*den(322)
  den(340) = den(4)*den(299)
  den(341) = den(36)*den(340)
  den(342) = den(43)*den(144)
  den(343) = den(4)*den(342)
  den(344) = den(50)*den(144)
  den(345) = den(4)*den(344)
  den(346) = den(49)*den(320)
  den(347) = den(4)*den(346)
  den(348) = den(4)*den(198)
  den(349) = den(320)*den(348)
  den(350) = den(43)*den(348)
  den(351) = den(4)*den(210)
  den(352) = den(50)*den(351)
  den(353) = den(191)*den(316)
  den(354) = den(60)*den(318)
  den(355) = den(199)*den(290)
  den(356) = den(58)*den(292)
  den(357) = den(58)*den(191)
  den(358) = den(60)*den(199)
  den(359) = den(29)*den(316)
  den(360) = den(62)*den(359)
  den(361) = den(65)*den(318)
  den(362) = den(62)**2
  den(363) = den(199)*den(362)
  den(364) = den(29)*den(264)
  den(365) = den(65)*den(199)
  den(366) = den(35)*den(362)
  den(367) = den(29)*den(366)
  den(368) = den(21)*den(316)
  den(369) = den(29)*den(368)
  den(370) = den(29)*den(201)
  den(371) = den(316)*den(370)
  den(372) = den(6)*den(39)
  den(373) = den(29)*den(372)
  den(374) = den(6)*den(58)
  den(375) = den(29)*den(374)
  den(376) = den(58)*den(313)
  den(377) = den(39)*den(370)
  den(378) = den(181)*den(326)
  den(379) = den(71)*den(328)
  den(380) = den(211)*den(282)
  den(381) = den(69)*den(284)
  den(382) = den(69)*den(181)
  den(383) = den(71)*den(211)
  den(384) = den(181)*den(362)
  den(385) = den(4)*den(273)
  den(386) = den(75)*den(181)
  den(387) = den(4)*den(282)
  den(388) = den(62)*den(387)
  den(389) = den(75)*den(284)
  den(390) = den(4)*den(362)
  den(391) = den(10)*den(390)
  den(392) = den(17)*den(144)
  den(393) = den(4)*den(392)
  den(394) = den(71)*den(144)
  den(395) = den(4)*den(394)
  den(396) = den(49)*den(282)
  den(397) = den(4)*den(396)
  den(398) = den(4)*den(177)
  den(399) = den(282)*den(398)
  den(400) = den(17)*den(398)
  den(401) = den(71)*den(351)
  den(402) = den(29)*den(326)
  den(403) = den(79)*den(402)
  den(404) = den(82)*den(328)
  den(405) = den(79)**2
  den(406) = den(211)*den(405)
  den(407) = den(29)*den(267)
  den(408) = den(82)*den(211)
  den(409) = den(45)*den(405)
  den(410) = den(29)*den(409)
  den(411) = den(191)*den(405)
  den(412) = den(4)*den(276)
  den(413) = den(86)*den(191)
  den(414) = den(4)*den(290)
  den(415) = den(79)*den(414)
  den(416) = den(86)*den(292)
  den(417) = den(4)*den(405)
  den(418) = den(19)*den(417)
  den(419) = den(88)*den(144)
  den(420) = den(4)*den(419)
  den(421) = den(6)*den(88)
  den(422) = den(29)*den(421)
  den(423) = den(21)*den(405)
  den(424) = den(29)*den(423)
  den(425) = den(82)*den(144)
  den(426) = den(4)*den(425)
  den(428) = den(29)*den(427)
  den(429) = den(88)*den(428)
  den(430) = den(86)*den(313)
  den(431) = den(49)*den(405)
  den(432) = den(4)*den(431)
  den(433) = den(4)*den(427)
  den(434) = den(88)*den(433)
  den(435) = den(82)*den(351)
  den(436) = den(6)*den(86)
  den(437) = den(29)*den(436)
  den(438) = den(405)*den(433)
  den(439) = den(405)*den(428)
  den(440) = den(12)*den(326)
  den(441) = den(29)*den(440)
  den(442) = den(326)*den(370)
  den(443) = den(6)*den(46)
  den(444) = den(29)*den(443)
  den(445) = den(6)*den(69)
  den(446) = den(29)*den(445)
  den(447) = den(69)*den(307)
  den(448) = den(46)*den(370)
  den(449) = den(24)*den(144)
  den(450) = den(4)*den(449)
  den(451) = den(60)*den(144)
  den(452) = den(4)*den(451)
  den(453) = den(42)*den(290)
  den(454) = den(4)*den(453)
  den(455) = den(290)*den(398)
  den(456) = den(24)*den(398)
  den(457) = den(60)*den(348)
  den(458) = den(97)*den(144)
  den(459) = den(4)*den(458)
  den(460) = den(6)*den(97)
  den(461) = den(29)*den(460)
  den(462) = den(12)*den(362)
  den(463) = den(29)*den(462)
  den(464) = den(65)*den(144)
  den(465) = den(4)*den(464)
  den(466) = den(97)*den(428)
  den(467) = den(75)*den(307)
  den(468) = den(42)*den(362)
  den(469) = den(4)*den(468)
  den(470) = den(97)*den(433)
  den(471) = den(65)*den(348)
  den(472) = den(6)*den(75)
  den(473) = den(29)*den(472)
  den(474) = den(362)*den(433)
  den(475) = den(362)*den(428)
  den(476) = den(102)*den(144)
  den(477) = den(4)*den(476)
  den(478) = den(6)*den(102)
  den(479) = den(29)*den(478)
  den(480) = den(31)*den(144)
  den(481) = den(4)*den(480)
  den(482) = den(102)*den(428)
  den(483) = den(54)*den(370)
  den(484) = den(38)*den(299)
  den(485) = den(29)*den(484)
  den(486) = den(102)*den(433)
  den(487) = den(31)*den(398)
  den(488) = den(6)*den(54)
  den(489) = den(29)*den(488)
  den(490) = den(16)*den(299)
  den(491) = den(4)*den(490)
  den(492) = den(299)*den(433)
  den(493) = den(299)*den(428)
  den(494) = den(112)*den(115)
  den(495) = den(112)*den(118)
  den(496) = den(115)*den(126)
  den(497) = den(121)*den(126)
  den(498) = den(118)*den(129)
  den(499) = den(121)*den(129)
  den(500) = den(9)*den(29)
  den(502) = den(500)*den(501)
  den(503) = den(115)*den(131)
  den(504) = den(118)*den(131)
  den(505) = den(22)*den(115)
  den(506) = den(1)*den(22)
  den(508) = den(506)*den(507)
  den(509) = den(13)*den(118)
  den(510) = den(1)*den(13)
  den(512) = den(510)*den(511)
  den(513) = den(178)*den(501)
  den(514) = den(178)*den(507)
  den(515) = den(178)*den(511)
  den(516) = den(4)*den(36)
  den(517) = den(501)*den(516)
  den(518) = den(115)*den(133)
  den(519) = den(118)*den(133)
  den(520) = den(50)*den(115)
  den(521) = den(43)*den(118)
  den(522) = den(202)*den(501)
  den(523) = den(1)*den(50)
  den(525) = den(523)*den(524)
  den(526) = den(1)*den(43)
  den(528) = den(526)*den(527)
  den(529) = den(202)*den(524)
  den(530) = den(202)*den(527)
  den(531) = den(29)*den(35)
  den(533) = den(531)*den(532)
  den(534) = den(115)*den(135)
  den(535) = den(121)*den(135)
  den(536) = den(58)*den(115)
  den(537) = den(1)*den(58)
  den(538) = den(507)*den(537)
  den(539) = den(39)*den(121)
  den(540) = den(1)*den(39)
  den(542) = den(540)*den(541)
  den(543) = den(199)*den(532)
  den(544) = den(199)*den(507)
  den(545) = den(199)*den(541)
  den(546) = den(4)*den(10)
  den(547) = den(532)*den(546)
  den(548) = den(115)*den(137)
  den(549) = den(121)*den(137)
  den(550) = den(71)*den(115)
  den(551) = den(17)*den(121)
  den(552) = den(181)*den(532)
  den(553) = den(1)*den(71)
  den(554) = den(524)*den(553)
  den(555) = den(1)*den(17)
  den(557) = den(555)*den(556)
  den(558) = den(181)*den(524)
  den(559) = den(181)*den(556)
  den(560) = den(4)*den(79)
  den(561) = den(507)*den(560)
  den(562) = den(29)*den(79)
  den(563) = den(524)*den(562)
  den(564) = den(86)*den(115)
  den(565) = den(82)*den(115)
  den(566) = den(1)*den(86)
  den(567) = den(507)*den(566)
  den(568) = den(1)*den(82)
  den(569) = den(524)*den(568)
  den(570) = den(29)*den(45)
  den(572) = den(570)*den(571)
  den(573) = den(118)*den(139)
  den(574) = den(121)*den(139)
  den(575) = den(69)*den(118)
  den(576) = den(1)*den(69)
  den(577) = den(511)*den(576)
  den(578) = den(46)*den(121)
  den(579) = den(1)*den(46)
  den(580) = den(541)*den(579)
  den(581) = den(211)*den(571)
  den(582) = den(211)*den(511)
  den(583) = den(211)*den(541)
  den(584) = den(4)*den(19)
  den(585) = den(571)*den(584)
  den(586) = den(118)*den(141)
  den(587) = den(121)*den(141)
  den(588) = den(60)*den(118)
  den(589) = den(24)*den(121)
  den(590) = den(191)*den(571)
  den(591) = den(1)*den(60)
  den(592) = den(527)*den(591)
  den(593) = den(1)*den(24)
  den(594) = den(556)*den(593)
  den(595) = den(191)*den(527)
  den(596) = den(191)*den(556)
  den(597) = den(4)*den(62)
  den(598) = den(511)*den(597)
  den(599) = den(29)*den(62)
  den(600) = den(527)*den(599)
  den(601) = den(75)*den(118)
  den(602) = den(65)*den(118)
  den(603) = den(1)*den(75)
  den(604) = den(511)*den(603)
  den(605) = den(1)*den(65)
  den(606) = den(527)*den(605)
  den(607) = den(4)*den(26)
  den(608) = den(541)*den(607)
  den(609) = den(26)*den(29)
  den(610) = den(556)*den(609)
  den(611) = den(54)*den(121)
  den(612) = den(31)*den(121)
  den(613) = den(1)*den(54)
  den(614) = den(541)*den(613)
  den(615) = den(1)*den(31)
  den(616) = den(556)*den(615)
  den(617) = den(433)*den(501)
  den(618) = den(433)*den(532)
  den(619) = den(433)*den(571)
  den(620) = den(398)*den(501)
  den(621) = den(398)*den(507)
  den(622) = den(398)*den(511)
  den(623) = den(348)*den(532)
  den(624) = den(348)*den(507)
  den(625) = den(348)*den(541)
  den(626) = den(351)*den(571)
  den(627) = den(351)*den(511)
  den(628) = den(351)*den(541)
  den(629) = den(428)*den(501)
  den(630) = den(428)*den(532)
  den(631) = den(428)*den(571)
  den(632) = den(370)*den(501)
  den(633) = den(307)*den(532)
  den(634) = den(313)*den(571)
  den(635) = den(370)*den(524)
  den(636) = den(370)*den(527)
  den(637) = den(307)*den(524)
  den(638) = den(307)*den(556)
  den(639) = den(313)*den(527)
  den(640) = den(313)*den(556)
  den(641) = den(1)*den(2)*den(107)
  den(642) = den(1)*den(2)
  den(643) = den(1)*den(79)*den(129)
  den(644) = den(1)*den(88)*den(107)
  den(645) = den(1)*den(79)*den(107)
  den(646) = den(1)*den(62)*den(126)
  den(647) = den(1)*den(97)*den(107)
  den(648) = den(1)*den(62)*den(107)
  den(649) = den(1)*den(26)*den(112)
  den(650) = den(1)*den(102)*den(107)
  den(651) = den(1)*den(26)*den(107)
  den(652) = den(1)*den(494)
  den(653) = den(1)*den(495)
  den(654) = den(1)*den(496)
  den(655) = den(1)*den(497)
  den(656) = den(1)*den(498)
  den(657) = den(1)*den(499)
  den(658) = den(1)*den(10)*den(13)
  den(659) = den(1)*den(9)*den(17)
  den(660) = den(1)*den(9)*den(10)
  den(661) = den(1)*den(19)*den(22)
  den(662) = den(1)*den(9)*den(24)
  den(663) = den(1)*den(9)*den(19)
  den(664) = den(9)*den(26)*den(29)
  den(665) = den(1)*den(26)*den(131)
  den(666) = den(1)*den(9)*den(31)
  den(667) = den(1)*den(9)*den(26)
  den(668) = den(9)*den(307)
  den(669) = den(9)*den(313)
  den(670) = den(1)*den(503)
  den(671) = den(1)*den(504)
  den(672) = den(1)*den(505)
  den(673) = den(1)*den(311)
  den(674) = den(1)*den(509)
  den(675) = den(1)*den(309)
  den(676) = den(1)*den(36)*den(39)
  den(677) = den(1)*den(35)*den(43)
  den(678) = den(1)*den(35)*den(36)
  den(679) = den(1)*den(36)*den(46)
  den(680) = den(1)*den(45)*den(50)
  den(681) = den(1)*den(36)*den(45)
  den(682) = den(4)*den(26)*den(36)
  den(683) = den(1)*den(26)*den(133)
  den(684) = den(1)*den(36)*den(54)
  den(685) = den(1)*den(26)*den(36)
  den(686) = den(36)*den(348)
  den(687) = den(36)*den(351)
  den(688) = den(1)*den(518)
  den(689) = den(1)*den(519)
  den(690) = den(1)*den(520)
  den(691) = den(1)*den(521)
  den(692) = den(1)*den(344)
  den(693) = den(1)*den(342)
  den(694) = den(1)*den(19)*den(58)
  den(695) = den(1)*den(35)*den(60)
  den(696) = den(1)*den(19)*den(35)
  den(697) = den(29)*den(35)*den(62)
  den(698) = den(1)*den(62)*den(135)
  den(699) = den(1)*den(35)*den(65)
  den(700) = den(1)*den(35)*den(62)
  den(701) = den(35)*den(370)
  den(702) = den(35)*den(313)
  den(703) = den(1)*den(534)
  den(704) = den(1)*den(535)
  den(705) = den(1)*den(536)
  den(706) = den(1)*den(374)
  den(707) = den(1)*den(539)
  den(708) = den(1)*den(372)
  den(709) = den(1)*den(10)*den(69)
  den(710) = den(1)*den(45)*den(71)
  den(711) = den(1)*den(10)*den(45)
  den(712) = den(4)*den(10)*den(62)
  den(713) = den(1)*den(62)*den(137)
  den(714) = den(1)*den(10)*den(75)
  den(715) = den(1)*den(10)*den(62)
  den(716) = den(10)*den(398)
  den(717) = den(10)*den(351)
  den(718) = den(1)*den(548)
  den(719) = den(1)*den(549)
  den(720) = den(1)*den(550)
  den(721) = den(1)*den(551)
  den(722) = den(1)*den(394)
  den(723) = den(1)*den(392)
  den(724) = den(29)*den(45)*den(79)
  den(725) = den(1)*den(79)*den(139)
  den(726) = den(1)*den(45)*den(82)
  den(727) = den(1)*den(45)*den(79)
  den(728) = den(4)*den(19)*den(79)
  den(729) = den(1)*den(79)*den(141)
  den(730) = den(1)*den(19)*den(86)
  den(731) = den(1)*den(19)*den(79)
  den(732) = den(79)*den(433)
  den(733) = den(79)*den(351)
  den(734) = den(79)*den(428)
  den(735) = den(79)*den(313)
  den(736) = den(1)*den(564)
  den(737) = den(1)*den(565)
  den(738) = den(1)*den(436)
  den(739) = den(1)*den(421)
  den(740) = den(1)*den(425)
  den(741) = den(1)*den(419)
  den(742) = den(1)*den(88)
  den(743) = den(45)*den(370)
  den(744) = den(45)*den(307)
  den(745) = den(1)*den(573)
  den(746) = den(1)*den(574)
  den(747) = den(1)*den(575)
  den(748) = den(1)*den(445)
  den(749) = den(1)*den(578)
  den(750) = den(1)*den(443)
  den(751) = den(19)*den(398)
  den(752) = den(19)*den(348)
  den(753) = den(1)*den(586)
  den(754) = den(1)*den(587)
  den(755) = den(1)*den(588)
  den(756) = den(1)*den(589)
  den(757) = den(1)*den(451)
  den(758) = den(1)*den(449)
  den(759) = den(62)*den(433)
  den(760) = den(62)*den(348)
  den(761) = den(62)*den(428)
  den(762) = den(62)*den(307)
  den(763) = den(1)*den(601)
  den(764) = den(1)*den(602)
  den(765) = den(1)*den(472)
  den(766) = den(1)*den(460)
  den(767) = den(1)*den(464)
  den(768) = den(1)*den(458)
  den(769) = den(1)*den(97)
  den(770) = den(26)*den(433)
  den(771) = den(26)*den(398)
  den(772) = den(26)*den(428)
  den(773) = den(26)*den(370)
  den(774) = den(1)*den(611)
  den(775) = den(1)*den(612)
  den(776) = den(1)*den(488)
  den(777) = den(1)*den(478)
  den(778) = den(1)*den(480)
  den(779) = den(1)*den(476)
  den(780) = den(1)*den(102)
  den(781) = den(2)*den(433)
  den(782) = den(2)*den(428)
  den(783) = den(10)*den(512)
  den(784) = den(10)*den(515)
  den(785) = den(9)*den(557)
  den(786) = den(9)*den(559)
  den(787) = den(19)*den(508)
  den(788) = den(19)*den(514)
  den(789) = den(9)*den(594)
  den(790) = den(9)*den(596)
  den(791) = den(26)*den(502)
  den(792) = den(9)*den(610)
  den(793) = den(26)*den(513)
  den(794) = den(9)*den(616)
  den(795) = den(9)*den(638)
  den(796) = den(9)*den(640)
  den(797) = den(36)*den(542)
  den(798) = den(36)*den(545)
  den(799) = den(35)*den(528)
  den(800) = den(35)*den(530)
  den(801) = den(36)*den(580)
  den(802) = den(36)*den(583)
  den(803) = den(45)*den(525)
  den(804) = den(45)*den(529)
  den(805) = den(26)*den(517)
  den(806) = den(36)*den(608)
  den(807) = den(36)*den(614)
  den(808) = den(26)*den(522)
  den(809) = den(36)*den(625)
  den(810) = den(36)*den(628)
  den(811) = den(19)*den(538)
  den(812) = den(19)*den(544)
  den(813) = den(35)*den(592)
  den(814) = den(35)*den(595)
  den(815) = den(62)*den(533)
  den(816) = den(35)*den(600)
  den(817) = den(62)*den(543)
  den(818) = den(35)*den(606)
  den(819) = den(35)*den(636)
  den(820) = den(35)*den(639)
  den(821) = den(10)*den(577)
  den(822) = den(10)*den(582)
  den(823) = den(45)*den(554)
  den(824) = den(45)*den(558)
  den(825) = den(62)*den(547)
  den(826) = den(10)*den(598)
  den(827) = den(10)*den(604)
  den(828) = den(62)*den(552)
  den(829) = den(10)*den(622)
  den(830) = den(10)*den(627)
  den(831) = den(79)*den(572)
  den(832) = den(45)*den(563)
  den(833) = den(79)*den(581)
  den(834) = den(45)*den(569)
  den(835) = den(79)*den(585)
  den(836) = den(19)*den(561)
  den(837) = den(19)*den(567)
  den(838) = den(79)*den(590)
  den(839) = den(79)*den(619)
  den(840) = den(79)*den(626)
  den(841) = den(79)*den(631)
  den(842) = den(79)*den(634)
  den(843) = den(45)*den(635)
  den(844) = den(45)*den(637)
  den(845) = den(19)*den(621)
  den(846) = den(19)*den(624)
  den(847) = den(62)*den(618)
  den(848) = den(62)*den(623)
  den(849) = den(62)*den(630)
  den(850) = den(62)*den(633)
  den(851) = den(26)*den(617)
  den(852) = den(26)*den(620)
  den(853) = den(26)*den(629)
  den(854) = den(26)*den(632)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(519)

  A(1) = cont_QA(wf(:,5),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,6),wf(:,8)) * den(5)
  A(3) = cont_QA(wf(:,6),wf(:,10)) * den(5)
  A(4) = cont_QA(wf(:,12),wf(:,13)) * den(8)
  A(5) = cont_QA(wf(:,12),wf(:,15)) * den(8)
  A(6) = cont_QA(wf(:,12),wf(:,17)) * den(8)
  A(7) = cont_QA(wf(:,23),wf(:,24)) * den(14)
  A(8) = cont_QA(wf(:,26),wf(:,27)) * den(18)
  A(9) = cont_QA(wf(:,31),wf(:,32)) * den(23)
  A(10) = cont_QA(wf(:,26),wf(:,34)) * den(25)
  A(11) = cont_QA(wf(:,36),wf(:,37)) * den(30)
  A(12) = cont_QA(wf(:,26),wf(:,39)) * den(32)
  A(13) = cont_QA(wf(:,32),wf(:,40)) * den(33)
  A(14) = cont_QA(wf(:,24),wf(:,41)) * den(34)
  A(15) = cont_QA(wf(:,47),wf(:,48)) * den(40)
  A(16) = cont_QA(wf(:,50),wf(:,51)) * den(44)
  A(17) = cont_QA(wf(:,47),wf(:,55)) * den(47)
  A(18) = cont_QA(wf(:,57),wf(:,58)) * den(51)
  A(19) = cont_QA(wf(:,6),wf(:,59)) * den(53)
  A(20) = cont_QA(wf(:,47),wf(:,61)) * den(55)
  A(21) = cont_QA(wf(:,51),wf(:,62)) * den(56)
  A(22) = cont_QA(wf(:,58),wf(:,63)) * den(57)
  A(23) = cont_QA(wf(:,31),wf(:,65)) * den(59)
  A(24) = cont_QA(wf(:,50),wf(:,67)) * den(61)
  A(25) = cont_QA(wf(:,37),wf(:,69)) * den(64)
  A(26) = cont_QA(wf(:,50),wf(:,71)) * den(66)
  A(27) = cont_QA(wf(:,40),wf(:,65)) * den(67)
  A(28) = cont_QA(wf(:,48),wf(:,72)) * den(68)
  A(29) = cont_QA(wf(:,23),wf(:,74)) * den(70)
  A(30) = cont_QA(wf(:,57),wf(:,76)) * den(72)
  A(31) = cont_QA(wf(:,6),wf(:,77)) * den(74)
  A(32) = cont_QA(wf(:,23),wf(:,79)) * den(76)
  A(33) = cont_QA(wf(:,27),wf(:,80)) * den(77)
  A(34) = cont_QA(wf(:,63),wf(:,76)) * den(78)
  A(35) = cont_QA(wf(:,37),wf(:,82)) * den(81)
  A(36) = cont_QA(wf(:,57),wf(:,84)) * den(83)
  A(37) = cont_QA(wf(:,6),wf(:,85)) * den(85)
  A(38) = cont_QA(wf(:,31),wf(:,87)) * den(87)
  A(39) = cont_VV(wf(:,88),wf(:,89)) * den(89)
  A(40) = cont_QA(wf(:,63),wf(:,84)) * den(90)
  A(41) = cont_VV(wf(:,88),wf(:,90)) * den(91)
  A(42) = cont_QA(wf(:,37),wf(:,91)) * den(92)
  A(43) = cont_QA(wf(:,41),wf(:,74)) * den(93)
  A(44) = cont_QA(wf(:,55),wf(:,72)) * den(94)
  A(45) = cont_QA(wf(:,34),wf(:,80)) * den(95)
  A(46) = cont_QA(wf(:,62),wf(:,67)) * den(96)
  A(47) = cont_VV(wf(:,89),wf(:,92)) * den(98)
  A(48) = cont_QA(wf(:,62),wf(:,71)) * den(99)
  A(49) = cont_VV(wf(:,90),wf(:,92)) * den(100)
  A(50) = cont_QA(wf(:,37),wf(:,93)) * den(101)
  A(51) = cont_VV(wf(:,89),wf(:,94)) * den(103)
  A(52) = cont_QA(wf(:,39),wf(:,80)) * den(104)
  A(53) = cont_VV(wf(:,90),wf(:,94)) * den(105)
  A(54) = cont_QA(wf(:,37),wf(:,95)) * den(106)

  A(55) = cont_VV(wf(:,81),wf(:,97)) * den(109)
  A(56) = cont_VV(wf(:,81),wf(:,98)) * den(109)
  A(57) = cont_VV(wf(:,68),wf(:,99)) * den(110)
  A(58) = cont_VV(wf(:,68),wf(:,100)) * den(110)
  A(59) = cont_VV(wf(:,101),wf(:,102)) * den(113)
  A(60) = cont_VV(wf(:,101),wf(:,103)) * den(113)
  A(61) = cont_VV(wf(:,2),wf(:,104)) * den(114)
  A(62) = cont_VV(wf(:,7),wf(:,104)) * den(114)
  A(63) = cont_VV(wf(:,9),wf(:,104)) * den(114)
  A(64) = cont_VV(wf(:,105),wf(:,106)) * den(117)
  A(65) = cont_VV(wf(:,106),wf(:,107)) * den(117)
  A(66) = cont_VV(wf(:,106),wf(:,108)) * den(117)
  A(67) = cont_VV(wf(:,109),wf(:,110)) * den(120)
  A(68) = cont_VV(wf(:,110),wf(:,111)) * den(120)
  A(69) = cont_VV(wf(:,110),wf(:,112)) * den(120)
  A(70) = cont_VV(wf(:,113),wf(:,114)) * den(123)
  A(71) = cont_VV(wf(:,114),wf(:,115)) * den(123)
  A(72) = cont_VV(wf(:,114),wf(:,116)) * den(123)
  A(73) = cont_VV(wf(:,35),wf(:,117)) * den(124)
  A(74) = cont_VV(wf(:,35),wf(:,118)) * den(124)
  A(75) = cont_VV(wf(:,119),wf(:,120)) * den(127)
  A(76) = cont_VV(wf(:,119),wf(:,121)) * den(127)
  A(77) = cont_VV(wf(:,122),wf(:,123)) * den(130)
  A(78) = cont_VV(wf(:,122),wf(:,124)) * den(130)
  A(79) = cont_VV(wf(:,102),wf(:,125)) * den(132)
  A(80) = cont_VV(wf(:,103),wf(:,125)) * den(132)
  A(81) = cont_VV(wf(:,102),wf(:,126)) * den(134)
  A(82) = cont_VV(wf(:,103),wf(:,126)) * den(134)
  A(83) = cont_VV(wf(:,120),wf(:,127)) * den(136)
  A(84) = cont_VV(wf(:,121),wf(:,127)) * den(136)
  A(85) = cont_VV(wf(:,120),wf(:,128)) * den(138)
  A(86) = cont_VV(wf(:,121),wf(:,128)) * den(138)
  A(87) = cont_VV(wf(:,123),wf(:,129)) * den(140)
  A(88) = cont_VV(wf(:,124),wf(:,129)) * den(140)
  A(89) = cont_VV(wf(:,123),wf(:,130)) * den(142)
  A(90) = cont_VV(wf(:,124),wf(:,130)) * den(142)
  A(91) = cont_QA(wf(:,6),wf(:,132)) * den(5)
  A(92) = cont_QA(wf(:,6),wf(:,134)) * den(5)
  A(93) = cont_QA(wf(:,6),wf(:,136)) * den(5)
  A(94) = cont_QA(wf(:,6),wf(:,132)) * den(5)
  A(95) = cont_QA(wf(:,6),wf(:,134)) * den(5)
  A(96) = cont_QA(wf(:,6),wf(:,136)) * den(5)
  A(97) = cont_QA(wf(:,12),wf(:,138)) * den(8)
  A(98) = cont_QA(wf(:,12),wf(:,140)) * den(8)
  A(99) = cont_QA(wf(:,12),wf(:,142)) * den(8)
  A(100) = cont_QA(wf(:,12),wf(:,138)) * den(8)
  A(101) = cont_QA(wf(:,12),wf(:,140)) * den(8)
  A(102) = cont_QA(wf(:,12),wf(:,142)) * den(8)
  A(103) = cont_QA(wf(:,6),wf(:,143)) * den(5)
  A(104) = cont_QA(wf(:,6),wf(:,144)) * den(5)
  A(105) = cont_QA(wf(:,6),wf(:,145)) * den(5)
  A(106) = cont_QA(wf(:,13),wf(:,146)) * den(8)
  A(107) = cont_QA(wf(:,15),wf(:,146)) * den(8)
  A(108) = cont_QA(wf(:,17),wf(:,146)) * den(8)
  A(109) = cont_QA(wf(:,37),wf(:,147)) * den(143)
  A(110) = cont_QA(wf(:,37),wf(:,148)) * den(143)
  A(111) = cont_QA(wf(:,37),wf(:,149)) * den(143)
  A(112) = cont_QA(wf(:,150),wf(:,151)) * den(146)
  A(113) = cont_QA(wf(:,150),wf(:,152)) * den(146)
  A(114) = cont_QA(wf(:,150),wf(:,153)) * den(146)
  A(115) = cont_VV(wf(:,122),wf(:,154)) * den(148)
  A(116) = cont_VV(wf(:,88),wf(:,104)) * den(149)
  A(117) = cont_VV(wf(:,106),wf(:,155)) * den(152)
  A(118) = cont_VV(wf(:,119),wf(:,156)) * den(154)
  A(119) = cont_VV(wf(:,92),wf(:,104)) * den(155)
  A(120) = cont_VV(wf(:,101),wf(:,157)) * den(157)
  A(121) = cont_VV(wf(:,94),wf(:,104)) * den(158)
  A(122) = cont_VV(wf(:,106),wf(:,158)) * den(161)
  A(123) = cont_VV(wf(:,106),wf(:,159)) * den(162)
  A(124) = cont_VV(wf(:,110),wf(:,160)) * den(165)
  A(125) = cont_VV(wf(:,110),wf(:,161)) * den(168)
  A(126) = cont_VV(wf(:,122),wf(:,162)) * den(169)
  A(127) = cont_VV(wf(:,114),wf(:,163)) * den(172)
  A(128) = cont_VV(wf(:,119),wf(:,164)) * den(175)
  A(129) = cont_VV(wf(:,122),wf(:,165)) * den(176)
  A(130) = cont_QA(wf(:,24),wf(:,166)) * den(14)
  A(131) = cont_QA(wf(:,27),wf(:,167)) * den(18)
  A(132) = cont_QA(wf(:,168),wf(:,169)) * den(179)
  A(133) = cont_QA(wf(:,170),wf(:,171)) * den(182)
  A(134) = cont_VV(wf(:,106),wf(:,172)) * den(185)
  A(135) = cont_QA(wf(:,32),wf(:,173)) * den(23)
  A(136) = cont_QA(wf(:,34),wf(:,167)) * den(25)
  A(137) = cont_QA(wf(:,37),wf(:,174)) * den(30)
  A(138) = cont_VV(wf(:,125),wf(:,157)) * den(186)
  A(139) = cont_QA(wf(:,39),wf(:,167)) * den(32)
  A(140) = cont_QA(wf(:,32),wf(:,175)) * den(33)
  A(141) = cont_QA(wf(:,41),wf(:,176)) * den(34)
  A(142) = cont_VV(wf(:,106),wf(:,177)) * den(187)
  A(143) = cont_VV(wf(:,106),wf(:,178)) * den(188)
  A(144) = cont_QA(wf(:,169),wf(:,179)) * den(189)
  A(145) = cont_QA(wf(:,180),wf(:,181)) * den(192)
  A(146) = cont_VV(wf(:,110),wf(:,182)) * den(195)
  A(147) = cont_QA(wf(:,24),wf(:,183)) * den(34)
  A(148) = cont_QA(wf(:,40),wf(:,184)) * den(33)
  A(149) = cont_VV(wf(:,110),wf(:,185)) * den(196)
  A(150) = cont_QA(wf(:,24),wf(:,186)) * den(197)
  A(151) = cont_QA(wf(:,37),wf(:,188)) * den(30)
  A(152) = cont_QA(wf(:,26),wf(:,190)) * den(32)
  A(153) = cont_QA(wf(:,48),wf(:,191)) * den(40)
  A(154) = cont_QA(wf(:,51),wf(:,192)) * den(44)
  A(155) = cont_QA(wf(:,193),wf(:,194)) * den(200)
  A(156) = cont_QA(wf(:,195),wf(:,196)) * den(203)
  A(157) = cont_VV(wf(:,106),wf(:,197)) * den(206)
  A(158) = cont_QA(wf(:,55),wf(:,191)) * den(47)
  A(159) = cont_QA(wf(:,58),wf(:,198)) * den(51)
  A(160) = cont_QA(wf(:,6),wf(:,199)) * den(53)
  A(161) = cont_VV(wf(:,126),wf(:,157)) * den(207)
  A(162) = cont_QA(wf(:,61),wf(:,191)) * den(55)
  A(163) = cont_QA(wf(:,62),wf(:,200)) * den(56)
  A(164) = cont_QA(wf(:,58),wf(:,201)) * den(57)
  A(165) = cont_VV(wf(:,106),wf(:,202)) * den(208)
  A(166) = cont_VV(wf(:,106),wf(:,203)) * den(209)
  A(167) = cont_QA(wf(:,204),wf(:,205)) * den(212)
  A(168) = cont_QA(wf(:,196),wf(:,206)) * den(213)
  A(169) = cont_VV(wf(:,110),wf(:,207)) * den(216)
  A(170) = cont_QA(wf(:,63),wf(:,208)) * den(57)
  A(171) = cont_QA(wf(:,51),wf(:,209)) * den(56)
  A(172) = cont_VV(wf(:,110),wf(:,210)) * den(217)
  A(173) = cont_QA(wf(:,51),wf(:,211)) * den(218)
  A(174) = cont_QA(wf(:,6),wf(:,212)) * den(53)
  A(175) = cont_QA(wf(:,47),wf(:,214)) * den(55)
  A(176) = cont_QA(wf(:,65),wf(:,173)) * den(59)
  A(177) = cont_QA(wf(:,67),wf(:,192)) * den(61)
  A(178) = cont_QA(wf(:,37),wf(:,215)) * den(64)
  A(179) = cont_VV(wf(:,127),wf(:,156)) * den(219)
  A(180) = cont_QA(wf(:,71),wf(:,192)) * den(66)
  A(181) = cont_QA(wf(:,65),wf(:,175)) * den(67)
  A(182) = cont_QA(wf(:,72),wf(:,216)) * den(68)
  A(183) = cont_VV(wf(:,106),wf(:,217)) * den(220)
  A(184) = cont_VV(wf(:,106),wf(:,218)) * den(221)
  A(185) = cont_QA(wf(:,74),wf(:,166)) * den(70)
  A(186) = cont_QA(wf(:,76),wf(:,198)) * den(72)
  A(187) = cont_QA(wf(:,6),wf(:,219)) * den(74)
  A(188) = cont_VV(wf(:,128),wf(:,156)) * den(222)
  A(189) = cont_QA(wf(:,79),wf(:,166)) * den(76)
  A(190) = cont_QA(wf(:,80),wf(:,220)) * den(77)
  A(191) = cont_QA(wf(:,76),wf(:,201)) * den(78)
  A(192) = cont_VV(wf(:,106),wf(:,221)) * den(223)
  A(193) = cont_VV(wf(:,106),wf(:,222)) * den(224)
  A(194) = cont_QA(wf(:,37),wf(:,223)) * den(81)
  A(195) = cont_VV(wf(:,129),wf(:,154)) * den(225)
  A(196) = cont_QA(wf(:,84),wf(:,198)) * den(83)
  A(197) = cont_QA(wf(:,6),wf(:,224)) * den(85)
  A(198) = cont_VV(wf(:,130),wf(:,154)) * den(226)
  A(199) = cont_QA(wf(:,87),wf(:,173)) * den(87)
  A(200) = cont_VV(wf(:,89),wf(:,225)) * den(89)
  A(201) = cont_QA(wf(:,84),wf(:,201)) * den(90)
  A(202) = cont_VV(wf(:,90),wf(:,225)) * den(91)
  A(203) = cont_QA(wf(:,37),wf(:,226)) * den(92)
  A(204) = cont_VV(wf(:,106),wf(:,227)) * den(227)
  A(205) = cont_VV(wf(:,106),wf(:,228)) * den(228)
  A(206) = cont_QA(wf(:,74),wf(:,183)) * den(93)
  A(207) = cont_QA(wf(:,72),wf(:,229)) * den(94)
  A(208) = cont_VV(wf(:,110),wf(:,230)) * den(229)
  A(209) = cont_VV(wf(:,110),wf(:,231)) * den(230)
  A(210) = cont_QA(wf(:,80),wf(:,232)) * den(95)
  A(211) = cont_QA(wf(:,67),wf(:,209)) * den(96)
  A(212) = cont_VV(wf(:,110),wf(:,233)) * den(231)
  A(213) = cont_VV(wf(:,110),wf(:,234)) * den(232)
  A(214) = cont_VV(wf(:,89),wf(:,235)) * den(98)
  A(215) = cont_QA(wf(:,71),wf(:,209)) * den(99)
  A(216) = cont_VV(wf(:,90),wf(:,235)) * den(100)
  A(217) = cont_QA(wf(:,37),wf(:,236)) * den(101)
  A(218) = cont_VV(wf(:,110),wf(:,237)) * den(233)
  A(219) = cont_VV(wf(:,110),wf(:,238)) * den(234)
  A(220) = cont_VV(wf(:,89),wf(:,239)) * den(103)
  A(221) = cont_QA(wf(:,80),wf(:,190)) * den(104)
  A(222) = cont_VV(wf(:,90),wf(:,239)) * den(105)
  A(223) = cont_QA(wf(:,37),wf(:,240)) * den(106)
  A(224) = cont_QA(wf(:,151),wf(:,241)) * den(235)
  A(225) = cont_QA(wf(:,152),wf(:,241)) * den(235)
  A(226) = cont_QA(wf(:,153),wf(:,241)) * den(235)
  A(227) = cont_QA(wf(:,37),wf(:,242)) * den(236)
  A(228) = cont_QA(wf(:,37),wf(:,243)) * den(236)
  A(229) = cont_QA(wf(:,37),wf(:,244)) * den(236)
  A(230) = cont_QA(wf(:,37),wf(:,246)) * den(238)
  A(231) = cont_QA(wf(:,37),wf(:,248)) * den(238)
  A(232) = cont_QA(wf(:,37),wf(:,250)) * den(238)
  A(233) = cont_QA(wf(:,6),wf(:,251)) * den(239)
  A(234) = cont_QA(wf(:,6),wf(:,252)) * den(239)
  A(235) = cont_QA(wf(:,6),wf(:,253)) * den(239)
  A(236) = cont_QA(wf(:,194),wf(:,254)) * den(240)
  A(237) = cont_QA(wf(:,181),wf(:,255)) * den(241)
  A(238) = cont_VV(wf(:,114),wf(:,256)) * den(244)
  A(239) = cont_QA(wf(:,48),wf(:,257)) * den(68)
  A(240) = cont_QA(wf(:,40),wf(:,258)) * den(67)
  A(241) = cont_VV(wf(:,114),wf(:,259)) * den(245)
  A(242) = cont_QA(wf(:,48),wf(:,260)) * den(246)
  A(243) = cont_QA(wf(:,37),wf(:,262)) * den(64)
  A(244) = cont_QA(wf(:,50),wf(:,264)) * den(66)
  A(245) = cont_QA(wf(:,205),wf(:,265)) * den(247)
  A(246) = cont_QA(wf(:,171),wf(:,266)) * den(248)
  A(247) = cont_VV(wf(:,114),wf(:,267)) * den(251)
  A(248) = cont_QA(wf(:,63),wf(:,268)) * den(78)
  A(249) = cont_QA(wf(:,27),wf(:,269)) * den(77)
  A(250) = cont_VV(wf(:,114),wf(:,270)) * den(252)
  A(251) = cont_QA(wf(:,27),wf(:,271)) * den(253)
  A(252) = cont_QA(wf(:,6),wf(:,272)) * den(74)
  A(253) = cont_QA(wf(:,23),wf(:,274)) * den(76)
  A(254) = cont_QA(wf(:,55),wf(:,257)) * den(94)
  A(255) = cont_QA(wf(:,41),wf(:,275)) * den(93)
  A(256) = cont_VV(wf(:,114),wf(:,276)) * den(254)
  A(257) = cont_QA(wf(:,55),wf(:,260)) * den(255)
  A(258) = cont_QA(wf(:,62),wf(:,277)) * den(96)
  A(259) = cont_QA(wf(:,34),wf(:,269)) * den(95)
  A(260) = cont_VV(wf(:,114),wf(:,278)) * den(256)
  A(261) = cont_QA(wf(:,34),wf(:,271)) * den(257)
  A(262) = cont_VV(wf(:,89),wf(:,279)) * den(103)
  A(263) = cont_QA(wf(:,39),wf(:,269)) * den(104)
  A(264) = cont_VV(wf(:,90),wf(:,279)) * den(105)
  A(265) = cont_QA(wf(:,37),wf(:,280)) * den(106)
  A(266) = cont_VV(wf(:,114),wf(:,281)) * den(258)
  A(267) = cont_VV(wf(:,114),wf(:,282)) * den(259)
  A(268) = cont_VV(wf(:,89),wf(:,283)) * den(98)
  A(269) = cont_QA(wf(:,62),wf(:,264)) * den(99)
  A(270) = cont_VV(wf(:,90),wf(:,283)) * den(100)
  A(271) = cont_QA(wf(:,37),wf(:,284)) * den(101)
  A(272) = cont_QA(wf(:,37),wf(:,286)) * den(81)
  A(273) = cont_QA(wf(:,57),wf(:,288)) * den(83)
  A(274) = cont_QA(wf(:,6),wf(:,289)) * den(85)
  A(275) = cont_QA(wf(:,31),wf(:,291)) * den(87)
  A(276) = cont_VV(wf(:,89),wf(:,292)) * den(89)
  A(277) = cont_QA(wf(:,63),wf(:,288)) * den(90)
  A(278) = cont_VV(wf(:,90),wf(:,292)) * den(91)
  A(279) = cont_QA(wf(:,37),wf(:,293)) * den(92)
  A(280) = cont_QA(wf(:,169),wf(:,294)) * den(260)
  A(281) = cont_QA(wf(:,146),wf(:,295)) * den(262)
  A(282) = cont_QA(wf(:,32),wf(:,297)) * den(33)
  A(283) = cont_QA(wf(:,24),wf(:,298)) * den(34)
  A(284) = cont_QA(wf(:,32),wf(:,301)) * den(23)
  A(285) = cont_QA(wf(:,26),wf(:,303)) * den(25)
  A(286) = cont_QA(wf(:,24),wf(:,306)) * den(14)
  A(287) = cont_QA(wf(:,26),wf(:,308)) * den(18)
  A(288) = cont_QA(wf(:,194),wf(:,309)) * den(263)
  A(289) = cont_QA(wf(:,146),wf(:,310)) * den(265)
  A(290) = cont_QA(wf(:,65),wf(:,297)) * den(67)
  A(291) = cont_QA(wf(:,48),wf(:,311)) * den(68)
  A(292) = cont_QA(wf(:,65),wf(:,301)) * den(59)
  A(293) = cont_QA(wf(:,50),wf(:,313)) * den(61)
  A(294) = cont_QA(wf(:,205),wf(:,314)) * den(266)
  A(295) = cont_QA(wf(:,146),wf(:,315)) * den(268)
  A(296) = cont_QA(wf(:,63),wf(:,316)) * den(90)
  A(297) = cont_VV(wf(:,88),wf(:,317)) * den(89)
  A(298) = cont_QA(wf(:,91),wf(:,296)) * den(92)
  A(299) = cont_VV(wf(:,88),wf(:,318)) * den(91)
  A(300) = cont_QA(wf(:,6),wf(:,319)) * den(85)
  A(301) = cont_QA(wf(:,87),wf(:,301)) * den(87)
  A(302) = cont_QA(wf(:,74),wf(:,298)) * den(93)
  A(303) = cont_QA(wf(:,55),wf(:,311)) * den(94)
  A(304) = cont_QA(wf(:,62),wf(:,320)) * den(99)
  A(305) = cont_VV(wf(:,92),wf(:,317)) * den(98)
  A(306) = cont_QA(wf(:,93),wf(:,296)) * den(101)
  A(307) = cont_VV(wf(:,92),wf(:,318)) * den(100)
  A(308) = cont_QA(wf(:,80),wf(:,321)) * den(104)
  A(309) = cont_VV(wf(:,94),wf(:,317)) * den(103)
  A(310) = cont_QA(wf(:,95),wf(:,296)) * den(106)
  A(311) = cont_VV(wf(:,94),wf(:,318)) * den(105)
  A(312) = cont_QA(wf(:,80),wf(:,303)) * den(95)
  A(313) = cont_QA(wf(:,62),wf(:,313)) * den(96)
  A(314) = cont_QA(wf(:,74),wf(:,306)) * den(70)
  A(315) = cont_QA(wf(:,57),wf(:,323)) * den(72)
  A(316) = cont_QA(wf(:,6),wf(:,324)) * den(74)
  A(317) = cont_QA(wf(:,79),wf(:,306)) * den(76)
  A(318) = cont_QA(wf(:,80),wf(:,308)) * den(77)
  A(319) = cont_QA(wf(:,63),wf(:,323)) * den(78)
  A(320) = cont_QA(wf(:,48),wf(:,327)) * den(40)
  A(321) = cont_QA(wf(:,50),wf(:,329)) * den(44)
  A(322) = cont_QA(wf(:,55),wf(:,327)) * den(47)
  A(323) = cont_QA(wf(:,57),wf(:,331)) * den(51)
  A(324) = cont_QA(wf(:,6),wf(:,332)) * den(53)
  A(325) = cont_QA(wf(:,61),wf(:,327)) * den(55)
  A(326) = cont_QA(wf(:,62),wf(:,329)) * den(56)
  A(327) = cont_QA(wf(:,63),wf(:,331)) * den(57)
  A(328) = cont_QA(wf(:,196),wf(:,333)) * den(269)
  A(329) = cont_QA(wf(:,150),wf(:,334)) * den(271)
  A(330) = cont_QA(wf(:,51),wf(:,336)) * den(56)
  A(331) = cont_QA(wf(:,58),wf(:,337)) * den(57)
  A(332) = cont_QA(wf(:,47),wf(:,341)) * den(47)
  A(333) = cont_QA(wf(:,58),wf(:,342)) * den(51)
  A(334) = cont_QA(wf(:,47),wf(:,346)) * den(40)
  A(335) = cont_QA(wf(:,51),wf(:,347)) * den(44)
  A(336) = cont_QA(wf(:,171),wf(:,348)) * den(272)
  A(337) = cont_QA(wf(:,150),wf(:,349)) * den(274)
  A(338) = cont_QA(wf(:,27),wf(:,350)) * den(77)
  A(339) = cont_QA(wf(:,76),wf(:,337)) * den(78)
  A(340) = cont_QA(wf(:,23),wf(:,352)) * den(70)
  A(341) = cont_QA(wf(:,76),wf(:,342)) * den(72)
  A(342) = cont_QA(wf(:,181),wf(:,353)) * den(275)
  A(343) = cont_QA(wf(:,150),wf(:,354)) * den(277)
  A(344) = cont_VV(wf(:,88),wf(:,355)) * den(91)
  A(345) = cont_QA(wf(:,37),wf(:,357)) * den(92)
  A(346) = cont_VV(wf(:,88),wf(:,358)) * den(89)
  A(347) = cont_QA(wf(:,84),wf(:,337)) * den(90)
  A(348) = cont_QA(wf(:,37),wf(:,359)) * den(81)
  A(349) = cont_QA(wf(:,84),wf(:,342)) * den(83)
  A(350) = cont_QA(wf(:,34),wf(:,350)) * den(95)
  A(351) = cont_QA(wf(:,67),wf(:,336)) * den(96)
  A(352) = cont_VV(wf(:,92),wf(:,355)) * den(100)
  A(353) = cont_QA(wf(:,37),wf(:,361)) * den(101)
  A(354) = cont_VV(wf(:,92),wf(:,358)) * den(98)
  A(355) = cont_QA(wf(:,71),wf(:,336)) * den(99)
  A(356) = cont_VV(wf(:,94),wf(:,355)) * den(105)
  A(357) = cont_QA(wf(:,37),wf(:,363)) * den(106)
  A(358) = cont_VV(wf(:,94),wf(:,358)) * den(103)
  A(359) = cont_QA(wf(:,39),wf(:,350)) * den(104)
  A(360) = cont_QA(wf(:,41),wf(:,352)) * den(93)
  A(361) = cont_QA(wf(:,72),wf(:,341)) * den(94)
  A(362) = cont_QA(wf(:,31),wf(:,365)) * den(59)
  A(363) = cont_QA(wf(:,67),wf(:,347)) * den(61)
  A(364) = cont_QA(wf(:,37),wf(:,366)) * den(64)
  A(365) = cont_QA(wf(:,71),wf(:,347)) * den(66)
  A(366) = cont_QA(wf(:,40),wf(:,365)) * den(67)
  A(367) = cont_QA(wf(:,72),wf(:,346)) * den(68)
  A(368) = cont_QA(wf(:,23),wf(:,370)) * den(14)
  A(369) = cont_QA(wf(:,27),wf(:,371)) * den(18)
  A(370) = cont_QA(wf(:,31),wf(:,373)) * den(23)
  A(371) = cont_QA(wf(:,34),wf(:,371)) * den(25)
  A(372) = cont_QA(wf(:,37),wf(:,374)) * den(30)
  A(373) = cont_QA(wf(:,39),wf(:,371)) * den(32)
  A(374) = cont_QA(wf(:,40),wf(:,373)) * den(33)
  A(375) = cont_QA(wf(:,41),wf(:,370)) * den(34)
  A(376) = cont_QA(wf(:,171),wf(:,377)) * den(279)
  A(377) = cont_QA(wf(:,27),wf(:,378)) * den(281)
  A(378) = cont_QA(wf(:,169),wf(:,381)) * den(283)
  A(379) = cont_QA(wf(:,24),wf(:,382)) * den(285)
  A(380) = cont_QA(wf(:,171),wf(:,383)) * den(286)
  A(381) = cont_QA(wf(:,169),wf(:,384)) * den(287)
  A(382) = cont_QA(wf(:,181),wf(:,385)) * den(288)
  A(383) = cont_QA(wf(:,34),wf(:,378)) * den(289)
  A(384) = cont_QA(wf(:,169),wf(:,388)) * den(291)
  A(385) = cont_QA(wf(:,32),wf(:,389)) * den(293)
  A(386) = cont_QA(wf(:,181),wf(:,390)) * den(294)
  A(387) = cont_QA(wf(:,169),wf(:,391)) * den(295)
  A(388) = cont_VV(wf(:,35),wf(:,392)) * den(297)
  A(389) = cont_QA(wf(:,39),wf(:,378)) * den(298)
  A(390) = cont_QA(wf(:,169),wf(:,394)) * den(300)
  A(391) = cont_QA(wf(:,295),wf(:,395)) * den(301)
  A(392) = cont_QA(wf(:,169),wf(:,396)) * den(302)
  A(393) = cont_QA(wf(:,37),wf(:,397)) * den(304)
  A(394) = cont_QA(wf(:,40),wf(:,398)) * den(306)
  A(395) = cont_QA(wf(:,377),wf(:,399)) * den(308)
  A(396) = cont_QA(wf(:,395),wf(:,401)) * den(310)
  A(397) = cont_QA(wf(:,395),wf(:,403)) * den(312)
  A(398) = cont_QA(wf(:,390),wf(:,404)) * den(314)
  A(399) = cont_QA(wf(:,383),wf(:,399)) * den(315)
  A(400) = cont_QA(wf(:,196),wf(:,407)) * den(317)
  A(401) = cont_QA(wf(:,51),wf(:,408)) * den(319)
  A(402) = cont_QA(wf(:,194),wf(:,411)) * den(321)
  A(403) = cont_QA(wf(:,48),wf(:,412)) * den(323)
  A(404) = cont_QA(wf(:,196),wf(:,413)) * den(324)
  A(405) = cont_QA(wf(:,194),wf(:,414)) * den(325)
  A(406) = cont_QA(wf(:,196),wf(:,417)) * den(327)
  A(407) = cont_QA(wf(:,58),wf(:,418)) * den(329)
  A(408) = cont_QA(wf(:,205),wf(:,419)) * den(330)
  A(409) = cont_QA(wf(:,55),wf(:,412)) * den(331)
  A(410) = cont_QA(wf(:,196),wf(:,420)) * den(332)
  A(411) = cont_QA(wf(:,205),wf(:,421)) * den(333)
  A(412) = cont_QA(wf(:,196),wf(:,422)) * den(334)
  A(413) = cont_QA(wf(:,241),wf(:,334)) * den(335)
  A(414) = cont_QA(wf(:,196),wf(:,423)) * den(336)
  A(415) = cont_VV(wf(:,35),wf(:,424)) * den(338)
  A(416) = cont_QA(wf(:,61),wf(:,412)) * den(339)
  A(417) = cont_QA(wf(:,45),wf(:,425)) * den(341)
  A(418) = cont_QA(wf(:,241),wf(:,427)) * den(343)
  A(419) = cont_QA(wf(:,241),wf(:,429)) * den(345)
  A(420) = cont_QA(wf(:,63),wf(:,430)) * den(347)
  A(421) = cont_QA(wf(:,411),wf(:,431)) * den(349)
  A(422) = cont_QA(wf(:,414),wf(:,431)) * den(350)
  A(423) = cont_QA(wf(:,421),wf(:,432)) * den(352)
  A(424) = cont_QA(wf(:,181),wf(:,433)) * den(353)
  A(425) = cont_QA(wf(:,67),wf(:,408)) * den(354)
  A(426) = cont_QA(wf(:,194),wf(:,434)) * den(355)
  A(427) = cont_QA(wf(:,65),wf(:,389)) * den(356)
  A(428) = cont_QA(wf(:,181),wf(:,435)) * den(357)
  A(429) = cont_QA(wf(:,194),wf(:,436)) * den(358)
  A(430) = cont_VV(wf(:,68),wf(:,437)) * den(360)
  A(431) = cont_QA(wf(:,71),wf(:,408)) * den(361)
  A(432) = cont_QA(wf(:,194),wf(:,439)) * den(363)
  A(433) = cont_QA(wf(:,310),wf(:,395)) * den(364)
  A(434) = cont_QA(wf(:,194),wf(:,440)) * den(365)
  A(435) = cont_QA(wf(:,37),wf(:,441)) * den(367)
  A(436) = cont_QA(wf(:,40),wf(:,442)) * den(369)
  A(437) = cont_QA(wf(:,407),wf(:,443)) * den(371)
  A(438) = cont_QA(wf(:,395),wf(:,445)) * den(373)
  A(439) = cont_QA(wf(:,395),wf(:,447)) * den(375)
  A(440) = cont_QA(wf(:,404),wf(:,435)) * den(376)
  A(441) = cont_QA(wf(:,413),wf(:,443)) * den(377)
  A(442) = cont_QA(wf(:,171),wf(:,448)) * den(378)
  A(443) = cont_QA(wf(:,76),wf(:,418)) * den(379)
  A(444) = cont_QA(wf(:,205),wf(:,449)) * den(380)
  A(445) = cont_QA(wf(:,74),wf(:,382)) * den(381)
  A(446) = cont_QA(wf(:,171),wf(:,450)) * den(382)
  A(447) = cont_QA(wf(:,205),wf(:,451)) * den(383)
  A(448) = cont_QA(wf(:,171),wf(:,452)) * den(384)
  A(449) = cont_QA(wf(:,241),wf(:,349)) * den(385)
  A(450) = cont_QA(wf(:,171),wf(:,453)) * den(386)
  A(451) = cont_VV(wf(:,68),wf(:,454)) * den(388)
  A(452) = cont_QA(wf(:,79),wf(:,382)) * den(389)
  A(453) = cont_QA(wf(:,21),wf(:,455)) * den(391)
  A(454) = cont_QA(wf(:,241),wf(:,457)) * den(393)
  A(455) = cont_QA(wf(:,241),wf(:,459)) * den(395)
  A(456) = cont_QA(wf(:,63),wf(:,460)) * den(397)
  A(457) = cont_QA(wf(:,381),wf(:,461)) * den(399)
  A(458) = cont_QA(wf(:,384),wf(:,461)) * den(400)
  A(459) = cont_QA(wf(:,432),wf(:,451)) * den(401)
  A(460) = cont_VV(wf(:,81),wf(:,462)) * den(403)
  A(461) = cont_QA(wf(:,84),wf(:,418)) * den(404)
  A(462) = cont_QA(wf(:,205),wf(:,464)) * den(406)
  A(463) = cont_QA(wf(:,315),wf(:,395)) * den(407)
  A(464) = cont_QA(wf(:,205),wf(:,465)) * den(408)
  A(465) = cont_QA(wf(:,37),wf(:,466)) * den(410)
  A(466) = cont_QA(wf(:,181),wf(:,467)) * den(411)
  A(467) = cont_QA(wf(:,241),wf(:,354)) * den(412)
  A(468) = cont_QA(wf(:,181),wf(:,468)) * den(413)
  A(469) = cont_VV(wf(:,81),wf(:,469)) * den(415)
  A(470) = cont_QA(wf(:,87),wf(:,389)) * den(416)
  A(471) = cont_QA(wf(:,29),wf(:,470)) * den(418)
  A(472) = cont_QA(wf(:,241),wf(:,472)) * den(420)
  A(473) = cont_QA(wf(:,395),wf(:,474)) * den(422)
  A(474) = cont_QA(wf(:,40),wf(:,475)) * den(424)
  A(475) = cont_QA(wf(:,241),wf(:,477)) * den(426)
  A(476) = cont_VV(wf(:,90),wf(:,478)) * den(429)
  A(477) = cont_QA(wf(:,404),wf(:,468)) * den(430)
  A(478) = cont_QA(wf(:,63),wf(:,479)) * den(432)
  A(479) = cont_VV(wf(:,89),wf(:,478)) * den(434)
  A(480) = cont_QA(wf(:,432),wf(:,465)) * den(435)
  A(481) = cont_QA(wf(:,395),wf(:,480)) * den(437)
  A(482) = cont_VV(wf(:,89),wf(:,481)) * den(438)
  A(483) = cont_VV(wf(:,90),wf(:,481)) * den(439)
  A(484) = cont_QA(wf(:,41),wf(:,482)) * den(441)
  A(485) = cont_QA(wf(:,417),wf(:,443)) * den(442)
  A(486) = cont_QA(wf(:,395),wf(:,484)) * den(444)
  A(487) = cont_QA(wf(:,395),wf(:,486)) * den(446)
  A(488) = cont_QA(wf(:,399),wf(:,450)) * den(447)
  A(489) = cont_QA(wf(:,420),wf(:,443)) * den(448)
  A(490) = cont_QA(wf(:,241),wf(:,488)) * den(450)
  A(491) = cont_QA(wf(:,241),wf(:,490)) * den(452)
  A(492) = cont_QA(wf(:,62),wf(:,491)) * den(454)
  A(493) = cont_QA(wf(:,388),wf(:,461)) * den(455)
  A(494) = cont_QA(wf(:,391),wf(:,461)) * den(456)
  A(495) = cont_QA(wf(:,431),wf(:,436)) * den(457)
  A(496) = cont_QA(wf(:,241),wf(:,493)) * den(459)
  A(497) = cont_QA(wf(:,395),wf(:,495)) * den(461)
  A(498) = cont_QA(wf(:,41),wf(:,496)) * den(463)
  A(499) = cont_QA(wf(:,241),wf(:,498)) * den(465)
  A(500) = cont_VV(wf(:,90),wf(:,499)) * den(466)
  A(501) = cont_QA(wf(:,399),wf(:,453)) * den(467)
  A(502) = cont_QA(wf(:,62),wf(:,500)) * den(469)
  A(503) = cont_VV(wf(:,89),wf(:,499)) * den(470)
  A(504) = cont_QA(wf(:,431),wf(:,440)) * den(471)
  A(505) = cont_QA(wf(:,395),wf(:,501)) * den(473)
  A(506) = cont_VV(wf(:,89),wf(:,502)) * den(474)
  A(507) = cont_VV(wf(:,90),wf(:,502)) * den(475)
  A(508) = cont_QA(wf(:,241),wf(:,504)) * den(477)
  A(509) = cont_QA(wf(:,395),wf(:,506)) * den(479)
  A(510) = cont_QA(wf(:,241),wf(:,508)) * den(481)
  A(511) = cont_VV(wf(:,90),wf(:,509)) * den(482)
  A(512) = cont_QA(wf(:,423),wf(:,443)) * den(483)
  A(513) = cont_QA(wf(:,72),wf(:,510)) * den(485)
  A(514) = cont_VV(wf(:,89),wf(:,509)) * den(486)
  A(515) = cont_QA(wf(:,396),wf(:,461)) * den(487)
  A(516) = cont_QA(wf(:,395),wf(:,511)) * den(489)
  A(517) = cont_QA(wf(:,80),wf(:,512)) * den(491)
  A(518) = cont_VV(wf(:,89),wf(:,513)) * den(492)
  A(519) = cont_VV(wf(:,90),wf(:,513)) * den(493)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(519)
  complex(REALKIND), intent(out) :: M1(6), M2(11)

  M1(1) = (A(1)-A(2)+A(4)-A(5)+A(17)+A(18)+A(22)+A(39)+A(41)+A(44)+A(51)+A(53))*f(1)+CI*(A(19)+A(20)+A(35)+A(36)+A(40) &
       +A(54))*f(2)
  M1(2) = (A(2)-A(3)+A(5)-A(6)+A(15)+A(16)+A(21)+A(28)-A(47)-A(49)-A(51)-A(53))*f(1)+CI*(-A(19)-A(20)+A(25)+A(26)+A(48) &
       -A(54))*f(2)
  M1(3) = (-A(1)+A(3)-A(4)+A(6)+A(29)+A(30)+A(34)-A(39)-A(41)+A(43)+A(47)+A(49))*f(1)+CI*(A(31)+A(32)-A(35)-A(36)-A(40) &
       +A(50))*f(2)
  M1(4) = (A(2)-A(3)+A(5)-A(6)+A(7)+A(8)+A(14)+A(33)-A(47)-A(49)-A(51)-A(53))*f(1)+CI*(A(11)+A(12)-A(31)-A(32)-A(50)+A(52))*f(2)
  M1(5) = (-A(1)+A(3)-A(4)+A(6)+A(23)+A(24)+A(27)-A(39)-A(41)+A(46)+A(47)+A(49))*f(1)+CI*(-A(25)-A(26)+A(37)+A(38)+A(42) &
       -A(48))*f(2)
  M1(6) = (A(1)-A(2)+A(4)-A(5)+A(9)+A(10)+A(13)+A(39)+A(41)+A(45)+A(51)+A(53))*f(1)+CI*(-A(11)-A(12)-A(37)-A(38)-A(42) &
       -A(52))*f(2)

  M2( 1) = ((A(81)+A(87))*f(3))/2._/**/REALKIND+(-A(224)+A(225)-A(227)+A(228)-A(230)+A(231)-A(233)+A(234)-A(406)-A(407)-A(408) &
        -A(409)-A(410)-A(411)-A(419)-A(420)-A(423)-A(472)-A(473)-A(476)-A(479)-A(482)-A(483)-A(485)-A(486)-A(489)-A(508)-A(509) &
        -A(511)-A(514)-A(518)-A(519))*f(3)+(CI*(A(56)+A(59)+A(73)-A(77))*f(4))/2._/**/REALKIND+CI*(-A(412)-A(413)-A(414)-A(415) &
        -A(416)-A(417)-A(460)-A(461)-A(462)-A(463)-A(464)-A(465)-A(475)-A(478)-A(480)-A(512)-A(513)-A(516))*f(4)+(A(103)-A(104) &
        +A(109)-A(110)+A(164)+A(167)+A(168)+A(170)+A(207)+A(254)+A(297)+A(309)+A(322)+A(323)+A(327)+A(332)+A(333)+A(344)+A(356) &
        +A(361))*f(5)+CI*(A(160)+A(194)+A(201)+A(265)+A(294)+A(296)+A(324)+A(325)+A(328)+A(348)+A(349)+A(357))*f(6)+(A(106)-A(107) &
        +A(112)-A(113)+A(158)+A(159)+A(299)+A(303)+A(311)+A(331)+A(346)+A(358))*f(7)+CI*(A(162)+A(196)+A(295)+A(310)+A(329) &
        +A(347))*f(8)+(A(200)+A(202)+A(220)+A(222)+A(262)+A(264)+A(276)+A(278))*f(9)+CI*(A(174)+A(175)+A(223)+A(272)+A(273) &
        +A(277))*f(10)+(-A(91)-A(92)-A(97)-A(98))*f(11)+2*(A(93)+A(99))*f(11)+CI*(A(161)+A(165)-A(172)+A(195)+A(205)-A(208)+A(256) &
        +A(266))*f(12)+(-A(61)+A(62)-A(64)+A(65)+A(67)-A(69)-A(71)+A(72)+A(115)-A(116)-A(117)-A(120)-A(121)-A(122)+A(125)+A(126) &
        +A(127)+A(129)-A(166)-A(169)-A(257))*f(13)+(19*(A(94)+A(95)+A(100)+A(101))*f(14))/2._/**/REALKIND+18*(-A(96) &
        -A(102))*f(14)
  M2( 2) = ((A(82)+A(83))*f(3))/2._/**/REALKIND+(-A(225)+A(226)-A(228)+A(229)-A(231)+A(232)-A(234)+A(235)-A(400)-A(401)-A(402) &
        -A(403)-A(404)-A(405)-A(418)-A(421)-A(422)-A(437)-A(438)-A(441)+A(496)+A(497)+A(500)+A(503)+A(506)+A(507)+A(508)+A(509) &
        +A(511)+A(514)+A(518)+A(519))*f(3)+(CI*(A(58)+A(60)-A(73)-A(75))*f(4))/2._/**/REALKIND+CI*(A(412)+A(413)+A(414)+A(415) &
        +A(416)+A(417)-A(430)-A(431)-A(432)-A(433)-A(434)-A(435)-A(499)-A(502)-A(504)+A(512)+A(513)+A(516))*f(4)+(A(104)-A(105) &
        +A(110)-A(111)+A(155)+A(156)+A(163)+A(171)+A(182)+A(239)-A(305)-A(309)+A(320)+A(321)+A(326)+A(334)+A(335)-A(352)-A(356) &
        +A(367))*f(5)+CI*(-A(160)+A(178)+A(215)-A(265)+A(288)+A(304)-A(324)-A(325)-A(328)-A(357)+A(364)+A(365))*f(6)+(A(107) &
        -A(108)+A(113)-A(114)+A(153)+A(154)+A(291)-A(307)-A(311)+A(330)-A(354)-A(358))*f(7)+CI*(-A(162)+A(180)+A(289)-A(310) &
        -A(329)+A(355))*f(8)+(-A(214)-A(216)-A(220)-A(222)-A(262)-A(264)-A(268)-A(270))*f(9)+CI*(-A(174)-A(175)-A(223)+A(243) &
        +A(244)+A(269))*f(10)+2*(A(91)+A(97))*f(11)+(-A(92)-A(93)-A(98)-A(99))*f(11)+CI*(-A(161)-A(165)+A(172)+A(179)-A(183) &
        +A(219)-A(241)-A(266))*f(12)+(-A(62)+A(63)+A(64)-A(66)-A(67)+A(68)-A(70)+A(71)+A(118)+A(119)+A(120)+A(121)+A(122)-A(123) &
        -A(124)-A(125)-A(127)+A(128)-A(157)-A(173)-A(242))*f(13)+18*(-A(94)-A(100))*f(14)+(19*(A(95)+A(96)+A(101) &
        +A(102))*f(14))/2._/**/REALKIND
  M2( 3) = ((A(85)+A(88))*f(3))/2._/**/REALKIND+(A(224)-A(226)+A(227)-A(229)+A(230)-A(232)+A(233)-A(235)-A(442)-A(443)-A(444) &
        -A(445)-A(446)-A(447)-A(455)-A(456)-A(459)+A(472)+A(473)+A(476)+A(479)+A(482)+A(483)-A(484)-A(487)-A(488)-A(496)-A(497) &
        -A(500)-A(503)-A(506)-A(507))*f(3)+(CI*(-A(56)+A(57)+A(75)-A(78))*f(4))/2._/**/REALKIND+CI*(-A(448)-A(449)-A(450)-A(451) &
        -A(452)-A(453)+A(460)+A(461)+A(462)+A(463)+A(464)+A(465)+A(475)+A(478)+A(480)-A(498)-A(501)-A(505))*f(4)+(-A(103)+A(105) &
        -A(109)+A(111)+A(191)+A(206)+A(245)+A(246)+A(248)+A(255)-A(297)+A(305)+A(314)+A(315)+A(319)+A(340)+A(341)-A(344)+A(352) &
        +A(360))*f(5)+CI*(A(187)-A(194)-A(201)+A(217)-A(294)-A(296)+A(316)+A(317)+A(336)-A(348)-A(349)+A(353))*f(6)+(-A(106) &
        +A(108)-A(112)+A(114)+A(185)+A(186)-A(299)+A(302)+A(307)+A(339)-A(346)+A(354))*f(7)+CI*(A(189)-A(196)-A(295)+A(306)+A(337) &
        -A(347))*f(8)+(-A(200)-A(202)+A(214)+A(216)+A(268)+A(270)-A(276)-A(278))*f(9)+CI*(A(252)+A(253)+A(271)-A(272)-A(273) &
        -A(277))*f(10)+2*(A(92)+A(98))*f(11)+(-A(91)-A(93)-A(97)-A(99))*f(11)+CI*(A(188)-A(192)-A(195)-A(205)+A(208)+A(218)-A(250) &
        -A(256))*f(12)+(A(61)-A(63)-A(65)+A(66)-A(68)+A(69)+A(70)-A(72)-A(115)+A(116)+A(117)-A(118)-A(119)+A(123)+A(124)-A(126) &
        -A(128)-A(129)-A(193)-A(209)-A(247))*f(13)+18*(-A(95)-A(101))*f(14)+(19*(A(94)+A(96)+A(100) &
        +A(102))*f(14))/2._/**/REALKIND
  M2( 4) = ((A(79)+A(86))*f(3))/2._/**/REALKIND+(-A(225)+A(226)-A(228)+A(229)-A(231)+A(232)-A(234)+A(235)-A(376)-A(377)-A(378) &
        -A(379)-A(380)-A(381)-A(395)-A(396)-A(399)-A(454)-A(457)-A(458)+A(496)+A(497)+A(500)+A(503)+A(506)+A(507)+A(508)+A(509) &
        +A(511)+A(514)+A(518)+A(519))*f(3)+(CI*(-A(57)-A(59)+A(74)+A(76))*f(4))/2._/**/REALKIND+CI*(-A(388)-A(389)-A(390)-A(391) &
        -A(392)-A(393)+A(448)+A(449)+A(450)+A(451)+A(452)+A(453)+A(498)+A(501)+A(505)-A(510)-A(515)-A(517))*f(4)+(A(104)-A(105) &
        +A(110)-A(111)+A(132)+A(133)+A(141)+A(147)+A(190)+A(249)+A(286)+A(287)-A(305)-A(309)+A(318)-A(352)-A(356)+A(368)+A(369) &
        +A(375))*f(5)+CI*(A(137)-A(187)-A(217)+A(263)+A(280)+A(308)-A(316)-A(317)-A(336)-A(353)+A(372)+A(373))*f(6)+(A(107)-A(108) &
        +A(113)-A(114)+A(130)+A(131)+A(283)-A(307)-A(311)+A(338)-A(354)-A(358))*f(7)+CI*(A(139)-A(189)+A(281)-A(306)-A(337) &
        +A(359))*f(8)+(-A(214)-A(216)-A(220)-A(222)-A(262)-A(264)-A(268)-A(270))*f(9)+CI*(A(151)+A(152)+A(221)-A(252)-A(253) &
        -A(271))*f(10)+2*(A(91)+A(97))*f(11)+(-A(92)-A(93)-A(98)-A(99))*f(11)+CI*(A(138)+A(142)-A(149)-A(188)+A(192)-A(218)+A(250) &
        +A(267))*f(12)+(-A(62)+A(63)+A(64)-A(66)-A(67)+A(68)-A(70)+A(71)+A(118)+A(119)+A(120)+A(121)+A(122)-A(123)-A(124)-A(125) &
        -A(127)+A(128)-A(134)-A(150)-A(251))*f(13)+18*(-A(94)-A(100))*f(14)+(19*(A(95)+A(96)+A(101) &
        +A(102))*f(14))/2._/**/REALKIND
  M2( 5) = ((A(84)+A(89))*f(3))/2._/**/REALKIND+(A(224)-A(226)+A(227)-A(229)+A(230)-A(232)+A(233)-A(235)-A(424)-A(425)-A(426) &
        -A(427)-A(428)-A(429)-A(436)-A(439)-A(440)+A(472)+A(473)+A(476)+A(479)+A(482)+A(483)-A(491)-A(492)-A(495)-A(496)-A(497) &
        -A(500)-A(503)-A(506)-A(507))*f(3)+(CI*(A(55)-A(58)-A(76)+A(77))*f(4))/2._/**/REALKIND+CI*(A(430)+A(431)+A(432)+A(433) &
        +A(434)+A(435)-A(466)-A(467)-A(468)-A(469)-A(470)-A(471)-A(474)-A(477)-A(481)+A(499)+A(502)+A(504))*f(4)+(-A(103)+A(105) &
        -A(109)+A(111)+A(181)+A(211)+A(236)+A(237)+A(240)+A(258)+A(292)+A(293)-A(297)+A(305)+A(313)-A(344)+A(352)+A(362)+A(363) &
        +A(366))*f(5)+CI*(-A(178)+A(197)+A(203)-A(215)-A(288)+A(300)+A(301)-A(304)+A(342)+A(345)-A(364)-A(365))*f(6)+(-A(106) &
        +A(108)-A(112)+A(114)+A(176)+A(177)+A(290)-A(299)+A(307)-A(346)+A(351)+A(354))*f(7)+CI*(-A(180)+A(199)-A(289)+A(298) &
        +A(343)-A(355))*f(8)+(-A(200)-A(202)+A(214)+A(216)+A(268)+A(270)-A(276)-A(278))*f(9)+CI*(-A(243)-A(244)-A(269)+A(274) &
        +A(275)+A(279))*f(10)+2*(A(92)+A(98))*f(11)+(-A(91)-A(93)-A(97)-A(99))*f(11)+CI*(-A(179)+A(183)+A(198)+A(204)-A(212) &
        -A(219)+A(241)+A(260))*f(12)+(A(61)-A(63)-A(65)+A(66)-A(68)+A(69)+A(70)-A(72)-A(115)+A(116)+A(117)-A(118)-A(119)+A(123) &
        +A(124)-A(126)-A(128)-A(129)-A(184)-A(213)-A(238))*f(13)+18*(-A(95)-A(101))*f(14)+(19*(A(94)+A(96)+A(100) &
        +A(102))*f(14))/2._/**/REALKIND
  M2( 6) = ((A(80)+A(90))*f(3))/2._/**/REALKIND+(-A(224)+A(225)-A(227)+A(228)-A(230)+A(231)-A(233)+A(234)-A(382)-A(383)-A(384) &
        -A(385)-A(386)-A(387)-A(394)-A(397)-A(398)-A(472)-A(473)-A(476)-A(479)-A(482)-A(483)-A(490)-A(493)-A(494)-A(508)-A(509) &
        -A(511)-A(514)-A(518)-A(519))*f(3)+(CI*(-A(55)-A(60)-A(74)+A(78))*f(4))/2._/**/REALKIND+CI*(A(388)+A(389)+A(390)+A(391) &
        +A(392)+A(393)+A(466)+A(467)+A(468)+A(469)+A(470)+A(471)+A(474)+A(477)+A(481)+A(510)+A(515)+A(517))*f(4)+(A(103)-A(104) &
        +A(109)-A(110)+A(140)+A(144)+A(145)+A(148)+A(210)+A(259)+A(284)+A(285)+A(297)+A(309)+A(312)+A(344)+A(356)+A(370)+A(371) &
        +A(374))*f(5)+CI*(-A(137)-A(197)-A(203)-A(263)-A(280)-A(300)-A(301)-A(308)-A(342)-A(345)-A(372)-A(373))*f(6)+(A(106) &
        -A(107)+A(112)-A(113)+A(135)+A(136)+A(282)+A(299)+A(311)+A(346)+A(350)+A(358))*f(7)+CI*(-A(139)-A(199)-A(281)-A(298) &
        -A(343)-A(359))*f(8)+(A(200)+A(202)+A(220)+A(222)+A(262)+A(264)+A(276)+A(278))*f(9)+CI*(-A(151)-A(152)-A(221)-A(274) &
        -A(275)-A(279))*f(10)+(-A(91)-A(92)-A(97)-A(98))*f(11)+2*(A(93)+A(99))*f(11)+CI*(-A(138)-A(142)+A(149)-A(198)-A(204) &
        +A(212)-A(260)-A(267))*f(12)+(-A(61)+A(62)-A(64)+A(65)+A(67)-A(69)-A(71)+A(72)+A(115)-A(116)-A(117)-A(120)-A(121)-A(122) &
        +A(125)+A(126)+A(127)+A(129)-A(143)-A(146)-A(261))*f(13)+(19*(A(94)+A(95)+A(100)+A(101))*f(14))/2._/**/REALKIND+18*(-A(96) &
        -A(102))*f(14)
  M2( 7) = ((-A(87)-A(88)-A(89)-A(90))*f(3))/6._/**/REALKIND+(2*(-A(94)-A(95)-A(96)-A(100)-A(101)-A(102))*f(14))/3._/**/REALKIND
  M2( 8) = ((-A(83)-A(84)-A(85)-A(86))*f(3))/6._/**/REALKIND+(2*(-A(94)-A(95)-A(96)-A(100)-A(101)-A(102))*f(14))/3._/**/REALKIND
  M2( 9) = ((-A(79)-A(80)-A(81)-A(82))*f(3))/6._/**/REALKIND+(2*(-A(94)-A(95)-A(96)-A(100)-A(101)-A(102))*f(14))/3._/**/REALKIND
  M2(10) = (CI*(-A(55)-A(56)+A(57)+A(58)-A(73)-A(74))*f(4))/6._/**/REALKIND+((-A(94)-A(95)-A(96)-A(100)-A(101) &
        -A(102))*f(14))/3._/**/REALKIND
  M2(11) = (CI*(A(55)+A(56)-A(57)-A(58)+A(73)+A(74))*f(4))/6._/**/REALKIND+((-A(94)-A(95)-A(96)-A(100)-A(101) &
        -A(102))*f(14))/3._/**/REALKIND

end subroutine colourvectors

end module ol_loop_ppllttj_nenexttxggg_1_/**/REALKIND
