
module ol_colourmatrix_ppllttj_eexuuxttxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(120,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  36,  12,  12,   0]
  K1(  2,:) = [  12,  36,   0,  12]
  K1(  3,:) = [  12,   0,  36,  12]
  K1(  4,:) = [   0,  12,  12,  36]
  K1(  5,:) = [   0,   0,   0,   0]
  K1(  6,:) = [   0,   0,   0,   0]
  K1(  7,:) = [   0,   0,   0,   0]
  K1(  8,:) = [   0,   0,   0,   0]
  K1(  9,:) = [   0,   0,   0,   0]
  K1( 10,:) = [   0,   0,   0,   0]
  K1( 11,:) = [   0,   0,   0,   0]
  K1( 12,:) = [   0,   0,   0,   0]
  K1( 13,:) = [   0,   0,   0,   0]
  K1( 14,:) = [   0,   0,   0,   0]
  K1( 15,:) = [   0,   0,   0,   0]
  K1( 16,:) = [   0,   0,   0,   0]
  K1( 17,:) = [   0,   0,   0,   0]
  K1( 18,:) = [   0,   0,   0,   0]
  K1( 19,:) = [   0,   0,   0,   0]
  K1( 20,:) = [   0,   0,   0,   0]
  K1( 21,:) = [   0,   0,   0,   0]
  K1( 22,:) = [   0,   0,   0,   0]
  K1( 23,:) = [   0,   0,   0,   0]
  K1( 24,:) = [   0,   0,   0,   0]
  K1( 25,:) = [  48,  16,  16,   0]
  K1( 26,:) = [  16,  48,   0,  16]
  K1( 27,:) = [  16,   0,  48,  16]
  K1( 28,:) = [   0,  16,  16,  48]
  K1( 29,:) = [   0,   0,   0,   0]
  K1( 30,:) = [   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,   0,   0]
  K1( 32,:) = [   0,   0,   0,   0]
  K1( 33,:) = [   0,   0,   0,   0]
  K1( 34,:) = [   0,   0,   0,   0]
  K1( 35,:) = [   0,   0,   0,   0]
  K1( 36,:) = [   0,   0,   0,   0]
  K1( 37,:) = [   6,   2,   2,   0]
  K1( 38,:) = [   2,   0,  -6, -16]
  K1( 39,:) = [   2,  -6,   0, -16]
  K1( 40,:) = [   0, -16, -16, -48]
  K1( 41,:) = [  48,  16,  16,   0]
  K1( 42,:) = [  16,  48,   0,  16]
  K1( 43,:) = [  16,   0,  48,  16]
  K1( 44,:) = [   0,  16,  16,  48]
  K1( 45,:) = [   0,   0,   0,   0]
  K1( 46,:) = [   0,   0,   0,   0]
  K1( 47,:) = [   0,   0,   0,   0]
  K1( 48,:) = [   0,   0,   0,   0]
  K1( 49,:) = [   0,   0,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0]
  K1( 51,:) = [   0,   0,   0,   0]
  K1( 52,:) = [   0,   0,   0,   0]
  K1( 53,:) = [   0,  16,  -2,   6]
  K1( 54,:) = [  16,   0,   6,  -2]
  K1( 55,:) = [  -2,   6,   0,  16]
  K1( 56,:) = [   6,  -2,  16,   0]
  K1( 57,:) = [   0,   2, -16,  -6]
  K1( 58,:) = [   2,   6,   0,   2]
  K1( 59,:) = [ -16,   0, -48, -16]
  K1( 60,:) = [  -6,   2, -16,   0]
  K1( 61,:) = [  48,  16,  16,   0]
  K1( 62,:) = [  16,  48,   0,  16]
  K1( 63,:) = [  16,   0,  48,  16]
  K1( 64,:) = [   0,  16,  16,  48]
  K1( 65,:) = [   0,   0,   0,   0]
  K1( 66,:) = [   0,   0,   0,   0]
  K1( 67,:) = [   0,   0,   0,   0]
  K1( 68,:) = [   0,   0,   0,   0]
  K1( 69,:) = [   0,   0,   0,   0]
  K1( 70,:) = [   0,   0,   0,   0]
  K1( 71,:) = [   0,   0,   0,   0]
  K1( 72,:) = [   0,   0,   0,   0]
  K1( 73,:) = [   0, -16,   2,  -6]
  K1( 74,:) = [ -16, -48,   0, -16]
  K1( 75,:) = [   2,   0,   6,   2]
  K1( 76,:) = [  -6, -16,   2,   0]
  K1( 77,:) = [   0,  -2,  16,   6]
  K1( 78,:) = [  -2,   0,   6,  16]
  K1( 79,:) = [  16,   6,   0,  -2]
  K1( 80,:) = [   6,  16,  -2,   0]
  K1( 81,:) = [ -48, -16, -16,   0]
  K1( 82,:) = [ -16,   0,  -6,   2]
  K1( 83,:) = [ -16,  -6,   0,   2]
  K1( 84,:) = [   0,   2,   2,   6]
  K1( 85,:) = [  48,  16,  16,   0]
  K1( 86,:) = [  16,  48,   0,  16]
  K1( 87,:) = [  16,   0,  48,  16]
  K1( 88,:) = [   0,  16,  16,  48]
  K1( 89,:) = [   0,   0,   0,   0]
  K1( 90,:) = [   0,   0,   0,   0]
  K1( 91,:) = [   0,   0,   0,   0]
  K1( 92,:) = [   0,   0,   0,   0]
  K1( 93,:) = [   0,   0,   0,   0]
  K1( 94,:) = [   0,   0,   0,   0]
  K1( 95,:) = [   0,   0,   0,   0]
  K1( 96,:) = [   0,   0,   0,   0]
  K1( 97,:) = [ -54, -18, -18,   0]
  K1( 98,:) = [ -18,   0,   0,  18]
  K1( 99,:) = [ -18,   0, -54, -18]
  K1(100,:) = [   0,  18, -18,   0]
  K1(101,:) = [ -54, -18, -18,   0]
  K1(102,:) = [ -18, -54,   0, -18]
  K1(103,:) = [ -18,   0,   0,  18]
  K1(104,:) = [   0, -18,  18,   0]
  K1(105,:) = [   0, -18,  18,   0]
  K1(106,:) = [ -18, -54,   0, -18]
  K1(107,:) = [  18,   0,   0, -18]
  K1(108,:) = [   0, -18, -18, -54]
  K1(109,:) = [   0,  18, -18,   0]
  K1(110,:) = [  18,   0,   0, -18]
  K1(111,:) = [ -18,   0, -54, -18]
  K1(112,:) = [   0, -18, -18, -54]
  K1(113,:) = [ 108,  36,  36,   0]
  K1(114,:) = [  36, 108,   0,  36]
  K1(115,:) = [  36,   0, 108,  36]
  K1(116,:) = [   0,  36,  36, 108]
  K1(117,:) = [   0,   0,   0,   0]
  K1(118,:) = [   0,   0,   0,   0]
  K1(119,:) = [   0,   0,   0,   0]
  K1(120,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllttj_eexuuxttxg_1_/**/REALKIND



module ol_forced_parameters_ppllttj_eexuuxttxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllttj_eexuuxttxg_1_/**/REALKIND

module ol_loop_ppllttj_eexuuxttxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(46), c(55)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:417)
  ! denominators
  complex(REALKIND), save :: den(665)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(4,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 2) = CI*eQED**2*gQCD**3
    f( 3) = (2*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 4) = eQED**2*gQCD**3
    f( 5) = (2*CI*countertermnorm*eQED**2*gQCD**5)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**2*gQCD**5
    f( 7) = (2*countertermnorm*eQED**2*gQCD**5)/3._/**/REALKIND
    f( 8) = countertermnorm*eQED**2*gQCD**5
    f( 9) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(10) = CI*countertermnorm*ctGqq*eQED**2*gQCD**5
    f(11) = (2*countertermnorm*ctGqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(12) = countertermnorm*ctGqq*eQED**2*gQCD**5
    f(13) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctGtt*eQED**2*gQCD**5
    f(15) = (2*countertermnorm*ctGtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(16) = countertermnorm*ctGtt*eQED**2*gQCD**5
    f(17) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(18) = CI*countertermnorm*ctVqq*eQED**2*gQCD**5
    f(19) = (2*countertermnorm*ctVqq*eQED**2*gQCD**5)/3._/**/REALKIND
    f(20) = countertermnorm*ctVqq*eQED**2*gQCD**5
    f(21) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(22) = CI*countertermnorm*ctVtt*eQED**2*gQCD**5
    f(23) = (2*countertermnorm*ctVtt*eQED**2*gQCD**5)/3._/**/REALKIND
    f(24) = countertermnorm*ctVtt*eQED**2*gQCD**5
    f(25) = (2*countertermnorm*ctVVV*eQED**2*gQCD**5)/3._/**/REALKIND
    f(26) = countertermnorm*ctVVV*eQED**2*gQCD**5
    f(27) = CI*countertermnorm*ctZGG*eQED**2*gQCD**5
    f(28) = countertermnorm*ctZGG*eQED**2*gQCD**5
    f(29) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(30) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(31) = (2*CI*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(32) = CI*eQED**2*gQCD**5*integralnorm*SwB
    f(33) = (eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(34) = (eQED**2*gQCD**5*integralnorm*SwB)/2._/**/REALKIND
    f(35) = (2*eQED**2*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(36) = eQED**2*gQCD**5*integralnorm*SwB
    f(37) = (CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(38) = (2*CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(39) = CI*eQED**2*gQCD**5*integralnorm*SwF
    f(40) = (4*CI*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(41) = 2*CI*eQED**2*gQCD**5*integralnorm*SwF
    f(42) = (eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(43) = (2*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(44) = eQED**2*gQCD**5*integralnorm*SwF
    f(45) = (4*eQED**2*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(46) = 2*eQED**2*gQCD**5*integralnorm*SwF

  c = [ 27*CI*f(29), 54*CI*f(29), 27*CI*f(30), 54*CI*f(30), 3*CI*f(31), 9*CI*f(31), 24*CI*f(31), 27*CI*f(31), 54*CI*f(31) &
    , 3*CI*f(32), 9*CI*f(32), 24*CI*f(32), 27*CI*f(32), 54*CI*f(32), 18*f(33), 54*f(33), 18*f(34), 54*f(34), f(35), 3*f(35) &
    , 6*f(35), 8*f(35), 9*f(35), 10*f(35), 18*f(35), 21*f(35), 24*f(35), 27*f(35), 54*f(35), f(36), 3*f(36), 6*f(36), 8*f(36) &
    , 9*f(36), 10*f(36), 18*f(36), 21*f(36), 24*f(36), 27*f(36), 54*f(36), 9*CI*f(37), 9*CI*f(38), 9*CI*f(39), 9*CI*f(40) &
    , 9*CI*f(41), 3*f(42), 9*f(42), 3*f(43), 9*f(43), 3*f(44), 9*f(44), 3*f(45), 9*f(45), 3*f(46), 9*f(46) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(4), M2(4)
  complex(REALKIND) :: A(399)
  ! external WFs
  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rMT, H(5), wf(:,-4))
  call wf_A(P(:,6), rMT, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_Q_A(wf(:,3),Q(:,80),MT,1_intkind1,wf(:,4))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,5))
  call vert_VQ_A(wf(:,2),wf(:,4),wf(:,6))
  call prop_A_Q(wf(:,5),Q(:,35),MT,1_intkind1,wf(:,7))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,8))
  call prop_W_W(wf(:,8),Q(:,3),MZ,1_intkind1,wf(:,9))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,9),wf(:,10))
  call prop_A_Q(wf(:,10),Q(:,35),MT,1_intkind1,wf(:,11))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,12))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,13))
  call prop_A_Q(wf(:,12),Q(:,44),MT,1_intkind1,wf(:,14))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,4),wf(:,15))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,16))
  call prop_A_Q(wf(:,16),Q(:,96),MT,1_intkind1,wf(:,17))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,18))
  call vert_AV_Q(wf(:,17),wf(:,2),wf(:,19))
  call prop_Q_A(wf(:,18),Q(:,19),MT,1_intkind1,wf(:,20))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,-4),wf(:,21))
  call prop_Q_A(wf(:,21),Q(:,19),MT,1_intkind1,wf(:,22))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,23))
  call vert_AV_Q(wf(:,17),wf(:,1),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,28),MT,1_intkind1,wf(:,25))
  call vert_AZ_Q(gZu,wf(:,17),wf(:,9),wf(:,26))
  call vert_VQ_A(wf(:,-6),wf(:,20),wf(:,27))
  call vert_VQ_A(wf(:,-6),wf(:,22),wf(:,28))
  call vert_UV_W(wf(:,2),Q(:,12),wf(:,-6),Q(:,64),wf(:,29))
  call vert_QA_V(wf(:,20),wf(:,-5),wf(:,30))
  call vert_QA_V(wf(:,22),wf(:,-5),wf(:,31))
  call vert_VQ_A(wf(:,-6),wf(:,25),wf(:,32))
  call vert_QA_V(wf(:,-4),wf(:,7),wf(:,33))
  call vert_QA_V(wf(:,-4),wf(:,11),wf(:,34))
  call vert_VQ_A(wf(:,-6),wf(:,-2),wf(:,35))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,36))
  call prop_Q_A(wf(:,35),Q(:,68),ZERO,0_intkind1,wf(:,37))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,38))
  call vert_VQ_A(wf(:,36),wf(:,37),wf(:,39))
  call prop_A_Q(wf(:,38),Q(:,11),ZERO,0_intkind1,wf(:,40))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,9),wf(:,41))
  call prop_A_Q(wf(:,41),Q(:,11),ZERO,0_intkind1,wf(:,42))
  call vert_AV_Q(wf(:,-3),wf(:,36),wf(:,43))
  call vert_VQ_A(wf(:,1),wf(:,37),wf(:,44))
  call prop_A_Q(wf(:,43),Q(:,56),ZERO,0_intkind1,wf(:,45))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,37),wf(:,46))
  call vert_AV_Q(wf(:,-3),wf(:,-6),wf(:,47))
  call prop_A_Q(wf(:,47),Q(:,72),ZERO,0_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,1),wf(:,-2),wf(:,49))
  call vert_AV_Q(wf(:,48),wf(:,36),wf(:,50))
  call prop_Q_A(wf(:,49),Q(:,7),ZERO,0_intkind1,wf(:,51))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,-2),wf(:,52))
  call prop_Q_A(wf(:,52),Q(:,7),ZERO,0_intkind1,wf(:,53))
  call vert_VQ_A(wf(:,36),wf(:,-2),wf(:,54))
  call vert_AV_Q(wf(:,48),wf(:,1),wf(:,55))
  call prop_Q_A(wf(:,54),Q(:,52),ZERO,0_intkind1,wf(:,56))
  call vert_AZ_Q(gZu,wf(:,48),wf(:,9),wf(:,57))
  call vert_UV_W(wf(:,36),Q(:,48),wf(:,-6),Q(:,64),wf(:,58))
  call vert_QA_V(wf(:,51),wf(:,-3),wf(:,59))
  call vert_QA_V(wf(:,53),wf(:,-3),wf(:,60))
  call vert_VQ_A(wf(:,-6),wf(:,51),wf(:,61))
  call vert_VQ_A(wf(:,-6),wf(:,53),wf(:,62))
  call vert_QA_V(wf(:,-2),wf(:,40),wf(:,63))
  call vert_QA_V(wf(:,-2),wf(:,42),wf(:,64))
  call vert_VQ_A(wf(:,-6),wf(:,56),wf(:,65))
  call vert_QA_V(wf(:,37),wf(:,-3),wf(:,66))
  call vert_AV_Q(wf(:,-5),wf(:,66),wf(:,67))
  call vert_VQ_A(wf(:,66),wf(:,-4),wf(:,68))
  call vert_QA_V(wf(:,-2),wf(:,48),wf(:,69))
  call vert_AV_Q(wf(:,-5),wf(:,69),wf(:,70))
  call vert_VQ_A(wf(:,69),wf(:,-4),wf(:,71))
  call vert_QA_V(wf(:,4),wf(:,-5),wf(:,72))
  call vert_QA_V(wf(:,-4),wf(:,17),wf(:,73))
  call counter_VGG_G(ctAGGG,wf(:,1),wf(:,2),wf(:,-6),wf(:,74))
  call counter_VGG_G(ctAGGG,wf(:,1),wf(:,-6),wf(:,2),wf(:,75))
  call counter_VGG_G(ctZGGG,wf(:,9),wf(:,2),wf(:,-6),wf(:,76))
  call counter_VGG_G(ctZGGG,wf(:,9),wf(:,-6),wf(:,2),wf(:,77))
  call counter_VG_G(wf(:,9),wf(:,36),Q(:,48),wf(:,78),Q(:,51))
  call counter_VG_G(wf(:,9),wf(:,2),Q(:,12),wf(:,79),Q(:,15))
  call vert_UV_W(wf(:,2),Q(:,12),wf(:,36),Q(:,48),wf(:,80))
  call counter_VG_G(wf(:,9),wf(:,-6),Q(:,64),wf(:,81),Q(:,67))
  call counter_VQ_A(wf(:,2),wf(:,4),wf(:,82))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,83))
  call counter_ZQ_A(gZu,wf(:,9),wf(:,4),wf(:,84))
  call counter_AV_Q(wf(:,17),wf(:,2),wf(:,85))
  call counter_AV_Q(wf(:,17),wf(:,1),wf(:,86))
  call counter_AZ_Q(gZu,wf(:,17),wf(:,9),wf(:,87))
  call counter_VQ_A(wf(:,-6),wf(:,20),wf(:,88))
  call counter_VQ_A(wf(:,-6),wf(:,22),wf(:,89))
  call counter_UV_W(wf(:,2),Q(:,12),wf(:,-6),Q(:,64),wf(:,90))
  call counter_VQ_A(wf(:,-6),wf(:,25),wf(:,91))
  call vert_QA_V(wf(:,25),wf(:,-5),wf(:,92))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,93))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,94))
  call prop_Q_A(wf(:,13),Q(:,83),MT,1_intkind1,wf(:,95))
  call prop_Q_A(wf(:,15),Q(:,83),MT,1_intkind1,wf(:,96))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,97))
  call prop_Q_A(wf(:,6),Q(:,92),MT,1_intkind1,wf(:,98))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,9),wf(:,99))
  call counter_QA_V(wf(:,20),wf(:,-5),wf(:,100))
  call counter_QA_V(wf(:,22),wf(:,-5),wf(:,101))
  call prop_A_Q(wf(:,94),Q(:,44),MT,1_intkind1,wf(:,102))
  call prop_A_Q(wf(:,97),Q(:,35),MT,1_intkind1,wf(:,103))
  call prop_A_Q(wf(:,99),Q(:,35),MT,1_intkind1,wf(:,104))
  call vert_QA_V(wf(:,-4),wf(:,103),wf(:,105))
  call vert_QA_V(wf(:,-4),wf(:,104),wf(:,106))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,107))
  call prop_A_Q(wf(:,107),Q(:,96),MT,1_intkind1,wf(:,108))
  call vert_AV_Q(wf(:,108),wf(:,2),wf(:,109))
  call vert_AV_Q(wf(:,108),wf(:,1),wf(:,110))
  call vert_AZ_Q(gZu,wf(:,108),wf(:,9),wf(:,111))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,112))
  call prop_A_Q(wf(:,24),Q(:,99),MT,1_intkind1,wf(:,113))
  call prop_A_Q(wf(:,26),Q(:,99),MT,1_intkind1,wf(:,114))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,115))
  call prop_A_Q(wf(:,19),Q(:,108),MT,1_intkind1,wf(:,116))
  call counter_ZQ_A(gZu,wf(:,9),wf(:,-4),wf(:,117))
  call counter_QA_V(wf(:,-4),wf(:,7),wf(:,118))
  call counter_QA_V(wf(:,-4),wf(:,11),wf(:,119))
  call prop_Q_A(wf(:,112),Q(:,28),MT,1_intkind1,wf(:,120))
  call vert_VQ_A(wf(:,-6),wf(:,120),wf(:,121))
  call prop_Q_A(wf(:,115),Q(:,19),MT,1_intkind1,wf(:,122))
  call vert_VQ_A(wf(:,-6),wf(:,122),wf(:,123))
  call prop_Q_A(wf(:,117),Q(:,19),MT,1_intkind1,wf(:,124))
  call vert_VQ_A(wf(:,-6),wf(:,124),wf(:,125))
  call vert_QA_V(wf(:,122),wf(:,-5),wf(:,126))
  call vert_QA_V(wf(:,124),wf(:,-5),wf(:,127))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,128))
  call prop_Q_A(wf(:,128),Q(:,80),MT,1_intkind1,wf(:,129))
  call vert_VQ_A(wf(:,2),wf(:,129),wf(:,130))
  call vert_VQ_A(wf(:,1),wf(:,129),wf(:,131))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,129),wf(:,132))
  call counter_VQ_A(wf(:,36),wf(:,37),wf(:,133))
  call counter_VQ_A(wf(:,1),wf(:,37),wf(:,134))
  call counter_ZQ_A(gZu,wf(:,9),wf(:,37),wf(:,135))
  call counter_AV_Q(wf(:,48),wf(:,36),wf(:,136))
  call counter_AV_Q(wf(:,48),wf(:,1),wf(:,137))
  call counter_AZ_Q(gZu,wf(:,48),wf(:,9),wf(:,138))
  call counter_UV_W(wf(:,36),Q(:,48),wf(:,-6),Q(:,64),wf(:,139))
  call counter_VQ_A(wf(:,-6),wf(:,51),wf(:,140))
  call counter_VQ_A(wf(:,-6),wf(:,53),wf(:,141))
  call counter_VQ_A(wf(:,-6),wf(:,56),wf(:,142))
  call vert_QA_V(wf(:,56),wf(:,-3),wf(:,143))
  call vert_QA_V(wf(:,-2),wf(:,45),wf(:,144))
  call counter_AV_Q(wf(:,-5),wf(:,66),wf(:,145))
  call counter_AV_Q(wf(:,-5),wf(:,69),wf(:,146))
  call counter_QA_V(wf(:,4),wf(:,-5),wf(:,147))
  call vert_QA_V(wf(:,-4),wf(:,108),wf(:,148))
  call counter_VQ_A(wf(:,66),wf(:,-4),wf(:,149))
  call counter_VQ_A(wf(:,69),wf(:,-4),wf(:,150))
  call counter_QA_V(wf(:,-4),wf(:,17),wf(:,151))
  call vert_QA_V(wf(:,129),wf(:,-5),wf(:,152))
  call counter_QA_V(wf(:,-4),wf(:,-5),wf(:,153))
  call vert_VQ_A(wf(:,153),wf(:,37),wf(:,154))
  call vert_AV_Q(wf(:,-3),wf(:,153),wf(:,155))
  call prop_A_Q(wf(:,155),Q(:,56),ZERO,0_intkind1,wf(:,156))
  call vert_AV_Q(wf(:,48),wf(:,153),wf(:,157))
  call vert_VQ_A(wf(:,153),wf(:,-2),wf(:,158))
  call prop_Q_A(wf(:,158),Q(:,52),ZERO,0_intkind1,wf(:,159))
  call vert_UV_W(wf(:,153),Q(:,48),wf(:,-6),Q(:,64),wf(:,160))
  call vert_VQ_A(wf(:,-6),wf(:,159),wf(:,161))
  call counter_AV_Q(wf(:,-3),wf(:,36),wf(:,162))
  call prop_Q_A(wf(:,44),Q(:,71),ZERO,0_intkind1,wf(:,163))
  call prop_Q_A(wf(:,46),Q(:,71),ZERO,0_intkind1,wf(:,164))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,165))
  call prop_Q_A(wf(:,39),Q(:,116),ZERO,0_intkind1,wf(:,166))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,9),wf(:,167))
  call prop_A_Q(wf(:,162),Q(:,56),ZERO,0_intkind1,wf(:,168))
  call counter_QA_V(wf(:,51),wf(:,-3),wf(:,169))
  call counter_QA_V(wf(:,53),wf(:,-3),wf(:,170))
  call prop_A_Q(wf(:,165),Q(:,11),ZERO,0_intkind1,wf(:,171))
  call prop_A_Q(wf(:,167),Q(:,11),ZERO,0_intkind1,wf(:,172))
  call vert_QA_V(wf(:,-2),wf(:,171),wf(:,173))
  call vert_QA_V(wf(:,-2),wf(:,172),wf(:,174))
  call counter_AV_Q(wf(:,-3),wf(:,-6),wf(:,175))
  call prop_A_Q(wf(:,175),Q(:,72),ZERO,0_intkind1,wf(:,176))
  call vert_AV_Q(wf(:,176),wf(:,36),wf(:,177))
  call vert_AV_Q(wf(:,176),wf(:,1),wf(:,178))
  call vert_AZ_Q(gZu,wf(:,176),wf(:,9),wf(:,179))
  call counter_QA_V(wf(:,37),wf(:,-3),wf(:,180))
  call vert_AV_Q(wf(:,-5),wf(:,180),wf(:,181))
  call vert_VQ_A(wf(:,180),wf(:,-4),wf(:,182))
  call vert_QA_V(wf(:,-2),wf(:,176),wf(:,183))
  call vert_AV_Q(wf(:,-5),wf(:,183),wf(:,184))
  call vert_VQ_A(wf(:,183),wf(:,-4),wf(:,185))
  call counter_VQ_A(wf(:,36),wf(:,-2),wf(:,186))
  call prop_A_Q(wf(:,55),Q(:,75),ZERO,0_intkind1,wf(:,187))
  call prop_A_Q(wf(:,57),Q(:,75),ZERO,0_intkind1,wf(:,188))
  call counter_VQ_A(wf(:,1),wf(:,-2),wf(:,189))
  call prop_A_Q(wf(:,50),Q(:,120),ZERO,0_intkind1,wf(:,190))
  call counter_ZQ_A(gZu,wf(:,9),wf(:,-2),wf(:,191))
  call counter_QA_V(wf(:,-2),wf(:,40),wf(:,192))
  call counter_QA_V(wf(:,-2),wf(:,42),wf(:,193))
  call prop_Q_A(wf(:,186),Q(:,52),ZERO,0_intkind1,wf(:,194))
  call vert_VQ_A(wf(:,-6),wf(:,194),wf(:,195))
  call prop_Q_A(wf(:,189),Q(:,7),ZERO,0_intkind1,wf(:,196))
  call vert_QA_V(wf(:,196),wf(:,-3),wf(:,197))
  call prop_Q_A(wf(:,191),Q(:,7),ZERO,0_intkind1,wf(:,198))
  call vert_QA_V(wf(:,198),wf(:,-3),wf(:,199))
  call vert_VQ_A(wf(:,-6),wf(:,196),wf(:,200))
  call vert_VQ_A(wf(:,-6),wf(:,198),wf(:,201))
  call counter_VQ_A(wf(:,-6),wf(:,-2),wf(:,202))
  call prop_Q_A(wf(:,202),Q(:,68),ZERO,0_intkind1,wf(:,203))
  call vert_VQ_A(wf(:,36),wf(:,203),wf(:,204))
  call vert_VQ_A(wf(:,1),wf(:,203),wf(:,205))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,203),wf(:,206))
  call counter_QA_V(wf(:,-2),wf(:,48),wf(:,207))
  call vert_AV_Q(wf(:,-5),wf(:,207),wf(:,208))
  call vert_VQ_A(wf(:,207),wf(:,-4),wf(:,209))
  call vert_QA_V(wf(:,203),wf(:,-3),wf(:,210))
  call vert_AV_Q(wf(:,-5),wf(:,210),wf(:,211))
  call vert_VQ_A(wf(:,210),wf(:,-4),wf(:,212))
  call counter_QA_V(wf(:,-2),wf(:,-3),wf(:,213))
  call vert_VQ_A(wf(:,213),wf(:,4),wf(:,214))
  call vert_AV_Q(wf(:,-5),wf(:,213),wf(:,215))
  call prop_A_Q(wf(:,215),Q(:,44),MT,1_intkind1,wf(:,216))
  call vert_AV_Q(wf(:,17),wf(:,213),wf(:,217))
  call vert_VQ_A(wf(:,213),wf(:,-4),wf(:,218))
  call prop_Q_A(wf(:,218),Q(:,28),MT,1_intkind1,wf(:,219))
  call vert_UV_W(wf(:,213),Q(:,12),wf(:,-6),Q(:,64),wf(:,220))
  call vert_VQ_A(wf(:,-6),wf(:,219),wf(:,221))
  call counter_V_V(ctGG,wf(:,2),Q(:,12),wf(:,222))
  call vert_AV_Q(wf(:,-5),wf(:,222),wf(:,223))
  call vert_VQ_A(wf(:,222),wf(:,4),wf(:,224))
  call counter_Q_A(cttt,wf(:,4),Q(:,80),wf(:,225))
  call prop_Q_A(wf(:,225),Q(:,80),MT,1_intkind1,wf(:,226))
  call vert_VQ_A(wf(:,2),wf(:,226),wf(:,227))
  call vert_VQ_A(wf(:,1),wf(:,226),wf(:,228))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,226),wf(:,229))
  call counter_A_Q(cttt,wf(:,7),Q(:,35),wf(:,230))
  call counter_A_Q(cttt,wf(:,11),Q(:,35),wf(:,231))
  call counter_A_Q(cttt,wf(:,14),Q(:,44),wf(:,232))
  call vert_VQ_A(wf(:,222),wf(:,-4),wf(:,233))
  call vert_VQ_A(wf(:,222),wf(:,20),wf(:,234))
  call vert_VQ_A(wf(:,222),wf(:,22),wf(:,235))
  call counter_Q_A(cttt,wf(:,20),Q(:,19),wf(:,236))
  call counter_Q_A(cttt,wf(:,22),Q(:,19),wf(:,237))
  call counter_Q_A(cttt,wf(:,25),Q(:,28),wf(:,238))
  call counter_A_Q(cttt,wf(:,17),Q(:,96),wf(:,239))
  call prop_A_Q(wf(:,239),Q(:,96),MT,1_intkind1,wf(:,240))
  call vert_AV_Q(wf(:,240),wf(:,2),wf(:,241))
  call vert_AV_Q(wf(:,240),wf(:,1),wf(:,242))
  call vert_AZ_Q(gZu,wf(:,240),wf(:,9),wf(:,243))
  call vert_AV_Q(wf(:,7),wf(:,-6),wf(:,244))
  call prop_Q_A(wf(:,233),Q(:,28),MT,1_intkind1,wf(:,245))
  call vert_AV_Q(wf(:,11),wf(:,-6),wf(:,246))
  call prop_A_Q(wf(:,223),Q(:,44),MT,1_intkind1,wf(:,247))
  call vert_UV_W(wf(:,222),Q(:,12),wf(:,-6),Q(:,64),wf(:,248))
  call vert_AV_Q(wf(:,-5),wf(:,29),wf(:,249))
  call prop_A_Q(wf(:,249),Q(:,108),MT,1_intkind1,wf(:,250))
  call vert_VQ_A(wf(:,29),wf(:,-4),wf(:,251))
  call prop_Q_A(wf(:,251),Q(:,92),MT,1_intkind1,wf(:,252))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,253))
  call prop_A_Q(wf(:,253),Q(:,108),MT,1_intkind1,wf(:,254))
  call prop_A_Q(wf(:,244),Q(:,99),MT,1_intkind1,wf(:,255))
  call prop_A_Q(wf(:,246),Q(:,99),MT,1_intkind1,wf(:,256))
  call counter_V_V(ctGG,wf(:,29),Q(:,76),wf(:,257))
  call prop_Q_A(wf(:,27),Q(:,83),MT,1_intkind1,wf(:,258))
  call prop_Q_A(wf(:,28),Q(:,83),MT,1_intkind1,wf(:,259))
  call prop_Q_A(wf(:,32),Q(:,92),MT,1_intkind1,wf(:,260))
  call counter_Q_A(ctqq,wf(:,37),Q(:,68),wf(:,261))
  call prop_Q_A(wf(:,261),Q(:,68),ZERO,0_intkind1,wf(:,262))
  call vert_QA_V(wf(:,262),wf(:,40),wf(:,263))
  call vert_QA_V(wf(:,262),wf(:,42),wf(:,264))
  call vert_VQ_A(wf(:,1),wf(:,262),wf(:,265))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,262),wf(:,266))
  call counter_V_V(ctGG,wf(:,36),Q(:,48),wf(:,267))
  call vert_AV_Q(wf(:,-3),wf(:,267),wf(:,268))
  call counter_A_Q(ctqq,wf(:,40),Q(:,11),wf(:,269))
  call counter_A_Q(ctqq,wf(:,42),Q(:,11),wf(:,270))
  call counter_A_Q(ctqq,wf(:,45),Q(:,56),wf(:,271))
  call vert_VQ_A(wf(:,267),wf(:,37),wf(:,272))
  call vert_VQ_A(wf(:,267),wf(:,-2),wf(:,273))
  call counter_Q_A(ctqq,wf(:,51),Q(:,7),wf(:,274))
  call counter_Q_A(ctqq,wf(:,53),Q(:,7),wf(:,275))
  call counter_Q_A(ctqq,wf(:,56),Q(:,52),wf(:,276))
  call counter_A_Q(ctqq,wf(:,48),Q(:,72),wf(:,277))
  call prop_A_Q(wf(:,277),Q(:,72),ZERO,0_intkind1,wf(:,278))
  call vert_QA_V(wf(:,51),wf(:,278),wf(:,279))
  call vert_QA_V(wf(:,53),wf(:,278),wf(:,280))
  call vert_AV_Q(wf(:,278),wf(:,1),wf(:,281))
  call vert_AZ_Q(gZu,wf(:,278),wf(:,9),wf(:,282))
  call vert_VQ_A(wf(:,267),wf(:,51),wf(:,283))
  call vert_VQ_A(wf(:,267),wf(:,53),wf(:,284))
  call vert_AV_Q(wf(:,-3),wf(:,58),wf(:,285))
  call prop_A_Q(wf(:,285),Q(:,120),ZERO,0_intkind1,wf(:,286))
  call vert_VQ_A(wf(:,58),wf(:,-2),wf(:,287))
  call prop_Q_A(wf(:,287),Q(:,116),ZERO,0_intkind1,wf(:,288))
  call vert_AV_Q(wf(:,40),wf(:,-6),wf(:,289))
  call prop_Q_A(wf(:,273),Q(:,52),ZERO,0_intkind1,wf(:,290))
  call vert_AV_Q(wf(:,42),wf(:,-6),wf(:,291))
  call vert_AV_Q(wf(:,45),wf(:,-6),wf(:,292))
  call prop_A_Q(wf(:,292),Q(:,120),ZERO,0_intkind1,wf(:,293))
  call counter_V_V(ctGG,wf(:,58),Q(:,112),wf(:,294))
  call prop_A_Q(wf(:,289),Q(:,75),ZERO,0_intkind1,wf(:,295))
  call prop_A_Q(wf(:,291),Q(:,75),ZERO,0_intkind1,wf(:,296))
  call prop_A_Q(wf(:,268),Q(:,56),ZERO,0_intkind1,wf(:,297))
  call prop_Q_A(wf(:,61),Q(:,71),ZERO,0_intkind1,wf(:,298))
  call prop_Q_A(wf(:,62),Q(:,71),ZERO,0_intkind1,wf(:,299))
  call prop_Q_A(wf(:,65),Q(:,116),ZERO,0_intkind1,wf(:,300))
  call vert_UV_W(wf(:,267),Q(:,48),wf(:,-6),Q(:,64),wf(:,301))
  call vert_QA_V(wf(:,262),wf(:,-3),wf(:,302))
  call counter_V_V(ctGG,wf(:,66),Q(:,76),wf(:,303))
  call prop_A_Q(wf(:,67),Q(:,108),MT,1_intkind1,wf(:,304))
  call prop_Q_A(wf(:,68),Q(:,92),MT,1_intkind1,wf(:,305))
  call vert_QA_V(wf(:,-2),wf(:,278),wf(:,306))
  call counter_V_V(ctGG,wf(:,69),Q(:,76),wf(:,307))
  call prop_A_Q(wf(:,70),Q(:,108),MT,1_intkind1,wf(:,308))
  call prop_Q_A(wf(:,71),Q(:,92),MT,1_intkind1,wf(:,309))
  call vert_AV_Q(wf(:,-3),wf(:,72),wf(:,310))
  call prop_A_Q(wf(:,310),Q(:,120),ZERO,0_intkind1,wf(:,311))
  call vert_VQ_A(wf(:,72),wf(:,-2),wf(:,312))
  call prop_Q_A(wf(:,312),Q(:,116),ZERO,0_intkind1,wf(:,313))
  call counter_V_V(ctGG,wf(:,72),Q(:,112),wf(:,314))
  call vert_QA_V(wf(:,226),wf(:,-5),wf(:,315))
  call vert_AV_Q(wf(:,-3),wf(:,73),wf(:,316))
  call prop_A_Q(wf(:,316),Q(:,120),ZERO,0_intkind1,wf(:,317))
  call vert_VQ_A(wf(:,73),wf(:,-2),wf(:,318))
  call prop_Q_A(wf(:,318),Q(:,116),ZERO,0_intkind1,wf(:,319))
  call counter_V_V(ctGG,wf(:,73),Q(:,112),wf(:,320))
  call vert_QA_V(wf(:,-4),wf(:,240),wf(:,321))
  call vert_VQ_A(wf(:,2),wf(:,20),wf(:,322))
  call prop_Q_A(wf(:,322),Q(:,31),MT,1_intkind1,wf(:,323))
  call vert_VQ_A(wf(:,2),wf(:,22),wf(:,324))
  call prop_Q_A(wf(:,324),Q(:,31),MT,1_intkind1,wf(:,325))
  call vert_AV_Q(wf(:,7),wf(:,2),wf(:,326))
  call prop_A_Q(wf(:,326),Q(:,47),MT,1_intkind1,wf(:,327))
  call vert_AV_Q(wf(:,11),wf(:,2),wf(:,328))
  call prop_A_Q(wf(:,328),Q(:,47),MT,1_intkind1,wf(:,329))
  call vert_VQ_A(wf(:,1),wf(:,25),wf(:,330))
  call prop_Q_A(wf(:,330),Q(:,31),MT,1_intkind1,wf(:,331))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,25),wf(:,332))
  call prop_Q_A(wf(:,332),Q(:,31),MT,1_intkind1,wf(:,333))
  call vert_AV_Q(wf(:,14),wf(:,1),wf(:,334))
  call prop_A_Q(wf(:,334),Q(:,47),MT,1_intkind1,wf(:,335))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,9),wf(:,336))
  call prop_A_Q(wf(:,336),Q(:,47),MT,1_intkind1,wf(:,337))
  call vert_VQ_A(wf(:,36),wf(:,51),wf(:,338))
  call prop_Q_A(wf(:,338),Q(:,55),ZERO,0_intkind1,wf(:,339))
  call vert_VQ_A(wf(:,36),wf(:,53),wf(:,340))
  call prop_Q_A(wf(:,340),Q(:,55),ZERO,0_intkind1,wf(:,341))
  call vert_AV_Q(wf(:,40),wf(:,36),wf(:,342))
  call prop_A_Q(wf(:,342),Q(:,59),ZERO,0_intkind1,wf(:,343))
  call vert_AV_Q(wf(:,42),wf(:,36),wf(:,344))
  call prop_A_Q(wf(:,344),Q(:,59),ZERO,0_intkind1,wf(:,345))
  call vert_VQ_A(wf(:,1),wf(:,56),wf(:,346))
  call prop_Q_A(wf(:,346),Q(:,55),ZERO,0_intkind1,wf(:,347))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,56),wf(:,348))
  call prop_Q_A(wf(:,348),Q(:,55),ZERO,0_intkind1,wf(:,349))
  call vert_AV_Q(wf(:,45),wf(:,1),wf(:,350))
  call prop_A_Q(wf(:,350),Q(:,59),ZERO,0_intkind1,wf(:,351))
  call vert_AZ_Q(gZu,wf(:,45),wf(:,9),wf(:,352))
  call prop_A_Q(wf(:,352),Q(:,59),ZERO,0_intkind1,wf(:,353))
  call vert_QA_V(wf(:,37),wf(:,40),wf(:,354))
  call vert_QA_V(wf(:,37),wf(:,42),wf(:,355))
  call vert_QA_V(wf(:,163),wf(:,-3),wf(:,356))
  call vert_QA_V(wf(:,164),wf(:,-3),wf(:,357))
  call vert_QA_V(wf(:,51),wf(:,48),wf(:,358))
  call vert_QA_V(wf(:,53),wf(:,48),wf(:,359))
  call vert_QA_V(wf(:,-2),wf(:,187),wf(:,360))
  call vert_QA_V(wf(:,-2),wf(:,188),wf(:,361))
  call vert_QA_V(wf(:,4),wf(:,7),wf(:,362))
  call vert_QA_V(wf(:,4),wf(:,11),wf(:,363))
  call vert_QA_V(wf(:,95),wf(:,-5),wf(:,364))
  call vert_QA_V(wf(:,96),wf(:,-5),wf(:,365))
  call vert_QA_V(wf(:,20),wf(:,17),wf(:,366))
  call vert_QA_V(wf(:,22),wf(:,17),wf(:,367))
  call vert_QA_V(wf(:,-4),wf(:,113),wf(:,368))
  call vert_QA_V(wf(:,-4),wf(:,114),wf(:,369))
  call vert_VQ_A(wf(:,59),wf(:,-4),wf(:,370))
  call prop_Q_A(wf(:,370),Q(:,31),MT,1_intkind1,wf(:,371))
  call vert_VQ_A(wf(:,60),wf(:,-4),wf(:,372))
  call prop_Q_A(wf(:,372),Q(:,31),MT,1_intkind1,wf(:,373))
  call vert_AV_Q(wf(:,-5),wf(:,59),wf(:,374))
  call prop_A_Q(wf(:,374),Q(:,47),MT,1_intkind1,wf(:,375))
  call vert_AV_Q(wf(:,-5),wf(:,60),wf(:,376))
  call prop_A_Q(wf(:,376),Q(:,47),MT,1_intkind1,wf(:,377))
  call vert_UV_W(wf(:,59),Q(:,15),wf(:,-6),Q(:,64),wf(:,378))
  call vert_UV_W(wf(:,60),Q(:,15),wf(:,-6),Q(:,64),wf(:,379))
  call vert_QA_V(wf(:,298),wf(:,-3),wf(:,380))
  call vert_QA_V(wf(:,299),wf(:,-3),wf(:,381))
  call vert_VQ_A(wf(:,63),wf(:,-4),wf(:,382))
  call prop_Q_A(wf(:,382),Q(:,31),MT,1_intkind1,wf(:,383))
  call vert_VQ_A(wf(:,64),wf(:,-4),wf(:,384))
  call prop_Q_A(wf(:,384),Q(:,31),MT,1_intkind1,wf(:,385))
  call vert_AV_Q(wf(:,-5),wf(:,63),wf(:,386))
  call prop_A_Q(wf(:,386),Q(:,47),MT,1_intkind1,wf(:,387))
  call vert_AV_Q(wf(:,-5),wf(:,64),wf(:,388))
  call prop_A_Q(wf(:,388),Q(:,47),MT,1_intkind1,wf(:,389))
  call vert_UV_W(wf(:,63),Q(:,15),wf(:,-6),Q(:,64),wf(:,390))
  call vert_UV_W(wf(:,64),Q(:,15),wf(:,-6),Q(:,64),wf(:,391))
  call vert_QA_V(wf(:,-2),wf(:,295),wf(:,392))
  call vert_QA_V(wf(:,-2),wf(:,296),wf(:,393))
  call vert_VQ_A(wf(:,30),wf(:,-2),wf(:,394))
  call prop_Q_A(wf(:,394),Q(:,55),ZERO,0_intkind1,wf(:,395))
  call vert_VQ_A(wf(:,31),wf(:,-2),wf(:,396))
  call prop_Q_A(wf(:,396),Q(:,55),ZERO,0_intkind1,wf(:,397))
  call vert_AV_Q(wf(:,-3),wf(:,30),wf(:,398))
  call prop_A_Q(wf(:,398),Q(:,59),ZERO,0_intkind1,wf(:,399))
  call vert_AV_Q(wf(:,-3),wf(:,31),wf(:,400))
  call prop_A_Q(wf(:,400),Q(:,59),ZERO,0_intkind1,wf(:,401))
  call vert_UV_W(wf(:,30),Q(:,51),wf(:,-6),Q(:,64),wf(:,402))
  call vert_UV_W(wf(:,31),Q(:,51),wf(:,-6),Q(:,64),wf(:,403))
  call vert_QA_V(wf(:,258),wf(:,-5),wf(:,404))
  call vert_QA_V(wf(:,259),wf(:,-5),wf(:,405))
  call vert_VQ_A(wf(:,33),wf(:,-2),wf(:,406))
  call prop_Q_A(wf(:,406),Q(:,55),ZERO,0_intkind1,wf(:,407))
  call vert_VQ_A(wf(:,34),wf(:,-2),wf(:,408))
  call prop_Q_A(wf(:,408),Q(:,55),ZERO,0_intkind1,wf(:,409))
  call vert_AV_Q(wf(:,-3),wf(:,33),wf(:,410))
  call prop_A_Q(wf(:,410),Q(:,59),ZERO,0_intkind1,wf(:,411))
  call vert_AV_Q(wf(:,-3),wf(:,34),wf(:,412))
  call prop_A_Q(wf(:,412),Q(:,59),ZERO,0_intkind1,wf(:,413))
  call vert_UV_W(wf(:,33),Q(:,51),wf(:,-6),Q(:,64),wf(:,414))
  call vert_UV_W(wf(:,34),Q(:,51),wf(:,-6),Q(:,64),wf(:,415))
  call vert_QA_V(wf(:,-4),wf(:,255),wf(:,416))
  call vert_QA_V(wf(:,-4),wf(:,256),wf(:,417))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3))
  den(2) = 1 / (Q(5,12))
  den(3) = 1 / (Q(5,80) - MT2)
  den(5) = 1 / (Q(5,35) - MT2)
  den(8) = 1 / (Q(5,3) - MZ2)
  den(12) = 1 / (Q(5,44) - MT2)
  den(17) = 1 / (Q(5,96) - MT2)
  den(19) = 1 / (Q(5,19) - MT2)
  den(25) = 1 / (Q(5,28) - MT2)
  den(32) = 1 / (Q(5,76))
  den(40) = 1 / (Q(5,68))
  den(41) = 1 / (Q(5,48))
  den(43) = 1 / (Q(5,11))
  den(49) = 1 / (Q(5,56))
  den(54) = 1 / (Q(5,72))
  den(56) = 1 / (Q(5,7))
  den(62) = 1 / (Q(5,52))
  den(67) = 1 / (Q(5,112))
  den(105) = 1 / (Q(5,60))
  den(110) = 1 / (Q(5,67))
  den(114) = 1 / (Q(5,83) - MT2)
  den(119) = 1 / (Q(5,92) - MT2)
  den(123) = 1 / (Q(5,99) - MT2)
  den(128) = 1 / (Q(5,108) - MT2)
  den(136) = 1 / (Q(5,71))
  den(141) = 1 / (Q(5,116))
  den(145) = 1 / (Q(5,75))
  den(150) = 1 / (Q(5,120))
  den(196) = 1 / (Q(5,51))
  den(279) = 1 / (Q(5,15))
  den(365) = 1 / (Q(5,31) - MT2)
  den(370) = 1 / (Q(5,47) - MT2)
  den(385) = 1 / (Q(5,55))
  den(390) = 1 / (Q(5,59))
  den(405) = 1 / (Q(5,79))
  den(418) = 1 / (Q(5,115))

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(9) = den(5)*den(8)
  den(10) = den(4)*den(9)
  den(11) = den(1)*den(3)
  den(13) = den(2)*den(12)
  den(14) = den(11)*den(13)
  den(15) = den(3)*den(8)
  den(16) = den(13)*den(15)
  den(18) = den(2)*den(17)
  den(20) = den(1)*den(19)
  den(21) = den(18)*den(20)
  den(22) = den(8)*den(19)
  den(23) = den(18)*den(22)
  den(24) = den(1)*den(17)
  den(26) = den(2)*den(25)
  den(27) = den(24)*den(26)
  den(28) = den(8)*den(17)
  den(29) = den(26)*den(28)
  den(30) = den(13)*den(20)
  den(31) = den(13)*den(22)
  den(33) = den(2)*den(32)
  den(34) = den(20)*den(33)
  den(35) = den(22)*den(33)
  den(36) = den(6)*den(26)
  den(37) = den(9)*den(26)
  den(38) = den(6)*den(33)
  den(39) = den(9)*den(33)
  den(42) = den(40)*den(41)
  den(44) = den(1)*den(43)
  den(45) = den(42)*den(44)
  den(46) = den(8)*den(43)
  den(47) = den(42)*den(46)
  den(48) = den(1)*den(40)
  den(50) = den(41)*den(49)
  den(51) = den(48)*den(50)
  den(52) = den(8)*den(40)
  den(53) = den(50)*den(52)
  den(55) = den(41)*den(54)
  den(57) = den(1)*den(56)
  den(58) = den(55)*den(57)
  den(59) = den(8)*den(56)
  den(60) = den(55)*den(59)
  den(61) = den(1)*den(54)
  den(63) = den(41)*den(62)
  den(64) = den(61)*den(63)
  den(65) = den(8)*den(54)
  den(66) = den(63)*den(65)
  den(68) = den(41)*den(67)
  den(69) = den(57)*den(68)
  den(70) = den(59)*den(68)
  den(71) = den(50)*den(57)
  den(72) = den(50)*den(59)
  den(73) = den(44)*den(68)
  den(74) = den(46)*den(68)
  den(75) = den(44)*den(63)
  den(76) = den(46)*den(63)
  den(77) = den(32)*den(40)
  den(78) = den(20)*den(77)
  den(79) = den(22)*den(77)
  den(80) = den(6)*den(77)
  den(81) = den(9)*den(77)
  den(82) = den(32)*den(54)
  den(83) = den(20)*den(82)
  den(84) = den(22)*den(82)
  den(85) = den(6)*den(82)
  den(86) = den(9)*den(82)
  den(87) = den(3)*den(67)
  den(88) = den(57)*den(87)
  den(89) = den(59)*den(87)
  den(90) = den(44)*den(87)
  den(91) = den(46)*den(87)
  den(92) = den(17)*den(67)
  den(93) = den(57)*den(92)
  den(94) = den(59)*den(92)
  den(95) = den(44)*den(92)
  den(96) = den(46)*den(92)
  den(97) = den(1)*den(2)
  den(98) = den(41)*den(97)
  den(99) = den(2)*den(8)
  den(100) = den(41)*den(99)
  den(101) = den(8)*den(41)
  den(102) = den(33)*den(101)
  den(103) = den(68)*den(99)
  den(104) = den(2)*den(41)
  den(106) = den(104)*den(105)
  den(107) = den(8)*den(106)
  den(108) = den(87)*den(99)
  den(109) = den(92)*den(99)
  den(111) = den(8)*den(110)
  den(112) = den(26)*den(111)
  den(113) = den(13)*den(111)
  den(115) = den(11)*den(114)
  den(116) = den(2)*den(115)
  den(117) = den(15)*den(114)
  den(118) = den(2)*den(117)
  den(120) = den(4)*den(119)
  den(121) = den(1)*den(120)
  den(122) = den(8)*den(120)
  den(124) = den(24)*den(123)
  den(125) = den(2)*den(124)
  den(126) = den(28)*den(123)
  den(127) = den(2)*den(126)
  den(129) = den(18)*den(128)
  den(130) = den(1)*den(129)
  den(131) = den(8)*den(129)
  den(132) = den(77)*den(101)
  den(133) = den(82)*den(101)
  den(134) = den(63)*den(111)
  den(135) = den(50)*den(111)
  den(137) = den(48)*den(136)
  den(138) = den(41)*den(137)
  den(139) = den(52)*den(136)
  den(140) = den(41)*den(139)
  den(142) = den(42)*den(141)
  den(143) = den(1)*den(142)
  den(144) = den(8)*den(142)
  den(146) = den(61)*den(145)
  den(147) = den(41)*den(146)
  den(148) = den(65)*den(145)
  den(149) = den(41)*den(148)
  den(151) = den(55)*den(150)
  den(152) = den(1)*den(151)
  den(153) = den(8)*den(151)
  den(154) = den(2)**2
  den(155) = den(115)*den(154)
  den(156) = den(117)*den(154)
  den(157) = den(3)*den(154)
  den(158) = den(6)*den(157)
  den(159) = den(9)*den(157)
  den(160) = den(3)**2
  den(161) = den(2)*den(160)
  den(162) = den(6)*den(161)
  den(163) = den(9)*den(161)
  den(164) = den(1)*den(160)
  den(165) = den(13)*den(164)
  den(166) = den(8)*den(160)
  den(167) = den(13)*den(166)
  den(168) = den(6)*den(120)
  den(169) = den(9)*den(120)
  den(170) = den(13)*den(115)
  den(171) = den(13)*den(117)
  den(172) = den(124)*den(154)
  den(173) = den(126)*den(154)
  den(174) = den(20)*den(154)
  den(175) = den(17)*den(174)
  den(176) = den(22)*den(154)
  den(177) = den(17)*den(176)
  den(178) = den(20)*den(129)
  den(179) = den(22)*den(129)
  den(180) = den(26)*den(124)
  den(181) = den(26)*den(126)
  den(182) = den(17)**2
  den(183) = den(2)*den(182)
  den(184) = den(20)*den(183)
  den(185) = den(22)*den(183)
  den(186) = den(1)*den(182)
  den(187) = den(26)*den(186)
  den(188) = den(8)*den(182)
  den(189) = den(26)*den(188)
  den(190) = den(25)*den(154)
  den(191) = den(6)*den(190)
  den(192) = den(9)*den(190)
  den(193) = den(12)*den(154)
  den(194) = den(20)*den(193)
  den(195) = den(22)*den(193)
  den(197) = den(20)*den(196)
  den(198) = den(154)*den(197)
  den(199) = den(22)*den(196)
  den(200) = den(154)*den(199)
  den(201) = den(6)*den(196)
  den(202) = den(154)*den(201)
  den(203) = den(9)*den(196)
  den(204) = den(154)*den(203)
  den(205) = den(33)*den(128)
  den(206) = den(20)*den(205)
  den(207) = den(22)*den(205)
  den(208) = den(33)*den(119)
  den(209) = den(6)*den(208)
  den(210) = den(9)*den(208)
  den(211) = den(13)*den(128)
  den(212) = den(20)*den(211)
  den(213) = den(22)*den(211)
  den(214) = den(6)*den(123)
  den(215) = den(26)*den(214)
  den(216) = den(9)*den(123)
  den(217) = den(26)*den(216)
  den(218) = den(33)*den(201)
  den(219) = den(33)*den(203)
  den(220) = den(20)*den(114)
  den(221) = den(13)*den(220)
  den(222) = den(22)*den(114)
  den(223) = den(13)*den(222)
  den(224) = den(33)*den(197)
  den(225) = den(33)*den(199)
  den(226) = den(26)*den(119)
  den(227) = den(6)*den(226)
  den(228) = den(9)*den(226)
  den(229) = den(40)**2
  den(230) = den(44)*den(229)
  den(231) = den(41)*den(230)
  den(232) = den(46)*den(229)
  den(233) = den(41)*den(232)
  den(234) = den(1)*den(229)
  den(235) = den(50)*den(234)
  den(236) = den(8)*den(229)
  den(237) = den(50)*den(236)
  den(238) = den(41)**2
  den(239) = den(137)*den(238)
  den(240) = den(139)*den(238)
  den(241) = den(44)*den(142)
  den(242) = den(46)*den(142)
  den(243) = den(50)*den(137)
  den(244) = den(50)*den(139)
  den(245) = den(40)*den(238)
  den(246) = den(44)*den(245)
  den(247) = den(46)*den(245)
  den(248) = den(146)*den(238)
  den(249) = den(148)*den(238)
  den(250) = den(57)*den(151)
  den(251) = den(59)*den(151)
  den(252) = den(63)*den(146)
  den(253) = den(63)*den(148)
  den(254) = den(54)**2
  den(255) = den(57)*den(254)
  den(256) = den(41)*den(255)
  den(257) = den(59)*den(254)
  den(258) = den(41)*den(257)
  den(259) = den(1)*den(254)
  den(260) = den(63)*den(259)
  den(261) = den(8)*den(254)
  den(262) = den(63)*den(261)
  den(263) = den(57)*den(238)
  den(264) = den(54)*den(263)
  den(265) = den(59)*den(238)
  den(266) = den(54)*den(265)
  den(267) = den(68)*den(150)
  den(268) = den(57)*den(267)
  den(269) = den(59)*den(267)
  den(270) = den(68)*den(141)
  den(271) = den(44)*den(270)
  den(272) = den(46)*den(270)
  den(273) = den(62)*den(238)
  den(274) = den(44)*den(273)
  den(275) = den(46)*den(273)
  den(276) = den(50)*den(150)
  den(277) = den(57)*den(276)
  den(278) = den(59)*den(276)
  den(280) = den(44)*den(279)
  den(281) = den(68)*den(280)
  den(282) = den(46)*den(279)
  den(283) = den(68)*den(282)
  den(284) = den(44)*den(145)
  den(285) = den(63)*den(284)
  den(286) = den(46)*den(145)
  den(287) = den(63)*den(286)
  den(288) = den(49)*den(238)
  den(289) = den(57)*den(288)
  den(290) = den(59)*den(288)
  den(291) = den(57)*den(279)
  den(292) = den(68)*den(291)
  den(293) = den(59)*den(279)
  den(294) = den(68)*den(293)
  den(295) = den(57)*den(136)
  den(296) = den(50)*den(295)
  den(297) = den(59)*den(136)
  den(298) = den(50)*den(297)
  den(299) = den(63)*den(141)
  den(300) = den(44)*den(299)
  den(301) = den(46)*den(299)
  den(302) = den(238)*den(291)
  den(303) = den(238)*den(293)
  den(304) = den(238)*den(280)
  den(305) = den(238)*den(282)
  den(306) = den(32)*den(229)
  den(307) = den(20)*den(306)
  den(308) = den(22)*den(306)
  den(309) = den(6)*den(306)
  den(310) = den(9)*den(306)
  den(311) = den(77)*den(201)
  den(312) = den(77)*den(203)
  den(313) = den(77)*den(197)
  den(314) = den(77)*den(199)
  den(315) = den(77)*den(128)
  den(316) = den(20)*den(315)
  den(317) = den(22)*den(315)
  den(318) = den(77)*den(119)
  den(319) = den(6)*den(318)
  den(320) = den(9)*den(318)
  den(321) = den(32)*den(254)
  den(322) = den(20)*den(321)
  den(323) = den(22)*den(321)
  den(324) = den(6)*den(321)
  den(325) = den(9)*den(321)
  den(326) = den(82)*den(201)
  den(327) = den(82)*den(203)
  den(328) = den(82)*den(197)
  den(329) = den(82)*den(199)
  den(330) = den(82)*den(128)
  den(331) = den(20)*den(330)
  den(332) = den(22)*den(330)
  den(333) = den(82)*den(119)
  den(334) = den(6)*den(333)
  den(335) = den(9)*den(333)
  den(336) = den(87)*den(150)
  den(337) = den(57)*den(336)
  den(338) = den(59)*den(336)
  den(339) = den(87)*den(141)
  den(340) = den(44)*den(339)
  den(341) = den(46)*den(339)
  den(342) = den(87)*den(280)
  den(343) = den(87)*den(282)
  den(344) = den(87)*den(291)
  den(345) = den(87)*den(293)
  den(346) = den(160)*den(291)
  den(347) = den(160)*den(293)
  den(348) = den(160)*den(280)
  den(349) = den(160)*den(282)
  den(350) = den(92)*den(150)
  den(351) = den(57)*den(350)
  den(352) = den(59)*den(350)
  den(353) = den(92)*den(141)
  den(354) = den(44)*den(353)
  den(355) = den(46)*den(353)
  den(356) = den(92)*den(280)
  den(357) = den(92)*den(282)
  den(358) = den(92)*den(291)
  den(359) = den(92)*den(293)
  den(360) = den(182)*den(291)
  den(361) = den(182)*den(293)
  den(362) = den(182)*den(280)
  den(363) = den(182)*den(282)
  den(364) = den(2)*den(20)
  den(366) = den(364)*den(365)
  den(367) = den(2)*den(22)
  den(368) = den(365)*den(367)
  den(369) = den(2)*den(6)
  den(371) = den(369)*den(370)
  den(372) = den(2)*den(9)
  den(373) = den(370)*den(372)
  den(374) = den(26)*den(105)
  den(375) = den(1)*den(26)
  den(376) = den(365)*den(375)
  den(377) = den(8)*den(26)
  den(378) = den(365)*den(377)
  den(379) = den(13)*den(105)
  den(380) = den(1)*den(13)
  den(381) = den(370)*den(380)
  den(382) = den(8)*den(13)
  den(383) = den(370)*den(382)
  den(384) = den(41)*den(57)
  den(386) = den(384)*den(385)
  den(387) = den(41)*den(59)
  den(388) = den(385)*den(387)
  den(389) = den(41)*den(44)
  den(391) = den(389)*den(390)
  den(392) = den(41)*den(46)
  den(393) = den(390)*den(392)
  den(394) = den(63)*den(105)
  den(395) = den(50)*den(105)
  den(396) = den(1)*den(63)
  den(397) = den(385)*den(396)
  den(398) = den(8)*den(63)
  den(399) = den(385)*den(398)
  den(400) = den(1)*den(50)
  den(401) = den(390)*den(400)
  den(402) = den(8)*den(50)
  den(403) = den(390)*den(402)
  den(404) = den(40)*den(44)
  den(406) = den(404)*den(405)
  den(407) = den(40)*den(46)
  den(408) = den(405)*den(407)
  den(409) = den(137)*den(405)
  den(410) = den(139)*den(405)
  den(411) = den(54)*den(57)
  den(412) = den(405)*den(411)
  den(413) = den(54)*den(59)
  den(414) = den(405)*den(413)
  den(415) = den(146)*den(405)
  den(416) = den(148)*den(405)
  den(417) = den(3)*den(6)
  den(419) = den(417)*den(418)
  den(420) = den(3)*den(9)
  den(421) = den(418)*den(420)
  den(422) = den(115)*den(418)
  den(423) = den(117)*den(418)
  den(424) = den(17)*den(20)
  den(425) = den(418)*den(424)
  den(426) = den(17)*den(22)
  den(427) = den(418)*den(426)
  den(428) = den(124)*den(418)
  den(429) = den(126)*den(418)
  den(430) = den(291)*den(365)
  den(431) = den(293)*den(365)
  den(432) = den(291)*den(370)
  den(433) = den(293)*den(370)
  den(434) = den(291)*den(405)
  den(435) = den(293)*den(405)
  den(436) = den(295)*den(405)
  den(437) = den(297)*den(405)
  den(438) = den(280)*den(365)
  den(439) = den(282)*den(365)
  den(440) = den(280)*den(370)
  den(441) = den(282)*den(370)
  den(442) = den(280)*den(405)
  den(443) = den(282)*den(405)
  den(444) = den(284)*den(405)
  den(445) = den(286)*den(405)
  den(446) = den(197)*den(385)
  den(447) = den(199)*den(385)
  den(448) = den(197)*den(390)
  den(449) = den(199)*den(390)
  den(450) = den(197)*den(418)
  den(451) = den(199)*den(418)
  den(452) = den(220)*den(418)
  den(453) = den(222)*den(418)
  den(454) = den(201)*den(385)
  den(455) = den(203)*den(385)
  den(456) = den(201)*den(390)
  den(457) = den(203)*den(390)
  den(458) = den(201)*den(418)
  den(459) = den(203)*den(418)
  den(460) = den(214)*den(418)
  den(461) = den(216)*den(418)
  den(462) = den(1)*den(41)
  den(463) = den(1)*den(33)*den(41)
  den(464) = den(8)*den(33)*den(41)
  den(465) = den(1)*den(2)*den(68)
  den(466) = den(2)*den(8)*den(68)
  den(467) = den(1)*den(106)
  den(468) = den(1)*den(2)*den(41)
  den(469) = den(2)*den(8)*den(41)
  den(470) = den(2)*den(3)*den(6)
  den(471) = den(2)*den(3)*den(9)
  den(472) = den(1)*den(3)*den(13)
  den(473) = den(3)*den(8)*den(13)
  den(474) = den(1)*den(2)*den(87)
  den(475) = den(2)*den(8)*den(87)
  den(476) = den(1)*den(2)*den(3)
  den(477) = den(2)*den(3)*den(8)
  den(478) = den(2)*den(17)*den(20)
  den(479) = den(2)*den(17)*den(22)
  den(480) = den(1)*den(17)*den(26)
  den(481) = den(8)*den(17)*den(26)
  den(482) = den(1)*den(2)*den(92)
  den(483) = den(2)*den(8)*den(92)
  den(484) = den(1)*den(2)*den(17)
  den(485) = den(2)*den(8)*den(17)
  den(486) = den(2)*den(197)
  den(487) = den(2)*den(199)
  den(488) = den(2)*den(220)
  den(489) = den(2)*den(222)
  den(490) = den(2)*den(201)
  den(491) = den(2)*den(203)
  den(492) = den(2)*den(214)
  den(493) = den(2)*den(216)
  den(494) = den(1)*den(374)
  den(495) = den(8)*den(374)
  den(496) = den(1)*den(226)
  den(497) = den(8)*den(226)
  den(498) = den(1)*den(379)
  den(499) = den(8)*den(379)
  den(500) = den(1)*den(211)
  den(501) = den(8)*den(211)
  den(502) = den(1)*den(208)
  den(503) = den(8)*den(208)
  den(504) = den(1)*den(205)
  den(505) = den(8)*den(205)
  den(506) = den(1)*den(33)
  den(507) = den(8)*den(33)
  den(508) = den(40)*den(41)*den(44)
  den(509) = den(40)*den(41)*den(46)
  den(510) = den(1)*den(41)*den(77)
  den(511) = den(8)*den(41)*den(77)
  den(512) = den(1)*den(40)*den(50)
  den(513) = den(8)*den(40)*den(50)
  den(514) = den(1)*den(40)*den(41)
  den(515) = den(8)*den(40)*den(41)
  den(516) = den(41)*den(54)*den(57)
  den(517) = den(41)*den(54)*den(59)
  den(518) = den(1)*den(41)*den(82)
  den(519) = den(8)*den(41)*den(82)
  den(520) = den(1)*den(54)*den(63)
  den(521) = den(8)*den(54)*den(63)
  den(522) = den(1)*den(41)*den(54)
  den(523) = den(8)*den(41)*den(54)
  den(524) = den(41)*den(291)
  den(525) = den(41)*den(293)
  den(526) = den(41)*den(295)
  den(527) = den(41)*den(297)
  den(528) = den(41)*den(280)
  den(529) = den(41)*den(282)
  den(530) = den(41)*den(284)
  den(531) = den(41)*den(286)
  den(532) = den(1)*den(394)
  den(533) = den(8)*den(394)
  den(534) = den(1)*den(395)
  den(535) = den(8)*den(395)
  den(536) = den(1)*den(299)
  den(537) = den(8)*den(299)
  den(538) = den(1)*den(270)
  den(539) = den(8)*den(270)
  den(540) = den(1)*den(276)
  den(541) = den(8)*den(276)
  den(542) = den(1)*den(267)
  den(543) = den(8)*den(267)
  den(544) = den(1)*den(68)
  den(545) = den(8)*den(68)
  den(546) = den(40)*den(197)
  den(547) = den(40)*den(199)
  den(548) = den(20)*den(40)
  den(549) = den(22)*den(40)
  den(550) = den(40)*den(201)
  den(551) = den(40)*den(203)
  den(552) = den(6)*den(40)
  den(553) = den(9)*den(40)
  den(554) = den(1)*den(318)
  den(555) = den(8)*den(318)
  den(556) = den(1)*den(315)
  den(557) = den(8)*den(315)
  den(558) = den(1)*den(77)
  den(559) = den(8)*den(77)
  den(560) = den(54)*den(197)
  den(561) = den(54)*den(199)
  den(562) = den(20)*den(54)
  den(563) = den(22)*den(54)
  den(564) = den(54)*den(201)
  den(565) = den(54)*den(203)
  den(566) = den(6)*den(54)
  den(567) = den(9)*den(54)
  den(568) = den(1)*den(333)
  den(569) = den(8)*den(333)
  den(570) = den(1)*den(330)
  den(571) = den(8)*den(330)
  den(572) = den(1)*den(82)
  den(573) = den(8)*den(82)
  den(574) = den(3)*den(291)
  den(575) = den(3)*den(293)
  den(576) = den(3)*den(57)
  den(577) = den(3)*den(59)
  den(578) = den(3)*den(280)
  den(579) = den(3)*den(282)
  den(580) = den(3)*den(44)
  den(581) = den(3)*den(46)
  den(582) = den(1)*den(339)
  den(583) = den(8)*den(339)
  den(584) = den(1)*den(336)
  den(585) = den(8)*den(336)
  den(586) = den(1)*den(87)
  den(587) = den(8)*den(87)
  den(588) = den(17)*den(291)
  den(589) = den(17)*den(293)
  den(590) = den(17)*den(57)
  den(591) = den(17)*den(59)
  den(592) = den(17)*den(280)
  den(593) = den(17)*den(282)
  den(594) = den(17)*den(44)
  den(595) = den(17)*den(46)
  den(596) = den(1)*den(353)
  den(597) = den(8)*den(353)
  den(598) = den(1)*den(350)
  den(599) = den(8)*den(350)
  den(600) = den(1)*den(92)
  den(601) = den(8)*den(92)
  den(602) = den(3)*den(371)
  den(603) = den(3)*den(373)
  den(604) = den(2)*den(419)
  den(605) = den(2)*den(421)
  den(606) = den(3)*den(381)
  den(607) = den(3)*den(383)
  den(608) = den(2)*den(422)
  den(609) = den(2)*den(423)
  den(610) = den(17)*den(366)
  den(611) = den(17)*den(368)
  den(612) = den(2)*den(425)
  den(613) = den(2)*den(427)
  den(614) = den(17)*den(376)
  den(615) = den(17)*den(378)
  den(616) = den(2)*den(428)
  den(617) = den(2)*den(429)
  den(618) = den(2)*den(450)
  den(619) = den(2)*den(451)
  den(620) = den(2)*den(452)
  den(621) = den(2)*den(453)
  den(622) = den(2)*den(458)
  den(623) = den(2)*den(459)
  den(624) = den(2)*den(460)
  den(625) = den(2)*den(461)
  den(626) = den(41)*den(406)
  den(627) = den(41)*den(408)
  den(628) = den(40)*den(391)
  den(629) = den(40)*den(393)
  den(630) = den(41)*den(409)
  den(631) = den(41)*den(410)
  den(632) = den(40)*den(401)
  den(633) = den(40)*den(403)
  den(634) = den(41)*den(412)
  den(635) = den(41)*den(414)
  den(636) = den(54)*den(386)
  den(637) = den(54)*den(388)
  den(638) = den(54)*den(397)
  den(639) = den(54)*den(399)
  den(640) = den(41)*den(415)
  den(641) = den(41)*den(416)
  den(642) = den(41)*den(434)
  den(643) = den(41)*den(435)
  den(644) = den(41)*den(436)
  den(645) = den(41)*den(437)
  den(646) = den(41)*den(442)
  den(647) = den(41)*den(443)
  den(648) = den(41)*den(444)
  den(649) = den(41)*den(445)
  den(650) = den(40)*den(448)
  den(651) = den(40)*den(449)
  den(652) = den(40)*den(456)
  den(653) = den(40)*den(457)
  den(654) = den(54)*den(446)
  den(655) = den(54)*den(447)
  den(656) = den(54)*den(454)
  den(657) = den(54)*den(455)
  den(658) = den(3)*den(432)
  den(659) = den(3)*den(433)
  den(660) = den(3)*den(440)
  den(661) = den(3)*den(441)
  den(662) = den(17)*den(430)
  den(663) = den(17)*den(431)
  den(664) = den(17)*den(438)
  den(665) = den(17)*den(439)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(399)

  A(1) = cont_QA(wf(:,6),wf(:,7)) * den(7)
  A(2) = cont_QA(wf(:,6),wf(:,11)) * den(10)
  A(3) = cont_QA(wf(:,13),wf(:,14)) * den(14)
  A(4) = cont_QA(wf(:,14),wf(:,15)) * den(16)
  A(5) = cont_QA(wf(:,19),wf(:,20)) * den(21)
  A(6) = cont_QA(wf(:,19),wf(:,22)) * den(23)
  A(7) = cont_QA(wf(:,24),wf(:,25)) * den(27)
  A(8) = cont_QA(wf(:,25),wf(:,26)) * den(29)
  A(9) = cont_QA(wf(:,14),wf(:,27)) * den(30)
  A(10) = cont_QA(wf(:,14),wf(:,28)) * den(31)
  A(11) = cont_VV(wf(:,29),wf(:,30)) * den(34)
  A(12) = cont_VV(wf(:,29),wf(:,31)) * den(35)
  A(13) = cont_QA(wf(:,7),wf(:,32)) * den(36)
  A(14) = cont_QA(wf(:,11),wf(:,32)) * den(37)
  A(15) = cont_VV(wf(:,29),wf(:,33)) * den(38)
  A(16) = cont_VV(wf(:,29),wf(:,34)) * den(39)
  A(17) = cont_QA(wf(:,39),wf(:,40)) * den(45)
  A(18) = cont_QA(wf(:,39),wf(:,42)) * den(47)
  A(19) = cont_QA(wf(:,44),wf(:,45)) * den(51)
  A(20) = cont_QA(wf(:,45),wf(:,46)) * den(53)
  A(21) = cont_QA(wf(:,50),wf(:,51)) * den(58)
  A(22) = cont_QA(wf(:,50),wf(:,53)) * den(60)
  A(23) = cont_QA(wf(:,55),wf(:,56)) * den(64)
  A(24) = cont_QA(wf(:,56),wf(:,57)) * den(66)
  A(25) = cont_VV(wf(:,58),wf(:,59)) * den(69)
  A(26) = cont_VV(wf(:,58),wf(:,60)) * den(70)
  A(27) = cont_QA(wf(:,45),wf(:,61)) * den(71)
  A(28) = cont_QA(wf(:,45),wf(:,62)) * den(72)
  A(29) = cont_VV(wf(:,58),wf(:,63)) * den(73)
  A(30) = cont_VV(wf(:,58),wf(:,64)) * den(74)
  A(31) = cont_QA(wf(:,40),wf(:,65)) * den(75)
  A(32) = cont_QA(wf(:,42),wf(:,65)) * den(76)
  A(33) = cont_QA(wf(:,20),wf(:,67)) * den(78)
  A(34) = cont_QA(wf(:,22),wf(:,67)) * den(79)
  A(35) = cont_QA(wf(:,7),wf(:,68)) * den(80)
  A(36) = cont_QA(wf(:,11),wf(:,68)) * den(81)
  A(37) = cont_QA(wf(:,20),wf(:,70)) * den(83)
  A(38) = cont_QA(wf(:,22),wf(:,70)) * den(84)
  A(39) = cont_QA(wf(:,7),wf(:,71)) * den(85)
  A(40) = cont_QA(wf(:,11),wf(:,71)) * den(86)
  A(41) = cont_VV(wf(:,59),wf(:,72)) * den(88)
  A(42) = cont_VV(wf(:,60),wf(:,72)) * den(89)
  A(43) = cont_VV(wf(:,63),wf(:,72)) * den(90)
  A(44) = cont_VV(wf(:,64),wf(:,72)) * den(91)
  A(45) = cont_VV(wf(:,59),wf(:,73)) * den(93)
  A(46) = cont_VV(wf(:,60),wf(:,73)) * den(94)
  A(47) = cont_VV(wf(:,63),wf(:,73)) * den(95)
  A(48) = cont_VV(wf(:,64),wf(:,73)) * den(96)

  A(49) = cont_VV(wf(:,36),wf(:,74)) * den(98)
  A(50) = cont_VV(wf(:,36),wf(:,75)) * den(98)
  A(51) = cont_VV(wf(:,36),wf(:,76)) * den(100)
  A(52) = cont_VV(wf(:,36),wf(:,77)) * den(100)
  A(53) = cont_VV(wf(:,29),wf(:,78)) * den(102)
  A(54) = cont_VV(wf(:,58),wf(:,79)) * den(103)
  A(55) = cont_VV(wf(:,80),wf(:,81)) * den(107)
  A(56) = cont_QA(wf(:,7),wf(:,82)) * den(7)
  A(57) = cont_QA(wf(:,11),wf(:,82)) * den(10)
  A(58) = cont_QA(wf(:,14),wf(:,83)) * den(14)
  A(59) = cont_QA(wf(:,14),wf(:,84)) * den(16)
  A(60) = cont_VV(wf(:,72),wf(:,79)) * den(108)
  A(61) = cont_QA(wf(:,20),wf(:,85)) * den(21)
  A(62) = cont_QA(wf(:,22),wf(:,85)) * den(23)
  A(63) = cont_QA(wf(:,25),wf(:,86)) * den(27)
  A(64) = cont_QA(wf(:,25),wf(:,87)) * den(29)
  A(65) = cont_VV(wf(:,73),wf(:,79)) * den(109)
  A(66) = cont_QA(wf(:,14),wf(:,88)) * den(30)
  A(67) = cont_QA(wf(:,14),wf(:,89)) * den(31)
  A(68) = cont_VV(wf(:,30),wf(:,90)) * den(34)
  A(69) = cont_VV(wf(:,31),wf(:,90)) * den(35)
  A(70) = cont_QA(wf(:,7),wf(:,91)) * den(36)
  A(71) = cont_QA(wf(:,11),wf(:,91)) * den(37)
  A(72) = cont_VV(wf(:,33),wf(:,90)) * den(38)
  A(73) = cont_VV(wf(:,34),wf(:,90)) * den(39)
  A(74) = cont_VV(wf(:,81),wf(:,92)) * den(112)
  A(75) = cont_VV(wf(:,81),wf(:,93)) * den(113)
  A(76) = cont_QA(wf(:,94),wf(:,95)) * den(116)
  A(77) = cont_QA(wf(:,94),wf(:,96)) * den(118)
  A(78) = cont_QA(wf(:,97),wf(:,98)) * den(121)
  A(79) = cont_QA(wf(:,98),wf(:,99)) * den(122)
  A(80) = cont_VV(wf(:,29),wf(:,100)) * den(34)
  A(81) = cont_VV(wf(:,29),wf(:,101)) * den(35)
  A(82) = cont_QA(wf(:,27),wf(:,102)) * den(30)
  A(83) = cont_QA(wf(:,28),wf(:,102)) * den(31)
  A(84) = cont_QA(wf(:,32),wf(:,103)) * den(36)
  A(85) = cont_QA(wf(:,32),wf(:,104)) * den(37)
  A(86) = cont_VV(wf(:,29),wf(:,105)) * den(38)
  A(87) = cont_VV(wf(:,29),wf(:,106)) * den(39)
  A(88) = cont_QA(wf(:,20),wf(:,109)) * den(21)
  A(89) = cont_QA(wf(:,22),wf(:,109)) * den(23)
  A(90) = cont_QA(wf(:,25),wf(:,110)) * den(27)
  A(91) = cont_QA(wf(:,25),wf(:,111)) * den(29)
  A(92) = cont_QA(wf(:,112),wf(:,113)) * den(125)
  A(93) = cont_QA(wf(:,112),wf(:,114)) * den(127)
  A(94) = cont_QA(wf(:,115),wf(:,116)) * den(130)
  A(95) = cont_QA(wf(:,116),wf(:,117)) * den(131)
  A(96) = cont_VV(wf(:,29),wf(:,118)) * den(38)
  A(97) = cont_VV(wf(:,29),wf(:,119)) * den(39)
  A(98) = cont_QA(wf(:,7),wf(:,121)) * den(36)
  A(99) = cont_QA(wf(:,11),wf(:,121)) * den(37)
  A(100) = cont_QA(wf(:,14),wf(:,123)) * den(30)
  A(101) = cont_QA(wf(:,14),wf(:,125)) * den(31)
  A(102) = cont_VV(wf(:,29),wf(:,126)) * den(34)
  A(103) = cont_VV(wf(:,29),wf(:,127)) * den(35)
  A(104) = cont_QA(wf(:,7),wf(:,130)) * den(7)
  A(105) = cont_QA(wf(:,11),wf(:,130)) * den(10)
  A(106) = cont_QA(wf(:,14),wf(:,131)) * den(14)
  A(107) = cont_QA(wf(:,14),wf(:,132)) * den(16)
  A(108) = cont_QA(wf(:,40),wf(:,133)) * den(45)
  A(109) = cont_QA(wf(:,42),wf(:,133)) * den(47)
  A(110) = cont_VV(wf(:,66),wf(:,78)) * den(132)
  A(111) = cont_QA(wf(:,45),wf(:,134)) * den(51)
  A(112) = cont_QA(wf(:,45),wf(:,135)) * den(53)
  A(113) = cont_QA(wf(:,51),wf(:,136)) * den(58)
  A(114) = cont_QA(wf(:,53),wf(:,136)) * den(60)
  A(115) = cont_VV(wf(:,69),wf(:,78)) * den(133)
  A(116) = cont_QA(wf(:,56),wf(:,137)) * den(64)
  A(117) = cont_QA(wf(:,56),wf(:,138)) * den(66)
  A(118) = cont_VV(wf(:,59),wf(:,139)) * den(69)
  A(119) = cont_VV(wf(:,60),wf(:,139)) * den(70)
  A(120) = cont_QA(wf(:,45),wf(:,140)) * den(71)
  A(121) = cont_QA(wf(:,45),wf(:,141)) * den(72)
  A(122) = cont_VV(wf(:,63),wf(:,139)) * den(73)
  A(123) = cont_VV(wf(:,64),wf(:,139)) * den(74)
  A(124) = cont_QA(wf(:,40),wf(:,142)) * den(75)
  A(125) = cont_QA(wf(:,42),wf(:,142)) * den(76)
  A(126) = cont_VV(wf(:,81),wf(:,143)) * den(134)
  A(127) = cont_VV(wf(:,81),wf(:,144)) * den(135)
  A(128) = cont_QA(wf(:,20),wf(:,145)) * den(78)
  A(129) = cont_QA(wf(:,22),wf(:,145)) * den(79)
  A(130) = cont_QA(wf(:,68),wf(:,103)) * den(80)
  A(131) = cont_QA(wf(:,68),wf(:,104)) * den(81)
  A(132) = cont_QA(wf(:,20),wf(:,146)) * den(83)
  A(133) = cont_QA(wf(:,22),wf(:,146)) * den(84)
  A(134) = cont_QA(wf(:,71),wf(:,103)) * den(85)
  A(135) = cont_QA(wf(:,71),wf(:,104)) * den(86)
  A(136) = cont_VV(wf(:,59),wf(:,147)) * den(88)
  A(137) = cont_VV(wf(:,60),wf(:,147)) * den(89)
  A(138) = cont_VV(wf(:,63),wf(:,147)) * den(90)
  A(139) = cont_VV(wf(:,64),wf(:,147)) * den(91)
  A(140) = cont_VV(wf(:,59),wf(:,148)) * den(93)
  A(141) = cont_VV(wf(:,60),wf(:,148)) * den(94)
  A(142) = cont_VV(wf(:,63),wf(:,148)) * den(95)
  A(143) = cont_VV(wf(:,64),wf(:,148)) * den(96)
  A(144) = cont_QA(wf(:,7),wf(:,149)) * den(80)
  A(145) = cont_QA(wf(:,11),wf(:,149)) * den(81)
  A(146) = cont_QA(wf(:,67),wf(:,122)) * den(78)
  A(147) = cont_QA(wf(:,67),wf(:,124)) * den(79)
  A(148) = cont_QA(wf(:,7),wf(:,150)) * den(85)
  A(149) = cont_QA(wf(:,11),wf(:,150)) * den(86)
  A(150) = cont_QA(wf(:,70),wf(:,122)) * den(83)
  A(151) = cont_QA(wf(:,70),wf(:,124)) * den(84)
  A(152) = cont_VV(wf(:,59),wf(:,151)) * den(93)
  A(153) = cont_VV(wf(:,60),wf(:,151)) * den(94)
  A(154) = cont_VV(wf(:,63),wf(:,151)) * den(95)
  A(155) = cont_VV(wf(:,64),wf(:,151)) * den(96)
  A(156) = cont_VV(wf(:,59),wf(:,152)) * den(88)
  A(157) = cont_VV(wf(:,60),wf(:,152)) * den(89)
  A(158) = cont_VV(wf(:,63),wf(:,152)) * den(90)
  A(159) = cont_VV(wf(:,64),wf(:,152)) * den(91)
  A(160) = cont_QA(wf(:,40),wf(:,154)) * den(45)
  A(161) = cont_QA(wf(:,42),wf(:,154)) * den(47)
  A(162) = cont_QA(wf(:,44),wf(:,156)) * den(51)
  A(163) = cont_QA(wf(:,46),wf(:,156)) * den(53)
  A(164) = cont_QA(wf(:,51),wf(:,157)) * den(58)
  A(165) = cont_QA(wf(:,53),wf(:,157)) * den(60)
  A(166) = cont_QA(wf(:,55),wf(:,159)) * den(64)
  A(167) = cont_QA(wf(:,57),wf(:,159)) * den(66)
  A(168) = cont_VV(wf(:,59),wf(:,160)) * den(69)
  A(169) = cont_VV(wf(:,60),wf(:,160)) * den(70)
  A(170) = cont_QA(wf(:,61),wf(:,156)) * den(71)
  A(171) = cont_QA(wf(:,62),wf(:,156)) * den(72)
  A(172) = cont_VV(wf(:,63),wf(:,160)) * den(73)
  A(173) = cont_VV(wf(:,64),wf(:,160)) * den(74)
  A(174) = cont_QA(wf(:,40),wf(:,161)) * den(75)
  A(175) = cont_QA(wf(:,42),wf(:,161)) * den(76)
  A(176) = cont_QA(wf(:,162),wf(:,163)) * den(138)
  A(177) = cont_QA(wf(:,162),wf(:,164)) * den(140)
  A(178) = cont_QA(wf(:,165),wf(:,166)) * den(143)
  A(179) = cont_QA(wf(:,166),wf(:,167)) * den(144)
  A(180) = cont_QA(wf(:,61),wf(:,168)) * den(71)
  A(181) = cont_QA(wf(:,62),wf(:,168)) * den(72)
  A(182) = cont_VV(wf(:,58),wf(:,169)) * den(69)
  A(183) = cont_VV(wf(:,58),wf(:,170)) * den(70)
  A(184) = cont_QA(wf(:,65),wf(:,171)) * den(75)
  A(185) = cont_QA(wf(:,65),wf(:,172)) * den(76)
  A(186) = cont_VV(wf(:,58),wf(:,173)) * den(73)
  A(187) = cont_VV(wf(:,58),wf(:,174)) * den(74)
  A(188) = cont_QA(wf(:,51),wf(:,177)) * den(58)
  A(189) = cont_QA(wf(:,53),wf(:,177)) * den(60)
  A(190) = cont_QA(wf(:,56),wf(:,178)) * den(64)
  A(191) = cont_QA(wf(:,56),wf(:,179)) * den(66)
  A(192) = cont_QA(wf(:,20),wf(:,181)) * den(78)
  A(193) = cont_QA(wf(:,22),wf(:,181)) * den(79)
  A(194) = cont_QA(wf(:,7),wf(:,182)) * den(80)
  A(195) = cont_QA(wf(:,11),wf(:,182)) * den(81)
  A(196) = cont_VV(wf(:,72),wf(:,169)) * den(88)
  A(197) = cont_VV(wf(:,72),wf(:,170)) * den(89)
  A(198) = cont_VV(wf(:,72),wf(:,173)) * den(90)
  A(199) = cont_VV(wf(:,72),wf(:,174)) * den(91)
  A(200) = cont_VV(wf(:,73),wf(:,169)) * den(93)
  A(201) = cont_VV(wf(:,73),wf(:,170)) * den(94)
  A(202) = cont_VV(wf(:,73),wf(:,173)) * den(95)
  A(203) = cont_VV(wf(:,73),wf(:,174)) * den(96)
  A(204) = cont_QA(wf(:,20),wf(:,184)) * den(83)
  A(205) = cont_QA(wf(:,22),wf(:,184)) * den(84)
  A(206) = cont_QA(wf(:,7),wf(:,185)) * den(85)
  A(207) = cont_QA(wf(:,11),wf(:,185)) * den(86)
  A(208) = cont_QA(wf(:,186),wf(:,187)) * den(147)
  A(209) = cont_QA(wf(:,186),wf(:,188)) * den(149)
  A(210) = cont_QA(wf(:,189),wf(:,190)) * den(152)
  A(211) = cont_QA(wf(:,190),wf(:,191)) * den(153)
  A(212) = cont_VV(wf(:,58),wf(:,192)) * den(73)
  A(213) = cont_VV(wf(:,58),wf(:,193)) * den(74)
  A(214) = cont_QA(wf(:,40),wf(:,195)) * den(75)
  A(215) = cont_QA(wf(:,42),wf(:,195)) * den(76)
  A(216) = cont_VV(wf(:,58),wf(:,197)) * den(69)
  A(217) = cont_VV(wf(:,58),wf(:,199)) * den(70)
  A(218) = cont_QA(wf(:,45),wf(:,200)) * den(71)
  A(219) = cont_QA(wf(:,45),wf(:,201)) * den(72)
  A(220) = cont_QA(wf(:,40),wf(:,204)) * den(45)
  A(221) = cont_QA(wf(:,42),wf(:,204)) * den(47)
  A(222) = cont_QA(wf(:,45),wf(:,205)) * den(51)
  A(223) = cont_QA(wf(:,45),wf(:,206)) * den(53)
  A(224) = cont_QA(wf(:,20),wf(:,208)) * den(83)
  A(225) = cont_QA(wf(:,22),wf(:,208)) * den(84)
  A(226) = cont_QA(wf(:,7),wf(:,209)) * den(85)
  A(227) = cont_QA(wf(:,11),wf(:,209)) * den(86)
  A(228) = cont_VV(wf(:,72),wf(:,192)) * den(90)
  A(229) = cont_VV(wf(:,72),wf(:,193)) * den(91)
  A(230) = cont_VV(wf(:,72),wf(:,197)) * den(88)
  A(231) = cont_VV(wf(:,72),wf(:,199)) * den(89)
  A(232) = cont_VV(wf(:,73),wf(:,192)) * den(95)
  A(233) = cont_VV(wf(:,73),wf(:,193)) * den(96)
  A(234) = cont_VV(wf(:,73),wf(:,197)) * den(93)
  A(235) = cont_VV(wf(:,73),wf(:,199)) * den(94)
  A(236) = cont_QA(wf(:,20),wf(:,211)) * den(78)
  A(237) = cont_QA(wf(:,22),wf(:,211)) * den(79)
  A(238) = cont_QA(wf(:,7),wf(:,212)) * den(80)
  A(239) = cont_QA(wf(:,11),wf(:,212)) * den(81)
  A(240) = cont_QA(wf(:,7),wf(:,214)) * den(7)
  A(241) = cont_QA(wf(:,11),wf(:,214)) * den(10)
  A(242) = cont_QA(wf(:,13),wf(:,216)) * den(14)
  A(243) = cont_QA(wf(:,15),wf(:,216)) * den(16)
  A(244) = cont_QA(wf(:,20),wf(:,217)) * den(21)
  A(245) = cont_QA(wf(:,22),wf(:,217)) * den(23)
  A(246) = cont_QA(wf(:,24),wf(:,219)) * den(27)
  A(247) = cont_QA(wf(:,26),wf(:,219)) * den(29)
  A(248) = cont_QA(wf(:,27),wf(:,216)) * den(30)
  A(249) = cont_QA(wf(:,28),wf(:,216)) * den(31)
  A(250) = cont_VV(wf(:,30),wf(:,220)) * den(34)
  A(251) = cont_VV(wf(:,31),wf(:,220)) * den(35)
  A(252) = cont_QA(wf(:,7),wf(:,221)) * den(36)
  A(253) = cont_QA(wf(:,11),wf(:,221)) * den(37)
  A(254) = cont_VV(wf(:,33),wf(:,220)) * den(38)
  A(255) = cont_VV(wf(:,34),wf(:,220)) * den(39)
  A(256) = cont_QA(wf(:,95),wf(:,223)) * den(155)
  A(257) = cont_QA(wf(:,96),wf(:,223)) * den(156)
  A(258) = cont_QA(wf(:,7),wf(:,224)) * den(158)
  A(259) = cont_QA(wf(:,11),wf(:,224)) * den(159)
  A(260) = cont_QA(wf(:,7),wf(:,227)) * den(162)
  A(261) = cont_QA(wf(:,11),wf(:,227)) * den(163)
  A(262) = cont_QA(wf(:,14),wf(:,228)) * den(165)
  A(263) = cont_QA(wf(:,14),wf(:,229)) * den(167)
  A(264) = cont_QA(wf(:,98),wf(:,230)) * den(168)
  A(265) = cont_QA(wf(:,98),wf(:,231)) * den(169)
  A(266) = cont_QA(wf(:,95),wf(:,232)) * den(170)
  A(267) = cont_QA(wf(:,96),wf(:,232)) * den(171)
  A(268) = cont_QA(wf(:,113),wf(:,233)) * den(172)
  A(269) = cont_QA(wf(:,114),wf(:,233)) * den(173)
  A(270) = cont_QA(wf(:,17),wf(:,234)) * den(175)
  A(271) = cont_QA(wf(:,17),wf(:,235)) * den(177)
  A(272) = cont_QA(wf(:,116),wf(:,236)) * den(178)
  A(273) = cont_QA(wf(:,116),wf(:,237)) * den(179)
  A(274) = cont_QA(wf(:,113),wf(:,238)) * den(180)
  A(275) = cont_QA(wf(:,114),wf(:,238)) * den(181)
  A(276) = cont_QA(wf(:,20),wf(:,241)) * den(184)
  A(277) = cont_QA(wf(:,22),wf(:,241)) * den(185)
  A(278) = cont_QA(wf(:,25),wf(:,242)) * den(187)
  A(279) = cont_QA(wf(:,25),wf(:,243)) * den(189)
  A(280) = cont_QA(wf(:,244),wf(:,245)) * den(191)
  A(281) = cont_QA(wf(:,245),wf(:,246)) * den(192)
  A(282) = cont_QA(wf(:,27),wf(:,247)) * den(194)
  A(283) = cont_QA(wf(:,28),wf(:,247)) * den(195)
  A(284) = cont_VV(wf(:,30),wf(:,248)) * den(198)
  A(285) = cont_VV(wf(:,31),wf(:,248)) * den(200)
  A(286) = cont_VV(wf(:,33),wf(:,248)) * den(202)
  A(287) = cont_VV(wf(:,34),wf(:,248)) * den(204)
  A(288) = cont_QA(wf(:,236),wf(:,250)) * den(206)
  A(289) = cont_QA(wf(:,237),wf(:,250)) * den(207)
  A(290) = cont_QA(wf(:,230),wf(:,252)) * den(209)
  A(291) = cont_QA(wf(:,231),wf(:,252)) * den(210)
  A(292) = cont_QA(wf(:,236),wf(:,254)) * den(212)
  A(293) = cont_QA(wf(:,237),wf(:,254)) * den(213)
  A(294) = cont_QA(wf(:,238),wf(:,255)) * den(215)
  A(295) = cont_QA(wf(:,238),wf(:,256)) * den(217)
  A(296) = cont_VV(wf(:,33),wf(:,257)) * den(218)
  A(297) = cont_VV(wf(:,34),wf(:,257)) * den(219)
  A(298) = cont_QA(wf(:,232),wf(:,258)) * den(221)
  A(299) = cont_QA(wf(:,232),wf(:,259)) * den(223)
  A(300) = cont_VV(wf(:,30),wf(:,257)) * den(224)
  A(301) = cont_VV(wf(:,31),wf(:,257)) * den(225)
  A(302) = cont_QA(wf(:,230),wf(:,260)) * den(227)
  A(303) = cont_QA(wf(:,231),wf(:,260)) * den(228)
  A(304) = cont_VV(wf(:,36),wf(:,263)) * den(231)
  A(305) = cont_VV(wf(:,36),wf(:,264)) * den(233)
  A(306) = cont_QA(wf(:,45),wf(:,265)) * den(235)
  A(307) = cont_QA(wf(:,45),wf(:,266)) * den(237)
  A(308) = cont_QA(wf(:,163),wf(:,268)) * den(239)
  A(309) = cont_QA(wf(:,164),wf(:,268)) * den(240)
  A(310) = cont_QA(wf(:,166),wf(:,269)) * den(241)
  A(311) = cont_QA(wf(:,166),wf(:,270)) * den(242)
  A(312) = cont_QA(wf(:,163),wf(:,271)) * den(243)
  A(313) = cont_QA(wf(:,164),wf(:,271)) * den(244)
  A(314) = cont_QA(wf(:,40),wf(:,272)) * den(246)
  A(315) = cont_QA(wf(:,42),wf(:,272)) * den(247)
  A(316) = cont_QA(wf(:,187),wf(:,273)) * den(248)
  A(317) = cont_QA(wf(:,188),wf(:,273)) * den(249)
  A(318) = cont_QA(wf(:,190),wf(:,274)) * den(250)
  A(319) = cont_QA(wf(:,190),wf(:,275)) * den(251)
  A(320) = cont_QA(wf(:,187),wf(:,276)) * den(252)
  A(321) = cont_QA(wf(:,188),wf(:,276)) * den(253)
  A(322) = cont_VV(wf(:,36),wf(:,279)) * den(256)
  A(323) = cont_VV(wf(:,36),wf(:,280)) * den(258)
  A(324) = cont_QA(wf(:,56),wf(:,281)) * den(260)
  A(325) = cont_QA(wf(:,56),wf(:,282)) * den(262)
  A(326) = cont_QA(wf(:,48),wf(:,283)) * den(264)
  A(327) = cont_QA(wf(:,48),wf(:,284)) * den(266)
  A(328) = cont_QA(wf(:,274),wf(:,286)) * den(268)
  A(329) = cont_QA(wf(:,275),wf(:,286)) * den(269)
  A(330) = cont_QA(wf(:,269),wf(:,288)) * den(271)
  A(331) = cont_QA(wf(:,270),wf(:,288)) * den(272)
  A(332) = cont_QA(wf(:,289),wf(:,290)) * den(274)
  A(333) = cont_QA(wf(:,290),wf(:,291)) * den(275)
  A(334) = cont_QA(wf(:,274),wf(:,293)) * den(277)
  A(335) = cont_QA(wf(:,275),wf(:,293)) * den(278)
  A(336) = cont_VV(wf(:,63),wf(:,294)) * den(281)
  A(337) = cont_VV(wf(:,64),wf(:,294)) * den(283)
  A(338) = cont_QA(wf(:,276),wf(:,295)) * den(285)
  A(339) = cont_QA(wf(:,276),wf(:,296)) * den(287)
  A(340) = cont_QA(wf(:,61),wf(:,297)) * den(289)
  A(341) = cont_QA(wf(:,62),wf(:,297)) * den(290)
  A(342) = cont_VV(wf(:,59),wf(:,294)) * den(292)
  A(343) = cont_VV(wf(:,60),wf(:,294)) * den(294)
  A(344) = cont_QA(wf(:,271),wf(:,298)) * den(296)
  A(345) = cont_QA(wf(:,271),wf(:,299)) * den(298)
  A(346) = cont_QA(wf(:,269),wf(:,300)) * den(300)
  A(347) = cont_QA(wf(:,270),wf(:,300)) * den(301)
  A(348) = cont_VV(wf(:,59),wf(:,301)) * den(302)
  A(349) = cont_VV(wf(:,60),wf(:,301)) * den(303)
  A(350) = cont_VV(wf(:,63),wf(:,301)) * den(304)
  A(351) = cont_VV(wf(:,64),wf(:,301)) * den(305)
  A(352) = cont_VV(wf(:,30),wf(:,302)) * den(307)
  A(353) = cont_VV(wf(:,31),wf(:,302)) * den(308)
  A(354) = cont_VV(wf(:,33),wf(:,302)) * den(309)
  A(355) = cont_VV(wf(:,34),wf(:,302)) * den(310)
  A(356) = cont_VV(wf(:,33),wf(:,303)) * den(311)
  A(357) = cont_VV(wf(:,34),wf(:,303)) * den(312)
  A(358) = cont_VV(wf(:,30),wf(:,303)) * den(313)
  A(359) = cont_VV(wf(:,31),wf(:,303)) * den(314)
  A(360) = cont_QA(wf(:,236),wf(:,304)) * den(316)
  A(361) = cont_QA(wf(:,237),wf(:,304)) * den(317)
  A(362) = cont_QA(wf(:,230),wf(:,305)) * den(319)
  A(363) = cont_QA(wf(:,231),wf(:,305)) * den(320)
  A(364) = cont_VV(wf(:,30),wf(:,306)) * den(322)
  A(365) = cont_VV(wf(:,31),wf(:,306)) * den(323)
  A(366) = cont_VV(wf(:,33),wf(:,306)) * den(324)
  A(367) = cont_VV(wf(:,34),wf(:,306)) * den(325)
  A(368) = cont_VV(wf(:,33),wf(:,307)) * den(326)
  A(369) = cont_VV(wf(:,34),wf(:,307)) * den(327)
  A(370) = cont_VV(wf(:,30),wf(:,307)) * den(328)
  A(371) = cont_VV(wf(:,31),wf(:,307)) * den(329)
  A(372) = cont_QA(wf(:,236),wf(:,308)) * den(331)
  A(373) = cont_QA(wf(:,237),wf(:,308)) * den(332)
  A(374) = cont_QA(wf(:,230),wf(:,309)) * den(334)
  A(375) = cont_QA(wf(:,231),wf(:,309)) * den(335)
  A(376) = cont_QA(wf(:,274),wf(:,311)) * den(337)
  A(377) = cont_QA(wf(:,275),wf(:,311)) * den(338)
  A(378) = cont_QA(wf(:,269),wf(:,313)) * den(340)
  A(379) = cont_QA(wf(:,270),wf(:,313)) * den(341)
  A(380) = cont_VV(wf(:,63),wf(:,314)) * den(342)
  A(381) = cont_VV(wf(:,64),wf(:,314)) * den(343)
  A(382) = cont_VV(wf(:,59),wf(:,314)) * den(344)
  A(383) = cont_VV(wf(:,60),wf(:,314)) * den(345)
  A(384) = cont_VV(wf(:,59),wf(:,315)) * den(346)
  A(385) = cont_VV(wf(:,60),wf(:,315)) * den(347)
  A(386) = cont_VV(wf(:,63),wf(:,315)) * den(348)
  A(387) = cont_VV(wf(:,64),wf(:,315)) * den(349)
  A(388) = cont_QA(wf(:,274),wf(:,317)) * den(351)
  A(389) = cont_QA(wf(:,275),wf(:,317)) * den(352)
  A(390) = cont_QA(wf(:,269),wf(:,319)) * den(354)
  A(391) = cont_QA(wf(:,270),wf(:,319)) * den(355)
  A(392) = cont_VV(wf(:,63),wf(:,320)) * den(356)
  A(393) = cont_VV(wf(:,64),wf(:,320)) * den(357)
  A(394) = cont_VV(wf(:,59),wf(:,320)) * den(358)
  A(395) = cont_VV(wf(:,60),wf(:,320)) * den(359)
  A(396) = cont_VV(wf(:,59),wf(:,321)) * den(360)
  A(397) = cont_VV(wf(:,60),wf(:,321)) * den(361)
  A(398) = cont_VV(wf(:,63),wf(:,321)) * den(362)
  A(399) = cont_VV(wf(:,64),wf(:,321)) * den(363)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(399)
  complex(REALKIND), intent(out) :: M1(4), M2(4)

  M1(1) = ((A(17)+A(19)+A(21)+A(23)+A(27)+A(31)+A(33)+A(35)+A(37)+A(39))*f(1))/6._/**/REALKIND+((-A(18)-A(20)-A(22)-A(24)-A(28) &
       -A(32)-A(34)-A(36)-A(38)-A(40))*f(2))/6._/**/REALKIND
  M1(2) = ((-A(1)-A(3)-A(9)-A(21)-A(23)-A(31)-A(37)-A(39)-A(41)-A(43))*f(1))/2._/**/REALKIND+((A(2)+A(4)+A(10)+A(22)+A(24)+A(32) &
       +A(38)+A(40)+A(42)+A(44))*f(2))/2._/**/REALKIND+(CI*(-A(11)-A(15)+A(25)+A(29))*f(3))/2._/**/REALKIND+(CI*(A(12)+A(16)-A(26) &
       -A(30))*f(4))/2._/**/REALKIND
  M1(3) = ((-A(5)-A(7)-A(13)-A(17)-A(19)-A(27)-A(33)-A(35)-A(45)-A(47))*f(1))/2._/**/REALKIND+((A(6)+A(8)+A(14)+A(18)+A(20)+A(28) &
       +A(34)+A(36)+A(46)+A(48))*f(2))/2._/**/REALKIND+(CI*(A(11)+A(15)-A(25)-A(29))*f(3))/2._/**/REALKIND+(CI*(-A(12)-A(16)+A(26) &
       +A(30))*f(4))/2._/**/REALKIND
  M1(4) = ((A(1)+A(3)+A(5)+A(7)+A(9)+A(13)+A(41)+A(43)+A(45)+A(47))*f(1))/6._/**/REALKIND+((-A(2)-A(4)-A(6)-A(8)-A(10)-A(14)-A(42) &
       -A(44)-A(46)-A(48))*f(2))/6._/**/REALKIND

  M2(1) = ((-A(304)-A(306)-A(308)-A(310)-A(312)-A(314)-A(316)-A(318)-A(320)-A(322)-A(324)-A(326)-A(332)-A(334)-A(338)-A(340) &
       -A(344)-A(346)-A(352)-A(354)-A(356)-A(358)-A(360)-A(362)-A(364)-A(366)-A(368)-A(370)-A(372)-A(374))*f(5))/6._/**/REALKIND &
       +((-A(49)-A(50)-A(51)-A(52))*f(6))/12._/**/REALKIND+((A(305)+A(307)+A(309)+A(311)+A(313)+A(315)+A(317)+A(319)+A(321)+A(323) &
       +A(325)+A(327)+A(333)+A(335)+A(339)+A(341)+A(345)+A(347)+A(353)+A(355)+A(357)+A(359)+A(361)+A(363)+A(365)+A(367)+A(369) &
       +A(371)+A(373)+A(375))*f(6))/6._/**/REALKIND+((A(108)+A(113)+A(120)+A(124)+A(176)+A(180)+A(188)+A(190)+A(192)+A(194)+A(204) &
       +A(206)+A(208)+A(214)+A(220)+A(222)+A(224)+A(226)+A(236)+A(238))*f(9))/6._/**/REALKIND+((-A(109)-A(114)-A(121)-A(125) &
       -A(177)-A(181)-A(189)-A(191)-A(193)-A(195)-A(205)-A(207)-A(209)-A(215)-A(221)-A(223)-A(225)-A(227)-A(237) &
       -A(239))*f(10))/6._/**/REALKIND+((A(128)+A(132)+A(144)+A(148)+A(160)+A(162)+A(164)+A(166)+A(170) &
       +A(174))*f(13))/6._/**/REALKIND+((-A(129)-A(133)-A(145)-A(149)-A(161)-A(163)-A(165)-A(167)-A(171) &
       -A(175))*f(14))/6._/**/REALKIND+((A(111)+A(116)+A(178)+A(184)+A(210)+A(218))*f(17))/6._/**/REALKIND+((-A(112)-A(117)-A(179) &
       -A(185)-A(211)-A(219))*f(18))/6._/**/REALKIND+((A(130)+A(134)+A(146)+A(150))*f(21))/6._/**/REALKIND+((-A(131)-A(135)-A(147) &
       -A(151))*f(22))/6._/**/REALKIND+((A(110)+A(115)+A(126)+A(127))*f(28))/6._/**/REALKIND
  M2(2) = ((A(256)+A(258)+A(260)+A(262)+A(264)+A(266)+A(282)+A(292)+A(298)+A(316)+A(318)+A(320)+A(322)+A(324)+A(326)+A(332)+A(338) &
       +A(346)+A(364)+A(366)+A(368)+A(370)+A(372)+A(374)+A(376)+A(378)+A(380)+A(382)+A(384)+A(386))*f(5))/2._/**/REALKIND+((A(49) &
       +A(51))*f(6))/4._/**/REALKIND+((-A(257)-A(259)-A(261)-A(263)-A(265)-A(267)-A(283)-A(293)-A(299)-A(317)-A(319)-A(321)-A(323) &
       -A(325)-A(327)-A(333)-A(339)-A(347)-A(365)-A(367)-A(369)-A(371)-A(373)-A(375)-A(377)-A(379)-A(381)-A(383)-A(385) &
       -A(387))*f(6))/2._/**/REALKIND+(CI*(A(284)+A(286)+A(288)+A(290)+A(296)+A(300)-A(328)-A(330)-A(336)-A(342)-A(348) &
       -A(350))*f(7))/2._/**/REALKIND+(CI*(-A(285)-A(287)-A(289)-A(291)-A(297)-A(301)+A(329)+A(331)+A(337)+A(343)+A(349) &
       +A(351))*f(8))/2._/**/REALKIND+((-A(113)-A(124)-A(188)-A(190)-A(196)-A(204)-A(206)-A(208)-A(214)-A(224)-A(226)-A(228) &
       -A(240)-A(242)-A(248))*f(9))/2._/**/REALKIND+((A(114)+A(125)+A(189)+A(191)+A(197)+A(205)+A(207)+A(209)+A(215)+A(225)+A(227) &
       +A(229)+A(241)+A(243)+A(249))*f(10))/2._/**/REALKIND+(CI*(A(182)+A(212)-A(250)-A(254))*f(11))/2._/**/REALKIND+(CI*(-A(183) &
       -A(213)+A(251)+A(255))*f(12))/2._/**/REALKIND+((-A(56)-A(66)-A(76)-A(82)-A(104)-A(106)-A(132)-A(136)-A(138)-A(148)-A(156) &
       -A(158)-A(164)-A(166)-A(174))*f(13))/2._/**/REALKIND+((A(57)+A(67)+A(77)+A(83)+A(105)+A(107)+A(133)+A(137)+A(139)+A(149) &
       +A(157)+A(159)+A(165)+A(167)+A(175))*f(14))/2._/**/REALKIND+(CI*(-A(80)-A(96)+A(168)+A(172))*f(15))/2._/**/REALKIND &
       +(CI*(A(81)+A(97)-A(169)-A(173))*f(16))/2._/**/REALKIND+((-A(116)-A(184)-A(198)-A(210)-A(230))*f(17))/2._/**/REALKIND &
       +((A(117)+A(185)+A(199)+A(211)+A(231))*f(18))/2._/**/REALKIND+(CI*(A(186)+A(216))*f(19))/2._/**/REALKIND+(CI*(-A(187) &
       -A(217))*f(20))/2._/**/REALKIND+((-A(58)-A(78)-A(100)-A(134)-A(150))*f(21))/2._/**/REALKIND+((A(59)+A(79)+A(101)+A(135) &
       +A(151))*f(22))/2._/**/REALKIND+(CI*(-A(86)-A(102))*f(23))/2._/**/REALKIND+(CI*(A(87)+A(103))*f(24))/2._/**/REALKIND+(CI*( &
       -A(68)-A(72)+A(118)+A(122))*f(25))/2._/**/REALKIND+(CI*(A(69)+A(73)-A(119)-A(123))*f(26))/2._/**/REALKIND+(CI*(A(53)-A(54) &
       -A(55))*f(27))/2._/**/REALKIND+((-A(60)-A(75)-A(115)-A(126))*f(28))/2._/**/REALKIND
  M2(3) = ((A(268)+A(270)+A(272)+A(274)+A(276)+A(278)+A(280)+A(294)+A(302)+A(304)+A(306)+A(308)+A(310)+A(312)+A(314)+A(334)+A(340) &
       +A(344)+A(352)+A(354)+A(356)+A(358)+A(360)+A(362)+A(388)+A(390)+A(392)+A(394)+A(396)+A(398))*f(5))/2._/**/REALKIND+((A(50) &
       +A(52))*f(6))/4._/**/REALKIND+((-A(269)-A(271)-A(273)-A(275)-A(277)-A(279)-A(281)-A(295)-A(303)-A(305)-A(307)-A(309)-A(311) &
       -A(313)-A(315)-A(335)-A(341)-A(345)-A(353)-A(355)-A(357)-A(359)-A(361)-A(363)-A(389)-A(391)-A(393)-A(395)-A(397) &
       -A(399))*f(6))/2._/**/REALKIND+(CI*(-A(284)-A(286)-A(288)-A(290)-A(296)-A(300)+A(328)+A(330)+A(336)+A(342)+A(348) &
       +A(350))*f(7))/2._/**/REALKIND+(CI*(A(285)+A(287)+A(289)+A(291)+A(297)+A(301)-A(329)-A(331)-A(337)-A(343)-A(349) &
       -A(351))*f(8))/2._/**/REALKIND+((-A(108)-A(120)-A(176)-A(180)-A(192)-A(194)-A(200)-A(220)-A(222)-A(232)-A(236)-A(238) &
       -A(244)-A(246)-A(252))*f(9))/2._/**/REALKIND+((A(109)+A(121)+A(177)+A(181)+A(193)+A(195)+A(201)+A(221)+A(223)+A(233)+A(237) &
       +A(239)+A(245)+A(247)+A(253))*f(10))/2._/**/REALKIND+(CI*(-A(182)-A(212)+A(250)+A(254))*f(11))/2._/**/REALKIND+(CI*(A(183) &
       +A(213)-A(251)-A(255))*f(12))/2._/**/REALKIND+((-A(61)-A(70)-A(88)-A(90)-A(92)-A(98)-A(128)-A(140)-A(142)-A(144)-A(152) &
       -A(154)-A(160)-A(162)-A(170))*f(13))/2._/**/REALKIND+((A(62)+A(71)+A(89)+A(91)+A(93)+A(99)+A(129)+A(141)+A(143)+A(145) &
       +A(153)+A(155)+A(161)+A(163)+A(171))*f(14))/2._/**/REALKIND+(CI*(A(80)+A(96)-A(168)-A(172))*f(15))/2._/**/REALKIND+(CI*( &
       -A(81)-A(97)+A(169)+A(173))*f(16))/2._/**/REALKIND+((-A(111)-A(178)-A(202)-A(218)-A(234))*f(17))/2._/**/REALKIND+((A(112) &
       +A(179)+A(203)+A(219)+A(235))*f(18))/2._/**/REALKIND+(CI*(-A(186)-A(216))*f(19))/2._/**/REALKIND+(CI*(A(187) &
       +A(217))*f(20))/2._/**/REALKIND+((-A(63)-A(84)-A(94)-A(130)-A(146))*f(21))/2._/**/REALKIND+((A(64)+A(85)+A(95)+A(131) &
       +A(147))*f(22))/2._/**/REALKIND+(CI*(A(86)+A(102))*f(23))/2._/**/REALKIND+(CI*(-A(87)-A(103))*f(24))/2._/**/REALKIND &
       +(CI*(A(68)+A(72)-A(118)-A(122))*f(25))/2._/**/REALKIND+(CI*(-A(69)-A(73)+A(119)+A(123))*f(26))/2._/**/REALKIND+(CI*(-A(53) &
       +A(54)+A(55))*f(27))/2._/**/REALKIND+((-A(65)-A(74)-A(110)-A(127))*f(28))/2._/**/REALKIND
  M2(4) = ((-A(256)-A(258)-A(260)-A(262)-A(264)-A(266)-A(268)-A(270)-A(272)-A(274)-A(276)-A(278)-A(280)-A(282)-A(292)-A(294) &
       -A(298)-A(302)-A(376)-A(378)-A(380)-A(382)-A(384)-A(386)-A(388)-A(390)-A(392)-A(394)-A(396)-A(398))*f(5))/6._/**/REALKIND &
       +((-A(49)-A(50)-A(51)-A(52))*f(6))/12._/**/REALKIND+((A(257)+A(259)+A(261)+A(263)+A(265)+A(267)+A(269)+A(271)+A(273)+A(275) &
       +A(277)+A(279)+A(281)+A(283)+A(293)+A(295)+A(299)+A(303)+A(377)+A(379)+A(381)+A(383)+A(385)+A(387)+A(389)+A(391)+A(393) &
       +A(395)+A(397)+A(399))*f(6))/6._/**/REALKIND+((A(196)+A(200)+A(228)+A(232)+A(240)+A(242)+A(244)+A(246)+A(248) &
       +A(252))*f(9))/6._/**/REALKIND+((-A(197)-A(201)-A(229)-A(233)-A(241)-A(243)-A(245)-A(247)-A(249) &
       -A(253))*f(10))/6._/**/REALKIND+((A(56)+A(61)+A(66)+A(70)+A(76)+A(82)+A(88)+A(90)+A(92)+A(98)+A(104)+A(106)+A(136)+A(138) &
       +A(140)+A(142)+A(152)+A(154)+A(156)+A(158))*f(13))/6._/**/REALKIND+((-A(57)-A(62)-A(67)-A(71)-A(77)-A(83)-A(89)-A(91)-A(93) &
       -A(99)-A(105)-A(107)-A(137)-A(139)-A(141)-A(143)-A(153)-A(155)-A(157)-A(159))*f(14))/6._/**/REALKIND+((A(198)+A(202)+A(230) &
       +A(234))*f(17))/6._/**/REALKIND+((-A(199)-A(203)-A(231)-A(235))*f(18))/6._/**/REALKIND+((A(58)+A(63)+A(78)+A(84)+A(94) &
       +A(100))*f(21))/6._/**/REALKIND+((-A(59)-A(64)-A(79)-A(85)-A(95)-A(101))*f(22))/6._/**/REALKIND+((A(60)+A(65)+A(74) &
       +A(75))*f(28))/6._/**/REALKIND

end subroutine colourvectors

end module ol_loop_ppllttj_eexuuxttxg_1_/**/REALKIND
