
module ol_vamp_1_ppllllj_nenexnmxmudxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj_nenexnmxmudxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj_nenexnmxmudxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj_nenexnmxmudxg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj_nenexnmxmudxg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(1)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,32) :: G0
  complex(REALKIND), dimension(4,5,4,90) :: G1
  complex(REALKIND), dimension(4,15,4,104) :: G2
  complex(REALKIND), dimension(4,35,4,38) :: G3
  complex(REALKIND), dimension(4,70,4,8) :: G4
  complex(REALKIND), dimension(5,20) :: G1tensor
  complex(REALKIND), dimension(15,48) :: G2tensor
  complex(REALKIND), dimension(35,44) :: G3tensor
  complex(REALKIND), dimension(70,8) :: G4tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,80),ZERO,G1(:,:,:,1))
  call loop_QW_A(G1(:,:,:,1),wf(:,5),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,92),ZERO,G2(:,:,:,1))
  call check_last_QA_V(l_switch,G2(:,:,:,1),wf(:,9),G2tensor(:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,4),G2(:,:,:,2),gZd)
  call loop_Q_A(G2(:,:,:,2),Q(:,95),ZERO,G3(:,:,:,1))
  call check_last_QA_V(l_switch,G3(:,:,:,1),wf(:,-5),G3tensor(:,1))
  call loop_QZ_A(G1(:,:,:,1),wf(:,4),G1(:,:,:,3),gZu)
  call loop_Q_A(G1(:,:,:,3),Q(:,83),ZERO,G2(:,:,:,3))
  call check_last_QA_V(l_switch,G2(:,:,:,3),wf(:,12),G2tensor(:,2))
  call loop_QW_A(G2(:,:,:,3),wf(:,5),G2(:,:,:,4))
  call loop_Q_A(G2(:,:,:,4),Q(:,95),ZERO,G3(:,:,:,2))
  call check_last_QA_V(l_switch,G3(:,:,:,2),wf(:,-5),G3tensor(:,2))
  call loop_QW_A(G1(:,:,:,1),wf(:,47),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,95),ZERO,G2(:,:,:,5))
  call check_last_QA_V(l_switch,G2(:,:,:,5),wf(:,-5),G2tensor(:,3))
  call loop_QW_A(G1(:,:,:,1),wf(:,97),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,95),ZERO,G2(:,:,:,6))
  call check_last_QA_V(l_switch,G2(:,:,:,6),wf(:,-5),G2tensor(:,4))
  call loop_QW_A(G1(:,:,:,1),wf(:,98),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,95),ZERO,G2(:,:,:,7))
  call check_last_QA_V(l_switch,G2(:,:,:,7),wf(:,-5),G2tensor(:,5))
  call loop_QW_A(G1(:,:,:,1),wf(:,99),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,95),ZERO,G2(:,:,:,8))
  call check_last_QA_V(l_switch,G2(:,:,:,8),wf(:,-5),G2tensor(:,6))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,103),G1tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,107),G1tensor(:,2))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,111),G1tensor(:,3))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,115),G1tensor(:,4))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,119),G1tensor(:,5))
  call check_last_QA_V(l_switch,G1(:,:,:,1),wf(:,123),G1tensor(:,6))
  call loop_VQ_A(G0(:,:,:,1),wf(:,49),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,83),ZERO,G1(:,:,:,8))
  call loop_QW_A(G1(:,:,:,8),wf(:,5),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,95),ZERO,G2(:,:,:,9))
  call check_last_QA_V(l_switch,G2(:,:,:,9),wf(:,-5),G2tensor(:,7))
  call check_last_QA_V(l_switch,G1(:,:,:,8),wf(:,12),G1tensor(:,7))
  call loop_VQ_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,92),ZERO,G1(:,:,:,10))
  call loop_QZ_A(G1(:,:,:,10),wf(:,4),G1(:,:,:,11),gZd)
  call loop_Q_A(G1(:,:,:,11),Q(:,95),ZERO,G2(:,:,:,10))
  call check_last_QA_V(l_switch,G2(:,:,:,10),wf(:,-5),G2tensor(:,8))
  call check_last_QA_V(l_switch,G1(:,:,:,10),wf(:,9),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,17),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,96),ZERO,G1(:,:,:,12))
  call loop_AW_Q(G1(:,:,:,12),wf(:,5),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,108),ZERO,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,20),G2tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,4),G2(:,:,:,12),gZu)
  call loop_A_Q(G2(:,:,:,12),Q(:,111),ZERO,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-4),G3tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,12),wf(:,4),G1(:,:,:,14),gZd)
  call loop_A_Q(G1(:,:,:,14),Q(:,99),ZERO,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,23),G2tensor(:,10))
  call loop_AW_Q(G2(:,:,:,13),wf(:,5),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,111),ZERO,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-4),G3tensor(:,4))
  call loop_AW_Q(G1(:,:,:,12),wf(:,47),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,111),ZERO,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,-4),G2tensor(:,11))
  call loop_AW_Q(G1(:,:,:,12),wf(:,97),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,111),ZERO,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,-4),G2tensor(:,12))
  call loop_AW_Q(G1(:,:,:,12),wf(:,98),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,111),ZERO,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,-4),G2tensor(:,13))
  call loop_AW_Q(G1(:,:,:,12),wf(:,99),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,111),ZERO,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-4),G2tensor(:,14))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,101),G1tensor(:,9))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,105),G1tensor(:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,109),G1tensor(:,11))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,113),G1tensor(:,12))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,117),G1tensor(:,13))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,121),G1tensor(:,14))
  call loop_VA_Q(G0(:,:,:,1),wf(:,62),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,99),ZERO,G1(:,:,:,19))
  call loop_AW_Q(G1(:,:,:,19),wf(:,5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,111),ZERO,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,-4),G2tensor(:,15))
  call check_last_AQ_V(l_switch,G1(:,:,:,19),wf(:,23),G1tensor(:,15))
  call loop_VA_Q(G0(:,:,:,1),wf(:,64),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,108),ZERO,G1(:,:,:,21))
  call loop_AZ_Q(G1(:,:,:,21),wf(:,4),G1(:,:,:,22),gZu)
  call loop_A_Q(G1(:,:,:,22),Q(:,111),ZERO,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,-4),G2tensor(:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,21),wf(:,20),G1tensor(:,16))
  call loop_VA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,44),ZERO,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-6),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,108),ZERO,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,20),G2tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,4),G2(:,:,:,22),gZu)
  call loop_A_Q(G2(:,:,:,22),Q(:,111),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-4),G3tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,23),wf(:,4),G1(:,:,:,25),gZu)
  call loop_A_Q(G1(:,:,:,25),Q(:,47),ZERO,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-6),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,111),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-4),G3tensor(:,6))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-6),Q(:,64),G1(:,:,:,26))
  call loop_VA_Q(G1(:,:,:,26),wf(:,12),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,108),ZERO,G2(:,:,:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,25),wf(:,20),G2tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,4),G2(:,:,:,26),gZu)
  call loop_A_Q(G2(:,:,:,26),Q(:,111),ZERO,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-4),G3tensor(:,7))
  call loop_VA_Q(G1(:,:,:,26),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,96),ZERO,G2(:,:,:,27))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,101),G2tensor(:,19))
  call loop_AW_Q(G2(:,:,:,27),wf(:,5),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,108),ZERO,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,20),G3tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,8),wf(:,4),G3(:,:,:,9),gZu)
  call loop_A_Q(G3(:,:,:,9),Q(:,111),ZERO,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,-4),G4tensor(:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,105),G2tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,27),wf(:,4),G2(:,:,:,29),gZd)
  call loop_A_Q(G2(:,:,:,29),Q(:,99),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,23),G3tensor(:,9))
  call loop_AW_Q(G3(:,:,:,10),wf(:,5),G3(:,:,:,11))
  call loop_A_Q(G3(:,:,:,11),Q(:,111),ZERO,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,-4),G4tensor(:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,109),G2tensor(:,21))
  call loop_AW_Q(G2(:,:,:,27),wf(:,47),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,111),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-4),G3tensor(:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,113),G2tensor(:,22))
  call loop_AW_Q(G2(:,:,:,27),wf(:,97),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,111),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-4),G3tensor(:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,117),G2tensor(:,23))
  call loop_AW_Q(G2(:,:,:,27),wf(:,98),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,111),ZERO,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-4),G3tensor(:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,27),wf(:,121),G2tensor(:,24))
  call loop_AW_Q(G2(:,:,:,27),wf(:,99),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,111),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-4),G3tensor(:,13))
  call loop_VA_Q(G1(:,:,:,26),wf(:,9),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,99),ZERO,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,23),G2tensor(:,25))
  call loop_AW_Q(G2(:,:,:,34),wf(:,5),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,111),ZERO,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-4),G3tensor(:,14))
  call loop_VA_Q(G1(:,:,:,26),wf(:,103),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,111),ZERO,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,-4),G2tensor(:,26))
  call loop_VA_Q(G1(:,:,:,26),wf(:,107),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,111),ZERO,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,-4),G2tensor(:,27))
  call loop_VA_Q(G1(:,:,:,26),wf(:,111),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,111),ZERO,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,-4),G2tensor(:,28))
  call loop_VA_Q(G1(:,:,:,26),wf(:,115),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,111),ZERO,G2(:,:,:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,39),wf(:,-4),G2tensor(:,29))
  call loop_VA_Q(G1(:,:,:,26),wf(:,119),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,111),ZERO,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,-4),G2tensor(:,30))
  call loop_VA_Q(G1(:,:,:,26),wf(:,123),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,111),ZERO,G2(:,:,:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,41),wf(:,-4),G2tensor(:,31))
  call loop_VQ_A(G0(:,:,:,1),wf(:,95),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,83),ZERO,G1(:,:,:,36))
  call loop_QW_A(G1(:,:,:,36),wf(:,5),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,95),ZERO,G2(:,:,:,42))
  call check_last_QA_V(l_switch,G2(:,:,:,42),wf(:,-5),G2tensor(:,32))
  call check_last_QA_V(l_switch,G1(:,:,:,36),wf(:,12),G1tensor(:,17))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,32),ZERO,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-6),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,96),ZERO,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,101),G2tensor(:,33))
  call loop_AW_Q(G2(:,:,:,43),wf(:,5),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,108),ZERO,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,20),G3tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,17),wf(:,4),G3(:,:,:,18),gZu)
  call loop_A_Q(G3(:,:,:,18),Q(:,111),ZERO,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,-4),G4tensor(:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,105),G2tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,4),G2(:,:,:,45),gZd)
  call loop_A_Q(G2(:,:,:,45),Q(:,99),ZERO,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,23),G3tensor(:,16))
  call loop_AW_Q(G3(:,:,:,19),wf(:,5),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,111),ZERO,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,-4),G4tensor(:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,109),G2tensor(:,35))
  call loop_AW_Q(G2(:,:,:,43),wf(:,47),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,111),ZERO,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,-4),G3tensor(:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,113),G2tensor(:,36))
  call loop_AW_Q(G2(:,:,:,43),wf(:,97),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,111),ZERO,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-4),G3tensor(:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,117),G2tensor(:,37))
  call loop_AW_Q(G2(:,:,:,43),wf(:,98),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,111),ZERO,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,-4),G3tensor(:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,121),G2tensor(:,38))
  call loop_AW_Q(G2(:,:,:,43),wf(:,99),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,111),ZERO,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,-4),G3tensor(:,20))
  call loop_AW_Q(G1(:,:,:,38),wf(:,5),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,44),ZERO,G2(:,:,:,50))
  call loop_AV_Q(G2(:,:,:,50),wf(:,-6),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,108),ZERO,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,20),G3tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,25),wf(:,4),G3(:,:,:,26),gZu)
  call loop_A_Q(G3(:,:,:,26),Q(:,111),ZERO,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,-4),G4tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,50),wf(:,4),G2(:,:,:,52),gZu)
  call loop_A_Q(G2(:,:,:,52),Q(:,47),ZERO,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,-6),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,111),ZERO,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,-4),G4tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,38),wf(:,4),G1(:,:,:,41),gZd)
  call loop_A_Q(G1(:,:,:,41),Q(:,35),ZERO,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-6),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,99),ZERO,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,23),G3tensor(:,22))
  call loop_AW_Q(G3(:,:,:,29),wf(:,5),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,111),ZERO,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-4),G4tensor(:,7))
  call loop_AW_Q(G2(:,:,:,53),wf(:,5),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,47),ZERO,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,-6),G3(:,:,:,32))
  call loop_A_Q(G3(:,:,:,32),Q(:,111),ZERO,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,-4),G4tensor(:,8))
  call loop_AW_Q(G1(:,:,:,38),wf(:,47),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,47),ZERO,G2(:,:,:,56))
  call loop_AV_Q(G2(:,:,:,56),wf(:,-6),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,111),ZERO,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,-4),G3tensor(:,23))
  call loop_AW_Q(G1(:,:,:,38),wf(:,97),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,47),ZERO,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,-6),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,111),ZERO,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,-4),G3tensor(:,24))
  call loop_AW_Q(G1(:,:,:,38),wf(:,98),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,47),ZERO,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-6),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,111),ZERO,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-4),G3tensor(:,25))
  call loop_AW_Q(G1(:,:,:,38),wf(:,99),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,47),ZERO,G2(:,:,:,62))
  call loop_AV_Q(G2(:,:,:,62),wf(:,-6),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,111),ZERO,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,-4),G3tensor(:,26))
  call loop_VA_Q(G0(:,:,:,1),wf(:,9),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,35),ZERO,G1(:,:,:,46))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-6),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,99),ZERO,G2(:,:,:,64))
  call check_last_AQ_V(l_switch,G2(:,:,:,64),wf(:,23),G2tensor(:,39))
  call loop_AW_Q(G2(:,:,:,64),wf(:,5),G2(:,:,:,65))
  call loop_A_Q(G2(:,:,:,65),Q(:,111),ZERO,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,-4),G3tensor(:,27))
  call loop_AW_Q(G1(:,:,:,46),wf(:,5),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,47),ZERO,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-6),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,111),ZERO,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,-4),G3tensor(:,28))
  call loop_VA_Q(G0(:,:,:,1),wf(:,94),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,99),ZERO,G1(:,:,:,49))
  call loop_AW_Q(G1(:,:,:,49),wf(:,5),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,111),ZERO,G2(:,:,:,68))
  call check_last_AQ_V(l_switch,G2(:,:,:,68),wf(:,-4),G2tensor(:,40))
  call check_last_AQ_V(l_switch,G1(:,:,:,49),wf(:,23),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,1),wf(:,103),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,47),ZERO,G1(:,:,:,51))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-6),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,111),ZERO,G2(:,:,:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,-4),G2tensor(:,41))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,60),ZERO,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-6),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,124),ZERO,G2(:,:,:,70))
  call loop_AZ_Q(G2(:,:,:,70),wf(:,4),G2(:,:,:,71),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,70),wf(:,4),G2(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,60),MT,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-6),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,124),MT,G2(:,:,:,73))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,4),G2(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),MT,G3tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,60),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,-6),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,124),ZERO,G2(:,:,:,75))
  call loop_QZ_A(G2(:,:,:,75),wf(:,4),G2(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,127),ZERO,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,75),wf(:,4),G2(:,:,:,77),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,127),ZERO,G3tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,60),MT,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-6),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,124),MT,G2(:,:,:,78))
  call loop_QZ_A(G2(:,:,:,78),wf(:,4),G2(:,:,:,79),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,127),MT,G3tensor(:,34))
  call loop_AV_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,60),MB,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-6),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,124),MB,G2(:,:,:,80))
  call loop_AZ_Q(G2(:,:,:,80),wf(:,4),G2(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,60),MB,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,-6),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,124),MB,G2(:,:,:,82))
  call loop_QZ_A(G2(:,:,:,82),wf(:,4),G2(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,36))
  call loop_VQ_A(G0(:,:,:,1),wf(:,96),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,92),ZERO,G1(:,:,:,65))
  call loop_QZ_A(G1(:,:,:,65),wf(:,4),G1(:,:,:,66),gZd)
  call loop_Q_A(G1(:,:,:,66),Q(:,95),ZERO,G2(:,:,:,84))
  call check_last_QA_V(l_switch,G2(:,:,:,84),wf(:,-5),G2tensor(:,42))
  call check_last_QA_V(l_switch,G1(:,:,:,65),wf(:,9),G1tensor(:,19))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,60),ZERO,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-6),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,124),ZERO,G2(:,:,:,85))
  call loop_AZ_Q(G2(:,:,:,85),wf(:,4),G2(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,127),ZERO,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,85),wf(:,4),G2(:,:,:,87),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,87),Q(:,127),ZERO,G3tensor(:,38))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,60),MT,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-6),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,124),MT,G2(:,:,:,88))
  call loop_AZ_Q(G2(:,:,:,88),wf(:,4),G2(:,:,:,89),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,89),Q(:,127),MT,G3tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,60),ZERO,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-6),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,124),ZERO,G2(:,:,:,90))
  call loop_QZ_A(G2(:,:,:,90),wf(:,4),G2(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,127),ZERO,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,90),wf(:,4),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,127),ZERO,G3tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,60),MT,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,-6),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,124),MT,G2(:,:,:,93))
  call loop_QZ_A(G2(:,:,:,93),wf(:,4),G2(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,127),MT,G3tensor(:,42))
  call loop_AV_Q(G0(:,:,:,1),wf(:,45),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,60),MB,G1(:,:,:,75))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-6),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,124),MB,G2(:,:,:,95))
  call loop_AZ_Q(G2(:,:,:,95),wf(:,4),G2(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,127),MB,G3tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,45),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,60),MB,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,-6),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,124),MB,G2(:,:,:,97))
  call loop_QZ_A(G2(:,:,:,97),wf(:,4),G2(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,127),MB,G3tensor(:,44))
  call loop_VA_Q(G0(:,:,:,1),wf(:,92),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,108),ZERO,G1(:,:,:,79))
  call loop_AZ_Q(G1(:,:,:,79),wf(:,4),G1(:,:,:,80),gZu)
  call loop_A_Q(G1(:,:,:,80),Q(:,111),ZERO,G2(:,:,:,99))
  call check_last_AQ_V(l_switch,G2(:,:,:,99),wf(:,-4),G2tensor(:,43))
  call check_last_AQ_V(l_switch,G1(:,:,:,79),wf(:,20),G1tensor(:,20))
  call loop_VA_Q(G0(:,:,:,1),wf(:,107),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,47),ZERO,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-6),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,111),ZERO,G2(:,:,:,100))
  call check_last_AQ_V(l_switch,G2(:,:,:,100),wf(:,-4),G2tensor(:,44))
  call loop_VA_Q(G0(:,:,:,1),wf(:,111),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,47),ZERO,G1(:,:,:,83))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-6),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,111),ZERO,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,-4),G2tensor(:,45))
  call loop_VA_Q(G0(:,:,:,1),wf(:,115),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,47),ZERO,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-6),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,111),ZERO,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,-4),G2tensor(:,46))
  call loop_VA_Q(G0(:,:,:,1),wf(:,119),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,47),ZERO,G1(:,:,:,87))
  call loop_AV_Q(G1(:,:,:,87),wf(:,-6),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,111),ZERO,G2(:,:,:,103))
  call check_last_AQ_V(l_switch,G2(:,:,:,103),wf(:,-4),G2tensor(:,47))
  call loop_VA_Q(G0(:,:,:,1),wf(:,123),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,47),ZERO,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-6),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,111),ZERO,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,-4),G2tensor(:,48))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(9)*M(1))) * den(115)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(9)*M(1))) * den(116)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(6)*M(1))) * den(47)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(9)*M(1))) * den(50)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(9)*M(1))) * den(53)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(9)*M(1))) * den(117)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(9)*M(1))) * den(117)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(9)*M(1))) * den(118)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(9)*M(1))) * den(119)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(6)*M(1))) * den(54)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(9)*M(1))) * den(57)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(9)*M(1))) * den(60)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(9)*M(1))) * den(120)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(9)*M(1))) * den(120)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(8)*M(1)) * den(27)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(7)*M(1))) * den(27)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(9)*M(1))) * den(121)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(8)*M(1)) * den(96)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(7)*M(1))) * den(96)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(7)*M(1))) * den(94)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(8)*M(1)) * den(94)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(8)*M(1)) * den(94)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(8)*M(1)) * den(28)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(7)*M(1))) * den(28)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(9)*M(1))) * den(122)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(8)*M(1)) * den(99)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(7)*M(1))) * den(99)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(7)*M(1))) * den(97)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(8)*M(1)) * den(97)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(8)*M(1)) * den(97)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(11)*M(1)) * den(123)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(10)*M(1)) * den(123)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(11)*M(1)) * den(123)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(10)*M(1)) * den(123)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(11)*M(1)) * den(123)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(10)*M(1)) * den(123)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(11)*M(1)) * den(123)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(10)*M(1)) * den(123)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,36)
  Gcoeff = (-(c(9)*M(1))) * den(124)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(8)*M(1)) * den(103)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(7)*M(1))) * den(103)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(7)*M(1))) * den(102)
  T3sum(1:35,14) = T3sum(1:35,14) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(8)*M(1)) * den(102)
  T3sum(1:35,15) = T3sum(1:35,15) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(8)*M(1)) * den(102)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(11)*M(1)) * den(125)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(10)*M(1)) * den(125)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(11)*M(1)) * den(125)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(10)*M(1)) * den(125)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(11)*M(1)) * den(125)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(10)*M(1)) * den(125)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(11)*M(1)) * den(125)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(10)*M(1)) * den(125)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,44)
  Gcoeff = (-(c(9)*M(1))) * den(126)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(8)*M(1)) * den(106)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(7)*M(1))) * den(106)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(7)*M(1))) * den(105)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(8)*M(1)) * den(105)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(8)*M(1)) * den(105)
  T3sum(1:35,19) = T3sum(1:35,19) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(5)*M(1)) * den(107)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(4)*M(1))) * den(107)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(5)*M(1)) * den(108)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(4)*M(1))) * den(108)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(5)*M(1)) * den(46)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(5)*M(1)) * den(46)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(4)*M(1))) * den(46)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(8)*M(1)) * den(12)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(8)*M(1)) * den(12)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(8)*M(1)) * den(12)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(8)*M(1)) * den(12)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(8)*M(1)) * den(12)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(8)*M(1)) * den(12)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(7)*M(1))) * den(12)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(7)*M(1))) * den(12)
  T4sum(1:70,8) = T4sum(1:70,8) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(9)*M(1))) * den(127)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(9)*M(1))) * den(128)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(9)*M(1))) * den(129)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(9)*M(1))) * den(130)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(8)*M(1)) * den(109)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(7)*M(1))) * den(109)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(8)*M(1)) * den(110)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(7)*M(1))) * den(110)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(8)*M(1)) * den(85)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(8)*M(1)) * den(85)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(7)*M(1))) * den(85)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(8)*M(1)) * den(111)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(7)*M(1))) * den(111)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(8)*M(1)) * den(112)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(7)*M(1))) * den(112)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(8)*M(1)) * den(87)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(8)*M(1)) * den(87)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,19)
  Gcoeff = (-(c(7)*M(1))) * den(87)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(3)*M(1))) * den(131)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(3)*M(1))) * den(132)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(2)*M(1)) * den(113)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(1)*M(1))) * den(113)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(2)*M(1)) * den(114)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(1)*M(1))) * den(114)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(2)*M(1)) * den(91)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(2)*M(1)) * den(91)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(1)*M(1))) * den(91)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(9)*M(1))) * den(67)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(9)*M(1))) * den(133)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(9)*M(1))) * den(68)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(9)*M(1))) * den(134)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(6)*M(1))) * den(135)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(9)*M(1))) * den(136)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(9)*M(1))) * den(71)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(9)*M(1))) * den(137)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(9)*M(1))) * den(72)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,15)
  Gcoeff = (-(c(6)*M(1))) * den(138)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(9)*M(1))) * den(82)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(9)*M(1))) * den(78)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(9)*M(1))) * den(84)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(9)*M(1))) * den(80)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(9)*M(1))) * den(139)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(9)*M(1))) * den(140)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(9)*M(1))) * den(141)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(9)*M(1))) * den(142)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(3)*M(1))) * den(143)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(3)*M(1))) * den(144)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,14)

end subroutine vamp_1

end module ol_vamp_1_ppllllj_nenexnmxmudxg_1_/**/REALKIND
