
FeynArtsProcess = {F[1, {1}], -F[1, {1}]} -> {-F[1, {2}], F[1, {2}], -F[3, {1}], F[3, {1}], V[5]};

SortExternal = True;

OpenLoopsModel = "SM";

CreateTopologiesOptions = {
  ExcludeTopologies -> {Snails, WFCorrectionCTs, TadpoleCTs, Loops[6 | 7]}
};

InsertFieldsOptions = {
  Restrictions -> {ExcludeParticles -> {S[2 | 3]}, NoQuarkMixing},
  Model -> {"SMQCD", "SMQCDR2"},
  InsertionLevel -> {Particles}
};

UnitaryGauge = True;

ColourCorrelations = Automatic;

SubProcessName = Automatic;

SelectCoupling = Exponent[#1, gQCD] == 1 + 2*#2 & ;

SelectInterference = False;

SelectTreeDiagrams = True & ;

SelectLoopDiagrams = True & ;

SelectCTDiagrams = True & ;

ReplaceOSw = False;

SetParameters = {
  nc -> 3,
  nf -> 6,
  ME -> 0,
  MM -> 0,
  ML -> 0,
  MU -> 0,
  MD -> 0,
  MS -> 0,
  MC -> 0,
  LeadingColour -> 0
};

ChannelMap = {};

Approximation = "";

NonZeroHels = Null;
