
module ol_colourmatrix_ppllllj_nexeeexudxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_nexeeexudxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_nexeeexudxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_nexeeexudxg_1_/**/REALKIND

module ol_loop_ppllllj_nexeeexudxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(36), c(20)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:318)
  ! denominators
  complex(REALKIND), save :: den(437)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD)/(4._/**/REALKIND*sw**4)
    f( 2) = (CI*countertermnorm*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f( 3) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f( 4) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f( 5) = (CI*cw*eQED**4*gQCD)/(2._/**/REALKIND*sw**3)
    f( 6) = (CI*countertermnorm*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f( 7) = (CI*countertermnorm*ctGqq*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f( 8) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f( 9) = (CI*eQED**4*gQCD)/(6._/**/REALKIND*sw**2)
    f(10) = (CI*eQED**4*gQCD)/(3._/**/REALKIND*sw**2)
    f(11) = (CI*eQED**4*gQCD)/(2._/**/REALKIND*sw**2)
    f(12) = (CI*countertermnorm*eQED**4*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(13) = (CI*countertermnorm*eQED**4*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(14) = (CI*countertermnorm*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(15) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(16) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(17) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(18) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(19) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(20) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(21) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/(sw**2*2._/**/REALKIND)
    f(22) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(4._/**/REALKIND*sw**4)
    f(23) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(24) = (CI*cw*eQED**4*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**3)
    f(25) = (cw*eQED**4*gQCD**3*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(26) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(6._/**/REALKIND*sw**2)
    f(27) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(3._/**/REALKIND*sw**2)
    f(28) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(29) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(30) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(31) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(32) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(33) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(34) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(35) = (2*eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(36) = (eQED**4*gQCD**3*integralnorm*SwF)/sw**2

  c = [ 9*CI*f(22), f(23), 8*f(23), 9*CI*f(24), f(25), 8*f(25), 9*CI*f(26), 9*CI*f(27), 9*CI*f(28), f(29), 8*f(29), f(30), 8*f(30) &
    , f(31), 8*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(244)

  ! external WFs

  call wf_A(P(:,1), rZERO, H(1), wf(:,0))
  call wf_Q(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_A(P(:,6), rZERO, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_W(wf(:,-1),wf(:,0),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,3),MW,1_intkind1,wf(:,4))
  call prop_Q_A(wf(:,3),Q(:,80),ZERO,0_intkind1,wf(:,5))
  call vert_AW_Q(wf(:,-5),wf(:,4),wf(:,6))
  call vert_VQ_A(wf(:,2),wf(:,5),wf(:,7))
  call prop_A_Q(wf(:,6),Q(:,35),ZERO,0_intkind1,wf(:,8))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,9))
  call prop_W_W(wf(:,9),Q(:,12),MZ,1_intkind1,wf(:,10))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,5),wf(:,11))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,12))
  call vert_WQ_A(wf(:,4),wf(:,5),wf(:,13))
  call prop_A_Q(wf(:,12),Q(:,44),ZERO,0_intkind1,wf(:,14))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,10),wf(:,15))
  call prop_A_Q(wf(:,15),Q(:,44),ZERO,0_intkind1,wf(:,16))
  call vert_QA_W(wf(:,5),wf(:,-5),wf(:,17))
  call vert_UV_W(wf(:,4),Q(:,3),wf(:,2),Q(:,12),wf(:,18))
  call prop_W_W(wf(:,17),Q(:,112),MW,1_intkind1,wf(:,19))
  call vert_UV_W(wf(:,4),Q(:,3),wf(:,10),Q(:,12),wf(:,20))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,21))
  call prop_A_Q(wf(:,21),Q(:,96),ZERO,0_intkind1,wf(:,22))
  call vert_WQ_A(wf(:,4),wf(:,-4),wf(:,23))
  call vert_AV_Q(wf(:,22),wf(:,2),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,19),ZERO,0_intkind1,wf(:,25))
  call vert_AZ_Q(gZd,wf(:,22),wf(:,10),wf(:,26))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,27))
  call vert_AW_Q(wf(:,22),wf(:,4),wf(:,28))
  call prop_Q_A(wf(:,27),Q(:,28),ZERO,0_intkind1,wf(:,29))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,-4),wf(:,30))
  call prop_Q_A(wf(:,30),Q(:,28),ZERO,0_intkind1,wf(:,31))
  call vert_QA_W(wf(:,-4),wf(:,22),wf(:,32))
  call prop_W_W(wf(:,32),Q(:,112),MW,1_intkind1,wf(:,33))
  call vert_VQ_A(wf(:,-6),wf(:,25),wf(:,34))
  call vert_VQ_A(wf(:,-6),wf(:,29),wf(:,35))
  call vert_VQ_A(wf(:,-6),wf(:,31),wf(:,36))
  call vert_AW_Q(wf(:,-3),wf(:,4),wf(:,37))
  call prop_A_Q(wf(:,37),Q(:,11),ZERO,0_intkind1,wf(:,38))
  call vert_QA_W(wf(:,-2),wf(:,38),wf(:,39))
  call vert_QA_W(wf(:,-2),wf(:,0),wf(:,40))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,41))
  call prop_W_W(wf(:,40),Q(:,5),MW,1_intkind1,wf(:,42))
  call vert_AW_Q(wf(:,-5),wf(:,42),wf(:,43))
  call vert_VQ_A(wf(:,41),wf(:,5),wf(:,44))
  call prop_A_Q(wf(:,43),Q(:,37),ZERO,0_intkind1,wf(:,45))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-3),wf(:,46))
  call prop_W_W(wf(:,46),Q(:,10),MZ,1_intkind1,wf(:,47))
  call vert_ZQ_A(gZu,wf(:,47),wf(:,5),wf(:,48))
  call vert_AV_Q(wf(:,-5),wf(:,41),wf(:,49))
  call vert_WQ_A(wf(:,42),wf(:,5),wf(:,50))
  call prop_A_Q(wf(:,49),Q(:,42),ZERO,0_intkind1,wf(:,51))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,47),wf(:,52))
  call prop_A_Q(wf(:,52),Q(:,42),ZERO,0_intkind1,wf(:,53))
  call vert_UV_W(wf(:,42),Q(:,5),wf(:,41),Q(:,10),wf(:,54))
  call vert_UV_W(wf(:,42),Q(:,5),wf(:,47),Q(:,10),wf(:,55))
  call vert_WQ_A(wf(:,42),wf(:,-4),wf(:,56))
  call vert_AV_Q(wf(:,22),wf(:,41),wf(:,57))
  call prop_Q_A(wf(:,56),Q(:,21),ZERO,0_intkind1,wf(:,58))
  call vert_AZ_Q(gZd,wf(:,22),wf(:,47),wf(:,59))
  call vert_VQ_A(wf(:,41),wf(:,-4),wf(:,60))
  call vert_AW_Q(wf(:,22),wf(:,42),wf(:,61))
  call prop_Q_A(wf(:,60),Q(:,26),ZERO,0_intkind1,wf(:,62))
  call vert_ZQ_A(gZu,wf(:,47),wf(:,-4),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,26),ZERO,0_intkind1,wf(:,64))
  call vert_VQ_A(wf(:,-6),wf(:,58),wf(:,65))
  call vert_VQ_A(wf(:,-6),wf(:,62),wf(:,66))
  call vert_VQ_A(wf(:,-6),wf(:,64),wf(:,67))
  call vert_AW_Q(wf(:,-3),wf(:,42),wf(:,68))
  call prop_A_Q(wf(:,68),Q(:,13),ZERO,0_intkind1,wf(:,69))
  call vert_QA_W(wf(:,-1),wf(:,69),wf(:,70))
  call vert_AZ_Q(gZn,wf(:,0),wf(:,47),wf(:,71))
  call prop_A_Q(wf(:,71),Q(:,11),ZERO,0_intkind1,wf(:,72))
  call vert_QA_W(wf(:,-2),wf(:,72),wf(:,73))
  call vert_VQ_A(wf(:,41),wf(:,-2),wf(:,74))
  call prop_Q_A(wf(:,74),Q(:,14),ZERO,0_intkind1,wf(:,75))
  call vert_QA_W(wf(:,75),wf(:,0),wf(:,76))
  call vert_ZQ_A(gZl,wf(:,47),wf(:,-2),wf(:,77))
  call prop_Q_A(wf(:,77),Q(:,14),ZERO,0_intkind1,wf(:,78))
  call vert_QA_W(wf(:,78),wf(:,0),wf(:,79))
  call vert_AZ_Q(gZn,wf(:,0),wf(:,10),wf(:,80))
  call prop_A_Q(wf(:,80),Q(:,13),ZERO,0_intkind1,wf(:,81))
  call vert_QA_W(wf(:,-1),wf(:,81),wf(:,82))
  call vert_VQ_A(wf(:,2),wf(:,-1),wf(:,83))
  call prop_Q_A(wf(:,83),Q(:,14),ZERO,0_intkind1,wf(:,84))
  call vert_QA_W(wf(:,84),wf(:,0),wf(:,85))
  call vert_ZQ_A(gZl,wf(:,10),wf(:,-1),wf(:,86))
  call prop_Q_A(wf(:,86),Q(:,14),ZERO,0_intkind1,wf(:,87))
  call vert_QA_W(wf(:,87),wf(:,0),wf(:,88))
  call counter_VQ_A(wf(:,2),wf(:,5),wf(:,89))
  call counter_ZQ_A(gZu,wf(:,10),wf(:,5),wf(:,90))
  call counter_WQ_A(wf(:,4),wf(:,5),wf(:,91))
  call counter_AV_Q(wf(:,22),wf(:,2),wf(:,92))
  call counter_AZ_Q(gZd,wf(:,22),wf(:,10),wf(:,93))
  call counter_AW_Q(wf(:,22),wf(:,4),wf(:,94))
  call counter_VQ_A(wf(:,-6),wf(:,25),wf(:,95))
  call counter_VG_G(wf(:,10),wf(:,-6),Q(:,64),wf(:,96),Q(:,76))
  call vert_QA_V(wf(:,25),wf(:,-5),wf(:,97))
  call counter_VQ_A(wf(:,-6),wf(:,29),wf(:,98))
  call counter_VQ_A(wf(:,-6),wf(:,31),wf(:,99))
  call vert_QA_V(wf(:,-4),wf(:,8),wf(:,100))
  call counter_QA_W(wf(:,5),wf(:,-5),wf(:,101))
  call prop_W_W(wf(:,18),Q(:,15),MW,1_intkind1,wf(:,102))
  call prop_W_W(wf(:,20),Q(:,15),MW,1_intkind1,wf(:,103))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,104))
  call prop_Q_A(wf(:,13),Q(:,83),ZERO,0_intkind1,wf(:,105))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,10),wf(:,106))
  call counter_AW_Q(wf(:,-5),wf(:,4),wf(:,107))
  call prop_Q_A(wf(:,7),Q(:,92),ZERO,0_intkind1,wf(:,108))
  call prop_Q_A(wf(:,11),Q(:,92),ZERO,0_intkind1,wf(:,109))
  call prop_A_Q(wf(:,104),Q(:,44),ZERO,0_intkind1,wf(:,110))
  call prop_A_Q(wf(:,106),Q(:,44),ZERO,0_intkind1,wf(:,111))
  call prop_A_Q(wf(:,107),Q(:,35),ZERO,0_intkind1,wf(:,112))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,113))
  call prop_A_Q(wf(:,113),Q(:,96),ZERO,0_intkind1,wf(:,114))
  call vert_AV_Q(wf(:,114),wf(:,2),wf(:,115))
  call vert_AZ_Q(gZd,wf(:,114),wf(:,10),wf(:,116))
  call vert_AW_Q(wf(:,114),wf(:,4),wf(:,117))
  call vert_QA_W(wf(:,-4),wf(:,114),wf(:,118))
  call prop_W_W(wf(:,118),Q(:,112),MW,1_intkind1,wf(:,119))
  call counter_QA_W(wf(:,-4),wf(:,22),wf(:,120))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,121))
  call prop_A_Q(wf(:,28),Q(:,99),ZERO,0_intkind1,wf(:,122))
  call counter_ZQ_A(gZu,wf(:,10),wf(:,-4),wf(:,123))
  call counter_WQ_A(wf(:,4),wf(:,-4),wf(:,124))
  call prop_A_Q(wf(:,24),Q(:,108),ZERO,0_intkind1,wf(:,125))
  call prop_A_Q(wf(:,26),Q(:,108),ZERO,0_intkind1,wf(:,126))
  call prop_Q_A(wf(:,121),Q(:,28),ZERO,0_intkind1,wf(:,127))
  call vert_VQ_A(wf(:,-6),wf(:,127),wf(:,128))
  call prop_Q_A(wf(:,123),Q(:,28),ZERO,0_intkind1,wf(:,129))
  call vert_VQ_A(wf(:,-6),wf(:,129),wf(:,130))
  call prop_Q_A(wf(:,124),Q(:,19),ZERO,0_intkind1,wf(:,131))
  call vert_VQ_A(wf(:,-6),wf(:,131),wf(:,132))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,133))
  call prop_Q_A(wf(:,133),Q(:,80),ZERO,0_intkind1,wf(:,134))
  call vert_VQ_A(wf(:,2),wf(:,134),wf(:,135))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,134),wf(:,136))
  call vert_WQ_A(wf(:,4),wf(:,134),wf(:,137))
  call vert_QA_W(wf(:,134),wf(:,-5),wf(:,138))
  call prop_W_W(wf(:,138),Q(:,112),MW,1_intkind1,wf(:,139))
  call prop_W_W(wf(:,101),Q(:,112),MW,1_intkind1,wf(:,140))
  call prop_W_W(wf(:,120),Q(:,112),MW,1_intkind1,wf(:,141))
  call counter_VQ_A(wf(:,41),wf(:,5),wf(:,142))
  call counter_ZQ_A(gZu,wf(:,47),wf(:,5),wf(:,143))
  call counter_WQ_A(wf(:,42),wf(:,5),wf(:,144))
  call counter_AV_Q(wf(:,22),wf(:,41),wf(:,145))
  call counter_AZ_Q(gZd,wf(:,22),wf(:,47),wf(:,146))
  call counter_AW_Q(wf(:,22),wf(:,42),wf(:,147))
  call counter_VQ_A(wf(:,-6),wf(:,58),wf(:,148))
  call counter_VG_G(wf(:,47),wf(:,-6),Q(:,64),wf(:,149),Q(:,74))
  call vert_QA_V(wf(:,58),wf(:,-5),wf(:,150))
  call counter_VQ_A(wf(:,-6),wf(:,62),wf(:,151))
  call counter_VQ_A(wf(:,-6),wf(:,64),wf(:,152))
  call vert_QA_V(wf(:,-4),wf(:,45),wf(:,153))
  call prop_W_W(wf(:,54),Q(:,15),MW,1_intkind1,wf(:,154))
  call prop_W_W(wf(:,55),Q(:,15),MW,1_intkind1,wf(:,155))
  call counter_AV_Q(wf(:,-5),wf(:,41),wf(:,156))
  call prop_Q_A(wf(:,50),Q(:,85),ZERO,0_intkind1,wf(:,157))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,47),wf(:,158))
  call counter_AW_Q(wf(:,-5),wf(:,42),wf(:,159))
  call prop_Q_A(wf(:,44),Q(:,90),ZERO,0_intkind1,wf(:,160))
  call prop_Q_A(wf(:,48),Q(:,90),ZERO,0_intkind1,wf(:,161))
  call prop_A_Q(wf(:,156),Q(:,42),ZERO,0_intkind1,wf(:,162))
  call prop_A_Q(wf(:,158),Q(:,42),ZERO,0_intkind1,wf(:,163))
  call prop_A_Q(wf(:,159),Q(:,37),ZERO,0_intkind1,wf(:,164))
  call vert_AV_Q(wf(:,114),wf(:,41),wf(:,165))
  call vert_AZ_Q(gZd,wf(:,114),wf(:,47),wf(:,166))
  call vert_AW_Q(wf(:,114),wf(:,42),wf(:,167))
  call counter_VQ_A(wf(:,41),wf(:,-4),wf(:,168))
  call prop_A_Q(wf(:,61),Q(:,101),ZERO,0_intkind1,wf(:,169))
  call counter_ZQ_A(gZu,wf(:,47),wf(:,-4),wf(:,170))
  call counter_WQ_A(wf(:,42),wf(:,-4),wf(:,171))
  call prop_A_Q(wf(:,57),Q(:,106),ZERO,0_intkind1,wf(:,172))
  call prop_A_Q(wf(:,59),Q(:,106),ZERO,0_intkind1,wf(:,173))
  call prop_Q_A(wf(:,168),Q(:,26),ZERO,0_intkind1,wf(:,174))
  call vert_VQ_A(wf(:,-6),wf(:,174),wf(:,175))
  call prop_Q_A(wf(:,170),Q(:,26),ZERO,0_intkind1,wf(:,176))
  call vert_VQ_A(wf(:,-6),wf(:,176),wf(:,177))
  call prop_Q_A(wf(:,171),Q(:,21),ZERO,0_intkind1,wf(:,178))
  call vert_VQ_A(wf(:,-6),wf(:,178),wf(:,179))
  call vert_VQ_A(wf(:,41),wf(:,134),wf(:,180))
  call vert_ZQ_A(gZu,wf(:,47),wf(:,134),wf(:,181))
  call vert_WQ_A(wf(:,42),wf(:,134),wf(:,182))
  call counter_Q_A(ctqq,wf(:,5),Q(:,80),wf(:,183))
  call prop_Q_A(wf(:,183),Q(:,80),ZERO,0_intkind1,wf(:,184))
  call vert_QA_W(wf(:,184),wf(:,-5),wf(:,185))
  call vert_VQ_A(wf(:,2),wf(:,184),wf(:,186))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,184),wf(:,187))
  call vert_WQ_A(wf(:,4),wf(:,184),wf(:,188))
  call counter_A_Q(ctqq,wf(:,8),Q(:,35),wf(:,189))
  call counter_A_Q(ctqq,wf(:,14),Q(:,44),wf(:,190))
  call counter_A_Q(ctqq,wf(:,16),Q(:,44),wf(:,191))
  call counter_A_Q(ctqq,wf(:,22),Q(:,96),wf(:,192))
  call prop_A_Q(wf(:,192),Q(:,96),ZERO,0_intkind1,wf(:,193))
  call vert_QA_W(wf(:,-4),wf(:,193),wf(:,194))
  call counter_Q_A(ctqq,wf(:,25),Q(:,19),wf(:,195))
  call counter_Q_A(ctqq,wf(:,29),Q(:,28),wf(:,196))
  call counter_Q_A(ctqq,wf(:,31),Q(:,28),wf(:,197))
  call vert_AV_Q(wf(:,193),wf(:,2),wf(:,198))
  call vert_AZ_Q(gZd,wf(:,193),wf(:,10),wf(:,199))
  call vert_AW_Q(wf(:,193),wf(:,4),wf(:,200))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,201))
  call prop_A_Q(wf(:,201),Q(:,108),ZERO,0_intkind1,wf(:,202))
  call vert_AV_Q(wf(:,16),wf(:,-6),wf(:,203))
  call prop_A_Q(wf(:,203),Q(:,108),ZERO,0_intkind1,wf(:,204))
  call vert_AV_Q(wf(:,8),wf(:,-6),wf(:,205))
  call prop_A_Q(wf(:,205),Q(:,99),ZERO,0_intkind1,wf(:,206))
  call prop_Q_A(wf(:,34),Q(:,83),ZERO,0_intkind1,wf(:,207))
  call prop_Q_A(wf(:,35),Q(:,92),ZERO,0_intkind1,wf(:,208))
  call prop_Q_A(wf(:,36),Q(:,92),ZERO,0_intkind1,wf(:,209))
  call prop_W_W(wf(:,39),Q(:,15),MW,1_intkind1,wf(:,210))
  call vert_VQ_A(wf(:,41),wf(:,184),wf(:,211))
  call vert_ZQ_A(gZu,wf(:,47),wf(:,184),wf(:,212))
  call vert_WQ_A(wf(:,42),wf(:,184),wf(:,213))
  call counter_A_Q(ctqq,wf(:,45),Q(:,37),wf(:,214))
  call counter_A_Q(ctqq,wf(:,51),Q(:,42),wf(:,215))
  call counter_A_Q(ctqq,wf(:,53),Q(:,42),wf(:,216))
  call counter_Q_A(ctqq,wf(:,58),Q(:,21),wf(:,217))
  call counter_Q_A(ctqq,wf(:,62),Q(:,26),wf(:,218))
  call counter_Q_A(ctqq,wf(:,64),Q(:,26),wf(:,219))
  call vert_AV_Q(wf(:,193),wf(:,41),wf(:,220))
  call vert_AZ_Q(gZd,wf(:,193),wf(:,47),wf(:,221))
  call vert_AW_Q(wf(:,193),wf(:,42),wf(:,222))
  call vert_AV_Q(wf(:,51),wf(:,-6),wf(:,223))
  call prop_A_Q(wf(:,223),Q(:,106),ZERO,0_intkind1,wf(:,224))
  call vert_AV_Q(wf(:,53),wf(:,-6),wf(:,225))
  call prop_A_Q(wf(:,225),Q(:,106),ZERO,0_intkind1,wf(:,226))
  call vert_AV_Q(wf(:,45),wf(:,-6),wf(:,227))
  call prop_A_Q(wf(:,227),Q(:,101),ZERO,0_intkind1,wf(:,228))
  call prop_Q_A(wf(:,65),Q(:,85),ZERO,0_intkind1,wf(:,229))
  call prop_Q_A(wf(:,66),Q(:,90),ZERO,0_intkind1,wf(:,230))
  call prop_Q_A(wf(:,67),Q(:,90),ZERO,0_intkind1,wf(:,231))
  call prop_W_W(wf(:,70),Q(:,15),MW,1_intkind1,wf(:,232))
  call prop_W_W(wf(:,73),Q(:,15),MW,1_intkind1,wf(:,233))
  call prop_W_W(wf(:,76),Q(:,15),MW,1_intkind1,wf(:,234))
  call prop_W_W(wf(:,79),Q(:,15),MW,1_intkind1,wf(:,235))
  call prop_W_W(wf(:,82),Q(:,15),MW,1_intkind1,wf(:,236))
  call prop_W_W(wf(:,85),Q(:,15),MW,1_intkind1,wf(:,237))
  call prop_W_W(wf(:,88),Q(:,15),MW,1_intkind1,wf(:,238))
  call vert_VQ_A(wf(:,2),wf(:,25),wf(:,239))
  call prop_Q_A(wf(:,239),Q(:,31),ZERO,0_intkind1,wf(:,240))
  call vert_ZQ_A(gZd,wf(:,10),wf(:,25),wf(:,241))
  call prop_Q_A(wf(:,241),Q(:,31),ZERO,0_intkind1,wf(:,242))
  call vert_AV_Q(wf(:,8),wf(:,2),wf(:,243))
  call prop_A_Q(wf(:,243),Q(:,47),ZERO,0_intkind1,wf(:,244))
  call vert_AZ_Q(gZu,wf(:,8),wf(:,10),wf(:,245))
  call prop_A_Q(wf(:,245),Q(:,47),ZERO,0_intkind1,wf(:,246))
  call vert_WQ_A(wf(:,4),wf(:,29),wf(:,247))
  call prop_Q_A(wf(:,247),Q(:,31),ZERO,0_intkind1,wf(:,248))
  call vert_WQ_A(wf(:,4),wf(:,31),wf(:,249))
  call prop_Q_A(wf(:,249),Q(:,31),ZERO,0_intkind1,wf(:,250))
  call vert_AW_Q(wf(:,14),wf(:,4),wf(:,251))
  call prop_A_Q(wf(:,251),Q(:,47),ZERO,0_intkind1,wf(:,252))
  call vert_AW_Q(wf(:,16),wf(:,4),wf(:,253))
  call prop_A_Q(wf(:,253),Q(:,47),ZERO,0_intkind1,wf(:,254))
  call vert_WQ_A(wf(:,102),wf(:,-4),wf(:,255))
  call prop_Q_A(wf(:,255),Q(:,31),ZERO,0_intkind1,wf(:,256))
  call vert_WQ_A(wf(:,103),wf(:,-4),wf(:,257))
  call prop_Q_A(wf(:,257),Q(:,31),ZERO,0_intkind1,wf(:,258))
  call vert_AW_Q(wf(:,-5),wf(:,102),wf(:,259))
  call prop_A_Q(wf(:,259),Q(:,47),ZERO,0_intkind1,wf(:,260))
  call vert_AW_Q(wf(:,-5),wf(:,103),wf(:,261))
  call prop_A_Q(wf(:,261),Q(:,47),ZERO,0_intkind1,wf(:,262))
  call vert_WQ_A(wf(:,210),wf(:,-4),wf(:,263))
  call prop_Q_A(wf(:,263),Q(:,31),ZERO,0_intkind1,wf(:,264))
  call vert_AW_Q(wf(:,-5),wf(:,210),wf(:,265))
  call prop_A_Q(wf(:,265),Q(:,47),ZERO,0_intkind1,wf(:,266))
  call vert_VQ_A(wf(:,41),wf(:,58),wf(:,267))
  call prop_Q_A(wf(:,267),Q(:,31),ZERO,0_intkind1,wf(:,268))
  call vert_ZQ_A(gZd,wf(:,47),wf(:,58),wf(:,269))
  call prop_Q_A(wf(:,269),Q(:,31),ZERO,0_intkind1,wf(:,270))
  call vert_AV_Q(wf(:,45),wf(:,41),wf(:,271))
  call prop_A_Q(wf(:,271),Q(:,47),ZERO,0_intkind1,wf(:,272))
  call vert_AZ_Q(gZu,wf(:,45),wf(:,47),wf(:,273))
  call prop_A_Q(wf(:,273),Q(:,47),ZERO,0_intkind1,wf(:,274))
  call vert_WQ_A(wf(:,42),wf(:,62),wf(:,275))
  call prop_Q_A(wf(:,275),Q(:,31),ZERO,0_intkind1,wf(:,276))
  call vert_WQ_A(wf(:,42),wf(:,64),wf(:,277))
  call prop_Q_A(wf(:,277),Q(:,31),ZERO,0_intkind1,wf(:,278))
  call vert_AW_Q(wf(:,51),wf(:,42),wf(:,279))
  call prop_A_Q(wf(:,279),Q(:,47),ZERO,0_intkind1,wf(:,280))
  call vert_AW_Q(wf(:,53),wf(:,42),wf(:,281))
  call prop_A_Q(wf(:,281),Q(:,47),ZERO,0_intkind1,wf(:,282))
  call vert_WQ_A(wf(:,154),wf(:,-4),wf(:,283))
  call prop_Q_A(wf(:,283),Q(:,31),ZERO,0_intkind1,wf(:,284))
  call vert_WQ_A(wf(:,155),wf(:,-4),wf(:,285))
  call prop_Q_A(wf(:,285),Q(:,31),ZERO,0_intkind1,wf(:,286))
  call vert_AW_Q(wf(:,-5),wf(:,154),wf(:,287))
  call prop_A_Q(wf(:,287),Q(:,47),ZERO,0_intkind1,wf(:,288))
  call vert_AW_Q(wf(:,-5),wf(:,155),wf(:,289))
  call prop_A_Q(wf(:,289),Q(:,47),ZERO,0_intkind1,wf(:,290))
  call vert_WQ_A(wf(:,232),wf(:,-4),wf(:,291))
  call prop_Q_A(wf(:,291),Q(:,31),ZERO,0_intkind1,wf(:,292))
  call vert_AW_Q(wf(:,-5),wf(:,232),wf(:,293))
  call prop_A_Q(wf(:,293),Q(:,47),ZERO,0_intkind1,wf(:,294))
  call vert_WQ_A(wf(:,233),wf(:,-4),wf(:,295))
  call prop_Q_A(wf(:,295),Q(:,31),ZERO,0_intkind1,wf(:,296))
  call vert_AW_Q(wf(:,-5),wf(:,233),wf(:,297))
  call prop_A_Q(wf(:,297),Q(:,47),ZERO,0_intkind1,wf(:,298))
  call vert_WQ_A(wf(:,234),wf(:,-4),wf(:,299))
  call prop_Q_A(wf(:,299),Q(:,31),ZERO,0_intkind1,wf(:,300))
  call vert_WQ_A(wf(:,235),wf(:,-4),wf(:,301))
  call prop_Q_A(wf(:,301),Q(:,31),ZERO,0_intkind1,wf(:,302))
  call vert_AW_Q(wf(:,-5),wf(:,234),wf(:,303))
  call prop_A_Q(wf(:,303),Q(:,47),ZERO,0_intkind1,wf(:,304))
  call vert_AW_Q(wf(:,-5),wf(:,235),wf(:,305))
  call prop_A_Q(wf(:,305),Q(:,47),ZERO,0_intkind1,wf(:,306))
  call vert_WQ_A(wf(:,236),wf(:,-4),wf(:,307))
  call prop_Q_A(wf(:,307),Q(:,31),ZERO,0_intkind1,wf(:,308))
  call vert_AW_Q(wf(:,-5),wf(:,236),wf(:,309))
  call prop_A_Q(wf(:,309),Q(:,47),ZERO,0_intkind1,wf(:,310))
  call vert_WQ_A(wf(:,237),wf(:,-4),wf(:,311))
  call prop_Q_A(wf(:,311),Q(:,31),ZERO,0_intkind1,wf(:,312))
  call vert_WQ_A(wf(:,238),wf(:,-4),wf(:,313))
  call prop_Q_A(wf(:,313),Q(:,31),ZERO,0_intkind1,wf(:,314))
  call vert_AW_Q(wf(:,-5),wf(:,237),wf(:,315))
  call prop_A_Q(wf(:,315),Q(:,47),ZERO,0_intkind1,wf(:,316))
  call vert_AW_Q(wf(:,-5),wf(:,238),wf(:,317))
  call prop_A_Q(wf(:,317),Q(:,47),ZERO,0_intkind1,wf(:,318))


  ! propagators

    den(1) = 1 / (Q(5,3) - MW2)
    den(2) = 1 / (Q(5,12))
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,35))
    den(8) = 1 / (Q(5,12) - MZ2)
    den(12) = 1 / (Q(5,44))
    den(18) = 1 / (Q(5,112) - MW2)
    den(23) = 1 / (Q(5,96))
    den(25) = 1 / (Q(5,19))
    den(31) = 1 / (Q(5,28))
    den(43) = 1 / (Q(5,11))
    den(47) = 1 / (Q(5,5) - MW2)
    den(48) = 1 / (Q(5,10))
    den(50) = 1 / (Q(5,37))
    den(53) = 1 / (Q(5,10) - MZ2)
    den(57) = 1 / (Q(5,42))
    den(67) = 1 / (Q(5,21))
    den(73) = 1 / (Q(5,26))
    den(84) = 1 / (Q(5,13))
    den(90) = 1 / (Q(5,14))
    den(107) = 1 / (Q(5,76))
    den(111) = 1 / (Q(5,15) - MW2)
    den(116) = 1 / (Q(5,83))
    den(120) = 1 / (Q(5,92))
    den(127) = 1 / (Q(5,99))
    den(131) = 1 / (Q(5,108))
    den(136) = 1 / (Q(5,74))
    den(144) = 1 / (Q(5,85))
    den(148) = 1 / (Q(5,90))
    den(155) = 1 / (Q(5,101))
    den(159) = 1 / (Q(5,106))
    den(270) = 1 / (Q(5,51))
    den(273) = 1 / (Q(5,31))
    den(279) = 1 / (Q(5,47))
    den(297) = 1 / (Q(5,53))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(11) = den(1)*den(3)
    den(13) = den(2)*den(12)
    den(14) = den(11)*den(13)
    den(15) = den(8)*den(12)
    den(16) = den(11)*den(15)
    den(17) = den(1)*den(2)
    den(19) = den(3)*den(18)
    den(20) = den(17)*den(19)
    den(21) = den(1)*den(8)
    den(22) = den(19)*den(21)
    den(24) = den(2)*den(23)
    den(26) = den(1)*den(25)
    den(27) = den(24)*den(26)
    den(28) = den(8)*den(23)
    den(29) = den(26)*den(28)
    den(30) = den(1)*den(23)
    den(32) = den(2)*den(31)
    den(33) = den(30)*den(32)
    den(34) = den(8)*den(31)
    den(35) = den(30)*den(34)
    den(36) = den(18)*den(23)
    den(37) = den(17)*den(36)
    den(38) = den(21)*den(36)
    den(39) = den(13)*den(26)
    den(40) = den(15)*den(26)
    den(41) = den(6)*den(32)
    den(42) = den(6)*den(34)
    den(44) = den(1)*den(43)
    den(45) = den(19)*den(44)
    den(46) = den(36)*den(44)
    den(49) = den(3)*den(48)
    den(51) = den(47)*den(50)
    den(52) = den(49)*den(51)
    den(54) = den(3)*den(53)
    den(55) = den(51)*den(54)
    den(56) = den(3)*den(47)
    den(58) = den(48)*den(57)
    den(59) = den(56)*den(58)
    den(60) = den(53)*den(57)
    den(61) = den(56)*den(60)
    den(62) = den(47)*den(48)
    den(63) = den(19)*den(62)
    den(64) = den(47)*den(53)
    den(65) = den(19)*den(64)
    den(66) = den(23)*den(48)
    den(68) = den(47)*den(67)
    den(69) = den(66)*den(68)
    den(70) = den(23)*den(53)
    den(71) = den(68)*den(70)
    den(72) = den(23)*den(47)
    den(74) = den(48)*den(73)
    den(75) = den(72)*den(74)
    den(76) = den(53)*den(73)
    den(77) = den(72)*den(76)
    den(78) = den(36)*den(62)
    den(79) = den(36)*den(64)
    den(80) = den(58)*den(68)
    den(81) = den(60)*den(68)
    den(82) = den(51)*den(74)
    den(83) = den(51)*den(76)
    den(85) = den(47)*den(84)
    den(86) = den(19)*den(85)
    den(87) = den(36)*den(85)
    den(88) = den(43)*den(53)
    den(89) = den(19)*den(88)
    den(91) = den(48)*den(90)
    den(92) = den(19)*den(91)
    den(93) = den(53)*den(90)
    den(94) = den(19)*den(93)
    den(95) = den(36)*den(88)
    den(96) = den(36)*den(91)
    den(97) = den(36)*den(93)
    den(98) = den(8)*den(84)
    den(99) = den(19)*den(98)
    den(100) = den(2)*den(90)
    den(101) = den(19)*den(100)
    den(102) = den(8)*den(90)
    den(103) = den(19)*den(102)
    den(104) = den(36)*den(98)
    den(105) = den(36)*den(100)
    den(106) = den(36)*den(102)
    den(108) = den(8)*den(107)
    den(109) = den(26)*den(108)
    den(110) = den(6)*den(108)
    den(112) = den(17)*den(111)
    den(113) = den(3)*den(112)
    den(114) = den(21)*den(111)
    den(115) = den(3)*den(114)
    den(117) = den(11)*den(116)
    den(118) = den(2)*den(117)
    den(119) = den(8)*den(117)
    den(121) = den(4)*den(120)
    den(122) = den(1)*den(121)
    den(123) = den(9)*den(120)
    den(124) = den(1)*den(123)
    den(125) = den(23)*den(112)
    den(126) = den(23)*den(114)
    den(128) = den(30)*den(127)
    den(129) = den(2)*den(128)
    den(130) = den(8)*den(128)
    den(132) = den(24)*den(131)
    den(133) = den(1)*den(132)
    den(134) = den(28)*den(131)
    den(135) = den(1)*den(134)
    den(137) = den(53)*den(136)
    den(138) = den(68)*den(137)
    den(139) = den(51)*den(137)
    den(140) = den(62)*den(111)
    den(141) = den(3)*den(140)
    den(142) = den(64)*den(111)
    den(143) = den(3)*den(142)
    den(145) = den(56)*den(144)
    den(146) = den(48)*den(145)
    den(147) = den(53)*den(145)
    den(149) = den(49)*den(148)
    den(150) = den(47)*den(149)
    den(151) = den(54)*den(148)
    den(152) = den(47)*den(151)
    den(153) = den(23)*den(140)
    den(154) = den(23)*den(142)
    den(156) = den(72)*den(155)
    den(157) = den(48)*den(156)
    den(158) = den(53)*den(156)
    den(160) = den(66)*den(159)
    den(161) = den(47)*den(160)
    den(162) = den(70)*den(159)
    den(163) = den(47)*den(162)
    den(164) = den(3)**2
    den(165) = den(112)*den(164)
    den(166) = den(114)*den(164)
    den(167) = den(2)*den(164)
    den(168) = den(6)*den(167)
    den(169) = den(8)*den(164)
    den(170) = den(6)*den(169)
    den(171) = den(1)*den(164)
    den(172) = den(13)*den(171)
    den(173) = den(15)*den(171)
    den(174) = den(6)*den(121)
    den(175) = den(6)*den(123)
    den(176) = den(13)*den(117)
    den(177) = den(15)*den(117)
    den(178) = den(23)**2
    den(179) = den(112)*den(178)
    den(180) = den(114)*den(178)
    den(181) = den(26)*den(132)
    den(182) = den(26)*den(134)
    den(183) = den(32)*den(128)
    den(184) = den(34)*den(128)
    den(185) = den(2)*den(178)
    den(186) = den(26)*den(185)
    den(187) = den(8)*den(178)
    den(188) = den(26)*den(187)
    den(189) = den(1)*den(178)
    den(190) = den(32)*den(189)
    den(191) = den(34)*den(189)
    den(192) = den(13)*den(131)
    den(193) = den(26)*den(192)
    den(194) = den(15)*den(131)
    den(195) = den(26)*den(194)
    den(196) = den(6)*den(127)
    den(197) = den(32)*den(196)
    den(198) = den(34)*den(196)
    den(199) = den(26)*den(116)
    den(200) = den(13)*den(199)
    den(201) = den(15)*den(199)
    den(202) = den(32)*den(120)
    den(203) = den(6)*den(202)
    den(204) = den(34)*den(120)
    den(205) = den(6)*den(204)
    den(206) = den(44)*den(111)
    den(207) = den(164)*den(206)
    den(208) = den(178)*den(206)
    den(209) = den(140)*den(164)
    den(210) = den(142)*den(164)
    den(211) = den(48)*den(164)
    den(212) = den(51)*den(211)
    den(213) = den(53)*den(164)
    den(214) = den(51)*den(213)
    den(215) = den(47)*den(164)
    den(216) = den(58)*den(215)
    den(217) = den(60)*den(215)
    den(218) = den(51)*den(149)
    den(219) = den(51)*den(151)
    den(220) = den(58)*den(145)
    den(221) = den(60)*den(145)
    den(222) = den(140)*den(178)
    den(223) = den(142)*den(178)
    den(224) = den(68)*den(160)
    den(225) = den(68)*den(162)
    den(226) = den(74)*den(156)
    den(227) = den(76)*den(156)
    den(228) = den(48)*den(178)
    den(229) = den(68)*den(228)
    den(230) = den(53)*den(178)
    den(231) = den(68)*den(230)
    den(232) = den(47)*den(178)
    den(233) = den(74)*den(232)
    den(234) = den(76)*den(232)
    den(235) = den(58)*den(159)
    den(236) = den(68)*den(235)
    den(237) = den(60)*den(159)
    den(238) = den(68)*den(237)
    den(239) = den(51)*den(155)
    den(240) = den(74)*den(239)
    den(241) = den(76)*den(239)
    den(242) = den(68)*den(144)
    den(243) = den(58)*den(242)
    den(244) = den(60)*den(242)
    den(245) = den(74)*den(148)
    den(246) = den(51)*den(245)
    den(247) = den(76)*den(148)
    den(248) = den(51)*den(247)
    den(249) = den(85)*den(111)
    den(250) = den(164)*den(249)
    den(251) = den(178)*den(249)
    den(252) = den(88)*den(111)
    den(253) = den(164)*den(252)
    den(254) = den(91)*den(111)
    den(255) = den(164)*den(254)
    den(256) = den(93)*den(111)
    den(257) = den(164)*den(256)
    den(258) = den(178)*den(252)
    den(259) = den(178)*den(254)
    den(260) = den(178)*den(256)
    den(261) = den(98)*den(111)
    den(262) = den(164)*den(261)
    den(263) = den(100)*den(111)
    den(264) = den(164)*den(263)
    den(265) = den(102)*den(111)
    den(266) = den(164)*den(265)
    den(267) = den(178)*den(261)
    den(268) = den(178)*den(263)
    den(269) = den(178)*den(265)
    den(271) = den(26)*den(270)
    den(272) = den(2)*den(26)
    den(274) = den(272)*den(273)
    den(275) = den(8)*den(26)
    den(276) = den(273)*den(275)
    den(277) = den(6)*den(270)
    den(278) = den(2)*den(6)
    den(280) = den(278)*den(279)
    den(281) = den(6)*den(8)
    den(282) = den(279)*den(281)
    den(283) = den(1)*den(32)
    den(284) = den(273)*den(283)
    den(285) = den(1)*den(34)
    den(286) = den(273)*den(285)
    den(287) = den(1)*den(13)
    den(288) = den(279)*den(287)
    den(289) = den(1)*den(15)
    den(290) = den(279)*den(289)
    den(291) = den(112)*den(273)
    den(292) = den(114)*den(273)
    den(293) = den(112)*den(279)
    den(294) = den(114)*den(279)
    den(295) = den(206)*den(273)
    den(296) = den(206)*den(279)
    den(298) = den(68)*den(297)
    den(299) = den(48)*den(68)
    den(300) = den(273)*den(299)
    den(301) = den(53)*den(68)
    den(302) = den(273)*den(301)
    den(303) = den(51)*den(297)
    den(304) = den(48)*den(51)
    den(305) = den(279)*den(304)
    den(306) = den(51)*den(53)
    den(307) = den(279)*den(306)
    den(308) = den(47)*den(74)
    den(309) = den(273)*den(308)
    den(310) = den(47)*den(76)
    den(311) = den(273)*den(310)
    den(312) = den(47)*den(58)
    den(313) = den(279)*den(312)
    den(314) = den(47)*den(60)
    den(315) = den(279)*den(314)
    den(316) = den(140)*den(273)
    den(317) = den(142)*den(273)
    den(318) = den(140)*den(279)
    den(319) = den(142)*den(279)
    den(320) = den(249)*den(273)
    den(321) = den(249)*den(279)
    den(322) = den(252)*den(273)
    den(323) = den(252)*den(279)
    den(324) = den(254)*den(273)
    den(325) = den(256)*den(273)
    den(326) = den(254)*den(279)
    den(327) = den(256)*den(279)
    den(328) = den(261)*den(273)
    den(329) = den(261)*den(279)
    den(330) = den(263)*den(273)
    den(331) = den(265)*den(273)
    den(332) = den(263)*den(279)
    den(333) = den(265)*den(279)
    den(334) = den(2)*den(3)*den(6)
    den(335) = den(3)*den(6)*den(8)
    den(336) = den(1)*den(3)*den(13)
    den(337) = den(1)*den(3)*den(15)
    den(338) = den(1)*den(2)*den(3)
    den(339) = den(1)*den(3)*den(8)
    den(340) = den(2)*den(23)*den(26)
    den(341) = den(8)*den(23)*den(26)
    den(342) = den(1)*den(23)*den(32)
    den(343) = den(1)*den(23)*den(34)
    den(344) = den(1)*den(2)*den(23)
    den(345) = den(1)*den(8)*den(23)
    den(346) = den(2)*den(271)
    den(347) = den(8)*den(271)
    den(348) = den(2)*den(199)
    den(349) = den(8)*den(199)
    den(350) = den(2)*den(277)
    den(351) = den(8)*den(277)
    den(352) = den(2)*den(196)
    den(353) = den(8)*den(196)
    den(354) = den(1)*den(202)
    den(355) = den(1)*den(204)
    den(356) = den(1)*den(192)
    den(357) = den(1)*den(194)
    den(358) = den(3)*den(206)
    den(359) = den(23)*den(206)
    den(360) = den(3)*den(48)*den(51)
    den(361) = den(3)*den(51)*den(53)
    den(362) = den(3)*den(47)*den(58)
    den(363) = den(3)*den(47)*den(60)
    den(364) = den(3)*den(47)*den(48)
    den(365) = den(3)*den(47)*den(53)
    den(366) = den(23)*den(48)*den(68)
    den(367) = den(23)*den(53)*den(68)
    den(368) = den(23)*den(47)*den(74)
    den(369) = den(23)*den(47)*den(76)
    den(370) = den(23)*den(47)*den(48)
    den(371) = den(23)*den(47)*den(53)
    den(372) = den(48)*den(298)
    den(373) = den(53)*den(298)
    den(374) = den(48)*den(242)
    den(375) = den(53)*den(242)
    den(376) = den(48)*den(303)
    den(377) = den(53)*den(303)
    den(378) = den(48)*den(239)
    den(379) = den(53)*den(239)
    den(380) = den(47)*den(245)
    den(381) = den(47)*den(247)
    den(382) = den(47)*den(235)
    den(383) = den(47)*den(237)
    den(384) = den(3)*den(249)
    den(385) = den(23)*den(249)
    den(386) = den(3)*den(252)
    den(387) = den(3)*den(254)
    den(388) = den(3)*den(256)
    den(389) = den(23)*den(252)
    den(390) = den(23)*den(254)
    den(391) = den(23)*den(256)
    den(392) = den(3)*den(261)
    den(393) = den(3)*den(263)
    den(394) = den(3)*den(265)
    den(395) = den(23)*den(261)
    den(396) = den(23)*den(263)
    den(397) = den(23)*den(265)
    den(398) = den(3)*den(280)
    den(399) = den(3)*den(282)
    den(400) = den(3)*den(288)
    den(401) = den(3)*den(290)
    den(402) = den(3)*den(293)
    den(403) = den(3)*den(294)
    den(404) = den(23)*den(274)
    den(405) = den(23)*den(276)
    den(406) = den(23)*den(284)
    den(407) = den(23)*den(286)
    den(408) = den(23)*den(291)
    den(409) = den(23)*den(292)
    den(410) = den(3)*den(296)
    den(411) = den(23)*den(295)
    den(412) = den(3)*den(305)
    den(413) = den(3)*den(307)
    den(414) = den(3)*den(313)
    den(415) = den(3)*den(315)
    den(416) = den(3)*den(318)
    den(417) = den(3)*den(319)
    den(418) = den(23)*den(300)
    den(419) = den(23)*den(302)
    den(420) = den(23)*den(309)
    den(421) = den(23)*den(311)
    den(422) = den(23)*den(316)
    den(423) = den(23)*den(317)
    den(424) = den(3)*den(321)
    den(425) = den(23)*den(320)
    den(426) = den(3)*den(323)
    den(427) = den(3)*den(326)
    den(428) = den(3)*den(327)
    den(429) = den(23)*den(322)
    den(430) = den(23)*den(324)
    den(431) = den(23)*den(325)
    den(432) = den(3)*den(329)
    den(433) = den(3)*den(332)
    den(434) = den(3)*den(333)
    den(435) = den(23)*den(328)
    den(436) = den(23)*den(330)
    den(437) = den(23)*den(331)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,7),wf(:,8)) * den(7)
  A(2) = cont_QA(wf(:,8),wf(:,11)) * den(10)
  A(3) = cont_QA(wf(:,13),wf(:,14)) * den(14)
  A(4) = cont_QA(wf(:,13),wf(:,16)) * den(16)
  A(5) = cont_VV(wf(:,18),wf(:,19)) * den(20)
  A(6) = cont_VV(wf(:,19),wf(:,20)) * den(22)
  A(7) = cont_QA(wf(:,24),wf(:,25)) * den(27)
  A(8) = cont_QA(wf(:,25),wf(:,26)) * den(29)
  A(9) = cont_QA(wf(:,28),wf(:,29)) * den(33)
  A(10) = cont_QA(wf(:,28),wf(:,31)) * den(35)
  A(11) = cont_VV(wf(:,18),wf(:,33)) * den(37)
  A(12) = cont_VV(wf(:,20),wf(:,33)) * den(38)
  A(13) = cont_QA(wf(:,14),wf(:,34)) * den(39)
  A(14) = cont_QA(wf(:,16),wf(:,34)) * den(40)
  A(15) = cont_QA(wf(:,8),wf(:,35)) * den(41)
  A(16) = cont_QA(wf(:,8),wf(:,36)) * den(42)
  A(17) = cont_VV(wf(:,19),wf(:,39)) * den(45)
  A(18) = cont_VV(wf(:,33),wf(:,39)) * den(46)
  A(19) = cont_QA(wf(:,44),wf(:,45)) * den(52)
  A(20) = cont_QA(wf(:,45),wf(:,48)) * den(55)
  A(21) = cont_QA(wf(:,50),wf(:,51)) * den(59)
  A(22) = cont_QA(wf(:,50),wf(:,53)) * den(61)
  A(23) = cont_VV(wf(:,19),wf(:,54)) * den(63)
  A(24) = cont_VV(wf(:,19),wf(:,55)) * den(65)
  A(25) = cont_QA(wf(:,57),wf(:,58)) * den(69)
  A(26) = cont_QA(wf(:,58),wf(:,59)) * den(71)
  A(27) = cont_QA(wf(:,61),wf(:,62)) * den(75)
  A(28) = cont_QA(wf(:,61),wf(:,64)) * den(77)
  A(29) = cont_VV(wf(:,33),wf(:,54)) * den(78)
  A(30) = cont_VV(wf(:,33),wf(:,55)) * den(79)
  A(31) = cont_QA(wf(:,51),wf(:,65)) * den(80)
  A(32) = cont_QA(wf(:,53),wf(:,65)) * den(81)
  A(33) = cont_QA(wf(:,45),wf(:,66)) * den(82)
  A(34) = cont_QA(wf(:,45),wf(:,67)) * den(83)
  A(35) = cont_VV(wf(:,19),wf(:,70)) * den(86)
  A(36) = cont_VV(wf(:,33),wf(:,70)) * den(87)
  A(37) = cont_VV(wf(:,19),wf(:,73)) * den(89)
  A(38) = cont_VV(wf(:,19),wf(:,76)) * den(92)
  A(39) = cont_VV(wf(:,19),wf(:,79)) * den(94)
  A(40) = cont_VV(wf(:,33),wf(:,73)) * den(95)
  A(41) = cont_VV(wf(:,33),wf(:,76)) * den(96)
  A(42) = cont_VV(wf(:,33),wf(:,79)) * den(97)
  A(43) = cont_VV(wf(:,19),wf(:,82)) * den(99)
  A(44) = cont_VV(wf(:,19),wf(:,85)) * den(101)
  A(45) = cont_VV(wf(:,19),wf(:,88)) * den(103)
  A(46) = cont_VV(wf(:,33),wf(:,82)) * den(104)
  A(47) = cont_VV(wf(:,33),wf(:,85)) * den(105)
  A(48) = cont_VV(wf(:,33),wf(:,88)) * den(106)

  A(49) = cont_QA(wf(:,8),wf(:,89)) * den(7)
  A(50) = cont_QA(wf(:,8),wf(:,90)) * den(10)
  A(51) = cont_QA(wf(:,14),wf(:,91)) * den(14)
  A(52) = cont_QA(wf(:,16),wf(:,91)) * den(16)
  A(53) = cont_QA(wf(:,25),wf(:,92)) * den(27)
  A(54) = cont_QA(wf(:,25),wf(:,93)) * den(29)
  A(55) = cont_QA(wf(:,29),wf(:,94)) * den(33)
  A(56) = cont_QA(wf(:,31),wf(:,94)) * den(35)
  A(57) = cont_QA(wf(:,14),wf(:,95)) * den(39)
  A(58) = cont_QA(wf(:,16),wf(:,95)) * den(40)
  A(59) = cont_VV(wf(:,96),wf(:,97)) * den(109)
  A(60) = cont_QA(wf(:,8),wf(:,98)) * den(41)
  A(61) = cont_QA(wf(:,8),wf(:,99)) * den(42)
  A(62) = cont_VV(wf(:,96),wf(:,100)) * den(110)
  A(63) = cont_VV(wf(:,101),wf(:,102)) * den(113)
  A(64) = cont_VV(wf(:,101),wf(:,103)) * den(115)
  A(65) = cont_QA(wf(:,104),wf(:,105)) * den(118)
  A(66) = cont_QA(wf(:,105),wf(:,106)) * den(119)
  A(67) = cont_QA(wf(:,107),wf(:,108)) * den(122)
  A(68) = cont_QA(wf(:,107),wf(:,109)) * den(124)
  A(69) = cont_QA(wf(:,34),wf(:,110)) * den(39)
  A(70) = cont_QA(wf(:,34),wf(:,111)) * den(40)
  A(71) = cont_QA(wf(:,35),wf(:,112)) * den(41)
  A(72) = cont_QA(wf(:,36),wf(:,112)) * den(42)
  A(73) = cont_QA(wf(:,25),wf(:,115)) * den(27)
  A(74) = cont_QA(wf(:,25),wf(:,116)) * den(29)
  A(75) = cont_QA(wf(:,29),wf(:,117)) * den(33)
  A(76) = cont_QA(wf(:,31),wf(:,117)) * den(35)
  A(77) = cont_VV(wf(:,18),wf(:,119)) * den(37)
  A(78) = cont_VV(wf(:,20),wf(:,119)) * den(38)
  A(79) = cont_VV(wf(:,102),wf(:,120)) * den(125)
  A(80) = cont_VV(wf(:,103),wf(:,120)) * den(126)
  A(81) = cont_QA(wf(:,121),wf(:,122)) * den(129)
  A(82) = cont_QA(wf(:,122),wf(:,123)) * den(130)
  A(83) = cont_QA(wf(:,124),wf(:,125)) * den(133)
  A(84) = cont_QA(wf(:,124),wf(:,126)) * den(135)
  A(85) = cont_QA(wf(:,8),wf(:,128)) * den(41)
  A(86) = cont_QA(wf(:,8),wf(:,130)) * den(42)
  A(87) = cont_QA(wf(:,14),wf(:,132)) * den(39)
  A(88) = cont_QA(wf(:,16),wf(:,132)) * den(40)
  A(89) = cont_QA(wf(:,8),wf(:,135)) * den(7)
  A(90) = cont_QA(wf(:,8),wf(:,136)) * den(10)
  A(91) = cont_QA(wf(:,14),wf(:,137)) * den(14)
  A(92) = cont_QA(wf(:,16),wf(:,137)) * den(16)
  A(93) = cont_VV(wf(:,18),wf(:,139)) * den(20)
  A(94) = cont_VV(wf(:,20),wf(:,139)) * den(22)
  A(95) = cont_VV(wf(:,39),wf(:,140)) * den(45)
  A(96) = cont_VV(wf(:,39),wf(:,119)) * den(46)
  A(97) = cont_VV(wf(:,39),wf(:,141)) * den(46)
  A(98) = cont_VV(wf(:,39),wf(:,139)) * den(45)
  A(99) = cont_QA(wf(:,45),wf(:,142)) * den(52)
  A(100) = cont_QA(wf(:,45),wf(:,143)) * den(55)
  A(101) = cont_QA(wf(:,51),wf(:,144)) * den(59)
  A(102) = cont_QA(wf(:,53),wf(:,144)) * den(61)
  A(103) = cont_QA(wf(:,58),wf(:,145)) * den(69)
  A(104) = cont_QA(wf(:,58),wf(:,146)) * den(71)
  A(105) = cont_QA(wf(:,62),wf(:,147)) * den(75)
  A(106) = cont_QA(wf(:,64),wf(:,147)) * den(77)
  A(107) = cont_QA(wf(:,51),wf(:,148)) * den(80)
  A(108) = cont_QA(wf(:,53),wf(:,148)) * den(81)
  A(109) = cont_VV(wf(:,149),wf(:,150)) * den(138)
  A(110) = cont_QA(wf(:,45),wf(:,151)) * den(82)
  A(111) = cont_QA(wf(:,45),wf(:,152)) * den(83)
  A(112) = cont_VV(wf(:,149),wf(:,153)) * den(139)
  A(113) = cont_VV(wf(:,101),wf(:,154)) * den(141)
  A(114) = cont_VV(wf(:,101),wf(:,155)) * den(143)
  A(115) = cont_QA(wf(:,156),wf(:,157)) * den(146)
  A(116) = cont_QA(wf(:,157),wf(:,158)) * den(147)
  A(117) = cont_QA(wf(:,159),wf(:,160)) * den(150)
  A(118) = cont_QA(wf(:,159),wf(:,161)) * den(152)
  A(119) = cont_QA(wf(:,65),wf(:,162)) * den(80)
  A(120) = cont_QA(wf(:,65),wf(:,163)) * den(81)
  A(121) = cont_QA(wf(:,66),wf(:,164)) * den(82)
  A(122) = cont_QA(wf(:,67),wf(:,164)) * den(83)
  A(123) = cont_QA(wf(:,58),wf(:,165)) * den(69)
  A(124) = cont_QA(wf(:,58),wf(:,166)) * den(71)
  A(125) = cont_QA(wf(:,62),wf(:,167)) * den(75)
  A(126) = cont_QA(wf(:,64),wf(:,167)) * den(77)
  A(127) = cont_VV(wf(:,54),wf(:,119)) * den(78)
  A(128) = cont_VV(wf(:,55),wf(:,119)) * den(79)
  A(129) = cont_VV(wf(:,120),wf(:,154)) * den(153)
  A(130) = cont_VV(wf(:,120),wf(:,155)) * den(154)
  A(131) = cont_QA(wf(:,168),wf(:,169)) * den(157)
  A(132) = cont_QA(wf(:,169),wf(:,170)) * den(158)
  A(133) = cont_QA(wf(:,171),wf(:,172)) * den(161)
  A(134) = cont_QA(wf(:,171),wf(:,173)) * den(163)
  A(135) = cont_QA(wf(:,45),wf(:,175)) * den(82)
  A(136) = cont_QA(wf(:,45),wf(:,177)) * den(83)
  A(137) = cont_QA(wf(:,51),wf(:,179)) * den(80)
  A(138) = cont_QA(wf(:,53),wf(:,179)) * den(81)
  A(139) = cont_QA(wf(:,45),wf(:,180)) * den(52)
  A(140) = cont_QA(wf(:,45),wf(:,181)) * den(55)
  A(141) = cont_QA(wf(:,51),wf(:,182)) * den(59)
  A(142) = cont_QA(wf(:,53),wf(:,182)) * den(61)
  A(143) = cont_VV(wf(:,54),wf(:,139)) * den(63)
  A(144) = cont_VV(wf(:,55),wf(:,139)) * den(65)
  A(145) = cont_VV(wf(:,70),wf(:,140)) * den(86)
  A(146) = cont_VV(wf(:,70),wf(:,119)) * den(87)
  A(147) = cont_VV(wf(:,70),wf(:,141)) * den(87)
  A(148) = cont_VV(wf(:,70),wf(:,139)) * den(86)
  A(149) = cont_VV(wf(:,73),wf(:,140)) * den(89)
  A(150) = cont_VV(wf(:,76),wf(:,140)) * den(92)
  A(151) = cont_VV(wf(:,79),wf(:,140)) * den(94)
  A(152) = cont_VV(wf(:,73),wf(:,119)) * den(95)
  A(153) = cont_VV(wf(:,76),wf(:,119)) * den(96)
  A(154) = cont_VV(wf(:,79),wf(:,119)) * den(97)
  A(155) = cont_VV(wf(:,73),wf(:,141)) * den(95)
  A(156) = cont_VV(wf(:,76),wf(:,141)) * den(96)
  A(157) = cont_VV(wf(:,79),wf(:,141)) * den(97)
  A(158) = cont_VV(wf(:,73),wf(:,139)) * den(89)
  A(159) = cont_VV(wf(:,76),wf(:,139)) * den(92)
  A(160) = cont_VV(wf(:,79),wf(:,139)) * den(94)
  A(161) = cont_VV(wf(:,82),wf(:,140)) * den(99)
  A(162) = cont_VV(wf(:,85),wf(:,140)) * den(101)
  A(163) = cont_VV(wf(:,88),wf(:,140)) * den(103)
  A(164) = cont_VV(wf(:,82),wf(:,119)) * den(104)
  A(165) = cont_VV(wf(:,85),wf(:,119)) * den(105)
  A(166) = cont_VV(wf(:,88),wf(:,119)) * den(106)
  A(167) = cont_VV(wf(:,82),wf(:,141)) * den(104)
  A(168) = cont_VV(wf(:,85),wf(:,141)) * den(105)
  A(169) = cont_VV(wf(:,88),wf(:,141)) * den(106)
  A(170) = cont_VV(wf(:,82),wf(:,139)) * den(99)
  A(171) = cont_VV(wf(:,85),wf(:,139)) * den(101)
  A(172) = cont_VV(wf(:,88),wf(:,139)) * den(103)
  A(173) = cont_VV(wf(:,102),wf(:,185)) * den(165)
  A(174) = cont_VV(wf(:,103),wf(:,185)) * den(166)
  A(175) = cont_QA(wf(:,8),wf(:,186)) * den(168)
  A(176) = cont_QA(wf(:,8),wf(:,187)) * den(170)
  A(177) = cont_QA(wf(:,14),wf(:,188)) * den(172)
  A(178) = cont_QA(wf(:,16),wf(:,188)) * den(173)
  A(179) = cont_QA(wf(:,108),wf(:,189)) * den(174)
  A(180) = cont_QA(wf(:,109),wf(:,189)) * den(175)
  A(181) = cont_QA(wf(:,105),wf(:,190)) * den(176)
  A(182) = cont_QA(wf(:,105),wf(:,191)) * den(177)
  A(183) = cont_VV(wf(:,102),wf(:,194)) * den(179)
  A(184) = cont_VV(wf(:,103),wf(:,194)) * den(180)
  A(185) = cont_QA(wf(:,125),wf(:,195)) * den(181)
  A(186) = cont_QA(wf(:,126),wf(:,195)) * den(182)
  A(187) = cont_QA(wf(:,122),wf(:,196)) * den(183)
  A(188) = cont_QA(wf(:,122),wf(:,197)) * den(184)
  A(189) = cont_QA(wf(:,25),wf(:,198)) * den(186)
  A(190) = cont_QA(wf(:,25),wf(:,199)) * den(188)
  A(191) = cont_QA(wf(:,29),wf(:,200)) * den(190)
  A(192) = cont_QA(wf(:,31),wf(:,200)) * den(191)
  A(193) = cont_QA(wf(:,195),wf(:,202)) * den(193)
  A(194) = cont_QA(wf(:,195),wf(:,204)) * den(195)
  A(195) = cont_QA(wf(:,196),wf(:,206)) * den(197)
  A(196) = cont_QA(wf(:,197),wf(:,206)) * den(198)
  A(197) = cont_QA(wf(:,190),wf(:,207)) * den(200)
  A(198) = cont_QA(wf(:,191),wf(:,207)) * den(201)
  A(199) = cont_QA(wf(:,189),wf(:,208)) * den(203)
  A(200) = cont_QA(wf(:,189),wf(:,209)) * den(205)
  A(201) = cont_VV(wf(:,185),wf(:,210)) * den(207)
  A(202) = cont_VV(wf(:,194),wf(:,210)) * den(208)
  A(203) = cont_VV(wf(:,154),wf(:,185)) * den(209)
  A(204) = cont_VV(wf(:,155),wf(:,185)) * den(210)
  A(205) = cont_QA(wf(:,45),wf(:,211)) * den(212)
  A(206) = cont_QA(wf(:,45),wf(:,212)) * den(214)
  A(207) = cont_QA(wf(:,51),wf(:,213)) * den(216)
  A(208) = cont_QA(wf(:,53),wf(:,213)) * den(217)
  A(209) = cont_QA(wf(:,160),wf(:,214)) * den(218)
  A(210) = cont_QA(wf(:,161),wf(:,214)) * den(219)
  A(211) = cont_QA(wf(:,157),wf(:,215)) * den(220)
  A(212) = cont_QA(wf(:,157),wf(:,216)) * den(221)
  A(213) = cont_VV(wf(:,154),wf(:,194)) * den(222)
  A(214) = cont_VV(wf(:,155),wf(:,194)) * den(223)
  A(215) = cont_QA(wf(:,172),wf(:,217)) * den(224)
  A(216) = cont_QA(wf(:,173),wf(:,217)) * den(225)
  A(217) = cont_QA(wf(:,169),wf(:,218)) * den(226)
  A(218) = cont_QA(wf(:,169),wf(:,219)) * den(227)
  A(219) = cont_QA(wf(:,58),wf(:,220)) * den(229)
  A(220) = cont_QA(wf(:,58),wf(:,221)) * den(231)
  A(221) = cont_QA(wf(:,62),wf(:,222)) * den(233)
  A(222) = cont_QA(wf(:,64),wf(:,222)) * den(234)
  A(223) = cont_QA(wf(:,217),wf(:,224)) * den(236)
  A(224) = cont_QA(wf(:,217),wf(:,226)) * den(238)
  A(225) = cont_QA(wf(:,218),wf(:,228)) * den(240)
  A(226) = cont_QA(wf(:,219),wf(:,228)) * den(241)
  A(227) = cont_QA(wf(:,215),wf(:,229)) * den(243)
  A(228) = cont_QA(wf(:,216),wf(:,229)) * den(244)
  A(229) = cont_QA(wf(:,214),wf(:,230)) * den(246)
  A(230) = cont_QA(wf(:,214),wf(:,231)) * den(248)
  A(231) = cont_VV(wf(:,185),wf(:,232)) * den(250)
  A(232) = cont_VV(wf(:,194),wf(:,232)) * den(251)
  A(233) = cont_VV(wf(:,185),wf(:,233)) * den(253)
  A(234) = cont_VV(wf(:,185),wf(:,234)) * den(255)
  A(235) = cont_VV(wf(:,185),wf(:,235)) * den(257)
  A(236) = cont_VV(wf(:,194),wf(:,233)) * den(258)
  A(237) = cont_VV(wf(:,194),wf(:,234)) * den(259)
  A(238) = cont_VV(wf(:,194),wf(:,235)) * den(260)
  A(239) = cont_VV(wf(:,185),wf(:,236)) * den(262)
  A(240) = cont_VV(wf(:,185),wf(:,237)) * den(264)
  A(241) = cont_VV(wf(:,185),wf(:,238)) * den(266)
  A(242) = cont_VV(wf(:,194),wf(:,236)) * den(267)
  A(243) = cont_VV(wf(:,194),wf(:,237)) * den(268)
  A(244) = cont_VV(wf(:,194),wf(:,238)) * den(269)


  ! colour vectors

  M1(1) = (-A(17)-A(18)+A(35)+A(36))*f(1)+(-A(6)-A(12)+A(24)+A(30))*f(5)+(-A(3)-A(7)-A(13)+A(21)+A(25)+A(31))*f(9)+(A(1)+A(9) &
       +A(15)-A(19)-A(27)-A(33))*f(10)+(-A(2)-A(4)+A(5)-A(8)-A(10)+A(11)-A(14)-A(16)+A(20)+A(22)-A(23)+A(26)+A(28)-A(29)+A(32) &
       +A(34)+A(37)+A(38)+A(39)+A(40)+A(41)+A(42)-A(43)-A(44)-A(45)-A(46)-A(47)-A(48))*f(11)

  M2(1) = (A(201)+A(202)-A(231)-A(232))*f(2)+(-A(96)-A(98)+A(146)+A(148))*f(3)+(-A(95)-A(97)+A(145)+A(147))*f(4)+(A(174)+A(184) &
       -A(204)-A(214))*f(6)+(-A(78)-A(94)+A(128)+A(144))*f(7)+(-A(64)-A(80)+A(114)+A(130))*f(8)+(A(177)+A(181)+A(185)+A(189) &
       +A(193)+A(197)-A(207)-A(211)-A(215)-A(219)-A(223)-A(227))*f(12)+(-A(175)-A(179)-A(187)-A(191)-A(195)-A(199)+A(205)+A(209) &
       +A(217)+A(221)+A(225)+A(229))*f(13)+(-A(173)+A(176)+A(178)+A(180)+A(182)-A(183)+A(186)+A(188)+A(190)+A(192)+A(194)+A(196) &
       +A(198)+A(200)+A(203)-A(206)-A(208)-A(210)-A(212)+A(213)-A(216)-A(218)-A(220)-A(222)-A(224)-A(226)-A(228)-A(230)-A(233) &
       -A(234)-A(235)-A(236)-A(237)-A(238)+A(239)+A(240)+A(241)+A(242)+A(243)+A(244))*f(14)+(-A(57)-A(73)-A(91)+A(107)+A(123) &
       +A(141))*f(15)+(A(60)+A(75)+A(89)-A(110)-A(125)-A(139))*f(16)+(-A(58)-A(61)-A(74)-A(76)+A(77)-A(90)-A(92)+A(93)+A(108) &
       +A(111)+A(124)+A(126)-A(127)+A(140)+A(142)-A(143)+A(152)+A(153)+A(154)+A(158)+A(159)+A(160)-A(164)-A(165)-A(166)-A(170) &
       -A(171)-A(172))*f(17)+(-A(51)-A(53)-A(65)-A(69)-A(83)-A(87)+A(101)+A(103)+A(115)+A(119)+A(133)+A(137))*f(18)+(A(49)+A(55) &
       +A(67)+A(71)+A(81)+A(85)-A(99)-A(105)-A(117)-A(121)-A(131)-A(135))*f(19)+(-A(50)-A(52)-A(54)-A(56)+A(63)-A(66)-A(68)-A(70) &
       -A(72)+A(79)-A(82)-A(84)-A(86)-A(88)+A(100)+A(102)+A(104)+A(106)-A(113)+A(116)+A(118)+A(120)+A(122)-A(129)+A(132)+A(134) &
       +A(136)+A(138)+A(149)+A(150)+A(151)+A(155)+A(156)+A(157)-A(161)-A(162)-A(163)-A(167)-A(168)-A(169))*f(20)+(A(59)+A(62) &
       -A(109)-A(112))*f(21)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_nexeeexudxg_1_/**/REALKIND
