
module ol_colourmatrix_ppllllj_nenexnmnmxbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_nenexnmnmxbbxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_nenexnmnmxbbxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_nenexnmnmxbbxg_1_/**/REALKIND

module ol_loop_ppllllj_nenexnmnmxbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(19), c(10)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:146)
  ! denominators
  complex(REALKIND), save :: den(183)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4*gQCD
    f( 2) = CI*countertermnorm*eQED**4*gQCD**3
    f( 3) = CI*countertermnorm*ctGbb*eQED**4*gQCD**3
    f( 4) = CI*countertermnorm*ctVbb*eQED**4*gQCD**3
    f( 5) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f( 6) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f( 7) = (CI*eQED**4*gQCD*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 8) = (CI*countertermnorm*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 9) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(10) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(11) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(12) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(13) = eQED**4*gQCD**3*integralnorm*SwB
    f(14) = (CI*eQED**4*gQCD**3*integralnorm*MB*SwB)/(2._/**/REALKIND*cw**2*sw**2)
    f(15) = (eQED**4*gQCD**3*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(16) = eQED**4*gQCD**3*integralnorm*SwF
    f(17) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(18) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(19) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(12), f(13), 8*f(13), 9*CI*f(14), f(15), 8*f(15), 3*f(16), 3*f(17), 3*f(18), 3*f(19) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(86)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rMB, H(5), wf(:,-4))
  call wf_A(P(:,6), rMB, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_Z(gZn,wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,3),MZ,1_intkind1,wf(:,4))
  call prop_W_W(wf(:,2),Q(:,12),MZ,1_intkind1,wf(:,5))
  call prop_Q_A(wf(:,3),Q(:,80),MB,1_intkind1,wf(:,6))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,4),wf(:,7))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,6),wf(:,8))
  call prop_A_Q(wf(:,7),Q(:,35),MB,1_intkind1,wf(:,9))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,5),wf(:,10))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,6),wf(:,11))
  call prop_A_Q(wf(:,10),Q(:,44),MB,1_intkind1,wf(:,12))
  call vert_AQ_S(gH,wf(:,-5),wf(:,6),wf(:,13))
  call vert_VV_S(wf(:,4),wf(:,5),wf(:,14))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,15))
  call prop_A_Q(wf(:,15),Q(:,96),MB,1_intkind1,wf(:,16))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,-4),wf(:,17))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,5),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,19),MB,1_intkind1,wf(:,19))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,-4),wf(:,20))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,4),wf(:,21))
  call prop_Q_A(wf(:,20),Q(:,28),MB,1_intkind1,wf(:,22))
  call vert_AQ_S(gH,wf(:,16),wf(:,-4),wf(:,23))
  call vert_VQ_A(wf(:,-6),wf(:,19),wf(:,24))
  call vert_VQ_A(wf(:,-6),wf(:,22),wf(:,25))
  call vert_ZQ_A(gZn,wf(:,4),wf(:,-2),wf(:,26))
  call vert_QA_Z(gZd,wf(:,6),wf(:,-5),wf(:,27))
  call prop_Q_A(wf(:,26),Q(:,7),ZERO,0_intkind1,wf(:,28))
  call prop_W_W(wf(:,27),Q(:,112),MZ,1_intkind1,wf(:,29))
  call vert_QA_Z(gZn,wf(:,28),wf(:,-3),wf(:,30))
  call vert_AZ_Q(gZn,wf(:,-3),wf(:,4),wf(:,31))
  call prop_A_Q(wf(:,31),Q(:,11),ZERO,0_intkind1,wf(:,32))
  call vert_QA_Z(gZn,wf(:,-2),wf(:,32),wf(:,33))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,16),wf(:,34))
  call prop_W_W(wf(:,34),Q(:,112),MZ,1_intkind1,wf(:,35))
  call vert_ZQ_A(gZn,wf(:,5),wf(:,0),wf(:,36))
  call prop_Q_A(wf(:,36),Q(:,13),ZERO,0_intkind1,wf(:,37))
  call vert_QA_Z(gZn,wf(:,37),wf(:,-1),wf(:,38))
  call vert_AZ_Q(gZn,wf(:,-1),wf(:,5),wf(:,39))
  call prop_A_Q(wf(:,39),Q(:,14),ZERO,0_intkind1,wf(:,40))
  call vert_QA_Z(gZn,wf(:,0),wf(:,40),wf(:,41))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,42))
  call counter_VVG_G(wf(:,4),wf(:,5),wf(:,-6),wf(:,43))
  call counter_GG_S(wf(:,42),wf(:,-6),wf(:,44))
  call counter_ZQ_A(gZd,wf(:,5),wf(:,6),wf(:,45))
  call counter_ZQ_A(gZd,wf(:,4),wf(:,6),wf(:,46))
  call counter_AZ_Q(gZd,wf(:,16),wf(:,5),wf(:,47))
  call counter_AZ_Q(gZd,wf(:,16),wf(:,4),wf(:,48))
  call counter_VQ_A(wf(:,-6),wf(:,19),wf(:,49))
  call counter_VG_G(wf(:,5),wf(:,-6),Q(:,64),wf(:,50),Q(:,76))
  call vert_QA_V(wf(:,19),wf(:,-5),wf(:,51))
  call counter_VQ_A(wf(:,-6),wf(:,22),wf(:,52))
  call vert_QA_V(wf(:,-4),wf(:,9),wf(:,53))
  call counter_VG_G(wf(:,4),wf(:,-6),Q(:,64),wf(:,54),Q(:,67))
  call vert_QA_V(wf(:,22),wf(:,-5),wf(:,55))
  call vert_QA_V(wf(:,-4),wf(:,12),wf(:,56))
  call counter_AQ_S(gH,wf(:,-5),wf(:,6),wf(:,57))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,5),wf(:,58))
  call prop_Q_A(wf(:,11),Q(:,83),MB,1_intkind1,wf(:,59))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,4),wf(:,60))
  call prop_Q_A(wf(:,8),Q(:,92),MB,1_intkind1,wf(:,61))
  call prop_A_Q(wf(:,58),Q(:,44),MB,1_intkind1,wf(:,62))
  call prop_A_Q(wf(:,60),Q(:,35),MB,1_intkind1,wf(:,63))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,64))
  call prop_A_Q(wf(:,64),Q(:,96),MB,1_intkind1,wf(:,65))
  call vert_AZ_Q(gZd,wf(:,65),wf(:,5),wf(:,66))
  call vert_AZ_Q(gZd,wf(:,65),wf(:,4),wf(:,67))
  call vert_AQ_S(gH,wf(:,65),wf(:,-4),wf(:,68))
  call counter_AQ_S(gH,wf(:,16),wf(:,-4),wf(:,69))
  call counter_ZQ_A(gZd,wf(:,5),wf(:,-4),wf(:,70))
  call prop_A_Q(wf(:,21),Q(:,99),MB,1_intkind1,wf(:,71))
  call counter_ZQ_A(gZd,wf(:,4),wf(:,-4),wf(:,72))
  call prop_A_Q(wf(:,18),Q(:,108),MB,1_intkind1,wf(:,73))
  call prop_Q_A(wf(:,70),Q(:,28),MB,1_intkind1,wf(:,74))
  call vert_VQ_A(wf(:,-6),wf(:,74),wf(:,75))
  call prop_Q_A(wf(:,72),Q(:,19),MB,1_intkind1,wf(:,76))
  call vert_VQ_A(wf(:,-6),wf(:,76),wf(:,77))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,78))
  call prop_Q_A(wf(:,78),Q(:,80),MB,1_intkind1,wf(:,79))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,79),wf(:,80))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,79),wf(:,81))
  call vert_AQ_S(gH,wf(:,-5),wf(:,79),wf(:,82))
  call counter_GG_V(wf(:,42),Q(:,48),wf(:,-6),Q(:,64),wf(:,83))
  call prop_W_W(wf(:,83),Q(:,112),MZ,1_intkind1,wf(:,84))
  call counter_QA_Z(gZd,wf(:,6),wf(:,-5),wf(:,85))
  call prop_W_W(wf(:,85),Q(:,112),MZ,1_intkind1,wf(:,86))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,65),wf(:,87))
  call prop_W_W(wf(:,87),Q(:,112),MZ,1_intkind1,wf(:,88))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,16),wf(:,89))
  call prop_W_W(wf(:,89),Q(:,112),MZ,1_intkind1,wf(:,90))
  call vert_QA_Z(gZd,wf(:,79),wf(:,-5),wf(:,91))
  call prop_W_W(wf(:,91),Q(:,112),MZ,1_intkind1,wf(:,92))
  call counter_Q_A(ctbb,wf(:,6),Q(:,80),wf(:,93))
  call prop_Q_A(wf(:,93),Q(:,80),MB,1_intkind1,wf(:,94))
  call vert_AQ_S(gH,wf(:,-5),wf(:,94),wf(:,95))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,94),wf(:,96))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,94),wf(:,97))
  call counter_A_Q(ctbb,wf(:,9),Q(:,35),wf(:,98))
  call counter_A_Q(ctbb,wf(:,12),Q(:,44),wf(:,99))
  call counter_A_Q(ctbb,wf(:,16),Q(:,96),wf(:,100))
  call prop_A_Q(wf(:,100),Q(:,96),MB,1_intkind1,wf(:,101))
  call vert_AQ_S(gH,wf(:,101),wf(:,-4),wf(:,102))
  call counter_Q_A(ctbb,wf(:,19),Q(:,19),wf(:,103))
  call counter_Q_A(ctbb,wf(:,22),Q(:,28),wf(:,104))
  call vert_AZ_Q(gZd,wf(:,101),wf(:,5),wf(:,105))
  call vert_AZ_Q(gZd,wf(:,101),wf(:,4),wf(:,106))
  call vert_AV_Q(wf(:,12),wf(:,-6),wf(:,107))
  call prop_A_Q(wf(:,107),Q(:,108),MB,1_intkind1,wf(:,108))
  call vert_AV_Q(wf(:,9),wf(:,-6),wf(:,109))
  call prop_A_Q(wf(:,109),Q(:,99),MB,1_intkind1,wf(:,110))
  call prop_Q_A(wf(:,24),Q(:,83),MB,1_intkind1,wf(:,111))
  call prop_Q_A(wf(:,25),Q(:,92),MB,1_intkind1,wf(:,112))
  call vert_QA_Z(gZd,wf(:,94),wf(:,-5),wf(:,113))
  call prop_W_W(wf(:,30),Q(:,15),MZ,1_intkind1,wf(:,114))
  call prop_W_W(wf(:,33),Q(:,15),MZ,1_intkind1,wf(:,115))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,101),wf(:,116))
  call prop_W_W(wf(:,38),Q(:,15),MZ,1_intkind1,wf(:,117))
  call prop_W_W(wf(:,41),Q(:,15),MZ,1_intkind1,wf(:,118))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,19),wf(:,119))
  call prop_Q_A(wf(:,119),Q(:,31),MB,1_intkind1,wf(:,120))
  call vert_AZ_Q(gZd,wf(:,9),wf(:,5),wf(:,121))
  call prop_A_Q(wf(:,121),Q(:,47),MB,1_intkind1,wf(:,122))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,22),wf(:,123))
  call prop_Q_A(wf(:,123),Q(:,31),MB,1_intkind1,wf(:,124))
  call vert_AZ_Q(gZd,wf(:,12),wf(:,4),wf(:,125))
  call prop_A_Q(wf(:,125),Q(:,47),MB,1_intkind1,wf(:,126))
  call vert_QS_A(gH,wf(:,-4),wf(:,14),wf(:,127))
  call prop_Q_A(wf(:,127),Q(:,31),MB,1_intkind1,wf(:,128))
  call vert_SA_Q(gH,wf(:,14),wf(:,-5),wf(:,129))
  call prop_A_Q(wf(:,129),Q(:,47),MB,1_intkind1,wf(:,130))
  call vert_ZQ_A(gZd,wf(:,114),wf(:,-4),wf(:,131))
  call prop_Q_A(wf(:,131),Q(:,31),MB,1_intkind1,wf(:,132))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,114),wf(:,133))
  call prop_A_Q(wf(:,133),Q(:,47),MB,1_intkind1,wf(:,134))
  call vert_ZQ_A(gZd,wf(:,115),wf(:,-4),wf(:,135))
  call prop_Q_A(wf(:,135),Q(:,31),MB,1_intkind1,wf(:,136))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,115),wf(:,137))
  call prop_A_Q(wf(:,137),Q(:,47),MB,1_intkind1,wf(:,138))
  call vert_ZQ_A(gZd,wf(:,117),wf(:,-4),wf(:,139))
  call prop_Q_A(wf(:,139),Q(:,31),MB,1_intkind1,wf(:,140))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,117),wf(:,141))
  call prop_A_Q(wf(:,141),Q(:,47),MB,1_intkind1,wf(:,142))
  call vert_ZQ_A(gZd,wf(:,118),wf(:,-4),wf(:,143))
  call prop_Q_A(wf(:,143),Q(:,31),MB,1_intkind1,wf(:,144))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,118),wf(:,145))
  call prop_A_Q(wf(:,145),Q(:,47),MB,1_intkind1,wf(:,146))


  ! propagators

    den(1) = 1 / (Q(5,3) - MZ2)
    den(2) = 1 / (Q(5,12) - MZ2)
    den(3) = 1 / (Q(5,80) - MB2)
    den(5) = 1 / (Q(5,35) - MB2)
    den(9) = 1 / (Q(5,44) - MB2)
    den(13) = 1 / (Q(5,112) - MH2)
    den(16) = 1 / (Q(5,96) - MB2)
    den(18) = 1 / (Q(5,19) - MB2)
    den(22) = 1 / (Q(5,28) - MB2)
    den(29) = 1 / (Q(5,7))
    den(31) = 1 / (Q(5,112) - MZ2)
    den(34) = 1 / (Q(5,11))
    den(40) = 1 / (Q(5,13))
    den(43) = 1 / (Q(5,14))
    den(48) = 1 / (Q(5,48))
    den(50) = 1 / (Q(5,15) - MH2)
    den(53) = 1 / (Q(5,76))
    den(57) = 1 / (Q(5,67))
    den(62) = 1 / (Q(5,83) - MB2)
    den(65) = 1 / (Q(5,92) - MB2)
    den(69) = 1 / (Q(5,99) - MB2)
    den(72) = 1 / (Q(5,108) - MB2)
    den(104) = 1 / (Q(5,15) - MZ2)
    den(117) = 1 / (Q(5,51))
    den(120) = 1 / (Q(5,31) - MB2)
    den(124) = 1 / (Q(5,47) - MB2)
    den(126) = 1 / (Q(5,60))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(8) = den(1)*den(3)
    den(10) = den(2)*den(9)
    den(11) = den(8)*den(10)
    den(12) = den(1)*den(2)
    den(14) = den(3)*den(13)
    den(15) = den(12)*den(14)
    den(17) = den(2)*den(16)
    den(19) = den(1)*den(18)
    den(20) = den(17)*den(19)
    den(21) = den(1)*den(16)
    den(23) = den(2)*den(22)
    den(24) = den(21)*den(23)
    den(25) = den(13)*den(16)
    den(26) = den(12)*den(25)
    den(27) = den(10)*den(19)
    den(28) = den(6)*den(23)
    den(30) = den(1)*den(29)
    den(32) = den(3)*den(31)
    den(33) = den(30)*den(32)
    den(35) = den(1)*den(34)
    den(36) = den(32)*den(35)
    den(37) = den(16)*den(31)
    den(38) = den(30)*den(37)
    den(39) = den(35)*den(37)
    den(41) = den(2)*den(40)
    den(42) = den(32)*den(41)
    den(44) = den(2)*den(43)
    den(45) = den(32)*den(44)
    den(46) = den(37)*den(41)
    den(47) = den(37)*den(44)
    den(49) = den(12)*den(48)
    den(51) = den(12)*den(50)
    den(52) = den(48)*den(51)
    den(54) = den(2)*den(53)
    den(55) = den(19)*den(54)
    den(56) = den(6)*den(54)
    den(58) = den(1)*den(57)
    den(59) = den(23)*den(58)
    den(60) = den(10)*den(58)
    den(61) = den(3)*den(51)
    den(63) = den(8)*den(62)
    den(64) = den(2)*den(63)
    den(66) = den(4)*den(65)
    den(67) = den(1)*den(66)
    den(68) = den(16)*den(51)
    den(70) = den(21)*den(69)
    den(71) = den(2)*den(70)
    den(73) = den(17)*den(72)
    den(74) = den(1)*den(73)
    den(75) = den(31)*den(48)
    den(76) = den(30)*den(75)
    den(77) = den(35)*den(75)
    den(78) = den(41)*den(75)
    den(79) = den(44)*den(75)
    den(80) = den(3)**2
    den(81) = den(51)*den(80)
    den(82) = den(2)*den(80)
    den(83) = den(6)*den(82)
    den(84) = den(1)*den(80)
    den(85) = den(10)*den(84)
    den(86) = den(6)*den(66)
    den(87) = den(10)*den(63)
    den(88) = den(16)**2
    den(89) = den(51)*den(88)
    den(90) = den(19)*den(73)
    den(91) = den(23)*den(70)
    den(92) = den(2)*den(88)
    den(93) = den(19)*den(92)
    den(94) = den(1)*den(88)
    den(95) = den(23)*den(94)
    den(96) = den(10)*den(72)
    den(97) = den(19)*den(96)
    den(98) = den(6)*den(69)
    den(99) = den(23)*den(98)
    den(100) = den(19)*den(62)
    den(101) = den(10)*den(100)
    den(102) = den(23)*den(65)
    den(103) = den(6)*den(102)
    den(105) = den(30)*den(104)
    den(106) = den(80)*den(105)
    den(107) = den(35)*den(104)
    den(108) = den(80)*den(107)
    den(109) = den(88)*den(105)
    den(110) = den(88)*den(107)
    den(111) = den(41)*den(104)
    den(112) = den(80)*den(111)
    den(113) = den(44)*den(104)
    den(114) = den(80)*den(113)
    den(115) = den(88)*den(111)
    den(116) = den(88)*den(113)
    den(118) = den(19)*den(117)
    den(119) = den(2)*den(19)
    den(121) = den(119)*den(120)
    den(122) = den(6)*den(117)
    den(123) = den(2)*den(6)
    den(125) = den(123)*den(124)
    den(127) = den(23)*den(126)
    den(128) = den(1)*den(23)
    den(129) = den(120)*den(128)
    den(130) = den(10)*den(126)
    den(131) = den(1)*den(10)
    den(132) = den(124)*den(131)
    den(133) = den(51)*den(120)
    den(134) = den(51)*den(124)
    den(135) = den(105)*den(120)
    den(136) = den(105)*den(124)
    den(137) = den(107)*den(120)
    den(138) = den(107)*den(124)
    den(139) = den(111)*den(120)
    den(140) = den(111)*den(124)
    den(141) = den(113)*den(120)
    den(142) = den(113)*den(124)
    den(143) = den(1)*den(2)*den(48)
    den(144) = den(2)*den(3)*den(6)
    den(145) = den(1)*den(3)*den(10)
    den(146) = den(1)*den(2)*den(3)
    den(147) = den(2)*den(16)*den(19)
    den(148) = den(1)*den(16)*den(23)
    den(149) = den(1)*den(2)*den(16)
    den(150) = den(2)*den(118)
    den(151) = den(2)*den(100)
    den(152) = den(2)*den(122)
    den(153) = den(2)*den(98)
    den(154) = den(1)*den(127)
    den(155) = den(1)*den(102)
    den(156) = den(1)*den(130)
    den(157) = den(1)*den(96)
    den(158) = den(48)*den(105)
    den(159) = den(48)*den(107)
    den(160) = den(3)*den(105)
    den(161) = den(3)*den(107)
    den(162) = den(16)*den(105)
    den(163) = den(16)*den(107)
    den(164) = den(48)*den(111)
    den(165) = den(48)*den(113)
    den(166) = den(3)*den(111)
    den(167) = den(3)*den(113)
    den(168) = den(16)*den(111)
    den(169) = den(16)*den(113)
    den(170) = den(3)*den(125)
    den(171) = den(3)*den(132)
    den(172) = den(3)*den(134)
    den(173) = den(16)*den(121)
    den(174) = den(16)*den(129)
    den(175) = den(16)*den(133)
    den(176) = den(3)*den(136)
    den(177) = den(3)*den(138)
    den(178) = den(16)*den(135)
    den(179) = den(16)*den(137)
    den(180) = den(3)*den(140)
    den(181) = den(3)*den(142)
    den(182) = den(16)*den(139)
    den(183) = den(16)*den(141)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,8),wf(:,9)) * den(7)
  A(2) = cont_QA(wf(:,11),wf(:,12)) * den(11)
  A(3) = cont_SS(wf(:,13),wf(:,14)) * den(15)
  A(4) = cont_QA(wf(:,18),wf(:,19)) * den(20)
  A(5) = cont_QA(wf(:,21),wf(:,22)) * den(24)
  A(6) = cont_SS(wf(:,14),wf(:,23)) * den(26)
  A(7) = cont_QA(wf(:,12),wf(:,24)) * den(27)
  A(8) = cont_QA(wf(:,9),wf(:,25)) * den(28)
  A(9) = cont_VV(wf(:,29),wf(:,30)) * den(33)
  A(10) = cont_VV(wf(:,29),wf(:,33)) * den(36)
  A(11) = cont_VV(wf(:,30),wf(:,35)) * den(38)
  A(12) = cont_VV(wf(:,33),wf(:,35)) * den(39)
  A(13) = cont_VV(wf(:,29),wf(:,38)) * den(42)
  A(14) = cont_VV(wf(:,29),wf(:,41)) * den(45)
  A(15) = cont_VV(wf(:,35),wf(:,38)) * den(46)
  A(16) = cont_VV(wf(:,35),wf(:,41)) * den(47)

  A(17) = cont_VV(wf(:,42),wf(:,43)) * den(49)
  A(18) = cont_SS(wf(:,14),wf(:,44)) * den(52)
  A(19) = cont_QA(wf(:,9),wf(:,45)) * den(7)
  A(20) = cont_QA(wf(:,12),wf(:,46)) * den(11)
  A(21) = cont_QA(wf(:,19),wf(:,47)) * den(20)
  A(22) = cont_QA(wf(:,22),wf(:,48)) * den(24)
  A(23) = cont_QA(wf(:,12),wf(:,49)) * den(27)
  A(24) = cont_VV(wf(:,50),wf(:,51)) * den(55)
  A(25) = cont_QA(wf(:,9),wf(:,52)) * den(28)
  A(26) = cont_VV(wf(:,50),wf(:,53)) * den(56)
  A(27) = cont_VV(wf(:,54),wf(:,55)) * den(59)
  A(28) = cont_VV(wf(:,54),wf(:,56)) * den(60)
  A(29) = cont_SS(wf(:,14),wf(:,57)) * den(61)
  A(30) = cont_QA(wf(:,58),wf(:,59)) * den(64)
  A(31) = cont_QA(wf(:,60),wf(:,61)) * den(67)
  A(32) = cont_QA(wf(:,24),wf(:,62)) * den(27)
  A(33) = cont_QA(wf(:,25),wf(:,63)) * den(28)
  A(34) = cont_QA(wf(:,19),wf(:,66)) * den(20)
  A(35) = cont_QA(wf(:,22),wf(:,67)) * den(24)
  A(36) = cont_SS(wf(:,14),wf(:,68)) * den(26)
  A(37) = cont_SS(wf(:,14),wf(:,69)) * den(68)
  A(38) = cont_QA(wf(:,70),wf(:,71)) * den(71)
  A(39) = cont_QA(wf(:,72),wf(:,73)) * den(74)
  A(40) = cont_QA(wf(:,9),wf(:,75)) * den(28)
  A(41) = cont_QA(wf(:,12),wf(:,77)) * den(27)
  A(42) = cont_QA(wf(:,9),wf(:,80)) * den(7)
  A(43) = cont_QA(wf(:,12),wf(:,81)) * den(11)
  A(44) = cont_SS(wf(:,14),wf(:,82)) * den(15)
  A(45) = cont_VV(wf(:,30),wf(:,84)) * den(76)
  A(46) = cont_VV(wf(:,33),wf(:,84)) * den(77)
  A(47) = cont_VV(wf(:,30),wf(:,86)) * den(33)
  A(48) = cont_VV(wf(:,33),wf(:,86)) * den(36)
  A(49) = cont_VV(wf(:,30),wf(:,88)) * den(38)
  A(50) = cont_VV(wf(:,33),wf(:,88)) * den(39)
  A(51) = cont_VV(wf(:,30),wf(:,90)) * den(38)
  A(52) = cont_VV(wf(:,33),wf(:,90)) * den(39)
  A(53) = cont_VV(wf(:,30),wf(:,92)) * den(33)
  A(54) = cont_VV(wf(:,33),wf(:,92)) * den(36)
  A(55) = cont_VV(wf(:,38),wf(:,84)) * den(78)
  A(56) = cont_VV(wf(:,41),wf(:,84)) * den(79)
  A(57) = cont_VV(wf(:,38),wf(:,86)) * den(42)
  A(58) = cont_VV(wf(:,41),wf(:,86)) * den(45)
  A(59) = cont_VV(wf(:,38),wf(:,88)) * den(46)
  A(60) = cont_VV(wf(:,41),wf(:,88)) * den(47)
  A(61) = cont_VV(wf(:,38),wf(:,90)) * den(46)
  A(62) = cont_VV(wf(:,41),wf(:,90)) * den(47)
  A(63) = cont_VV(wf(:,38),wf(:,92)) * den(42)
  A(64) = cont_VV(wf(:,41),wf(:,92)) * den(45)
  A(65) = cont_SS(wf(:,14),wf(:,95)) * den(81)
  A(66) = cont_QA(wf(:,9),wf(:,96)) * den(83)
  A(67) = cont_QA(wf(:,12),wf(:,97)) * den(85)
  A(68) = cont_QA(wf(:,61),wf(:,98)) * den(86)
  A(69) = cont_QA(wf(:,59),wf(:,99)) * den(87)
  A(70) = cont_SS(wf(:,14),wf(:,102)) * den(89)
  A(71) = cont_QA(wf(:,73),wf(:,103)) * den(90)
  A(72) = cont_QA(wf(:,71),wf(:,104)) * den(91)
  A(73) = cont_QA(wf(:,19),wf(:,105)) * den(93)
  A(74) = cont_QA(wf(:,22),wf(:,106)) * den(95)
  A(75) = cont_QA(wf(:,103),wf(:,108)) * den(97)
  A(76) = cont_QA(wf(:,104),wf(:,110)) * den(99)
  A(77) = cont_QA(wf(:,99),wf(:,111)) * den(101)
  A(78) = cont_QA(wf(:,98),wf(:,112)) * den(103)
  A(79) = cont_VV(wf(:,113),wf(:,114)) * den(106)
  A(80) = cont_VV(wf(:,113),wf(:,115)) * den(108)
  A(81) = cont_VV(wf(:,114),wf(:,116)) * den(109)
  A(82) = cont_VV(wf(:,115),wf(:,116)) * den(110)
  A(83) = cont_VV(wf(:,113),wf(:,117)) * den(112)
  A(84) = cont_VV(wf(:,113),wf(:,118)) * den(114)
  A(85) = cont_VV(wf(:,116),wf(:,117)) * den(115)
  A(86) = cont_VV(wf(:,116),wf(:,118)) * den(116)


  ! colour vectors

  M1(1) = (A(1)+A(2)+A(4)+A(5)+A(7)+A(8)+A(9)+A(10)+A(11)+A(12)+A(13)+A(14)+A(15)+A(16))*f(1)+(-A(3)-A(6))*f(7)

  M2(1) = (-A(66)-A(67)-A(68)-A(69)-A(71)-A(72)-A(73)-A(74)-A(75)-A(76)-A(77)-A(78)-A(79)-A(80)-A(81)-A(82)-A(83)-A(84)-A(85) &
       -A(86))*f(2)+(A(23)+A(25)+A(34)+A(35)+A(42)+A(43)+A(49)+A(50)+A(53)+A(54)+A(59)+A(60)+A(63)+A(64))*f(3)+(A(19)+A(20)+A(21) &
       +A(22)+A(30)+A(31)+A(32)+A(33)+A(38)+A(39)+A(40)+A(41)+A(47)+A(48)+A(51)+A(52)+A(57)+A(58)+A(61)+A(62))*f(4)+(-A(24)-A(26) &
       -A(27)-A(28)-A(45)-A(46)-A(55)-A(56))*f(5)+A(17)*f(6)+(A(65)+A(70))*f(8)+(-A(36)-A(44))*f(9)+(-A(29)-A(37))*f(10) &
       -A(18)*f(11)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_nenexnmnmxbbxg_1_/**/REALKIND
