
module ol_colourmatrix_ppllllj_nenexeexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_nenexeexuuxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_nenexeexuuxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_nenexeexuuxg_1_/**/REALKIND

module ol_loop_ppllllj_nenexeexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(63), c(36)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:278)
  ! denominators
  complex(REALKIND), save :: den(412)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 2) = CI*eQED**4*gQCD
    f( 3) = (2*CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**4*gQCD**3
    f( 5) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 6) = (2*CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 7) = CI*countertermnorm*ctGqq*eQED**4*gQCD**3
    f( 8) = (2*CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 9) = CI*countertermnorm*ctVqq*eQED**4*gQCD**3
    f(10) = (2*countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(12) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(13) = (CI*eQED**4*gQCD)/(4._/**/REALKIND*sw**4)
    f(14) = (CI*countertermnorm*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(15) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(16) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(17) = (CI*cw*eQED**4*gQCD)/(2._/**/REALKIND*sw**3)
    f(18) = (CI*countertermnorm*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f(19) = (CI*countertermnorm*ctGqq*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f(20) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f(21) = (countertermnorm*ctZGG*cw*eQED**4*gQCD**3)/(sw**3*2._/**/REALKIND)
    f(22) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(23) = (CI*eQED**4*gQCD)/(3._/**/REALKIND*sw**2)
    f(24) = (CI*eQED**4*gQCD)/(2._/**/REALKIND*sw**2)
    f(25) = (CI*countertermnorm*eQED**4*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(26) = (CI*countertermnorm*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(27) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(28) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(29) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(3._/**/REALKIND*sw**2)
    f(30) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(31) = (CI*countertermnorm*ctWWGG*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(32) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/(sw**2*2._/**/REALKIND)
    f(33) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(34) = (2*CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(35) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(36) = (2*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(37) = eQED**4*gQCD**3*integralnorm*SwB
    f(38) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(4._/**/REALKIND*sw**4)
    f(39) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(40) = (CI*cw*eQED**4*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**3)
    f(41) = (cw*eQED**4*gQCD**3*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(42) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(3._/**/REALKIND*sw**2)
    f(43) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(44) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(45) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(46) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(47) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(48) = eQED**4*gQCD**3*integralnorm*SwF
    f(49) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(50) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(51) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(52) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(53) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(54) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(sw**4*4._/**/REALKIND)
    f(55) = (cw*eQED**4*gQCD**3*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(56) = (cw*eQED**4*gQCD**3*integralnorm*SwF)/sw**3
    f(57) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(58) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(59) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(60) = (2*eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(61) = (eQED**4*gQCD**3*integralnorm*SwF)/sw**2
    f(62) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(63) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(34), 9*CI*f(35), f(36), 8*f(36), f(37), 8*f(37), 9*CI*f(38), f(39), 8*f(39), 9*CI*f(40), f(41), 8*f(41), 9*CI*f(42) &
    , 9*CI*f(43), f(44), 8*f(44), f(45), 8*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50), 3*f(51), 3*f(52), 3*f(53), 3*f(54) &
    , 3*f(55), 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(222)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_A(P(:,6), rZERO, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,3),MZ,1_intkind1,wf(:,4))
  call prop_Q_A(wf(:,3),Q(:,80),ZERO,0_intkind1,wf(:,5))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,4),wf(:,6))
  call vert_VQ_A(wf(:,2),wf(:,5),wf(:,7))
  call prop_A_Q(wf(:,6),Q(:,35),ZERO,0_intkind1,wf(:,8))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,9))
  call prop_W_W(wf(:,9),Q(:,12),MZ,1_intkind1,wf(:,10))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,5),wf(:,11))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,12))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,5),wf(:,13))
  call prop_A_Q(wf(:,12),Q(:,44),ZERO,0_intkind1,wf(:,14))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,10),wf(:,15))
  call prop_A_Q(wf(:,15),Q(:,44),ZERO,0_intkind1,wf(:,16))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,17))
  call prop_A_Q(wf(:,17),Q(:,96),ZERO,0_intkind1,wf(:,18))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,-4),wf(:,19))
  call vert_AV_Q(wf(:,18),wf(:,2),wf(:,20))
  call prop_Q_A(wf(:,19),Q(:,19),ZERO,0_intkind1,wf(:,21))
  call vert_AZ_Q(gZu,wf(:,18),wf(:,10),wf(:,22))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,23))
  call vert_AZ_Q(gZu,wf(:,18),wf(:,4),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,28),ZERO,0_intkind1,wf(:,25))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,-4),wf(:,26))
  call prop_Q_A(wf(:,26),Q(:,28),ZERO,0_intkind1,wf(:,27))
  call vert_VQ_A(wf(:,-6),wf(:,21),wf(:,28))
  call vert_VQ_A(wf(:,-6),wf(:,25),wf(:,29))
  call vert_VQ_A(wf(:,-6),wf(:,27),wf(:,30))
  call vert_ZQ_A(gZl,wf(:,4),wf(:,-2),wf(:,31))
  call vert_QA_V(wf(:,5),wf(:,-5),wf(:,32))
  call prop_Q_A(wf(:,31),Q(:,7),ZERO,0_intkind1,wf(:,33))
  call vert_QA_V(wf(:,33),wf(:,-3),wf(:,34))
  call vert_QA_Z(gZu,wf(:,5),wf(:,-5),wf(:,35))
  call prop_W_W(wf(:,35),Q(:,112),MZ,1_intkind1,wf(:,36))
  call vert_QA_Z(gZl,wf(:,33),wf(:,-3),wf(:,37))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,4),wf(:,38))
  call prop_A_Q(wf(:,38),Q(:,11),ZERO,0_intkind1,wf(:,39))
  call vert_QA_V(wf(:,-2),wf(:,39),wf(:,40))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,39),wf(:,41))
  call vert_QA_V(wf(:,-4),wf(:,18),wf(:,42))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,18),wf(:,43))
  call prop_W_W(wf(:,43),Q(:,112),MZ,1_intkind1,wf(:,44))
  call vert_QA_W(wf(:,0),wf(:,-3),wf(:,45))
  call vert_QA_W(wf(:,-2),wf(:,-1),wf(:,46))
  call prop_W_W(wf(:,45),Q(:,9),MW,1_intkind1,wf(:,47))
  call prop_W_W(wf(:,46),Q(:,6),MW,1_intkind1,wf(:,48))
  call vert_AW_Q(wf(:,-5),wf(:,47),wf(:,49))
  call vert_WQ_A(wf(:,48),wf(:,5),wf(:,50))
  call prop_A_Q(wf(:,49),Q(:,41),ZERO,0_intkind1,wf(:,51))
  call vert_UV_W(wf(:,47),Q(:,9),wf(:,48),Q(:,6),wf(:,52))
  call vert_WQ_A(wf(:,48),wf(:,-4),wf(:,53))
  call vert_AW_Q(wf(:,18),wf(:,47),wf(:,54))
  call prop_Q_A(wf(:,53),Q(:,22),ZERO,0_intkind1,wf(:,55))
  call vert_VQ_A(wf(:,-6),wf(:,55),wf(:,56))
  call vert_WQ_A(wf(:,48),wf(:,0),wf(:,57))
  call prop_Q_A(wf(:,57),Q(:,7),ZERO,0_intkind1,wf(:,58))
  call vert_QA_V(wf(:,58),wf(:,-3),wf(:,59))
  call vert_QA_Z(gZl,wf(:,58),wf(:,-3),wf(:,60))
  call vert_AW_Q(wf(:,-3),wf(:,48),wf(:,61))
  call prop_A_Q(wf(:,61),Q(:,14),ZERO,0_intkind1,wf(:,62))
  call vert_QA_Z(gZn,wf(:,0),wf(:,62),wf(:,63))
  call vert_AW_Q(wf(:,-1),wf(:,47),wf(:,64))
  call prop_A_Q(wf(:,64),Q(:,11),ZERO,0_intkind1,wf(:,65))
  call vert_QA_V(wf(:,-2),wf(:,65),wf(:,66))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,65),wf(:,67))
  call vert_WQ_A(wf(:,47),wf(:,-2),wf(:,68))
  call prop_Q_A(wf(:,68),Q(:,13),ZERO,0_intkind1,wf(:,69))
  call vert_QA_Z(gZn,wf(:,69),wf(:,-1),wf(:,70))
  call vert_ZQ_A(gZn,wf(:,10),wf(:,0),wf(:,71))
  call prop_Q_A(wf(:,71),Q(:,13),ZERO,0_intkind1,wf(:,72))
  call vert_QA_Z(gZn,wf(:,72),wf(:,-1),wf(:,73))
  call vert_AZ_Q(gZn,wf(:,-1),wf(:,10),wf(:,74))
  call prop_A_Q(wf(:,74),Q(:,14),ZERO,0_intkind1,wf(:,75))
  call vert_QA_Z(gZn,wf(:,0),wf(:,75),wf(:,76))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,77))
  call counter_VVG_G(wf(:,4),wf(:,2),wf(:,-6),wf(:,78))
  call counter_VVG_G(wf(:,4),wf(:,10),wf(:,-6),wf(:,79))
  call counter_VVG_G(wf(:,48),wf(:,47),wf(:,-6),wf(:,80))
  call vert_VV_S(wf(:,4),wf(:,10),wf(:,81))
  call counter_GG_S(wf(:,77),wf(:,-6),wf(:,82))
  call counter_VQ_A(wf(:,2),wf(:,5),wf(:,83))
  call counter_ZQ_A(gZu,wf(:,10),wf(:,5),wf(:,84))
  call counter_ZQ_A(gZu,wf(:,4),wf(:,5),wf(:,85))
  call counter_AV_Q(wf(:,18),wf(:,2),wf(:,86))
  call counter_AZ_Q(gZu,wf(:,18),wf(:,10),wf(:,87))
  call counter_AZ_Q(gZu,wf(:,18),wf(:,4),wf(:,88))
  call counter_VQ_A(wf(:,-6),wf(:,21),wf(:,89))
  call counter_VG_G(wf(:,10),wf(:,-6),Q(:,64),wf(:,90),Q(:,76))
  call vert_QA_V(wf(:,21),wf(:,-5),wf(:,91))
  call counter_VQ_A(wf(:,-6),wf(:,25),wf(:,92))
  call counter_VQ_A(wf(:,-6),wf(:,27),wf(:,93))
  call vert_QA_V(wf(:,-4),wf(:,8),wf(:,94))
  call counter_VG_G(wf(:,4),wf(:,-6),Q(:,64),wf(:,95),Q(:,67))
  call vert_QA_V(wf(:,25),wf(:,-5),wf(:,96))
  call vert_QA_V(wf(:,27),wf(:,-5),wf(:,97))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,98))
  call vert_QA_V(wf(:,-4),wf(:,16),wf(:,99))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,100))
  call prop_Q_A(wf(:,13),Q(:,83),ZERO,0_intkind1,wf(:,101))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,10),wf(:,102))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,4),wf(:,103))
  call prop_Q_A(wf(:,7),Q(:,92),ZERO,0_intkind1,wf(:,104))
  call prop_Q_A(wf(:,11),Q(:,92),ZERO,0_intkind1,wf(:,105))
  call prop_A_Q(wf(:,100),Q(:,44),ZERO,0_intkind1,wf(:,106))
  call prop_A_Q(wf(:,102),Q(:,44),ZERO,0_intkind1,wf(:,107))
  call prop_A_Q(wf(:,103),Q(:,35),ZERO,0_intkind1,wf(:,108))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,109))
  call prop_A_Q(wf(:,109),Q(:,96),ZERO,0_intkind1,wf(:,110))
  call vert_AV_Q(wf(:,110),wf(:,2),wf(:,111))
  call vert_AZ_Q(gZu,wf(:,110),wf(:,10),wf(:,112))
  call vert_AZ_Q(gZu,wf(:,110),wf(:,4),wf(:,113))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,114))
  call prop_A_Q(wf(:,24),Q(:,99),ZERO,0_intkind1,wf(:,115))
  call counter_ZQ_A(gZu,wf(:,10),wf(:,-4),wf(:,116))
  call counter_ZQ_A(gZu,wf(:,4),wf(:,-4),wf(:,117))
  call prop_A_Q(wf(:,20),Q(:,108),ZERO,0_intkind1,wf(:,118))
  call prop_A_Q(wf(:,22),Q(:,108),ZERO,0_intkind1,wf(:,119))
  call prop_Q_A(wf(:,114),Q(:,28),ZERO,0_intkind1,wf(:,120))
  call vert_VQ_A(wf(:,-6),wf(:,120),wf(:,121))
  call prop_Q_A(wf(:,116),Q(:,28),ZERO,0_intkind1,wf(:,122))
  call vert_VQ_A(wf(:,-6),wf(:,122),wf(:,123))
  call prop_Q_A(wf(:,117),Q(:,19),ZERO,0_intkind1,wf(:,124))
  call vert_VQ_A(wf(:,-6),wf(:,124),wf(:,125))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,126))
  call prop_Q_A(wf(:,126),Q(:,80),ZERO,0_intkind1,wf(:,127))
  call vert_VQ_A(wf(:,2),wf(:,127),wf(:,128))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,127),wf(:,129))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,127),wf(:,130))
  call counter_GG_V(wf(:,77),Q(:,48),wf(:,-6),Q(:,64),wf(:,131))
  call prop_W_W(wf(:,131),Q(:,112),MZ,1_intkind1,wf(:,132))
  call counter_QA_V(wf(:,5),wf(:,-5),wf(:,133))
  call counter_QA_Z(gZu,wf(:,5),wf(:,-5),wf(:,134))
  call prop_W_W(wf(:,134),Q(:,112),MZ,1_intkind1,wf(:,135))
  call vert_QA_V(wf(:,-4),wf(:,110),wf(:,136))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,110),wf(:,137))
  call prop_W_W(wf(:,137),Q(:,112),MZ,1_intkind1,wf(:,138))
  call counter_QA_V(wf(:,-4),wf(:,18),wf(:,139))
  call counter_QA_Z(gZu,wf(:,-4),wf(:,18),wf(:,140))
  call prop_W_W(wf(:,140),Q(:,112),MZ,1_intkind1,wf(:,141))
  call vert_QA_V(wf(:,127),wf(:,-5),wf(:,142))
  call vert_QA_Z(gZu,wf(:,127),wf(:,-5),wf(:,143))
  call prop_W_W(wf(:,143),Q(:,112),MZ,1_intkind1,wf(:,144))
  call vert_VV_S(wf(:,48),wf(:,47),wf(:,145))
  call prop_W_W(wf(:,52),Q(:,15),MZ,1_intkind1,wf(:,146))
  call counter_WQ_A(wf(:,48),wf(:,5),wf(:,147))
  call counter_AW_Q(wf(:,18),wf(:,47),wf(:,148))
  call counter_VQ_A(wf(:,-6),wf(:,55),wf(:,149))
  call counter_AW_Q(wf(:,-5),wf(:,47),wf(:,150))
  call prop_Q_A(wf(:,50),Q(:,86),ZERO,0_intkind1,wf(:,151))
  call prop_A_Q(wf(:,150),Q(:,41),ZERO,0_intkind1,wf(:,152))
  call vert_AW_Q(wf(:,110),wf(:,47),wf(:,153))
  call counter_WQ_A(wf(:,48),wf(:,-4),wf(:,154))
  call prop_A_Q(wf(:,54),Q(:,105),ZERO,0_intkind1,wf(:,155))
  call prop_Q_A(wf(:,154),Q(:,22),ZERO,0_intkind1,wf(:,156))
  call vert_VQ_A(wf(:,-6),wf(:,156),wf(:,157))
  call vert_WQ_A(wf(:,48),wf(:,127),wf(:,158))
  call counter_Q_A(ctqq,wf(:,5),Q(:,80),wf(:,159))
  call prop_Q_A(wf(:,159),Q(:,80),ZERO,0_intkind1,wf(:,160))
  call vert_VQ_A(wf(:,2),wf(:,160),wf(:,161))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,160),wf(:,162))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,160),wf(:,163))
  call counter_A_Q(ctqq,wf(:,8),Q(:,35),wf(:,164))
  call counter_A_Q(ctqq,wf(:,14),Q(:,44),wf(:,165))
  call counter_A_Q(ctqq,wf(:,16),Q(:,44),wf(:,166))
  call counter_Q_A(ctqq,wf(:,21),Q(:,19),wf(:,167))
  call counter_Q_A(ctqq,wf(:,25),Q(:,28),wf(:,168))
  call counter_Q_A(ctqq,wf(:,27),Q(:,28),wf(:,169))
  call counter_A_Q(ctqq,wf(:,18),Q(:,96),wf(:,170))
  call prop_A_Q(wf(:,170),Q(:,96),ZERO,0_intkind1,wf(:,171))
  call vert_AV_Q(wf(:,171),wf(:,2),wf(:,172))
  call vert_AZ_Q(gZu,wf(:,171),wf(:,10),wf(:,173))
  call vert_AZ_Q(gZu,wf(:,171),wf(:,4),wf(:,174))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,175))
  call prop_A_Q(wf(:,175),Q(:,108),ZERO,0_intkind1,wf(:,176))
  call vert_AV_Q(wf(:,16),wf(:,-6),wf(:,177))
  call prop_A_Q(wf(:,177),Q(:,108),ZERO,0_intkind1,wf(:,178))
  call vert_AV_Q(wf(:,8),wf(:,-6),wf(:,179))
  call prop_A_Q(wf(:,179),Q(:,99),ZERO,0_intkind1,wf(:,180))
  call prop_Q_A(wf(:,28),Q(:,83),ZERO,0_intkind1,wf(:,181))
  call prop_Q_A(wf(:,29),Q(:,92),ZERO,0_intkind1,wf(:,182))
  call prop_Q_A(wf(:,30),Q(:,92),ZERO,0_intkind1,wf(:,183))
  call vert_QA_V(wf(:,160),wf(:,-5),wf(:,184))
  call vert_QA_Z(gZu,wf(:,160),wf(:,-5),wf(:,185))
  call prop_W_W(wf(:,37),Q(:,15),MZ,1_intkind1,wf(:,186))
  call prop_W_W(wf(:,41),Q(:,15),MZ,1_intkind1,wf(:,187))
  call vert_QA_V(wf(:,-4),wf(:,171),wf(:,188))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,171),wf(:,189))
  call vert_WQ_A(wf(:,48),wf(:,160),wf(:,190))
  call counter_A_Q(ctqq,wf(:,51),Q(:,41),wf(:,191))
  call counter_Q_A(ctqq,wf(:,55),Q(:,22),wf(:,192))
  call vert_AW_Q(wf(:,171),wf(:,47),wf(:,193))
  call vert_AV_Q(wf(:,51),wf(:,-6),wf(:,194))
  call prop_A_Q(wf(:,194),Q(:,105),ZERO,0_intkind1,wf(:,195))
  call prop_Q_A(wf(:,56),Q(:,86),ZERO,0_intkind1,wf(:,196))
  call prop_W_W(wf(:,60),Q(:,15),MZ,1_intkind1,wf(:,197))
  call prop_W_W(wf(:,63),Q(:,15),MZ,1_intkind1,wf(:,198))
  call prop_W_W(wf(:,67),Q(:,15),MZ,1_intkind1,wf(:,199))
  call prop_W_W(wf(:,70),Q(:,15),MZ,1_intkind1,wf(:,200))
  call prop_W_W(wf(:,73),Q(:,15),MZ,1_intkind1,wf(:,201))
  call prop_W_W(wf(:,76),Q(:,15),MZ,1_intkind1,wf(:,202))
  call vert_VQ_A(wf(:,2),wf(:,21),wf(:,203))
  call prop_Q_A(wf(:,203),Q(:,31),ZERO,0_intkind1,wf(:,204))
  call vert_ZQ_A(gZu,wf(:,10),wf(:,21),wf(:,205))
  call prop_Q_A(wf(:,205),Q(:,31),ZERO,0_intkind1,wf(:,206))
  call vert_AV_Q(wf(:,8),wf(:,2),wf(:,207))
  call prop_A_Q(wf(:,207),Q(:,47),ZERO,0_intkind1,wf(:,208))
  call vert_AZ_Q(gZu,wf(:,8),wf(:,10),wf(:,209))
  call prop_A_Q(wf(:,209),Q(:,47),ZERO,0_intkind1,wf(:,210))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,25),wf(:,211))
  call prop_Q_A(wf(:,211),Q(:,31),ZERO,0_intkind1,wf(:,212))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,27),wf(:,213))
  call prop_Q_A(wf(:,213),Q(:,31),ZERO,0_intkind1,wf(:,214))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,4),wf(:,215))
  call prop_A_Q(wf(:,215),Q(:,47),ZERO,0_intkind1,wf(:,216))
  call vert_AZ_Q(gZu,wf(:,16),wf(:,4),wf(:,217))
  call prop_A_Q(wf(:,217),Q(:,47),ZERO,0_intkind1,wf(:,218))
  call vert_VQ_A(wf(:,34),wf(:,-4),wf(:,219))
  call prop_Q_A(wf(:,219),Q(:,31),ZERO,0_intkind1,wf(:,220))
  call vert_ZQ_A(gZu,wf(:,186),wf(:,-4),wf(:,221))
  call prop_Q_A(wf(:,221),Q(:,31),ZERO,0_intkind1,wf(:,222))
  call vert_AV_Q(wf(:,-5),wf(:,34),wf(:,223))
  call prop_A_Q(wf(:,223),Q(:,47),ZERO,0_intkind1,wf(:,224))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,186),wf(:,225))
  call prop_A_Q(wf(:,225),Q(:,47),ZERO,0_intkind1,wf(:,226))
  call vert_VQ_A(wf(:,40),wf(:,-4),wf(:,227))
  call prop_Q_A(wf(:,227),Q(:,31),ZERO,0_intkind1,wf(:,228))
  call vert_ZQ_A(gZu,wf(:,187),wf(:,-4),wf(:,229))
  call prop_Q_A(wf(:,229),Q(:,31),ZERO,0_intkind1,wf(:,230))
  call vert_AV_Q(wf(:,-5),wf(:,40),wf(:,231))
  call prop_A_Q(wf(:,231),Q(:,47),ZERO,0_intkind1,wf(:,232))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,187),wf(:,233))
  call prop_A_Q(wf(:,233),Q(:,47),ZERO,0_intkind1,wf(:,234))
  call vert_AW_Q(wf(:,51),wf(:,48),wf(:,235))
  call prop_A_Q(wf(:,235),Q(:,47),ZERO,0_intkind1,wf(:,236))
  call vert_WQ_A(wf(:,47),wf(:,55),wf(:,237))
  call prop_Q_A(wf(:,237),Q(:,31),ZERO,0_intkind1,wf(:,238))
  call vert_VQ_A(wf(:,52),wf(:,-4),wf(:,239))
  call prop_Q_A(wf(:,239),Q(:,31),ZERO,0_intkind1,wf(:,240))
  call vert_ZQ_A(gZu,wf(:,146),wf(:,-4),wf(:,241))
  call prop_Q_A(wf(:,241),Q(:,31),ZERO,0_intkind1,wf(:,242))
  call vert_AV_Q(wf(:,-5),wf(:,52),wf(:,243))
  call prop_A_Q(wf(:,243),Q(:,47),ZERO,0_intkind1,wf(:,244))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,146),wf(:,245))
  call prop_A_Q(wf(:,245),Q(:,47),ZERO,0_intkind1,wf(:,246))
  call vert_VQ_A(wf(:,59),wf(:,-4),wf(:,247))
  call prop_Q_A(wf(:,247),Q(:,31),ZERO,0_intkind1,wf(:,248))
  call vert_ZQ_A(gZu,wf(:,197),wf(:,-4),wf(:,249))
  call prop_Q_A(wf(:,249),Q(:,31),ZERO,0_intkind1,wf(:,250))
  call vert_AV_Q(wf(:,-5),wf(:,59),wf(:,251))
  call prop_A_Q(wf(:,251),Q(:,47),ZERO,0_intkind1,wf(:,252))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,197),wf(:,253))
  call prop_A_Q(wf(:,253),Q(:,47),ZERO,0_intkind1,wf(:,254))
  call vert_ZQ_A(gZu,wf(:,198),wf(:,-4),wf(:,255))
  call prop_Q_A(wf(:,255),Q(:,31),ZERO,0_intkind1,wf(:,256))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,198),wf(:,257))
  call prop_A_Q(wf(:,257),Q(:,47),ZERO,0_intkind1,wf(:,258))
  call vert_VQ_A(wf(:,66),wf(:,-4),wf(:,259))
  call prop_Q_A(wf(:,259),Q(:,31),ZERO,0_intkind1,wf(:,260))
  call vert_ZQ_A(gZu,wf(:,199),wf(:,-4),wf(:,261))
  call prop_Q_A(wf(:,261),Q(:,31),ZERO,0_intkind1,wf(:,262))
  call vert_AV_Q(wf(:,-5),wf(:,66),wf(:,263))
  call prop_A_Q(wf(:,263),Q(:,47),ZERO,0_intkind1,wf(:,264))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,199),wf(:,265))
  call prop_A_Q(wf(:,265),Q(:,47),ZERO,0_intkind1,wf(:,266))
  call vert_ZQ_A(gZu,wf(:,200),wf(:,-4),wf(:,267))
  call prop_Q_A(wf(:,267),Q(:,31),ZERO,0_intkind1,wf(:,268))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,200),wf(:,269))
  call prop_A_Q(wf(:,269),Q(:,47),ZERO,0_intkind1,wf(:,270))
  call vert_ZQ_A(gZu,wf(:,201),wf(:,-4),wf(:,271))
  call prop_Q_A(wf(:,271),Q(:,31),ZERO,0_intkind1,wf(:,272))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,201),wf(:,273))
  call prop_A_Q(wf(:,273),Q(:,47),ZERO,0_intkind1,wf(:,274))
  call vert_ZQ_A(gZu,wf(:,202),wf(:,-4),wf(:,275))
  call prop_Q_A(wf(:,275),Q(:,31),ZERO,0_intkind1,wf(:,276))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,202),wf(:,277))
  call prop_A_Q(wf(:,277),Q(:,47),ZERO,0_intkind1,wf(:,278))


  ! propagators

    den(1) = 1 / (Q(5,3) - MZ2)
    den(2) = 1 / (Q(5,12))
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,35))
    den(8) = 1 / (Q(5,12) - MZ2)
    den(12) = 1 / (Q(5,44))
    den(17) = 1 / (Q(5,96))
    den(19) = 1 / (Q(5,19))
    den(25) = 1 / (Q(5,28))
    den(34) = 1 / (Q(5,7))
    den(36) = 1 / (Q(5,112))
    den(39) = 1 / (Q(5,112) - MZ2)
    den(42) = 1 / (Q(5,11))
    den(52) = 1 / (Q(5,9) - MW2)
    den(53) = 1 / (Q(5,6) - MW2)
    den(55) = 1 / (Q(5,41))
    den(62) = 1 / (Q(5,22))
    den(71) = 1 / (Q(5,14))
    den(80) = 1 / (Q(5,13))
    den(92) = 1 / (Q(5,48))
    den(98) = 1 / (Q(5,15) - MH2)
    den(101) = 1 / (Q(5,76))
    den(105) = 1 / (Q(5,67))
    den(111) = 1 / (Q(5,83))
    den(115) = 1 / (Q(5,92))
    den(120) = 1 / (Q(5,99))
    den(124) = 1 / (Q(5,108))
    den(134) = 1 / (Q(5,15) - MZ2)
    den(137) = 1 / (Q(5,15))
    den(141) = 1 / (Q(5,86))
    den(146) = 1 / (Q(5,105))
    den(243) = 1 / (Q(5,51))
    den(246) = 1 / (Q(5,31))
    den(252) = 1 / (Q(5,47))
    den(256) = 1 / (Q(5,60))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(11) = den(1)*den(3)
    den(13) = den(2)*den(12)
    den(14) = den(11)*den(13)
    den(15) = den(8)*den(12)
    den(16) = den(11)*den(15)
    den(18) = den(2)*den(17)
    den(20) = den(1)*den(19)
    den(21) = den(18)*den(20)
    den(22) = den(8)*den(17)
    den(23) = den(20)*den(22)
    den(24) = den(1)*den(17)
    den(26) = den(2)*den(25)
    den(27) = den(24)*den(26)
    den(28) = den(8)*den(25)
    den(29) = den(24)*den(28)
    den(30) = den(13)*den(20)
    den(31) = den(15)*den(20)
    den(32) = den(6)*den(26)
    den(33) = den(6)*den(28)
    den(35) = den(1)*den(34)
    den(37) = den(3)*den(36)
    den(38) = den(35)*den(37)
    den(40) = den(3)*den(39)
    den(41) = den(35)*den(40)
    den(43) = den(1)*den(42)
    den(44) = den(37)*den(43)
    den(45) = den(40)*den(43)
    den(46) = den(17)*den(36)
    den(47) = den(35)*den(46)
    den(48) = den(17)*den(39)
    den(49) = den(35)*den(48)
    den(50) = den(43)*den(46)
    den(51) = den(43)*den(48)
    den(54) = den(3)*den(53)
    den(56) = den(52)*den(55)
    den(57) = den(54)*den(56)
    den(58) = den(52)*den(53)
    den(59) = den(37)*den(58)
    den(60) = den(40)*den(58)
    den(61) = den(17)*den(52)
    den(63) = den(53)*den(62)
    den(64) = den(61)*den(63)
    den(65) = den(46)*den(58)
    den(66) = den(48)*den(58)
    den(67) = den(56)*den(63)
    den(68) = den(34)*den(53)
    den(69) = den(37)*den(68)
    den(70) = den(40)*den(68)
    den(72) = den(53)*den(71)
    den(73) = den(40)*den(72)
    den(74) = den(46)*den(68)
    den(75) = den(48)*den(68)
    den(76) = den(48)*den(72)
    den(77) = den(42)*den(52)
    den(78) = den(37)*den(77)
    den(79) = den(40)*den(77)
    den(81) = den(52)*den(80)
    den(82) = den(40)*den(81)
    den(83) = den(46)*den(77)
    den(84) = den(48)*den(77)
    den(85) = den(48)*den(81)
    den(86) = den(8)*den(80)
    den(87) = den(40)*den(86)
    den(88) = den(8)*den(71)
    den(89) = den(40)*den(88)
    den(90) = den(48)*den(86)
    den(91) = den(48)*den(88)
    den(93) = den(1)*den(2)
    den(94) = den(92)*den(93)
    den(95) = den(1)*den(8)
    den(96) = den(92)*den(95)
    den(97) = den(58)*den(92)
    den(99) = den(95)*den(98)
    den(100) = den(92)*den(99)
    den(102) = den(8)*den(101)
    den(103) = den(20)*den(102)
    den(104) = den(6)*den(102)
    den(106) = den(1)*den(105)
    den(107) = den(26)*den(106)
    den(108) = den(28)*den(106)
    den(109) = den(13)*den(106)
    den(110) = den(15)*den(106)
    den(112) = den(11)*den(111)
    den(113) = den(2)*den(112)
    den(114) = den(8)*den(112)
    den(116) = den(4)*den(115)
    den(117) = den(1)*den(116)
    den(118) = den(9)*den(115)
    den(119) = den(1)*den(118)
    den(121) = den(24)*den(120)
    den(122) = den(2)*den(121)
    den(123) = den(8)*den(121)
    den(125) = den(18)*den(124)
    den(126) = den(1)*den(125)
    den(127) = den(22)*den(124)
    den(128) = den(1)*den(127)
    den(129) = den(39)*den(92)
    den(130) = den(35)*den(129)
    den(131) = den(43)*den(129)
    den(132) = den(58)*den(98)
    den(133) = den(92)*den(132)
    den(135) = den(58)*den(134)
    den(136) = den(92)*den(135)
    den(138) = den(58)*den(137)
    den(139) = den(3)*den(138)
    den(140) = den(3)*den(135)
    den(142) = den(54)*den(141)
    den(143) = den(52)*den(142)
    den(144) = den(17)*den(138)
    den(145) = den(17)*den(135)
    den(147) = den(61)*den(146)
    den(148) = den(53)*den(147)
    den(149) = den(68)*den(129)
    den(150) = den(72)*den(129)
    den(151) = den(77)*den(129)
    den(152) = den(81)*den(129)
    den(153) = den(86)*den(129)
    den(154) = den(88)*den(129)
    den(155) = den(3)**2
    den(156) = den(2)*den(155)
    den(157) = den(6)*den(156)
    den(158) = den(8)*den(155)
    den(159) = den(6)*den(158)
    den(160) = den(1)*den(155)
    den(161) = den(13)*den(160)
    den(162) = den(15)*den(160)
    den(163) = den(6)*den(116)
    den(164) = den(6)*den(118)
    den(165) = den(13)*den(112)
    den(166) = den(15)*den(112)
    den(167) = den(20)*den(125)
    den(168) = den(20)*den(127)
    den(169) = den(26)*den(121)
    den(170) = den(28)*den(121)
    den(171) = den(17)**2
    den(172) = den(2)*den(171)
    den(173) = den(20)*den(172)
    den(174) = den(8)*den(171)
    den(175) = den(20)*den(174)
    den(176) = den(1)*den(171)
    den(177) = den(26)*den(176)
    den(178) = den(28)*den(176)
    den(179) = den(13)*den(124)
    den(180) = den(20)*den(179)
    den(181) = den(15)*den(124)
    den(182) = den(20)*den(181)
    den(183) = den(6)*den(120)
    den(184) = den(26)*den(183)
    den(185) = den(28)*den(183)
    den(186) = den(20)*den(111)
    den(187) = den(13)*den(186)
    den(188) = den(15)*den(186)
    den(189) = den(26)*den(115)
    den(190) = den(6)*den(189)
    den(191) = den(28)*den(115)
    den(192) = den(6)*den(191)
    den(193) = den(35)*den(137)
    den(194) = den(155)*den(193)
    den(195) = den(35)*den(134)
    den(196) = den(155)*den(195)
    den(197) = den(43)*den(137)
    den(198) = den(155)*den(197)
    den(199) = den(43)*den(134)
    den(200) = den(155)*den(199)
    den(201) = den(171)*den(193)
    den(202) = den(171)*den(195)
    den(203) = den(171)*den(197)
    den(204) = den(171)*den(199)
    den(205) = den(138)*den(155)
    den(206) = den(135)*den(155)
    den(207) = den(53)*den(155)
    den(208) = den(56)*den(207)
    den(209) = den(56)*den(142)
    den(210) = den(138)*den(171)
    den(211) = den(135)*den(171)
    den(212) = den(63)*den(147)
    den(213) = den(52)*den(171)
    den(214) = den(63)*den(213)
    den(215) = den(56)*den(146)
    den(216) = den(63)*den(215)
    den(217) = den(63)*den(141)
    den(218) = den(56)*den(217)
    den(219) = den(68)*den(137)
    den(220) = den(155)*den(219)
    den(221) = den(68)*den(134)
    den(222) = den(155)*den(221)
    den(223) = den(72)*den(134)
    den(224) = den(155)*den(223)
    den(225) = den(171)*den(219)
    den(226) = den(171)*den(221)
    den(227) = den(171)*den(223)
    den(228) = den(77)*den(137)
    den(229) = den(155)*den(228)
    den(230) = den(77)*den(134)
    den(231) = den(155)*den(230)
    den(232) = den(81)*den(134)
    den(233) = den(155)*den(232)
    den(234) = den(171)*den(228)
    den(235) = den(171)*den(230)
    den(236) = den(171)*den(232)
    den(237) = den(86)*den(134)
    den(238) = den(155)*den(237)
    den(239) = den(88)*den(134)
    den(240) = den(155)*den(239)
    den(241) = den(171)*den(237)
    den(242) = den(171)*den(239)
    den(244) = den(20)*den(243)
    den(245) = den(2)*den(20)
    den(247) = den(245)*den(246)
    den(248) = den(8)*den(20)
    den(249) = den(246)*den(248)
    den(250) = den(6)*den(243)
    den(251) = den(2)*den(6)
    den(253) = den(251)*den(252)
    den(254) = den(6)*den(8)
    den(255) = den(252)*den(254)
    den(257) = den(26)*den(256)
    den(258) = den(28)*den(256)
    den(259) = den(1)*den(26)
    den(260) = den(246)*den(259)
    den(261) = den(1)*den(28)
    den(262) = den(246)*den(261)
    den(263) = den(13)*den(256)
    den(264) = den(15)*den(256)
    den(265) = den(1)*den(13)
    den(266) = den(252)*den(265)
    den(267) = den(1)*den(15)
    den(268) = den(252)*den(267)
    den(269) = den(193)*den(246)
    den(270) = den(195)*den(246)
    den(271) = den(193)*den(252)
    den(272) = den(195)*den(252)
    den(273) = den(197)*den(246)
    den(274) = den(199)*den(246)
    den(275) = den(197)*den(252)
    den(276) = den(199)*den(252)
    den(277) = den(53)*den(56)
    den(278) = den(252)*den(277)
    den(279) = den(52)*den(63)
    den(280) = den(246)*den(279)
    den(281) = den(138)*den(246)
    den(282) = den(135)*den(246)
    den(283) = den(138)*den(252)
    den(284) = den(135)*den(252)
    den(285) = den(219)*den(246)
    den(286) = den(221)*den(246)
    den(287) = den(219)*den(252)
    den(288) = den(221)*den(252)
    den(289) = den(223)*den(246)
    den(290) = den(223)*den(252)
    den(291) = den(228)*den(246)
    den(292) = den(230)*den(246)
    den(293) = den(228)*den(252)
    den(294) = den(230)*den(252)
    den(295) = den(232)*den(246)
    den(296) = den(232)*den(252)
    den(297) = den(237)*den(246)
    den(298) = den(237)*den(252)
    den(299) = den(239)*den(246)
    den(300) = den(239)*den(252)
    den(301) = den(1)*den(2)*den(92)
    den(302) = den(1)*den(8)*den(92)
    den(303) = den(2)*den(3)*den(6)
    den(304) = den(3)*den(6)*den(8)
    den(305) = den(1)*den(3)*den(13)
    den(306) = den(1)*den(3)*den(15)
    den(307) = den(1)*den(2)*den(3)
    den(308) = den(1)*den(3)*den(8)
    den(309) = den(2)*den(17)*den(20)
    den(310) = den(8)*den(17)*den(20)
    den(311) = den(1)*den(17)*den(26)
    den(312) = den(1)*den(17)*den(28)
    den(313) = den(1)*den(2)*den(17)
    den(314) = den(1)*den(8)*den(17)
    den(315) = den(2)*den(244)
    den(316) = den(8)*den(244)
    den(317) = den(2)*den(186)
    den(318) = den(8)*den(186)
    den(319) = den(2)*den(250)
    den(320) = den(8)*den(250)
    den(321) = den(2)*den(183)
    den(322) = den(8)*den(183)
    den(323) = den(1)*den(257)
    den(324) = den(1)*den(258)
    den(325) = den(1)*den(189)
    den(326) = den(1)*den(191)
    den(327) = den(1)*den(263)
    den(328) = den(1)*den(264)
    den(329) = den(1)*den(179)
    den(330) = den(1)*den(181)
    den(331) = den(92)*den(193)
    den(332) = den(92)*den(195)
    den(333) = den(92)*den(197)
    den(334) = den(92)*den(199)
    den(335) = den(3)*den(193)
    den(336) = den(3)*den(195)
    den(337) = den(3)*den(197)
    den(338) = den(3)*den(199)
    den(339) = den(17)*den(193)
    den(340) = den(17)*den(195)
    den(341) = den(17)*den(197)
    den(342) = den(17)*den(199)
    den(343) = den(92)*den(138)
    den(344) = den(52)*den(53)*den(92)
    den(345) = den(3)*den(53)*den(56)
    den(346) = den(3)*den(52)*den(53)
    den(347) = den(17)*den(52)*den(63)
    den(348) = den(17)*den(52)*den(53)
    den(349) = den(53)*den(215)
    den(350) = den(52)*den(217)
    den(351) = den(92)*den(219)
    den(352) = den(92)*den(221)
    den(353) = den(92)*den(223)
    den(354) = den(3)*den(219)
    den(355) = den(3)*den(221)
    den(356) = den(3)*den(223)
    den(357) = den(17)*den(219)
    den(358) = den(17)*den(221)
    den(359) = den(17)*den(223)
    den(360) = den(92)*den(228)
    den(361) = den(92)*den(230)
    den(362) = den(92)*den(232)
    den(363) = den(3)*den(228)
    den(364) = den(3)*den(230)
    den(365) = den(3)*den(232)
    den(366) = den(17)*den(228)
    den(367) = den(17)*den(230)
    den(368) = den(17)*den(232)
    den(369) = den(92)*den(237)
    den(370) = den(92)*den(239)
    den(371) = den(3)*den(237)
    den(372) = den(3)*den(239)
    den(373) = den(17)*den(237)
    den(374) = den(17)*den(239)
    den(375) = den(3)*den(253)
    den(376) = den(3)*den(255)
    den(377) = den(3)*den(266)
    den(378) = den(3)*den(268)
    den(379) = den(17)*den(247)
    den(380) = den(17)*den(249)
    den(381) = den(17)*den(260)
    den(382) = den(17)*den(262)
    den(383) = den(3)*den(271)
    den(384) = den(3)*den(272)
    den(385) = den(3)*den(275)
    den(386) = den(3)*den(276)
    den(387) = den(17)*den(269)
    den(388) = den(17)*den(270)
    den(389) = den(17)*den(273)
    den(390) = den(17)*den(274)
    den(391) = den(3)*den(278)
    den(392) = den(3)*den(283)
    den(393) = den(3)*den(284)
    den(394) = den(17)*den(280)
    den(395) = den(17)*den(281)
    den(396) = den(17)*den(282)
    den(397) = den(3)*den(287)
    den(398) = den(3)*den(288)
    den(399) = den(3)*den(290)
    den(400) = den(17)*den(285)
    den(401) = den(17)*den(286)
    den(402) = den(17)*den(289)
    den(403) = den(3)*den(293)
    den(404) = den(3)*den(294)
    den(405) = den(3)*den(296)
    den(406) = den(17)*den(291)
    den(407) = den(17)*den(292)
    den(408) = den(17)*den(295)
    den(409) = den(3)*den(298)
    den(410) = den(3)*den(300)
    den(411) = den(17)*den(297)
    den(412) = den(17)*den(299)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,7),wf(:,8)) * den(7)
  A(2) = cont_QA(wf(:,8),wf(:,11)) * den(10)
  A(3) = cont_QA(wf(:,13),wf(:,14)) * den(14)
  A(4) = cont_QA(wf(:,13),wf(:,16)) * den(16)
  A(5) = cont_QA(wf(:,20),wf(:,21)) * den(21)
  A(6) = cont_QA(wf(:,21),wf(:,22)) * den(23)
  A(7) = cont_QA(wf(:,24),wf(:,25)) * den(27)
  A(8) = cont_QA(wf(:,24),wf(:,27)) * den(29)
  A(9) = cont_QA(wf(:,14),wf(:,28)) * den(30)
  A(10) = cont_QA(wf(:,16),wf(:,28)) * den(31)
  A(11) = cont_QA(wf(:,8),wf(:,29)) * den(32)
  A(12) = cont_QA(wf(:,8),wf(:,30)) * den(33)
  A(13) = cont_VV(wf(:,32),wf(:,34)) * den(38)
  A(14) = cont_VV(wf(:,36),wf(:,37)) * den(41)
  A(15) = cont_VV(wf(:,32),wf(:,40)) * den(44)
  A(16) = cont_VV(wf(:,36),wf(:,41)) * den(45)
  A(17) = cont_VV(wf(:,34),wf(:,42)) * den(47)
  A(18) = cont_VV(wf(:,37),wf(:,44)) * den(49)
  A(19) = cont_VV(wf(:,40),wf(:,42)) * den(50)
  A(20) = cont_VV(wf(:,41),wf(:,44)) * den(51)
  A(21) = cont_QA(wf(:,50),wf(:,51)) * den(57)
  A(22) = cont_VV(wf(:,32),wf(:,52)) * den(59)
  A(23) = cont_VV(wf(:,36),wf(:,52)) * den(60)
  A(24) = cont_QA(wf(:,54),wf(:,55)) * den(64)
  A(25) = cont_VV(wf(:,42),wf(:,52)) * den(65)
  A(26) = cont_VV(wf(:,44),wf(:,52)) * den(66)
  A(27) = cont_QA(wf(:,51),wf(:,56)) * den(67)
  A(28) = cont_VV(wf(:,32),wf(:,59)) * den(69)
  A(29) = cont_VV(wf(:,36),wf(:,60)) * den(70)
  A(30) = cont_VV(wf(:,36),wf(:,63)) * den(73)
  A(31) = cont_VV(wf(:,42),wf(:,59)) * den(74)
  A(32) = cont_VV(wf(:,44),wf(:,60)) * den(75)
  A(33) = cont_VV(wf(:,44),wf(:,63)) * den(76)
  A(34) = cont_VV(wf(:,32),wf(:,66)) * den(78)
  A(35) = cont_VV(wf(:,36),wf(:,67)) * den(79)
  A(36) = cont_VV(wf(:,36),wf(:,70)) * den(82)
  A(37) = cont_VV(wf(:,42),wf(:,66)) * den(83)
  A(38) = cont_VV(wf(:,44),wf(:,67)) * den(84)
  A(39) = cont_VV(wf(:,44),wf(:,70)) * den(85)
  A(40) = cont_VV(wf(:,36),wf(:,73)) * den(87)
  A(41) = cont_VV(wf(:,36),wf(:,76)) * den(89)
  A(42) = cont_VV(wf(:,44),wf(:,73)) * den(90)
  A(43) = cont_VV(wf(:,44),wf(:,76)) * den(91)

  A(44) = cont_VV(wf(:,77),wf(:,78)) * den(94)
  A(45) = cont_VV(wf(:,77),wf(:,79)) * den(96)
  A(46) = cont_VV(wf(:,77),wf(:,80)) * den(97)
  A(47) = cont_SS(wf(:,81),wf(:,82)) * den(100)
  A(48) = cont_QA(wf(:,8),wf(:,83)) * den(7)
  A(49) = cont_QA(wf(:,8),wf(:,84)) * den(10)
  A(50) = cont_QA(wf(:,14),wf(:,85)) * den(14)
  A(51) = cont_QA(wf(:,16),wf(:,85)) * den(16)
  A(52) = cont_QA(wf(:,21),wf(:,86)) * den(21)
  A(53) = cont_QA(wf(:,21),wf(:,87)) * den(23)
  A(54) = cont_QA(wf(:,25),wf(:,88)) * den(27)
  A(55) = cont_QA(wf(:,27),wf(:,88)) * den(29)
  A(56) = cont_QA(wf(:,14),wf(:,89)) * den(30)
  A(57) = cont_QA(wf(:,16),wf(:,89)) * den(31)
  A(58) = cont_VV(wf(:,90),wf(:,91)) * den(103)
  A(59) = cont_QA(wf(:,8),wf(:,92)) * den(32)
  A(60) = cont_QA(wf(:,8),wf(:,93)) * den(33)
  A(61) = cont_VV(wf(:,90),wf(:,94)) * den(104)
  A(62) = cont_VV(wf(:,95),wf(:,96)) * den(107)
  A(63) = cont_VV(wf(:,95),wf(:,97)) * den(108)
  A(64) = cont_VV(wf(:,95),wf(:,98)) * den(109)
  A(65) = cont_VV(wf(:,95),wf(:,99)) * den(110)
  A(66) = cont_QA(wf(:,100),wf(:,101)) * den(113)
  A(67) = cont_QA(wf(:,101),wf(:,102)) * den(114)
  A(68) = cont_QA(wf(:,103),wf(:,104)) * den(117)
  A(69) = cont_QA(wf(:,103),wf(:,105)) * den(119)
  A(70) = cont_QA(wf(:,28),wf(:,106)) * den(30)
  A(71) = cont_QA(wf(:,28),wf(:,107)) * den(31)
  A(72) = cont_QA(wf(:,29),wf(:,108)) * den(32)
  A(73) = cont_QA(wf(:,30),wf(:,108)) * den(33)
  A(74) = cont_QA(wf(:,21),wf(:,111)) * den(21)
  A(75) = cont_QA(wf(:,21),wf(:,112)) * den(23)
  A(76) = cont_QA(wf(:,25),wf(:,113)) * den(27)
  A(77) = cont_QA(wf(:,27),wf(:,113)) * den(29)
  A(78) = cont_QA(wf(:,114),wf(:,115)) * den(122)
  A(79) = cont_QA(wf(:,115),wf(:,116)) * den(123)
  A(80) = cont_QA(wf(:,117),wf(:,118)) * den(126)
  A(81) = cont_QA(wf(:,117),wf(:,119)) * den(128)
  A(82) = cont_QA(wf(:,8),wf(:,121)) * den(32)
  A(83) = cont_QA(wf(:,8),wf(:,123)) * den(33)
  A(84) = cont_QA(wf(:,14),wf(:,125)) * den(30)
  A(85) = cont_QA(wf(:,16),wf(:,125)) * den(31)
  A(86) = cont_QA(wf(:,8),wf(:,128)) * den(7)
  A(87) = cont_QA(wf(:,8),wf(:,129)) * den(10)
  A(88) = cont_QA(wf(:,14),wf(:,130)) * den(14)
  A(89) = cont_QA(wf(:,16),wf(:,130)) * den(16)
  A(90) = cont_VV(wf(:,37),wf(:,132)) * den(130)
  A(91) = cont_VV(wf(:,41),wf(:,132)) * den(131)
  A(92) = cont_VV(wf(:,34),wf(:,133)) * den(38)
  A(93) = cont_VV(wf(:,37),wf(:,135)) * den(41)
  A(94) = cont_VV(wf(:,40),wf(:,133)) * den(44)
  A(95) = cont_VV(wf(:,41),wf(:,135)) * den(45)
  A(96) = cont_VV(wf(:,34),wf(:,136)) * den(47)
  A(97) = cont_VV(wf(:,37),wf(:,138)) * den(49)
  A(98) = cont_VV(wf(:,40),wf(:,136)) * den(50)
  A(99) = cont_VV(wf(:,41),wf(:,138)) * den(51)
  A(100) = cont_VV(wf(:,34),wf(:,139)) * den(47)
  A(101) = cont_VV(wf(:,37),wf(:,141)) * den(49)
  A(102) = cont_VV(wf(:,40),wf(:,139)) * den(50)
  A(103) = cont_VV(wf(:,41),wf(:,141)) * den(51)
  A(104) = cont_VV(wf(:,34),wf(:,142)) * den(38)
  A(105) = cont_VV(wf(:,37),wf(:,144)) * den(41)
  A(106) = cont_VV(wf(:,40),wf(:,142)) * den(44)
  A(107) = cont_VV(wf(:,41),wf(:,144)) * den(45)
  A(108) = cont_SS(wf(:,82),wf(:,145)) * den(133)
  A(109) = cont_VV(wf(:,131),wf(:,146)) * den(136)
  A(110) = cont_QA(wf(:,51),wf(:,147)) * den(57)
  A(111) = cont_QA(wf(:,55),wf(:,148)) * den(64)
  A(112) = cont_QA(wf(:,51),wf(:,149)) * den(67)
  A(113) = cont_VV(wf(:,52),wf(:,133)) * den(139)
  A(114) = cont_VV(wf(:,134),wf(:,146)) * den(140)
  A(115) = cont_QA(wf(:,150),wf(:,151)) * den(143)
  A(116) = cont_QA(wf(:,56),wf(:,152)) * den(67)
  A(117) = cont_QA(wf(:,55),wf(:,153)) * den(64)
  A(118) = cont_VV(wf(:,52),wf(:,136)) * den(65)
  A(119) = cont_VV(wf(:,52),wf(:,138)) * den(66)
  A(120) = cont_VV(wf(:,52),wf(:,139)) * den(144)
  A(121) = cont_VV(wf(:,140),wf(:,146)) * den(145)
  A(122) = cont_QA(wf(:,154),wf(:,155)) * den(148)
  A(123) = cont_QA(wf(:,51),wf(:,157)) * den(67)
  A(124) = cont_QA(wf(:,51),wf(:,158)) * den(57)
  A(125) = cont_VV(wf(:,52),wf(:,142)) * den(59)
  A(126) = cont_VV(wf(:,52),wf(:,144)) * den(60)
  A(127) = cont_VV(wf(:,60),wf(:,132)) * den(149)
  A(128) = cont_VV(wf(:,63),wf(:,132)) * den(150)
  A(129) = cont_VV(wf(:,59),wf(:,133)) * den(69)
  A(130) = cont_VV(wf(:,60),wf(:,135)) * den(70)
  A(131) = cont_VV(wf(:,63),wf(:,135)) * den(73)
  A(132) = cont_VV(wf(:,59),wf(:,136)) * den(74)
  A(133) = cont_VV(wf(:,60),wf(:,138)) * den(75)
  A(134) = cont_VV(wf(:,63),wf(:,138)) * den(76)
  A(135) = cont_VV(wf(:,59),wf(:,139)) * den(74)
  A(136) = cont_VV(wf(:,60),wf(:,141)) * den(75)
  A(137) = cont_VV(wf(:,63),wf(:,141)) * den(76)
  A(138) = cont_VV(wf(:,59),wf(:,142)) * den(69)
  A(139) = cont_VV(wf(:,60),wf(:,144)) * den(70)
  A(140) = cont_VV(wf(:,63),wf(:,144)) * den(73)
  A(141) = cont_VV(wf(:,67),wf(:,132)) * den(151)
  A(142) = cont_VV(wf(:,70),wf(:,132)) * den(152)
  A(143) = cont_VV(wf(:,66),wf(:,133)) * den(78)
  A(144) = cont_VV(wf(:,67),wf(:,135)) * den(79)
  A(145) = cont_VV(wf(:,70),wf(:,135)) * den(82)
  A(146) = cont_VV(wf(:,66),wf(:,136)) * den(83)
  A(147) = cont_VV(wf(:,67),wf(:,138)) * den(84)
  A(148) = cont_VV(wf(:,70),wf(:,138)) * den(85)
  A(149) = cont_VV(wf(:,66),wf(:,139)) * den(83)
  A(150) = cont_VV(wf(:,67),wf(:,141)) * den(84)
  A(151) = cont_VV(wf(:,70),wf(:,141)) * den(85)
  A(152) = cont_VV(wf(:,66),wf(:,142)) * den(78)
  A(153) = cont_VV(wf(:,67),wf(:,144)) * den(79)
  A(154) = cont_VV(wf(:,70),wf(:,144)) * den(82)
  A(155) = cont_VV(wf(:,73),wf(:,132)) * den(153)
  A(156) = cont_VV(wf(:,76),wf(:,132)) * den(154)
  A(157) = cont_VV(wf(:,73),wf(:,135)) * den(87)
  A(158) = cont_VV(wf(:,76),wf(:,135)) * den(89)
  A(159) = cont_VV(wf(:,73),wf(:,138)) * den(90)
  A(160) = cont_VV(wf(:,76),wf(:,138)) * den(91)
  A(161) = cont_VV(wf(:,73),wf(:,141)) * den(90)
  A(162) = cont_VV(wf(:,76),wf(:,141)) * den(91)
  A(163) = cont_VV(wf(:,73),wf(:,144)) * den(87)
  A(164) = cont_VV(wf(:,76),wf(:,144)) * den(89)
  A(165) = cont_QA(wf(:,8),wf(:,161)) * den(157)
  A(166) = cont_QA(wf(:,8),wf(:,162)) * den(159)
  A(167) = cont_QA(wf(:,14),wf(:,163)) * den(161)
  A(168) = cont_QA(wf(:,16),wf(:,163)) * den(162)
  A(169) = cont_QA(wf(:,104),wf(:,164)) * den(163)
  A(170) = cont_QA(wf(:,105),wf(:,164)) * den(164)
  A(171) = cont_QA(wf(:,101),wf(:,165)) * den(165)
  A(172) = cont_QA(wf(:,101),wf(:,166)) * den(166)
  A(173) = cont_QA(wf(:,118),wf(:,167)) * den(167)
  A(174) = cont_QA(wf(:,119),wf(:,167)) * den(168)
  A(175) = cont_QA(wf(:,115),wf(:,168)) * den(169)
  A(176) = cont_QA(wf(:,115),wf(:,169)) * den(170)
  A(177) = cont_QA(wf(:,21),wf(:,172)) * den(173)
  A(178) = cont_QA(wf(:,21),wf(:,173)) * den(175)
  A(179) = cont_QA(wf(:,25),wf(:,174)) * den(177)
  A(180) = cont_QA(wf(:,27),wf(:,174)) * den(178)
  A(181) = cont_QA(wf(:,167),wf(:,176)) * den(180)
  A(182) = cont_QA(wf(:,167),wf(:,178)) * den(182)
  A(183) = cont_QA(wf(:,168),wf(:,180)) * den(184)
  A(184) = cont_QA(wf(:,169),wf(:,180)) * den(185)
  A(185) = cont_QA(wf(:,165),wf(:,181)) * den(187)
  A(186) = cont_QA(wf(:,166),wf(:,181)) * den(188)
  A(187) = cont_QA(wf(:,164),wf(:,182)) * den(190)
  A(188) = cont_QA(wf(:,164),wf(:,183)) * den(192)
  A(189) = cont_VV(wf(:,34),wf(:,184)) * den(194)
  A(190) = cont_VV(wf(:,185),wf(:,186)) * den(196)
  A(191) = cont_VV(wf(:,40),wf(:,184)) * den(198)
  A(192) = cont_VV(wf(:,185),wf(:,187)) * den(200)
  A(193) = cont_VV(wf(:,34),wf(:,188)) * den(201)
  A(194) = cont_VV(wf(:,186),wf(:,189)) * den(202)
  A(195) = cont_VV(wf(:,40),wf(:,188)) * den(203)
  A(196) = cont_VV(wf(:,187),wf(:,189)) * den(204)
  A(197) = cont_VV(wf(:,52),wf(:,184)) * den(205)
  A(198) = cont_VV(wf(:,146),wf(:,185)) * den(206)
  A(199) = cont_QA(wf(:,51),wf(:,190)) * den(208)
  A(200) = cont_QA(wf(:,151),wf(:,191)) * den(209)
  A(201) = cont_VV(wf(:,52),wf(:,188)) * den(210)
  A(202) = cont_VV(wf(:,146),wf(:,189)) * den(211)
  A(203) = cont_QA(wf(:,155),wf(:,192)) * den(212)
  A(204) = cont_QA(wf(:,55),wf(:,193)) * den(214)
  A(205) = cont_QA(wf(:,192),wf(:,195)) * den(216)
  A(206) = cont_QA(wf(:,191),wf(:,196)) * den(218)
  A(207) = cont_VV(wf(:,59),wf(:,184)) * den(220)
  A(208) = cont_VV(wf(:,185),wf(:,197)) * den(222)
  A(209) = cont_VV(wf(:,185),wf(:,198)) * den(224)
  A(210) = cont_VV(wf(:,59),wf(:,188)) * den(225)
  A(211) = cont_VV(wf(:,189),wf(:,197)) * den(226)
  A(212) = cont_VV(wf(:,189),wf(:,198)) * den(227)
  A(213) = cont_VV(wf(:,66),wf(:,184)) * den(229)
  A(214) = cont_VV(wf(:,185),wf(:,199)) * den(231)
  A(215) = cont_VV(wf(:,185),wf(:,200)) * den(233)
  A(216) = cont_VV(wf(:,66),wf(:,188)) * den(234)
  A(217) = cont_VV(wf(:,189),wf(:,199)) * den(235)
  A(218) = cont_VV(wf(:,189),wf(:,200)) * den(236)
  A(219) = cont_VV(wf(:,185),wf(:,201)) * den(238)
  A(220) = cont_VV(wf(:,185),wf(:,202)) * den(240)
  A(221) = cont_VV(wf(:,189),wf(:,201)) * den(241)
  A(222) = cont_VV(wf(:,189),wf(:,202)) * den(242)


  ! colour vectors

  M1(1) = (-A(1)-A(3)-A(5)-A(7)-A(9)-A(11)-A(13)-A(15)-A(17)-A(19))*f(1)+(A(2)+A(4)+A(6)+A(8)+A(10)+A(12)+A(14)+A(16)+A(18)+A(20) &
       +A(40)+A(41)+A(42)+A(43))*f(2)+(-A(21)-A(24)-A(27))*f(13)+(-A(23)-A(26))*f(17)+(-A(22)-A(25)+A(28)+A(31)+A(34)+A(37))*f(23) &
       +(-A(29)-A(30)-A(32)-A(33)-A(35)-A(36)-A(38)-A(39))*f(24)

  M2(1) = (A(165)+A(167)+A(169)+A(171)+A(173)+A(175)+A(177)+A(179)+A(181)+A(183)+A(185)+A(187)+A(189)+A(191)+A(193)+A(195))*f(3)+( &
       -A(166)-A(168)-A(170)-A(172)-A(174)-A(176)-A(178)-A(180)-A(182)-A(184)-A(186)-A(188)-A(190)-A(192)-A(194)-A(196)-A(219) &
       -A(220)-A(221)-A(222))*f(4)+A(44)*f(5)+(-A(56)-A(59)-A(74)-A(76)-A(86)-A(88)-A(96)-A(98)-A(104)-A(106))*f(6)+(A(57)+A(60) &
       +A(75)+A(77)+A(87)+A(89)+A(97)+A(99)+A(105)+A(107)+A(159)+A(160)+A(163)+A(164))*f(7)+(-A(48)-A(50)-A(52)-A(54)-A(66)-A(68) &
       -A(70)-A(72)-A(78)-A(80)-A(82)-A(84)-A(92)-A(94)-A(100)-A(102))*f(8)+(A(49)+A(51)+A(53)+A(55)+A(67)+A(69)+A(71)+A(73)+A(79) &
       +A(81)+A(83)+A(85)+A(93)+A(95)+A(101)+A(103)+A(157)+A(158)+A(161)+A(162))*f(9)+(A(62)+A(64))*f(10)+(-A(58)-A(61)-A(63) &
       -A(65)-A(90)-A(91)-A(155)-A(156))*f(11)+A(45)*f(12)+(A(199)+A(200)+A(203)+A(204)+A(205)+A(206))*f(14)+(-A(112)-A(117) &
       -A(124))*f(15)+(-A(110)-A(111)-A(115)-A(116)-A(122)-A(123))*f(16)+(A(198)+A(202))*f(18)+(-A(119)-A(126))*f(19)+(-A(114) &
       -A(121))*f(20)+A(109)*f(21)+A(108)*f(22)+(A(197)+A(201)-A(207)-A(210)-A(213)-A(216))*f(25)+(A(208)+A(209)+A(211)+A(212) &
       +A(214)+A(215)+A(217)+A(218))*f(26)+(-A(118)-A(125)+A(132)+A(138)+A(146)+A(152))*f(27)+(-A(133)-A(134)-A(139)-A(140)-A(147) &
       -A(148)-A(153)-A(154))*f(28)+(-A(113)-A(120)+A(129)+A(135)+A(143)+A(149))*f(29)+(-A(130)-A(131)-A(136)-A(137)-A(144)-A(145) &
       -A(150)-A(151))*f(30)-A(46)*f(31)+(A(127)+A(128)+A(141)+A(142))*f(32)-A(47)*f(33)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_nenexeexuuxg_1_/**/REALKIND
