
module ol_colourmatrix_ppllllj_nenexeexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_nenexeexbbxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_nenexeexbbxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_nenexeexbbxg_1_/**/REALKIND

module ol_loop_ppllllj_nenexeexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(76), c(42)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:294)
  ! denominators
  complex(REALKIND), save :: den(435)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 2) = CI*eQED**4*gQCD
    f( 3) = (CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**4*gQCD**3
    f( 5) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 6) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 7) = CI*countertermnorm*ctGbb*eQED**4*gQCD**3
    f( 8) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 9) = CI*countertermnorm*ctVbb*eQED**4*gQCD**3
    f(10) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(12) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(13) = (CI*eQED**4*gQCD)/(4._/**/REALKIND*sw**4)
    f(14) = (CI*countertermnorm*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(15) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(16) = (CI*countertermnorm*ctGtt*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(17) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**3)/(4._/**/REALKIND*sw**4)
    f(18) = (CI*eQED**4*gQCD*MB)/(4._/**/REALKIND*sw**4)
    f(19) = (CI*countertermnorm*eQED**4*gQCD**3*MB)/(4._/**/REALKIND*sw**4)
    f(20) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*MB)/(4._/**/REALKIND*sw**4)
    f(21) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*MB)/(4._/**/REALKIND*sw**4)
    f(22) = (CI*cw*eQED**4*gQCD)/(2._/**/REALKIND*sw**3)
    f(23) = (CI*countertermnorm*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f(24) = (CI*countertermnorm*ctGbb*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f(25) = (CI*countertermnorm*ctVbb*cw*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**3)
    f(26) = (countertermnorm*ctZGG*cw*eQED**4*gQCD**3)/(sw**3*2._/**/REALKIND)
    f(27) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(2._/**/REALKIND*sw**3)
    f(28) = (CI*eQED**4*gQCD)/(6._/**/REALKIND*sw**2)
    f(29) = (CI*eQED**4*gQCD)/(2._/**/REALKIND*sw**2)
    f(30) = (CI*countertermnorm*eQED**4*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(31) = (CI*countertermnorm*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(32) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(33) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(34) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/(6._/**/REALKIND*sw**2)
    f(35) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(36) = (CI*countertermnorm*ctWWGG*eQED**4*gQCD**3)/(2._/**/REALKIND*sw**2)
    f(37) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/(sw**2*2._/**/REALKIND)
    f(38) = (CI*eQED**4*gQCD*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(39) = (CI*countertermnorm*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(40) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(41) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(42) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(43) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(44) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(45) = (eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(46) = eQED**4*gQCD**3*integralnorm*SwB
    f(47) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(4._/**/REALKIND*sw**4)
    f(48) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(49) = (CI*eQED**4*gQCD**3*integralnorm*MB*SwB)/(4._/**/REALKIND*sw**4)
    f(50) = (eQED**4*gQCD**3*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f(51) = (CI*cw*eQED**4*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**3)
    f(52) = (cw*eQED**4*gQCD**3*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(53) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(6._/**/REALKIND*sw**2)
    f(54) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(55) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(56) = (eQED**4*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(57) = (CI*eQED**4*gQCD**3*integralnorm*MB*SwB)/(2._/**/REALKIND*cw**2*sw**2)
    f(58) = (eQED**4*gQCD**3*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(59) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(60) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(61) = eQED**4*gQCD**3*integralnorm*SwF
    f(62) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(63) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(64) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(65) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(66) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(sw**4*4._/**/REALKIND)
    f(67) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(sw**4*4._/**/REALKIND)
    f(68) = (cw*eQED**4*gQCD**3*integralnorm*SwF)/(sw**3*2._/**/REALKIND)
    f(69) = (cw*eQED**4*gQCD**3*integralnorm*SwF)/sw**3
    f(70) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*6._/**/REALKIND)
    f(71) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(72) = (eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(73) = (2*eQED**4*gQCD**3*integralnorm*SwF)/(sw**2*3._/**/REALKIND)
    f(74) = (eQED**4*gQCD**3*integralnorm*SwF)/sw**2
    f(75) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(76) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(43), 9*CI*f(44), f(45), 8*f(45), f(46), 8*f(46), 9*CI*f(47), f(48), 8*f(48), 9*CI*f(49), f(50), 8*f(50), 9*CI*f(51) &
    , f(52), 8*f(52), 9*CI*f(53), 9*CI*f(54), f(55), 8*f(55), f(56), 8*f(56), 9*CI*f(57), f(58), 8*f(58), 3*f(59), 3*f(60) &
    , 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), 3*f(66), 3*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74) &
    , 3*f(75), 3*f(76) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(238)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rMB, H(5), wf(:,-4))
  call wf_A(P(:,6), rMB, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,3),MZ,1_intkind1,wf(:,4))
  call prop_Q_A(wf(:,3),Q(:,80),MB,1_intkind1,wf(:,5))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,4),wf(:,6))
  call vert_VQ_A(wf(:,2),wf(:,5),wf(:,7))
  call prop_A_Q(wf(:,6),Q(:,35),MB,1_intkind1,wf(:,8))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,9))
  call prop_W_W(wf(:,9),Q(:,12),MZ,1_intkind1,wf(:,10))
  call vert_ZQ_A(gZd,wf(:,10),wf(:,5),wf(:,11))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,12))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,5),wf(:,13))
  call prop_A_Q(wf(:,12),Q(:,44),MB,1_intkind1,wf(:,14))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,10),wf(:,15))
  call prop_A_Q(wf(:,15),Q(:,44),MB,1_intkind1,wf(:,16))
  call vert_AQ_S(gH,wf(:,-5),wf(:,5),wf(:,17))
  call vert_VV_S(wf(:,4),wf(:,10),wf(:,18))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,19))
  call prop_A_Q(wf(:,19),Q(:,96),MB,1_intkind1,wf(:,20))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,-4),wf(:,21))
  call vert_AV_Q(wf(:,20),wf(:,2),wf(:,22))
  call prop_Q_A(wf(:,21),Q(:,19),MB,1_intkind1,wf(:,23))
  call vert_AZ_Q(gZd,wf(:,20),wf(:,10),wf(:,24))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,25))
  call vert_AZ_Q(gZd,wf(:,20),wf(:,4),wf(:,26))
  call prop_Q_A(wf(:,25),Q(:,28),MB,1_intkind1,wf(:,27))
  call vert_ZQ_A(gZd,wf(:,10),wf(:,-4),wf(:,28))
  call prop_Q_A(wf(:,28),Q(:,28),MB,1_intkind1,wf(:,29))
  call vert_AQ_S(gH,wf(:,20),wf(:,-4),wf(:,30))
  call vert_VQ_A(wf(:,-6),wf(:,23),wf(:,31))
  call vert_VQ_A(wf(:,-6),wf(:,27),wf(:,32))
  call vert_VQ_A(wf(:,-6),wf(:,29),wf(:,33))
  call vert_ZQ_A(gZl,wf(:,4),wf(:,-2),wf(:,34))
  call vert_QA_V(wf(:,5),wf(:,-5),wf(:,35))
  call prop_Q_A(wf(:,34),Q(:,7),ZERO,0_intkind1,wf(:,36))
  call vert_QA_V(wf(:,36),wf(:,-3),wf(:,37))
  call vert_QA_Z(gZd,wf(:,5),wf(:,-5),wf(:,38))
  call prop_W_W(wf(:,38),Q(:,112),MZ,1_intkind1,wf(:,39))
  call vert_QA_Z(gZl,wf(:,36),wf(:,-3),wf(:,40))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,4),wf(:,41))
  call prop_A_Q(wf(:,41),Q(:,11),ZERO,0_intkind1,wf(:,42))
  call vert_QA_V(wf(:,-2),wf(:,42),wf(:,43))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,42),wf(:,44))
  call vert_QA_V(wf(:,-4),wf(:,20),wf(:,45))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,20),wf(:,46))
  call prop_W_W(wf(:,46),Q(:,112),MZ,1_intkind1,wf(:,47))
  call vert_QA_W(wf(:,0),wf(:,-3),wf(:,48))
  call vert_QA_W(wf(:,-2),wf(:,-1),wf(:,49))
  call prop_W_W(wf(:,49),Q(:,6),MW,1_intkind1,wf(:,50))
  call prop_W_W(wf(:,48),Q(:,9),MW,1_intkind1,wf(:,51))
  call vert_AW_Q(wf(:,-5),wf(:,50),wf(:,52))
  call vert_WQ_A(wf(:,51),wf(:,5),wf(:,53))
  call prop_A_Q(wf(:,52),Q(:,38),MT,1_intkind1,wf(:,54))
  call vert_VV_S(wf(:,50),wf(:,51),wf(:,55))
  call vert_UV_W(wf(:,51),Q(:,9),wf(:,50),Q(:,6),wf(:,56))
  call vert_WQ_A(wf(:,51),wf(:,-4),wf(:,57))
  call vert_AW_Q(wf(:,20),wf(:,50),wf(:,58))
  call prop_Q_A(wf(:,57),Q(:,25),MT,1_intkind1,wf(:,59))
  call vert_VQ_A(wf(:,-6),wf(:,59),wf(:,60))
  call vert_WQ_A(wf(:,50),wf(:,0),wf(:,61))
  call prop_Q_A(wf(:,61),Q(:,7),ZERO,0_intkind1,wf(:,62))
  call vert_QA_V(wf(:,62),wf(:,-3),wf(:,63))
  call vert_QA_Z(gZl,wf(:,62),wf(:,-3),wf(:,64))
  call vert_AW_Q(wf(:,-3),wf(:,50),wf(:,65))
  call prop_A_Q(wf(:,65),Q(:,14),ZERO,0_intkind1,wf(:,66))
  call vert_QA_Z(gZn,wf(:,0),wf(:,66),wf(:,67))
  call vert_AW_Q(wf(:,-1),wf(:,51),wf(:,68))
  call prop_A_Q(wf(:,68),Q(:,11),ZERO,0_intkind1,wf(:,69))
  call vert_QA_V(wf(:,-2),wf(:,69),wf(:,70))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,69),wf(:,71))
  call vert_WQ_A(wf(:,51),wf(:,-2),wf(:,72))
  call prop_Q_A(wf(:,72),Q(:,13),ZERO,0_intkind1,wf(:,73))
  call vert_QA_Z(gZn,wf(:,73),wf(:,-1),wf(:,74))
  call vert_ZQ_A(gZn,wf(:,10),wf(:,0),wf(:,75))
  call prop_Q_A(wf(:,75),Q(:,13),ZERO,0_intkind1,wf(:,76))
  call vert_QA_Z(gZn,wf(:,76),wf(:,-1),wf(:,77))
  call vert_AZ_Q(gZn,wf(:,-1),wf(:,10),wf(:,78))
  call prop_A_Q(wf(:,78),Q(:,14),ZERO,0_intkind1,wf(:,79))
  call vert_QA_Z(gZn,wf(:,0),wf(:,79),wf(:,80))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,81))
  call counter_VVG_G(wf(:,4),wf(:,2),wf(:,-6),wf(:,82))
  call counter_VVG_G(wf(:,4),wf(:,10),wf(:,-6),wf(:,83))
  call counter_VVG_G(wf(:,50),wf(:,51),wf(:,-6),wf(:,84))
  call counter_GG_S(wf(:,81),wf(:,-6),wf(:,85))
  call counter_VQ_A(wf(:,2),wf(:,5),wf(:,86))
  call counter_ZQ_A(gZd,wf(:,10),wf(:,5),wf(:,87))
  call counter_ZQ_A(gZd,wf(:,4),wf(:,5),wf(:,88))
  call counter_AV_Q(wf(:,20),wf(:,2),wf(:,89))
  call counter_AZ_Q(gZd,wf(:,20),wf(:,10),wf(:,90))
  call counter_AZ_Q(gZd,wf(:,20),wf(:,4),wf(:,91))
  call counter_VQ_A(wf(:,-6),wf(:,23),wf(:,92))
  call counter_VG_G(wf(:,10),wf(:,-6),Q(:,64),wf(:,93),Q(:,76))
  call vert_QA_V(wf(:,23),wf(:,-5),wf(:,94))
  call counter_VQ_A(wf(:,-6),wf(:,27),wf(:,95))
  call counter_VQ_A(wf(:,-6),wf(:,29),wf(:,96))
  call vert_QA_V(wf(:,-4),wf(:,8),wf(:,97))
  call counter_VG_G(wf(:,4),wf(:,-6),Q(:,64),wf(:,98),Q(:,67))
  call vert_QA_V(wf(:,27),wf(:,-5),wf(:,99))
  call vert_QA_V(wf(:,29),wf(:,-5),wf(:,100))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,101))
  call vert_QA_V(wf(:,-4),wf(:,16),wf(:,102))
  call counter_AQ_S(gH,wf(:,-5),wf(:,5),wf(:,103))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,104))
  call prop_Q_A(wf(:,13),Q(:,83),MB,1_intkind1,wf(:,105))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,10),wf(:,106))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,4),wf(:,107))
  call prop_Q_A(wf(:,7),Q(:,92),MB,1_intkind1,wf(:,108))
  call prop_Q_A(wf(:,11),Q(:,92),MB,1_intkind1,wf(:,109))
  call prop_A_Q(wf(:,104),Q(:,44),MB,1_intkind1,wf(:,110))
  call prop_A_Q(wf(:,106),Q(:,44),MB,1_intkind1,wf(:,111))
  call prop_A_Q(wf(:,107),Q(:,35),MB,1_intkind1,wf(:,112))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,113))
  call prop_A_Q(wf(:,113),Q(:,96),MB,1_intkind1,wf(:,114))
  call vert_AV_Q(wf(:,114),wf(:,2),wf(:,115))
  call vert_AZ_Q(gZd,wf(:,114),wf(:,10),wf(:,116))
  call vert_AZ_Q(gZd,wf(:,114),wf(:,4),wf(:,117))
  call vert_AQ_S(gH,wf(:,114),wf(:,-4),wf(:,118))
  call counter_AQ_S(gH,wf(:,20),wf(:,-4),wf(:,119))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,120))
  call prop_A_Q(wf(:,26),Q(:,99),MB,1_intkind1,wf(:,121))
  call counter_ZQ_A(gZd,wf(:,10),wf(:,-4),wf(:,122))
  call counter_ZQ_A(gZd,wf(:,4),wf(:,-4),wf(:,123))
  call prop_A_Q(wf(:,22),Q(:,108),MB,1_intkind1,wf(:,124))
  call prop_A_Q(wf(:,24),Q(:,108),MB,1_intkind1,wf(:,125))
  call prop_Q_A(wf(:,120),Q(:,28),MB,1_intkind1,wf(:,126))
  call vert_VQ_A(wf(:,-6),wf(:,126),wf(:,127))
  call prop_Q_A(wf(:,122),Q(:,28),MB,1_intkind1,wf(:,128))
  call vert_VQ_A(wf(:,-6),wf(:,128),wf(:,129))
  call prop_Q_A(wf(:,123),Q(:,19),MB,1_intkind1,wf(:,130))
  call vert_VQ_A(wf(:,-6),wf(:,130),wf(:,131))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,132))
  call prop_Q_A(wf(:,132),Q(:,80),MB,1_intkind1,wf(:,133))
  call vert_VQ_A(wf(:,2),wf(:,133),wf(:,134))
  call vert_ZQ_A(gZd,wf(:,10),wf(:,133),wf(:,135))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,133),wf(:,136))
  call vert_AQ_S(gH,wf(:,-5),wf(:,133),wf(:,137))
  call counter_GG_V(wf(:,81),Q(:,48),wf(:,-6),Q(:,64),wf(:,138))
  call prop_W_W(wf(:,138),Q(:,112),MZ,1_intkind1,wf(:,139))
  call counter_QA_V(wf(:,5),wf(:,-5),wf(:,140))
  call counter_QA_Z(gZd,wf(:,5),wf(:,-5),wf(:,141))
  call prop_W_W(wf(:,141),Q(:,112),MZ,1_intkind1,wf(:,142))
  call vert_QA_V(wf(:,-4),wf(:,114),wf(:,143))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,114),wf(:,144))
  call prop_W_W(wf(:,144),Q(:,112),MZ,1_intkind1,wf(:,145))
  call counter_QA_V(wf(:,-4),wf(:,20),wf(:,146))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,20),wf(:,147))
  call prop_W_W(wf(:,147),Q(:,112),MZ,1_intkind1,wf(:,148))
  call vert_QA_V(wf(:,133),wf(:,-5),wf(:,149))
  call vert_QA_Z(gZd,wf(:,133),wf(:,-5),wf(:,150))
  call prop_W_W(wf(:,150),Q(:,112),MZ,1_intkind1,wf(:,151))
  call prop_W_W(wf(:,56),Q(:,15),MZ,1_intkind1,wf(:,152))
  call counter_WQ_A(wf(:,51),wf(:,5),wf(:,153))
  call counter_AW_Q(wf(:,20),wf(:,50),wf(:,154))
  call counter_VQ_A(wf(:,-6),wf(:,59),wf(:,155))
  call counter_AW_Q(wf(:,-5),wf(:,50),wf(:,156))
  call prop_Q_A(wf(:,53),Q(:,89),MT,1_intkind1,wf(:,157))
  call prop_A_Q(wf(:,156),Q(:,38),MT,1_intkind1,wf(:,158))
  call vert_AW_Q(wf(:,114),wf(:,50),wf(:,159))
  call counter_WQ_A(wf(:,51),wf(:,-4),wf(:,160))
  call prop_A_Q(wf(:,58),Q(:,102),MT,1_intkind1,wf(:,161))
  call prop_Q_A(wf(:,160),Q(:,25),MT,1_intkind1,wf(:,162))
  call vert_VQ_A(wf(:,-6),wf(:,162),wf(:,163))
  call vert_WQ_A(wf(:,51),wf(:,133),wf(:,164))
  call counter_Q_A(ctbb,wf(:,5),Q(:,80),wf(:,165))
  call prop_Q_A(wf(:,165),Q(:,80),MB,1_intkind1,wf(:,166))
  call vert_AQ_S(gH,wf(:,-5),wf(:,166),wf(:,167))
  call vert_VQ_A(wf(:,2),wf(:,166),wf(:,168))
  call vert_ZQ_A(gZd,wf(:,10),wf(:,166),wf(:,169))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,166),wf(:,170))
  call counter_A_Q(ctbb,wf(:,8),Q(:,35),wf(:,171))
  call counter_A_Q(ctbb,wf(:,14),Q(:,44),wf(:,172))
  call counter_A_Q(ctbb,wf(:,16),Q(:,44),wf(:,173))
  call counter_A_Q(ctbb,wf(:,20),Q(:,96),wf(:,174))
  call prop_A_Q(wf(:,174),Q(:,96),MB,1_intkind1,wf(:,175))
  call vert_AQ_S(gH,wf(:,175),wf(:,-4),wf(:,176))
  call counter_Q_A(ctbb,wf(:,23),Q(:,19),wf(:,177))
  call counter_Q_A(ctbb,wf(:,27),Q(:,28),wf(:,178))
  call counter_Q_A(ctbb,wf(:,29),Q(:,28),wf(:,179))
  call vert_AV_Q(wf(:,175),wf(:,2),wf(:,180))
  call vert_AZ_Q(gZd,wf(:,175),wf(:,10),wf(:,181))
  call vert_AZ_Q(gZd,wf(:,175),wf(:,4),wf(:,182))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,183))
  call prop_A_Q(wf(:,183),Q(:,108),MB,1_intkind1,wf(:,184))
  call vert_AV_Q(wf(:,16),wf(:,-6),wf(:,185))
  call prop_A_Q(wf(:,185),Q(:,108),MB,1_intkind1,wf(:,186))
  call vert_AV_Q(wf(:,8),wf(:,-6),wf(:,187))
  call prop_A_Q(wf(:,187),Q(:,99),MB,1_intkind1,wf(:,188))
  call prop_Q_A(wf(:,31),Q(:,83),MB,1_intkind1,wf(:,189))
  call prop_Q_A(wf(:,32),Q(:,92),MB,1_intkind1,wf(:,190))
  call prop_Q_A(wf(:,33),Q(:,92),MB,1_intkind1,wf(:,191))
  call vert_QA_V(wf(:,166),wf(:,-5),wf(:,192))
  call vert_QA_Z(gZd,wf(:,166),wf(:,-5),wf(:,193))
  call prop_W_W(wf(:,40),Q(:,15),MZ,1_intkind1,wf(:,194))
  call prop_W_W(wf(:,44),Q(:,15),MZ,1_intkind1,wf(:,195))
  call vert_QA_V(wf(:,-4),wf(:,175),wf(:,196))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,175),wf(:,197))
  call vert_WQ_A(wf(:,51),wf(:,166),wf(:,198))
  call counter_A_Q(cttt,wf(:,54),Q(:,38),wf(:,199))
  call counter_Q_A(cttt,wf(:,59),Q(:,25),wf(:,200))
  call vert_AW_Q(wf(:,175),wf(:,50),wf(:,201))
  call vert_AV_Q(wf(:,54),wf(:,-6),wf(:,202))
  call prop_A_Q(wf(:,202),Q(:,102),MT,1_intkind1,wf(:,203))
  call prop_Q_A(wf(:,60),Q(:,89),MT,1_intkind1,wf(:,204))
  call prop_W_W(wf(:,64),Q(:,15),MZ,1_intkind1,wf(:,205))
  call prop_W_W(wf(:,67),Q(:,15),MZ,1_intkind1,wf(:,206))
  call prop_W_W(wf(:,71),Q(:,15),MZ,1_intkind1,wf(:,207))
  call prop_W_W(wf(:,74),Q(:,15),MZ,1_intkind1,wf(:,208))
  call prop_W_W(wf(:,77),Q(:,15),MZ,1_intkind1,wf(:,209))
  call prop_W_W(wf(:,80),Q(:,15),MZ,1_intkind1,wf(:,210))
  call vert_VQ_A(wf(:,2),wf(:,23),wf(:,211))
  call prop_Q_A(wf(:,211),Q(:,31),MB,1_intkind1,wf(:,212))
  call vert_ZQ_A(gZd,wf(:,10),wf(:,23),wf(:,213))
  call prop_Q_A(wf(:,213),Q(:,31),MB,1_intkind1,wf(:,214))
  call vert_AV_Q(wf(:,8),wf(:,2),wf(:,215))
  call prop_A_Q(wf(:,215),Q(:,47),MB,1_intkind1,wf(:,216))
  call vert_AZ_Q(gZd,wf(:,8),wf(:,10),wf(:,217))
  call prop_A_Q(wf(:,217),Q(:,47),MB,1_intkind1,wf(:,218))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,27),wf(:,219))
  call prop_Q_A(wf(:,219),Q(:,31),MB,1_intkind1,wf(:,220))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,29),wf(:,221))
  call prop_Q_A(wf(:,221),Q(:,31),MB,1_intkind1,wf(:,222))
  call vert_AZ_Q(gZd,wf(:,14),wf(:,4),wf(:,223))
  call prop_A_Q(wf(:,223),Q(:,47),MB,1_intkind1,wf(:,224))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,4),wf(:,225))
  call prop_A_Q(wf(:,225),Q(:,47),MB,1_intkind1,wf(:,226))
  call vert_QS_A(gH,wf(:,-4),wf(:,18),wf(:,227))
  call prop_Q_A(wf(:,227),Q(:,31),MB,1_intkind1,wf(:,228))
  call vert_SA_Q(gH,wf(:,18),wf(:,-5),wf(:,229))
  call prop_A_Q(wf(:,229),Q(:,47),MB,1_intkind1,wf(:,230))
  call vert_VQ_A(wf(:,37),wf(:,-4),wf(:,231))
  call prop_Q_A(wf(:,231),Q(:,31),MB,1_intkind1,wf(:,232))
  call vert_ZQ_A(gZd,wf(:,194),wf(:,-4),wf(:,233))
  call prop_Q_A(wf(:,233),Q(:,31),MB,1_intkind1,wf(:,234))
  call vert_AV_Q(wf(:,-5),wf(:,37),wf(:,235))
  call prop_A_Q(wf(:,235),Q(:,47),MB,1_intkind1,wf(:,236))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,194),wf(:,237))
  call prop_A_Q(wf(:,237),Q(:,47),MB,1_intkind1,wf(:,238))
  call vert_VQ_A(wf(:,43),wf(:,-4),wf(:,239))
  call prop_Q_A(wf(:,239),Q(:,31),MB,1_intkind1,wf(:,240))
  call vert_ZQ_A(gZd,wf(:,195),wf(:,-4),wf(:,241))
  call prop_Q_A(wf(:,241),Q(:,31),MB,1_intkind1,wf(:,242))
  call vert_AV_Q(wf(:,-5),wf(:,43),wf(:,243))
  call prop_A_Q(wf(:,243),Q(:,47),MB,1_intkind1,wf(:,244))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,195),wf(:,245))
  call prop_A_Q(wf(:,245),Q(:,47),MB,1_intkind1,wf(:,246))
  call vert_WQ_A(wf(:,50),wf(:,59),wf(:,247))
  call prop_Q_A(wf(:,247),Q(:,31),MB,1_intkind1,wf(:,248))
  call vert_AW_Q(wf(:,54),wf(:,51),wf(:,249))
  call prop_A_Q(wf(:,249),Q(:,47),MB,1_intkind1,wf(:,250))
  call vert_QS_A(gH,wf(:,-4),wf(:,55),wf(:,251))
  call prop_Q_A(wf(:,251),Q(:,31),MB,1_intkind1,wf(:,252))
  call vert_VQ_A(wf(:,56),wf(:,-4),wf(:,253))
  call prop_Q_A(wf(:,253),Q(:,31),MB,1_intkind1,wf(:,254))
  call vert_ZQ_A(gZd,wf(:,152),wf(:,-4),wf(:,255))
  call prop_Q_A(wf(:,255),Q(:,31),MB,1_intkind1,wf(:,256))
  call vert_SA_Q(gH,wf(:,55),wf(:,-5),wf(:,257))
  call prop_A_Q(wf(:,257),Q(:,47),MB,1_intkind1,wf(:,258))
  call vert_AV_Q(wf(:,-5),wf(:,56),wf(:,259))
  call prop_A_Q(wf(:,259),Q(:,47),MB,1_intkind1,wf(:,260))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,152),wf(:,261))
  call prop_A_Q(wf(:,261),Q(:,47),MB,1_intkind1,wf(:,262))
  call vert_VQ_A(wf(:,63),wf(:,-4),wf(:,263))
  call prop_Q_A(wf(:,263),Q(:,31),MB,1_intkind1,wf(:,264))
  call vert_ZQ_A(gZd,wf(:,205),wf(:,-4),wf(:,265))
  call prop_Q_A(wf(:,265),Q(:,31),MB,1_intkind1,wf(:,266))
  call vert_AV_Q(wf(:,-5),wf(:,63),wf(:,267))
  call prop_A_Q(wf(:,267),Q(:,47),MB,1_intkind1,wf(:,268))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,205),wf(:,269))
  call prop_A_Q(wf(:,269),Q(:,47),MB,1_intkind1,wf(:,270))
  call vert_ZQ_A(gZd,wf(:,206),wf(:,-4),wf(:,271))
  call prop_Q_A(wf(:,271),Q(:,31),MB,1_intkind1,wf(:,272))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,206),wf(:,273))
  call prop_A_Q(wf(:,273),Q(:,47),MB,1_intkind1,wf(:,274))
  call vert_VQ_A(wf(:,70),wf(:,-4),wf(:,275))
  call prop_Q_A(wf(:,275),Q(:,31),MB,1_intkind1,wf(:,276))
  call vert_ZQ_A(gZd,wf(:,207),wf(:,-4),wf(:,277))
  call prop_Q_A(wf(:,277),Q(:,31),MB,1_intkind1,wf(:,278))
  call vert_AV_Q(wf(:,-5),wf(:,70),wf(:,279))
  call prop_A_Q(wf(:,279),Q(:,47),MB,1_intkind1,wf(:,280))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,207),wf(:,281))
  call prop_A_Q(wf(:,281),Q(:,47),MB,1_intkind1,wf(:,282))
  call vert_ZQ_A(gZd,wf(:,208),wf(:,-4),wf(:,283))
  call prop_Q_A(wf(:,283),Q(:,31),MB,1_intkind1,wf(:,284))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,208),wf(:,285))
  call prop_A_Q(wf(:,285),Q(:,47),MB,1_intkind1,wf(:,286))
  call vert_ZQ_A(gZd,wf(:,209),wf(:,-4),wf(:,287))
  call prop_Q_A(wf(:,287),Q(:,31),MB,1_intkind1,wf(:,288))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,209),wf(:,289))
  call prop_A_Q(wf(:,289),Q(:,47),MB,1_intkind1,wf(:,290))
  call vert_ZQ_A(gZd,wf(:,210),wf(:,-4),wf(:,291))
  call prop_Q_A(wf(:,291),Q(:,31),MB,1_intkind1,wf(:,292))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,210),wf(:,293))
  call prop_A_Q(wf(:,293),Q(:,47),MB,1_intkind1,wf(:,294))


  ! propagators

    den(1) = 1 / (Q(5,3) - MZ2)
    den(2) = 1 / (Q(5,12))
    den(3) = 1 / (Q(5,80) - MB2)
    den(5) = 1 / (Q(5,35) - MB2)
    den(8) = 1 / (Q(5,12) - MZ2)
    den(12) = 1 / (Q(5,44) - MB2)
    den(18) = 1 / (Q(5,112) - MH2)
    den(21) = 1 / (Q(5,96) - MB2)
    den(23) = 1 / (Q(5,19) - MB2)
    den(29) = 1 / (Q(5,28) - MB2)
    den(40) = 1 / (Q(5,7))
    den(42) = 1 / (Q(5,112))
    den(45) = 1 / (Q(5,112) - MZ2)
    den(48) = 1 / (Q(5,11))
    den(58) = 1 / (Q(5,6) - MW2)
    den(59) = 1 / (Q(5,9) - MW2)
    den(61) = 1 / (Q(5,38) - MT2)
    den(69) = 1 / (Q(5,25) - MT2)
    den(79) = 1 / (Q(5,14))
    den(88) = 1 / (Q(5,13))
    den(100) = 1 / (Q(5,48))
    den(105) = 1 / (Q(5,15) - MH2)
    den(108) = 1 / (Q(5,76))
    den(112) = 1 / (Q(5,67))
    den(119) = 1 / (Q(5,83) - MB2)
    den(123) = 1 / (Q(5,92) - MB2)
    den(129) = 1 / (Q(5,99) - MB2)
    den(133) = 1 / (Q(5,108) - MB2)
    den(143) = 1 / (Q(5,15) - MZ2)
    den(147) = 1 / (Q(5,15))
    den(151) = 1 / (Q(5,89) - MT2)
    den(157) = 1 / (Q(5,102) - MT2)
    den(258) = 1 / (Q(5,51))
    den(261) = 1 / (Q(5,31) - MB2)
    den(267) = 1 / (Q(5,47) - MB2)
    den(271) = 1 / (Q(5,60))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(11) = den(1)*den(3)
    den(13) = den(2)*den(12)
    den(14) = den(11)*den(13)
    den(15) = den(8)*den(12)
    den(16) = den(11)*den(15)
    den(17) = den(1)*den(8)
    den(19) = den(3)*den(18)
    den(20) = den(17)*den(19)
    den(22) = den(2)*den(21)
    den(24) = den(1)*den(23)
    den(25) = den(22)*den(24)
    den(26) = den(8)*den(21)
    den(27) = den(24)*den(26)
    den(28) = den(1)*den(21)
    den(30) = den(2)*den(29)
    den(31) = den(28)*den(30)
    den(32) = den(8)*den(29)
    den(33) = den(28)*den(32)
    den(34) = den(18)*den(21)
    den(35) = den(17)*den(34)
    den(36) = den(13)*den(24)
    den(37) = den(15)*den(24)
    den(38) = den(6)*den(30)
    den(39) = den(6)*den(32)
    den(41) = den(1)*den(40)
    den(43) = den(3)*den(42)
    den(44) = den(41)*den(43)
    den(46) = den(3)*den(45)
    den(47) = den(41)*den(46)
    den(49) = den(1)*den(48)
    den(50) = den(43)*den(49)
    den(51) = den(46)*den(49)
    den(52) = den(21)*den(42)
    den(53) = den(41)*den(52)
    den(54) = den(21)*den(45)
    den(55) = den(41)*den(54)
    den(56) = den(49)*den(52)
    den(57) = den(49)*den(54)
    den(60) = den(3)*den(59)
    den(62) = den(58)*den(61)
    den(63) = den(60)*den(62)
    den(64) = den(58)*den(59)
    den(65) = den(19)*den(64)
    den(66) = den(43)*den(64)
    den(67) = den(46)*den(64)
    den(68) = den(21)*den(58)
    den(70) = den(59)*den(69)
    den(71) = den(68)*den(70)
    den(72) = den(34)*den(64)
    den(73) = den(52)*den(64)
    den(74) = den(54)*den(64)
    den(75) = den(62)*den(70)
    den(76) = den(40)*den(58)
    den(77) = den(43)*den(76)
    den(78) = den(46)*den(76)
    den(80) = den(58)*den(79)
    den(81) = den(46)*den(80)
    den(82) = den(52)*den(76)
    den(83) = den(54)*den(76)
    den(84) = den(54)*den(80)
    den(85) = den(48)*den(59)
    den(86) = den(43)*den(85)
    den(87) = den(46)*den(85)
    den(89) = den(59)*den(88)
    den(90) = den(46)*den(89)
    den(91) = den(52)*den(85)
    den(92) = den(54)*den(85)
    den(93) = den(54)*den(89)
    den(94) = den(8)*den(88)
    den(95) = den(46)*den(94)
    den(96) = den(8)*den(79)
    den(97) = den(46)*den(96)
    den(98) = den(54)*den(94)
    den(99) = den(54)*den(96)
    den(101) = den(1)*den(2)
    den(102) = den(100)*den(101)
    den(103) = den(17)*den(100)
    den(104) = den(64)*den(100)
    den(106) = den(17)*den(105)
    den(107) = den(100)*den(106)
    den(109) = den(8)*den(108)
    den(110) = den(24)*den(109)
    den(111) = den(6)*den(109)
    den(113) = den(1)*den(112)
    den(114) = den(30)*den(113)
    den(115) = den(32)*den(113)
    den(116) = den(13)*den(113)
    den(117) = den(15)*den(113)
    den(118) = den(3)*den(106)
    den(120) = den(11)*den(119)
    den(121) = den(2)*den(120)
    den(122) = den(8)*den(120)
    den(124) = den(4)*den(123)
    den(125) = den(1)*den(124)
    den(126) = den(9)*den(123)
    den(127) = den(1)*den(126)
    den(128) = den(21)*den(106)
    den(130) = den(28)*den(129)
    den(131) = den(2)*den(130)
    den(132) = den(8)*den(130)
    den(134) = den(22)*den(133)
    den(135) = den(1)*den(134)
    den(136) = den(26)*den(133)
    den(137) = den(1)*den(136)
    den(138) = den(45)*den(100)
    den(139) = den(41)*den(138)
    den(140) = den(49)*den(138)
    den(141) = den(64)*den(105)
    den(142) = den(100)*den(141)
    den(144) = den(64)*den(143)
    den(145) = den(100)*den(144)
    den(146) = den(3)*den(141)
    den(148) = den(64)*den(147)
    den(149) = den(3)*den(148)
    den(150) = den(3)*den(144)
    den(152) = den(60)*den(151)
    den(153) = den(58)*den(152)
    den(154) = den(21)*den(141)
    den(155) = den(21)*den(148)
    den(156) = den(21)*den(144)
    den(158) = den(68)*den(157)
    den(159) = den(59)*den(158)
    den(160) = den(76)*den(138)
    den(161) = den(80)*den(138)
    den(162) = den(85)*den(138)
    den(163) = den(89)*den(138)
    den(164) = den(94)*den(138)
    den(165) = den(96)*den(138)
    den(166) = den(3)**2
    den(167) = den(106)*den(166)
    den(168) = den(2)*den(166)
    den(169) = den(6)*den(168)
    den(170) = den(8)*den(166)
    den(171) = den(6)*den(170)
    den(172) = den(1)*den(166)
    den(173) = den(13)*den(172)
    den(174) = den(15)*den(172)
    den(175) = den(6)*den(124)
    den(176) = den(6)*den(126)
    den(177) = den(13)*den(120)
    den(178) = den(15)*den(120)
    den(179) = den(21)**2
    den(180) = den(106)*den(179)
    den(181) = den(24)*den(134)
    den(182) = den(24)*den(136)
    den(183) = den(30)*den(130)
    den(184) = den(32)*den(130)
    den(185) = den(2)*den(179)
    den(186) = den(24)*den(185)
    den(187) = den(8)*den(179)
    den(188) = den(24)*den(187)
    den(189) = den(1)*den(179)
    den(190) = den(30)*den(189)
    den(191) = den(32)*den(189)
    den(192) = den(13)*den(133)
    den(193) = den(24)*den(192)
    den(194) = den(15)*den(133)
    den(195) = den(24)*den(194)
    den(196) = den(6)*den(129)
    den(197) = den(30)*den(196)
    den(198) = den(32)*den(196)
    den(199) = den(24)*den(119)
    den(200) = den(13)*den(199)
    den(201) = den(15)*den(199)
    den(202) = den(30)*den(123)
    den(203) = den(6)*den(202)
    den(204) = den(32)*den(123)
    den(205) = den(6)*den(204)
    den(206) = den(41)*den(147)
    den(207) = den(166)*den(206)
    den(208) = den(41)*den(143)
    den(209) = den(166)*den(208)
    den(210) = den(49)*den(147)
    den(211) = den(166)*den(210)
    den(212) = den(49)*den(143)
    den(213) = den(166)*den(212)
    den(214) = den(179)*den(206)
    den(215) = den(179)*den(208)
    den(216) = den(179)*den(210)
    den(217) = den(179)*den(212)
    den(218) = den(141)*den(166)
    den(219) = den(148)*den(166)
    den(220) = den(144)*den(166)
    den(221) = den(59)*den(166)
    den(222) = den(62)*den(221)
    den(223) = den(62)*den(152)
    den(224) = den(141)*den(179)
    den(225) = den(148)*den(179)
    den(226) = den(144)*den(179)
    den(227) = den(70)*den(158)
    den(228) = den(58)*den(179)
    den(229) = den(70)*den(228)
    den(230) = den(62)*den(157)
    den(231) = den(70)*den(230)
    den(232) = den(70)*den(151)
    den(233) = den(62)*den(232)
    den(234) = den(76)*den(147)
    den(235) = den(166)*den(234)
    den(236) = den(76)*den(143)
    den(237) = den(166)*den(236)
    den(238) = den(80)*den(143)
    den(239) = den(166)*den(238)
    den(240) = den(179)*den(234)
    den(241) = den(179)*den(236)
    den(242) = den(179)*den(238)
    den(243) = den(85)*den(147)
    den(244) = den(166)*den(243)
    den(245) = den(85)*den(143)
    den(246) = den(166)*den(245)
    den(247) = den(89)*den(143)
    den(248) = den(166)*den(247)
    den(249) = den(179)*den(243)
    den(250) = den(179)*den(245)
    den(251) = den(179)*den(247)
    den(252) = den(94)*den(143)
    den(253) = den(166)*den(252)
    den(254) = den(96)*den(143)
    den(255) = den(166)*den(254)
    den(256) = den(179)*den(252)
    den(257) = den(179)*den(254)
    den(259) = den(24)*den(258)
    den(260) = den(2)*den(24)
    den(262) = den(260)*den(261)
    den(263) = den(8)*den(24)
    den(264) = den(261)*den(263)
    den(265) = den(6)*den(258)
    den(266) = den(2)*den(6)
    den(268) = den(266)*den(267)
    den(269) = den(6)*den(8)
    den(270) = den(267)*den(269)
    den(272) = den(30)*den(271)
    den(273) = den(32)*den(271)
    den(274) = den(1)*den(30)
    den(275) = den(261)*den(274)
    den(276) = den(1)*den(32)
    den(277) = den(261)*den(276)
    den(278) = den(13)*den(271)
    den(279) = den(15)*den(271)
    den(280) = den(1)*den(13)
    den(281) = den(267)*den(280)
    den(282) = den(1)*den(15)
    den(283) = den(267)*den(282)
    den(284) = den(106)*den(261)
    den(285) = den(106)*den(267)
    den(286) = den(206)*den(261)
    den(287) = den(208)*den(261)
    den(288) = den(206)*den(267)
    den(289) = den(208)*den(267)
    den(290) = den(210)*den(261)
    den(291) = den(212)*den(261)
    den(292) = den(210)*den(267)
    den(293) = den(212)*den(267)
    den(294) = den(58)*den(70)
    den(295) = den(261)*den(294)
    den(296) = den(59)*den(62)
    den(297) = den(267)*den(296)
    den(298) = den(141)*den(261)
    den(299) = den(148)*den(261)
    den(300) = den(144)*den(261)
    den(301) = den(141)*den(267)
    den(302) = den(148)*den(267)
    den(303) = den(144)*den(267)
    den(304) = den(234)*den(261)
    den(305) = den(236)*den(261)
    den(306) = den(234)*den(267)
    den(307) = den(236)*den(267)
    den(308) = den(238)*den(261)
    den(309) = den(238)*den(267)
    den(310) = den(243)*den(261)
    den(311) = den(245)*den(261)
    den(312) = den(243)*den(267)
    den(313) = den(245)*den(267)
    den(314) = den(247)*den(261)
    den(315) = den(247)*den(267)
    den(316) = den(252)*den(261)
    den(317) = den(252)*den(267)
    den(318) = den(254)*den(261)
    den(319) = den(254)*den(267)
    den(320) = den(1)*den(2)*den(100)
    den(321) = den(1)*den(8)*den(100)
    den(322) = den(2)*den(3)*den(6)
    den(323) = den(3)*den(6)*den(8)
    den(324) = den(1)*den(3)*den(13)
    den(325) = den(1)*den(3)*den(15)
    den(326) = den(1)*den(2)*den(3)
    den(327) = den(1)*den(3)*den(8)
    den(328) = den(2)*den(21)*den(24)
    den(329) = den(8)*den(21)*den(24)
    den(330) = den(1)*den(21)*den(30)
    den(331) = den(1)*den(21)*den(32)
    den(332) = den(1)*den(2)*den(21)
    den(333) = den(1)*den(8)*den(21)
    den(334) = den(2)*den(259)
    den(335) = den(8)*den(259)
    den(336) = den(2)*den(199)
    den(337) = den(8)*den(199)
    den(338) = den(2)*den(265)
    den(339) = den(8)*den(265)
    den(340) = den(2)*den(196)
    den(341) = den(8)*den(196)
    den(342) = den(1)*den(272)
    den(343) = den(1)*den(273)
    den(344) = den(1)*den(202)
    den(345) = den(1)*den(204)
    den(346) = den(1)*den(278)
    den(347) = den(1)*den(279)
    den(348) = den(1)*den(192)
    den(349) = den(1)*den(194)
    den(350) = den(100)*den(206)
    den(351) = den(100)*den(208)
    den(352) = den(100)*den(210)
    den(353) = den(100)*den(212)
    den(354) = den(3)*den(206)
    den(355) = den(3)*den(208)
    den(356) = den(3)*den(210)
    den(357) = den(3)*den(212)
    den(358) = den(21)*den(206)
    den(359) = den(21)*den(208)
    den(360) = den(21)*den(210)
    den(361) = den(21)*den(212)
    den(362) = den(100)*den(148)
    den(363) = den(58)*den(59)*den(100)
    den(364) = den(3)*den(59)*den(62)
    den(365) = den(3)*den(58)*den(59)
    den(366) = den(21)*den(58)*den(70)
    den(367) = den(21)*den(58)*den(59)
    den(368) = den(58)*den(232)
    den(369) = den(59)*den(230)
    den(370) = den(100)*den(234)
    den(371) = den(100)*den(236)
    den(372) = den(100)*den(238)
    den(373) = den(3)*den(234)
    den(374) = den(3)*den(236)
    den(375) = den(3)*den(238)
    den(376) = den(21)*den(234)
    den(377) = den(21)*den(236)
    den(378) = den(21)*den(238)
    den(379) = den(100)*den(243)
    den(380) = den(100)*den(245)
    den(381) = den(100)*den(247)
    den(382) = den(3)*den(243)
    den(383) = den(3)*den(245)
    den(384) = den(3)*den(247)
    den(385) = den(21)*den(243)
    den(386) = den(21)*den(245)
    den(387) = den(21)*den(247)
    den(388) = den(100)*den(252)
    den(389) = den(100)*den(254)
    den(390) = den(3)*den(252)
    den(391) = den(3)*den(254)
    den(392) = den(21)*den(252)
    den(393) = den(21)*den(254)
    den(394) = den(3)*den(268)
    den(395) = den(3)*den(270)
    den(396) = den(3)*den(281)
    den(397) = den(3)*den(283)
    den(398) = den(3)*den(285)
    den(399) = den(21)*den(262)
    den(400) = den(21)*den(264)
    den(401) = den(21)*den(275)
    den(402) = den(21)*den(277)
    den(403) = den(21)*den(284)
    den(404) = den(3)*den(288)
    den(405) = den(3)*den(289)
    den(406) = den(3)*den(292)
    den(407) = den(3)*den(293)
    den(408) = den(21)*den(286)
    den(409) = den(21)*den(287)
    den(410) = den(21)*den(290)
    den(411) = den(21)*den(291)
    den(412) = den(3)*den(297)
    den(413) = den(3)*den(301)
    den(414) = den(3)*den(302)
    den(415) = den(3)*den(303)
    den(416) = den(21)*den(295)
    den(417) = den(21)*den(298)
    den(418) = den(21)*den(299)
    den(419) = den(21)*den(300)
    den(420) = den(3)*den(306)
    den(421) = den(3)*den(307)
    den(422) = den(3)*den(309)
    den(423) = den(21)*den(304)
    den(424) = den(21)*den(305)
    den(425) = den(21)*den(308)
    den(426) = den(3)*den(312)
    den(427) = den(3)*den(313)
    den(428) = den(3)*den(315)
    den(429) = den(21)*den(310)
    den(430) = den(21)*den(311)
    den(431) = den(21)*den(314)
    den(432) = den(3)*den(317)
    den(433) = den(3)*den(319)
    den(434) = den(21)*den(316)
    den(435) = den(21)*den(318)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,7),wf(:,8)) * den(7)
  A(2) = cont_QA(wf(:,8),wf(:,11)) * den(10)
  A(3) = cont_QA(wf(:,13),wf(:,14)) * den(14)
  A(4) = cont_QA(wf(:,13),wf(:,16)) * den(16)
  A(5) = cont_SS(wf(:,17),wf(:,18)) * den(20)
  A(6) = cont_QA(wf(:,22),wf(:,23)) * den(25)
  A(7) = cont_QA(wf(:,23),wf(:,24)) * den(27)
  A(8) = cont_QA(wf(:,26),wf(:,27)) * den(31)
  A(9) = cont_QA(wf(:,26),wf(:,29)) * den(33)
  A(10) = cont_SS(wf(:,18),wf(:,30)) * den(35)
  A(11) = cont_QA(wf(:,14),wf(:,31)) * den(36)
  A(12) = cont_QA(wf(:,16),wf(:,31)) * den(37)
  A(13) = cont_QA(wf(:,8),wf(:,32)) * den(38)
  A(14) = cont_QA(wf(:,8),wf(:,33)) * den(39)
  A(15) = cont_VV(wf(:,35),wf(:,37)) * den(44)
  A(16) = cont_VV(wf(:,39),wf(:,40)) * den(47)
  A(17) = cont_VV(wf(:,35),wf(:,43)) * den(50)
  A(18) = cont_VV(wf(:,39),wf(:,44)) * den(51)
  A(19) = cont_VV(wf(:,37),wf(:,45)) * den(53)
  A(20) = cont_VV(wf(:,40),wf(:,47)) * den(55)
  A(21) = cont_VV(wf(:,43),wf(:,45)) * den(56)
  A(22) = cont_VV(wf(:,44),wf(:,47)) * den(57)
  A(23) = cont_QA(wf(:,53),wf(:,54)) * den(63)
  A(24) = cont_SS(wf(:,17),wf(:,55)) * den(65)
  A(25) = cont_VV(wf(:,35),wf(:,56)) * den(66)
  A(26) = cont_VV(wf(:,39),wf(:,56)) * den(67)
  A(27) = cont_QA(wf(:,58),wf(:,59)) * den(71)
  A(28) = cont_SS(wf(:,30),wf(:,55)) * den(72)
  A(29) = cont_VV(wf(:,45),wf(:,56)) * den(73)
  A(30) = cont_VV(wf(:,47),wf(:,56)) * den(74)
  A(31) = cont_QA(wf(:,54),wf(:,60)) * den(75)
  A(32) = cont_VV(wf(:,35),wf(:,63)) * den(77)
  A(33) = cont_VV(wf(:,39),wf(:,64)) * den(78)
  A(34) = cont_VV(wf(:,39),wf(:,67)) * den(81)
  A(35) = cont_VV(wf(:,45),wf(:,63)) * den(82)
  A(36) = cont_VV(wf(:,47),wf(:,64)) * den(83)
  A(37) = cont_VV(wf(:,47),wf(:,67)) * den(84)
  A(38) = cont_VV(wf(:,35),wf(:,70)) * den(86)
  A(39) = cont_VV(wf(:,39),wf(:,71)) * den(87)
  A(40) = cont_VV(wf(:,39),wf(:,74)) * den(90)
  A(41) = cont_VV(wf(:,45),wf(:,70)) * den(91)
  A(42) = cont_VV(wf(:,47),wf(:,71)) * den(92)
  A(43) = cont_VV(wf(:,47),wf(:,74)) * den(93)
  A(44) = cont_VV(wf(:,39),wf(:,77)) * den(95)
  A(45) = cont_VV(wf(:,39),wf(:,80)) * den(97)
  A(46) = cont_VV(wf(:,47),wf(:,77)) * den(98)
  A(47) = cont_VV(wf(:,47),wf(:,80)) * den(99)

  A(48) = cont_VV(wf(:,81),wf(:,82)) * den(102)
  A(49) = cont_VV(wf(:,81),wf(:,83)) * den(103)
  A(50) = cont_VV(wf(:,81),wf(:,84)) * den(104)
  A(51) = cont_SS(wf(:,18),wf(:,85)) * den(107)
  A(52) = cont_QA(wf(:,8),wf(:,86)) * den(7)
  A(53) = cont_QA(wf(:,8),wf(:,87)) * den(10)
  A(54) = cont_QA(wf(:,14),wf(:,88)) * den(14)
  A(55) = cont_QA(wf(:,16),wf(:,88)) * den(16)
  A(56) = cont_QA(wf(:,23),wf(:,89)) * den(25)
  A(57) = cont_QA(wf(:,23),wf(:,90)) * den(27)
  A(58) = cont_QA(wf(:,27),wf(:,91)) * den(31)
  A(59) = cont_QA(wf(:,29),wf(:,91)) * den(33)
  A(60) = cont_QA(wf(:,14),wf(:,92)) * den(36)
  A(61) = cont_QA(wf(:,16),wf(:,92)) * den(37)
  A(62) = cont_VV(wf(:,93),wf(:,94)) * den(110)
  A(63) = cont_QA(wf(:,8),wf(:,95)) * den(38)
  A(64) = cont_QA(wf(:,8),wf(:,96)) * den(39)
  A(65) = cont_VV(wf(:,93),wf(:,97)) * den(111)
  A(66) = cont_VV(wf(:,98),wf(:,99)) * den(114)
  A(67) = cont_VV(wf(:,98),wf(:,100)) * den(115)
  A(68) = cont_VV(wf(:,98),wf(:,101)) * den(116)
  A(69) = cont_VV(wf(:,98),wf(:,102)) * den(117)
  A(70) = cont_SS(wf(:,18),wf(:,103)) * den(118)
  A(71) = cont_QA(wf(:,104),wf(:,105)) * den(121)
  A(72) = cont_QA(wf(:,105),wf(:,106)) * den(122)
  A(73) = cont_QA(wf(:,107),wf(:,108)) * den(125)
  A(74) = cont_QA(wf(:,107),wf(:,109)) * den(127)
  A(75) = cont_QA(wf(:,31),wf(:,110)) * den(36)
  A(76) = cont_QA(wf(:,31),wf(:,111)) * den(37)
  A(77) = cont_QA(wf(:,32),wf(:,112)) * den(38)
  A(78) = cont_QA(wf(:,33),wf(:,112)) * den(39)
  A(79) = cont_QA(wf(:,23),wf(:,115)) * den(25)
  A(80) = cont_QA(wf(:,23),wf(:,116)) * den(27)
  A(81) = cont_QA(wf(:,27),wf(:,117)) * den(31)
  A(82) = cont_QA(wf(:,29),wf(:,117)) * den(33)
  A(83) = cont_SS(wf(:,18),wf(:,118)) * den(35)
  A(84) = cont_SS(wf(:,18),wf(:,119)) * den(128)
  A(85) = cont_QA(wf(:,120),wf(:,121)) * den(131)
  A(86) = cont_QA(wf(:,121),wf(:,122)) * den(132)
  A(87) = cont_QA(wf(:,123),wf(:,124)) * den(135)
  A(88) = cont_QA(wf(:,123),wf(:,125)) * den(137)
  A(89) = cont_QA(wf(:,8),wf(:,127)) * den(38)
  A(90) = cont_QA(wf(:,8),wf(:,129)) * den(39)
  A(91) = cont_QA(wf(:,14),wf(:,131)) * den(36)
  A(92) = cont_QA(wf(:,16),wf(:,131)) * den(37)
  A(93) = cont_QA(wf(:,8),wf(:,134)) * den(7)
  A(94) = cont_QA(wf(:,8),wf(:,135)) * den(10)
  A(95) = cont_QA(wf(:,14),wf(:,136)) * den(14)
  A(96) = cont_QA(wf(:,16),wf(:,136)) * den(16)
  A(97) = cont_SS(wf(:,18),wf(:,137)) * den(20)
  A(98) = cont_VV(wf(:,40),wf(:,139)) * den(139)
  A(99) = cont_VV(wf(:,44),wf(:,139)) * den(140)
  A(100) = cont_VV(wf(:,37),wf(:,140)) * den(44)
  A(101) = cont_VV(wf(:,40),wf(:,142)) * den(47)
  A(102) = cont_VV(wf(:,43),wf(:,140)) * den(50)
  A(103) = cont_VV(wf(:,44),wf(:,142)) * den(51)
  A(104) = cont_VV(wf(:,37),wf(:,143)) * den(53)
  A(105) = cont_VV(wf(:,40),wf(:,145)) * den(55)
  A(106) = cont_VV(wf(:,43),wf(:,143)) * den(56)
  A(107) = cont_VV(wf(:,44),wf(:,145)) * den(57)
  A(108) = cont_VV(wf(:,37),wf(:,146)) * den(53)
  A(109) = cont_VV(wf(:,40),wf(:,148)) * den(55)
  A(110) = cont_VV(wf(:,43),wf(:,146)) * den(56)
  A(111) = cont_VV(wf(:,44),wf(:,148)) * den(57)
  A(112) = cont_VV(wf(:,37),wf(:,149)) * den(44)
  A(113) = cont_VV(wf(:,40),wf(:,151)) * den(47)
  A(114) = cont_VV(wf(:,43),wf(:,149)) * den(50)
  A(115) = cont_VV(wf(:,44),wf(:,151)) * den(51)
  A(116) = cont_SS(wf(:,55),wf(:,85)) * den(142)
  A(117) = cont_VV(wf(:,138),wf(:,152)) * den(145)
  A(118) = cont_QA(wf(:,54),wf(:,153)) * den(63)
  A(119) = cont_QA(wf(:,59),wf(:,154)) * den(71)
  A(120) = cont_QA(wf(:,54),wf(:,155)) * den(75)
  A(121) = cont_SS(wf(:,55),wf(:,103)) * den(146)
  A(122) = cont_VV(wf(:,56),wf(:,140)) * den(149)
  A(123) = cont_VV(wf(:,141),wf(:,152)) * den(150)
  A(124) = cont_QA(wf(:,156),wf(:,157)) * den(153)
  A(125) = cont_QA(wf(:,60),wf(:,158)) * den(75)
  A(126) = cont_QA(wf(:,59),wf(:,159)) * den(71)
  A(127) = cont_SS(wf(:,55),wf(:,118)) * den(72)
  A(128) = cont_VV(wf(:,56),wf(:,143)) * den(73)
  A(129) = cont_VV(wf(:,56),wf(:,145)) * den(74)
  A(130) = cont_SS(wf(:,55),wf(:,119)) * den(154)
  A(131) = cont_VV(wf(:,56),wf(:,146)) * den(155)
  A(132) = cont_VV(wf(:,147),wf(:,152)) * den(156)
  A(133) = cont_QA(wf(:,160),wf(:,161)) * den(159)
  A(134) = cont_QA(wf(:,54),wf(:,163)) * den(75)
  A(135) = cont_QA(wf(:,54),wf(:,164)) * den(63)
  A(136) = cont_SS(wf(:,55),wf(:,137)) * den(65)
  A(137) = cont_VV(wf(:,56),wf(:,149)) * den(66)
  A(138) = cont_VV(wf(:,56),wf(:,151)) * den(67)
  A(139) = cont_VV(wf(:,64),wf(:,139)) * den(160)
  A(140) = cont_VV(wf(:,67),wf(:,139)) * den(161)
  A(141) = cont_VV(wf(:,63),wf(:,140)) * den(77)
  A(142) = cont_VV(wf(:,64),wf(:,142)) * den(78)
  A(143) = cont_VV(wf(:,67),wf(:,142)) * den(81)
  A(144) = cont_VV(wf(:,63),wf(:,143)) * den(82)
  A(145) = cont_VV(wf(:,64),wf(:,145)) * den(83)
  A(146) = cont_VV(wf(:,67),wf(:,145)) * den(84)
  A(147) = cont_VV(wf(:,63),wf(:,146)) * den(82)
  A(148) = cont_VV(wf(:,64),wf(:,148)) * den(83)
  A(149) = cont_VV(wf(:,67),wf(:,148)) * den(84)
  A(150) = cont_VV(wf(:,63),wf(:,149)) * den(77)
  A(151) = cont_VV(wf(:,64),wf(:,151)) * den(78)
  A(152) = cont_VV(wf(:,67),wf(:,151)) * den(81)
  A(153) = cont_VV(wf(:,71),wf(:,139)) * den(162)
  A(154) = cont_VV(wf(:,74),wf(:,139)) * den(163)
  A(155) = cont_VV(wf(:,70),wf(:,140)) * den(86)
  A(156) = cont_VV(wf(:,71),wf(:,142)) * den(87)
  A(157) = cont_VV(wf(:,74),wf(:,142)) * den(90)
  A(158) = cont_VV(wf(:,70),wf(:,143)) * den(91)
  A(159) = cont_VV(wf(:,71),wf(:,145)) * den(92)
  A(160) = cont_VV(wf(:,74),wf(:,145)) * den(93)
  A(161) = cont_VV(wf(:,70),wf(:,146)) * den(91)
  A(162) = cont_VV(wf(:,71),wf(:,148)) * den(92)
  A(163) = cont_VV(wf(:,74),wf(:,148)) * den(93)
  A(164) = cont_VV(wf(:,70),wf(:,149)) * den(86)
  A(165) = cont_VV(wf(:,71),wf(:,151)) * den(87)
  A(166) = cont_VV(wf(:,74),wf(:,151)) * den(90)
  A(167) = cont_VV(wf(:,77),wf(:,139)) * den(164)
  A(168) = cont_VV(wf(:,80),wf(:,139)) * den(165)
  A(169) = cont_VV(wf(:,77),wf(:,142)) * den(95)
  A(170) = cont_VV(wf(:,80),wf(:,142)) * den(97)
  A(171) = cont_VV(wf(:,77),wf(:,145)) * den(98)
  A(172) = cont_VV(wf(:,80),wf(:,145)) * den(99)
  A(173) = cont_VV(wf(:,77),wf(:,148)) * den(98)
  A(174) = cont_VV(wf(:,80),wf(:,148)) * den(99)
  A(175) = cont_VV(wf(:,77),wf(:,151)) * den(95)
  A(176) = cont_VV(wf(:,80),wf(:,151)) * den(97)
  A(177) = cont_SS(wf(:,18),wf(:,167)) * den(167)
  A(178) = cont_QA(wf(:,8),wf(:,168)) * den(169)
  A(179) = cont_QA(wf(:,8),wf(:,169)) * den(171)
  A(180) = cont_QA(wf(:,14),wf(:,170)) * den(173)
  A(181) = cont_QA(wf(:,16),wf(:,170)) * den(174)
  A(182) = cont_QA(wf(:,108),wf(:,171)) * den(175)
  A(183) = cont_QA(wf(:,109),wf(:,171)) * den(176)
  A(184) = cont_QA(wf(:,105),wf(:,172)) * den(177)
  A(185) = cont_QA(wf(:,105),wf(:,173)) * den(178)
  A(186) = cont_SS(wf(:,18),wf(:,176)) * den(180)
  A(187) = cont_QA(wf(:,124),wf(:,177)) * den(181)
  A(188) = cont_QA(wf(:,125),wf(:,177)) * den(182)
  A(189) = cont_QA(wf(:,121),wf(:,178)) * den(183)
  A(190) = cont_QA(wf(:,121),wf(:,179)) * den(184)
  A(191) = cont_QA(wf(:,23),wf(:,180)) * den(186)
  A(192) = cont_QA(wf(:,23),wf(:,181)) * den(188)
  A(193) = cont_QA(wf(:,27),wf(:,182)) * den(190)
  A(194) = cont_QA(wf(:,29),wf(:,182)) * den(191)
  A(195) = cont_QA(wf(:,177),wf(:,184)) * den(193)
  A(196) = cont_QA(wf(:,177),wf(:,186)) * den(195)
  A(197) = cont_QA(wf(:,178),wf(:,188)) * den(197)
  A(198) = cont_QA(wf(:,179),wf(:,188)) * den(198)
  A(199) = cont_QA(wf(:,172),wf(:,189)) * den(200)
  A(200) = cont_QA(wf(:,173),wf(:,189)) * den(201)
  A(201) = cont_QA(wf(:,171),wf(:,190)) * den(203)
  A(202) = cont_QA(wf(:,171),wf(:,191)) * den(205)
  A(203) = cont_VV(wf(:,37),wf(:,192)) * den(207)
  A(204) = cont_VV(wf(:,193),wf(:,194)) * den(209)
  A(205) = cont_VV(wf(:,43),wf(:,192)) * den(211)
  A(206) = cont_VV(wf(:,193),wf(:,195)) * den(213)
  A(207) = cont_VV(wf(:,37),wf(:,196)) * den(214)
  A(208) = cont_VV(wf(:,194),wf(:,197)) * den(215)
  A(209) = cont_VV(wf(:,43),wf(:,196)) * den(216)
  A(210) = cont_VV(wf(:,195),wf(:,197)) * den(217)
  A(211) = cont_SS(wf(:,55),wf(:,167)) * den(218)
  A(212) = cont_VV(wf(:,56),wf(:,192)) * den(219)
  A(213) = cont_VV(wf(:,152),wf(:,193)) * den(220)
  A(214) = cont_QA(wf(:,54),wf(:,198)) * den(222)
  A(215) = cont_QA(wf(:,157),wf(:,199)) * den(223)
  A(216) = cont_SS(wf(:,55),wf(:,176)) * den(224)
  A(217) = cont_VV(wf(:,56),wf(:,196)) * den(225)
  A(218) = cont_VV(wf(:,152),wf(:,197)) * den(226)
  A(219) = cont_QA(wf(:,161),wf(:,200)) * den(227)
  A(220) = cont_QA(wf(:,59),wf(:,201)) * den(229)
  A(221) = cont_QA(wf(:,200),wf(:,203)) * den(231)
  A(222) = cont_QA(wf(:,199),wf(:,204)) * den(233)
  A(223) = cont_VV(wf(:,63),wf(:,192)) * den(235)
  A(224) = cont_VV(wf(:,193),wf(:,205)) * den(237)
  A(225) = cont_VV(wf(:,193),wf(:,206)) * den(239)
  A(226) = cont_VV(wf(:,63),wf(:,196)) * den(240)
  A(227) = cont_VV(wf(:,197),wf(:,205)) * den(241)
  A(228) = cont_VV(wf(:,197),wf(:,206)) * den(242)
  A(229) = cont_VV(wf(:,70),wf(:,192)) * den(244)
  A(230) = cont_VV(wf(:,193),wf(:,207)) * den(246)
  A(231) = cont_VV(wf(:,193),wf(:,208)) * den(248)
  A(232) = cont_VV(wf(:,70),wf(:,196)) * den(249)
  A(233) = cont_VV(wf(:,197),wf(:,207)) * den(250)
  A(234) = cont_VV(wf(:,197),wf(:,208)) * den(251)
  A(235) = cont_VV(wf(:,193),wf(:,209)) * den(253)
  A(236) = cont_VV(wf(:,193),wf(:,210)) * den(255)
  A(237) = cont_VV(wf(:,197),wf(:,209)) * den(256)
  A(238) = cont_VV(wf(:,197),wf(:,210)) * den(257)


  ! colour vectors

  M1(1) = (A(1)+A(3)+A(6)+A(8)+A(11)+A(13)+A(15)+A(17)+A(19)+A(21))*f(1)+(A(2)+A(4)+A(7)+A(9)+A(12)+A(14)+A(16)+A(18)+A(20)+A(22) &
       +A(44)+A(45)+A(46)+A(47))*f(2)+(-A(23)-A(27)-A(31))*f(13)+(A(24)+A(28))*f(18)+(-A(26)-A(30))*f(22)+(A(25)+A(29)-A(32)-A(35) &
       -A(38)-A(41))*f(28)+(-A(33)-A(34)-A(36)-A(37)-A(39)-A(40)-A(42)-A(43))*f(29)+(-A(5)-A(10))*f(38)

  M2(1) = (-A(178)-A(180)-A(182)-A(184)-A(187)-A(189)-A(191)-A(193)-A(195)-A(197)-A(199)-A(201)-A(203)-A(205)-A(207)-A(209))*f(3) &
       +(-A(179)-A(181)-A(183)-A(185)-A(188)-A(190)-A(192)-A(194)-A(196)-A(198)-A(200)-A(202)-A(204)-A(206)-A(208)-A(210)-A(235) &
       -A(236)-A(237)-A(238))*f(4)+A(48)*f(5)+(A(60)+A(63)+A(79)+A(81)+A(93)+A(95)+A(104)+A(106)+A(112)+A(114))*f(6)+(A(61)+A(64) &
       +A(80)+A(82)+A(94)+A(96)+A(105)+A(107)+A(113)+A(115)+A(171)+A(172)+A(175)+A(176))*f(7)+(A(52)+A(54)+A(56)+A(58)+A(71)+A(73) &
       +A(75)+A(77)+A(85)+A(87)+A(89)+A(91)+A(100)+A(102)+A(108)+A(110))*f(8)+(A(53)+A(55)+A(57)+A(59)+A(72)+A(74)+A(76)+A(78) &
       +A(86)+A(88)+A(90)+A(92)+A(101)+A(103)+A(109)+A(111)+A(169)+A(170)+A(173)+A(174))*f(9)+(-A(66)-A(68))*f(10)+(-A(62)-A(65) &
       -A(67)-A(69)-A(98)-A(99)-A(167)-A(168))*f(11)+A(49)*f(12)+(A(214)+A(215)+A(219)+A(220)+A(221)+A(222))*f(14)+(-A(126) &
       -A(135))*f(15)-A(120)*f(16)+(-A(118)-A(119)-A(124)-A(125)-A(133)-A(134))*f(17)+(-A(211)-A(216))*f(19)+(A(127)+A(136))*f(20) &
       +(A(121)+A(130))*f(21)+(A(213)+A(218))*f(23)+(-A(129)-A(138))*f(24)+(-A(123)-A(132))*f(25)+A(117)*f(26)+A(116)*f(27)+( &
       -A(212)-A(217)+A(223)+A(226)+A(229)+A(232))*f(30)+(A(224)+A(225)+A(227)+A(228)+A(230)+A(231)+A(233)+A(234))*f(31)+(A(128) &
       +A(137)-A(144)-A(150)-A(158)-A(164))*f(32)+(-A(145)-A(146)-A(151)-A(152)-A(159)-A(160)-A(165)-A(166))*f(33)+(A(122)+A(131) &
       -A(141)-A(147)-A(155)-A(161))*f(34)+(-A(142)-A(143)-A(148)-A(149)-A(156)-A(157)-A(162)-A(163))*f(35)-A(50)*f(36)+(A(139) &
       +A(140)+A(153)+A(154))*f(37)+(A(177)+A(186))*f(39)+(-A(83)-A(97))*f(40)+(-A(70)-A(84))*f(41)-A(51)*f(42)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_nenexeexbbxg_1_/**/REALKIND
