
module ol_colourmatrix_ppllllj_nenenexnexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_nenenexnexuuxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_nenenexnexuuxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_nenenexnexuuxg_1_/**/REALKIND

module ol_loop_ppllllj_nenenexnexuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(13), c(7)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:238)
  ! denominators
  complex(REALKIND), save :: den(323)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4*gQCD
    f( 2) = CI*countertermnorm*eQED**4*gQCD**3
    f( 3) = CI*countertermnorm*ctGqq*eQED**4*gQCD**3
    f( 4) = CI*countertermnorm*ctVqq*eQED**4*gQCD**3
    f( 5) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f( 6) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f( 7) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f( 8) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f( 9) = eQED**4*gQCD**3*integralnorm*SwB
    f(10) = eQED**4*gQCD**3*integralnorm*SwF
    f(11) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(12) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(13) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(8), f(9), 8*f(9), 3*f(10), 3*f(11), 3*f(12), 3*f(13) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(156)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_Q(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_A(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_A(P(:,6), rZERO, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_Z(gZn,wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,5),MZ,1_intkind1,wf(:,4))
  call prop_W_W(wf(:,2),Q(:,10),MZ,1_intkind1,wf(:,5))
  call prop_Q_A(wf(:,3),Q(:,80),ZERO,0_intkind1,wf(:,6))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,4),wf(:,7))
  call vert_ZQ_A(gZu,wf(:,5),wf(:,6),wf(:,8))
  call prop_A_Q(wf(:,7),Q(:,37),ZERO,0_intkind1,wf(:,9))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,5),wf(:,10))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,6),wf(:,11))
  call prop_A_Q(wf(:,10),Q(:,42),ZERO,0_intkind1,wf(:,12))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,96),ZERO,0_intkind1,wf(:,14))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,-4),wf(:,15))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,5),wf(:,16))
  call prop_Q_A(wf(:,15),Q(:,21),ZERO,0_intkind1,wf(:,17))
  call vert_ZQ_A(gZu,wf(:,5),wf(:,-4),wf(:,18))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,4),wf(:,19))
  call prop_Q_A(wf(:,18),Q(:,26),ZERO,0_intkind1,wf(:,20))
  call vert_VQ_A(wf(:,-6),wf(:,17),wf(:,21))
  call vert_VQ_A(wf(:,-6),wf(:,20),wf(:,22))
  call vert_ZQ_A(gZn,wf(:,4),wf(:,-1),wf(:,23))
  call vert_QA_Z(gZu,wf(:,6),wf(:,-5),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,7),ZERO,0_intkind1,wf(:,25))
  call prop_W_W(wf(:,24),Q(:,112),MZ,1_intkind1,wf(:,26))
  call vert_QA_Z(gZn,wf(:,25),wf(:,-3),wf(:,27))
  call vert_AZ_Q(gZn,wf(:,-3),wf(:,4),wf(:,28))
  call prop_A_Q(wf(:,28),Q(:,13),ZERO,0_intkind1,wf(:,29))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,29),wf(:,30))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,14),wf(:,31))
  call prop_W_W(wf(:,31),Q(:,112),MZ,1_intkind1,wf(:,32))
  call vert_QA_Z(gZn,wf(:,0),wf(:,-3),wf(:,33))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,-2),wf(:,34))
  call prop_W_W(wf(:,33),Q(:,9),MZ,1_intkind1,wf(:,35))
  call prop_W_W(wf(:,34),Q(:,6),MZ,1_intkind1,wf(:,36))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,35),wf(:,37))
  call vert_ZQ_A(gZu,wf(:,36),wf(:,6),wf(:,38))
  call prop_A_Q(wf(:,37),Q(:,41),ZERO,0_intkind1,wf(:,39))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,36),wf(:,40))
  call vert_ZQ_A(gZu,wf(:,35),wf(:,6),wf(:,41))
  call prop_A_Q(wf(:,40),Q(:,38),ZERO,0_intkind1,wf(:,42))
  call vert_ZQ_A(gZu,wf(:,35),wf(:,-4),wf(:,43))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,36),wf(:,44))
  call prop_Q_A(wf(:,43),Q(:,25),ZERO,0_intkind1,wf(:,45))
  call vert_ZQ_A(gZu,wf(:,36),wf(:,-4),wf(:,46))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,35),wf(:,47))
  call prop_Q_A(wf(:,46),Q(:,22),ZERO,0_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,-6),wf(:,45),wf(:,49))
  call vert_VQ_A(wf(:,-6),wf(:,48),wf(:,50))
  call vert_ZQ_A(gZn,wf(:,36),wf(:,0),wf(:,51))
  call prop_Q_A(wf(:,51),Q(:,7),ZERO,0_intkind1,wf(:,52))
  call vert_QA_Z(gZn,wf(:,52),wf(:,-3),wf(:,53))
  call vert_AZ_Q(gZn,wf(:,-3),wf(:,36),wf(:,54))
  call prop_A_Q(wf(:,54),Q(:,14),ZERO,0_intkind1,wf(:,55))
  call vert_QA_Z(gZn,wf(:,0),wf(:,55),wf(:,56))
  call vert_ZQ_A(gZn,wf(:,35),wf(:,-1),wf(:,57))
  call prop_Q_A(wf(:,57),Q(:,11),ZERO,0_intkind1,wf(:,58))
  call vert_QA_Z(gZn,wf(:,58),wf(:,-2),wf(:,59))
  call vert_AZ_Q(gZn,wf(:,-2),wf(:,35),wf(:,60))
  call prop_A_Q(wf(:,60),Q(:,13),ZERO,0_intkind1,wf(:,61))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,61),wf(:,62))
  call vert_ZQ_A(gZn,wf(:,5),wf(:,0),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,11),ZERO,0_intkind1,wf(:,64))
  call vert_QA_Z(gZn,wf(:,64),wf(:,-2),wf(:,65))
  call vert_AZ_Q(gZn,wf(:,-2),wf(:,5),wf(:,66))
  call prop_A_Q(wf(:,66),Q(:,14),ZERO,0_intkind1,wf(:,67))
  call vert_QA_Z(gZn,wf(:,0),wf(:,67),wf(:,68))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,69))
  call counter_VVG_G(wf(:,4),wf(:,5),wf(:,-6),wf(:,70))
  call counter_VVG_G(wf(:,36),wf(:,35),wf(:,-6),wf(:,71))
  call vert_VV_S(wf(:,4),wf(:,5),wf(:,72))
  call counter_GG_S(wf(:,69),wf(:,-6),wf(:,73))
  call counter_ZQ_A(gZu,wf(:,5),wf(:,6),wf(:,74))
  call counter_ZQ_A(gZu,wf(:,4),wf(:,6),wf(:,75))
  call counter_AZ_Q(gZu,wf(:,14),wf(:,5),wf(:,76))
  call counter_AZ_Q(gZu,wf(:,14),wf(:,4),wf(:,77))
  call counter_VQ_A(wf(:,-6),wf(:,17),wf(:,78))
  call counter_VG_G(wf(:,5),wf(:,-6),Q(:,64),wf(:,79),Q(:,74))
  call vert_QA_V(wf(:,17),wf(:,-5),wf(:,80))
  call counter_VQ_A(wf(:,-6),wf(:,20),wf(:,81))
  call vert_QA_V(wf(:,-4),wf(:,9),wf(:,82))
  call counter_VG_G(wf(:,4),wf(:,-6),Q(:,64),wf(:,83),Q(:,69))
  call vert_QA_V(wf(:,20),wf(:,-5),wf(:,84))
  call vert_QA_V(wf(:,-4),wf(:,12),wf(:,85))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,5),wf(:,86))
  call prop_Q_A(wf(:,11),Q(:,85),ZERO,0_intkind1,wf(:,87))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,4),wf(:,88))
  call prop_Q_A(wf(:,8),Q(:,90),ZERO,0_intkind1,wf(:,89))
  call prop_A_Q(wf(:,86),Q(:,42),ZERO,0_intkind1,wf(:,90))
  call prop_A_Q(wf(:,88),Q(:,37),ZERO,0_intkind1,wf(:,91))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,92))
  call prop_A_Q(wf(:,92),Q(:,96),ZERO,0_intkind1,wf(:,93))
  call vert_AZ_Q(gZu,wf(:,93),wf(:,5),wf(:,94))
  call vert_AZ_Q(gZu,wf(:,93),wf(:,4),wf(:,95))
  call counter_ZQ_A(gZu,wf(:,5),wf(:,-4),wf(:,96))
  call prop_A_Q(wf(:,19),Q(:,101),ZERO,0_intkind1,wf(:,97))
  call counter_ZQ_A(gZu,wf(:,4),wf(:,-4),wf(:,98))
  call prop_A_Q(wf(:,16),Q(:,106),ZERO,0_intkind1,wf(:,99))
  call prop_Q_A(wf(:,96),Q(:,26),ZERO,0_intkind1,wf(:,100))
  call vert_VQ_A(wf(:,-6),wf(:,100),wf(:,101))
  call prop_Q_A(wf(:,98),Q(:,21),ZERO,0_intkind1,wf(:,102))
  call vert_VQ_A(wf(:,-6),wf(:,102),wf(:,103))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,104))
  call prop_Q_A(wf(:,104),Q(:,80),ZERO,0_intkind1,wf(:,105))
  call vert_ZQ_A(gZu,wf(:,5),wf(:,105),wf(:,106))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,105),wf(:,107))
  call counter_GG_V(wf(:,69),Q(:,48),wf(:,-6),Q(:,64),wf(:,108))
  call prop_W_W(wf(:,108),Q(:,112),MZ,1_intkind1,wf(:,109))
  call counter_QA_Z(gZu,wf(:,6),wf(:,-5),wf(:,110))
  call prop_W_W(wf(:,110),Q(:,112),MZ,1_intkind1,wf(:,111))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,93),wf(:,112))
  call prop_W_W(wf(:,112),Q(:,112),MZ,1_intkind1,wf(:,113))
  call counter_QA_Z(gZu,wf(:,-4),wf(:,14),wf(:,114))
  call prop_W_W(wf(:,114),Q(:,112),MZ,1_intkind1,wf(:,115))
  call vert_QA_Z(gZu,wf(:,105),wf(:,-5),wf(:,116))
  call prop_W_W(wf(:,116),Q(:,112),MZ,1_intkind1,wf(:,117))
  call vert_VV_S(wf(:,36),wf(:,35),wf(:,118))
  call counter_ZQ_A(gZu,wf(:,36),wf(:,6),wf(:,119))
  call counter_ZQ_A(gZu,wf(:,35),wf(:,6),wf(:,120))
  call counter_AZ_Q(gZu,wf(:,14),wf(:,36),wf(:,121))
  call counter_AZ_Q(gZu,wf(:,14),wf(:,35),wf(:,122))
  call counter_VQ_A(wf(:,-6),wf(:,45),wf(:,123))
  call counter_VG_G(wf(:,36),wf(:,-6),Q(:,64),wf(:,124),Q(:,70))
  call vert_QA_V(wf(:,45),wf(:,-5),wf(:,125))
  call counter_VQ_A(wf(:,-6),wf(:,48),wf(:,126))
  call vert_QA_V(wf(:,-4),wf(:,39),wf(:,127))
  call counter_VG_G(wf(:,35),wf(:,-6),Q(:,64),wf(:,128),Q(:,73))
  call vert_QA_V(wf(:,48),wf(:,-5),wf(:,129))
  call vert_QA_V(wf(:,-4),wf(:,42),wf(:,130))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,36),wf(:,131))
  call prop_Q_A(wf(:,41),Q(:,89),ZERO,0_intkind1,wf(:,132))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,35),wf(:,133))
  call prop_Q_A(wf(:,38),Q(:,86),ZERO,0_intkind1,wf(:,134))
  call prop_A_Q(wf(:,131),Q(:,38),ZERO,0_intkind1,wf(:,135))
  call prop_A_Q(wf(:,133),Q(:,41),ZERO,0_intkind1,wf(:,136))
  call vert_AZ_Q(gZu,wf(:,93),wf(:,36),wf(:,137))
  call vert_AZ_Q(gZu,wf(:,93),wf(:,35),wf(:,138))
  call counter_ZQ_A(gZu,wf(:,36),wf(:,-4),wf(:,139))
  call prop_A_Q(wf(:,47),Q(:,105),ZERO,0_intkind1,wf(:,140))
  call counter_ZQ_A(gZu,wf(:,35),wf(:,-4),wf(:,141))
  call prop_A_Q(wf(:,44),Q(:,102),ZERO,0_intkind1,wf(:,142))
  call prop_Q_A(wf(:,139),Q(:,22),ZERO,0_intkind1,wf(:,143))
  call vert_VQ_A(wf(:,-6),wf(:,143),wf(:,144))
  call prop_Q_A(wf(:,141),Q(:,25),ZERO,0_intkind1,wf(:,145))
  call vert_VQ_A(wf(:,-6),wf(:,145),wf(:,146))
  call vert_ZQ_A(gZu,wf(:,36),wf(:,105),wf(:,147))
  call vert_ZQ_A(gZu,wf(:,35),wf(:,105),wf(:,148))
  call counter_Q_A(ctqq,wf(:,6),Q(:,80),wf(:,149))
  call prop_Q_A(wf(:,149),Q(:,80),ZERO,0_intkind1,wf(:,150))
  call vert_ZQ_A(gZu,wf(:,5),wf(:,150),wf(:,151))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,150),wf(:,152))
  call counter_A_Q(ctqq,wf(:,9),Q(:,37),wf(:,153))
  call counter_A_Q(ctqq,wf(:,12),Q(:,42),wf(:,154))
  call counter_Q_A(ctqq,wf(:,17),Q(:,21),wf(:,155))
  call counter_Q_A(ctqq,wf(:,20),Q(:,26),wf(:,156))
  call counter_A_Q(ctqq,wf(:,14),Q(:,96),wf(:,157))
  call prop_A_Q(wf(:,157),Q(:,96),ZERO,0_intkind1,wf(:,158))
  call vert_AZ_Q(gZu,wf(:,158),wf(:,5),wf(:,159))
  call vert_AZ_Q(gZu,wf(:,158),wf(:,4),wf(:,160))
  call vert_AV_Q(wf(:,12),wf(:,-6),wf(:,161))
  call prop_A_Q(wf(:,161),Q(:,106),ZERO,0_intkind1,wf(:,162))
  call vert_AV_Q(wf(:,9),wf(:,-6),wf(:,163))
  call prop_A_Q(wf(:,163),Q(:,101),ZERO,0_intkind1,wf(:,164))
  call prop_Q_A(wf(:,21),Q(:,85),ZERO,0_intkind1,wf(:,165))
  call prop_Q_A(wf(:,22),Q(:,90),ZERO,0_intkind1,wf(:,166))
  call vert_QA_Z(gZu,wf(:,150),wf(:,-5),wf(:,167))
  call prop_W_W(wf(:,27),Q(:,15),MZ,1_intkind1,wf(:,168))
  call prop_W_W(wf(:,30),Q(:,15),MZ,1_intkind1,wf(:,169))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,158),wf(:,170))
  call vert_ZQ_A(gZu,wf(:,36),wf(:,150),wf(:,171))
  call vert_ZQ_A(gZu,wf(:,35),wf(:,150),wf(:,172))
  call counter_A_Q(ctqq,wf(:,39),Q(:,41),wf(:,173))
  call counter_A_Q(ctqq,wf(:,42),Q(:,38),wf(:,174))
  call counter_Q_A(ctqq,wf(:,45),Q(:,25),wf(:,175))
  call counter_Q_A(ctqq,wf(:,48),Q(:,22),wf(:,176))
  call vert_AZ_Q(gZu,wf(:,158),wf(:,36),wf(:,177))
  call vert_AZ_Q(gZu,wf(:,158),wf(:,35),wf(:,178))
  call vert_AV_Q(wf(:,42),wf(:,-6),wf(:,179))
  call prop_A_Q(wf(:,179),Q(:,102),ZERO,0_intkind1,wf(:,180))
  call vert_AV_Q(wf(:,39),wf(:,-6),wf(:,181))
  call prop_A_Q(wf(:,181),Q(:,105),ZERO,0_intkind1,wf(:,182))
  call prop_Q_A(wf(:,49),Q(:,89),ZERO,0_intkind1,wf(:,183))
  call prop_Q_A(wf(:,50),Q(:,86),ZERO,0_intkind1,wf(:,184))
  call prop_W_W(wf(:,53),Q(:,15),MZ,1_intkind1,wf(:,185))
  call prop_W_W(wf(:,56),Q(:,15),MZ,1_intkind1,wf(:,186))
  call prop_W_W(wf(:,59),Q(:,15),MZ,1_intkind1,wf(:,187))
  call prop_W_W(wf(:,62),Q(:,15),MZ,1_intkind1,wf(:,188))
  call prop_W_W(wf(:,65),Q(:,15),MZ,1_intkind1,wf(:,189))
  call prop_W_W(wf(:,68),Q(:,15),MZ,1_intkind1,wf(:,190))
  call vert_ZQ_A(gZu,wf(:,5),wf(:,17),wf(:,191))
  call prop_Q_A(wf(:,191),Q(:,31),ZERO,0_intkind1,wf(:,192))
  call vert_AZ_Q(gZu,wf(:,9),wf(:,5),wf(:,193))
  call prop_A_Q(wf(:,193),Q(:,47),ZERO,0_intkind1,wf(:,194))
  call vert_ZQ_A(gZu,wf(:,4),wf(:,20),wf(:,195))
  call prop_Q_A(wf(:,195),Q(:,31),ZERO,0_intkind1,wf(:,196))
  call vert_AZ_Q(gZu,wf(:,12),wf(:,4),wf(:,197))
  call prop_A_Q(wf(:,197),Q(:,47),ZERO,0_intkind1,wf(:,198))
  call vert_ZQ_A(gZu,wf(:,168),wf(:,-4),wf(:,199))
  call prop_Q_A(wf(:,199),Q(:,31),ZERO,0_intkind1,wf(:,200))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,168),wf(:,201))
  call prop_A_Q(wf(:,201),Q(:,47),ZERO,0_intkind1,wf(:,202))
  call vert_ZQ_A(gZu,wf(:,169),wf(:,-4),wf(:,203))
  call prop_Q_A(wf(:,203),Q(:,31),ZERO,0_intkind1,wf(:,204))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,169),wf(:,205))
  call prop_A_Q(wf(:,205),Q(:,47),ZERO,0_intkind1,wf(:,206))
  call vert_ZQ_A(gZu,wf(:,36),wf(:,45),wf(:,207))
  call prop_Q_A(wf(:,207),Q(:,31),ZERO,0_intkind1,wf(:,208))
  call vert_AZ_Q(gZu,wf(:,39),wf(:,36),wf(:,209))
  call prop_A_Q(wf(:,209),Q(:,47),ZERO,0_intkind1,wf(:,210))
  call vert_ZQ_A(gZu,wf(:,35),wf(:,48),wf(:,211))
  call prop_Q_A(wf(:,211),Q(:,31),ZERO,0_intkind1,wf(:,212))
  call vert_AZ_Q(gZu,wf(:,42),wf(:,35),wf(:,213))
  call prop_A_Q(wf(:,213),Q(:,47),ZERO,0_intkind1,wf(:,214))
  call vert_ZQ_A(gZu,wf(:,185),wf(:,-4),wf(:,215))
  call prop_Q_A(wf(:,215),Q(:,31),ZERO,0_intkind1,wf(:,216))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,185),wf(:,217))
  call prop_A_Q(wf(:,217),Q(:,47),ZERO,0_intkind1,wf(:,218))
  call vert_ZQ_A(gZu,wf(:,186),wf(:,-4),wf(:,219))
  call prop_Q_A(wf(:,219),Q(:,31),ZERO,0_intkind1,wf(:,220))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,186),wf(:,221))
  call prop_A_Q(wf(:,221),Q(:,47),ZERO,0_intkind1,wf(:,222))
  call vert_ZQ_A(gZu,wf(:,187),wf(:,-4),wf(:,223))
  call prop_Q_A(wf(:,223),Q(:,31),ZERO,0_intkind1,wf(:,224))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,187),wf(:,225))
  call prop_A_Q(wf(:,225),Q(:,47),ZERO,0_intkind1,wf(:,226))
  call vert_ZQ_A(gZu,wf(:,188),wf(:,-4),wf(:,227))
  call prop_Q_A(wf(:,227),Q(:,31),ZERO,0_intkind1,wf(:,228))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,188),wf(:,229))
  call prop_A_Q(wf(:,229),Q(:,47),ZERO,0_intkind1,wf(:,230))
  call vert_ZQ_A(gZu,wf(:,189),wf(:,-4),wf(:,231))
  call prop_Q_A(wf(:,231),Q(:,31),ZERO,0_intkind1,wf(:,232))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,189),wf(:,233))
  call prop_A_Q(wf(:,233),Q(:,47),ZERO,0_intkind1,wf(:,234))
  call vert_ZQ_A(gZu,wf(:,190),wf(:,-4),wf(:,235))
  call prop_Q_A(wf(:,235),Q(:,31),ZERO,0_intkind1,wf(:,236))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,190),wf(:,237))
  call prop_A_Q(wf(:,237),Q(:,47),ZERO,0_intkind1,wf(:,238))


  ! propagators

    den(1) = 1 / (Q(5,5) - MZ2)
    den(2) = 1 / (Q(5,10) - MZ2)
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,37))
    den(9) = 1 / (Q(5,42))
    den(12) = 1 / (Q(5,96))
    den(14) = 1 / (Q(5,21))
    den(18) = 1 / (Q(5,26))
    den(23) = 1 / (Q(5,7))
    den(25) = 1 / (Q(5,112) - MZ2)
    den(28) = 1 / (Q(5,13))
    den(34) = 1 / (Q(5,9) - MZ2)
    den(35) = 1 / (Q(5,6) - MZ2)
    den(37) = 1 / (Q(5,41))
    den(41) = 1 / (Q(5,38))
    den(45) = 1 / (Q(5,25))
    den(49) = 1 / (Q(5,22))
    den(56) = 1 / (Q(5,14))
    den(61) = 1 / (Q(5,11))
    den(74) = 1 / (Q(5,48))
    den(79) = 1 / (Q(5,15) - MH2)
    den(82) = 1 / (Q(5,74))
    den(86) = 1 / (Q(5,69))
    den(90) = 1 / (Q(5,85))
    den(93) = 1 / (Q(5,90))
    den(96) = 1 / (Q(5,101))
    den(99) = 1 / (Q(5,106))
    den(107) = 1 / (Q(5,70))
    den(111) = 1 / (Q(5,73))
    den(115) = 1 / (Q(5,89))
    den(118) = 1 / (Q(5,86))
    den(121) = 1 / (Q(5,105))
    den(124) = 1 / (Q(5,102))
    den(155) = 1 / (Q(5,15) - MZ2)
    den(200) = 1 / (Q(5,53))
    den(203) = 1 / (Q(5,31))
    den(207) = 1 / (Q(5,47))
    den(209) = 1 / (Q(5,58))
    den(220) = 1 / (Q(5,57))
    den(227) = 1 / (Q(5,54))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(8) = den(1)*den(3)
    den(10) = den(2)*den(9)
    den(11) = den(8)*den(10)
    den(13) = den(2)*den(12)
    den(15) = den(1)*den(14)
    den(16) = den(13)*den(15)
    den(17) = den(1)*den(12)
    den(19) = den(2)*den(18)
    den(20) = den(17)*den(19)
    den(21) = den(10)*den(15)
    den(22) = den(6)*den(19)
    den(24) = den(1)*den(23)
    den(26) = den(3)*den(25)
    den(27) = den(24)*den(26)
    den(29) = den(1)*den(28)
    den(30) = den(26)*den(29)
    den(31) = den(12)*den(25)
    den(32) = den(24)*den(31)
    den(33) = den(29)*den(31)
    den(36) = den(3)*den(35)
    den(38) = den(34)*den(37)
    den(39) = den(36)*den(38)
    den(40) = den(3)*den(34)
    den(42) = den(35)*den(41)
    den(43) = den(40)*den(42)
    den(44) = den(12)*den(35)
    den(46) = den(34)*den(45)
    den(47) = den(44)*den(46)
    den(48) = den(12)*den(34)
    den(50) = den(35)*den(49)
    den(51) = den(48)*den(50)
    den(52) = den(42)*den(46)
    den(53) = den(38)*den(50)
    den(54) = den(23)*den(35)
    den(55) = den(26)*den(54)
    den(57) = den(35)*den(56)
    den(58) = den(26)*den(57)
    den(59) = den(31)*den(54)
    den(60) = den(31)*den(57)
    den(62) = den(34)*den(61)
    den(63) = den(26)*den(62)
    den(64) = den(28)*den(34)
    den(65) = den(26)*den(64)
    den(66) = den(31)*den(62)
    den(67) = den(31)*den(64)
    den(68) = den(2)*den(61)
    den(69) = den(26)*den(68)
    den(70) = den(2)*den(56)
    den(71) = den(26)*den(70)
    den(72) = den(31)*den(68)
    den(73) = den(31)*den(70)
    den(75) = den(1)*den(2)
    den(76) = den(74)*den(75)
    den(77) = den(34)*den(35)
    den(78) = den(74)*den(77)
    den(80) = den(75)*den(79)
    den(81) = den(74)*den(80)
    den(83) = den(2)*den(82)
    den(84) = den(15)*den(83)
    den(85) = den(6)*den(83)
    den(87) = den(1)*den(86)
    den(88) = den(19)*den(87)
    den(89) = den(10)*den(87)
    den(91) = den(8)*den(90)
    den(92) = den(2)*den(91)
    den(94) = den(4)*den(93)
    den(95) = den(1)*den(94)
    den(97) = den(17)*den(96)
    den(98) = den(2)*den(97)
    den(100) = den(13)*den(99)
    den(101) = den(1)*den(100)
    den(102) = den(25)*den(74)
    den(103) = den(24)*den(102)
    den(104) = den(29)*den(102)
    den(105) = den(77)*den(79)
    den(106) = den(74)*den(105)
    den(108) = den(35)*den(107)
    den(109) = den(46)*den(108)
    den(110) = den(38)*den(108)
    den(112) = den(34)*den(111)
    den(113) = den(50)*den(112)
    den(114) = den(42)*den(112)
    den(116) = den(40)*den(115)
    den(117) = den(35)*den(116)
    den(119) = den(36)*den(118)
    den(120) = den(34)*den(119)
    den(122) = den(48)*den(121)
    den(123) = den(35)*den(122)
    den(125) = den(44)*den(124)
    den(126) = den(34)*den(125)
    den(127) = den(54)*den(102)
    den(128) = den(57)*den(102)
    den(129) = den(62)*den(102)
    den(130) = den(64)*den(102)
    den(131) = den(68)*den(102)
    den(132) = den(70)*den(102)
    den(133) = den(3)**2
    den(134) = den(2)*den(133)
    den(135) = den(6)*den(134)
    den(136) = den(1)*den(133)
    den(137) = den(10)*den(136)
    den(138) = den(6)*den(94)
    den(139) = den(10)*den(91)
    den(140) = den(15)*den(100)
    den(141) = den(19)*den(97)
    den(142) = den(12)**2
    den(143) = den(2)*den(142)
    den(144) = den(15)*den(143)
    den(145) = den(1)*den(142)
    den(146) = den(19)*den(145)
    den(147) = den(10)*den(99)
    den(148) = den(15)*den(147)
    den(149) = den(6)*den(96)
    den(150) = den(19)*den(149)
    den(151) = den(15)*den(90)
    den(152) = den(10)*den(151)
    den(153) = den(19)*den(93)
    den(154) = den(6)*den(153)
    den(156) = den(24)*den(155)
    den(157) = den(133)*den(156)
    den(158) = den(29)*den(155)
    den(159) = den(133)*den(158)
    den(160) = den(142)*den(156)
    den(161) = den(142)*den(158)
    den(162) = den(35)*den(133)
    den(163) = den(38)*den(162)
    den(164) = den(34)*den(133)
    den(165) = den(42)*den(164)
    den(166) = den(38)*den(119)
    den(167) = den(42)*den(116)
    den(168) = den(46)*den(125)
    den(169) = den(50)*den(122)
    den(170) = den(35)*den(142)
    den(171) = den(46)*den(170)
    den(172) = den(34)*den(142)
    den(173) = den(50)*den(172)
    den(174) = den(42)*den(124)
    den(175) = den(46)*den(174)
    den(176) = den(38)*den(121)
    den(177) = den(50)*den(176)
    den(178) = den(46)*den(115)
    den(179) = den(42)*den(178)
    den(180) = den(50)*den(118)
    den(181) = den(38)*den(180)
    den(182) = den(54)*den(155)
    den(183) = den(133)*den(182)
    den(184) = den(57)*den(155)
    den(185) = den(133)*den(184)
    den(186) = den(142)*den(182)
    den(187) = den(142)*den(184)
    den(188) = den(62)*den(155)
    den(189) = den(133)*den(188)
    den(190) = den(64)*den(155)
    den(191) = den(133)*den(190)
    den(192) = den(142)*den(188)
    den(193) = den(142)*den(190)
    den(194) = den(68)*den(155)
    den(195) = den(133)*den(194)
    den(196) = den(70)*den(155)
    den(197) = den(133)*den(196)
    den(198) = den(142)*den(194)
    den(199) = den(142)*den(196)
    den(201) = den(15)*den(200)
    den(202) = den(2)*den(15)
    den(204) = den(202)*den(203)
    den(205) = den(6)*den(200)
    den(206) = den(2)*den(6)
    den(208) = den(206)*den(207)
    den(210) = den(19)*den(209)
    den(211) = den(1)*den(19)
    den(212) = den(203)*den(211)
    den(213) = den(10)*den(209)
    den(214) = den(1)*den(10)
    den(215) = den(207)*den(214)
    den(216) = den(156)*den(203)
    den(217) = den(156)*den(207)
    den(218) = den(158)*den(203)
    den(219) = den(158)*den(207)
    den(221) = den(46)*den(220)
    den(222) = den(35)*den(46)
    den(223) = den(203)*den(222)
    den(224) = den(38)*den(220)
    den(225) = den(35)*den(38)
    den(226) = den(207)*den(225)
    den(228) = den(50)*den(227)
    den(229) = den(34)*den(50)
    den(230) = den(203)*den(229)
    den(231) = den(42)*den(227)
    den(232) = den(34)*den(42)
    den(233) = den(207)*den(232)
    den(234) = den(182)*den(203)
    den(235) = den(182)*den(207)
    den(236) = den(184)*den(203)
    den(237) = den(184)*den(207)
    den(238) = den(188)*den(203)
    den(239) = den(188)*den(207)
    den(240) = den(190)*den(203)
    den(241) = den(190)*den(207)
    den(242) = den(194)*den(203)
    den(243) = den(194)*den(207)
    den(244) = den(196)*den(203)
    den(245) = den(196)*den(207)
    den(246) = den(1)*den(2)*den(74)
    den(247) = den(2)*den(3)*den(6)
    den(248) = den(1)*den(3)*den(10)
    den(249) = den(1)*den(2)*den(3)
    den(250) = den(2)*den(12)*den(15)
    den(251) = den(1)*den(12)*den(19)
    den(252) = den(1)*den(2)*den(12)
    den(253) = den(2)*den(201)
    den(254) = den(2)*den(151)
    den(255) = den(2)*den(205)
    den(256) = den(2)*den(149)
    den(257) = den(1)*den(210)
    den(258) = den(1)*den(153)
    den(259) = den(1)*den(213)
    den(260) = den(1)*den(147)
    den(261) = den(74)*den(156)
    den(262) = den(74)*den(158)
    den(263) = den(3)*den(156)
    den(264) = den(3)*den(158)
    den(265) = den(12)*den(156)
    den(266) = den(12)*den(158)
    den(267) = den(34)*den(35)*den(74)
    den(268) = den(3)*den(35)*den(38)
    den(269) = den(3)*den(34)*den(42)
    den(270) = den(3)*den(34)*den(35)
    den(271) = den(12)*den(35)*den(46)
    den(272) = den(12)*den(34)*den(50)
    den(273) = den(12)*den(34)*den(35)
    den(274) = den(35)*den(221)
    den(275) = den(35)*den(178)
    den(276) = den(35)*den(224)
    den(277) = den(35)*den(176)
    den(278) = den(34)*den(228)
    den(279) = den(34)*den(180)
    den(280) = den(34)*den(231)
    den(281) = den(34)*den(174)
    den(282) = den(74)*den(182)
    den(283) = den(74)*den(184)
    den(284) = den(3)*den(182)
    den(285) = den(3)*den(184)
    den(286) = den(12)*den(182)
    den(287) = den(12)*den(184)
    den(288) = den(74)*den(188)
    den(289) = den(74)*den(190)
    den(290) = den(3)*den(188)
    den(291) = den(3)*den(190)
    den(292) = den(12)*den(188)
    den(293) = den(12)*den(190)
    den(294) = den(74)*den(194)
    den(295) = den(74)*den(196)
    den(296) = den(3)*den(194)
    den(297) = den(3)*den(196)
    den(298) = den(12)*den(194)
    den(299) = den(12)*den(196)
    den(300) = den(3)*den(208)
    den(301) = den(3)*den(215)
    den(302) = den(12)*den(204)
    den(303) = den(12)*den(212)
    den(304) = den(3)*den(217)
    den(305) = den(3)*den(219)
    den(306) = den(12)*den(216)
    den(307) = den(12)*den(218)
    den(308) = den(3)*den(226)
    den(309) = den(3)*den(233)
    den(310) = den(12)*den(223)
    den(311) = den(12)*den(230)
    den(312) = den(3)*den(235)
    den(313) = den(3)*den(237)
    den(314) = den(12)*den(234)
    den(315) = den(12)*den(236)
    den(316) = den(3)*den(239)
    den(317) = den(3)*den(241)
    den(318) = den(12)*den(238)
    den(319) = den(12)*den(240)
    den(320) = den(3)*den(243)
    den(321) = den(3)*den(245)
    den(322) = den(12)*den(242)
    den(323) = den(12)*den(244)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,8),wf(:,9)) * den(7)
  A(2) = cont_QA(wf(:,11),wf(:,12)) * den(11)
  A(3) = cont_QA(wf(:,16),wf(:,17)) * den(16)
  A(4) = cont_QA(wf(:,19),wf(:,20)) * den(20)
  A(5) = cont_QA(wf(:,12),wf(:,21)) * den(21)
  A(6) = cont_QA(wf(:,9),wf(:,22)) * den(22)
  A(7) = cont_VV(wf(:,26),wf(:,27)) * den(27)
  A(8) = cont_VV(wf(:,26),wf(:,30)) * den(30)
  A(9) = cont_VV(wf(:,27),wf(:,32)) * den(32)
  A(10) = cont_VV(wf(:,30),wf(:,32)) * den(33)
  A(11) = cont_QA(wf(:,38),wf(:,39)) * den(39)
  A(12) = cont_QA(wf(:,41),wf(:,42)) * den(43)
  A(13) = cont_QA(wf(:,44),wf(:,45)) * den(47)
  A(14) = cont_QA(wf(:,47),wf(:,48)) * den(51)
  A(15) = cont_QA(wf(:,42),wf(:,49)) * den(52)
  A(16) = cont_QA(wf(:,39),wf(:,50)) * den(53)
  A(17) = cont_VV(wf(:,26),wf(:,53)) * den(55)
  A(18) = cont_VV(wf(:,26),wf(:,56)) * den(58)
  A(19) = cont_VV(wf(:,32),wf(:,53)) * den(59)
  A(20) = cont_VV(wf(:,32),wf(:,56)) * den(60)
  A(21) = cont_VV(wf(:,26),wf(:,59)) * den(63)
  A(22) = cont_VV(wf(:,26),wf(:,62)) * den(65)
  A(23) = cont_VV(wf(:,32),wf(:,59)) * den(66)
  A(24) = cont_VV(wf(:,32),wf(:,62)) * den(67)
  A(25) = cont_VV(wf(:,26),wf(:,65)) * den(69)
  A(26) = cont_VV(wf(:,26),wf(:,68)) * den(71)
  A(27) = cont_VV(wf(:,32),wf(:,65)) * den(72)
  A(28) = cont_VV(wf(:,32),wf(:,68)) * den(73)

  A(29) = cont_VV(wf(:,69),wf(:,70)) * den(76)
  A(30) = cont_VV(wf(:,69),wf(:,71)) * den(78)
  A(31) = cont_SS(wf(:,72),wf(:,73)) * den(81)
  A(32) = cont_QA(wf(:,9),wf(:,74)) * den(7)
  A(33) = cont_QA(wf(:,12),wf(:,75)) * den(11)
  A(34) = cont_QA(wf(:,17),wf(:,76)) * den(16)
  A(35) = cont_QA(wf(:,20),wf(:,77)) * den(20)
  A(36) = cont_QA(wf(:,12),wf(:,78)) * den(21)
  A(37) = cont_VV(wf(:,79),wf(:,80)) * den(84)
  A(38) = cont_QA(wf(:,9),wf(:,81)) * den(22)
  A(39) = cont_VV(wf(:,79),wf(:,82)) * den(85)
  A(40) = cont_VV(wf(:,83),wf(:,84)) * den(88)
  A(41) = cont_VV(wf(:,83),wf(:,85)) * den(89)
  A(42) = cont_QA(wf(:,86),wf(:,87)) * den(92)
  A(43) = cont_QA(wf(:,88),wf(:,89)) * den(95)
  A(44) = cont_QA(wf(:,21),wf(:,90)) * den(21)
  A(45) = cont_QA(wf(:,22),wf(:,91)) * den(22)
  A(46) = cont_QA(wf(:,17),wf(:,94)) * den(16)
  A(47) = cont_QA(wf(:,20),wf(:,95)) * den(20)
  A(48) = cont_QA(wf(:,96),wf(:,97)) * den(98)
  A(49) = cont_QA(wf(:,98),wf(:,99)) * den(101)
  A(50) = cont_QA(wf(:,9),wf(:,101)) * den(22)
  A(51) = cont_QA(wf(:,12),wf(:,103)) * den(21)
  A(52) = cont_QA(wf(:,9),wf(:,106)) * den(7)
  A(53) = cont_QA(wf(:,12),wf(:,107)) * den(11)
  A(54) = cont_VV(wf(:,27),wf(:,109)) * den(103)
  A(55) = cont_VV(wf(:,30),wf(:,109)) * den(104)
  A(56) = cont_VV(wf(:,27),wf(:,111)) * den(27)
  A(57) = cont_VV(wf(:,30),wf(:,111)) * den(30)
  A(58) = cont_VV(wf(:,27),wf(:,113)) * den(32)
  A(59) = cont_VV(wf(:,30),wf(:,113)) * den(33)
  A(60) = cont_VV(wf(:,27),wf(:,115)) * den(32)
  A(61) = cont_VV(wf(:,30),wf(:,115)) * den(33)
  A(62) = cont_VV(wf(:,27),wf(:,117)) * den(27)
  A(63) = cont_VV(wf(:,30),wf(:,117)) * den(30)
  A(64) = cont_SS(wf(:,73),wf(:,118)) * den(106)
  A(65) = cont_QA(wf(:,39),wf(:,119)) * den(39)
  A(66) = cont_QA(wf(:,42),wf(:,120)) * den(43)
  A(67) = cont_QA(wf(:,45),wf(:,121)) * den(47)
  A(68) = cont_QA(wf(:,48),wf(:,122)) * den(51)
  A(69) = cont_QA(wf(:,42),wf(:,123)) * den(52)
  A(70) = cont_VV(wf(:,124),wf(:,125)) * den(109)
  A(71) = cont_QA(wf(:,39),wf(:,126)) * den(53)
  A(72) = cont_VV(wf(:,124),wf(:,127)) * den(110)
  A(73) = cont_VV(wf(:,128),wf(:,129)) * den(113)
  A(74) = cont_VV(wf(:,128),wf(:,130)) * den(114)
  A(75) = cont_QA(wf(:,131),wf(:,132)) * den(117)
  A(76) = cont_QA(wf(:,133),wf(:,134)) * den(120)
  A(77) = cont_QA(wf(:,49),wf(:,135)) * den(52)
  A(78) = cont_QA(wf(:,50),wf(:,136)) * den(53)
  A(79) = cont_QA(wf(:,45),wf(:,137)) * den(47)
  A(80) = cont_QA(wf(:,48),wf(:,138)) * den(51)
  A(81) = cont_QA(wf(:,139),wf(:,140)) * den(123)
  A(82) = cont_QA(wf(:,141),wf(:,142)) * den(126)
  A(83) = cont_QA(wf(:,39),wf(:,144)) * den(53)
  A(84) = cont_QA(wf(:,42),wf(:,146)) * den(52)
  A(85) = cont_QA(wf(:,39),wf(:,147)) * den(39)
  A(86) = cont_QA(wf(:,42),wf(:,148)) * den(43)
  A(87) = cont_VV(wf(:,53),wf(:,109)) * den(127)
  A(88) = cont_VV(wf(:,56),wf(:,109)) * den(128)
  A(89) = cont_VV(wf(:,53),wf(:,111)) * den(55)
  A(90) = cont_VV(wf(:,56),wf(:,111)) * den(58)
  A(91) = cont_VV(wf(:,53),wf(:,113)) * den(59)
  A(92) = cont_VV(wf(:,56),wf(:,113)) * den(60)
  A(93) = cont_VV(wf(:,53),wf(:,115)) * den(59)
  A(94) = cont_VV(wf(:,56),wf(:,115)) * den(60)
  A(95) = cont_VV(wf(:,53),wf(:,117)) * den(55)
  A(96) = cont_VV(wf(:,56),wf(:,117)) * den(58)
  A(97) = cont_VV(wf(:,59),wf(:,109)) * den(129)
  A(98) = cont_VV(wf(:,62),wf(:,109)) * den(130)
  A(99) = cont_VV(wf(:,59),wf(:,111)) * den(63)
  A(100) = cont_VV(wf(:,62),wf(:,111)) * den(65)
  A(101) = cont_VV(wf(:,59),wf(:,113)) * den(66)
  A(102) = cont_VV(wf(:,62),wf(:,113)) * den(67)
  A(103) = cont_VV(wf(:,59),wf(:,115)) * den(66)
  A(104) = cont_VV(wf(:,62),wf(:,115)) * den(67)
  A(105) = cont_VV(wf(:,59),wf(:,117)) * den(63)
  A(106) = cont_VV(wf(:,62),wf(:,117)) * den(65)
  A(107) = cont_VV(wf(:,65),wf(:,109)) * den(131)
  A(108) = cont_VV(wf(:,68),wf(:,109)) * den(132)
  A(109) = cont_VV(wf(:,65),wf(:,111)) * den(69)
  A(110) = cont_VV(wf(:,68),wf(:,111)) * den(71)
  A(111) = cont_VV(wf(:,65),wf(:,113)) * den(72)
  A(112) = cont_VV(wf(:,68),wf(:,113)) * den(73)
  A(113) = cont_VV(wf(:,65),wf(:,115)) * den(72)
  A(114) = cont_VV(wf(:,68),wf(:,115)) * den(73)
  A(115) = cont_VV(wf(:,65),wf(:,117)) * den(69)
  A(116) = cont_VV(wf(:,68),wf(:,117)) * den(71)
  A(117) = cont_QA(wf(:,9),wf(:,151)) * den(135)
  A(118) = cont_QA(wf(:,12),wf(:,152)) * den(137)
  A(119) = cont_QA(wf(:,89),wf(:,153)) * den(138)
  A(120) = cont_QA(wf(:,87),wf(:,154)) * den(139)
  A(121) = cont_QA(wf(:,99),wf(:,155)) * den(140)
  A(122) = cont_QA(wf(:,97),wf(:,156)) * den(141)
  A(123) = cont_QA(wf(:,17),wf(:,159)) * den(144)
  A(124) = cont_QA(wf(:,20),wf(:,160)) * den(146)
  A(125) = cont_QA(wf(:,155),wf(:,162)) * den(148)
  A(126) = cont_QA(wf(:,156),wf(:,164)) * den(150)
  A(127) = cont_QA(wf(:,154),wf(:,165)) * den(152)
  A(128) = cont_QA(wf(:,153),wf(:,166)) * den(154)
  A(129) = cont_VV(wf(:,167),wf(:,168)) * den(157)
  A(130) = cont_VV(wf(:,167),wf(:,169)) * den(159)
  A(131) = cont_VV(wf(:,168),wf(:,170)) * den(160)
  A(132) = cont_VV(wf(:,169),wf(:,170)) * den(161)
  A(133) = cont_QA(wf(:,39),wf(:,171)) * den(163)
  A(134) = cont_QA(wf(:,42),wf(:,172)) * den(165)
  A(135) = cont_QA(wf(:,134),wf(:,173)) * den(166)
  A(136) = cont_QA(wf(:,132),wf(:,174)) * den(167)
  A(137) = cont_QA(wf(:,142),wf(:,175)) * den(168)
  A(138) = cont_QA(wf(:,140),wf(:,176)) * den(169)
  A(139) = cont_QA(wf(:,45),wf(:,177)) * den(171)
  A(140) = cont_QA(wf(:,48),wf(:,178)) * den(173)
  A(141) = cont_QA(wf(:,175),wf(:,180)) * den(175)
  A(142) = cont_QA(wf(:,176),wf(:,182)) * den(177)
  A(143) = cont_QA(wf(:,174),wf(:,183)) * den(179)
  A(144) = cont_QA(wf(:,173),wf(:,184)) * den(181)
  A(145) = cont_VV(wf(:,167),wf(:,185)) * den(183)
  A(146) = cont_VV(wf(:,167),wf(:,186)) * den(185)
  A(147) = cont_VV(wf(:,170),wf(:,185)) * den(186)
  A(148) = cont_VV(wf(:,170),wf(:,186)) * den(187)
  A(149) = cont_VV(wf(:,167),wf(:,187)) * den(189)
  A(150) = cont_VV(wf(:,167),wf(:,188)) * den(191)
  A(151) = cont_VV(wf(:,170),wf(:,187)) * den(192)
  A(152) = cont_VV(wf(:,170),wf(:,188)) * den(193)
  A(153) = cont_VV(wf(:,167),wf(:,189)) * den(195)
  A(154) = cont_VV(wf(:,167),wf(:,190)) * den(197)
  A(155) = cont_VV(wf(:,170),wf(:,189)) * den(198)
  A(156) = cont_VV(wf(:,170),wf(:,190)) * den(199)


  ! colour vectors

  M1(1) = (-A(1)-A(2)-A(3)-A(4)-A(5)-A(6)-A(7)-A(8)-A(9)-A(10)+A(11)+A(12)+A(13)+A(14)+A(15)+A(16)+A(17)+A(18)+A(19)+A(20)+A(21) &
       +A(22)+A(23)+A(24)-A(25)-A(26)-A(27)-A(28))*f(1)

  M2(1) = (A(117)+A(118)+A(119)+A(120)+A(121)+A(122)+A(123)+A(124)+A(125)+A(126)+A(127)+A(128)+A(129)+A(130)+A(131)+A(132)-A(133) &
       -A(134)-A(135)-A(136)-A(137)-A(138)-A(139)-A(140)-A(141)-A(142)-A(143)-A(144)-A(145)-A(146)-A(147)-A(148)-A(149)-A(150) &
       -A(151)-A(152)+A(153)+A(154)+A(155)+A(156))*f(2)+(-A(36)-A(38)-A(46)-A(47)-A(52)-A(53)-A(58)-A(59)-A(62)-A(63)+A(69)+A(71) &
       +A(79)+A(80)+A(85)+A(86)+A(91)+A(92)+A(95)+A(96)+A(101)+A(102)+A(105)+A(106)-A(111)-A(112)-A(115)-A(116))*f(3)+(-A(32) &
       -A(33)-A(34)-A(35)-A(42)-A(43)-A(44)-A(45)-A(48)-A(49)-A(50)-A(51)-A(56)-A(57)-A(60)-A(61)+A(65)+A(66)+A(67)+A(68)+A(75) &
       +A(76)+A(77)+A(78)+A(81)+A(82)+A(83)+A(84)+A(89)+A(90)+A(93)+A(94)+A(99)+A(100)+A(103)+A(104)-A(109)-A(110)-A(113) &
       -A(114))*f(4)+(A(37)+A(39)+A(40)+A(41)+A(54)+A(55)-A(70)-A(72)-A(73)-A(74)-A(87)-A(88)-A(97)-A(98)+A(107)+A(108))*f(5)+( &
       -A(29)+A(30))*f(6)+(A(31)-A(64))*f(7)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_nenenexnexuuxg_1_/**/REALKIND
