
module ol_colourmatrix_ppllllj_nenenexnexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_nenenexnexbbxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_nenenexnexbbxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_nenenexnexbbxg_1_/**/REALKIND

module ol_loop_ppllllj_nenenexnexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(19), c(10)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:254)
  ! denominators
  complex(REALKIND), save :: den(346)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*eQED**4*gQCD
    f( 2) = CI*countertermnorm*eQED**4*gQCD**3
    f( 3) = CI*countertermnorm*ctGbb*eQED**4*gQCD**3
    f( 4) = CI*countertermnorm*ctVbb*eQED**4*gQCD**3
    f( 5) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f( 6) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f( 7) = (CI*eQED**4*gQCD*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 8) = (CI*countertermnorm*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 9) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(10) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(11) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(12) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(13) = eQED**4*gQCD**3*integralnorm*SwB
    f(14) = (CI*eQED**4*gQCD**3*integralnorm*MB*SwB)/(2._/**/REALKIND*cw**2*sw**2)
    f(15) = (eQED**4*gQCD**3*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(16) = eQED**4*gQCD**3*integralnorm*SwF
    f(17) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(18) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(19) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(12), f(13), 8*f(13), 9*CI*f(14), f(15), 8*f(15), 3*f(16), 3*f(17), 3*f(18), 3*f(19) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(172)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_Q(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_A(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rMB, H(5), wf(:,-4))
  call wf_A(P(:,6), rMB, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_Z(gZn,wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_W_W(wf(:,1),Q(:,5),MZ,1_intkind1,wf(:,4))
  call prop_W_W(wf(:,2),Q(:,10),MZ,1_intkind1,wf(:,5))
  call prop_Q_A(wf(:,3),Q(:,80),MB,1_intkind1,wf(:,6))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,4),wf(:,7))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,6),wf(:,8))
  call prop_A_Q(wf(:,7),Q(:,37),MB,1_intkind1,wf(:,9))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,5),wf(:,10))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,6),wf(:,11))
  call prop_A_Q(wf(:,10),Q(:,42),MB,1_intkind1,wf(:,12))
  call vert_AQ_S(gH,wf(:,-5),wf(:,6),wf(:,13))
  call vert_VV_S(wf(:,4),wf(:,5),wf(:,14))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,15))
  call prop_A_Q(wf(:,15),Q(:,96),MB,1_intkind1,wf(:,16))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,-4),wf(:,17))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,5),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,21),MB,1_intkind1,wf(:,19))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,-4),wf(:,20))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,4),wf(:,21))
  call prop_Q_A(wf(:,20),Q(:,26),MB,1_intkind1,wf(:,22))
  call vert_AQ_S(gH,wf(:,16),wf(:,-4),wf(:,23))
  call vert_VQ_A(wf(:,-6),wf(:,19),wf(:,24))
  call vert_VQ_A(wf(:,-6),wf(:,22),wf(:,25))
  call vert_ZQ_A(gZn,wf(:,4),wf(:,-1),wf(:,26))
  call vert_QA_Z(gZd,wf(:,6),wf(:,-5),wf(:,27))
  call prop_Q_A(wf(:,26),Q(:,7),ZERO,0_intkind1,wf(:,28))
  call prop_W_W(wf(:,27),Q(:,112),MZ,1_intkind1,wf(:,29))
  call vert_QA_Z(gZn,wf(:,28),wf(:,-3),wf(:,30))
  call vert_AZ_Q(gZn,wf(:,-3),wf(:,4),wf(:,31))
  call prop_A_Q(wf(:,31),Q(:,13),ZERO,0_intkind1,wf(:,32))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,32),wf(:,33))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,16),wf(:,34))
  call prop_W_W(wf(:,34),Q(:,112),MZ,1_intkind1,wf(:,35))
  call vert_QA_Z(gZn,wf(:,0),wf(:,-3),wf(:,36))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,-2),wf(:,37))
  call prop_W_W(wf(:,36),Q(:,9),MZ,1_intkind1,wf(:,38))
  call prop_W_W(wf(:,37),Q(:,6),MZ,1_intkind1,wf(:,39))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,38),wf(:,40))
  call vert_ZQ_A(gZd,wf(:,39),wf(:,6),wf(:,41))
  call prop_A_Q(wf(:,40),Q(:,41),MB,1_intkind1,wf(:,42))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,39),wf(:,43))
  call vert_ZQ_A(gZd,wf(:,38),wf(:,6),wf(:,44))
  call prop_A_Q(wf(:,43),Q(:,38),MB,1_intkind1,wf(:,45))
  call vert_VV_S(wf(:,39),wf(:,38),wf(:,46))
  call vert_ZQ_A(gZd,wf(:,38),wf(:,-4),wf(:,47))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,39),wf(:,48))
  call prop_Q_A(wf(:,47),Q(:,25),MB,1_intkind1,wf(:,49))
  call vert_ZQ_A(gZd,wf(:,39),wf(:,-4),wf(:,50))
  call vert_AZ_Q(gZd,wf(:,16),wf(:,38),wf(:,51))
  call prop_Q_A(wf(:,50),Q(:,22),MB,1_intkind1,wf(:,52))
  call vert_VQ_A(wf(:,-6),wf(:,49),wf(:,53))
  call vert_VQ_A(wf(:,-6),wf(:,52),wf(:,54))
  call vert_ZQ_A(gZn,wf(:,39),wf(:,0),wf(:,55))
  call prop_Q_A(wf(:,55),Q(:,7),ZERO,0_intkind1,wf(:,56))
  call vert_QA_Z(gZn,wf(:,56),wf(:,-3),wf(:,57))
  call vert_AZ_Q(gZn,wf(:,-3),wf(:,39),wf(:,58))
  call prop_A_Q(wf(:,58),Q(:,14),ZERO,0_intkind1,wf(:,59))
  call vert_QA_Z(gZn,wf(:,0),wf(:,59),wf(:,60))
  call vert_ZQ_A(gZn,wf(:,38),wf(:,-1),wf(:,61))
  call prop_Q_A(wf(:,61),Q(:,11),ZERO,0_intkind1,wf(:,62))
  call vert_QA_Z(gZn,wf(:,62),wf(:,-2),wf(:,63))
  call vert_AZ_Q(gZn,wf(:,-2),wf(:,38),wf(:,64))
  call prop_A_Q(wf(:,64),Q(:,13),ZERO,0_intkind1,wf(:,65))
  call vert_QA_Z(gZn,wf(:,-1),wf(:,65),wf(:,66))
  call vert_ZQ_A(gZn,wf(:,5),wf(:,0),wf(:,67))
  call prop_Q_A(wf(:,67),Q(:,11),ZERO,0_intkind1,wf(:,68))
  call vert_QA_Z(gZn,wf(:,68),wf(:,-2),wf(:,69))
  call vert_AZ_Q(gZn,wf(:,-2),wf(:,5),wf(:,70))
  call prop_A_Q(wf(:,70),Q(:,14),ZERO,0_intkind1,wf(:,71))
  call vert_QA_Z(gZn,wf(:,0),wf(:,71),wf(:,72))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,73))
  call counter_VVG_G(wf(:,4),wf(:,5),wf(:,-6),wf(:,74))
  call counter_VVG_G(wf(:,39),wf(:,38),wf(:,-6),wf(:,75))
  call counter_GG_S(wf(:,73),wf(:,-6),wf(:,76))
  call counter_ZQ_A(gZd,wf(:,5),wf(:,6),wf(:,77))
  call counter_ZQ_A(gZd,wf(:,4),wf(:,6),wf(:,78))
  call counter_AZ_Q(gZd,wf(:,16),wf(:,5),wf(:,79))
  call counter_AZ_Q(gZd,wf(:,16),wf(:,4),wf(:,80))
  call counter_VQ_A(wf(:,-6),wf(:,19),wf(:,81))
  call counter_VG_G(wf(:,5),wf(:,-6),Q(:,64),wf(:,82),Q(:,74))
  call vert_QA_V(wf(:,19),wf(:,-5),wf(:,83))
  call counter_VQ_A(wf(:,-6),wf(:,22),wf(:,84))
  call vert_QA_V(wf(:,-4),wf(:,9),wf(:,85))
  call counter_VG_G(wf(:,4),wf(:,-6),Q(:,64),wf(:,86),Q(:,69))
  call vert_QA_V(wf(:,22),wf(:,-5),wf(:,87))
  call vert_QA_V(wf(:,-4),wf(:,12),wf(:,88))
  call counter_AQ_S(gH,wf(:,-5),wf(:,6),wf(:,89))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,5),wf(:,90))
  call prop_Q_A(wf(:,11),Q(:,85),MB,1_intkind1,wf(:,91))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,4),wf(:,92))
  call prop_Q_A(wf(:,8),Q(:,90),MB,1_intkind1,wf(:,93))
  call prop_A_Q(wf(:,90),Q(:,42),MB,1_intkind1,wf(:,94))
  call prop_A_Q(wf(:,92),Q(:,37),MB,1_intkind1,wf(:,95))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,96))
  call prop_A_Q(wf(:,96),Q(:,96),MB,1_intkind1,wf(:,97))
  call vert_AZ_Q(gZd,wf(:,97),wf(:,5),wf(:,98))
  call vert_AZ_Q(gZd,wf(:,97),wf(:,4),wf(:,99))
  call vert_AQ_S(gH,wf(:,97),wf(:,-4),wf(:,100))
  call counter_AQ_S(gH,wf(:,16),wf(:,-4),wf(:,101))
  call counter_ZQ_A(gZd,wf(:,5),wf(:,-4),wf(:,102))
  call prop_A_Q(wf(:,21),Q(:,101),MB,1_intkind1,wf(:,103))
  call counter_ZQ_A(gZd,wf(:,4),wf(:,-4),wf(:,104))
  call prop_A_Q(wf(:,18),Q(:,106),MB,1_intkind1,wf(:,105))
  call prop_Q_A(wf(:,102),Q(:,26),MB,1_intkind1,wf(:,106))
  call vert_VQ_A(wf(:,-6),wf(:,106),wf(:,107))
  call prop_Q_A(wf(:,104),Q(:,21),MB,1_intkind1,wf(:,108))
  call vert_VQ_A(wf(:,-6),wf(:,108),wf(:,109))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,110))
  call prop_Q_A(wf(:,110),Q(:,80),MB,1_intkind1,wf(:,111))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,111),wf(:,112))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,111),wf(:,113))
  call vert_AQ_S(gH,wf(:,-5),wf(:,111),wf(:,114))
  call counter_GG_V(wf(:,73),Q(:,48),wf(:,-6),Q(:,64),wf(:,115))
  call prop_W_W(wf(:,115),Q(:,112),MZ,1_intkind1,wf(:,116))
  call counter_QA_Z(gZd,wf(:,6),wf(:,-5),wf(:,117))
  call prop_W_W(wf(:,117),Q(:,112),MZ,1_intkind1,wf(:,118))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,97),wf(:,119))
  call prop_W_W(wf(:,119),Q(:,112),MZ,1_intkind1,wf(:,120))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,16),wf(:,121))
  call prop_W_W(wf(:,121),Q(:,112),MZ,1_intkind1,wf(:,122))
  call vert_QA_Z(gZd,wf(:,111),wf(:,-5),wf(:,123))
  call prop_W_W(wf(:,123),Q(:,112),MZ,1_intkind1,wf(:,124))
  call counter_ZQ_A(gZd,wf(:,39),wf(:,6),wf(:,125))
  call counter_ZQ_A(gZd,wf(:,38),wf(:,6),wf(:,126))
  call counter_AZ_Q(gZd,wf(:,16),wf(:,39),wf(:,127))
  call counter_AZ_Q(gZd,wf(:,16),wf(:,38),wf(:,128))
  call counter_VQ_A(wf(:,-6),wf(:,49),wf(:,129))
  call counter_VG_G(wf(:,39),wf(:,-6),Q(:,64),wf(:,130),Q(:,70))
  call vert_QA_V(wf(:,49),wf(:,-5),wf(:,131))
  call counter_VQ_A(wf(:,-6),wf(:,52),wf(:,132))
  call vert_QA_V(wf(:,-4),wf(:,42),wf(:,133))
  call counter_VG_G(wf(:,38),wf(:,-6),Q(:,64),wf(:,134),Q(:,73))
  call vert_QA_V(wf(:,52),wf(:,-5),wf(:,135))
  call vert_QA_V(wf(:,-4),wf(:,45),wf(:,136))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,39),wf(:,137))
  call prop_Q_A(wf(:,44),Q(:,89),MB,1_intkind1,wf(:,138))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,38),wf(:,139))
  call prop_Q_A(wf(:,41),Q(:,86),MB,1_intkind1,wf(:,140))
  call prop_A_Q(wf(:,137),Q(:,38),MB,1_intkind1,wf(:,141))
  call prop_A_Q(wf(:,139),Q(:,41),MB,1_intkind1,wf(:,142))
  call vert_AZ_Q(gZd,wf(:,97),wf(:,39),wf(:,143))
  call vert_AZ_Q(gZd,wf(:,97),wf(:,38),wf(:,144))
  call counter_ZQ_A(gZd,wf(:,39),wf(:,-4),wf(:,145))
  call prop_A_Q(wf(:,51),Q(:,105),MB,1_intkind1,wf(:,146))
  call counter_ZQ_A(gZd,wf(:,38),wf(:,-4),wf(:,147))
  call prop_A_Q(wf(:,48),Q(:,102),MB,1_intkind1,wf(:,148))
  call prop_Q_A(wf(:,145),Q(:,22),MB,1_intkind1,wf(:,149))
  call vert_VQ_A(wf(:,-6),wf(:,149),wf(:,150))
  call prop_Q_A(wf(:,147),Q(:,25),MB,1_intkind1,wf(:,151))
  call vert_VQ_A(wf(:,-6),wf(:,151),wf(:,152))
  call vert_ZQ_A(gZd,wf(:,39),wf(:,111),wf(:,153))
  call vert_ZQ_A(gZd,wf(:,38),wf(:,111),wf(:,154))
  call counter_Q_A(ctbb,wf(:,6),Q(:,80),wf(:,155))
  call prop_Q_A(wf(:,155),Q(:,80),MB,1_intkind1,wf(:,156))
  call vert_AQ_S(gH,wf(:,-5),wf(:,156),wf(:,157))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,156),wf(:,158))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,156),wf(:,159))
  call counter_A_Q(ctbb,wf(:,9),Q(:,37),wf(:,160))
  call counter_A_Q(ctbb,wf(:,12),Q(:,42),wf(:,161))
  call counter_A_Q(ctbb,wf(:,16),Q(:,96),wf(:,162))
  call prop_A_Q(wf(:,162),Q(:,96),MB,1_intkind1,wf(:,163))
  call vert_AQ_S(gH,wf(:,163),wf(:,-4),wf(:,164))
  call counter_Q_A(ctbb,wf(:,19),Q(:,21),wf(:,165))
  call counter_Q_A(ctbb,wf(:,22),Q(:,26),wf(:,166))
  call vert_AZ_Q(gZd,wf(:,163),wf(:,5),wf(:,167))
  call vert_AZ_Q(gZd,wf(:,163),wf(:,4),wf(:,168))
  call vert_AV_Q(wf(:,12),wf(:,-6),wf(:,169))
  call prop_A_Q(wf(:,169),Q(:,106),MB,1_intkind1,wf(:,170))
  call vert_AV_Q(wf(:,9),wf(:,-6),wf(:,171))
  call prop_A_Q(wf(:,171),Q(:,101),MB,1_intkind1,wf(:,172))
  call prop_Q_A(wf(:,24),Q(:,85),MB,1_intkind1,wf(:,173))
  call prop_Q_A(wf(:,25),Q(:,90),MB,1_intkind1,wf(:,174))
  call vert_QA_Z(gZd,wf(:,156),wf(:,-5),wf(:,175))
  call prop_W_W(wf(:,30),Q(:,15),MZ,1_intkind1,wf(:,176))
  call prop_W_W(wf(:,33),Q(:,15),MZ,1_intkind1,wf(:,177))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,163),wf(:,178))
  call vert_ZQ_A(gZd,wf(:,39),wf(:,156),wf(:,179))
  call vert_ZQ_A(gZd,wf(:,38),wf(:,156),wf(:,180))
  call counter_A_Q(ctbb,wf(:,42),Q(:,41),wf(:,181))
  call counter_A_Q(ctbb,wf(:,45),Q(:,38),wf(:,182))
  call counter_Q_A(ctbb,wf(:,49),Q(:,25),wf(:,183))
  call counter_Q_A(ctbb,wf(:,52),Q(:,22),wf(:,184))
  call vert_AZ_Q(gZd,wf(:,163),wf(:,39),wf(:,185))
  call vert_AZ_Q(gZd,wf(:,163),wf(:,38),wf(:,186))
  call vert_AV_Q(wf(:,45),wf(:,-6),wf(:,187))
  call prop_A_Q(wf(:,187),Q(:,102),MB,1_intkind1,wf(:,188))
  call vert_AV_Q(wf(:,42),wf(:,-6),wf(:,189))
  call prop_A_Q(wf(:,189),Q(:,105),MB,1_intkind1,wf(:,190))
  call prop_Q_A(wf(:,53),Q(:,89),MB,1_intkind1,wf(:,191))
  call prop_Q_A(wf(:,54),Q(:,86),MB,1_intkind1,wf(:,192))
  call prop_W_W(wf(:,57),Q(:,15),MZ,1_intkind1,wf(:,193))
  call prop_W_W(wf(:,60),Q(:,15),MZ,1_intkind1,wf(:,194))
  call prop_W_W(wf(:,63),Q(:,15),MZ,1_intkind1,wf(:,195))
  call prop_W_W(wf(:,66),Q(:,15),MZ,1_intkind1,wf(:,196))
  call prop_W_W(wf(:,69),Q(:,15),MZ,1_intkind1,wf(:,197))
  call prop_W_W(wf(:,72),Q(:,15),MZ,1_intkind1,wf(:,198))
  call vert_ZQ_A(gZd,wf(:,5),wf(:,19),wf(:,199))
  call prop_Q_A(wf(:,199),Q(:,31),MB,1_intkind1,wf(:,200))
  call vert_AZ_Q(gZd,wf(:,9),wf(:,5),wf(:,201))
  call prop_A_Q(wf(:,201),Q(:,47),MB,1_intkind1,wf(:,202))
  call vert_ZQ_A(gZd,wf(:,4),wf(:,22),wf(:,203))
  call prop_Q_A(wf(:,203),Q(:,31),MB,1_intkind1,wf(:,204))
  call vert_AZ_Q(gZd,wf(:,12),wf(:,4),wf(:,205))
  call prop_A_Q(wf(:,205),Q(:,47),MB,1_intkind1,wf(:,206))
  call vert_QS_A(gH,wf(:,-4),wf(:,14),wf(:,207))
  call prop_Q_A(wf(:,207),Q(:,31),MB,1_intkind1,wf(:,208))
  call vert_SA_Q(gH,wf(:,14),wf(:,-5),wf(:,209))
  call prop_A_Q(wf(:,209),Q(:,47),MB,1_intkind1,wf(:,210))
  call vert_ZQ_A(gZd,wf(:,176),wf(:,-4),wf(:,211))
  call prop_Q_A(wf(:,211),Q(:,31),MB,1_intkind1,wf(:,212))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,176),wf(:,213))
  call prop_A_Q(wf(:,213),Q(:,47),MB,1_intkind1,wf(:,214))
  call vert_ZQ_A(gZd,wf(:,177),wf(:,-4),wf(:,215))
  call prop_Q_A(wf(:,215),Q(:,31),MB,1_intkind1,wf(:,216))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,177),wf(:,217))
  call prop_A_Q(wf(:,217),Q(:,47),MB,1_intkind1,wf(:,218))
  call vert_ZQ_A(gZd,wf(:,39),wf(:,49),wf(:,219))
  call prop_Q_A(wf(:,219),Q(:,31),MB,1_intkind1,wf(:,220))
  call vert_AZ_Q(gZd,wf(:,42),wf(:,39),wf(:,221))
  call prop_A_Q(wf(:,221),Q(:,47),MB,1_intkind1,wf(:,222))
  call vert_ZQ_A(gZd,wf(:,38),wf(:,52),wf(:,223))
  call prop_Q_A(wf(:,223),Q(:,31),MB,1_intkind1,wf(:,224))
  call vert_AZ_Q(gZd,wf(:,45),wf(:,38),wf(:,225))
  call prop_A_Q(wf(:,225),Q(:,47),MB,1_intkind1,wf(:,226))
  call vert_QS_A(gH,wf(:,-4),wf(:,46),wf(:,227))
  call prop_Q_A(wf(:,227),Q(:,31),MB,1_intkind1,wf(:,228))
  call vert_SA_Q(gH,wf(:,46),wf(:,-5),wf(:,229))
  call prop_A_Q(wf(:,229),Q(:,47),MB,1_intkind1,wf(:,230))
  call vert_ZQ_A(gZd,wf(:,193),wf(:,-4),wf(:,231))
  call prop_Q_A(wf(:,231),Q(:,31),MB,1_intkind1,wf(:,232))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,193),wf(:,233))
  call prop_A_Q(wf(:,233),Q(:,47),MB,1_intkind1,wf(:,234))
  call vert_ZQ_A(gZd,wf(:,194),wf(:,-4),wf(:,235))
  call prop_Q_A(wf(:,235),Q(:,31),MB,1_intkind1,wf(:,236))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,194),wf(:,237))
  call prop_A_Q(wf(:,237),Q(:,47),MB,1_intkind1,wf(:,238))
  call vert_ZQ_A(gZd,wf(:,195),wf(:,-4),wf(:,239))
  call prop_Q_A(wf(:,239),Q(:,31),MB,1_intkind1,wf(:,240))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,195),wf(:,241))
  call prop_A_Q(wf(:,241),Q(:,47),MB,1_intkind1,wf(:,242))
  call vert_ZQ_A(gZd,wf(:,196),wf(:,-4),wf(:,243))
  call prop_Q_A(wf(:,243),Q(:,31),MB,1_intkind1,wf(:,244))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,196),wf(:,245))
  call prop_A_Q(wf(:,245),Q(:,47),MB,1_intkind1,wf(:,246))
  call vert_ZQ_A(gZd,wf(:,197),wf(:,-4),wf(:,247))
  call prop_Q_A(wf(:,247),Q(:,31),MB,1_intkind1,wf(:,248))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,197),wf(:,249))
  call prop_A_Q(wf(:,249),Q(:,47),MB,1_intkind1,wf(:,250))
  call vert_ZQ_A(gZd,wf(:,198),wf(:,-4),wf(:,251))
  call prop_Q_A(wf(:,251),Q(:,31),MB,1_intkind1,wf(:,252))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,198),wf(:,253))
  call prop_A_Q(wf(:,253),Q(:,47),MB,1_intkind1,wf(:,254))


  ! propagators

    den(1) = 1 / (Q(5,5) - MZ2)
    den(2) = 1 / (Q(5,10) - MZ2)
    den(3) = 1 / (Q(5,80) - MB2)
    den(5) = 1 / (Q(5,37) - MB2)
    den(9) = 1 / (Q(5,42) - MB2)
    den(13) = 1 / (Q(5,112) - MH2)
    den(16) = 1 / (Q(5,96) - MB2)
    den(18) = 1 / (Q(5,21) - MB2)
    den(22) = 1 / (Q(5,26) - MB2)
    den(29) = 1 / (Q(5,7))
    den(31) = 1 / (Q(5,112) - MZ2)
    den(34) = 1 / (Q(5,13))
    den(40) = 1 / (Q(5,9) - MZ2)
    den(41) = 1 / (Q(5,6) - MZ2)
    den(43) = 1 / (Q(5,41) - MB2)
    den(47) = 1 / (Q(5,38) - MB2)
    den(53) = 1 / (Q(5,25) - MB2)
    den(57) = 1 / (Q(5,22) - MB2)
    den(65) = 1 / (Q(5,14))
    den(70) = 1 / (Q(5,11))
    den(83) = 1 / (Q(5,48))
    den(86) = 1 / (Q(5,15) - MH2)
    den(89) = 1 / (Q(5,74))
    den(93) = 1 / (Q(5,69))
    den(98) = 1 / (Q(5,85) - MB2)
    den(101) = 1 / (Q(5,90) - MB2)
    den(105) = 1 / (Q(5,101) - MB2)
    den(108) = 1 / (Q(5,106) - MB2)
    den(116) = 1 / (Q(5,70))
    den(120) = 1 / (Q(5,73))
    den(125) = 1 / (Q(5,89) - MB2)
    den(128) = 1 / (Q(5,86) - MB2)
    den(132) = 1 / (Q(5,105) - MB2)
    den(135) = 1 / (Q(5,102) - MB2)
    den(168) = 1 / (Q(5,15) - MZ2)
    den(215) = 1 / (Q(5,53))
    den(218) = 1 / (Q(5,31) - MB2)
    den(222) = 1 / (Q(5,47) - MB2)
    den(224) = 1 / (Q(5,58))
    den(237) = 1 / (Q(5,57))
    den(244) = 1 / (Q(5,54))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(8) = den(1)*den(3)
    den(10) = den(2)*den(9)
    den(11) = den(8)*den(10)
    den(12) = den(1)*den(2)
    den(14) = den(3)*den(13)
    den(15) = den(12)*den(14)
    den(17) = den(2)*den(16)
    den(19) = den(1)*den(18)
    den(20) = den(17)*den(19)
    den(21) = den(1)*den(16)
    den(23) = den(2)*den(22)
    den(24) = den(21)*den(23)
    den(25) = den(13)*den(16)
    den(26) = den(12)*den(25)
    den(27) = den(10)*den(19)
    den(28) = den(6)*den(23)
    den(30) = den(1)*den(29)
    den(32) = den(3)*den(31)
    den(33) = den(30)*den(32)
    den(35) = den(1)*den(34)
    den(36) = den(32)*den(35)
    den(37) = den(16)*den(31)
    den(38) = den(30)*den(37)
    den(39) = den(35)*den(37)
    den(42) = den(3)*den(41)
    den(44) = den(40)*den(43)
    den(45) = den(42)*den(44)
    den(46) = den(3)*den(40)
    den(48) = den(41)*den(47)
    den(49) = den(46)*den(48)
    den(50) = den(40)*den(41)
    den(51) = den(14)*den(50)
    den(52) = den(16)*den(41)
    den(54) = den(40)*den(53)
    den(55) = den(52)*den(54)
    den(56) = den(16)*den(40)
    den(58) = den(41)*den(57)
    den(59) = den(56)*den(58)
    den(60) = den(25)*den(50)
    den(61) = den(48)*den(54)
    den(62) = den(44)*den(58)
    den(63) = den(29)*den(41)
    den(64) = den(32)*den(63)
    den(66) = den(41)*den(65)
    den(67) = den(32)*den(66)
    den(68) = den(37)*den(63)
    den(69) = den(37)*den(66)
    den(71) = den(40)*den(70)
    den(72) = den(32)*den(71)
    den(73) = den(34)*den(40)
    den(74) = den(32)*den(73)
    den(75) = den(37)*den(71)
    den(76) = den(37)*den(73)
    den(77) = den(2)*den(70)
    den(78) = den(32)*den(77)
    den(79) = den(2)*den(65)
    den(80) = den(32)*den(79)
    den(81) = den(37)*den(77)
    den(82) = den(37)*den(79)
    den(84) = den(12)*den(83)
    den(85) = den(50)*den(83)
    den(87) = den(12)*den(86)
    den(88) = den(83)*den(87)
    den(90) = den(2)*den(89)
    den(91) = den(19)*den(90)
    den(92) = den(6)*den(90)
    den(94) = den(1)*den(93)
    den(95) = den(23)*den(94)
    den(96) = den(10)*den(94)
    den(97) = den(3)*den(87)
    den(99) = den(8)*den(98)
    den(100) = den(2)*den(99)
    den(102) = den(4)*den(101)
    den(103) = den(1)*den(102)
    den(104) = den(16)*den(87)
    den(106) = den(21)*den(105)
    den(107) = den(2)*den(106)
    den(109) = den(17)*den(108)
    den(110) = den(1)*den(109)
    den(111) = den(31)*den(83)
    den(112) = den(30)*den(111)
    den(113) = den(35)*den(111)
    den(114) = den(50)*den(86)
    den(115) = den(83)*den(114)
    den(117) = den(41)*den(116)
    den(118) = den(54)*den(117)
    den(119) = den(44)*den(117)
    den(121) = den(40)*den(120)
    den(122) = den(58)*den(121)
    den(123) = den(48)*den(121)
    den(124) = den(3)*den(114)
    den(126) = den(46)*den(125)
    den(127) = den(41)*den(126)
    den(129) = den(42)*den(128)
    den(130) = den(40)*den(129)
    den(131) = den(16)*den(114)
    den(133) = den(56)*den(132)
    den(134) = den(41)*den(133)
    den(136) = den(52)*den(135)
    den(137) = den(40)*den(136)
    den(138) = den(63)*den(111)
    den(139) = den(66)*den(111)
    den(140) = den(71)*den(111)
    den(141) = den(73)*den(111)
    den(142) = den(77)*den(111)
    den(143) = den(79)*den(111)
    den(144) = den(3)**2
    den(145) = den(87)*den(144)
    den(146) = den(2)*den(144)
    den(147) = den(6)*den(146)
    den(148) = den(1)*den(144)
    den(149) = den(10)*den(148)
    den(150) = den(6)*den(102)
    den(151) = den(10)*den(99)
    den(152) = den(16)**2
    den(153) = den(87)*den(152)
    den(154) = den(19)*den(109)
    den(155) = den(23)*den(106)
    den(156) = den(2)*den(152)
    den(157) = den(19)*den(156)
    den(158) = den(1)*den(152)
    den(159) = den(23)*den(158)
    den(160) = den(10)*den(108)
    den(161) = den(19)*den(160)
    den(162) = den(6)*den(105)
    den(163) = den(23)*den(162)
    den(164) = den(19)*den(98)
    den(165) = den(10)*den(164)
    den(166) = den(23)*den(101)
    den(167) = den(6)*den(166)
    den(169) = den(30)*den(168)
    den(170) = den(144)*den(169)
    den(171) = den(35)*den(168)
    den(172) = den(144)*den(171)
    den(173) = den(152)*den(169)
    den(174) = den(152)*den(171)
    den(175) = den(114)*den(144)
    den(176) = den(41)*den(144)
    den(177) = den(44)*den(176)
    den(178) = den(40)*den(144)
    den(179) = den(48)*den(178)
    den(180) = den(44)*den(129)
    den(181) = den(48)*den(126)
    den(182) = den(114)*den(152)
    den(183) = den(54)*den(136)
    den(184) = den(58)*den(133)
    den(185) = den(41)*den(152)
    den(186) = den(54)*den(185)
    den(187) = den(40)*den(152)
    den(188) = den(58)*den(187)
    den(189) = den(48)*den(135)
    den(190) = den(54)*den(189)
    den(191) = den(44)*den(132)
    den(192) = den(58)*den(191)
    den(193) = den(54)*den(125)
    den(194) = den(48)*den(193)
    den(195) = den(58)*den(128)
    den(196) = den(44)*den(195)
    den(197) = den(63)*den(168)
    den(198) = den(144)*den(197)
    den(199) = den(66)*den(168)
    den(200) = den(144)*den(199)
    den(201) = den(152)*den(197)
    den(202) = den(152)*den(199)
    den(203) = den(71)*den(168)
    den(204) = den(144)*den(203)
    den(205) = den(73)*den(168)
    den(206) = den(144)*den(205)
    den(207) = den(152)*den(203)
    den(208) = den(152)*den(205)
    den(209) = den(77)*den(168)
    den(210) = den(144)*den(209)
    den(211) = den(79)*den(168)
    den(212) = den(144)*den(211)
    den(213) = den(152)*den(209)
    den(214) = den(152)*den(211)
    den(216) = den(19)*den(215)
    den(217) = den(2)*den(19)
    den(219) = den(217)*den(218)
    den(220) = den(6)*den(215)
    den(221) = den(2)*den(6)
    den(223) = den(221)*den(222)
    den(225) = den(23)*den(224)
    den(226) = den(1)*den(23)
    den(227) = den(218)*den(226)
    den(228) = den(10)*den(224)
    den(229) = den(1)*den(10)
    den(230) = den(222)*den(229)
    den(231) = den(87)*den(218)
    den(232) = den(87)*den(222)
    den(233) = den(169)*den(218)
    den(234) = den(169)*den(222)
    den(235) = den(171)*den(218)
    den(236) = den(171)*den(222)
    den(238) = den(54)*den(237)
    den(239) = den(41)*den(54)
    den(240) = den(218)*den(239)
    den(241) = den(44)*den(237)
    den(242) = den(41)*den(44)
    den(243) = den(222)*den(242)
    den(245) = den(58)*den(244)
    den(246) = den(40)*den(58)
    den(247) = den(218)*den(246)
    den(248) = den(48)*den(244)
    den(249) = den(40)*den(48)
    den(250) = den(222)*den(249)
    den(251) = den(114)*den(218)
    den(252) = den(114)*den(222)
    den(253) = den(197)*den(218)
    den(254) = den(197)*den(222)
    den(255) = den(199)*den(218)
    den(256) = den(199)*den(222)
    den(257) = den(203)*den(218)
    den(258) = den(203)*den(222)
    den(259) = den(205)*den(218)
    den(260) = den(205)*den(222)
    den(261) = den(209)*den(218)
    den(262) = den(209)*den(222)
    den(263) = den(211)*den(218)
    den(264) = den(211)*den(222)
    den(265) = den(1)*den(2)*den(83)
    den(266) = den(2)*den(3)*den(6)
    den(267) = den(1)*den(3)*den(10)
    den(268) = den(1)*den(2)*den(3)
    den(269) = den(2)*den(16)*den(19)
    den(270) = den(1)*den(16)*den(23)
    den(271) = den(1)*den(2)*den(16)
    den(272) = den(2)*den(216)
    den(273) = den(2)*den(164)
    den(274) = den(2)*den(220)
    den(275) = den(2)*den(162)
    den(276) = den(1)*den(225)
    den(277) = den(1)*den(166)
    den(278) = den(1)*den(228)
    den(279) = den(1)*den(160)
    den(280) = den(83)*den(169)
    den(281) = den(83)*den(171)
    den(282) = den(3)*den(169)
    den(283) = den(3)*den(171)
    den(284) = den(16)*den(169)
    den(285) = den(16)*den(171)
    den(286) = den(40)*den(41)*den(83)
    den(287) = den(3)*den(41)*den(44)
    den(288) = den(3)*den(40)*den(48)
    den(289) = den(3)*den(40)*den(41)
    den(290) = den(16)*den(41)*den(54)
    den(291) = den(16)*den(40)*den(58)
    den(292) = den(16)*den(40)*den(41)
    den(293) = den(41)*den(238)
    den(294) = den(41)*den(193)
    den(295) = den(41)*den(241)
    den(296) = den(41)*den(191)
    den(297) = den(40)*den(245)
    den(298) = den(40)*den(195)
    den(299) = den(40)*den(248)
    den(300) = den(40)*den(189)
    den(301) = den(83)*den(197)
    den(302) = den(83)*den(199)
    den(303) = den(3)*den(197)
    den(304) = den(3)*den(199)
    den(305) = den(16)*den(197)
    den(306) = den(16)*den(199)
    den(307) = den(83)*den(203)
    den(308) = den(83)*den(205)
    den(309) = den(3)*den(203)
    den(310) = den(3)*den(205)
    den(311) = den(16)*den(203)
    den(312) = den(16)*den(205)
    den(313) = den(83)*den(209)
    den(314) = den(83)*den(211)
    den(315) = den(3)*den(209)
    den(316) = den(3)*den(211)
    den(317) = den(16)*den(209)
    den(318) = den(16)*den(211)
    den(319) = den(3)*den(223)
    den(320) = den(3)*den(230)
    den(321) = den(3)*den(232)
    den(322) = den(16)*den(219)
    den(323) = den(16)*den(227)
    den(324) = den(16)*den(231)
    den(325) = den(3)*den(234)
    den(326) = den(3)*den(236)
    den(327) = den(16)*den(233)
    den(328) = den(16)*den(235)
    den(329) = den(3)*den(243)
    den(330) = den(3)*den(250)
    den(331) = den(3)*den(252)
    den(332) = den(16)*den(240)
    den(333) = den(16)*den(247)
    den(334) = den(16)*den(251)
    den(335) = den(3)*den(254)
    den(336) = den(3)*den(256)
    den(337) = den(16)*den(253)
    den(338) = den(16)*den(255)
    den(339) = den(3)*den(258)
    den(340) = den(3)*den(260)
    den(341) = den(16)*den(257)
    den(342) = den(16)*den(259)
    den(343) = den(3)*den(262)
    den(344) = den(3)*den(264)
    den(345) = den(16)*den(261)
    den(346) = den(16)*den(263)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,8),wf(:,9)) * den(7)
  A(2) = cont_QA(wf(:,11),wf(:,12)) * den(11)
  A(3) = cont_SS(wf(:,13),wf(:,14)) * den(15)
  A(4) = cont_QA(wf(:,18),wf(:,19)) * den(20)
  A(5) = cont_QA(wf(:,21),wf(:,22)) * den(24)
  A(6) = cont_SS(wf(:,14),wf(:,23)) * den(26)
  A(7) = cont_QA(wf(:,12),wf(:,24)) * den(27)
  A(8) = cont_QA(wf(:,9),wf(:,25)) * den(28)
  A(9) = cont_VV(wf(:,29),wf(:,30)) * den(33)
  A(10) = cont_VV(wf(:,29),wf(:,33)) * den(36)
  A(11) = cont_VV(wf(:,30),wf(:,35)) * den(38)
  A(12) = cont_VV(wf(:,33),wf(:,35)) * den(39)
  A(13) = cont_QA(wf(:,41),wf(:,42)) * den(45)
  A(14) = cont_QA(wf(:,44),wf(:,45)) * den(49)
  A(15) = cont_SS(wf(:,13),wf(:,46)) * den(51)
  A(16) = cont_QA(wf(:,48),wf(:,49)) * den(55)
  A(17) = cont_QA(wf(:,51),wf(:,52)) * den(59)
  A(18) = cont_SS(wf(:,23),wf(:,46)) * den(60)
  A(19) = cont_QA(wf(:,45),wf(:,53)) * den(61)
  A(20) = cont_QA(wf(:,42),wf(:,54)) * den(62)
  A(21) = cont_VV(wf(:,29),wf(:,57)) * den(64)
  A(22) = cont_VV(wf(:,29),wf(:,60)) * den(67)
  A(23) = cont_VV(wf(:,35),wf(:,57)) * den(68)
  A(24) = cont_VV(wf(:,35),wf(:,60)) * den(69)
  A(25) = cont_VV(wf(:,29),wf(:,63)) * den(72)
  A(26) = cont_VV(wf(:,29),wf(:,66)) * den(74)
  A(27) = cont_VV(wf(:,35),wf(:,63)) * den(75)
  A(28) = cont_VV(wf(:,35),wf(:,66)) * den(76)
  A(29) = cont_VV(wf(:,29),wf(:,69)) * den(78)
  A(30) = cont_VV(wf(:,29),wf(:,72)) * den(80)
  A(31) = cont_VV(wf(:,35),wf(:,69)) * den(81)
  A(32) = cont_VV(wf(:,35),wf(:,72)) * den(82)

  A(33) = cont_VV(wf(:,73),wf(:,74)) * den(84)
  A(34) = cont_VV(wf(:,73),wf(:,75)) * den(85)
  A(35) = cont_SS(wf(:,14),wf(:,76)) * den(88)
  A(36) = cont_QA(wf(:,9),wf(:,77)) * den(7)
  A(37) = cont_QA(wf(:,12),wf(:,78)) * den(11)
  A(38) = cont_QA(wf(:,19),wf(:,79)) * den(20)
  A(39) = cont_QA(wf(:,22),wf(:,80)) * den(24)
  A(40) = cont_QA(wf(:,12),wf(:,81)) * den(27)
  A(41) = cont_VV(wf(:,82),wf(:,83)) * den(91)
  A(42) = cont_QA(wf(:,9),wf(:,84)) * den(28)
  A(43) = cont_VV(wf(:,82),wf(:,85)) * den(92)
  A(44) = cont_VV(wf(:,86),wf(:,87)) * den(95)
  A(45) = cont_VV(wf(:,86),wf(:,88)) * den(96)
  A(46) = cont_SS(wf(:,14),wf(:,89)) * den(97)
  A(47) = cont_QA(wf(:,90),wf(:,91)) * den(100)
  A(48) = cont_QA(wf(:,92),wf(:,93)) * den(103)
  A(49) = cont_QA(wf(:,24),wf(:,94)) * den(27)
  A(50) = cont_QA(wf(:,25),wf(:,95)) * den(28)
  A(51) = cont_QA(wf(:,19),wf(:,98)) * den(20)
  A(52) = cont_QA(wf(:,22),wf(:,99)) * den(24)
  A(53) = cont_SS(wf(:,14),wf(:,100)) * den(26)
  A(54) = cont_SS(wf(:,14),wf(:,101)) * den(104)
  A(55) = cont_QA(wf(:,102),wf(:,103)) * den(107)
  A(56) = cont_QA(wf(:,104),wf(:,105)) * den(110)
  A(57) = cont_QA(wf(:,9),wf(:,107)) * den(28)
  A(58) = cont_QA(wf(:,12),wf(:,109)) * den(27)
  A(59) = cont_QA(wf(:,9),wf(:,112)) * den(7)
  A(60) = cont_QA(wf(:,12),wf(:,113)) * den(11)
  A(61) = cont_SS(wf(:,14),wf(:,114)) * den(15)
  A(62) = cont_VV(wf(:,30),wf(:,116)) * den(112)
  A(63) = cont_VV(wf(:,33),wf(:,116)) * den(113)
  A(64) = cont_VV(wf(:,30),wf(:,118)) * den(33)
  A(65) = cont_VV(wf(:,33),wf(:,118)) * den(36)
  A(66) = cont_VV(wf(:,30),wf(:,120)) * den(38)
  A(67) = cont_VV(wf(:,33),wf(:,120)) * den(39)
  A(68) = cont_VV(wf(:,30),wf(:,122)) * den(38)
  A(69) = cont_VV(wf(:,33),wf(:,122)) * den(39)
  A(70) = cont_VV(wf(:,30),wf(:,124)) * den(33)
  A(71) = cont_VV(wf(:,33),wf(:,124)) * den(36)
  A(72) = cont_SS(wf(:,46),wf(:,76)) * den(115)
  A(73) = cont_QA(wf(:,42),wf(:,125)) * den(45)
  A(74) = cont_QA(wf(:,45),wf(:,126)) * den(49)
  A(75) = cont_QA(wf(:,49),wf(:,127)) * den(55)
  A(76) = cont_QA(wf(:,52),wf(:,128)) * den(59)
  A(77) = cont_QA(wf(:,45),wf(:,129)) * den(61)
  A(78) = cont_VV(wf(:,130),wf(:,131)) * den(118)
  A(79) = cont_QA(wf(:,42),wf(:,132)) * den(62)
  A(80) = cont_VV(wf(:,130),wf(:,133)) * den(119)
  A(81) = cont_VV(wf(:,134),wf(:,135)) * den(122)
  A(82) = cont_VV(wf(:,134),wf(:,136)) * den(123)
  A(83) = cont_SS(wf(:,46),wf(:,89)) * den(124)
  A(84) = cont_QA(wf(:,137),wf(:,138)) * den(127)
  A(85) = cont_QA(wf(:,139),wf(:,140)) * den(130)
  A(86) = cont_QA(wf(:,53),wf(:,141)) * den(61)
  A(87) = cont_QA(wf(:,54),wf(:,142)) * den(62)
  A(88) = cont_QA(wf(:,49),wf(:,143)) * den(55)
  A(89) = cont_QA(wf(:,52),wf(:,144)) * den(59)
  A(90) = cont_SS(wf(:,46),wf(:,100)) * den(60)
  A(91) = cont_SS(wf(:,46),wf(:,101)) * den(131)
  A(92) = cont_QA(wf(:,145),wf(:,146)) * den(134)
  A(93) = cont_QA(wf(:,147),wf(:,148)) * den(137)
  A(94) = cont_QA(wf(:,42),wf(:,150)) * den(62)
  A(95) = cont_QA(wf(:,45),wf(:,152)) * den(61)
  A(96) = cont_QA(wf(:,42),wf(:,153)) * den(45)
  A(97) = cont_QA(wf(:,45),wf(:,154)) * den(49)
  A(98) = cont_SS(wf(:,46),wf(:,114)) * den(51)
  A(99) = cont_VV(wf(:,57),wf(:,116)) * den(138)
  A(100) = cont_VV(wf(:,60),wf(:,116)) * den(139)
  A(101) = cont_VV(wf(:,57),wf(:,118)) * den(64)
  A(102) = cont_VV(wf(:,60),wf(:,118)) * den(67)
  A(103) = cont_VV(wf(:,57),wf(:,120)) * den(68)
  A(104) = cont_VV(wf(:,60),wf(:,120)) * den(69)
  A(105) = cont_VV(wf(:,57),wf(:,122)) * den(68)
  A(106) = cont_VV(wf(:,60),wf(:,122)) * den(69)
  A(107) = cont_VV(wf(:,57),wf(:,124)) * den(64)
  A(108) = cont_VV(wf(:,60),wf(:,124)) * den(67)
  A(109) = cont_VV(wf(:,63),wf(:,116)) * den(140)
  A(110) = cont_VV(wf(:,66),wf(:,116)) * den(141)
  A(111) = cont_VV(wf(:,63),wf(:,118)) * den(72)
  A(112) = cont_VV(wf(:,66),wf(:,118)) * den(74)
  A(113) = cont_VV(wf(:,63),wf(:,120)) * den(75)
  A(114) = cont_VV(wf(:,66),wf(:,120)) * den(76)
  A(115) = cont_VV(wf(:,63),wf(:,122)) * den(75)
  A(116) = cont_VV(wf(:,66),wf(:,122)) * den(76)
  A(117) = cont_VV(wf(:,63),wf(:,124)) * den(72)
  A(118) = cont_VV(wf(:,66),wf(:,124)) * den(74)
  A(119) = cont_VV(wf(:,69),wf(:,116)) * den(142)
  A(120) = cont_VV(wf(:,72),wf(:,116)) * den(143)
  A(121) = cont_VV(wf(:,69),wf(:,118)) * den(78)
  A(122) = cont_VV(wf(:,72),wf(:,118)) * den(80)
  A(123) = cont_VV(wf(:,69),wf(:,120)) * den(81)
  A(124) = cont_VV(wf(:,72),wf(:,120)) * den(82)
  A(125) = cont_VV(wf(:,69),wf(:,122)) * den(81)
  A(126) = cont_VV(wf(:,72),wf(:,122)) * den(82)
  A(127) = cont_VV(wf(:,69),wf(:,124)) * den(78)
  A(128) = cont_VV(wf(:,72),wf(:,124)) * den(80)
  A(129) = cont_SS(wf(:,14),wf(:,157)) * den(145)
  A(130) = cont_QA(wf(:,9),wf(:,158)) * den(147)
  A(131) = cont_QA(wf(:,12),wf(:,159)) * den(149)
  A(132) = cont_QA(wf(:,93),wf(:,160)) * den(150)
  A(133) = cont_QA(wf(:,91),wf(:,161)) * den(151)
  A(134) = cont_SS(wf(:,14),wf(:,164)) * den(153)
  A(135) = cont_QA(wf(:,105),wf(:,165)) * den(154)
  A(136) = cont_QA(wf(:,103),wf(:,166)) * den(155)
  A(137) = cont_QA(wf(:,19),wf(:,167)) * den(157)
  A(138) = cont_QA(wf(:,22),wf(:,168)) * den(159)
  A(139) = cont_QA(wf(:,165),wf(:,170)) * den(161)
  A(140) = cont_QA(wf(:,166),wf(:,172)) * den(163)
  A(141) = cont_QA(wf(:,161),wf(:,173)) * den(165)
  A(142) = cont_QA(wf(:,160),wf(:,174)) * den(167)
  A(143) = cont_VV(wf(:,175),wf(:,176)) * den(170)
  A(144) = cont_VV(wf(:,175),wf(:,177)) * den(172)
  A(145) = cont_VV(wf(:,176),wf(:,178)) * den(173)
  A(146) = cont_VV(wf(:,177),wf(:,178)) * den(174)
  A(147) = cont_SS(wf(:,46),wf(:,157)) * den(175)
  A(148) = cont_QA(wf(:,42),wf(:,179)) * den(177)
  A(149) = cont_QA(wf(:,45),wf(:,180)) * den(179)
  A(150) = cont_QA(wf(:,140),wf(:,181)) * den(180)
  A(151) = cont_QA(wf(:,138),wf(:,182)) * den(181)
  A(152) = cont_SS(wf(:,46),wf(:,164)) * den(182)
  A(153) = cont_QA(wf(:,148),wf(:,183)) * den(183)
  A(154) = cont_QA(wf(:,146),wf(:,184)) * den(184)
  A(155) = cont_QA(wf(:,49),wf(:,185)) * den(186)
  A(156) = cont_QA(wf(:,52),wf(:,186)) * den(188)
  A(157) = cont_QA(wf(:,183),wf(:,188)) * den(190)
  A(158) = cont_QA(wf(:,184),wf(:,190)) * den(192)
  A(159) = cont_QA(wf(:,182),wf(:,191)) * den(194)
  A(160) = cont_QA(wf(:,181),wf(:,192)) * den(196)
  A(161) = cont_VV(wf(:,175),wf(:,193)) * den(198)
  A(162) = cont_VV(wf(:,175),wf(:,194)) * den(200)
  A(163) = cont_VV(wf(:,178),wf(:,193)) * den(201)
  A(164) = cont_VV(wf(:,178),wf(:,194)) * den(202)
  A(165) = cont_VV(wf(:,175),wf(:,195)) * den(204)
  A(166) = cont_VV(wf(:,175),wf(:,196)) * den(206)
  A(167) = cont_VV(wf(:,178),wf(:,195)) * den(207)
  A(168) = cont_VV(wf(:,178),wf(:,196)) * den(208)
  A(169) = cont_VV(wf(:,175),wf(:,197)) * den(210)
  A(170) = cont_VV(wf(:,175),wf(:,198)) * den(212)
  A(171) = cont_VV(wf(:,178),wf(:,197)) * den(213)
  A(172) = cont_VV(wf(:,178),wf(:,198)) * den(214)


  ! colour vectors

  M1(1) = (-A(1)-A(2)-A(4)-A(5)-A(7)-A(8)-A(9)-A(10)-A(11)-A(12)+A(13)+A(14)+A(16)+A(17)+A(19)+A(20)+A(21)+A(22)+A(23)+A(24)+A(25) &
       +A(26)+A(27)+A(28)-A(29)-A(30)-A(31)-A(32))*f(1)+(A(3)+A(6)-A(15)-A(18))*f(7)

  M2(1) = (A(130)+A(131)+A(132)+A(133)+A(135)+A(136)+A(137)+A(138)+A(139)+A(140)+A(141)+A(142)+A(143)+A(144)+A(145)+A(146)-A(148) &
       -A(149)-A(150)-A(151)-A(153)-A(154)-A(155)-A(156)-A(157)-A(158)-A(159)-A(160)-A(161)-A(162)-A(163)-A(164)-A(165)-A(166) &
       -A(167)-A(168)+A(169)+A(170)+A(171)+A(172))*f(2)+(-A(40)-A(42)-A(51)-A(52)-A(59)-A(60)-A(66)-A(67)-A(70)-A(71)+A(77)+A(79) &
       +A(88)+A(89)+A(96)+A(97)+A(103)+A(104)+A(107)+A(108)+A(113)+A(114)+A(117)+A(118)-A(123)-A(124)-A(127)-A(128))*f(3)+(-A(36) &
       -A(37)-A(38)-A(39)-A(47)-A(48)-A(49)-A(50)-A(55)-A(56)-A(57)-A(58)-A(64)-A(65)-A(68)-A(69)+A(73)+A(74)+A(75)+A(76)+A(84) &
       +A(85)+A(86)+A(87)+A(92)+A(93)+A(94)+A(95)+A(101)+A(102)+A(105)+A(106)+A(111)+A(112)+A(115)+A(116)-A(121)-A(122)-A(125) &
       -A(126))*f(4)+(A(41)+A(43)+A(44)+A(45)+A(62)+A(63)-A(78)-A(80)-A(81)-A(82)-A(99)-A(100)-A(109)-A(110)+A(119)+A(120))*f(5)+( &
       -A(33)+A(34))*f(6)+(-A(129)-A(134)+A(147)+A(152))*f(8)+(A(53)+A(61)-A(90)-A(98))*f(9)+(A(46)+A(54)-A(83)-A(91))*f(10) &
       +(A(35)-A(72))*f(11)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_nenenexnexbbxg_1_/**/REALKIND
