
module ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_eexmmxuuxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_eexmmxuuxg_1_/**/REALKIND

module ol_loop_ppllllj_eexmmxuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(35), c(20)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:299)
  ! denominators
  complex(REALKIND), save :: den(509)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**4*gQCD)/9._/**/REALKIND
    f( 2) = (2*CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 3) = CI*eQED**4*gQCD
    f( 4) = (4*CI*countertermnorm*eQED**4*gQCD**3)/9._/**/REALKIND
    f( 5) = (2*CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**4*gQCD**3
    f( 7) = CI*countertermnorm*ctAAGG*eQED**4*gQCD**3
    f( 8) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 9) = (4*CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/9._/**/REALKIND
    f(10) = (2*CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctGqq*eQED**4*gQCD**3
    f(12) = (4*CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/9._/**/REALKIND
    f(13) = (2*CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVqq*eQED**4*gQCD**3
    f(15) = (2*countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(16) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(17) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(18) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(19) = (4*CI*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(20) = (2*CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(21) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(22) = (4*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(23) = (2*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(24) = eQED**4*gQCD**3*integralnorm*SwB
    f(25) = (eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(26) = (2*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(27) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(28) = (4*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(29) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(30) = (8*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(31) = eQED**4*gQCD**3*integralnorm*SwF
    f(32) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(33) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(34) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(35) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(19), 9*CI*f(20), 9*CI*f(21), f(22), 8*f(22), f(23), 8*f(23), f(24), 8*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28) &
    , 3*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(293)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_A(P(:,6), rZERO, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_Q_A(wf(:,3),Q(:,80),ZERO,0_intkind1,wf(:,4))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,5))
  call vert_VQ_A(wf(:,2),wf(:,4),wf(:,6))
  call prop_A_Q(wf(:,5),Q(:,35),ZERO,0_intkind1,wf(:,7))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,8))
  call prop_W_W(wf(:,8),Q(:,12),MZ,1_intkind1,wf(:,9))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,4),wf(:,10))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,11))
  call prop_W_W(wf(:,11),Q(:,3),MZ,1_intkind1,wf(:,12))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,12),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,35),ZERO,0_intkind1,wf(:,14))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,15))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,16))
  call prop_A_Q(wf(:,15),Q(:,44),ZERO,0_intkind1,wf(:,17))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,9),wf(:,18))
  call prop_A_Q(wf(:,18),Q(:,44),ZERO,0_intkind1,wf(:,19))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,4),wf(:,20))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,21))
  call prop_A_Q(wf(:,21),Q(:,96),ZERO,0_intkind1,wf(:,22))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,23))
  call vert_AV_Q(wf(:,22),wf(:,2),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,19),ZERO,0_intkind1,wf(:,25))
  call vert_AZ_Q(gZu,wf(:,22),wf(:,9),wf(:,26))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,-4),wf(:,27))
  call prop_Q_A(wf(:,27),Q(:,19),ZERO,0_intkind1,wf(:,28))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,29))
  call vert_AV_Q(wf(:,22),wf(:,1),wf(:,30))
  call prop_Q_A(wf(:,29),Q(:,28),ZERO,0_intkind1,wf(:,31))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,-4),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,28),ZERO,0_intkind1,wf(:,33))
  call vert_AZ_Q(gZu,wf(:,22),wf(:,12),wf(:,34))
  call vert_VQ_A(wf(:,-6),wf(:,25),wf(:,35))
  call vert_VQ_A(wf(:,-6),wf(:,28),wf(:,36))
  call vert_VQ_A(wf(:,-6),wf(:,31),wf(:,37))
  call vert_VQ_A(wf(:,-6),wf(:,33),wf(:,38))
  call vert_VQ_A(wf(:,1),wf(:,-2),wf(:,39))
  call vert_QA_V(wf(:,4),wf(:,-5),wf(:,40))
  call prop_Q_A(wf(:,39),Q(:,7),ZERO,0_intkind1,wf(:,41))
  call vert_QA_V(wf(:,41),wf(:,-3),wf(:,42))
  call vert_QA_Z(gZu,wf(:,4),wf(:,-5),wf(:,43))
  call prop_W_W(wf(:,43),Q(:,112),MZ,1_intkind1,wf(:,44))
  call vert_QA_Z(gZl,wf(:,41),wf(:,-3),wf(:,45))
  call vert_ZQ_A(gZl,wf(:,12),wf(:,-2),wf(:,46))
  call prop_Q_A(wf(:,46),Q(:,7),ZERO,0_intkind1,wf(:,47))
  call vert_QA_V(wf(:,47),wf(:,-3),wf(:,48))
  call vert_QA_Z(gZl,wf(:,47),wf(:,-3),wf(:,49))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,50))
  call prop_A_Q(wf(:,50),Q(:,11),ZERO,0_intkind1,wf(:,51))
  call vert_QA_V(wf(:,-2),wf(:,51),wf(:,52))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,51),wf(:,53))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,12),wf(:,54))
  call prop_A_Q(wf(:,54),Q(:,11),ZERO,0_intkind1,wf(:,55))
  call vert_QA_V(wf(:,-2),wf(:,55),wf(:,56))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,55),wf(:,57))
  call vert_QA_V(wf(:,-4),wf(:,22),wf(:,58))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,22),wf(:,59))
  call prop_W_W(wf(:,59),Q(:,112),MZ,1_intkind1,wf(:,60))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,61))
  call prop_Q_A(wf(:,61),Q(:,13),ZERO,0_intkind1,wf(:,62))
  call vert_QA_V(wf(:,62),wf(:,-1),wf(:,63))
  call vert_QA_Z(gZl,wf(:,62),wf(:,-1),wf(:,64))
  call vert_ZQ_A(gZl,wf(:,9),wf(:,0),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,13),ZERO,0_intkind1,wf(:,66))
  call vert_QA_V(wf(:,66),wf(:,-1),wf(:,67))
  call vert_QA_Z(gZl,wf(:,66),wf(:,-1),wf(:,68))
  call vert_AV_Q(wf(:,-1),wf(:,2),wf(:,69))
  call prop_A_Q(wf(:,69),Q(:,14),ZERO,0_intkind1,wf(:,70))
  call vert_QA_V(wf(:,0),wf(:,70),wf(:,71))
  call vert_AZ_Q(gZl,wf(:,-1),wf(:,9),wf(:,72))
  call prop_A_Q(wf(:,72),Q(:,14),ZERO,0_intkind1,wf(:,73))
  call vert_QA_V(wf(:,0),wf(:,73),wf(:,74))
  call vert_QA_Z(gZl,wf(:,0),wf(:,70),wf(:,75))
  call vert_QA_Z(gZl,wf(:,0),wf(:,73),wf(:,76))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,77))
  call counter_VVG_G(wf(:,1),wf(:,2),wf(:,-6),wf(:,78))
  call counter_VVG_G(wf(:,1),wf(:,9),wf(:,-6),wf(:,79))
  call counter_VVG_G(wf(:,12),wf(:,2),wf(:,-6),wf(:,80))
  call counter_VVG_G(wf(:,12),wf(:,9),wf(:,-6),wf(:,81))
  call vert_VV_S(wf(:,12),wf(:,9),wf(:,82))
  call counter_GG_S(wf(:,77),wf(:,-6),wf(:,83))
  call counter_VQ_A(wf(:,2),wf(:,4),wf(:,84))
  call counter_ZQ_A(gZu,wf(:,9),wf(:,4),wf(:,85))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,86))
  call counter_ZQ_A(gZu,wf(:,12),wf(:,4),wf(:,87))
  call counter_AV_Q(wf(:,22),wf(:,2),wf(:,88))
  call counter_AZ_Q(gZu,wf(:,22),wf(:,9),wf(:,89))
  call counter_AV_Q(wf(:,22),wf(:,1),wf(:,90))
  call counter_AZ_Q(gZu,wf(:,22),wf(:,12),wf(:,91))
  call counter_VQ_A(wf(:,-6),wf(:,25),wf(:,92))
  call counter_VQ_A(wf(:,-6),wf(:,28),wf(:,93))
  call counter_VG_G(wf(:,9),wf(:,-6),Q(:,64),wf(:,94),Q(:,76))
  call vert_QA_V(wf(:,25),wf(:,-5),wf(:,95))
  call vert_QA_V(wf(:,28),wf(:,-5),wf(:,96))
  call counter_VQ_A(wf(:,-6),wf(:,31),wf(:,97))
  call counter_VQ_A(wf(:,-6),wf(:,33),wf(:,98))
  call vert_QA_V(wf(:,-4),wf(:,7),wf(:,99))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,100))
  call counter_VG_G(wf(:,12),wf(:,-6),Q(:,64),wf(:,101),Q(:,67))
  call vert_QA_V(wf(:,31),wf(:,-5),wf(:,102))
  call vert_QA_V(wf(:,33),wf(:,-5),wf(:,103))
  call vert_QA_V(wf(:,-4),wf(:,17),wf(:,104))
  call vert_QA_V(wf(:,-4),wf(:,19),wf(:,105))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,106))
  call prop_Q_A(wf(:,16),Q(:,83),ZERO,0_intkind1,wf(:,107))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,9),wf(:,108))
  call prop_Q_A(wf(:,20),Q(:,83),ZERO,0_intkind1,wf(:,109))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,110))
  call prop_Q_A(wf(:,6),Q(:,92),ZERO,0_intkind1,wf(:,111))
  call prop_Q_A(wf(:,10),Q(:,92),ZERO,0_intkind1,wf(:,112))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,12),wf(:,113))
  call prop_A_Q(wf(:,106),Q(:,44),ZERO,0_intkind1,wf(:,114))
  call prop_A_Q(wf(:,108),Q(:,44),ZERO,0_intkind1,wf(:,115))
  call prop_A_Q(wf(:,110),Q(:,35),ZERO,0_intkind1,wf(:,116))
  call prop_A_Q(wf(:,113),Q(:,35),ZERO,0_intkind1,wf(:,117))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,118))
  call prop_A_Q(wf(:,118),Q(:,96),ZERO,0_intkind1,wf(:,119))
  call vert_AV_Q(wf(:,119),wf(:,2),wf(:,120))
  call vert_AZ_Q(gZu,wf(:,119),wf(:,9),wf(:,121))
  call vert_AV_Q(wf(:,119),wf(:,1),wf(:,122))
  call vert_AZ_Q(gZu,wf(:,119),wf(:,12),wf(:,123))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,124))
  call prop_A_Q(wf(:,30),Q(:,99),ZERO,0_intkind1,wf(:,125))
  call counter_ZQ_A(gZu,wf(:,9),wf(:,-4),wf(:,126))
  call prop_A_Q(wf(:,34),Q(:,99),ZERO,0_intkind1,wf(:,127))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,128))
  call prop_A_Q(wf(:,24),Q(:,108),ZERO,0_intkind1,wf(:,129))
  call prop_A_Q(wf(:,26),Q(:,108),ZERO,0_intkind1,wf(:,130))
  call counter_ZQ_A(gZu,wf(:,12),wf(:,-4),wf(:,131))
  call prop_Q_A(wf(:,124),Q(:,28),ZERO,0_intkind1,wf(:,132))
  call vert_VQ_A(wf(:,-6),wf(:,132),wf(:,133))
  call prop_Q_A(wf(:,126),Q(:,28),ZERO,0_intkind1,wf(:,134))
  call vert_VQ_A(wf(:,-6),wf(:,134),wf(:,135))
  call prop_Q_A(wf(:,128),Q(:,19),ZERO,0_intkind1,wf(:,136))
  call vert_VQ_A(wf(:,-6),wf(:,136),wf(:,137))
  call prop_Q_A(wf(:,131),Q(:,19),ZERO,0_intkind1,wf(:,138))
  call vert_VQ_A(wf(:,-6),wf(:,138),wf(:,139))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,140))
  call prop_Q_A(wf(:,140),Q(:,80),ZERO,0_intkind1,wf(:,141))
  call vert_VQ_A(wf(:,2),wf(:,141),wf(:,142))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,141),wf(:,143))
  call vert_VQ_A(wf(:,1),wf(:,141),wf(:,144))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,141),wf(:,145))
  call counter_GG_V(wf(:,77),Q(:,48),wf(:,-6),Q(:,64),wf(:,146))
  call prop_W_W(wf(:,146),Q(:,112),MZ,1_intkind1,wf(:,147))
  call counter_QA_V(wf(:,4),wf(:,-5),wf(:,148))
  call counter_QA_Z(gZu,wf(:,4),wf(:,-5),wf(:,149))
  call prop_W_W(wf(:,149),Q(:,112),MZ,1_intkind1,wf(:,150))
  call vert_QA_V(wf(:,-4),wf(:,119),wf(:,151))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,119),wf(:,152))
  call prop_W_W(wf(:,152),Q(:,112),MZ,1_intkind1,wf(:,153))
  call counter_QA_V(wf(:,-4),wf(:,22),wf(:,154))
  call counter_QA_Z(gZu,wf(:,-4),wf(:,22),wf(:,155))
  call prop_W_W(wf(:,155),Q(:,112),MZ,1_intkind1,wf(:,156))
  call vert_QA_V(wf(:,141),wf(:,-5),wf(:,157))
  call vert_QA_Z(gZu,wf(:,141),wf(:,-5),wf(:,158))
  call prop_W_W(wf(:,158),Q(:,112),MZ,1_intkind1,wf(:,159))
  call counter_Q_A(ctqq,wf(:,4),Q(:,80),wf(:,160))
  call prop_Q_A(wf(:,160),Q(:,80),ZERO,0_intkind1,wf(:,161))
  call vert_VQ_A(wf(:,2),wf(:,161),wf(:,162))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,161),wf(:,163))
  call vert_VQ_A(wf(:,1),wf(:,161),wf(:,164))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,161),wf(:,165))
  call counter_A_Q(ctqq,wf(:,7),Q(:,35),wf(:,166))
  call counter_A_Q(ctqq,wf(:,14),Q(:,35),wf(:,167))
  call counter_A_Q(ctqq,wf(:,17),Q(:,44),wf(:,168))
  call counter_A_Q(ctqq,wf(:,19),Q(:,44),wf(:,169))
  call counter_Q_A(ctqq,wf(:,25),Q(:,19),wf(:,170))
  call counter_Q_A(ctqq,wf(:,28),Q(:,19),wf(:,171))
  call counter_Q_A(ctqq,wf(:,31),Q(:,28),wf(:,172))
  call counter_Q_A(ctqq,wf(:,33),Q(:,28),wf(:,173))
  call counter_A_Q(ctqq,wf(:,22),Q(:,96),wf(:,174))
  call prop_A_Q(wf(:,174),Q(:,96),ZERO,0_intkind1,wf(:,175))
  call vert_AV_Q(wf(:,175),wf(:,2),wf(:,176))
  call vert_AZ_Q(gZu,wf(:,175),wf(:,9),wf(:,177))
  call vert_AV_Q(wf(:,175),wf(:,1),wf(:,178))
  call vert_AZ_Q(gZu,wf(:,175),wf(:,12),wf(:,179))
  call vert_AV_Q(wf(:,17),wf(:,-6),wf(:,180))
  call prop_A_Q(wf(:,180),Q(:,108),ZERO,0_intkind1,wf(:,181))
  call vert_AV_Q(wf(:,19),wf(:,-6),wf(:,182))
  call prop_A_Q(wf(:,182),Q(:,108),ZERO,0_intkind1,wf(:,183))
  call vert_AV_Q(wf(:,7),wf(:,-6),wf(:,184))
  call prop_A_Q(wf(:,184),Q(:,99),ZERO,0_intkind1,wf(:,185))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,186))
  call prop_A_Q(wf(:,186),Q(:,99),ZERO,0_intkind1,wf(:,187))
  call prop_Q_A(wf(:,35),Q(:,83),ZERO,0_intkind1,wf(:,188))
  call prop_Q_A(wf(:,36),Q(:,83),ZERO,0_intkind1,wf(:,189))
  call prop_Q_A(wf(:,37),Q(:,92),ZERO,0_intkind1,wf(:,190))
  call prop_Q_A(wf(:,38),Q(:,92),ZERO,0_intkind1,wf(:,191))
  call vert_QA_V(wf(:,161),wf(:,-5),wf(:,192))
  call vert_QA_Z(gZu,wf(:,161),wf(:,-5),wf(:,193))
  call prop_W_W(wf(:,45),Q(:,15),MZ,1_intkind1,wf(:,194))
  call prop_W_W(wf(:,49),Q(:,15),MZ,1_intkind1,wf(:,195))
  call prop_W_W(wf(:,53),Q(:,15),MZ,1_intkind1,wf(:,196))
  call prop_W_W(wf(:,57),Q(:,15),MZ,1_intkind1,wf(:,197))
  call vert_QA_V(wf(:,-4),wf(:,175),wf(:,198))
  call vert_QA_Z(gZu,wf(:,-4),wf(:,175),wf(:,199))
  call prop_W_W(wf(:,64),Q(:,15),MZ,1_intkind1,wf(:,200))
  call prop_W_W(wf(:,68),Q(:,15),MZ,1_intkind1,wf(:,201))
  call prop_W_W(wf(:,75),Q(:,15),MZ,1_intkind1,wf(:,202))
  call prop_W_W(wf(:,76),Q(:,15),MZ,1_intkind1,wf(:,203))
  call vert_VQ_A(wf(:,2),wf(:,25),wf(:,204))
  call prop_Q_A(wf(:,204),Q(:,31),ZERO,0_intkind1,wf(:,205))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,25),wf(:,206))
  call prop_Q_A(wf(:,206),Q(:,31),ZERO,0_intkind1,wf(:,207))
  call vert_VQ_A(wf(:,2),wf(:,28),wf(:,208))
  call prop_Q_A(wf(:,208),Q(:,31),ZERO,0_intkind1,wf(:,209))
  call vert_ZQ_A(gZu,wf(:,9),wf(:,28),wf(:,210))
  call prop_Q_A(wf(:,210),Q(:,31),ZERO,0_intkind1,wf(:,211))
  call vert_AV_Q(wf(:,7),wf(:,2),wf(:,212))
  call prop_A_Q(wf(:,212),Q(:,47),ZERO,0_intkind1,wf(:,213))
  call vert_AZ_Q(gZu,wf(:,7),wf(:,9),wf(:,214))
  call prop_A_Q(wf(:,214),Q(:,47),ZERO,0_intkind1,wf(:,215))
  call vert_AV_Q(wf(:,14),wf(:,2),wf(:,216))
  call prop_A_Q(wf(:,216),Q(:,47),ZERO,0_intkind1,wf(:,217))
  call vert_AZ_Q(gZu,wf(:,14),wf(:,9),wf(:,218))
  call prop_A_Q(wf(:,218),Q(:,47),ZERO,0_intkind1,wf(:,219))
  call vert_VQ_A(wf(:,1),wf(:,31),wf(:,220))
  call prop_Q_A(wf(:,220),Q(:,31),ZERO,0_intkind1,wf(:,221))
  call vert_VQ_A(wf(:,1),wf(:,33),wf(:,222))
  call prop_Q_A(wf(:,222),Q(:,31),ZERO,0_intkind1,wf(:,223))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,31),wf(:,224))
  call prop_Q_A(wf(:,224),Q(:,31),ZERO,0_intkind1,wf(:,225))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,33),wf(:,226))
  call prop_Q_A(wf(:,226),Q(:,31),ZERO,0_intkind1,wf(:,227))
  call vert_AV_Q(wf(:,17),wf(:,1),wf(:,228))
  call prop_A_Q(wf(:,228),Q(:,47),ZERO,0_intkind1,wf(:,229))
  call vert_AV_Q(wf(:,19),wf(:,1),wf(:,230))
  call prop_A_Q(wf(:,230),Q(:,47),ZERO,0_intkind1,wf(:,231))
  call vert_AZ_Q(gZu,wf(:,17),wf(:,12),wf(:,232))
  call prop_A_Q(wf(:,232),Q(:,47),ZERO,0_intkind1,wf(:,233))
  call vert_AZ_Q(gZu,wf(:,19),wf(:,12),wf(:,234))
  call prop_A_Q(wf(:,234),Q(:,47),ZERO,0_intkind1,wf(:,235))
  call vert_VQ_A(wf(:,42),wf(:,-4),wf(:,236))
  call prop_Q_A(wf(:,236),Q(:,31),ZERO,0_intkind1,wf(:,237))
  call vert_ZQ_A(gZu,wf(:,194),wf(:,-4),wf(:,238))
  call prop_Q_A(wf(:,238),Q(:,31),ZERO,0_intkind1,wf(:,239))
  call vert_VQ_A(wf(:,48),wf(:,-4),wf(:,240))
  call prop_Q_A(wf(:,240),Q(:,31),ZERO,0_intkind1,wf(:,241))
  call vert_ZQ_A(gZu,wf(:,195),wf(:,-4),wf(:,242))
  call prop_Q_A(wf(:,242),Q(:,31),ZERO,0_intkind1,wf(:,243))
  call vert_AV_Q(wf(:,-5),wf(:,42),wf(:,244))
  call prop_A_Q(wf(:,244),Q(:,47),ZERO,0_intkind1,wf(:,245))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,194),wf(:,246))
  call prop_A_Q(wf(:,246),Q(:,47),ZERO,0_intkind1,wf(:,247))
  call vert_AV_Q(wf(:,-5),wf(:,48),wf(:,248))
  call prop_A_Q(wf(:,248),Q(:,47),ZERO,0_intkind1,wf(:,249))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,195),wf(:,250))
  call prop_A_Q(wf(:,250),Q(:,47),ZERO,0_intkind1,wf(:,251))
  call vert_VQ_A(wf(:,52),wf(:,-4),wf(:,252))
  call prop_Q_A(wf(:,252),Q(:,31),ZERO,0_intkind1,wf(:,253))
  call vert_ZQ_A(gZu,wf(:,196),wf(:,-4),wf(:,254))
  call prop_Q_A(wf(:,254),Q(:,31),ZERO,0_intkind1,wf(:,255))
  call vert_VQ_A(wf(:,56),wf(:,-4),wf(:,256))
  call prop_Q_A(wf(:,256),Q(:,31),ZERO,0_intkind1,wf(:,257))
  call vert_ZQ_A(gZu,wf(:,197),wf(:,-4),wf(:,258))
  call prop_Q_A(wf(:,258),Q(:,31),ZERO,0_intkind1,wf(:,259))
  call vert_AV_Q(wf(:,-5),wf(:,52),wf(:,260))
  call prop_A_Q(wf(:,260),Q(:,47),ZERO,0_intkind1,wf(:,261))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,196),wf(:,262))
  call prop_A_Q(wf(:,262),Q(:,47),ZERO,0_intkind1,wf(:,263))
  call vert_AV_Q(wf(:,-5),wf(:,56),wf(:,264))
  call prop_A_Q(wf(:,264),Q(:,47),ZERO,0_intkind1,wf(:,265))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,197),wf(:,266))
  call prop_A_Q(wf(:,266),Q(:,47),ZERO,0_intkind1,wf(:,267))
  call vert_VQ_A(wf(:,63),wf(:,-4),wf(:,268))
  call prop_Q_A(wf(:,268),Q(:,31),ZERO,0_intkind1,wf(:,269))
  call vert_ZQ_A(gZu,wf(:,200),wf(:,-4),wf(:,270))
  call prop_Q_A(wf(:,270),Q(:,31),ZERO,0_intkind1,wf(:,271))
  call vert_VQ_A(wf(:,67),wf(:,-4),wf(:,272))
  call prop_Q_A(wf(:,272),Q(:,31),ZERO,0_intkind1,wf(:,273))
  call vert_ZQ_A(gZu,wf(:,201),wf(:,-4),wf(:,274))
  call prop_Q_A(wf(:,274),Q(:,31),ZERO,0_intkind1,wf(:,275))
  call vert_AV_Q(wf(:,-5),wf(:,63),wf(:,276))
  call prop_A_Q(wf(:,276),Q(:,47),ZERO,0_intkind1,wf(:,277))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,200),wf(:,278))
  call prop_A_Q(wf(:,278),Q(:,47),ZERO,0_intkind1,wf(:,279))
  call vert_AV_Q(wf(:,-5),wf(:,67),wf(:,280))
  call prop_A_Q(wf(:,280),Q(:,47),ZERO,0_intkind1,wf(:,281))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,201),wf(:,282))
  call prop_A_Q(wf(:,282),Q(:,47),ZERO,0_intkind1,wf(:,283))
  call vert_VQ_A(wf(:,71),wf(:,-4),wf(:,284))
  call prop_Q_A(wf(:,284),Q(:,31),ZERO,0_intkind1,wf(:,285))
  call vert_VQ_A(wf(:,74),wf(:,-4),wf(:,286))
  call prop_Q_A(wf(:,286),Q(:,31),ZERO,0_intkind1,wf(:,287))
  call vert_ZQ_A(gZu,wf(:,202),wf(:,-4),wf(:,288))
  call prop_Q_A(wf(:,288),Q(:,31),ZERO,0_intkind1,wf(:,289))
  call vert_ZQ_A(gZu,wf(:,203),wf(:,-4),wf(:,290))
  call prop_Q_A(wf(:,290),Q(:,31),ZERO,0_intkind1,wf(:,291))
  call vert_AV_Q(wf(:,-5),wf(:,71),wf(:,292))
  call prop_A_Q(wf(:,292),Q(:,47),ZERO,0_intkind1,wf(:,293))
  call vert_AV_Q(wf(:,-5),wf(:,74),wf(:,294))
  call prop_A_Q(wf(:,294),Q(:,47),ZERO,0_intkind1,wf(:,295))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,202),wf(:,296))
  call prop_A_Q(wf(:,296),Q(:,47),ZERO,0_intkind1,wf(:,297))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,203),wf(:,298))
  call prop_A_Q(wf(:,298),Q(:,47),ZERO,0_intkind1,wf(:,299))


  ! propagators

    den(1) = 1 / (Q(5,3))
    den(2) = 1 / (Q(5,12))
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,35))
    den(8) = 1 / (Q(5,12) - MZ2)
    den(11) = 1 / (Q(5,3) - MZ2)
    den(16) = 1 / (Q(5,44))
    den(24) = 1 / (Q(5,96))
    den(26) = 1 / (Q(5,19))
    den(35) = 1 / (Q(5,28))
    den(51) = 1 / (Q(5,7))
    den(53) = 1 / (Q(5,112))
    den(56) = 1 / (Q(5,112) - MZ2)
    den(62) = 1 / (Q(5,11))
    den(79) = 1 / (Q(5,13))
    den(86) = 1 / (Q(5,14))
    den(101) = 1 / (Q(5,48))
    den(110) = 1 / (Q(5,15) - MH2)
    den(113) = 1 / (Q(5,76))
    den(119) = 1 / (Q(5,67))
    den(125) = 1 / (Q(5,83))
    den(132) = 1 / (Q(5,92))
    den(139) = 1 / (Q(5,99))
    den(146) = 1 / (Q(5,108))
    den(228) = 1 / (Q(5,15))
    den(231) = 1 / (Q(5,15) - MZ2)
    den(278) = 1 / (Q(5,51))
    den(282) = 1 / (Q(5,31))
    den(293) = 1 / (Q(5,47))
    den(301) = 1 / (Q(5,60))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(12) = den(5)*den(11)
    den(13) = den(4)*den(12)
    den(14) = den(9)*den(12)
    den(15) = den(1)*den(3)
    den(17) = den(2)*den(16)
    den(18) = den(15)*den(17)
    den(19) = den(8)*den(16)
    den(20) = den(15)*den(19)
    den(21) = den(3)*den(11)
    den(22) = den(17)*den(21)
    den(23) = den(19)*den(21)
    den(25) = den(2)*den(24)
    den(27) = den(1)*den(26)
    den(28) = den(25)*den(27)
    den(29) = den(8)*den(24)
    den(30) = den(27)*den(29)
    den(31) = den(11)*den(26)
    den(32) = den(25)*den(31)
    den(33) = den(29)*den(31)
    den(34) = den(1)*den(24)
    den(36) = den(2)*den(35)
    den(37) = den(34)*den(36)
    den(38) = den(8)*den(35)
    den(39) = den(34)*den(38)
    den(40) = den(11)*den(24)
    den(41) = den(36)*den(40)
    den(42) = den(38)*den(40)
    den(43) = den(17)*den(27)
    den(44) = den(19)*den(27)
    den(45) = den(17)*den(31)
    den(46) = den(19)*den(31)
    den(47) = den(6)*den(36)
    den(48) = den(6)*den(38)
    den(49) = den(12)*den(36)
    den(50) = den(12)*den(38)
    den(52) = den(1)*den(51)
    den(54) = den(3)*den(53)
    den(55) = den(52)*den(54)
    den(57) = den(3)*den(56)
    den(58) = den(52)*den(57)
    den(59) = den(11)*den(51)
    den(60) = den(54)*den(59)
    den(61) = den(57)*den(59)
    den(63) = den(1)*den(62)
    den(64) = den(54)*den(63)
    den(65) = den(57)*den(63)
    den(66) = den(11)*den(62)
    den(67) = den(54)*den(66)
    den(68) = den(57)*den(66)
    den(69) = den(24)*den(53)
    den(70) = den(52)*den(69)
    den(71) = den(24)*den(56)
    den(72) = den(52)*den(71)
    den(73) = den(59)*den(69)
    den(74) = den(59)*den(71)
    den(75) = den(63)*den(69)
    den(76) = den(63)*den(71)
    den(77) = den(66)*den(69)
    den(78) = den(66)*den(71)
    den(80) = den(2)*den(79)
    den(81) = den(54)*den(80)
    den(82) = den(57)*den(80)
    den(83) = den(8)*den(79)
    den(84) = den(54)*den(83)
    den(85) = den(57)*den(83)
    den(87) = den(2)*den(86)
    den(88) = den(54)*den(87)
    den(89) = den(8)*den(86)
    den(90) = den(54)*den(89)
    den(91) = den(57)*den(87)
    den(92) = den(57)*den(89)
    den(93) = den(69)*den(80)
    den(94) = den(71)*den(80)
    den(95) = den(69)*den(83)
    den(96) = den(71)*den(83)
    den(97) = den(69)*den(87)
    den(98) = den(69)*den(89)
    den(99) = den(71)*den(87)
    den(100) = den(71)*den(89)
    den(102) = den(1)*den(2)
    den(103) = den(101)*den(102)
    den(104) = den(1)*den(8)
    den(105) = den(101)*den(104)
    den(106) = den(2)*den(11)
    den(107) = den(101)*den(106)
    den(108) = den(8)*den(11)
    den(109) = den(101)*den(108)
    den(111) = den(108)*den(110)
    den(112) = den(101)*den(111)
    den(114) = den(8)*den(113)
    den(115) = den(27)*den(114)
    den(116) = den(31)*den(114)
    den(117) = den(6)*den(114)
    den(118) = den(12)*den(114)
    den(120) = den(11)*den(119)
    den(121) = den(36)*den(120)
    den(122) = den(38)*den(120)
    den(123) = den(17)*den(120)
    den(124) = den(19)*den(120)
    den(126) = den(15)*den(125)
    den(127) = den(2)*den(126)
    den(128) = den(8)*den(126)
    den(129) = den(21)*den(125)
    den(130) = den(2)*den(129)
    den(131) = den(8)*den(129)
    den(133) = den(4)*den(132)
    den(134) = den(1)*den(133)
    den(135) = den(9)*den(132)
    den(136) = den(1)*den(135)
    den(137) = den(11)*den(133)
    den(138) = den(11)*den(135)
    den(140) = den(34)*den(139)
    den(141) = den(2)*den(140)
    den(142) = den(8)*den(140)
    den(143) = den(40)*den(139)
    den(144) = den(2)*den(143)
    den(145) = den(8)*den(143)
    den(147) = den(25)*den(146)
    den(148) = den(1)*den(147)
    den(149) = den(29)*den(146)
    den(150) = den(1)*den(149)
    den(151) = den(11)*den(147)
    den(152) = den(11)*den(149)
    den(153) = den(56)*den(101)
    den(154) = den(52)*den(153)
    den(155) = den(59)*den(153)
    den(156) = den(63)*den(153)
    den(157) = den(66)*den(153)
    den(158) = den(80)*den(153)
    den(159) = den(83)*den(153)
    den(160) = den(87)*den(153)
    den(161) = den(89)*den(153)
    den(162) = den(3)**2
    den(163) = den(2)*den(162)
    den(164) = den(6)*den(163)
    den(165) = den(8)*den(162)
    den(166) = den(6)*den(165)
    den(167) = den(12)*den(163)
    den(168) = den(12)*den(165)
    den(169) = den(1)*den(162)
    den(170) = den(17)*den(169)
    den(171) = den(19)*den(169)
    den(172) = den(11)*den(162)
    den(173) = den(17)*den(172)
    den(174) = den(19)*den(172)
    den(175) = den(6)*den(133)
    den(176) = den(6)*den(135)
    den(177) = den(12)*den(133)
    den(178) = den(12)*den(135)
    den(179) = den(17)*den(126)
    den(180) = den(19)*den(126)
    den(181) = den(17)*den(129)
    den(182) = den(19)*den(129)
    den(183) = den(27)*den(147)
    den(184) = den(27)*den(149)
    den(185) = den(31)*den(147)
    den(186) = den(31)*den(149)
    den(187) = den(36)*den(140)
    den(188) = den(38)*den(140)
    den(189) = den(36)*den(143)
    den(190) = den(38)*den(143)
    den(191) = den(24)**2
    den(192) = den(2)*den(191)
    den(193) = den(27)*den(192)
    den(194) = den(8)*den(191)
    den(195) = den(27)*den(194)
    den(196) = den(31)*den(192)
    den(197) = den(31)*den(194)
    den(198) = den(1)*den(191)
    den(199) = den(36)*den(198)
    den(200) = den(38)*den(198)
    den(201) = den(11)*den(191)
    den(202) = den(36)*den(201)
    den(203) = den(38)*den(201)
    den(204) = den(17)*den(146)
    den(205) = den(27)*den(204)
    den(206) = den(19)*den(146)
    den(207) = den(27)*den(206)
    den(208) = den(31)*den(204)
    den(209) = den(31)*den(206)
    den(210) = den(6)*den(139)
    den(211) = den(36)*den(210)
    den(212) = den(38)*den(210)
    den(213) = den(12)*den(139)
    den(214) = den(36)*den(213)
    den(215) = den(38)*den(213)
    den(216) = den(27)*den(125)
    den(217) = den(17)*den(216)
    den(218) = den(19)*den(216)
    den(219) = den(31)*den(125)
    den(220) = den(17)*den(219)
    den(221) = den(19)*den(219)
    den(222) = den(36)*den(132)
    den(223) = den(6)*den(222)
    den(224) = den(38)*den(132)
    den(225) = den(6)*den(224)
    den(226) = den(12)*den(222)
    den(227) = den(12)*den(224)
    den(229) = den(52)*den(228)
    den(230) = den(162)*den(229)
    den(232) = den(52)*den(231)
    den(233) = den(162)*den(232)
    den(234) = den(59)*den(228)
    den(235) = den(162)*den(234)
    den(236) = den(59)*den(231)
    den(237) = den(162)*den(236)
    den(238) = den(63)*den(228)
    den(239) = den(162)*den(238)
    den(240) = den(63)*den(231)
    den(241) = den(162)*den(240)
    den(242) = den(66)*den(228)
    den(243) = den(162)*den(242)
    den(244) = den(66)*den(231)
    den(245) = den(162)*den(244)
    den(246) = den(191)*den(229)
    den(247) = den(191)*den(232)
    den(248) = den(191)*den(234)
    den(249) = den(191)*den(236)
    den(250) = den(191)*den(238)
    den(251) = den(191)*den(240)
    den(252) = den(191)*den(242)
    den(253) = den(191)*den(244)
    den(254) = den(80)*den(228)
    den(255) = den(162)*den(254)
    den(256) = den(80)*den(231)
    den(257) = den(162)*den(256)
    den(258) = den(83)*den(228)
    den(259) = den(162)*den(258)
    den(260) = den(83)*den(231)
    den(261) = den(162)*den(260)
    den(262) = den(87)*den(228)
    den(263) = den(162)*den(262)
    den(264) = den(89)*den(228)
    den(265) = den(162)*den(264)
    den(266) = den(87)*den(231)
    den(267) = den(162)*den(266)
    den(268) = den(89)*den(231)
    den(269) = den(162)*den(268)
    den(270) = den(191)*den(254)
    den(271) = den(191)*den(256)
    den(272) = den(191)*den(258)
    den(273) = den(191)*den(260)
    den(274) = den(191)*den(262)
    den(275) = den(191)*den(264)
    den(276) = den(191)*den(266)
    den(277) = den(191)*den(268)
    den(279) = den(27)*den(278)
    den(280) = den(31)*den(278)
    den(281) = den(2)*den(27)
    den(283) = den(281)*den(282)
    den(284) = den(8)*den(27)
    den(285) = den(282)*den(284)
    den(286) = den(2)*den(31)
    den(287) = den(282)*den(286)
    den(288) = den(8)*den(31)
    den(289) = den(282)*den(288)
    den(290) = den(6)*den(278)
    den(291) = den(12)*den(278)
    den(292) = den(2)*den(6)
    den(294) = den(292)*den(293)
    den(295) = den(6)*den(8)
    den(296) = den(293)*den(295)
    den(297) = den(2)*den(12)
    den(298) = den(293)*den(297)
    den(299) = den(8)*den(12)
    den(300) = den(293)*den(299)
    den(302) = den(36)*den(301)
    den(303) = den(38)*den(301)
    den(304) = den(1)*den(36)
    den(305) = den(282)*den(304)
    den(306) = den(1)*den(38)
    den(307) = den(282)*den(306)
    den(308) = den(11)*den(36)
    den(309) = den(282)*den(308)
    den(310) = den(11)*den(38)
    den(311) = den(282)*den(310)
    den(312) = den(17)*den(301)
    den(313) = den(19)*den(301)
    den(314) = den(1)*den(17)
    den(315) = den(293)*den(314)
    den(316) = den(1)*den(19)
    den(317) = den(293)*den(316)
    den(318) = den(11)*den(17)
    den(319) = den(293)*den(318)
    den(320) = den(11)*den(19)
    den(321) = den(293)*den(320)
    den(322) = den(229)*den(282)
    den(323) = den(232)*den(282)
    den(324) = den(234)*den(282)
    den(325) = den(236)*den(282)
    den(326) = den(229)*den(293)
    den(327) = den(232)*den(293)
    den(328) = den(234)*den(293)
    den(329) = den(236)*den(293)
    den(330) = den(238)*den(282)
    den(331) = den(240)*den(282)
    den(332) = den(242)*den(282)
    den(333) = den(244)*den(282)
    den(334) = den(238)*den(293)
    den(335) = den(240)*den(293)
    den(336) = den(242)*den(293)
    den(337) = den(244)*den(293)
    den(338) = den(254)*den(282)
    den(339) = den(256)*den(282)
    den(340) = den(258)*den(282)
    den(341) = den(260)*den(282)
    den(342) = den(254)*den(293)
    den(343) = den(256)*den(293)
    den(344) = den(258)*den(293)
    den(345) = den(260)*den(293)
    den(346) = den(262)*den(282)
    den(347) = den(264)*den(282)
    den(348) = den(266)*den(282)
    den(349) = den(268)*den(282)
    den(350) = den(262)*den(293)
    den(351) = den(264)*den(293)
    den(352) = den(266)*den(293)
    den(353) = den(268)*den(293)
    den(354) = den(1)*den(2)*den(101)
    den(355) = den(1)*den(8)*den(101)
    den(356) = den(2)*den(11)*den(101)
    den(357) = den(8)*den(11)*den(101)
    den(358) = den(2)*den(3)*den(6)
    den(359) = den(3)*den(6)*den(8)
    den(360) = den(2)*den(3)*den(12)
    den(361) = den(3)*den(8)*den(12)
    den(362) = den(1)*den(3)*den(17)
    den(363) = den(1)*den(3)*den(19)
    den(364) = den(3)*den(11)*den(17)
    den(365) = den(3)*den(11)*den(19)
    den(366) = den(1)*den(2)*den(3)
    den(367) = den(1)*den(3)*den(8)
    den(368) = den(2)*den(3)*den(11)
    den(369) = den(3)*den(8)*den(11)
    den(370) = den(2)*den(24)*den(27)
    den(371) = den(8)*den(24)*den(27)
    den(372) = den(2)*den(24)*den(31)
    den(373) = den(8)*den(24)*den(31)
    den(374) = den(1)*den(24)*den(36)
    den(375) = den(1)*den(24)*den(38)
    den(376) = den(11)*den(24)*den(36)
    den(377) = den(11)*den(24)*den(38)
    den(378) = den(1)*den(2)*den(24)
    den(379) = den(1)*den(8)*den(24)
    den(380) = den(2)*den(11)*den(24)
    den(381) = den(8)*den(11)*den(24)
    den(382) = den(2)*den(279)
    den(383) = den(8)*den(279)
    den(384) = den(2)*den(280)
    den(385) = den(8)*den(280)
    den(386) = den(2)*den(216)
    den(387) = den(8)*den(216)
    den(388) = den(2)*den(219)
    den(389) = den(8)*den(219)
    den(390) = den(2)*den(290)
    den(391) = den(8)*den(290)
    den(392) = den(2)*den(291)
    den(393) = den(8)*den(291)
    den(394) = den(2)*den(210)
    den(395) = den(8)*den(210)
    den(396) = den(2)*den(213)
    den(397) = den(8)*den(213)
    den(398) = den(1)*den(302)
    den(399) = den(1)*den(303)
    den(400) = den(11)*den(302)
    den(401) = den(11)*den(303)
    den(402) = den(1)*den(222)
    den(403) = den(1)*den(224)
    den(404) = den(11)*den(222)
    den(405) = den(11)*den(224)
    den(406) = den(1)*den(312)
    den(407) = den(1)*den(313)
    den(408) = den(11)*den(312)
    den(409) = den(11)*den(313)
    den(410) = den(1)*den(204)
    den(411) = den(1)*den(206)
    den(412) = den(11)*den(204)
    den(413) = den(11)*den(206)
    den(414) = den(101)*den(229)
    den(415) = den(101)*den(232)
    den(416) = den(101)*den(234)
    den(417) = den(101)*den(236)
    den(418) = den(101)*den(238)
    den(419) = den(101)*den(240)
    den(420) = den(101)*den(242)
    den(421) = den(101)*den(244)
    den(422) = den(3)*den(229)
    den(423) = den(3)*den(232)
    den(424) = den(3)*den(234)
    den(425) = den(3)*den(236)
    den(426) = den(3)*den(238)
    den(427) = den(3)*den(240)
    den(428) = den(3)*den(242)
    den(429) = den(3)*den(244)
    den(430) = den(24)*den(229)
    den(431) = den(24)*den(232)
    den(432) = den(24)*den(234)
    den(433) = den(24)*den(236)
    den(434) = den(24)*den(238)
    den(435) = den(24)*den(240)
    den(436) = den(24)*den(242)
    den(437) = den(24)*den(244)
    den(438) = den(101)*den(254)
    den(439) = den(101)*den(256)
    den(440) = den(101)*den(258)
    den(441) = den(101)*den(260)
    den(442) = den(101)*den(262)
    den(443) = den(101)*den(264)
    den(444) = den(101)*den(266)
    den(445) = den(101)*den(268)
    den(446) = den(3)*den(254)
    den(447) = den(3)*den(256)
    den(448) = den(3)*den(258)
    den(449) = den(3)*den(260)
    den(450) = den(3)*den(262)
    den(451) = den(3)*den(264)
    den(452) = den(3)*den(266)
    den(453) = den(3)*den(268)
    den(454) = den(24)*den(254)
    den(455) = den(24)*den(256)
    den(456) = den(24)*den(258)
    den(457) = den(24)*den(260)
    den(458) = den(24)*den(262)
    den(459) = den(24)*den(264)
    den(460) = den(24)*den(266)
    den(461) = den(24)*den(268)
    den(462) = den(3)*den(294)
    den(463) = den(3)*den(296)
    den(464) = den(3)*den(298)
    den(465) = den(3)*den(300)
    den(466) = den(3)*den(315)
    den(467) = den(3)*den(317)
    den(468) = den(3)*den(319)
    den(469) = den(3)*den(321)
    den(470) = den(24)*den(283)
    den(471) = den(24)*den(285)
    den(472) = den(24)*den(287)
    den(473) = den(24)*den(289)
    den(474) = den(24)*den(305)
    den(475) = den(24)*den(307)
    den(476) = den(24)*den(309)
    den(477) = den(24)*den(311)
    den(478) = den(3)*den(326)
    den(479) = den(3)*den(327)
    den(480) = den(3)*den(328)
    den(481) = den(3)*den(329)
    den(482) = den(3)*den(334)
    den(483) = den(3)*den(335)
    den(484) = den(3)*den(336)
    den(485) = den(3)*den(337)
    den(486) = den(24)*den(322)
    den(487) = den(24)*den(323)
    den(488) = den(24)*den(324)
    den(489) = den(24)*den(325)
    den(490) = den(24)*den(330)
    den(491) = den(24)*den(331)
    den(492) = den(24)*den(332)
    den(493) = den(24)*den(333)
    den(494) = den(3)*den(342)
    den(495) = den(3)*den(343)
    den(496) = den(3)*den(344)
    den(497) = den(3)*den(345)
    den(498) = den(3)*den(350)
    den(499) = den(3)*den(351)
    den(500) = den(3)*den(352)
    den(501) = den(3)*den(353)
    den(502) = den(24)*den(338)
    den(503) = den(24)*den(339)
    den(504) = den(24)*den(340)
    den(505) = den(24)*den(341)
    den(506) = den(24)*den(346)
    den(507) = den(24)*den(347)
    den(508) = den(24)*den(348)
    den(509) = den(24)*den(349)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,6),wf(:,7)) * den(7)
  A(2) = cont_QA(wf(:,7),wf(:,10)) * den(10)
  A(3) = cont_QA(wf(:,6),wf(:,14)) * den(13)
  A(4) = cont_QA(wf(:,10),wf(:,14)) * den(14)
  A(5) = cont_QA(wf(:,16),wf(:,17)) * den(18)
  A(6) = cont_QA(wf(:,16),wf(:,19)) * den(20)
  A(7) = cont_QA(wf(:,17),wf(:,20)) * den(22)
  A(8) = cont_QA(wf(:,19),wf(:,20)) * den(23)
  A(9) = cont_QA(wf(:,24),wf(:,25)) * den(28)
  A(10) = cont_QA(wf(:,25),wf(:,26)) * den(30)
  A(11) = cont_QA(wf(:,24),wf(:,28)) * den(32)
  A(12) = cont_QA(wf(:,26),wf(:,28)) * den(33)
  A(13) = cont_QA(wf(:,30),wf(:,31)) * den(37)
  A(14) = cont_QA(wf(:,30),wf(:,33)) * den(39)
  A(15) = cont_QA(wf(:,31),wf(:,34)) * den(41)
  A(16) = cont_QA(wf(:,33),wf(:,34)) * den(42)
  A(17) = cont_QA(wf(:,17),wf(:,35)) * den(43)
  A(18) = cont_QA(wf(:,19),wf(:,35)) * den(44)
  A(19) = cont_QA(wf(:,17),wf(:,36)) * den(45)
  A(20) = cont_QA(wf(:,19),wf(:,36)) * den(46)
  A(21) = cont_QA(wf(:,7),wf(:,37)) * den(47)
  A(22) = cont_QA(wf(:,7),wf(:,38)) * den(48)
  A(23) = cont_QA(wf(:,14),wf(:,37)) * den(49)
  A(24) = cont_QA(wf(:,14),wf(:,38)) * den(50)
  A(25) = cont_VV(wf(:,40),wf(:,42)) * den(55)
  A(26) = cont_VV(wf(:,44),wf(:,45)) * den(58)
  A(27) = cont_VV(wf(:,40),wf(:,48)) * den(60)
  A(28) = cont_VV(wf(:,44),wf(:,49)) * den(61)
  A(29) = cont_VV(wf(:,40),wf(:,52)) * den(64)
  A(30) = cont_VV(wf(:,44),wf(:,53)) * den(65)
  A(31) = cont_VV(wf(:,40),wf(:,56)) * den(67)
  A(32) = cont_VV(wf(:,44),wf(:,57)) * den(68)
  A(33) = cont_VV(wf(:,42),wf(:,58)) * den(70)
  A(34) = cont_VV(wf(:,45),wf(:,60)) * den(72)
  A(35) = cont_VV(wf(:,48),wf(:,58)) * den(73)
  A(36) = cont_VV(wf(:,49),wf(:,60)) * den(74)
  A(37) = cont_VV(wf(:,52),wf(:,58)) * den(75)
  A(38) = cont_VV(wf(:,53),wf(:,60)) * den(76)
  A(39) = cont_VV(wf(:,56),wf(:,58)) * den(77)
  A(40) = cont_VV(wf(:,57),wf(:,60)) * den(78)
  A(41) = cont_VV(wf(:,40),wf(:,63)) * den(81)
  A(42) = cont_VV(wf(:,44),wf(:,64)) * den(82)
  A(43) = cont_VV(wf(:,40),wf(:,67)) * den(84)
  A(44) = cont_VV(wf(:,44),wf(:,68)) * den(85)
  A(45) = cont_VV(wf(:,40),wf(:,71)) * den(88)
  A(46) = cont_VV(wf(:,40),wf(:,74)) * den(90)
  A(47) = cont_VV(wf(:,44),wf(:,75)) * den(91)
  A(48) = cont_VV(wf(:,44),wf(:,76)) * den(92)
  A(49) = cont_VV(wf(:,58),wf(:,63)) * den(93)
  A(50) = cont_VV(wf(:,60),wf(:,64)) * den(94)
  A(51) = cont_VV(wf(:,58),wf(:,67)) * den(95)
  A(52) = cont_VV(wf(:,60),wf(:,68)) * den(96)
  A(53) = cont_VV(wf(:,58),wf(:,71)) * den(97)
  A(54) = cont_VV(wf(:,58),wf(:,74)) * den(98)
  A(55) = cont_VV(wf(:,60),wf(:,75)) * den(99)
  A(56) = cont_VV(wf(:,60),wf(:,76)) * den(100)

  A(57) = cont_VV(wf(:,77),wf(:,78)) * den(103)
  A(58) = cont_VV(wf(:,77),wf(:,79)) * den(105)
  A(59) = cont_VV(wf(:,77),wf(:,80)) * den(107)
  A(60) = cont_VV(wf(:,77),wf(:,81)) * den(109)
  A(61) = cont_SS(wf(:,82),wf(:,83)) * den(112)
  A(62) = cont_QA(wf(:,7),wf(:,84)) * den(7)
  A(63) = cont_QA(wf(:,7),wf(:,85)) * den(10)
  A(64) = cont_QA(wf(:,14),wf(:,84)) * den(13)
  A(65) = cont_QA(wf(:,14),wf(:,85)) * den(14)
  A(66) = cont_QA(wf(:,17),wf(:,86)) * den(18)
  A(67) = cont_QA(wf(:,19),wf(:,86)) * den(20)
  A(68) = cont_QA(wf(:,17),wf(:,87)) * den(22)
  A(69) = cont_QA(wf(:,19),wf(:,87)) * den(23)
  A(70) = cont_QA(wf(:,25),wf(:,88)) * den(28)
  A(71) = cont_QA(wf(:,25),wf(:,89)) * den(30)
  A(72) = cont_QA(wf(:,28),wf(:,88)) * den(32)
  A(73) = cont_QA(wf(:,28),wf(:,89)) * den(33)
  A(74) = cont_QA(wf(:,31),wf(:,90)) * den(37)
  A(75) = cont_QA(wf(:,33),wf(:,90)) * den(39)
  A(76) = cont_QA(wf(:,31),wf(:,91)) * den(41)
  A(77) = cont_QA(wf(:,33),wf(:,91)) * den(42)
  A(78) = cont_QA(wf(:,17),wf(:,92)) * den(43)
  A(79) = cont_QA(wf(:,19),wf(:,92)) * den(44)
  A(80) = cont_QA(wf(:,17),wf(:,93)) * den(45)
  A(81) = cont_QA(wf(:,19),wf(:,93)) * den(46)
  A(82) = cont_VV(wf(:,94),wf(:,95)) * den(115)
  A(83) = cont_VV(wf(:,94),wf(:,96)) * den(116)
  A(84) = cont_QA(wf(:,7),wf(:,97)) * den(47)
  A(85) = cont_QA(wf(:,7),wf(:,98)) * den(48)
  A(86) = cont_QA(wf(:,14),wf(:,97)) * den(49)
  A(87) = cont_QA(wf(:,14),wf(:,98)) * den(50)
  A(88) = cont_VV(wf(:,94),wf(:,99)) * den(117)
  A(89) = cont_VV(wf(:,94),wf(:,100)) * den(118)
  A(90) = cont_VV(wf(:,101),wf(:,102)) * den(121)
  A(91) = cont_VV(wf(:,101),wf(:,103)) * den(122)
  A(92) = cont_VV(wf(:,101),wf(:,104)) * den(123)
  A(93) = cont_VV(wf(:,101),wf(:,105)) * den(124)
  A(94) = cont_QA(wf(:,106),wf(:,107)) * den(127)
  A(95) = cont_QA(wf(:,107),wf(:,108)) * den(128)
  A(96) = cont_QA(wf(:,106),wf(:,109)) * den(130)
  A(97) = cont_QA(wf(:,108),wf(:,109)) * den(131)
  A(98) = cont_QA(wf(:,110),wf(:,111)) * den(134)
  A(99) = cont_QA(wf(:,110),wf(:,112)) * den(136)
  A(100) = cont_QA(wf(:,111),wf(:,113)) * den(137)
  A(101) = cont_QA(wf(:,112),wf(:,113)) * den(138)
  A(102) = cont_QA(wf(:,35),wf(:,114)) * den(43)
  A(103) = cont_QA(wf(:,35),wf(:,115)) * den(44)
  A(104) = cont_QA(wf(:,36),wf(:,114)) * den(45)
  A(105) = cont_QA(wf(:,36),wf(:,115)) * den(46)
  A(106) = cont_QA(wf(:,37),wf(:,116)) * den(47)
  A(107) = cont_QA(wf(:,38),wf(:,116)) * den(48)
  A(108) = cont_QA(wf(:,37),wf(:,117)) * den(49)
  A(109) = cont_QA(wf(:,38),wf(:,117)) * den(50)
  A(110) = cont_QA(wf(:,25),wf(:,120)) * den(28)
  A(111) = cont_QA(wf(:,25),wf(:,121)) * den(30)
  A(112) = cont_QA(wf(:,28),wf(:,120)) * den(32)
  A(113) = cont_QA(wf(:,28),wf(:,121)) * den(33)
  A(114) = cont_QA(wf(:,31),wf(:,122)) * den(37)
  A(115) = cont_QA(wf(:,33),wf(:,122)) * den(39)
  A(116) = cont_QA(wf(:,31),wf(:,123)) * den(41)
  A(117) = cont_QA(wf(:,33),wf(:,123)) * den(42)
  A(118) = cont_QA(wf(:,124),wf(:,125)) * den(141)
  A(119) = cont_QA(wf(:,125),wf(:,126)) * den(142)
  A(120) = cont_QA(wf(:,124),wf(:,127)) * den(144)
  A(121) = cont_QA(wf(:,126),wf(:,127)) * den(145)
  A(122) = cont_QA(wf(:,128),wf(:,129)) * den(148)
  A(123) = cont_QA(wf(:,128),wf(:,130)) * den(150)
  A(124) = cont_QA(wf(:,129),wf(:,131)) * den(151)
  A(125) = cont_QA(wf(:,130),wf(:,131)) * den(152)
  A(126) = cont_QA(wf(:,7),wf(:,133)) * den(47)
  A(127) = cont_QA(wf(:,7),wf(:,135)) * den(48)
  A(128) = cont_QA(wf(:,14),wf(:,133)) * den(49)
  A(129) = cont_QA(wf(:,14),wf(:,135)) * den(50)
  A(130) = cont_QA(wf(:,17),wf(:,137)) * den(43)
  A(131) = cont_QA(wf(:,19),wf(:,137)) * den(44)
  A(132) = cont_QA(wf(:,17),wf(:,139)) * den(45)
  A(133) = cont_QA(wf(:,19),wf(:,139)) * den(46)
  A(134) = cont_QA(wf(:,7),wf(:,142)) * den(7)
  A(135) = cont_QA(wf(:,7),wf(:,143)) * den(10)
  A(136) = cont_QA(wf(:,14),wf(:,142)) * den(13)
  A(137) = cont_QA(wf(:,14),wf(:,143)) * den(14)
  A(138) = cont_QA(wf(:,17),wf(:,144)) * den(18)
  A(139) = cont_QA(wf(:,19),wf(:,144)) * den(20)
  A(140) = cont_QA(wf(:,17),wf(:,145)) * den(22)
  A(141) = cont_QA(wf(:,19),wf(:,145)) * den(23)
  A(142) = cont_VV(wf(:,45),wf(:,147)) * den(154)
  A(143) = cont_VV(wf(:,49),wf(:,147)) * den(155)
  A(144) = cont_VV(wf(:,53),wf(:,147)) * den(156)
  A(145) = cont_VV(wf(:,57),wf(:,147)) * den(157)
  A(146) = cont_VV(wf(:,42),wf(:,148)) * den(55)
  A(147) = cont_VV(wf(:,45),wf(:,150)) * den(58)
  A(148) = cont_VV(wf(:,48),wf(:,148)) * den(60)
  A(149) = cont_VV(wf(:,49),wf(:,150)) * den(61)
  A(150) = cont_VV(wf(:,52),wf(:,148)) * den(64)
  A(151) = cont_VV(wf(:,53),wf(:,150)) * den(65)
  A(152) = cont_VV(wf(:,56),wf(:,148)) * den(67)
  A(153) = cont_VV(wf(:,57),wf(:,150)) * den(68)
  A(154) = cont_VV(wf(:,42),wf(:,151)) * den(70)
  A(155) = cont_VV(wf(:,45),wf(:,153)) * den(72)
  A(156) = cont_VV(wf(:,48),wf(:,151)) * den(73)
  A(157) = cont_VV(wf(:,49),wf(:,153)) * den(74)
  A(158) = cont_VV(wf(:,52),wf(:,151)) * den(75)
  A(159) = cont_VV(wf(:,53),wf(:,153)) * den(76)
  A(160) = cont_VV(wf(:,56),wf(:,151)) * den(77)
  A(161) = cont_VV(wf(:,57),wf(:,153)) * den(78)
  A(162) = cont_VV(wf(:,42),wf(:,154)) * den(70)
  A(163) = cont_VV(wf(:,45),wf(:,156)) * den(72)
  A(164) = cont_VV(wf(:,48),wf(:,154)) * den(73)
  A(165) = cont_VV(wf(:,49),wf(:,156)) * den(74)
  A(166) = cont_VV(wf(:,52),wf(:,154)) * den(75)
  A(167) = cont_VV(wf(:,53),wf(:,156)) * den(76)
  A(168) = cont_VV(wf(:,56),wf(:,154)) * den(77)
  A(169) = cont_VV(wf(:,57),wf(:,156)) * den(78)
  A(170) = cont_VV(wf(:,42),wf(:,157)) * den(55)
  A(171) = cont_VV(wf(:,45),wf(:,159)) * den(58)
  A(172) = cont_VV(wf(:,48),wf(:,157)) * den(60)
  A(173) = cont_VV(wf(:,49),wf(:,159)) * den(61)
  A(174) = cont_VV(wf(:,52),wf(:,157)) * den(64)
  A(175) = cont_VV(wf(:,53),wf(:,159)) * den(65)
  A(176) = cont_VV(wf(:,56),wf(:,157)) * den(67)
  A(177) = cont_VV(wf(:,57),wf(:,159)) * den(68)
  A(178) = cont_VV(wf(:,64),wf(:,147)) * den(158)
  A(179) = cont_VV(wf(:,68),wf(:,147)) * den(159)
  A(180) = cont_VV(wf(:,75),wf(:,147)) * den(160)
  A(181) = cont_VV(wf(:,76),wf(:,147)) * den(161)
  A(182) = cont_VV(wf(:,63),wf(:,148)) * den(81)
  A(183) = cont_VV(wf(:,64),wf(:,150)) * den(82)
  A(184) = cont_VV(wf(:,67),wf(:,148)) * den(84)
  A(185) = cont_VV(wf(:,68),wf(:,150)) * den(85)
  A(186) = cont_VV(wf(:,71),wf(:,148)) * den(88)
  A(187) = cont_VV(wf(:,74),wf(:,148)) * den(90)
  A(188) = cont_VV(wf(:,75),wf(:,150)) * den(91)
  A(189) = cont_VV(wf(:,76),wf(:,150)) * den(92)
  A(190) = cont_VV(wf(:,63),wf(:,151)) * den(93)
  A(191) = cont_VV(wf(:,64),wf(:,153)) * den(94)
  A(192) = cont_VV(wf(:,67),wf(:,151)) * den(95)
  A(193) = cont_VV(wf(:,68),wf(:,153)) * den(96)
  A(194) = cont_VV(wf(:,71),wf(:,151)) * den(97)
  A(195) = cont_VV(wf(:,74),wf(:,151)) * den(98)
  A(196) = cont_VV(wf(:,75),wf(:,153)) * den(99)
  A(197) = cont_VV(wf(:,76),wf(:,153)) * den(100)
  A(198) = cont_VV(wf(:,63),wf(:,154)) * den(93)
  A(199) = cont_VV(wf(:,64),wf(:,156)) * den(94)
  A(200) = cont_VV(wf(:,67),wf(:,154)) * den(95)
  A(201) = cont_VV(wf(:,68),wf(:,156)) * den(96)
  A(202) = cont_VV(wf(:,71),wf(:,154)) * den(97)
  A(203) = cont_VV(wf(:,74),wf(:,154)) * den(98)
  A(204) = cont_VV(wf(:,75),wf(:,156)) * den(99)
  A(205) = cont_VV(wf(:,76),wf(:,156)) * den(100)
  A(206) = cont_VV(wf(:,63),wf(:,157)) * den(81)
  A(207) = cont_VV(wf(:,64),wf(:,159)) * den(82)
  A(208) = cont_VV(wf(:,67),wf(:,157)) * den(84)
  A(209) = cont_VV(wf(:,68),wf(:,159)) * den(85)
  A(210) = cont_VV(wf(:,71),wf(:,157)) * den(88)
  A(211) = cont_VV(wf(:,74),wf(:,157)) * den(90)
  A(212) = cont_VV(wf(:,75),wf(:,159)) * den(91)
  A(213) = cont_VV(wf(:,76),wf(:,159)) * den(92)
  A(214) = cont_QA(wf(:,7),wf(:,162)) * den(164)
  A(215) = cont_QA(wf(:,7),wf(:,163)) * den(166)
  A(216) = cont_QA(wf(:,14),wf(:,162)) * den(167)
  A(217) = cont_QA(wf(:,14),wf(:,163)) * den(168)
  A(218) = cont_QA(wf(:,17),wf(:,164)) * den(170)
  A(219) = cont_QA(wf(:,19),wf(:,164)) * den(171)
  A(220) = cont_QA(wf(:,17),wf(:,165)) * den(173)
  A(221) = cont_QA(wf(:,19),wf(:,165)) * den(174)
  A(222) = cont_QA(wf(:,111),wf(:,166)) * den(175)
  A(223) = cont_QA(wf(:,112),wf(:,166)) * den(176)
  A(224) = cont_QA(wf(:,111),wf(:,167)) * den(177)
  A(225) = cont_QA(wf(:,112),wf(:,167)) * den(178)
  A(226) = cont_QA(wf(:,107),wf(:,168)) * den(179)
  A(227) = cont_QA(wf(:,107),wf(:,169)) * den(180)
  A(228) = cont_QA(wf(:,109),wf(:,168)) * den(181)
  A(229) = cont_QA(wf(:,109),wf(:,169)) * den(182)
  A(230) = cont_QA(wf(:,129),wf(:,170)) * den(183)
  A(231) = cont_QA(wf(:,130),wf(:,170)) * den(184)
  A(232) = cont_QA(wf(:,129),wf(:,171)) * den(185)
  A(233) = cont_QA(wf(:,130),wf(:,171)) * den(186)
  A(234) = cont_QA(wf(:,125),wf(:,172)) * den(187)
  A(235) = cont_QA(wf(:,125),wf(:,173)) * den(188)
  A(236) = cont_QA(wf(:,127),wf(:,172)) * den(189)
  A(237) = cont_QA(wf(:,127),wf(:,173)) * den(190)
  A(238) = cont_QA(wf(:,25),wf(:,176)) * den(193)
  A(239) = cont_QA(wf(:,25),wf(:,177)) * den(195)
  A(240) = cont_QA(wf(:,28),wf(:,176)) * den(196)
  A(241) = cont_QA(wf(:,28),wf(:,177)) * den(197)
  A(242) = cont_QA(wf(:,31),wf(:,178)) * den(199)
  A(243) = cont_QA(wf(:,33),wf(:,178)) * den(200)
  A(244) = cont_QA(wf(:,31),wf(:,179)) * den(202)
  A(245) = cont_QA(wf(:,33),wf(:,179)) * den(203)
  A(246) = cont_QA(wf(:,170),wf(:,181)) * den(205)
  A(247) = cont_QA(wf(:,170),wf(:,183)) * den(207)
  A(248) = cont_QA(wf(:,171),wf(:,181)) * den(208)
  A(249) = cont_QA(wf(:,171),wf(:,183)) * den(209)
  A(250) = cont_QA(wf(:,172),wf(:,185)) * den(211)
  A(251) = cont_QA(wf(:,173),wf(:,185)) * den(212)
  A(252) = cont_QA(wf(:,172),wf(:,187)) * den(214)
  A(253) = cont_QA(wf(:,173),wf(:,187)) * den(215)
  A(254) = cont_QA(wf(:,168),wf(:,188)) * den(217)
  A(255) = cont_QA(wf(:,169),wf(:,188)) * den(218)
  A(256) = cont_QA(wf(:,168),wf(:,189)) * den(220)
  A(257) = cont_QA(wf(:,169),wf(:,189)) * den(221)
  A(258) = cont_QA(wf(:,166),wf(:,190)) * den(223)
  A(259) = cont_QA(wf(:,166),wf(:,191)) * den(225)
  A(260) = cont_QA(wf(:,167),wf(:,190)) * den(226)
  A(261) = cont_QA(wf(:,167),wf(:,191)) * den(227)
  A(262) = cont_VV(wf(:,42),wf(:,192)) * den(230)
  A(263) = cont_VV(wf(:,193),wf(:,194)) * den(233)
  A(264) = cont_VV(wf(:,48),wf(:,192)) * den(235)
  A(265) = cont_VV(wf(:,193),wf(:,195)) * den(237)
  A(266) = cont_VV(wf(:,52),wf(:,192)) * den(239)
  A(267) = cont_VV(wf(:,193),wf(:,196)) * den(241)
  A(268) = cont_VV(wf(:,56),wf(:,192)) * den(243)
  A(269) = cont_VV(wf(:,193),wf(:,197)) * den(245)
  A(270) = cont_VV(wf(:,42),wf(:,198)) * den(246)
  A(271) = cont_VV(wf(:,194),wf(:,199)) * den(247)
  A(272) = cont_VV(wf(:,48),wf(:,198)) * den(248)
  A(273) = cont_VV(wf(:,195),wf(:,199)) * den(249)
  A(274) = cont_VV(wf(:,52),wf(:,198)) * den(250)
  A(275) = cont_VV(wf(:,196),wf(:,199)) * den(251)
  A(276) = cont_VV(wf(:,56),wf(:,198)) * den(252)
  A(277) = cont_VV(wf(:,197),wf(:,199)) * den(253)
  A(278) = cont_VV(wf(:,63),wf(:,192)) * den(255)
  A(279) = cont_VV(wf(:,193),wf(:,200)) * den(257)
  A(280) = cont_VV(wf(:,67),wf(:,192)) * den(259)
  A(281) = cont_VV(wf(:,193),wf(:,201)) * den(261)
  A(282) = cont_VV(wf(:,71),wf(:,192)) * den(263)
  A(283) = cont_VV(wf(:,74),wf(:,192)) * den(265)
  A(284) = cont_VV(wf(:,193),wf(:,202)) * den(267)
  A(285) = cont_VV(wf(:,193),wf(:,203)) * den(269)
  A(286) = cont_VV(wf(:,63),wf(:,198)) * den(270)
  A(287) = cont_VV(wf(:,199),wf(:,200)) * den(271)
  A(288) = cont_VV(wf(:,67),wf(:,198)) * den(272)
  A(289) = cont_VV(wf(:,199),wf(:,201)) * den(273)
  A(290) = cont_VV(wf(:,71),wf(:,198)) * den(274)
  A(291) = cont_VV(wf(:,74),wf(:,198)) * den(275)
  A(292) = cont_VV(wf(:,199),wf(:,202)) * den(276)
  A(293) = cont_VV(wf(:,199),wf(:,203)) * den(277)


  ! colour vectors

  M1(1) = (A(1)+A(5)+A(9)+A(13)+A(17)+A(21))*f(1)+(-A(2)-A(3)-A(6)-A(7)-A(10)-A(11)-A(14)-A(15)-A(18)-A(19)-A(22)-A(23)-A(25) &
       -A(27)-A(29)-A(31)-A(33)-A(35)-A(37)-A(39)-A(41)-A(43)-A(45)-A(46)-A(49)-A(51)-A(53)-A(54))*f(2)+(A(4)+A(8)+A(12)+A(16) &
       +A(20)+A(24)+A(26)+A(28)+A(30)+A(32)+A(34)+A(36)+A(38)+A(40)+A(42)+A(44)+A(47)+A(48)+A(50)+A(52)+A(55)+A(56))*f(3)

  M2(1) = (-A(214)-A(218)-A(222)-A(226)-A(230)-A(234)-A(238)-A(242)-A(246)-A(250)-A(254)-A(258))*f(4)+(A(215)+A(216)+A(219)+A(220) &
       +A(223)+A(224)+A(227)+A(228)+A(231)+A(232)+A(235)+A(236)+A(239)+A(240)+A(243)+A(244)+A(247)+A(248)+A(251)+A(252)+A(255) &
       +A(256)+A(259)+A(260)+A(262)+A(264)+A(266)+A(268)+A(270)+A(272)+A(274)+A(276)+A(278)+A(280)+A(282)+A(283)+A(286)+A(288) &
       +A(290)+A(291))*f(5)+(-A(217)-A(221)-A(225)-A(229)-A(233)-A(237)-A(241)-A(245)-A(249)-A(253)-A(257)-A(261)-A(263)-A(265) &
       -A(267)-A(269)-A(271)-A(273)-A(275)-A(277)-A(279)-A(281)-A(284)-A(285)-A(287)-A(289)-A(292)-A(293))*f(6)+A(57)*f(7)+(A(58) &
       +A(59))*f(8)+(A(78)+A(84)+A(110)+A(114)+A(134)+A(138))*f(9)+(-A(79)-A(80)-A(85)-A(86)-A(111)-A(112)-A(115)-A(116)-A(135) &
       -A(136)-A(139)-A(140)-A(154)-A(156)-A(158)-A(160)-A(170)-A(172)-A(174)-A(176)-A(190)-A(192)-A(194)-A(195)-A(206)-A(208) &
       -A(210)-A(211))*f(10)+(A(81)+A(87)+A(113)+A(117)+A(137)+A(141)+A(155)+A(157)+A(159)+A(161)+A(171)+A(173)+A(175)+A(177) &
       +A(191)+A(193)+A(196)+A(197)+A(207)+A(209)+A(212)+A(213))*f(11)+(A(62)+A(66)+A(70)+A(74)+A(94)+A(98)+A(102)+A(106)+A(118) &
       +A(122)+A(126)+A(130))*f(12)+(-A(63)-A(64)-A(67)-A(68)-A(71)-A(72)-A(75)-A(76)-A(95)-A(96)-A(99)-A(100)-A(103)-A(104) &
       -A(107)-A(108)-A(119)-A(120)-A(123)-A(124)-A(127)-A(128)-A(131)-A(132)-A(146)-A(148)-A(150)-A(152)-A(162)-A(164)-A(166) &
       -A(168)-A(182)-A(184)-A(186)-A(187)-A(198)-A(200)-A(202)-A(203))*f(13)+(A(65)+A(69)+A(73)+A(77)+A(97)+A(101)+A(105)+A(109) &
       +A(121)+A(125)+A(129)+A(133)+A(147)+A(149)+A(151)+A(153)+A(163)+A(165)+A(167)+A(169)+A(183)+A(185)+A(188)+A(189)+A(199) &
       +A(201)+A(204)+A(205))*f(14)+(A(82)+A(88)+A(90)+A(92))*f(15)+(-A(83)-A(89)-A(91)-A(93)-A(142)-A(143)-A(144)-A(145)-A(178) &
       -A(179)-A(180)-A(181))*f(16)+A(60)*f(17)-A(61)*f(18)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_eexmmxuuxg_1_/**/REALKIND
