
module ol_colourmatrix_ppllllj_eexmmxbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_eexmmxbbxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_eexmmxbbxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_eexmmxbbxg_1_/**/REALKIND

module ol_loop_ppllllj_eexmmxbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(41), c(23)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:311)
  ! denominators
  complex(REALKIND), save :: den(522)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD)/9._/**/REALKIND
    f( 2) = (CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 3) = CI*eQED**4*gQCD
    f( 4) = (CI*countertermnorm*eQED**4*gQCD**3)/9._/**/REALKIND
    f( 5) = (CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**4*gQCD**3
    f( 7) = CI*countertermnorm*ctAAGG*eQED**4*gQCD**3
    f( 8) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 9) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/9._/**/REALKIND
    f(10) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctGbb*eQED**4*gQCD**3
    f(12) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/9._/**/REALKIND
    f(13) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVbb*eQED**4*gQCD**3
    f(15) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(16) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(17) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(18) = (CI*eQED**4*gQCD*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(19) = (CI*countertermnorm*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(20) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(21) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(22) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(23) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(24) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(25) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(26) = (eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(27) = (eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(28) = eQED**4*gQCD**3*integralnorm*SwB
    f(29) = (CI*eQED**4*gQCD**3*integralnorm*MB*SwB)/(2._/**/REALKIND*cw**2*sw**2)
    f(30) = (eQED**4*gQCD**3*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(31) = (eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(32) = (2*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(33) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(34) = (4*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(35) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(36) = (8*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(37) = eQED**4*gQCD**3*integralnorm*SwF
    f(38) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(39) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(40) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(41) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(23), 9*CI*f(24), 9*CI*f(25), f(26), 8*f(26), f(27), 8*f(27), f(28), 8*f(28), 9*CI*f(29), f(30), 8*f(30), 3*f(31) &
    , 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(301)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_A(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_Q(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rMB, H(5), wf(:,-4))
  call wf_A(P(:,6), rMB, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_Q_A(wf(:,3),Q(:,80),MB,1_intkind1,wf(:,4))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,5))
  call vert_VQ_A(wf(:,2),wf(:,4),wf(:,6))
  call prop_A_Q(wf(:,5),Q(:,35),MB,1_intkind1,wf(:,7))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,-3),wf(:,8))
  call prop_W_W(wf(:,8),Q(:,12),MZ,1_intkind1,wf(:,9))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,4),wf(:,10))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,11))
  call prop_W_W(wf(:,11),Q(:,3),MZ,1_intkind1,wf(:,12))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,12),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,35),MB,1_intkind1,wf(:,14))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,15))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,16))
  call prop_A_Q(wf(:,15),Q(:,44),MB,1_intkind1,wf(:,17))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,9),wf(:,18))
  call prop_A_Q(wf(:,18),Q(:,44),MB,1_intkind1,wf(:,19))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,4),wf(:,20))
  call vert_AQ_S(gH,wf(:,-5),wf(:,4),wf(:,21))
  call vert_VV_S(wf(:,12),wf(:,9),wf(:,22))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,23))
  call prop_A_Q(wf(:,23),Q(:,96),MB,1_intkind1,wf(:,24))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,25))
  call vert_AV_Q(wf(:,24),wf(:,2),wf(:,26))
  call prop_Q_A(wf(:,25),Q(:,19),MB,1_intkind1,wf(:,27))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,9),wf(:,28))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,-4),wf(:,29))
  call prop_Q_A(wf(:,29),Q(:,19),MB,1_intkind1,wf(:,30))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,31))
  call vert_AV_Q(wf(:,24),wf(:,1),wf(:,32))
  call prop_Q_A(wf(:,31),Q(:,28),MB,1_intkind1,wf(:,33))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,-4),wf(:,34))
  call prop_Q_A(wf(:,34),Q(:,28),MB,1_intkind1,wf(:,35))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,12),wf(:,36))
  call vert_AQ_S(gH,wf(:,24),wf(:,-4),wf(:,37))
  call vert_VQ_A(wf(:,-6),wf(:,27),wf(:,38))
  call vert_VQ_A(wf(:,-6),wf(:,30),wf(:,39))
  call vert_VQ_A(wf(:,-6),wf(:,33),wf(:,40))
  call vert_VQ_A(wf(:,-6),wf(:,35),wf(:,41))
  call vert_VQ_A(wf(:,1),wf(:,-2),wf(:,42))
  call vert_QA_V(wf(:,4),wf(:,-5),wf(:,43))
  call prop_Q_A(wf(:,42),Q(:,7),ZERO,0_intkind1,wf(:,44))
  call vert_QA_V(wf(:,44),wf(:,-3),wf(:,45))
  call vert_QA_Z(gZd,wf(:,4),wf(:,-5),wf(:,46))
  call prop_W_W(wf(:,46),Q(:,112),MZ,1_intkind1,wf(:,47))
  call vert_QA_Z(gZl,wf(:,44),wf(:,-3),wf(:,48))
  call vert_ZQ_A(gZl,wf(:,12),wf(:,-2),wf(:,49))
  call prop_Q_A(wf(:,49),Q(:,7),ZERO,0_intkind1,wf(:,50))
  call vert_QA_V(wf(:,50),wf(:,-3),wf(:,51))
  call vert_QA_Z(gZl,wf(:,50),wf(:,-3),wf(:,52))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,53))
  call prop_A_Q(wf(:,53),Q(:,11),ZERO,0_intkind1,wf(:,54))
  call vert_QA_V(wf(:,-2),wf(:,54),wf(:,55))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,54),wf(:,56))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,12),wf(:,57))
  call prop_A_Q(wf(:,57),Q(:,11),ZERO,0_intkind1,wf(:,58))
  call vert_QA_V(wf(:,-2),wf(:,58),wf(:,59))
  call vert_QA_Z(gZl,wf(:,-2),wf(:,58),wf(:,60))
  call vert_QA_V(wf(:,-4),wf(:,24),wf(:,61))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,24),wf(:,62))
  call prop_W_W(wf(:,62),Q(:,112),MZ,1_intkind1,wf(:,63))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,64))
  call prop_Q_A(wf(:,64),Q(:,13),ZERO,0_intkind1,wf(:,65))
  call vert_QA_V(wf(:,65),wf(:,-1),wf(:,66))
  call vert_QA_Z(gZl,wf(:,65),wf(:,-1),wf(:,67))
  call vert_ZQ_A(gZl,wf(:,9),wf(:,0),wf(:,68))
  call prop_Q_A(wf(:,68),Q(:,13),ZERO,0_intkind1,wf(:,69))
  call vert_QA_V(wf(:,69),wf(:,-1),wf(:,70))
  call vert_QA_Z(gZl,wf(:,69),wf(:,-1),wf(:,71))
  call vert_AV_Q(wf(:,-1),wf(:,2),wf(:,72))
  call prop_A_Q(wf(:,72),Q(:,14),ZERO,0_intkind1,wf(:,73))
  call vert_QA_V(wf(:,0),wf(:,73),wf(:,74))
  call vert_AZ_Q(gZl,wf(:,-1),wf(:,9),wf(:,75))
  call prop_A_Q(wf(:,75),Q(:,14),ZERO,0_intkind1,wf(:,76))
  call vert_QA_V(wf(:,0),wf(:,76),wf(:,77))
  call vert_QA_Z(gZl,wf(:,0),wf(:,73),wf(:,78))
  call vert_QA_Z(gZl,wf(:,0),wf(:,76),wf(:,79))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,80))
  call counter_VVG_G(wf(:,1),wf(:,2),wf(:,-6),wf(:,81))
  call counter_VVG_G(wf(:,1),wf(:,9),wf(:,-6),wf(:,82))
  call counter_VVG_G(wf(:,12),wf(:,2),wf(:,-6),wf(:,83))
  call counter_VVG_G(wf(:,12),wf(:,9),wf(:,-6),wf(:,84))
  call counter_GG_S(wf(:,80),wf(:,-6),wf(:,85))
  call counter_VQ_A(wf(:,2),wf(:,4),wf(:,86))
  call counter_ZQ_A(gZd,wf(:,9),wf(:,4),wf(:,87))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,88))
  call counter_ZQ_A(gZd,wf(:,12),wf(:,4),wf(:,89))
  call counter_AV_Q(wf(:,24),wf(:,2),wf(:,90))
  call counter_AZ_Q(gZd,wf(:,24),wf(:,9),wf(:,91))
  call counter_AV_Q(wf(:,24),wf(:,1),wf(:,92))
  call counter_AZ_Q(gZd,wf(:,24),wf(:,12),wf(:,93))
  call counter_VQ_A(wf(:,-6),wf(:,27),wf(:,94))
  call counter_VQ_A(wf(:,-6),wf(:,30),wf(:,95))
  call counter_VG_G(wf(:,9),wf(:,-6),Q(:,64),wf(:,96),Q(:,76))
  call vert_QA_V(wf(:,27),wf(:,-5),wf(:,97))
  call vert_QA_V(wf(:,30),wf(:,-5),wf(:,98))
  call counter_VQ_A(wf(:,-6),wf(:,33),wf(:,99))
  call counter_VQ_A(wf(:,-6),wf(:,35),wf(:,100))
  call vert_QA_V(wf(:,-4),wf(:,7),wf(:,101))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,102))
  call counter_VG_G(wf(:,12),wf(:,-6),Q(:,64),wf(:,103),Q(:,67))
  call vert_QA_V(wf(:,33),wf(:,-5),wf(:,104))
  call vert_QA_V(wf(:,35),wf(:,-5),wf(:,105))
  call vert_QA_V(wf(:,-4),wf(:,17),wf(:,106))
  call vert_QA_V(wf(:,-4),wf(:,19),wf(:,107))
  call counter_AQ_S(gH,wf(:,-5),wf(:,4),wf(:,108))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,109))
  call prop_Q_A(wf(:,16),Q(:,83),MB,1_intkind1,wf(:,110))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,9),wf(:,111))
  call prop_Q_A(wf(:,20),Q(:,83),MB,1_intkind1,wf(:,112))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,113))
  call prop_Q_A(wf(:,6),Q(:,92),MB,1_intkind1,wf(:,114))
  call prop_Q_A(wf(:,10),Q(:,92),MB,1_intkind1,wf(:,115))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,12),wf(:,116))
  call prop_A_Q(wf(:,109),Q(:,44),MB,1_intkind1,wf(:,117))
  call prop_A_Q(wf(:,111),Q(:,44),MB,1_intkind1,wf(:,118))
  call prop_A_Q(wf(:,113),Q(:,35),MB,1_intkind1,wf(:,119))
  call prop_A_Q(wf(:,116),Q(:,35),MB,1_intkind1,wf(:,120))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,121))
  call prop_A_Q(wf(:,121),Q(:,96),MB,1_intkind1,wf(:,122))
  call vert_AV_Q(wf(:,122),wf(:,2),wf(:,123))
  call vert_AZ_Q(gZd,wf(:,122),wf(:,9),wf(:,124))
  call vert_AV_Q(wf(:,122),wf(:,1),wf(:,125))
  call vert_AZ_Q(gZd,wf(:,122),wf(:,12),wf(:,126))
  call vert_AQ_S(gH,wf(:,122),wf(:,-4),wf(:,127))
  call counter_AQ_S(gH,wf(:,24),wf(:,-4),wf(:,128))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,129))
  call prop_A_Q(wf(:,32),Q(:,99),MB,1_intkind1,wf(:,130))
  call counter_ZQ_A(gZd,wf(:,9),wf(:,-4),wf(:,131))
  call prop_A_Q(wf(:,36),Q(:,99),MB,1_intkind1,wf(:,132))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,133))
  call prop_A_Q(wf(:,26),Q(:,108),MB,1_intkind1,wf(:,134))
  call prop_A_Q(wf(:,28),Q(:,108),MB,1_intkind1,wf(:,135))
  call counter_ZQ_A(gZd,wf(:,12),wf(:,-4),wf(:,136))
  call prop_Q_A(wf(:,129),Q(:,28),MB,1_intkind1,wf(:,137))
  call vert_VQ_A(wf(:,-6),wf(:,137),wf(:,138))
  call prop_Q_A(wf(:,131),Q(:,28),MB,1_intkind1,wf(:,139))
  call vert_VQ_A(wf(:,-6),wf(:,139),wf(:,140))
  call prop_Q_A(wf(:,133),Q(:,19),MB,1_intkind1,wf(:,141))
  call vert_VQ_A(wf(:,-6),wf(:,141),wf(:,142))
  call prop_Q_A(wf(:,136),Q(:,19),MB,1_intkind1,wf(:,143))
  call vert_VQ_A(wf(:,-6),wf(:,143),wf(:,144))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,145))
  call prop_Q_A(wf(:,145),Q(:,80),MB,1_intkind1,wf(:,146))
  call vert_VQ_A(wf(:,2),wf(:,146),wf(:,147))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,146),wf(:,148))
  call vert_VQ_A(wf(:,1),wf(:,146),wf(:,149))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,146),wf(:,150))
  call vert_AQ_S(gH,wf(:,-5),wf(:,146),wf(:,151))
  call counter_GG_V(wf(:,80),Q(:,48),wf(:,-6),Q(:,64),wf(:,152))
  call prop_W_W(wf(:,152),Q(:,112),MZ,1_intkind1,wf(:,153))
  call counter_QA_V(wf(:,4),wf(:,-5),wf(:,154))
  call counter_QA_Z(gZd,wf(:,4),wf(:,-5),wf(:,155))
  call prop_W_W(wf(:,155),Q(:,112),MZ,1_intkind1,wf(:,156))
  call vert_QA_V(wf(:,-4),wf(:,122),wf(:,157))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,122),wf(:,158))
  call prop_W_W(wf(:,158),Q(:,112),MZ,1_intkind1,wf(:,159))
  call counter_QA_V(wf(:,-4),wf(:,24),wf(:,160))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,24),wf(:,161))
  call prop_W_W(wf(:,161),Q(:,112),MZ,1_intkind1,wf(:,162))
  call vert_QA_V(wf(:,146),wf(:,-5),wf(:,163))
  call vert_QA_Z(gZd,wf(:,146),wf(:,-5),wf(:,164))
  call prop_W_W(wf(:,164),Q(:,112),MZ,1_intkind1,wf(:,165))
  call counter_Q_A(ctbb,wf(:,4),Q(:,80),wf(:,166))
  call prop_Q_A(wf(:,166),Q(:,80),MB,1_intkind1,wf(:,167))
  call vert_AQ_S(gH,wf(:,-5),wf(:,167),wf(:,168))
  call vert_VQ_A(wf(:,2),wf(:,167),wf(:,169))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,167),wf(:,170))
  call vert_VQ_A(wf(:,1),wf(:,167),wf(:,171))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,167),wf(:,172))
  call counter_A_Q(ctbb,wf(:,7),Q(:,35),wf(:,173))
  call counter_A_Q(ctbb,wf(:,14),Q(:,35),wf(:,174))
  call counter_A_Q(ctbb,wf(:,17),Q(:,44),wf(:,175))
  call counter_A_Q(ctbb,wf(:,19),Q(:,44),wf(:,176))
  call counter_A_Q(ctbb,wf(:,24),Q(:,96),wf(:,177))
  call prop_A_Q(wf(:,177),Q(:,96),MB,1_intkind1,wf(:,178))
  call vert_AQ_S(gH,wf(:,178),wf(:,-4),wf(:,179))
  call counter_Q_A(ctbb,wf(:,27),Q(:,19),wf(:,180))
  call counter_Q_A(ctbb,wf(:,30),Q(:,19),wf(:,181))
  call counter_Q_A(ctbb,wf(:,33),Q(:,28),wf(:,182))
  call counter_Q_A(ctbb,wf(:,35),Q(:,28),wf(:,183))
  call vert_AV_Q(wf(:,178),wf(:,2),wf(:,184))
  call vert_AZ_Q(gZd,wf(:,178),wf(:,9),wf(:,185))
  call vert_AV_Q(wf(:,178),wf(:,1),wf(:,186))
  call vert_AZ_Q(gZd,wf(:,178),wf(:,12),wf(:,187))
  call vert_AV_Q(wf(:,17),wf(:,-6),wf(:,188))
  call prop_A_Q(wf(:,188),Q(:,108),MB,1_intkind1,wf(:,189))
  call vert_AV_Q(wf(:,19),wf(:,-6),wf(:,190))
  call prop_A_Q(wf(:,190),Q(:,108),MB,1_intkind1,wf(:,191))
  call vert_AV_Q(wf(:,7),wf(:,-6),wf(:,192))
  call prop_A_Q(wf(:,192),Q(:,99),MB,1_intkind1,wf(:,193))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,194))
  call prop_A_Q(wf(:,194),Q(:,99),MB,1_intkind1,wf(:,195))
  call prop_Q_A(wf(:,38),Q(:,83),MB,1_intkind1,wf(:,196))
  call prop_Q_A(wf(:,39),Q(:,83),MB,1_intkind1,wf(:,197))
  call prop_Q_A(wf(:,40),Q(:,92),MB,1_intkind1,wf(:,198))
  call prop_Q_A(wf(:,41),Q(:,92),MB,1_intkind1,wf(:,199))
  call vert_QA_V(wf(:,167),wf(:,-5),wf(:,200))
  call vert_QA_Z(gZd,wf(:,167),wf(:,-5),wf(:,201))
  call prop_W_W(wf(:,48),Q(:,15),MZ,1_intkind1,wf(:,202))
  call prop_W_W(wf(:,52),Q(:,15),MZ,1_intkind1,wf(:,203))
  call prop_W_W(wf(:,56),Q(:,15),MZ,1_intkind1,wf(:,204))
  call prop_W_W(wf(:,60),Q(:,15),MZ,1_intkind1,wf(:,205))
  call vert_QA_V(wf(:,-4),wf(:,178),wf(:,206))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,178),wf(:,207))
  call prop_W_W(wf(:,67),Q(:,15),MZ,1_intkind1,wf(:,208))
  call prop_W_W(wf(:,71),Q(:,15),MZ,1_intkind1,wf(:,209))
  call prop_W_W(wf(:,78),Q(:,15),MZ,1_intkind1,wf(:,210))
  call prop_W_W(wf(:,79),Q(:,15),MZ,1_intkind1,wf(:,211))
  call vert_VQ_A(wf(:,2),wf(:,27),wf(:,212))
  call prop_Q_A(wf(:,212),Q(:,31),MB,1_intkind1,wf(:,213))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,27),wf(:,214))
  call prop_Q_A(wf(:,214),Q(:,31),MB,1_intkind1,wf(:,215))
  call vert_VQ_A(wf(:,2),wf(:,30),wf(:,216))
  call prop_Q_A(wf(:,216),Q(:,31),MB,1_intkind1,wf(:,217))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,30),wf(:,218))
  call prop_Q_A(wf(:,218),Q(:,31),MB,1_intkind1,wf(:,219))
  call vert_AV_Q(wf(:,7),wf(:,2),wf(:,220))
  call prop_A_Q(wf(:,220),Q(:,47),MB,1_intkind1,wf(:,221))
  call vert_AZ_Q(gZd,wf(:,7),wf(:,9),wf(:,222))
  call prop_A_Q(wf(:,222),Q(:,47),MB,1_intkind1,wf(:,223))
  call vert_AV_Q(wf(:,14),wf(:,2),wf(:,224))
  call prop_A_Q(wf(:,224),Q(:,47),MB,1_intkind1,wf(:,225))
  call vert_AZ_Q(gZd,wf(:,14),wf(:,9),wf(:,226))
  call prop_A_Q(wf(:,226),Q(:,47),MB,1_intkind1,wf(:,227))
  call vert_VQ_A(wf(:,1),wf(:,33),wf(:,228))
  call prop_Q_A(wf(:,228),Q(:,31),MB,1_intkind1,wf(:,229))
  call vert_VQ_A(wf(:,1),wf(:,35),wf(:,230))
  call prop_Q_A(wf(:,230),Q(:,31),MB,1_intkind1,wf(:,231))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,33),wf(:,232))
  call prop_Q_A(wf(:,232),Q(:,31),MB,1_intkind1,wf(:,233))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,35),wf(:,234))
  call prop_Q_A(wf(:,234),Q(:,31),MB,1_intkind1,wf(:,235))
  call vert_AV_Q(wf(:,17),wf(:,1),wf(:,236))
  call prop_A_Q(wf(:,236),Q(:,47),MB,1_intkind1,wf(:,237))
  call vert_AV_Q(wf(:,19),wf(:,1),wf(:,238))
  call prop_A_Q(wf(:,238),Q(:,47),MB,1_intkind1,wf(:,239))
  call vert_AZ_Q(gZd,wf(:,17),wf(:,12),wf(:,240))
  call prop_A_Q(wf(:,240),Q(:,47),MB,1_intkind1,wf(:,241))
  call vert_AZ_Q(gZd,wf(:,19),wf(:,12),wf(:,242))
  call prop_A_Q(wf(:,242),Q(:,47),MB,1_intkind1,wf(:,243))
  call vert_QS_A(gH,wf(:,-4),wf(:,22),wf(:,244))
  call prop_Q_A(wf(:,244),Q(:,31),MB,1_intkind1,wf(:,245))
  call vert_SA_Q(gH,wf(:,22),wf(:,-5),wf(:,246))
  call prop_A_Q(wf(:,246),Q(:,47),MB,1_intkind1,wf(:,247))
  call vert_VQ_A(wf(:,45),wf(:,-4),wf(:,248))
  call prop_Q_A(wf(:,248),Q(:,31),MB,1_intkind1,wf(:,249))
  call vert_ZQ_A(gZd,wf(:,202),wf(:,-4),wf(:,250))
  call prop_Q_A(wf(:,250),Q(:,31),MB,1_intkind1,wf(:,251))
  call vert_VQ_A(wf(:,51),wf(:,-4),wf(:,252))
  call prop_Q_A(wf(:,252),Q(:,31),MB,1_intkind1,wf(:,253))
  call vert_ZQ_A(gZd,wf(:,203),wf(:,-4),wf(:,254))
  call prop_Q_A(wf(:,254),Q(:,31),MB,1_intkind1,wf(:,255))
  call vert_AV_Q(wf(:,-5),wf(:,45),wf(:,256))
  call prop_A_Q(wf(:,256),Q(:,47),MB,1_intkind1,wf(:,257))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,202),wf(:,258))
  call prop_A_Q(wf(:,258),Q(:,47),MB,1_intkind1,wf(:,259))
  call vert_AV_Q(wf(:,-5),wf(:,51),wf(:,260))
  call prop_A_Q(wf(:,260),Q(:,47),MB,1_intkind1,wf(:,261))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,203),wf(:,262))
  call prop_A_Q(wf(:,262),Q(:,47),MB,1_intkind1,wf(:,263))
  call vert_VQ_A(wf(:,55),wf(:,-4),wf(:,264))
  call prop_Q_A(wf(:,264),Q(:,31),MB,1_intkind1,wf(:,265))
  call vert_ZQ_A(gZd,wf(:,204),wf(:,-4),wf(:,266))
  call prop_Q_A(wf(:,266),Q(:,31),MB,1_intkind1,wf(:,267))
  call vert_VQ_A(wf(:,59),wf(:,-4),wf(:,268))
  call prop_Q_A(wf(:,268),Q(:,31),MB,1_intkind1,wf(:,269))
  call vert_ZQ_A(gZd,wf(:,205),wf(:,-4),wf(:,270))
  call prop_Q_A(wf(:,270),Q(:,31),MB,1_intkind1,wf(:,271))
  call vert_AV_Q(wf(:,-5),wf(:,55),wf(:,272))
  call prop_A_Q(wf(:,272),Q(:,47),MB,1_intkind1,wf(:,273))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,204),wf(:,274))
  call prop_A_Q(wf(:,274),Q(:,47),MB,1_intkind1,wf(:,275))
  call vert_AV_Q(wf(:,-5),wf(:,59),wf(:,276))
  call prop_A_Q(wf(:,276),Q(:,47),MB,1_intkind1,wf(:,277))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,205),wf(:,278))
  call prop_A_Q(wf(:,278),Q(:,47),MB,1_intkind1,wf(:,279))
  call vert_VQ_A(wf(:,66),wf(:,-4),wf(:,280))
  call prop_Q_A(wf(:,280),Q(:,31),MB,1_intkind1,wf(:,281))
  call vert_ZQ_A(gZd,wf(:,208),wf(:,-4),wf(:,282))
  call prop_Q_A(wf(:,282),Q(:,31),MB,1_intkind1,wf(:,283))
  call vert_VQ_A(wf(:,70),wf(:,-4),wf(:,284))
  call prop_Q_A(wf(:,284),Q(:,31),MB,1_intkind1,wf(:,285))
  call vert_ZQ_A(gZd,wf(:,209),wf(:,-4),wf(:,286))
  call prop_Q_A(wf(:,286),Q(:,31),MB,1_intkind1,wf(:,287))
  call vert_AV_Q(wf(:,-5),wf(:,66),wf(:,288))
  call prop_A_Q(wf(:,288),Q(:,47),MB,1_intkind1,wf(:,289))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,208),wf(:,290))
  call prop_A_Q(wf(:,290),Q(:,47),MB,1_intkind1,wf(:,291))
  call vert_AV_Q(wf(:,-5),wf(:,70),wf(:,292))
  call prop_A_Q(wf(:,292),Q(:,47),MB,1_intkind1,wf(:,293))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,209),wf(:,294))
  call prop_A_Q(wf(:,294),Q(:,47),MB,1_intkind1,wf(:,295))
  call vert_VQ_A(wf(:,74),wf(:,-4),wf(:,296))
  call prop_Q_A(wf(:,296),Q(:,31),MB,1_intkind1,wf(:,297))
  call vert_VQ_A(wf(:,77),wf(:,-4),wf(:,298))
  call prop_Q_A(wf(:,298),Q(:,31),MB,1_intkind1,wf(:,299))
  call vert_ZQ_A(gZd,wf(:,210),wf(:,-4),wf(:,300))
  call prop_Q_A(wf(:,300),Q(:,31),MB,1_intkind1,wf(:,301))
  call vert_ZQ_A(gZd,wf(:,211),wf(:,-4),wf(:,302))
  call prop_Q_A(wf(:,302),Q(:,31),MB,1_intkind1,wf(:,303))
  call vert_AV_Q(wf(:,-5),wf(:,74),wf(:,304))
  call prop_A_Q(wf(:,304),Q(:,47),MB,1_intkind1,wf(:,305))
  call vert_AV_Q(wf(:,-5),wf(:,77),wf(:,306))
  call prop_A_Q(wf(:,306),Q(:,47),MB,1_intkind1,wf(:,307))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,210),wf(:,308))
  call prop_A_Q(wf(:,308),Q(:,47),MB,1_intkind1,wf(:,309))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,211),wf(:,310))
  call prop_A_Q(wf(:,310),Q(:,47),MB,1_intkind1,wf(:,311))


  ! propagators

    den(1) = 1 / (Q(5,3))
    den(2) = 1 / (Q(5,12))
    den(3) = 1 / (Q(5,80) - MB2)
    den(5) = 1 / (Q(5,35) - MB2)
    den(8) = 1 / (Q(5,12) - MZ2)
    den(11) = 1 / (Q(5,3) - MZ2)
    den(16) = 1 / (Q(5,44) - MB2)
    den(25) = 1 / (Q(5,112) - MH2)
    den(28) = 1 / (Q(5,96) - MB2)
    den(30) = 1 / (Q(5,19) - MB2)
    den(39) = 1 / (Q(5,28) - MB2)
    den(57) = 1 / (Q(5,7))
    den(59) = 1 / (Q(5,112))
    den(62) = 1 / (Q(5,112) - MZ2)
    den(68) = 1 / (Q(5,11))
    den(85) = 1 / (Q(5,13))
    den(92) = 1 / (Q(5,14))
    den(107) = 1 / (Q(5,48))
    den(115) = 1 / (Q(5,15) - MH2)
    den(118) = 1 / (Q(5,76))
    den(124) = 1 / (Q(5,67))
    den(131) = 1 / (Q(5,83) - MB2)
    den(138) = 1 / (Q(5,92) - MB2)
    den(146) = 1 / (Q(5,99) - MB2)
    den(153) = 1 / (Q(5,108) - MB2)
    den(237) = 1 / (Q(5,15))
    den(240) = 1 / (Q(5,15) - MZ2)
    den(287) = 1 / (Q(5,51))
    den(291) = 1 / (Q(5,31) - MB2)
    den(302) = 1 / (Q(5,47) - MB2)
    den(310) = 1 / (Q(5,60))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(12) = den(5)*den(11)
    den(13) = den(4)*den(12)
    den(14) = den(9)*den(12)
    den(15) = den(1)*den(3)
    den(17) = den(2)*den(16)
    den(18) = den(15)*den(17)
    den(19) = den(8)*den(16)
    den(20) = den(15)*den(19)
    den(21) = den(3)*den(11)
    den(22) = den(17)*den(21)
    den(23) = den(19)*den(21)
    den(24) = den(8)*den(11)
    den(26) = den(3)*den(25)
    den(27) = den(24)*den(26)
    den(29) = den(2)*den(28)
    den(31) = den(1)*den(30)
    den(32) = den(29)*den(31)
    den(33) = den(8)*den(28)
    den(34) = den(31)*den(33)
    den(35) = den(11)*den(30)
    den(36) = den(29)*den(35)
    den(37) = den(33)*den(35)
    den(38) = den(1)*den(28)
    den(40) = den(2)*den(39)
    den(41) = den(38)*den(40)
    den(42) = den(8)*den(39)
    den(43) = den(38)*den(42)
    den(44) = den(11)*den(28)
    den(45) = den(40)*den(44)
    den(46) = den(42)*den(44)
    den(47) = den(25)*den(28)
    den(48) = den(24)*den(47)
    den(49) = den(17)*den(31)
    den(50) = den(19)*den(31)
    den(51) = den(17)*den(35)
    den(52) = den(19)*den(35)
    den(53) = den(6)*den(40)
    den(54) = den(6)*den(42)
    den(55) = den(12)*den(40)
    den(56) = den(12)*den(42)
    den(58) = den(1)*den(57)
    den(60) = den(3)*den(59)
    den(61) = den(58)*den(60)
    den(63) = den(3)*den(62)
    den(64) = den(58)*den(63)
    den(65) = den(11)*den(57)
    den(66) = den(60)*den(65)
    den(67) = den(63)*den(65)
    den(69) = den(1)*den(68)
    den(70) = den(60)*den(69)
    den(71) = den(63)*den(69)
    den(72) = den(11)*den(68)
    den(73) = den(60)*den(72)
    den(74) = den(63)*den(72)
    den(75) = den(28)*den(59)
    den(76) = den(58)*den(75)
    den(77) = den(28)*den(62)
    den(78) = den(58)*den(77)
    den(79) = den(65)*den(75)
    den(80) = den(65)*den(77)
    den(81) = den(69)*den(75)
    den(82) = den(69)*den(77)
    den(83) = den(72)*den(75)
    den(84) = den(72)*den(77)
    den(86) = den(2)*den(85)
    den(87) = den(60)*den(86)
    den(88) = den(63)*den(86)
    den(89) = den(8)*den(85)
    den(90) = den(60)*den(89)
    den(91) = den(63)*den(89)
    den(93) = den(2)*den(92)
    den(94) = den(60)*den(93)
    den(95) = den(8)*den(92)
    den(96) = den(60)*den(95)
    den(97) = den(63)*den(93)
    den(98) = den(63)*den(95)
    den(99) = den(75)*den(86)
    den(100) = den(77)*den(86)
    den(101) = den(75)*den(89)
    den(102) = den(77)*den(89)
    den(103) = den(75)*den(93)
    den(104) = den(75)*den(95)
    den(105) = den(77)*den(93)
    den(106) = den(77)*den(95)
    den(108) = den(1)*den(2)
    den(109) = den(107)*den(108)
    den(110) = den(1)*den(8)
    den(111) = den(107)*den(110)
    den(112) = den(2)*den(11)
    den(113) = den(107)*den(112)
    den(114) = den(24)*den(107)
    den(116) = den(24)*den(115)
    den(117) = den(107)*den(116)
    den(119) = den(8)*den(118)
    den(120) = den(31)*den(119)
    den(121) = den(35)*den(119)
    den(122) = den(6)*den(119)
    den(123) = den(12)*den(119)
    den(125) = den(11)*den(124)
    den(126) = den(40)*den(125)
    den(127) = den(42)*den(125)
    den(128) = den(17)*den(125)
    den(129) = den(19)*den(125)
    den(130) = den(3)*den(116)
    den(132) = den(15)*den(131)
    den(133) = den(2)*den(132)
    den(134) = den(8)*den(132)
    den(135) = den(21)*den(131)
    den(136) = den(2)*den(135)
    den(137) = den(8)*den(135)
    den(139) = den(4)*den(138)
    den(140) = den(1)*den(139)
    den(141) = den(9)*den(138)
    den(142) = den(1)*den(141)
    den(143) = den(11)*den(139)
    den(144) = den(11)*den(141)
    den(145) = den(28)*den(116)
    den(147) = den(38)*den(146)
    den(148) = den(2)*den(147)
    den(149) = den(8)*den(147)
    den(150) = den(44)*den(146)
    den(151) = den(2)*den(150)
    den(152) = den(8)*den(150)
    den(154) = den(29)*den(153)
    den(155) = den(1)*den(154)
    den(156) = den(33)*den(153)
    den(157) = den(1)*den(156)
    den(158) = den(11)*den(154)
    den(159) = den(11)*den(156)
    den(160) = den(62)*den(107)
    den(161) = den(58)*den(160)
    den(162) = den(65)*den(160)
    den(163) = den(69)*den(160)
    den(164) = den(72)*den(160)
    den(165) = den(86)*den(160)
    den(166) = den(89)*den(160)
    den(167) = den(93)*den(160)
    den(168) = den(95)*den(160)
    den(169) = den(3)**2
    den(170) = den(116)*den(169)
    den(171) = den(2)*den(169)
    den(172) = den(6)*den(171)
    den(173) = den(8)*den(169)
    den(174) = den(6)*den(173)
    den(175) = den(12)*den(171)
    den(176) = den(12)*den(173)
    den(177) = den(1)*den(169)
    den(178) = den(17)*den(177)
    den(179) = den(19)*den(177)
    den(180) = den(11)*den(169)
    den(181) = den(17)*den(180)
    den(182) = den(19)*den(180)
    den(183) = den(6)*den(139)
    den(184) = den(6)*den(141)
    den(185) = den(12)*den(139)
    den(186) = den(12)*den(141)
    den(187) = den(17)*den(132)
    den(188) = den(19)*den(132)
    den(189) = den(17)*den(135)
    den(190) = den(19)*den(135)
    den(191) = den(28)**2
    den(192) = den(116)*den(191)
    den(193) = den(31)*den(154)
    den(194) = den(31)*den(156)
    den(195) = den(35)*den(154)
    den(196) = den(35)*den(156)
    den(197) = den(40)*den(147)
    den(198) = den(42)*den(147)
    den(199) = den(40)*den(150)
    den(200) = den(42)*den(150)
    den(201) = den(2)*den(191)
    den(202) = den(31)*den(201)
    den(203) = den(8)*den(191)
    den(204) = den(31)*den(203)
    den(205) = den(35)*den(201)
    den(206) = den(35)*den(203)
    den(207) = den(1)*den(191)
    den(208) = den(40)*den(207)
    den(209) = den(42)*den(207)
    den(210) = den(11)*den(191)
    den(211) = den(40)*den(210)
    den(212) = den(42)*den(210)
    den(213) = den(17)*den(153)
    den(214) = den(31)*den(213)
    den(215) = den(19)*den(153)
    den(216) = den(31)*den(215)
    den(217) = den(35)*den(213)
    den(218) = den(35)*den(215)
    den(219) = den(6)*den(146)
    den(220) = den(40)*den(219)
    den(221) = den(42)*den(219)
    den(222) = den(12)*den(146)
    den(223) = den(40)*den(222)
    den(224) = den(42)*den(222)
    den(225) = den(31)*den(131)
    den(226) = den(17)*den(225)
    den(227) = den(19)*den(225)
    den(228) = den(35)*den(131)
    den(229) = den(17)*den(228)
    den(230) = den(19)*den(228)
    den(231) = den(40)*den(138)
    den(232) = den(6)*den(231)
    den(233) = den(42)*den(138)
    den(234) = den(6)*den(233)
    den(235) = den(12)*den(231)
    den(236) = den(12)*den(233)
    den(238) = den(58)*den(237)
    den(239) = den(169)*den(238)
    den(241) = den(58)*den(240)
    den(242) = den(169)*den(241)
    den(243) = den(65)*den(237)
    den(244) = den(169)*den(243)
    den(245) = den(65)*den(240)
    den(246) = den(169)*den(245)
    den(247) = den(69)*den(237)
    den(248) = den(169)*den(247)
    den(249) = den(69)*den(240)
    den(250) = den(169)*den(249)
    den(251) = den(72)*den(237)
    den(252) = den(169)*den(251)
    den(253) = den(72)*den(240)
    den(254) = den(169)*den(253)
    den(255) = den(191)*den(238)
    den(256) = den(191)*den(241)
    den(257) = den(191)*den(243)
    den(258) = den(191)*den(245)
    den(259) = den(191)*den(247)
    den(260) = den(191)*den(249)
    den(261) = den(191)*den(251)
    den(262) = den(191)*den(253)
    den(263) = den(86)*den(237)
    den(264) = den(169)*den(263)
    den(265) = den(86)*den(240)
    den(266) = den(169)*den(265)
    den(267) = den(89)*den(237)
    den(268) = den(169)*den(267)
    den(269) = den(89)*den(240)
    den(270) = den(169)*den(269)
    den(271) = den(93)*den(237)
    den(272) = den(169)*den(271)
    den(273) = den(95)*den(237)
    den(274) = den(169)*den(273)
    den(275) = den(93)*den(240)
    den(276) = den(169)*den(275)
    den(277) = den(95)*den(240)
    den(278) = den(169)*den(277)
    den(279) = den(191)*den(263)
    den(280) = den(191)*den(265)
    den(281) = den(191)*den(267)
    den(282) = den(191)*den(269)
    den(283) = den(191)*den(271)
    den(284) = den(191)*den(273)
    den(285) = den(191)*den(275)
    den(286) = den(191)*den(277)
    den(288) = den(31)*den(287)
    den(289) = den(35)*den(287)
    den(290) = den(2)*den(31)
    den(292) = den(290)*den(291)
    den(293) = den(8)*den(31)
    den(294) = den(291)*den(293)
    den(295) = den(2)*den(35)
    den(296) = den(291)*den(295)
    den(297) = den(8)*den(35)
    den(298) = den(291)*den(297)
    den(299) = den(6)*den(287)
    den(300) = den(12)*den(287)
    den(301) = den(2)*den(6)
    den(303) = den(301)*den(302)
    den(304) = den(6)*den(8)
    den(305) = den(302)*den(304)
    den(306) = den(2)*den(12)
    den(307) = den(302)*den(306)
    den(308) = den(8)*den(12)
    den(309) = den(302)*den(308)
    den(311) = den(40)*den(310)
    den(312) = den(42)*den(310)
    den(313) = den(1)*den(40)
    den(314) = den(291)*den(313)
    den(315) = den(1)*den(42)
    den(316) = den(291)*den(315)
    den(317) = den(11)*den(40)
    den(318) = den(291)*den(317)
    den(319) = den(11)*den(42)
    den(320) = den(291)*den(319)
    den(321) = den(17)*den(310)
    den(322) = den(19)*den(310)
    den(323) = den(1)*den(17)
    den(324) = den(302)*den(323)
    den(325) = den(1)*den(19)
    den(326) = den(302)*den(325)
    den(327) = den(11)*den(17)
    den(328) = den(302)*den(327)
    den(329) = den(11)*den(19)
    den(330) = den(302)*den(329)
    den(331) = den(116)*den(291)
    den(332) = den(116)*den(302)
    den(333) = den(238)*den(291)
    den(334) = den(241)*den(291)
    den(335) = den(243)*den(291)
    den(336) = den(245)*den(291)
    den(337) = den(238)*den(302)
    den(338) = den(241)*den(302)
    den(339) = den(243)*den(302)
    den(340) = den(245)*den(302)
    den(341) = den(247)*den(291)
    den(342) = den(249)*den(291)
    den(343) = den(251)*den(291)
    den(344) = den(253)*den(291)
    den(345) = den(247)*den(302)
    den(346) = den(249)*den(302)
    den(347) = den(251)*den(302)
    den(348) = den(253)*den(302)
    den(349) = den(263)*den(291)
    den(350) = den(265)*den(291)
    den(351) = den(267)*den(291)
    den(352) = den(269)*den(291)
    den(353) = den(263)*den(302)
    den(354) = den(265)*den(302)
    den(355) = den(267)*den(302)
    den(356) = den(269)*den(302)
    den(357) = den(271)*den(291)
    den(358) = den(273)*den(291)
    den(359) = den(275)*den(291)
    den(360) = den(277)*den(291)
    den(361) = den(271)*den(302)
    den(362) = den(273)*den(302)
    den(363) = den(275)*den(302)
    den(364) = den(277)*den(302)
    den(365) = den(1)*den(2)*den(107)
    den(366) = den(1)*den(8)*den(107)
    den(367) = den(2)*den(11)*den(107)
    den(368) = den(8)*den(11)*den(107)
    den(369) = den(2)*den(3)*den(6)
    den(370) = den(3)*den(6)*den(8)
    den(371) = den(2)*den(3)*den(12)
    den(372) = den(3)*den(8)*den(12)
    den(373) = den(1)*den(3)*den(17)
    den(374) = den(1)*den(3)*den(19)
    den(375) = den(3)*den(11)*den(17)
    den(376) = den(3)*den(11)*den(19)
    den(377) = den(1)*den(2)*den(3)
    den(378) = den(1)*den(3)*den(8)
    den(379) = den(2)*den(3)*den(11)
    den(380) = den(3)*den(8)*den(11)
    den(381) = den(2)*den(28)*den(31)
    den(382) = den(8)*den(28)*den(31)
    den(383) = den(2)*den(28)*den(35)
    den(384) = den(8)*den(28)*den(35)
    den(385) = den(1)*den(28)*den(40)
    den(386) = den(1)*den(28)*den(42)
    den(387) = den(11)*den(28)*den(40)
    den(388) = den(11)*den(28)*den(42)
    den(389) = den(1)*den(2)*den(28)
    den(390) = den(1)*den(8)*den(28)
    den(391) = den(2)*den(11)*den(28)
    den(392) = den(8)*den(11)*den(28)
    den(393) = den(2)*den(288)
    den(394) = den(8)*den(288)
    den(395) = den(2)*den(289)
    den(396) = den(8)*den(289)
    den(397) = den(2)*den(225)
    den(398) = den(8)*den(225)
    den(399) = den(2)*den(228)
    den(400) = den(8)*den(228)
    den(401) = den(2)*den(299)
    den(402) = den(8)*den(299)
    den(403) = den(2)*den(300)
    den(404) = den(8)*den(300)
    den(405) = den(2)*den(219)
    den(406) = den(8)*den(219)
    den(407) = den(2)*den(222)
    den(408) = den(8)*den(222)
    den(409) = den(1)*den(311)
    den(410) = den(1)*den(312)
    den(411) = den(11)*den(311)
    den(412) = den(11)*den(312)
    den(413) = den(1)*den(231)
    den(414) = den(1)*den(233)
    den(415) = den(11)*den(231)
    den(416) = den(11)*den(233)
    den(417) = den(1)*den(321)
    den(418) = den(1)*den(322)
    den(419) = den(11)*den(321)
    den(420) = den(11)*den(322)
    den(421) = den(1)*den(213)
    den(422) = den(1)*den(215)
    den(423) = den(11)*den(213)
    den(424) = den(11)*den(215)
    den(425) = den(107)*den(238)
    den(426) = den(107)*den(241)
    den(427) = den(107)*den(243)
    den(428) = den(107)*den(245)
    den(429) = den(107)*den(247)
    den(430) = den(107)*den(249)
    den(431) = den(107)*den(251)
    den(432) = den(107)*den(253)
    den(433) = den(3)*den(238)
    den(434) = den(3)*den(241)
    den(435) = den(3)*den(243)
    den(436) = den(3)*den(245)
    den(437) = den(3)*den(247)
    den(438) = den(3)*den(249)
    den(439) = den(3)*den(251)
    den(440) = den(3)*den(253)
    den(441) = den(28)*den(238)
    den(442) = den(28)*den(241)
    den(443) = den(28)*den(243)
    den(444) = den(28)*den(245)
    den(445) = den(28)*den(247)
    den(446) = den(28)*den(249)
    den(447) = den(28)*den(251)
    den(448) = den(28)*den(253)
    den(449) = den(107)*den(263)
    den(450) = den(107)*den(265)
    den(451) = den(107)*den(267)
    den(452) = den(107)*den(269)
    den(453) = den(107)*den(271)
    den(454) = den(107)*den(273)
    den(455) = den(107)*den(275)
    den(456) = den(107)*den(277)
    den(457) = den(3)*den(263)
    den(458) = den(3)*den(265)
    den(459) = den(3)*den(267)
    den(460) = den(3)*den(269)
    den(461) = den(3)*den(271)
    den(462) = den(3)*den(273)
    den(463) = den(3)*den(275)
    den(464) = den(3)*den(277)
    den(465) = den(28)*den(263)
    den(466) = den(28)*den(265)
    den(467) = den(28)*den(267)
    den(468) = den(28)*den(269)
    den(469) = den(28)*den(271)
    den(470) = den(28)*den(273)
    den(471) = den(28)*den(275)
    den(472) = den(28)*den(277)
    den(473) = den(3)*den(303)
    den(474) = den(3)*den(305)
    den(475) = den(3)*den(307)
    den(476) = den(3)*den(309)
    den(477) = den(3)*den(324)
    den(478) = den(3)*den(326)
    den(479) = den(3)*den(328)
    den(480) = den(3)*den(330)
    den(481) = den(3)*den(332)
    den(482) = den(28)*den(292)
    den(483) = den(28)*den(294)
    den(484) = den(28)*den(296)
    den(485) = den(28)*den(298)
    den(486) = den(28)*den(314)
    den(487) = den(28)*den(316)
    den(488) = den(28)*den(318)
    den(489) = den(28)*den(320)
    den(490) = den(28)*den(331)
    den(491) = den(3)*den(337)
    den(492) = den(3)*den(338)
    den(493) = den(3)*den(339)
    den(494) = den(3)*den(340)
    den(495) = den(3)*den(345)
    den(496) = den(3)*den(346)
    den(497) = den(3)*den(347)
    den(498) = den(3)*den(348)
    den(499) = den(28)*den(333)
    den(500) = den(28)*den(334)
    den(501) = den(28)*den(335)
    den(502) = den(28)*den(336)
    den(503) = den(28)*den(341)
    den(504) = den(28)*den(342)
    den(505) = den(28)*den(343)
    den(506) = den(28)*den(344)
    den(507) = den(3)*den(353)
    den(508) = den(3)*den(354)
    den(509) = den(3)*den(355)
    den(510) = den(3)*den(356)
    den(511) = den(3)*den(361)
    den(512) = den(3)*den(362)
    den(513) = den(3)*den(363)
    den(514) = den(3)*den(364)
    den(515) = den(28)*den(349)
    den(516) = den(28)*den(350)
    den(517) = den(28)*den(351)
    den(518) = den(28)*den(352)
    den(519) = den(28)*den(357)
    den(520) = den(28)*den(358)
    den(521) = den(28)*den(359)
    den(522) = den(28)*den(360)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,6),wf(:,7)) * den(7)
  A(2) = cont_QA(wf(:,7),wf(:,10)) * den(10)
  A(3) = cont_QA(wf(:,6),wf(:,14)) * den(13)
  A(4) = cont_QA(wf(:,10),wf(:,14)) * den(14)
  A(5) = cont_QA(wf(:,16),wf(:,17)) * den(18)
  A(6) = cont_QA(wf(:,16),wf(:,19)) * den(20)
  A(7) = cont_QA(wf(:,17),wf(:,20)) * den(22)
  A(8) = cont_QA(wf(:,19),wf(:,20)) * den(23)
  A(9) = cont_SS(wf(:,21),wf(:,22)) * den(27)
  A(10) = cont_QA(wf(:,26),wf(:,27)) * den(32)
  A(11) = cont_QA(wf(:,27),wf(:,28)) * den(34)
  A(12) = cont_QA(wf(:,26),wf(:,30)) * den(36)
  A(13) = cont_QA(wf(:,28),wf(:,30)) * den(37)
  A(14) = cont_QA(wf(:,32),wf(:,33)) * den(41)
  A(15) = cont_QA(wf(:,32),wf(:,35)) * den(43)
  A(16) = cont_QA(wf(:,33),wf(:,36)) * den(45)
  A(17) = cont_QA(wf(:,35),wf(:,36)) * den(46)
  A(18) = cont_SS(wf(:,22),wf(:,37)) * den(48)
  A(19) = cont_QA(wf(:,17),wf(:,38)) * den(49)
  A(20) = cont_QA(wf(:,19),wf(:,38)) * den(50)
  A(21) = cont_QA(wf(:,17),wf(:,39)) * den(51)
  A(22) = cont_QA(wf(:,19),wf(:,39)) * den(52)
  A(23) = cont_QA(wf(:,7),wf(:,40)) * den(53)
  A(24) = cont_QA(wf(:,7),wf(:,41)) * den(54)
  A(25) = cont_QA(wf(:,14),wf(:,40)) * den(55)
  A(26) = cont_QA(wf(:,14),wf(:,41)) * den(56)
  A(27) = cont_VV(wf(:,43),wf(:,45)) * den(61)
  A(28) = cont_VV(wf(:,47),wf(:,48)) * den(64)
  A(29) = cont_VV(wf(:,43),wf(:,51)) * den(66)
  A(30) = cont_VV(wf(:,47),wf(:,52)) * den(67)
  A(31) = cont_VV(wf(:,43),wf(:,55)) * den(70)
  A(32) = cont_VV(wf(:,47),wf(:,56)) * den(71)
  A(33) = cont_VV(wf(:,43),wf(:,59)) * den(73)
  A(34) = cont_VV(wf(:,47),wf(:,60)) * den(74)
  A(35) = cont_VV(wf(:,45),wf(:,61)) * den(76)
  A(36) = cont_VV(wf(:,48),wf(:,63)) * den(78)
  A(37) = cont_VV(wf(:,51),wf(:,61)) * den(79)
  A(38) = cont_VV(wf(:,52),wf(:,63)) * den(80)
  A(39) = cont_VV(wf(:,55),wf(:,61)) * den(81)
  A(40) = cont_VV(wf(:,56),wf(:,63)) * den(82)
  A(41) = cont_VV(wf(:,59),wf(:,61)) * den(83)
  A(42) = cont_VV(wf(:,60),wf(:,63)) * den(84)
  A(43) = cont_VV(wf(:,43),wf(:,66)) * den(87)
  A(44) = cont_VV(wf(:,47),wf(:,67)) * den(88)
  A(45) = cont_VV(wf(:,43),wf(:,70)) * den(90)
  A(46) = cont_VV(wf(:,47),wf(:,71)) * den(91)
  A(47) = cont_VV(wf(:,43),wf(:,74)) * den(94)
  A(48) = cont_VV(wf(:,43),wf(:,77)) * den(96)
  A(49) = cont_VV(wf(:,47),wf(:,78)) * den(97)
  A(50) = cont_VV(wf(:,47),wf(:,79)) * den(98)
  A(51) = cont_VV(wf(:,61),wf(:,66)) * den(99)
  A(52) = cont_VV(wf(:,63),wf(:,67)) * den(100)
  A(53) = cont_VV(wf(:,61),wf(:,70)) * den(101)
  A(54) = cont_VV(wf(:,63),wf(:,71)) * den(102)
  A(55) = cont_VV(wf(:,61),wf(:,74)) * den(103)
  A(56) = cont_VV(wf(:,61),wf(:,77)) * den(104)
  A(57) = cont_VV(wf(:,63),wf(:,78)) * den(105)
  A(58) = cont_VV(wf(:,63),wf(:,79)) * den(106)

  A(59) = cont_VV(wf(:,80),wf(:,81)) * den(109)
  A(60) = cont_VV(wf(:,80),wf(:,82)) * den(111)
  A(61) = cont_VV(wf(:,80),wf(:,83)) * den(113)
  A(62) = cont_VV(wf(:,80),wf(:,84)) * den(114)
  A(63) = cont_SS(wf(:,22),wf(:,85)) * den(117)
  A(64) = cont_QA(wf(:,7),wf(:,86)) * den(7)
  A(65) = cont_QA(wf(:,7),wf(:,87)) * den(10)
  A(66) = cont_QA(wf(:,14),wf(:,86)) * den(13)
  A(67) = cont_QA(wf(:,14),wf(:,87)) * den(14)
  A(68) = cont_QA(wf(:,17),wf(:,88)) * den(18)
  A(69) = cont_QA(wf(:,19),wf(:,88)) * den(20)
  A(70) = cont_QA(wf(:,17),wf(:,89)) * den(22)
  A(71) = cont_QA(wf(:,19),wf(:,89)) * den(23)
  A(72) = cont_QA(wf(:,27),wf(:,90)) * den(32)
  A(73) = cont_QA(wf(:,27),wf(:,91)) * den(34)
  A(74) = cont_QA(wf(:,30),wf(:,90)) * den(36)
  A(75) = cont_QA(wf(:,30),wf(:,91)) * den(37)
  A(76) = cont_QA(wf(:,33),wf(:,92)) * den(41)
  A(77) = cont_QA(wf(:,35),wf(:,92)) * den(43)
  A(78) = cont_QA(wf(:,33),wf(:,93)) * den(45)
  A(79) = cont_QA(wf(:,35),wf(:,93)) * den(46)
  A(80) = cont_QA(wf(:,17),wf(:,94)) * den(49)
  A(81) = cont_QA(wf(:,19),wf(:,94)) * den(50)
  A(82) = cont_QA(wf(:,17),wf(:,95)) * den(51)
  A(83) = cont_QA(wf(:,19),wf(:,95)) * den(52)
  A(84) = cont_VV(wf(:,96),wf(:,97)) * den(120)
  A(85) = cont_VV(wf(:,96),wf(:,98)) * den(121)
  A(86) = cont_QA(wf(:,7),wf(:,99)) * den(53)
  A(87) = cont_QA(wf(:,7),wf(:,100)) * den(54)
  A(88) = cont_QA(wf(:,14),wf(:,99)) * den(55)
  A(89) = cont_QA(wf(:,14),wf(:,100)) * den(56)
  A(90) = cont_VV(wf(:,96),wf(:,101)) * den(122)
  A(91) = cont_VV(wf(:,96),wf(:,102)) * den(123)
  A(92) = cont_VV(wf(:,103),wf(:,104)) * den(126)
  A(93) = cont_VV(wf(:,103),wf(:,105)) * den(127)
  A(94) = cont_VV(wf(:,103),wf(:,106)) * den(128)
  A(95) = cont_VV(wf(:,103),wf(:,107)) * den(129)
  A(96) = cont_SS(wf(:,22),wf(:,108)) * den(130)
  A(97) = cont_QA(wf(:,109),wf(:,110)) * den(133)
  A(98) = cont_QA(wf(:,110),wf(:,111)) * den(134)
  A(99) = cont_QA(wf(:,109),wf(:,112)) * den(136)
  A(100) = cont_QA(wf(:,111),wf(:,112)) * den(137)
  A(101) = cont_QA(wf(:,113),wf(:,114)) * den(140)
  A(102) = cont_QA(wf(:,113),wf(:,115)) * den(142)
  A(103) = cont_QA(wf(:,114),wf(:,116)) * den(143)
  A(104) = cont_QA(wf(:,115),wf(:,116)) * den(144)
  A(105) = cont_QA(wf(:,38),wf(:,117)) * den(49)
  A(106) = cont_QA(wf(:,38),wf(:,118)) * den(50)
  A(107) = cont_QA(wf(:,39),wf(:,117)) * den(51)
  A(108) = cont_QA(wf(:,39),wf(:,118)) * den(52)
  A(109) = cont_QA(wf(:,40),wf(:,119)) * den(53)
  A(110) = cont_QA(wf(:,41),wf(:,119)) * den(54)
  A(111) = cont_QA(wf(:,40),wf(:,120)) * den(55)
  A(112) = cont_QA(wf(:,41),wf(:,120)) * den(56)
  A(113) = cont_QA(wf(:,27),wf(:,123)) * den(32)
  A(114) = cont_QA(wf(:,27),wf(:,124)) * den(34)
  A(115) = cont_QA(wf(:,30),wf(:,123)) * den(36)
  A(116) = cont_QA(wf(:,30),wf(:,124)) * den(37)
  A(117) = cont_QA(wf(:,33),wf(:,125)) * den(41)
  A(118) = cont_QA(wf(:,35),wf(:,125)) * den(43)
  A(119) = cont_QA(wf(:,33),wf(:,126)) * den(45)
  A(120) = cont_QA(wf(:,35),wf(:,126)) * den(46)
  A(121) = cont_SS(wf(:,22),wf(:,127)) * den(48)
  A(122) = cont_SS(wf(:,22),wf(:,128)) * den(145)
  A(123) = cont_QA(wf(:,129),wf(:,130)) * den(148)
  A(124) = cont_QA(wf(:,130),wf(:,131)) * den(149)
  A(125) = cont_QA(wf(:,129),wf(:,132)) * den(151)
  A(126) = cont_QA(wf(:,131),wf(:,132)) * den(152)
  A(127) = cont_QA(wf(:,133),wf(:,134)) * den(155)
  A(128) = cont_QA(wf(:,133),wf(:,135)) * den(157)
  A(129) = cont_QA(wf(:,134),wf(:,136)) * den(158)
  A(130) = cont_QA(wf(:,135),wf(:,136)) * den(159)
  A(131) = cont_QA(wf(:,7),wf(:,138)) * den(53)
  A(132) = cont_QA(wf(:,7),wf(:,140)) * den(54)
  A(133) = cont_QA(wf(:,14),wf(:,138)) * den(55)
  A(134) = cont_QA(wf(:,14),wf(:,140)) * den(56)
  A(135) = cont_QA(wf(:,17),wf(:,142)) * den(49)
  A(136) = cont_QA(wf(:,19),wf(:,142)) * den(50)
  A(137) = cont_QA(wf(:,17),wf(:,144)) * den(51)
  A(138) = cont_QA(wf(:,19),wf(:,144)) * den(52)
  A(139) = cont_QA(wf(:,7),wf(:,147)) * den(7)
  A(140) = cont_QA(wf(:,7),wf(:,148)) * den(10)
  A(141) = cont_QA(wf(:,14),wf(:,147)) * den(13)
  A(142) = cont_QA(wf(:,14),wf(:,148)) * den(14)
  A(143) = cont_QA(wf(:,17),wf(:,149)) * den(18)
  A(144) = cont_QA(wf(:,19),wf(:,149)) * den(20)
  A(145) = cont_QA(wf(:,17),wf(:,150)) * den(22)
  A(146) = cont_QA(wf(:,19),wf(:,150)) * den(23)
  A(147) = cont_SS(wf(:,22),wf(:,151)) * den(27)
  A(148) = cont_VV(wf(:,48),wf(:,153)) * den(161)
  A(149) = cont_VV(wf(:,52),wf(:,153)) * den(162)
  A(150) = cont_VV(wf(:,56),wf(:,153)) * den(163)
  A(151) = cont_VV(wf(:,60),wf(:,153)) * den(164)
  A(152) = cont_VV(wf(:,45),wf(:,154)) * den(61)
  A(153) = cont_VV(wf(:,48),wf(:,156)) * den(64)
  A(154) = cont_VV(wf(:,51),wf(:,154)) * den(66)
  A(155) = cont_VV(wf(:,52),wf(:,156)) * den(67)
  A(156) = cont_VV(wf(:,55),wf(:,154)) * den(70)
  A(157) = cont_VV(wf(:,56),wf(:,156)) * den(71)
  A(158) = cont_VV(wf(:,59),wf(:,154)) * den(73)
  A(159) = cont_VV(wf(:,60),wf(:,156)) * den(74)
  A(160) = cont_VV(wf(:,45),wf(:,157)) * den(76)
  A(161) = cont_VV(wf(:,48),wf(:,159)) * den(78)
  A(162) = cont_VV(wf(:,51),wf(:,157)) * den(79)
  A(163) = cont_VV(wf(:,52),wf(:,159)) * den(80)
  A(164) = cont_VV(wf(:,55),wf(:,157)) * den(81)
  A(165) = cont_VV(wf(:,56),wf(:,159)) * den(82)
  A(166) = cont_VV(wf(:,59),wf(:,157)) * den(83)
  A(167) = cont_VV(wf(:,60),wf(:,159)) * den(84)
  A(168) = cont_VV(wf(:,45),wf(:,160)) * den(76)
  A(169) = cont_VV(wf(:,48),wf(:,162)) * den(78)
  A(170) = cont_VV(wf(:,51),wf(:,160)) * den(79)
  A(171) = cont_VV(wf(:,52),wf(:,162)) * den(80)
  A(172) = cont_VV(wf(:,55),wf(:,160)) * den(81)
  A(173) = cont_VV(wf(:,56),wf(:,162)) * den(82)
  A(174) = cont_VV(wf(:,59),wf(:,160)) * den(83)
  A(175) = cont_VV(wf(:,60),wf(:,162)) * den(84)
  A(176) = cont_VV(wf(:,45),wf(:,163)) * den(61)
  A(177) = cont_VV(wf(:,48),wf(:,165)) * den(64)
  A(178) = cont_VV(wf(:,51),wf(:,163)) * den(66)
  A(179) = cont_VV(wf(:,52),wf(:,165)) * den(67)
  A(180) = cont_VV(wf(:,55),wf(:,163)) * den(70)
  A(181) = cont_VV(wf(:,56),wf(:,165)) * den(71)
  A(182) = cont_VV(wf(:,59),wf(:,163)) * den(73)
  A(183) = cont_VV(wf(:,60),wf(:,165)) * den(74)
  A(184) = cont_VV(wf(:,67),wf(:,153)) * den(165)
  A(185) = cont_VV(wf(:,71),wf(:,153)) * den(166)
  A(186) = cont_VV(wf(:,78),wf(:,153)) * den(167)
  A(187) = cont_VV(wf(:,79),wf(:,153)) * den(168)
  A(188) = cont_VV(wf(:,66),wf(:,154)) * den(87)
  A(189) = cont_VV(wf(:,67),wf(:,156)) * den(88)
  A(190) = cont_VV(wf(:,70),wf(:,154)) * den(90)
  A(191) = cont_VV(wf(:,71),wf(:,156)) * den(91)
  A(192) = cont_VV(wf(:,74),wf(:,154)) * den(94)
  A(193) = cont_VV(wf(:,77),wf(:,154)) * den(96)
  A(194) = cont_VV(wf(:,78),wf(:,156)) * den(97)
  A(195) = cont_VV(wf(:,79),wf(:,156)) * den(98)
  A(196) = cont_VV(wf(:,66),wf(:,157)) * den(99)
  A(197) = cont_VV(wf(:,67),wf(:,159)) * den(100)
  A(198) = cont_VV(wf(:,70),wf(:,157)) * den(101)
  A(199) = cont_VV(wf(:,71),wf(:,159)) * den(102)
  A(200) = cont_VV(wf(:,74),wf(:,157)) * den(103)
  A(201) = cont_VV(wf(:,77),wf(:,157)) * den(104)
  A(202) = cont_VV(wf(:,78),wf(:,159)) * den(105)
  A(203) = cont_VV(wf(:,79),wf(:,159)) * den(106)
  A(204) = cont_VV(wf(:,66),wf(:,160)) * den(99)
  A(205) = cont_VV(wf(:,67),wf(:,162)) * den(100)
  A(206) = cont_VV(wf(:,70),wf(:,160)) * den(101)
  A(207) = cont_VV(wf(:,71),wf(:,162)) * den(102)
  A(208) = cont_VV(wf(:,74),wf(:,160)) * den(103)
  A(209) = cont_VV(wf(:,77),wf(:,160)) * den(104)
  A(210) = cont_VV(wf(:,78),wf(:,162)) * den(105)
  A(211) = cont_VV(wf(:,79),wf(:,162)) * den(106)
  A(212) = cont_VV(wf(:,66),wf(:,163)) * den(87)
  A(213) = cont_VV(wf(:,67),wf(:,165)) * den(88)
  A(214) = cont_VV(wf(:,70),wf(:,163)) * den(90)
  A(215) = cont_VV(wf(:,71),wf(:,165)) * den(91)
  A(216) = cont_VV(wf(:,74),wf(:,163)) * den(94)
  A(217) = cont_VV(wf(:,77),wf(:,163)) * den(96)
  A(218) = cont_VV(wf(:,78),wf(:,165)) * den(97)
  A(219) = cont_VV(wf(:,79),wf(:,165)) * den(98)
  A(220) = cont_SS(wf(:,22),wf(:,168)) * den(170)
  A(221) = cont_QA(wf(:,7),wf(:,169)) * den(172)
  A(222) = cont_QA(wf(:,7),wf(:,170)) * den(174)
  A(223) = cont_QA(wf(:,14),wf(:,169)) * den(175)
  A(224) = cont_QA(wf(:,14),wf(:,170)) * den(176)
  A(225) = cont_QA(wf(:,17),wf(:,171)) * den(178)
  A(226) = cont_QA(wf(:,19),wf(:,171)) * den(179)
  A(227) = cont_QA(wf(:,17),wf(:,172)) * den(181)
  A(228) = cont_QA(wf(:,19),wf(:,172)) * den(182)
  A(229) = cont_QA(wf(:,114),wf(:,173)) * den(183)
  A(230) = cont_QA(wf(:,115),wf(:,173)) * den(184)
  A(231) = cont_QA(wf(:,114),wf(:,174)) * den(185)
  A(232) = cont_QA(wf(:,115),wf(:,174)) * den(186)
  A(233) = cont_QA(wf(:,110),wf(:,175)) * den(187)
  A(234) = cont_QA(wf(:,110),wf(:,176)) * den(188)
  A(235) = cont_QA(wf(:,112),wf(:,175)) * den(189)
  A(236) = cont_QA(wf(:,112),wf(:,176)) * den(190)
  A(237) = cont_SS(wf(:,22),wf(:,179)) * den(192)
  A(238) = cont_QA(wf(:,134),wf(:,180)) * den(193)
  A(239) = cont_QA(wf(:,135),wf(:,180)) * den(194)
  A(240) = cont_QA(wf(:,134),wf(:,181)) * den(195)
  A(241) = cont_QA(wf(:,135),wf(:,181)) * den(196)
  A(242) = cont_QA(wf(:,130),wf(:,182)) * den(197)
  A(243) = cont_QA(wf(:,130),wf(:,183)) * den(198)
  A(244) = cont_QA(wf(:,132),wf(:,182)) * den(199)
  A(245) = cont_QA(wf(:,132),wf(:,183)) * den(200)
  A(246) = cont_QA(wf(:,27),wf(:,184)) * den(202)
  A(247) = cont_QA(wf(:,27),wf(:,185)) * den(204)
  A(248) = cont_QA(wf(:,30),wf(:,184)) * den(205)
  A(249) = cont_QA(wf(:,30),wf(:,185)) * den(206)
  A(250) = cont_QA(wf(:,33),wf(:,186)) * den(208)
  A(251) = cont_QA(wf(:,35),wf(:,186)) * den(209)
  A(252) = cont_QA(wf(:,33),wf(:,187)) * den(211)
  A(253) = cont_QA(wf(:,35),wf(:,187)) * den(212)
  A(254) = cont_QA(wf(:,180),wf(:,189)) * den(214)
  A(255) = cont_QA(wf(:,180),wf(:,191)) * den(216)
  A(256) = cont_QA(wf(:,181),wf(:,189)) * den(217)
  A(257) = cont_QA(wf(:,181),wf(:,191)) * den(218)
  A(258) = cont_QA(wf(:,182),wf(:,193)) * den(220)
  A(259) = cont_QA(wf(:,183),wf(:,193)) * den(221)
  A(260) = cont_QA(wf(:,182),wf(:,195)) * den(223)
  A(261) = cont_QA(wf(:,183),wf(:,195)) * den(224)
  A(262) = cont_QA(wf(:,175),wf(:,196)) * den(226)
  A(263) = cont_QA(wf(:,176),wf(:,196)) * den(227)
  A(264) = cont_QA(wf(:,175),wf(:,197)) * den(229)
  A(265) = cont_QA(wf(:,176),wf(:,197)) * den(230)
  A(266) = cont_QA(wf(:,173),wf(:,198)) * den(232)
  A(267) = cont_QA(wf(:,173),wf(:,199)) * den(234)
  A(268) = cont_QA(wf(:,174),wf(:,198)) * den(235)
  A(269) = cont_QA(wf(:,174),wf(:,199)) * den(236)
  A(270) = cont_VV(wf(:,45),wf(:,200)) * den(239)
  A(271) = cont_VV(wf(:,201),wf(:,202)) * den(242)
  A(272) = cont_VV(wf(:,51),wf(:,200)) * den(244)
  A(273) = cont_VV(wf(:,201),wf(:,203)) * den(246)
  A(274) = cont_VV(wf(:,55),wf(:,200)) * den(248)
  A(275) = cont_VV(wf(:,201),wf(:,204)) * den(250)
  A(276) = cont_VV(wf(:,59),wf(:,200)) * den(252)
  A(277) = cont_VV(wf(:,201),wf(:,205)) * den(254)
  A(278) = cont_VV(wf(:,45),wf(:,206)) * den(255)
  A(279) = cont_VV(wf(:,202),wf(:,207)) * den(256)
  A(280) = cont_VV(wf(:,51),wf(:,206)) * den(257)
  A(281) = cont_VV(wf(:,203),wf(:,207)) * den(258)
  A(282) = cont_VV(wf(:,55),wf(:,206)) * den(259)
  A(283) = cont_VV(wf(:,204),wf(:,207)) * den(260)
  A(284) = cont_VV(wf(:,59),wf(:,206)) * den(261)
  A(285) = cont_VV(wf(:,205),wf(:,207)) * den(262)
  A(286) = cont_VV(wf(:,66),wf(:,200)) * den(264)
  A(287) = cont_VV(wf(:,201),wf(:,208)) * den(266)
  A(288) = cont_VV(wf(:,70),wf(:,200)) * den(268)
  A(289) = cont_VV(wf(:,201),wf(:,209)) * den(270)
  A(290) = cont_VV(wf(:,74),wf(:,200)) * den(272)
  A(291) = cont_VV(wf(:,77),wf(:,200)) * den(274)
  A(292) = cont_VV(wf(:,201),wf(:,210)) * den(276)
  A(293) = cont_VV(wf(:,201),wf(:,211)) * den(278)
  A(294) = cont_VV(wf(:,66),wf(:,206)) * den(279)
  A(295) = cont_VV(wf(:,207),wf(:,208)) * den(280)
  A(296) = cont_VV(wf(:,70),wf(:,206)) * den(281)
  A(297) = cont_VV(wf(:,207),wf(:,209)) * den(282)
  A(298) = cont_VV(wf(:,74),wf(:,206)) * den(283)
  A(299) = cont_VV(wf(:,77),wf(:,206)) * den(284)
  A(300) = cont_VV(wf(:,207),wf(:,210)) * den(285)
  A(301) = cont_VV(wf(:,207),wf(:,211)) * den(286)


  ! colour vectors

  M1(1) = (A(1)+A(5)+A(10)+A(14)+A(19)+A(23))*f(1)+(A(2)+A(3)+A(6)+A(7)+A(11)+A(12)+A(15)+A(16)+A(20)+A(21)+A(24)+A(25)+A(27) &
       +A(29)+A(31)+A(33)+A(35)+A(37)+A(39)+A(41)+A(43)+A(45)+A(47)+A(48)+A(51)+A(53)+A(55)+A(56))*f(2)+(A(4)+A(8)+A(13)+A(17) &
       +A(22)+A(26)+A(28)+A(30)+A(32)+A(34)+A(36)+A(38)+A(40)+A(42)+A(44)+A(46)+A(49)+A(50)+A(52)+A(54)+A(57)+A(58))*f(3)+(-A(9) &
       -A(18))*f(18)

  M2(1) = (-A(221)-A(225)-A(229)-A(233)-A(238)-A(242)-A(246)-A(250)-A(254)-A(258)-A(262)-A(266))*f(4)+(-A(222)-A(223)-A(226) &
       -A(227)-A(230)-A(231)-A(234)-A(235)-A(239)-A(240)-A(243)-A(244)-A(247)-A(248)-A(251)-A(252)-A(255)-A(256)-A(259)-A(260) &
       -A(263)-A(264)-A(267)-A(268)-A(270)-A(272)-A(274)-A(276)-A(278)-A(280)-A(282)-A(284)-A(286)-A(288)-A(290)-A(291)-A(294) &
       -A(296)-A(298)-A(299))*f(5)+(-A(224)-A(228)-A(232)-A(236)-A(241)-A(245)-A(249)-A(253)-A(257)-A(261)-A(265)-A(269)-A(271) &
       -A(273)-A(275)-A(277)-A(279)-A(281)-A(283)-A(285)-A(287)-A(289)-A(292)-A(293)-A(295)-A(297)-A(300)-A(301))*f(6)+A(59)*f(7) &
       +(A(60)+A(61))*f(8)+(A(80)+A(86)+A(113)+A(117)+A(139)+A(143))*f(9)+(A(81)+A(82)+A(87)+A(88)+A(114)+A(115)+A(118)+A(119) &
       +A(140)+A(141)+A(144)+A(145)+A(160)+A(162)+A(164)+A(166)+A(176)+A(178)+A(180)+A(182)+A(196)+A(198)+A(200)+A(201)+A(212) &
       +A(214)+A(216)+A(217))*f(10)+(A(83)+A(89)+A(116)+A(120)+A(142)+A(146)+A(161)+A(163)+A(165)+A(167)+A(177)+A(179)+A(181) &
       +A(183)+A(197)+A(199)+A(202)+A(203)+A(213)+A(215)+A(218)+A(219))*f(11)+(A(64)+A(68)+A(72)+A(76)+A(97)+A(101)+A(105)+A(109) &
       +A(123)+A(127)+A(131)+A(135))*f(12)+(A(65)+A(66)+A(69)+A(70)+A(73)+A(74)+A(77)+A(78)+A(98)+A(99)+A(102)+A(103)+A(106) &
       +A(107)+A(110)+A(111)+A(124)+A(125)+A(128)+A(129)+A(132)+A(133)+A(136)+A(137)+A(152)+A(154)+A(156)+A(158)+A(168)+A(170) &
       +A(172)+A(174)+A(188)+A(190)+A(192)+A(193)+A(204)+A(206)+A(208)+A(209))*f(13)+(A(67)+A(71)+A(75)+A(79)+A(100)+A(104)+A(108) &
       +A(112)+A(126)+A(130)+A(134)+A(138)+A(153)+A(155)+A(157)+A(159)+A(169)+A(171)+A(173)+A(175)+A(189)+A(191)+A(194)+A(195) &
       +A(205)+A(207)+A(210)+A(211))*f(14)+(-A(84)-A(90)-A(92)-A(94))*f(15)+(-A(85)-A(91)-A(93)-A(95)-A(148)-A(149)-A(150)-A(151) &
       -A(184)-A(185)-A(186)-A(187))*f(16)+A(62)*f(17)+(A(220)+A(237))*f(19)+(-A(121)-A(147))*f(20)+(-A(96)-A(122))*f(21) &
       -A(63)*f(22)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_eexmmxbbxg_1_/**/REALKIND
