
module ol_colourmatrix_ppllllj_eeexexddxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_eeexexddxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_eeexexddxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_eeexexddxg_1_/**/REALKIND

module ol_loop_ppllllj_eeexexddxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(35), c(20)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:560)
  ! denominators
  complex(REALKIND), save :: den(997)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD)/9._/**/REALKIND
    f( 2) = (CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 3) = CI*eQED**4*gQCD
    f( 4) = (CI*countertermnorm*eQED**4*gQCD**3)/9._/**/REALKIND
    f( 5) = (CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**4*gQCD**3
    f( 7) = CI*countertermnorm*ctAAGG*eQED**4*gQCD**3
    f( 8) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 9) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/9._/**/REALKIND
    f(10) = (CI*countertermnorm*ctGqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctGqq*eQED**4*gQCD**3
    f(12) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/9._/**/REALKIND
    f(13) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**3)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVqq*eQED**4*gQCD**3
    f(15) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(16) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(17) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(18) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(19) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(20) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(21) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(22) = (eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(23) = (eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(24) = eQED**4*gQCD**3*integralnorm*SwB
    f(25) = (eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(26) = (2*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(27) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(28) = (4*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(29) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(30) = (8*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(31) = eQED**4*gQCD**3*integralnorm*SwF
    f(32) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(33) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(34) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(35) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(19), 9*CI*f(20), 9*CI*f(21), f(22), 8*f(22), f(23), 8*f(23), f(24), 8*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28) &
    , 3*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(586)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_Q(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_A(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rZERO, H(5), wf(:,-4))
  call wf_A(P(:,6), rZERO, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_Q_A(wf(:,3),Q(:,80),ZERO,0_intkind1,wf(:,4))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,5))
  call vert_VQ_A(wf(:,2),wf(:,4),wf(:,6))
  call prop_A_Q(wf(:,5),Q(:,37),ZERO,0_intkind1,wf(:,7))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-3),wf(:,8))
  call prop_W_W(wf(:,8),Q(:,10),MZ,1_intkind1,wf(:,9))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,4),wf(:,10))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-2),wf(:,11))
  call prop_W_W(wf(:,11),Q(:,5),MZ,1_intkind1,wf(:,12))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,12),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,37),ZERO,0_intkind1,wf(:,14))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,15))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,16))
  call prop_A_Q(wf(:,15),Q(:,42),ZERO,0_intkind1,wf(:,17))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,9),wf(:,18))
  call prop_A_Q(wf(:,18),Q(:,42),ZERO,0_intkind1,wf(:,19))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,4),wf(:,20))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,21))
  call prop_A_Q(wf(:,21),Q(:,96),ZERO,0_intkind1,wf(:,22))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,23))
  call vert_AV_Q(wf(:,22),wf(:,2),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,21),ZERO,0_intkind1,wf(:,25))
  call vert_AZ_Q(gZd,wf(:,22),wf(:,9),wf(:,26))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,-4),wf(:,27))
  call prop_Q_A(wf(:,27),Q(:,21),ZERO,0_intkind1,wf(:,28))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,29))
  call vert_AV_Q(wf(:,22),wf(:,1),wf(:,30))
  call prop_Q_A(wf(:,29),Q(:,26),ZERO,0_intkind1,wf(:,31))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,-4),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,26),ZERO,0_intkind1,wf(:,33))
  call vert_AZ_Q(gZd,wf(:,22),wf(:,12),wf(:,34))
  call vert_VQ_A(wf(:,-6),wf(:,25),wf(:,35))
  call vert_VQ_A(wf(:,-6),wf(:,28),wf(:,36))
  call vert_VQ_A(wf(:,-6),wf(:,31),wf(:,37))
  call vert_VQ_A(wf(:,-6),wf(:,33),wf(:,38))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,39))
  call vert_QA_V(wf(:,4),wf(:,-5),wf(:,40))
  call prop_Q_A(wf(:,39),Q(:,7),ZERO,0_intkind1,wf(:,41))
  call vert_QA_V(wf(:,41),wf(:,-3),wf(:,42))
  call vert_QA_Z(gZd,wf(:,4),wf(:,-5),wf(:,43))
  call prop_W_W(wf(:,43),Q(:,112),MZ,1_intkind1,wf(:,44))
  call vert_QA_Z(gZl,wf(:,41),wf(:,-3),wf(:,45))
  call vert_ZQ_A(gZl,wf(:,12),wf(:,-1),wf(:,46))
  call prop_Q_A(wf(:,46),Q(:,7),ZERO,0_intkind1,wf(:,47))
  call vert_QA_V(wf(:,47),wf(:,-3),wf(:,48))
  call vert_QA_Z(gZl,wf(:,47),wf(:,-3),wf(:,49))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,50))
  call prop_A_Q(wf(:,50),Q(:,13),ZERO,0_intkind1,wf(:,51))
  call vert_QA_V(wf(:,-1),wf(:,51),wf(:,52))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,51),wf(:,53))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,12),wf(:,54))
  call prop_A_Q(wf(:,54),Q(:,13),ZERO,0_intkind1,wf(:,55))
  call vert_QA_V(wf(:,-1),wf(:,55),wf(:,56))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,55),wf(:,57))
  call vert_QA_V(wf(:,-4),wf(:,22),wf(:,58))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,22),wf(:,59))
  call prop_W_W(wf(:,59),Q(:,112),MZ,1_intkind1,wf(:,60))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,61))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,62))
  call vert_AV_Q(wf(:,-5),wf(:,61),wf(:,63))
  call vert_VQ_A(wf(:,62),wf(:,4),wf(:,64))
  call prop_A_Q(wf(:,63),Q(:,41),ZERO,0_intkind1,wf(:,65))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-2),wf(:,66))
  call prop_W_W(wf(:,66),Q(:,6),MZ,1_intkind1,wf(:,67))
  call vert_ZQ_A(gZd,wf(:,67),wf(:,4),wf(:,68))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-3),wf(:,69))
  call prop_W_W(wf(:,69),Q(:,9),MZ,1_intkind1,wf(:,70))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,70),wf(:,71))
  call prop_A_Q(wf(:,71),Q(:,41),ZERO,0_intkind1,wf(:,72))
  call vert_AV_Q(wf(:,-5),wf(:,62),wf(:,73))
  call vert_VQ_A(wf(:,61),wf(:,4),wf(:,74))
  call prop_A_Q(wf(:,73),Q(:,38),ZERO,0_intkind1,wf(:,75))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,67),wf(:,76))
  call prop_A_Q(wf(:,76),Q(:,38),ZERO,0_intkind1,wf(:,77))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,4),wf(:,78))
  call vert_VQ_A(wf(:,61),wf(:,-4),wf(:,79))
  call vert_AV_Q(wf(:,22),wf(:,62),wf(:,80))
  call prop_Q_A(wf(:,79),Q(:,25),ZERO,0_intkind1,wf(:,81))
  call vert_AZ_Q(gZd,wf(:,22),wf(:,67),wf(:,82))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,-4),wf(:,83))
  call prop_Q_A(wf(:,83),Q(:,25),ZERO,0_intkind1,wf(:,84))
  call vert_VQ_A(wf(:,62),wf(:,-4),wf(:,85))
  call vert_AV_Q(wf(:,22),wf(:,61),wf(:,86))
  call prop_Q_A(wf(:,85),Q(:,22),ZERO,0_intkind1,wf(:,87))
  call vert_ZQ_A(gZd,wf(:,67),wf(:,-4),wf(:,88))
  call prop_Q_A(wf(:,88),Q(:,22),ZERO,0_intkind1,wf(:,89))
  call vert_AZ_Q(gZd,wf(:,22),wf(:,70),wf(:,90))
  call vert_VQ_A(wf(:,-6),wf(:,81),wf(:,91))
  call vert_VQ_A(wf(:,-6),wf(:,84),wf(:,92))
  call vert_VQ_A(wf(:,-6),wf(:,87),wf(:,93))
  call vert_VQ_A(wf(:,-6),wf(:,89),wf(:,94))
  call vert_VQ_A(wf(:,62),wf(:,0),wf(:,95))
  call prop_Q_A(wf(:,95),Q(:,7),ZERO,0_intkind1,wf(:,96))
  call vert_QA_V(wf(:,96),wf(:,-3),wf(:,97))
  call vert_QA_Z(gZl,wf(:,96),wf(:,-3),wf(:,98))
  call vert_ZQ_A(gZl,wf(:,67),wf(:,0),wf(:,99))
  call prop_Q_A(wf(:,99),Q(:,7),ZERO,0_intkind1,wf(:,100))
  call vert_QA_V(wf(:,100),wf(:,-3),wf(:,101))
  call vert_QA_Z(gZl,wf(:,100),wf(:,-3),wf(:,102))
  call vert_AV_Q(wf(:,-3),wf(:,62),wf(:,103))
  call prop_A_Q(wf(:,103),Q(:,14),ZERO,0_intkind1,wf(:,104))
  call vert_QA_V(wf(:,0),wf(:,104),wf(:,105))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,67),wf(:,106))
  call prop_A_Q(wf(:,106),Q(:,14),ZERO,0_intkind1,wf(:,107))
  call vert_QA_V(wf(:,0),wf(:,107),wf(:,108))
  call vert_QA_Z(gZl,wf(:,0),wf(:,104),wf(:,109))
  call vert_QA_Z(gZl,wf(:,0),wf(:,107),wf(:,110))
  call vert_VQ_A(wf(:,61),wf(:,-1),wf(:,111))
  call prop_Q_A(wf(:,111),Q(:,11),ZERO,0_intkind1,wf(:,112))
  call vert_QA_V(wf(:,112),wf(:,-2),wf(:,113))
  call vert_QA_Z(gZl,wf(:,112),wf(:,-2),wf(:,114))
  call vert_ZQ_A(gZl,wf(:,70),wf(:,-1),wf(:,115))
  call prop_Q_A(wf(:,115),Q(:,11),ZERO,0_intkind1,wf(:,116))
  call vert_QA_V(wf(:,116),wf(:,-2),wf(:,117))
  call vert_QA_Z(gZl,wf(:,116),wf(:,-2),wf(:,118))
  call vert_AV_Q(wf(:,-2),wf(:,61),wf(:,119))
  call prop_A_Q(wf(:,119),Q(:,13),ZERO,0_intkind1,wf(:,120))
  call vert_QA_V(wf(:,-1),wf(:,120),wf(:,121))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,120),wf(:,122))
  call vert_AZ_Q(gZl,wf(:,-2),wf(:,70),wf(:,123))
  call prop_A_Q(wf(:,123),Q(:,13),ZERO,0_intkind1,wf(:,124))
  call vert_QA_V(wf(:,-1),wf(:,124),wf(:,125))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,124),wf(:,126))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,127))
  call prop_Q_A(wf(:,127),Q(:,11),ZERO,0_intkind1,wf(:,128))
  call vert_QA_V(wf(:,128),wf(:,-2),wf(:,129))
  call vert_QA_Z(gZl,wf(:,128),wf(:,-2),wf(:,130))
  call vert_ZQ_A(gZl,wf(:,9),wf(:,0),wf(:,131))
  call prop_Q_A(wf(:,131),Q(:,11),ZERO,0_intkind1,wf(:,132))
  call vert_QA_V(wf(:,132),wf(:,-2),wf(:,133))
  call vert_QA_Z(gZl,wf(:,132),wf(:,-2),wf(:,134))
  call vert_AV_Q(wf(:,-2),wf(:,2),wf(:,135))
  call prop_A_Q(wf(:,135),Q(:,14),ZERO,0_intkind1,wf(:,136))
  call vert_QA_V(wf(:,0),wf(:,136),wf(:,137))
  call vert_AZ_Q(gZl,wf(:,-2),wf(:,9),wf(:,138))
  call prop_A_Q(wf(:,138),Q(:,14),ZERO,0_intkind1,wf(:,139))
  call vert_QA_V(wf(:,0),wf(:,139),wf(:,140))
  call vert_QA_Z(gZl,wf(:,0),wf(:,136),wf(:,141))
  call vert_QA_Z(gZl,wf(:,0),wf(:,139),wf(:,142))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,143))
  call counter_VVG_G(wf(:,1),wf(:,2),wf(:,-6),wf(:,144))
  call counter_VVG_G(wf(:,1),wf(:,9),wf(:,-6),wf(:,145))
  call counter_VVG_G(wf(:,12),wf(:,2),wf(:,-6),wf(:,146))
  call counter_VVG_G(wf(:,12),wf(:,9),wf(:,-6),wf(:,147))
  call counter_VVG_G(wf(:,62),wf(:,61),wf(:,-6),wf(:,148))
  call counter_VVG_G(wf(:,67),wf(:,61),wf(:,-6),wf(:,149))
  call counter_VVG_G(wf(:,62),wf(:,70),wf(:,-6),wf(:,150))
  call counter_VVG_G(wf(:,67),wf(:,70),wf(:,-6),wf(:,151))
  call vert_VV_S(wf(:,12),wf(:,9),wf(:,152))
  call counter_GG_S(wf(:,143),wf(:,-6),wf(:,153))
  call counter_VQ_A(wf(:,2),wf(:,4),wf(:,154))
  call counter_ZQ_A(gZd,wf(:,9),wf(:,4),wf(:,155))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,156))
  call counter_ZQ_A(gZd,wf(:,12),wf(:,4),wf(:,157))
  call counter_AV_Q(wf(:,22),wf(:,2),wf(:,158))
  call counter_AZ_Q(gZd,wf(:,22),wf(:,9),wf(:,159))
  call counter_AV_Q(wf(:,22),wf(:,1),wf(:,160))
  call counter_AZ_Q(gZd,wf(:,22),wf(:,12),wf(:,161))
  call counter_VQ_A(wf(:,-6),wf(:,25),wf(:,162))
  call counter_VQ_A(wf(:,-6),wf(:,28),wf(:,163))
  call counter_VG_G(wf(:,9),wf(:,-6),Q(:,64),wf(:,164),Q(:,74))
  call vert_QA_V(wf(:,25),wf(:,-5),wf(:,165))
  call vert_QA_V(wf(:,28),wf(:,-5),wf(:,166))
  call counter_VQ_A(wf(:,-6),wf(:,31),wf(:,167))
  call counter_VQ_A(wf(:,-6),wf(:,33),wf(:,168))
  call vert_QA_V(wf(:,-4),wf(:,7),wf(:,169))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,170))
  call counter_VG_G(wf(:,12),wf(:,-6),Q(:,64),wf(:,171),Q(:,69))
  call vert_QA_V(wf(:,31),wf(:,-5),wf(:,172))
  call vert_QA_V(wf(:,33),wf(:,-5),wf(:,173))
  call vert_QA_V(wf(:,-4),wf(:,17),wf(:,174))
  call vert_QA_V(wf(:,-4),wf(:,19),wf(:,175))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,176))
  call prop_Q_A(wf(:,16),Q(:,85),ZERO,0_intkind1,wf(:,177))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,9),wf(:,178))
  call prop_Q_A(wf(:,20),Q(:,85),ZERO,0_intkind1,wf(:,179))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,180))
  call prop_Q_A(wf(:,6),Q(:,90),ZERO,0_intkind1,wf(:,181))
  call prop_Q_A(wf(:,10),Q(:,90),ZERO,0_intkind1,wf(:,182))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,12),wf(:,183))
  call prop_A_Q(wf(:,176),Q(:,42),ZERO,0_intkind1,wf(:,184))
  call prop_A_Q(wf(:,178),Q(:,42),ZERO,0_intkind1,wf(:,185))
  call prop_A_Q(wf(:,180),Q(:,37),ZERO,0_intkind1,wf(:,186))
  call prop_A_Q(wf(:,183),Q(:,37),ZERO,0_intkind1,wf(:,187))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,188))
  call prop_A_Q(wf(:,188),Q(:,96),ZERO,0_intkind1,wf(:,189))
  call vert_AV_Q(wf(:,189),wf(:,2),wf(:,190))
  call vert_AZ_Q(gZd,wf(:,189),wf(:,9),wf(:,191))
  call vert_AV_Q(wf(:,189),wf(:,1),wf(:,192))
  call vert_AZ_Q(gZd,wf(:,189),wf(:,12),wf(:,193))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,194))
  call prop_A_Q(wf(:,30),Q(:,101),ZERO,0_intkind1,wf(:,195))
  call counter_ZQ_A(gZd,wf(:,9),wf(:,-4),wf(:,196))
  call prop_A_Q(wf(:,34),Q(:,101),ZERO,0_intkind1,wf(:,197))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,198))
  call prop_A_Q(wf(:,24),Q(:,106),ZERO,0_intkind1,wf(:,199))
  call prop_A_Q(wf(:,26),Q(:,106),ZERO,0_intkind1,wf(:,200))
  call counter_ZQ_A(gZd,wf(:,12),wf(:,-4),wf(:,201))
  call prop_Q_A(wf(:,194),Q(:,26),ZERO,0_intkind1,wf(:,202))
  call vert_VQ_A(wf(:,-6),wf(:,202),wf(:,203))
  call prop_Q_A(wf(:,196),Q(:,26),ZERO,0_intkind1,wf(:,204))
  call vert_VQ_A(wf(:,-6),wf(:,204),wf(:,205))
  call prop_Q_A(wf(:,198),Q(:,21),ZERO,0_intkind1,wf(:,206))
  call vert_VQ_A(wf(:,-6),wf(:,206),wf(:,207))
  call prop_Q_A(wf(:,201),Q(:,21),ZERO,0_intkind1,wf(:,208))
  call vert_VQ_A(wf(:,-6),wf(:,208),wf(:,209))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,210))
  call prop_Q_A(wf(:,210),Q(:,80),ZERO,0_intkind1,wf(:,211))
  call vert_VQ_A(wf(:,2),wf(:,211),wf(:,212))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,211),wf(:,213))
  call vert_VQ_A(wf(:,1),wf(:,211),wf(:,214))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,211),wf(:,215))
  call counter_GG_V(wf(:,143),Q(:,48),wf(:,-6),Q(:,64),wf(:,216))
  call prop_W_W(wf(:,216),Q(:,112),MZ,1_intkind1,wf(:,217))
  call counter_QA_V(wf(:,4),wf(:,-5),wf(:,218))
  call counter_QA_Z(gZd,wf(:,4),wf(:,-5),wf(:,219))
  call prop_W_W(wf(:,219),Q(:,112),MZ,1_intkind1,wf(:,220))
  call vert_QA_V(wf(:,-4),wf(:,189),wf(:,221))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,189),wf(:,222))
  call prop_W_W(wf(:,222),Q(:,112),MZ,1_intkind1,wf(:,223))
  call counter_QA_V(wf(:,-4),wf(:,22),wf(:,224))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,22),wf(:,225))
  call prop_W_W(wf(:,225),Q(:,112),MZ,1_intkind1,wf(:,226))
  call vert_QA_V(wf(:,211),wf(:,-5),wf(:,227))
  call vert_QA_Z(gZd,wf(:,211),wf(:,-5),wf(:,228))
  call prop_W_W(wf(:,228),Q(:,112),MZ,1_intkind1,wf(:,229))
  call vert_VV_S(wf(:,67),wf(:,70),wf(:,230))
  call counter_VQ_A(wf(:,62),wf(:,4),wf(:,231))
  call counter_ZQ_A(gZd,wf(:,67),wf(:,4),wf(:,232))
  call counter_VQ_A(wf(:,61),wf(:,4),wf(:,233))
  call counter_ZQ_A(gZd,wf(:,70),wf(:,4),wf(:,234))
  call counter_AV_Q(wf(:,22),wf(:,62),wf(:,235))
  call counter_AZ_Q(gZd,wf(:,22),wf(:,67),wf(:,236))
  call counter_AV_Q(wf(:,22),wf(:,61),wf(:,237))
  call counter_AZ_Q(gZd,wf(:,22),wf(:,70),wf(:,238))
  call counter_VQ_A(wf(:,-6),wf(:,81),wf(:,239))
  call counter_VQ_A(wf(:,-6),wf(:,84),wf(:,240))
  call counter_VG_G(wf(:,67),wf(:,-6),Q(:,64),wf(:,241),Q(:,70))
  call vert_QA_V(wf(:,81),wf(:,-5),wf(:,242))
  call vert_QA_V(wf(:,84),wf(:,-5),wf(:,243))
  call counter_VQ_A(wf(:,-6),wf(:,87),wf(:,244))
  call counter_VQ_A(wf(:,-6),wf(:,89),wf(:,245))
  call vert_QA_V(wf(:,-4),wf(:,65),wf(:,246))
  call vert_QA_V(wf(:,-4),wf(:,72),wf(:,247))
  call counter_VG_G(wf(:,70),wf(:,-6),Q(:,64),wf(:,248),Q(:,73))
  call vert_QA_V(wf(:,87),wf(:,-5),wf(:,249))
  call vert_QA_V(wf(:,89),wf(:,-5),wf(:,250))
  call vert_QA_V(wf(:,-4),wf(:,75),wf(:,251))
  call vert_QA_V(wf(:,-4),wf(:,77),wf(:,252))
  call counter_AV_Q(wf(:,-5),wf(:,62),wf(:,253))
  call prop_Q_A(wf(:,74),Q(:,89),ZERO,0_intkind1,wf(:,254))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,67),wf(:,255))
  call prop_Q_A(wf(:,78),Q(:,89),ZERO,0_intkind1,wf(:,256))
  call counter_AV_Q(wf(:,-5),wf(:,61),wf(:,257))
  call prop_Q_A(wf(:,64),Q(:,86),ZERO,0_intkind1,wf(:,258))
  call prop_Q_A(wf(:,68),Q(:,86),ZERO,0_intkind1,wf(:,259))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,70),wf(:,260))
  call prop_A_Q(wf(:,253),Q(:,38),ZERO,0_intkind1,wf(:,261))
  call prop_A_Q(wf(:,255),Q(:,38),ZERO,0_intkind1,wf(:,262))
  call prop_A_Q(wf(:,257),Q(:,41),ZERO,0_intkind1,wf(:,263))
  call prop_A_Q(wf(:,260),Q(:,41),ZERO,0_intkind1,wf(:,264))
  call vert_AV_Q(wf(:,189),wf(:,62),wf(:,265))
  call vert_AZ_Q(gZd,wf(:,189),wf(:,67),wf(:,266))
  call vert_AV_Q(wf(:,189),wf(:,61),wf(:,267))
  call vert_AZ_Q(gZd,wf(:,189),wf(:,70),wf(:,268))
  call counter_VQ_A(wf(:,62),wf(:,-4),wf(:,269))
  call prop_A_Q(wf(:,86),Q(:,105),ZERO,0_intkind1,wf(:,270))
  call counter_ZQ_A(gZd,wf(:,67),wf(:,-4),wf(:,271))
  call prop_A_Q(wf(:,90),Q(:,105),ZERO,0_intkind1,wf(:,272))
  call counter_VQ_A(wf(:,61),wf(:,-4),wf(:,273))
  call prop_A_Q(wf(:,80),Q(:,102),ZERO,0_intkind1,wf(:,274))
  call prop_A_Q(wf(:,82),Q(:,102),ZERO,0_intkind1,wf(:,275))
  call counter_ZQ_A(gZd,wf(:,70),wf(:,-4),wf(:,276))
  call prop_Q_A(wf(:,269),Q(:,22),ZERO,0_intkind1,wf(:,277))
  call vert_VQ_A(wf(:,-6),wf(:,277),wf(:,278))
  call prop_Q_A(wf(:,271),Q(:,22),ZERO,0_intkind1,wf(:,279))
  call vert_VQ_A(wf(:,-6),wf(:,279),wf(:,280))
  call prop_Q_A(wf(:,273),Q(:,25),ZERO,0_intkind1,wf(:,281))
  call vert_VQ_A(wf(:,-6),wf(:,281),wf(:,282))
  call prop_Q_A(wf(:,276),Q(:,25),ZERO,0_intkind1,wf(:,283))
  call vert_VQ_A(wf(:,-6),wf(:,283),wf(:,284))
  call vert_VQ_A(wf(:,62),wf(:,211),wf(:,285))
  call vert_ZQ_A(gZd,wf(:,67),wf(:,211),wf(:,286))
  call vert_VQ_A(wf(:,61),wf(:,211),wf(:,287))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,211),wf(:,288))
  call counter_Q_A(ctqq,wf(:,4),Q(:,80),wf(:,289))
  call prop_Q_A(wf(:,289),Q(:,80),ZERO,0_intkind1,wf(:,290))
  call vert_VQ_A(wf(:,2),wf(:,290),wf(:,291))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,290),wf(:,292))
  call vert_VQ_A(wf(:,1),wf(:,290),wf(:,293))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,290),wf(:,294))
  call counter_A_Q(ctqq,wf(:,7),Q(:,37),wf(:,295))
  call counter_A_Q(ctqq,wf(:,14),Q(:,37),wf(:,296))
  call counter_A_Q(ctqq,wf(:,17),Q(:,42),wf(:,297))
  call counter_A_Q(ctqq,wf(:,19),Q(:,42),wf(:,298))
  call counter_Q_A(ctqq,wf(:,25),Q(:,21),wf(:,299))
  call counter_Q_A(ctqq,wf(:,28),Q(:,21),wf(:,300))
  call counter_Q_A(ctqq,wf(:,31),Q(:,26),wf(:,301))
  call counter_Q_A(ctqq,wf(:,33),Q(:,26),wf(:,302))
  call counter_A_Q(ctqq,wf(:,22),Q(:,96),wf(:,303))
  call prop_A_Q(wf(:,303),Q(:,96),ZERO,0_intkind1,wf(:,304))
  call vert_AV_Q(wf(:,304),wf(:,2),wf(:,305))
  call vert_AZ_Q(gZd,wf(:,304),wf(:,9),wf(:,306))
  call vert_AV_Q(wf(:,304),wf(:,1),wf(:,307))
  call vert_AZ_Q(gZd,wf(:,304),wf(:,12),wf(:,308))
  call vert_AV_Q(wf(:,17),wf(:,-6),wf(:,309))
  call prop_A_Q(wf(:,309),Q(:,106),ZERO,0_intkind1,wf(:,310))
  call vert_AV_Q(wf(:,19),wf(:,-6),wf(:,311))
  call prop_A_Q(wf(:,311),Q(:,106),ZERO,0_intkind1,wf(:,312))
  call vert_AV_Q(wf(:,7),wf(:,-6),wf(:,313))
  call prop_A_Q(wf(:,313),Q(:,101),ZERO,0_intkind1,wf(:,314))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,315))
  call prop_A_Q(wf(:,315),Q(:,101),ZERO,0_intkind1,wf(:,316))
  call prop_Q_A(wf(:,35),Q(:,85),ZERO,0_intkind1,wf(:,317))
  call prop_Q_A(wf(:,36),Q(:,85),ZERO,0_intkind1,wf(:,318))
  call prop_Q_A(wf(:,37),Q(:,90),ZERO,0_intkind1,wf(:,319))
  call prop_Q_A(wf(:,38),Q(:,90),ZERO,0_intkind1,wf(:,320))
  call vert_QA_V(wf(:,290),wf(:,-5),wf(:,321))
  call vert_QA_Z(gZd,wf(:,290),wf(:,-5),wf(:,322))
  call prop_W_W(wf(:,45),Q(:,15),MZ,1_intkind1,wf(:,323))
  call prop_W_W(wf(:,49),Q(:,15),MZ,1_intkind1,wf(:,324))
  call prop_W_W(wf(:,53),Q(:,15),MZ,1_intkind1,wf(:,325))
  call prop_W_W(wf(:,57),Q(:,15),MZ,1_intkind1,wf(:,326))
  call vert_QA_V(wf(:,-4),wf(:,304),wf(:,327))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,304),wf(:,328))
  call vert_VQ_A(wf(:,62),wf(:,290),wf(:,329))
  call vert_ZQ_A(gZd,wf(:,67),wf(:,290),wf(:,330))
  call vert_VQ_A(wf(:,61),wf(:,290),wf(:,331))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,290),wf(:,332))
  call counter_A_Q(ctqq,wf(:,65),Q(:,41),wf(:,333))
  call counter_A_Q(ctqq,wf(:,72),Q(:,41),wf(:,334))
  call counter_A_Q(ctqq,wf(:,75),Q(:,38),wf(:,335))
  call counter_A_Q(ctqq,wf(:,77),Q(:,38),wf(:,336))
  call counter_Q_A(ctqq,wf(:,81),Q(:,25),wf(:,337))
  call counter_Q_A(ctqq,wf(:,84),Q(:,25),wf(:,338))
  call counter_Q_A(ctqq,wf(:,87),Q(:,22),wf(:,339))
  call counter_Q_A(ctqq,wf(:,89),Q(:,22),wf(:,340))
  call vert_AV_Q(wf(:,304),wf(:,62),wf(:,341))
  call vert_AZ_Q(gZd,wf(:,304),wf(:,67),wf(:,342))
  call vert_AV_Q(wf(:,304),wf(:,61),wf(:,343))
  call vert_AZ_Q(gZd,wf(:,304),wf(:,70),wf(:,344))
  call vert_AV_Q(wf(:,75),wf(:,-6),wf(:,345))
  call prop_A_Q(wf(:,345),Q(:,102),ZERO,0_intkind1,wf(:,346))
  call vert_AV_Q(wf(:,77),wf(:,-6),wf(:,347))
  call prop_A_Q(wf(:,347),Q(:,102),ZERO,0_intkind1,wf(:,348))
  call vert_AV_Q(wf(:,65),wf(:,-6),wf(:,349))
  call prop_A_Q(wf(:,349),Q(:,105),ZERO,0_intkind1,wf(:,350))
  call vert_AV_Q(wf(:,72),wf(:,-6),wf(:,351))
  call prop_A_Q(wf(:,351),Q(:,105),ZERO,0_intkind1,wf(:,352))
  call prop_Q_A(wf(:,91),Q(:,89),ZERO,0_intkind1,wf(:,353))
  call prop_Q_A(wf(:,92),Q(:,89),ZERO,0_intkind1,wf(:,354))
  call prop_Q_A(wf(:,93),Q(:,86),ZERO,0_intkind1,wf(:,355))
  call prop_Q_A(wf(:,94),Q(:,86),ZERO,0_intkind1,wf(:,356))
  call prop_W_W(wf(:,98),Q(:,15),MZ,1_intkind1,wf(:,357))
  call prop_W_W(wf(:,102),Q(:,15),MZ,1_intkind1,wf(:,358))
  call prop_W_W(wf(:,109),Q(:,15),MZ,1_intkind1,wf(:,359))
  call prop_W_W(wf(:,110),Q(:,15),MZ,1_intkind1,wf(:,360))
  call prop_W_W(wf(:,114),Q(:,15),MZ,1_intkind1,wf(:,361))
  call prop_W_W(wf(:,118),Q(:,15),MZ,1_intkind1,wf(:,362))
  call prop_W_W(wf(:,122),Q(:,15),MZ,1_intkind1,wf(:,363))
  call prop_W_W(wf(:,126),Q(:,15),MZ,1_intkind1,wf(:,364))
  call prop_W_W(wf(:,130),Q(:,15),MZ,1_intkind1,wf(:,365))
  call prop_W_W(wf(:,134),Q(:,15),MZ,1_intkind1,wf(:,366))
  call prop_W_W(wf(:,141),Q(:,15),MZ,1_intkind1,wf(:,367))
  call prop_W_W(wf(:,142),Q(:,15),MZ,1_intkind1,wf(:,368))
  call vert_VQ_A(wf(:,2),wf(:,25),wf(:,369))
  call prop_Q_A(wf(:,369),Q(:,31),ZERO,0_intkind1,wf(:,370))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,25),wf(:,371))
  call prop_Q_A(wf(:,371),Q(:,31),ZERO,0_intkind1,wf(:,372))
  call vert_VQ_A(wf(:,2),wf(:,28),wf(:,373))
  call prop_Q_A(wf(:,373),Q(:,31),ZERO,0_intkind1,wf(:,374))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,28),wf(:,375))
  call prop_Q_A(wf(:,375),Q(:,31),ZERO,0_intkind1,wf(:,376))
  call vert_AV_Q(wf(:,7),wf(:,2),wf(:,377))
  call prop_A_Q(wf(:,377),Q(:,47),ZERO,0_intkind1,wf(:,378))
  call vert_AZ_Q(gZd,wf(:,7),wf(:,9),wf(:,379))
  call prop_A_Q(wf(:,379),Q(:,47),ZERO,0_intkind1,wf(:,380))
  call vert_AV_Q(wf(:,14),wf(:,2),wf(:,381))
  call prop_A_Q(wf(:,381),Q(:,47),ZERO,0_intkind1,wf(:,382))
  call vert_AZ_Q(gZd,wf(:,14),wf(:,9),wf(:,383))
  call prop_A_Q(wf(:,383),Q(:,47),ZERO,0_intkind1,wf(:,384))
  call vert_VQ_A(wf(:,1),wf(:,31),wf(:,385))
  call prop_Q_A(wf(:,385),Q(:,31),ZERO,0_intkind1,wf(:,386))
  call vert_VQ_A(wf(:,1),wf(:,33),wf(:,387))
  call prop_Q_A(wf(:,387),Q(:,31),ZERO,0_intkind1,wf(:,388))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,31),wf(:,389))
  call prop_Q_A(wf(:,389),Q(:,31),ZERO,0_intkind1,wf(:,390))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,33),wf(:,391))
  call prop_Q_A(wf(:,391),Q(:,31),ZERO,0_intkind1,wf(:,392))
  call vert_AV_Q(wf(:,17),wf(:,1),wf(:,393))
  call prop_A_Q(wf(:,393),Q(:,47),ZERO,0_intkind1,wf(:,394))
  call vert_AV_Q(wf(:,19),wf(:,1),wf(:,395))
  call prop_A_Q(wf(:,395),Q(:,47),ZERO,0_intkind1,wf(:,396))
  call vert_AZ_Q(gZd,wf(:,17),wf(:,12),wf(:,397))
  call prop_A_Q(wf(:,397),Q(:,47),ZERO,0_intkind1,wf(:,398))
  call vert_AZ_Q(gZd,wf(:,19),wf(:,12),wf(:,399))
  call prop_A_Q(wf(:,399),Q(:,47),ZERO,0_intkind1,wf(:,400))
  call vert_VQ_A(wf(:,42),wf(:,-4),wf(:,401))
  call prop_Q_A(wf(:,401),Q(:,31),ZERO,0_intkind1,wf(:,402))
  call vert_ZQ_A(gZd,wf(:,323),wf(:,-4),wf(:,403))
  call prop_Q_A(wf(:,403),Q(:,31),ZERO,0_intkind1,wf(:,404))
  call vert_VQ_A(wf(:,48),wf(:,-4),wf(:,405))
  call prop_Q_A(wf(:,405),Q(:,31),ZERO,0_intkind1,wf(:,406))
  call vert_ZQ_A(gZd,wf(:,324),wf(:,-4),wf(:,407))
  call prop_Q_A(wf(:,407),Q(:,31),ZERO,0_intkind1,wf(:,408))
  call vert_AV_Q(wf(:,-5),wf(:,42),wf(:,409))
  call prop_A_Q(wf(:,409),Q(:,47),ZERO,0_intkind1,wf(:,410))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,323),wf(:,411))
  call prop_A_Q(wf(:,411),Q(:,47),ZERO,0_intkind1,wf(:,412))
  call vert_AV_Q(wf(:,-5),wf(:,48),wf(:,413))
  call prop_A_Q(wf(:,413),Q(:,47),ZERO,0_intkind1,wf(:,414))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,324),wf(:,415))
  call prop_A_Q(wf(:,415),Q(:,47),ZERO,0_intkind1,wf(:,416))
  call vert_VQ_A(wf(:,52),wf(:,-4),wf(:,417))
  call prop_Q_A(wf(:,417),Q(:,31),ZERO,0_intkind1,wf(:,418))
  call vert_ZQ_A(gZd,wf(:,325),wf(:,-4),wf(:,419))
  call prop_Q_A(wf(:,419),Q(:,31),ZERO,0_intkind1,wf(:,420))
  call vert_VQ_A(wf(:,56),wf(:,-4),wf(:,421))
  call prop_Q_A(wf(:,421),Q(:,31),ZERO,0_intkind1,wf(:,422))
  call vert_ZQ_A(gZd,wf(:,326),wf(:,-4),wf(:,423))
  call prop_Q_A(wf(:,423),Q(:,31),ZERO,0_intkind1,wf(:,424))
  call vert_AV_Q(wf(:,-5),wf(:,52),wf(:,425))
  call prop_A_Q(wf(:,425),Q(:,47),ZERO,0_intkind1,wf(:,426))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,325),wf(:,427))
  call prop_A_Q(wf(:,427),Q(:,47),ZERO,0_intkind1,wf(:,428))
  call vert_AV_Q(wf(:,-5),wf(:,56),wf(:,429))
  call prop_A_Q(wf(:,429),Q(:,47),ZERO,0_intkind1,wf(:,430))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,326),wf(:,431))
  call prop_A_Q(wf(:,431),Q(:,47),ZERO,0_intkind1,wf(:,432))
  call vert_VQ_A(wf(:,62),wf(:,81),wf(:,433))
  call prop_Q_A(wf(:,433),Q(:,31),ZERO,0_intkind1,wf(:,434))
  call vert_ZQ_A(gZd,wf(:,67),wf(:,81),wf(:,435))
  call prop_Q_A(wf(:,435),Q(:,31),ZERO,0_intkind1,wf(:,436))
  call vert_VQ_A(wf(:,62),wf(:,84),wf(:,437))
  call prop_Q_A(wf(:,437),Q(:,31),ZERO,0_intkind1,wf(:,438))
  call vert_ZQ_A(gZd,wf(:,67),wf(:,84),wf(:,439))
  call prop_Q_A(wf(:,439),Q(:,31),ZERO,0_intkind1,wf(:,440))
  call vert_AV_Q(wf(:,65),wf(:,62),wf(:,441))
  call prop_A_Q(wf(:,441),Q(:,47),ZERO,0_intkind1,wf(:,442))
  call vert_AZ_Q(gZd,wf(:,65),wf(:,67),wf(:,443))
  call prop_A_Q(wf(:,443),Q(:,47),ZERO,0_intkind1,wf(:,444))
  call vert_AV_Q(wf(:,72),wf(:,62),wf(:,445))
  call prop_A_Q(wf(:,445),Q(:,47),ZERO,0_intkind1,wf(:,446))
  call vert_AZ_Q(gZd,wf(:,72),wf(:,67),wf(:,447))
  call prop_A_Q(wf(:,447),Q(:,47),ZERO,0_intkind1,wf(:,448))
  call vert_VQ_A(wf(:,61),wf(:,87),wf(:,449))
  call prop_Q_A(wf(:,449),Q(:,31),ZERO,0_intkind1,wf(:,450))
  call vert_VQ_A(wf(:,61),wf(:,89),wf(:,451))
  call prop_Q_A(wf(:,451),Q(:,31),ZERO,0_intkind1,wf(:,452))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,87),wf(:,453))
  call prop_Q_A(wf(:,453),Q(:,31),ZERO,0_intkind1,wf(:,454))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,89),wf(:,455))
  call prop_Q_A(wf(:,455),Q(:,31),ZERO,0_intkind1,wf(:,456))
  call vert_AV_Q(wf(:,75),wf(:,61),wf(:,457))
  call prop_A_Q(wf(:,457),Q(:,47),ZERO,0_intkind1,wf(:,458))
  call vert_AV_Q(wf(:,77),wf(:,61),wf(:,459))
  call prop_A_Q(wf(:,459),Q(:,47),ZERO,0_intkind1,wf(:,460))
  call vert_AZ_Q(gZd,wf(:,75),wf(:,70),wf(:,461))
  call prop_A_Q(wf(:,461),Q(:,47),ZERO,0_intkind1,wf(:,462))
  call vert_AZ_Q(gZd,wf(:,77),wf(:,70),wf(:,463))
  call prop_A_Q(wf(:,463),Q(:,47),ZERO,0_intkind1,wf(:,464))
  call vert_VQ_A(wf(:,97),wf(:,-4),wf(:,465))
  call prop_Q_A(wf(:,465),Q(:,31),ZERO,0_intkind1,wf(:,466))
  call vert_ZQ_A(gZd,wf(:,357),wf(:,-4),wf(:,467))
  call prop_Q_A(wf(:,467),Q(:,31),ZERO,0_intkind1,wf(:,468))
  call vert_VQ_A(wf(:,101),wf(:,-4),wf(:,469))
  call prop_Q_A(wf(:,469),Q(:,31),ZERO,0_intkind1,wf(:,470))
  call vert_ZQ_A(gZd,wf(:,358),wf(:,-4),wf(:,471))
  call prop_Q_A(wf(:,471),Q(:,31),ZERO,0_intkind1,wf(:,472))
  call vert_AV_Q(wf(:,-5),wf(:,97),wf(:,473))
  call prop_A_Q(wf(:,473),Q(:,47),ZERO,0_intkind1,wf(:,474))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,357),wf(:,475))
  call prop_A_Q(wf(:,475),Q(:,47),ZERO,0_intkind1,wf(:,476))
  call vert_AV_Q(wf(:,-5),wf(:,101),wf(:,477))
  call prop_A_Q(wf(:,477),Q(:,47),ZERO,0_intkind1,wf(:,478))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,358),wf(:,479))
  call prop_A_Q(wf(:,479),Q(:,47),ZERO,0_intkind1,wf(:,480))
  call vert_VQ_A(wf(:,105),wf(:,-4),wf(:,481))
  call prop_Q_A(wf(:,481),Q(:,31),ZERO,0_intkind1,wf(:,482))
  call vert_VQ_A(wf(:,108),wf(:,-4),wf(:,483))
  call prop_Q_A(wf(:,483),Q(:,31),ZERO,0_intkind1,wf(:,484))
  call vert_ZQ_A(gZd,wf(:,359),wf(:,-4),wf(:,485))
  call prop_Q_A(wf(:,485),Q(:,31),ZERO,0_intkind1,wf(:,486))
  call vert_ZQ_A(gZd,wf(:,360),wf(:,-4),wf(:,487))
  call prop_Q_A(wf(:,487),Q(:,31),ZERO,0_intkind1,wf(:,488))
  call vert_AV_Q(wf(:,-5),wf(:,105),wf(:,489))
  call prop_A_Q(wf(:,489),Q(:,47),ZERO,0_intkind1,wf(:,490))
  call vert_AV_Q(wf(:,-5),wf(:,108),wf(:,491))
  call prop_A_Q(wf(:,491),Q(:,47),ZERO,0_intkind1,wf(:,492))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,359),wf(:,493))
  call prop_A_Q(wf(:,493),Q(:,47),ZERO,0_intkind1,wf(:,494))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,360),wf(:,495))
  call prop_A_Q(wf(:,495),Q(:,47),ZERO,0_intkind1,wf(:,496))
  call vert_VQ_A(wf(:,113),wf(:,-4),wf(:,497))
  call prop_Q_A(wf(:,497),Q(:,31),ZERO,0_intkind1,wf(:,498))
  call vert_ZQ_A(gZd,wf(:,361),wf(:,-4),wf(:,499))
  call prop_Q_A(wf(:,499),Q(:,31),ZERO,0_intkind1,wf(:,500))
  call vert_VQ_A(wf(:,117),wf(:,-4),wf(:,501))
  call prop_Q_A(wf(:,501),Q(:,31),ZERO,0_intkind1,wf(:,502))
  call vert_ZQ_A(gZd,wf(:,362),wf(:,-4),wf(:,503))
  call prop_Q_A(wf(:,503),Q(:,31),ZERO,0_intkind1,wf(:,504))
  call vert_AV_Q(wf(:,-5),wf(:,113),wf(:,505))
  call prop_A_Q(wf(:,505),Q(:,47),ZERO,0_intkind1,wf(:,506))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,361),wf(:,507))
  call prop_A_Q(wf(:,507),Q(:,47),ZERO,0_intkind1,wf(:,508))
  call vert_AV_Q(wf(:,-5),wf(:,117),wf(:,509))
  call prop_A_Q(wf(:,509),Q(:,47),ZERO,0_intkind1,wf(:,510))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,362),wf(:,511))
  call prop_A_Q(wf(:,511),Q(:,47),ZERO,0_intkind1,wf(:,512))
  call vert_VQ_A(wf(:,121),wf(:,-4),wf(:,513))
  call prop_Q_A(wf(:,513),Q(:,31),ZERO,0_intkind1,wf(:,514))
  call vert_ZQ_A(gZd,wf(:,363),wf(:,-4),wf(:,515))
  call prop_Q_A(wf(:,515),Q(:,31),ZERO,0_intkind1,wf(:,516))
  call vert_VQ_A(wf(:,125),wf(:,-4),wf(:,517))
  call prop_Q_A(wf(:,517),Q(:,31),ZERO,0_intkind1,wf(:,518))
  call vert_ZQ_A(gZd,wf(:,364),wf(:,-4),wf(:,519))
  call prop_Q_A(wf(:,519),Q(:,31),ZERO,0_intkind1,wf(:,520))
  call vert_AV_Q(wf(:,-5),wf(:,121),wf(:,521))
  call prop_A_Q(wf(:,521),Q(:,47),ZERO,0_intkind1,wf(:,522))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,363),wf(:,523))
  call prop_A_Q(wf(:,523),Q(:,47),ZERO,0_intkind1,wf(:,524))
  call vert_AV_Q(wf(:,-5),wf(:,125),wf(:,525))
  call prop_A_Q(wf(:,525),Q(:,47),ZERO,0_intkind1,wf(:,526))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,364),wf(:,527))
  call prop_A_Q(wf(:,527),Q(:,47),ZERO,0_intkind1,wf(:,528))
  call vert_VQ_A(wf(:,129),wf(:,-4),wf(:,529))
  call prop_Q_A(wf(:,529),Q(:,31),ZERO,0_intkind1,wf(:,530))
  call vert_ZQ_A(gZd,wf(:,365),wf(:,-4),wf(:,531))
  call prop_Q_A(wf(:,531),Q(:,31),ZERO,0_intkind1,wf(:,532))
  call vert_VQ_A(wf(:,133),wf(:,-4),wf(:,533))
  call prop_Q_A(wf(:,533),Q(:,31),ZERO,0_intkind1,wf(:,534))
  call vert_ZQ_A(gZd,wf(:,366),wf(:,-4),wf(:,535))
  call prop_Q_A(wf(:,535),Q(:,31),ZERO,0_intkind1,wf(:,536))
  call vert_AV_Q(wf(:,-5),wf(:,129),wf(:,537))
  call prop_A_Q(wf(:,537),Q(:,47),ZERO,0_intkind1,wf(:,538))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,365),wf(:,539))
  call prop_A_Q(wf(:,539),Q(:,47),ZERO,0_intkind1,wf(:,540))
  call vert_AV_Q(wf(:,-5),wf(:,133),wf(:,541))
  call prop_A_Q(wf(:,541),Q(:,47),ZERO,0_intkind1,wf(:,542))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,366),wf(:,543))
  call prop_A_Q(wf(:,543),Q(:,47),ZERO,0_intkind1,wf(:,544))
  call vert_VQ_A(wf(:,137),wf(:,-4),wf(:,545))
  call prop_Q_A(wf(:,545),Q(:,31),ZERO,0_intkind1,wf(:,546))
  call vert_VQ_A(wf(:,140),wf(:,-4),wf(:,547))
  call prop_Q_A(wf(:,547),Q(:,31),ZERO,0_intkind1,wf(:,548))
  call vert_ZQ_A(gZd,wf(:,367),wf(:,-4),wf(:,549))
  call prop_Q_A(wf(:,549),Q(:,31),ZERO,0_intkind1,wf(:,550))
  call vert_ZQ_A(gZd,wf(:,368),wf(:,-4),wf(:,551))
  call prop_Q_A(wf(:,551),Q(:,31),ZERO,0_intkind1,wf(:,552))
  call vert_AV_Q(wf(:,-5),wf(:,137),wf(:,553))
  call prop_A_Q(wf(:,553),Q(:,47),ZERO,0_intkind1,wf(:,554))
  call vert_AV_Q(wf(:,-5),wf(:,140),wf(:,555))
  call prop_A_Q(wf(:,555),Q(:,47),ZERO,0_intkind1,wf(:,556))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,367),wf(:,557))
  call prop_A_Q(wf(:,557),Q(:,47),ZERO,0_intkind1,wf(:,558))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,368),wf(:,559))
  call prop_A_Q(wf(:,559),Q(:,47),ZERO,0_intkind1,wf(:,560))


  ! propagators

    den(1) = 1 / (Q(5,5))
    den(2) = 1 / (Q(5,10))
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,37))
    den(8) = 1 / (Q(5,10) - MZ2)
    den(11) = 1 / (Q(5,5) - MZ2)
    den(16) = 1 / (Q(5,42))
    den(24) = 1 / (Q(5,96))
    den(26) = 1 / (Q(5,21))
    den(35) = 1 / (Q(5,26))
    den(51) = 1 / (Q(5,7))
    den(53) = 1 / (Q(5,112))
    den(56) = 1 / (Q(5,112) - MZ2)
    den(62) = 1 / (Q(5,13))
    den(79) = 1 / (Q(5,9))
    den(80) = 1 / (Q(5,6))
    den(82) = 1 / (Q(5,41))
    den(85) = 1 / (Q(5,6) - MZ2)
    den(88) = 1 / (Q(5,9) - MZ2)
    den(93) = 1 / (Q(5,38))
    den(102) = 1 / (Q(5,25))
    den(111) = 1 / (Q(5,22))
    den(133) = 1 / (Q(5,14))
    den(148) = 1 / (Q(5,11))
    den(189) = 1 / (Q(5,48))
    den(206) = 1 / (Q(5,15) - MH2)
    den(209) = 1 / (Q(5,74))
    den(215) = 1 / (Q(5,69))
    den(221) = 1 / (Q(5,85))
    den(228) = 1 / (Q(5,90))
    den(235) = 1 / (Q(5,101))
    den(242) = 1 / (Q(5,106))
    den(256) = 1 / (Q(5,70))
    den(262) = 1 / (Q(5,73))
    den(268) = 1 / (Q(5,89))
    den(275) = 1 / (Q(5,86))
    den(282) = 1 / (Q(5,105))
    den(289) = 1 / (Q(5,102))
    den(374) = 1 / (Q(5,15))
    den(377) = 1 / (Q(5,15) - MZ2)
    den(536) = 1 / (Q(5,53))
    den(540) = 1 / (Q(5,31))
    den(551) = 1 / (Q(5,47))
    den(559) = 1 / (Q(5,58))
    den(596) = 1 / (Q(5,57))
    den(617) = 1 / (Q(5,54))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(12) = den(5)*den(11)
    den(13) = den(4)*den(12)
    den(14) = den(9)*den(12)
    den(15) = den(1)*den(3)
    den(17) = den(2)*den(16)
    den(18) = den(15)*den(17)
    den(19) = den(8)*den(16)
    den(20) = den(15)*den(19)
    den(21) = den(3)*den(11)
    den(22) = den(17)*den(21)
    den(23) = den(19)*den(21)
    den(25) = den(2)*den(24)
    den(27) = den(1)*den(26)
    den(28) = den(25)*den(27)
    den(29) = den(8)*den(24)
    den(30) = den(27)*den(29)
    den(31) = den(11)*den(26)
    den(32) = den(25)*den(31)
    den(33) = den(29)*den(31)
    den(34) = den(1)*den(24)
    den(36) = den(2)*den(35)
    den(37) = den(34)*den(36)
    den(38) = den(8)*den(35)
    den(39) = den(34)*den(38)
    den(40) = den(11)*den(24)
    den(41) = den(36)*den(40)
    den(42) = den(38)*den(40)
    den(43) = den(17)*den(27)
    den(44) = den(19)*den(27)
    den(45) = den(17)*den(31)
    den(46) = den(19)*den(31)
    den(47) = den(6)*den(36)
    den(48) = den(6)*den(38)
    den(49) = den(12)*den(36)
    den(50) = den(12)*den(38)
    den(52) = den(1)*den(51)
    den(54) = den(3)*den(53)
    den(55) = den(52)*den(54)
    den(57) = den(3)*den(56)
    den(58) = den(52)*den(57)
    den(59) = den(11)*den(51)
    den(60) = den(54)*den(59)
    den(61) = den(57)*den(59)
    den(63) = den(1)*den(62)
    den(64) = den(54)*den(63)
    den(65) = den(57)*den(63)
    den(66) = den(11)*den(62)
    den(67) = den(54)*den(66)
    den(68) = den(57)*den(66)
    den(69) = den(24)*den(53)
    den(70) = den(52)*den(69)
    den(71) = den(24)*den(56)
    den(72) = den(52)*den(71)
    den(73) = den(59)*den(69)
    den(74) = den(59)*den(71)
    den(75) = den(63)*den(69)
    den(76) = den(63)*den(71)
    den(77) = den(66)*den(69)
    den(78) = den(66)*den(71)
    den(81) = den(3)*den(80)
    den(83) = den(79)*den(82)
    den(84) = den(81)*den(83)
    den(86) = den(3)*den(85)
    den(87) = den(83)*den(86)
    den(89) = den(82)*den(88)
    den(90) = den(81)*den(89)
    den(91) = den(86)*den(89)
    den(92) = den(3)*den(79)
    den(94) = den(80)*den(93)
    den(95) = den(92)*den(94)
    den(96) = den(85)*den(93)
    den(97) = den(92)*den(96)
    den(98) = den(3)*den(88)
    den(99) = den(94)*den(98)
    den(100) = den(96)*den(98)
    den(101) = den(24)*den(80)
    den(103) = den(79)*den(102)
    den(104) = den(101)*den(103)
    den(105) = den(24)*den(85)
    den(106) = den(103)*den(105)
    den(107) = den(88)*den(102)
    den(108) = den(101)*den(107)
    den(109) = den(105)*den(107)
    den(110) = den(24)*den(79)
    den(112) = den(80)*den(111)
    den(113) = den(110)*den(112)
    den(114) = den(85)*den(111)
    den(115) = den(110)*den(114)
    den(116) = den(24)*den(88)
    den(117) = den(112)*den(116)
    den(118) = den(114)*den(116)
    den(119) = den(94)*den(103)
    den(120) = den(96)*den(103)
    den(121) = den(94)*den(107)
    den(122) = den(96)*den(107)
    den(123) = den(83)*den(112)
    den(124) = den(83)*den(114)
    den(125) = den(89)*den(112)
    den(126) = den(89)*den(114)
    den(127) = den(51)*den(80)
    den(128) = den(54)*den(127)
    den(129) = den(57)*den(127)
    den(130) = den(51)*den(85)
    den(131) = den(54)*den(130)
    den(132) = den(57)*den(130)
    den(134) = den(80)*den(133)
    den(135) = den(54)*den(134)
    den(136) = den(85)*den(133)
    den(137) = den(54)*den(136)
    den(138) = den(57)*den(134)
    den(139) = den(57)*den(136)
    den(140) = den(69)*den(127)
    den(141) = den(71)*den(127)
    den(142) = den(69)*den(130)
    den(143) = den(71)*den(130)
    den(144) = den(69)*den(134)
    den(145) = den(69)*den(136)
    den(146) = den(71)*den(134)
    den(147) = den(71)*den(136)
    den(149) = den(79)*den(148)
    den(150) = den(54)*den(149)
    den(151) = den(57)*den(149)
    den(152) = den(88)*den(148)
    den(153) = den(54)*den(152)
    den(154) = den(57)*den(152)
    den(155) = den(62)*den(79)
    den(156) = den(54)*den(155)
    den(157) = den(57)*den(155)
    den(158) = den(62)*den(88)
    den(159) = den(54)*den(158)
    den(160) = den(57)*den(158)
    den(161) = den(69)*den(149)
    den(162) = den(71)*den(149)
    den(163) = den(69)*den(152)
    den(164) = den(71)*den(152)
    den(165) = den(69)*den(155)
    den(166) = den(71)*den(155)
    den(167) = den(69)*den(158)
    den(168) = den(71)*den(158)
    den(169) = den(2)*den(148)
    den(170) = den(54)*den(169)
    den(171) = den(57)*den(169)
    den(172) = den(8)*den(148)
    den(173) = den(54)*den(172)
    den(174) = den(57)*den(172)
    den(175) = den(2)*den(133)
    den(176) = den(54)*den(175)
    den(177) = den(8)*den(133)
    den(178) = den(54)*den(177)
    den(179) = den(57)*den(175)
    den(180) = den(57)*den(177)
    den(181) = den(69)*den(169)
    den(182) = den(71)*den(169)
    den(183) = den(69)*den(172)
    den(184) = den(71)*den(172)
    den(185) = den(69)*den(175)
    den(186) = den(69)*den(177)
    den(187) = den(71)*den(175)
    den(188) = den(71)*den(177)
    den(190) = den(1)*den(2)
    den(191) = den(189)*den(190)
    den(192) = den(1)*den(8)
    den(193) = den(189)*den(192)
    den(194) = den(2)*den(11)
    den(195) = den(189)*den(194)
    den(196) = den(8)*den(11)
    den(197) = den(189)*den(196)
    den(198) = den(79)*den(80)
    den(199) = den(189)*den(198)
    den(200) = den(79)*den(85)
    den(201) = den(189)*den(200)
    den(202) = den(80)*den(88)
    den(203) = den(189)*den(202)
    den(204) = den(85)*den(88)
    den(205) = den(189)*den(204)
    den(207) = den(196)*den(206)
    den(208) = den(189)*den(207)
    den(210) = den(8)*den(209)
    den(211) = den(27)*den(210)
    den(212) = den(31)*den(210)
    den(213) = den(6)*den(210)
    den(214) = den(12)*den(210)
    den(216) = den(11)*den(215)
    den(217) = den(36)*den(216)
    den(218) = den(38)*den(216)
    den(219) = den(17)*den(216)
    den(220) = den(19)*den(216)
    den(222) = den(15)*den(221)
    den(223) = den(2)*den(222)
    den(224) = den(8)*den(222)
    den(225) = den(21)*den(221)
    den(226) = den(2)*den(225)
    den(227) = den(8)*den(225)
    den(229) = den(4)*den(228)
    den(230) = den(1)*den(229)
    den(231) = den(9)*den(228)
    den(232) = den(1)*den(231)
    den(233) = den(11)*den(229)
    den(234) = den(11)*den(231)
    den(236) = den(34)*den(235)
    den(237) = den(2)*den(236)
    den(238) = den(8)*den(236)
    den(239) = den(40)*den(235)
    den(240) = den(2)*den(239)
    den(241) = den(8)*den(239)
    den(243) = den(25)*den(242)
    den(244) = den(1)*den(243)
    den(245) = den(29)*den(242)
    den(246) = den(1)*den(245)
    den(247) = den(11)*den(243)
    den(248) = den(11)*den(245)
    den(249) = den(56)*den(189)
    den(250) = den(52)*den(249)
    den(251) = den(59)*den(249)
    den(252) = den(63)*den(249)
    den(253) = den(66)*den(249)
    den(254) = den(204)*den(206)
    den(255) = den(189)*den(254)
    den(257) = den(85)*den(256)
    den(258) = den(103)*den(257)
    den(259) = den(107)*den(257)
    den(260) = den(83)*den(257)
    den(261) = den(89)*den(257)
    den(263) = den(88)*den(262)
    den(264) = den(112)*den(263)
    den(265) = den(114)*den(263)
    den(266) = den(94)*den(263)
    den(267) = den(96)*den(263)
    den(269) = den(92)*den(268)
    den(270) = den(80)*den(269)
    den(271) = den(85)*den(269)
    den(272) = den(98)*den(268)
    den(273) = den(80)*den(272)
    den(274) = den(85)*den(272)
    den(276) = den(81)*den(275)
    den(277) = den(79)*den(276)
    den(278) = den(86)*den(275)
    den(279) = den(79)*den(278)
    den(280) = den(88)*den(276)
    den(281) = den(88)*den(278)
    den(283) = den(110)*den(282)
    den(284) = den(80)*den(283)
    den(285) = den(85)*den(283)
    den(286) = den(116)*den(282)
    den(287) = den(80)*den(286)
    den(288) = den(85)*den(286)
    den(290) = den(101)*den(289)
    den(291) = den(79)*den(290)
    den(292) = den(105)*den(289)
    den(293) = den(79)*den(292)
    den(294) = den(88)*den(290)
    den(295) = den(88)*den(292)
    den(296) = den(127)*den(249)
    den(297) = den(130)*den(249)
    den(298) = den(134)*den(249)
    den(299) = den(136)*den(249)
    den(300) = den(149)*den(249)
    den(301) = den(152)*den(249)
    den(302) = den(155)*den(249)
    den(303) = den(158)*den(249)
    den(304) = den(169)*den(249)
    den(305) = den(172)*den(249)
    den(306) = den(175)*den(249)
    den(307) = den(177)*den(249)
    den(308) = den(3)**2
    den(309) = den(2)*den(308)
    den(310) = den(6)*den(309)
    den(311) = den(8)*den(308)
    den(312) = den(6)*den(311)
    den(313) = den(12)*den(309)
    den(314) = den(12)*den(311)
    den(315) = den(1)*den(308)
    den(316) = den(17)*den(315)
    den(317) = den(19)*den(315)
    den(318) = den(11)*den(308)
    den(319) = den(17)*den(318)
    den(320) = den(19)*den(318)
    den(321) = den(6)*den(229)
    den(322) = den(6)*den(231)
    den(323) = den(12)*den(229)
    den(324) = den(12)*den(231)
    den(325) = den(17)*den(222)
    den(326) = den(19)*den(222)
    den(327) = den(17)*den(225)
    den(328) = den(19)*den(225)
    den(329) = den(27)*den(243)
    den(330) = den(27)*den(245)
    den(331) = den(31)*den(243)
    den(332) = den(31)*den(245)
    den(333) = den(36)*den(236)
    den(334) = den(38)*den(236)
    den(335) = den(36)*den(239)
    den(336) = den(38)*den(239)
    den(337) = den(24)**2
    den(338) = den(2)*den(337)
    den(339) = den(27)*den(338)
    den(340) = den(8)*den(337)
    den(341) = den(27)*den(340)
    den(342) = den(31)*den(338)
    den(343) = den(31)*den(340)
    den(344) = den(1)*den(337)
    den(345) = den(36)*den(344)
    den(346) = den(38)*den(344)
    den(347) = den(11)*den(337)
    den(348) = den(36)*den(347)
    den(349) = den(38)*den(347)
    den(350) = den(17)*den(242)
    den(351) = den(27)*den(350)
    den(352) = den(19)*den(242)
    den(353) = den(27)*den(352)
    den(354) = den(31)*den(350)
    den(355) = den(31)*den(352)
    den(356) = den(6)*den(235)
    den(357) = den(36)*den(356)
    den(358) = den(38)*den(356)
    den(359) = den(12)*den(235)
    den(360) = den(36)*den(359)
    den(361) = den(38)*den(359)
    den(362) = den(27)*den(221)
    den(363) = den(17)*den(362)
    den(364) = den(19)*den(362)
    den(365) = den(31)*den(221)
    den(366) = den(17)*den(365)
    den(367) = den(19)*den(365)
    den(368) = den(36)*den(228)
    den(369) = den(6)*den(368)
    den(370) = den(38)*den(228)
    den(371) = den(6)*den(370)
    den(372) = den(12)*den(368)
    den(373) = den(12)*den(370)
    den(375) = den(52)*den(374)
    den(376) = den(308)*den(375)
    den(378) = den(52)*den(377)
    den(379) = den(308)*den(378)
    den(380) = den(59)*den(374)
    den(381) = den(308)*den(380)
    den(382) = den(59)*den(377)
    den(383) = den(308)*den(382)
    den(384) = den(63)*den(374)
    den(385) = den(308)*den(384)
    den(386) = den(63)*den(377)
    den(387) = den(308)*den(386)
    den(388) = den(66)*den(374)
    den(389) = den(308)*den(388)
    den(390) = den(66)*den(377)
    den(391) = den(308)*den(390)
    den(392) = den(337)*den(375)
    den(393) = den(337)*den(378)
    den(394) = den(337)*den(380)
    den(395) = den(337)*den(382)
    den(396) = den(337)*den(384)
    den(397) = den(337)*den(386)
    den(398) = den(337)*den(388)
    den(399) = den(337)*den(390)
    den(400) = den(80)*den(308)
    den(401) = den(83)*den(400)
    den(402) = den(85)*den(308)
    den(403) = den(83)*den(402)
    den(404) = den(89)*den(400)
    den(405) = den(89)*den(402)
    den(406) = den(79)*den(308)
    den(407) = den(94)*den(406)
    den(408) = den(96)*den(406)
    den(409) = den(88)*den(308)
    den(410) = den(94)*den(409)
    den(411) = den(96)*den(409)
    den(412) = den(83)*den(276)
    den(413) = den(83)*den(278)
    den(414) = den(89)*den(276)
    den(415) = den(89)*den(278)
    den(416) = den(94)*den(269)
    den(417) = den(96)*den(269)
    den(418) = den(94)*den(272)
    den(419) = den(96)*den(272)
    den(420) = den(103)*den(290)
    den(421) = den(103)*den(292)
    den(422) = den(107)*den(290)
    den(423) = den(107)*den(292)
    den(424) = den(112)*den(283)
    den(425) = den(114)*den(283)
    den(426) = den(112)*den(286)
    den(427) = den(114)*den(286)
    den(428) = den(80)*den(337)
    den(429) = den(103)*den(428)
    den(430) = den(85)*den(337)
    den(431) = den(103)*den(430)
    den(432) = den(107)*den(428)
    den(433) = den(107)*den(430)
    den(434) = den(79)*den(337)
    den(435) = den(112)*den(434)
    den(436) = den(114)*den(434)
    den(437) = den(88)*den(337)
    den(438) = den(112)*den(437)
    den(439) = den(114)*den(437)
    den(440) = den(94)*den(289)
    den(441) = den(103)*den(440)
    den(442) = den(96)*den(289)
    den(443) = den(103)*den(442)
    den(444) = den(107)*den(440)
    den(445) = den(107)*den(442)
    den(446) = den(83)*den(282)
    den(447) = den(112)*den(446)
    den(448) = den(114)*den(446)
    den(449) = den(89)*den(282)
    den(450) = den(112)*den(449)
    den(451) = den(114)*den(449)
    den(452) = den(103)*den(268)
    den(453) = den(94)*den(452)
    den(454) = den(96)*den(452)
    den(455) = den(107)*den(268)
    den(456) = den(94)*den(455)
    den(457) = den(96)*den(455)
    den(458) = den(112)*den(275)
    den(459) = den(83)*den(458)
    den(460) = den(114)*den(275)
    den(461) = den(83)*den(460)
    den(462) = den(89)*den(458)
    den(463) = den(89)*den(460)
    den(464) = den(127)*den(374)
    den(465) = den(308)*den(464)
    den(466) = den(127)*den(377)
    den(467) = den(308)*den(466)
    den(468) = den(130)*den(374)
    den(469) = den(308)*den(468)
    den(470) = den(130)*den(377)
    den(471) = den(308)*den(470)
    den(472) = den(134)*den(374)
    den(473) = den(308)*den(472)
    den(474) = den(136)*den(374)
    den(475) = den(308)*den(474)
    den(476) = den(134)*den(377)
    den(477) = den(308)*den(476)
    den(478) = den(136)*den(377)
    den(479) = den(308)*den(478)
    den(480) = den(337)*den(464)
    den(481) = den(337)*den(466)
    den(482) = den(337)*den(468)
    den(483) = den(337)*den(470)
    den(484) = den(337)*den(472)
    den(485) = den(337)*den(474)
    den(486) = den(337)*den(476)
    den(487) = den(337)*den(478)
    den(488) = den(149)*den(374)
    den(489) = den(308)*den(488)
    den(490) = den(149)*den(377)
    den(491) = den(308)*den(490)
    den(492) = den(152)*den(374)
    den(493) = den(308)*den(492)
    den(494) = den(152)*den(377)
    den(495) = den(308)*den(494)
    den(496) = den(155)*den(374)
    den(497) = den(308)*den(496)
    den(498) = den(155)*den(377)
    den(499) = den(308)*den(498)
    den(500) = den(158)*den(374)
    den(501) = den(308)*den(500)
    den(502) = den(158)*den(377)
    den(503) = den(308)*den(502)
    den(504) = den(337)*den(488)
    den(505) = den(337)*den(490)
    den(506) = den(337)*den(492)
    den(507) = den(337)*den(494)
    den(508) = den(337)*den(496)
    den(509) = den(337)*den(498)
    den(510) = den(337)*den(500)
    den(511) = den(337)*den(502)
    den(512) = den(169)*den(374)
    den(513) = den(308)*den(512)
    den(514) = den(169)*den(377)
    den(515) = den(308)*den(514)
    den(516) = den(172)*den(374)
    den(517) = den(308)*den(516)
    den(518) = den(172)*den(377)
    den(519) = den(308)*den(518)
    den(520) = den(175)*den(374)
    den(521) = den(308)*den(520)
    den(522) = den(177)*den(374)
    den(523) = den(308)*den(522)
    den(524) = den(175)*den(377)
    den(525) = den(308)*den(524)
    den(526) = den(177)*den(377)
    den(527) = den(308)*den(526)
    den(528) = den(337)*den(512)
    den(529) = den(337)*den(514)
    den(530) = den(337)*den(516)
    den(531) = den(337)*den(518)
    den(532) = den(337)*den(520)
    den(533) = den(337)*den(522)
    den(534) = den(337)*den(524)
    den(535) = den(337)*den(526)
    den(537) = den(27)*den(536)
    den(538) = den(31)*den(536)
    den(539) = den(2)*den(27)
    den(541) = den(539)*den(540)
    den(542) = den(8)*den(27)
    den(543) = den(540)*den(542)
    den(544) = den(2)*den(31)
    den(545) = den(540)*den(544)
    den(546) = den(8)*den(31)
    den(547) = den(540)*den(546)
    den(548) = den(6)*den(536)
    den(549) = den(12)*den(536)
    den(550) = den(2)*den(6)
    den(552) = den(550)*den(551)
    den(553) = den(6)*den(8)
    den(554) = den(551)*den(553)
    den(555) = den(2)*den(12)
    den(556) = den(551)*den(555)
    den(557) = den(8)*den(12)
    den(558) = den(551)*den(557)
    den(560) = den(36)*den(559)
    den(561) = den(38)*den(559)
    den(562) = den(1)*den(36)
    den(563) = den(540)*den(562)
    den(564) = den(1)*den(38)
    den(565) = den(540)*den(564)
    den(566) = den(11)*den(36)
    den(567) = den(540)*den(566)
    den(568) = den(11)*den(38)
    den(569) = den(540)*den(568)
    den(570) = den(17)*den(559)
    den(571) = den(19)*den(559)
    den(572) = den(1)*den(17)
    den(573) = den(551)*den(572)
    den(574) = den(1)*den(19)
    den(575) = den(551)*den(574)
    den(576) = den(11)*den(17)
    den(577) = den(551)*den(576)
    den(578) = den(11)*den(19)
    den(579) = den(551)*den(578)
    den(580) = den(375)*den(540)
    den(581) = den(378)*den(540)
    den(582) = den(380)*den(540)
    den(583) = den(382)*den(540)
    den(584) = den(375)*den(551)
    den(585) = den(378)*den(551)
    den(586) = den(380)*den(551)
    den(587) = den(382)*den(551)
    den(588) = den(384)*den(540)
    den(589) = den(386)*den(540)
    den(590) = den(388)*den(540)
    den(591) = den(390)*den(540)
    den(592) = den(384)*den(551)
    den(593) = den(386)*den(551)
    den(594) = den(388)*den(551)
    den(595) = den(390)*den(551)
    den(597) = den(103)*den(596)
    den(598) = den(107)*den(596)
    den(599) = den(80)*den(103)
    den(600) = den(540)*den(599)
    den(601) = den(85)*den(103)
    den(602) = den(540)*den(601)
    den(603) = den(80)*den(107)
    den(604) = den(540)*den(603)
    den(605) = den(85)*den(107)
    den(606) = den(540)*den(605)
    den(607) = den(83)*den(596)
    den(608) = den(89)*den(596)
    den(609) = den(80)*den(83)
    den(610) = den(551)*den(609)
    den(611) = den(83)*den(85)
    den(612) = den(551)*den(611)
    den(613) = den(80)*den(89)
    den(614) = den(551)*den(613)
    den(615) = den(85)*den(89)
    den(616) = den(551)*den(615)
    den(618) = den(112)*den(617)
    den(619) = den(114)*den(617)
    den(620) = den(79)*den(112)
    den(621) = den(540)*den(620)
    den(622) = den(79)*den(114)
    den(623) = den(540)*den(622)
    den(624) = den(88)*den(112)
    den(625) = den(540)*den(624)
    den(626) = den(88)*den(114)
    den(627) = den(540)*den(626)
    den(628) = den(94)*den(617)
    den(629) = den(96)*den(617)
    den(630) = den(79)*den(94)
    den(631) = den(551)*den(630)
    den(632) = den(79)*den(96)
    den(633) = den(551)*den(632)
    den(634) = den(88)*den(94)
    den(635) = den(551)*den(634)
    den(636) = den(88)*den(96)
    den(637) = den(551)*den(636)
    den(638) = den(464)*den(540)
    den(639) = den(466)*den(540)
    den(640) = den(468)*den(540)
    den(641) = den(470)*den(540)
    den(642) = den(464)*den(551)
    den(643) = den(466)*den(551)
    den(644) = den(468)*den(551)
    den(645) = den(470)*den(551)
    den(646) = den(472)*den(540)
    den(647) = den(474)*den(540)
    den(648) = den(476)*den(540)
    den(649) = den(478)*den(540)
    den(650) = den(472)*den(551)
    den(651) = den(474)*den(551)
    den(652) = den(476)*den(551)
    den(653) = den(478)*den(551)
    den(654) = den(488)*den(540)
    den(655) = den(490)*den(540)
    den(656) = den(492)*den(540)
    den(657) = den(494)*den(540)
    den(658) = den(488)*den(551)
    den(659) = den(490)*den(551)
    den(660) = den(492)*den(551)
    den(661) = den(494)*den(551)
    den(662) = den(496)*den(540)
    den(663) = den(498)*den(540)
    den(664) = den(500)*den(540)
    den(665) = den(502)*den(540)
    den(666) = den(496)*den(551)
    den(667) = den(498)*den(551)
    den(668) = den(500)*den(551)
    den(669) = den(502)*den(551)
    den(670) = den(512)*den(540)
    den(671) = den(514)*den(540)
    den(672) = den(516)*den(540)
    den(673) = den(518)*den(540)
    den(674) = den(512)*den(551)
    den(675) = den(514)*den(551)
    den(676) = den(516)*den(551)
    den(677) = den(518)*den(551)
    den(678) = den(520)*den(540)
    den(679) = den(522)*den(540)
    den(680) = den(524)*den(540)
    den(681) = den(526)*den(540)
    den(682) = den(520)*den(551)
    den(683) = den(522)*den(551)
    den(684) = den(524)*den(551)
    den(685) = den(526)*den(551)
    den(686) = den(1)*den(2)*den(189)
    den(687) = den(1)*den(8)*den(189)
    den(688) = den(2)*den(11)*den(189)
    den(689) = den(8)*den(11)*den(189)
    den(690) = den(2)*den(3)*den(6)
    den(691) = den(3)*den(6)*den(8)
    den(692) = den(2)*den(3)*den(12)
    den(693) = den(3)*den(8)*den(12)
    den(694) = den(1)*den(3)*den(17)
    den(695) = den(1)*den(3)*den(19)
    den(696) = den(3)*den(11)*den(17)
    den(697) = den(3)*den(11)*den(19)
    den(698) = den(1)*den(2)*den(3)
    den(699) = den(1)*den(3)*den(8)
    den(700) = den(2)*den(3)*den(11)
    den(701) = den(3)*den(8)*den(11)
    den(702) = den(2)*den(24)*den(27)
    den(703) = den(8)*den(24)*den(27)
    den(704) = den(2)*den(24)*den(31)
    den(705) = den(8)*den(24)*den(31)
    den(706) = den(1)*den(24)*den(36)
    den(707) = den(1)*den(24)*den(38)
    den(708) = den(11)*den(24)*den(36)
    den(709) = den(11)*den(24)*den(38)
    den(710) = den(1)*den(2)*den(24)
    den(711) = den(1)*den(8)*den(24)
    den(712) = den(2)*den(11)*den(24)
    den(713) = den(8)*den(11)*den(24)
    den(714) = den(2)*den(537)
    den(715) = den(8)*den(537)
    den(716) = den(2)*den(538)
    den(717) = den(8)*den(538)
    den(718) = den(2)*den(362)
    den(719) = den(8)*den(362)
    den(720) = den(2)*den(365)
    den(721) = den(8)*den(365)
    den(722) = den(2)*den(548)
    den(723) = den(8)*den(548)
    den(724) = den(2)*den(549)
    den(725) = den(8)*den(549)
    den(726) = den(2)*den(356)
    den(727) = den(8)*den(356)
    den(728) = den(2)*den(359)
    den(729) = den(8)*den(359)
    den(730) = den(1)*den(560)
    den(731) = den(1)*den(561)
    den(732) = den(11)*den(560)
    den(733) = den(11)*den(561)
    den(734) = den(1)*den(368)
    den(735) = den(1)*den(370)
    den(736) = den(11)*den(368)
    den(737) = den(11)*den(370)
    den(738) = den(1)*den(570)
    den(739) = den(1)*den(571)
    den(740) = den(11)*den(570)
    den(741) = den(11)*den(571)
    den(742) = den(1)*den(350)
    den(743) = den(1)*den(352)
    den(744) = den(11)*den(350)
    den(745) = den(11)*den(352)
    den(746) = den(189)*den(375)
    den(747) = den(189)*den(378)
    den(748) = den(189)*den(380)
    den(749) = den(189)*den(382)
    den(750) = den(189)*den(384)
    den(751) = den(189)*den(386)
    den(752) = den(189)*den(388)
    den(753) = den(189)*den(390)
    den(754) = den(3)*den(375)
    den(755) = den(3)*den(378)
    den(756) = den(3)*den(380)
    den(757) = den(3)*den(382)
    den(758) = den(3)*den(384)
    den(759) = den(3)*den(386)
    den(760) = den(3)*den(388)
    den(761) = den(3)*den(390)
    den(762) = den(24)*den(375)
    den(763) = den(24)*den(378)
    den(764) = den(24)*den(380)
    den(765) = den(24)*den(382)
    den(766) = den(24)*den(384)
    den(767) = den(24)*den(386)
    den(768) = den(24)*den(388)
    den(769) = den(24)*den(390)
    den(770) = den(79)*den(80)*den(189)
    den(771) = den(79)*den(85)*den(189)
    den(772) = den(80)*den(88)*den(189)
    den(773) = den(85)*den(88)*den(189)
    den(774) = den(3)*den(80)*den(83)
    den(775) = den(3)*den(83)*den(85)
    den(776) = den(3)*den(80)*den(89)
    den(777) = den(3)*den(85)*den(89)
    den(778) = den(3)*den(79)*den(94)
    den(779) = den(3)*den(79)*den(96)
    den(780) = den(3)*den(88)*den(94)
    den(781) = den(3)*den(88)*den(96)
    den(782) = den(3)*den(79)*den(80)
    den(783) = den(3)*den(79)*den(85)
    den(784) = den(3)*den(80)*den(88)
    den(785) = den(3)*den(85)*den(88)
    den(786) = den(24)*den(80)*den(103)
    den(787) = den(24)*den(85)*den(103)
    den(788) = den(24)*den(80)*den(107)
    den(789) = den(24)*den(85)*den(107)
    den(790) = den(24)*den(79)*den(112)
    den(791) = den(24)*den(79)*den(114)
    den(792) = den(24)*den(88)*den(112)
    den(793) = den(24)*den(88)*den(114)
    den(794) = den(24)*den(79)*den(80)
    den(795) = den(24)*den(79)*den(85)
    den(796) = den(24)*den(80)*den(88)
    den(797) = den(24)*den(85)*den(88)
    den(798) = den(80)*den(597)
    den(799) = den(85)*den(597)
    den(800) = den(80)*den(598)
    den(801) = den(85)*den(598)
    den(802) = den(80)*den(452)
    den(803) = den(85)*den(452)
    den(804) = den(80)*den(455)
    den(805) = den(85)*den(455)
    den(806) = den(80)*den(607)
    den(807) = den(85)*den(607)
    den(808) = den(80)*den(608)
    den(809) = den(85)*den(608)
    den(810) = den(80)*den(446)
    den(811) = den(85)*den(446)
    den(812) = den(80)*den(449)
    den(813) = den(85)*den(449)
    den(814) = den(79)*den(618)
    den(815) = den(79)*den(619)
    den(816) = den(88)*den(618)
    den(817) = den(88)*den(619)
    den(818) = den(79)*den(458)
    den(819) = den(79)*den(460)
    den(820) = den(88)*den(458)
    den(821) = den(88)*den(460)
    den(822) = den(79)*den(628)
    den(823) = den(79)*den(629)
    den(824) = den(88)*den(628)
    den(825) = den(88)*den(629)
    den(826) = den(79)*den(440)
    den(827) = den(79)*den(442)
    den(828) = den(88)*den(440)
    den(829) = den(88)*den(442)
    den(830) = den(189)*den(464)
    den(831) = den(189)*den(466)
    den(832) = den(189)*den(468)
    den(833) = den(189)*den(470)
    den(834) = den(189)*den(472)
    den(835) = den(189)*den(474)
    den(836) = den(189)*den(476)
    den(837) = den(189)*den(478)
    den(838) = den(3)*den(464)
    den(839) = den(3)*den(466)
    den(840) = den(3)*den(468)
    den(841) = den(3)*den(470)
    den(842) = den(3)*den(472)
    den(843) = den(3)*den(474)
    den(844) = den(3)*den(476)
    den(845) = den(3)*den(478)
    den(846) = den(24)*den(464)
    den(847) = den(24)*den(466)
    den(848) = den(24)*den(468)
    den(849) = den(24)*den(470)
    den(850) = den(24)*den(472)
    den(851) = den(24)*den(474)
    den(852) = den(24)*den(476)
    den(853) = den(24)*den(478)
    den(854) = den(189)*den(488)
    den(855) = den(189)*den(490)
    den(856) = den(189)*den(492)
    den(857) = den(189)*den(494)
    den(858) = den(189)*den(496)
    den(859) = den(189)*den(498)
    den(860) = den(189)*den(500)
    den(861) = den(189)*den(502)
    den(862) = den(3)*den(488)
    den(863) = den(3)*den(490)
    den(864) = den(3)*den(492)
    den(865) = den(3)*den(494)
    den(866) = den(3)*den(496)
    den(867) = den(3)*den(498)
    den(868) = den(3)*den(500)
    den(869) = den(3)*den(502)
    den(870) = den(24)*den(488)
    den(871) = den(24)*den(490)
    den(872) = den(24)*den(492)
    den(873) = den(24)*den(494)
    den(874) = den(24)*den(496)
    den(875) = den(24)*den(498)
    den(876) = den(24)*den(500)
    den(877) = den(24)*den(502)
    den(878) = den(189)*den(512)
    den(879) = den(189)*den(514)
    den(880) = den(189)*den(516)
    den(881) = den(189)*den(518)
    den(882) = den(189)*den(520)
    den(883) = den(189)*den(522)
    den(884) = den(189)*den(524)
    den(885) = den(189)*den(526)
    den(886) = den(3)*den(512)
    den(887) = den(3)*den(514)
    den(888) = den(3)*den(516)
    den(889) = den(3)*den(518)
    den(890) = den(3)*den(520)
    den(891) = den(3)*den(522)
    den(892) = den(3)*den(524)
    den(893) = den(3)*den(526)
    den(894) = den(24)*den(512)
    den(895) = den(24)*den(514)
    den(896) = den(24)*den(516)
    den(897) = den(24)*den(518)
    den(898) = den(24)*den(520)
    den(899) = den(24)*den(522)
    den(900) = den(24)*den(524)
    den(901) = den(24)*den(526)
    den(902) = den(3)*den(552)
    den(903) = den(3)*den(554)
    den(904) = den(3)*den(556)
    den(905) = den(3)*den(558)
    den(906) = den(3)*den(573)
    den(907) = den(3)*den(575)
    den(908) = den(3)*den(577)
    den(909) = den(3)*den(579)
    den(910) = den(24)*den(541)
    den(911) = den(24)*den(543)
    den(912) = den(24)*den(545)
    den(913) = den(24)*den(547)
    den(914) = den(24)*den(563)
    den(915) = den(24)*den(565)
    den(916) = den(24)*den(567)
    den(917) = den(24)*den(569)
    den(918) = den(3)*den(584)
    den(919) = den(3)*den(585)
    den(920) = den(3)*den(586)
    den(921) = den(3)*den(587)
    den(922) = den(3)*den(592)
    den(923) = den(3)*den(593)
    den(924) = den(3)*den(594)
    den(925) = den(3)*den(595)
    den(926) = den(24)*den(580)
    den(927) = den(24)*den(581)
    den(928) = den(24)*den(582)
    den(929) = den(24)*den(583)
    den(930) = den(24)*den(588)
    den(931) = den(24)*den(589)
    den(932) = den(24)*den(590)
    den(933) = den(24)*den(591)
    den(934) = den(3)*den(610)
    den(935) = den(3)*den(612)
    den(936) = den(3)*den(614)
    den(937) = den(3)*den(616)
    den(938) = den(3)*den(631)
    den(939) = den(3)*den(633)
    den(940) = den(3)*den(635)
    den(941) = den(3)*den(637)
    den(942) = den(24)*den(600)
    den(943) = den(24)*den(602)
    den(944) = den(24)*den(604)
    den(945) = den(24)*den(606)
    den(946) = den(24)*den(621)
    den(947) = den(24)*den(623)
    den(948) = den(24)*den(625)
    den(949) = den(24)*den(627)
    den(950) = den(3)*den(642)
    den(951) = den(3)*den(643)
    den(952) = den(3)*den(644)
    den(953) = den(3)*den(645)
    den(954) = den(3)*den(650)
    den(955) = den(3)*den(651)
    den(956) = den(3)*den(652)
    den(957) = den(3)*den(653)
    den(958) = den(24)*den(638)
    den(959) = den(24)*den(639)
    den(960) = den(24)*den(640)
    den(961) = den(24)*den(641)
    den(962) = den(24)*den(646)
    den(963) = den(24)*den(647)
    den(964) = den(24)*den(648)
    den(965) = den(24)*den(649)
    den(966) = den(3)*den(658)
    den(967) = den(3)*den(659)
    den(968) = den(3)*den(660)
    den(969) = den(3)*den(661)
    den(970) = den(3)*den(666)
    den(971) = den(3)*den(667)
    den(972) = den(3)*den(668)
    den(973) = den(3)*den(669)
    den(974) = den(24)*den(654)
    den(975) = den(24)*den(655)
    den(976) = den(24)*den(656)
    den(977) = den(24)*den(657)
    den(978) = den(24)*den(662)
    den(979) = den(24)*den(663)
    den(980) = den(24)*den(664)
    den(981) = den(24)*den(665)
    den(982) = den(3)*den(674)
    den(983) = den(3)*den(675)
    den(984) = den(3)*den(676)
    den(985) = den(3)*den(677)
    den(986) = den(3)*den(682)
    den(987) = den(3)*den(683)
    den(988) = den(3)*den(684)
    den(989) = den(3)*den(685)
    den(990) = den(24)*den(670)
    den(991) = den(24)*den(671)
    den(992) = den(24)*den(672)
    den(993) = den(24)*den(673)
    den(994) = den(24)*den(678)
    den(995) = den(24)*den(679)
    den(996) = den(24)*den(680)
    den(997) = den(24)*den(681)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,6),wf(:,7)) * den(7)
  A(2) = cont_QA(wf(:,7),wf(:,10)) * den(10)
  A(3) = cont_QA(wf(:,6),wf(:,14)) * den(13)
  A(4) = cont_QA(wf(:,10),wf(:,14)) * den(14)
  A(5) = cont_QA(wf(:,16),wf(:,17)) * den(18)
  A(6) = cont_QA(wf(:,16),wf(:,19)) * den(20)
  A(7) = cont_QA(wf(:,17),wf(:,20)) * den(22)
  A(8) = cont_QA(wf(:,19),wf(:,20)) * den(23)
  A(9) = cont_QA(wf(:,24),wf(:,25)) * den(28)
  A(10) = cont_QA(wf(:,25),wf(:,26)) * den(30)
  A(11) = cont_QA(wf(:,24),wf(:,28)) * den(32)
  A(12) = cont_QA(wf(:,26),wf(:,28)) * den(33)
  A(13) = cont_QA(wf(:,30),wf(:,31)) * den(37)
  A(14) = cont_QA(wf(:,30),wf(:,33)) * den(39)
  A(15) = cont_QA(wf(:,31),wf(:,34)) * den(41)
  A(16) = cont_QA(wf(:,33),wf(:,34)) * den(42)
  A(17) = cont_QA(wf(:,17),wf(:,35)) * den(43)
  A(18) = cont_QA(wf(:,19),wf(:,35)) * den(44)
  A(19) = cont_QA(wf(:,17),wf(:,36)) * den(45)
  A(20) = cont_QA(wf(:,19),wf(:,36)) * den(46)
  A(21) = cont_QA(wf(:,7),wf(:,37)) * den(47)
  A(22) = cont_QA(wf(:,7),wf(:,38)) * den(48)
  A(23) = cont_QA(wf(:,14),wf(:,37)) * den(49)
  A(24) = cont_QA(wf(:,14),wf(:,38)) * den(50)
  A(25) = cont_VV(wf(:,40),wf(:,42)) * den(55)
  A(26) = cont_VV(wf(:,44),wf(:,45)) * den(58)
  A(27) = cont_VV(wf(:,40),wf(:,48)) * den(60)
  A(28) = cont_VV(wf(:,44),wf(:,49)) * den(61)
  A(29) = cont_VV(wf(:,40),wf(:,52)) * den(64)
  A(30) = cont_VV(wf(:,44),wf(:,53)) * den(65)
  A(31) = cont_VV(wf(:,40),wf(:,56)) * den(67)
  A(32) = cont_VV(wf(:,44),wf(:,57)) * den(68)
  A(33) = cont_VV(wf(:,42),wf(:,58)) * den(70)
  A(34) = cont_VV(wf(:,45),wf(:,60)) * den(72)
  A(35) = cont_VV(wf(:,48),wf(:,58)) * den(73)
  A(36) = cont_VV(wf(:,49),wf(:,60)) * den(74)
  A(37) = cont_VV(wf(:,52),wf(:,58)) * den(75)
  A(38) = cont_VV(wf(:,53),wf(:,60)) * den(76)
  A(39) = cont_VV(wf(:,56),wf(:,58)) * den(77)
  A(40) = cont_VV(wf(:,57),wf(:,60)) * den(78)
  A(41) = cont_QA(wf(:,64),wf(:,65)) * den(84)
  A(42) = cont_QA(wf(:,65),wf(:,68)) * den(87)
  A(43) = cont_QA(wf(:,64),wf(:,72)) * den(90)
  A(44) = cont_QA(wf(:,68),wf(:,72)) * den(91)
  A(45) = cont_QA(wf(:,74),wf(:,75)) * den(95)
  A(46) = cont_QA(wf(:,74),wf(:,77)) * den(97)
  A(47) = cont_QA(wf(:,75),wf(:,78)) * den(99)
  A(48) = cont_QA(wf(:,77),wf(:,78)) * den(100)
  A(49) = cont_QA(wf(:,80),wf(:,81)) * den(104)
  A(50) = cont_QA(wf(:,81),wf(:,82)) * den(106)
  A(51) = cont_QA(wf(:,80),wf(:,84)) * den(108)
  A(52) = cont_QA(wf(:,82),wf(:,84)) * den(109)
  A(53) = cont_QA(wf(:,86),wf(:,87)) * den(113)
  A(54) = cont_QA(wf(:,86),wf(:,89)) * den(115)
  A(55) = cont_QA(wf(:,87),wf(:,90)) * den(117)
  A(56) = cont_QA(wf(:,89),wf(:,90)) * den(118)
  A(57) = cont_QA(wf(:,75),wf(:,91)) * den(119)
  A(58) = cont_QA(wf(:,77),wf(:,91)) * den(120)
  A(59) = cont_QA(wf(:,75),wf(:,92)) * den(121)
  A(60) = cont_QA(wf(:,77),wf(:,92)) * den(122)
  A(61) = cont_QA(wf(:,65),wf(:,93)) * den(123)
  A(62) = cont_QA(wf(:,65),wf(:,94)) * den(124)
  A(63) = cont_QA(wf(:,72),wf(:,93)) * den(125)
  A(64) = cont_QA(wf(:,72),wf(:,94)) * den(126)
  A(65) = cont_VV(wf(:,40),wf(:,97)) * den(128)
  A(66) = cont_VV(wf(:,44),wf(:,98)) * den(129)
  A(67) = cont_VV(wf(:,40),wf(:,101)) * den(131)
  A(68) = cont_VV(wf(:,44),wf(:,102)) * den(132)
  A(69) = cont_VV(wf(:,40),wf(:,105)) * den(135)
  A(70) = cont_VV(wf(:,40),wf(:,108)) * den(137)
  A(71) = cont_VV(wf(:,44),wf(:,109)) * den(138)
  A(72) = cont_VV(wf(:,44),wf(:,110)) * den(139)
  A(73) = cont_VV(wf(:,58),wf(:,97)) * den(140)
  A(74) = cont_VV(wf(:,60),wf(:,98)) * den(141)
  A(75) = cont_VV(wf(:,58),wf(:,101)) * den(142)
  A(76) = cont_VV(wf(:,60),wf(:,102)) * den(143)
  A(77) = cont_VV(wf(:,58),wf(:,105)) * den(144)
  A(78) = cont_VV(wf(:,58),wf(:,108)) * den(145)
  A(79) = cont_VV(wf(:,60),wf(:,109)) * den(146)
  A(80) = cont_VV(wf(:,60),wf(:,110)) * den(147)
  A(81) = cont_VV(wf(:,40),wf(:,113)) * den(150)
  A(82) = cont_VV(wf(:,44),wf(:,114)) * den(151)
  A(83) = cont_VV(wf(:,40),wf(:,117)) * den(153)
  A(84) = cont_VV(wf(:,44),wf(:,118)) * den(154)
  A(85) = cont_VV(wf(:,40),wf(:,121)) * den(156)
  A(86) = cont_VV(wf(:,44),wf(:,122)) * den(157)
  A(87) = cont_VV(wf(:,40),wf(:,125)) * den(159)
  A(88) = cont_VV(wf(:,44),wf(:,126)) * den(160)
  A(89) = cont_VV(wf(:,58),wf(:,113)) * den(161)
  A(90) = cont_VV(wf(:,60),wf(:,114)) * den(162)
  A(91) = cont_VV(wf(:,58),wf(:,117)) * den(163)
  A(92) = cont_VV(wf(:,60),wf(:,118)) * den(164)
  A(93) = cont_VV(wf(:,58),wf(:,121)) * den(165)
  A(94) = cont_VV(wf(:,60),wf(:,122)) * den(166)
  A(95) = cont_VV(wf(:,58),wf(:,125)) * den(167)
  A(96) = cont_VV(wf(:,60),wf(:,126)) * den(168)
  A(97) = cont_VV(wf(:,40),wf(:,129)) * den(170)
  A(98) = cont_VV(wf(:,44),wf(:,130)) * den(171)
  A(99) = cont_VV(wf(:,40),wf(:,133)) * den(173)
  A(100) = cont_VV(wf(:,44),wf(:,134)) * den(174)
  A(101) = cont_VV(wf(:,40),wf(:,137)) * den(176)
  A(102) = cont_VV(wf(:,40),wf(:,140)) * den(178)
  A(103) = cont_VV(wf(:,44),wf(:,141)) * den(179)
  A(104) = cont_VV(wf(:,44),wf(:,142)) * den(180)
  A(105) = cont_VV(wf(:,58),wf(:,129)) * den(181)
  A(106) = cont_VV(wf(:,60),wf(:,130)) * den(182)
  A(107) = cont_VV(wf(:,58),wf(:,133)) * den(183)
  A(108) = cont_VV(wf(:,60),wf(:,134)) * den(184)
  A(109) = cont_VV(wf(:,58),wf(:,137)) * den(185)
  A(110) = cont_VV(wf(:,58),wf(:,140)) * den(186)
  A(111) = cont_VV(wf(:,60),wf(:,141)) * den(187)
  A(112) = cont_VV(wf(:,60),wf(:,142)) * den(188)

  A(113) = cont_VV(wf(:,143),wf(:,144)) * den(191)
  A(114) = cont_VV(wf(:,143),wf(:,145)) * den(193)
  A(115) = cont_VV(wf(:,143),wf(:,146)) * den(195)
  A(116) = cont_VV(wf(:,143),wf(:,147)) * den(197)
  A(117) = cont_VV(wf(:,143),wf(:,148)) * den(199)
  A(118) = cont_VV(wf(:,143),wf(:,149)) * den(201)
  A(119) = cont_VV(wf(:,143),wf(:,150)) * den(203)
  A(120) = cont_VV(wf(:,143),wf(:,151)) * den(205)
  A(121) = cont_SS(wf(:,152),wf(:,153)) * den(208)
  A(122) = cont_QA(wf(:,7),wf(:,154)) * den(7)
  A(123) = cont_QA(wf(:,7),wf(:,155)) * den(10)
  A(124) = cont_QA(wf(:,14),wf(:,154)) * den(13)
  A(125) = cont_QA(wf(:,14),wf(:,155)) * den(14)
  A(126) = cont_QA(wf(:,17),wf(:,156)) * den(18)
  A(127) = cont_QA(wf(:,19),wf(:,156)) * den(20)
  A(128) = cont_QA(wf(:,17),wf(:,157)) * den(22)
  A(129) = cont_QA(wf(:,19),wf(:,157)) * den(23)
  A(130) = cont_QA(wf(:,25),wf(:,158)) * den(28)
  A(131) = cont_QA(wf(:,25),wf(:,159)) * den(30)
  A(132) = cont_QA(wf(:,28),wf(:,158)) * den(32)
  A(133) = cont_QA(wf(:,28),wf(:,159)) * den(33)
  A(134) = cont_QA(wf(:,31),wf(:,160)) * den(37)
  A(135) = cont_QA(wf(:,33),wf(:,160)) * den(39)
  A(136) = cont_QA(wf(:,31),wf(:,161)) * den(41)
  A(137) = cont_QA(wf(:,33),wf(:,161)) * den(42)
  A(138) = cont_QA(wf(:,17),wf(:,162)) * den(43)
  A(139) = cont_QA(wf(:,19),wf(:,162)) * den(44)
  A(140) = cont_QA(wf(:,17),wf(:,163)) * den(45)
  A(141) = cont_QA(wf(:,19),wf(:,163)) * den(46)
  A(142) = cont_VV(wf(:,164),wf(:,165)) * den(211)
  A(143) = cont_VV(wf(:,164),wf(:,166)) * den(212)
  A(144) = cont_QA(wf(:,7),wf(:,167)) * den(47)
  A(145) = cont_QA(wf(:,7),wf(:,168)) * den(48)
  A(146) = cont_QA(wf(:,14),wf(:,167)) * den(49)
  A(147) = cont_QA(wf(:,14),wf(:,168)) * den(50)
  A(148) = cont_VV(wf(:,164),wf(:,169)) * den(213)
  A(149) = cont_VV(wf(:,164),wf(:,170)) * den(214)
  A(150) = cont_VV(wf(:,171),wf(:,172)) * den(217)
  A(151) = cont_VV(wf(:,171),wf(:,173)) * den(218)
  A(152) = cont_VV(wf(:,171),wf(:,174)) * den(219)
  A(153) = cont_VV(wf(:,171),wf(:,175)) * den(220)
  A(154) = cont_QA(wf(:,176),wf(:,177)) * den(223)
  A(155) = cont_QA(wf(:,177),wf(:,178)) * den(224)
  A(156) = cont_QA(wf(:,176),wf(:,179)) * den(226)
  A(157) = cont_QA(wf(:,178),wf(:,179)) * den(227)
  A(158) = cont_QA(wf(:,180),wf(:,181)) * den(230)
  A(159) = cont_QA(wf(:,180),wf(:,182)) * den(232)
  A(160) = cont_QA(wf(:,181),wf(:,183)) * den(233)
  A(161) = cont_QA(wf(:,182),wf(:,183)) * den(234)
  A(162) = cont_QA(wf(:,35),wf(:,184)) * den(43)
  A(163) = cont_QA(wf(:,35),wf(:,185)) * den(44)
  A(164) = cont_QA(wf(:,36),wf(:,184)) * den(45)
  A(165) = cont_QA(wf(:,36),wf(:,185)) * den(46)
  A(166) = cont_QA(wf(:,37),wf(:,186)) * den(47)
  A(167) = cont_QA(wf(:,38),wf(:,186)) * den(48)
  A(168) = cont_QA(wf(:,37),wf(:,187)) * den(49)
  A(169) = cont_QA(wf(:,38),wf(:,187)) * den(50)
  A(170) = cont_QA(wf(:,25),wf(:,190)) * den(28)
  A(171) = cont_QA(wf(:,25),wf(:,191)) * den(30)
  A(172) = cont_QA(wf(:,28),wf(:,190)) * den(32)
  A(173) = cont_QA(wf(:,28),wf(:,191)) * den(33)
  A(174) = cont_QA(wf(:,31),wf(:,192)) * den(37)
  A(175) = cont_QA(wf(:,33),wf(:,192)) * den(39)
  A(176) = cont_QA(wf(:,31),wf(:,193)) * den(41)
  A(177) = cont_QA(wf(:,33),wf(:,193)) * den(42)
  A(178) = cont_QA(wf(:,194),wf(:,195)) * den(237)
  A(179) = cont_QA(wf(:,195),wf(:,196)) * den(238)
  A(180) = cont_QA(wf(:,194),wf(:,197)) * den(240)
  A(181) = cont_QA(wf(:,196),wf(:,197)) * den(241)
  A(182) = cont_QA(wf(:,198),wf(:,199)) * den(244)
  A(183) = cont_QA(wf(:,198),wf(:,200)) * den(246)
  A(184) = cont_QA(wf(:,199),wf(:,201)) * den(247)
  A(185) = cont_QA(wf(:,200),wf(:,201)) * den(248)
  A(186) = cont_QA(wf(:,7),wf(:,203)) * den(47)
  A(187) = cont_QA(wf(:,7),wf(:,205)) * den(48)
  A(188) = cont_QA(wf(:,14),wf(:,203)) * den(49)
  A(189) = cont_QA(wf(:,14),wf(:,205)) * den(50)
  A(190) = cont_QA(wf(:,17),wf(:,207)) * den(43)
  A(191) = cont_QA(wf(:,19),wf(:,207)) * den(44)
  A(192) = cont_QA(wf(:,17),wf(:,209)) * den(45)
  A(193) = cont_QA(wf(:,19),wf(:,209)) * den(46)
  A(194) = cont_QA(wf(:,7),wf(:,212)) * den(7)
  A(195) = cont_QA(wf(:,7),wf(:,213)) * den(10)
  A(196) = cont_QA(wf(:,14),wf(:,212)) * den(13)
  A(197) = cont_QA(wf(:,14),wf(:,213)) * den(14)
  A(198) = cont_QA(wf(:,17),wf(:,214)) * den(18)
  A(199) = cont_QA(wf(:,19),wf(:,214)) * den(20)
  A(200) = cont_QA(wf(:,17),wf(:,215)) * den(22)
  A(201) = cont_QA(wf(:,19),wf(:,215)) * den(23)
  A(202) = cont_VV(wf(:,45),wf(:,217)) * den(250)
  A(203) = cont_VV(wf(:,49),wf(:,217)) * den(251)
  A(204) = cont_VV(wf(:,53),wf(:,217)) * den(252)
  A(205) = cont_VV(wf(:,57),wf(:,217)) * den(253)
  A(206) = cont_VV(wf(:,42),wf(:,218)) * den(55)
  A(207) = cont_VV(wf(:,45),wf(:,220)) * den(58)
  A(208) = cont_VV(wf(:,48),wf(:,218)) * den(60)
  A(209) = cont_VV(wf(:,49),wf(:,220)) * den(61)
  A(210) = cont_VV(wf(:,52),wf(:,218)) * den(64)
  A(211) = cont_VV(wf(:,53),wf(:,220)) * den(65)
  A(212) = cont_VV(wf(:,56),wf(:,218)) * den(67)
  A(213) = cont_VV(wf(:,57),wf(:,220)) * den(68)
  A(214) = cont_VV(wf(:,42),wf(:,221)) * den(70)
  A(215) = cont_VV(wf(:,45),wf(:,223)) * den(72)
  A(216) = cont_VV(wf(:,48),wf(:,221)) * den(73)
  A(217) = cont_VV(wf(:,49),wf(:,223)) * den(74)
  A(218) = cont_VV(wf(:,52),wf(:,221)) * den(75)
  A(219) = cont_VV(wf(:,53),wf(:,223)) * den(76)
  A(220) = cont_VV(wf(:,56),wf(:,221)) * den(77)
  A(221) = cont_VV(wf(:,57),wf(:,223)) * den(78)
  A(222) = cont_VV(wf(:,42),wf(:,224)) * den(70)
  A(223) = cont_VV(wf(:,45),wf(:,226)) * den(72)
  A(224) = cont_VV(wf(:,48),wf(:,224)) * den(73)
  A(225) = cont_VV(wf(:,49),wf(:,226)) * den(74)
  A(226) = cont_VV(wf(:,52),wf(:,224)) * den(75)
  A(227) = cont_VV(wf(:,53),wf(:,226)) * den(76)
  A(228) = cont_VV(wf(:,56),wf(:,224)) * den(77)
  A(229) = cont_VV(wf(:,57),wf(:,226)) * den(78)
  A(230) = cont_VV(wf(:,42),wf(:,227)) * den(55)
  A(231) = cont_VV(wf(:,45),wf(:,229)) * den(58)
  A(232) = cont_VV(wf(:,48),wf(:,227)) * den(60)
  A(233) = cont_VV(wf(:,49),wf(:,229)) * den(61)
  A(234) = cont_VV(wf(:,52),wf(:,227)) * den(64)
  A(235) = cont_VV(wf(:,53),wf(:,229)) * den(65)
  A(236) = cont_VV(wf(:,56),wf(:,227)) * den(67)
  A(237) = cont_VV(wf(:,57),wf(:,229)) * den(68)
  A(238) = cont_SS(wf(:,153),wf(:,230)) * den(255)
  A(239) = cont_QA(wf(:,65),wf(:,231)) * den(84)
  A(240) = cont_QA(wf(:,65),wf(:,232)) * den(87)
  A(241) = cont_QA(wf(:,72),wf(:,231)) * den(90)
  A(242) = cont_QA(wf(:,72),wf(:,232)) * den(91)
  A(243) = cont_QA(wf(:,75),wf(:,233)) * den(95)
  A(244) = cont_QA(wf(:,77),wf(:,233)) * den(97)
  A(245) = cont_QA(wf(:,75),wf(:,234)) * den(99)
  A(246) = cont_QA(wf(:,77),wf(:,234)) * den(100)
  A(247) = cont_QA(wf(:,81),wf(:,235)) * den(104)
  A(248) = cont_QA(wf(:,81),wf(:,236)) * den(106)
  A(249) = cont_QA(wf(:,84),wf(:,235)) * den(108)
  A(250) = cont_QA(wf(:,84),wf(:,236)) * den(109)
  A(251) = cont_QA(wf(:,87),wf(:,237)) * den(113)
  A(252) = cont_QA(wf(:,89),wf(:,237)) * den(115)
  A(253) = cont_QA(wf(:,87),wf(:,238)) * den(117)
  A(254) = cont_QA(wf(:,89),wf(:,238)) * den(118)
  A(255) = cont_QA(wf(:,75),wf(:,239)) * den(119)
  A(256) = cont_QA(wf(:,77),wf(:,239)) * den(120)
  A(257) = cont_QA(wf(:,75),wf(:,240)) * den(121)
  A(258) = cont_QA(wf(:,77),wf(:,240)) * den(122)
  A(259) = cont_VV(wf(:,241),wf(:,242)) * den(258)
  A(260) = cont_VV(wf(:,241),wf(:,243)) * den(259)
  A(261) = cont_QA(wf(:,65),wf(:,244)) * den(123)
  A(262) = cont_QA(wf(:,65),wf(:,245)) * den(124)
  A(263) = cont_QA(wf(:,72),wf(:,244)) * den(125)
  A(264) = cont_QA(wf(:,72),wf(:,245)) * den(126)
  A(265) = cont_VV(wf(:,241),wf(:,246)) * den(260)
  A(266) = cont_VV(wf(:,241),wf(:,247)) * den(261)
  A(267) = cont_VV(wf(:,248),wf(:,249)) * den(264)
  A(268) = cont_VV(wf(:,248),wf(:,250)) * den(265)
  A(269) = cont_VV(wf(:,248),wf(:,251)) * den(266)
  A(270) = cont_VV(wf(:,248),wf(:,252)) * den(267)
  A(271) = cont_QA(wf(:,253),wf(:,254)) * den(270)
  A(272) = cont_QA(wf(:,254),wf(:,255)) * den(271)
  A(273) = cont_QA(wf(:,253),wf(:,256)) * den(273)
  A(274) = cont_QA(wf(:,255),wf(:,256)) * den(274)
  A(275) = cont_QA(wf(:,257),wf(:,258)) * den(277)
  A(276) = cont_QA(wf(:,257),wf(:,259)) * den(279)
  A(277) = cont_QA(wf(:,258),wf(:,260)) * den(280)
  A(278) = cont_QA(wf(:,259),wf(:,260)) * den(281)
  A(279) = cont_QA(wf(:,91),wf(:,261)) * den(119)
  A(280) = cont_QA(wf(:,91),wf(:,262)) * den(120)
  A(281) = cont_QA(wf(:,92),wf(:,261)) * den(121)
  A(282) = cont_QA(wf(:,92),wf(:,262)) * den(122)
  A(283) = cont_QA(wf(:,93),wf(:,263)) * den(123)
  A(284) = cont_QA(wf(:,94),wf(:,263)) * den(124)
  A(285) = cont_QA(wf(:,93),wf(:,264)) * den(125)
  A(286) = cont_QA(wf(:,94),wf(:,264)) * den(126)
  A(287) = cont_QA(wf(:,81),wf(:,265)) * den(104)
  A(288) = cont_QA(wf(:,81),wf(:,266)) * den(106)
  A(289) = cont_QA(wf(:,84),wf(:,265)) * den(108)
  A(290) = cont_QA(wf(:,84),wf(:,266)) * den(109)
  A(291) = cont_QA(wf(:,87),wf(:,267)) * den(113)
  A(292) = cont_QA(wf(:,89),wf(:,267)) * den(115)
  A(293) = cont_QA(wf(:,87),wf(:,268)) * den(117)
  A(294) = cont_QA(wf(:,89),wf(:,268)) * den(118)
  A(295) = cont_QA(wf(:,269),wf(:,270)) * den(284)
  A(296) = cont_QA(wf(:,270),wf(:,271)) * den(285)
  A(297) = cont_QA(wf(:,269),wf(:,272)) * den(287)
  A(298) = cont_QA(wf(:,271),wf(:,272)) * den(288)
  A(299) = cont_QA(wf(:,273),wf(:,274)) * den(291)
  A(300) = cont_QA(wf(:,273),wf(:,275)) * den(293)
  A(301) = cont_QA(wf(:,274),wf(:,276)) * den(294)
  A(302) = cont_QA(wf(:,275),wf(:,276)) * den(295)
  A(303) = cont_QA(wf(:,65),wf(:,278)) * den(123)
  A(304) = cont_QA(wf(:,65),wf(:,280)) * den(124)
  A(305) = cont_QA(wf(:,72),wf(:,278)) * den(125)
  A(306) = cont_QA(wf(:,72),wf(:,280)) * den(126)
  A(307) = cont_QA(wf(:,75),wf(:,282)) * den(119)
  A(308) = cont_QA(wf(:,77),wf(:,282)) * den(120)
  A(309) = cont_QA(wf(:,75),wf(:,284)) * den(121)
  A(310) = cont_QA(wf(:,77),wf(:,284)) * den(122)
  A(311) = cont_QA(wf(:,65),wf(:,285)) * den(84)
  A(312) = cont_QA(wf(:,65),wf(:,286)) * den(87)
  A(313) = cont_QA(wf(:,72),wf(:,285)) * den(90)
  A(314) = cont_QA(wf(:,72),wf(:,286)) * den(91)
  A(315) = cont_QA(wf(:,75),wf(:,287)) * den(95)
  A(316) = cont_QA(wf(:,77),wf(:,287)) * den(97)
  A(317) = cont_QA(wf(:,75),wf(:,288)) * den(99)
  A(318) = cont_QA(wf(:,77),wf(:,288)) * den(100)
  A(319) = cont_VV(wf(:,98),wf(:,217)) * den(296)
  A(320) = cont_VV(wf(:,102),wf(:,217)) * den(297)
  A(321) = cont_VV(wf(:,109),wf(:,217)) * den(298)
  A(322) = cont_VV(wf(:,110),wf(:,217)) * den(299)
  A(323) = cont_VV(wf(:,97),wf(:,218)) * den(128)
  A(324) = cont_VV(wf(:,98),wf(:,220)) * den(129)
  A(325) = cont_VV(wf(:,101),wf(:,218)) * den(131)
  A(326) = cont_VV(wf(:,102),wf(:,220)) * den(132)
  A(327) = cont_VV(wf(:,105),wf(:,218)) * den(135)
  A(328) = cont_VV(wf(:,108),wf(:,218)) * den(137)
  A(329) = cont_VV(wf(:,109),wf(:,220)) * den(138)
  A(330) = cont_VV(wf(:,110),wf(:,220)) * den(139)
  A(331) = cont_VV(wf(:,97),wf(:,221)) * den(140)
  A(332) = cont_VV(wf(:,98),wf(:,223)) * den(141)
  A(333) = cont_VV(wf(:,101),wf(:,221)) * den(142)
  A(334) = cont_VV(wf(:,102),wf(:,223)) * den(143)
  A(335) = cont_VV(wf(:,105),wf(:,221)) * den(144)
  A(336) = cont_VV(wf(:,108),wf(:,221)) * den(145)
  A(337) = cont_VV(wf(:,109),wf(:,223)) * den(146)
  A(338) = cont_VV(wf(:,110),wf(:,223)) * den(147)
  A(339) = cont_VV(wf(:,97),wf(:,224)) * den(140)
  A(340) = cont_VV(wf(:,98),wf(:,226)) * den(141)
  A(341) = cont_VV(wf(:,101),wf(:,224)) * den(142)
  A(342) = cont_VV(wf(:,102),wf(:,226)) * den(143)
  A(343) = cont_VV(wf(:,105),wf(:,224)) * den(144)
  A(344) = cont_VV(wf(:,108),wf(:,224)) * den(145)
  A(345) = cont_VV(wf(:,109),wf(:,226)) * den(146)
  A(346) = cont_VV(wf(:,110),wf(:,226)) * den(147)
  A(347) = cont_VV(wf(:,97),wf(:,227)) * den(128)
  A(348) = cont_VV(wf(:,98),wf(:,229)) * den(129)
  A(349) = cont_VV(wf(:,101),wf(:,227)) * den(131)
  A(350) = cont_VV(wf(:,102),wf(:,229)) * den(132)
  A(351) = cont_VV(wf(:,105),wf(:,227)) * den(135)
  A(352) = cont_VV(wf(:,108),wf(:,227)) * den(137)
  A(353) = cont_VV(wf(:,109),wf(:,229)) * den(138)
  A(354) = cont_VV(wf(:,110),wf(:,229)) * den(139)
  A(355) = cont_VV(wf(:,114),wf(:,217)) * den(300)
  A(356) = cont_VV(wf(:,118),wf(:,217)) * den(301)
  A(357) = cont_VV(wf(:,122),wf(:,217)) * den(302)
  A(358) = cont_VV(wf(:,126),wf(:,217)) * den(303)
  A(359) = cont_VV(wf(:,113),wf(:,218)) * den(150)
  A(360) = cont_VV(wf(:,114),wf(:,220)) * den(151)
  A(361) = cont_VV(wf(:,117),wf(:,218)) * den(153)
  A(362) = cont_VV(wf(:,118),wf(:,220)) * den(154)
  A(363) = cont_VV(wf(:,121),wf(:,218)) * den(156)
  A(364) = cont_VV(wf(:,122),wf(:,220)) * den(157)
  A(365) = cont_VV(wf(:,125),wf(:,218)) * den(159)
  A(366) = cont_VV(wf(:,126),wf(:,220)) * den(160)
  A(367) = cont_VV(wf(:,113),wf(:,221)) * den(161)
  A(368) = cont_VV(wf(:,114),wf(:,223)) * den(162)
  A(369) = cont_VV(wf(:,117),wf(:,221)) * den(163)
  A(370) = cont_VV(wf(:,118),wf(:,223)) * den(164)
  A(371) = cont_VV(wf(:,121),wf(:,221)) * den(165)
  A(372) = cont_VV(wf(:,122),wf(:,223)) * den(166)
  A(373) = cont_VV(wf(:,125),wf(:,221)) * den(167)
  A(374) = cont_VV(wf(:,126),wf(:,223)) * den(168)
  A(375) = cont_VV(wf(:,113),wf(:,224)) * den(161)
  A(376) = cont_VV(wf(:,114),wf(:,226)) * den(162)
  A(377) = cont_VV(wf(:,117),wf(:,224)) * den(163)
  A(378) = cont_VV(wf(:,118),wf(:,226)) * den(164)
  A(379) = cont_VV(wf(:,121),wf(:,224)) * den(165)
  A(380) = cont_VV(wf(:,122),wf(:,226)) * den(166)
  A(381) = cont_VV(wf(:,125),wf(:,224)) * den(167)
  A(382) = cont_VV(wf(:,126),wf(:,226)) * den(168)
  A(383) = cont_VV(wf(:,113),wf(:,227)) * den(150)
  A(384) = cont_VV(wf(:,114),wf(:,229)) * den(151)
  A(385) = cont_VV(wf(:,117),wf(:,227)) * den(153)
  A(386) = cont_VV(wf(:,118),wf(:,229)) * den(154)
  A(387) = cont_VV(wf(:,121),wf(:,227)) * den(156)
  A(388) = cont_VV(wf(:,122),wf(:,229)) * den(157)
  A(389) = cont_VV(wf(:,125),wf(:,227)) * den(159)
  A(390) = cont_VV(wf(:,126),wf(:,229)) * den(160)
  A(391) = cont_VV(wf(:,130),wf(:,217)) * den(304)
  A(392) = cont_VV(wf(:,134),wf(:,217)) * den(305)
  A(393) = cont_VV(wf(:,141),wf(:,217)) * den(306)
  A(394) = cont_VV(wf(:,142),wf(:,217)) * den(307)
  A(395) = cont_VV(wf(:,129),wf(:,218)) * den(170)
  A(396) = cont_VV(wf(:,130),wf(:,220)) * den(171)
  A(397) = cont_VV(wf(:,133),wf(:,218)) * den(173)
  A(398) = cont_VV(wf(:,134),wf(:,220)) * den(174)
  A(399) = cont_VV(wf(:,137),wf(:,218)) * den(176)
  A(400) = cont_VV(wf(:,140),wf(:,218)) * den(178)
  A(401) = cont_VV(wf(:,141),wf(:,220)) * den(179)
  A(402) = cont_VV(wf(:,142),wf(:,220)) * den(180)
  A(403) = cont_VV(wf(:,129),wf(:,221)) * den(181)
  A(404) = cont_VV(wf(:,130),wf(:,223)) * den(182)
  A(405) = cont_VV(wf(:,133),wf(:,221)) * den(183)
  A(406) = cont_VV(wf(:,134),wf(:,223)) * den(184)
  A(407) = cont_VV(wf(:,137),wf(:,221)) * den(185)
  A(408) = cont_VV(wf(:,140),wf(:,221)) * den(186)
  A(409) = cont_VV(wf(:,141),wf(:,223)) * den(187)
  A(410) = cont_VV(wf(:,142),wf(:,223)) * den(188)
  A(411) = cont_VV(wf(:,129),wf(:,224)) * den(181)
  A(412) = cont_VV(wf(:,130),wf(:,226)) * den(182)
  A(413) = cont_VV(wf(:,133),wf(:,224)) * den(183)
  A(414) = cont_VV(wf(:,134),wf(:,226)) * den(184)
  A(415) = cont_VV(wf(:,137),wf(:,224)) * den(185)
  A(416) = cont_VV(wf(:,140),wf(:,224)) * den(186)
  A(417) = cont_VV(wf(:,141),wf(:,226)) * den(187)
  A(418) = cont_VV(wf(:,142),wf(:,226)) * den(188)
  A(419) = cont_VV(wf(:,129),wf(:,227)) * den(170)
  A(420) = cont_VV(wf(:,130),wf(:,229)) * den(171)
  A(421) = cont_VV(wf(:,133),wf(:,227)) * den(173)
  A(422) = cont_VV(wf(:,134),wf(:,229)) * den(174)
  A(423) = cont_VV(wf(:,137),wf(:,227)) * den(176)
  A(424) = cont_VV(wf(:,140),wf(:,227)) * den(178)
  A(425) = cont_VV(wf(:,141),wf(:,229)) * den(179)
  A(426) = cont_VV(wf(:,142),wf(:,229)) * den(180)
  A(427) = cont_QA(wf(:,7),wf(:,291)) * den(310)
  A(428) = cont_QA(wf(:,7),wf(:,292)) * den(312)
  A(429) = cont_QA(wf(:,14),wf(:,291)) * den(313)
  A(430) = cont_QA(wf(:,14),wf(:,292)) * den(314)
  A(431) = cont_QA(wf(:,17),wf(:,293)) * den(316)
  A(432) = cont_QA(wf(:,19),wf(:,293)) * den(317)
  A(433) = cont_QA(wf(:,17),wf(:,294)) * den(319)
  A(434) = cont_QA(wf(:,19),wf(:,294)) * den(320)
  A(435) = cont_QA(wf(:,181),wf(:,295)) * den(321)
  A(436) = cont_QA(wf(:,182),wf(:,295)) * den(322)
  A(437) = cont_QA(wf(:,181),wf(:,296)) * den(323)
  A(438) = cont_QA(wf(:,182),wf(:,296)) * den(324)
  A(439) = cont_QA(wf(:,177),wf(:,297)) * den(325)
  A(440) = cont_QA(wf(:,177),wf(:,298)) * den(326)
  A(441) = cont_QA(wf(:,179),wf(:,297)) * den(327)
  A(442) = cont_QA(wf(:,179),wf(:,298)) * den(328)
  A(443) = cont_QA(wf(:,199),wf(:,299)) * den(329)
  A(444) = cont_QA(wf(:,200),wf(:,299)) * den(330)
  A(445) = cont_QA(wf(:,199),wf(:,300)) * den(331)
  A(446) = cont_QA(wf(:,200),wf(:,300)) * den(332)
  A(447) = cont_QA(wf(:,195),wf(:,301)) * den(333)
  A(448) = cont_QA(wf(:,195),wf(:,302)) * den(334)
  A(449) = cont_QA(wf(:,197),wf(:,301)) * den(335)
  A(450) = cont_QA(wf(:,197),wf(:,302)) * den(336)
  A(451) = cont_QA(wf(:,25),wf(:,305)) * den(339)
  A(452) = cont_QA(wf(:,25),wf(:,306)) * den(341)
  A(453) = cont_QA(wf(:,28),wf(:,305)) * den(342)
  A(454) = cont_QA(wf(:,28),wf(:,306)) * den(343)
  A(455) = cont_QA(wf(:,31),wf(:,307)) * den(345)
  A(456) = cont_QA(wf(:,33),wf(:,307)) * den(346)
  A(457) = cont_QA(wf(:,31),wf(:,308)) * den(348)
  A(458) = cont_QA(wf(:,33),wf(:,308)) * den(349)
  A(459) = cont_QA(wf(:,299),wf(:,310)) * den(351)
  A(460) = cont_QA(wf(:,299),wf(:,312)) * den(353)
  A(461) = cont_QA(wf(:,300),wf(:,310)) * den(354)
  A(462) = cont_QA(wf(:,300),wf(:,312)) * den(355)
  A(463) = cont_QA(wf(:,301),wf(:,314)) * den(357)
  A(464) = cont_QA(wf(:,302),wf(:,314)) * den(358)
  A(465) = cont_QA(wf(:,301),wf(:,316)) * den(360)
  A(466) = cont_QA(wf(:,302),wf(:,316)) * den(361)
  A(467) = cont_QA(wf(:,297),wf(:,317)) * den(363)
  A(468) = cont_QA(wf(:,298),wf(:,317)) * den(364)
  A(469) = cont_QA(wf(:,297),wf(:,318)) * den(366)
  A(470) = cont_QA(wf(:,298),wf(:,318)) * den(367)
  A(471) = cont_QA(wf(:,295),wf(:,319)) * den(369)
  A(472) = cont_QA(wf(:,295),wf(:,320)) * den(371)
  A(473) = cont_QA(wf(:,296),wf(:,319)) * den(372)
  A(474) = cont_QA(wf(:,296),wf(:,320)) * den(373)
  A(475) = cont_VV(wf(:,42),wf(:,321)) * den(376)
  A(476) = cont_VV(wf(:,322),wf(:,323)) * den(379)
  A(477) = cont_VV(wf(:,48),wf(:,321)) * den(381)
  A(478) = cont_VV(wf(:,322),wf(:,324)) * den(383)
  A(479) = cont_VV(wf(:,52),wf(:,321)) * den(385)
  A(480) = cont_VV(wf(:,322),wf(:,325)) * den(387)
  A(481) = cont_VV(wf(:,56),wf(:,321)) * den(389)
  A(482) = cont_VV(wf(:,322),wf(:,326)) * den(391)
  A(483) = cont_VV(wf(:,42),wf(:,327)) * den(392)
  A(484) = cont_VV(wf(:,323),wf(:,328)) * den(393)
  A(485) = cont_VV(wf(:,48),wf(:,327)) * den(394)
  A(486) = cont_VV(wf(:,324),wf(:,328)) * den(395)
  A(487) = cont_VV(wf(:,52),wf(:,327)) * den(396)
  A(488) = cont_VV(wf(:,325),wf(:,328)) * den(397)
  A(489) = cont_VV(wf(:,56),wf(:,327)) * den(398)
  A(490) = cont_VV(wf(:,326),wf(:,328)) * den(399)
  A(491) = cont_QA(wf(:,65),wf(:,329)) * den(401)
  A(492) = cont_QA(wf(:,65),wf(:,330)) * den(403)
  A(493) = cont_QA(wf(:,72),wf(:,329)) * den(404)
  A(494) = cont_QA(wf(:,72),wf(:,330)) * den(405)
  A(495) = cont_QA(wf(:,75),wf(:,331)) * den(407)
  A(496) = cont_QA(wf(:,77),wf(:,331)) * den(408)
  A(497) = cont_QA(wf(:,75),wf(:,332)) * den(410)
  A(498) = cont_QA(wf(:,77),wf(:,332)) * den(411)
  A(499) = cont_QA(wf(:,258),wf(:,333)) * den(412)
  A(500) = cont_QA(wf(:,259),wf(:,333)) * den(413)
  A(501) = cont_QA(wf(:,258),wf(:,334)) * den(414)
  A(502) = cont_QA(wf(:,259),wf(:,334)) * den(415)
  A(503) = cont_QA(wf(:,254),wf(:,335)) * den(416)
  A(504) = cont_QA(wf(:,254),wf(:,336)) * den(417)
  A(505) = cont_QA(wf(:,256),wf(:,335)) * den(418)
  A(506) = cont_QA(wf(:,256),wf(:,336)) * den(419)
  A(507) = cont_QA(wf(:,274),wf(:,337)) * den(420)
  A(508) = cont_QA(wf(:,275),wf(:,337)) * den(421)
  A(509) = cont_QA(wf(:,274),wf(:,338)) * den(422)
  A(510) = cont_QA(wf(:,275),wf(:,338)) * den(423)
  A(511) = cont_QA(wf(:,270),wf(:,339)) * den(424)
  A(512) = cont_QA(wf(:,270),wf(:,340)) * den(425)
  A(513) = cont_QA(wf(:,272),wf(:,339)) * den(426)
  A(514) = cont_QA(wf(:,272),wf(:,340)) * den(427)
  A(515) = cont_QA(wf(:,81),wf(:,341)) * den(429)
  A(516) = cont_QA(wf(:,81),wf(:,342)) * den(431)
  A(517) = cont_QA(wf(:,84),wf(:,341)) * den(432)
  A(518) = cont_QA(wf(:,84),wf(:,342)) * den(433)
  A(519) = cont_QA(wf(:,87),wf(:,343)) * den(435)
  A(520) = cont_QA(wf(:,89),wf(:,343)) * den(436)
  A(521) = cont_QA(wf(:,87),wf(:,344)) * den(438)
  A(522) = cont_QA(wf(:,89),wf(:,344)) * den(439)
  A(523) = cont_QA(wf(:,337),wf(:,346)) * den(441)
  A(524) = cont_QA(wf(:,337),wf(:,348)) * den(443)
  A(525) = cont_QA(wf(:,338),wf(:,346)) * den(444)
  A(526) = cont_QA(wf(:,338),wf(:,348)) * den(445)
  A(527) = cont_QA(wf(:,339),wf(:,350)) * den(447)
  A(528) = cont_QA(wf(:,340),wf(:,350)) * den(448)
  A(529) = cont_QA(wf(:,339),wf(:,352)) * den(450)
  A(530) = cont_QA(wf(:,340),wf(:,352)) * den(451)
  A(531) = cont_QA(wf(:,335),wf(:,353)) * den(453)
  A(532) = cont_QA(wf(:,336),wf(:,353)) * den(454)
  A(533) = cont_QA(wf(:,335),wf(:,354)) * den(456)
  A(534) = cont_QA(wf(:,336),wf(:,354)) * den(457)
  A(535) = cont_QA(wf(:,333),wf(:,355)) * den(459)
  A(536) = cont_QA(wf(:,333),wf(:,356)) * den(461)
  A(537) = cont_QA(wf(:,334),wf(:,355)) * den(462)
  A(538) = cont_QA(wf(:,334),wf(:,356)) * den(463)
  A(539) = cont_VV(wf(:,97),wf(:,321)) * den(465)
  A(540) = cont_VV(wf(:,322),wf(:,357)) * den(467)
  A(541) = cont_VV(wf(:,101),wf(:,321)) * den(469)
  A(542) = cont_VV(wf(:,322),wf(:,358)) * den(471)
  A(543) = cont_VV(wf(:,105),wf(:,321)) * den(473)
  A(544) = cont_VV(wf(:,108),wf(:,321)) * den(475)
  A(545) = cont_VV(wf(:,322),wf(:,359)) * den(477)
  A(546) = cont_VV(wf(:,322),wf(:,360)) * den(479)
  A(547) = cont_VV(wf(:,97),wf(:,327)) * den(480)
  A(548) = cont_VV(wf(:,328),wf(:,357)) * den(481)
  A(549) = cont_VV(wf(:,101),wf(:,327)) * den(482)
  A(550) = cont_VV(wf(:,328),wf(:,358)) * den(483)
  A(551) = cont_VV(wf(:,105),wf(:,327)) * den(484)
  A(552) = cont_VV(wf(:,108),wf(:,327)) * den(485)
  A(553) = cont_VV(wf(:,328),wf(:,359)) * den(486)
  A(554) = cont_VV(wf(:,328),wf(:,360)) * den(487)
  A(555) = cont_VV(wf(:,113),wf(:,321)) * den(489)
  A(556) = cont_VV(wf(:,322),wf(:,361)) * den(491)
  A(557) = cont_VV(wf(:,117),wf(:,321)) * den(493)
  A(558) = cont_VV(wf(:,322),wf(:,362)) * den(495)
  A(559) = cont_VV(wf(:,121),wf(:,321)) * den(497)
  A(560) = cont_VV(wf(:,322),wf(:,363)) * den(499)
  A(561) = cont_VV(wf(:,125),wf(:,321)) * den(501)
  A(562) = cont_VV(wf(:,322),wf(:,364)) * den(503)
  A(563) = cont_VV(wf(:,113),wf(:,327)) * den(504)
  A(564) = cont_VV(wf(:,328),wf(:,361)) * den(505)
  A(565) = cont_VV(wf(:,117),wf(:,327)) * den(506)
  A(566) = cont_VV(wf(:,328),wf(:,362)) * den(507)
  A(567) = cont_VV(wf(:,121),wf(:,327)) * den(508)
  A(568) = cont_VV(wf(:,328),wf(:,363)) * den(509)
  A(569) = cont_VV(wf(:,125),wf(:,327)) * den(510)
  A(570) = cont_VV(wf(:,328),wf(:,364)) * den(511)
  A(571) = cont_VV(wf(:,129),wf(:,321)) * den(513)
  A(572) = cont_VV(wf(:,322),wf(:,365)) * den(515)
  A(573) = cont_VV(wf(:,133),wf(:,321)) * den(517)
  A(574) = cont_VV(wf(:,322),wf(:,366)) * den(519)
  A(575) = cont_VV(wf(:,137),wf(:,321)) * den(521)
  A(576) = cont_VV(wf(:,140),wf(:,321)) * den(523)
  A(577) = cont_VV(wf(:,322),wf(:,367)) * den(525)
  A(578) = cont_VV(wf(:,322),wf(:,368)) * den(527)
  A(579) = cont_VV(wf(:,129),wf(:,327)) * den(528)
  A(580) = cont_VV(wf(:,328),wf(:,365)) * den(529)
  A(581) = cont_VV(wf(:,133),wf(:,327)) * den(530)
  A(582) = cont_VV(wf(:,328),wf(:,366)) * den(531)
  A(583) = cont_VV(wf(:,137),wf(:,327)) * den(532)
  A(584) = cont_VV(wf(:,140),wf(:,327)) * den(533)
  A(585) = cont_VV(wf(:,328),wf(:,367)) * den(534)
  A(586) = cont_VV(wf(:,328),wf(:,368)) * den(535)


  ! colour vectors

  M1(1) = (-A(1)-A(5)-A(9)-A(13)-A(17)-A(21)+A(41)+A(45)+A(49)+A(53)+A(57)+A(61))*f(1)+(-A(2)-A(3)-A(6)-A(7)-A(10)-A(11)-A(14) &
       -A(15)-A(18)-A(19)-A(22)-A(23)-A(25)-A(27)-A(29)-A(31)-A(33)-A(35)-A(37)-A(39)+A(42)+A(43)+A(46)+A(47)+A(50)+A(51)+A(54) &
       +A(55)+A(58)+A(59)+A(62)+A(63)+A(65)+A(67)+A(69)+A(70)+A(73)+A(75)+A(77)+A(78)+A(81)+A(83)+A(85)+A(87)+A(89)+A(91)+A(93) &
       +A(95)-A(97)-A(99)-A(101)-A(102)-A(105)-A(107)-A(109)-A(110))*f(2)+(-A(4)-A(8)-A(12)-A(16)-A(20)-A(24)-A(26)-A(28)-A(30) &
       -A(32)-A(34)-A(36)-A(38)-A(40)+A(44)+A(48)+A(52)+A(56)+A(60)+A(64)+A(66)+A(68)+A(71)+A(72)+A(74)+A(76)+A(79)+A(80)+A(82) &
       +A(84)+A(86)+A(88)+A(90)+A(92)+A(94)+A(96)-A(98)-A(100)-A(103)-A(104)-A(106)-A(108)-A(111)-A(112))*f(3)

  M2(1) = (A(427)+A(431)+A(435)+A(439)+A(443)+A(447)+A(451)+A(455)+A(459)+A(463)+A(467)+A(471)-A(491)-A(495)-A(499)-A(503)-A(507) &
       -A(511)-A(515)-A(519)-A(523)-A(527)-A(531)-A(535))*f(4)+(A(428)+A(429)+A(432)+A(433)+A(436)+A(437)+A(440)+A(441)+A(444) &
       +A(445)+A(448)+A(449)+A(452)+A(453)+A(456)+A(457)+A(460)+A(461)+A(464)+A(465)+A(468)+A(469)+A(472)+A(473)+A(475)+A(477) &
       +A(479)+A(481)+A(483)+A(485)+A(487)+A(489)-A(492)-A(493)-A(496)-A(497)-A(500)-A(501)-A(504)-A(505)-A(508)-A(509)-A(512) &
       -A(513)-A(516)-A(517)-A(520)-A(521)-A(524)-A(525)-A(528)-A(529)-A(532)-A(533)-A(536)-A(537)-A(539)-A(541)-A(543)-A(544) &
       -A(547)-A(549)-A(551)-A(552)-A(555)-A(557)-A(559)-A(561)-A(563)-A(565)-A(567)-A(569)+A(571)+A(573)+A(575)+A(576)+A(579) &
       +A(581)+A(583)+A(584))*f(5)+(A(430)+A(434)+A(438)+A(442)+A(446)+A(450)+A(454)+A(458)+A(462)+A(466)+A(470)+A(474)+A(476) &
       +A(478)+A(480)+A(482)+A(484)+A(486)+A(488)+A(490)-A(494)-A(498)-A(502)-A(506)-A(510)-A(514)-A(518)-A(522)-A(526)-A(530) &
       -A(534)-A(538)-A(540)-A(542)-A(545)-A(546)-A(548)-A(550)-A(553)-A(554)-A(556)-A(558)-A(560)-A(562)-A(564)-A(566)-A(568) &
       -A(570)+A(572)+A(574)+A(577)+A(578)+A(580)+A(582)+A(585)+A(586))*f(6)+(-A(113)+A(117))*f(7)+(-A(114)-A(115)+A(118) &
       +A(119))*f(8)+(-A(138)-A(144)-A(170)-A(174)-A(194)-A(198)+A(255)+A(261)+A(287)+A(291)+A(311)+A(315))*f(9)+(-A(139)-A(140) &
       -A(145)-A(146)-A(171)-A(172)-A(175)-A(176)-A(195)-A(196)-A(199)-A(200)-A(214)-A(216)-A(218)-A(220)-A(230)-A(232)-A(234) &
       -A(236)+A(256)+A(257)+A(262)+A(263)+A(288)+A(289)+A(292)+A(293)+A(312)+A(313)+A(316)+A(317)+A(331)+A(333)+A(335)+A(336) &
       +A(347)+A(349)+A(351)+A(352)+A(367)+A(369)+A(371)+A(373)+A(383)+A(385)+A(387)+A(389)-A(403)-A(405)-A(407)-A(408)-A(419) &
       -A(421)-A(423)-A(424))*f(10)+(-A(141)-A(147)-A(173)-A(177)-A(197)-A(201)-A(215)-A(217)-A(219)-A(221)-A(231)-A(233)-A(235) &
       -A(237)+A(258)+A(264)+A(290)+A(294)+A(314)+A(318)+A(332)+A(334)+A(337)+A(338)+A(348)+A(350)+A(353)+A(354)+A(368)+A(370) &
       +A(372)+A(374)+A(384)+A(386)+A(388)+A(390)-A(404)-A(406)-A(409)-A(410)-A(420)-A(422)-A(425)-A(426))*f(11)+(-A(122)-A(126) &
       -A(130)-A(134)-A(154)-A(158)-A(162)-A(166)-A(178)-A(182)-A(186)-A(190)+A(239)+A(243)+A(247)+A(251)+A(271)+A(275)+A(279) &
       +A(283)+A(295)+A(299)+A(303)+A(307))*f(12)+(-A(123)-A(124)-A(127)-A(128)-A(131)-A(132)-A(135)-A(136)-A(155)-A(156)-A(159) &
       -A(160)-A(163)-A(164)-A(167)-A(168)-A(179)-A(180)-A(183)-A(184)-A(187)-A(188)-A(191)-A(192)-A(206)-A(208)-A(210)-A(212) &
       -A(222)-A(224)-A(226)-A(228)+A(240)+A(241)+A(244)+A(245)+A(248)+A(249)+A(252)+A(253)+A(272)+A(273)+A(276)+A(277)+A(280) &
       +A(281)+A(284)+A(285)+A(296)+A(297)+A(300)+A(301)+A(304)+A(305)+A(308)+A(309)+A(323)+A(325)+A(327)+A(328)+A(339)+A(341) &
       +A(343)+A(344)+A(359)+A(361)+A(363)+A(365)+A(375)+A(377)+A(379)+A(381)-A(395)-A(397)-A(399)-A(400)-A(411)-A(413)-A(415) &
       -A(416))*f(13)+(-A(125)-A(129)-A(133)-A(137)-A(157)-A(161)-A(165)-A(169)-A(181)-A(185)-A(189)-A(193)-A(207)-A(209)-A(211) &
       -A(213)-A(223)-A(225)-A(227)-A(229)+A(242)+A(246)+A(250)+A(254)+A(274)+A(278)+A(282)+A(286)+A(298)+A(302)+A(306)+A(310) &
       +A(324)+A(326)+A(329)+A(330)+A(340)+A(342)+A(345)+A(346)+A(360)+A(362)+A(364)+A(366)+A(376)+A(378)+A(380)+A(382)-A(396) &
       -A(398)-A(401)-A(402)-A(412)-A(414)-A(417)-A(418))*f(14)+(A(142)+A(148)+A(150)+A(152)-A(259)-A(265)-A(267)-A(269))*f(15) &
       +(A(143)+A(149)+A(151)+A(153)+A(202)+A(203)+A(204)+A(205)-A(260)-A(266)-A(268)-A(270)-A(319)-A(320)-A(321)-A(322)-A(355) &
       -A(356)-A(357)-A(358)+A(391)+A(392)+A(393)+A(394))*f(16)+(-A(116)+A(120))*f(17)+(A(121)-A(238))*f(18)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_eeexexddxg_1_/**/REALKIND
