
module ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(30,1), K2(1,1), KL(1,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12]
  K1( 2,:) = [   0]
  K1( 3,:) = [   0]
  K1( 4,:) = [   0]
  K1( 5,:) = [   0]
  K1( 6,:) = [   0]
  K1( 7,:) = [   0]
  K1( 8,:) = [   0]
  K1( 9,:) = [   0]
  K1(10,:) = [   0]
  K1(11,:) = [   0]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [  16]
  K1(17,:) = [   0]
  K1(18,:) = [   0]
  K1(19,:) = [   0]
  K1(20,:) = [   0]
  K1(21,:) = [   2]
  K1(22,:) = [  16]
  K1(23,:) = [   0]
  K1(24,:) = [   0]
  K1(25,:) = [   0]
  K1(26,:) = [   0]
  K1(27,:) = [ -18]
  K1(28,:) = [ -18]
  K1(29,:) = [  36]
  K1(30,:) = [  12]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 4]

  KL(1,:) = [ 4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND



module ol_forced_parameters_ppllllj_eeexexbbxg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf
#endif
    implicit none
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (ML /= 0) write(*,101) 'ML = 0'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'

    101 format('========',/,'WARNING: code was generated with ',A,/,'========')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppllllj_eeexexbbxg_1_/**/REALKIND

module ol_loop_ppllllj_eeexexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(41), c(23)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-7+1:576)
  ! denominators
  complex(REALKIND), save :: den(1020)
  ! Born colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,128)
  ! zero helicity identifier
  logical,           save :: zerohel(128) = .true., zerohel_ct(128) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: parameters_init, loop_parameters_init
  use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
#endif
  implicit none
  if (parameters_status == 0) call parameters_init()
  if (loop_parameters_status == 0) call loop_parameters_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4*gQCD)/9._/**/REALKIND
    f( 2) = (CI*eQED**4*gQCD)/3._/**/REALKIND
    f( 3) = CI*eQED**4*gQCD
    f( 4) = (CI*countertermnorm*eQED**4*gQCD**3)/9._/**/REALKIND
    f( 5) = (CI*countertermnorm*eQED**4*gQCD**3)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**4*gQCD**3
    f( 7) = CI*countertermnorm*ctAAGG*eQED**4*gQCD**3
    f( 8) = CI*countertermnorm*ctAZGG*eQED**4*gQCD**3
    f( 9) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/9._/**/REALKIND
    f(10) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f(11) = CI*countertermnorm*ctGbb*eQED**4*gQCD**3
    f(12) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/9._/**/REALKIND
    f(13) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**3)/3._/**/REALKIND
    f(14) = CI*countertermnorm*ctVbb*eQED**4*gQCD**3
    f(15) = (countertermnorm*ctZGG*eQED**4*gQCD**3)/3._/**/REALKIND
    f(16) = countertermnorm*ctZGG*eQED**4*gQCD**3
    f(17) = CI*countertermnorm*ctZZGG*eQED**4*gQCD**3
    f(18) = (CI*eQED**4*gQCD*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(19) = (CI*countertermnorm*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(20) = (CI*countertermnorm*ctGbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(21) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**3*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(22) = (CI*countertermnorm*ctHGG*eQED**4*gQCD**3*MW)/(cw**2*sw)
    f(23) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(24) = (CI*eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(25) = CI*eQED**4*gQCD**3*integralnorm*SwB
    f(26) = (eQED**4*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(27) = (eQED**4*gQCD**3*integralnorm*SwB)/3._/**/REALKIND
    f(28) = eQED**4*gQCD**3*integralnorm*SwB
    f(29) = (CI*eQED**4*gQCD**3*integralnorm*MB*SwB)/(2._/**/REALKIND*cw**2*sw**2)
    f(30) = (eQED**4*gQCD**3*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(31) = (eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(32) = (2*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(33) = (eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(34) = (4*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(35) = (2*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(36) = (8*eQED**4*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(37) = eQED**4*gQCD**3*integralnorm*SwF
    f(38) = (4*eQED**4*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f(39) = 2*eQED**4*gQCD**3*integralnorm*SwF
    f(40) = (eQED**4*gQCD**3*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(41) = (eQED**4*gQCD**3*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ 9*CI*f(23), 9*CI*f(24), 9*CI*f(25), f(26), 8*f(26), f(27), 8*f(27), f(28), 8*f(28), 9*CI*f(29), f(30), 8*f(30), 3*f(31) &
    , 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_contractions_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none

  real(REALKIND),    intent(in)  :: P(0:3,7)
  integer,           intent(in)  :: H(7)
  complex(REALKIND), intent(out) :: M1(1), M2(1)
  complex(REALKIND) :: A(602)

  ! external WFs

  call wf_Q(P(:,1), rZERO, H(1), wf(:,0))
  call wf_Q(P(:,2), rZERO, H(2), wf(:,-1))
  call wf_A(P(:,3), rZERO, H(3), wf(:,-2))
  call wf_A(P(:,4), rZERO, H(4), wf(:,-3))
  call wf_Q(P(:,5), rMB, H(5), wf(:,-4))
  call wf_A(P(:,6), rMB, H(6), wf(:,-5))
  call wf_V(P(:,7), rZERO, H(7), wf(:,-6))


  ! internal WFs

  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_VQ_A(wf(:,-6),wf(:,-4),wf(:,3))
  call prop_Q_A(wf(:,3),Q(:,80),MB,1_intkind1,wf(:,4))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,5))
  call vert_VQ_A(wf(:,2),wf(:,4),wf(:,6))
  call prop_A_Q(wf(:,5),Q(:,37),MB,1_intkind1,wf(:,7))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-3),wf(:,8))
  call prop_W_W(wf(:,8),Q(:,10),MZ,1_intkind1,wf(:,9))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,4),wf(:,10))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-2),wf(:,11))
  call prop_W_W(wf(:,11),Q(:,5),MZ,1_intkind1,wf(:,12))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,12),wf(:,13))
  call prop_A_Q(wf(:,13),Q(:,37),MB,1_intkind1,wf(:,14))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,15))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,16))
  call prop_A_Q(wf(:,15),Q(:,42),MB,1_intkind1,wf(:,17))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,9),wf(:,18))
  call prop_A_Q(wf(:,18),Q(:,42),MB,1_intkind1,wf(:,19))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,4),wf(:,20))
  call vert_AQ_S(gH,wf(:,-5),wf(:,4),wf(:,21))
  call vert_VV_S(wf(:,12),wf(:,9),wf(:,22))
  call vert_AV_Q(wf(:,-5),wf(:,-6),wf(:,23))
  call prop_A_Q(wf(:,23),Q(:,96),MB,1_intkind1,wf(:,24))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,25))
  call vert_AV_Q(wf(:,24),wf(:,2),wf(:,26))
  call prop_Q_A(wf(:,25),Q(:,21),MB,1_intkind1,wf(:,27))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,9),wf(:,28))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,-4),wf(:,29))
  call prop_Q_A(wf(:,29),Q(:,21),MB,1_intkind1,wf(:,30))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,31))
  call vert_AV_Q(wf(:,24),wf(:,1),wf(:,32))
  call prop_Q_A(wf(:,31),Q(:,26),MB,1_intkind1,wf(:,33))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,-4),wf(:,34))
  call prop_Q_A(wf(:,34),Q(:,26),MB,1_intkind1,wf(:,35))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,12),wf(:,36))
  call vert_AQ_S(gH,wf(:,24),wf(:,-4),wf(:,37))
  call vert_VQ_A(wf(:,-6),wf(:,27),wf(:,38))
  call vert_VQ_A(wf(:,-6),wf(:,30),wf(:,39))
  call vert_VQ_A(wf(:,-6),wf(:,33),wf(:,40))
  call vert_VQ_A(wf(:,-6),wf(:,35),wf(:,41))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,42))
  call vert_QA_V(wf(:,4),wf(:,-5),wf(:,43))
  call prop_Q_A(wf(:,42),Q(:,7),ZERO,0_intkind1,wf(:,44))
  call vert_QA_V(wf(:,44),wf(:,-3),wf(:,45))
  call vert_QA_Z(gZd,wf(:,4),wf(:,-5),wf(:,46))
  call prop_W_W(wf(:,46),Q(:,112),MZ,1_intkind1,wf(:,47))
  call vert_QA_Z(gZl,wf(:,44),wf(:,-3),wf(:,48))
  call vert_ZQ_A(gZl,wf(:,12),wf(:,-1),wf(:,49))
  call prop_Q_A(wf(:,49),Q(:,7),ZERO,0_intkind1,wf(:,50))
  call vert_QA_V(wf(:,50),wf(:,-3),wf(:,51))
  call vert_QA_Z(gZl,wf(:,50),wf(:,-3),wf(:,52))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,53))
  call prop_A_Q(wf(:,53),Q(:,13),ZERO,0_intkind1,wf(:,54))
  call vert_QA_V(wf(:,-1),wf(:,54),wf(:,55))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,54),wf(:,56))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,12),wf(:,57))
  call prop_A_Q(wf(:,57),Q(:,13),ZERO,0_intkind1,wf(:,58))
  call vert_QA_V(wf(:,-1),wf(:,58),wf(:,59))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,58),wf(:,60))
  call vert_QA_V(wf(:,-4),wf(:,24),wf(:,61))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,24),wf(:,62))
  call prop_W_W(wf(:,62),Q(:,112),MZ,1_intkind1,wf(:,63))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,64))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,65))
  call vert_AV_Q(wf(:,-5),wf(:,64),wf(:,66))
  call vert_VQ_A(wf(:,65),wf(:,4),wf(:,67))
  call prop_A_Q(wf(:,66),Q(:,41),MB,1_intkind1,wf(:,68))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,-2),wf(:,69))
  call prop_W_W(wf(:,69),Q(:,6),MZ,1_intkind1,wf(:,70))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,4),wf(:,71))
  call vert_QA_Z(gZl,wf(:,0),wf(:,-3),wf(:,72))
  call prop_W_W(wf(:,72),Q(:,9),MZ,1_intkind1,wf(:,73))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,73),wf(:,74))
  call prop_A_Q(wf(:,74),Q(:,41),MB,1_intkind1,wf(:,75))
  call vert_AV_Q(wf(:,-5),wf(:,65),wf(:,76))
  call vert_VQ_A(wf(:,64),wf(:,4),wf(:,77))
  call prop_A_Q(wf(:,76),Q(:,38),MB,1_intkind1,wf(:,78))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,70),wf(:,79))
  call prop_A_Q(wf(:,79),Q(:,38),MB,1_intkind1,wf(:,80))
  call vert_ZQ_A(gZd,wf(:,73),wf(:,4),wf(:,81))
  call vert_VV_S(wf(:,70),wf(:,73),wf(:,82))
  call vert_VQ_A(wf(:,64),wf(:,-4),wf(:,83))
  call vert_AV_Q(wf(:,24),wf(:,65),wf(:,84))
  call prop_Q_A(wf(:,83),Q(:,25),MB,1_intkind1,wf(:,85))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,70),wf(:,86))
  call vert_ZQ_A(gZd,wf(:,73),wf(:,-4),wf(:,87))
  call prop_Q_A(wf(:,87),Q(:,25),MB,1_intkind1,wf(:,88))
  call vert_VQ_A(wf(:,65),wf(:,-4),wf(:,89))
  call vert_AV_Q(wf(:,24),wf(:,64),wf(:,90))
  call prop_Q_A(wf(:,89),Q(:,22),MB,1_intkind1,wf(:,91))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,-4),wf(:,92))
  call prop_Q_A(wf(:,92),Q(:,22),MB,1_intkind1,wf(:,93))
  call vert_AZ_Q(gZd,wf(:,24),wf(:,73),wf(:,94))
  call vert_VQ_A(wf(:,-6),wf(:,85),wf(:,95))
  call vert_VQ_A(wf(:,-6),wf(:,88),wf(:,96))
  call vert_VQ_A(wf(:,-6),wf(:,91),wf(:,97))
  call vert_VQ_A(wf(:,-6),wf(:,93),wf(:,98))
  call vert_VQ_A(wf(:,65),wf(:,0),wf(:,99))
  call prop_Q_A(wf(:,99),Q(:,7),ZERO,0_intkind1,wf(:,100))
  call vert_QA_V(wf(:,100),wf(:,-3),wf(:,101))
  call vert_QA_Z(gZl,wf(:,100),wf(:,-3),wf(:,102))
  call vert_ZQ_A(gZl,wf(:,70),wf(:,0),wf(:,103))
  call prop_Q_A(wf(:,103),Q(:,7),ZERO,0_intkind1,wf(:,104))
  call vert_QA_V(wf(:,104),wf(:,-3),wf(:,105))
  call vert_QA_Z(gZl,wf(:,104),wf(:,-3),wf(:,106))
  call vert_AV_Q(wf(:,-3),wf(:,65),wf(:,107))
  call prop_A_Q(wf(:,107),Q(:,14),ZERO,0_intkind1,wf(:,108))
  call vert_QA_V(wf(:,0),wf(:,108),wf(:,109))
  call vert_AZ_Q(gZl,wf(:,-3),wf(:,70),wf(:,110))
  call prop_A_Q(wf(:,110),Q(:,14),ZERO,0_intkind1,wf(:,111))
  call vert_QA_V(wf(:,0),wf(:,111),wf(:,112))
  call vert_QA_Z(gZl,wf(:,0),wf(:,108),wf(:,113))
  call vert_QA_Z(gZl,wf(:,0),wf(:,111),wf(:,114))
  call vert_VQ_A(wf(:,64),wf(:,-1),wf(:,115))
  call prop_Q_A(wf(:,115),Q(:,11),ZERO,0_intkind1,wf(:,116))
  call vert_QA_V(wf(:,116),wf(:,-2),wf(:,117))
  call vert_QA_Z(gZl,wf(:,116),wf(:,-2),wf(:,118))
  call vert_ZQ_A(gZl,wf(:,73),wf(:,-1),wf(:,119))
  call prop_Q_A(wf(:,119),Q(:,11),ZERO,0_intkind1,wf(:,120))
  call vert_QA_V(wf(:,120),wf(:,-2),wf(:,121))
  call vert_QA_Z(gZl,wf(:,120),wf(:,-2),wf(:,122))
  call vert_AV_Q(wf(:,-2),wf(:,64),wf(:,123))
  call prop_A_Q(wf(:,123),Q(:,13),ZERO,0_intkind1,wf(:,124))
  call vert_QA_V(wf(:,-1),wf(:,124),wf(:,125))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,124),wf(:,126))
  call vert_AZ_Q(gZl,wf(:,-2),wf(:,73),wf(:,127))
  call prop_A_Q(wf(:,127),Q(:,13),ZERO,0_intkind1,wf(:,128))
  call vert_QA_V(wf(:,-1),wf(:,128),wf(:,129))
  call vert_QA_Z(gZl,wf(:,-1),wf(:,128),wf(:,130))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,131))
  call prop_Q_A(wf(:,131),Q(:,11),ZERO,0_intkind1,wf(:,132))
  call vert_QA_V(wf(:,132),wf(:,-2),wf(:,133))
  call vert_QA_Z(gZl,wf(:,132),wf(:,-2),wf(:,134))
  call vert_ZQ_A(gZl,wf(:,9),wf(:,0),wf(:,135))
  call prop_Q_A(wf(:,135),Q(:,11),ZERO,0_intkind1,wf(:,136))
  call vert_QA_V(wf(:,136),wf(:,-2),wf(:,137))
  call vert_QA_Z(gZl,wf(:,136),wf(:,-2),wf(:,138))
  call vert_AV_Q(wf(:,-2),wf(:,2),wf(:,139))
  call prop_A_Q(wf(:,139),Q(:,14),ZERO,0_intkind1,wf(:,140))
  call vert_QA_V(wf(:,0),wf(:,140),wf(:,141))
  call vert_AZ_Q(gZl,wf(:,-2),wf(:,9),wf(:,142))
  call prop_A_Q(wf(:,142),Q(:,14),ZERO,0_intkind1,wf(:,143))
  call vert_QA_V(wf(:,0),wf(:,143),wf(:,144))
  call vert_QA_Z(gZl,wf(:,0),wf(:,140),wf(:,145))
  call vert_QA_Z(gZl,wf(:,0),wf(:,143),wf(:,146))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,147))
  call counter_VVG_G(wf(:,1),wf(:,2),wf(:,-6),wf(:,148))
  call counter_VVG_G(wf(:,1),wf(:,9),wf(:,-6),wf(:,149))
  call counter_VVG_G(wf(:,12),wf(:,2),wf(:,-6),wf(:,150))
  call counter_VVG_G(wf(:,12),wf(:,9),wf(:,-6),wf(:,151))
  call counter_VVG_G(wf(:,65),wf(:,64),wf(:,-6),wf(:,152))
  call counter_VVG_G(wf(:,70),wf(:,64),wf(:,-6),wf(:,153))
  call counter_VVG_G(wf(:,65),wf(:,73),wf(:,-6),wf(:,154))
  call counter_VVG_G(wf(:,70),wf(:,73),wf(:,-6),wf(:,155))
  call counter_GG_S(wf(:,147),wf(:,-6),wf(:,156))
  call counter_VQ_A(wf(:,2),wf(:,4),wf(:,157))
  call counter_ZQ_A(gZd,wf(:,9),wf(:,4),wf(:,158))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,159))
  call counter_ZQ_A(gZd,wf(:,12),wf(:,4),wf(:,160))
  call counter_AV_Q(wf(:,24),wf(:,2),wf(:,161))
  call counter_AZ_Q(gZd,wf(:,24),wf(:,9),wf(:,162))
  call counter_AV_Q(wf(:,24),wf(:,1),wf(:,163))
  call counter_AZ_Q(gZd,wf(:,24),wf(:,12),wf(:,164))
  call counter_VQ_A(wf(:,-6),wf(:,27),wf(:,165))
  call counter_VQ_A(wf(:,-6),wf(:,30),wf(:,166))
  call counter_VG_G(wf(:,9),wf(:,-6),Q(:,64),wf(:,167),Q(:,74))
  call vert_QA_V(wf(:,27),wf(:,-5),wf(:,168))
  call vert_QA_V(wf(:,30),wf(:,-5),wf(:,169))
  call counter_VQ_A(wf(:,-6),wf(:,33),wf(:,170))
  call counter_VQ_A(wf(:,-6),wf(:,35),wf(:,171))
  call vert_QA_V(wf(:,-4),wf(:,7),wf(:,172))
  call vert_QA_V(wf(:,-4),wf(:,14),wf(:,173))
  call counter_VG_G(wf(:,12),wf(:,-6),Q(:,64),wf(:,174),Q(:,69))
  call vert_QA_V(wf(:,33),wf(:,-5),wf(:,175))
  call vert_QA_V(wf(:,35),wf(:,-5),wf(:,176))
  call vert_QA_V(wf(:,-4),wf(:,17),wf(:,177))
  call vert_QA_V(wf(:,-4),wf(:,19),wf(:,178))
  call counter_AQ_S(gH,wf(:,-5),wf(:,4),wf(:,179))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,180))
  call prop_Q_A(wf(:,16),Q(:,85),MB,1_intkind1,wf(:,181))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,9),wf(:,182))
  call prop_Q_A(wf(:,20),Q(:,85),MB,1_intkind1,wf(:,183))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,184))
  call prop_Q_A(wf(:,6),Q(:,90),MB,1_intkind1,wf(:,185))
  call prop_Q_A(wf(:,10),Q(:,90),MB,1_intkind1,wf(:,186))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,12),wf(:,187))
  call prop_A_Q(wf(:,180),Q(:,42),MB,1_intkind1,wf(:,188))
  call prop_A_Q(wf(:,182),Q(:,42),MB,1_intkind1,wf(:,189))
  call prop_A_Q(wf(:,184),Q(:,37),MB,1_intkind1,wf(:,190))
  call prop_A_Q(wf(:,187),Q(:,37),MB,1_intkind1,wf(:,191))
  call counter_AV_Q(wf(:,-5),wf(:,-6),wf(:,192))
  call prop_A_Q(wf(:,192),Q(:,96),MB,1_intkind1,wf(:,193))
  call vert_AV_Q(wf(:,193),wf(:,2),wf(:,194))
  call vert_AZ_Q(gZd,wf(:,193),wf(:,9),wf(:,195))
  call vert_AV_Q(wf(:,193),wf(:,1),wf(:,196))
  call vert_AZ_Q(gZd,wf(:,193),wf(:,12),wf(:,197))
  call vert_AQ_S(gH,wf(:,193),wf(:,-4),wf(:,198))
  call counter_AQ_S(gH,wf(:,24),wf(:,-4),wf(:,199))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,200))
  call prop_A_Q(wf(:,32),Q(:,101),MB,1_intkind1,wf(:,201))
  call counter_ZQ_A(gZd,wf(:,9),wf(:,-4),wf(:,202))
  call prop_A_Q(wf(:,36),Q(:,101),MB,1_intkind1,wf(:,203))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,204))
  call prop_A_Q(wf(:,26),Q(:,106),MB,1_intkind1,wf(:,205))
  call prop_A_Q(wf(:,28),Q(:,106),MB,1_intkind1,wf(:,206))
  call counter_ZQ_A(gZd,wf(:,12),wf(:,-4),wf(:,207))
  call prop_Q_A(wf(:,200),Q(:,26),MB,1_intkind1,wf(:,208))
  call vert_VQ_A(wf(:,-6),wf(:,208),wf(:,209))
  call prop_Q_A(wf(:,202),Q(:,26),MB,1_intkind1,wf(:,210))
  call vert_VQ_A(wf(:,-6),wf(:,210),wf(:,211))
  call prop_Q_A(wf(:,204),Q(:,21),MB,1_intkind1,wf(:,212))
  call vert_VQ_A(wf(:,-6),wf(:,212),wf(:,213))
  call prop_Q_A(wf(:,207),Q(:,21),MB,1_intkind1,wf(:,214))
  call vert_VQ_A(wf(:,-6),wf(:,214),wf(:,215))
  call counter_VQ_A(wf(:,-6),wf(:,-4),wf(:,216))
  call prop_Q_A(wf(:,216),Q(:,80),MB,1_intkind1,wf(:,217))
  call vert_VQ_A(wf(:,2),wf(:,217),wf(:,218))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,217),wf(:,219))
  call vert_VQ_A(wf(:,1),wf(:,217),wf(:,220))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,217),wf(:,221))
  call vert_AQ_S(gH,wf(:,-5),wf(:,217),wf(:,222))
  call counter_GG_V(wf(:,147),Q(:,48),wf(:,-6),Q(:,64),wf(:,223))
  call prop_W_W(wf(:,223),Q(:,112),MZ,1_intkind1,wf(:,224))
  call counter_QA_V(wf(:,4),wf(:,-5),wf(:,225))
  call counter_QA_Z(gZd,wf(:,4),wf(:,-5),wf(:,226))
  call prop_W_W(wf(:,226),Q(:,112),MZ,1_intkind1,wf(:,227))
  call vert_QA_V(wf(:,-4),wf(:,193),wf(:,228))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,193),wf(:,229))
  call prop_W_W(wf(:,229),Q(:,112),MZ,1_intkind1,wf(:,230))
  call counter_QA_V(wf(:,-4),wf(:,24),wf(:,231))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,24),wf(:,232))
  call prop_W_W(wf(:,232),Q(:,112),MZ,1_intkind1,wf(:,233))
  call vert_QA_V(wf(:,217),wf(:,-5),wf(:,234))
  call vert_QA_Z(gZd,wf(:,217),wf(:,-5),wf(:,235))
  call prop_W_W(wf(:,235),Q(:,112),MZ,1_intkind1,wf(:,236))
  call counter_VQ_A(wf(:,65),wf(:,4),wf(:,237))
  call counter_ZQ_A(gZd,wf(:,70),wf(:,4),wf(:,238))
  call counter_VQ_A(wf(:,64),wf(:,4),wf(:,239))
  call counter_ZQ_A(gZd,wf(:,73),wf(:,4),wf(:,240))
  call counter_AV_Q(wf(:,24),wf(:,65),wf(:,241))
  call counter_AZ_Q(gZd,wf(:,24),wf(:,70),wf(:,242))
  call counter_AV_Q(wf(:,24),wf(:,64),wf(:,243))
  call counter_AZ_Q(gZd,wf(:,24),wf(:,73),wf(:,244))
  call counter_VQ_A(wf(:,-6),wf(:,85),wf(:,245))
  call counter_VQ_A(wf(:,-6),wf(:,88),wf(:,246))
  call counter_VG_G(wf(:,70),wf(:,-6),Q(:,64),wf(:,247),Q(:,70))
  call vert_QA_V(wf(:,85),wf(:,-5),wf(:,248))
  call vert_QA_V(wf(:,88),wf(:,-5),wf(:,249))
  call counter_VQ_A(wf(:,-6),wf(:,91),wf(:,250))
  call counter_VQ_A(wf(:,-6),wf(:,93),wf(:,251))
  call vert_QA_V(wf(:,-4),wf(:,68),wf(:,252))
  call vert_QA_V(wf(:,-4),wf(:,75),wf(:,253))
  call counter_VG_G(wf(:,73),wf(:,-6),Q(:,64),wf(:,254),Q(:,73))
  call vert_QA_V(wf(:,91),wf(:,-5),wf(:,255))
  call vert_QA_V(wf(:,93),wf(:,-5),wf(:,256))
  call vert_QA_V(wf(:,-4),wf(:,78),wf(:,257))
  call vert_QA_V(wf(:,-4),wf(:,80),wf(:,258))
  call counter_AV_Q(wf(:,-5),wf(:,65),wf(:,259))
  call prop_Q_A(wf(:,77),Q(:,89),MB,1_intkind1,wf(:,260))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,70),wf(:,261))
  call prop_Q_A(wf(:,81),Q(:,89),MB,1_intkind1,wf(:,262))
  call counter_AV_Q(wf(:,-5),wf(:,64),wf(:,263))
  call prop_Q_A(wf(:,67),Q(:,86),MB,1_intkind1,wf(:,264))
  call prop_Q_A(wf(:,71),Q(:,86),MB,1_intkind1,wf(:,265))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,73),wf(:,266))
  call prop_A_Q(wf(:,259),Q(:,38),MB,1_intkind1,wf(:,267))
  call prop_A_Q(wf(:,261),Q(:,38),MB,1_intkind1,wf(:,268))
  call prop_A_Q(wf(:,263),Q(:,41),MB,1_intkind1,wf(:,269))
  call prop_A_Q(wf(:,266),Q(:,41),MB,1_intkind1,wf(:,270))
  call vert_AV_Q(wf(:,193),wf(:,65),wf(:,271))
  call vert_AZ_Q(gZd,wf(:,193),wf(:,70),wf(:,272))
  call vert_AV_Q(wf(:,193),wf(:,64),wf(:,273))
  call vert_AZ_Q(gZd,wf(:,193),wf(:,73),wf(:,274))
  call counter_VQ_A(wf(:,65),wf(:,-4),wf(:,275))
  call prop_A_Q(wf(:,90),Q(:,105),MB,1_intkind1,wf(:,276))
  call counter_ZQ_A(gZd,wf(:,70),wf(:,-4),wf(:,277))
  call prop_A_Q(wf(:,94),Q(:,105),MB,1_intkind1,wf(:,278))
  call counter_VQ_A(wf(:,64),wf(:,-4),wf(:,279))
  call prop_A_Q(wf(:,84),Q(:,102),MB,1_intkind1,wf(:,280))
  call prop_A_Q(wf(:,86),Q(:,102),MB,1_intkind1,wf(:,281))
  call counter_ZQ_A(gZd,wf(:,73),wf(:,-4),wf(:,282))
  call prop_Q_A(wf(:,275),Q(:,22),MB,1_intkind1,wf(:,283))
  call vert_VQ_A(wf(:,-6),wf(:,283),wf(:,284))
  call prop_Q_A(wf(:,277),Q(:,22),MB,1_intkind1,wf(:,285))
  call vert_VQ_A(wf(:,-6),wf(:,285),wf(:,286))
  call prop_Q_A(wf(:,279),Q(:,25),MB,1_intkind1,wf(:,287))
  call vert_VQ_A(wf(:,-6),wf(:,287),wf(:,288))
  call prop_Q_A(wf(:,282),Q(:,25),MB,1_intkind1,wf(:,289))
  call vert_VQ_A(wf(:,-6),wf(:,289),wf(:,290))
  call vert_VQ_A(wf(:,65),wf(:,217),wf(:,291))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,217),wf(:,292))
  call vert_VQ_A(wf(:,64),wf(:,217),wf(:,293))
  call vert_ZQ_A(gZd,wf(:,73),wf(:,217),wf(:,294))
  call counter_Q_A(ctbb,wf(:,4),Q(:,80),wf(:,295))
  call prop_Q_A(wf(:,295),Q(:,80),MB,1_intkind1,wf(:,296))
  call vert_AQ_S(gH,wf(:,-5),wf(:,296),wf(:,297))
  call vert_VQ_A(wf(:,2),wf(:,296),wf(:,298))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,296),wf(:,299))
  call vert_VQ_A(wf(:,1),wf(:,296),wf(:,300))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,296),wf(:,301))
  call counter_A_Q(ctbb,wf(:,7),Q(:,37),wf(:,302))
  call counter_A_Q(ctbb,wf(:,14),Q(:,37),wf(:,303))
  call counter_A_Q(ctbb,wf(:,17),Q(:,42),wf(:,304))
  call counter_A_Q(ctbb,wf(:,19),Q(:,42),wf(:,305))
  call counter_A_Q(ctbb,wf(:,24),Q(:,96),wf(:,306))
  call prop_A_Q(wf(:,306),Q(:,96),MB,1_intkind1,wf(:,307))
  call vert_AQ_S(gH,wf(:,307),wf(:,-4),wf(:,308))
  call counter_Q_A(ctbb,wf(:,27),Q(:,21),wf(:,309))
  call counter_Q_A(ctbb,wf(:,30),Q(:,21),wf(:,310))
  call counter_Q_A(ctbb,wf(:,33),Q(:,26),wf(:,311))
  call counter_Q_A(ctbb,wf(:,35),Q(:,26),wf(:,312))
  call vert_AV_Q(wf(:,307),wf(:,2),wf(:,313))
  call vert_AZ_Q(gZd,wf(:,307),wf(:,9),wf(:,314))
  call vert_AV_Q(wf(:,307),wf(:,1),wf(:,315))
  call vert_AZ_Q(gZd,wf(:,307),wf(:,12),wf(:,316))
  call vert_AV_Q(wf(:,17),wf(:,-6),wf(:,317))
  call prop_A_Q(wf(:,317),Q(:,106),MB,1_intkind1,wf(:,318))
  call vert_AV_Q(wf(:,19),wf(:,-6),wf(:,319))
  call prop_A_Q(wf(:,319),Q(:,106),MB,1_intkind1,wf(:,320))
  call vert_AV_Q(wf(:,7),wf(:,-6),wf(:,321))
  call prop_A_Q(wf(:,321),Q(:,101),MB,1_intkind1,wf(:,322))
  call vert_AV_Q(wf(:,14),wf(:,-6),wf(:,323))
  call prop_A_Q(wf(:,323),Q(:,101),MB,1_intkind1,wf(:,324))
  call prop_Q_A(wf(:,38),Q(:,85),MB,1_intkind1,wf(:,325))
  call prop_Q_A(wf(:,39),Q(:,85),MB,1_intkind1,wf(:,326))
  call prop_Q_A(wf(:,40),Q(:,90),MB,1_intkind1,wf(:,327))
  call prop_Q_A(wf(:,41),Q(:,90),MB,1_intkind1,wf(:,328))
  call vert_QA_V(wf(:,296),wf(:,-5),wf(:,329))
  call vert_QA_Z(gZd,wf(:,296),wf(:,-5),wf(:,330))
  call prop_W_W(wf(:,48),Q(:,15),MZ,1_intkind1,wf(:,331))
  call prop_W_W(wf(:,52),Q(:,15),MZ,1_intkind1,wf(:,332))
  call prop_W_W(wf(:,56),Q(:,15),MZ,1_intkind1,wf(:,333))
  call prop_W_W(wf(:,60),Q(:,15),MZ,1_intkind1,wf(:,334))
  call vert_QA_V(wf(:,-4),wf(:,307),wf(:,335))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,307),wf(:,336))
  call vert_VQ_A(wf(:,65),wf(:,296),wf(:,337))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,296),wf(:,338))
  call vert_VQ_A(wf(:,64),wf(:,296),wf(:,339))
  call vert_ZQ_A(gZd,wf(:,73),wf(:,296),wf(:,340))
  call counter_A_Q(ctbb,wf(:,68),Q(:,41),wf(:,341))
  call counter_A_Q(ctbb,wf(:,75),Q(:,41),wf(:,342))
  call counter_A_Q(ctbb,wf(:,78),Q(:,38),wf(:,343))
  call counter_A_Q(ctbb,wf(:,80),Q(:,38),wf(:,344))
  call counter_Q_A(ctbb,wf(:,85),Q(:,25),wf(:,345))
  call counter_Q_A(ctbb,wf(:,88),Q(:,25),wf(:,346))
  call counter_Q_A(ctbb,wf(:,91),Q(:,22),wf(:,347))
  call counter_Q_A(ctbb,wf(:,93),Q(:,22),wf(:,348))
  call vert_AV_Q(wf(:,307),wf(:,65),wf(:,349))
  call vert_AZ_Q(gZd,wf(:,307),wf(:,70),wf(:,350))
  call vert_AV_Q(wf(:,307),wf(:,64),wf(:,351))
  call vert_AZ_Q(gZd,wf(:,307),wf(:,73),wf(:,352))
  call vert_AV_Q(wf(:,78),wf(:,-6),wf(:,353))
  call prop_A_Q(wf(:,353),Q(:,102),MB,1_intkind1,wf(:,354))
  call vert_AV_Q(wf(:,80),wf(:,-6),wf(:,355))
  call prop_A_Q(wf(:,355),Q(:,102),MB,1_intkind1,wf(:,356))
  call vert_AV_Q(wf(:,68),wf(:,-6),wf(:,357))
  call prop_A_Q(wf(:,357),Q(:,105),MB,1_intkind1,wf(:,358))
  call vert_AV_Q(wf(:,75),wf(:,-6),wf(:,359))
  call prop_A_Q(wf(:,359),Q(:,105),MB,1_intkind1,wf(:,360))
  call prop_Q_A(wf(:,95),Q(:,89),MB,1_intkind1,wf(:,361))
  call prop_Q_A(wf(:,96),Q(:,89),MB,1_intkind1,wf(:,362))
  call prop_Q_A(wf(:,97),Q(:,86),MB,1_intkind1,wf(:,363))
  call prop_Q_A(wf(:,98),Q(:,86),MB,1_intkind1,wf(:,364))
  call prop_W_W(wf(:,102),Q(:,15),MZ,1_intkind1,wf(:,365))
  call prop_W_W(wf(:,106),Q(:,15),MZ,1_intkind1,wf(:,366))
  call prop_W_W(wf(:,113),Q(:,15),MZ,1_intkind1,wf(:,367))
  call prop_W_W(wf(:,114),Q(:,15),MZ,1_intkind1,wf(:,368))
  call prop_W_W(wf(:,118),Q(:,15),MZ,1_intkind1,wf(:,369))
  call prop_W_W(wf(:,122),Q(:,15),MZ,1_intkind1,wf(:,370))
  call prop_W_W(wf(:,126),Q(:,15),MZ,1_intkind1,wf(:,371))
  call prop_W_W(wf(:,130),Q(:,15),MZ,1_intkind1,wf(:,372))
  call prop_W_W(wf(:,134),Q(:,15),MZ,1_intkind1,wf(:,373))
  call prop_W_W(wf(:,138),Q(:,15),MZ,1_intkind1,wf(:,374))
  call prop_W_W(wf(:,145),Q(:,15),MZ,1_intkind1,wf(:,375))
  call prop_W_W(wf(:,146),Q(:,15),MZ,1_intkind1,wf(:,376))
  call vert_VQ_A(wf(:,2),wf(:,27),wf(:,377))
  call prop_Q_A(wf(:,377),Q(:,31),MB,1_intkind1,wf(:,378))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,27),wf(:,379))
  call prop_Q_A(wf(:,379),Q(:,31),MB,1_intkind1,wf(:,380))
  call vert_VQ_A(wf(:,2),wf(:,30),wf(:,381))
  call prop_Q_A(wf(:,381),Q(:,31),MB,1_intkind1,wf(:,382))
  call vert_ZQ_A(gZd,wf(:,9),wf(:,30),wf(:,383))
  call prop_Q_A(wf(:,383),Q(:,31),MB,1_intkind1,wf(:,384))
  call vert_AV_Q(wf(:,7),wf(:,2),wf(:,385))
  call prop_A_Q(wf(:,385),Q(:,47),MB,1_intkind1,wf(:,386))
  call vert_AZ_Q(gZd,wf(:,7),wf(:,9),wf(:,387))
  call prop_A_Q(wf(:,387),Q(:,47),MB,1_intkind1,wf(:,388))
  call vert_AV_Q(wf(:,14),wf(:,2),wf(:,389))
  call prop_A_Q(wf(:,389),Q(:,47),MB,1_intkind1,wf(:,390))
  call vert_AZ_Q(gZd,wf(:,14),wf(:,9),wf(:,391))
  call prop_A_Q(wf(:,391),Q(:,47),MB,1_intkind1,wf(:,392))
  call vert_VQ_A(wf(:,1),wf(:,33),wf(:,393))
  call prop_Q_A(wf(:,393),Q(:,31),MB,1_intkind1,wf(:,394))
  call vert_VQ_A(wf(:,1),wf(:,35),wf(:,395))
  call prop_Q_A(wf(:,395),Q(:,31),MB,1_intkind1,wf(:,396))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,33),wf(:,397))
  call prop_Q_A(wf(:,397),Q(:,31),MB,1_intkind1,wf(:,398))
  call vert_ZQ_A(gZd,wf(:,12),wf(:,35),wf(:,399))
  call prop_Q_A(wf(:,399),Q(:,31),MB,1_intkind1,wf(:,400))
  call vert_AV_Q(wf(:,17),wf(:,1),wf(:,401))
  call prop_A_Q(wf(:,401),Q(:,47),MB,1_intkind1,wf(:,402))
  call vert_AV_Q(wf(:,19),wf(:,1),wf(:,403))
  call prop_A_Q(wf(:,403),Q(:,47),MB,1_intkind1,wf(:,404))
  call vert_AZ_Q(gZd,wf(:,17),wf(:,12),wf(:,405))
  call prop_A_Q(wf(:,405),Q(:,47),MB,1_intkind1,wf(:,406))
  call vert_AZ_Q(gZd,wf(:,19),wf(:,12),wf(:,407))
  call prop_A_Q(wf(:,407),Q(:,47),MB,1_intkind1,wf(:,408))
  call vert_QS_A(gH,wf(:,-4),wf(:,22),wf(:,409))
  call prop_Q_A(wf(:,409),Q(:,31),MB,1_intkind1,wf(:,410))
  call vert_SA_Q(gH,wf(:,22),wf(:,-5),wf(:,411))
  call prop_A_Q(wf(:,411),Q(:,47),MB,1_intkind1,wf(:,412))
  call vert_VQ_A(wf(:,45),wf(:,-4),wf(:,413))
  call prop_Q_A(wf(:,413),Q(:,31),MB,1_intkind1,wf(:,414))
  call vert_ZQ_A(gZd,wf(:,331),wf(:,-4),wf(:,415))
  call prop_Q_A(wf(:,415),Q(:,31),MB,1_intkind1,wf(:,416))
  call vert_VQ_A(wf(:,51),wf(:,-4),wf(:,417))
  call prop_Q_A(wf(:,417),Q(:,31),MB,1_intkind1,wf(:,418))
  call vert_ZQ_A(gZd,wf(:,332),wf(:,-4),wf(:,419))
  call prop_Q_A(wf(:,419),Q(:,31),MB,1_intkind1,wf(:,420))
  call vert_AV_Q(wf(:,-5),wf(:,45),wf(:,421))
  call prop_A_Q(wf(:,421),Q(:,47),MB,1_intkind1,wf(:,422))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,331),wf(:,423))
  call prop_A_Q(wf(:,423),Q(:,47),MB,1_intkind1,wf(:,424))
  call vert_AV_Q(wf(:,-5),wf(:,51),wf(:,425))
  call prop_A_Q(wf(:,425),Q(:,47),MB,1_intkind1,wf(:,426))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,332),wf(:,427))
  call prop_A_Q(wf(:,427),Q(:,47),MB,1_intkind1,wf(:,428))
  call vert_VQ_A(wf(:,55),wf(:,-4),wf(:,429))
  call prop_Q_A(wf(:,429),Q(:,31),MB,1_intkind1,wf(:,430))
  call vert_ZQ_A(gZd,wf(:,333),wf(:,-4),wf(:,431))
  call prop_Q_A(wf(:,431),Q(:,31),MB,1_intkind1,wf(:,432))
  call vert_VQ_A(wf(:,59),wf(:,-4),wf(:,433))
  call prop_Q_A(wf(:,433),Q(:,31),MB,1_intkind1,wf(:,434))
  call vert_ZQ_A(gZd,wf(:,334),wf(:,-4),wf(:,435))
  call prop_Q_A(wf(:,435),Q(:,31),MB,1_intkind1,wf(:,436))
  call vert_AV_Q(wf(:,-5),wf(:,55),wf(:,437))
  call prop_A_Q(wf(:,437),Q(:,47),MB,1_intkind1,wf(:,438))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,333),wf(:,439))
  call prop_A_Q(wf(:,439),Q(:,47),MB,1_intkind1,wf(:,440))
  call vert_AV_Q(wf(:,-5),wf(:,59),wf(:,441))
  call prop_A_Q(wf(:,441),Q(:,47),MB,1_intkind1,wf(:,442))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,334),wf(:,443))
  call prop_A_Q(wf(:,443),Q(:,47),MB,1_intkind1,wf(:,444))
  call vert_VQ_A(wf(:,65),wf(:,85),wf(:,445))
  call prop_Q_A(wf(:,445),Q(:,31),MB,1_intkind1,wf(:,446))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,85),wf(:,447))
  call prop_Q_A(wf(:,447),Q(:,31),MB,1_intkind1,wf(:,448))
  call vert_VQ_A(wf(:,65),wf(:,88),wf(:,449))
  call prop_Q_A(wf(:,449),Q(:,31),MB,1_intkind1,wf(:,450))
  call vert_ZQ_A(gZd,wf(:,70),wf(:,88),wf(:,451))
  call prop_Q_A(wf(:,451),Q(:,31),MB,1_intkind1,wf(:,452))
  call vert_AV_Q(wf(:,68),wf(:,65),wf(:,453))
  call prop_A_Q(wf(:,453),Q(:,47),MB,1_intkind1,wf(:,454))
  call vert_AZ_Q(gZd,wf(:,68),wf(:,70),wf(:,455))
  call prop_A_Q(wf(:,455),Q(:,47),MB,1_intkind1,wf(:,456))
  call vert_AV_Q(wf(:,75),wf(:,65),wf(:,457))
  call prop_A_Q(wf(:,457),Q(:,47),MB,1_intkind1,wf(:,458))
  call vert_AZ_Q(gZd,wf(:,75),wf(:,70),wf(:,459))
  call prop_A_Q(wf(:,459),Q(:,47),MB,1_intkind1,wf(:,460))
  call vert_VQ_A(wf(:,64),wf(:,91),wf(:,461))
  call prop_Q_A(wf(:,461),Q(:,31),MB,1_intkind1,wf(:,462))
  call vert_VQ_A(wf(:,64),wf(:,93),wf(:,463))
  call prop_Q_A(wf(:,463),Q(:,31),MB,1_intkind1,wf(:,464))
  call vert_ZQ_A(gZd,wf(:,73),wf(:,91),wf(:,465))
  call prop_Q_A(wf(:,465),Q(:,31),MB,1_intkind1,wf(:,466))
  call vert_ZQ_A(gZd,wf(:,73),wf(:,93),wf(:,467))
  call prop_Q_A(wf(:,467),Q(:,31),MB,1_intkind1,wf(:,468))
  call vert_AV_Q(wf(:,78),wf(:,64),wf(:,469))
  call prop_A_Q(wf(:,469),Q(:,47),MB,1_intkind1,wf(:,470))
  call vert_AV_Q(wf(:,80),wf(:,64),wf(:,471))
  call prop_A_Q(wf(:,471),Q(:,47),MB,1_intkind1,wf(:,472))
  call vert_AZ_Q(gZd,wf(:,78),wf(:,73),wf(:,473))
  call prop_A_Q(wf(:,473),Q(:,47),MB,1_intkind1,wf(:,474))
  call vert_AZ_Q(gZd,wf(:,80),wf(:,73),wf(:,475))
  call prop_A_Q(wf(:,475),Q(:,47),MB,1_intkind1,wf(:,476))
  call vert_QS_A(gH,wf(:,-4),wf(:,82),wf(:,477))
  call prop_Q_A(wf(:,477),Q(:,31),MB,1_intkind1,wf(:,478))
  call vert_SA_Q(gH,wf(:,82),wf(:,-5),wf(:,479))
  call prop_A_Q(wf(:,479),Q(:,47),MB,1_intkind1,wf(:,480))
  call vert_VQ_A(wf(:,101),wf(:,-4),wf(:,481))
  call prop_Q_A(wf(:,481),Q(:,31),MB,1_intkind1,wf(:,482))
  call vert_ZQ_A(gZd,wf(:,365),wf(:,-4),wf(:,483))
  call prop_Q_A(wf(:,483),Q(:,31),MB,1_intkind1,wf(:,484))
  call vert_VQ_A(wf(:,105),wf(:,-4),wf(:,485))
  call prop_Q_A(wf(:,485),Q(:,31),MB,1_intkind1,wf(:,486))
  call vert_ZQ_A(gZd,wf(:,366),wf(:,-4),wf(:,487))
  call prop_Q_A(wf(:,487),Q(:,31),MB,1_intkind1,wf(:,488))
  call vert_AV_Q(wf(:,-5),wf(:,101),wf(:,489))
  call prop_A_Q(wf(:,489),Q(:,47),MB,1_intkind1,wf(:,490))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,365),wf(:,491))
  call prop_A_Q(wf(:,491),Q(:,47),MB,1_intkind1,wf(:,492))
  call vert_AV_Q(wf(:,-5),wf(:,105),wf(:,493))
  call prop_A_Q(wf(:,493),Q(:,47),MB,1_intkind1,wf(:,494))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,366),wf(:,495))
  call prop_A_Q(wf(:,495),Q(:,47),MB,1_intkind1,wf(:,496))
  call vert_VQ_A(wf(:,109),wf(:,-4),wf(:,497))
  call prop_Q_A(wf(:,497),Q(:,31),MB,1_intkind1,wf(:,498))
  call vert_VQ_A(wf(:,112),wf(:,-4),wf(:,499))
  call prop_Q_A(wf(:,499),Q(:,31),MB,1_intkind1,wf(:,500))
  call vert_ZQ_A(gZd,wf(:,367),wf(:,-4),wf(:,501))
  call prop_Q_A(wf(:,501),Q(:,31),MB,1_intkind1,wf(:,502))
  call vert_ZQ_A(gZd,wf(:,368),wf(:,-4),wf(:,503))
  call prop_Q_A(wf(:,503),Q(:,31),MB,1_intkind1,wf(:,504))
  call vert_AV_Q(wf(:,-5),wf(:,109),wf(:,505))
  call prop_A_Q(wf(:,505),Q(:,47),MB,1_intkind1,wf(:,506))
  call vert_AV_Q(wf(:,-5),wf(:,112),wf(:,507))
  call prop_A_Q(wf(:,507),Q(:,47),MB,1_intkind1,wf(:,508))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,367),wf(:,509))
  call prop_A_Q(wf(:,509),Q(:,47),MB,1_intkind1,wf(:,510))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,368),wf(:,511))
  call prop_A_Q(wf(:,511),Q(:,47),MB,1_intkind1,wf(:,512))
  call vert_VQ_A(wf(:,117),wf(:,-4),wf(:,513))
  call prop_Q_A(wf(:,513),Q(:,31),MB,1_intkind1,wf(:,514))
  call vert_ZQ_A(gZd,wf(:,369),wf(:,-4),wf(:,515))
  call prop_Q_A(wf(:,515),Q(:,31),MB,1_intkind1,wf(:,516))
  call vert_VQ_A(wf(:,121),wf(:,-4),wf(:,517))
  call prop_Q_A(wf(:,517),Q(:,31),MB,1_intkind1,wf(:,518))
  call vert_ZQ_A(gZd,wf(:,370),wf(:,-4),wf(:,519))
  call prop_Q_A(wf(:,519),Q(:,31),MB,1_intkind1,wf(:,520))
  call vert_AV_Q(wf(:,-5),wf(:,117),wf(:,521))
  call prop_A_Q(wf(:,521),Q(:,47),MB,1_intkind1,wf(:,522))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,369),wf(:,523))
  call prop_A_Q(wf(:,523),Q(:,47),MB,1_intkind1,wf(:,524))
  call vert_AV_Q(wf(:,-5),wf(:,121),wf(:,525))
  call prop_A_Q(wf(:,525),Q(:,47),MB,1_intkind1,wf(:,526))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,370),wf(:,527))
  call prop_A_Q(wf(:,527),Q(:,47),MB,1_intkind1,wf(:,528))
  call vert_VQ_A(wf(:,125),wf(:,-4),wf(:,529))
  call prop_Q_A(wf(:,529),Q(:,31),MB,1_intkind1,wf(:,530))
  call vert_ZQ_A(gZd,wf(:,371),wf(:,-4),wf(:,531))
  call prop_Q_A(wf(:,531),Q(:,31),MB,1_intkind1,wf(:,532))
  call vert_VQ_A(wf(:,129),wf(:,-4),wf(:,533))
  call prop_Q_A(wf(:,533),Q(:,31),MB,1_intkind1,wf(:,534))
  call vert_ZQ_A(gZd,wf(:,372),wf(:,-4),wf(:,535))
  call prop_Q_A(wf(:,535),Q(:,31),MB,1_intkind1,wf(:,536))
  call vert_AV_Q(wf(:,-5),wf(:,125),wf(:,537))
  call prop_A_Q(wf(:,537),Q(:,47),MB,1_intkind1,wf(:,538))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,371),wf(:,539))
  call prop_A_Q(wf(:,539),Q(:,47),MB,1_intkind1,wf(:,540))
  call vert_AV_Q(wf(:,-5),wf(:,129),wf(:,541))
  call prop_A_Q(wf(:,541),Q(:,47),MB,1_intkind1,wf(:,542))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,372),wf(:,543))
  call prop_A_Q(wf(:,543),Q(:,47),MB,1_intkind1,wf(:,544))
  call vert_VQ_A(wf(:,133),wf(:,-4),wf(:,545))
  call prop_Q_A(wf(:,545),Q(:,31),MB,1_intkind1,wf(:,546))
  call vert_ZQ_A(gZd,wf(:,373),wf(:,-4),wf(:,547))
  call prop_Q_A(wf(:,547),Q(:,31),MB,1_intkind1,wf(:,548))
  call vert_VQ_A(wf(:,137),wf(:,-4),wf(:,549))
  call prop_Q_A(wf(:,549),Q(:,31),MB,1_intkind1,wf(:,550))
  call vert_ZQ_A(gZd,wf(:,374),wf(:,-4),wf(:,551))
  call prop_Q_A(wf(:,551),Q(:,31),MB,1_intkind1,wf(:,552))
  call vert_AV_Q(wf(:,-5),wf(:,133),wf(:,553))
  call prop_A_Q(wf(:,553),Q(:,47),MB,1_intkind1,wf(:,554))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,373),wf(:,555))
  call prop_A_Q(wf(:,555),Q(:,47),MB,1_intkind1,wf(:,556))
  call vert_AV_Q(wf(:,-5),wf(:,137),wf(:,557))
  call prop_A_Q(wf(:,557),Q(:,47),MB,1_intkind1,wf(:,558))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,374),wf(:,559))
  call prop_A_Q(wf(:,559),Q(:,47),MB,1_intkind1,wf(:,560))
  call vert_VQ_A(wf(:,141),wf(:,-4),wf(:,561))
  call prop_Q_A(wf(:,561),Q(:,31),MB,1_intkind1,wf(:,562))
  call vert_VQ_A(wf(:,144),wf(:,-4),wf(:,563))
  call prop_Q_A(wf(:,563),Q(:,31),MB,1_intkind1,wf(:,564))
  call vert_ZQ_A(gZd,wf(:,375),wf(:,-4),wf(:,565))
  call prop_Q_A(wf(:,565),Q(:,31),MB,1_intkind1,wf(:,566))
  call vert_ZQ_A(gZd,wf(:,376),wf(:,-4),wf(:,567))
  call prop_Q_A(wf(:,567),Q(:,31),MB,1_intkind1,wf(:,568))
  call vert_AV_Q(wf(:,-5),wf(:,141),wf(:,569))
  call prop_A_Q(wf(:,569),Q(:,47),MB,1_intkind1,wf(:,570))
  call vert_AV_Q(wf(:,-5),wf(:,144),wf(:,571))
  call prop_A_Q(wf(:,571),Q(:,47),MB,1_intkind1,wf(:,572))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,375),wf(:,573))
  call prop_A_Q(wf(:,573),Q(:,47),MB,1_intkind1,wf(:,574))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,376),wf(:,575))
  call prop_A_Q(wf(:,575),Q(:,47),MB,1_intkind1,wf(:,576))


  ! propagators

    den(1) = 1 / (Q(5,5))
    den(2) = 1 / (Q(5,10))
    den(3) = 1 / (Q(5,80) - MB2)
    den(5) = 1 / (Q(5,37) - MB2)
    den(8) = 1 / (Q(5,10) - MZ2)
    den(11) = 1 / (Q(5,5) - MZ2)
    den(16) = 1 / (Q(5,42) - MB2)
    den(25) = 1 / (Q(5,112) - MH2)
    den(28) = 1 / (Q(5,96) - MB2)
    den(30) = 1 / (Q(5,21) - MB2)
    den(39) = 1 / (Q(5,26) - MB2)
    den(57) = 1 / (Q(5,7))
    den(59) = 1 / (Q(5,112))
    den(62) = 1 / (Q(5,112) - MZ2)
    den(68) = 1 / (Q(5,13))
    den(85) = 1 / (Q(5,9))
    den(86) = 1 / (Q(5,6))
    den(88) = 1 / (Q(5,41) - MB2)
    den(91) = 1 / (Q(5,6) - MZ2)
    den(94) = 1 / (Q(5,9) - MZ2)
    den(99) = 1 / (Q(5,38) - MB2)
    den(110) = 1 / (Q(5,25) - MB2)
    den(119) = 1 / (Q(5,22) - MB2)
    den(142) = 1 / (Q(5,14))
    den(157) = 1 / (Q(5,11))
    den(198) = 1 / (Q(5,48))
    den(213) = 1 / (Q(5,15) - MH2)
    den(216) = 1 / (Q(5,74))
    den(222) = 1 / (Q(5,69))
    den(229) = 1 / (Q(5,85) - MB2)
    den(236) = 1 / (Q(5,90) - MB2)
    den(244) = 1 / (Q(5,101) - MB2)
    den(251) = 1 / (Q(5,106) - MB2)
    den(265) = 1 / (Q(5,70))
    den(271) = 1 / (Q(5,73))
    den(278) = 1 / (Q(5,89) - MB2)
    den(285) = 1 / (Q(5,86) - MB2)
    den(293) = 1 / (Q(5,105) - MB2)
    den(300) = 1 / (Q(5,102) - MB2)
    den(387) = 1 / (Q(5,15))
    den(390) = 1 / (Q(5,15) - MZ2)
    den(551) = 1 / (Q(5,53))
    den(555) = 1 / (Q(5,31) - MB2)
    den(566) = 1 / (Q(5,47) - MB2)
    den(574) = 1 / (Q(5,58))
    den(613) = 1 / (Q(5,57))
    den(634) = 1 / (Q(5,54))


  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(12) = den(5)*den(11)
    den(13) = den(4)*den(12)
    den(14) = den(9)*den(12)
    den(15) = den(1)*den(3)
    den(17) = den(2)*den(16)
    den(18) = den(15)*den(17)
    den(19) = den(8)*den(16)
    den(20) = den(15)*den(19)
    den(21) = den(3)*den(11)
    den(22) = den(17)*den(21)
    den(23) = den(19)*den(21)
    den(24) = den(8)*den(11)
    den(26) = den(3)*den(25)
    den(27) = den(24)*den(26)
    den(29) = den(2)*den(28)
    den(31) = den(1)*den(30)
    den(32) = den(29)*den(31)
    den(33) = den(8)*den(28)
    den(34) = den(31)*den(33)
    den(35) = den(11)*den(30)
    den(36) = den(29)*den(35)
    den(37) = den(33)*den(35)
    den(38) = den(1)*den(28)
    den(40) = den(2)*den(39)
    den(41) = den(38)*den(40)
    den(42) = den(8)*den(39)
    den(43) = den(38)*den(42)
    den(44) = den(11)*den(28)
    den(45) = den(40)*den(44)
    den(46) = den(42)*den(44)
    den(47) = den(25)*den(28)
    den(48) = den(24)*den(47)
    den(49) = den(17)*den(31)
    den(50) = den(19)*den(31)
    den(51) = den(17)*den(35)
    den(52) = den(19)*den(35)
    den(53) = den(6)*den(40)
    den(54) = den(6)*den(42)
    den(55) = den(12)*den(40)
    den(56) = den(12)*den(42)
    den(58) = den(1)*den(57)
    den(60) = den(3)*den(59)
    den(61) = den(58)*den(60)
    den(63) = den(3)*den(62)
    den(64) = den(58)*den(63)
    den(65) = den(11)*den(57)
    den(66) = den(60)*den(65)
    den(67) = den(63)*den(65)
    den(69) = den(1)*den(68)
    den(70) = den(60)*den(69)
    den(71) = den(63)*den(69)
    den(72) = den(11)*den(68)
    den(73) = den(60)*den(72)
    den(74) = den(63)*den(72)
    den(75) = den(28)*den(59)
    den(76) = den(58)*den(75)
    den(77) = den(28)*den(62)
    den(78) = den(58)*den(77)
    den(79) = den(65)*den(75)
    den(80) = den(65)*den(77)
    den(81) = den(69)*den(75)
    den(82) = den(69)*den(77)
    den(83) = den(72)*den(75)
    den(84) = den(72)*den(77)
    den(87) = den(3)*den(86)
    den(89) = den(85)*den(88)
    den(90) = den(87)*den(89)
    den(92) = den(3)*den(91)
    den(93) = den(89)*den(92)
    den(95) = den(88)*den(94)
    den(96) = den(87)*den(95)
    den(97) = den(92)*den(95)
    den(98) = den(3)*den(85)
    den(100) = den(86)*den(99)
    den(101) = den(98)*den(100)
    den(102) = den(91)*den(99)
    den(103) = den(98)*den(102)
    den(104) = den(3)*den(94)
    den(105) = den(100)*den(104)
    den(106) = den(102)*den(104)
    den(107) = den(91)*den(94)
    den(108) = den(26)*den(107)
    den(109) = den(28)*den(86)
    den(111) = den(85)*den(110)
    den(112) = den(109)*den(111)
    den(113) = den(28)*den(91)
    den(114) = den(111)*den(113)
    den(115) = den(94)*den(110)
    den(116) = den(109)*den(115)
    den(117) = den(113)*den(115)
    den(118) = den(28)*den(85)
    den(120) = den(86)*den(119)
    den(121) = den(118)*den(120)
    den(122) = den(91)*den(119)
    den(123) = den(118)*den(122)
    den(124) = den(28)*den(94)
    den(125) = den(120)*den(124)
    den(126) = den(122)*den(124)
    den(127) = den(47)*den(107)
    den(128) = den(100)*den(111)
    den(129) = den(102)*den(111)
    den(130) = den(100)*den(115)
    den(131) = den(102)*den(115)
    den(132) = den(89)*den(120)
    den(133) = den(89)*den(122)
    den(134) = den(95)*den(120)
    den(135) = den(95)*den(122)
    den(136) = den(57)*den(86)
    den(137) = den(60)*den(136)
    den(138) = den(63)*den(136)
    den(139) = den(57)*den(91)
    den(140) = den(60)*den(139)
    den(141) = den(63)*den(139)
    den(143) = den(86)*den(142)
    den(144) = den(60)*den(143)
    den(145) = den(91)*den(142)
    den(146) = den(60)*den(145)
    den(147) = den(63)*den(143)
    den(148) = den(63)*den(145)
    den(149) = den(75)*den(136)
    den(150) = den(77)*den(136)
    den(151) = den(75)*den(139)
    den(152) = den(77)*den(139)
    den(153) = den(75)*den(143)
    den(154) = den(75)*den(145)
    den(155) = den(77)*den(143)
    den(156) = den(77)*den(145)
    den(158) = den(85)*den(157)
    den(159) = den(60)*den(158)
    den(160) = den(63)*den(158)
    den(161) = den(94)*den(157)
    den(162) = den(60)*den(161)
    den(163) = den(63)*den(161)
    den(164) = den(68)*den(85)
    den(165) = den(60)*den(164)
    den(166) = den(63)*den(164)
    den(167) = den(68)*den(94)
    den(168) = den(60)*den(167)
    den(169) = den(63)*den(167)
    den(170) = den(75)*den(158)
    den(171) = den(77)*den(158)
    den(172) = den(75)*den(161)
    den(173) = den(77)*den(161)
    den(174) = den(75)*den(164)
    den(175) = den(77)*den(164)
    den(176) = den(75)*den(167)
    den(177) = den(77)*den(167)
    den(178) = den(2)*den(157)
    den(179) = den(60)*den(178)
    den(180) = den(63)*den(178)
    den(181) = den(8)*den(157)
    den(182) = den(60)*den(181)
    den(183) = den(63)*den(181)
    den(184) = den(2)*den(142)
    den(185) = den(60)*den(184)
    den(186) = den(8)*den(142)
    den(187) = den(60)*den(186)
    den(188) = den(63)*den(184)
    den(189) = den(63)*den(186)
    den(190) = den(75)*den(178)
    den(191) = den(77)*den(178)
    den(192) = den(75)*den(181)
    den(193) = den(77)*den(181)
    den(194) = den(75)*den(184)
    den(195) = den(75)*den(186)
    den(196) = den(77)*den(184)
    den(197) = den(77)*den(186)
    den(199) = den(1)*den(2)
    den(200) = den(198)*den(199)
    den(201) = den(1)*den(8)
    den(202) = den(198)*den(201)
    den(203) = den(2)*den(11)
    den(204) = den(198)*den(203)
    den(205) = den(24)*den(198)
    den(206) = den(85)*den(86)
    den(207) = den(198)*den(206)
    den(208) = den(85)*den(91)
    den(209) = den(198)*den(208)
    den(210) = den(86)*den(94)
    den(211) = den(198)*den(210)
    den(212) = den(107)*den(198)
    den(214) = den(24)*den(213)
    den(215) = den(198)*den(214)
    den(217) = den(8)*den(216)
    den(218) = den(31)*den(217)
    den(219) = den(35)*den(217)
    den(220) = den(6)*den(217)
    den(221) = den(12)*den(217)
    den(223) = den(11)*den(222)
    den(224) = den(40)*den(223)
    den(225) = den(42)*den(223)
    den(226) = den(17)*den(223)
    den(227) = den(19)*den(223)
    den(228) = den(3)*den(214)
    den(230) = den(15)*den(229)
    den(231) = den(2)*den(230)
    den(232) = den(8)*den(230)
    den(233) = den(21)*den(229)
    den(234) = den(2)*den(233)
    den(235) = den(8)*den(233)
    den(237) = den(4)*den(236)
    den(238) = den(1)*den(237)
    den(239) = den(9)*den(236)
    den(240) = den(1)*den(239)
    den(241) = den(11)*den(237)
    den(242) = den(11)*den(239)
    den(243) = den(28)*den(214)
    den(245) = den(38)*den(244)
    den(246) = den(2)*den(245)
    den(247) = den(8)*den(245)
    den(248) = den(44)*den(244)
    den(249) = den(2)*den(248)
    den(250) = den(8)*den(248)
    den(252) = den(29)*den(251)
    den(253) = den(1)*den(252)
    den(254) = den(33)*den(251)
    den(255) = den(1)*den(254)
    den(256) = den(11)*den(252)
    den(257) = den(11)*den(254)
    den(258) = den(62)*den(198)
    den(259) = den(58)*den(258)
    den(260) = den(65)*den(258)
    den(261) = den(69)*den(258)
    den(262) = den(72)*den(258)
    den(263) = den(107)*den(213)
    den(264) = den(198)*den(263)
    den(266) = den(91)*den(265)
    den(267) = den(111)*den(266)
    den(268) = den(115)*den(266)
    den(269) = den(89)*den(266)
    den(270) = den(95)*den(266)
    den(272) = den(94)*den(271)
    den(273) = den(120)*den(272)
    den(274) = den(122)*den(272)
    den(275) = den(100)*den(272)
    den(276) = den(102)*den(272)
    den(277) = den(3)*den(263)
    den(279) = den(98)*den(278)
    den(280) = den(86)*den(279)
    den(281) = den(91)*den(279)
    den(282) = den(104)*den(278)
    den(283) = den(86)*den(282)
    den(284) = den(91)*den(282)
    den(286) = den(87)*den(285)
    den(287) = den(85)*den(286)
    den(288) = den(92)*den(285)
    den(289) = den(85)*den(288)
    den(290) = den(94)*den(286)
    den(291) = den(94)*den(288)
    den(292) = den(28)*den(263)
    den(294) = den(118)*den(293)
    den(295) = den(86)*den(294)
    den(296) = den(91)*den(294)
    den(297) = den(124)*den(293)
    den(298) = den(86)*den(297)
    den(299) = den(91)*den(297)
    den(301) = den(109)*den(300)
    den(302) = den(85)*den(301)
    den(303) = den(113)*den(300)
    den(304) = den(85)*den(303)
    den(305) = den(94)*den(301)
    den(306) = den(94)*den(303)
    den(307) = den(136)*den(258)
    den(308) = den(139)*den(258)
    den(309) = den(143)*den(258)
    den(310) = den(145)*den(258)
    den(311) = den(158)*den(258)
    den(312) = den(161)*den(258)
    den(313) = den(164)*den(258)
    den(314) = den(167)*den(258)
    den(315) = den(178)*den(258)
    den(316) = den(181)*den(258)
    den(317) = den(184)*den(258)
    den(318) = den(186)*den(258)
    den(319) = den(3)**2
    den(320) = den(214)*den(319)
    den(321) = den(2)*den(319)
    den(322) = den(6)*den(321)
    den(323) = den(8)*den(319)
    den(324) = den(6)*den(323)
    den(325) = den(12)*den(321)
    den(326) = den(12)*den(323)
    den(327) = den(1)*den(319)
    den(328) = den(17)*den(327)
    den(329) = den(19)*den(327)
    den(330) = den(11)*den(319)
    den(331) = den(17)*den(330)
    den(332) = den(19)*den(330)
    den(333) = den(6)*den(237)
    den(334) = den(6)*den(239)
    den(335) = den(12)*den(237)
    den(336) = den(12)*den(239)
    den(337) = den(17)*den(230)
    den(338) = den(19)*den(230)
    den(339) = den(17)*den(233)
    den(340) = den(19)*den(233)
    den(341) = den(28)**2
    den(342) = den(214)*den(341)
    den(343) = den(31)*den(252)
    den(344) = den(31)*den(254)
    den(345) = den(35)*den(252)
    den(346) = den(35)*den(254)
    den(347) = den(40)*den(245)
    den(348) = den(42)*den(245)
    den(349) = den(40)*den(248)
    den(350) = den(42)*den(248)
    den(351) = den(2)*den(341)
    den(352) = den(31)*den(351)
    den(353) = den(8)*den(341)
    den(354) = den(31)*den(353)
    den(355) = den(35)*den(351)
    den(356) = den(35)*den(353)
    den(357) = den(1)*den(341)
    den(358) = den(40)*den(357)
    den(359) = den(42)*den(357)
    den(360) = den(11)*den(341)
    den(361) = den(40)*den(360)
    den(362) = den(42)*den(360)
    den(363) = den(17)*den(251)
    den(364) = den(31)*den(363)
    den(365) = den(19)*den(251)
    den(366) = den(31)*den(365)
    den(367) = den(35)*den(363)
    den(368) = den(35)*den(365)
    den(369) = den(6)*den(244)
    den(370) = den(40)*den(369)
    den(371) = den(42)*den(369)
    den(372) = den(12)*den(244)
    den(373) = den(40)*den(372)
    den(374) = den(42)*den(372)
    den(375) = den(31)*den(229)
    den(376) = den(17)*den(375)
    den(377) = den(19)*den(375)
    den(378) = den(35)*den(229)
    den(379) = den(17)*den(378)
    den(380) = den(19)*den(378)
    den(381) = den(40)*den(236)
    den(382) = den(6)*den(381)
    den(383) = den(42)*den(236)
    den(384) = den(6)*den(383)
    den(385) = den(12)*den(381)
    den(386) = den(12)*den(383)
    den(388) = den(58)*den(387)
    den(389) = den(319)*den(388)
    den(391) = den(58)*den(390)
    den(392) = den(319)*den(391)
    den(393) = den(65)*den(387)
    den(394) = den(319)*den(393)
    den(395) = den(65)*den(390)
    den(396) = den(319)*den(395)
    den(397) = den(69)*den(387)
    den(398) = den(319)*den(397)
    den(399) = den(69)*den(390)
    den(400) = den(319)*den(399)
    den(401) = den(72)*den(387)
    den(402) = den(319)*den(401)
    den(403) = den(72)*den(390)
    den(404) = den(319)*den(403)
    den(405) = den(341)*den(388)
    den(406) = den(341)*den(391)
    den(407) = den(341)*den(393)
    den(408) = den(341)*den(395)
    den(409) = den(341)*den(397)
    den(410) = den(341)*den(399)
    den(411) = den(341)*den(401)
    den(412) = den(341)*den(403)
    den(413) = den(263)*den(319)
    den(414) = den(86)*den(319)
    den(415) = den(89)*den(414)
    den(416) = den(91)*den(319)
    den(417) = den(89)*den(416)
    den(418) = den(95)*den(414)
    den(419) = den(95)*den(416)
    den(420) = den(85)*den(319)
    den(421) = den(100)*den(420)
    den(422) = den(102)*den(420)
    den(423) = den(94)*den(319)
    den(424) = den(100)*den(423)
    den(425) = den(102)*den(423)
    den(426) = den(89)*den(286)
    den(427) = den(89)*den(288)
    den(428) = den(95)*den(286)
    den(429) = den(95)*den(288)
    den(430) = den(100)*den(279)
    den(431) = den(102)*den(279)
    den(432) = den(100)*den(282)
    den(433) = den(102)*den(282)
    den(434) = den(263)*den(341)
    den(435) = den(111)*den(301)
    den(436) = den(111)*den(303)
    den(437) = den(115)*den(301)
    den(438) = den(115)*den(303)
    den(439) = den(120)*den(294)
    den(440) = den(122)*den(294)
    den(441) = den(120)*den(297)
    den(442) = den(122)*den(297)
    den(443) = den(86)*den(341)
    den(444) = den(111)*den(443)
    den(445) = den(91)*den(341)
    den(446) = den(111)*den(445)
    den(447) = den(115)*den(443)
    den(448) = den(115)*den(445)
    den(449) = den(85)*den(341)
    den(450) = den(120)*den(449)
    den(451) = den(122)*den(449)
    den(452) = den(94)*den(341)
    den(453) = den(120)*den(452)
    den(454) = den(122)*den(452)
    den(455) = den(100)*den(300)
    den(456) = den(111)*den(455)
    den(457) = den(102)*den(300)
    den(458) = den(111)*den(457)
    den(459) = den(115)*den(455)
    den(460) = den(115)*den(457)
    den(461) = den(89)*den(293)
    den(462) = den(120)*den(461)
    den(463) = den(122)*den(461)
    den(464) = den(95)*den(293)
    den(465) = den(120)*den(464)
    den(466) = den(122)*den(464)
    den(467) = den(111)*den(278)
    den(468) = den(100)*den(467)
    den(469) = den(102)*den(467)
    den(470) = den(115)*den(278)
    den(471) = den(100)*den(470)
    den(472) = den(102)*den(470)
    den(473) = den(120)*den(285)
    den(474) = den(89)*den(473)
    den(475) = den(122)*den(285)
    den(476) = den(89)*den(475)
    den(477) = den(95)*den(473)
    den(478) = den(95)*den(475)
    den(479) = den(136)*den(387)
    den(480) = den(319)*den(479)
    den(481) = den(136)*den(390)
    den(482) = den(319)*den(481)
    den(483) = den(139)*den(387)
    den(484) = den(319)*den(483)
    den(485) = den(139)*den(390)
    den(486) = den(319)*den(485)
    den(487) = den(143)*den(387)
    den(488) = den(319)*den(487)
    den(489) = den(145)*den(387)
    den(490) = den(319)*den(489)
    den(491) = den(143)*den(390)
    den(492) = den(319)*den(491)
    den(493) = den(145)*den(390)
    den(494) = den(319)*den(493)
    den(495) = den(341)*den(479)
    den(496) = den(341)*den(481)
    den(497) = den(341)*den(483)
    den(498) = den(341)*den(485)
    den(499) = den(341)*den(487)
    den(500) = den(341)*den(489)
    den(501) = den(341)*den(491)
    den(502) = den(341)*den(493)
    den(503) = den(158)*den(387)
    den(504) = den(319)*den(503)
    den(505) = den(158)*den(390)
    den(506) = den(319)*den(505)
    den(507) = den(161)*den(387)
    den(508) = den(319)*den(507)
    den(509) = den(161)*den(390)
    den(510) = den(319)*den(509)
    den(511) = den(164)*den(387)
    den(512) = den(319)*den(511)
    den(513) = den(164)*den(390)
    den(514) = den(319)*den(513)
    den(515) = den(167)*den(387)
    den(516) = den(319)*den(515)
    den(517) = den(167)*den(390)
    den(518) = den(319)*den(517)
    den(519) = den(341)*den(503)
    den(520) = den(341)*den(505)
    den(521) = den(341)*den(507)
    den(522) = den(341)*den(509)
    den(523) = den(341)*den(511)
    den(524) = den(341)*den(513)
    den(525) = den(341)*den(515)
    den(526) = den(341)*den(517)
    den(527) = den(178)*den(387)
    den(528) = den(319)*den(527)
    den(529) = den(178)*den(390)
    den(530) = den(319)*den(529)
    den(531) = den(181)*den(387)
    den(532) = den(319)*den(531)
    den(533) = den(181)*den(390)
    den(534) = den(319)*den(533)
    den(535) = den(184)*den(387)
    den(536) = den(319)*den(535)
    den(537) = den(186)*den(387)
    den(538) = den(319)*den(537)
    den(539) = den(184)*den(390)
    den(540) = den(319)*den(539)
    den(541) = den(186)*den(390)
    den(542) = den(319)*den(541)
    den(543) = den(341)*den(527)
    den(544) = den(341)*den(529)
    den(545) = den(341)*den(531)
    den(546) = den(341)*den(533)
    den(547) = den(341)*den(535)
    den(548) = den(341)*den(537)
    den(549) = den(341)*den(539)
    den(550) = den(341)*den(541)
    den(552) = den(31)*den(551)
    den(553) = den(35)*den(551)
    den(554) = den(2)*den(31)
    den(556) = den(554)*den(555)
    den(557) = den(8)*den(31)
    den(558) = den(555)*den(557)
    den(559) = den(2)*den(35)
    den(560) = den(555)*den(559)
    den(561) = den(8)*den(35)
    den(562) = den(555)*den(561)
    den(563) = den(6)*den(551)
    den(564) = den(12)*den(551)
    den(565) = den(2)*den(6)
    den(567) = den(565)*den(566)
    den(568) = den(6)*den(8)
    den(569) = den(566)*den(568)
    den(570) = den(2)*den(12)
    den(571) = den(566)*den(570)
    den(572) = den(8)*den(12)
    den(573) = den(566)*den(572)
    den(575) = den(40)*den(574)
    den(576) = den(42)*den(574)
    den(577) = den(1)*den(40)
    den(578) = den(555)*den(577)
    den(579) = den(1)*den(42)
    den(580) = den(555)*den(579)
    den(581) = den(11)*den(40)
    den(582) = den(555)*den(581)
    den(583) = den(11)*den(42)
    den(584) = den(555)*den(583)
    den(585) = den(17)*den(574)
    den(586) = den(19)*den(574)
    den(587) = den(1)*den(17)
    den(588) = den(566)*den(587)
    den(589) = den(1)*den(19)
    den(590) = den(566)*den(589)
    den(591) = den(11)*den(17)
    den(592) = den(566)*den(591)
    den(593) = den(11)*den(19)
    den(594) = den(566)*den(593)
    den(595) = den(214)*den(555)
    den(596) = den(214)*den(566)
    den(597) = den(388)*den(555)
    den(598) = den(391)*den(555)
    den(599) = den(393)*den(555)
    den(600) = den(395)*den(555)
    den(601) = den(388)*den(566)
    den(602) = den(391)*den(566)
    den(603) = den(393)*den(566)
    den(604) = den(395)*den(566)
    den(605) = den(397)*den(555)
    den(606) = den(399)*den(555)
    den(607) = den(401)*den(555)
    den(608) = den(403)*den(555)
    den(609) = den(397)*den(566)
    den(610) = den(399)*den(566)
    den(611) = den(401)*den(566)
    den(612) = den(403)*den(566)
    den(614) = den(111)*den(613)
    den(615) = den(115)*den(613)
    den(616) = den(86)*den(111)
    den(617) = den(555)*den(616)
    den(618) = den(91)*den(111)
    den(619) = den(555)*den(618)
    den(620) = den(86)*den(115)
    den(621) = den(555)*den(620)
    den(622) = den(91)*den(115)
    den(623) = den(555)*den(622)
    den(624) = den(89)*den(613)
    den(625) = den(95)*den(613)
    den(626) = den(86)*den(89)
    den(627) = den(566)*den(626)
    den(628) = den(89)*den(91)
    den(629) = den(566)*den(628)
    den(630) = den(86)*den(95)
    den(631) = den(566)*den(630)
    den(632) = den(91)*den(95)
    den(633) = den(566)*den(632)
    den(635) = den(120)*den(634)
    den(636) = den(122)*den(634)
    den(637) = den(85)*den(120)
    den(638) = den(555)*den(637)
    den(639) = den(85)*den(122)
    den(640) = den(555)*den(639)
    den(641) = den(94)*den(120)
    den(642) = den(555)*den(641)
    den(643) = den(94)*den(122)
    den(644) = den(555)*den(643)
    den(645) = den(100)*den(634)
    den(646) = den(102)*den(634)
    den(647) = den(85)*den(100)
    den(648) = den(566)*den(647)
    den(649) = den(85)*den(102)
    den(650) = den(566)*den(649)
    den(651) = den(94)*den(100)
    den(652) = den(566)*den(651)
    den(653) = den(94)*den(102)
    den(654) = den(566)*den(653)
    den(655) = den(263)*den(555)
    den(656) = den(263)*den(566)
    den(657) = den(479)*den(555)
    den(658) = den(481)*den(555)
    den(659) = den(483)*den(555)
    den(660) = den(485)*den(555)
    den(661) = den(479)*den(566)
    den(662) = den(481)*den(566)
    den(663) = den(483)*den(566)
    den(664) = den(485)*den(566)
    den(665) = den(487)*den(555)
    den(666) = den(489)*den(555)
    den(667) = den(491)*den(555)
    den(668) = den(493)*den(555)
    den(669) = den(487)*den(566)
    den(670) = den(489)*den(566)
    den(671) = den(491)*den(566)
    den(672) = den(493)*den(566)
    den(673) = den(503)*den(555)
    den(674) = den(505)*den(555)
    den(675) = den(507)*den(555)
    den(676) = den(509)*den(555)
    den(677) = den(503)*den(566)
    den(678) = den(505)*den(566)
    den(679) = den(507)*den(566)
    den(680) = den(509)*den(566)
    den(681) = den(511)*den(555)
    den(682) = den(513)*den(555)
    den(683) = den(515)*den(555)
    den(684) = den(517)*den(555)
    den(685) = den(511)*den(566)
    den(686) = den(513)*den(566)
    den(687) = den(515)*den(566)
    den(688) = den(517)*den(566)
    den(689) = den(527)*den(555)
    den(690) = den(529)*den(555)
    den(691) = den(531)*den(555)
    den(692) = den(533)*den(555)
    den(693) = den(527)*den(566)
    den(694) = den(529)*den(566)
    den(695) = den(531)*den(566)
    den(696) = den(533)*den(566)
    den(697) = den(535)*den(555)
    den(698) = den(537)*den(555)
    den(699) = den(539)*den(555)
    den(700) = den(541)*den(555)
    den(701) = den(535)*den(566)
    den(702) = den(537)*den(566)
    den(703) = den(539)*den(566)
    den(704) = den(541)*den(566)
    den(705) = den(1)*den(2)*den(198)
    den(706) = den(1)*den(8)*den(198)
    den(707) = den(2)*den(11)*den(198)
    den(708) = den(8)*den(11)*den(198)
    den(709) = den(2)*den(3)*den(6)
    den(710) = den(3)*den(6)*den(8)
    den(711) = den(2)*den(3)*den(12)
    den(712) = den(3)*den(8)*den(12)
    den(713) = den(1)*den(3)*den(17)
    den(714) = den(1)*den(3)*den(19)
    den(715) = den(3)*den(11)*den(17)
    den(716) = den(3)*den(11)*den(19)
    den(717) = den(1)*den(2)*den(3)
    den(718) = den(1)*den(3)*den(8)
    den(719) = den(2)*den(3)*den(11)
    den(720) = den(3)*den(8)*den(11)
    den(721) = den(2)*den(28)*den(31)
    den(722) = den(8)*den(28)*den(31)
    den(723) = den(2)*den(28)*den(35)
    den(724) = den(8)*den(28)*den(35)
    den(725) = den(1)*den(28)*den(40)
    den(726) = den(1)*den(28)*den(42)
    den(727) = den(11)*den(28)*den(40)
    den(728) = den(11)*den(28)*den(42)
    den(729) = den(1)*den(2)*den(28)
    den(730) = den(1)*den(8)*den(28)
    den(731) = den(2)*den(11)*den(28)
    den(732) = den(8)*den(11)*den(28)
    den(733) = den(2)*den(552)
    den(734) = den(8)*den(552)
    den(735) = den(2)*den(553)
    den(736) = den(8)*den(553)
    den(737) = den(2)*den(375)
    den(738) = den(8)*den(375)
    den(739) = den(2)*den(378)
    den(740) = den(8)*den(378)
    den(741) = den(2)*den(563)
    den(742) = den(8)*den(563)
    den(743) = den(2)*den(564)
    den(744) = den(8)*den(564)
    den(745) = den(2)*den(369)
    den(746) = den(8)*den(369)
    den(747) = den(2)*den(372)
    den(748) = den(8)*den(372)
    den(749) = den(1)*den(575)
    den(750) = den(1)*den(576)
    den(751) = den(11)*den(575)
    den(752) = den(11)*den(576)
    den(753) = den(1)*den(381)
    den(754) = den(1)*den(383)
    den(755) = den(11)*den(381)
    den(756) = den(11)*den(383)
    den(757) = den(1)*den(585)
    den(758) = den(1)*den(586)
    den(759) = den(11)*den(585)
    den(760) = den(11)*den(586)
    den(761) = den(1)*den(363)
    den(762) = den(1)*den(365)
    den(763) = den(11)*den(363)
    den(764) = den(11)*den(365)
    den(765) = den(198)*den(388)
    den(766) = den(198)*den(391)
    den(767) = den(198)*den(393)
    den(768) = den(198)*den(395)
    den(769) = den(198)*den(397)
    den(770) = den(198)*den(399)
    den(771) = den(198)*den(401)
    den(772) = den(198)*den(403)
    den(773) = den(3)*den(388)
    den(774) = den(3)*den(391)
    den(775) = den(3)*den(393)
    den(776) = den(3)*den(395)
    den(777) = den(3)*den(397)
    den(778) = den(3)*den(399)
    den(779) = den(3)*den(401)
    den(780) = den(3)*den(403)
    den(781) = den(28)*den(388)
    den(782) = den(28)*den(391)
    den(783) = den(28)*den(393)
    den(784) = den(28)*den(395)
    den(785) = den(28)*den(397)
    den(786) = den(28)*den(399)
    den(787) = den(28)*den(401)
    den(788) = den(28)*den(403)
    den(789) = den(85)*den(86)*den(198)
    den(790) = den(85)*den(91)*den(198)
    den(791) = den(86)*den(94)*den(198)
    den(792) = den(91)*den(94)*den(198)
    den(793) = den(3)*den(86)*den(89)
    den(794) = den(3)*den(89)*den(91)
    den(795) = den(3)*den(86)*den(95)
    den(796) = den(3)*den(91)*den(95)
    den(797) = den(3)*den(85)*den(100)
    den(798) = den(3)*den(85)*den(102)
    den(799) = den(3)*den(94)*den(100)
    den(800) = den(3)*den(94)*den(102)
    den(801) = den(3)*den(85)*den(86)
    den(802) = den(3)*den(85)*den(91)
    den(803) = den(3)*den(86)*den(94)
    den(804) = den(3)*den(91)*den(94)
    den(805) = den(28)*den(86)*den(111)
    den(806) = den(28)*den(91)*den(111)
    den(807) = den(28)*den(86)*den(115)
    den(808) = den(28)*den(91)*den(115)
    den(809) = den(28)*den(85)*den(120)
    den(810) = den(28)*den(85)*den(122)
    den(811) = den(28)*den(94)*den(120)
    den(812) = den(28)*den(94)*den(122)
    den(813) = den(28)*den(85)*den(86)
    den(814) = den(28)*den(85)*den(91)
    den(815) = den(28)*den(86)*den(94)
    den(816) = den(28)*den(91)*den(94)
    den(817) = den(86)*den(614)
    den(818) = den(91)*den(614)
    den(819) = den(86)*den(615)
    den(820) = den(91)*den(615)
    den(821) = den(86)*den(467)
    den(822) = den(91)*den(467)
    den(823) = den(86)*den(470)
    den(824) = den(91)*den(470)
    den(825) = den(86)*den(624)
    den(826) = den(91)*den(624)
    den(827) = den(86)*den(625)
    den(828) = den(91)*den(625)
    den(829) = den(86)*den(461)
    den(830) = den(91)*den(461)
    den(831) = den(86)*den(464)
    den(832) = den(91)*den(464)
    den(833) = den(85)*den(635)
    den(834) = den(85)*den(636)
    den(835) = den(94)*den(635)
    den(836) = den(94)*den(636)
    den(837) = den(85)*den(473)
    den(838) = den(85)*den(475)
    den(839) = den(94)*den(473)
    den(840) = den(94)*den(475)
    den(841) = den(85)*den(645)
    den(842) = den(85)*den(646)
    den(843) = den(94)*den(645)
    den(844) = den(94)*den(646)
    den(845) = den(85)*den(455)
    den(846) = den(85)*den(457)
    den(847) = den(94)*den(455)
    den(848) = den(94)*den(457)
    den(849) = den(198)*den(479)
    den(850) = den(198)*den(481)
    den(851) = den(198)*den(483)
    den(852) = den(198)*den(485)
    den(853) = den(198)*den(487)
    den(854) = den(198)*den(489)
    den(855) = den(198)*den(491)
    den(856) = den(198)*den(493)
    den(857) = den(3)*den(479)
    den(858) = den(3)*den(481)
    den(859) = den(3)*den(483)
    den(860) = den(3)*den(485)
    den(861) = den(3)*den(487)
    den(862) = den(3)*den(489)
    den(863) = den(3)*den(491)
    den(864) = den(3)*den(493)
    den(865) = den(28)*den(479)
    den(866) = den(28)*den(481)
    den(867) = den(28)*den(483)
    den(868) = den(28)*den(485)
    den(869) = den(28)*den(487)
    den(870) = den(28)*den(489)
    den(871) = den(28)*den(491)
    den(872) = den(28)*den(493)
    den(873) = den(198)*den(503)
    den(874) = den(198)*den(505)
    den(875) = den(198)*den(507)
    den(876) = den(198)*den(509)
    den(877) = den(198)*den(511)
    den(878) = den(198)*den(513)
    den(879) = den(198)*den(515)
    den(880) = den(198)*den(517)
    den(881) = den(3)*den(503)
    den(882) = den(3)*den(505)
    den(883) = den(3)*den(507)
    den(884) = den(3)*den(509)
    den(885) = den(3)*den(511)
    den(886) = den(3)*den(513)
    den(887) = den(3)*den(515)
    den(888) = den(3)*den(517)
    den(889) = den(28)*den(503)
    den(890) = den(28)*den(505)
    den(891) = den(28)*den(507)
    den(892) = den(28)*den(509)
    den(893) = den(28)*den(511)
    den(894) = den(28)*den(513)
    den(895) = den(28)*den(515)
    den(896) = den(28)*den(517)
    den(897) = den(198)*den(527)
    den(898) = den(198)*den(529)
    den(899) = den(198)*den(531)
    den(900) = den(198)*den(533)
    den(901) = den(198)*den(535)
    den(902) = den(198)*den(537)
    den(903) = den(198)*den(539)
    den(904) = den(198)*den(541)
    den(905) = den(3)*den(527)
    den(906) = den(3)*den(529)
    den(907) = den(3)*den(531)
    den(908) = den(3)*den(533)
    den(909) = den(3)*den(535)
    den(910) = den(3)*den(537)
    den(911) = den(3)*den(539)
    den(912) = den(3)*den(541)
    den(913) = den(28)*den(527)
    den(914) = den(28)*den(529)
    den(915) = den(28)*den(531)
    den(916) = den(28)*den(533)
    den(917) = den(28)*den(535)
    den(918) = den(28)*den(537)
    den(919) = den(28)*den(539)
    den(920) = den(28)*den(541)
    den(921) = den(3)*den(567)
    den(922) = den(3)*den(569)
    den(923) = den(3)*den(571)
    den(924) = den(3)*den(573)
    den(925) = den(3)*den(588)
    den(926) = den(3)*den(590)
    den(927) = den(3)*den(592)
    den(928) = den(3)*den(594)
    den(929) = den(3)*den(596)
    den(930) = den(28)*den(556)
    den(931) = den(28)*den(558)
    den(932) = den(28)*den(560)
    den(933) = den(28)*den(562)
    den(934) = den(28)*den(578)
    den(935) = den(28)*den(580)
    den(936) = den(28)*den(582)
    den(937) = den(28)*den(584)
    den(938) = den(28)*den(595)
    den(939) = den(3)*den(601)
    den(940) = den(3)*den(602)
    den(941) = den(3)*den(603)
    den(942) = den(3)*den(604)
    den(943) = den(3)*den(609)
    den(944) = den(3)*den(610)
    den(945) = den(3)*den(611)
    den(946) = den(3)*den(612)
    den(947) = den(28)*den(597)
    den(948) = den(28)*den(598)
    den(949) = den(28)*den(599)
    den(950) = den(28)*den(600)
    den(951) = den(28)*den(605)
    den(952) = den(28)*den(606)
    den(953) = den(28)*den(607)
    den(954) = den(28)*den(608)
    den(955) = den(3)*den(627)
    den(956) = den(3)*den(629)
    den(957) = den(3)*den(631)
    den(958) = den(3)*den(633)
    den(959) = den(3)*den(648)
    den(960) = den(3)*den(650)
    den(961) = den(3)*den(652)
    den(962) = den(3)*den(654)
    den(963) = den(3)*den(656)
    den(964) = den(28)*den(617)
    den(965) = den(28)*den(619)
    den(966) = den(28)*den(621)
    den(967) = den(28)*den(623)
    den(968) = den(28)*den(638)
    den(969) = den(28)*den(640)
    den(970) = den(28)*den(642)
    den(971) = den(28)*den(644)
    den(972) = den(28)*den(655)
    den(973) = den(3)*den(661)
    den(974) = den(3)*den(662)
    den(975) = den(3)*den(663)
    den(976) = den(3)*den(664)
    den(977) = den(3)*den(669)
    den(978) = den(3)*den(670)
    den(979) = den(3)*den(671)
    den(980) = den(3)*den(672)
    den(981) = den(28)*den(657)
    den(982) = den(28)*den(658)
    den(983) = den(28)*den(659)
    den(984) = den(28)*den(660)
    den(985) = den(28)*den(665)
    den(986) = den(28)*den(666)
    den(987) = den(28)*den(667)
    den(988) = den(28)*den(668)
    den(989) = den(3)*den(677)
    den(990) = den(3)*den(678)
    den(991) = den(3)*den(679)
    den(992) = den(3)*den(680)
    den(993) = den(3)*den(685)
    den(994) = den(3)*den(686)
    den(995) = den(3)*den(687)
    den(996) = den(3)*den(688)
    den(997) = den(28)*den(673)
    den(998) = den(28)*den(674)
    den(999) = den(28)*den(675)
    den(1000) = den(28)*den(676)
    den(1001) = den(28)*den(681)
    den(1002) = den(28)*den(682)
    den(1003) = den(28)*den(683)
    den(1004) = den(28)*den(684)
    den(1005) = den(3)*den(693)
    den(1006) = den(3)*den(694)
    den(1007) = den(3)*den(695)
    den(1008) = den(3)*den(696)
    den(1009) = den(3)*den(701)
    den(1010) = den(3)*den(702)
    den(1011) = den(3)*den(703)
    den(1012) = den(3)*den(704)
    den(1013) = den(28)*den(689)
    den(1014) = den(28)*den(690)
    den(1015) = den(28)*den(691)
    den(1016) = den(28)*den(692)
    den(1017) = den(28)*den(697)
    den(1018) = den(28)*den(698)
    den(1019) = den(28)*den(699)
    den(1020) = den(28)*den(700)


  ! colour stripped tree amplitudes

  A(1) = cont_QA(wf(:,6),wf(:,7)) * den(7)
  A(2) = cont_QA(wf(:,7),wf(:,10)) * den(10)
  A(3) = cont_QA(wf(:,6),wf(:,14)) * den(13)
  A(4) = cont_QA(wf(:,10),wf(:,14)) * den(14)
  A(5) = cont_QA(wf(:,16),wf(:,17)) * den(18)
  A(6) = cont_QA(wf(:,16),wf(:,19)) * den(20)
  A(7) = cont_QA(wf(:,17),wf(:,20)) * den(22)
  A(8) = cont_QA(wf(:,19),wf(:,20)) * den(23)
  A(9) = cont_SS(wf(:,21),wf(:,22)) * den(27)
  A(10) = cont_QA(wf(:,26),wf(:,27)) * den(32)
  A(11) = cont_QA(wf(:,27),wf(:,28)) * den(34)
  A(12) = cont_QA(wf(:,26),wf(:,30)) * den(36)
  A(13) = cont_QA(wf(:,28),wf(:,30)) * den(37)
  A(14) = cont_QA(wf(:,32),wf(:,33)) * den(41)
  A(15) = cont_QA(wf(:,32),wf(:,35)) * den(43)
  A(16) = cont_QA(wf(:,33),wf(:,36)) * den(45)
  A(17) = cont_QA(wf(:,35),wf(:,36)) * den(46)
  A(18) = cont_SS(wf(:,22),wf(:,37)) * den(48)
  A(19) = cont_QA(wf(:,17),wf(:,38)) * den(49)
  A(20) = cont_QA(wf(:,19),wf(:,38)) * den(50)
  A(21) = cont_QA(wf(:,17),wf(:,39)) * den(51)
  A(22) = cont_QA(wf(:,19),wf(:,39)) * den(52)
  A(23) = cont_QA(wf(:,7),wf(:,40)) * den(53)
  A(24) = cont_QA(wf(:,7),wf(:,41)) * den(54)
  A(25) = cont_QA(wf(:,14),wf(:,40)) * den(55)
  A(26) = cont_QA(wf(:,14),wf(:,41)) * den(56)
  A(27) = cont_VV(wf(:,43),wf(:,45)) * den(61)
  A(28) = cont_VV(wf(:,47),wf(:,48)) * den(64)
  A(29) = cont_VV(wf(:,43),wf(:,51)) * den(66)
  A(30) = cont_VV(wf(:,47),wf(:,52)) * den(67)
  A(31) = cont_VV(wf(:,43),wf(:,55)) * den(70)
  A(32) = cont_VV(wf(:,47),wf(:,56)) * den(71)
  A(33) = cont_VV(wf(:,43),wf(:,59)) * den(73)
  A(34) = cont_VV(wf(:,47),wf(:,60)) * den(74)
  A(35) = cont_VV(wf(:,45),wf(:,61)) * den(76)
  A(36) = cont_VV(wf(:,48),wf(:,63)) * den(78)
  A(37) = cont_VV(wf(:,51),wf(:,61)) * den(79)
  A(38) = cont_VV(wf(:,52),wf(:,63)) * den(80)
  A(39) = cont_VV(wf(:,55),wf(:,61)) * den(81)
  A(40) = cont_VV(wf(:,56),wf(:,63)) * den(82)
  A(41) = cont_VV(wf(:,59),wf(:,61)) * den(83)
  A(42) = cont_VV(wf(:,60),wf(:,63)) * den(84)
  A(43) = cont_QA(wf(:,67),wf(:,68)) * den(90)
  A(44) = cont_QA(wf(:,68),wf(:,71)) * den(93)
  A(45) = cont_QA(wf(:,67),wf(:,75)) * den(96)
  A(46) = cont_QA(wf(:,71),wf(:,75)) * den(97)
  A(47) = cont_QA(wf(:,77),wf(:,78)) * den(101)
  A(48) = cont_QA(wf(:,77),wf(:,80)) * den(103)
  A(49) = cont_QA(wf(:,78),wf(:,81)) * den(105)
  A(50) = cont_QA(wf(:,80),wf(:,81)) * den(106)
  A(51) = cont_SS(wf(:,21),wf(:,82)) * den(108)
  A(52) = cont_QA(wf(:,84),wf(:,85)) * den(112)
  A(53) = cont_QA(wf(:,85),wf(:,86)) * den(114)
  A(54) = cont_QA(wf(:,84),wf(:,88)) * den(116)
  A(55) = cont_QA(wf(:,86),wf(:,88)) * den(117)
  A(56) = cont_QA(wf(:,90),wf(:,91)) * den(121)
  A(57) = cont_QA(wf(:,90),wf(:,93)) * den(123)
  A(58) = cont_QA(wf(:,91),wf(:,94)) * den(125)
  A(59) = cont_QA(wf(:,93),wf(:,94)) * den(126)
  A(60) = cont_SS(wf(:,37),wf(:,82)) * den(127)
  A(61) = cont_QA(wf(:,78),wf(:,95)) * den(128)
  A(62) = cont_QA(wf(:,80),wf(:,95)) * den(129)
  A(63) = cont_QA(wf(:,78),wf(:,96)) * den(130)
  A(64) = cont_QA(wf(:,80),wf(:,96)) * den(131)
  A(65) = cont_QA(wf(:,68),wf(:,97)) * den(132)
  A(66) = cont_QA(wf(:,68),wf(:,98)) * den(133)
  A(67) = cont_QA(wf(:,75),wf(:,97)) * den(134)
  A(68) = cont_QA(wf(:,75),wf(:,98)) * den(135)
  A(69) = cont_VV(wf(:,43),wf(:,101)) * den(137)
  A(70) = cont_VV(wf(:,47),wf(:,102)) * den(138)
  A(71) = cont_VV(wf(:,43),wf(:,105)) * den(140)
  A(72) = cont_VV(wf(:,47),wf(:,106)) * den(141)
  A(73) = cont_VV(wf(:,43),wf(:,109)) * den(144)
  A(74) = cont_VV(wf(:,43),wf(:,112)) * den(146)
  A(75) = cont_VV(wf(:,47),wf(:,113)) * den(147)
  A(76) = cont_VV(wf(:,47),wf(:,114)) * den(148)
  A(77) = cont_VV(wf(:,61),wf(:,101)) * den(149)
  A(78) = cont_VV(wf(:,63),wf(:,102)) * den(150)
  A(79) = cont_VV(wf(:,61),wf(:,105)) * den(151)
  A(80) = cont_VV(wf(:,63),wf(:,106)) * den(152)
  A(81) = cont_VV(wf(:,61),wf(:,109)) * den(153)
  A(82) = cont_VV(wf(:,61),wf(:,112)) * den(154)
  A(83) = cont_VV(wf(:,63),wf(:,113)) * den(155)
  A(84) = cont_VV(wf(:,63),wf(:,114)) * den(156)
  A(85) = cont_VV(wf(:,43),wf(:,117)) * den(159)
  A(86) = cont_VV(wf(:,47),wf(:,118)) * den(160)
  A(87) = cont_VV(wf(:,43),wf(:,121)) * den(162)
  A(88) = cont_VV(wf(:,47),wf(:,122)) * den(163)
  A(89) = cont_VV(wf(:,43),wf(:,125)) * den(165)
  A(90) = cont_VV(wf(:,47),wf(:,126)) * den(166)
  A(91) = cont_VV(wf(:,43),wf(:,129)) * den(168)
  A(92) = cont_VV(wf(:,47),wf(:,130)) * den(169)
  A(93) = cont_VV(wf(:,61),wf(:,117)) * den(170)
  A(94) = cont_VV(wf(:,63),wf(:,118)) * den(171)
  A(95) = cont_VV(wf(:,61),wf(:,121)) * den(172)
  A(96) = cont_VV(wf(:,63),wf(:,122)) * den(173)
  A(97) = cont_VV(wf(:,61),wf(:,125)) * den(174)
  A(98) = cont_VV(wf(:,63),wf(:,126)) * den(175)
  A(99) = cont_VV(wf(:,61),wf(:,129)) * den(176)
  A(100) = cont_VV(wf(:,63),wf(:,130)) * den(177)
  A(101) = cont_VV(wf(:,43),wf(:,133)) * den(179)
  A(102) = cont_VV(wf(:,47),wf(:,134)) * den(180)
  A(103) = cont_VV(wf(:,43),wf(:,137)) * den(182)
  A(104) = cont_VV(wf(:,47),wf(:,138)) * den(183)
  A(105) = cont_VV(wf(:,43),wf(:,141)) * den(185)
  A(106) = cont_VV(wf(:,43),wf(:,144)) * den(187)
  A(107) = cont_VV(wf(:,47),wf(:,145)) * den(188)
  A(108) = cont_VV(wf(:,47),wf(:,146)) * den(189)
  A(109) = cont_VV(wf(:,61),wf(:,133)) * den(190)
  A(110) = cont_VV(wf(:,63),wf(:,134)) * den(191)
  A(111) = cont_VV(wf(:,61),wf(:,137)) * den(192)
  A(112) = cont_VV(wf(:,63),wf(:,138)) * den(193)
  A(113) = cont_VV(wf(:,61),wf(:,141)) * den(194)
  A(114) = cont_VV(wf(:,61),wf(:,144)) * den(195)
  A(115) = cont_VV(wf(:,63),wf(:,145)) * den(196)
  A(116) = cont_VV(wf(:,63),wf(:,146)) * den(197)

  A(117) = cont_VV(wf(:,147),wf(:,148)) * den(200)
  A(118) = cont_VV(wf(:,147),wf(:,149)) * den(202)
  A(119) = cont_VV(wf(:,147),wf(:,150)) * den(204)
  A(120) = cont_VV(wf(:,147),wf(:,151)) * den(205)
  A(121) = cont_VV(wf(:,147),wf(:,152)) * den(207)
  A(122) = cont_VV(wf(:,147),wf(:,153)) * den(209)
  A(123) = cont_VV(wf(:,147),wf(:,154)) * den(211)
  A(124) = cont_VV(wf(:,147),wf(:,155)) * den(212)
  A(125) = cont_SS(wf(:,22),wf(:,156)) * den(215)
  A(126) = cont_QA(wf(:,7),wf(:,157)) * den(7)
  A(127) = cont_QA(wf(:,7),wf(:,158)) * den(10)
  A(128) = cont_QA(wf(:,14),wf(:,157)) * den(13)
  A(129) = cont_QA(wf(:,14),wf(:,158)) * den(14)
  A(130) = cont_QA(wf(:,17),wf(:,159)) * den(18)
  A(131) = cont_QA(wf(:,19),wf(:,159)) * den(20)
  A(132) = cont_QA(wf(:,17),wf(:,160)) * den(22)
  A(133) = cont_QA(wf(:,19),wf(:,160)) * den(23)
  A(134) = cont_QA(wf(:,27),wf(:,161)) * den(32)
  A(135) = cont_QA(wf(:,27),wf(:,162)) * den(34)
  A(136) = cont_QA(wf(:,30),wf(:,161)) * den(36)
  A(137) = cont_QA(wf(:,30),wf(:,162)) * den(37)
  A(138) = cont_QA(wf(:,33),wf(:,163)) * den(41)
  A(139) = cont_QA(wf(:,35),wf(:,163)) * den(43)
  A(140) = cont_QA(wf(:,33),wf(:,164)) * den(45)
  A(141) = cont_QA(wf(:,35),wf(:,164)) * den(46)
  A(142) = cont_QA(wf(:,17),wf(:,165)) * den(49)
  A(143) = cont_QA(wf(:,19),wf(:,165)) * den(50)
  A(144) = cont_QA(wf(:,17),wf(:,166)) * den(51)
  A(145) = cont_QA(wf(:,19),wf(:,166)) * den(52)
  A(146) = cont_VV(wf(:,167),wf(:,168)) * den(218)
  A(147) = cont_VV(wf(:,167),wf(:,169)) * den(219)
  A(148) = cont_QA(wf(:,7),wf(:,170)) * den(53)
  A(149) = cont_QA(wf(:,7),wf(:,171)) * den(54)
  A(150) = cont_QA(wf(:,14),wf(:,170)) * den(55)
  A(151) = cont_QA(wf(:,14),wf(:,171)) * den(56)
  A(152) = cont_VV(wf(:,167),wf(:,172)) * den(220)
  A(153) = cont_VV(wf(:,167),wf(:,173)) * den(221)
  A(154) = cont_VV(wf(:,174),wf(:,175)) * den(224)
  A(155) = cont_VV(wf(:,174),wf(:,176)) * den(225)
  A(156) = cont_VV(wf(:,174),wf(:,177)) * den(226)
  A(157) = cont_VV(wf(:,174),wf(:,178)) * den(227)
  A(158) = cont_SS(wf(:,22),wf(:,179)) * den(228)
  A(159) = cont_QA(wf(:,180),wf(:,181)) * den(231)
  A(160) = cont_QA(wf(:,181),wf(:,182)) * den(232)
  A(161) = cont_QA(wf(:,180),wf(:,183)) * den(234)
  A(162) = cont_QA(wf(:,182),wf(:,183)) * den(235)
  A(163) = cont_QA(wf(:,184),wf(:,185)) * den(238)
  A(164) = cont_QA(wf(:,184),wf(:,186)) * den(240)
  A(165) = cont_QA(wf(:,185),wf(:,187)) * den(241)
  A(166) = cont_QA(wf(:,186),wf(:,187)) * den(242)
  A(167) = cont_QA(wf(:,38),wf(:,188)) * den(49)
  A(168) = cont_QA(wf(:,38),wf(:,189)) * den(50)
  A(169) = cont_QA(wf(:,39),wf(:,188)) * den(51)
  A(170) = cont_QA(wf(:,39),wf(:,189)) * den(52)
  A(171) = cont_QA(wf(:,40),wf(:,190)) * den(53)
  A(172) = cont_QA(wf(:,41),wf(:,190)) * den(54)
  A(173) = cont_QA(wf(:,40),wf(:,191)) * den(55)
  A(174) = cont_QA(wf(:,41),wf(:,191)) * den(56)
  A(175) = cont_QA(wf(:,27),wf(:,194)) * den(32)
  A(176) = cont_QA(wf(:,27),wf(:,195)) * den(34)
  A(177) = cont_QA(wf(:,30),wf(:,194)) * den(36)
  A(178) = cont_QA(wf(:,30),wf(:,195)) * den(37)
  A(179) = cont_QA(wf(:,33),wf(:,196)) * den(41)
  A(180) = cont_QA(wf(:,35),wf(:,196)) * den(43)
  A(181) = cont_QA(wf(:,33),wf(:,197)) * den(45)
  A(182) = cont_QA(wf(:,35),wf(:,197)) * den(46)
  A(183) = cont_SS(wf(:,22),wf(:,198)) * den(48)
  A(184) = cont_SS(wf(:,22),wf(:,199)) * den(243)
  A(185) = cont_QA(wf(:,200),wf(:,201)) * den(246)
  A(186) = cont_QA(wf(:,201),wf(:,202)) * den(247)
  A(187) = cont_QA(wf(:,200),wf(:,203)) * den(249)
  A(188) = cont_QA(wf(:,202),wf(:,203)) * den(250)
  A(189) = cont_QA(wf(:,204),wf(:,205)) * den(253)
  A(190) = cont_QA(wf(:,204),wf(:,206)) * den(255)
  A(191) = cont_QA(wf(:,205),wf(:,207)) * den(256)
  A(192) = cont_QA(wf(:,206),wf(:,207)) * den(257)
  A(193) = cont_QA(wf(:,7),wf(:,209)) * den(53)
  A(194) = cont_QA(wf(:,7),wf(:,211)) * den(54)
  A(195) = cont_QA(wf(:,14),wf(:,209)) * den(55)
  A(196) = cont_QA(wf(:,14),wf(:,211)) * den(56)
  A(197) = cont_QA(wf(:,17),wf(:,213)) * den(49)
  A(198) = cont_QA(wf(:,19),wf(:,213)) * den(50)
  A(199) = cont_QA(wf(:,17),wf(:,215)) * den(51)
  A(200) = cont_QA(wf(:,19),wf(:,215)) * den(52)
  A(201) = cont_QA(wf(:,7),wf(:,218)) * den(7)
  A(202) = cont_QA(wf(:,7),wf(:,219)) * den(10)
  A(203) = cont_QA(wf(:,14),wf(:,218)) * den(13)
  A(204) = cont_QA(wf(:,14),wf(:,219)) * den(14)
  A(205) = cont_QA(wf(:,17),wf(:,220)) * den(18)
  A(206) = cont_QA(wf(:,19),wf(:,220)) * den(20)
  A(207) = cont_QA(wf(:,17),wf(:,221)) * den(22)
  A(208) = cont_QA(wf(:,19),wf(:,221)) * den(23)
  A(209) = cont_SS(wf(:,22),wf(:,222)) * den(27)
  A(210) = cont_VV(wf(:,48),wf(:,224)) * den(259)
  A(211) = cont_VV(wf(:,52),wf(:,224)) * den(260)
  A(212) = cont_VV(wf(:,56),wf(:,224)) * den(261)
  A(213) = cont_VV(wf(:,60),wf(:,224)) * den(262)
  A(214) = cont_VV(wf(:,45),wf(:,225)) * den(61)
  A(215) = cont_VV(wf(:,48),wf(:,227)) * den(64)
  A(216) = cont_VV(wf(:,51),wf(:,225)) * den(66)
  A(217) = cont_VV(wf(:,52),wf(:,227)) * den(67)
  A(218) = cont_VV(wf(:,55),wf(:,225)) * den(70)
  A(219) = cont_VV(wf(:,56),wf(:,227)) * den(71)
  A(220) = cont_VV(wf(:,59),wf(:,225)) * den(73)
  A(221) = cont_VV(wf(:,60),wf(:,227)) * den(74)
  A(222) = cont_VV(wf(:,45),wf(:,228)) * den(76)
  A(223) = cont_VV(wf(:,48),wf(:,230)) * den(78)
  A(224) = cont_VV(wf(:,51),wf(:,228)) * den(79)
  A(225) = cont_VV(wf(:,52),wf(:,230)) * den(80)
  A(226) = cont_VV(wf(:,55),wf(:,228)) * den(81)
  A(227) = cont_VV(wf(:,56),wf(:,230)) * den(82)
  A(228) = cont_VV(wf(:,59),wf(:,228)) * den(83)
  A(229) = cont_VV(wf(:,60),wf(:,230)) * den(84)
  A(230) = cont_VV(wf(:,45),wf(:,231)) * den(76)
  A(231) = cont_VV(wf(:,48),wf(:,233)) * den(78)
  A(232) = cont_VV(wf(:,51),wf(:,231)) * den(79)
  A(233) = cont_VV(wf(:,52),wf(:,233)) * den(80)
  A(234) = cont_VV(wf(:,55),wf(:,231)) * den(81)
  A(235) = cont_VV(wf(:,56),wf(:,233)) * den(82)
  A(236) = cont_VV(wf(:,59),wf(:,231)) * den(83)
  A(237) = cont_VV(wf(:,60),wf(:,233)) * den(84)
  A(238) = cont_VV(wf(:,45),wf(:,234)) * den(61)
  A(239) = cont_VV(wf(:,48),wf(:,236)) * den(64)
  A(240) = cont_VV(wf(:,51),wf(:,234)) * den(66)
  A(241) = cont_VV(wf(:,52),wf(:,236)) * den(67)
  A(242) = cont_VV(wf(:,55),wf(:,234)) * den(70)
  A(243) = cont_VV(wf(:,56),wf(:,236)) * den(71)
  A(244) = cont_VV(wf(:,59),wf(:,234)) * den(73)
  A(245) = cont_VV(wf(:,60),wf(:,236)) * den(74)
  A(246) = cont_SS(wf(:,82),wf(:,156)) * den(264)
  A(247) = cont_QA(wf(:,68),wf(:,237)) * den(90)
  A(248) = cont_QA(wf(:,68),wf(:,238)) * den(93)
  A(249) = cont_QA(wf(:,75),wf(:,237)) * den(96)
  A(250) = cont_QA(wf(:,75),wf(:,238)) * den(97)
  A(251) = cont_QA(wf(:,78),wf(:,239)) * den(101)
  A(252) = cont_QA(wf(:,80),wf(:,239)) * den(103)
  A(253) = cont_QA(wf(:,78),wf(:,240)) * den(105)
  A(254) = cont_QA(wf(:,80),wf(:,240)) * den(106)
  A(255) = cont_QA(wf(:,85),wf(:,241)) * den(112)
  A(256) = cont_QA(wf(:,85),wf(:,242)) * den(114)
  A(257) = cont_QA(wf(:,88),wf(:,241)) * den(116)
  A(258) = cont_QA(wf(:,88),wf(:,242)) * den(117)
  A(259) = cont_QA(wf(:,91),wf(:,243)) * den(121)
  A(260) = cont_QA(wf(:,93),wf(:,243)) * den(123)
  A(261) = cont_QA(wf(:,91),wf(:,244)) * den(125)
  A(262) = cont_QA(wf(:,93),wf(:,244)) * den(126)
  A(263) = cont_QA(wf(:,78),wf(:,245)) * den(128)
  A(264) = cont_QA(wf(:,80),wf(:,245)) * den(129)
  A(265) = cont_QA(wf(:,78),wf(:,246)) * den(130)
  A(266) = cont_QA(wf(:,80),wf(:,246)) * den(131)
  A(267) = cont_VV(wf(:,247),wf(:,248)) * den(267)
  A(268) = cont_VV(wf(:,247),wf(:,249)) * den(268)
  A(269) = cont_QA(wf(:,68),wf(:,250)) * den(132)
  A(270) = cont_QA(wf(:,68),wf(:,251)) * den(133)
  A(271) = cont_QA(wf(:,75),wf(:,250)) * den(134)
  A(272) = cont_QA(wf(:,75),wf(:,251)) * den(135)
  A(273) = cont_VV(wf(:,247),wf(:,252)) * den(269)
  A(274) = cont_VV(wf(:,247),wf(:,253)) * den(270)
  A(275) = cont_VV(wf(:,254),wf(:,255)) * den(273)
  A(276) = cont_VV(wf(:,254),wf(:,256)) * den(274)
  A(277) = cont_VV(wf(:,254),wf(:,257)) * den(275)
  A(278) = cont_VV(wf(:,254),wf(:,258)) * den(276)
  A(279) = cont_SS(wf(:,82),wf(:,179)) * den(277)
  A(280) = cont_QA(wf(:,259),wf(:,260)) * den(280)
  A(281) = cont_QA(wf(:,260),wf(:,261)) * den(281)
  A(282) = cont_QA(wf(:,259),wf(:,262)) * den(283)
  A(283) = cont_QA(wf(:,261),wf(:,262)) * den(284)
  A(284) = cont_QA(wf(:,263),wf(:,264)) * den(287)
  A(285) = cont_QA(wf(:,263),wf(:,265)) * den(289)
  A(286) = cont_QA(wf(:,264),wf(:,266)) * den(290)
  A(287) = cont_QA(wf(:,265),wf(:,266)) * den(291)
  A(288) = cont_QA(wf(:,95),wf(:,267)) * den(128)
  A(289) = cont_QA(wf(:,95),wf(:,268)) * den(129)
  A(290) = cont_QA(wf(:,96),wf(:,267)) * den(130)
  A(291) = cont_QA(wf(:,96),wf(:,268)) * den(131)
  A(292) = cont_QA(wf(:,97),wf(:,269)) * den(132)
  A(293) = cont_QA(wf(:,98),wf(:,269)) * den(133)
  A(294) = cont_QA(wf(:,97),wf(:,270)) * den(134)
  A(295) = cont_QA(wf(:,98),wf(:,270)) * den(135)
  A(296) = cont_QA(wf(:,85),wf(:,271)) * den(112)
  A(297) = cont_QA(wf(:,85),wf(:,272)) * den(114)
  A(298) = cont_QA(wf(:,88),wf(:,271)) * den(116)
  A(299) = cont_QA(wf(:,88),wf(:,272)) * den(117)
  A(300) = cont_QA(wf(:,91),wf(:,273)) * den(121)
  A(301) = cont_QA(wf(:,93),wf(:,273)) * den(123)
  A(302) = cont_QA(wf(:,91),wf(:,274)) * den(125)
  A(303) = cont_QA(wf(:,93),wf(:,274)) * den(126)
  A(304) = cont_SS(wf(:,82),wf(:,198)) * den(127)
  A(305) = cont_SS(wf(:,82),wf(:,199)) * den(292)
  A(306) = cont_QA(wf(:,275),wf(:,276)) * den(295)
  A(307) = cont_QA(wf(:,276),wf(:,277)) * den(296)
  A(308) = cont_QA(wf(:,275),wf(:,278)) * den(298)
  A(309) = cont_QA(wf(:,277),wf(:,278)) * den(299)
  A(310) = cont_QA(wf(:,279),wf(:,280)) * den(302)
  A(311) = cont_QA(wf(:,279),wf(:,281)) * den(304)
  A(312) = cont_QA(wf(:,280),wf(:,282)) * den(305)
  A(313) = cont_QA(wf(:,281),wf(:,282)) * den(306)
  A(314) = cont_QA(wf(:,68),wf(:,284)) * den(132)
  A(315) = cont_QA(wf(:,68),wf(:,286)) * den(133)
  A(316) = cont_QA(wf(:,75),wf(:,284)) * den(134)
  A(317) = cont_QA(wf(:,75),wf(:,286)) * den(135)
  A(318) = cont_QA(wf(:,78),wf(:,288)) * den(128)
  A(319) = cont_QA(wf(:,80),wf(:,288)) * den(129)
  A(320) = cont_QA(wf(:,78),wf(:,290)) * den(130)
  A(321) = cont_QA(wf(:,80),wf(:,290)) * den(131)
  A(322) = cont_QA(wf(:,68),wf(:,291)) * den(90)
  A(323) = cont_QA(wf(:,68),wf(:,292)) * den(93)
  A(324) = cont_QA(wf(:,75),wf(:,291)) * den(96)
  A(325) = cont_QA(wf(:,75),wf(:,292)) * den(97)
  A(326) = cont_QA(wf(:,78),wf(:,293)) * den(101)
  A(327) = cont_QA(wf(:,80),wf(:,293)) * den(103)
  A(328) = cont_QA(wf(:,78),wf(:,294)) * den(105)
  A(329) = cont_QA(wf(:,80),wf(:,294)) * den(106)
  A(330) = cont_SS(wf(:,82),wf(:,222)) * den(108)
  A(331) = cont_VV(wf(:,102),wf(:,224)) * den(307)
  A(332) = cont_VV(wf(:,106),wf(:,224)) * den(308)
  A(333) = cont_VV(wf(:,113),wf(:,224)) * den(309)
  A(334) = cont_VV(wf(:,114),wf(:,224)) * den(310)
  A(335) = cont_VV(wf(:,101),wf(:,225)) * den(137)
  A(336) = cont_VV(wf(:,102),wf(:,227)) * den(138)
  A(337) = cont_VV(wf(:,105),wf(:,225)) * den(140)
  A(338) = cont_VV(wf(:,106),wf(:,227)) * den(141)
  A(339) = cont_VV(wf(:,109),wf(:,225)) * den(144)
  A(340) = cont_VV(wf(:,112),wf(:,225)) * den(146)
  A(341) = cont_VV(wf(:,113),wf(:,227)) * den(147)
  A(342) = cont_VV(wf(:,114),wf(:,227)) * den(148)
  A(343) = cont_VV(wf(:,101),wf(:,228)) * den(149)
  A(344) = cont_VV(wf(:,102),wf(:,230)) * den(150)
  A(345) = cont_VV(wf(:,105),wf(:,228)) * den(151)
  A(346) = cont_VV(wf(:,106),wf(:,230)) * den(152)
  A(347) = cont_VV(wf(:,109),wf(:,228)) * den(153)
  A(348) = cont_VV(wf(:,112),wf(:,228)) * den(154)
  A(349) = cont_VV(wf(:,113),wf(:,230)) * den(155)
  A(350) = cont_VV(wf(:,114),wf(:,230)) * den(156)
  A(351) = cont_VV(wf(:,101),wf(:,231)) * den(149)
  A(352) = cont_VV(wf(:,102),wf(:,233)) * den(150)
  A(353) = cont_VV(wf(:,105),wf(:,231)) * den(151)
  A(354) = cont_VV(wf(:,106),wf(:,233)) * den(152)
  A(355) = cont_VV(wf(:,109),wf(:,231)) * den(153)
  A(356) = cont_VV(wf(:,112),wf(:,231)) * den(154)
  A(357) = cont_VV(wf(:,113),wf(:,233)) * den(155)
  A(358) = cont_VV(wf(:,114),wf(:,233)) * den(156)
  A(359) = cont_VV(wf(:,101),wf(:,234)) * den(137)
  A(360) = cont_VV(wf(:,102),wf(:,236)) * den(138)
  A(361) = cont_VV(wf(:,105),wf(:,234)) * den(140)
  A(362) = cont_VV(wf(:,106),wf(:,236)) * den(141)
  A(363) = cont_VV(wf(:,109),wf(:,234)) * den(144)
  A(364) = cont_VV(wf(:,112),wf(:,234)) * den(146)
  A(365) = cont_VV(wf(:,113),wf(:,236)) * den(147)
  A(366) = cont_VV(wf(:,114),wf(:,236)) * den(148)
  A(367) = cont_VV(wf(:,118),wf(:,224)) * den(311)
  A(368) = cont_VV(wf(:,122),wf(:,224)) * den(312)
  A(369) = cont_VV(wf(:,126),wf(:,224)) * den(313)
  A(370) = cont_VV(wf(:,130),wf(:,224)) * den(314)
  A(371) = cont_VV(wf(:,117),wf(:,225)) * den(159)
  A(372) = cont_VV(wf(:,118),wf(:,227)) * den(160)
  A(373) = cont_VV(wf(:,121),wf(:,225)) * den(162)
  A(374) = cont_VV(wf(:,122),wf(:,227)) * den(163)
  A(375) = cont_VV(wf(:,125),wf(:,225)) * den(165)
  A(376) = cont_VV(wf(:,126),wf(:,227)) * den(166)
  A(377) = cont_VV(wf(:,129),wf(:,225)) * den(168)
  A(378) = cont_VV(wf(:,130),wf(:,227)) * den(169)
  A(379) = cont_VV(wf(:,117),wf(:,228)) * den(170)
  A(380) = cont_VV(wf(:,118),wf(:,230)) * den(171)
  A(381) = cont_VV(wf(:,121),wf(:,228)) * den(172)
  A(382) = cont_VV(wf(:,122),wf(:,230)) * den(173)
  A(383) = cont_VV(wf(:,125),wf(:,228)) * den(174)
  A(384) = cont_VV(wf(:,126),wf(:,230)) * den(175)
  A(385) = cont_VV(wf(:,129),wf(:,228)) * den(176)
  A(386) = cont_VV(wf(:,130),wf(:,230)) * den(177)
  A(387) = cont_VV(wf(:,117),wf(:,231)) * den(170)
  A(388) = cont_VV(wf(:,118),wf(:,233)) * den(171)
  A(389) = cont_VV(wf(:,121),wf(:,231)) * den(172)
  A(390) = cont_VV(wf(:,122),wf(:,233)) * den(173)
  A(391) = cont_VV(wf(:,125),wf(:,231)) * den(174)
  A(392) = cont_VV(wf(:,126),wf(:,233)) * den(175)
  A(393) = cont_VV(wf(:,129),wf(:,231)) * den(176)
  A(394) = cont_VV(wf(:,130),wf(:,233)) * den(177)
  A(395) = cont_VV(wf(:,117),wf(:,234)) * den(159)
  A(396) = cont_VV(wf(:,118),wf(:,236)) * den(160)
  A(397) = cont_VV(wf(:,121),wf(:,234)) * den(162)
  A(398) = cont_VV(wf(:,122),wf(:,236)) * den(163)
  A(399) = cont_VV(wf(:,125),wf(:,234)) * den(165)
  A(400) = cont_VV(wf(:,126),wf(:,236)) * den(166)
  A(401) = cont_VV(wf(:,129),wf(:,234)) * den(168)
  A(402) = cont_VV(wf(:,130),wf(:,236)) * den(169)
  A(403) = cont_VV(wf(:,134),wf(:,224)) * den(315)
  A(404) = cont_VV(wf(:,138),wf(:,224)) * den(316)
  A(405) = cont_VV(wf(:,145),wf(:,224)) * den(317)
  A(406) = cont_VV(wf(:,146),wf(:,224)) * den(318)
  A(407) = cont_VV(wf(:,133),wf(:,225)) * den(179)
  A(408) = cont_VV(wf(:,134),wf(:,227)) * den(180)
  A(409) = cont_VV(wf(:,137),wf(:,225)) * den(182)
  A(410) = cont_VV(wf(:,138),wf(:,227)) * den(183)
  A(411) = cont_VV(wf(:,141),wf(:,225)) * den(185)
  A(412) = cont_VV(wf(:,144),wf(:,225)) * den(187)
  A(413) = cont_VV(wf(:,145),wf(:,227)) * den(188)
  A(414) = cont_VV(wf(:,146),wf(:,227)) * den(189)
  A(415) = cont_VV(wf(:,133),wf(:,228)) * den(190)
  A(416) = cont_VV(wf(:,134),wf(:,230)) * den(191)
  A(417) = cont_VV(wf(:,137),wf(:,228)) * den(192)
  A(418) = cont_VV(wf(:,138),wf(:,230)) * den(193)
  A(419) = cont_VV(wf(:,141),wf(:,228)) * den(194)
  A(420) = cont_VV(wf(:,144),wf(:,228)) * den(195)
  A(421) = cont_VV(wf(:,145),wf(:,230)) * den(196)
  A(422) = cont_VV(wf(:,146),wf(:,230)) * den(197)
  A(423) = cont_VV(wf(:,133),wf(:,231)) * den(190)
  A(424) = cont_VV(wf(:,134),wf(:,233)) * den(191)
  A(425) = cont_VV(wf(:,137),wf(:,231)) * den(192)
  A(426) = cont_VV(wf(:,138),wf(:,233)) * den(193)
  A(427) = cont_VV(wf(:,141),wf(:,231)) * den(194)
  A(428) = cont_VV(wf(:,144),wf(:,231)) * den(195)
  A(429) = cont_VV(wf(:,145),wf(:,233)) * den(196)
  A(430) = cont_VV(wf(:,146),wf(:,233)) * den(197)
  A(431) = cont_VV(wf(:,133),wf(:,234)) * den(179)
  A(432) = cont_VV(wf(:,134),wf(:,236)) * den(180)
  A(433) = cont_VV(wf(:,137),wf(:,234)) * den(182)
  A(434) = cont_VV(wf(:,138),wf(:,236)) * den(183)
  A(435) = cont_VV(wf(:,141),wf(:,234)) * den(185)
  A(436) = cont_VV(wf(:,144),wf(:,234)) * den(187)
  A(437) = cont_VV(wf(:,145),wf(:,236)) * den(188)
  A(438) = cont_VV(wf(:,146),wf(:,236)) * den(189)
  A(439) = cont_SS(wf(:,22),wf(:,297)) * den(320)
  A(440) = cont_QA(wf(:,7),wf(:,298)) * den(322)
  A(441) = cont_QA(wf(:,7),wf(:,299)) * den(324)
  A(442) = cont_QA(wf(:,14),wf(:,298)) * den(325)
  A(443) = cont_QA(wf(:,14),wf(:,299)) * den(326)
  A(444) = cont_QA(wf(:,17),wf(:,300)) * den(328)
  A(445) = cont_QA(wf(:,19),wf(:,300)) * den(329)
  A(446) = cont_QA(wf(:,17),wf(:,301)) * den(331)
  A(447) = cont_QA(wf(:,19),wf(:,301)) * den(332)
  A(448) = cont_QA(wf(:,185),wf(:,302)) * den(333)
  A(449) = cont_QA(wf(:,186),wf(:,302)) * den(334)
  A(450) = cont_QA(wf(:,185),wf(:,303)) * den(335)
  A(451) = cont_QA(wf(:,186),wf(:,303)) * den(336)
  A(452) = cont_QA(wf(:,181),wf(:,304)) * den(337)
  A(453) = cont_QA(wf(:,181),wf(:,305)) * den(338)
  A(454) = cont_QA(wf(:,183),wf(:,304)) * den(339)
  A(455) = cont_QA(wf(:,183),wf(:,305)) * den(340)
  A(456) = cont_SS(wf(:,22),wf(:,308)) * den(342)
  A(457) = cont_QA(wf(:,205),wf(:,309)) * den(343)
  A(458) = cont_QA(wf(:,206),wf(:,309)) * den(344)
  A(459) = cont_QA(wf(:,205),wf(:,310)) * den(345)
  A(460) = cont_QA(wf(:,206),wf(:,310)) * den(346)
  A(461) = cont_QA(wf(:,201),wf(:,311)) * den(347)
  A(462) = cont_QA(wf(:,201),wf(:,312)) * den(348)
  A(463) = cont_QA(wf(:,203),wf(:,311)) * den(349)
  A(464) = cont_QA(wf(:,203),wf(:,312)) * den(350)
  A(465) = cont_QA(wf(:,27),wf(:,313)) * den(352)
  A(466) = cont_QA(wf(:,27),wf(:,314)) * den(354)
  A(467) = cont_QA(wf(:,30),wf(:,313)) * den(355)
  A(468) = cont_QA(wf(:,30),wf(:,314)) * den(356)
  A(469) = cont_QA(wf(:,33),wf(:,315)) * den(358)
  A(470) = cont_QA(wf(:,35),wf(:,315)) * den(359)
  A(471) = cont_QA(wf(:,33),wf(:,316)) * den(361)
  A(472) = cont_QA(wf(:,35),wf(:,316)) * den(362)
  A(473) = cont_QA(wf(:,309),wf(:,318)) * den(364)
  A(474) = cont_QA(wf(:,309),wf(:,320)) * den(366)
  A(475) = cont_QA(wf(:,310),wf(:,318)) * den(367)
  A(476) = cont_QA(wf(:,310),wf(:,320)) * den(368)
  A(477) = cont_QA(wf(:,311),wf(:,322)) * den(370)
  A(478) = cont_QA(wf(:,312),wf(:,322)) * den(371)
  A(479) = cont_QA(wf(:,311),wf(:,324)) * den(373)
  A(480) = cont_QA(wf(:,312),wf(:,324)) * den(374)
  A(481) = cont_QA(wf(:,304),wf(:,325)) * den(376)
  A(482) = cont_QA(wf(:,305),wf(:,325)) * den(377)
  A(483) = cont_QA(wf(:,304),wf(:,326)) * den(379)
  A(484) = cont_QA(wf(:,305),wf(:,326)) * den(380)
  A(485) = cont_QA(wf(:,302),wf(:,327)) * den(382)
  A(486) = cont_QA(wf(:,302),wf(:,328)) * den(384)
  A(487) = cont_QA(wf(:,303),wf(:,327)) * den(385)
  A(488) = cont_QA(wf(:,303),wf(:,328)) * den(386)
  A(489) = cont_VV(wf(:,45),wf(:,329)) * den(389)
  A(490) = cont_VV(wf(:,330),wf(:,331)) * den(392)
  A(491) = cont_VV(wf(:,51),wf(:,329)) * den(394)
  A(492) = cont_VV(wf(:,330),wf(:,332)) * den(396)
  A(493) = cont_VV(wf(:,55),wf(:,329)) * den(398)
  A(494) = cont_VV(wf(:,330),wf(:,333)) * den(400)
  A(495) = cont_VV(wf(:,59),wf(:,329)) * den(402)
  A(496) = cont_VV(wf(:,330),wf(:,334)) * den(404)
  A(497) = cont_VV(wf(:,45),wf(:,335)) * den(405)
  A(498) = cont_VV(wf(:,331),wf(:,336)) * den(406)
  A(499) = cont_VV(wf(:,51),wf(:,335)) * den(407)
  A(500) = cont_VV(wf(:,332),wf(:,336)) * den(408)
  A(501) = cont_VV(wf(:,55),wf(:,335)) * den(409)
  A(502) = cont_VV(wf(:,333),wf(:,336)) * den(410)
  A(503) = cont_VV(wf(:,59),wf(:,335)) * den(411)
  A(504) = cont_VV(wf(:,334),wf(:,336)) * den(412)
  A(505) = cont_SS(wf(:,82),wf(:,297)) * den(413)
  A(506) = cont_QA(wf(:,68),wf(:,337)) * den(415)
  A(507) = cont_QA(wf(:,68),wf(:,338)) * den(417)
  A(508) = cont_QA(wf(:,75),wf(:,337)) * den(418)
  A(509) = cont_QA(wf(:,75),wf(:,338)) * den(419)
  A(510) = cont_QA(wf(:,78),wf(:,339)) * den(421)
  A(511) = cont_QA(wf(:,80),wf(:,339)) * den(422)
  A(512) = cont_QA(wf(:,78),wf(:,340)) * den(424)
  A(513) = cont_QA(wf(:,80),wf(:,340)) * den(425)
  A(514) = cont_QA(wf(:,264),wf(:,341)) * den(426)
  A(515) = cont_QA(wf(:,265),wf(:,341)) * den(427)
  A(516) = cont_QA(wf(:,264),wf(:,342)) * den(428)
  A(517) = cont_QA(wf(:,265),wf(:,342)) * den(429)
  A(518) = cont_QA(wf(:,260),wf(:,343)) * den(430)
  A(519) = cont_QA(wf(:,260),wf(:,344)) * den(431)
  A(520) = cont_QA(wf(:,262),wf(:,343)) * den(432)
  A(521) = cont_QA(wf(:,262),wf(:,344)) * den(433)
  A(522) = cont_SS(wf(:,82),wf(:,308)) * den(434)
  A(523) = cont_QA(wf(:,280),wf(:,345)) * den(435)
  A(524) = cont_QA(wf(:,281),wf(:,345)) * den(436)
  A(525) = cont_QA(wf(:,280),wf(:,346)) * den(437)
  A(526) = cont_QA(wf(:,281),wf(:,346)) * den(438)
  A(527) = cont_QA(wf(:,276),wf(:,347)) * den(439)
  A(528) = cont_QA(wf(:,276),wf(:,348)) * den(440)
  A(529) = cont_QA(wf(:,278),wf(:,347)) * den(441)
  A(530) = cont_QA(wf(:,278),wf(:,348)) * den(442)
  A(531) = cont_QA(wf(:,85),wf(:,349)) * den(444)
  A(532) = cont_QA(wf(:,85),wf(:,350)) * den(446)
  A(533) = cont_QA(wf(:,88),wf(:,349)) * den(447)
  A(534) = cont_QA(wf(:,88),wf(:,350)) * den(448)
  A(535) = cont_QA(wf(:,91),wf(:,351)) * den(450)
  A(536) = cont_QA(wf(:,93),wf(:,351)) * den(451)
  A(537) = cont_QA(wf(:,91),wf(:,352)) * den(453)
  A(538) = cont_QA(wf(:,93),wf(:,352)) * den(454)
  A(539) = cont_QA(wf(:,345),wf(:,354)) * den(456)
  A(540) = cont_QA(wf(:,345),wf(:,356)) * den(458)
  A(541) = cont_QA(wf(:,346),wf(:,354)) * den(459)
  A(542) = cont_QA(wf(:,346),wf(:,356)) * den(460)
  A(543) = cont_QA(wf(:,347),wf(:,358)) * den(462)
  A(544) = cont_QA(wf(:,348),wf(:,358)) * den(463)
  A(545) = cont_QA(wf(:,347),wf(:,360)) * den(465)
  A(546) = cont_QA(wf(:,348),wf(:,360)) * den(466)
  A(547) = cont_QA(wf(:,343),wf(:,361)) * den(468)
  A(548) = cont_QA(wf(:,344),wf(:,361)) * den(469)
  A(549) = cont_QA(wf(:,343),wf(:,362)) * den(471)
  A(550) = cont_QA(wf(:,344),wf(:,362)) * den(472)
  A(551) = cont_QA(wf(:,341),wf(:,363)) * den(474)
  A(552) = cont_QA(wf(:,341),wf(:,364)) * den(476)
  A(553) = cont_QA(wf(:,342),wf(:,363)) * den(477)
  A(554) = cont_QA(wf(:,342),wf(:,364)) * den(478)
  A(555) = cont_VV(wf(:,101),wf(:,329)) * den(480)
  A(556) = cont_VV(wf(:,330),wf(:,365)) * den(482)
  A(557) = cont_VV(wf(:,105),wf(:,329)) * den(484)
  A(558) = cont_VV(wf(:,330),wf(:,366)) * den(486)
  A(559) = cont_VV(wf(:,109),wf(:,329)) * den(488)
  A(560) = cont_VV(wf(:,112),wf(:,329)) * den(490)
  A(561) = cont_VV(wf(:,330),wf(:,367)) * den(492)
  A(562) = cont_VV(wf(:,330),wf(:,368)) * den(494)
  A(563) = cont_VV(wf(:,101),wf(:,335)) * den(495)
  A(564) = cont_VV(wf(:,336),wf(:,365)) * den(496)
  A(565) = cont_VV(wf(:,105),wf(:,335)) * den(497)
  A(566) = cont_VV(wf(:,336),wf(:,366)) * den(498)
  A(567) = cont_VV(wf(:,109),wf(:,335)) * den(499)
  A(568) = cont_VV(wf(:,112),wf(:,335)) * den(500)
  A(569) = cont_VV(wf(:,336),wf(:,367)) * den(501)
  A(570) = cont_VV(wf(:,336),wf(:,368)) * den(502)
  A(571) = cont_VV(wf(:,117),wf(:,329)) * den(504)
  A(572) = cont_VV(wf(:,330),wf(:,369)) * den(506)
  A(573) = cont_VV(wf(:,121),wf(:,329)) * den(508)
  A(574) = cont_VV(wf(:,330),wf(:,370)) * den(510)
  A(575) = cont_VV(wf(:,125),wf(:,329)) * den(512)
  A(576) = cont_VV(wf(:,330),wf(:,371)) * den(514)
  A(577) = cont_VV(wf(:,129),wf(:,329)) * den(516)
  A(578) = cont_VV(wf(:,330),wf(:,372)) * den(518)
  A(579) = cont_VV(wf(:,117),wf(:,335)) * den(519)
  A(580) = cont_VV(wf(:,336),wf(:,369)) * den(520)
  A(581) = cont_VV(wf(:,121),wf(:,335)) * den(521)
  A(582) = cont_VV(wf(:,336),wf(:,370)) * den(522)
  A(583) = cont_VV(wf(:,125),wf(:,335)) * den(523)
  A(584) = cont_VV(wf(:,336),wf(:,371)) * den(524)
  A(585) = cont_VV(wf(:,129),wf(:,335)) * den(525)
  A(586) = cont_VV(wf(:,336),wf(:,372)) * den(526)
  A(587) = cont_VV(wf(:,133),wf(:,329)) * den(528)
  A(588) = cont_VV(wf(:,330),wf(:,373)) * den(530)
  A(589) = cont_VV(wf(:,137),wf(:,329)) * den(532)
  A(590) = cont_VV(wf(:,330),wf(:,374)) * den(534)
  A(591) = cont_VV(wf(:,141),wf(:,329)) * den(536)
  A(592) = cont_VV(wf(:,144),wf(:,329)) * den(538)
  A(593) = cont_VV(wf(:,330),wf(:,375)) * den(540)
  A(594) = cont_VV(wf(:,330),wf(:,376)) * den(542)
  A(595) = cont_VV(wf(:,133),wf(:,335)) * den(543)
  A(596) = cont_VV(wf(:,336),wf(:,373)) * den(544)
  A(597) = cont_VV(wf(:,137),wf(:,335)) * den(545)
  A(598) = cont_VV(wf(:,336),wf(:,374)) * den(546)
  A(599) = cont_VV(wf(:,141),wf(:,335)) * den(547)
  A(600) = cont_VV(wf(:,144),wf(:,335)) * den(548)
  A(601) = cont_VV(wf(:,336),wf(:,375)) * den(549)
  A(602) = cont_VV(wf(:,336),wf(:,376)) * den(550)


  ! colour vectors

  M1(1) = (-A(1)-A(5)-A(10)-A(14)-A(19)-A(23)+A(43)+A(47)+A(52)+A(56)+A(61)+A(65))*f(1)+(-A(2)-A(3)-A(6)-A(7)-A(11)-A(12)-A(15) &
       -A(16)-A(20)-A(21)-A(24)-A(25)-A(27)-A(29)-A(31)-A(33)-A(35)-A(37)-A(39)-A(41)+A(44)+A(45)+A(48)+A(49)+A(53)+A(54)+A(57) &
       +A(58)+A(62)+A(63)+A(66)+A(67)+A(69)+A(71)+A(73)+A(74)+A(77)+A(79)+A(81)+A(82)+A(85)+A(87)+A(89)+A(91)+A(93)+A(95)+A(97) &
       +A(99)-A(101)-A(103)-A(105)-A(106)-A(109)-A(111)-A(113)-A(114))*f(2)+(-A(4)-A(8)-A(13)-A(17)-A(22)-A(26)-A(28)-A(30)-A(32) &
       -A(34)-A(36)-A(38)-A(40)-A(42)+A(46)+A(50)+A(55)+A(59)+A(64)+A(68)+A(70)+A(72)+A(75)+A(76)+A(78)+A(80)+A(83)+A(84)+A(86) &
       +A(88)+A(90)+A(92)+A(94)+A(96)+A(98)+A(100)-A(102)-A(104)-A(107)-A(108)-A(110)-A(112)-A(115)-A(116))*f(3)+(A(9)+A(18)-A(51) &
       -A(60))*f(18)

  M2(1) = (A(440)+A(444)+A(448)+A(452)+A(457)+A(461)+A(465)+A(469)+A(473)+A(477)+A(481)+A(485)-A(506)-A(510)-A(514)-A(518)-A(523) &
       -A(527)-A(531)-A(535)-A(539)-A(543)-A(547)-A(551))*f(4)+(A(441)+A(442)+A(445)+A(446)+A(449)+A(450)+A(453)+A(454)+A(458) &
       +A(459)+A(462)+A(463)+A(466)+A(467)+A(470)+A(471)+A(474)+A(475)+A(478)+A(479)+A(482)+A(483)+A(486)+A(487)+A(489)+A(491) &
       +A(493)+A(495)+A(497)+A(499)+A(501)+A(503)-A(507)-A(508)-A(511)-A(512)-A(515)-A(516)-A(519)-A(520)-A(524)-A(525)-A(528) &
       -A(529)-A(532)-A(533)-A(536)-A(537)-A(540)-A(541)-A(544)-A(545)-A(548)-A(549)-A(552)-A(553)-A(555)-A(557)-A(559)-A(560) &
       -A(563)-A(565)-A(567)-A(568)-A(571)-A(573)-A(575)-A(577)-A(579)-A(581)-A(583)-A(585)+A(587)+A(589)+A(591)+A(592)+A(595) &
       +A(597)+A(599)+A(600))*f(5)+(A(443)+A(447)+A(451)+A(455)+A(460)+A(464)+A(468)+A(472)+A(476)+A(480)+A(484)+A(488)+A(490) &
       +A(492)+A(494)+A(496)+A(498)+A(500)+A(502)+A(504)-A(509)-A(513)-A(517)-A(521)-A(526)-A(530)-A(534)-A(538)-A(542)-A(546) &
       -A(550)-A(554)-A(556)-A(558)-A(561)-A(562)-A(564)-A(566)-A(569)-A(570)-A(572)-A(574)-A(576)-A(578)-A(580)-A(582)-A(584) &
       -A(586)+A(588)+A(590)+A(593)+A(594)+A(596)+A(598)+A(601)+A(602))*f(6)+(-A(117)+A(121))*f(7)+(-A(118)-A(119)+A(122) &
       +A(123))*f(8)+(-A(142)-A(148)-A(175)-A(179)-A(201)-A(205)+A(263)+A(269)+A(296)+A(300)+A(322)+A(326))*f(9)+(-A(143)-A(144) &
       -A(149)-A(150)-A(176)-A(177)-A(180)-A(181)-A(202)-A(203)-A(206)-A(207)-A(222)-A(224)-A(226)-A(228)-A(238)-A(240)-A(242) &
       -A(244)+A(264)+A(265)+A(270)+A(271)+A(297)+A(298)+A(301)+A(302)+A(323)+A(324)+A(327)+A(328)+A(343)+A(345)+A(347)+A(348) &
       +A(359)+A(361)+A(363)+A(364)+A(379)+A(381)+A(383)+A(385)+A(395)+A(397)+A(399)+A(401)-A(415)-A(417)-A(419)-A(420)-A(431) &
       -A(433)-A(435)-A(436))*f(10)+(-A(145)-A(151)-A(178)-A(182)-A(204)-A(208)-A(223)-A(225)-A(227)-A(229)-A(239)-A(241)-A(243) &
       -A(245)+A(266)+A(272)+A(299)+A(303)+A(325)+A(329)+A(344)+A(346)+A(349)+A(350)+A(360)+A(362)+A(365)+A(366)+A(380)+A(382) &
       +A(384)+A(386)+A(396)+A(398)+A(400)+A(402)-A(416)-A(418)-A(421)-A(422)-A(432)-A(434)-A(437)-A(438))*f(11)+(-A(126)-A(130) &
       -A(134)-A(138)-A(159)-A(163)-A(167)-A(171)-A(185)-A(189)-A(193)-A(197)+A(247)+A(251)+A(255)+A(259)+A(280)+A(284)+A(288) &
       +A(292)+A(306)+A(310)+A(314)+A(318))*f(12)+(-A(127)-A(128)-A(131)-A(132)-A(135)-A(136)-A(139)-A(140)-A(160)-A(161)-A(164) &
       -A(165)-A(168)-A(169)-A(172)-A(173)-A(186)-A(187)-A(190)-A(191)-A(194)-A(195)-A(198)-A(199)-A(214)-A(216)-A(218)-A(220) &
       -A(230)-A(232)-A(234)-A(236)+A(248)+A(249)+A(252)+A(253)+A(256)+A(257)+A(260)+A(261)+A(281)+A(282)+A(285)+A(286)+A(289) &
       +A(290)+A(293)+A(294)+A(307)+A(308)+A(311)+A(312)+A(315)+A(316)+A(319)+A(320)+A(335)+A(337)+A(339)+A(340)+A(351)+A(353) &
       +A(355)+A(356)+A(371)+A(373)+A(375)+A(377)+A(387)+A(389)+A(391)+A(393)-A(407)-A(409)-A(411)-A(412)-A(423)-A(425)-A(427) &
       -A(428))*f(13)+(-A(129)-A(133)-A(137)-A(141)-A(162)-A(166)-A(170)-A(174)-A(188)-A(192)-A(196)-A(200)-A(215)-A(217)-A(219) &
       -A(221)-A(231)-A(233)-A(235)-A(237)+A(250)+A(254)+A(258)+A(262)+A(283)+A(287)+A(291)+A(295)+A(309)+A(313)+A(317)+A(321) &
       +A(336)+A(338)+A(341)+A(342)+A(352)+A(354)+A(357)+A(358)+A(372)+A(374)+A(376)+A(378)+A(388)+A(390)+A(392)+A(394)-A(408) &
       -A(410)-A(413)-A(414)-A(424)-A(426)-A(429)-A(430))*f(14)+(A(146)+A(152)+A(154)+A(156)-A(267)-A(273)-A(275)-A(277))*f(15) &
       +(A(147)+A(153)+A(155)+A(157)+A(210)+A(211)+A(212)+A(213)-A(268)-A(274)-A(276)-A(278)-A(331)-A(332)-A(333)-A(334)-A(367) &
       -A(368)-A(369)-A(370)+A(403)+A(404)+A(405)+A(406))*f(16)+(-A(120)+A(124))*f(17)+(-A(439)-A(456)+A(505)+A(522))*f(19) &
       +(A(183)+A(209)-A(304)-A(330))*f(20)+(A(158)+A(184)-A(279)-A(305))*f(21)+(A(125)-A(246))*f(22)


end subroutine tree_wavefunctions

end module ol_loop_ppllllj_eeexexbbxg_1_/**/REALKIND
