
! **********************************************************************
module ol_heltables_ppllllj_nmeexmxuxdg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n8, n10, n14, n16, n19, n22, n25, n29, n31, n33, n38, n41, n44, n47

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n6, n7, n9, n11, n12, n13, n15, n17, n18, n20, n21, n23, n24, n26, n27, n28, n30, n32, n34, n35, n36, n37, n39, n40 &
  , n42, n43, n45, n46, n48, n49, n50, n51, n52, n53, n54, n55, n56, n57, n58, n59, n60, n61, n62, n63, n64, n65, n66, n67, n68 &
  , n69, n70, n71, n72


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t9, t21

  integer(intkind2), save, dimension(2,8) :: &
  t6, t12, t15, t17, t23, t27, t30, t32, t37, t40, t43, t46

  integer(intkind2), save, dimension(2,16) :: &
  t7, t11, t13, t18, t20, t24, t26, t28, t34, t35, t36, t39, t42, t45, t48

  integer(intkind2), save, dimension(2,128) :: &
  t49, t50, t51, t52, t53, t54, t55, t56, t57, t58, t59, t60, t61, t62, t63, t64, t65, t66, t67, t68, t69, t70, t71, t72


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  n5 = 4
  call heltable([4,2,8], n6, t6)
  call heltable([4,4,16], n7, t7)
  n8 = 8
  call heltable([2,2,4], n9, t9)
  n10 = 4
  call heltable([4,4,16], n11, t11)
  call heltable([4,2,8], n12, t12)
  call heltable([4,4,16], n13, t13)
  n14 = 8
  call heltable([4,2,8], n15, t15)
  n16 = 8
  call heltable([2,4,8], n17, t17)
  call heltable([4,4,16], n18, t18)
  n19 = 8
  call heltable([4,4,16], n20, t20)
  call heltable([2,2,4], n21, t21)
  n22 = 4
  call heltable([2,4,8], n23, t23)
  call heltable([4,4,16], n24, t24)
  n25 = 8
  call heltable([4,4,16], n26, t26)
  call heltable([2,4,8], n27, t27)
  call heltable([4,4,16], n28, t28)
  n29 = 8
  call heltable([2,4,8], n30, t30)
  n31 = 8
  call heltable([4,2,8], n32, t32)
  n33 = 8
  call heltable([8,2,16], n34, t34)
  call heltable([8,2,16], n35, t35)
  call heltable([8,2,16], n36, t36)
  call heltable([4,2,8], n37, t37)
  n38 = 8
  call heltable([8,2,16], n39, t39)
  call heltable([2,4,8], n40, t40)
  n41 = 8
  call heltable([2,8,16], n42, t42)
  call heltable([2,4,8], n43, t43)
  n44 = 8
  call heltable([2,8,16], n45, t45)
  call heltable([4,2,8], n46, t46)
  n47 = 8
  call heltable([8,2,16], n48, t48)
  call heltable([16,8,128], n49, t49)
  call heltable([8,16,128], n50, t50)
  call heltable([16,8,128], n51, t51)
  call heltable([16,8,128], n52, t52)
  call heltable([16,8,128], n53, t53)
  call heltable([8,16,128], n54, t54)
  call heltable([16,8,128], n55, t55)
  call heltable([8,16,128], n56, t56)
  call heltable([16,8,128], n57, t57)
  call heltable([16,8,128], n58, t58)
  call heltable([16,8,128], n59, t59)
  call heltable([16,8,128], n60, t60)
  call heltable([8,16,128], n61, t61)
  call heltable([8,16,128], n62, t62)
  call heltable([8,16,128], n63, t63)
  call heltable([8,16,128], n64, t64)
  call heltable([8,16,128], n65, t65)
  call heltable([8,16,128], n66, t66)
  call heltable([8,16,128], n67, t67)
  call heltable([8,16,128], n68, t68)
  call heltable([8,16,128], n69, t69)
  call heltable([8,16,128], n70, t70)
  call heltable([8,16,128], n71, t71)
  call heltable([8,16,128], n72, t72)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_nmeexmxuxdg_1
