
! **********************************************************************
module ol_heltables_ppllllj_nenmxexmddxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n6, n9, n13, n15, n18, n21, n24, n28, n31, n35

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n7, n8, n10, n11, n12, n14, n16, n17, n19, n20, n22, n23, n25, n26, n27, n29, n30, n32, n33, n34, n36, n37, n38, n39 &
  , n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54, n55


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t14

  integer(intkind2), save, dimension(2,8) :: &
  t7, t10, t12, t16, t19, t20, t23, t27, t30, t34

  integer(intkind2), save, dimension(2,16) :: &
  t8, t11, t17, t22, t25, t26, t29, t32, t33, t36

  integer(intkind2), save, dimension(2,128) :: &
  t37, t38, t39, t40, t41, t42, t43, t44, t45, t46, t47, t48, t49, t50, t51, t52, t53, t54, t55


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  n5 = 4
  n6 = 4
  call heltable([2,4,8], n7, t7)
  call heltable([4,4,16], n8, t8)
  n9 = 8
  call heltable([4,2,8], n10, t10)
  call heltable([4,4,16], n11, t11)
  call heltable([4,2,8], n12, t12)
  n13 = 8
  call heltable([2,2,4], n14, t14)
  n15 = 4
  call heltable([4,2,8], n16, t16)
  call heltable([4,4,16], n17, t17)
  n18 = 8
  call heltable([2,4,8], n19, t19)
  call heltable([2,4,8], n20, t20)
  n21 = 8
  call heltable([2,8,16], n22, t22)
  call heltable([2,4,8], n23, t23)
  n24 = 8
  call heltable([2,8,16], n25, t25)
  call heltable([2,8,16], n26, t26)
  call heltable([4,2,8], n27, t27)
  n28 = 8
  call heltable([8,2,16], n29, t29)
  call heltable([4,2,8], n30, t30)
  n31 = 8
  call heltable([8,2,16], n32, t32)
  call heltable([8,2,16], n33, t33)
  call heltable([2,4,8], n34, t34)
  n35 = 8
  call heltable([2,8,16], n36, t36)
  call heltable([16,8,128], n37, t37)
  call heltable([8,16,128], n38, t38)
  call heltable([16,8,128], n39, t39)
  call heltable([16,8,128], n40, t40)
  call heltable([16,8,128], n41, t41)
  call heltable([16,8,128], n42, t42)
  call heltable([8,16,128], n43, t43)
  call heltable([8,16,128], n44, t44)
  call heltable([8,16,128], n45, t45)
  call heltable([8,16,128], n46, t46)
  call heltable([8,16,128], n47, t47)
  call heltable([8,16,128], n48, t48)
  call heltable([8,16,128], n49, t49)
  call heltable([8,16,128], n50, t50)
  call heltable([8,16,128], n51, t51)
  call heltable([8,16,128], n52, t52)
  call heltable([8,16,128], n53, t53)
  call heltable([8,16,128], n54, t54)
  call heltable([8,16,128], n55, t55)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_nenmxexmddxg_1
