
! **********************************************************************
module ol_heltables_ppllllj_nenexnexeudxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n6, n9, n12, n15, n17, n20, n23, n25, n29, n32, n36, n37, n40, n43, n47, n50, n54, n57, n60, n63

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n7, n8, n10, n11, n13, n14, n16, n18, n19, n21, n22, n24, n26, n27, n28, n30, n31, n33, n34, n35, n38, n39, n41, n42 &
  , n44, n45, n46, n48, n49, n51, n52, n53, n55, n56, n58, n59, n61, n62, n64, n65, n66, n67, n68, n69, n70, n71, n72, n73, n74 &
  , n75, n76, n77, n78, n79, n80, n81, n82, n83, n84, n85, n86, n87, n88, n89, n90, n91, n92


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t16, t34, t35

  integer(intkind2), save, dimension(2,8) :: &
  t7, t10, t13, t18, t21, t24, t28, t31, t38, t41, t45, t48, t53, t56, t59, t62

  integer(intkind2), save, dimension(2,16) :: &
  t8, t11, t14, t19, t22, t26, t27, t30, t33, t39, t42, t44, t46, t49, t51, t52, t55, t58, t61, t64

  integer(intkind2), save, dimension(2,128) :: &
  t65, t66, t67, t68, t69, t70, t71, t72, t73, t74, t75, t76, t77, t78, t79, t80, t81, t82, t83, t84, t85, t86, t87, t88, t89, t90 &
  , t91, t92


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  n5 = 4
  n6 = 4
  call heltable([2,4,8], n7, t7)
  call heltable([4,4,16], n8, t8)
  n9 = 8
  call heltable([2,4,8], n10, t10)
  call heltable([4,4,16], n11, t11)
  n12 = 8
  call heltable([4,2,8], n13, t13)
  call heltable([4,4,16], n14, t14)
  n15 = 8
  call heltable([2,2,4], n16, t16)
  n17 = 4
  call heltable([4,2,8], n18, t18)
  call heltable([4,4,16], n19, t19)
  n20 = 8
  call heltable([4,2,8], n21, t21)
  call heltable([4,4,16], n22, t22)
  n23 = 8
  call heltable([2,4,8], n24, t24)
  n25 = 8
  call heltable([2,8,16], n26, t26)
  call heltable([2,8,16], n27, t27)
  call heltable([2,4,8], n28, t28)
  n29 = 8
  call heltable([2,8,16], n30, t30)
  call heltable([4,2,8], n31, t31)
  n32 = 8
  call heltable([8,2,16], n33, t33)
  call heltable([2,2,4], n34, t34)
  call heltable([2,2,4], n35, t35)
  n36 = 4
  n37 = 4
  call heltable([2,4,8], n38, t38)
  call heltable([4,4,16], n39, t39)
  n40 = 8
  call heltable([2,4,8], n41, t41)
  call heltable([4,4,16], n42, t42)
  n43 = 8
  call heltable([4,4,16], n44, t44)
  call heltable([4,2,8], n45, t45)
  call heltable([4,4,16], n46, t46)
  n47 = 8
  call heltable([4,2,8], n48, t48)
  call heltable([4,4,16], n49, t49)
  n50 = 8
  call heltable([2,8,16], n51, t51)
  call heltable([2,8,16], n52, t52)
  call heltable([2,4,8], n53, t53)
  n54 = 8
  call heltable([2,8,16], n55, t55)
  call heltable([4,2,8], n56, t56)
  n57 = 8
  call heltable([8,2,16], n58, t58)
  call heltable([4,2,8], n59, t59)
  n60 = 8
  call heltable([8,2,16], n61, t61)
  call heltable([4,2,8], n62, t62)
  n63 = 8
  call heltable([8,2,16], n64, t64)
  call heltable([16,8,128], n65, t65)
  call heltable([16,8,128], n66, t66)
  call heltable([16,8,128], n67, t67)
  call heltable([16,8,128], n68, t68)
  call heltable([16,8,128], n69, t69)
  call heltable([16,8,128], n70, t70)
  call heltable([8,16,128], n71, t71)
  call heltable([8,16,128], n72, t72)
  call heltable([8,16,128], n73, t73)
  call heltable([8,16,128], n74, t74)
  call heltable([8,16,128], n75, t75)
  call heltable([8,16,128], n76, t76)
  call heltable([16,8,128], n77, t77)
  call heltable([16,8,128], n78, t78)
  call heltable([8,16,128], n79, t79)
  call heltable([16,8,128], n80, t80)
  call heltable([16,8,128], n81, t81)
  call heltable([8,16,128], n82, t82)
  call heltable([8,16,128], n83, t83)
  call heltable([8,16,128], n84, t84)
  call heltable([8,16,128], n85, t85)
  call heltable([8,16,128], n86, t86)
  call heltable([8,16,128], n87, t87)
  call heltable([8,16,128], n88, t88)
  call heltable([8,16,128], n89, t89)
  call heltable([8,16,128], n90, t90)
  call heltable([8,16,128], n91, t91)
  call heltable([8,16,128], n92, t92)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_nenexnexeudxg_1
