
! **********************************************************************
module ol_heltables_ppllllj_nenexeexddxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n8, n10, n14, n16, n18, n21, n25, n27, n33, n36, n39, n44, n47, n48, n51, n55, n58, n62, n65, n69, n72, n75

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n6, n7, n9, n11, n12, n13, n15, n17, n19, n20, n22, n23, n24, n26, n28, n29, n30, n31, n32, n34, n35, n37, n38, n40 &
  , n41, n42, n43, n45, n46, n49, n50, n52, n53, n54, n56, n57, n59, n60, n61, n63, n64, n66, n67, n68, n70, n71, n73, n74, n76 &
  , n77, n78, n79, n80, n81, n82, n83, n84, n85, n86, n87, n88, n89, n90, n91, n92, n93, n94, n95, n96, n97, n98, n99, n100, n101 &
  , n102, n103, n104, n105, n106, n107, n108, n109, n110, n111, n112, n113, n114, n115, n116, n117, n118, n119


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t9, t17, t45, t46

  integer(intkind2), save, dimension(2,8) :: &
  t6, t12, t15, t19, t23, t26, t31, t32, t35, t38, t42, t43, t49, t53, t57, t61, t64, t68, t71, t74

  integer(intkind2), save, dimension(2,16) :: &
  t7, t11, t13, t20, t22, t24, t28, t29, t30, t34, t37, t40, t41, t50, t52, t54, t56, t59, t60, t63, t66, t67, t70, t73, t76

  integer(intkind2), save, dimension(2,128) :: &
  t77, t78, t79, t80, t81, t82, t83, t84, t85, t86, t87, t88, t89, t90, t91, t92, t93, t94, t95, t96, t97, t98, t99, t100, t101 &
  , t102, t103, t104, t105, t106, t107, t108, t109, t110, t111, t112, t113, t114, t115, t116, t117, t118, t119


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  n5 = 4
  call heltable([2,4,8], n6, t6)
  call heltable([4,4,16], n7, t7)
  n8 = 8
  call heltable([2,2,4], n9, t9)
  n10 = 4
  call heltable([4,4,16], n11, t11)
  call heltable([2,4,8], n12, t12)
  call heltable([4,4,16], n13, t13)
  n14 = 8
  call heltable([2,4,8], n15, t15)
  n16 = 8
  call heltable([2,2,4], n17, t17)
  n18 = 4
  call heltable([4,2,8], n19, t19)
  call heltable([4,4,16], n20, t20)
  n21 = 8
  call heltable([4,4,16], n22, t22)
  call heltable([4,2,8], n23, t23)
  call heltable([4,4,16], n24, t24)
  n25 = 8
  call heltable([4,2,8], n26, t26)
  n27 = 8
  call heltable([2,8,16], n28, t28)
  call heltable([2,8,16], n29, t29)
  call heltable([2,8,16], n30, t30)
  call heltable([4,2,8], n31, t31)
  call heltable([4,2,8], n32, t32)
  n33 = 8
  call heltable([8,2,16], n34, t34)
  call heltable([4,2,8], n35, t35)
  n36 = 8
  call heltable([8,2,16], n37, t37)
  call heltable([2,4,8], n38, t38)
  n39 = 8
  call heltable([2,8,16], n40, t40)
  call heltable([2,8,16], n41, t41)
  call heltable([2,4,8], n42, t42)
  call heltable([2,4,8], n43, t43)
  n44 = 8
  call heltable([2,2,4], n45, t45)
  call heltable([2,2,4], n46, t46)
  n47 = 4
  n48 = 4
  call heltable([2,4,8], n49, t49)
  call heltable([4,4,16], n50, t50)
  n51 = 8
  call heltable([4,4,16], n52, t52)
  call heltable([4,2,8], n53, t53)
  call heltable([4,4,16], n54, t54)
  n55 = 8
  call heltable([2,8,16], n56, t56)
  call heltable([4,2,8], n57, t57)
  n58 = 8
  call heltable([8,2,16], n59, t59)
  call heltable([8,2,16], n60, t60)
  call heltable([2,4,8], n61, t61)
  n62 = 8
  call heltable([2,8,16], n63, t63)
  call heltable([2,4,8], n64, t64)
  n65 = 8
  call heltable([2,8,16], n66, t66)
  call heltable([2,8,16], n67, t67)
  call heltable([4,2,8], n68, t68)
  n69 = 8
  call heltable([8,2,16], n70, t70)
  call heltable([4,2,8], n71, t71)
  n72 = 8
  call heltable([8,2,16], n73, t73)
  call heltable([2,4,8], n74, t74)
  n75 = 8
  call heltable([2,8,16], n76, t76)
  call heltable([16,8,128], n77, t77)
  call heltable([8,16,128], n78, t78)
  call heltable([16,8,128], n79, t79)
  call heltable([16,8,128], n80, t80)
  call heltable([16,8,128], n81, t81)
  call heltable([8,16,128], n82, t82)
  call heltable([16,8,128], n83, t83)
  call heltable([16,8,128], n84, t84)
  call heltable([8,16,128], n85, t85)
  call heltable([8,16,128], n86, t86)
  call heltable([8,16,128], n87, t87)
  call heltable([8,16,128], n88, t88)
  call heltable([8,16,128], n89, t89)
  call heltable([8,16,128], n90, t90)
  call heltable([8,16,128], n91, t91)
  call heltable([8,16,128], n92, t92)
  call heltable([16,8,128], n93, t93)
  call heltable([16,8,128], n94, t94)
  call heltable([16,8,128], n95, t95)
  call heltable([16,8,128], n96, t96)
  call heltable([16,8,128], n97, t97)
  call heltable([8,16,128], n98, t98)
  call heltable([8,16,128], n99, t99)
  call heltable([16,8,128], n100, t100)
  call heltable([8,16,128], n101, t101)
  call heltable([8,16,128], n102, t102)
  call heltable([8,16,128], n103, t103)
  call heltable([8,16,128], n104, t104)
  call heltable([8,16,128], n105, t105)
  call heltable([8,16,128], n106, t106)
  call heltable([8,16,128], n107, t107)
  call heltable([8,16,128], n108, t108)
  call heltable([8,16,128], n109, t109)
  call heltable([8,16,128], n110, t110)
  call heltable([8,16,128], n111, t111)
  call heltable([8,16,128], n112, t112)
  call heltable([8,16,128], n113, t113)
  call heltable([8,16,128], n114, t114)
  call heltable([8,16,128], n115, t115)
  call heltable([8,16,128], n116, t116)
  call heltable([8,16,128], n117, t117)
  call heltable([8,16,128], n118, t118)
  call heltable([8,16,128], n119, t119)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_nenexeexddxg_1
