
! **********************************************************************
module ol_heltables_ppllllj_nenenexnexddxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n6, n9, n12, n14, n17, n20, n25, n26, n29, n32, n35, n36, n39, n42, n45, n48, n52, n55, n58, n61, n64, n67

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n7, n8, n10, n11, n13, n15, n16, n18, n19, n21, n22, n23, n24, n27, n28, n30, n31, n33, n34, n37, n38, n40, n41, n43 &
  , n44, n46, n47, n49, n50, n51, n53, n54, n56, n57, n59, n60, n62, n63, n65, n66, n68, n69, n70, n71, n72, n73, n74, n75, n76 &
  , n77, n78, n79, n80, n81, n82, n83, n84, n85, n86, n87, n88, n89, n90, n91, n92, n93, n94, n95, n96


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t13, t33, t34

  integer(intkind2), save, dimension(2,8) :: &
  t7, t10, t15, t18, t23, t24, t28, t31, t37, t40, t43, t46, t51, t54, t57, t60, t63, t66

  integer(intkind2), save, dimension(2,16) :: &
  t8, t11, t16, t19, t21, t22, t27, t30, t38, t41, t44, t47, t49, t50, t53, t56, t59, t62, t65, t68

  integer(intkind2), save, dimension(2,128) :: &
  t69, t70, t71, t72, t73, t74, t75, t76, t77, t78, t79, t80, t81, t82, t83, t84, t85, t86, t87, t88, t89, t90, t91, t92, t93, t94 &
  , t95, t96


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  n5 = 4
  n6 = 4
  call heltable([2,4,8], n7, t7)
  call heltable([4,4,16], n8, t8)
  n9 = 8
  call heltable([2,4,8], n10, t10)
  call heltable([4,4,16], n11, t11)
  n12 = 8
  call heltable([2,2,4], n13, t13)
  n14 = 4
  call heltable([4,2,8], n15, t15)
  call heltable([4,4,16], n16, t16)
  n17 = 8
  call heltable([4,2,8], n18, t18)
  call heltable([4,4,16], n19, t19)
  n20 = 8
  call heltable([2,8,16], n21, t21)
  call heltable([2,8,16], n22, t22)
  call heltable([4,2,8], n23, t23)
  call heltable([4,2,8], n24, t24)
  n25 = 8
  n26 = 8
  call heltable([8,2,16], n27, t27)
  call heltable([2,4,8], n28, t28)
  n29 = 8
  call heltable([2,8,16], n30, t30)
  call heltable([2,4,8], n31, t31)
  n32 = 8
  call heltable([2,2,4], n33, t33)
  call heltable([2,2,4], n34, t34)
  n35 = 4
  n36 = 4
  call heltable([2,4,8], n37, t37)
  call heltable([4,4,16], n38, t38)
  n39 = 8
  call heltable([2,4,8], n40, t40)
  call heltable([4,4,16], n41, t41)
  n42 = 8
  call heltable([4,2,8], n43, t43)
  call heltable([4,4,16], n44, t44)
  n45 = 8
  call heltable([4,2,8], n46, t46)
  call heltable([4,4,16], n47, t47)
  n48 = 8
  call heltable([2,8,16], n49, t49)
  call heltable([2,8,16], n50, t50)
  call heltable([4,2,8], n51, t51)
  n52 = 8
  call heltable([8,2,16], n53, t53)
  call heltable([2,4,8], n54, t54)
  n55 = 8
  call heltable([2,8,16], n56, t56)
  call heltable([4,2,8], n57, t57)
  n58 = 8
  call heltable([8,2,16], n59, t59)
  call heltable([2,4,8], n60, t60)
  n61 = 8
  call heltable([2,8,16], n62, t62)
  call heltable([4,2,8], n63, t63)
  n64 = 8
  call heltable([8,2,16], n65, t65)
  call heltable([2,4,8], n66, t66)
  n67 = 8
  call heltable([2,8,16], n68, t68)
  call heltable([16,8,128], n69, t69)
  call heltable([16,8,128], n70, t70)
  call heltable([16,8,128], n71, t71)
  call heltable([16,8,128], n72, t72)
  call heltable([8,16,128], n73, t73)
  call heltable([8,16,128], n74, t74)
  call heltable([8,16,128], n75, t75)
  call heltable([8,16,128], n76, t76)
  call heltable([16,8,128], n77, t77)
  call heltable([16,8,128], n78, t78)
  call heltable([16,8,128], n79, t79)
  call heltable([16,8,128], n80, t80)
  call heltable([16,8,128], n81, t81)
  call heltable([16,8,128], n82, t82)
  call heltable([8,16,128], n83, t83)
  call heltable([8,16,128], n84, t84)
  call heltable([8,16,128], n85, t85)
  call heltable([8,16,128], n86, t86)
  call heltable([8,16,128], n87, t87)
  call heltable([8,16,128], n88, t88)
  call heltable([8,16,128], n89, t89)
  call heltable([8,16,128], n90, t90)
  call heltable([8,16,128], n91, t91)
  call heltable([8,16,128], n92, t92)
  call heltable([8,16,128], n93, t93)
  call heltable([8,16,128], n94, t94)
  call heltable([8,16,128], n95, t95)
  call heltable([8,16,128], n96, t96)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_nenenexnexddxg_1
