
! **********************************************************************
module ol_heltables_ppllllj_nenenexnexbbxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n5, n6, n9, n12, n16, n19, n22, n28, n29, n32, n35, n38, n39, n42, n45, n49, n52, n56, n59, n62, n65, n68, n71

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n7, n8, n10, n11, n13, n14, n15, n17, n18, n20, n21, n23, n24, n25, n26, n27, n30, n31, n33, n34, n36, n37, n40, n41 &
  , n43, n44, n46, n47, n48, n50, n51, n53, n54, n55, n57, n58, n60, n61, n63, n64, n66, n67, n69, n70, n72, n73, n74, n75, n76 &
  , n77, n78, n79, n80, n81, n82, n83, n84, n85, n86, n87, n88, n89, n90, n91, n92, n93, n94, n95, n96, n97, n98, n99, n100, n101 &
  , n102, n103, n104


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t15, t36, t37

  integer(intkind2), save, dimension(2,8) :: &
  t7, t10, t13, t17, t20, t23, t26, t27, t31, t34, t40, t43, t47, t50, t55, t58, t61, t64, t67, t70

  integer(intkind2), save, dimension(2,16) :: &
  t8, t11, t14, t18, t21, t24, t25, t30, t33, t41, t44, t46, t48, t51, t53, t54, t57, t60, t63, t66, t69, t72

  integer(intkind2), save, dimension(2,128) :: &
  t73, t74, t75, t76, t77, t78, t79, t80, t81, t82, t83, t84, t85, t86, t87, t88, t89, t90, t91, t92, t93, t94, t95, t96, t97, t98 &
  , t99, t100, t101, t102, t103, t104


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  n5 = 4
  n6 = 4
  call heltable([2,4,8], n7, t7)
  call heltable([4,4,16], n8, t8)
  n9 = 8
  call heltable([2,4,8], n10, t10)
  call heltable([4,4,16], n11, t11)
  n12 = 8
  call heltable([2,4,8], n13, t13)
  call heltable([4,4,16], n14, t14)
  call heltable([2,2,4], n15, t15)
  n16 = 4
  call heltable([4,2,8], n17, t17)
  call heltable([4,4,16], n18, t18)
  n19 = 8
  call heltable([4,2,8], n20, t20)
  call heltable([4,4,16], n21, t21)
  n22 = 8
  call heltable([4,2,8], n23, t23)
  call heltable([2,8,16], n24, t24)
  call heltable([2,8,16], n25, t25)
  call heltable([4,2,8], n26, t26)
  call heltable([4,2,8], n27, t27)
  n28 = 8
  n29 = 8
  call heltable([8,2,16], n30, t30)
  call heltable([2,4,8], n31, t31)
  n32 = 8
  call heltable([2,8,16], n33, t33)
  call heltable([2,4,8], n34, t34)
  n35 = 8
  call heltable([2,2,4], n36, t36)
  call heltable([2,2,4], n37, t37)
  n38 = 4
  n39 = 4
  call heltable([2,4,8], n40, t40)
  call heltable([4,4,16], n41, t41)
  n42 = 8
  call heltable([2,4,8], n43, t43)
  call heltable([4,4,16], n44, t44)
  n45 = 8
  call heltable([4,4,16], n46, t46)
  call heltable([4,2,8], n47, t47)
  call heltable([4,4,16], n48, t48)
  n49 = 8
  call heltable([4,2,8], n50, t50)
  call heltable([4,4,16], n51, t51)
  n52 = 8
  call heltable([2,8,16], n53, t53)
  call heltable([2,8,16], n54, t54)
  call heltable([4,2,8], n55, t55)
  n56 = 8
  call heltable([8,2,16], n57, t57)
  call heltable([2,4,8], n58, t58)
  n59 = 8
  call heltable([2,8,16], n60, t60)
  call heltable([4,2,8], n61, t61)
  n62 = 8
  call heltable([8,2,16], n63, t63)
  call heltable([2,4,8], n64, t64)
  n65 = 8
  call heltable([2,8,16], n66, t66)
  call heltable([4,2,8], n67, t67)
  n68 = 8
  call heltable([8,2,16], n69, t69)
  call heltable([2,4,8], n70, t70)
  n71 = 8
  call heltable([2,8,16], n72, t72)
  call heltable([16,8,128], n73, t73)
  call heltable([16,8,128], n74, t74)
  call heltable([8,16,128], n75, t75)
  call heltable([16,8,128], n76, t76)
  call heltable([16,8,128], n77, t77)
  call heltable([16,8,128], n78, t78)
  call heltable([8,16,128], n79, t79)
  call heltable([8,16,128], n80, t80)
  call heltable([8,16,128], n81, t81)
  call heltable([8,16,128], n82, t82)
  call heltable([16,8,128], n83, t83)
  call heltable([16,8,128], n84, t84)
  call heltable([16,8,128], n85, t85)
  call heltable([16,8,128], n86, t86)
  call heltable([8,16,128], n87, t87)
  call heltable([16,8,128], n88, t88)
  call heltable([16,8,128], n89, t89)
  call heltable([8,16,128], n90, t90)
  call heltable([8,16,128], n91, t91)
  call heltable([8,16,128], n92, t92)
  call heltable([8,16,128], n93, t93)
  call heltable([8,16,128], n94, t94)
  call heltable([8,16,128], n95, t95)
  call heltable([8,16,128], n96, t96)
  call heltable([8,16,128], n97, t97)
  call heltable([8,16,128], n98, t98)
  call heltable([8,16,128], n99, t99)
  call heltable([8,16,128], n100, t100)
  call heltable([8,16,128], n101, t101)
  call heltable([8,16,128], n102, t102)
  call heltable([8,16,128], n103, t103)
  call heltable([8,16,128], n104, t104)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_nenenexnexbbxg_1
