
! **********************************************************************
module ol_heltables_ppllllj_eexmmxuuxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n7, n9, n12, n14, n17, n19, n22, n25, n28, n31, n33, n41, n44, n47, n51, n55, n60, n62, n66, n70, n73

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n5, n6, n8, n10, n11, n13, n15, n16, n18, n20, n21, n23, n24, n26, n27, n29, n30, n32, n34, n35, n36, n37, n38, n39 &
  , n40, n42, n43, n45, n46, n48, n49, n50, n52, n53, n54, n56, n57, n58, n59, n61, n63, n64, n65, n67, n68, n69, n71, n72, n74 &
  , n75, n76, n77, n78, n79, n80, n81, n82, n83, n84, n85, n86, n87, n88, n89, n90, n91, n92, n93, n94, n95, n96, n97, n98, n99 &
  , n100, n101, n102, n103, n104, n105, n106, n107, n108, n109, n110, n111, n112, n113, n114, n115, n116, n117, n118, n119, n120 &
  , n121, n122, n123, n124, n125, n126, n127, n128, n129, n130, n131, n132


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t8, t11, t21

  integer(intkind2), save, dimension(2,8) :: &
  t5, t13, t15, t18, t23, t27, t29, t32, t39, t40, t43, t46, t50, t54, t58, t59, t61, t65, t69, t72

  integer(intkind2), save, dimension(2,16) :: &
  t6, t10, t16, t20, t24, t26, t30, t34, t35, t36, t37, t38, t42, t45, t48, t49, t52, t53, t56, t57, t63, t64, t67, t68, t71, t74 &
  , t75, t76

  integer(intkind2), save, dimension(2,128) :: &
  t77, t78, t79, t80, t81, t82, t83, t84, t85, t86, t87, t88, t89, t90, t91, t92, t93, t94, t95, t96, t97, t98, t99, t100, t101 &
  , t102, t103, t104, t105, t106, t107, t108, t109, t110, t111, t112, t113, t114, t115, t116, t117, t118, t119, t120, t121, t122 &
  , t123, t124, t125, t126, t127, t128, t129, t130, t131, t132


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  call heltable([2,4,8], n5, t5)
  call heltable([4,4,16], n6, t6)
  n7 = 8
  call heltable([2,2,4], n8, t8)
  n9 = 4
  call heltable([4,4,16], n10, t10)
  call heltable([2,2,4], n11, t11)
  n12 = 4
  call heltable([2,4,8], n13, t13)
  n14 = 8
  call heltable([2,4,8], n15, t15)
  call heltable([4,4,16], n16, t16)
  n17 = 8
  call heltable([2,4,8], n18, t18)
  n19 = 8
  call heltable([4,4,16], n20, t20)
  call heltable([2,2,4], n21, t21)
  n22 = 4
  call heltable([4,2,8], n23, t23)
  call heltable([4,4,16], n24, t24)
  n25 = 8
  call heltable([4,4,16], n26, t26)
  call heltable([4,2,8], n27, t27)
  n28 = 8
  call heltable([4,2,8], n29, t29)
  call heltable([4,4,16], n30, t30)
  n31 = 8
  call heltable([4,2,8], n32, t32)
  n33 = 8
  call heltable([4,4,16], n34, t34)
  call heltable([2,8,16], n35, t35)
  call heltable([2,8,16], n36, t36)
  call heltable([2,8,16], n37, t37)
  call heltable([2,8,16], n38, t38)
  call heltable([4,2,8], n39, t39)
  call heltable([4,2,8], n40, t40)
  n41 = 8
  call heltable([8,2,16], n42, t42)
  call heltable([4,2,8], n43, t43)
  n44 = 8
  call heltable([8,2,16], n45, t45)
  call heltable([4,2,8], n46, t46)
  n47 = 8
  call heltable([8,2,16], n48, t48)
  call heltable([8,2,16], n49, t49)
  call heltable([2,4,8], n50, t50)
  n51 = 8
  call heltable([2,8,16], n52, t52)
  call heltable([2,8,16], n53, t53)
  call heltable([2,4,8], n54, t54)
  n55 = 8
  call heltable([2,8,16], n56, t56)
  call heltable([2,8,16], n57, t57)
  call heltable([2,4,8], n58, t58)
  call heltable([2,4,8], n59, t59)
  n60 = 8
  call heltable([4,2,8], n61, t61)
  n62 = 8
  call heltable([8,2,16], n63, t63)
  call heltable([8,2,16], n64, t64)
  call heltable([4,2,8], n65, t65)
  n66 = 8
  call heltable([8,2,16], n67, t67)
  call heltable([8,2,16], n68, t68)
  call heltable([2,4,8], n69, t69)
  n70 = 8
  call heltable([2,8,16], n71, t71)
  call heltable([2,4,8], n72, t72)
  n73 = 8
  call heltable([2,8,16], n74, t74)
  call heltable([2,8,16], n75, t75)
  call heltable([2,8,16], n76, t76)
  call heltable([16,8,128], n77, t77)
  call heltable([8,16,128], n78, t78)
  call heltable([16,8,128], n79, t79)
  call heltable([16,8,128], n80, t80)
  call heltable([16,8,128], n81, t81)
  call heltable([16,8,128], n82, t82)
  call heltable([8,16,128], n83, t83)
  call heltable([8,16,128], n84, t84)
  call heltable([16,8,128], n85, t85)
  call heltable([8,16,128], n86, t86)
  call heltable([16,8,128], n87, t87)
  call heltable([16,8,128], n88, t88)
  call heltable([16,8,128], n89, t89)
  call heltable([16,8,128], n90, t90)
  call heltable([8,16,128], n91, t91)
  call heltable([8,16,128], n92, t92)
  call heltable([8,16,128], n93, t93)
  call heltable([8,16,128], n94, t94)
  call heltable([8,16,128], n95, t95)
  call heltable([8,16,128], n96, t96)
  call heltable([8,16,128], n97, t97)
  call heltable([8,16,128], n98, t98)
  call heltable([8,16,128], n99, t99)
  call heltable([8,16,128], n100, t100)
  call heltable([8,16,128], n101, t101)
  call heltable([8,16,128], n102, t102)
  call heltable([8,16,128], n103, t103)
  call heltable([8,16,128], n104, t104)
  call heltable([8,16,128], n105, t105)
  call heltable([8,16,128], n106, t106)
  call heltable([8,16,128], n107, t107)
  call heltable([8,16,128], n108, t108)
  call heltable([16,8,128], n109, t109)
  call heltable([16,8,128], n110, t110)
  call heltable([16,8,128], n111, t111)
  call heltable([16,8,128], n112, t112)
  call heltable([16,8,128], n113, t113)
  call heltable([16,8,128], n114, t114)
  call heltable([16,8,128], n115, t115)
  call heltable([16,8,128], n116, t116)
  call heltable([8,16,128], n117, t117)
  call heltable([8,16,128], n118, t118)
  call heltable([8,16,128], n119, t119)
  call heltable([8,16,128], n120, t120)
  call heltable([8,16,128], n121, t121)
  call heltable([8,16,128], n122, t122)
  call heltable([8,16,128], n123, t123)
  call heltable([8,16,128], n124, t124)
  call heltable([8,16,128], n125, t125)
  call heltable([8,16,128], n126, t126)
  call heltable([8,16,128], n127, t127)
  call heltable([8,16,128], n128, t128)
  call heltable([8,16,128], n129, t129)
  call heltable([8,16,128], n130, t130)
  call heltable([8,16,128], n131, t131)
  call heltable([8,16,128], n132, t132)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_eexmmxuuxg_1
