
! **********************************************************************
module ol_heltables_ppllllj_eeexexbbxg_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(2) = [-1,1], &
    H4(2) = [-1,1], &
    H5(2) = [-1,1], &
    H6(2) = [-1,1], &
    H7(2) = [-1,1]

  ! number of helicity states for wave functions returned by a propagator call
  ! integer(intkind2), save :: &
  !   na, nb, ...

  ! number of helicity states for wave functions in a v-point vertex call (v >= 3) or a contraction (v = 3)
  ! integer(intkind2), save, dimension(v) :: &
  !   nc, nd, ...

  integer(intkind2), save :: &
  n4, n7, n9, n12, n14, n17, n19, n24, n27, n30, n33, n35, n44, n47, n50, n54, n58, n63, n68, n70, n73, n75, n78, n80, n85, n88 &
  , n91, n93, n100, n104, n108, n111, n116, n120, n124, n128, n132, n136, n140, n143

  integer(intkind2), save, dimension(3) :: &
  n1, n2, n3, n5, n6, n8, n10, n11, n13, n15, n16, n18, n20, n21, n22, n23, n25, n26, n28, n29, n31, n32, n34, n36, n37, n38, n39 &
  , n40, n41, n42, n43, n45, n46, n48, n49, n51, n52, n53, n55, n56, n57, n59, n60, n61, n62, n64, n65, n66, n67, n69, n71, n72 &
  , n74, n76, n77, n79, n81, n82, n83, n84, n86, n87, n89, n90, n92, n94, n95, n96, n97, n98, n99, n101, n102, n103, n105, n106 &
  , n107, n109, n110, n112, n113, n114, n115, n117, n118, n119, n121, n122, n123, n125, n126, n127, n129, n130, n131, n133, n134 &
  , n135, n137, n138, n139, n141, n142, n144, n145, n146, n147, n148, n149, n150, n151, n152, n153, n154, n155, n156, n157, n158 &
  , n159, n160, n161, n162, n163, n164, n165, n166, n167, n168, n169, n170, n171, n172, n173, n174, n175, n176, n177, n178, n179 &
  , n180, n181, n182, n183, n184, n185, n186, n187, n188, n189, n190, n191, n192, n193, n194, n195, n196, n197, n198, n199, n200 &
  , n201, n202, n203, n204, n205, n206, n207, n208, n209, n210, n211, n212, n213, n214, n215, n216, n217, n218, n219, n220, n221 &
  , n222, n223, n224, n225, n226, n227, n228, n229, n230, n231, n232, n233, n234, n235, n236, n237, n238, n239, n240, n241, n242 &
  , n243, n244, n245, n246, n247, n248, n249, n250, n251, n252, n253, n254, n255, n256, n257, n258, n259, n260, n261, n262


  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude) from an v-point vertex (contraction)
  ! integer(intkind2), save, dimension(v-1,h) :: &
  !   ta, tb, ...

  integer(intkind2), save, dimension(2,4) :: &
  t1, t2, t3, t8, t11, t23, t64, t65, t69, t72

  integer(intkind2), save, dimension(2,8) :: &
  t5, t13, t15, t18, t21, t25, t29, t31, t34, t37, t42, t43, t46, t49, t53, t57, t61, t62, t66, t74, t76, t79, t83, t87, t89, t92 &
  , t99, t103, t107, t110, t115, t119, t123, t127, t131, t135, t139, t142

  integer(intkind2), save, dimension(2,16) :: &
  t6, t10, t16, t20, t22, t26, t28, t32, t36, t38, t39, t40, t41, t45, t48, t51, t52, t55, t56, t59, t60, t67, t71, t77, t81, t82 &
  , t84, t86, t90, t94, t95, t96, t97, t98, t101, t102, t105, t106, t109, t112, t113, t114, t117, t118, t121, t122, t125, t126 &
  , t129, t130, t133, t134, t137, t138, t141, t144, t145, t146

  integer(intkind2), save, dimension(2,128) :: &
  t147, t148, t149, t150, t151, t152, t153, t154, t155, t156, t157, t158, t159, t160, t161, t162, t163, t164, t165, t166, t167 &
  , t168, t169, t170, t171, t172, t173, t174, t175, t176, t177, t178, t179, t180, t181, t182, t183, t184, t185, t186, t187, t188 &
  , t189, t190, t191, t192, t193, t194, t195, t196, t197, t198, t199, t200, t201, t202, t203, t204, t205, t206, t207, t208, t209 &
  , t210, t211, t212, t213, t214, t215, t216, t217, t218, t219, t220, t221, t222, t223, t224, t225, t226, t227, t228, t229, t230 &
  , t231, t232, t233, t234, t235, t236, t237, t238, t239, t240, t241, t242, t243, t244, t245, t246, t247, t248, t249, t250, t251 &
  , t252, t253, t254, t255, t256, t257, t258, t259, t260, t261, t262


  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(128,7)
  integer,           save :: exthel(128,7)
  integer,           save :: firstpol(7)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n1, t1)
  call heltable([2,2,4], n2, t2)
  call heltable([2,2,4], n3, t3)
  n4 = 4
  call heltable([2,4,8], n5, t5)
  call heltable([4,4,16], n6, t6)
  n7 = 8
  call heltable([2,2,4], n8, t8)
  n9 = 4
  call heltable([4,4,16], n10, t10)
  call heltable([2,2,4], n11, t11)
  n12 = 4
  call heltable([2,4,8], n13, t13)
  n14 = 8
  call heltable([2,4,8], n15, t15)
  call heltable([4,4,16], n16, t16)
  n17 = 8
  call heltable([2,4,8], n18, t18)
  n19 = 8
  call heltable([4,4,16], n20, t20)
  call heltable([2,4,8], n21, t21)
  call heltable([4,4,16], n22, t22)
  call heltable([2,2,4], n23, t23)
  n24 = 4
  call heltable([4,2,8], n25, t25)
  call heltable([4,4,16], n26, t26)
  n27 = 8
  call heltable([4,4,16], n28, t28)
  call heltable([4,2,8], n29, t29)
  n30 = 8
  call heltable([4,2,8], n31, t31)
  call heltable([4,4,16], n32, t32)
  n33 = 8
  call heltable([4,2,8], n34, t34)
  n35 = 8
  call heltable([4,4,16], n36, t36)
  call heltable([4,2,8], n37, t37)
  call heltable([2,8,16], n38, t38)
  call heltable([2,8,16], n39, t39)
  call heltable([2,8,16], n40, t40)
  call heltable([2,8,16], n41, t41)
  call heltable([4,2,8], n42, t42)
  call heltable([4,2,8], n43, t43)
  n44 = 8
  call heltable([8,2,16], n45, t45)
  call heltable([4,2,8], n46, t46)
  n47 = 8
  call heltable([8,2,16], n48, t48)
  call heltable([4,2,8], n49, t49)
  n50 = 8
  call heltable([8,2,16], n51, t51)
  call heltable([8,2,16], n52, t52)
  call heltable([2,4,8], n53, t53)
  n54 = 8
  call heltable([2,8,16], n55, t55)
  call heltable([2,8,16], n56, t56)
  call heltable([2,4,8], n57, t57)
  n58 = 8
  call heltable([2,8,16], n59, t59)
  call heltable([2,8,16], n60, t60)
  call heltable([2,4,8], n61, t61)
  call heltable([2,4,8], n62, t62)
  n63 = 8
  call heltable([2,2,4], n64, t64)
  call heltable([2,2,4], n65, t65)
  call heltable([2,4,8], n66, t66)
  call heltable([4,4,16], n67, t67)
  n68 = 8
  call heltable([2,2,4], n69, t69)
  n70 = 4
  call heltable([4,4,16], n71, t71)
  call heltable([2,2,4], n72, t72)
  n73 = 4
  call heltable([2,4,8], n74, t74)
  n75 = 8
  call heltable([2,4,8], n76, t76)
  call heltable([4,4,16], n77, t77)
  n78 = 8
  call heltable([2,4,8], n79, t79)
  n80 = 8
  call heltable([4,4,16], n81, t81)
  call heltable([4,4,16], n82, t82)
  call heltable([4,2,8], n83, t83)
  call heltable([4,4,16], n84, t84)
  n85 = 8
  call heltable([4,4,16], n86, t86)
  call heltable([4,2,8], n87, t87)
  n88 = 8
  call heltable([4,2,8], n89, t89)
  call heltable([4,4,16], n90, t90)
  n91 = 8
  call heltable([4,2,8], n92, t92)
  n93 = 8
  call heltable([4,4,16], n94, t94)
  call heltable([2,8,16], n95, t95)
  call heltable([2,8,16], n96, t96)
  call heltable([2,8,16], n97, t97)
  call heltable([2,8,16], n98, t98)
  call heltable([4,2,8], n99, t99)
  n100 = 8
  call heltable([8,2,16], n101, t101)
  call heltable([8,2,16], n102, t102)
  call heltable([4,2,8], n103, t103)
  n104 = 8
  call heltable([8,2,16], n105, t105)
  call heltable([8,2,16], n106, t106)
  call heltable([2,4,8], n107, t107)
  n108 = 8
  call heltable([2,8,16], n109, t109)
  call heltable([2,4,8], n110, t110)
  n111 = 8
  call heltable([2,8,16], n112, t112)
  call heltable([2,8,16], n113, t113)
  call heltable([2,8,16], n114, t114)
  call heltable([4,2,8], n115, t115)
  n116 = 8
  call heltable([8,2,16], n117, t117)
  call heltable([8,2,16], n118, t118)
  call heltable([4,2,8], n119, t119)
  n120 = 8
  call heltable([8,2,16], n121, t121)
  call heltable([8,2,16], n122, t122)
  call heltable([2,4,8], n123, t123)
  n124 = 8
  call heltable([2,8,16], n125, t125)
  call heltable([2,8,16], n126, t126)
  call heltable([2,4,8], n127, t127)
  n128 = 8
  call heltable([2,8,16], n129, t129)
  call heltable([2,8,16], n130, t130)
  call heltable([4,2,8], n131, t131)
  n132 = 8
  call heltable([8,2,16], n133, t133)
  call heltable([8,2,16], n134, t134)
  call heltable([4,2,8], n135, t135)
  n136 = 8
  call heltable([8,2,16], n137, t137)
  call heltable([8,2,16], n138, t138)
  call heltable([2,4,8], n139, t139)
  n140 = 8
  call heltable([2,8,16], n141, t141)
  call heltable([2,4,8], n142, t142)
  n143 = 8
  call heltable([2,8,16], n144, t144)
  call heltable([2,8,16], n145, t145)
  call heltable([2,8,16], n146, t146)
  call heltable([16,8,128], n147, t147)
  call heltable([8,16,128], n148, t148)
  call heltable([16,8,128], n149, t149)
  call heltable([16,8,128], n150, t150)
  call heltable([16,8,128], n151, t151)
  call heltable([16,8,128], n152, t152)
  call heltable([8,16,128], n153, t153)
  call heltable([8,16,128], n154, t154)
  call heltable([8,16,128], n155, t155)
  call heltable([16,8,128], n156, t156)
  call heltable([8,16,128], n157, t157)
  call heltable([16,8,128], n158, t158)
  call heltable([16,8,128], n159, t159)
  call heltable([16,8,128], n160, t160)
  call heltable([16,8,128], n161, t161)
  call heltable([8,16,128], n162, t162)
  call heltable([8,16,128], n163, t163)
  call heltable([16,8,128], n164, t164)
  call heltable([8,16,128], n165, t165)
  call heltable([8,16,128], n166, t166)
  call heltable([8,16,128], n167, t167)
  call heltable([8,16,128], n168, t168)
  call heltable([8,16,128], n169, t169)
  call heltable([8,16,128], n170, t170)
  call heltable([8,16,128], n171, t171)
  call heltable([8,16,128], n172, t172)
  call heltable([8,16,128], n173, t173)
  call heltable([8,16,128], n174, t174)
  call heltable([8,16,128], n175, t175)
  call heltable([8,16,128], n176, t176)
  call heltable([8,16,128], n177, t177)
  call heltable([8,16,128], n178, t178)
  call heltable([8,16,128], n179, t179)
  call heltable([8,16,128], n180, t180)
  call heltable([16,8,128], n181, t181)
  call heltable([16,8,128], n182, t182)
  call heltable([16,8,128], n183, t183)
  call heltable([16,8,128], n184, t184)
  call heltable([16,8,128], n185, t185)
  call heltable([16,8,128], n186, t186)
  call heltable([16,8,128], n187, t187)
  call heltable([16,8,128], n188, t188)
  call heltable([16,8,128], n189, t189)
  call heltable([8,16,128], n190, t190)
  call heltable([16,8,128], n191, t191)
  call heltable([16,8,128], n192, t192)
  call heltable([16,8,128], n193, t193)
  call heltable([16,8,128], n194, t194)
  call heltable([8,16,128], n195, t195)
  call heltable([8,16,128], n196, t196)
  call heltable([8,16,128], n197, t197)
  call heltable([16,8,128], n198, t198)
  call heltable([8,16,128], n199, t199)
  call heltable([16,8,128], n200, t200)
  call heltable([16,8,128], n201, t201)
  call heltable([16,8,128], n202, t202)
  call heltable([16,8,128], n203, t203)
  call heltable([8,16,128], n204, t204)
  call heltable([8,16,128], n205, t205)
  call heltable([8,16,128], n206, t206)
  call heltable([8,16,128], n207, t207)
  call heltable([8,16,128], n208, t208)
  call heltable([8,16,128], n209, t209)
  call heltable([8,16,128], n210, t210)
  call heltable([8,16,128], n211, t211)
  call heltable([8,16,128], n212, t212)
  call heltable([8,16,128], n213, t213)
  call heltable([8,16,128], n214, t214)
  call heltable([8,16,128], n215, t215)
  call heltable([8,16,128], n216, t216)
  call heltable([8,16,128], n217, t217)
  call heltable([8,16,128], n218, t218)
  call heltable([8,16,128], n219, t219)
  call heltable([8,16,128], n220, t220)
  call heltable([8,16,128], n221, t221)
  call heltable([8,16,128], n222, t222)
  call heltable([8,16,128], n223, t223)
  call heltable([8,16,128], n224, t224)
  call heltable([8,16,128], n225, t225)
  call heltable([8,16,128], n226, t226)
  call heltable([8,16,128], n227, t227)
  call heltable([8,16,128], n228, t228)
  call heltable([8,16,128], n229, t229)
  call heltable([8,16,128], n230, t230)
  call heltable([8,16,128], n231, t231)
  call heltable([8,16,128], n232, t232)
  call heltable([8,16,128], n233, t233)
  call heltable([8,16,128], n234, t234)
  call heltable([8,16,128], n235, t235)
  call heltable([8,16,128], n236, t236)
  call heltable([8,16,128], n237, t237)
  call heltable([8,16,128], n238, t238)
  call heltable([8,16,128], n239, t239)
  call heltable([8,16,128], n240, t240)
  call heltable([8,16,128], n241, t241)
  call heltable([8,16,128], n242, t242)
  call heltable([8,16,128], n243, t243)
  call heltable([8,16,128], n244, t244)
  call heltable([8,16,128], n245, t245)
  call heltable([8,16,128], n246, t246)
  call heltable([8,16,128], n247, t247)
  call heltable([8,16,128], n248, t248)
  call heltable([8,16,128], n249, t249)
  call heltable([8,16,128], n250, t250)
  call heltable([8,16,128], n251, t251)
  call heltable([8,16,128], n252, t252)
  call heltable([8,16,128], n253, t253)
  call heltable([8,16,128], n254, t254)
  call heltable([8,16,128], n255, t255)
  call heltable([8,16,128], n256, t256)
  call heltable([8,16,128], n257, t257)
  call heltable([8,16,128], n258, t258)
  call heltable([8,16,128], n259, t259)
  call heltable([8,16,128], n260, t260)
  call heltable([8,16,128], n261, t261)
  call heltable([8,16,128], n262, t262)

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_ppllllj_eeexexbbxg_1
