
module ol_tree_ppllllj_nenenexnexddxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(1)
  complex(REALKIND), save :: den(73)

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = CI*eQED**4*gQCD

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

    den(1) = 1 / (Q(5,5) - MZ2)
    den(2) = 1 / (Q(5,10) - MZ2)
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,37))
    den(9) = 1 / (Q(5,42))
    den(12) = 1 / (Q(5,96))
    den(14) = 1 / (Q(5,21))
    den(18) = 1 / (Q(5,26))
    den(23) = 1 / (Q(5,7))
    den(25) = 1 / (Q(5,112) - MZ2)
    den(28) = 1 / (Q(5,13))
    den(34) = 1 / (Q(5,9) - MZ2)
    den(35) = 1 / (Q(5,6) - MZ2)
    den(37) = 1 / (Q(5,41))
    den(41) = 1 / (Q(5,38))
    den(45) = 1 / (Q(5,25))
    den(49) = 1 / (Q(5,22))
    den(56) = 1 / (Q(5,14))
    den(61) = 1 / (Q(5,11))

  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(8) = den(1)*den(3)
    den(10) = den(2)*den(9)
    den(11) = den(8)*den(10)
    den(13) = den(2)*den(12)
    den(15) = den(1)*den(14)
    den(16) = den(13)*den(15)
    den(17) = den(1)*den(12)
    den(19) = den(2)*den(18)
    den(20) = den(17)*den(19)
    den(21) = den(10)*den(15)
    den(22) = den(6)*den(19)
    den(24) = den(1)*den(23)
    den(26) = den(3)*den(25)
    den(27) = den(24)*den(26)
    den(29) = den(1)*den(28)
    den(30) = den(26)*den(29)
    den(31) = den(12)*den(25)
    den(32) = den(24)*den(31)
    den(33) = den(29)*den(31)
    den(36) = den(3)*den(35)
    den(38) = den(34)*den(37)
    den(39) = den(36)*den(38)
    den(40) = den(3)*den(34)
    den(42) = den(35)*den(41)
    den(43) = den(40)*den(42)
    den(44) = den(12)*den(35)
    den(46) = den(34)*den(45)
    den(47) = den(44)*den(46)
    den(48) = den(12)*den(34)
    den(50) = den(35)*den(49)
    den(51) = den(48)*den(50)
    den(52) = den(42)*den(46)
    den(53) = den(38)*den(50)
    den(54) = den(23)*den(35)
    den(55) = den(26)*den(54)
    den(57) = den(35)*den(56)
    den(58) = den(26)*den(57)
    den(59) = den(31)*den(54)
    den(60) = den(31)*den(57)
    den(62) = den(34)*den(61)
    den(63) = den(26)*den(62)
    den(64) = den(28)*den(34)
    den(65) = den(26)*den(64)
    den(66) = den(31)*den(62)
    den(67) = den(31)*den(64)
    den(68) = den(2)*den(61)
    den(69) = den(26)*den(68)
    den(70) = den(2)*den(56)
    den(71) = den(26)*den(70)
    den(72) = den(31)*den(68)
    den(73) = den(31)*den(70)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs) &
    & bind(c,name="ol_f_amp2_ppllllj_nenenexnexddxg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs)
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e nu_e anti-nu_e anti-nu_e down anti-down glue -> 0
! I   = emitter, 0._/**/REALKIND means none (replace wave function I in the current crossing by the momentum MOM)
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllllj_nenenexnexddxg_1, only: external_perm_ppllllj_nenenexnexddxg_1, &
    & external_perm_inv_ppllllj_nenenexnexddxg_1, extcomb_perm_ppllllj_nenenexnexddxg_1, &
    & average_factor_ppllllj_nenenexnexddxg_1
  use ol_external_ppllllj_nenenexnexddxg_1, only: H, hel_not_initialised, hel_init
  use ol_colourmatrix_ppllllj_nenenexnexddxg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllllj_nenenexnexddxg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_ppllllj_nenenexnexddxg_1
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, extcombs_permuted(nextcombs), shift, k, r
  real(REALKIND)    :: P(0:3,7)
  real(REALKIND)    :: extmasses2(7)
  real(REALKIND)    :: M2add(0:30-1)
  complex(REALKIND) :: MOM_LC(4), M1(1), M1helarray(1,128)

  integer(intkind1), save :: ntry = 1
  integer(intkind1)       :: nsync
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
  real(REALKIND),    save :: scalebackfactor, old_scalefactor = 0

  type(wfun) :: & ! ex1(nhel1), ...
    ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! Declarations of wave functions for all possible helicity configurations from which they are built.
  ! type(wfun), dimension(nhel) :: wf1, ...

  type(wfun), dimension(4) :: &
    wf1, wf2, wf3, wf4, wf5, wf6, wf13, wf14, wf33, wf34, wf35, wf36

  type(wfun), dimension(8) :: &
    wf7, wf9, wf10, wf12, wf15, wf17, wf18, wf20, wf23, wf24, wf25, wf26, wf28, wf29, wf31, wf32, wf37, wf39, wf40, wf42, wf43 &
  , wf45, wf46, wf48, wf51, wf52, wf54, wf55, wf57, wf58, wf60, wf61, wf63, wf64, wf66, wf67

  type(wfun), dimension(16) :: &
    wf8, wf11, wf16, wf19, wf21, wf22, wf27, wf30, wf38, wf41, wf44, wf47, wf49, wf50, wf53, wf56, wf59, wf62, wf65, wf68

  type(wfun), dimension(128) :: &
    wf69, wf70, wf71, wf72, wf73, wf74, wf75, wf76, wf77, wf78, wf79, wf80, wf81, wf82, wf83, wf84, wf85, wf86, wf87, wf88, wf89 &
  , wf90, wf91, wf92, wf93, wf94, wf95, wf96


  type(polcont) :: A(128,28)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rZERO2, rZERO2, rZERO2, rZERO2, rZERO2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, external_perm_inv_ppllllj_nenenexnexddxg_1,7)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,7)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  if (I > 0) ReplacePol = external_perm_ppllllj_nenenexnexddxg_1(I)

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllllj_nenenexnexddxg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  ! external WFs
  call wf_Q(P(:,1), rZERO, H1, ex1)
  call wf_Q(P(:,2), rZERO, H2, ex2)
  call wf_A(P(:,3), rZERO, H3, ex3)
  call wf_A(P(:,4), rZERO, H4, ex4)
  call wf_Q(P(:,5), rZERO, H5, ex5)
  call wf_A(P(:,6), rZERO, H6, ex6)
  call wf_V(P(:,7), rZERO, H7, ex7)


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...
    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1, ex3, wf1, n1, t1)
  call vert_QA_Z(gZn,ntry, ex2, ex4, wf2, n2, t2)
  call vert_VQ_A(ntry, ex7, ex5, wf3, n3, t3)
  call prop_W_W(ntry, wf1, Q(:,5), MZ, 1_intkind1, wf4, n4)
  call prop_W_W(ntry, wf2, Q(:,10), MZ, 1_intkind1, wf5, n5)
  call prop_Q_A(ntry, wf3, Q(:,80), ZERO, 0_intkind1, wf6, n6)
  call vert_AZ_Q(gZd,ntry, ex6, wf4, wf7, n7, t7)
  call vert_ZQ_A(gZd,ntry, wf5, wf6, wf8, n8, t8)
  call prop_A_Q(ntry, wf7, Q(:,37), ZERO, 0_intkind1, wf9, n9)
  call vert_AZ_Q(gZd,ntry, ex6, wf5, wf10, n10, t10)
  call vert_ZQ_A(gZd,ntry, wf4, wf6, wf11, n11, t11)
  call prop_A_Q(ntry, wf10, Q(:,42), ZERO, 0_intkind1, wf12, n12)
  call vert_AV_Q(ntry, ex6, ex7, wf13, n13, t13)
  call prop_A_Q(ntry, wf13, Q(:,96), ZERO, 0_intkind1, wf14, n14)
  call vert_ZQ_A(gZd,ntry, wf4, ex5, wf15, n15, t15)
  call vert_AZ_Q(gZd,ntry, wf14, wf5, wf16, n16, t16)
  call prop_Q_A(ntry, wf15, Q(:,21), ZERO, 0_intkind1, wf17, n17)
  call vert_ZQ_A(gZd,ntry, wf5, ex5, wf18, n18, t18)
  call vert_AZ_Q(gZd,ntry, wf14, wf4, wf19, n19, t19)
  call prop_Q_A(ntry, wf18, Q(:,26), ZERO, 0_intkind1, wf20, n20)
  call vert_VQ_A(ntry, ex7, wf17, wf21, n21, t21)
  call vert_VQ_A(ntry, ex7, wf20, wf22, n22, t22)
  call vert_ZQ_A(gZn,ntry, wf4, ex2, wf23, n23, t23)
  call vert_QA_Z(gZd,ntry, wf6, ex6, wf24, n24, t24)
  call prop_Q_A(ntry, wf23, Q(:,7), ZERO, 0_intkind1, wf25, n25)
  call prop_W_W(ntry, wf24, Q(:,112), MZ, 1_intkind1, wf26, n26)
  call vert_QA_Z(gZn,ntry, wf25, ex4, wf27, n27, t27)
  call vert_AZ_Q(gZn,ntry, ex4, wf4, wf28, n28, t28)
  call prop_A_Q(ntry, wf28, Q(:,13), ZERO, 0_intkind1, wf29, n29)
  call vert_QA_Z(gZn,ntry, ex2, wf29, wf30, n30, t30)
  call vert_QA_Z(gZd,ntry, ex5, wf14, wf31, n31, t31)
  call prop_W_W(ntry, wf31, Q(:,112), MZ, 1_intkind1, wf32, n32)
  call vert_QA_Z(gZn,ntry, ex1, ex4, wf33, n33, t33)
  call vert_QA_Z(gZn,ntry, ex2, ex3, wf34, n34, t34)
  call prop_W_W(ntry, wf33, Q(:,9), MZ, 1_intkind1, wf35, n35)
  call prop_W_W(ntry, wf34, Q(:,6), MZ, 1_intkind1, wf36, n36)
  call vert_AZ_Q(gZd,ntry, ex6, wf35, wf37, n37, t37)
  call vert_ZQ_A(gZd,ntry, wf36, wf6, wf38, n38, t38)
  call prop_A_Q(ntry, wf37, Q(:,41), ZERO, 0_intkind1, wf39, n39)
  call vert_AZ_Q(gZd,ntry, ex6, wf36, wf40, n40, t40)
  call vert_ZQ_A(gZd,ntry, wf35, wf6, wf41, n41, t41)
  call prop_A_Q(ntry, wf40, Q(:,38), ZERO, 0_intkind1, wf42, n42)
  call vert_ZQ_A(gZd,ntry, wf35, ex5, wf43, n43, t43)
  call vert_AZ_Q(gZd,ntry, wf14, wf36, wf44, n44, t44)
  call prop_Q_A(ntry, wf43, Q(:,25), ZERO, 0_intkind1, wf45, n45)
  call vert_ZQ_A(gZd,ntry, wf36, ex5, wf46, n46, t46)
  call vert_AZ_Q(gZd,ntry, wf14, wf35, wf47, n47, t47)
  call prop_Q_A(ntry, wf46, Q(:,22), ZERO, 0_intkind1, wf48, n48)
  call vert_VQ_A(ntry, ex7, wf45, wf49, n49, t49)
  call vert_VQ_A(ntry, ex7, wf48, wf50, n50, t50)
  call vert_ZQ_A(gZn,ntry, wf36, ex1, wf51, n51, t51)
  call prop_Q_A(ntry, wf51, Q(:,7), ZERO, 0_intkind1, wf52, n52)
  call vert_QA_Z(gZn,ntry, wf52, ex4, wf53, n53, t53)
  call vert_AZ_Q(gZn,ntry, ex4, wf36, wf54, n54, t54)
  call prop_A_Q(ntry, wf54, Q(:,14), ZERO, 0_intkind1, wf55, n55)
  call vert_QA_Z(gZn,ntry, ex1, wf55, wf56, n56, t56)
  call vert_ZQ_A(gZn,ntry, wf35, ex2, wf57, n57, t57)
  call prop_Q_A(ntry, wf57, Q(:,11), ZERO, 0_intkind1, wf58, n58)
  call vert_QA_Z(gZn,ntry, wf58, ex3, wf59, n59, t59)
  call vert_AZ_Q(gZn,ntry, ex3, wf35, wf60, n60, t60)
  call prop_A_Q(ntry, wf60, Q(:,13), ZERO, 0_intkind1, wf61, n61)
  call vert_QA_Z(gZn,ntry, ex2, wf61, wf62, n62, t62)
  call vert_ZQ_A(gZn,ntry, wf5, ex1, wf63, n63, t63)
  call prop_Q_A(ntry, wf63, Q(:,11), ZERO, 0_intkind1, wf64, n64)
  call vert_QA_Z(gZn,ntry, wf64, ex3, wf65, n65, t65)
  call vert_AZ_Q(gZn,ntry, ex3, wf5, wf66, n66, t66)
  call prop_A_Q(ntry, wf66, Q(:,14), ZERO, 0_intkind1, wf67, n67)
  call vert_QA_Z(gZn,ntry, ex1, wf67, wf68, n68, t68)


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later

    ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf8, wf9, A(:,1), n69, t69, nhel, den(7))
    call cont_QA(nsync, wf11, wf12, A(:,2), n70, t70, nhel, den(11))
    call cont_QA(nsync, wf16, wf17, A(:,3), n71, t71, nhel, den(16))
    call cont_QA(nsync, wf19, wf20, A(:,4), n72, t72, nhel, den(20))
    call cont_QA(nsync, wf12, wf21, A(:,5), n73, t73, nhel, den(21))
    call cont_QA(nsync, wf9, wf22, A(:,6), n74, t74, nhel, den(22))
    call cont_VV(nsync, wf26, wf27, A(:,7), n75, t75, nhel, den(27))
    call cont_VV(nsync, wf26, wf30, A(:,8), n76, t76, nhel, den(30))
    call cont_VV(nsync, wf27, wf32, A(:,9), n77, t77, nhel, den(32))
    call cont_VV(nsync, wf30, wf32, A(:,10), n78, t78, nhel, den(33))
    call cont_QA(nsync, wf38, wf39, A(:,11), n79, t79, nhel, den(39))
    call cont_QA(nsync, wf41, wf42, A(:,12), n80, t80, nhel, den(43))
    call cont_QA(nsync, wf44, wf45, A(:,13), n81, t81, nhel, den(47))
    call cont_QA(nsync, wf47, wf48, A(:,14), n82, t82, nhel, den(51))
    call cont_QA(nsync, wf42, wf49, A(:,15), n83, t83, nhel, den(52))
    call cont_QA(nsync, wf39, wf50, A(:,16), n84, t84, nhel, den(53))
    call cont_VV(nsync, wf26, wf53, A(:,17), n85, t85, nhel, den(55))
    call cont_VV(nsync, wf26, wf56, A(:,18), n86, t86, nhel, den(58))
    call cont_VV(nsync, wf32, wf53, A(:,19), n87, t87, nhel, den(59))
    call cont_VV(nsync, wf32, wf56, A(:,20), n88, t88, nhel, den(60))
    call cont_VV(nsync, wf26, wf59, A(:,21), n89, t89, nhel, den(63))
    call cont_VV(nsync, wf26, wf62, A(:,22), n90, t90, nhel, den(65))
    call cont_VV(nsync, wf32, wf59, A(:,23), n91, t91, nhel, den(66))
    call cont_VV(nsync, wf32, wf62, A(:,24), n92, t92, nhel, den(67))
    call cont_VV(nsync, wf26, wf65, A(:,25), n93, t93, nhel, den(69))
    call cont_VV(nsync, wf26, wf68, A(:,26), n94, t94, nhel, den(71))
    call cont_VV(nsync, wf32, wf65, A(:,27), n95, t95, nhel, den(72))
    call cont_VV(nsync, wf32, wf68, A(:,28), n96, t96, nhel, den(73))


    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if

  end do

  M2 = 0
  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do

  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it doesn't vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint(M1, M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.25_/**/REALKIND * M2

  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllllj_nenenexnexddxg_1

  do k = 0, 30-1
    M2(k) = M2add(extcomb_perm_ppllllj_nenenexnexddxg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*7-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont),     intent(in)  :: A(128,28)
  integer,           intent(in)  :: j
  complex(REALKIND), intent(out) :: M1(1) ! M1helarray(1,128)

  M1(1) = (-A(j,1)%j-A(j,2)%j-A(j,3)%j-A(j,4)%j-A(j,5)%j-A(j,6)%j-A(j,7)%j-A(j,8)%j-A(j,9)%j-A(j,10)%j+A(j,11)%j+A(j,12)%j &
       +A(j,13)%j+A(j,14)%j+A(j,15)%j+A(j,16)%j+A(j,17)%j+A(j,18)%j+A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j+A(j,23)%j+A(j,24)%j &
       -A(j,25)%j-A(j,26)%j-A(j,27)%j-A(j,28)%j)*f(1)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, nextcombs, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_colourmatrix_ppllllj_nenenexnexddxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: nextcombs
  integer,           intent(in)  :: extcombs(nextcombs)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, nextcombs
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint

end subroutine amp2



! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllllj_nenenexnexddxg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:30-1)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ])
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllllj_nenenexnexddxg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllllj_nenenexnexddxg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    30, [ (k, k = 0, 30-1) ])
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllllj_nenenexnexddxg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllllj_nenenexnexddxg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(7)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:30-1)
  integer        :: J, extcombs(7)
  do J = 1, 7
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 7, extcombs)
  do J = 1, 7
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllllj_nenenexnexddxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllllj_nenenexnexddxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllllj_nenenexnexddxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllllj_nenenexnexddxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllllj_nenenexnexddxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c



! Only for compatibility with the old interface
subroutine amp2tree_legacy(p, m2) &
    & bind(c,name="amp2tree_ppllllj_nenenexnexddxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_legacy

subroutine amp2ccone_legacy(p, m2, i, j) &
    & bind(c,name="amp2ccone_ppllllj_nenenexnexddxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_legacy

subroutine amp2ccall_legacy(p, m2) &
    & bind(c,name="amp2ccall_ppllllj_nenenexnexddxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_legacy

subroutine amp2hcone_legacy(p, m2, i, j, mom) &
    & bind(c,name="amp2hcone_ppllllj_nenenexnexddxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_legacy

subroutine amp2hcall_legacy(p, m2, i, mom) &
    & bind(c,name="amp2hcall_ppllllj_nenenexnexddxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_legacy

#endif

end module ol_tree_ppllllj_nenenexnexddxg_1_/**/REALKIND
