
module ol_tree_ppllllj_eexmmxuuxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(3)
  complex(REALKIND), save :: den(100)

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (4*CI*eQED**4*gQCD)/9._/**/REALKIND
    f(2) = (2*CI*eQED**4*gQCD)/3._/**/REALKIND
    f(3) = CI*eQED**4*gQCD

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

    den(1) = 1 / (Q(5,3))
    den(2) = 1 / (Q(5,12))
    den(3) = 1 / (Q(5,80))
    den(5) = 1 / (Q(5,35))
    den(8) = 1 / (Q(5,12) - MZ2)
    den(11) = 1 / (Q(5,3) - MZ2)
    den(16) = 1 / (Q(5,44))
    den(24) = 1 / (Q(5,96))
    den(26) = 1 / (Q(5,19))
    den(35) = 1 / (Q(5,28))
    den(51) = 1 / (Q(5,7))
    den(53) = 1 / (Q(5,112))
    den(56) = 1 / (Q(5,112) - MZ2)
    den(62) = 1 / (Q(5,11))
    den(79) = 1 / (Q(5,13))
    den(86) = 1 / (Q(5,14))

  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(12) = den(5)*den(11)
    den(13) = den(4)*den(12)
    den(14) = den(9)*den(12)
    den(15) = den(1)*den(3)
    den(17) = den(2)*den(16)
    den(18) = den(15)*den(17)
    den(19) = den(8)*den(16)
    den(20) = den(15)*den(19)
    den(21) = den(3)*den(11)
    den(22) = den(17)*den(21)
    den(23) = den(19)*den(21)
    den(25) = den(2)*den(24)
    den(27) = den(1)*den(26)
    den(28) = den(25)*den(27)
    den(29) = den(8)*den(24)
    den(30) = den(27)*den(29)
    den(31) = den(11)*den(26)
    den(32) = den(25)*den(31)
    den(33) = den(29)*den(31)
    den(34) = den(1)*den(24)
    den(36) = den(2)*den(35)
    den(37) = den(34)*den(36)
    den(38) = den(8)*den(35)
    den(39) = den(34)*den(38)
    den(40) = den(11)*den(24)
    den(41) = den(36)*den(40)
    den(42) = den(38)*den(40)
    den(43) = den(17)*den(27)
    den(44) = den(19)*den(27)
    den(45) = den(17)*den(31)
    den(46) = den(19)*den(31)
    den(47) = den(6)*den(36)
    den(48) = den(6)*den(38)
    den(49) = den(12)*den(36)
    den(50) = den(12)*den(38)
    den(52) = den(1)*den(51)
    den(54) = den(3)*den(53)
    den(55) = den(52)*den(54)
    den(57) = den(3)*den(56)
    den(58) = den(52)*den(57)
    den(59) = den(11)*den(51)
    den(60) = den(54)*den(59)
    den(61) = den(57)*den(59)
    den(63) = den(1)*den(62)
    den(64) = den(54)*den(63)
    den(65) = den(57)*den(63)
    den(66) = den(11)*den(62)
    den(67) = den(54)*den(66)
    den(68) = den(57)*den(66)
    den(69) = den(24)*den(53)
    den(70) = den(52)*den(69)
    den(71) = den(24)*den(56)
    den(72) = den(52)*den(71)
    den(73) = den(59)*den(69)
    den(74) = den(59)*den(71)
    den(75) = den(63)*den(69)
    den(76) = den(63)*den(71)
    den(77) = den(66)*den(69)
    den(78) = den(66)*den(71)
    den(80) = den(2)*den(79)
    den(81) = den(54)*den(80)
    den(82) = den(57)*den(80)
    den(83) = den(8)*den(79)
    den(84) = den(54)*den(83)
    den(85) = den(57)*den(83)
    den(87) = den(2)*den(86)
    den(88) = den(54)*den(87)
    den(89) = den(8)*den(86)
    den(90) = den(54)*den(89)
    den(91) = den(57)*den(87)
    den(92) = den(57)*den(89)
    den(93) = den(69)*den(80)
    den(94) = den(71)*den(80)
    den(95) = den(69)*den(83)
    den(96) = den(71)*den(83)
    den(97) = den(69)*den(87)
    den(98) = den(69)*den(89)
    den(99) = den(71)*den(87)
    den(100) = den(71)*den(89)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs) &
    & bind(c,name="ol_f_amp2_ppllllj_eexmmxuuxg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs)
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ mu- mu+ up anti-up glue -> 0
! I   = emitter, 0._/**/REALKIND means none (replace wave function I in the current crossing by the momentum MOM)
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllllj_eexmmxuuxg_1, only: external_perm_ppllllj_eexmmxuuxg_1, &
    & external_perm_inv_ppllllj_eexmmxuuxg_1, extcomb_perm_ppllllj_eexmmxuuxg_1, &
    & average_factor_ppllllj_eexmmxuuxg_1
  use ol_external_ppllllj_eexmmxuuxg_1, only: H, hel_not_initialised, hel_init
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_ppllllj_eexmmxuuxg_1
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, extcombs_permuted(nextcombs), shift, k, r
  real(REALKIND)    :: P(0:3,7)
  real(REALKIND)    :: extmasses2(7)
  real(REALKIND)    :: M2add(0:30-1)
  complex(REALKIND) :: MOM_LC(4), M1(1), M1helarray(1,128)

  integer(intkind1), save :: ntry = 1
  integer(intkind1)       :: nsync
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
  real(REALKIND),    save :: scalebackfactor, old_scalefactor = 0

  type(wfun) :: & ! ex1(nhel1), ...
    ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! Declarations of wave functions for all possible helicity configurations from which they are built.
  ! type(wfun), dimension(nhel) :: wf1, ...

  type(wfun), dimension(4) :: &
    wf1, wf2, wf3, wf4, wf8, wf9, wf11, wf12, wf21, wf22

  type(wfun), dimension(8) :: &
    wf5, wf7, wf13, wf14, wf15, wf17, wf18, wf19, wf23, wf25, wf27, wf28, wf29, wf31, wf32, wf33, wf39, wf40, wf41, wf43, wf44 &
  , wf46, wf47, wf50, wf51, wf54, wf55, wf58, wf59, wf60, wf61, wf62, wf65, wf66, wf69, wf70, wf72, wf73

  type(wfun), dimension(16) :: &
    wf6, wf10, wf16, wf20, wf24, wf26, wf30, wf34, wf35, wf36, wf37, wf38, wf42, wf45, wf48, wf49, wf52, wf53, wf56, wf57, wf63 &
  , wf64, wf67, wf68, wf71, wf74, wf75, wf76

  type(wfun), dimension(128) :: &
    wf77, wf78, wf79, wf80, wf81, wf82, wf83, wf84, wf85, wf86, wf87, wf88, wf89, wf90, wf91, wf92, wf93, wf94, wf95, wf96, wf97 &
  , wf98, wf99, wf100, wf101, wf102, wf103, wf104, wf105, wf106, wf107, wf108, wf109, wf110, wf111, wf112, wf113, wf114, wf115 &
  , wf116, wf117, wf118, wf119, wf120, wf121, wf122, wf123, wf124, wf125, wf126, wf127, wf128, wf129, wf130, wf131, wf132


  type(polcont) :: A(128,56)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rZERO2, rZERO2, rZERO2, rZERO2, rZERO2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, external_perm_inv_ppllllj_eexmmxuuxg_1,7)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,7)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  if (I > 0) ReplacePol = external_perm_ppllllj_eexmmxuuxg_1(I)

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllllj_eexmmxuuxg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  ! external WFs
  call wf_Q(P(:,1), rZERO, H1, ex1)
  call wf_A(P(:,2), rZERO, H2, ex2)
  call wf_Q(P(:,3), rZERO, H3, ex3)
  call wf_A(P(:,4), rZERO, H4, ex4)
  call wf_Q(P(:,5), rZERO, H5, ex5)
  call wf_A(P(:,6), rZERO, H6, ex6)
  call wf_V(P(:,7), rZERO, H7, ex7)


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...
    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex2, wf1, n1, t1)
  call vert_QA_V(ntry, ex3, ex4, wf2, n2, t2)
  call vert_VQ_A(ntry, ex7, ex5, wf3, n3, t3)
  call prop_Q_A(ntry, wf3, Q(:,80), ZERO, 0_intkind1, wf4, n4)
  call vert_AV_Q(ntry, ex6, wf1, wf5, n5, t5)
  call vert_VQ_A(ntry, wf2, wf4, wf6, n6, t6)
  call prop_A_Q(ntry, wf5, Q(:,35), ZERO, 0_intkind1, wf7, n7)
  call vert_QA_Z(gZl,ntry, ex3, ex4, wf8, n8, t8)
  call prop_W_W(ntry, wf8, Q(:,12), MZ, 1_intkind1, wf9, n9)
  call vert_ZQ_A(gZu,ntry, wf9, wf4, wf10, n10, t10)
  call vert_QA_Z(gZl,ntry, ex1, ex2, wf11, n11, t11)
  call prop_W_W(ntry, wf11, Q(:,3), MZ, 1_intkind1, wf12, n12)
  call vert_AZ_Q(gZu,ntry, ex6, wf12, wf13, n13, t13)
  call prop_A_Q(ntry, wf13, Q(:,35), ZERO, 0_intkind1, wf14, n14)
  call vert_AV_Q(ntry, ex6, wf2, wf15, n15, t15)
  call vert_VQ_A(ntry, wf1, wf4, wf16, n16, t16)
  call prop_A_Q(ntry, wf15, Q(:,44), ZERO, 0_intkind1, wf17, n17)
  call vert_AZ_Q(gZu,ntry, ex6, wf9, wf18, n18, t18)
  call prop_A_Q(ntry, wf18, Q(:,44), ZERO, 0_intkind1, wf19, n19)
  call vert_ZQ_A(gZu,ntry, wf12, wf4, wf20, n20, t20)
  call vert_AV_Q(ntry, ex6, ex7, wf21, n21, t21)
  call prop_A_Q(ntry, wf21, Q(:,96), ZERO, 0_intkind1, wf22, n22)
  call vert_VQ_A(ntry, wf1, ex5, wf23, n23, t23)
  call vert_AV_Q(ntry, wf22, wf2, wf24, n24, t24)
  call prop_Q_A(ntry, wf23, Q(:,19), ZERO, 0_intkind1, wf25, n25)
  call vert_AZ_Q(gZu,ntry, wf22, wf9, wf26, n26, t26)
  call vert_ZQ_A(gZu,ntry, wf12, ex5, wf27, n27, t27)
  call prop_Q_A(ntry, wf27, Q(:,19), ZERO, 0_intkind1, wf28, n28)
  call vert_VQ_A(ntry, wf2, ex5, wf29, n29, t29)
  call vert_AV_Q(ntry, wf22, wf1, wf30, n30, t30)
  call prop_Q_A(ntry, wf29, Q(:,28), ZERO, 0_intkind1, wf31, n31)
  call vert_ZQ_A(gZu,ntry, wf9, ex5, wf32, n32, t32)
  call prop_Q_A(ntry, wf32, Q(:,28), ZERO, 0_intkind1, wf33, n33)
  call vert_AZ_Q(gZu,ntry, wf22, wf12, wf34, n34, t34)
  call vert_VQ_A(ntry, ex7, wf25, wf35, n35, t35)
  call vert_VQ_A(ntry, ex7, wf28, wf36, n36, t36)
  call vert_VQ_A(ntry, ex7, wf31, wf37, n37, t37)
  call vert_VQ_A(ntry, ex7, wf33, wf38, n38, t38)
  call vert_VQ_A(ntry, wf1, ex3, wf39, n39, t39)
  call vert_QA_V(ntry, wf4, ex6, wf40, n40, t40)
  call prop_Q_A(ntry, wf39, Q(:,7), ZERO, 0_intkind1, wf41, n41)
  call vert_QA_V(ntry, wf41, ex4, wf42, n42, t42)
  call vert_QA_Z(gZu,ntry, wf4, ex6, wf43, n43, t43)
  call prop_W_W(ntry, wf43, Q(:,112), MZ, 1_intkind1, wf44, n44)
  call vert_QA_Z(gZl,ntry, wf41, ex4, wf45, n45, t45)
  call vert_ZQ_A(gZl,ntry, wf12, ex3, wf46, n46, t46)
  call prop_Q_A(ntry, wf46, Q(:,7), ZERO, 0_intkind1, wf47, n47)
  call vert_QA_V(ntry, wf47, ex4, wf48, n48, t48)
  call vert_QA_Z(gZl,ntry, wf47, ex4, wf49, n49, t49)
  call vert_AV_Q(ntry, ex4, wf1, wf50, n50, t50)
  call prop_A_Q(ntry, wf50, Q(:,11), ZERO, 0_intkind1, wf51, n51)
  call vert_QA_V(ntry, ex3, wf51, wf52, n52, t52)
  call vert_QA_Z(gZl,ntry, ex3, wf51, wf53, n53, t53)
  call vert_AZ_Q(gZl,ntry, ex4, wf12, wf54, n54, t54)
  call prop_A_Q(ntry, wf54, Q(:,11), ZERO, 0_intkind1, wf55, n55)
  call vert_QA_V(ntry, ex3, wf55, wf56, n56, t56)
  call vert_QA_Z(gZl,ntry, ex3, wf55, wf57, n57, t57)
  call vert_QA_V(ntry, ex5, wf22, wf58, n58, t58)
  call vert_QA_Z(gZu,ntry, ex5, wf22, wf59, n59, t59)
  call prop_W_W(ntry, wf59, Q(:,112), MZ, 1_intkind1, wf60, n60)
  call vert_VQ_A(ntry, wf2, ex1, wf61, n61, t61)
  call prop_Q_A(ntry, wf61, Q(:,13), ZERO, 0_intkind1, wf62, n62)
  call vert_QA_V(ntry, wf62, ex2, wf63, n63, t63)
  call vert_QA_Z(gZl,ntry, wf62, ex2, wf64, n64, t64)
  call vert_ZQ_A(gZl,ntry, wf9, ex1, wf65, n65, t65)
  call prop_Q_A(ntry, wf65, Q(:,13), ZERO, 0_intkind1, wf66, n66)
  call vert_QA_V(ntry, wf66, ex2, wf67, n67, t67)
  call vert_QA_Z(gZl,ntry, wf66, ex2, wf68, n68, t68)
  call vert_AV_Q(ntry, ex2, wf2, wf69, n69, t69)
  call prop_A_Q(ntry, wf69, Q(:,14), ZERO, 0_intkind1, wf70, n70)
  call vert_QA_V(ntry, ex1, wf70, wf71, n71, t71)
  call vert_AZ_Q(gZl,ntry, ex2, wf9, wf72, n72, t72)
  call prop_A_Q(ntry, wf72, Q(:,14), ZERO, 0_intkind1, wf73, n73)
  call vert_QA_V(ntry, ex1, wf73, wf74, n74, t74)
  call vert_QA_Z(gZl,ntry, ex1, wf70, wf75, n75, t75)
  call vert_QA_Z(gZl,ntry, ex1, wf73, wf76, n76, t76)


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later

    ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf6, wf7, A(:,1), n77, t77, nhel, den(7))
    call cont_QA(nsync, wf7, wf10, A(:,2), n78, t78, nhel, den(10))
    call cont_QA(nsync, wf6, wf14, A(:,3), n79, t79, nhel, den(13))
    call cont_QA(nsync, wf10, wf14, A(:,4), n80, t80, nhel, den(14))
    call cont_QA(nsync, wf16, wf17, A(:,5), n81, t81, nhel, den(18))
    call cont_QA(nsync, wf16, wf19, A(:,6), n82, t82, nhel, den(20))
    call cont_QA(nsync, wf17, wf20, A(:,7), n83, t83, nhel, den(22))
    call cont_QA(nsync, wf19, wf20, A(:,8), n84, t84, nhel, den(23))
    call cont_QA(nsync, wf24, wf25, A(:,9), n85, t85, nhel, den(28))
    call cont_QA(nsync, wf25, wf26, A(:,10), n86, t86, nhel, den(30))
    call cont_QA(nsync, wf24, wf28, A(:,11), n87, t87, nhel, den(32))
    call cont_QA(nsync, wf26, wf28, A(:,12), n88, t88, nhel, den(33))
    call cont_QA(nsync, wf30, wf31, A(:,13), n89, t89, nhel, den(37))
    call cont_QA(nsync, wf30, wf33, A(:,14), n90, t90, nhel, den(39))
    call cont_QA(nsync, wf31, wf34, A(:,15), n91, t91, nhel, den(41))
    call cont_QA(nsync, wf33, wf34, A(:,16), n92, t92, nhel, den(42))
    call cont_QA(nsync, wf17, wf35, A(:,17), n93, t93, nhel, den(43))
    call cont_QA(nsync, wf19, wf35, A(:,18), n94, t94, nhel, den(44))
    call cont_QA(nsync, wf17, wf36, A(:,19), n95, t95, nhel, den(45))
    call cont_QA(nsync, wf19, wf36, A(:,20), n96, t96, nhel, den(46))
    call cont_QA(nsync, wf7, wf37, A(:,21), n97, t97, nhel, den(47))
    call cont_QA(nsync, wf7, wf38, A(:,22), n98, t98, nhel, den(48))
    call cont_QA(nsync, wf14, wf37, A(:,23), n99, t99, nhel, den(49))
    call cont_QA(nsync, wf14, wf38, A(:,24), n100, t100, nhel, den(50))
    call cont_VV(nsync, wf40, wf42, A(:,25), n101, t101, nhel, den(55))
    call cont_VV(nsync, wf44, wf45, A(:,26), n102, t102, nhel, den(58))
    call cont_VV(nsync, wf40, wf48, A(:,27), n103, t103, nhel, den(60))
    call cont_VV(nsync, wf44, wf49, A(:,28), n104, t104, nhel, den(61))
    call cont_VV(nsync, wf40, wf52, A(:,29), n105, t105, nhel, den(64))
    call cont_VV(nsync, wf44, wf53, A(:,30), n106, t106, nhel, den(65))
    call cont_VV(nsync, wf40, wf56, A(:,31), n107, t107, nhel, den(67))
    call cont_VV(nsync, wf44, wf57, A(:,32), n108, t108, nhel, den(68))
    call cont_VV(nsync, wf42, wf58, A(:,33), n109, t109, nhel, den(70))
    call cont_VV(nsync, wf45, wf60, A(:,34), n110, t110, nhel, den(72))
    call cont_VV(nsync, wf48, wf58, A(:,35), n111, t111, nhel, den(73))
    call cont_VV(nsync, wf49, wf60, A(:,36), n112, t112, nhel, den(74))
    call cont_VV(nsync, wf52, wf58, A(:,37), n113, t113, nhel, den(75))
    call cont_VV(nsync, wf53, wf60, A(:,38), n114, t114, nhel, den(76))
    call cont_VV(nsync, wf56, wf58, A(:,39), n115, t115, nhel, den(77))
    call cont_VV(nsync, wf57, wf60, A(:,40), n116, t116, nhel, den(78))
    call cont_VV(nsync, wf40, wf63, A(:,41), n117, t117, nhel, den(81))
    call cont_VV(nsync, wf44, wf64, A(:,42), n118, t118, nhel, den(82))
    call cont_VV(nsync, wf40, wf67, A(:,43), n119, t119, nhel, den(84))
    call cont_VV(nsync, wf44, wf68, A(:,44), n120, t120, nhel, den(85))
    call cont_VV(nsync, wf40, wf71, A(:,45), n121, t121, nhel, den(88))
    call cont_VV(nsync, wf40, wf74, A(:,46), n122, t122, nhel, den(90))
    call cont_VV(nsync, wf44, wf75, A(:,47), n123, t123, nhel, den(91))
    call cont_VV(nsync, wf44, wf76, A(:,48), n124, t124, nhel, den(92))
    call cont_VV(nsync, wf58, wf63, A(:,49), n125, t125, nhel, den(93))
    call cont_VV(nsync, wf60, wf64, A(:,50), n126, t126, nhel, den(94))
    call cont_VV(nsync, wf58, wf67, A(:,51), n127, t127, nhel, den(95))
    call cont_VV(nsync, wf60, wf68, A(:,52), n128, t128, nhel, den(96))
    call cont_VV(nsync, wf58, wf71, A(:,53), n129, t129, nhel, den(97))
    call cont_VV(nsync, wf58, wf74, A(:,54), n130, t130, nhel, den(98))
    call cont_VV(nsync, wf60, wf75, A(:,55), n131, t131, nhel, den(99))
    call cont_VV(nsync, wf60, wf76, A(:,56), n132, t132, nhel, den(100))


    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if

  end do

  M2 = 0
  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do

  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it doesn't vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint(M1, M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.25_/**/REALKIND * M2

  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllllj_eexmmxuuxg_1

  do k = 0, 30-1
    M2(k) = M2add(extcomb_perm_ppllllj_eexmmxuuxg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*7-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont),     intent(in)  :: A(128,56)
  integer,           intent(in)  :: j
  complex(REALKIND), intent(out) :: M1(1) ! M1helarray(1,128)

  M1(1) = (A(j,1)%j+A(j,5)%j+A(j,9)%j+A(j,13)%j+A(j,17)%j+A(j,21)%j)*f(1)+(-A(j,2)%j-A(j,3)%j-A(j,6)%j-A(j,7)%j-A(j,10)%j &
       -A(j,11)%j-A(j,14)%j-A(j,15)%j-A(j,18)%j-A(j,19)%j-A(j,22)%j-A(j,23)%j-A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j &
       -A(j,35)%j-A(j,37)%j-A(j,39)%j-A(j,41)%j-A(j,43)%j-A(j,45)%j-A(j,46)%j-A(j,49)%j-A(j,51)%j-A(j,53)%j-A(j,54)%j)*f(2) &
       +(A(j,4)%j+A(j,8)%j+A(j,12)%j+A(j,16)%j+A(j,20)%j+A(j,24)%j+A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,34)%j+A(j,36)%j &
       +A(j,38)%j+A(j,40)%j+A(j,42)%j+A(j,44)%j+A(j,47)%j+A(j,48)%j+A(j,50)%j+A(j,52)%j+A(j,55)%j+A(j,56)%j)*f(3)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, nextcombs, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_colourmatrix_ppllllj_eexmmxuuxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: nextcombs
  integer,           intent(in)  :: extcombs(nextcombs)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, nextcombs
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint

end subroutine amp2



! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllllj_eexmmxuuxg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:30-1)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ])
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllllj_eexmmxuuxg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllllj_eexmmxuuxg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    30, [ (k, k = 0, 30-1) ])
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllllj_eexmmxuuxg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllllj_eexmmxuuxg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(7)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:30-1)
  integer        :: J, extcombs(7)
  do J = 1, 7
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 7, extcombs)
  do J = 1, 7
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllllj_eexmmxuuxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllllj_eexmmxuuxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllllj_eexmmxuuxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllllj_eexmmxuuxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllllj_eexmmxuuxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c



! Only for compatibility with the old interface
subroutine amp2tree_legacy(p, m2) &
    & bind(c,name="amp2tree_ppllllj_eexmmxuuxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_legacy

subroutine amp2ccone_legacy(p, m2, i, j) &
    & bind(c,name="amp2ccone_ppllllj_eexmmxuuxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_legacy

subroutine amp2ccall_legacy(p, m2) &
    & bind(c,name="amp2ccall_ppllllj_eexmmxuuxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_legacy

subroutine amp2hcone_legacy(p, m2, i, j, mom) &
    & bind(c,name="amp2hcone_ppllllj_eexmmxuuxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_legacy

subroutine amp2hcall_legacy(p, m2, i, mom) &
    & bind(c,name="amp2hcall_ppllllj_eexmmxuuxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_legacy

#endif

end module ol_tree_ppllllj_eexmmxuuxg_1_/**/REALKIND
