
module ol_tree_ppllllj_eeexexbbxg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(4)
  complex(REALKIND), save :: den(197)

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = (CI*eQED**4*gQCD)/9._/**/REALKIND
    f(2) = (CI*eQED**4*gQCD)/3._/**/REALKIND
    f(3) = CI*eQED**4*gQCD
    f(4) = (CI*eQED**4*gQCD*MB)/(2._/**/REALKIND*cw**2*sw**2)

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

    den(1) = 1 / (Q(5,5))
    den(2) = 1 / (Q(5,10))
    den(3) = 1 / (Q(5,80) - MB2)
    den(5) = 1 / (Q(5,37) - MB2)
    den(8) = 1 / (Q(5,10) - MZ2)
    den(11) = 1 / (Q(5,5) - MZ2)
    den(16) = 1 / (Q(5,42) - MB2)
    den(25) = 1 / (Q(5,112) - MH2)
    den(28) = 1 / (Q(5,96) - MB2)
    den(30) = 1 / (Q(5,21) - MB2)
    den(39) = 1 / (Q(5,26) - MB2)
    den(57) = 1 / (Q(5,7))
    den(59) = 1 / (Q(5,112))
    den(62) = 1 / (Q(5,112) - MZ2)
    den(68) = 1 / (Q(5,13))
    den(85) = 1 / (Q(5,9))
    den(86) = 1 / (Q(5,6))
    den(88) = 1 / (Q(5,41) - MB2)
    den(91) = 1 / (Q(5,6) - MZ2)
    den(94) = 1 / (Q(5,9) - MZ2)
    den(99) = 1 / (Q(5,38) - MB2)
    den(110) = 1 / (Q(5,25) - MB2)
    den(119) = 1 / (Q(5,22) - MB2)
    den(142) = 1 / (Q(5,14))
    den(157) = 1 / (Q(5,11))

  ! denominators

    den(4) = den(2)*den(3)
    den(6) = den(1)*den(5)
    den(7) = den(4)*den(6)
    den(9) = den(3)*den(8)
    den(10) = den(6)*den(9)
    den(12) = den(5)*den(11)
    den(13) = den(4)*den(12)
    den(14) = den(9)*den(12)
    den(15) = den(1)*den(3)
    den(17) = den(2)*den(16)
    den(18) = den(15)*den(17)
    den(19) = den(8)*den(16)
    den(20) = den(15)*den(19)
    den(21) = den(3)*den(11)
    den(22) = den(17)*den(21)
    den(23) = den(19)*den(21)
    den(24) = den(8)*den(11)
    den(26) = den(3)*den(25)
    den(27) = den(24)*den(26)
    den(29) = den(2)*den(28)
    den(31) = den(1)*den(30)
    den(32) = den(29)*den(31)
    den(33) = den(8)*den(28)
    den(34) = den(31)*den(33)
    den(35) = den(11)*den(30)
    den(36) = den(29)*den(35)
    den(37) = den(33)*den(35)
    den(38) = den(1)*den(28)
    den(40) = den(2)*den(39)
    den(41) = den(38)*den(40)
    den(42) = den(8)*den(39)
    den(43) = den(38)*den(42)
    den(44) = den(11)*den(28)
    den(45) = den(40)*den(44)
    den(46) = den(42)*den(44)
    den(47) = den(25)*den(28)
    den(48) = den(24)*den(47)
    den(49) = den(17)*den(31)
    den(50) = den(19)*den(31)
    den(51) = den(17)*den(35)
    den(52) = den(19)*den(35)
    den(53) = den(6)*den(40)
    den(54) = den(6)*den(42)
    den(55) = den(12)*den(40)
    den(56) = den(12)*den(42)
    den(58) = den(1)*den(57)
    den(60) = den(3)*den(59)
    den(61) = den(58)*den(60)
    den(63) = den(3)*den(62)
    den(64) = den(58)*den(63)
    den(65) = den(11)*den(57)
    den(66) = den(60)*den(65)
    den(67) = den(63)*den(65)
    den(69) = den(1)*den(68)
    den(70) = den(60)*den(69)
    den(71) = den(63)*den(69)
    den(72) = den(11)*den(68)
    den(73) = den(60)*den(72)
    den(74) = den(63)*den(72)
    den(75) = den(28)*den(59)
    den(76) = den(58)*den(75)
    den(77) = den(28)*den(62)
    den(78) = den(58)*den(77)
    den(79) = den(65)*den(75)
    den(80) = den(65)*den(77)
    den(81) = den(69)*den(75)
    den(82) = den(69)*den(77)
    den(83) = den(72)*den(75)
    den(84) = den(72)*den(77)
    den(87) = den(3)*den(86)
    den(89) = den(85)*den(88)
    den(90) = den(87)*den(89)
    den(92) = den(3)*den(91)
    den(93) = den(89)*den(92)
    den(95) = den(88)*den(94)
    den(96) = den(87)*den(95)
    den(97) = den(92)*den(95)
    den(98) = den(3)*den(85)
    den(100) = den(86)*den(99)
    den(101) = den(98)*den(100)
    den(102) = den(91)*den(99)
    den(103) = den(98)*den(102)
    den(104) = den(3)*den(94)
    den(105) = den(100)*den(104)
    den(106) = den(102)*den(104)
    den(107) = den(91)*den(94)
    den(108) = den(26)*den(107)
    den(109) = den(28)*den(86)
    den(111) = den(85)*den(110)
    den(112) = den(109)*den(111)
    den(113) = den(28)*den(91)
    den(114) = den(111)*den(113)
    den(115) = den(94)*den(110)
    den(116) = den(109)*den(115)
    den(117) = den(113)*den(115)
    den(118) = den(28)*den(85)
    den(120) = den(86)*den(119)
    den(121) = den(118)*den(120)
    den(122) = den(91)*den(119)
    den(123) = den(118)*den(122)
    den(124) = den(28)*den(94)
    den(125) = den(120)*den(124)
    den(126) = den(122)*den(124)
    den(127) = den(47)*den(107)
    den(128) = den(100)*den(111)
    den(129) = den(102)*den(111)
    den(130) = den(100)*den(115)
    den(131) = den(102)*den(115)
    den(132) = den(89)*den(120)
    den(133) = den(89)*den(122)
    den(134) = den(95)*den(120)
    den(135) = den(95)*den(122)
    den(136) = den(57)*den(86)
    den(137) = den(60)*den(136)
    den(138) = den(63)*den(136)
    den(139) = den(57)*den(91)
    den(140) = den(60)*den(139)
    den(141) = den(63)*den(139)
    den(143) = den(86)*den(142)
    den(144) = den(60)*den(143)
    den(145) = den(91)*den(142)
    den(146) = den(60)*den(145)
    den(147) = den(63)*den(143)
    den(148) = den(63)*den(145)
    den(149) = den(75)*den(136)
    den(150) = den(77)*den(136)
    den(151) = den(75)*den(139)
    den(152) = den(77)*den(139)
    den(153) = den(75)*den(143)
    den(154) = den(75)*den(145)
    den(155) = den(77)*den(143)
    den(156) = den(77)*den(145)
    den(158) = den(85)*den(157)
    den(159) = den(60)*den(158)
    den(160) = den(63)*den(158)
    den(161) = den(94)*den(157)
    den(162) = den(60)*den(161)
    den(163) = den(63)*den(161)
    den(164) = den(68)*den(85)
    den(165) = den(60)*den(164)
    den(166) = den(63)*den(164)
    den(167) = den(68)*den(94)
    den(168) = den(60)*den(167)
    den(169) = den(63)*den(167)
    den(170) = den(75)*den(158)
    den(171) = den(77)*den(158)
    den(172) = den(75)*den(161)
    den(173) = den(77)*den(161)
    den(174) = den(75)*den(164)
    den(175) = den(77)*den(164)
    den(176) = den(75)*den(167)
    den(177) = den(77)*den(167)
    den(178) = den(2)*den(157)
    den(179) = den(60)*den(178)
    den(180) = den(63)*den(178)
    den(181) = den(8)*den(157)
    den(182) = den(60)*den(181)
    den(183) = den(63)*den(181)
    den(184) = den(2)*den(142)
    den(185) = den(60)*den(184)
    den(186) = den(8)*den(142)
    den(187) = den(60)*den(186)
    den(188) = den(63)*den(184)
    den(189) = den(63)*den(186)
    den(190) = den(75)*den(178)
    den(191) = den(77)*den(178)
    den(192) = den(75)*den(181)
    den(193) = den(77)*den(181)
    den(194) = den(75)*den(184)
    den(195) = den(75)*den(186)
    den(196) = den(77)*den(184)
    den(197) = den(77)*den(186)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs) &
    & bind(c,name="ol_f_amp2_ppllllj_eeexexbbxg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs)
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e- e+ e+ bottom anti-bottom glue -> 0
! I   = emitter, 0._/**/REALKIND means none (replace wave function I in the current crossing by the momentum MOM)
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppllllj_eeexexbbxg_1, only: external_perm_ppllllj_eeexexbbxg_1, &
    & external_perm_inv_ppllllj_eeexexbbxg_1, extcomb_perm_ppllllj_eeexexbbxg_1, &
    & average_factor_ppllllj_eeexexbbxg_1
  use ol_external_ppllllj_eeexexbbxg_1, only: H, hel_not_initialised, hel_init
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppllllj_eeexexbbxg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_ppllllj_eeexexbbxg_1
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, extcombs_permuted(nextcombs), shift, k, r
  real(REALKIND)    :: P(0:3,7)
  real(REALKIND)    :: extmasses2(7)
  real(REALKIND)    :: M2add(0:30-1)
  complex(REALKIND) :: MOM_LC(4), M1(1), M1helarray(1,128)

  integer(intkind1), save :: ntry = 1
  integer(intkind1)       :: nsync
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
  real(REALKIND),    save :: scalebackfactor, old_scalefactor = 0

  type(wfun) :: & ! ex1(nhel1), ...
    ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! Declarations of wave functions for all possible helicity configurations from which they are built.
  ! type(wfun), dimension(nhel) :: wf1, ...

  type(wfun), dimension(4) :: &
    wf1, wf2, wf3, wf4, wf8, wf9, wf11, wf12, wf23, wf24, wf64, wf65, wf69, wf70, wf72, wf73

  type(wfun), dimension(8) :: &
    wf5, wf7, wf13, wf14, wf15, wf17, wf18, wf19, wf21, wf25, wf27, wf29, wf30, wf31, wf33, wf34, wf35, wf37, wf42, wf43, wf44 &
  , wf46, wf47, wf49, wf50, wf53, wf54, wf57, wf58, wf61, wf62, wf63, wf66, wf68, wf74, wf75, wf76, wf78, wf79, wf80, wf83, wf85 &
  , wf87, wf88, wf89, wf91, wf92, wf93, wf99, wf100, wf103, wf104, wf107, wf108, wf110, wf111, wf115, wf116, wf119, wf120, wf123 &
  , wf124, wf127, wf128, wf131, wf132, wf135, wf136, wf139, wf140, wf142, wf143

  type(wfun), dimension(16) :: &
    wf6, wf10, wf16, wf20, wf22, wf26, wf28, wf32, wf36, wf38, wf39, wf40, wf41, wf45, wf48, wf51, wf52, wf55, wf56, wf59, wf60 &
  , wf67, wf71, wf77, wf81, wf82, wf84, wf86, wf90, wf94, wf95, wf96, wf97, wf98, wf101, wf102, wf105, wf106, wf109, wf112, wf113 &
  , wf114, wf117, wf118, wf121, wf122, wf125, wf126, wf129, wf130, wf133, wf134, wf137, wf138, wf141, wf144, wf145, wf146

  type(wfun), dimension(128) :: &
    wf147, wf148, wf149, wf150, wf151, wf152, wf153, wf154, wf155, wf156, wf157, wf158, wf159, wf160, wf161, wf162, wf163, wf164 &
  , wf165, wf166, wf167, wf168, wf169, wf170, wf171, wf172, wf173, wf174, wf175, wf176, wf177, wf178, wf179, wf180, wf181, wf182 &
  , wf183, wf184, wf185, wf186, wf187, wf188, wf189, wf190, wf191, wf192, wf193, wf194, wf195, wf196, wf197, wf198, wf199, wf200 &
  , wf201, wf202, wf203, wf204, wf205, wf206, wf207, wf208, wf209, wf210, wf211, wf212, wf213, wf214, wf215, wf216, wf217, wf218 &
  , wf219, wf220, wf221, wf222, wf223, wf224, wf225, wf226, wf227, wf228, wf229, wf230, wf231, wf232, wf233, wf234, wf235, wf236 &
  , wf237, wf238, wf239, wf240, wf241, wf242, wf243, wf244, wf245, wf246, wf247, wf248, wf249, wf250, wf251, wf252, wf253, wf254 &
  , wf255, wf256, wf257, wf258, wf259, wf260, wf261, wf262


  type(polcont) :: A(128,116)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rZERO2, rZERO2, rZERO2, rZERO2, rMB2, rMB2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, external_perm_inv_ppllllj_eeexexbbxg_1,7)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,7)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  if (I > 0) ReplacePol = external_perm_ppllllj_eeexexbbxg_1(I)

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppllllj_eeexexbbxg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  ! external WFs
  call wf_Q(P(:,1), rZERO, H1, ex1)
  call wf_Q(P(:,2), rZERO, H2, ex2)
  call wf_A(P(:,3), rZERO, H3, ex3)
  call wf_A(P(:,4), rZERO, H4, ex4)
  call wf_Q(P(:,5), rMB, H5, ex5)
  call wf_A(P(:,6), rMB, H6, ex6)
  call wf_V(P(:,7), rZERO, H7, ex7)


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...
    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex3, wf1, n1, t1)
  call vert_QA_V(ntry, ex2, ex4, wf2, n2, t2)
  call vert_VQ_A(ntry, ex7, ex5, wf3, n3, t3)
  call prop_Q_A(ntry, wf3, Q(:,80), MB, 1_intkind1, wf4, n4)
  call vert_AV_Q(ntry, ex6, wf1, wf5, n5, t5)
  call vert_VQ_A(ntry, wf2, wf4, wf6, n6, t6)
  call prop_A_Q(ntry, wf5, Q(:,37), MB, 1_intkind1, wf7, n7)
  call vert_QA_Z(gZl,ntry, ex2, ex4, wf8, n8, t8)
  call prop_W_W(ntry, wf8, Q(:,10), MZ, 1_intkind1, wf9, n9)
  call vert_ZQ_A(gZd,ntry, wf9, wf4, wf10, n10, t10)
  call vert_QA_Z(gZl,ntry, ex1, ex3, wf11, n11, t11)
  call prop_W_W(ntry, wf11, Q(:,5), MZ, 1_intkind1, wf12, n12)
  call vert_AZ_Q(gZd,ntry, ex6, wf12, wf13, n13, t13)
  call prop_A_Q(ntry, wf13, Q(:,37), MB, 1_intkind1, wf14, n14)
  call vert_AV_Q(ntry, ex6, wf2, wf15, n15, t15)
  call vert_VQ_A(ntry, wf1, wf4, wf16, n16, t16)
  call prop_A_Q(ntry, wf15, Q(:,42), MB, 1_intkind1, wf17, n17)
  call vert_AZ_Q(gZd,ntry, ex6, wf9, wf18, n18, t18)
  call prop_A_Q(ntry, wf18, Q(:,42), MB, 1_intkind1, wf19, n19)
  call vert_ZQ_A(gZd,ntry, wf12, wf4, wf20, n20, t20)
  call vert_AQ_S(gH,ntry, ex6, wf4, wf21, n21, t21)
  call vert_VV_S(ntry, wf12, wf9, wf22, n22, t22)
  call vert_AV_Q(ntry, ex6, ex7, wf23, n23, t23)
  call prop_A_Q(ntry, wf23, Q(:,96), MB, 1_intkind1, wf24, n24)
  call vert_VQ_A(ntry, wf1, ex5, wf25, n25, t25)
  call vert_AV_Q(ntry, wf24, wf2, wf26, n26, t26)
  call prop_Q_A(ntry, wf25, Q(:,21), MB, 1_intkind1, wf27, n27)
  call vert_AZ_Q(gZd,ntry, wf24, wf9, wf28, n28, t28)
  call vert_ZQ_A(gZd,ntry, wf12, ex5, wf29, n29, t29)
  call prop_Q_A(ntry, wf29, Q(:,21), MB, 1_intkind1, wf30, n30)
  call vert_VQ_A(ntry, wf2, ex5, wf31, n31, t31)
  call vert_AV_Q(ntry, wf24, wf1, wf32, n32, t32)
  call prop_Q_A(ntry, wf31, Q(:,26), MB, 1_intkind1, wf33, n33)
  call vert_ZQ_A(gZd,ntry, wf9, ex5, wf34, n34, t34)
  call prop_Q_A(ntry, wf34, Q(:,26), MB, 1_intkind1, wf35, n35)
  call vert_AZ_Q(gZd,ntry, wf24, wf12, wf36, n36, t36)
  call vert_AQ_S(gH,ntry, wf24, ex5, wf37, n37, t37)
  call vert_VQ_A(ntry, ex7, wf27, wf38, n38, t38)
  call vert_VQ_A(ntry, ex7, wf30, wf39, n39, t39)
  call vert_VQ_A(ntry, ex7, wf33, wf40, n40, t40)
  call vert_VQ_A(ntry, ex7, wf35, wf41, n41, t41)
  call vert_VQ_A(ntry, wf1, ex2, wf42, n42, t42)
  call vert_QA_V(ntry, wf4, ex6, wf43, n43, t43)
  call prop_Q_A(ntry, wf42, Q(:,7), ZERO, 0_intkind1, wf44, n44)
  call vert_QA_V(ntry, wf44, ex4, wf45, n45, t45)
  call vert_QA_Z(gZd,ntry, wf4, ex6, wf46, n46, t46)
  call prop_W_W(ntry, wf46, Q(:,112), MZ, 1_intkind1, wf47, n47)
  call vert_QA_Z(gZl,ntry, wf44, ex4, wf48, n48, t48)
  call vert_ZQ_A(gZl,ntry, wf12, ex2, wf49, n49, t49)
  call prop_Q_A(ntry, wf49, Q(:,7), ZERO, 0_intkind1, wf50, n50)
  call vert_QA_V(ntry, wf50, ex4, wf51, n51, t51)
  call vert_QA_Z(gZl,ntry, wf50, ex4, wf52, n52, t52)
  call vert_AV_Q(ntry, ex4, wf1, wf53, n53, t53)
  call prop_A_Q(ntry, wf53, Q(:,13), ZERO, 0_intkind1, wf54, n54)
  call vert_QA_V(ntry, ex2, wf54, wf55, n55, t55)
  call vert_QA_Z(gZl,ntry, ex2, wf54, wf56, n56, t56)
  call vert_AZ_Q(gZl,ntry, ex4, wf12, wf57, n57, t57)
  call prop_A_Q(ntry, wf57, Q(:,13), ZERO, 0_intkind1, wf58, n58)
  call vert_QA_V(ntry, ex2, wf58, wf59, n59, t59)
  call vert_QA_Z(gZl,ntry, ex2, wf58, wf60, n60, t60)
  call vert_QA_V(ntry, ex5, wf24, wf61, n61, t61)
  call vert_QA_Z(gZd,ntry, ex5, wf24, wf62, n62, t62)
  call prop_W_W(ntry, wf62, Q(:,112), MZ, 1_intkind1, wf63, n63)
  call vert_QA_V(ntry, ex1, ex4, wf64, n64, t64)
  call vert_QA_V(ntry, ex2, ex3, wf65, n65, t65)
  call vert_AV_Q(ntry, ex6, wf64, wf66, n66, t66)
  call vert_VQ_A(ntry, wf65, wf4, wf67, n67, t67)
  call prop_A_Q(ntry, wf66, Q(:,41), MB, 1_intkind1, wf68, n68)
  call vert_QA_Z(gZl,ntry, ex2, ex3, wf69, n69, t69)
  call prop_W_W(ntry, wf69, Q(:,6), MZ, 1_intkind1, wf70, n70)
  call vert_ZQ_A(gZd,ntry, wf70, wf4, wf71, n71, t71)
  call vert_QA_Z(gZl,ntry, ex1, ex4, wf72, n72, t72)
  call prop_W_W(ntry, wf72, Q(:,9), MZ, 1_intkind1, wf73, n73)
  call vert_AZ_Q(gZd,ntry, ex6, wf73, wf74, n74, t74)
  call prop_A_Q(ntry, wf74, Q(:,41), MB, 1_intkind1, wf75, n75)
  call vert_AV_Q(ntry, ex6, wf65, wf76, n76, t76)
  call vert_VQ_A(ntry, wf64, wf4, wf77, n77, t77)
  call prop_A_Q(ntry, wf76, Q(:,38), MB, 1_intkind1, wf78, n78)
  call vert_AZ_Q(gZd,ntry, ex6, wf70, wf79, n79, t79)
  call prop_A_Q(ntry, wf79, Q(:,38), MB, 1_intkind1, wf80, n80)
  call vert_ZQ_A(gZd,ntry, wf73, wf4, wf81, n81, t81)
  call vert_VV_S(ntry, wf70, wf73, wf82, n82, t82)
  call vert_VQ_A(ntry, wf64, ex5, wf83, n83, t83)
  call vert_AV_Q(ntry, wf24, wf65, wf84, n84, t84)
  call prop_Q_A(ntry, wf83, Q(:,25), MB, 1_intkind1, wf85, n85)
  call vert_AZ_Q(gZd,ntry, wf24, wf70, wf86, n86, t86)
  call vert_ZQ_A(gZd,ntry, wf73, ex5, wf87, n87, t87)
  call prop_Q_A(ntry, wf87, Q(:,25), MB, 1_intkind1, wf88, n88)
  call vert_VQ_A(ntry, wf65, ex5, wf89, n89, t89)
  call vert_AV_Q(ntry, wf24, wf64, wf90, n90, t90)
  call prop_Q_A(ntry, wf89, Q(:,22), MB, 1_intkind1, wf91, n91)
  call vert_ZQ_A(gZd,ntry, wf70, ex5, wf92, n92, t92)
  call prop_Q_A(ntry, wf92, Q(:,22), MB, 1_intkind1, wf93, n93)
  call vert_AZ_Q(gZd,ntry, wf24, wf73, wf94, n94, t94)
  call vert_VQ_A(ntry, ex7, wf85, wf95, n95, t95)
  call vert_VQ_A(ntry, ex7, wf88, wf96, n96, t96)
  call vert_VQ_A(ntry, ex7, wf91, wf97, n97, t97)
  call vert_VQ_A(ntry, ex7, wf93, wf98, n98, t98)
  call vert_VQ_A(ntry, wf65, ex1, wf99, n99, t99)
  call prop_Q_A(ntry, wf99, Q(:,7), ZERO, 0_intkind1, wf100, n100)
  call vert_QA_V(ntry, wf100, ex4, wf101, n101, t101)
  call vert_QA_Z(gZl,ntry, wf100, ex4, wf102, n102, t102)
  call vert_ZQ_A(gZl,ntry, wf70, ex1, wf103, n103, t103)
  call prop_Q_A(ntry, wf103, Q(:,7), ZERO, 0_intkind1, wf104, n104)
  call vert_QA_V(ntry, wf104, ex4, wf105, n105, t105)
  call vert_QA_Z(gZl,ntry, wf104, ex4, wf106, n106, t106)
  call vert_AV_Q(ntry, ex4, wf65, wf107, n107, t107)
  call prop_A_Q(ntry, wf107, Q(:,14), ZERO, 0_intkind1, wf108, n108)
  call vert_QA_V(ntry, ex1, wf108, wf109, n109, t109)
  call vert_AZ_Q(gZl,ntry, ex4, wf70, wf110, n110, t110)
  call prop_A_Q(ntry, wf110, Q(:,14), ZERO, 0_intkind1, wf111, n111)
  call vert_QA_V(ntry, ex1, wf111, wf112, n112, t112)
  call vert_QA_Z(gZl,ntry, ex1, wf108, wf113, n113, t113)
  call vert_QA_Z(gZl,ntry, ex1, wf111, wf114, n114, t114)
  call vert_VQ_A(ntry, wf64, ex2, wf115, n115, t115)
  call prop_Q_A(ntry, wf115, Q(:,11), ZERO, 0_intkind1, wf116, n116)
  call vert_QA_V(ntry, wf116, ex3, wf117, n117, t117)
  call vert_QA_Z(gZl,ntry, wf116, ex3, wf118, n118, t118)
  call vert_ZQ_A(gZl,ntry, wf73, ex2, wf119, n119, t119)
  call prop_Q_A(ntry, wf119, Q(:,11), ZERO, 0_intkind1, wf120, n120)
  call vert_QA_V(ntry, wf120, ex3, wf121, n121, t121)
  call vert_QA_Z(gZl,ntry, wf120, ex3, wf122, n122, t122)
  call vert_AV_Q(ntry, ex3, wf64, wf123, n123, t123)
  call prop_A_Q(ntry, wf123, Q(:,13), ZERO, 0_intkind1, wf124, n124)
  call vert_QA_V(ntry, ex2, wf124, wf125, n125, t125)
  call vert_QA_Z(gZl,ntry, ex2, wf124, wf126, n126, t126)
  call vert_AZ_Q(gZl,ntry, ex3, wf73, wf127, n127, t127)
  call prop_A_Q(ntry, wf127, Q(:,13), ZERO, 0_intkind1, wf128, n128)
  call vert_QA_V(ntry, ex2, wf128, wf129, n129, t129)
  call vert_QA_Z(gZl,ntry, ex2, wf128, wf130, n130, t130)
  call vert_VQ_A(ntry, wf2, ex1, wf131, n131, t131)
  call prop_Q_A(ntry, wf131, Q(:,11), ZERO, 0_intkind1, wf132, n132)
  call vert_QA_V(ntry, wf132, ex3, wf133, n133, t133)
  call vert_QA_Z(gZl,ntry, wf132, ex3, wf134, n134, t134)
  call vert_ZQ_A(gZl,ntry, wf9, ex1, wf135, n135, t135)
  call prop_Q_A(ntry, wf135, Q(:,11), ZERO, 0_intkind1, wf136, n136)
  call vert_QA_V(ntry, wf136, ex3, wf137, n137, t137)
  call vert_QA_Z(gZl,ntry, wf136, ex3, wf138, n138, t138)
  call vert_AV_Q(ntry, ex3, wf2, wf139, n139, t139)
  call prop_A_Q(ntry, wf139, Q(:,14), ZERO, 0_intkind1, wf140, n140)
  call vert_QA_V(ntry, ex1, wf140, wf141, n141, t141)
  call vert_AZ_Q(gZl,ntry, ex3, wf9, wf142, n142, t142)
  call prop_A_Q(ntry, wf142, Q(:,14), ZERO, 0_intkind1, wf143, n143)
  call vert_QA_V(ntry, ex1, wf143, wf144, n144, t144)
  call vert_QA_Z(gZl,ntry, ex1, wf140, wf145, n145, t145)
  call vert_QA_Z(gZl,ntry, ex1, wf143, wf146, n146, t146)


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later

    ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_QA(nsync, wf6, wf7, A(:,1), n147, t147, nhel, den(7))
    call cont_QA(nsync, wf7, wf10, A(:,2), n148, t148, nhel, den(10))
    call cont_QA(nsync, wf6, wf14, A(:,3), n149, t149, nhel, den(13))
    call cont_QA(nsync, wf10, wf14, A(:,4), n150, t150, nhel, den(14))
    call cont_QA(nsync, wf16, wf17, A(:,5), n151, t151, nhel, den(18))
    call cont_QA(nsync, wf16, wf19, A(:,6), n152, t152, nhel, den(20))
    call cont_QA(nsync, wf17, wf20, A(:,7), n153, t153, nhel, den(22))
    call cont_QA(nsync, wf19, wf20, A(:,8), n154, t154, nhel, den(23))
    call cont_SS(nsync, wf21, wf22, A(:,9), n155, t155, nhel, den(27))
    call cont_QA(nsync, wf26, wf27, A(:,10), n156, t156, nhel, den(32))
    call cont_QA(nsync, wf27, wf28, A(:,11), n157, t157, nhel, den(34))
    call cont_QA(nsync, wf26, wf30, A(:,12), n158, t158, nhel, den(36))
    call cont_QA(nsync, wf28, wf30, A(:,13), n159, t159, nhel, den(37))
    call cont_QA(nsync, wf32, wf33, A(:,14), n160, t160, nhel, den(41))
    call cont_QA(nsync, wf32, wf35, A(:,15), n161, t161, nhel, den(43))
    call cont_QA(nsync, wf33, wf36, A(:,16), n162, t162, nhel, den(45))
    call cont_QA(nsync, wf35, wf36, A(:,17), n163, t163, nhel, den(46))
    call cont_SS(nsync, wf22, wf37, A(:,18), n164, t164, nhel, den(48))
    call cont_QA(nsync, wf17, wf38, A(:,19), n165, t165, nhel, den(49))
    call cont_QA(nsync, wf19, wf38, A(:,20), n166, t166, nhel, den(50))
    call cont_QA(nsync, wf17, wf39, A(:,21), n167, t167, nhel, den(51))
    call cont_QA(nsync, wf19, wf39, A(:,22), n168, t168, nhel, den(52))
    call cont_QA(nsync, wf7, wf40, A(:,23), n169, t169, nhel, den(53))
    call cont_QA(nsync, wf7, wf41, A(:,24), n170, t170, nhel, den(54))
    call cont_QA(nsync, wf14, wf40, A(:,25), n171, t171, nhel, den(55))
    call cont_QA(nsync, wf14, wf41, A(:,26), n172, t172, nhel, den(56))
    call cont_VV(nsync, wf43, wf45, A(:,27), n173, t173, nhel, den(61))
    call cont_VV(nsync, wf47, wf48, A(:,28), n174, t174, nhel, den(64))
    call cont_VV(nsync, wf43, wf51, A(:,29), n175, t175, nhel, den(66))
    call cont_VV(nsync, wf47, wf52, A(:,30), n176, t176, nhel, den(67))
    call cont_VV(nsync, wf43, wf55, A(:,31), n177, t177, nhel, den(70))
    call cont_VV(nsync, wf47, wf56, A(:,32), n178, t178, nhel, den(71))
    call cont_VV(nsync, wf43, wf59, A(:,33), n179, t179, nhel, den(73))
    call cont_VV(nsync, wf47, wf60, A(:,34), n180, t180, nhel, den(74))
    call cont_VV(nsync, wf45, wf61, A(:,35), n181, t181, nhel, den(76))
    call cont_VV(nsync, wf48, wf63, A(:,36), n182, t182, nhel, den(78))
    call cont_VV(nsync, wf51, wf61, A(:,37), n183, t183, nhel, den(79))
    call cont_VV(nsync, wf52, wf63, A(:,38), n184, t184, nhel, den(80))
    call cont_VV(nsync, wf55, wf61, A(:,39), n185, t185, nhel, den(81))
    call cont_VV(nsync, wf56, wf63, A(:,40), n186, t186, nhel, den(82))
    call cont_VV(nsync, wf59, wf61, A(:,41), n187, t187, nhel, den(83))
    call cont_VV(nsync, wf60, wf63, A(:,42), n188, t188, nhel, den(84))
    call cont_QA(nsync, wf67, wf68, A(:,43), n189, t189, nhel, den(90))
    call cont_QA(nsync, wf68, wf71, A(:,44), n190, t190, nhel, den(93))
    call cont_QA(nsync, wf67, wf75, A(:,45), n191, t191, nhel, den(96))
    call cont_QA(nsync, wf71, wf75, A(:,46), n192, t192, nhel, den(97))
    call cont_QA(nsync, wf77, wf78, A(:,47), n193, t193, nhel, den(101))
    call cont_QA(nsync, wf77, wf80, A(:,48), n194, t194, nhel, den(103))
    call cont_QA(nsync, wf78, wf81, A(:,49), n195, t195, nhel, den(105))
    call cont_QA(nsync, wf80, wf81, A(:,50), n196, t196, nhel, den(106))
    call cont_SS(nsync, wf21, wf82, A(:,51), n197, t197, nhel, den(108))
    call cont_QA(nsync, wf84, wf85, A(:,52), n198, t198, nhel, den(112))
    call cont_QA(nsync, wf85, wf86, A(:,53), n199, t199, nhel, den(114))
    call cont_QA(nsync, wf84, wf88, A(:,54), n200, t200, nhel, den(116))
    call cont_QA(nsync, wf86, wf88, A(:,55), n201, t201, nhel, den(117))
    call cont_QA(nsync, wf90, wf91, A(:,56), n202, t202, nhel, den(121))
    call cont_QA(nsync, wf90, wf93, A(:,57), n203, t203, nhel, den(123))
    call cont_QA(nsync, wf91, wf94, A(:,58), n204, t204, nhel, den(125))
    call cont_QA(nsync, wf93, wf94, A(:,59), n205, t205, nhel, den(126))
    call cont_SS(nsync, wf37, wf82, A(:,60), n206, t206, nhel, den(127))
    call cont_QA(nsync, wf78, wf95, A(:,61), n207, t207, nhel, den(128))
    call cont_QA(nsync, wf80, wf95, A(:,62), n208, t208, nhel, den(129))
    call cont_QA(nsync, wf78, wf96, A(:,63), n209, t209, nhel, den(130))
    call cont_QA(nsync, wf80, wf96, A(:,64), n210, t210, nhel, den(131))
    call cont_QA(nsync, wf68, wf97, A(:,65), n211, t211, nhel, den(132))
    call cont_QA(nsync, wf68, wf98, A(:,66), n212, t212, nhel, den(133))
    call cont_QA(nsync, wf75, wf97, A(:,67), n213, t213, nhel, den(134))
    call cont_QA(nsync, wf75, wf98, A(:,68), n214, t214, nhel, den(135))
    call cont_VV(nsync, wf43, wf101, A(:,69), n215, t215, nhel, den(137))
    call cont_VV(nsync, wf47, wf102, A(:,70), n216, t216, nhel, den(138))
    call cont_VV(nsync, wf43, wf105, A(:,71), n217, t217, nhel, den(140))
    call cont_VV(nsync, wf47, wf106, A(:,72), n218, t218, nhel, den(141))
    call cont_VV(nsync, wf43, wf109, A(:,73), n219, t219, nhel, den(144))
    call cont_VV(nsync, wf43, wf112, A(:,74), n220, t220, nhel, den(146))
    call cont_VV(nsync, wf47, wf113, A(:,75), n221, t221, nhel, den(147))
    call cont_VV(nsync, wf47, wf114, A(:,76), n222, t222, nhel, den(148))
    call cont_VV(nsync, wf61, wf101, A(:,77), n223, t223, nhel, den(149))
    call cont_VV(nsync, wf63, wf102, A(:,78), n224, t224, nhel, den(150))
    call cont_VV(nsync, wf61, wf105, A(:,79), n225, t225, nhel, den(151))
    call cont_VV(nsync, wf63, wf106, A(:,80), n226, t226, nhel, den(152))
    call cont_VV(nsync, wf61, wf109, A(:,81), n227, t227, nhel, den(153))
    call cont_VV(nsync, wf61, wf112, A(:,82), n228, t228, nhel, den(154))
    call cont_VV(nsync, wf63, wf113, A(:,83), n229, t229, nhel, den(155))
    call cont_VV(nsync, wf63, wf114, A(:,84), n230, t230, nhel, den(156))
    call cont_VV(nsync, wf43, wf117, A(:,85), n231, t231, nhel, den(159))
    call cont_VV(nsync, wf47, wf118, A(:,86), n232, t232, nhel, den(160))
    call cont_VV(nsync, wf43, wf121, A(:,87), n233, t233, nhel, den(162))
    call cont_VV(nsync, wf47, wf122, A(:,88), n234, t234, nhel, den(163))
    call cont_VV(nsync, wf43, wf125, A(:,89), n235, t235, nhel, den(165))
    call cont_VV(nsync, wf47, wf126, A(:,90), n236, t236, nhel, den(166))
    call cont_VV(nsync, wf43, wf129, A(:,91), n237, t237, nhel, den(168))
    call cont_VV(nsync, wf47, wf130, A(:,92), n238, t238, nhel, den(169))
    call cont_VV(nsync, wf61, wf117, A(:,93), n239, t239, nhel, den(170))
    call cont_VV(nsync, wf63, wf118, A(:,94), n240, t240, nhel, den(171))
    call cont_VV(nsync, wf61, wf121, A(:,95), n241, t241, nhel, den(172))
    call cont_VV(nsync, wf63, wf122, A(:,96), n242, t242, nhel, den(173))
    call cont_VV(nsync, wf61, wf125, A(:,97), n243, t243, nhel, den(174))
    call cont_VV(nsync, wf63, wf126, A(:,98), n244, t244, nhel, den(175))
    call cont_VV(nsync, wf61, wf129, A(:,99), n245, t245, nhel, den(176))
    call cont_VV(nsync, wf63, wf130, A(:,100), n246, t246, nhel, den(177))
    call cont_VV(nsync, wf43, wf133, A(:,101), n247, t247, nhel, den(179))
    call cont_VV(nsync, wf47, wf134, A(:,102), n248, t248, nhel, den(180))
    call cont_VV(nsync, wf43, wf137, A(:,103), n249, t249, nhel, den(182))
    call cont_VV(nsync, wf47, wf138, A(:,104), n250, t250, nhel, den(183))
    call cont_VV(nsync, wf43, wf141, A(:,105), n251, t251, nhel, den(185))
    call cont_VV(nsync, wf43, wf144, A(:,106), n252, t252, nhel, den(187))
    call cont_VV(nsync, wf47, wf145, A(:,107), n253, t253, nhel, den(188))
    call cont_VV(nsync, wf47, wf146, A(:,108), n254, t254, nhel, den(189))
    call cont_VV(nsync, wf61, wf133, A(:,109), n255, t255, nhel, den(190))
    call cont_VV(nsync, wf63, wf134, A(:,110), n256, t256, nhel, den(191))
    call cont_VV(nsync, wf61, wf137, A(:,111), n257, t257, nhel, den(192))
    call cont_VV(nsync, wf63, wf138, A(:,112), n258, t258, nhel, den(193))
    call cont_VV(nsync, wf61, wf141, A(:,113), n259, t259, nhel, den(194))
    call cont_VV(nsync, wf61, wf144, A(:,114), n260, t260, nhel, den(195))
    call cont_VV(nsync, wf63, wf145, A(:,115), n261, t261, nhel, den(196))
    call cont_VV(nsync, wf63, wf146, A(:,116), n262, t262, nhel, den(197))


    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
    end if

  end do

  M2 = 0
  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do

  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it doesn't vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint(M1, M2add, nextcombs, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.25_/**/REALKIND * M2

  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppllllj_eeexexbbxg_1

  do k = 0, 30-1
    M2(k) = M2add(extcomb_perm_ppllllj_eeexexbbxg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*7-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont),     intent(in)  :: A(128,116)
  integer,           intent(in)  :: j
  complex(REALKIND), intent(out) :: M1(1) ! M1helarray(1,128)

  M1(1) = (-A(j,1)%j-A(j,5)%j-A(j,10)%j-A(j,14)%j-A(j,19)%j-A(j,23)%j+A(j,43)%j+A(j,47)%j+A(j,52)%j+A(j,56)%j+A(j,61)%j &
       +A(j,65)%j)*f(1)+(-A(j,2)%j-A(j,3)%j-A(j,6)%j-A(j,7)%j-A(j,11)%j-A(j,12)%j-A(j,15)%j-A(j,16)%j-A(j,20)%j-A(j,21)%j &
       -A(j,24)%j-A(j,25)%j-A(j,27)%j-A(j,29)%j-A(j,31)%j-A(j,33)%j-A(j,35)%j-A(j,37)%j-A(j,39)%j-A(j,41)%j+A(j,44)%j+A(j,45)%j &
       +A(j,48)%j+A(j,49)%j+A(j,53)%j+A(j,54)%j+A(j,57)%j+A(j,58)%j+A(j,62)%j+A(j,63)%j+A(j,66)%j+A(j,67)%j+A(j,69)%j+A(j,71)%j &
       +A(j,73)%j+A(j,74)%j+A(j,77)%j+A(j,79)%j+A(j,81)%j+A(j,82)%j+A(j,85)%j+A(j,87)%j+A(j,89)%j+A(j,91)%j+A(j,93)%j+A(j,95)%j &
       +A(j,97)%j+A(j,99)%j-A(j,101)%j-A(j,103)%j-A(j,105)%j-A(j,106)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,114)%j)*f(2)+( &
       -A(j,4)%j-A(j,8)%j-A(j,13)%j-A(j,17)%j-A(j,22)%j-A(j,26)%j-A(j,28)%j-A(j,30)%j-A(j,32)%j-A(j,34)%j-A(j,36)%j-A(j,38)%j &
       -A(j,40)%j-A(j,42)%j+A(j,46)%j+A(j,50)%j+A(j,55)%j+A(j,59)%j+A(j,64)%j+A(j,68)%j+A(j,70)%j+A(j,72)%j+A(j,75)%j+A(j,76)%j &
       +A(j,78)%j+A(j,80)%j+A(j,83)%j+A(j,84)%j+A(j,86)%j+A(j,88)%j+A(j,90)%j+A(j,92)%j+A(j,94)%j+A(j,96)%j+A(j,98)%j+A(j,100)%j &
       -A(j,102)%j-A(j,104)%j-A(j,107)%j-A(j,108)%j-A(j,110)%j-A(j,112)%j-A(j,115)%j-A(j,116)%j)*f(3)+(A(j,9)%j+A(j,18)%j &
       -A(j,51)%j-A(j,60)%j)*f(4)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, nextcombs, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_colourmatrix_ppllllj_eeexexbbxg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: nextcombs
  integer,           intent(in)  :: extcombs(nextcombs)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, nextcombs
    extcomb = extcombs(eco)
    colmatpos = 1*extcomb
    do i = 1, 1
      do j = 1, 1
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint

end subroutine amp2



! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppllllj_eeexexbbxg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:30-1)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ])
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppllllj_eeexexbbxg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppllllj_eeexexbbxg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    30, [ (k, k = 0, 30-1) ])
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppllllj_eeexexbbxg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ])
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppllllj_eeexexbbxg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  use KIND_TYPES, only: REALKIND, DREALKIND
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(7)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:30-1)
  integer        :: J, extcombs(7)
  do J = 1, 7
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 7, extcombs)
  do J = 1, 7
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppllllj_eeexexbbxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppllllj_eeexexbbxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppllllj_eeexexbbxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppllllj_eeexexbbxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppllllj_eeexexbbxg_1")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c



! Only for compatibility with the old interface
subroutine amp2tree_legacy(p, m2) &
    & bind(c,name="amp2tree_ppllllj_eeexexbbxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_legacy

subroutine amp2ccone_legacy(p, m2, i, j) &
    & bind(c,name="amp2ccone_ppllllj_eeexexbbxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_legacy

subroutine amp2ccall_legacy(p, m2) &
    & bind(c,name="amp2ccall_ppllllj_eeexexbbxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_legacy

subroutine amp2hcone_legacy(p, m2, i, j, mom) &
    & bind(c,name="amp2hcone_ppllllj_eeexexbbxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_legacy

subroutine amp2hcall_legacy(p, m2, i, mom) &
    & bind(c,name="amp2hcall_ppllllj_eeexexbbxg_1_")
  use KIND_TYPES, only: DREALKIND
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_legacy

#endif

end module ol_tree_ppllllj_eeexexbbxg_1_/**/REALKIND
