
module ol_vamp_7_ppllllj2_eeexexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_7(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eeexexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eeexexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eeexexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eeexexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,7) :: G0
  complex(REALKIND), dimension(4,5,4,42) :: G1
  complex(REALKIND), dimension(4,15,4,108) :: G2
  complex(REALKIND), dimension(4,35,4,180) :: G3
  complex(REALKIND), dimension(4,70,4,108) :: G4
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G4tensorhel(70,72,128))
    allocate(G5tensorhel(126,72,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AZ_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,2),gZu)
  call loop_A_Q(G0(:,:,:,2),Q(:,9),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,73),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,3),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,121),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,47),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,50),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),ZERO,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-4),G2(:,:,:,3))
  call loop_A_Q(G2(:,:,:,3),Q(:,89),ZERO,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,-5),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,121),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,47),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,50),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-5),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,105),ZERO,G3(:,:,:,6))
  call loop_AV_Q(G3(:,:,:,6),wf(:,-4),G3(:,:,:,7))
  call loop_A_Q(G3(:,:,:,7),Q(:,121),ZERO,G4(:,:,:,4))
  call loop_AV_Q(G4(:,:,:,4),wf(:,47),G4(:,:,:,5))
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,50),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,57),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-6),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,121),ZERO,G3(:,:,:,8))
  call loop_AV_Q(G3(:,:,:,8),wf(:,47),G3(:,:,:,9))
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,8),wf(:,50),G3(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,41),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,12),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,121),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,47),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,50),G3(:,:,:,13),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-4),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,57),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,-6),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,121),ZERO,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,47),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,50),G4(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-6),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,105),ZERO,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,-4),G3(:,:,:,17))
  call loop_A_Q(G3(:,:,:,17),Q(:,121),ZERO,G4(:,:,:,10))
  call loop_AV_Q(G4(:,:,:,10),wf(:,47),G4(:,:,:,11))
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,50),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,12),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,89),ZERO,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,121),ZERO,G3(:,:,:,18))
  call loop_AV_Q(G3(:,:,:,18),wf(:,47),G3(:,:,:,19))
  call check_last_A_Q(l_switch,G3(:,:,:,19),Q(:,127),ZERO,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,18),wf(:,50),G3(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),ZERO,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,25),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,17),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,121),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,47),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,50),G3(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-5),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,57),ZERO,G3(:,:,:,24))
  call loop_AV_Q(G3(:,:,:,24),wf(:,-6),G3(:,:,:,25))
  call loop_A_Q(G3(:,:,:,25),Q(:,121),ZERO,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,47),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,50),G4(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,127),ZERO,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-6),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,89),ZERO,G3(:,:,:,26))
  call loop_AV_Q(G3(:,:,:,26),wf(:,-5),G3(:,:,:,27))
  call loop_A_Q(G3(:,:,:,27),Q(:,121),ZERO,G4(:,:,:,16))
  call loop_AV_Q(G4(:,:,:,16),wf(:,47),G4(:,:,:,17))
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),ZERO,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,50),G4(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),ZERO,G5tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,105),ZERO,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,121),ZERO,G3(:,:,:,28))
  call loop_AV_Q(G3(:,:,:,28),wf(:,47),G3(:,:,:,29))
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,28),wf(:,50),G3(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,3),gZu)
  call loop_A_Q(G0(:,:,:,3),Q(:,9),MT,G1(:,:,:,8))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-6),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,73),MT,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,3),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,121),MT,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,47),G3(:,:,:,32))
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),MT,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,50),G3(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),MT,G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-4),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,89),MT,G3(:,:,:,34))
  call loop_AV_Q(G3(:,:,:,34),wf(:,-5),G3(:,:,:,35))
  call loop_A_Q(G3(:,:,:,35),Q(:,121),MT,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,47),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,50),G4(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,21),Q(:,127),MT,G5tensor(:,14))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-5),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,105),MT,G3(:,:,:,36))
  call loop_AV_Q(G3(:,:,:,36),wf(:,-4),G3(:,:,:,37))
  call loop_A_Q(G3(:,:,:,37),Q(:,121),MT,G4(:,:,:,22))
  call loop_AV_Q(G4(:,:,:,22),wf(:,47),G4(:,:,:,23))
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),MT,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,22),wf(:,50),G4(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,8),wf(:,3),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,57),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-6),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,121),MT,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,47),G3(:,:,:,39))
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),MT,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,38),wf(:,50),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),MT,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-5),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,41),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,12),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,121),MT,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,47),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),MT,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,41),wf(:,50),G3(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),MT,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,57),MT,G3(:,:,:,44))
  call loop_AV_Q(G3(:,:,:,44),wf(:,-6),G3(:,:,:,45))
  call loop_A_Q(G3(:,:,:,45),Q(:,121),MT,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,47),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MT,G5tensor(:,17))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,50),G4(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,127),MT,G5tensor(:,18))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-6),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,105),MT,G3(:,:,:,46))
  call loop_AV_Q(G3(:,:,:,46),wf(:,-4),G3(:,:,:,47))
  call loop_A_Q(G3(:,:,:,47),Q(:,121),MT,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,47),G4(:,:,:,29))
  call check_last_A_Q(l_switch,G4(:,:,:,29),Q(:,127),MT,G5tensor(:,19))
  call loop_AZ_Q(G4(:,:,:,28),wf(:,50),G4(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),MT,G5tensor(:,20))
  call loop_AV_Q(G1(:,:,:,8),wf(:,12),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,89),MT,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,121),MT,G3(:,:,:,48))
  call loop_AV_Q(G3(:,:,:,48),wf(:,47),G3(:,:,:,49))
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,127),MT,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,48),wf(:,50),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),MT,G4tensor(:,20))
  call loop_AV_Q(G1(:,:,:,8),wf(:,-4),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,25),MT,G2(:,:,:,31))
  call loop_AV_Q(G2(:,:,:,31),wf(:,17),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,121),MT,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,47),G3(:,:,:,52))
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),MT,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,51),wf(:,50),G3(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,127),MT,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-5),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,57),MT,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-6),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,121),MT,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,47),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),MT,G5tensor(:,21))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,50),G4(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,33),Q(:,127),MT,G5tensor(:,22))
  call loop_AV_Q(G2(:,:,:,31),wf(:,-6),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,89),MT,G3(:,:,:,56))
  call loop_AV_Q(G3(:,:,:,56),wf(:,-5),G3(:,:,:,57))
  call loop_A_Q(G3(:,:,:,57),Q(:,121),MT,G4(:,:,:,34))
  call loop_AV_Q(G4(:,:,:,34),wf(:,47),G4(:,:,:,35))
  call check_last_A_Q(l_switch,G4(:,:,:,35),Q(:,127),MT,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,34),wf(:,50),G4(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),MT,G5tensor(:,24))
  call loop_AV_Q(G1(:,:,:,8),wf(:,17),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,105),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-4),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,121),MT,G3(:,:,:,58))
  call loop_AV_Q(G3(:,:,:,58),wf(:,47),G3(:,:,:,59))
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,127),MT,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,50),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MT,G4tensor(:,24))
  call loop_QZ_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,4),gZd)
  call loop_Q_A(G0(:,:,:,4),Q(:,9),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-6),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,73),ZERO,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,3),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,121),ZERO,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,47),G3(:,:,:,62))
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,61),wf(:,50),G3(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,127),ZERO,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,37),wf(:,-4),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,89),ZERO,G3(:,:,:,64))
  call loop_QV_A(G3(:,:,:,64),wf(:,-5),G3(:,:,:,65))
  call loop_Q_A(G3(:,:,:,65),Q(:,121),ZERO,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,47),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),ZERO,G5tensor(:,25))
  call loop_QZ_A(G4(:,:,:,37),wf(:,50),G4(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,39),Q(:,127),ZERO,G5tensor(:,26))
  call loop_QV_A(G2(:,:,:,37),wf(:,-5),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,105),ZERO,G3(:,:,:,66))
  call loop_QV_A(G3(:,:,:,66),wf(:,-4),G3(:,:,:,67))
  call loop_Q_A(G3(:,:,:,67),Q(:,121),ZERO,G4(:,:,:,40))
  call loop_QV_A(G4(:,:,:,40),wf(:,47),G4(:,:,:,41))
  call check_last_Q_A(l_switch,G4(:,:,:,41),Q(:,127),ZERO,G5tensor(:,27))
  call loop_QZ_A(G4(:,:,:,40),wf(:,50),G4(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),ZERO,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,15),wf(:,3),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,57),ZERO,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,-6),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,121),ZERO,G3(:,:,:,68))
  call loop_QV_A(G3(:,:,:,68),wf(:,47),G3(:,:,:,69))
  call check_last_Q_A(l_switch,G3(:,:,:,69),Q(:,127),ZERO,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,68),wf(:,50),G3(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,28))
  call loop_QV_A(G1(:,:,:,15),wf(:,-5),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,41),ZERO,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,12),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,121),ZERO,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,47),G3(:,:,:,72))
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),ZERO,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,71),wf(:,50),G3(:,:,:,73),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,73),Q(:,127),ZERO,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,43),wf(:,-4),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,57),ZERO,G3(:,:,:,74))
  call loop_QV_A(G3(:,:,:,74),wf(:,-6),G3(:,:,:,75))
  call loop_Q_A(G3(:,:,:,75),Q(:,121),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,47),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),ZERO,G5tensor(:,29))
  call loop_QZ_A(G4(:,:,:,43),wf(:,50),G4(:,:,:,45),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,45),Q(:,127),ZERO,G5tensor(:,30))
  call loop_QV_A(G2(:,:,:,43),wf(:,-6),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,105),ZERO,G3(:,:,:,76))
  call loop_QV_A(G3(:,:,:,76),wf(:,-4),G3(:,:,:,77))
  call loop_Q_A(G3(:,:,:,77),Q(:,121),ZERO,G4(:,:,:,46))
  call loop_QV_A(G4(:,:,:,46),wf(:,47),G4(:,:,:,47))
  call check_last_Q_A(l_switch,G4(:,:,:,47),Q(:,127),ZERO,G5tensor(:,31))
  call loop_QZ_A(G4(:,:,:,46),wf(:,50),G4(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),ZERO,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,15),wf(:,12),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,89),ZERO,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,121),ZERO,G3(:,:,:,78))
  call loop_QV_A(G3(:,:,:,78),wf(:,47),G3(:,:,:,79))
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,127),ZERO,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,78),wf(:,50),G3(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),ZERO,G4tensor(:,32))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,25),ZERO,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,17),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,121),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,47),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,33))
  call loop_QZ_A(G3(:,:,:,81),wf(:,50),G3(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,127),ZERO,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,49),wf(:,-5),G2(:,:,:,51))
  call loop_Q_A(G2(:,:,:,51),Q(:,57),ZERO,G3(:,:,:,84))
  call loop_QV_A(G3(:,:,:,84),wf(:,-6),G3(:,:,:,85))
  call loop_Q_A(G3(:,:,:,85),Q(:,121),ZERO,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,47),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,33))
  call loop_QZ_A(G4(:,:,:,49),wf(:,50),G4(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,51),Q(:,127),ZERO,G5tensor(:,34))
  call loop_QV_A(G2(:,:,:,49),wf(:,-6),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,89),ZERO,G3(:,:,:,86))
  call loop_QV_A(G3(:,:,:,86),wf(:,-5),G3(:,:,:,87))
  call loop_Q_A(G3(:,:,:,87),Q(:,121),ZERO,G4(:,:,:,52))
  call loop_QV_A(G4(:,:,:,52),wf(:,47),G4(:,:,:,53))
  call check_last_Q_A(l_switch,G4(:,:,:,53),Q(:,127),ZERO,G5tensor(:,35))
  call loop_QZ_A(G4(:,:,:,52),wf(:,50),G4(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,36))
  call loop_QV_A(G1(:,:,:,15),wf(:,17),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,105),ZERO,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,121),ZERO,G3(:,:,:,88))
  call loop_QV_A(G3(:,:,:,88),wf(:,47),G3(:,:,:,89))
  call check_last_Q_A(l_switch,G3(:,:,:,89),Q(:,127),ZERO,G4tensor(:,35))
  call loop_QZ_A(G3(:,:,:,88),wf(:,50),G3(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,127),ZERO,G4tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,5),gZd)
  call loop_Q_A(G0(:,:,:,5),Q(:,9),MB,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,-6),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,73),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,3),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,121),MB,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,47),G3(:,:,:,92))
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),MB,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,91),wf(:,50),G3(:,:,:,93),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,127),MB,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,55),wf(:,-4),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,89),MB,G3(:,:,:,94))
  call loop_QV_A(G3(:,:,:,94),wf(:,-5),G3(:,:,:,95))
  call loop_Q_A(G3(:,:,:,95),Q(:,121),MB,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,47),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),MB,G5tensor(:,37))
  call loop_QZ_A(G4(:,:,:,55),wf(:,50),G4(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,57),Q(:,127),MB,G5tensor(:,38))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,105),MB,G3(:,:,:,96))
  call loop_QV_A(G3(:,:,:,96),wf(:,-4),G3(:,:,:,97))
  call loop_Q_A(G3(:,:,:,97),Q(:,121),MB,G4(:,:,:,58))
  call loop_QV_A(G4(:,:,:,58),wf(:,47),G4(:,:,:,59))
  call check_last_Q_A(l_switch,G4(:,:,:,59),Q(:,127),MB,G5tensor(:,39))
  call loop_QZ_A(G4(:,:,:,58),wf(:,50),G4(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),MB,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,22),wf(:,3),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,57),MB,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,-6),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,121),MB,G3(:,:,:,98))
  call loop_QV_A(G3(:,:,:,98),wf(:,47),G3(:,:,:,99))
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,127),MB,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,98),wf(:,50),G3(:,:,:,100),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,127),MB,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,22),wf(:,-5),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,41),MB,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,12),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,121),MB,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,47),G3(:,:,:,102))
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,127),MB,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,101),wf(:,50),G3(:,:,:,103),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,103),Q(:,127),MB,G4tensor(:,42))
  call loop_QV_A(G2(:,:,:,61),wf(:,-4),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,57),MB,G3(:,:,:,104))
  call loop_QV_A(G3(:,:,:,104),wf(:,-6),G3(:,:,:,105))
  call loop_Q_A(G3(:,:,:,105),Q(:,121),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,47),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,61),wf(:,50),G4(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,63),Q(:,127),MB,G5tensor(:,42))
  call loop_QV_A(G2(:,:,:,61),wf(:,-6),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,105),MB,G3(:,:,:,106))
  call loop_QV_A(G3(:,:,:,106),wf(:,-4),G3(:,:,:,107))
  call loop_Q_A(G3(:,:,:,107),Q(:,121),MB,G4(:,:,:,64))
  call loop_QV_A(G4(:,:,:,64),wf(:,47),G4(:,:,:,65))
  call check_last_Q_A(l_switch,G4(:,:,:,65),Q(:,127),MB,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,64),wf(:,50),G4(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,127),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,22),wf(:,12),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,89),MB,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,121),MB,G3(:,:,:,108))
  call loop_QV_A(G3(:,:,:,108),wf(:,47),G3(:,:,:,109))
  call check_last_Q_A(l_switch,G3(:,:,:,109),Q(:,127),MB,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,108),wf(:,50),G3(:,:,:,110),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,127),MB,G4tensor(:,44))
  call loop_QV_A(G1(:,:,:,22),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,25),MB,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,17),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,121),MB,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,47),G3(:,:,:,112))
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,127),MB,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,111),wf(:,50),G3(:,:,:,113),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,113),Q(:,127),MB,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,67),wf(:,-5),G2(:,:,:,69))
  call loop_Q_A(G2(:,:,:,69),Q(:,57),MB,G3(:,:,:,114))
  call loop_QV_A(G3(:,:,:,114),wf(:,-6),G3(:,:,:,115))
  call loop_Q_A(G3(:,:,:,115),Q(:,121),MB,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,47),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),MB,G5tensor(:,45))
  call loop_QZ_A(G4(:,:,:,67),wf(:,50),G4(:,:,:,69),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,69),Q(:,127),MB,G5tensor(:,46))
  call loop_QV_A(G2(:,:,:,67),wf(:,-6),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,89),MB,G3(:,:,:,116))
  call loop_QV_A(G3(:,:,:,116),wf(:,-5),G3(:,:,:,117))
  call loop_Q_A(G3(:,:,:,117),Q(:,121),MB,G4(:,:,:,70))
  call loop_QV_A(G4(:,:,:,70),wf(:,47),G4(:,:,:,71))
  call check_last_Q_A(l_switch,G4(:,:,:,71),Q(:,127),MB,G5tensor(:,47))
  call loop_QZ_A(G4(:,:,:,70),wf(:,50),G4(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),MB,G5tensor(:,48))
  call loop_QV_A(G1(:,:,:,22),wf(:,17),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,105),MB,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,-4),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,121),MB,G3(:,:,:,118))
  call loop_QV_A(G3(:,:,:,118),wf(:,47),G3(:,:,:,119))
  call check_last_Q_A(l_switch,G3(:,:,:,119),Q(:,127),MB,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,118),wf(:,50),G3(:,:,:,120),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,120),Q(:,127),MB,G4tensor(:,48))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,6),gZd)
  call loop_A_Q(G0(:,:,:,6),Q(:,9),ZERO,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-6),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,73),ZERO,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,3),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,121),ZERO,G3(:,:,:,121))
  call loop_AV_Q(G3(:,:,:,121),wf(:,47),G3(:,:,:,122))
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),ZERO,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,121),wf(:,50),G3(:,:,:,123),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,123),Q(:,127),ZERO,G4tensor(:,50))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-4),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,89),ZERO,G3(:,:,:,124))
  call loop_AV_Q(G3(:,:,:,124),wf(:,-5),G3(:,:,:,125))
  call loop_A_Q(G3(:,:,:,125),Q(:,121),ZERO,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,47),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,49))
  call loop_AZ_Q(G4(:,:,:,73),wf(:,50),G4(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,75),Q(:,127),ZERO,G5tensor(:,50))
  call loop_AV_Q(G2(:,:,:,73),wf(:,-5),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,105),ZERO,G3(:,:,:,126))
  call loop_AV_Q(G3(:,:,:,126),wf(:,-4),G3(:,:,:,127))
  call loop_A_Q(G3(:,:,:,127),Q(:,121),ZERO,G4(:,:,:,76))
  call loop_AV_Q(G4(:,:,:,76),wf(:,47),G4(:,:,:,77))
  call check_last_A_Q(l_switch,G4(:,:,:,77),Q(:,127),ZERO,G5tensor(:,51))
  call loop_AZ_Q(G4(:,:,:,76),wf(:,50),G4(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,127),ZERO,G5tensor(:,52))
  call loop_AV_Q(G1(:,:,:,29),wf(:,3),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,57),ZERO,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-6),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,121),ZERO,G3(:,:,:,128))
  call loop_AV_Q(G3(:,:,:,128),wf(:,47),G3(:,:,:,129))
  call check_last_A_Q(l_switch,G3(:,:,:,129),Q(:,127),ZERO,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,128),wf(:,50),G3(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,52))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,41),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,12),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,121),ZERO,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,47),G3(:,:,:,132))
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),ZERO,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,50),G3(:,:,:,133),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,127),ZERO,G4tensor(:,54))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-4),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,57),ZERO,G3(:,:,:,134))
  call loop_AV_Q(G3(:,:,:,134),wf(:,-6),G3(:,:,:,135))
  call loop_A_Q(G3(:,:,:,135),Q(:,121),ZERO,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,47),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,53))
  call loop_AZ_Q(G4(:,:,:,79),wf(:,50),G4(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,81),Q(:,127),ZERO,G5tensor(:,54))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-6),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,105),ZERO,G3(:,:,:,136))
  call loop_AV_Q(G3(:,:,:,136),wf(:,-4),G3(:,:,:,137))
  call loop_A_Q(G3(:,:,:,137),Q(:,121),ZERO,G4(:,:,:,82))
  call loop_AV_Q(G4(:,:,:,82),wf(:,47),G4(:,:,:,83))
  call check_last_A_Q(l_switch,G4(:,:,:,83),Q(:,127),ZERO,G5tensor(:,55))
  call loop_AZ_Q(G4(:,:,:,82),wf(:,50),G4(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,56))
  call loop_AV_Q(G1(:,:,:,29),wf(:,12),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,89),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,121),ZERO,G3(:,:,:,138))
  call loop_AV_Q(G3(:,:,:,138),wf(:,47),G3(:,:,:,139))
  call check_last_A_Q(l_switch,G3(:,:,:,139),Q(:,127),ZERO,G4tensor(:,55))
  call loop_AZ_Q(G3(:,:,:,138),wf(:,50),G3(:,:,:,140),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,127),ZERO,G4tensor(:,56))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-4),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,25),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,17),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,121),ZERO,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,47),G3(:,:,:,142))
  call check_last_A_Q(l_switch,G3(:,:,:,142),Q(:,127),ZERO,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,141),wf(:,50),G3(:,:,:,143),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,143),Q(:,127),ZERO,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-5),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,57),ZERO,G3(:,:,:,144))
  call loop_AV_Q(G3(:,:,:,144),wf(:,-6),G3(:,:,:,145))
  call loop_A_Q(G3(:,:,:,145),Q(:,121),ZERO,G4(:,:,:,85))
  call loop_AV_Q(G4(:,:,:,85),wf(:,47),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,57))
  call loop_AZ_Q(G4(:,:,:,85),wf(:,50),G4(:,:,:,87),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,87),Q(:,127),ZERO,G5tensor(:,58))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,89),ZERO,G3(:,:,:,146))
  call loop_AV_Q(G3(:,:,:,146),wf(:,-5),G3(:,:,:,147))
  call loop_A_Q(G3(:,:,:,147),Q(:,121),ZERO,G4(:,:,:,88))
  call loop_AV_Q(G4(:,:,:,88),wf(:,47),G4(:,:,:,89))
  call check_last_A_Q(l_switch,G4(:,:,:,89),Q(:,127),ZERO,G5tensor(:,59))
  call loop_AZ_Q(G4(:,:,:,88),wf(:,50),G4(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,60))
  call loop_AV_Q(G1(:,:,:,29),wf(:,17),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,105),ZERO,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,121),ZERO,G3(:,:,:,148))
  call loop_AV_Q(G3(:,:,:,148),wf(:,47),G3(:,:,:,149))
  call check_last_A_Q(l_switch,G3(:,:,:,149),Q(:,127),ZERO,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,148),wf(:,50),G3(:,:,:,150),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,127),ZERO,G4tensor(:,60))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,7),gZd)
  call loop_A_Q(G0(:,:,:,7),Q(:,9),MB,G1(:,:,:,36))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-6),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,73),MB,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,3),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,121),MB,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,47),G3(:,:,:,152))
  call check_last_A_Q(l_switch,G3(:,:,:,152),Q(:,127),MB,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,151),wf(:,50),G3(:,:,:,153),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,153),Q(:,127),MB,G4tensor(:,62))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-4),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,89),MB,G3(:,:,:,154))
  call loop_AV_Q(G3(:,:,:,154),wf(:,-5),G3(:,:,:,155))
  call loop_A_Q(G3(:,:,:,155),Q(:,121),MB,G4(:,:,:,91))
  call loop_AV_Q(G4(:,:,:,91),wf(:,47),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,127),MB,G5tensor(:,61))
  call loop_AZ_Q(G4(:,:,:,91),wf(:,50),G4(:,:,:,93),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,93),Q(:,127),MB,G5tensor(:,62))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-5),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,105),MB,G3(:,:,:,156))
  call loop_AV_Q(G3(:,:,:,156),wf(:,-4),G3(:,:,:,157))
  call loop_A_Q(G3(:,:,:,157),Q(:,121),MB,G4(:,:,:,94))
  call loop_AV_Q(G4(:,:,:,94),wf(:,47),G4(:,:,:,95))
  call check_last_A_Q(l_switch,G4(:,:,:,95),Q(:,127),MB,G5tensor(:,63))
  call loop_AZ_Q(G4(:,:,:,94),wf(:,50),G4(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,127),MB,G5tensor(:,64))
  call loop_AV_Q(G1(:,:,:,36),wf(:,3),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,57),MB,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-6),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,121),MB,G3(:,:,:,158))
  call loop_AV_Q(G3(:,:,:,158),wf(:,47),G3(:,:,:,159))
  call check_last_A_Q(l_switch,G3(:,:,:,159),Q(:,127),MB,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,158),wf(:,50),G3(:,:,:,160),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,160),Q(:,127),MB,G4tensor(:,64))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-5),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,41),MB,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,12),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,121),MB,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,47),G3(:,:,:,162))
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,127),MB,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,50),G3(:,:,:,163),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,163),Q(:,127),MB,G4tensor(:,66))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-4),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,57),MB,G3(:,:,:,164))
  call loop_AV_Q(G3(:,:,:,164),wf(:,-6),G3(:,:,:,165))
  call loop_A_Q(G3(:,:,:,165),Q(:,121),MB,G4(:,:,:,97))
  call loop_AV_Q(G4(:,:,:,97),wf(:,47),G4(:,:,:,98))
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MB,G5tensor(:,65))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,50),G4(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,99),Q(:,127),MB,G5tensor(:,66))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-6),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,105),MB,G3(:,:,:,166))
  call loop_AV_Q(G3(:,:,:,166),wf(:,-4),G3(:,:,:,167))
  call loop_A_Q(G3(:,:,:,167),Q(:,121),MB,G4(:,:,:,100))
  call loop_AV_Q(G4(:,:,:,100),wf(:,47),G4(:,:,:,101))
  call check_last_A_Q(l_switch,G4(:,:,:,101),Q(:,127),MB,G5tensor(:,67))
  call loop_AZ_Q(G4(:,:,:,100),wf(:,50),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),MB,G5tensor(:,68))
  call loop_AV_Q(G1(:,:,:,36),wf(:,12),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,89),MB,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,121),MB,G3(:,:,:,168))
  call loop_AV_Q(G3(:,:,:,168),wf(:,47),G3(:,:,:,169))
  call check_last_A_Q(l_switch,G3(:,:,:,169),Q(:,127),MB,G4tensor(:,67))
  call loop_AZ_Q(G3(:,:,:,168),wf(:,50),G3(:,:,:,170),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,127),MB,G4tensor(:,68))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,25),MB,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,17),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,121),MB,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,47),G3(:,:,:,172))
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,127),MB,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,171),wf(:,50),G3(:,:,:,173),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,173),Q(:,127),MB,G4tensor(:,70))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-5),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,57),MB,G3(:,:,:,174))
  call loop_AV_Q(G3(:,:,:,174),wf(:,-6),G3(:,:,:,175))
  call loop_A_Q(G3(:,:,:,175),Q(:,121),MB,G4(:,:,:,103))
  call loop_AV_Q(G4(:,:,:,103),wf(:,47),G4(:,:,:,104))
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),MB,G5tensor(:,69))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,50),G4(:,:,:,105),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,105),Q(:,127),MB,G5tensor(:,70))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-6),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,89),MB,G3(:,:,:,176))
  call loop_AV_Q(G3(:,:,:,176),wf(:,-5),G3(:,:,:,177))
  call loop_A_Q(G3(:,:,:,177),Q(:,121),MB,G4(:,:,:,106))
  call loop_AV_Q(G4(:,:,:,106),wf(:,47),G4(:,:,:,107))
  call check_last_A_Q(l_switch,G4(:,:,:,107),Q(:,127),MB,G5tensor(:,71))
  call loop_AZ_Q(G4(:,:,:,106),wf(:,50),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),MB,G5tensor(:,72))
  call loop_AV_Q(G1(:,:,:,36),wf(:,17),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,105),MB,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,-4),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,121),MB,G3(:,:,:,178))
  call loop_AV_Q(G3(:,:,:,178),wf(:,47),G3(:,:,:,179))
  call check_last_A_Q(l_switch,G3(:,:,:,179),Q(:,127),MB,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,178),wf(:,50),G3(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,127),MB,G4tensor(:,72))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(14)) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,1),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(14) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,1),T4sum(1:70,40))
  M(1) = M(1) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,13),T4sum(1:70,41))
  M(2) = M(2) + (CI*f(11) * den(236)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,13),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(11) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,25),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,25),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(9) * den(236)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,37),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(9)) * den(236)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,37),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(11) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,49),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,49),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(9) * den(236)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,61),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(9)) * den(236)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,61),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,2),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,2),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,14),T4sum(1:70,41))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,14),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,26),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,26),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,38),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,38),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,50),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,50),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,62),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,62),T4sum(1:70,42))
  M(1) = M(1) + (-(CI*f(14)) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,3),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(14) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,3),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,15),T4sum(1:70,44))
  M(2) = M(2) + (CI*f(11) * den(236)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,15),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(11) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,51),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,51),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(9) * den(236)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,63),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(9)) * den(236)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,63),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(11) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,27),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,27),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(9) * den(236)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,39),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(9)) * den(236)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,39),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,4),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,4),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,16),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,16),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,52),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,52),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,64),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,64),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,28),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,28),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,40),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,40),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(14) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,5),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(14)) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,5),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(11) * den(240)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,17),T4sum(1:70,50))
  M(2) = M(2) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,17),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,29),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(11) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,29),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(9)) * den(240)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,41),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(9) * den(240)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,41),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,53),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(11) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,53),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(9)) * den(240)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,65),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(9) * den(240)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,65),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,6),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,6),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,18),T4sum(1:70,50))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,18),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,30),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,30),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,42),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,42),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,54),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,54),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,66),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,66),T4sum(1:70,51))
  M(1) = M(1) + (CI*f(14) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,7),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(14)) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,7),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(11) * den(240)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,19),T4sum(1:70,53))
  M(2) = M(2) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,19),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,55),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(11) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,55),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(9)) * den(240)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,67),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(9) * den(240)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,67),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,31),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(11) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,31),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(9)) * den(240)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,43),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(9) * den(240)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,43),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,8),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,8),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,20),T4sum(1:70,53))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,20),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,56),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,56),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,68),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,68),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,32),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,32),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,44),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,44),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(14)) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,9),T4sum(1:70,58))
  M(2) = M(2) + (CI*f(14) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,9),T4sum(1:70,58))
  M(1) = M(1) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,21),T4sum(1:70,59))
  M(2) = M(2) + (CI*f(11) * den(244)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,21),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(11) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,33),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,33),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(9) * den(244)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,45),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(9)) * den(244)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,45),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(11) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,57),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,57),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(9) * den(244)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,69),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(9)) * den(244)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,69),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,10),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,10),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,22),T4sum(1:70,59))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,22),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,34),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,34),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,46),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,46),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,58),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,58),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,70),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,70),T4sum(1:70,60))
  M(1) = M(1) + (-(CI*f(14)) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,11),T4sum(1:70,61))
  M(2) = M(2) + (CI*f(14) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,11),T4sum(1:70,61))
  M(1) = M(1) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,23),T4sum(1:70,62))
  M(2) = M(2) + (CI*f(11) * den(244)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,23),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(11) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,59),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,59),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(9) * den(244)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,71),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(9)) * den(244)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,71),T4sum(1:70,63))
  M(1) = M(1) + (CI*f(11) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,35),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,35),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(9) * den(244)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,47),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(9)) * den(244)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,47),T4sum(1:70,63))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,12),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,12),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,24),T4sum(1:70,62))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,24),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,60),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,60),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,72),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,72),T4sum(1:70,63))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,36),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,36),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,48),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,48),T4sum(1:70,63))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,5),T5sum(1:126,37))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,17),T5sum(1:126,38))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,29),T5sum(1:126,37))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,41),T5sum(1:126,39))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,53),T5sum(1:126,37))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,65),T5sum(1:126,39))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,6),T5sum(1:126,37))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,18),T5sum(1:126,38))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,30),T5sum(1:126,37))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,42),T5sum(1:126,39))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,54),T5sum(1:126,37))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,66),T5sum(1:126,39))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,1),T5sum(1:126,40))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,13),T5sum(1:126,41))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,49),T5sum(1:126,40))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,61),T5sum(1:126,42))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,25),T5sum(1:126,40))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,37),T5sum(1:126,42))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,2),T5sum(1:126,40))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,14),T5sum(1:126,41))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,50),T5sum(1:126,40))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,62),T5sum(1:126,42))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,26),T5sum(1:126,40))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,38),T5sum(1:126,42))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,9),T5sum(1:126,43))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,21),T5sum(1:126,44))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,57),T5sum(1:126,43))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,69),T5sum(1:126,45))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,33),T5sum(1:126,43))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,45),T5sum(1:126,45))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,10),T5sum(1:126,43))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,22),T5sum(1:126,44))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,58),T5sum(1:126,43))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,70),T5sum(1:126,45))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,34),T5sum(1:126,43))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,46),T5sum(1:126,45))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,3),T5sum(1:126,49))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,15),T5sum(1:126,50))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,27),T5sum(1:126,49))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,39),T5sum(1:126,51))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,51),T5sum(1:126,49))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,63),T5sum(1:126,51))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,4),T5sum(1:126,49))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,16),T5sum(1:126,50))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,28),T5sum(1:126,49))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,40),T5sum(1:126,51))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,52),T5sum(1:126,49))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,64),T5sum(1:126,51))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,11),T5sum(1:126,55))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,23),T5sum(1:126,56))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,59),T5sum(1:126,55))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,71),T5sum(1:126,57))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,35),T5sum(1:126,55))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,47),T5sum(1:126,57))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,12),T5sum(1:126,55))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,24),T5sum(1:126,56))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,60),T5sum(1:126,55))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,72),T5sum(1:126,57))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,36),T5sum(1:126,55))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,48),T5sum(1:126,57))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,7),T5sum(1:126,61))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,19),T5sum(1:126,62))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,31),T5sum(1:126,61))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,43),T5sum(1:126,63))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,55),T5sum(1:126,61))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,67),T5sum(1:126,63))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,8),T5sum(1:126,61))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,20),T5sum(1:126,62))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,32),T5sum(1:126,61))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,44),T5sum(1:126,63))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,56),T5sum(1:126,61))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,68),T5sum(1:126,63))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_7

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_7_ppllllj2_eeexexggg_1_/**/REALKIND
