
module ol_vamp_6_ppllllj2_eeexexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_6(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eeexexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eeexexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eeexexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eeexexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,10) :: G0
  complex(REALKIND), dimension(4,5,4,66) :: G1
  complex(REALKIND), dimension(4,15,4,233) :: G2
  complex(REALKIND), dimension(4,35,4,418) :: G3
  complex(REALKIND), dimension(4,70,4,236) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,48,128))
    allocate(G4tensorhel(70,218,128))
    allocate(G5tensorhel(126,164,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,26),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,17),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,122),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),ZERO,G4tensor(:,2))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-6),G2(:,:,:,3))
  call loop_A_Q(G2(:,:,:,3),Q(:,90),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-5),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,122),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-5),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,58),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-6),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,122),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,1),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,9),G4(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,7),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,9),G4(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,26),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,17),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,122),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,4))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,9),G3(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-6),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,90),ZERO,G3(:,:,:,12))
  call loop_AV_Q(G3(:,:,:,12),wf(:,-5),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,122),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,1),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,9),G4(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-5),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,58),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,-6),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,122),ZERO,G4(:,:,:,12))
  call loop_AV_Q(G4(:,:,:,12),wf(:,1),G4(:,:,:,13))
  call check_last_A_Q(l_switch,G4(:,:,:,13),Q(:,127),ZERO,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,12),wf(:,9),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,26),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,17),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,122),ZERO,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AZ_Q(G3(:,:,:,16),wf(:,9),G3(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,7))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-6),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,90),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-5),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,122),ZERO,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,1),G4(:,:,:,16))
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),ZERO,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,9),G4(:,:,:,17),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),ZERO,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,58),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-6),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,122),ZERO,G4(:,:,:,18))
  call loop_AV_Q(G4(:,:,:,18),wf(:,1),G4(:,:,:,19))
  call check_last_A_Q(l_switch,G4(:,:,:,19),Q(:,127),ZERO,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,18),wf(:,9),G4(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),ZERO,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,48),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,58),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-6),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,122),ZERO,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,1),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),ZERO,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,9),G4(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),ZERO,G5tensor(:,16))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,9),G4(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),ZERO,G5tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,6),G2(:,:,:,15),gZu)
  call loop_A_Q(G2(:,:,:,15),Q(:,58),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,-6),G3(:,:,:,26))
  call loop_A_Q(G3(:,:,:,26),Q(:,122),ZERO,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),ZERO,G5tensor(:,18))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,9),G4(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,127),ZERO,G5tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,6),G2(:,:,:,16),gZd)
  call loop_A_Q(G2(:,:,:,16),Q(:,58),ZERO,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,-6),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,122),ZERO,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,1),G4(:,:,:,29))
  call check_last_A_Q(l_switch,G4(:,:,:,29),Q(:,127),ZERO,G5tensor(:,20))
  call loop_AZ_Q(G4(:,:,:,28),wf(:,9),G4(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),ZERO,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-6),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,112),ZERO,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,129),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,130),G3(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,130),G3(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G3(:,:,:,29),wf(:,131),G3(:,:,:,33))
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,132),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,132),G3(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AV_Q(G3(:,:,:,29),wf(:,133),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,134),G3(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,127),ZERO,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,134),G3(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),ZERO,G4tensor(:,16))
  call loop_AV_Q(G3(:,:,:,29),wf(:,135),G3(:,:,:,39))
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,136),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,136),G3(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AV_Q(G3(:,:,:,29),wf(:,137),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,138),G3(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,138),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G3(:,:,:,29),wf(:,139),G3(:,:,:,45))
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,140),G3(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),ZERO,G4tensor(:,24))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,140),G3(:,:,:,47),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),ZERO,G4tensor(:,25))
  call loop_AV_Q(G3(:,:,:,29),wf(:,141),G3(:,:,:,48))
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),ZERO,G4tensor(:,26))
  call loop_AV_Q(G3(:,:,:,29),wf(:,142),G3(:,:,:,49))
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,127),ZERO,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,143),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,28))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,143),G3(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,144),G3(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,30))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,144),G3(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,127),ZERO,G4tensor(:,31))
  call loop_AV_Q(G3(:,:,:,29),wf(:,145),G3(:,:,:,54))
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,127),ZERO,G4tensor(:,32))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,146),G3(:,:,:,55),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,146),G3(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AV_Q(G3(:,:,:,29),wf(:,147),G3(:,:,:,57))
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,127),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,148),G3(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),ZERO,G4tensor(:,36))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,148),G3(:,:,:,59),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AV_Q(G3(:,:,:,29),wf(:,149),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,150),G3(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),ZERO,G4tensor(:,39))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,150),G3(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,40))
  call loop_AV_Q(G3(:,:,:,29),wf(:,151),G3(:,:,:,63))
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,127),ZERO,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,152),G3(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),ZERO,G4tensor(:,42))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,152),G3(:,:,:,65),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,65),Q(:,127),ZERO,G4tensor(:,43))
  call loop_AV_Q(G3(:,:,:,29),wf(:,153),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,44))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,154),G3(:,:,:,67),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,154),G3(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,46))
  call loop_AV_Q(G3(:,:,:,29),wf(:,155),G3(:,:,:,69))
  call check_last_A_Q(l_switch,G3(:,:,:,69),Q(:,127),ZERO,G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,156),G3(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,48))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,156),G3(:,:,:,71),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,71),Q(:,127),ZERO,G4tensor(:,49))
  call loop_AV_Q(G3(:,:,:,29),wf(:,157),G3(:,:,:,72))
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,127),ZERO,G4tensor(:,50))
  call loop_AV_Q(G3(:,:,:,29),wf(:,158),G3(:,:,:,73))
  call check_last_A_Q(l_switch,G3(:,:,:,73),Q(:,127),ZERO,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,159),G3(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,52))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,159),G3(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,127),ZERO,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,160),G3(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,160),G3(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,77),Q(:,127),ZERO,G4tensor(:,55))
  call loop_AV_Q(G2(:,:,:,13),wf(:,46),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,57),ZERO,G3(:,:,:,78))
  call loop_AV_Q(G3(:,:,:,78),wf(:,-6),G3(:,:,:,79))
  call loop_A_Q(G3(:,:,:,79),Q(:,121),ZERO,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,47),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,22))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,50),G4(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,33),Q(:,127),ZERO,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,50),G4(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,127),ZERO,G5tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,53),G2(:,:,:,19),gZu)
  call loop_A_Q(G2(:,:,:,19),Q(:,57),ZERO,G3(:,:,:,80))
  call loop_AV_Q(G3(:,:,:,80),wf(:,-6),G3(:,:,:,81))
  call loop_A_Q(G3(:,:,:,81),Q(:,121),ZERO,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,47),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,25))
  call loop_AZ_Q(G4(:,:,:,35),wf(:,50),G4(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,37),Q(:,127),ZERO,G5tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,53),G2(:,:,:,20),gZd)
  call loop_A_Q(G2(:,:,:,20),Q(:,57),ZERO,G3(:,:,:,82))
  call loop_AV_Q(G3(:,:,:,82),wf(:,-6),G3(:,:,:,83))
  call loop_A_Q(G3(:,:,:,83),Q(:,121),ZERO,G4(:,:,:,38))
  call loop_AV_Q(G4(:,:,:,38),wf(:,47),G4(:,:,:,39))
  call check_last_A_Q(l_switch,G4(:,:,:,39),Q(:,127),ZERO,G5tensor(:,27))
  call loop_AZ_Q(G4(:,:,:,38),wf(:,50),G4(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,127),ZERO,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,80),ZERO,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,2),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,90),ZERO,G3(:,:,:,84))
  call loop_AV_Q(G3(:,:,:,84),wf(:,-5),G3(:,:,:,85))
  call loop_A_Q(G3(:,:,:,85),Q(:,122),ZERO,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,1),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,127),ZERO,G5tensor(:,29))
  call loop_AZ_Q(G4(:,:,:,41),wf(:,9),G4(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,43),Q(:,127),ZERO,G5tensor(:,30))
  call loop_AZ_Q(G4(:,:,:,41),wf(:,9),G4(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,127),ZERO,G5tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,6),G2(:,:,:,23),gZu)
  call loop_A_Q(G2(:,:,:,23),Q(:,90),ZERO,G3(:,:,:,86))
  call loop_AV_Q(G3(:,:,:,86),wf(:,-5),G3(:,:,:,87))
  call loop_A_Q(G3(:,:,:,87),Q(:,122),ZERO,G4(:,:,:,45))
  call loop_AV_Q(G4(:,:,:,45),wf(:,1),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,127),ZERO,G5tensor(:,32))
  call loop_AZ_Q(G4(:,:,:,45),wf(:,9),G4(:,:,:,47),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,47),Q(:,127),ZERO,G5tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,6),G2(:,:,:,24),gZd)
  call loop_A_Q(G2(:,:,:,24),Q(:,90),ZERO,G3(:,:,:,88))
  call loop_AV_Q(G3(:,:,:,88),wf(:,-5),G3(:,:,:,89))
  call loop_A_Q(G3(:,:,:,89),Q(:,122),ZERO,G4(:,:,:,48))
  call loop_AV_Q(G4(:,:,:,48),wf(:,1),G4(:,:,:,49))
  call check_last_A_Q(l_switch,G4(:,:,:,49),Q(:,127),ZERO,G5tensor(:,34))
  call loop_AZ_Q(G4(:,:,:,48),wf(:,9),G4(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-5),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,112),ZERO,G3(:,:,:,90))
  call loop_AV_Q(G3(:,:,:,90),wf(:,129),G3(:,:,:,91))
  call check_last_A_Q(l_switch,G3(:,:,:,91),Q(:,127),ZERO,G4tensor(:,56))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,130),G3(:,:,:,92),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),ZERO,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,130),G3(:,:,:,93),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,93),Q(:,127),ZERO,G4tensor(:,58))
  call loop_AV_Q(G3(:,:,:,90),wf(:,131),G3(:,:,:,94))
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,127),ZERO,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,132),G3(:,:,:,95),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,127),ZERO,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,132),G3(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,127),ZERO,G4tensor(:,61))
  call loop_AV_Q(G3(:,:,:,90),wf(:,133),G3(:,:,:,97))
  call check_last_A_Q(l_switch,G3(:,:,:,97),Q(:,127),ZERO,G4tensor(:,62))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,134),G3(:,:,:,98),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,127),ZERO,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,134),G3(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,99),Q(:,127),ZERO,G4tensor(:,64))
  call loop_AV_Q(G3(:,:,:,90),wf(:,135),G3(:,:,:,100))
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,127),ZERO,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,136),G3(:,:,:,101),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,101),Q(:,127),ZERO,G4tensor(:,66))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,136),G3(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,127),ZERO,G4tensor(:,67))
  call loop_AV_Q(G3(:,:,:,90),wf(:,137),G3(:,:,:,103))
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,127),ZERO,G4tensor(:,68))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,138),G3(:,:,:,104),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,127),ZERO,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,138),G3(:,:,:,105),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,105),Q(:,127),ZERO,G4tensor(:,70))
  call loop_AV_Q(G3(:,:,:,90),wf(:,139),G3(:,:,:,106))
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,127),ZERO,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,140),G3(:,:,:,107),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,107),Q(:,127),ZERO,G4tensor(:,72))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,140),G3(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,127),ZERO,G4tensor(:,73))
  call loop_AV_Q(G3(:,:,:,90),wf(:,141),G3(:,:,:,109))
  call check_last_A_Q(l_switch,G3(:,:,:,109),Q(:,127),ZERO,G4tensor(:,74))
  call loop_AV_Q(G3(:,:,:,90),wf(:,142),G3(:,:,:,110))
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),ZERO,G4tensor(:,75))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,143),G3(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,111),Q(:,127),ZERO,G4tensor(:,76))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,143),G3(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,127),ZERO,G4tensor(:,77))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,144),G3(:,:,:,113),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,113),Q(:,127),ZERO,G4tensor(:,78))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,144),G3(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,127),ZERO,G4tensor(:,79))
  call loop_AV_Q(G3(:,:,:,90),wf(:,145),G3(:,:,:,115))
  call check_last_A_Q(l_switch,G3(:,:,:,115),Q(:,127),ZERO,G4tensor(:,80))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,146),G3(:,:,:,116),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),ZERO,G4tensor(:,81))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,146),G3(:,:,:,117),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,117),Q(:,127),ZERO,G4tensor(:,82))
  call loop_AV_Q(G3(:,:,:,90),wf(:,147),G3(:,:,:,118))
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,127),ZERO,G4tensor(:,83))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,148),G3(:,:,:,119),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,119),Q(:,127),ZERO,G4tensor(:,84))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,148),G3(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,127),ZERO,G4tensor(:,85))
  call loop_AV_Q(G3(:,:,:,90),wf(:,149),G3(:,:,:,121))
  call check_last_A_Q(l_switch,G3(:,:,:,121),Q(:,127),ZERO,G4tensor(:,86))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,150),G3(:,:,:,122),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),ZERO,G4tensor(:,87))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,150),G3(:,:,:,123),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,123),Q(:,127),ZERO,G4tensor(:,88))
  call loop_AV_Q(G3(:,:,:,90),wf(:,151),G3(:,:,:,124))
  call check_last_A_Q(l_switch,G3(:,:,:,124),Q(:,127),ZERO,G4tensor(:,89))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,152),G3(:,:,:,125),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,125),Q(:,127),ZERO,G4tensor(:,90))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,152),G3(:,:,:,126),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,126),Q(:,127),ZERO,G4tensor(:,91))
  call loop_AV_Q(G3(:,:,:,90),wf(:,153),G3(:,:,:,127))
  call check_last_A_Q(l_switch,G3(:,:,:,127),Q(:,127),ZERO,G4tensor(:,92))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,154),G3(:,:,:,128),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,127),ZERO,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,154),G3(:,:,:,129),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,129),Q(:,127),ZERO,G4tensor(:,94))
  call loop_AV_Q(G3(:,:,:,90),wf(:,155),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,95))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,156),G3(:,:,:,131),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,131),Q(:,127),ZERO,G4tensor(:,96))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,156),G3(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),ZERO,G4tensor(:,97))
  call loop_AV_Q(G3(:,:,:,90),wf(:,157),G3(:,:,:,133))
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,127),ZERO,G4tensor(:,98))
  call loop_AV_Q(G3(:,:,:,90),wf(:,158),G3(:,:,:,134))
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,127),ZERO,G4tensor(:,99))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,159),G3(:,:,:,135),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,135),Q(:,127),ZERO,G4tensor(:,100))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,159),G3(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,127),ZERO,G4tensor(:,101))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,160),G3(:,:,:,137),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,137),Q(:,127),ZERO,G4tensor(:,102))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,160),G3(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,127),ZERO,G4tensor(:,103))
  call loop_AV_Q(G2(:,:,:,21),wf(:,46),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,89),ZERO,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,-5),G3(:,:,:,140))
  call loop_A_Q(G3(:,:,:,140),Q(:,121),ZERO,G4(:,:,:,51))
  call loop_AV_Q(G4(:,:,:,51),wf(:,47),G4(:,:,:,52))
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,127),ZERO,G5tensor(:,36))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,50),G4(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,53),Q(:,127),ZERO,G5tensor(:,37))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,50),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,53),G2(:,:,:,27),gZu)
  call loop_A_Q(G2(:,:,:,27),Q(:,89),ZERO,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-5),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,121),ZERO,G4(:,:,:,55))
  call loop_AV_Q(G4(:,:,:,55),wf(:,47),G4(:,:,:,56))
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,127),ZERO,G5tensor(:,39))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,50),G4(:,:,:,57),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,57),Q(:,127),ZERO,G5tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,53),G2(:,:,:,28),gZd)
  call loop_A_Q(G2(:,:,:,28),Q(:,89),ZERO,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-5),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,121),ZERO,G4(:,:,:,58))
  call loop_AV_Q(G4(:,:,:,58),wf(:,47),G4(:,:,:,59))
  call check_last_A_Q(l_switch,G4(:,:,:,59),Q(:,127),ZERO,G5tensor(:,41))
  call loop_AZ_Q(G4(:,:,:,58),wf(:,50),G4(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,42))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,112),ZERO,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,129),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,130),G2(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,130),G2(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,29),wf(:,131),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,132),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),ZERO,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,132),G2(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),ZERO,G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,29),wf(:,133),G2(:,:,:,36))
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),ZERO,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,134),G2(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),ZERO,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,134),G2(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),ZERO,G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,29),wf(:,135),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),ZERO,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,136),G2(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),ZERO,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,136),G2(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),ZERO,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,29),wf(:,137),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),ZERO,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,138),G2(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),ZERO,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,138),G2(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),ZERO,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,29),wf(:,139),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,127),ZERO,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,140),G2(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,127),ZERO,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,140),G2(:,:,:,47),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,127),ZERO,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,29),wf(:,141),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,127),ZERO,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,29),wf(:,142),G2(:,:,:,49))
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,127),ZERO,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,143),G2(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,127),ZERO,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,143),G2(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,127),ZERO,G3tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,144),G2(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,52),Q(:,127),ZERO,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,144),G2(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,127),ZERO,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,29),wf(:,145),G2(:,:,:,54))
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,127),ZERO,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,146),G2(:,:,:,55),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,127),ZERO,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,146),G2(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),ZERO,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,29),wf(:,147),G2(:,:,:,57))
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,127),ZERO,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,148),G2(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,127),ZERO,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,148),G2(:,:,:,59),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,127),ZERO,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,29),wf(:,149),G2(:,:,:,60))
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,127),ZERO,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,150),G2(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,61),Q(:,127),ZERO,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,150),G2(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,127),ZERO,G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,29),wf(:,151),G2(:,:,:,63))
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,127),ZERO,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,152),G2(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),ZERO,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,152),G2(:,:,:,65),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),ZERO,G3tensor(:,36))
  call loop_AV_Q(G2(:,:,:,29),wf(:,153),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,154),G2(:,:,:,67),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,127),ZERO,G3tensor(:,38))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,154),G2(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,29),wf(:,155),G2(:,:,:,69))
  call check_last_A_Q(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,156),G2(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,156),G2(:,:,:,71),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,42))
  call loop_AV_Q(G2(:,:,:,29),wf(:,157),G2(:,:,:,72))
  call check_last_A_Q(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,43))
  call loop_AV_Q(G2(:,:,:,29),wf(:,158),G2(:,:,:,73))
  call check_last_A_Q(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,159),G2(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,45))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,159),G2(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),ZERO,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,160),G2(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,29),wf(:,160),G2(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,1),wf(:,46),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,25),ZERO,G2(:,:,:,78))
  call loop_AV_Q(G2(:,:,:,78),wf(:,17),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,121),ZERO,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,47),G3(:,:,:,146))
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,127),ZERO,G4tensor(:,104))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,50),G3(:,:,:,147),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,147),Q(:,127),ZERO,G4tensor(:,105))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,50),G3(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,148),Q(:,127),ZERO,G4tensor(:,106))
  call loop_AV_Q(G2(:,:,:,78),wf(:,-5),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,57),ZERO,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-6),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,121),ZERO,G4(:,:,:,61))
  call loop_AV_Q(G4(:,:,:,61),wf(:,47),G4(:,:,:,62))
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,127),ZERO,G5tensor(:,43))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,50),G4(:,:,:,63),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,63),Q(:,127),ZERO,G5tensor(:,44))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,50),G4(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,127),ZERO,G5tensor(:,45))
  call loop_AV_Q(G2(:,:,:,78),wf(:,-6),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,89),ZERO,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-5),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,121),ZERO,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,47),G4(:,:,:,66))
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,127),ZERO,G5tensor(:,46))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,50),G4(:,:,:,67),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,67),Q(:,127),ZERO,G5tensor(:,47))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,50),G4(:,:,:,68),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,127),ZERO,G5tensor(:,48))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,53),G1(:,:,:,9),gZu)
  call loop_A_Q(G1(:,:,:,9),Q(:,25),ZERO,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,17),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,121),ZERO,G3(:,:,:,153))
  call loop_AV_Q(G3(:,:,:,153),wf(:,47),G3(:,:,:,154))
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,127),ZERO,G4tensor(:,107))
  call loop_AZ_Q(G3(:,:,:,153),wf(:,50),G3(:,:,:,155),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,155),Q(:,127),ZERO,G4tensor(:,108))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-5),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,57),ZERO,G3(:,:,:,156))
  call loop_AV_Q(G3(:,:,:,156),wf(:,-6),G3(:,:,:,157))
  call loop_A_Q(G3(:,:,:,157),Q(:,121),ZERO,G4(:,:,:,69))
  call loop_AV_Q(G4(:,:,:,69),wf(:,47),G4(:,:,:,70))
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,127),ZERO,G5tensor(:,49))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,50),G4(:,:,:,71),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,71),Q(:,127),ZERO,G5tensor(:,50))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-6),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,89),ZERO,G3(:,:,:,158))
  call loop_AV_Q(G3(:,:,:,158),wf(:,-5),G3(:,:,:,159))
  call loop_A_Q(G3(:,:,:,159),Q(:,121),ZERO,G4(:,:,:,72))
  call loop_AV_Q(G4(:,:,:,72),wf(:,47),G4(:,:,:,73))
  call check_last_A_Q(l_switch,G4(:,:,:,73),Q(:,127),ZERO,G5tensor(:,51))
  call loop_AZ_Q(G4(:,:,:,72),wf(:,50),G4(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,52))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,53),G1(:,:,:,10),gZd)
  call loop_A_Q(G1(:,:,:,10),Q(:,25),ZERO,G2(:,:,:,86))
  call loop_AV_Q(G2(:,:,:,86),wf(:,17),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,121),ZERO,G3(:,:,:,160))
  call loop_AV_Q(G3(:,:,:,160),wf(:,47),G3(:,:,:,161))
  call check_last_A_Q(l_switch,G3(:,:,:,161),Q(:,127),ZERO,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,160),wf(:,50),G3(:,:,:,162),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,127),ZERO,G4tensor(:,110))
  call loop_AV_Q(G2(:,:,:,86),wf(:,-5),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,57),ZERO,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,-6),G3(:,:,:,164))
  call loop_A_Q(G3(:,:,:,164),Q(:,121),ZERO,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,47),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,127),ZERO,G5tensor(:,53))
  call loop_AZ_Q(G4(:,:,:,75),wf(:,50),G4(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,77),Q(:,127),ZERO,G5tensor(:,54))
  call loop_AV_Q(G2(:,:,:,86),wf(:,-6),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,89),ZERO,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,-5),G3(:,:,:,166))
  call loop_A_Q(G3(:,:,:,166),Q(:,121),ZERO,G4(:,:,:,78))
  call loop_AV_Q(G4(:,:,:,78),wf(:,47),G4(:,:,:,79))
  call check_last_A_Q(l_switch,G4(:,:,:,79),Q(:,127),ZERO,G5tensor(:,55))
  call loop_AZ_Q(G4(:,:,:,78),wf(:,50),G4(:,:,:,80),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,9),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-6),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,73),ZERO,G2(:,:,:,90))
  call loop_QV_A(G2(:,:,:,90),wf(:,3),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,121),ZERO,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,47),G3(:,:,:,168))
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,127),ZERO,G4tensor(:,111))
  call loop_QZ_A(G3(:,:,:,167),wf(:,50),G3(:,:,:,169),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,169),Q(:,127),ZERO,G4tensor(:,112))
  call loop_QZ_A(G3(:,:,:,167),wf(:,50),G3(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),ZERO,G4tensor(:,113))
  call loop_QV_A(G2(:,:,:,90),wf(:,-4),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,89),ZERO,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-5),G3(:,:,:,172))
  call loop_Q_A(G3(:,:,:,172),Q(:,121),ZERO,G4(:,:,:,81))
  call loop_QV_A(G4(:,:,:,81),wf(:,47),G4(:,:,:,82))
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,127),ZERO,G5tensor(:,57))
  call loop_QZ_A(G4(:,:,:,81),wf(:,50),G4(:,:,:,83),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,83),Q(:,127),ZERO,G5tensor(:,58))
  call loop_QZ_A(G4(:,:,:,81),wf(:,50),G4(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,59))
  call loop_QV_A(G2(:,:,:,90),wf(:,-5),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,105),ZERO,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-4),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,121),ZERO,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,47),G4(:,:,:,86))
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,60))
  call loop_QZ_A(G4(:,:,:,85),wf(:,50),G4(:,:,:,87),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,87),Q(:,127),ZERO,G5tensor(:,61))
  call loop_QZ_A(G4(:,:,:,85),wf(:,50),G4(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,62))
  call loop_QV_A(G1(:,:,:,11),wf(:,3),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,57),ZERO,G2(:,:,:,94))
  call loop_QV_A(G2(:,:,:,94),wf(:,-6),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,121),ZERO,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,47),G3(:,:,:,176))
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),ZERO,G4tensor(:,114))
  call loop_QZ_A(G3(:,:,:,175),wf(:,50),G3(:,:,:,177),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,177),Q(:,127),ZERO,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,175),wf(:,50),G3(:,:,:,178),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),ZERO,G4tensor(:,116))
  call loop_QV_A(G1(:,:,:,11),wf(:,-5),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,41),ZERO,G2(:,:,:,96))
  call loop_QV_A(G2(:,:,:,96),wf(:,12),G2(:,:,:,97))
  call loop_Q_A(G2(:,:,:,97),Q(:,121),ZERO,G3(:,:,:,179))
  call loop_QV_A(G3(:,:,:,179),wf(:,47),G3(:,:,:,180))
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),ZERO,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,179),wf(:,50),G3(:,:,:,181),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,181),Q(:,127),ZERO,G4tensor(:,118))
  call loop_QZ_A(G3(:,:,:,179),wf(:,50),G3(:,:,:,182),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,127),ZERO,G4tensor(:,119))
  call loop_QV_A(G2(:,:,:,96),wf(:,-4),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,57),ZERO,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-6),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,121),ZERO,G4(:,:,:,89))
  call loop_QV_A(G4(:,:,:,89),wf(:,47),G4(:,:,:,90))
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,63))
  call loop_QZ_A(G4(:,:,:,89),wf(:,50),G4(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,91),Q(:,127),ZERO,G5tensor(:,64))
  call loop_QZ_A(G4(:,:,:,89),wf(:,50),G4(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),ZERO,G5tensor(:,65))
  call loop_QV_A(G2(:,:,:,96),wf(:,-6),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,105),ZERO,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,-4),G3(:,:,:,186))
  call loop_Q_A(G3(:,:,:,186),Q(:,121),ZERO,G4(:,:,:,93))
  call loop_QV_A(G4(:,:,:,93),wf(:,47),G4(:,:,:,94))
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,127),ZERO,G5tensor(:,66))
  call loop_QZ_A(G4(:,:,:,93),wf(:,50),G4(:,:,:,95),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,95),Q(:,127),ZERO,G5tensor(:,67))
  call loop_QZ_A(G4(:,:,:,93),wf(:,50),G4(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,127),ZERO,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,11),wf(:,12),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,89),ZERO,G2(:,:,:,100))
  call loop_QV_A(G2(:,:,:,100),wf(:,-5),G2(:,:,:,101))
  call loop_Q_A(G2(:,:,:,101),Q(:,121),ZERO,G3(:,:,:,187))
  call loop_QV_A(G3(:,:,:,187),wf(:,47),G3(:,:,:,188))
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),ZERO,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,187),wf(:,50),G3(:,:,:,189),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),ZERO,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,187),wf(:,50),G3(:,:,:,190),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),ZERO,G4tensor(:,122))
  call loop_QV_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,25),ZERO,G2(:,:,:,102))
  call loop_QV_A(G2(:,:,:,102),wf(:,17),G2(:,:,:,103))
  call loop_Q_A(G2(:,:,:,103),Q(:,121),ZERO,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,47),G3(:,:,:,192))
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,127),ZERO,G4tensor(:,123))
  call loop_QZ_A(G3(:,:,:,191),wf(:,50),G3(:,:,:,193),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,127),ZERO,G4tensor(:,124))
  call loop_QZ_A(G3(:,:,:,191),wf(:,50),G3(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,125))
  call loop_QV_A(G2(:,:,:,102),wf(:,-5),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,57),ZERO,G3(:,:,:,195))
  call loop_QV_A(G3(:,:,:,195),wf(:,-6),G3(:,:,:,196))
  call loop_Q_A(G3(:,:,:,196),Q(:,121),ZERO,G4(:,:,:,97))
  call loop_QV_A(G4(:,:,:,97),wf(:,47),G4(:,:,:,98))
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,127),ZERO,G5tensor(:,69))
  call loop_QZ_A(G4(:,:,:,97),wf(:,50),G4(:,:,:,99),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,99),Q(:,127),ZERO,G5tensor(:,70))
  call loop_QZ_A(G4(:,:,:,97),wf(:,50),G4(:,:,:,100),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,127),ZERO,G5tensor(:,71))
  call loop_QV_A(G2(:,:,:,102),wf(:,-6),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,89),ZERO,G3(:,:,:,197))
  call loop_QV_A(G3(:,:,:,197),wf(:,-5),G3(:,:,:,198))
  call loop_Q_A(G3(:,:,:,198),Q(:,121),ZERO,G4(:,:,:,101))
  call loop_QV_A(G4(:,:,:,101),wf(:,47),G4(:,:,:,102))
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,127),ZERO,G5tensor(:,72))
  call loop_QZ_A(G4(:,:,:,101),wf(:,50),G4(:,:,:,103),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,103),Q(:,127),ZERO,G5tensor(:,73))
  call loop_QZ_A(G4(:,:,:,101),wf(:,50),G4(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,127),ZERO,G5tensor(:,74))
  call loop_QV_A(G1(:,:,:,11),wf(:,17),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,105),ZERO,G2(:,:,:,106))
  call loop_QV_A(G2(:,:,:,106),wf(:,-4),G2(:,:,:,107))
  call loop_Q_A(G2(:,:,:,107),Q(:,121),ZERO,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,47),G3(:,:,:,200))
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,127),ZERO,G4tensor(:,126))
  call loop_QZ_A(G3(:,:,:,199),wf(:,50),G3(:,:,:,201),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,201),Q(:,127),ZERO,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,199),wf(:,50),G3(:,:,:,202),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,127),ZERO,G4tensor(:,128))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,9),MT,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,-6),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,73),MT,G2(:,:,:,108))
  call loop_QV_A(G2(:,:,:,108),wf(:,3),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,121),MT,G3(:,:,:,203))
  call loop_QV_A(G3(:,:,:,203),wf(:,47),G3(:,:,:,204))
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,127),MT,G4tensor(:,129))
  call loop_QZ_A(G3(:,:,:,203),wf(:,50),G3(:,:,:,205),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,205),Q(:,127),MT,G4tensor(:,130))
  call loop_QV_A(G2(:,:,:,108),wf(:,-4),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,89),MT,G3(:,:,:,206))
  call loop_QV_A(G3(:,:,:,206),wf(:,-5),G3(:,:,:,207))
  call loop_Q_A(G3(:,:,:,207),Q(:,121),MT,G4(:,:,:,105))
  call loop_QV_A(G4(:,:,:,105),wf(:,47),G4(:,:,:,106))
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,127),MT,G5tensor(:,75))
  call loop_QZ_A(G4(:,:,:,105),wf(:,50),G4(:,:,:,107),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,107),Q(:,127),MT,G5tensor(:,76))
  call loop_QV_A(G2(:,:,:,108),wf(:,-5),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,105),MT,G3(:,:,:,208))
  call loop_QV_A(G3(:,:,:,208),wf(:,-4),G3(:,:,:,209))
  call loop_Q_A(G3(:,:,:,209),Q(:,121),MT,G4(:,:,:,108))
  call loop_QV_A(G4(:,:,:,108),wf(:,47),G4(:,:,:,109))
  call check_last_Q_A(l_switch,G4(:,:,:,109),Q(:,127),MT,G5tensor(:,77))
  call loop_QZ_A(G4(:,:,:,108),wf(:,50),G4(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),MT,G5tensor(:,78))
  call loop_QV_A(G1(:,:,:,18),wf(:,3),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,57),MT,G2(:,:,:,112))
  call loop_QV_A(G2(:,:,:,112),wf(:,-6),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,121),MT,G3(:,:,:,210))
  call loop_QV_A(G3(:,:,:,210),wf(:,47),G3(:,:,:,211))
  call check_last_Q_A(l_switch,G3(:,:,:,211),Q(:,127),MT,G4tensor(:,131))
  call loop_QZ_A(G3(:,:,:,210),wf(:,50),G3(:,:,:,212),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,127),MT,G4tensor(:,132))
  call loop_QV_A(G1(:,:,:,18),wf(:,-5),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,41),MT,G2(:,:,:,114))
  call loop_QV_A(G2(:,:,:,114),wf(:,12),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,121),MT,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,47),G3(:,:,:,214))
  call check_last_Q_A(l_switch,G3(:,:,:,214),Q(:,127),MT,G4tensor(:,133))
  call loop_QZ_A(G3(:,:,:,213),wf(:,50),G3(:,:,:,215),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,215),Q(:,127),MT,G4tensor(:,134))
  call loop_QV_A(G2(:,:,:,114),wf(:,-4),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,57),MT,G3(:,:,:,216))
  call loop_QV_A(G3(:,:,:,216),wf(:,-6),G3(:,:,:,217))
  call loop_Q_A(G3(:,:,:,217),Q(:,121),MT,G4(:,:,:,111))
  call loop_QV_A(G4(:,:,:,111),wf(:,47),G4(:,:,:,112))
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,127),MT,G5tensor(:,79))
  call loop_QZ_A(G4(:,:,:,111),wf(:,50),G4(:,:,:,113),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,113),Q(:,127),MT,G5tensor(:,80))
  call loop_QV_A(G2(:,:,:,114),wf(:,-6),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,105),MT,G3(:,:,:,218))
  call loop_QV_A(G3(:,:,:,218),wf(:,-4),G3(:,:,:,219))
  call loop_Q_A(G3(:,:,:,219),Q(:,121),MT,G4(:,:,:,114))
  call loop_QV_A(G4(:,:,:,114),wf(:,47),G4(:,:,:,115))
  call check_last_Q_A(l_switch,G4(:,:,:,115),Q(:,127),MT,G5tensor(:,81))
  call loop_QZ_A(G4(:,:,:,114),wf(:,50),G4(:,:,:,116),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,127),MT,G5tensor(:,82))
  call loop_QV_A(G1(:,:,:,18),wf(:,12),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,89),MT,G2(:,:,:,118))
  call loop_QV_A(G2(:,:,:,118),wf(:,-5),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,121),MT,G3(:,:,:,220))
  call loop_QV_A(G3(:,:,:,220),wf(:,47),G3(:,:,:,221))
  call check_last_Q_A(l_switch,G3(:,:,:,221),Q(:,127),MT,G4tensor(:,135))
  call loop_QZ_A(G3(:,:,:,220),wf(:,50),G3(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,127),MT,G4tensor(:,136))
  call loop_QV_A(G1(:,:,:,18),wf(:,-4),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,25),MT,G2(:,:,:,120))
  call loop_QV_A(G2(:,:,:,120),wf(:,17),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,121),MT,G3(:,:,:,223))
  call loop_QV_A(G3(:,:,:,223),wf(:,47),G3(:,:,:,224))
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,127),MT,G4tensor(:,137))
  call loop_QZ_A(G3(:,:,:,223),wf(:,50),G3(:,:,:,225),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,127),MT,G4tensor(:,138))
  call loop_QV_A(G2(:,:,:,120),wf(:,-5),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,57),MT,G3(:,:,:,226))
  call loop_QV_A(G3(:,:,:,226),wf(:,-6),G3(:,:,:,227))
  call loop_Q_A(G3(:,:,:,227),Q(:,121),MT,G4(:,:,:,117))
  call loop_QV_A(G4(:,:,:,117),wf(:,47),G4(:,:,:,118))
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,127),MT,G5tensor(:,83))
  call loop_QZ_A(G4(:,:,:,117),wf(:,50),G4(:,:,:,119),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,119),Q(:,127),MT,G5tensor(:,84))
  call loop_QV_A(G2(:,:,:,120),wf(:,-6),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,89),MT,G3(:,:,:,228))
  call loop_QV_A(G3(:,:,:,228),wf(:,-5),G3(:,:,:,229))
  call loop_Q_A(G3(:,:,:,229),Q(:,121),MT,G4(:,:,:,120))
  call loop_QV_A(G4(:,:,:,120),wf(:,47),G4(:,:,:,121))
  call check_last_Q_A(l_switch,G4(:,:,:,121),Q(:,127),MT,G5tensor(:,85))
  call loop_QZ_A(G4(:,:,:,120),wf(:,50),G4(:,:,:,122),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,127),MT,G5tensor(:,86))
  call loop_QV_A(G1(:,:,:,18),wf(:,17),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,105),MT,G2(:,:,:,124))
  call loop_QV_A(G2(:,:,:,124),wf(:,-4),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,121),MT,G3(:,:,:,230))
  call loop_QV_A(G3(:,:,:,230),wf(:,47),G3(:,:,:,231))
  call check_last_Q_A(l_switch,G3(:,:,:,231),Q(:,127),MT,G4tensor(:,139))
  call loop_QZ_A(G3(:,:,:,230),wf(:,50),G3(:,:,:,232),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,127),MT,G4tensor(:,140))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,9),ZERO,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-6),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,73),ZERO,G2(:,:,:,126))
  call loop_AV_Q(G2(:,:,:,126),wf(:,3),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,121),ZERO,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,47),G3(:,:,:,234))
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,127),ZERO,G4tensor(:,141))
  call loop_AZ_Q(G3(:,:,:,233),wf(:,50),G3(:,:,:,235),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,235),Q(:,127),ZERO,G4tensor(:,142))
  call loop_AZ_Q(G3(:,:,:,233),wf(:,50),G3(:,:,:,236),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,127),ZERO,G4tensor(:,143))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-4),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,89),ZERO,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-5),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,121),ZERO,G4(:,:,:,123))
  call loop_AV_Q(G4(:,:,:,123),wf(:,47),G4(:,:,:,124))
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,127),ZERO,G5tensor(:,87))
  call loop_AZ_Q(G4(:,:,:,123),wf(:,50),G4(:,:,:,125),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,125),Q(:,127),ZERO,G5tensor(:,88))
  call loop_AZ_Q(G4(:,:,:,123),wf(:,50),G4(:,:,:,126),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,127),ZERO,G5tensor(:,89))
  call loop_AV_Q(G2(:,:,:,126),wf(:,-5),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,105),ZERO,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-4),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,121),ZERO,G4(:,:,:,127))
  call loop_AV_Q(G4(:,:,:,127),wf(:,47),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),ZERO,G5tensor(:,90))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,50),G4(:,:,:,129),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,129),Q(:,127),ZERO,G5tensor(:,91))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,50),G4(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,127),ZERO,G5tensor(:,92))
  call loop_AV_Q(G1(:,:,:,25),wf(:,3),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,57),ZERO,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-6),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,121),ZERO,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,47),G3(:,:,:,242))
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,127),ZERO,G4tensor(:,144))
  call loop_AZ_Q(G3(:,:,:,241),wf(:,50),G3(:,:,:,243),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,243),Q(:,127),ZERO,G4tensor(:,145))
  call loop_AZ_Q(G3(:,:,:,241),wf(:,50),G3(:,:,:,244),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,244),Q(:,127),ZERO,G4tensor(:,146))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,41),ZERO,G2(:,:,:,132))
  call loop_AV_Q(G2(:,:,:,132),wf(:,12),G2(:,:,:,133))
  call loop_A_Q(G2(:,:,:,133),Q(:,121),ZERO,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,47),G3(:,:,:,246))
  call check_last_A_Q(l_switch,G3(:,:,:,246),Q(:,127),ZERO,G4tensor(:,147))
  call loop_AZ_Q(G3(:,:,:,245),wf(:,50),G3(:,:,:,247),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,247),Q(:,127),ZERO,G4tensor(:,148))
  call loop_AZ_Q(G3(:,:,:,245),wf(:,50),G3(:,:,:,248),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,127),ZERO,G4tensor(:,149))
  call loop_AV_Q(G2(:,:,:,132),wf(:,-4),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,57),ZERO,G3(:,:,:,249))
  call loop_AV_Q(G3(:,:,:,249),wf(:,-6),G3(:,:,:,250))
  call loop_A_Q(G3(:,:,:,250),Q(:,121),ZERO,G4(:,:,:,131))
  call loop_AV_Q(G4(:,:,:,131),wf(:,47),G4(:,:,:,132))
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,93))
  call loop_AZ_Q(G4(:,:,:,131),wf(:,50),G4(:,:,:,133),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,133),Q(:,127),ZERO,G5tensor(:,94))
  call loop_AZ_Q(G4(:,:,:,131),wf(:,50),G4(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,95))
  call loop_AV_Q(G2(:,:,:,132),wf(:,-6),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,105),ZERO,G3(:,:,:,251))
  call loop_AV_Q(G3(:,:,:,251),wf(:,-4),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,121),ZERO,G4(:,:,:,135))
  call loop_AV_Q(G4(:,:,:,135),wf(:,47),G4(:,:,:,136))
  call check_last_A_Q(l_switch,G4(:,:,:,136),Q(:,127),ZERO,G5tensor(:,96))
  call loop_AZ_Q(G4(:,:,:,135),wf(:,50),G4(:,:,:,137),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,137),Q(:,127),ZERO,G5tensor(:,97))
  call loop_AZ_Q(G4(:,:,:,135),wf(:,50),G4(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,127),ZERO,G5tensor(:,98))
  call loop_AV_Q(G1(:,:,:,25),wf(:,12),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,89),ZERO,G2(:,:,:,136))
  call loop_AV_Q(G2(:,:,:,136),wf(:,-5),G2(:,:,:,137))
  call loop_A_Q(G2(:,:,:,137),Q(:,121),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,47),G3(:,:,:,254))
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,127),ZERO,G4tensor(:,150))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,50),G3(:,:,:,255),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,255),Q(:,127),ZERO,G4tensor(:,151))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,50),G3(:,:,:,256),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,127),ZERO,G4tensor(:,152))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,25),ZERO,G2(:,:,:,138))
  call loop_AV_Q(G2(:,:,:,138),wf(:,17),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,121),ZERO,G3(:,:,:,257))
  call loop_AV_Q(G3(:,:,:,257),wf(:,47),G3(:,:,:,258))
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,153))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,50),G3(:,:,:,259),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,259),Q(:,127),ZERO,G4tensor(:,154))
  call loop_AZ_Q(G3(:,:,:,257),wf(:,50),G3(:,:,:,260),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),ZERO,G4tensor(:,155))
  call loop_AV_Q(G2(:,:,:,138),wf(:,-5),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,57),ZERO,G3(:,:,:,261))
  call loop_AV_Q(G3(:,:,:,261),wf(:,-6),G3(:,:,:,262))
  call loop_A_Q(G3(:,:,:,262),Q(:,121),ZERO,G4(:,:,:,139))
  call loop_AV_Q(G4(:,:,:,139),wf(:,47),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,127),ZERO,G5tensor(:,99))
  call loop_AZ_Q(G4(:,:,:,139),wf(:,50),G4(:,:,:,141),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,141),Q(:,127),ZERO,G5tensor(:,100))
  call loop_AZ_Q(G4(:,:,:,139),wf(:,50),G4(:,:,:,142),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,142),Q(:,127),ZERO,G5tensor(:,101))
  call loop_AV_Q(G2(:,:,:,138),wf(:,-6),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,89),ZERO,G3(:,:,:,263))
  call loop_AV_Q(G3(:,:,:,263),wf(:,-5),G3(:,:,:,264))
  call loop_A_Q(G3(:,:,:,264),Q(:,121),ZERO,G4(:,:,:,143))
  call loop_AV_Q(G4(:,:,:,143),wf(:,47),G4(:,:,:,144))
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,127),ZERO,G5tensor(:,102))
  call loop_AZ_Q(G4(:,:,:,143),wf(:,50),G4(:,:,:,145),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,145),Q(:,127),ZERO,G5tensor(:,103))
  call loop_AZ_Q(G4(:,:,:,143),wf(:,50),G4(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,127),ZERO,G5tensor(:,104))
  call loop_AV_Q(G1(:,:,:,25),wf(:,17),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,105),ZERO,G2(:,:,:,142))
  call loop_AV_Q(G2(:,:,:,142),wf(:,-4),G2(:,:,:,143))
  call loop_A_Q(G2(:,:,:,143),Q(:,121),ZERO,G3(:,:,:,265))
  call loop_AV_Q(G3(:,:,:,265),wf(:,47),G3(:,:,:,266))
  call check_last_A_Q(l_switch,G3(:,:,:,266),Q(:,127),ZERO,G4tensor(:,156))
  call loop_AZ_Q(G3(:,:,:,265),wf(:,50),G3(:,:,:,267),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,267),Q(:,127),ZERO,G4tensor(:,157))
  call loop_AZ_Q(G3(:,:,:,265),wf(:,50),G3(:,:,:,268),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,268),Q(:,127),ZERO,G4tensor(:,158))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,9),MT,G1(:,:,:,32))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-6),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,73),MT,G2(:,:,:,144))
  call loop_AV_Q(G2(:,:,:,144),wf(:,3),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,121),MT,G3(:,:,:,269))
  call loop_AV_Q(G3(:,:,:,269),wf(:,47),G3(:,:,:,270))
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,127),MT,G4tensor(:,159))
  call loop_AZ_Q(G3(:,:,:,269),wf(:,50),G3(:,:,:,271),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,271),Q(:,127),MT,G4tensor(:,160))
  call loop_AV_Q(G2(:,:,:,144),wf(:,-4),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,89),MT,G3(:,:,:,272))
  call loop_AV_Q(G3(:,:,:,272),wf(:,-5),G3(:,:,:,273))
  call loop_A_Q(G3(:,:,:,273),Q(:,121),MT,G4(:,:,:,147))
  call loop_AV_Q(G4(:,:,:,147),wf(:,47),G4(:,:,:,148))
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,127),MT,G5tensor(:,105))
  call loop_AZ_Q(G4(:,:,:,147),wf(:,50),G4(:,:,:,149),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,149),Q(:,127),MT,G5tensor(:,106))
  call loop_AV_Q(G2(:,:,:,144),wf(:,-5),G2(:,:,:,147))
  call loop_A_Q(G2(:,:,:,147),Q(:,105),MT,G3(:,:,:,274))
  call loop_AV_Q(G3(:,:,:,274),wf(:,-4),G3(:,:,:,275))
  call loop_A_Q(G3(:,:,:,275),Q(:,121),MT,G4(:,:,:,150))
  call loop_AV_Q(G4(:,:,:,150),wf(:,47),G4(:,:,:,151))
  call check_last_A_Q(l_switch,G4(:,:,:,151),Q(:,127),MT,G5tensor(:,107))
  call loop_AZ_Q(G4(:,:,:,150),wf(:,50),G4(:,:,:,152),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,127),MT,G5tensor(:,108))
  call loop_AV_Q(G1(:,:,:,32),wf(:,3),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,57),MT,G2(:,:,:,148))
  call loop_AV_Q(G2(:,:,:,148),wf(:,-6),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,121),MT,G3(:,:,:,276))
  call loop_AV_Q(G3(:,:,:,276),wf(:,47),G3(:,:,:,277))
  call check_last_A_Q(l_switch,G3(:,:,:,277),Q(:,127),MT,G4tensor(:,161))
  call loop_AZ_Q(G3(:,:,:,276),wf(:,50),G3(:,:,:,278),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,127),MT,G4tensor(:,162))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,41),MT,G2(:,:,:,150))
  call loop_AV_Q(G2(:,:,:,150),wf(:,12),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,121),MT,G3(:,:,:,279))
  call loop_AV_Q(G3(:,:,:,279),wf(:,47),G3(:,:,:,280))
  call check_last_A_Q(l_switch,G3(:,:,:,280),Q(:,127),MT,G4tensor(:,163))
  call loop_AZ_Q(G3(:,:,:,279),wf(:,50),G3(:,:,:,281),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,281),Q(:,127),MT,G4tensor(:,164))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-4),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,57),MT,G3(:,:,:,282))
  call loop_AV_Q(G3(:,:,:,282),wf(:,-6),G3(:,:,:,283))
  call loop_A_Q(G3(:,:,:,283),Q(:,121),MT,G4(:,:,:,153))
  call loop_AV_Q(G4(:,:,:,153),wf(:,47),G4(:,:,:,154))
  call check_last_A_Q(l_switch,G4(:,:,:,154),Q(:,127),MT,G5tensor(:,109))
  call loop_AZ_Q(G4(:,:,:,153),wf(:,50),G4(:,:,:,155),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,155),Q(:,127),MT,G5tensor(:,110))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-6),G2(:,:,:,153))
  call loop_A_Q(G2(:,:,:,153),Q(:,105),MT,G3(:,:,:,284))
  call loop_AV_Q(G3(:,:,:,284),wf(:,-4),G3(:,:,:,285))
  call loop_A_Q(G3(:,:,:,285),Q(:,121),MT,G4(:,:,:,156))
  call loop_AV_Q(G4(:,:,:,156),wf(:,47),G4(:,:,:,157))
  call check_last_A_Q(l_switch,G4(:,:,:,157),Q(:,127),MT,G5tensor(:,111))
  call loop_AZ_Q(G4(:,:,:,156),wf(:,50),G4(:,:,:,158),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,158),Q(:,127),MT,G5tensor(:,112))
  call loop_AV_Q(G1(:,:,:,32),wf(:,12),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,89),MT,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-5),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,121),MT,G3(:,:,:,286))
  call loop_AV_Q(G3(:,:,:,286),wf(:,47),G3(:,:,:,287))
  call check_last_A_Q(l_switch,G3(:,:,:,287),Q(:,127),MT,G4tensor(:,165))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,50),G3(:,:,:,288),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,127),MT,G4tensor(:,166))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-4),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,25),MT,G2(:,:,:,156))
  call loop_AV_Q(G2(:,:,:,156),wf(:,17),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,121),MT,G3(:,:,:,289))
  call loop_AV_Q(G3(:,:,:,289),wf(:,47),G3(:,:,:,290))
  call check_last_A_Q(l_switch,G3(:,:,:,290),Q(:,127),MT,G4tensor(:,167))
  call loop_AZ_Q(G3(:,:,:,289),wf(:,50),G3(:,:,:,291),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,291),Q(:,127),MT,G4tensor(:,168))
  call loop_AV_Q(G2(:,:,:,156),wf(:,-5),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,57),MT,G3(:,:,:,292))
  call loop_AV_Q(G3(:,:,:,292),wf(:,-6),G3(:,:,:,293))
  call loop_A_Q(G3(:,:,:,293),Q(:,121),MT,G4(:,:,:,159))
  call loop_AV_Q(G4(:,:,:,159),wf(:,47),G4(:,:,:,160))
  call check_last_A_Q(l_switch,G4(:,:,:,160),Q(:,127),MT,G5tensor(:,113))
  call loop_AZ_Q(G4(:,:,:,159),wf(:,50),G4(:,:,:,161),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,161),Q(:,127),MT,G5tensor(:,114))
  call loop_AV_Q(G2(:,:,:,156),wf(:,-6),G2(:,:,:,159))
  call loop_A_Q(G2(:,:,:,159),Q(:,89),MT,G3(:,:,:,294))
  call loop_AV_Q(G3(:,:,:,294),wf(:,-5),G3(:,:,:,295))
  call loop_A_Q(G3(:,:,:,295),Q(:,121),MT,G4(:,:,:,162))
  call loop_AV_Q(G4(:,:,:,162),wf(:,47),G4(:,:,:,163))
  call check_last_A_Q(l_switch,G4(:,:,:,163),Q(:,127),MT,G5tensor(:,115))
  call loop_AZ_Q(G4(:,:,:,162),wf(:,50),G4(:,:,:,164),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,164),Q(:,127),MT,G5tensor(:,116))
  call loop_AV_Q(G1(:,:,:,32),wf(:,17),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,105),MT,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-4),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,121),MT,G3(:,:,:,296))
  call loop_AV_Q(G3(:,:,:,296),wf(:,47),G3(:,:,:,297))
  call check_last_A_Q(l_switch,G3(:,:,:,297),Q(:,127),MT,G4tensor(:,169))
  call loop_AZ_Q(G3(:,:,:,296),wf(:,50),G3(:,:,:,298),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),MT,G4tensor(:,170))
  call loop_QV_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,9),MB,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,-6),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,73),MB,G2(:,:,:,162))
  call loop_QV_A(G2(:,:,:,162),wf(:,3),G2(:,:,:,163))
  call loop_Q_A(G2(:,:,:,163),Q(:,121),MB,G3(:,:,:,299))
  call loop_QV_A(G3(:,:,:,299),wf(:,47),G3(:,:,:,300))
  call check_last_Q_A(l_switch,G3(:,:,:,300),Q(:,127),MB,G4tensor(:,171))
  call loop_QZ_A(G3(:,:,:,299),wf(:,50),G3(:,:,:,301),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,301),Q(:,127),MB,G4tensor(:,172))
  call loop_QV_A(G2(:,:,:,162),wf(:,-4),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,89),MB,G3(:,:,:,302))
  call loop_QV_A(G3(:,:,:,302),wf(:,-5),G3(:,:,:,303))
  call loop_Q_A(G3(:,:,:,303),Q(:,121),MB,G4(:,:,:,165))
  call loop_QV_A(G4(:,:,:,165),wf(:,47),G4(:,:,:,166))
  call check_last_Q_A(l_switch,G4(:,:,:,166),Q(:,127),MB,G5tensor(:,117))
  call loop_QZ_A(G4(:,:,:,165),wf(:,50),G4(:,:,:,167),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,167),Q(:,127),MB,G5tensor(:,118))
  call loop_QV_A(G2(:,:,:,162),wf(:,-5),G2(:,:,:,165))
  call loop_Q_A(G2(:,:,:,165),Q(:,105),MB,G3(:,:,:,304))
  call loop_QV_A(G3(:,:,:,304),wf(:,-4),G3(:,:,:,305))
  call loop_Q_A(G3(:,:,:,305),Q(:,121),MB,G4(:,:,:,168))
  call loop_QV_A(G4(:,:,:,168),wf(:,47),G4(:,:,:,169))
  call check_last_Q_A(l_switch,G4(:,:,:,169),Q(:,127),MB,G5tensor(:,119))
  call loop_QZ_A(G4(:,:,:,168),wf(:,50),G4(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,170),Q(:,127),MB,G5tensor(:,120))
  call loop_QV_A(G1(:,:,:,39),wf(:,3),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,57),MB,G2(:,:,:,166))
  call loop_QV_A(G2(:,:,:,166),wf(:,-6),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,121),MB,G3(:,:,:,306))
  call loop_QV_A(G3(:,:,:,306),wf(:,47),G3(:,:,:,307))
  call check_last_Q_A(l_switch,G3(:,:,:,307),Q(:,127),MB,G4tensor(:,173))
  call loop_QZ_A(G3(:,:,:,306),wf(:,50),G3(:,:,:,308),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,308),Q(:,127),MB,G4tensor(:,174))
  call loop_QV_A(G1(:,:,:,39),wf(:,-5),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,41),MB,G2(:,:,:,168))
  call loop_QV_A(G2(:,:,:,168),wf(:,12),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,121),MB,G3(:,:,:,309))
  call loop_QV_A(G3(:,:,:,309),wf(:,47),G3(:,:,:,310))
  call check_last_Q_A(l_switch,G3(:,:,:,310),Q(:,127),MB,G4tensor(:,175))
  call loop_QZ_A(G3(:,:,:,309),wf(:,50),G3(:,:,:,311),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,311),Q(:,127),MB,G4tensor(:,176))
  call loop_QV_A(G2(:,:,:,168),wf(:,-4),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,57),MB,G3(:,:,:,312))
  call loop_QV_A(G3(:,:,:,312),wf(:,-6),G3(:,:,:,313))
  call loop_Q_A(G3(:,:,:,313),Q(:,121),MB,G4(:,:,:,171))
  call loop_QV_A(G4(:,:,:,171),wf(:,47),G4(:,:,:,172))
  call check_last_Q_A(l_switch,G4(:,:,:,172),Q(:,127),MB,G5tensor(:,121))
  call loop_QZ_A(G4(:,:,:,171),wf(:,50),G4(:,:,:,173),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,173),Q(:,127),MB,G5tensor(:,122))
  call loop_QV_A(G2(:,:,:,168),wf(:,-6),G2(:,:,:,171))
  call loop_Q_A(G2(:,:,:,171),Q(:,105),MB,G3(:,:,:,314))
  call loop_QV_A(G3(:,:,:,314),wf(:,-4),G3(:,:,:,315))
  call loop_Q_A(G3(:,:,:,315),Q(:,121),MB,G4(:,:,:,174))
  call loop_QV_A(G4(:,:,:,174),wf(:,47),G4(:,:,:,175))
  call check_last_Q_A(l_switch,G4(:,:,:,175),Q(:,127),MB,G5tensor(:,123))
  call loop_QZ_A(G4(:,:,:,174),wf(:,50),G4(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,127),MB,G5tensor(:,124))
  call loop_QV_A(G1(:,:,:,39),wf(:,12),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,89),MB,G2(:,:,:,172))
  call loop_QV_A(G2(:,:,:,172),wf(:,-5),G2(:,:,:,173))
  call loop_Q_A(G2(:,:,:,173),Q(:,121),MB,G3(:,:,:,316))
  call loop_QV_A(G3(:,:,:,316),wf(:,47),G3(:,:,:,317))
  call check_last_Q_A(l_switch,G3(:,:,:,317),Q(:,127),MB,G4tensor(:,177))
  call loop_QZ_A(G3(:,:,:,316),wf(:,50),G3(:,:,:,318),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,318),Q(:,127),MB,G4tensor(:,178))
  call loop_QV_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,25),MB,G2(:,:,:,174))
  call loop_QV_A(G2(:,:,:,174),wf(:,17),G2(:,:,:,175))
  call loop_Q_A(G2(:,:,:,175),Q(:,121),MB,G3(:,:,:,319))
  call loop_QV_A(G3(:,:,:,319),wf(:,47),G3(:,:,:,320))
  call check_last_Q_A(l_switch,G3(:,:,:,320),Q(:,127),MB,G4tensor(:,179))
  call loop_QZ_A(G3(:,:,:,319),wf(:,50),G3(:,:,:,321),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,321),Q(:,127),MB,G4tensor(:,180))
  call loop_QV_A(G2(:,:,:,174),wf(:,-5),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,57),MB,G3(:,:,:,322))
  call loop_QV_A(G3(:,:,:,322),wf(:,-6),G3(:,:,:,323))
  call loop_Q_A(G3(:,:,:,323),Q(:,121),MB,G4(:,:,:,177))
  call loop_QV_A(G4(:,:,:,177),wf(:,47),G4(:,:,:,178))
  call check_last_Q_A(l_switch,G4(:,:,:,178),Q(:,127),MB,G5tensor(:,125))
  call loop_QZ_A(G4(:,:,:,177),wf(:,50),G4(:,:,:,179),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,179),Q(:,127),MB,G5tensor(:,126))
  call loop_QV_A(G2(:,:,:,174),wf(:,-6),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,89),MB,G3(:,:,:,324))
  call loop_QV_A(G3(:,:,:,324),wf(:,-5),G3(:,:,:,325))
  call loop_Q_A(G3(:,:,:,325),Q(:,121),MB,G4(:,:,:,180))
  call loop_QV_A(G4(:,:,:,180),wf(:,47),G4(:,:,:,181))
  call check_last_Q_A(l_switch,G4(:,:,:,181),Q(:,127),MB,G5tensor(:,127))
  call loop_QZ_A(G4(:,:,:,180),wf(:,50),G4(:,:,:,182),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,182),Q(:,127),MB,G5tensor(:,128))
  call loop_QV_A(G1(:,:,:,39),wf(:,17),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,105),MB,G2(:,:,:,178))
  call loop_QV_A(G2(:,:,:,178),wf(:,-4),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,121),MB,G3(:,:,:,326))
  call loop_QV_A(G3(:,:,:,326),wf(:,47),G3(:,:,:,327))
  call check_last_Q_A(l_switch,G3(:,:,:,327),Q(:,127),MB,G4tensor(:,181))
  call loop_QZ_A(G3(:,:,:,326),wf(:,50),G3(:,:,:,328),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,328),Q(:,127),MB,G4tensor(:,182))
  call loop_AV_Q(G0(:,:,:,1),wf(:,46),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,9),MB,G1(:,:,:,46))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-6),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,73),MB,G2(:,:,:,180))
  call loop_AV_Q(G2(:,:,:,180),wf(:,3),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,121),MB,G3(:,:,:,329))
  call loop_AV_Q(G3(:,:,:,329),wf(:,47),G3(:,:,:,330))
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,127),MB,G4tensor(:,183))
  call loop_AZ_Q(G3(:,:,:,329),wf(:,50),G3(:,:,:,331),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,331),Q(:,127),MB,G4tensor(:,184))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-4),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,89),MB,G3(:,:,:,332))
  call loop_AV_Q(G3(:,:,:,332),wf(:,-5),G3(:,:,:,333))
  call loop_A_Q(G3(:,:,:,333),Q(:,121),MB,G4(:,:,:,183))
  call loop_AV_Q(G4(:,:,:,183),wf(:,47),G4(:,:,:,184))
  call check_last_A_Q(l_switch,G4(:,:,:,184),Q(:,127),MB,G5tensor(:,129))
  call loop_AZ_Q(G4(:,:,:,183),wf(:,50),G4(:,:,:,185),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,185),Q(:,127),MB,G5tensor(:,130))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-5),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,105),MB,G3(:,:,:,334))
  call loop_AV_Q(G3(:,:,:,334),wf(:,-4),G3(:,:,:,335))
  call loop_A_Q(G3(:,:,:,335),Q(:,121),MB,G4(:,:,:,186))
  call loop_AV_Q(G4(:,:,:,186),wf(:,47),G4(:,:,:,187))
  call check_last_A_Q(l_switch,G4(:,:,:,187),Q(:,127),MB,G5tensor(:,131))
  call loop_AZ_Q(G4(:,:,:,186),wf(:,50),G4(:,:,:,188),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,188),Q(:,127),MB,G5tensor(:,132))
  call loop_AV_Q(G1(:,:,:,46),wf(:,3),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,57),MB,G2(:,:,:,184))
  call loop_AV_Q(G2(:,:,:,184),wf(:,-6),G2(:,:,:,185))
  call loop_A_Q(G2(:,:,:,185),Q(:,121),MB,G3(:,:,:,336))
  call loop_AV_Q(G3(:,:,:,336),wf(:,47),G3(:,:,:,337))
  call check_last_A_Q(l_switch,G3(:,:,:,337),Q(:,127),MB,G4tensor(:,185))
  call loop_AZ_Q(G3(:,:,:,336),wf(:,50),G3(:,:,:,338),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,127),MB,G4tensor(:,186))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-5),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,41),MB,G2(:,:,:,186))
  call loop_AV_Q(G2(:,:,:,186),wf(:,12),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,121),MB,G3(:,:,:,339))
  call loop_AV_Q(G3(:,:,:,339),wf(:,47),G3(:,:,:,340))
  call check_last_A_Q(l_switch,G3(:,:,:,340),Q(:,127),MB,G4tensor(:,187))
  call loop_AZ_Q(G3(:,:,:,339),wf(:,50),G3(:,:,:,341),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,341),Q(:,127),MB,G4tensor(:,188))
  call loop_AV_Q(G2(:,:,:,186),wf(:,-4),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,57),MB,G3(:,:,:,342))
  call loop_AV_Q(G3(:,:,:,342),wf(:,-6),G3(:,:,:,343))
  call loop_A_Q(G3(:,:,:,343),Q(:,121),MB,G4(:,:,:,189))
  call loop_AV_Q(G4(:,:,:,189),wf(:,47),G4(:,:,:,190))
  call check_last_A_Q(l_switch,G4(:,:,:,190),Q(:,127),MB,G5tensor(:,133))
  call loop_AZ_Q(G4(:,:,:,189),wf(:,50),G4(:,:,:,191),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,191),Q(:,127),MB,G5tensor(:,134))
  call loop_AV_Q(G2(:,:,:,186),wf(:,-6),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,105),MB,G3(:,:,:,344))
  call loop_AV_Q(G3(:,:,:,344),wf(:,-4),G3(:,:,:,345))
  call loop_A_Q(G3(:,:,:,345),Q(:,121),MB,G4(:,:,:,192))
  call loop_AV_Q(G4(:,:,:,192),wf(:,47),G4(:,:,:,193))
  call check_last_A_Q(l_switch,G4(:,:,:,193),Q(:,127),MB,G5tensor(:,135))
  call loop_AZ_Q(G4(:,:,:,192),wf(:,50),G4(:,:,:,194),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,194),Q(:,127),MB,G5tensor(:,136))
  call loop_AV_Q(G1(:,:,:,46),wf(:,12),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,89),MB,G2(:,:,:,190))
  call loop_AV_Q(G2(:,:,:,190),wf(:,-5),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,121),MB,G3(:,:,:,346))
  call loop_AV_Q(G3(:,:,:,346),wf(:,47),G3(:,:,:,347))
  call check_last_A_Q(l_switch,G3(:,:,:,347),Q(:,127),MB,G4tensor(:,189))
  call loop_AZ_Q(G3(:,:,:,346),wf(:,50),G3(:,:,:,348),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,348),Q(:,127),MB,G4tensor(:,190))
  call loop_AV_Q(G1(:,:,:,46),wf(:,-4),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,25),MB,G2(:,:,:,192))
  call loop_AV_Q(G2(:,:,:,192),wf(:,17),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,121),MB,G3(:,:,:,349))
  call loop_AV_Q(G3(:,:,:,349),wf(:,47),G3(:,:,:,350))
  call check_last_A_Q(l_switch,G3(:,:,:,350),Q(:,127),MB,G4tensor(:,191))
  call loop_AZ_Q(G3(:,:,:,349),wf(:,50),G3(:,:,:,351),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,351),Q(:,127),MB,G4tensor(:,192))
  call loop_AV_Q(G2(:,:,:,192),wf(:,-5),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,57),MB,G3(:,:,:,352))
  call loop_AV_Q(G3(:,:,:,352),wf(:,-6),G3(:,:,:,353))
  call loop_A_Q(G3(:,:,:,353),Q(:,121),MB,G4(:,:,:,195))
  call loop_AV_Q(G4(:,:,:,195),wf(:,47),G4(:,:,:,196))
  call check_last_A_Q(l_switch,G4(:,:,:,196),Q(:,127),MB,G5tensor(:,137))
  call loop_AZ_Q(G4(:,:,:,195),wf(:,50),G4(:,:,:,197),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,197),Q(:,127),MB,G5tensor(:,138))
  call loop_AV_Q(G2(:,:,:,192),wf(:,-6),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,89),MB,G3(:,:,:,354))
  call loop_AV_Q(G3(:,:,:,354),wf(:,-5),G3(:,:,:,355))
  call loop_A_Q(G3(:,:,:,355),Q(:,121),MB,G4(:,:,:,198))
  call loop_AV_Q(G4(:,:,:,198),wf(:,47),G4(:,:,:,199))
  call check_last_A_Q(l_switch,G4(:,:,:,199),Q(:,127),MB,G5tensor(:,139))
  call loop_AZ_Q(G4(:,:,:,198),wf(:,50),G4(:,:,:,200),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,200),Q(:,127),MB,G5tensor(:,140))
  call loop_AV_Q(G1(:,:,:,46),wf(:,17),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,105),MB,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-4),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,121),MB,G3(:,:,:,356))
  call loop_AV_Q(G3(:,:,:,356),wf(:,47),G3(:,:,:,357))
  call check_last_A_Q(l_switch,G3(:,:,:,357),Q(:,127),MB,G4tensor(:,193))
  call loop_AZ_Q(G3(:,:,:,356),wf(:,50),G3(:,:,:,358),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,358),Q(:,127),MB,G4tensor(:,194))
  call loop_QZ_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,9),gZu)
  call loop_Q_A(G0(:,:,:,9),Q(:,9),ZERO,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,-6),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,73),ZERO,G2(:,:,:,198))
  call loop_QV_A(G2(:,:,:,198),wf(:,3),G2(:,:,:,199))
  call loop_Q_A(G2(:,:,:,199),Q(:,121),ZERO,G3(:,:,:,359))
  call loop_QV_A(G3(:,:,:,359),wf(:,47),G3(:,:,:,360))
  call check_last_Q_A(l_switch,G3(:,:,:,360),Q(:,127),ZERO,G4tensor(:,195))
  call loop_QZ_A(G3(:,:,:,359),wf(:,50),G3(:,:,:,361),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,361),Q(:,127),ZERO,G4tensor(:,196))
  call loop_QV_A(G2(:,:,:,198),wf(:,-4),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,89),ZERO,G3(:,:,:,362))
  call loop_QV_A(G3(:,:,:,362),wf(:,-5),G3(:,:,:,363))
  call loop_Q_A(G3(:,:,:,363),Q(:,121),ZERO,G4(:,:,:,201))
  call loop_QV_A(G4(:,:,:,201),wf(:,47),G4(:,:,:,202))
  call check_last_Q_A(l_switch,G4(:,:,:,202),Q(:,127),ZERO,G5tensor(:,141))
  call loop_QZ_A(G4(:,:,:,201),wf(:,50),G4(:,:,:,203),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,203),Q(:,127),ZERO,G5tensor(:,142))
  call loop_QV_A(G2(:,:,:,198),wf(:,-5),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,105),ZERO,G3(:,:,:,364))
  call loop_QV_A(G3(:,:,:,364),wf(:,-4),G3(:,:,:,365))
  call loop_Q_A(G3(:,:,:,365),Q(:,121),ZERO,G4(:,:,:,204))
  call loop_QV_A(G4(:,:,:,204),wf(:,47),G4(:,:,:,205))
  call check_last_Q_A(l_switch,G4(:,:,:,205),Q(:,127),ZERO,G5tensor(:,143))
  call loop_QZ_A(G4(:,:,:,204),wf(:,50),G4(:,:,:,206),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,206),Q(:,127),ZERO,G5tensor(:,144))
  call loop_QV_A(G1(:,:,:,53),wf(:,3),G1(:,:,:,55))
  call loop_Q_A(G1(:,:,:,55),Q(:,57),ZERO,G2(:,:,:,202))
  call loop_QV_A(G2(:,:,:,202),wf(:,-6),G2(:,:,:,203))
  call loop_Q_A(G2(:,:,:,203),Q(:,121),ZERO,G3(:,:,:,366))
  call loop_QV_A(G3(:,:,:,366),wf(:,47),G3(:,:,:,367))
  call check_last_Q_A(l_switch,G3(:,:,:,367),Q(:,127),ZERO,G4tensor(:,197))
  call loop_QZ_A(G3(:,:,:,366),wf(:,50),G3(:,:,:,368),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,368),Q(:,127),ZERO,G4tensor(:,198))
  call loop_QV_A(G1(:,:,:,53),wf(:,-5),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,41),ZERO,G2(:,:,:,204))
  call loop_QV_A(G2(:,:,:,204),wf(:,12),G2(:,:,:,205))
  call loop_Q_A(G2(:,:,:,205),Q(:,121),ZERO,G3(:,:,:,369))
  call loop_QV_A(G3(:,:,:,369),wf(:,47),G3(:,:,:,370))
  call check_last_Q_A(l_switch,G3(:,:,:,370),Q(:,127),ZERO,G4tensor(:,199))
  call loop_QZ_A(G3(:,:,:,369),wf(:,50),G3(:,:,:,371),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,371),Q(:,127),ZERO,G4tensor(:,200))
  call loop_QV_A(G2(:,:,:,204),wf(:,-4),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,57),ZERO,G3(:,:,:,372))
  call loop_QV_A(G3(:,:,:,372),wf(:,-6),G3(:,:,:,373))
  call loop_Q_A(G3(:,:,:,373),Q(:,121),ZERO,G4(:,:,:,207))
  call loop_QV_A(G4(:,:,:,207),wf(:,47),G4(:,:,:,208))
  call check_last_Q_A(l_switch,G4(:,:,:,208),Q(:,127),ZERO,G5tensor(:,145))
  call loop_QZ_A(G4(:,:,:,207),wf(:,50),G4(:,:,:,209),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,209),Q(:,127),ZERO,G5tensor(:,146))
  call loop_QV_A(G2(:,:,:,204),wf(:,-6),G2(:,:,:,207))
  call loop_Q_A(G2(:,:,:,207),Q(:,105),ZERO,G3(:,:,:,374))
  call loop_QV_A(G3(:,:,:,374),wf(:,-4),G3(:,:,:,375))
  call loop_Q_A(G3(:,:,:,375),Q(:,121),ZERO,G4(:,:,:,210))
  call loop_QV_A(G4(:,:,:,210),wf(:,47),G4(:,:,:,211))
  call check_last_Q_A(l_switch,G4(:,:,:,211),Q(:,127),ZERO,G5tensor(:,147))
  call loop_QZ_A(G4(:,:,:,210),wf(:,50),G4(:,:,:,212),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,212),Q(:,127),ZERO,G5tensor(:,148))
  call loop_QV_A(G1(:,:,:,53),wf(:,12),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,89),ZERO,G2(:,:,:,208))
  call loop_QV_A(G2(:,:,:,208),wf(:,-5),G2(:,:,:,209))
  call loop_Q_A(G2(:,:,:,209),Q(:,121),ZERO,G3(:,:,:,376))
  call loop_QV_A(G3(:,:,:,376),wf(:,47),G3(:,:,:,377))
  call check_last_Q_A(l_switch,G3(:,:,:,377),Q(:,127),ZERO,G4tensor(:,201))
  call loop_QZ_A(G3(:,:,:,376),wf(:,50),G3(:,:,:,378),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,378),Q(:,127),ZERO,G4tensor(:,202))
  call loop_QV_A(G1(:,:,:,53),wf(:,-4),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,25),ZERO,G2(:,:,:,210))
  call loop_QV_A(G2(:,:,:,210),wf(:,17),G2(:,:,:,211))
  call loop_Q_A(G2(:,:,:,211),Q(:,121),ZERO,G3(:,:,:,379))
  call loop_QV_A(G3(:,:,:,379),wf(:,47),G3(:,:,:,380))
  call check_last_Q_A(l_switch,G3(:,:,:,380),Q(:,127),ZERO,G4tensor(:,203))
  call loop_QZ_A(G3(:,:,:,379),wf(:,50),G3(:,:,:,381),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,381),Q(:,127),ZERO,G4tensor(:,204))
  call loop_QV_A(G2(:,:,:,210),wf(:,-5),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,57),ZERO,G3(:,:,:,382))
  call loop_QV_A(G3(:,:,:,382),wf(:,-6),G3(:,:,:,383))
  call loop_Q_A(G3(:,:,:,383),Q(:,121),ZERO,G4(:,:,:,213))
  call loop_QV_A(G4(:,:,:,213),wf(:,47),G4(:,:,:,214))
  call check_last_Q_A(l_switch,G4(:,:,:,214),Q(:,127),ZERO,G5tensor(:,149))
  call loop_QZ_A(G4(:,:,:,213),wf(:,50),G4(:,:,:,215),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,215),Q(:,127),ZERO,G5tensor(:,150))
  call loop_QV_A(G2(:,:,:,210),wf(:,-6),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,89),ZERO,G3(:,:,:,384))
  call loop_QV_A(G3(:,:,:,384),wf(:,-5),G3(:,:,:,385))
  call loop_Q_A(G3(:,:,:,385),Q(:,121),ZERO,G4(:,:,:,216))
  call loop_QV_A(G4(:,:,:,216),wf(:,47),G4(:,:,:,217))
  call check_last_Q_A(l_switch,G4(:,:,:,217),Q(:,127),ZERO,G5tensor(:,151))
  call loop_QZ_A(G4(:,:,:,216),wf(:,50),G4(:,:,:,218),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,218),Q(:,127),ZERO,G5tensor(:,152))
  call loop_QV_A(G1(:,:,:,53),wf(:,17),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,105),ZERO,G2(:,:,:,214))
  call loop_QV_A(G2(:,:,:,214),wf(:,-4),G2(:,:,:,215))
  call loop_Q_A(G2(:,:,:,215),Q(:,121),ZERO,G3(:,:,:,386))
  call loop_QV_A(G3(:,:,:,386),wf(:,47),G3(:,:,:,387))
  call check_last_Q_A(l_switch,G3(:,:,:,387),Q(:,127),ZERO,G4tensor(:,205))
  call loop_QZ_A(G3(:,:,:,386),wf(:,50),G3(:,:,:,388),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,388),Q(:,127),ZERO,G4tensor(:,206))
  call loop_QZ_A(G0(:,:,:,1),wf(:,53),G0(:,:,:,10),gZu)
  call loop_Q_A(G0(:,:,:,10),Q(:,9),MT,G1(:,:,:,60))
  call loop_QV_A(G1(:,:,:,60),wf(:,-6),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,73),MT,G2(:,:,:,216))
  call loop_QV_A(G2(:,:,:,216),wf(:,3),G2(:,:,:,217))
  call loop_Q_A(G2(:,:,:,217),Q(:,121),MT,G3(:,:,:,389))
  call loop_QV_A(G3(:,:,:,389),wf(:,47),G3(:,:,:,390))
  call check_last_Q_A(l_switch,G3(:,:,:,390),Q(:,127),MT,G4tensor(:,207))
  call loop_QZ_A(G3(:,:,:,389),wf(:,50),G3(:,:,:,391),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,391),Q(:,127),MT,G4tensor(:,208))
  call loop_QV_A(G2(:,:,:,216),wf(:,-4),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,89),MT,G3(:,:,:,392))
  call loop_QV_A(G3(:,:,:,392),wf(:,-5),G3(:,:,:,393))
  call loop_Q_A(G3(:,:,:,393),Q(:,121),MT,G4(:,:,:,219))
  call loop_QV_A(G4(:,:,:,219),wf(:,47),G4(:,:,:,220))
  call check_last_Q_A(l_switch,G4(:,:,:,220),Q(:,127),MT,G5tensor(:,153))
  call loop_QZ_A(G4(:,:,:,219),wf(:,50),G4(:,:,:,221),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,221),Q(:,127),MT,G5tensor(:,154))
  call loop_QV_A(G2(:,:,:,216),wf(:,-5),G2(:,:,:,219))
  call loop_Q_A(G2(:,:,:,219),Q(:,105),MT,G3(:,:,:,394))
  call loop_QV_A(G3(:,:,:,394),wf(:,-4),G3(:,:,:,395))
  call loop_Q_A(G3(:,:,:,395),Q(:,121),MT,G4(:,:,:,222))
  call loop_QV_A(G4(:,:,:,222),wf(:,47),G4(:,:,:,223))
  call check_last_Q_A(l_switch,G4(:,:,:,223),Q(:,127),MT,G5tensor(:,155))
  call loop_QZ_A(G4(:,:,:,222),wf(:,50),G4(:,:,:,224),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,224),Q(:,127),MT,G5tensor(:,156))
  call loop_QV_A(G1(:,:,:,60),wf(:,3),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,57),MT,G2(:,:,:,220))
  call loop_QV_A(G2(:,:,:,220),wf(:,-6),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,121),MT,G3(:,:,:,396))
  call loop_QV_A(G3(:,:,:,396),wf(:,47),G3(:,:,:,397))
  call check_last_Q_A(l_switch,G3(:,:,:,397),Q(:,127),MT,G4tensor(:,209))
  call loop_QZ_A(G3(:,:,:,396),wf(:,50),G3(:,:,:,398),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,398),Q(:,127),MT,G4tensor(:,210))
  call loop_QV_A(G1(:,:,:,60),wf(:,-5),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,41),MT,G2(:,:,:,222))
  call loop_QV_A(G2(:,:,:,222),wf(:,12),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,121),MT,G3(:,:,:,399))
  call loop_QV_A(G3(:,:,:,399),wf(:,47),G3(:,:,:,400))
  call check_last_Q_A(l_switch,G3(:,:,:,400),Q(:,127),MT,G4tensor(:,211))
  call loop_QZ_A(G3(:,:,:,399),wf(:,50),G3(:,:,:,401),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,401),Q(:,127),MT,G4tensor(:,212))
  call loop_QV_A(G2(:,:,:,222),wf(:,-4),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,57),MT,G3(:,:,:,402))
  call loop_QV_A(G3(:,:,:,402),wf(:,-6),G3(:,:,:,403))
  call loop_Q_A(G3(:,:,:,403),Q(:,121),MT,G4(:,:,:,225))
  call loop_QV_A(G4(:,:,:,225),wf(:,47),G4(:,:,:,226))
  call check_last_Q_A(l_switch,G4(:,:,:,226),Q(:,127),MT,G5tensor(:,157))
  call loop_QZ_A(G4(:,:,:,225),wf(:,50),G4(:,:,:,227),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,227),Q(:,127),MT,G5tensor(:,158))
  call loop_QV_A(G2(:,:,:,222),wf(:,-6),G2(:,:,:,225))
  call loop_Q_A(G2(:,:,:,225),Q(:,105),MT,G3(:,:,:,404))
  call loop_QV_A(G3(:,:,:,404),wf(:,-4),G3(:,:,:,405))
  call loop_Q_A(G3(:,:,:,405),Q(:,121),MT,G4(:,:,:,228))
  call loop_QV_A(G4(:,:,:,228),wf(:,47),G4(:,:,:,229))
  call check_last_Q_A(l_switch,G4(:,:,:,229),Q(:,127),MT,G5tensor(:,159))
  call loop_QZ_A(G4(:,:,:,228),wf(:,50),G4(:,:,:,230),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,230),Q(:,127),MT,G5tensor(:,160))
  call loop_QV_A(G1(:,:,:,60),wf(:,12),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,89),MT,G2(:,:,:,226))
  call loop_QV_A(G2(:,:,:,226),wf(:,-5),G2(:,:,:,227))
  call loop_Q_A(G2(:,:,:,227),Q(:,121),MT,G3(:,:,:,406))
  call loop_QV_A(G3(:,:,:,406),wf(:,47),G3(:,:,:,407))
  call check_last_Q_A(l_switch,G3(:,:,:,407),Q(:,127),MT,G4tensor(:,213))
  call loop_QZ_A(G3(:,:,:,406),wf(:,50),G3(:,:,:,408),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,408),Q(:,127),MT,G4tensor(:,214))
  call loop_QV_A(G1(:,:,:,60),wf(:,-4),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,25),MT,G2(:,:,:,228))
  call loop_QV_A(G2(:,:,:,228),wf(:,17),G2(:,:,:,229))
  call loop_Q_A(G2(:,:,:,229),Q(:,121),MT,G3(:,:,:,409))
  call loop_QV_A(G3(:,:,:,409),wf(:,47),G3(:,:,:,410))
  call check_last_Q_A(l_switch,G3(:,:,:,410),Q(:,127),MT,G4tensor(:,215))
  call loop_QZ_A(G3(:,:,:,409),wf(:,50),G3(:,:,:,411),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,411),Q(:,127),MT,G4tensor(:,216))
  call loop_QV_A(G2(:,:,:,228),wf(:,-5),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,57),MT,G3(:,:,:,412))
  call loop_QV_A(G3(:,:,:,412),wf(:,-6),G3(:,:,:,413))
  call loop_Q_A(G3(:,:,:,413),Q(:,121),MT,G4(:,:,:,231))
  call loop_QV_A(G4(:,:,:,231),wf(:,47),G4(:,:,:,232))
  call check_last_Q_A(l_switch,G4(:,:,:,232),Q(:,127),MT,G5tensor(:,161))
  call loop_QZ_A(G4(:,:,:,231),wf(:,50),G4(:,:,:,233),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,233),Q(:,127),MT,G5tensor(:,162))
  call loop_QV_A(G2(:,:,:,228),wf(:,-6),G2(:,:,:,231))
  call loop_Q_A(G2(:,:,:,231),Q(:,89),MT,G3(:,:,:,414))
  call loop_QV_A(G3(:,:,:,414),wf(:,-5),G3(:,:,:,415))
  call loop_Q_A(G3(:,:,:,415),Q(:,121),MT,G4(:,:,:,234))
  call loop_QV_A(G4(:,:,:,234),wf(:,47),G4(:,:,:,235))
  call check_last_Q_A(l_switch,G4(:,:,:,235),Q(:,127),MT,G5tensor(:,163))
  call loop_QZ_A(G4(:,:,:,234),wf(:,50),G4(:,:,:,236),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,236),Q(:,127),MT,G5tensor(:,164))
  call loop_QV_A(G1(:,:,:,60),wf(:,17),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,105),MT,G2(:,:,:,232))
  call loop_QV_A(G2(:,:,:,232),wf(:,-4),G2(:,:,:,233))
  call loop_Q_A(G2(:,:,:,233),Q(:,121),MT,G3(:,:,:,416))
  call loop_QV_A(G3(:,:,:,416),wf(:,47),G3(:,:,:,417))
  call check_last_Q_A(l_switch,G3(:,:,:,417),Q(:,127),MT,G4tensor(:,217))
  call loop_QZ_A(G3(:,:,:,416),wf(:,50),G3(:,:,:,418),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,418),Q(:,127),MT,G4tensor(:,218))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(12)) * den(206)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(12) * den(206)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(8)) * den(206)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(8) * den(206)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(14) * den(207)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,4),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(14)) * den(207)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,4),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(11)) * den(207)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,6),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(11) * den(207)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,6),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(14) * den(208)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,2),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(14)) * den(208)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,2),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(11)) * den(208)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,3),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(11) * den(208)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,3),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(15)) * den(209)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,5),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(15) * den(209)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,5),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(15)) * den(209)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,7),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(15) * den(209)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,7),T4sum(1:70,19))
  M(1) = M(1) + (f(21) * den(4)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,15),T5sum(1:126,10))
  M(1) = M(1) + (f(17) * den(4)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,15),T5sum(1:126,10))
  M(1) = M(1) + (-f(23) * den(7)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,18),T5sum(1:126,10))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,20),T5sum(1:126,10))
  M(1) = M(1) + (-f(23) * den(10)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,16),T5sum(1:126,10))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,17),T5sum(1:126,10))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,19),T5sum(1:126,10))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,21),T5sum(1:126,10))
  M(2) = M(2) + (f(21) * den(4)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,29),T5sum(1:126,22))
  M(2) = M(2) + (f(17) * den(4)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,29),T5sum(1:126,22))
  M(2) = M(2) + (-f(23) * den(7)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,32),T5sum(1:126,22))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,34),T5sum(1:126,22))
  M(2) = M(2) + (-f(23) * den(10)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,30),T5sum(1:126,22))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,31),T5sum(1:126,22))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,33),T5sum(1:126,22))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,35),T5sum(1:126,22))
  M(2) = M(2) + (f(21) * den(4)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,1),T5sum(1:126,31))
  M(2) = M(2) + (f(17) * den(4)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,1),T5sum(1:126,31))
  M(2) = M(2) + (-f(23) * den(7)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,7),T5sum(1:126,31))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,11),T5sum(1:126,31))
  M(2) = M(2) + (-f(23) * den(10)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,2),T5sum(1:126,31))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,3),T5sum(1:126,31))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,8),T5sum(1:126,31))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,12),T5sum(1:126,31))
  M(1) = M(1) + (f(21) * den(4)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,4),T5sum(1:126,34))
  M(1) = M(1) + (f(17) * den(4)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,4),T5sum(1:126,34))
  M(1) = M(1) + (-f(23) * den(7)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,9),T5sum(1:126,34))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,13),T5sum(1:126,34))
  M(1) = M(1) + (-f(23) * den(10)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,5),T5sum(1:126,34))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,6),T5sum(1:126,34))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,10),T5sum(1:126,34))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,14),T5sum(1:126,34))
  M(1) = M(1) + (CI*f(14) * den(226)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(226)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(226)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(226)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(227)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(227)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(227)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(227)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(228)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(228)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(228)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(228)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(229)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(229)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(229)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(229)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(230)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(230)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(230)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(230)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(231)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,8),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(231)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,8),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(231)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,9),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(231)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,9),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(232)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(232)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(232)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(232)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(233)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,11),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(233)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,11),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(233)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,12),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(233)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,12),T3sum(1:35,9))
  M(1) = M(1) + (-f(23) * den(165)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,8),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(165)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,8),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(167)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,9),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(167)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,10),T4sum(1:70,35))
  M(1) = M(1) + (-f(23) * den(168)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,11),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(168)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,11),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(169)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,12),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(169)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,13),T4sum(1:70,35))
  M(2) = M(2) + (-f(23) * den(165)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,56),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(165)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,56),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(167)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,57),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(167)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,58),T4sum(1:70,36))
  M(2) = M(2) + (-f(23) * den(168)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,59),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(168)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,59),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(169)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,60),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(169)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,61),T4sum(1:70,36))
  M(1) = M(1) + (-f(23) * den(170)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,14),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(170)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,14),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(171)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,15),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(171)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,16),T4sum(1:70,35))
  M(1) = M(1) + (-f(23) * den(172)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,17),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(172)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,17),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(173)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,18),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(173)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,19),T4sum(1:70,35))
  M(2) = M(2) + (-f(23) * den(170)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,62),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(170)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,62),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(171)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,63),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(171)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,64),T4sum(1:70,36))
  M(2) = M(2) + (-f(23) * den(172)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,65),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(172)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,65),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(173)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,66),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(173)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,67),T4sum(1:70,36))
  M(1) = M(1) + (CI*f(12) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,111),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(12)) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,111),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(10) * den(234)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,129),T4sum(1:70,41))
  M(2) = M(2) + (-(CI*f(10)) * den(234)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,129),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(12) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,141),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(12)) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,141),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(10) * den(234)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,159),T4sum(1:70,41))
  M(2) = M(2) + (-(CI*f(10)) * den(234)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,159),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(8) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,111),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(8)) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,111),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(7) * den(234)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,171),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(7)) * den(234)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,171),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(8) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,141),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(8)) * den(234)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,141),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(7) * den(234)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,183),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(7)) * den(234)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,183),T4sum(1:70,42))
  M(1) = M(1) + (-(CI*f(14)) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,112),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(14) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,112),T4sum(1:70,40))
  M(1) = M(1) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,130),T4sum(1:70,41))
  M(2) = M(2) + (CI*f(11) * den(235)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,130),T4sum(1:70,41))
  M(1) = M(1) + (-(CI*f(14)) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,142),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(14) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,142),T4sum(1:70,40))
  M(1) = M(1) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,160),T4sum(1:70,41))
  M(2) = M(2) + (CI*f(11) * den(235)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,160),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(11) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,113),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,113),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(9) * den(235)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,172),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(9)) * den(235)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,172),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(11) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,143),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,143),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(9) * den(235)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,184),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(9)) * den(235)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,184),T4sum(1:70,42))
  M(1) = M(1) + (-(CI*f(14)) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,195),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(14) * den(236)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,195),T4sum(1:70,40))
  M(1) = M(1) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,207),T4sum(1:70,41))
  M(2) = M(2) + (CI*f(11) * den(236)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,207),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,196),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,196),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,208),T4sum(1:70,41))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,208),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(12) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,144),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(12)) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,144),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(10) * den(234)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,161),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(10)) * den(234)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,161),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(12) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,114),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(12)) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,114),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(10) * den(234)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,131),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(10)) * den(234)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,131),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(8) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,144),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(8)) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,144),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(7) * den(234)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,185),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(7)) * den(234)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,185),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(8) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,114),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(8)) * den(234)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,114),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(7) * den(234)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,173),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(7)) * den(234)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,173),T4sum(1:70,45))
  M(1) = M(1) + (-(CI*f(14)) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,145),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(14) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,145),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,162),T4sum(1:70,44))
  M(2) = M(2) + (CI*f(11) * den(235)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,162),T4sum(1:70,44))
  M(1) = M(1) + (-(CI*f(14)) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,115),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(14) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,115),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,132),T4sum(1:70,44))
  M(2) = M(2) + (CI*f(11) * den(235)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,132),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(11) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,146),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,146),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(9) * den(235)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,186),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(9)) * den(235)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,186),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(11) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,116),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(11)) * den(235)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,116),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(9) * den(235)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,174),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(9)) * den(235)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,174),T4sum(1:70,45))
  M(1) = M(1) + (-(CI*f(14)) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,197),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(14) * den(236)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,197),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(11)) * den(236)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,209),T4sum(1:70,44))
  M(2) = M(2) + (CI*f(11) * den(236)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,209),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(15) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,198),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(15)) * den(237)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,198),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(13) * den(237)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,210),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(13)) * den(237)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,210),T4sum(1:70,44))
  M(1) = M(1) + (-(CI*f(12)) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,117),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(12) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,117),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(10)) * den(238)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,133),T4sum(1:70,50))
  M(2) = M(2) + (CI*f(10) * den(238)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,133),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(12)) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,147),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(12) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,147),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(10)) * den(238)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,163),T4sum(1:70,50))
  M(2) = M(2) + (CI*f(10) * den(238)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,163),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(8)) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,117),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(8) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,117),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(7)) * den(238)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,175),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(7) * den(238)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,175),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(8)) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,147),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(8) * den(238)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,147),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(7)) * den(238)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,187),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(7) * den(238)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,187),T4sum(1:70,51))
  M(1) = M(1) + (CI*f(14) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,118),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(14)) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,118),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(11) * den(239)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,134),T4sum(1:70,50))
  M(2) = M(2) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,134),T4sum(1:70,50))
  M(1) = M(1) + (CI*f(14) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,148),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(14)) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,148),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(11) * den(239)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,164),T4sum(1:70,50))
  M(2) = M(2) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,164),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,119),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(11) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,119),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(9)) * den(239)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,176),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(9) * den(239)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,176),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,149),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(11) * den(239)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,149),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(9)) * den(239)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,188),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(9) * den(239)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,188),T4sum(1:70,51))
  M(1) = M(1) + (CI*f(14) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,199),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(14)) * den(240)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,199),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(11) * den(240)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,211),T4sum(1:70,50))
  M(2) = M(2) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,211),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,200),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,200),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,212),T4sum(1:70,50))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,212),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(12)) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,150),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(12) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,150),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(10)) * den(238)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,165),T4sum(1:70,53))
  M(2) = M(2) + (CI*f(10) * den(238)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,165),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(12)) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,120),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(12) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,120),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(10)) * den(238)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,135),T4sum(1:70,53))
  M(2) = M(2) + (CI*f(10) * den(238)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,135),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(8)) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,150),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(8) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,150),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(7)) * den(238)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,189),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(7) * den(238)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,189),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(8)) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,120),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(8) * den(238)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,120),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(7)) * den(238)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,177),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(7) * den(238)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,177),T4sum(1:70,54))
  M(1) = M(1) + (CI*f(14) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,151),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(14)) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,151),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(11) * den(239)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,166),T4sum(1:70,53))
  M(2) = M(2) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,166),T4sum(1:70,53))
  M(1) = M(1) + (CI*f(14) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,121),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(14)) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,121),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(11) * den(239)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,136),T4sum(1:70,53))
  M(2) = M(2) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,136),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,152),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(11) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,152),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(9)) * den(239)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,190),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(9) * den(239)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,190),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,122),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(11) * den(239)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,122),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(9)) * den(239)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,178),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(9) * den(239)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,178),T4sum(1:70,54))
  M(1) = M(1) + (CI*f(14) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,201),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(14)) * den(240)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,201),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(11) * den(240)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,213),T4sum(1:70,53))
  M(2) = M(2) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,213),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,202),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,202),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,214),T4sum(1:70,53))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,214),T4sum(1:70,53))
  M(1) = M(1) + (CI*f(12) * den(242)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,104),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(12)) * den(242)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,104),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(8) * den(242)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,104),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(8)) * den(242)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,104),T4sum(1:70,55))
  M(1) = M(1) + (-(CI*f(14)) * den(243)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,105),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(14) * den(243)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,105),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(11) * den(243)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,106),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,106),T4sum(1:70,55))
  M(1) = M(1) + (-(CI*f(14)) * den(244)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,107),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(14) * den(244)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,107),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(11) * den(244)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,109),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,109),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,108),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,108),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,110),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,110),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(12) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,123),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(12)) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,123),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(10) * den(242)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,137),T4sum(1:70,59))
  M(2) = M(2) + (-(CI*f(10)) * den(242)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,137),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(12) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,153),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(12)) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,153),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(10) * den(242)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,167),T4sum(1:70,59))
  M(2) = M(2) + (-(CI*f(10)) * den(242)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,167),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(8) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,123),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(8)) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,123),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(7) * den(242)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,179),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(7)) * den(242)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,179),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(8) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,153),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(8)) * den(242)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,153),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(7) * den(242)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,191),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(7)) * den(242)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,191),T4sum(1:70,60))
  M(1) = M(1) + (-(CI*f(14)) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,124),T4sum(1:70,58))
  M(2) = M(2) + (CI*f(14) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,124),T4sum(1:70,58))
  M(1) = M(1) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,138),T4sum(1:70,59))
  M(2) = M(2) + (CI*f(11) * den(243)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,138),T4sum(1:70,59))
  M(1) = M(1) + (-(CI*f(14)) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,154),T4sum(1:70,58))
  M(2) = M(2) + (CI*f(14) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,154),T4sum(1:70,58))
  M(1) = M(1) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,168),T4sum(1:70,59))
  M(2) = M(2) + (CI*f(11) * den(243)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,168),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(11) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,125),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,125),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(9) * den(243)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,180),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(9)) * den(243)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,180),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(11) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,155),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,155),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(9) * den(243)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,192),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(9)) * den(243)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,192),T4sum(1:70,60))
  M(1) = M(1) + (-(CI*f(14)) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,203),T4sum(1:70,58))
  M(2) = M(2) + (CI*f(14) * den(244)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,203),T4sum(1:70,58))
  M(1) = M(1) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,215),T4sum(1:70,59))
  M(2) = M(2) + (CI*f(11) * den(244)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,215),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,204),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,204),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,216),T4sum(1:70,59))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,216),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(12) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,156),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(12)) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,156),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(10) * den(242)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,169),T4sum(1:70,62))
  M(2) = M(2) + (-(CI*f(10)) * den(242)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,169),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(12) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,126),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(12)) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,126),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(10) * den(242)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,139),T4sum(1:70,62))
  M(2) = M(2) + (-(CI*f(10)) * den(242)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,139),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(8) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,156),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(8)) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,156),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(7) * den(242)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,193),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(7)) * den(242)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,193),T4sum(1:70,63))
  M(1) = M(1) + (CI*f(8) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,126),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(8)) * den(242)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,126),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(7) * den(242)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,181),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(7)) * den(242)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,181),T4sum(1:70,63))
  M(1) = M(1) + (-(CI*f(14)) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,157),T4sum(1:70,61))
  M(2) = M(2) + (CI*f(14) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,157),T4sum(1:70,61))
  M(1) = M(1) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,170),T4sum(1:70,62))
  M(2) = M(2) + (CI*f(11) * den(243)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,170),T4sum(1:70,62))
  M(1) = M(1) + (-(CI*f(14)) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,127),T4sum(1:70,61))
  M(2) = M(2) + (CI*f(14) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,127),T4sum(1:70,61))
  M(1) = M(1) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,140),T4sum(1:70,62))
  M(2) = M(2) + (CI*f(11) * den(243)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,140),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(11) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,158),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,158),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(9) * den(243)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,194),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(9)) * den(243)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,194),T4sum(1:70,63))
  M(1) = M(1) + (CI*f(11) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,128),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,128),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(9) * den(243)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,182),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(9)) * den(243)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,182),T4sum(1:70,63))
  M(1) = M(1) + (-(CI*f(14)) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,205),T4sum(1:70,61))
  M(2) = M(2) + (CI*f(14) * den(244)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,205),T4sum(1:70,61))
  M(1) = M(1) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,217),T4sum(1:70,62))
  M(2) = M(2) + (CI*f(11) * den(244)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,217),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(15) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,206),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(15)) * den(245)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,206),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,218),T4sum(1:70,62))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,218),T4sum(1:70,62))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,63),T5sum(1:126,37))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,79),T5sum(1:126,38))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,93),T5sum(1:126,37))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,109),T5sum(1:126,38))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,63),T5sum(1:126,37))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,121),T5sum(1:126,39))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,93),T5sum(1:126,37))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,133),T5sum(1:126,39))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,64),T5sum(1:126,37))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,80),T5sum(1:126,38))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,94),T5sum(1:126,37))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,110),T5sum(1:126,38))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,65),T5sum(1:126,37))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,122),T5sum(1:126,39))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,95),T5sum(1:126,37))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,134),T5sum(1:126,39))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,145),T5sum(1:126,37))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,157),T5sum(1:126,38))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,146),T5sum(1:126,37))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,158),T5sum(1:126,38))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,87),T5sum(1:126,40))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,105),T5sum(1:126,41))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,57),T5sum(1:126,40))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,75),T5sum(1:126,41))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,87),T5sum(1:126,40))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,129),T5sum(1:126,42))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,57),T5sum(1:126,40))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,117),T5sum(1:126,42))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,88),T5sum(1:126,40))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,106),T5sum(1:126,41))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,58),T5sum(1:126,40))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,76),T5sum(1:126,41))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,89),T5sum(1:126,40))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,130),T5sum(1:126,42))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,59),T5sum(1:126,40))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,118),T5sum(1:126,42))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,141),T5sum(1:126,40))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,153),T5sum(1:126,41))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,142),T5sum(1:126,40))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,154),T5sum(1:126,41))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,99),T5sum(1:126,43))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,113),T5sum(1:126,44))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,69),T5sum(1:126,43))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,83),T5sum(1:126,44))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,99),T5sum(1:126,43))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,137),T5sum(1:126,45))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,69),T5sum(1:126,43))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,125),T5sum(1:126,45))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,100),T5sum(1:126,43))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,114),T5sum(1:126,44))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,70),T5sum(1:126,43))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,84),T5sum(1:126,44))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,101),T5sum(1:126,43))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,138),T5sum(1:126,45))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,71),T5sum(1:126,43))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,126),T5sum(1:126,45))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,149),T5sum(1:126,43))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,161),T5sum(1:126,44))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,150),T5sum(1:126,43))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,162),T5sum(1:126,44))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,60),T5sum(1:126,49))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,77),T5sum(1:126,50))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,90),T5sum(1:126,49))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,107),T5sum(1:126,50))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,60),T5sum(1:126,49))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,119),T5sum(1:126,51))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,90),T5sum(1:126,49))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,131),T5sum(1:126,51))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,61),T5sum(1:126,49))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,78),T5sum(1:126,50))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,91),T5sum(1:126,49))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,108),T5sum(1:126,50))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,62),T5sum(1:126,49))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,120),T5sum(1:126,51))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,92),T5sum(1:126,49))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,132),T5sum(1:126,51))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,143),T5sum(1:126,49))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,155),T5sum(1:126,50))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,144),T5sum(1:126,49))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,156),T5sum(1:126,50))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,22),T5sum(1:126,52))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,22),T5sum(1:126,52))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,23),T5sum(1:126,52))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,24),T5sum(1:126,52))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,25),T5sum(1:126,52))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,27),T5sum(1:126,52))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,26),T5sum(1:126,52))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,28),T5sum(1:126,52))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,102),T5sum(1:126,55))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,115),T5sum(1:126,56))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,72),T5sum(1:126,55))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,85),T5sum(1:126,56))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,102),T5sum(1:126,55))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,139),T5sum(1:126,57))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,72),T5sum(1:126,55))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,127),T5sum(1:126,57))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,103),T5sum(1:126,55))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,116),T5sum(1:126,56))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,73),T5sum(1:126,55))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,86),T5sum(1:126,56))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,104),T5sum(1:126,55))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,140),T5sum(1:126,57))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,74),T5sum(1:126,55))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,128),T5sum(1:126,57))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,151),T5sum(1:126,55))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,163),T5sum(1:126,56))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,152),T5sum(1:126,55))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,164),T5sum(1:126,56))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,66),T5sum(1:126,61))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,81),T5sum(1:126,62))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,96),T5sum(1:126,61))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,111),T5sum(1:126,62))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,66),T5sum(1:126,61))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,123),T5sum(1:126,63))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,96),T5sum(1:126,61))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,135),T5sum(1:126,63))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,67),T5sum(1:126,61))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,82),T5sum(1:126,62))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,97),T5sum(1:126,61))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,112),T5sum(1:126,62))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,68),T5sum(1:126,61))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,124),T5sum(1:126,63))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,98),T5sum(1:126,61))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,136),T5sum(1:126,63))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,147),T5sum(1:126,61))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,159),T5sum(1:126,62))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,148),T5sum(1:126,61))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,160),T5sum(1:126,62))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,36),T5sum(1:126,64))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,36),T5sum(1:126,64))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,37),T5sum(1:126,64))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,38),T5sum(1:126,64))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,39),T5sum(1:126,64))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,41),T5sum(1:126,64))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,40),T5sum(1:126,64))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,42),T5sum(1:126,64))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,43),T5sum(1:126,67))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,43),T5sum(1:126,67))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,44),T5sum(1:126,67))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,45),T5sum(1:126,67))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,49),T5sum(1:126,67))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,53),T5sum(1:126,67))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,50),T5sum(1:126,67))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,54),T5sum(1:126,67))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,46),T5sum(1:126,70))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,46),T5sum(1:126,70))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,47),T5sum(1:126,70))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,48),T5sum(1:126,70))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,51),T5sum(1:126,70))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,55),T5sum(1:126,70))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,52),T5sum(1:126,70))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,56),T5sum(1:126,70))
  M(1) = M(1) + (-(CI*f(14)) * den(262)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(262)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(262)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(262)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(263)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(263)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(263)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(263)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(264)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(264)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(264)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(264)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(265)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(265)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(265)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(265)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(266)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(266)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(266)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(266)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(267)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(267)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(267)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(267)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(268)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(268)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(268)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(268)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(269)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(269)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(269)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(269)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(1) = M(1) + (f(23) * den(174)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,20),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(174)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,20),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(175)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,21),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(175)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,22),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(176)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,23),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(176)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,23),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(177)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,24),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(177)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,25),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(174)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,68),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(174)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,68),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(175)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,69),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(175)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,70),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(176)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,71),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(176)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,71),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(177)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,72),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(177)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,73),T4sum(1:70,36))
  M(1) = M(1) + (f(23) * den(178)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,26),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(178)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,26),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(179)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,27),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(179)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,27),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(180)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,28),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(180)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,29),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(181)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,30),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(181)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,31),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(178)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,74),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(178)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,74),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(179)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,75),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(179)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,75),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(180)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,76),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(180)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,77),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(181)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,78),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(181)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,79),T4sum(1:70,36))
  M(1) = M(1) + (-(CI*f(14)) * den(286)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(286)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(286)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(286)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(287)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(287)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(287)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(287)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(288)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(288)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(288)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(288)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(289)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(289)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(289)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(289)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(290)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(290)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(290)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(290)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(291)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(291)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(291)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(291)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(292)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(292)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(292)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(292)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(293)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(293)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(293)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(293)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,9))
  M(1) = M(1) + (f(23) * den(182)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,32),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(182)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,32),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(183)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,33),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(183)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,34),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(184)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,35),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(184)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,35),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(185)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,36),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(185)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,37),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(182)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,80),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(182)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,80),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(183)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,81),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(183)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,82),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(184)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,83),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(184)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,83),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(185)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,84),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(185)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,85),T4sum(1:70,36))
  M(1) = M(1) + (f(23) * den(186)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,38),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(186)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,38),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(187)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,39),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(187)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,40),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(188)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,41),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(188)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,41),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(189)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,42),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(189)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,43),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(186)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,86),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(186)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,86),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(187)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,87),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(187)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,88),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(188)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,89),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(188)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,89),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(189)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,90),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(189)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,91),T4sum(1:70,36))
  M(1) = M(1) + (CI*f(14) * den(310)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(310)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(310)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(310)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(311)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(311)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(311)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(311)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(312)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(312)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(312)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(312)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(313)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(313)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(313)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(313)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(314)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(314)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(314)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(314)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(315)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(315)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(315)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(11) * den(315)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(316)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(316)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(316)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(316)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(317)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(317)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(317)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(317)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(1) = M(1) + (-f(23) * den(190)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,44),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(190)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,44),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(191)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,45),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(191)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,46),T4sum(1:70,35))
  M(1) = M(1) + (-f(23) * den(192)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,47),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(192)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,47),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(193)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,48),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(193)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,49),T4sum(1:70,35))
  M(2) = M(2) + (-f(23) * den(190)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,92),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(190)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,92),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(191)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,93),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(191)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,94),T4sum(1:70,36))
  M(2) = M(2) + (-f(23) * den(192)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,95),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(192)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,95),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(193)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,96),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(193)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,97),T4sum(1:70,36))
  M(1) = M(1) + (-f(23) * den(194)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,50),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(194)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,50),T4sum(1:70,35))
  M(1) = M(1) + (-f(23) * den(195)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,51),T4sum(1:70,35))
  M(1) = M(1) + (f(20) * den(195)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,51),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(196)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,52),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(196)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,53),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(197)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,54),T4sum(1:70,35))
  M(1) = M(1) + (f(24) * den(197)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,55),T4sum(1:70,35))
  M(2) = M(2) + (-f(23) * den(194)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,98),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(194)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,98),T4sum(1:70,36))
  M(2) = M(2) + (-f(23) * den(195)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,99),T4sum(1:70,36))
  M(2) = M(2) + (f(20) * den(195)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,99),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(196)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,100),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(196)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,101),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(197)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,102),T4sum(1:70,36))
  M(2) = M(2) + (f(24) * den(197)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,103),T4sum(1:70,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_6

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_6_ppllllj2_eeexexggg_1_/**/REALKIND
