
module ol_vamp_4_ppllllj2_eexmmxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eexmmxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eexmmxggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eexmmxggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eexmmxggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,2) :: G0
  complex(REALKIND), dimension(4,5,4,7) :: G1
  complex(REALKIND), dimension(4,15,4,47) :: G2
  complex(REALKIND), dimension(4,35,4,84) :: G3
  complex(REALKIND), dimension(4,70,4,40) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,24,128))
    allocate(G4tensorhel(70,55,128))
    allocate(G5tensorhel(126,28,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,17),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,124),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),ZERO,G4tensor(:,2))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-6),G2(:,:,:,3))
  call loop_A_Q(G2(:,:,:,3),Q(:,92),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-5),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-5),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,60),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-6),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,124),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,1),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,9),G4(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,7),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,9),G4(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,28),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,17),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,124),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),ZERO,G4tensor(:,4))
  call loop_AZ_Q(G3(:,:,:,9),wf(:,9),G3(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-6),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,92),ZERO,G3(:,:,:,12))
  call loop_AV_Q(G3(:,:,:,12),wf(:,-5),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,124),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,1),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,9),G4(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-5),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,60),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,-6),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,124),ZERO,G4(:,:,:,12))
  call loop_AV_Q(G4(:,:,:,12),wf(:,1),G4(:,:,:,13))
  call check_last_A_Q(l_switch,G4(:,:,:,13),Q(:,127),ZERO,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,12),wf(:,9),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,28),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,17),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,124),ZERO,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,1),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AZ_Q(G3(:,:,:,16),wf(:,9),G3(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),ZERO,G4tensor(:,7))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-6),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,92),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-5),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,124),ZERO,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,1),G4(:,:,:,16))
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),ZERO,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,9),G4(:,:,:,17),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),ZERO,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,60),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-6),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,124),ZERO,G4(:,:,:,18))
  call loop_AV_Q(G4(:,:,:,18),wf(:,1),G4(:,:,:,19))
  call check_last_A_Q(l_switch,G4(:,:,:,19),Q(:,127),ZERO,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,18),wf(:,9),G4(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),ZERO,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,48),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,60),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-6),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,124),ZERO,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,1),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),ZERO,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,9),G4(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),ZERO,G5tensor(:,16))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,9),G4(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),ZERO,G5tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,6),G2(:,:,:,15),gZu)
  call loop_A_Q(G2(:,:,:,15),Q(:,60),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,-6),G3(:,:,:,26))
  call loop_A_Q(G3(:,:,:,26),Q(:,124),ZERO,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),ZERO,G5tensor(:,18))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,9),G4(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,127),ZERO,G5tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,6),G2(:,:,:,16),gZd)
  call loop_A_Q(G2(:,:,:,16),Q(:,60),ZERO,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,-6),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,124),ZERO,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,1),G4(:,:,:,29))
  call check_last_A_Q(l_switch,G4(:,:,:,29),Q(:,127),ZERO,G5tensor(:,20))
  call loop_AZ_Q(G4(:,:,:,28),wf(:,9),G4(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),ZERO,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-6),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,112),ZERO,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,86),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,87),G3(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,87),G3(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AV_Q(G3(:,:,:,29),wf(:,88),G3(:,:,:,33))
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,89),G3(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,89),G3(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AV_Q(G3(:,:,:,29),wf(:,90),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,91),G3(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,127),ZERO,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,91),G3(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),ZERO,G4tensor(:,16))
  call loop_AV_Q(G3(:,:,:,29),wf(:,92),G3(:,:,:,39))
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),ZERO,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,93),G3(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,93),G3(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),ZERO,G4tensor(:,19))
  call loop_AV_Q(G3(:,:,:,29),wf(:,94),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),ZERO,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,95),G3(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,95),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),ZERO,G4tensor(:,22))
  call loop_AV_Q(G3(:,:,:,29),wf(:,96),G3(:,:,:,45))
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,97),G3(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),ZERO,G4tensor(:,24))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,97),G3(:,:,:,47),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),ZERO,G4tensor(:,25))
  call loop_AV_Q(G3(:,:,:,29),wf(:,98),G3(:,:,:,48))
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),ZERO,G4tensor(:,26))
  call loop_AV_Q(G3(:,:,:,29),wf(:,99),G3(:,:,:,49))
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,127),ZERO,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,100),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),ZERO,G4tensor(:,28))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,100),G3(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,127),ZERO,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,101),G3(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,127),ZERO,G4tensor(:,30))
  call loop_AZ_Q(G3(:,:,:,29),wf(:,101),G3(:,:,:,53),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,127),ZERO,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,80),ZERO,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,2),G2(:,:,:,19))
  call loop_A_Q(G2(:,:,:,19),Q(:,92),ZERO,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-5),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,124),ZERO,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,1),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,22))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,9),G4(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,33),Q(:,127),ZERO,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,9),G4(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,127),ZERO,G5tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,18),wf(:,6),G2(:,:,:,20),gZu)
  call loop_A_Q(G2(:,:,:,20),Q(:,92),ZERO,G3(:,:,:,56))
  call loop_AV_Q(G3(:,:,:,56),wf(:,-5),G3(:,:,:,57))
  call loop_A_Q(G3(:,:,:,57),Q(:,124),ZERO,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,1),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,25))
  call loop_AZ_Q(G4(:,:,:,35),wf(:,9),G4(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,37),Q(:,127),ZERO,G5tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,18),wf(:,6),G2(:,:,:,21),gZd)
  call loop_A_Q(G2(:,:,:,21),Q(:,92),ZERO,G3(:,:,:,58))
  call loop_AV_Q(G3(:,:,:,58),wf(:,-5),G3(:,:,:,59))
  call loop_A_Q(G3(:,:,:,59),Q(:,124),ZERO,G4(:,:,:,38))
  call loop_AV_Q(G4(:,:,:,38),wf(:,1),G4(:,:,:,39))
  call check_last_A_Q(l_switch,G4(:,:,:,39),Q(:,127),ZERO,G5tensor(:,27))
  call loop_AZ_Q(G4(:,:,:,38),wf(:,9),G4(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,127),ZERO,G5tensor(:,28))
  call loop_AV_Q(G2(:,:,:,18),wf(:,-5),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,112),ZERO,G3(:,:,:,60))
  call loop_AV_Q(G3(:,:,:,60),wf(:,86),G3(:,:,:,61))
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),ZERO,G4tensor(:,32))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,87),G3(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),ZERO,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,87),G3(:,:,:,63),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,127),ZERO,G4tensor(:,34))
  call loop_AV_Q(G3(:,:,:,60),wf(:,88),G3(:,:,:,64))
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),ZERO,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,89),G3(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,65),Q(:,127),ZERO,G4tensor(:,36))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,89),G3(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,37))
  call loop_AV_Q(G3(:,:,:,60),wf(:,90),G3(:,:,:,67))
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,127),ZERO,G4tensor(:,38))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,91),G3(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),ZERO,G4tensor(:,39))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,91),G3(:,:,:,69),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,69),Q(:,127),ZERO,G4tensor(:,40))
  call loop_AV_Q(G3(:,:,:,60),wf(:,92),G3(:,:,:,70))
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,127),ZERO,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,93),G3(:,:,:,71),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,71),Q(:,127),ZERO,G4tensor(:,42))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,93),G3(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,127),ZERO,G4tensor(:,43))
  call loop_AV_Q(G3(:,:,:,60),wf(:,94),G3(:,:,:,73))
  call check_last_A_Q(l_switch,G3(:,:,:,73),Q(:,127),ZERO,G4tensor(:,44))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,95),G3(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),ZERO,G4tensor(:,45))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,95),G3(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,127),ZERO,G4tensor(:,46))
  call loop_AV_Q(G3(:,:,:,60),wf(:,96),G3(:,:,:,76))
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),ZERO,G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,97),G3(:,:,:,77),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,77),Q(:,127),ZERO,G4tensor(:,48))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,97),G3(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,127),ZERO,G4tensor(:,49))
  call loop_AV_Q(G3(:,:,:,60),wf(:,98),G3(:,:,:,79))
  call check_last_A_Q(l_switch,G3(:,:,:,79),Q(:,127),ZERO,G4tensor(:,50))
  call loop_AV_Q(G3(:,:,:,60),wf(:,99),G3(:,:,:,80))
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,127),ZERO,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,100),G3(:,:,:,81),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,81),Q(:,127),ZERO,G4tensor(:,52))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,100),G3(:,:,:,82),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,127),ZERO,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,101),G3(:,:,:,83),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,83),Q(:,127),ZERO,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,60),wf(:,101),G3(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,127),ZERO,G4tensor(:,55))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,112),ZERO,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,86),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,87),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,87),G2(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,23),wf(:,88),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,89),G2(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),ZERO,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,89),G2(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),ZERO,G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,23),wf(:,90),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),ZERO,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,91),G2(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),ZERO,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,91),G2(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),ZERO,G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,23),wf(:,92),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),ZERO,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,93),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),ZERO,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,93),G2(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),ZERO,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,23),wf(:,94),G2(:,:,:,36))
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,127),ZERO,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,95),G2(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,127),ZERO,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,95),G2(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,127),ZERO,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,23),wf(:,96),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,127),ZERO,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,97),G2(:,:,:,40),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,127),ZERO,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,97),G2(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,127),ZERO,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,23),wf(:,98),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,127),ZERO,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,23),wf(:,99),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,127),ZERO,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,100),G2(:,:,:,44),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,127),ZERO,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,100),G2(:,:,:,45),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,127),ZERO,G3tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,101),G2(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,127),ZERO,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,101),G2(:,:,:,47),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,127),ZERO,G3tensor(:,24))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(12) * den(118)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(12)) * den(118)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(8) * den(118)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(8)) * den(118)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,1),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(14)) * den(119)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,4),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(14) * den(119)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,4),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(11) * den(119)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,6),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(11)) * den(119)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,6),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(14)) * den(120)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,2),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(14) * den(120)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,2),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(11) * den(120)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,3),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(11)) * den(120)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,3),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,5),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,5),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(15) * den(121)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,7),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(15)) * den(121)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,7),T4sum(1:70,19))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,15),T5sum(1:126,10))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,15),T5sum(1:126,10))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,18),T5sum(1:126,10))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,20),T5sum(1:126,10))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,16),T5sum(1:126,10))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,17),T5sum(1:126,10))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,19),T5sum(1:126,10))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,21),T5sum(1:126,10))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,22),T5sum(1:126,22))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,22),T5sum(1:126,22))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,25),T5sum(1:126,22))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,27),T5sum(1:126,22))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,23),T5sum(1:126,22))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,24),T5sum(1:126,22))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,26),T5sum(1:126,22))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,28),T5sum(1:126,22))
  M(2) = M(2) + (-f(21) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,1),T5sum(1:126,31))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,1),T5sum(1:126,31))
  M(2) = M(2) + (f(23) * den(7)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,7),T5sum(1:126,31))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,11),T5sum(1:126,31))
  M(2) = M(2) + (f(23) * den(10)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,2),T5sum(1:126,31))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,3),T5sum(1:126,31))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,8),T5sum(1:126,31))
  M(2) = M(2) + (-f(24) * den(12)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,12),T5sum(1:126,31))
  M(1) = M(1) + (-f(21) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,4),T5sum(1:126,34))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,4),T5sum(1:126,34))
  M(1) = M(1) + (f(23) * den(7)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,9),T5sum(1:126,34))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,13),T5sum(1:126,34))
  M(1) = M(1) + (f(23) * den(10)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,5),T5sum(1:126,34))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,6),T5sum(1:126,34))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,10),T5sum(1:126,34))
  M(1) = M(1) + (-f(24) * den(12)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,14),T5sum(1:126,34))
  M(1) = M(1) + (-(CI*f(14)) * den(138)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(138)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(138)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(138)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,1),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(139)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(139)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,2),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(139)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(139)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,3),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(140)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(140)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(140)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(140)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,4),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,7),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,8),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,8),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,9),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,9),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(144)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(144)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(144)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(144)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(145)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,11),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(145)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,11),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(145)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,12),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(145)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,12),T3sum(1:35,9))
  M(1) = M(1) + (f(23) * den(93)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,8),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(93)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,8),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(95)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,9),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(95)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,10),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(96)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,11),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(96)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,11),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(97)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,12),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(97)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,13),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(93)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,32),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(93)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,32),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(95)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,33),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(95)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,34),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(96)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,35),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(96)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,35),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(97)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,36),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(97)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,37),T4sum(1:70,36))
  M(1) = M(1) + (f(23) * den(98)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,14),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(98)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,14),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(99)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,15),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(99)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,16),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(100)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,17),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(100)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,17),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(101)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,18),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(101)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,19),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(98)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,38),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(98)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,38),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(99)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,39),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(99)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,40),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(100)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,41),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(100)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,41),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(101)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,42),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(101)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,43),T4sum(1:70,36))
  M(1) = M(1) + (-(CI*f(14)) * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(162)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(163)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(163)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(163)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(163)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,15),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(164)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(164)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(164)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(164)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,16),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(165)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(165)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(165)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(165)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(166)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(166)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(166)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(166)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(14)) * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(14) * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(11) * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(11)) * den(167)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(168)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(15)) * den(169)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(1) = M(1) + (f(23) * den(102)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,20),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(102)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,20),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(103)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,21),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(103)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,22),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(104)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,23),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(104)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,23),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(105)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,24),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(105)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,25),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(102)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,44),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(102)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,44),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(103)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,45),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(103)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,46),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(104)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,47),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(104)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,47),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(105)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,48),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(105)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,49),T4sum(1:70,36))
  M(1) = M(1) + (f(23) * den(106)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,26),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(106)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,26),T4sum(1:70,35))
  M(1) = M(1) + (f(23) * den(107)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,27),T4sum(1:70,35))
  M(1) = M(1) + (-f(20) * den(107)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,27),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(108)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,28),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(108)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,29),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(109)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,30),T4sum(1:70,35))
  M(1) = M(1) + (-f(24) * den(109)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,31),T4sum(1:70,35))
  M(2) = M(2) + (f(23) * den(106)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,50),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(106)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,50),T4sum(1:70,36))
  M(2) = M(2) + (f(23) * den(107)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,51),T4sum(1:70,36))
  M(2) = M(2) + (-f(20) * den(107)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,51),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(108)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,52),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(108)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,53),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(109)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,54),T4sum(1:70,36))
  M(2) = M(2) + (-f(24) * den(109)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,55),T4sum(1:70,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_4_ppllllj2_eexmmxggg_1_/**/REALKIND
