
module ol_vamp_4_ppllllj2_eeexexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eeexexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eeexexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eeexexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eeexexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,4) :: G0
  complex(REALKIND), dimension(4,5,4,24) :: G1
  complex(REALKIND), dimension(4,15,4,189) :: G2
  complex(REALKIND), dimension(4,35,4,342) :: G3
  complex(REALKIND), dimension(4,70,4,144) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,102,128))
    allocate(G4tensorhel(70,228,128))
    allocate(G5tensorhel(126,96,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,17),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,94),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,129),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,130),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,131),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,132),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,1),wf(:,133),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,134),G2(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,1),wf(:,135),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,136),G2(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_AS_Q(G2(:,:,:,1),wf(:,110),G2(:,:,:,11),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,1),wf(:,137),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,127),MT,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,138),G2(:,:,:,13),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,127),MT,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,1),wf(:,139),G2(:,:,:,14))
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),MT,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,140),G2(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,127),MT,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,1),wf(:,141),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,1),wf(:,142),G2(:,:,:,17))
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,143),G2(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MT,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,144),G2(:,:,:,19),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MT,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,1),wf(:,145),G2(:,:,:,20))
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MT,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,146),G2(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,127),MT,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,1),wf(:,147),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,127),MT,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,148),G2(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,1),wf(:,149),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,150),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MT,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,1),wf(:,151),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,152),G2(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,1),wf(:,153),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,154),G2(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,1),wf(:,155),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,156),G2(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,1),wf(:,157),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,1),wf(:,158),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,159),G2(:,:,:,34),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,160),G2(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,26),MT,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,17),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,122),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),MT,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-6),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,90),MT,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,-5),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,122),MT,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),MT,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),MT,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-5),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,58),MT,G3(:,:,:,6))
  call loop_AV_Q(G3(:,:,:,6),wf(:,-6),G3(:,:,:,7))
  call loop_A_Q(G3(:,:,:,7),Q(:,122),MT,G4(:,:,:,4))
  call loop_AV_Q(G4(:,:,:,4),wf(:,1),G4(:,:,:,5))
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,127),MT,G5tensor(:,3))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,9),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),MT,G5tensor(:,4))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZu)
  call loop_A_Q(G1(:,:,:,4),Q(:,26),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,17),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,122),MT,G3(:,:,:,8))
  call loop_AV_Q(G3(:,:,:,8),wf(:,1),G3(:,:,:,9))
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,8),wf(:,9),G3(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),MT,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-6),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,90),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-5),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,122),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,1),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),MT,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,9),G4(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,127),MT,G5tensor(:,6))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-5),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,58),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-6),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,122),MT,G4(:,:,:,10))
  call loop_AV_Q(G4(:,:,:,10),wf(:,1),G4(:,:,:,11))
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),MT,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,9),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),MT,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,48),MT,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-6),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,112),MT,G3(:,:,:,15))
  call loop_AS_Q(G3(:,:,:,15),wf(:,94),G3(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),MT,G4tensor(:,5))
  call loop_AV_Q(G3(:,:,:,15),wf(:,129),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,127),MT,G4tensor(:,6))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,130),G3(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),MT,G4tensor(:,7))
  call loop_AV_Q(G3(:,:,:,15),wf(:,131),G3(:,:,:,19))
  call check_last_A_Q(l_switch,G3(:,:,:,19),Q(:,127),MT,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,132),G3(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MT,G4tensor(:,9))
  call loop_AV_Q(G3(:,:,:,15),wf(:,133),G3(:,:,:,21))
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),MT,G4tensor(:,10))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,134),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),MT,G4tensor(:,11))
  call loop_AV_Q(G3(:,:,:,15),wf(:,135),G3(:,:,:,23))
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),MT,G4tensor(:,12))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,136),G3(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MT,G4tensor(:,13))
  call loop_AS_Q(G3(:,:,:,15),wf(:,110),G3(:,:,:,25),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),MT,G4tensor(:,14))
  call loop_AV_Q(G3(:,:,:,15),wf(:,137),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),MT,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,138),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),MT,G4tensor(:,16))
  call loop_AV_Q(G3(:,:,:,15),wf(:,139),G3(:,:,:,28))
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),MT,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,140),G3(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),MT,G4tensor(:,18))
  call loop_AV_Q(G3(:,:,:,15),wf(:,141),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),MT,G4tensor(:,19))
  call loop_AV_Q(G3(:,:,:,15),wf(:,142),G3(:,:,:,31))
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),MT,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,143),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),MT,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,144),G3(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),MT,G4tensor(:,22))
  call loop_AV_Q(G3(:,:,:,15),wf(:,145),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),MT,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,146),G3(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),MT,G4tensor(:,24))
  call loop_AV_Q(G3(:,:,:,15),wf(:,147),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),MT,G4tensor(:,25))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,148),G3(:,:,:,37),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,127),MT,G4tensor(:,26))
  call loop_AV_Q(G3(:,:,:,15),wf(:,149),G3(:,:,:,38))
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MT,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,150),G3(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),MT,G4tensor(:,28))
  call loop_AV_Q(G3(:,:,:,15),wf(:,151),G3(:,:,:,40))
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),MT,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,152),G3(:,:,:,41),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),MT,G4tensor(:,30))
  call loop_AV_Q(G3(:,:,:,15),wf(:,153),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),MT,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,154),G3(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),MT,G4tensor(:,32))
  call loop_AV_Q(G3(:,:,:,15),wf(:,155),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),MT,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,156),G3(:,:,:,45),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),MT,G4tensor(:,34))
  call loop_AV_Q(G3(:,:,:,15),wf(:,157),G3(:,:,:,46))
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),MT,G4tensor(:,35))
  call loop_AV_Q(G3(:,:,:,15),wf(:,158),G3(:,:,:,47))
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),MT,G4tensor(:,36))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,159),G3(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),MT,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,160),G3(:,:,:,49),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,127),MT,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,44),wf(:,2),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,58),MT,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,-6),G3(:,:,:,51))
  call loop_A_Q(G3(:,:,:,51),Q(:,122),MT,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,1),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),MT,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,9),G4(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,127),MT,G5tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,6),G2(:,:,:,47),gZu)
  call loop_A_Q(G2(:,:,:,47),Q(:,58),MT,G3(:,:,:,52))
  call loop_AV_Q(G3(:,:,:,52),wf(:,-6),G3(:,:,:,53))
  call loop_A_Q(G3(:,:,:,53),Q(:,122),MT,G4(:,:,:,16))
  call loop_AV_Q(G4(:,:,:,16),wf(:,1),G4(:,:,:,17))
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),MT,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,9),G4(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),MT,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,44),wf(:,46),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,57),MT,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-6),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,121),MT,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,47),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,50),G4(:,:,:,21),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,21),Q(:,127),MT,G5tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,44),wf(:,53),G2(:,:,:,49),gZu)
  call loop_A_Q(G2(:,:,:,49),Q(:,57),MT,G3(:,:,:,56))
  call loop_AV_Q(G3(:,:,:,56),wf(:,-6),G3(:,:,:,57))
  call loop_A_Q(G3(:,:,:,57),Q(:,121),MT,G4(:,:,:,22))
  call loop_AV_Q(G4(:,:,:,22),wf(:,47),G4(:,:,:,23))
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),MT,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,22),wf(:,50),G4(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,80),MT,G2(:,:,:,50))
  call loop_AV_Q(G2(:,:,:,50),wf(:,-5),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,112),MT,G3(:,:,:,58))
  call loop_AS_Q(G3(:,:,:,58),wf(:,94),G3(:,:,:,59),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,127),MT,G4tensor(:,39))
  call loop_AV_Q(G3(:,:,:,58),wf(:,129),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MT,G4tensor(:,40))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,130),G3(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),MT,G4tensor(:,41))
  call loop_AV_Q(G3(:,:,:,58),wf(:,131),G3(:,:,:,62))
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),MT,G4tensor(:,42))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,132),G3(:,:,:,63),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,63),Q(:,127),MT,G4tensor(:,43))
  call loop_AV_Q(G3(:,:,:,58),wf(:,133),G3(:,:,:,64))
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,127),MT,G4tensor(:,44))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,134),G3(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,65),Q(:,127),MT,G4tensor(:,45))
  call loop_AV_Q(G3(:,:,:,58),wf(:,135),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,127),MT,G4tensor(:,46))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,136),G3(:,:,:,67),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,127),MT,G4tensor(:,47))
  call loop_AS_Q(G3(:,:,:,58),wf(:,110),G3(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,127),MT,G4tensor(:,48))
  call loop_AV_Q(G3(:,:,:,58),wf(:,137),G3(:,:,:,69))
  call check_last_A_Q(l_switch,G3(:,:,:,69),Q(:,127),MT,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,138),G3(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,127),MT,G4tensor(:,50))
  call loop_AV_Q(G3(:,:,:,58),wf(:,139),G3(:,:,:,71))
  call check_last_A_Q(l_switch,G3(:,:,:,71),Q(:,127),MT,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,140),G3(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,52))
  call loop_AV_Q(G3(:,:,:,58),wf(:,141),G3(:,:,:,73))
  call check_last_A_Q(l_switch,G3(:,:,:,73),Q(:,127),MT,G4tensor(:,53))
  call loop_AV_Q(G3(:,:,:,58),wf(:,142),G3(:,:,:,74))
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,127),MT,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,143),G3(:,:,:,75),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,127),MT,G4tensor(:,55))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,144),G3(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,127),MT,G4tensor(:,56))
  call loop_AV_Q(G3(:,:,:,58),wf(:,145),G3(:,:,:,77))
  call check_last_A_Q(l_switch,G3(:,:,:,77),Q(:,127),MT,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,146),G3(:,:,:,78),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,127),MT,G4tensor(:,58))
  call loop_AV_Q(G3(:,:,:,58),wf(:,147),G3(:,:,:,79))
  call check_last_A_Q(l_switch,G3(:,:,:,79),Q(:,127),MT,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,148),G3(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,127),MT,G4tensor(:,60))
  call loop_AV_Q(G3(:,:,:,58),wf(:,149),G3(:,:,:,81))
  call check_last_A_Q(l_switch,G3(:,:,:,81),Q(:,127),MT,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,150),G3(:,:,:,82),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,127),MT,G4tensor(:,62))
  call loop_AV_Q(G3(:,:,:,58),wf(:,151),G3(:,:,:,83))
  call check_last_A_Q(l_switch,G3(:,:,:,83),Q(:,127),MT,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,152),G3(:,:,:,84),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,127),MT,G4tensor(:,64))
  call loop_AV_Q(G3(:,:,:,58),wf(:,153),G3(:,:,:,85))
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,127),MT,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,154),G3(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,127),MT,G4tensor(:,66))
  call loop_AV_Q(G3(:,:,:,58),wf(:,155),G3(:,:,:,87))
  call check_last_A_Q(l_switch,G3(:,:,:,87),Q(:,127),MT,G4tensor(:,67))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,156),G3(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,127),MT,G4tensor(:,68))
  call loop_AV_Q(G3(:,:,:,58),wf(:,157),G3(:,:,:,89))
  call check_last_A_Q(l_switch,G3(:,:,:,89),Q(:,127),MT,G4tensor(:,69))
  call loop_AV_Q(G3(:,:,:,58),wf(:,158),G3(:,:,:,90))
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,127),MT,G4tensor(:,70))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,159),G3(:,:,:,91),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,91),Q(:,127),MT,G4tensor(:,71))
  call loop_AZ_Q(G3(:,:,:,58),wf(:,160),G3(:,:,:,92),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),MT,G4tensor(:,72))
  call loop_AV_Q(G2(:,:,:,50),wf(:,2),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,90),MT,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,-5),G3(:,:,:,94))
  call loop_A_Q(G3(:,:,:,94),Q(:,122),MT,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MT,G5tensor(:,17))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,9),G4(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,127),MT,G5tensor(:,18))
  call loop_AZ_Q(G2(:,:,:,50),wf(:,6),G2(:,:,:,53),gZu)
  call loop_A_Q(G2(:,:,:,53),Q(:,90),MT,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-5),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,122),MT,G4(:,:,:,28))
  call loop_AV_Q(G4(:,:,:,28),wf(:,1),G4(:,:,:,29))
  call check_last_A_Q(l_switch,G4(:,:,:,29),Q(:,127),MT,G5tensor(:,19))
  call loop_AZ_Q(G4(:,:,:,28),wf(:,9),G4(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),MT,G5tensor(:,20))
  call loop_AV_Q(G2(:,:,:,50),wf(:,46),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,89),MT,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-5),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,121),MT,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,47),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,127),MT,G5tensor(:,21))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,50),G4(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,33),Q(:,127),MT,G5tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,50),wf(:,53),G2(:,:,:,55),gZu)
  call loop_A_Q(G2(:,:,:,55),Q(:,89),MT,G3(:,:,:,99))
  call loop_AV_Q(G3(:,:,:,99),wf(:,-5),G3(:,:,:,100))
  call loop_A_Q(G3(:,:,:,100),Q(:,121),MT,G4(:,:,:,34))
  call loop_AV_Q(G4(:,:,:,34),wf(:,47),G4(:,:,:,35))
  call check_last_A_Q(l_switch,G4(:,:,:,35),Q(:,127),MT,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,34),wf(:,50),G4(:,:,:,36),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),MT,G5tensor(:,24))
  call loop_AV_Q(G1(:,:,:,1),wf(:,46),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,25),MT,G2(:,:,:,56))
  call loop_AV_Q(G2(:,:,:,56),wf(:,17),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,121),MT,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,47),G3(:,:,:,102))
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,127),MT,G4tensor(:,73))
  call loop_AZ_Q(G3(:,:,:,101),wf(:,50),G3(:,:,:,103),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,127),MT,G4tensor(:,74))
  call loop_AV_Q(G2(:,:,:,56),wf(:,-5),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,57),MT,G3(:,:,:,104))
  call loop_AV_Q(G3(:,:,:,104),wf(:,-6),G3(:,:,:,105))
  call loop_A_Q(G3(:,:,:,105),Q(:,121),MT,G4(:,:,:,37))
  call loop_AV_Q(G4(:,:,:,37),wf(:,47),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,127),MT,G5tensor(:,25))
  call loop_AZ_Q(G4(:,:,:,37),wf(:,50),G4(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,39),Q(:,127),MT,G5tensor(:,26))
  call loop_AV_Q(G2(:,:,:,56),wf(:,-6),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,89),MT,G3(:,:,:,106))
  call loop_AV_Q(G3(:,:,:,106),wf(:,-5),G3(:,:,:,107))
  call loop_A_Q(G3(:,:,:,107),Q(:,121),MT,G4(:,:,:,40))
  call loop_AV_Q(G4(:,:,:,40),wf(:,47),G4(:,:,:,41))
  call check_last_A_Q(l_switch,G4(:,:,:,41),Q(:,127),MT,G5tensor(:,27))
  call loop_AZ_Q(G4(:,:,:,40),wf(:,50),G4(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,127),MT,G5tensor(:,28))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,53),G1(:,:,:,8),gZu)
  call loop_A_Q(G1(:,:,:,8),Q(:,25),MT,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,17),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,121),MT,G3(:,:,:,108))
  call loop_AV_Q(G3(:,:,:,108),wf(:,47),G3(:,:,:,109))
  call check_last_A_Q(l_switch,G3(:,:,:,109),Q(:,127),MT,G4tensor(:,75))
  call loop_AZ_Q(G3(:,:,:,108),wf(:,50),G3(:,:,:,110),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),MT,G4tensor(:,76))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-5),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,57),MT,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-6),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,121),MT,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,47),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,127),MT,G5tensor(:,29))
  call loop_AZ_Q(G4(:,:,:,43),wf(:,50),G4(:,:,:,45),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,45),Q(:,127),MT,G5tensor(:,30))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-6),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,89),MT,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,-5),G3(:,:,:,114))
  call loop_A_Q(G3(:,:,:,114),Q(:,121),MT,G4(:,:,:,46))
  call loop_AV_Q(G4(:,:,:,46),wf(:,47),G4(:,:,:,47))
  call check_last_A_Q(l_switch,G4(:,:,:,47),Q(:,127),MT,G5tensor(:,31))
  call loop_AZ_Q(G4(:,:,:,46),wf(:,50),G4(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,127),MT,G5tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,17),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,112),MT,G2(:,:,:,64))
  call loop_QS_A(G2(:,:,:,64),wf(:,94),G2(:,:,:,65),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,65),Q(:,127),MT,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,64),wf(:,129),G2(:,:,:,66))
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,127),MT,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,64),wf(:,130),G2(:,:,:,67),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,127),MT,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,64),wf(:,131),G2(:,:,:,68))
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,127),MT,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,64),wf(:,132),G2(:,:,:,69),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,127),MT,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,64),wf(:,133),G2(:,:,:,70))
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,127),MT,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,64),wf(:,134),G2(:,:,:,71),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,127),MT,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,64),wf(:,135),G2(:,:,:,72))
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,127),MT,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,64),wf(:,136),G2(:,:,:,73),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,127),MT,G3tensor(:,43))
  call loop_QS_A(G2(:,:,:,64),wf(:,110),G2(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,127),MT,G3tensor(:,44))
  call loop_QV_A(G2(:,:,:,64),wf(:,137),G2(:,:,:,75))
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,127),MT,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,64),wf(:,138),G2(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,127),MT,G3tensor(:,46))
  call loop_QV_A(G2(:,:,:,64),wf(:,139),G2(:,:,:,77))
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,127),MT,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,64),wf(:,140),G2(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,127),MT,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,64),wf(:,141),G2(:,:,:,79))
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,127),MT,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,64),wf(:,142),G2(:,:,:,80))
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,127),MT,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,64),wf(:,143),G2(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,127),MT,G3tensor(:,51))
  call loop_QZ_A(G2(:,:,:,64),wf(:,144),G2(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,127),MT,G3tensor(:,52))
  call loop_QV_A(G2(:,:,:,64),wf(:,145),G2(:,:,:,83))
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,127),MT,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,64),wf(:,146),G2(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,127),MT,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,64),wf(:,147),G2(:,:,:,85))
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,127),MT,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,64),wf(:,148),G2(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,127),MT,G3tensor(:,56))
  call loop_QV_A(G2(:,:,:,64),wf(:,149),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,127),MT,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,64),wf(:,150),G2(:,:,:,88),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,127),MT,G3tensor(:,58))
  call loop_QV_A(G2(:,:,:,64),wf(:,151),G2(:,:,:,89))
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,127),MT,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,64),wf(:,152),G2(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,127),MT,G3tensor(:,60))
  call loop_QV_A(G2(:,:,:,64),wf(:,153),G2(:,:,:,91))
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,127),MT,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,64),wf(:,154),G2(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,127),MT,G3tensor(:,62))
  call loop_QV_A(G2(:,:,:,64),wf(:,155),G2(:,:,:,93))
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,127),MT,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,64),wf(:,156),G2(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,127),MT,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,157),G2(:,:,:,95))
  call check_last_Q_A(l_switch,G2(:,:,:,95),Q(:,127),MT,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,64),wf(:,158),G2(:,:,:,96))
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,127),MT,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,64),wf(:,159),G2(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,127),MT,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,64),wf(:,160),G2(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,98),Q(:,127),MT,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,26),MT,G2(:,:,:,99))
  call loop_QV_A(G2(:,:,:,99),wf(:,17),G2(:,:,:,100))
  call loop_Q_A(G2(:,:,:,100),Q(:,122),MT,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,1),G3(:,:,:,116))
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,127),MT,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,115),wf(:,9),G3(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,117),Q(:,127),MT,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,99),wf(:,-6),G2(:,:,:,101))
  call loop_Q_A(G2(:,:,:,101),Q(:,90),MT,G3(:,:,:,118))
  call loop_QV_A(G3(:,:,:,118),wf(:,-5),G3(:,:,:,119))
  call loop_Q_A(G3(:,:,:,119),Q(:,122),MT,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,1),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),MT,G5tensor(:,33))
  call loop_QZ_A(G4(:,:,:,49),wf(:,9),G4(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,51),Q(:,127),MT,G5tensor(:,34))
  call loop_QV_A(G2(:,:,:,99),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,58),MT,G3(:,:,:,120))
  call loop_QV_A(G3(:,:,:,120),wf(:,-6),G3(:,:,:,121))
  call loop_Q_A(G3(:,:,:,121),Q(:,122),MT,G4(:,:,:,52))
  call loop_QV_A(G4(:,:,:,52),wf(:,1),G4(:,:,:,53))
  call check_last_Q_A(l_switch,G4(:,:,:,53),Q(:,127),MT,G5tensor(:,35))
  call loop_QZ_A(G4(:,:,:,52),wf(:,9),G4(:,:,:,54),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),MT,G5tensor(:,36))
  call loop_QZ_A(G1(:,:,:,9),wf(:,6),G1(:,:,:,12),gZu)
  call loop_Q_A(G1(:,:,:,12),Q(:,26),MT,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,17),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,122),MT,G3(:,:,:,122))
  call loop_QV_A(G3(:,:,:,122),wf(:,1),G3(:,:,:,123))
  call check_last_Q_A(l_switch,G3(:,:,:,123),Q(:,127),MT,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,122),wf(:,9),G3(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),MT,G4tensor(:,80))
  call loop_QV_A(G2(:,:,:,103),wf(:,-6),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,90),MT,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-5),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,122),MT,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,1),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),MT,G5tensor(:,37))
  call loop_QZ_A(G4(:,:,:,55),wf(:,9),G4(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,57),Q(:,127),MT,G5tensor(:,38))
  call loop_QV_A(G2(:,:,:,103),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,58),MT,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,-6),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,122),MT,G4(:,:,:,58))
  call loop_QV_A(G4(:,:,:,58),wf(:,1),G4(:,:,:,59))
  call check_last_Q_A(l_switch,G4(:,:,:,59),Q(:,127),MT,G5tensor(:,39))
  call loop_QZ_A(G4(:,:,:,58),wf(:,9),G4(:,:,:,60),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),MT,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,9),wf(:,-5),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,48),MT,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-6),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,112),MT,G3(:,:,:,129))
  call loop_QS_A(G3(:,:,:,129),wf(:,94),G3(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,127),MT,G4tensor(:,81))
  call loop_QV_A(G3(:,:,:,129),wf(:,129),G3(:,:,:,131))
  call check_last_Q_A(l_switch,G3(:,:,:,131),Q(:,127),MT,G4tensor(:,82))
  call loop_QZ_A(G3(:,:,:,129),wf(:,130),G3(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,127),MT,G4tensor(:,83))
  call loop_QV_A(G3(:,:,:,129),wf(:,131),G3(:,:,:,133))
  call check_last_Q_A(l_switch,G3(:,:,:,133),Q(:,127),MT,G4tensor(:,84))
  call loop_QZ_A(G3(:,:,:,129),wf(:,132),G3(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,127),MT,G4tensor(:,85))
  call loop_QV_A(G3(:,:,:,129),wf(:,133),G3(:,:,:,135))
  call check_last_Q_A(l_switch,G3(:,:,:,135),Q(:,127),MT,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,129),wf(:,134),G3(:,:,:,136),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,127),MT,G4tensor(:,87))
  call loop_QV_A(G3(:,:,:,129),wf(:,135),G3(:,:,:,137))
  call check_last_Q_A(l_switch,G3(:,:,:,137),Q(:,127),MT,G4tensor(:,88))
  call loop_QZ_A(G3(:,:,:,129),wf(:,136),G3(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,127),MT,G4tensor(:,89))
  call loop_QS_A(G3(:,:,:,129),wf(:,110),G3(:,:,:,139),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,127),MT,G4tensor(:,90))
  call loop_QV_A(G3(:,:,:,129),wf(:,137),G3(:,:,:,140))
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),MT,G4tensor(:,91))
  call loop_QZ_A(G3(:,:,:,129),wf(:,138),G3(:,:,:,141),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,141),Q(:,127),MT,G4tensor(:,92))
  call loop_QV_A(G3(:,:,:,129),wf(:,139),G3(:,:,:,142))
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),MT,G4tensor(:,93))
  call loop_QZ_A(G3(:,:,:,129),wf(:,140),G3(:,:,:,143),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,127),MT,G4tensor(:,94))
  call loop_QV_A(G3(:,:,:,129),wf(:,141),G3(:,:,:,144))
  call check_last_Q_A(l_switch,G3(:,:,:,144),Q(:,127),MT,G4tensor(:,95))
  call loop_QV_A(G3(:,:,:,129),wf(:,142),G3(:,:,:,145))
  call check_last_Q_A(l_switch,G3(:,:,:,145),Q(:,127),MT,G4tensor(:,96))
  call loop_QZ_A(G3(:,:,:,129),wf(:,143),G3(:,:,:,146),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,127),MT,G4tensor(:,97))
  call loop_QZ_A(G3(:,:,:,129),wf(:,144),G3(:,:,:,147),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,147),Q(:,127),MT,G4tensor(:,98))
  call loop_QV_A(G3(:,:,:,129),wf(:,145),G3(:,:,:,148))
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,127),MT,G4tensor(:,99))
  call loop_QZ_A(G3(:,:,:,129),wf(:,146),G3(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,127),MT,G4tensor(:,100))
  call loop_QV_A(G3(:,:,:,129),wf(:,147),G3(:,:,:,150))
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,127),MT,G4tensor(:,101))
  call loop_QZ_A(G3(:,:,:,129),wf(:,148),G3(:,:,:,151),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,151),Q(:,127),MT,G4tensor(:,102))
  call loop_QV_A(G3(:,:,:,129),wf(:,149),G3(:,:,:,152))
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),MT,G4tensor(:,103))
  call loop_QZ_A(G3(:,:,:,129),wf(:,150),G3(:,:,:,153),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,127),MT,G4tensor(:,104))
  call loop_QV_A(G3(:,:,:,129),wf(:,151),G3(:,:,:,154))
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,127),MT,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,129),wf(:,152),G3(:,:,:,155),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,127),MT,G4tensor(:,106))
  call loop_QV_A(G3(:,:,:,129),wf(:,153),G3(:,:,:,156))
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,127),MT,G4tensor(:,107))
  call loop_QZ_A(G3(:,:,:,129),wf(:,154),G3(:,:,:,157),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,157),Q(:,127),MT,G4tensor(:,108))
  call loop_QV_A(G3(:,:,:,129),wf(:,155),G3(:,:,:,158))
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,127),MT,G4tensor(:,109))
  call loop_QZ_A(G3(:,:,:,129),wf(:,156),G3(:,:,:,159),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,159),Q(:,127),MT,G4tensor(:,110))
  call loop_QV_A(G3(:,:,:,129),wf(:,157),G3(:,:,:,160))
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,127),MT,G4tensor(:,111))
  call loop_QV_A(G3(:,:,:,129),wf(:,158),G3(:,:,:,161))
  call check_last_Q_A(l_switch,G3(:,:,:,161),Q(:,127),MT,G4tensor(:,112))
  call loop_QZ_A(G3(:,:,:,129),wf(:,159),G3(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,127),MT,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,129),wf(:,160),G3(:,:,:,163),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,163),Q(:,127),MT,G4tensor(:,114))
  call loop_QV_A(G2(:,:,:,107),wf(:,2),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,58),MT,G3(:,:,:,164))
  call loop_QV_A(G3(:,:,:,164),wf(:,-6),G3(:,:,:,165))
  call loop_Q_A(G3(:,:,:,165),Q(:,122),MT,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,1),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),MT,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,61),wf(:,9),G4(:,:,:,63),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,63),Q(:,127),MT,G5tensor(:,42))
  call loop_QZ_A(G2(:,:,:,107),wf(:,6),G2(:,:,:,110),gZu)
  call loop_Q_A(G2(:,:,:,110),Q(:,58),MT,G3(:,:,:,166))
  call loop_QV_A(G3(:,:,:,166),wf(:,-6),G3(:,:,:,167))
  call loop_Q_A(G3(:,:,:,167),Q(:,122),MT,G4(:,:,:,64))
  call loop_QV_A(G4(:,:,:,64),wf(:,1),G4(:,:,:,65))
  call check_last_Q_A(l_switch,G4(:,:,:,65),Q(:,127),MT,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,64),wf(:,9),G4(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,127),MT,G5tensor(:,44))
  call loop_QV_A(G2(:,:,:,107),wf(:,46),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,57),MT,G3(:,:,:,168))
  call loop_QV_A(G3(:,:,:,168),wf(:,-6),G3(:,:,:,169))
  call loop_Q_A(G3(:,:,:,169),Q(:,121),MT,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,47),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),MT,G5tensor(:,45))
  call loop_QZ_A(G4(:,:,:,67),wf(:,50),G4(:,:,:,69),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,69),Q(:,127),MT,G5tensor(:,46))
  call loop_QZ_A(G2(:,:,:,107),wf(:,53),G2(:,:,:,112),gZu)
  call loop_Q_A(G2(:,:,:,112),Q(:,57),MT,G3(:,:,:,170))
  call loop_QV_A(G3(:,:,:,170),wf(:,-6),G3(:,:,:,171))
  call loop_Q_A(G3(:,:,:,171),Q(:,121),MT,G4(:,:,:,70))
  call loop_QV_A(G4(:,:,:,70),wf(:,47),G4(:,:,:,71))
  call check_last_Q_A(l_switch,G4(:,:,:,71),Q(:,127),MT,G5tensor(:,47))
  call loop_QZ_A(G4(:,:,:,70),wf(:,50),G4(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),MT,G5tensor(:,48))
  call loop_QV_A(G1(:,:,:,9),wf(:,-6),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,80),MT,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,-5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,112),MT,G3(:,:,:,172))
  call loop_QS_A(G3(:,:,:,172),wf(:,94),G3(:,:,:,173),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,173),Q(:,127),MT,G4tensor(:,115))
  call loop_QV_A(G3(:,:,:,172),wf(:,129),G3(:,:,:,174))
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,127),MT,G4tensor(:,116))
  call loop_QZ_A(G3(:,:,:,172),wf(:,130),G3(:,:,:,175),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,175),Q(:,127),MT,G4tensor(:,117))
  call loop_QV_A(G3(:,:,:,172),wf(:,131),G3(:,:,:,176))
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),MT,G4tensor(:,118))
  call loop_QZ_A(G3(:,:,:,172),wf(:,132),G3(:,:,:,177),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,177),Q(:,127),MT,G4tensor(:,119))
  call loop_QV_A(G3(:,:,:,172),wf(:,133),G3(:,:,:,178))
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),MT,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,172),wf(:,134),G3(:,:,:,179),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,179),Q(:,127),MT,G4tensor(:,121))
  call loop_QV_A(G3(:,:,:,172),wf(:,135),G3(:,:,:,180))
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),MT,G4tensor(:,122))
  call loop_QZ_A(G3(:,:,:,172),wf(:,136),G3(:,:,:,181),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,181),Q(:,127),MT,G4tensor(:,123))
  call loop_QS_A(G3(:,:,:,172),wf(:,110),G3(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,127),MT,G4tensor(:,124))
  call loop_QV_A(G3(:,:,:,172),wf(:,137),G3(:,:,:,183))
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,127),MT,G4tensor(:,125))
  call loop_QZ_A(G3(:,:,:,172),wf(:,138),G3(:,:,:,184),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,127),MT,G4tensor(:,126))
  call loop_QV_A(G3(:,:,:,172),wf(:,139),G3(:,:,:,185))
  call check_last_Q_A(l_switch,G3(:,:,:,185),Q(:,127),MT,G4tensor(:,127))
  call loop_QZ_A(G3(:,:,:,172),wf(:,140),G3(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),MT,G4tensor(:,128))
  call loop_QV_A(G3(:,:,:,172),wf(:,141),G3(:,:,:,187))
  call check_last_Q_A(l_switch,G3(:,:,:,187),Q(:,127),MT,G4tensor(:,129))
  call loop_QV_A(G3(:,:,:,172),wf(:,142),G3(:,:,:,188))
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),MT,G4tensor(:,130))
  call loop_QZ_A(G3(:,:,:,172),wf(:,143),G3(:,:,:,189),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),MT,G4tensor(:,131))
  call loop_QZ_A(G3(:,:,:,172),wf(:,144),G3(:,:,:,190),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),MT,G4tensor(:,132))
  call loop_QV_A(G3(:,:,:,172),wf(:,145),G3(:,:,:,191))
  call check_last_Q_A(l_switch,G3(:,:,:,191),Q(:,127),MT,G4tensor(:,133))
  call loop_QZ_A(G3(:,:,:,172),wf(:,146),G3(:,:,:,192),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,127),MT,G4tensor(:,134))
  call loop_QV_A(G3(:,:,:,172),wf(:,147),G3(:,:,:,193))
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,127),MT,G4tensor(:,135))
  call loop_QZ_A(G3(:,:,:,172),wf(:,148),G3(:,:,:,194),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),MT,G4tensor(:,136))
  call loop_QV_A(G3(:,:,:,172),wf(:,149),G3(:,:,:,195))
  call check_last_Q_A(l_switch,G3(:,:,:,195),Q(:,127),MT,G4tensor(:,137))
  call loop_QZ_A(G3(:,:,:,172),wf(:,150),G3(:,:,:,196),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,127),MT,G4tensor(:,138))
  call loop_QV_A(G3(:,:,:,172),wf(:,151),G3(:,:,:,197))
  call check_last_Q_A(l_switch,G3(:,:,:,197),Q(:,127),MT,G4tensor(:,139))
  call loop_QZ_A(G3(:,:,:,172),wf(:,152),G3(:,:,:,198),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,127),MT,G4tensor(:,140))
  call loop_QV_A(G3(:,:,:,172),wf(:,153),G3(:,:,:,199))
  call check_last_Q_A(l_switch,G3(:,:,:,199),Q(:,127),MT,G4tensor(:,141))
  call loop_QZ_A(G3(:,:,:,172),wf(:,154),G3(:,:,:,200),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,127),MT,G4tensor(:,142))
  call loop_QV_A(G3(:,:,:,172),wf(:,155),G3(:,:,:,201))
  call check_last_Q_A(l_switch,G3(:,:,:,201),Q(:,127),MT,G4tensor(:,143))
  call loop_QZ_A(G3(:,:,:,172),wf(:,156),G3(:,:,:,202),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,127),MT,G4tensor(:,144))
  call loop_QV_A(G3(:,:,:,172),wf(:,157),G3(:,:,:,203))
  call check_last_Q_A(l_switch,G3(:,:,:,203),Q(:,127),MT,G4tensor(:,145))
  call loop_QV_A(G3(:,:,:,172),wf(:,158),G3(:,:,:,204))
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,127),MT,G4tensor(:,146))
  call loop_QZ_A(G3(:,:,:,172),wf(:,159),G3(:,:,:,205),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,205),Q(:,127),MT,G4tensor(:,147))
  call loop_QZ_A(G3(:,:,:,172),wf(:,160),G3(:,:,:,206),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,127),MT,G4tensor(:,148))
  call loop_QV_A(G2(:,:,:,113),wf(:,2),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,90),MT,G3(:,:,:,207))
  call loop_QV_A(G3(:,:,:,207),wf(:,-5),G3(:,:,:,208))
  call loop_Q_A(G3(:,:,:,208),Q(:,122),MT,G4(:,:,:,73))
  call loop_QV_A(G4(:,:,:,73),wf(:,1),G4(:,:,:,74))
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),MT,G5tensor(:,49))
  call loop_QZ_A(G4(:,:,:,73),wf(:,9),G4(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,75),Q(:,127),MT,G5tensor(:,50))
  call loop_QZ_A(G2(:,:,:,113),wf(:,6),G2(:,:,:,116),gZu)
  call loop_Q_A(G2(:,:,:,116),Q(:,90),MT,G3(:,:,:,209))
  call loop_QV_A(G3(:,:,:,209),wf(:,-5),G3(:,:,:,210))
  call loop_Q_A(G3(:,:,:,210),Q(:,122),MT,G4(:,:,:,76))
  call loop_QV_A(G4(:,:,:,76),wf(:,1),G4(:,:,:,77))
  call check_last_Q_A(l_switch,G4(:,:,:,77),Q(:,127),MT,G5tensor(:,51))
  call loop_QZ_A(G4(:,:,:,76),wf(:,9),G4(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),MT,G5tensor(:,52))
  call loop_QV_A(G2(:,:,:,113),wf(:,46),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,89),MT,G3(:,:,:,211))
  call loop_QV_A(G3(:,:,:,211),wf(:,-5),G3(:,:,:,212))
  call loop_Q_A(G3(:,:,:,212),Q(:,121),MT,G4(:,:,:,79))
  call loop_QV_A(G4(:,:,:,79),wf(:,47),G4(:,:,:,80))
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),MT,G5tensor(:,53))
  call loop_QZ_A(G4(:,:,:,79),wf(:,50),G4(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,81),Q(:,127),MT,G5tensor(:,54))
  call loop_QZ_A(G2(:,:,:,113),wf(:,53),G2(:,:,:,118),gZu)
  call loop_Q_A(G2(:,:,:,118),Q(:,89),MT,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-5),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,121),MT,G4(:,:,:,82))
  call loop_QV_A(G4(:,:,:,82),wf(:,47),G4(:,:,:,83))
  call check_last_Q_A(l_switch,G4(:,:,:,83),Q(:,127),MT,G5tensor(:,55))
  call loop_QZ_A(G4(:,:,:,82),wf(:,50),G4(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),MT,G5tensor(:,56))
  call loop_QV_A(G1(:,:,:,9),wf(:,46),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,25),MT,G2(:,:,:,119))
  call loop_QV_A(G2(:,:,:,119),wf(:,17),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,121),MT,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,47),G3(:,:,:,216))
  call check_last_Q_A(l_switch,G3(:,:,:,216),Q(:,127),MT,G4tensor(:,149))
  call loop_QZ_A(G3(:,:,:,215),wf(:,50),G3(:,:,:,217),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,217),Q(:,127),MT,G4tensor(:,150))
  call loop_QV_A(G2(:,:,:,119),wf(:,-5),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,57),MT,G3(:,:,:,218))
  call loop_QV_A(G3(:,:,:,218),wf(:,-6),G3(:,:,:,219))
  call loop_Q_A(G3(:,:,:,219),Q(:,121),MT,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,47),G4(:,:,:,86))
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),MT,G5tensor(:,57))
  call loop_QZ_A(G4(:,:,:,85),wf(:,50),G4(:,:,:,87),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,87),Q(:,127),MT,G5tensor(:,58))
  call loop_QV_A(G2(:,:,:,119),wf(:,-6),G2(:,:,:,122))
  call loop_Q_A(G2(:,:,:,122),Q(:,89),MT,G3(:,:,:,220))
  call loop_QV_A(G3(:,:,:,220),wf(:,-5),G3(:,:,:,221))
  call loop_Q_A(G3(:,:,:,221),Q(:,121),MT,G4(:,:,:,88))
  call loop_QV_A(G4(:,:,:,88),wf(:,47),G4(:,:,:,89))
  call check_last_Q_A(l_switch,G4(:,:,:,89),Q(:,127),MT,G5tensor(:,59))
  call loop_QZ_A(G4(:,:,:,88),wf(:,50),G4(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),MT,G5tensor(:,60))
  call loop_QZ_A(G1(:,:,:,9),wf(:,53),G1(:,:,:,16),gZu)
  call loop_Q_A(G1(:,:,:,16),Q(:,25),MT,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,17),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,121),MT,G3(:,:,:,222))
  call loop_QV_A(G3(:,:,:,222),wf(:,47),G3(:,:,:,223))
  call check_last_Q_A(l_switch,G3(:,:,:,223),Q(:,127),MT,G4tensor(:,151))
  call loop_QZ_A(G3(:,:,:,222),wf(:,50),G3(:,:,:,224),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,127),MT,G4tensor(:,152))
  call loop_QV_A(G2(:,:,:,123),wf(:,-5),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,57),MT,G3(:,:,:,225))
  call loop_QV_A(G3(:,:,:,225),wf(:,-6),G3(:,:,:,226))
  call loop_Q_A(G3(:,:,:,226),Q(:,121),MT,G4(:,:,:,91))
  call loop_QV_A(G4(:,:,:,91),wf(:,47),G4(:,:,:,92))
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),MT,G5tensor(:,61))
  call loop_QZ_A(G4(:,:,:,91),wf(:,50),G4(:,:,:,93),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,93),Q(:,127),MT,G5tensor(:,62))
  call loop_QV_A(G2(:,:,:,123),wf(:,-6),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,89),MT,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,-5),G3(:,:,:,228))
  call loop_Q_A(G3(:,:,:,228),Q(:,121),MT,G4(:,:,:,94))
  call loop_QV_A(G4(:,:,:,94),wf(:,47),G4(:,:,:,95))
  call check_last_Q_A(l_switch,G4(:,:,:,95),Q(:,127),MT,G5tensor(:,63))
  call loop_QZ_A(G4(:,:,:,94),wf(:,50),G4(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,127),MT,G5tensor(:,64))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,17),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,112),MB,G2(:,:,:,127))
  call loop_AS_Q(G2(:,:,:,127),wf(:,94),G2(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,127),MB,G3tensor(:,69))
  call loop_AV_Q(G2(:,:,:,127),wf(:,129),G2(:,:,:,129))
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,127),MB,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,130),G2(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,127),MB,G3tensor(:,71))
  call loop_AV_Q(G2(:,:,:,127),wf(:,131),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,127),MB,G3tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,132),G2(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,127),MB,G3tensor(:,73))
  call loop_AV_Q(G2(:,:,:,127),wf(:,133),G2(:,:,:,133))
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,127),MB,G3tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,134),G2(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,127),MB,G3tensor(:,75))
  call loop_AV_Q(G2(:,:,:,127),wf(:,135),G2(:,:,:,135))
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,127),MB,G3tensor(:,76))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,136),G2(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,127),MB,G3tensor(:,77))
  call loop_AS_Q(G2(:,:,:,127),wf(:,110),G2(:,:,:,137),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,127),MB,G3tensor(:,78))
  call loop_AV_Q(G2(:,:,:,127),wf(:,137),G2(:,:,:,138))
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,127),MB,G3tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,138),G2(:,:,:,139),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,127),MB,G3tensor(:,80))
  call loop_AV_Q(G2(:,:,:,127),wf(:,139),G2(:,:,:,140))
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,127),MB,G3tensor(:,81))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,140),G2(:,:,:,141),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,141),Q(:,127),MB,G3tensor(:,82))
  call loop_AV_Q(G2(:,:,:,127),wf(:,141),G2(:,:,:,142))
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,127),MB,G3tensor(:,83))
  call loop_AV_Q(G2(:,:,:,127),wf(:,142),G2(:,:,:,143))
  call check_last_A_Q(l_switch,G2(:,:,:,143),Q(:,127),MB,G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,143),G2(:,:,:,144),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,127),MB,G3tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,144),G2(:,:,:,145),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,145),Q(:,127),MB,G3tensor(:,86))
  call loop_AV_Q(G2(:,:,:,127),wf(:,145),G2(:,:,:,146))
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,127),MB,G3tensor(:,87))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,146),G2(:,:,:,147),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,147),Q(:,127),MB,G3tensor(:,88))
  call loop_AV_Q(G2(:,:,:,127),wf(:,147),G2(:,:,:,148))
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,127),MB,G3tensor(:,89))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,148),G2(:,:,:,149),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,149),Q(:,127),MB,G3tensor(:,90))
  call loop_AV_Q(G2(:,:,:,127),wf(:,149),G2(:,:,:,150))
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,127),MB,G3tensor(:,91))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,150),G2(:,:,:,151),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,151),Q(:,127),MB,G3tensor(:,92))
  call loop_AV_Q(G2(:,:,:,127),wf(:,151),G2(:,:,:,152))
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,127),MB,G3tensor(:,93))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,152),G2(:,:,:,153),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,127),MB,G3tensor(:,94))
  call loop_AV_Q(G2(:,:,:,127),wf(:,153),G2(:,:,:,154))
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,127),MB,G3tensor(:,95))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,154),G2(:,:,:,155),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,155),Q(:,127),MB,G3tensor(:,96))
  call loop_AV_Q(G2(:,:,:,127),wf(:,155),G2(:,:,:,156))
  call check_last_A_Q(l_switch,G2(:,:,:,156),Q(:,127),MB,G3tensor(:,97))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,156),G2(:,:,:,157),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,157),Q(:,127),MB,G3tensor(:,98))
  call loop_AV_Q(G2(:,:,:,127),wf(:,157),G2(:,:,:,158))
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,127),MB,G3tensor(:,99))
  call loop_AV_Q(G2(:,:,:,127),wf(:,158),G2(:,:,:,159))
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,127),MB,G3tensor(:,100))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,159),G2(:,:,:,160),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,160),Q(:,127),MB,G3tensor(:,101))
  call loop_AZ_Q(G2(:,:,:,127),wf(:,160),G2(:,:,:,161),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,161),Q(:,127),MB,G3tensor(:,102))
  call loop_AV_Q(G1(:,:,:,17),wf(:,2),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,26),MB,G2(:,:,:,162))
  call loop_AV_Q(G2(:,:,:,162),wf(:,17),G2(:,:,:,163))
  call loop_A_Q(G2(:,:,:,163),Q(:,122),MB,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,1),G3(:,:,:,230))
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,127),MB,G4tensor(:,153))
  call loop_AZ_Q(G3(:,:,:,229),wf(:,9),G3(:,:,:,231),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,231),Q(:,127),MB,G4tensor(:,154))
  call loop_AV_Q(G2(:,:,:,162),wf(:,-6),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,90),MB,G3(:,:,:,232))
  call loop_AV_Q(G3(:,:,:,232),wf(:,-5),G3(:,:,:,233))
  call loop_A_Q(G3(:,:,:,233),Q(:,122),MB,G4(:,:,:,97))
  call loop_AV_Q(G4(:,:,:,97),wf(:,1),G4(:,:,:,98))
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),MB,G5tensor(:,65))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,9),G4(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,99),Q(:,127),MB,G5tensor(:,66))
  call loop_AV_Q(G2(:,:,:,162),wf(:,-5),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,58),MB,G3(:,:,:,234))
  call loop_AV_Q(G3(:,:,:,234),wf(:,-6),G3(:,:,:,235))
  call loop_A_Q(G3(:,:,:,235),Q(:,122),MB,G4(:,:,:,100))
  call loop_AV_Q(G4(:,:,:,100),wf(:,1),G4(:,:,:,101))
  call check_last_A_Q(l_switch,G4(:,:,:,101),Q(:,127),MB,G5tensor(:,67))
  call loop_AZ_Q(G4(:,:,:,100),wf(:,9),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),MB,G5tensor(:,68))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,6),G1(:,:,:,20),gZd)
  call loop_A_Q(G1(:,:,:,20),Q(:,26),MB,G2(:,:,:,166))
  call loop_AV_Q(G2(:,:,:,166),wf(:,17),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,122),MB,G3(:,:,:,236))
  call loop_AV_Q(G3(:,:,:,236),wf(:,1),G3(:,:,:,237))
  call check_last_A_Q(l_switch,G3(:,:,:,237),Q(:,127),MB,G4tensor(:,155))
  call loop_AZ_Q(G3(:,:,:,236),wf(:,9),G3(:,:,:,238),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,127),MB,G4tensor(:,156))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-6),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,90),MB,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-5),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,122),MB,G4(:,:,:,103))
  call loop_AV_Q(G4(:,:,:,103),wf(:,1),G4(:,:,:,104))
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),MB,G5tensor(:,69))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,9),G4(:,:,:,105),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,105),Q(:,127),MB,G5tensor(:,70))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-5),G2(:,:,:,169))
  call loop_A_Q(G2(:,:,:,169),Q(:,58),MB,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,-6),G3(:,:,:,242))
  call loop_A_Q(G3(:,:,:,242),Q(:,122),MB,G4(:,:,:,106))
  call loop_AV_Q(G4(:,:,:,106),wf(:,1),G4(:,:,:,107))
  call check_last_A_Q(l_switch,G4(:,:,:,107),Q(:,127),MB,G5tensor(:,71))
  call loop_AZ_Q(G4(:,:,:,106),wf(:,9),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),MB,G5tensor(:,72))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-5),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,48),MB,G2(:,:,:,170))
  call loop_AV_Q(G2(:,:,:,170),wf(:,-6),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,112),MB,G3(:,:,:,243))
  call loop_AS_Q(G3(:,:,:,243),wf(:,94),G3(:,:,:,244),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,244),Q(:,127),MB,G4tensor(:,157))
  call loop_AV_Q(G3(:,:,:,243),wf(:,129),G3(:,:,:,245))
  call check_last_A_Q(l_switch,G3(:,:,:,245),Q(:,127),MB,G4tensor(:,158))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,130),G3(:,:,:,246),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,246),Q(:,127),MB,G4tensor(:,159))
  call loop_AV_Q(G3(:,:,:,243),wf(:,131),G3(:,:,:,247))
  call check_last_A_Q(l_switch,G3(:,:,:,247),Q(:,127),MB,G4tensor(:,160))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,132),G3(:,:,:,248),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,127),MB,G4tensor(:,161))
  call loop_AV_Q(G3(:,:,:,243),wf(:,133),G3(:,:,:,249))
  call check_last_A_Q(l_switch,G3(:,:,:,249),Q(:,127),MB,G4tensor(:,162))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,134),G3(:,:,:,250),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,250),Q(:,127),MB,G4tensor(:,163))
  call loop_AV_Q(G3(:,:,:,243),wf(:,135),G3(:,:,:,251))
  call check_last_A_Q(l_switch,G3(:,:,:,251),Q(:,127),MB,G4tensor(:,164))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,136),G3(:,:,:,252),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,252),Q(:,127),MB,G4tensor(:,165))
  call loop_AS_Q(G3(:,:,:,243),wf(:,110),G3(:,:,:,253),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,253),Q(:,127),MB,G4tensor(:,166))
  call loop_AV_Q(G3(:,:,:,243),wf(:,137),G3(:,:,:,254))
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,127),MB,G4tensor(:,167))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,138),G3(:,:,:,255),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,255),Q(:,127),MB,G4tensor(:,168))
  call loop_AV_Q(G3(:,:,:,243),wf(:,139),G3(:,:,:,256))
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,127),MB,G4tensor(:,169))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,140),G3(:,:,:,257),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,257),Q(:,127),MB,G4tensor(:,170))
  call loop_AV_Q(G3(:,:,:,243),wf(:,141),G3(:,:,:,258))
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),MB,G4tensor(:,171))
  call loop_AV_Q(G3(:,:,:,243),wf(:,142),G3(:,:,:,259))
  call check_last_A_Q(l_switch,G3(:,:,:,259),Q(:,127),MB,G4tensor(:,172))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,143),G3(:,:,:,260),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),MB,G4tensor(:,173))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,144),G3(:,:,:,261),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),MB,G4tensor(:,174))
  call loop_AV_Q(G3(:,:,:,243),wf(:,145),G3(:,:,:,262))
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,127),MB,G4tensor(:,175))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,146),G3(:,:,:,263),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,263),Q(:,127),MB,G4tensor(:,176))
  call loop_AV_Q(G3(:,:,:,243),wf(:,147),G3(:,:,:,264))
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,127),MB,G4tensor(:,177))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,148),G3(:,:,:,265),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,265),Q(:,127),MB,G4tensor(:,178))
  call loop_AV_Q(G3(:,:,:,243),wf(:,149),G3(:,:,:,266))
  call check_last_A_Q(l_switch,G3(:,:,:,266),Q(:,127),MB,G4tensor(:,179))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,150),G3(:,:,:,267),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,267),Q(:,127),MB,G4tensor(:,180))
  call loop_AV_Q(G3(:,:,:,243),wf(:,151),G3(:,:,:,268))
  call check_last_A_Q(l_switch,G3(:,:,:,268),Q(:,127),MB,G4tensor(:,181))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,152),G3(:,:,:,269),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,269),Q(:,127),MB,G4tensor(:,182))
  call loop_AV_Q(G3(:,:,:,243),wf(:,153),G3(:,:,:,270))
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,127),MB,G4tensor(:,183))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,154),G3(:,:,:,271),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,271),Q(:,127),MB,G4tensor(:,184))
  call loop_AV_Q(G3(:,:,:,243),wf(:,155),G3(:,:,:,272))
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,127),MB,G4tensor(:,185))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,156),G3(:,:,:,273),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,273),Q(:,127),MB,G4tensor(:,186))
  call loop_AV_Q(G3(:,:,:,243),wf(:,157),G3(:,:,:,274))
  call check_last_A_Q(l_switch,G3(:,:,:,274),Q(:,127),MB,G4tensor(:,187))
  call loop_AV_Q(G3(:,:,:,243),wf(:,158),G3(:,:,:,275))
  call check_last_A_Q(l_switch,G3(:,:,:,275),Q(:,127),MB,G4tensor(:,188))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,159),G3(:,:,:,276),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,276),Q(:,127),MB,G4tensor(:,189))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,160),G3(:,:,:,277),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,277),Q(:,127),MB,G4tensor(:,190))
  call loop_AV_Q(G2(:,:,:,170),wf(:,2),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,58),MB,G3(:,:,:,278))
  call loop_AV_Q(G3(:,:,:,278),wf(:,-6),G3(:,:,:,279))
  call loop_A_Q(G3(:,:,:,279),Q(:,122),MB,G4(:,:,:,109))
  call loop_AV_Q(G4(:,:,:,109),wf(:,1),G4(:,:,:,110))
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,127),MB,G5tensor(:,73))
  call loop_AZ_Q(G4(:,:,:,109),wf(:,9),G4(:,:,:,111),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,111),Q(:,127),MB,G5tensor(:,74))
  call loop_AZ_Q(G2(:,:,:,170),wf(:,6),G2(:,:,:,173),gZd)
  call loop_A_Q(G2(:,:,:,173),Q(:,58),MB,G3(:,:,:,280))
  call loop_AV_Q(G3(:,:,:,280),wf(:,-6),G3(:,:,:,281))
  call loop_A_Q(G3(:,:,:,281),Q(:,122),MB,G4(:,:,:,112))
  call loop_AV_Q(G4(:,:,:,112),wf(:,1),G4(:,:,:,113))
  call check_last_A_Q(l_switch,G4(:,:,:,113),Q(:,127),MB,G5tensor(:,75))
  call loop_AZ_Q(G4(:,:,:,112),wf(:,9),G4(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,127),MB,G5tensor(:,76))
  call loop_AV_Q(G2(:,:,:,170),wf(:,46),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,57),MB,G3(:,:,:,282))
  call loop_AV_Q(G3(:,:,:,282),wf(:,-6),G3(:,:,:,283))
  call loop_A_Q(G3(:,:,:,283),Q(:,121),MB,G4(:,:,:,115))
  call loop_AV_Q(G4(:,:,:,115),wf(:,47),G4(:,:,:,116))
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,127),MB,G5tensor(:,77))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,50),G4(:,:,:,117),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,117),Q(:,127),MB,G5tensor(:,78))
  call loop_AZ_Q(G2(:,:,:,170),wf(:,53),G2(:,:,:,175),gZd)
  call loop_A_Q(G2(:,:,:,175),Q(:,57),MB,G3(:,:,:,284))
  call loop_AV_Q(G3(:,:,:,284),wf(:,-6),G3(:,:,:,285))
  call loop_A_Q(G3(:,:,:,285),Q(:,121),MB,G4(:,:,:,118))
  call loop_AV_Q(G4(:,:,:,118),wf(:,47),G4(:,:,:,119))
  call check_last_A_Q(l_switch,G4(:,:,:,119),Q(:,127),MB,G5tensor(:,79))
  call loop_AZ_Q(G4(:,:,:,118),wf(:,50),G4(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,127),MB,G5tensor(:,80))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-6),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,80),MB,G2(:,:,:,176))
  call loop_AV_Q(G2(:,:,:,176),wf(:,-5),G2(:,:,:,177))
  call loop_A_Q(G2(:,:,:,177),Q(:,112),MB,G3(:,:,:,286))
  call loop_AS_Q(G3(:,:,:,286),wf(:,94),G3(:,:,:,287),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,287),Q(:,127),MB,G4tensor(:,191))
  call loop_AV_Q(G3(:,:,:,286),wf(:,129),G3(:,:,:,288))
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,127),MB,G4tensor(:,192))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,130),G3(:,:,:,289),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,289),Q(:,127),MB,G4tensor(:,193))
  call loop_AV_Q(G3(:,:,:,286),wf(:,131),G3(:,:,:,290))
  call check_last_A_Q(l_switch,G3(:,:,:,290),Q(:,127),MB,G4tensor(:,194))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,132),G3(:,:,:,291),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,291),Q(:,127),MB,G4tensor(:,195))
  call loop_AV_Q(G3(:,:,:,286),wf(:,133),G3(:,:,:,292))
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,127),MB,G4tensor(:,196))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,134),G3(:,:,:,293),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,293),Q(:,127),MB,G4tensor(:,197))
  call loop_AV_Q(G3(:,:,:,286),wf(:,135),G3(:,:,:,294))
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,127),MB,G4tensor(:,198))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,136),G3(:,:,:,295),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,295),Q(:,127),MB,G4tensor(:,199))
  call loop_AS_Q(G3(:,:,:,286),wf(:,110),G3(:,:,:,296),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,296),Q(:,127),MB,G4tensor(:,200))
  call loop_AV_Q(G3(:,:,:,286),wf(:,137),G3(:,:,:,297))
  call check_last_A_Q(l_switch,G3(:,:,:,297),Q(:,127),MB,G4tensor(:,201))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,138),G3(:,:,:,298),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),MB,G4tensor(:,202))
  call loop_AV_Q(G3(:,:,:,286),wf(:,139),G3(:,:,:,299))
  call check_last_A_Q(l_switch,G3(:,:,:,299),Q(:,127),MB,G4tensor(:,203))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,140),G3(:,:,:,300),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,127),MB,G4tensor(:,204))
  call loop_AV_Q(G3(:,:,:,286),wf(:,141),G3(:,:,:,301))
  call check_last_A_Q(l_switch,G3(:,:,:,301),Q(:,127),MB,G4tensor(:,205))
  call loop_AV_Q(G3(:,:,:,286),wf(:,142),G3(:,:,:,302))
  call check_last_A_Q(l_switch,G3(:,:,:,302),Q(:,127),MB,G4tensor(:,206))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,143),G3(:,:,:,303),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,303),Q(:,127),MB,G4tensor(:,207))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,144),G3(:,:,:,304),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,127),MB,G4tensor(:,208))
  call loop_AV_Q(G3(:,:,:,286),wf(:,145),G3(:,:,:,305))
  call check_last_A_Q(l_switch,G3(:,:,:,305),Q(:,127),MB,G4tensor(:,209))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,146),G3(:,:,:,306),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,127),MB,G4tensor(:,210))
  call loop_AV_Q(G3(:,:,:,286),wf(:,147),G3(:,:,:,307))
  call check_last_A_Q(l_switch,G3(:,:,:,307),Q(:,127),MB,G4tensor(:,211))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,148),G3(:,:,:,308),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,127),MB,G4tensor(:,212))
  call loop_AV_Q(G3(:,:,:,286),wf(:,149),G3(:,:,:,309))
  call check_last_A_Q(l_switch,G3(:,:,:,309),Q(:,127),MB,G4tensor(:,213))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,150),G3(:,:,:,310),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,127),MB,G4tensor(:,214))
  call loop_AV_Q(G3(:,:,:,286),wf(:,151),G3(:,:,:,311))
  call check_last_A_Q(l_switch,G3(:,:,:,311),Q(:,127),MB,G4tensor(:,215))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,152),G3(:,:,:,312),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,312),Q(:,127),MB,G4tensor(:,216))
  call loop_AV_Q(G3(:,:,:,286),wf(:,153),G3(:,:,:,313))
  call check_last_A_Q(l_switch,G3(:,:,:,313),Q(:,127),MB,G4tensor(:,217))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,154),G3(:,:,:,314),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,314),Q(:,127),MB,G4tensor(:,218))
  call loop_AV_Q(G3(:,:,:,286),wf(:,155),G3(:,:,:,315))
  call check_last_A_Q(l_switch,G3(:,:,:,315),Q(:,127),MB,G4tensor(:,219))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,156),G3(:,:,:,316),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,127),MB,G4tensor(:,220))
  call loop_AV_Q(G3(:,:,:,286),wf(:,157),G3(:,:,:,317))
  call check_last_A_Q(l_switch,G3(:,:,:,317),Q(:,127),MB,G4tensor(:,221))
  call loop_AV_Q(G3(:,:,:,286),wf(:,158),G3(:,:,:,318))
  call check_last_A_Q(l_switch,G3(:,:,:,318),Q(:,127),MB,G4tensor(:,222))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,159),G3(:,:,:,319),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,319),Q(:,127),MB,G4tensor(:,223))
  call loop_AZ_Q(G3(:,:,:,286),wf(:,160),G3(:,:,:,320),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,320),Q(:,127),MB,G4tensor(:,224))
  call loop_AV_Q(G2(:,:,:,176),wf(:,2),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,90),MB,G3(:,:,:,321))
  call loop_AV_Q(G3(:,:,:,321),wf(:,-5),G3(:,:,:,322))
  call loop_A_Q(G3(:,:,:,322),Q(:,122),MB,G4(:,:,:,121))
  call loop_AV_Q(G4(:,:,:,121),wf(:,1),G4(:,:,:,122))
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),MB,G5tensor(:,81))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,9),G4(:,:,:,123),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,123),Q(:,127),MB,G5tensor(:,82))
  call loop_AZ_Q(G2(:,:,:,176),wf(:,6),G2(:,:,:,179),gZd)
  call loop_A_Q(G2(:,:,:,179),Q(:,90),MB,G3(:,:,:,323))
  call loop_AV_Q(G3(:,:,:,323),wf(:,-5),G3(:,:,:,324))
  call loop_A_Q(G3(:,:,:,324),Q(:,122),MB,G4(:,:,:,124))
  call loop_AV_Q(G4(:,:,:,124),wf(:,1),G4(:,:,:,125))
  call check_last_A_Q(l_switch,G4(:,:,:,125),Q(:,127),MB,G5tensor(:,83))
  call loop_AZ_Q(G4(:,:,:,124),wf(:,9),G4(:,:,:,126),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,127),MB,G5tensor(:,84))
  call loop_AV_Q(G2(:,:,:,176),wf(:,46),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,89),MB,G3(:,:,:,325))
  call loop_AV_Q(G3(:,:,:,325),wf(:,-5),G3(:,:,:,326))
  call loop_A_Q(G3(:,:,:,326),Q(:,121),MB,G4(:,:,:,127))
  call loop_AV_Q(G4(:,:,:,127),wf(:,47),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),MB,G5tensor(:,85))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,50),G4(:,:,:,129),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,129),Q(:,127),MB,G5tensor(:,86))
  call loop_AZ_Q(G2(:,:,:,176),wf(:,53),G2(:,:,:,181),gZd)
  call loop_A_Q(G2(:,:,:,181),Q(:,89),MB,G3(:,:,:,327))
  call loop_AV_Q(G3(:,:,:,327),wf(:,-5),G3(:,:,:,328))
  call loop_A_Q(G3(:,:,:,328),Q(:,121),MB,G4(:,:,:,130))
  call loop_AV_Q(G4(:,:,:,130),wf(:,47),G4(:,:,:,131))
  call check_last_A_Q(l_switch,G4(:,:,:,131),Q(:,127),MB,G5tensor(:,87))
  call loop_AZ_Q(G4(:,:,:,130),wf(:,50),G4(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,127),MB,G5tensor(:,88))
  call loop_AV_Q(G1(:,:,:,17),wf(:,46),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,25),MB,G2(:,:,:,182))
  call loop_AV_Q(G2(:,:,:,182),wf(:,17),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,121),MB,G3(:,:,:,329))
  call loop_AV_Q(G3(:,:,:,329),wf(:,47),G3(:,:,:,330))
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,127),MB,G4tensor(:,225))
  call loop_AZ_Q(G3(:,:,:,329),wf(:,50),G3(:,:,:,331),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,331),Q(:,127),MB,G4tensor(:,226))
  call loop_AV_Q(G2(:,:,:,182),wf(:,-5),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,57),MB,G3(:,:,:,332))
  call loop_AV_Q(G3(:,:,:,332),wf(:,-6),G3(:,:,:,333))
  call loop_A_Q(G3(:,:,:,333),Q(:,121),MB,G4(:,:,:,133))
  call loop_AV_Q(G4(:,:,:,133),wf(:,47),G4(:,:,:,134))
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),MB,G5tensor(:,89))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,50),G4(:,:,:,135),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,135),Q(:,127),MB,G5tensor(:,90))
  call loop_AV_Q(G2(:,:,:,182),wf(:,-6),G2(:,:,:,185))
  call loop_A_Q(G2(:,:,:,185),Q(:,89),MB,G3(:,:,:,334))
  call loop_AV_Q(G3(:,:,:,334),wf(:,-5),G3(:,:,:,335))
  call loop_A_Q(G3(:,:,:,335),Q(:,121),MB,G4(:,:,:,136))
  call loop_AV_Q(G4(:,:,:,136),wf(:,47),G4(:,:,:,137))
  call check_last_A_Q(l_switch,G4(:,:,:,137),Q(:,127),MB,G5tensor(:,91))
  call loop_AZ_Q(G4(:,:,:,136),wf(:,50),G4(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,127),MB,G5tensor(:,92))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,53),G1(:,:,:,24),gZd)
  call loop_A_Q(G1(:,:,:,24),Q(:,25),MB,G2(:,:,:,186))
  call loop_AV_Q(G2(:,:,:,186),wf(:,17),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,121),MB,G3(:,:,:,336))
  call loop_AV_Q(G3(:,:,:,336),wf(:,47),G3(:,:,:,337))
  call check_last_A_Q(l_switch,G3(:,:,:,337),Q(:,127),MB,G4tensor(:,227))
  call loop_AZ_Q(G3(:,:,:,336),wf(:,50),G3(:,:,:,338),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,127),MB,G4tensor(:,228))
  call loop_AV_Q(G2(:,:,:,186),wf(:,-5),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,57),MB,G3(:,:,:,339))
  call loop_AV_Q(G3(:,:,:,339),wf(:,-6),G3(:,:,:,340))
  call loop_A_Q(G3(:,:,:,340),Q(:,121),MB,G4(:,:,:,139))
  call loop_AV_Q(G4(:,:,:,139),wf(:,47),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,127),MB,G5tensor(:,93))
  call loop_AZ_Q(G4(:,:,:,139),wf(:,50),G4(:,:,:,141),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,141),Q(:,127),MB,G5tensor(:,94))
  call loop_AV_Q(G2(:,:,:,186),wf(:,-6),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,89),MB,G3(:,:,:,341))
  call loop_AV_Q(G3(:,:,:,341),wf(:,-5),G3(:,:,:,342))
  call loop_A_Q(G3(:,:,:,342),Q(:,121),MB,G4(:,:,:,142))
  call loop_AV_Q(G4(:,:,:,142),wf(:,47),G4(:,:,:,143))
  call check_last_A_Q(l_switch,G4(:,:,:,143),Q(:,127),MB,G5tensor(:,95))
  call loop_AZ_Q(G4(:,:,:,142),wf(:,50),G4(:,:,:,144),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,127),MB,G5tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(27) * den(98)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(27)) * den(98)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(27) * den(98)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,35),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(27)) * den(98)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,35),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(25) * den(98)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(25)) * den(98)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,69),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(10)) * den(206)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,77),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(10) * den(206)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,77),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(10)) * den(206)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,1),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(10) * den(206)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,1),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(7)) * den(206)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,153),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(7) * den(206)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,153),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(11) * den(207)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,79),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(11)) * den(207)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,79),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(11) * den(207)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,3),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(11)) * den(207)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,3),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(9)) * den(207)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,155),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(9) * den(207)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,155),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(11) * den(208)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,78),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(11)) * den(208)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,78),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(11) * den(208)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,2),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(11)) * den(208)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,2),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(9)) * den(208)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,154),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(9) * den(208)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,154),T4sum(1:70,21))
  M(1) = M(1) + (-(CI*f(13)) * den(209)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,80),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(13) * den(209)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,80),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(13)) * den(209)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,4),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(13) * den(209)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,4),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(13)) * den(209)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,156),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(13) * den(209)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,156),T4sum(1:70,21))
  M(1) = M(1) + (-f(28) * den(95)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,5),T4sum(1:70,30))
  M(2) = M(2) + (-f(28) * den(95)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,81),T4sum(1:70,30))
  M(1) = M(1) + (-f(26) * den(95)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,157),T4sum(1:70,31))
  M(2) = M(2) + (-f(28) * den(95)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,39),T4sum(1:70,32))
  M(1) = M(1) + (-f(28) * den(95)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,115),T4sum(1:70,32))
  M(2) = M(2) + (-f(26) * den(95)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,191),T4sum(1:70,33))
  M(1) = M(1) + (f(19) * den(4)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,9),T5sum(1:126,11))
  M(2) = M(2) + (f(19) * den(4)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,41),T5sum(1:126,11))
  M(1) = M(1) + (f(16) * den(4)) * TI2_call(5,momenta_42,masses2_7,G5tensor(:,73),T5sum(1:126,12))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,11),T5sum(1:126,11))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,43),T5sum(1:126,11))
  M(1) = M(1) + (f(18) * den(7)) * TI2_call(5,momenta_42,masses2_7,G5tensor(:,75),T5sum(1:126,12))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,10),T5sum(1:126,11))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,42),T5sum(1:126,11))
  M(1) = M(1) + (f(18) * den(10)) * TI2_call(5,momenta_42,masses2_7,G5tensor(:,74),T5sum(1:126,12))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,12),T5sum(1:126,11))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,44),T5sum(1:126,11))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_42,masses2_7,G5tensor(:,76),T5sum(1:126,12))
  M(2) = M(2) + (f(19) * den(4)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,17),T5sum(1:126,23))
  M(1) = M(1) + (f(19) * den(4)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,49),T5sum(1:126,23))
  M(2) = M(2) + (f(16) * den(4)) * TI2_call(5,momenta_44,masses2_7,G5tensor(:,81),T5sum(1:126,24))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,19),T5sum(1:126,23))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,51),T5sum(1:126,23))
  M(2) = M(2) + (f(18) * den(7)) * TI2_call(5,momenta_44,masses2_7,G5tensor(:,83),T5sum(1:126,24))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,18),T5sum(1:126,23))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,50),T5sum(1:126,23))
  M(2) = M(2) + (f(18) * den(10)) * TI2_call(5,momenta_44,masses2_7,G5tensor(:,82),T5sum(1:126,24))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,20),T5sum(1:126,23))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,52),T5sum(1:126,23))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_44,masses2_7,G5tensor(:,84),T5sum(1:126,24))
  M(1) = M(1) + (f(19) * den(4)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,33),T5sum(1:126,32))
  M(2) = M(2) + (f(19) * den(4)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,1),T5sum(1:126,32))
  M(2) = M(2) + (f(16) * den(4)) * TI2_call(5,momenta_40,masses2_7,G5tensor(:,65),T5sum(1:126,33))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,37),T5sum(1:126,32))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,5),T5sum(1:126,32))
  M(2) = M(2) + (f(18) * den(7)) * TI2_call(5,momenta_40,masses2_7,G5tensor(:,69),T5sum(1:126,33))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,34),T5sum(1:126,32))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,2),T5sum(1:126,32))
  M(2) = M(2) + (f(18) * den(10)) * TI2_call(5,momenta_40,masses2_7,G5tensor(:,66),T5sum(1:126,33))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,38),T5sum(1:126,32))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,6),T5sum(1:126,32))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_40,masses2_7,G5tensor(:,70),T5sum(1:126,33))
  M(2) = M(2) + (f(19) * den(4)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,35),T5sum(1:126,35))
  M(1) = M(1) + (f(19) * den(4)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,3),T5sum(1:126,35))
  M(1) = M(1) + (f(16) * den(4)) * TI2_call(5,momenta_39,masses2_7,G5tensor(:,67),T5sum(1:126,36))
  M(2) = M(2) + (-f(20) * den(7)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,39),T5sum(1:126,35))
  M(1) = M(1) + (-f(20) * den(7)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,7),T5sum(1:126,35))
  M(1) = M(1) + (f(18) * den(7)) * TI2_call(5,momenta_39,masses2_7,G5tensor(:,71),T5sum(1:126,36))
  M(2) = M(2) + (-f(20) * den(10)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,36),T5sum(1:126,35))
  M(1) = M(1) + (-f(20) * den(10)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,4),T5sum(1:126,35))
  M(1) = M(1) + (f(18) * den(10)) * TI2_call(5,momenta_39,masses2_7,G5tensor(:,68),T5sum(1:126,36))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,40),T5sum(1:126,35))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,8),T5sum(1:126,35))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_39,masses2_7,G5tensor(:,72),T5sum(1:126,36))
  M(1) = M(1) + (CI*f(11) * den(226)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,36),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(226)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,36),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(226)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(226)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(226)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(226)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,70),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(227)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(227)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(227)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(227)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(227)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(227)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,71),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(228)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(228)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(228)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(228)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(228)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(228)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,72),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(229)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(229)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(229)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(229)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(229)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(229)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(230)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(230)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(230)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(230)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(230)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(230)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(231)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(231)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(231)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(231)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(231)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(231)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(232)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(232)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(232)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(232)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(232)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(232)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(233)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,43),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(233)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,43),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(233)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(233)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(233)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(233)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(1) = M(1) + (-f(20) * den(165)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,6),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(165)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,82),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(165)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,158),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(167)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,7),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(167)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,83),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(167)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,159),T4sum(1:70,31))
  M(1) = M(1) + (-f(20) * den(168)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,8),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(168)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,84),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(168)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,160),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(169)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,9),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(169)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,85),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(169)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,161),T4sum(1:70,31))
  M(2) = M(2) + (-f(20) * den(165)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,40),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(165)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,116),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(165)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,192),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(167)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,41),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(167)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,117),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(167)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,193),T4sum(1:70,33))
  M(2) = M(2) + (-f(20) * den(168)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,42),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(168)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,118),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(168)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,194),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(169)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,43),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(169)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,119),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(169)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,195),T4sum(1:70,33))
  M(1) = M(1) + (-f(20) * den(170)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,10),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(170)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,86),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(170)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,162),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(171)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,11),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(171)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,87),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(171)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,163),T4sum(1:70,31))
  M(1) = M(1) + (-f(20) * den(172)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,12),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(172)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,88),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(172)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,164),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(173)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,13),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(173)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,89),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(173)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,165),T4sum(1:70,31))
  M(2) = M(2) + (-f(20) * den(170)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,44),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(170)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,120),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(170)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,196),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(171)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,45),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(171)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,121),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(171)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,197),T4sum(1:70,33))
  M(2) = M(2) + (-f(20) * den(172)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,46),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(172)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,122),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(172)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,198),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(173)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,47),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(173)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,123),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(173)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,199),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(27)) * den(120)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(27) * den(120)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(27)) * den(120)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(27) * den(120)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,44),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(25)) * den(120)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(25) * den(120)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(242)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,73),T4sum(1:70,56))
  M(2) = M(2) + (-(CI*f(10)) * den(242)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,73),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(10) * den(242)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,149),T4sum(1:70,56))
  M(2) = M(2) + (-(CI*f(10)) * den(242)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,149),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(7) * den(242)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,225),T4sum(1:70,57))
  M(2) = M(2) + (-(CI*f(7)) * den(242)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,225),T4sum(1:70,57))
  M(1) = M(1) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,74),T4sum(1:70,56))
  M(2) = M(2) + (CI*f(11) * den(243)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,74),T4sum(1:70,56))
  M(1) = M(1) + (-(CI*f(11)) * den(243)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,150),T4sum(1:70,56))
  M(2) = M(2) + (CI*f(11) * den(243)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,150),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(9) * den(243)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,226),T4sum(1:70,57))
  M(2) = M(2) + (-(CI*f(9)) * den(243)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,226),T4sum(1:70,57))
  M(1) = M(1) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,75),T4sum(1:70,56))
  M(2) = M(2) + (CI*f(11) * den(244)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,75),T4sum(1:70,56))
  M(1) = M(1) + (-(CI*f(11)) * den(244)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,151),T4sum(1:70,56))
  M(2) = M(2) + (CI*f(11) * den(244)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,151),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(9) * den(244)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,227),T4sum(1:70,57))
  M(2) = M(2) + (-(CI*f(9)) * den(244)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,227),T4sum(1:70,57))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,76),T4sum(1:70,56))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,76),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,152),T4sum(1:70,56))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,152),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(13) * den(245)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,228),T4sum(1:70,57))
  M(2) = M(2) + (-(CI*f(13)) * den(245)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,228),T4sum(1:70,57))
  M(1) = M(1) + (f(28) * den(117)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,14),T4sum(1:70,30))
  M(2) = M(2) + (f(28) * den(117)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,90),T4sum(1:70,30))
  M(1) = M(1) + (f(26) * den(117)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,166),T4sum(1:70,31))
  M(2) = M(2) + (f(28) * den(117)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,48),T4sum(1:70,32))
  M(1) = M(1) + (f(28) * den(117)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,124),T4sum(1:70,32))
  M(2) = M(2) + (f(26) * den(117)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,200),T4sum(1:70,33))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,13),T5sum(1:126,53))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,45),T5sum(1:126,53))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_41,masses2_7,G5tensor(:,77),T5sum(1:126,54))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,14),T5sum(1:126,53))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,46),T5sum(1:126,53))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_41,masses2_7,G5tensor(:,78),T5sum(1:126,54))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,15),T5sum(1:126,53))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,47),T5sum(1:126,53))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_41,masses2_7,G5tensor(:,79),T5sum(1:126,54))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,16),T5sum(1:126,53))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,48),T5sum(1:126,53))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_41,masses2_7,G5tensor(:,80),T5sum(1:126,54))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,21),T5sum(1:126,65))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,53),T5sum(1:126,65))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_43,masses2_7,G5tensor(:,85),T5sum(1:126,66))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,22),T5sum(1:126,65))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,54),T5sum(1:126,65))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_43,masses2_7,G5tensor(:,86),T5sum(1:126,66))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,23),T5sum(1:126,65))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,55),T5sum(1:126,65))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_43,masses2_7,G5tensor(:,87),T5sum(1:126,66))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,24),T5sum(1:126,65))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,56),T5sum(1:126,65))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_43,masses2_7,G5tensor(:,88),T5sum(1:126,66))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,25),T5sum(1:126,68))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,57),T5sum(1:126,68))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,89),T5sum(1:126,69))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,26),T5sum(1:126,68))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,58),T5sum(1:126,68))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,90),T5sum(1:126,69))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,29),T5sum(1:126,68))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,61),T5sum(1:126,68))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,93),T5sum(1:126,69))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,30),T5sum(1:126,68))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,62),T5sum(1:126,68))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,94),T5sum(1:126,69))
  M(2) = M(2) + (-f(19) * den(42)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,27),T5sum(1:126,71))
  M(1) = M(1) + (-f(19) * den(42)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,59),T5sum(1:126,71))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_38,masses2_7,G5tensor(:,91),T5sum(1:126,72))
  M(2) = M(2) + (f(20) * den(45)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,28),T5sum(1:126,71))
  M(1) = M(1) + (f(20) * den(45)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,60),T5sum(1:126,71))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_38,masses2_7,G5tensor(:,92),T5sum(1:126,72))
  M(2) = M(2) + (f(20) * den(48)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,31),T5sum(1:126,71))
  M(1) = M(1) + (f(20) * den(48)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,63),T5sum(1:126,71))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_38,masses2_7,G5tensor(:,95),T5sum(1:126,72))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,32),T5sum(1:126,71))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,64),T5sum(1:126,71))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_38,masses2_7,G5tensor(:,96),T5sum(1:126,72))
  M(1) = M(1) + (-(CI*f(11)) * den(262)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,45),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(262)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,45),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(262)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(262)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(262)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(262)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,79),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(263)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(263)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,46),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(263)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(263)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(263)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(263)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,80),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(11)) * den(264)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,47),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(264)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,47),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(264)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(264)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(264)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,81),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(265)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(265)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,48),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(265)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(265)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(265)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(265)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,82),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(11)) * den(266)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,49),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(266)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,49),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(266)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(266)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(266)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,83),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(11)) * den(267)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,50),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(267)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,50),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(267)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(267)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(267)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(267)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,84),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(268)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,51),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(268)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,51),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(268)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(268)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(268)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(269)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,52),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(269)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,52),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(269)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(269)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(269)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(269)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(1) = M(1) + (f(20) * den(174)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,15),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(174)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,91),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(174)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,167),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(175)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,16),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(175)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,92),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(175)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,168),T4sum(1:70,31))
  M(1) = M(1) + (f(20) * den(176)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,17),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(176)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,93),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(176)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,169),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(177)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,18),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(177)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,94),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(177)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,170),T4sum(1:70,31))
  M(2) = M(2) + (f(20) * den(174)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,49),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(174)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,125),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(174)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,201),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(175)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,50),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(175)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,126),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(175)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,202),T4sum(1:70,33))
  M(2) = M(2) + (f(20) * den(176)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,51),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(176)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,127),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(176)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,203),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(177)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,52),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(177)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,128),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(177)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,204),T4sum(1:70,33))
  M(1) = M(1) + (f(20) * den(178)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,19),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(178)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,95),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(178)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,171),T4sum(1:70,31))
  M(1) = M(1) + (f(20) * den(179)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,20),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(179)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,96),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(179)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,172),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(180)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,21),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(180)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,97),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(180)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,173),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(181)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,22),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(181)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,98),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(181)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,174),T4sum(1:70,31))
  M(2) = M(2) + (f(20) * den(178)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,53),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(178)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,129),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(178)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,205),T4sum(1:70,33))
  M(2) = M(2) + (f(20) * den(179)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,54),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(179)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,130),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(179)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,206),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(180)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,55),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(180)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,131),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(180)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,207),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(181)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,56),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(181)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,132),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(181)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,208),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(11)) * den(286)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,53),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(286)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,53),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(286)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(286)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(286)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(286)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(287)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,54),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(287)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,54),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(287)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(287)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(287)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(287)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(11)) * den(288)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,55),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(288)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,55),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(288)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(288)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(288)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(288)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(289)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(289)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,56),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(289)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(289)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(289)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(289)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(11)) * den(290)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,57),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(290)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,57),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(290)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(290)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(290)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,91),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(290)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,91),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(291)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(291)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,58),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(291)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(291)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(291)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,92),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(291)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,92),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(11)) * den(292)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,59),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(292)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,59),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(292)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(292)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,25),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(292)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,93),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(292)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,93),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(293)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(293)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,60),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(293)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(13)) * den(293)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,26),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(13) * den(293)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,94),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(13)) * den(293)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,94),T3sum(1:35,6))
  M(1) = M(1) + (f(20) * den(182)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,23),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(182)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,99),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(182)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,175),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(183)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,24),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(183)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,100),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(183)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,176),T4sum(1:70,31))
  M(1) = M(1) + (f(20) * den(184)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,25),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(184)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,101),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(184)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,177),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(185)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,26),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(185)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,102),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(185)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,178),T4sum(1:70,31))
  M(2) = M(2) + (f(20) * den(182)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,57),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(182)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,133),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(182)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,209),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(183)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,58),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(183)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,134),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(183)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,210),T4sum(1:70,33))
  M(2) = M(2) + (f(20) * den(184)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,59),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(184)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,135),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(184)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,211),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(185)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,60),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(185)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,136),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(185)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,212),T4sum(1:70,33))
  M(1) = M(1) + (f(20) * den(186)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,27),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(186)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,103),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(186)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,179),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(187)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,28),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(187)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,104),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(187)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,180),T4sum(1:70,31))
  M(1) = M(1) + (f(20) * den(188)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,29),T4sum(1:70,30))
  M(2) = M(2) + (f(20) * den(188)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,105),T4sum(1:70,30))
  M(1) = M(1) + (-f(18) * den(188)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,181),T4sum(1:70,31))
  M(1) = M(1) + (-f(22) * den(189)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,30),T4sum(1:70,30))
  M(2) = M(2) + (-f(22) * den(189)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,106),T4sum(1:70,30))
  M(1) = M(1) + (-f(22) * den(189)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,182),T4sum(1:70,31))
  M(2) = M(2) + (f(20) * den(186)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,61),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(186)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,137),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(186)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,213),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(187)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,62),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(187)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,138),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(187)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,214),T4sum(1:70,33))
  M(2) = M(2) + (f(20) * den(188)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,63),T4sum(1:70,32))
  M(1) = M(1) + (f(20) * den(188)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,139),T4sum(1:70,32))
  M(2) = M(2) + (-f(18) * den(188)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,215),T4sum(1:70,33))
  M(2) = M(2) + (-f(22) * den(189)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,64),T4sum(1:70,32))
  M(1) = M(1) + (-f(22) * den(189)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,140),T4sum(1:70,32))
  M(2) = M(2) + (-f(22) * den(189)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,216),T4sum(1:70,33))
  M(1) = M(1) + (CI*f(11) * den(310)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,61),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(310)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,61),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(310)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(310)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,27),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(310)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,95),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(310)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,95),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(311)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,62),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(311)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,62),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(311)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(311)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,28),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(311)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,96),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(311)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,96),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(312)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,63),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(312)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,63),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(312)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(312)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,29),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(312)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(312)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,97),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(313)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,64),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(313)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,64),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(313)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(313)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,30),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(313)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(313)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,98),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(314)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,65),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(314)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,65),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(314)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(314)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,31),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(314)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(314)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,99),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(315)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,66),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(315)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,66),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(315)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(315)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,32),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(315)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(315)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,100),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(316)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(316)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(316)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(316)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,33),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(316)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(316)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,101),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(13)) * den(317)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(317)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(317)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(13) * den(317)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,34),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(13)) * den(317)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(13) * den(317)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,102),T3sum(1:35,6))
  M(1) = M(1) + (-f(20) * den(190)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,31),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(190)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,107),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(190)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,183),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(191)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,32),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(191)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,108),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(191)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,184),T4sum(1:70,31))
  M(1) = M(1) + (-f(20) * den(192)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,33),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(192)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,109),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(192)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,185),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(193)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,34),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(193)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,110),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(193)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,186),T4sum(1:70,31))
  M(2) = M(2) + (-f(20) * den(190)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,65),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(190)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,141),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(190)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,217),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(191)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,66),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(191)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,142),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(191)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,218),T4sum(1:70,33))
  M(2) = M(2) + (-f(20) * den(192)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,67),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(192)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,143),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(192)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,219),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(193)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,68),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(193)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,144),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(193)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,220),T4sum(1:70,33))
  M(1) = M(1) + (-f(20) * den(194)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,35),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(194)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,111),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(194)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,187),T4sum(1:70,31))
  M(1) = M(1) + (-f(20) * den(195)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,36),T4sum(1:70,30))
  M(2) = M(2) + (-f(20) * den(195)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,112),T4sum(1:70,30))
  M(1) = M(1) + (f(18) * den(195)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,188),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(196)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,37),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(196)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,113),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(196)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,189),T4sum(1:70,31))
  M(1) = M(1) + (f(22) * den(197)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,38),T4sum(1:70,30))
  M(2) = M(2) + (f(22) * den(197)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,114),T4sum(1:70,30))
  M(1) = M(1) + (f(22) * den(197)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,190),T4sum(1:70,31))
  M(2) = M(2) + (-f(20) * den(194)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,69),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(194)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,145),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(194)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,221),T4sum(1:70,33))
  M(2) = M(2) + (-f(20) * den(195)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,70),T4sum(1:70,32))
  M(1) = M(1) + (-f(20) * den(195)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,146),T4sum(1:70,32))
  M(2) = M(2) + (f(18) * den(195)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,222),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(196)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,71),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(196)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,147),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(196)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,223),T4sum(1:70,33))
  M(2) = M(2) + (f(22) * den(197)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,72),T4sum(1:70,32))
  M(1) = M(1) + (f(22) * den(197)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,148),T4sum(1:70,32))
  M(2) = M(2) + (f(22) * den(197)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,224),T4sum(1:70,33))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_4_ppllllj2_eeexexggg_1_/**/REALKIND
