
module ol_vamp_3_ppllllj2_nenexeexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenexeexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenexeexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenexeexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenexeexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,8) :: G0
  complex(REALKIND), dimension(4,5,4,51) :: G1
  complex(REALKIND), dimension(4,15,4,215) :: G2
  complex(REALKIND), dimension(4,35,4,338) :: G3
  complex(REALKIND), dimension(4,70,4,144) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,62,128))
    allocate(G4tensorhel(70,161,128))
    allocate(G5tensorhel(126,76,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,16),MB,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,12),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,112),MB,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,61),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,127),MB,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,85),G2(:,:,:,3))
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,127),MB,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,86),G2(:,:,:,4),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,127),MB,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,87),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,127),MB,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,88),G2(:,:,:,6),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,127),MB,G3tensor(:,5))
  call loop_QS_A(G2(:,:,:,1),wf(:,74),G2(:,:,:,7),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,127),MB,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,1),wf(:,43),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,127),MB,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,75),G2(:,:,:,9),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,127),MB,G3tensor(:,8))
  call loop_QV_A(G2(:,:,:,1),wf(:,89),G2(:,:,:,10))
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,127),MB,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,1),wf(:,90),G2(:,:,:,11),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,127),MB,G3tensor(:,10))
  call loop_QZ_A(G2(:,:,:,1),wf(:,91),G2(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,127),MB,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,1),wf(:,92),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,127),MB,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,1),wf(:,93),G2(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,127),MB,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,1),wf(:,94),G2(:,:,:,15),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,127),MB,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,1),wf(:,95),G2(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,127),MB,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,1),wf(:,96),G2(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,127),MB,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,28),MB,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,12),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,124),MB,G3(:,:,:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,127),MB,G4tensor(:,1))
  call loop_QV_A(G2(:,:,:,18),wf(:,-6),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,92),MB,G3(:,:,:,3))
  call loop_QV_A(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_Q_A(G3(:,:,:,4),Q(:,124),MB,G4(:,:,:,1))
  call loop_QZ_A(G4(:,:,:,1),wf(:,4),G4(:,:,:,2),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,127),MB,G5tensor(:,1))
  call loop_QV_A(G2(:,:,:,18),wf(:,-5),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,60),MB,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,-6),G3(:,:,:,6))
  call loop_Q_A(G3(:,:,:,6),Q(:,124),MB,G4(:,:,:,3))
  call loop_QZ_A(G4(:,:,:,3),wf(:,4),G4(:,:,:,4),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,127),MB,G5tensor(:,2))
  call loop_QZ_A(G1(:,:,:,1),wf(:,7),G1(:,:,:,4),gZd)
  call loop_Q_A(G1(:,:,:,4),Q(:,28),MB,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,12),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,124),MB,G3(:,:,:,7))
  call loop_QZ_A(G3(:,:,:,7),wf(:,4),G3(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,127),MB,G4tensor(:,2))
  call loop_QV_A(G2(:,:,:,22),wf(:,-6),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,92),MB,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,-5),G3(:,:,:,10))
  call loop_Q_A(G3(:,:,:,10),Q(:,124),MB,G4(:,:,:,5))
  call loop_QZ_A(G4(:,:,:,5),wf(:,4),G4(:,:,:,6),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,6),Q(:,127),MB,G5tensor(:,3))
  call loop_QV_A(G2(:,:,:,22),wf(:,-5),G2(:,:,:,25))
  call loop_Q_A(G2(:,:,:,25),Q(:,60),MB,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,-6),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,124),MB,G4(:,:,:,7))
  call loop_QZ_A(G4(:,:,:,7),wf(:,4),G4(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,127),MB,G5tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,48),MB,G2(:,:,:,26))
  call loop_QV_A(G2(:,:,:,26),wf(:,-6),G2(:,:,:,27))
  call loop_Q_A(G2(:,:,:,27),Q(:,112),MB,G3(:,:,:,13))
  call loop_QS_A(G3(:,:,:,13),wf(:,61),G3(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,3))
  call loop_QV_A(G3(:,:,:,13),wf(:,85),G3(:,:,:,15))
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,127),MB,G4tensor(:,4))
  call loop_QZ_A(G3(:,:,:,13),wf(:,86),G3(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,5))
  call loop_QV_A(G3(:,:,:,13),wf(:,87),G3(:,:,:,17))
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,127),MB,G4tensor(:,6))
  call loop_QZ_A(G3(:,:,:,13),wf(:,88),G3(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,127),MB,G4tensor(:,7))
  call loop_QS_A(G3(:,:,:,13),wf(:,74),G3(:,:,:,19),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,19),Q(:,127),MB,G4tensor(:,8))
  call loop_QV_A(G3(:,:,:,13),wf(:,43),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,127),MB,G4tensor(:,9))
  call loop_QZ_A(G3(:,:,:,13),wf(:,75),G3(:,:,:,21),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,21),Q(:,127),MB,G4tensor(:,10))
  call loop_QV_A(G3(:,:,:,13),wf(:,89),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,127),MB,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,13),wf(:,90),G3(:,:,:,23),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,23),Q(:,127),MB,G4tensor(:,12))
  call loop_QZ_A(G3(:,:,:,13),wf(:,91),G3(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,127),MB,G4tensor(:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,92),G3(:,:,:,25))
  call check_last_Q_A(l_switch,G3(:,:,:,25),Q(:,127),MB,G4tensor(:,14))
  call loop_QZ_A(G3(:,:,:,13),wf(:,93),G3(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,127),MB,G4tensor(:,15))
  call loop_QZ_A(G3(:,:,:,13),wf(:,94),G3(:,:,:,27),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,27),Q(:,127),MB,G4tensor(:,16))
  call loop_QZ_A(G3(:,:,:,13),wf(:,95),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,127),MB,G4tensor(:,17))
  call loop_QZ_A(G3(:,:,:,13),wf(:,96),G3(:,:,:,29),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,29),Q(:,127),MB,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,26),wf(:,2),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,60),MB,G3(:,:,:,30))
  call loop_QV_A(G3(:,:,:,30),wf(:,-6),G3(:,:,:,31))
  call loop_Q_A(G3(:,:,:,31),Q(:,124),MB,G4(:,:,:,9))
  call loop_QZ_A(G4(:,:,:,9),wf(:,4),G4(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,127),MB,G5tensor(:,5))
  call loop_QZ_A(G2(:,:,:,26),wf(:,7),G2(:,:,:,29),gZd)
  call loop_Q_A(G2(:,:,:,29),Q(:,60),MB,G3(:,:,:,32))
  call loop_QV_A(G3(:,:,:,32),wf(:,-6),G3(:,:,:,33))
  call loop_Q_A(G3(:,:,:,33),Q(:,124),MB,G4(:,:,:,11))
  call loop_QZ_A(G4(:,:,:,11),wf(:,4),G4(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,127),MB,G5tensor(:,6))
  call loop_QW_A(G2(:,:,:,26),wf(:,38),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,57),MT,G3(:,:,:,34))
  call loop_QV_A(G3(:,:,:,34),wf(:,-6),G3(:,:,:,35))
  call loop_Q_A(G3(:,:,:,35),Q(:,121),MT,G4(:,:,:,13))
  call loop_QW_A(G4(:,:,:,13),wf(:,39),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,127),MB,G5tensor(:,7))
  call loop_QV_A(G1(:,:,:,1),wf(:,-6),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,80),MB,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,112),MB,G3(:,:,:,36))
  call loop_QS_A(G3(:,:,:,36),wf(:,61),G3(:,:,:,37),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,37),Q(:,127),MB,G4tensor(:,19))
  call loop_QV_A(G3(:,:,:,36),wf(:,85),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,127),MB,G4tensor(:,20))
  call loop_QZ_A(G3(:,:,:,36),wf(:,86),G3(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,39),Q(:,127),MB,G4tensor(:,21))
  call loop_QV_A(G3(:,:,:,36),wf(:,87),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,127),MB,G4tensor(:,22))
  call loop_QZ_A(G3(:,:,:,36),wf(:,88),G3(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,41),Q(:,127),MB,G4tensor(:,23))
  call loop_QS_A(G3(:,:,:,36),wf(:,74),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,127),MB,G4tensor(:,24))
  call loop_QV_A(G3(:,:,:,36),wf(:,43),G3(:,:,:,43))
  call check_last_Q_A(l_switch,G3(:,:,:,43),Q(:,127),MB,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,36),wf(:,75),G3(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,127),MB,G4tensor(:,26))
  call loop_QV_A(G3(:,:,:,36),wf(:,89),G3(:,:,:,45))
  call check_last_Q_A(l_switch,G3(:,:,:,45),Q(:,127),MB,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,36),wf(:,90),G3(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,127),MB,G4tensor(:,28))
  call loop_QZ_A(G3(:,:,:,36),wf(:,91),G3(:,:,:,47),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,47),Q(:,127),MB,G4tensor(:,29))
  call loop_QV_A(G3(:,:,:,36),wf(:,92),G3(:,:,:,48))
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,127),MB,G4tensor(:,30))
  call loop_QZ_A(G3(:,:,:,36),wf(:,93),G3(:,:,:,49),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,49),Q(:,127),MB,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,36),wf(:,94),G3(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,127),MB,G4tensor(:,32))
  call loop_QZ_A(G3(:,:,:,36),wf(:,95),G3(:,:,:,51),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,51),Q(:,127),MB,G4tensor(:,33))
  call loop_QZ_A(G3(:,:,:,36),wf(:,96),G3(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,127),MB,G4tensor(:,34))
  call loop_QV_A(G2(:,:,:,31),wf(:,2),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,92),MB,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,-5),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,124),MB,G4(:,:,:,15))
  call loop_QZ_A(G4(:,:,:,15),wf(:,4),G4(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,127),MB,G5tensor(:,8))
  call loop_QZ_A(G2(:,:,:,31),wf(:,7),G2(:,:,:,34),gZd)
  call loop_Q_A(G2(:,:,:,34),Q(:,92),MB,G3(:,:,:,55))
  call loop_QV_A(G3(:,:,:,55),wf(:,-5),G3(:,:,:,56))
  call loop_Q_A(G3(:,:,:,56),Q(:,124),MB,G4(:,:,:,17))
  call loop_QZ_A(G4(:,:,:,17),wf(:,4),G4(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,127),MB,G5tensor(:,9))
  call loop_QW_A(G2(:,:,:,31),wf(:,38),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,89),MT,G3(:,:,:,57))
  call loop_QV_A(G3(:,:,:,57),wf(:,-5),G3(:,:,:,58))
  call loop_Q_A(G3(:,:,:,58),Q(:,121),MT,G4(:,:,:,19))
  call loop_QW_A(G4(:,:,:,19),wf(:,39),G4(:,:,:,20))
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,127),MB,G5tensor(:,10))
  call loop_QW_A(G1(:,:,:,1),wf(:,38),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,25),MT,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,12),G2(:,:,:,37))
  call loop_Q_A(G2(:,:,:,37),Q(:,121),MT,G3(:,:,:,59))
  call loop_QW_A(G3(:,:,:,59),wf(:,39),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,127),MB,G4tensor(:,35))
  call loop_QV_A(G2(:,:,:,36),wf(:,-5),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,57),MT,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,-6),G3(:,:,:,62))
  call loop_Q_A(G3(:,:,:,62),Q(:,121),MT,G4(:,:,:,21))
  call loop_QW_A(G4(:,:,:,21),wf(:,39),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,127),MB,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,36),wf(:,-6),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,89),MT,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-5),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,121),MT,G4(:,:,:,23))
  call loop_QW_A(G4(:,:,:,23),wf(:,39),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,127),MB,G5tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,2),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,28),ZERO,G2(:,:,:,40))
  call loop_QV_A(G2(:,:,:,40),wf(:,12),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,124),ZERO,G3(:,:,:,65))
  call loop_QZ_A(G3(:,:,:,65),wf(:,4),G3(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),ZERO,G4tensor(:,36))
  call loop_QZ_A(G3(:,:,:,65),wf(:,4),G3(:,:,:,67),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,67),Q(:,127),ZERO,G4tensor(:,37))
  call loop_QV_A(G2(:,:,:,40),wf(:,-6),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,92),ZERO,G3(:,:,:,68))
  call loop_QV_A(G3(:,:,:,68),wf(:,-5),G3(:,:,:,69))
  call loop_Q_A(G3(:,:,:,69),Q(:,124),ZERO,G4(:,:,:,25))
  call loop_QZ_A(G4(:,:,:,25),wf(:,4),G4(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,127),ZERO,G5tensor(:,13))
  call loop_QZ_A(G4(:,:,:,25),wf(:,4),G4(:,:,:,27),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,27),Q(:,127),ZERO,G5tensor(:,14))
  call loop_QV_A(G2(:,:,:,40),wf(:,-5),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,60),ZERO,G3(:,:,:,70))
  call loop_QV_A(G3(:,:,:,70),wf(:,-6),G3(:,:,:,71))
  call loop_Q_A(G3(:,:,:,71),Q(:,124),ZERO,G4(:,:,:,28))
  call loop_QZ_A(G4(:,:,:,28),wf(:,4),G4(:,:,:,29),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,29),Q(:,127),ZERO,G5tensor(:,15))
  call loop_QZ_A(G4(:,:,:,28),wf(:,4),G4(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,127),ZERO,G5tensor(:,16))
  call loop_QZ_A(G1(:,:,:,8),wf(:,7),G1(:,:,:,10),gZu)
  call loop_Q_A(G1(:,:,:,10),Q(:,28),ZERO,G2(:,:,:,44))
  call loop_QV_A(G2(:,:,:,44),wf(:,12),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,124),ZERO,G3(:,:,:,72))
  call loop_QZ_A(G3(:,:,:,72),wf(:,4),G3(:,:,:,73),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,73),Q(:,127),ZERO,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,44),wf(:,-6),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,92),ZERO,G3(:,:,:,74))
  call loop_QV_A(G3(:,:,:,74),wf(:,-5),G3(:,:,:,75))
  call loop_Q_A(G3(:,:,:,75),Q(:,124),ZERO,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,4),G4(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),ZERO,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,44),wf(:,-5),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,60),ZERO,G3(:,:,:,76))
  call loop_QV_A(G3(:,:,:,76),wf(:,-6),G3(:,:,:,77))
  call loop_Q_A(G3(:,:,:,77),Q(:,124),ZERO,G4(:,:,:,33))
  call loop_QZ_A(G4(:,:,:,33),wf(:,4),G4(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,127),ZERO,G5tensor(:,18))
  call loop_QZ_A(G1(:,:,:,8),wf(:,7),G1(:,:,:,11),gZd)
  call loop_Q_A(G1(:,:,:,11),Q(:,28),ZERO,G2(:,:,:,48))
  call loop_QV_A(G2(:,:,:,48),wf(:,12),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,124),ZERO,G3(:,:,:,78))
  call loop_QZ_A(G3(:,:,:,78),wf(:,4),G3(:,:,:,79),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,127),ZERO,G4tensor(:,39))
  call loop_QV_A(G2(:,:,:,48),wf(:,-6),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,92),ZERO,G3(:,:,:,80))
  call loop_QV_A(G3(:,:,:,80),wf(:,-5),G3(:,:,:,81))
  call loop_Q_A(G3(:,:,:,81),Q(:,124),ZERO,G4(:,:,:,35))
  call loop_QZ_A(G4(:,:,:,35),wf(:,4),G4(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,127),ZERO,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,48),wf(:,-5),G2(:,:,:,51))
  call loop_Q_A(G2(:,:,:,51),Q(:,60),ZERO,G3(:,:,:,82))
  call loop_QV_A(G3(:,:,:,82),wf(:,-6),G3(:,:,:,83))
  call loop_Q_A(G3(:,:,:,83),Q(:,124),ZERO,G4(:,:,:,37))
  call loop_QZ_A(G4(:,:,:,37),wf(:,4),G4(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),ZERO,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,8),wf(:,-5),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,48),ZERO,G2(:,:,:,52))
  call loop_QV_A(G2(:,:,:,52),wf(:,2),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,60),ZERO,G3(:,:,:,84))
  call loop_QV_A(G3(:,:,:,84),wf(:,-6),G3(:,:,:,85))
  call loop_Q_A(G3(:,:,:,85),Q(:,124),ZERO,G4(:,:,:,39))
  call loop_QZ_A(G4(:,:,:,39),wf(:,4),G4(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,127),ZERO,G5tensor(:,21))
  call loop_QZ_A(G4(:,:,:,39),wf(:,4),G4(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,41),Q(:,127),ZERO,G5tensor(:,22))
  call loop_QZ_A(G2(:,:,:,52),wf(:,7),G2(:,:,:,54),gZu)
  call loop_Q_A(G2(:,:,:,54),Q(:,60),ZERO,G3(:,:,:,86))
  call loop_QV_A(G3(:,:,:,86),wf(:,-6),G3(:,:,:,87))
  call loop_Q_A(G3(:,:,:,87),Q(:,124),ZERO,G4(:,:,:,42))
  call loop_QZ_A(G4(:,:,:,42),wf(:,4),G4(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,43),Q(:,127),ZERO,G5tensor(:,23))
  call loop_QZ_A(G2(:,:,:,52),wf(:,7),G2(:,:,:,55),gZd)
  call loop_Q_A(G2(:,:,:,55),Q(:,60),ZERO,G3(:,:,:,88))
  call loop_QV_A(G3(:,:,:,88),wf(:,-6),G3(:,:,:,89))
  call loop_Q_A(G3(:,:,:,89),Q(:,124),ZERO,G4(:,:,:,44))
  call loop_QZ_A(G4(:,:,:,44),wf(:,4),G4(:,:,:,45),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,45),Q(:,127),ZERO,G5tensor(:,24))
  call loop_QV_A(G2(:,:,:,52),wf(:,-6),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,112),ZERO,G3(:,:,:,90))
  call loop_QV_A(G3(:,:,:,90),wf(:,85),G3(:,:,:,91))
  call check_last_Q_A(l_switch,G3(:,:,:,91),Q(:,127),ZERO,G4tensor(:,40))
  call loop_QZ_A(G3(:,:,:,90),wf(:,86),G3(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),ZERO,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,90),wf(:,86),G3(:,:,:,93),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,127),ZERO,G4tensor(:,42))
  call loop_QV_A(G3(:,:,:,90),wf(:,87),G3(:,:,:,94))
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,127),ZERO,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,90),wf(:,88),G3(:,:,:,95),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,95),Q(:,127),ZERO,G4tensor(:,44))
  call loop_QZ_A(G3(:,:,:,90),wf(:,88),G3(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,127),ZERO,G4tensor(:,45))
  call loop_QV_A(G3(:,:,:,90),wf(:,43),G3(:,:,:,97))
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,127),ZERO,G4tensor(:,46))
  call loop_QZ_A(G3(:,:,:,90),wf(:,75),G3(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),ZERO,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,90),wf(:,75),G3(:,:,:,99),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,127),ZERO,G4tensor(:,48))
  call loop_QV_A(G3(:,:,:,90),wf(:,89),G3(:,:,:,100))
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,127),ZERO,G4tensor(:,49))
  call loop_QZ_A(G3(:,:,:,90),wf(:,90),G3(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,127),ZERO,G4tensor(:,50))
  call loop_QZ_A(G3(:,:,:,90),wf(:,90),G3(:,:,:,102),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,127),ZERO,G4tensor(:,51))
  call loop_QZ_A(G3(:,:,:,90),wf(:,91),G3(:,:,:,103),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,103),Q(:,127),ZERO,G4tensor(:,52))
  call loop_QZ_A(G3(:,:,:,90),wf(:,91),G3(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,127),ZERO,G4tensor(:,53))
  call loop_QV_A(G3(:,:,:,90),wf(:,92),G3(:,:,:,105))
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,127),ZERO,G4tensor(:,54))
  call loop_QZ_A(G3(:,:,:,90),wf(:,93),G3(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),ZERO,G4tensor(:,55))
  call loop_QZ_A(G3(:,:,:,90),wf(:,93),G3(:,:,:,107),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,107),Q(:,127),ZERO,G4tensor(:,56))
  call loop_QZ_A(G3(:,:,:,90),wf(:,94),G3(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),ZERO,G4tensor(:,57))
  call loop_QZ_A(G3(:,:,:,90),wf(:,94),G3(:,:,:,109),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,109),Q(:,127),ZERO,G4tensor(:,58))
  call loop_QZ_A(G3(:,:,:,90),wf(:,95),G3(:,:,:,110),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,127),ZERO,G4tensor(:,59))
  call loop_QZ_A(G3(:,:,:,90),wf(:,95),G3(:,:,:,111),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,111),Q(:,127),ZERO,G4tensor(:,60))
  call loop_QZ_A(G3(:,:,:,90),wf(:,96),G3(:,:,:,112),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,127),ZERO,G4tensor(:,61))
  call loop_QZ_A(G3(:,:,:,90),wf(:,96),G3(:,:,:,113),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,113),Q(:,127),ZERO,G4tensor(:,62))
  call loop_QW_A(G2(:,:,:,52),wf(:,38),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,57),ZERO,G3(:,:,:,114))
  call loop_QV_A(G3(:,:,:,114),wf(:,-6),G3(:,:,:,115))
  call loop_Q_A(G3(:,:,:,115),Q(:,121),ZERO,G4(:,:,:,46))
  call loop_QW_A(G4(:,:,:,46),wf(:,39),G4(:,:,:,47))
  call check_last_Q_A(l_switch,G4(:,:,:,47),Q(:,127),ZERO,G5tensor(:,25))
  call loop_QV_A(G1(:,:,:,8),wf(:,-6),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,80),ZERO,G2(:,:,:,58))
  call loop_QV_A(G2(:,:,:,58),wf(:,2),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,92),ZERO,G3(:,:,:,116))
  call loop_QV_A(G3(:,:,:,116),wf(:,-5),G3(:,:,:,117))
  call loop_Q_A(G3(:,:,:,117),Q(:,124),ZERO,G4(:,:,:,48))
  call loop_QZ_A(G4(:,:,:,48),wf(:,4),G4(:,:,:,49),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,49),Q(:,127),ZERO,G5tensor(:,26))
  call loop_QZ_A(G4(:,:,:,48),wf(:,4),G4(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,27))
  call loop_QZ_A(G2(:,:,:,58),wf(:,7),G2(:,:,:,60),gZu)
  call loop_Q_A(G2(:,:,:,60),Q(:,92),ZERO,G3(:,:,:,118))
  call loop_QV_A(G3(:,:,:,118),wf(:,-5),G3(:,:,:,119))
  call loop_Q_A(G3(:,:,:,119),Q(:,124),ZERO,G4(:,:,:,51))
  call loop_QZ_A(G4(:,:,:,51),wf(:,4),G4(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,127),ZERO,G5tensor(:,28))
  call loop_QZ_A(G2(:,:,:,58),wf(:,7),G2(:,:,:,61),gZd)
  call loop_Q_A(G2(:,:,:,61),Q(:,92),ZERO,G3(:,:,:,120))
  call loop_QV_A(G3(:,:,:,120),wf(:,-5),G3(:,:,:,121))
  call loop_Q_A(G3(:,:,:,121),Q(:,124),ZERO,G4(:,:,:,53))
  call loop_QZ_A(G4(:,:,:,53),wf(:,4),G4(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,58),wf(:,-5),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,112),ZERO,G3(:,:,:,122))
  call loop_QV_A(G3(:,:,:,122),wf(:,85),G3(:,:,:,123))
  call check_last_Q_A(l_switch,G3(:,:,:,123),Q(:,127),ZERO,G4tensor(:,63))
  call loop_QZ_A(G3(:,:,:,122),wf(:,86),G3(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),ZERO,G4tensor(:,64))
  call loop_QZ_A(G3(:,:,:,122),wf(:,86),G3(:,:,:,125),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,125),Q(:,127),ZERO,G4tensor(:,65))
  call loop_QV_A(G3(:,:,:,122),wf(:,87),G3(:,:,:,126))
  call check_last_Q_A(l_switch,G3(:,:,:,126),Q(:,127),ZERO,G4tensor(:,66))
  call loop_QZ_A(G3(:,:,:,122),wf(:,88),G3(:,:,:,127),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,127),Q(:,127),ZERO,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,122),wf(:,88),G3(:,:,:,128),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),ZERO,G4tensor(:,68))
  call loop_QV_A(G3(:,:,:,122),wf(:,43),G3(:,:,:,129))
  call check_last_Q_A(l_switch,G3(:,:,:,129),Q(:,127),ZERO,G4tensor(:,69))
  call loop_QZ_A(G3(:,:,:,122),wf(:,75),G3(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,70))
  call loop_QZ_A(G3(:,:,:,122),wf(:,75),G3(:,:,:,131),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,131),Q(:,127),ZERO,G4tensor(:,71))
  call loop_QV_A(G3(:,:,:,122),wf(:,89),G3(:,:,:,132))
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,127),ZERO,G4tensor(:,72))
  call loop_QZ_A(G3(:,:,:,122),wf(:,90),G3(:,:,:,133),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,133),Q(:,127),ZERO,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,122),wf(:,90),G3(:,:,:,134),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,127),ZERO,G4tensor(:,74))
  call loop_QZ_A(G3(:,:,:,122),wf(:,91),G3(:,:,:,135),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,135),Q(:,127),ZERO,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,122),wf(:,91),G3(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,127),ZERO,G4tensor(:,76))
  call loop_QV_A(G3(:,:,:,122),wf(:,92),G3(:,:,:,137))
  call check_last_Q_A(l_switch,G3(:,:,:,137),Q(:,127),ZERO,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,122),wf(:,93),G3(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,127),ZERO,G4tensor(:,78))
  call loop_QZ_A(G3(:,:,:,122),wf(:,93),G3(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,127),ZERO,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,122),wf(:,94),G3(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),ZERO,G4tensor(:,80))
  call loop_QZ_A(G3(:,:,:,122),wf(:,94),G3(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,141),Q(:,127),ZERO,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,122),wf(:,95),G3(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),ZERO,G4tensor(:,82))
  call loop_QZ_A(G3(:,:,:,122),wf(:,95),G3(:,:,:,143),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,127),ZERO,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,122),wf(:,96),G3(:,:,:,144),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,144),Q(:,127),ZERO,G4tensor(:,84))
  call loop_QZ_A(G3(:,:,:,122),wf(:,96),G3(:,:,:,145),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,145),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QW_A(G2(:,:,:,58),wf(:,38),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,89),ZERO,G3(:,:,:,146))
  call loop_QV_A(G3(:,:,:,146),wf(:,-5),G3(:,:,:,147))
  call loop_Q_A(G3(:,:,:,147),Q(:,121),ZERO,G4(:,:,:,55))
  call loop_QW_A(G4(:,:,:,55),wf(:,39),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),ZERO,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,8),wf(:,12),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,112),ZERO,G2(:,:,:,64))
  call loop_QV_A(G2(:,:,:,64),wf(:,85),G2(:,:,:,65))
  call check_last_Q_A(l_switch,G2(:,:,:,65),Q(:,127),ZERO,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,64),wf(:,86),G2(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,127),ZERO,G3tensor(:,18))
  call loop_QZ_A(G2(:,:,:,64),wf(:,86),G2(:,:,:,67),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,127),ZERO,G3tensor(:,19))
  call loop_QV_A(G2(:,:,:,64),wf(:,87),G2(:,:,:,68))
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,127),ZERO,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,64),wf(:,88),G2(:,:,:,69),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,127),ZERO,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,64),wf(:,88),G2(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,127),ZERO,G3tensor(:,22))
  call loop_QV_A(G2(:,:,:,64),wf(:,43),G2(:,:,:,71))
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,127),ZERO,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,64),wf(:,75),G2(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,127),ZERO,G3tensor(:,24))
  call loop_QZ_A(G2(:,:,:,64),wf(:,75),G2(:,:,:,73),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,127),ZERO,G3tensor(:,25))
  call loop_QV_A(G2(:,:,:,64),wf(:,89),G2(:,:,:,74))
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,127),ZERO,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,64),wf(:,90),G2(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,127),ZERO,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,64),wf(:,90),G2(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,127),ZERO,G3tensor(:,28))
  call loop_QZ_A(G2(:,:,:,64),wf(:,91),G2(:,:,:,77),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,127),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,64),wf(:,91),G2(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,127),ZERO,G3tensor(:,30))
  call loop_QV_A(G2(:,:,:,64),wf(:,92),G2(:,:,:,79))
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,127),ZERO,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,64),wf(:,93),G2(:,:,:,80),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,127),ZERO,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,64),wf(:,93),G2(:,:,:,81),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,127),ZERO,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,64),wf(:,94),G2(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,127),ZERO,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,64),wf(:,94),G2(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,127),ZERO,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,64),wf(:,95),G2(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,127),ZERO,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,64),wf(:,95),G2(:,:,:,85),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,127),ZERO,G3tensor(:,37))
  call loop_QZ_A(G2(:,:,:,64),wf(:,96),G2(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,127),ZERO,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,64),wf(:,96),G2(:,:,:,87),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,127),ZERO,G3tensor(:,39))
  call loop_QW_A(G1(:,:,:,8),wf(:,38),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,25),ZERO,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,12),G2(:,:,:,89))
  call loop_Q_A(G2(:,:,:,89),Q(:,121),ZERO,G3(:,:,:,148))
  call loop_QW_A(G3(:,:,:,148),wf(:,39),G3(:,:,:,149))
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QV_A(G2(:,:,:,88),wf(:,-5),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,57),ZERO,G3(:,:,:,150))
  call loop_QV_A(G3(:,:,:,150),wf(:,-6),G3(:,:,:,151))
  call loop_Q_A(G3(:,:,:,151),Q(:,121),ZERO,G4(:,:,:,57))
  call loop_QW_A(G4(:,:,:,57),wf(:,39),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,127),ZERO,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,88),wf(:,-6),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,89),ZERO,G3(:,:,:,152))
  call loop_QV_A(G3(:,:,:,152),wf(:,-5),G3(:,:,:,153))
  call loop_Q_A(G3(:,:,:,153),Q(:,121),ZERO,G4(:,:,:,59))
  call loop_QW_A(G4(:,:,:,59),wf(:,39),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),ZERO,G1(:,:,:,16))
  call loop_AV_Q(G1(:,:,:,16),wf(:,2),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,28),ZERO,G2(:,:,:,92))
  call loop_AV_Q(G2(:,:,:,92),wf(:,12),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,124),ZERO,G3(:,:,:,154))
  call loop_AZ_Q(G3(:,:,:,154),wf(:,4),G3(:,:,:,155),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,155),Q(:,127),ZERO,G4tensor(:,87))
  call loop_AZ_Q(G3(:,:,:,154),wf(:,4),G3(:,:,:,156),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,127),ZERO,G4tensor(:,88))
  call loop_AV_Q(G2(:,:,:,92),wf(:,-6),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,92),ZERO,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-5),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,124),ZERO,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,4),G4(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,127),ZERO,G5tensor(:,33))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,4),G4(:,:,:,63),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,63),Q(:,127),ZERO,G5tensor(:,34))
  call loop_AV_Q(G2(:,:,:,92),wf(:,-5),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,60),ZERO,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-6),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,124),ZERO,G4(:,:,:,64))
  call loop_AZ_Q(G4(:,:,:,64),wf(:,4),G4(:,:,:,65),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,65),Q(:,127),ZERO,G5tensor(:,35))
  call loop_AZ_Q(G4(:,:,:,64),wf(:,4),G4(:,:,:,66),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,127),ZERO,G5tensor(:,36))
  call loop_AZ_Q(G1(:,:,:,16),wf(:,7),G1(:,:,:,18),gZu)
  call loop_A_Q(G1(:,:,:,18),Q(:,28),ZERO,G2(:,:,:,96))
  call loop_AV_Q(G2(:,:,:,96),wf(:,12),G2(:,:,:,97))
  call loop_A_Q(G2(:,:,:,97),Q(:,124),ZERO,G3(:,:,:,161))
  call loop_AZ_Q(G3(:,:,:,161),wf(:,4),G3(:,:,:,162),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,127),ZERO,G4tensor(:,89))
  call loop_AV_Q(G2(:,:,:,96),wf(:,-6),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,92),ZERO,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,-5),G3(:,:,:,164))
  call loop_A_Q(G3(:,:,:,164),Q(:,124),ZERO,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,4),G4(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,127),ZERO,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,96),wf(:,-5),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,60),ZERO,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,-6),G3(:,:,:,166))
  call loop_A_Q(G3(:,:,:,166),Q(:,124),ZERO,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,4),G4(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,127),ZERO,G5tensor(:,38))
  call loop_AZ_Q(G1(:,:,:,16),wf(:,7),G1(:,:,:,19),gZd)
  call loop_A_Q(G1(:,:,:,19),Q(:,28),ZERO,G2(:,:,:,100))
  call loop_AV_Q(G2(:,:,:,100),wf(:,12),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,124),ZERO,G3(:,:,:,167))
  call loop_AZ_Q(G3(:,:,:,167),wf(:,4),G3(:,:,:,168),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,127),ZERO,G4tensor(:,90))
  call loop_AV_Q(G2(:,:,:,100),wf(:,-6),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,92),ZERO,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-5),G3(:,:,:,170))
  call loop_A_Q(G3(:,:,:,170),Q(:,124),ZERO,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,4),G4(:,:,:,72),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,127),ZERO,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,100),wf(:,-5),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,60),ZERO,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,-6),G3(:,:,:,172))
  call loop_A_Q(G3(:,:,:,172),Q(:,124),ZERO,G4(:,:,:,73))
  call loop_AZ_Q(G4(:,:,:,73),wf(:,4),G4(:,:,:,74),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,48),ZERO,G2(:,:,:,104))
  call loop_AV_Q(G2(:,:,:,104),wf(:,2),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,60),ZERO,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,-6),G3(:,:,:,174))
  call loop_A_Q(G3(:,:,:,174),Q(:,124),ZERO,G4(:,:,:,75))
  call loop_AZ_Q(G4(:,:,:,75),wf(:,4),G4(:,:,:,76),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,127),ZERO,G5tensor(:,41))
  call loop_AZ_Q(G4(:,:,:,75),wf(:,4),G4(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,77),Q(:,127),ZERO,G5tensor(:,42))
  call loop_AZ_Q(G2(:,:,:,104),wf(:,7),G2(:,:,:,106),gZu)
  call loop_A_Q(G2(:,:,:,106),Q(:,60),ZERO,G3(:,:,:,175))
  call loop_AV_Q(G3(:,:,:,175),wf(:,-6),G3(:,:,:,176))
  call loop_A_Q(G3(:,:,:,176),Q(:,124),ZERO,G4(:,:,:,78))
  call loop_AZ_Q(G4(:,:,:,78),wf(:,4),G4(:,:,:,79),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,79),Q(:,127),ZERO,G5tensor(:,43))
  call loop_AZ_Q(G2(:,:,:,104),wf(:,7),G2(:,:,:,107),gZd)
  call loop_A_Q(G2(:,:,:,107),Q(:,60),ZERO,G3(:,:,:,177))
  call loop_AV_Q(G3(:,:,:,177),wf(:,-6),G3(:,:,:,178))
  call loop_A_Q(G3(:,:,:,178),Q(:,124),ZERO,G4(:,:,:,80))
  call loop_AZ_Q(G4(:,:,:,80),wf(:,4),G4(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,81),Q(:,127),ZERO,G5tensor(:,44))
  call loop_AV_Q(G2(:,:,:,104),wf(:,-6),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,112),ZERO,G3(:,:,:,179))
  call loop_AV_Q(G3(:,:,:,179),wf(:,85),G3(:,:,:,180))
  call check_last_A_Q(l_switch,G3(:,:,:,180),Q(:,127),ZERO,G4tensor(:,91))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,86),G3(:,:,:,181),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,181),Q(:,127),ZERO,G4tensor(:,92))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,86),G3(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,182),Q(:,127),ZERO,G4tensor(:,93))
  call loop_AV_Q(G3(:,:,:,179),wf(:,87),G3(:,:,:,183))
  call check_last_A_Q(l_switch,G3(:,:,:,183),Q(:,127),ZERO,G4tensor(:,94))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,88),G3(:,:,:,184),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,184),Q(:,127),ZERO,G4tensor(:,95))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,88),G3(:,:,:,185),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,185),Q(:,127),ZERO,G4tensor(:,96))
  call loop_AV_Q(G3(:,:,:,179),wf(:,43),G3(:,:,:,186))
  call check_last_A_Q(l_switch,G3(:,:,:,186),Q(:,127),ZERO,G4tensor(:,97))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,75),G3(:,:,:,187),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,187),Q(:,127),ZERO,G4tensor(:,98))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,75),G3(:,:,:,188),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,188),Q(:,127),ZERO,G4tensor(:,99))
  call loop_AV_Q(G3(:,:,:,179),wf(:,89),G3(:,:,:,189))
  call check_last_A_Q(l_switch,G3(:,:,:,189),Q(:,127),ZERO,G4tensor(:,100))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,90),G3(:,:,:,190),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,190),Q(:,127),ZERO,G4tensor(:,101))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,90),G3(:,:,:,191),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,191),Q(:,127),ZERO,G4tensor(:,102))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,91),G3(:,:,:,192),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,127),ZERO,G4tensor(:,103))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,91),G3(:,:,:,193),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,193),Q(:,127),ZERO,G4tensor(:,104))
  call loop_AV_Q(G3(:,:,:,179),wf(:,92),G3(:,:,:,194))
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,105))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,93),G3(:,:,:,195),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,195),Q(:,127),ZERO,G4tensor(:,106))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,93),G3(:,:,:,196),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,127),ZERO,G4tensor(:,107))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,94),G3(:,:,:,197),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,197),Q(:,127),ZERO,G4tensor(:,108))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,94),G3(:,:,:,198),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,127),ZERO,G4tensor(:,109))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,95),G3(:,:,:,199),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,199),Q(:,127),ZERO,G4tensor(:,110))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,95),G3(:,:,:,200),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,200),Q(:,127),ZERO,G4tensor(:,111))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,96),G3(:,:,:,201),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,201),Q(:,127),ZERO,G4tensor(:,112))
  call loop_AZ_Q(G3(:,:,:,179),wf(:,96),G3(:,:,:,202),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,127),ZERO,G4tensor(:,113))
  call loop_AW_Q(G2(:,:,:,104),wf(:,38),G2(:,:,:,109))
  call loop_A_Q(G2(:,:,:,109),Q(:,57),ZERO,G3(:,:,:,203))
  call loop_AV_Q(G3(:,:,:,203),wf(:,-6),G3(:,:,:,204))
  call loop_A_Q(G3(:,:,:,204),Q(:,121),ZERO,G4(:,:,:,82))
  call loop_AW_Q(G4(:,:,:,82),wf(:,39),G4(:,:,:,83))
  call check_last_A_Q(l_switch,G4(:,:,:,83),Q(:,127),ZERO,G5tensor(:,45))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-6),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,80),ZERO,G2(:,:,:,110))
  call loop_AV_Q(G2(:,:,:,110),wf(:,2),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,92),ZERO,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-5),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,124),ZERO,G4(:,:,:,84))
  call loop_AZ_Q(G4(:,:,:,84),wf(:,4),G4(:,:,:,85),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,85),Q(:,127),ZERO,G5tensor(:,46))
  call loop_AZ_Q(G4(:,:,:,84),wf(:,4),G4(:,:,:,86),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,110),wf(:,7),G2(:,:,:,112),gZu)
  call loop_A_Q(G2(:,:,:,112),Q(:,92),ZERO,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-5),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,124),ZERO,G4(:,:,:,87))
  call loop_AZ_Q(G4(:,:,:,87),wf(:,4),G4(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,110),wf(:,7),G2(:,:,:,113),gZd)
  call loop_A_Q(G2(:,:,:,113),Q(:,92),ZERO,G3(:,:,:,209))
  call loop_AV_Q(G3(:,:,:,209),wf(:,-5),G3(:,:,:,210))
  call loop_A_Q(G3(:,:,:,210),Q(:,124),ZERO,G4(:,:,:,89))
  call loop_AZ_Q(G4(:,:,:,89),wf(:,4),G4(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,49))
  call loop_AV_Q(G2(:,:,:,110),wf(:,-5),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,112),ZERO,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,85),G3(:,:,:,212))
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,127),ZERO,G4tensor(:,114))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,86),G3(:,:,:,213),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,213),Q(:,127),ZERO,G4tensor(:,115))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,86),G3(:,:,:,214),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,127),ZERO,G4tensor(:,116))
  call loop_AV_Q(G3(:,:,:,211),wf(:,87),G3(:,:,:,215))
  call check_last_A_Q(l_switch,G3(:,:,:,215),Q(:,127),ZERO,G4tensor(:,117))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,88),G3(:,:,:,216),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,216),Q(:,127),ZERO,G4tensor(:,118))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,88),G3(:,:,:,217),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,217),Q(:,127),ZERO,G4tensor(:,119))
  call loop_AV_Q(G3(:,:,:,211),wf(:,43),G3(:,:,:,218))
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,127),ZERO,G4tensor(:,120))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,75),G3(:,:,:,219),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,219),Q(:,127),ZERO,G4tensor(:,121))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,75),G3(:,:,:,220),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,127),ZERO,G4tensor(:,122))
  call loop_AV_Q(G3(:,:,:,211),wf(:,89),G3(:,:,:,221))
  call check_last_A_Q(l_switch,G3(:,:,:,221),Q(:,127),ZERO,G4tensor(:,123))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,90),G3(:,:,:,222),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,127),ZERO,G4tensor(:,124))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,90),G3(:,:,:,223),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,223),Q(:,127),ZERO,G4tensor(:,125))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,91),G3(:,:,:,224),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,224),Q(:,127),ZERO,G4tensor(:,126))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,91),G3(:,:,:,225),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,225),Q(:,127),ZERO,G4tensor(:,127))
  call loop_AV_Q(G3(:,:,:,211),wf(:,92),G3(:,:,:,226))
  call check_last_A_Q(l_switch,G3(:,:,:,226),Q(:,127),ZERO,G4tensor(:,128))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,93),G3(:,:,:,227),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,227),Q(:,127),ZERO,G4tensor(:,129))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,93),G3(:,:,:,228),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,127),ZERO,G4tensor(:,130))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,94),G3(:,:,:,229),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,229),Q(:,127),ZERO,G4tensor(:,131))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,94),G3(:,:,:,230),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,127),ZERO,G4tensor(:,132))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,95),G3(:,:,:,231),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,231),Q(:,127),ZERO,G4tensor(:,133))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,95),G3(:,:,:,232),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,232),Q(:,127),ZERO,G4tensor(:,134))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,96),G3(:,:,:,233),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,233),Q(:,127),ZERO,G4tensor(:,135))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,96),G3(:,:,:,234),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,127),ZERO,G4tensor(:,136))
  call loop_AW_Q(G2(:,:,:,110),wf(:,38),G2(:,:,:,115))
  call loop_A_Q(G2(:,:,:,115),Q(:,89),ZERO,G3(:,:,:,235))
  call loop_AV_Q(G3(:,:,:,235),wf(:,-5),G3(:,:,:,236))
  call loop_A_Q(G3(:,:,:,236),Q(:,121),ZERO,G4(:,:,:,91))
  call loop_AW_Q(G4(:,:,:,91),wf(:,39),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,127),ZERO,G5tensor(:,50))
  call loop_AV_Q(G1(:,:,:,16),wf(:,12),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,112),ZERO,G2(:,:,:,116))
  call loop_AV_Q(G2(:,:,:,116),wf(:,85),G2(:,:,:,117))
  call check_last_A_Q(l_switch,G2(:,:,:,117),Q(:,127),ZERO,G3tensor(:,40))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,86),G2(:,:,:,118),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,118),Q(:,127),ZERO,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,86),G2(:,:,:,119),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,127),ZERO,G3tensor(:,42))
  call loop_AV_Q(G2(:,:,:,116),wf(:,87),G2(:,:,:,120))
  call check_last_A_Q(l_switch,G2(:,:,:,120),Q(:,127),ZERO,G3tensor(:,43))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,88),G2(:,:,:,121),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,121),Q(:,127),ZERO,G3tensor(:,44))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,88),G2(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,127),ZERO,G3tensor(:,45))
  call loop_AV_Q(G2(:,:,:,116),wf(:,43),G2(:,:,:,123))
  call check_last_A_Q(l_switch,G2(:,:,:,123),Q(:,127),ZERO,G3tensor(:,46))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,75),G2(:,:,:,124),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,127),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,75),G2(:,:,:,125),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,125),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AV_Q(G2(:,:,:,116),wf(:,89),G2(:,:,:,126))
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,127),ZERO,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,90),G2(:,:,:,127),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,127),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,90),G2(:,:,:,128),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,128),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,91),G2(:,:,:,129),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,91),G2(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AV_Q(G2(:,:,:,116),wf(:,92),G2(:,:,:,131))
  call check_last_A_Q(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,93),G2(:,:,:,132),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,93),G2(:,:,:,133),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,94),G2(:,:,:,134),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,94),G2(:,:,:,135),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,95),G2(:,:,:,136),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,95),G2(:,:,:,137),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,60))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,96),G2(:,:,:,138),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,116),wf(:,96),G2(:,:,:,139),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,62))
  call loop_AW_Q(G1(:,:,:,16),wf(:,38),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,25),ZERO,G2(:,:,:,140))
  call loop_AV_Q(G2(:,:,:,140),wf(:,12),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,121),ZERO,G3(:,:,:,237))
  call loop_AW_Q(G3(:,:,:,237),wf(:,39),G3(:,:,:,238))
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,127),ZERO,G4tensor(:,137))
  call loop_AV_Q(G2(:,:,:,140),wf(:,-5),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,57),ZERO,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-6),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,121),ZERO,G4(:,:,:,93))
  call loop_AW_Q(G4(:,:,:,93),wf(:,39),G4(:,:,:,94))
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,127),ZERO,G5tensor(:,51))
  call loop_AV_Q(G2(:,:,:,140),wf(:,-6),G2(:,:,:,143))
  call loop_A_Q(G2(:,:,:,143),Q(:,89),ZERO,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,-5),G3(:,:,:,242))
  call loop_A_Q(G3(:,:,:,242),Q(:,121),ZERO,G4(:,:,:,95))
  call loop_AW_Q(G4(:,:,:,95),wf(:,39),G4(:,:,:,96))
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,127),ZERO,G5tensor(:,52))
  call loop_QW_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,9),ZERO,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,-6),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,73),ZERO,G2(:,:,:,144))
  call loop_QV_A(G2(:,:,:,144),wf(:,3),G2(:,:,:,145))
  call loop_Q_A(G2(:,:,:,145),Q(:,121),ZERO,G3(:,:,:,243))
  call loop_QW_A(G3(:,:,:,243),wf(:,39),G3(:,:,:,244))
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,127),ZERO,G4tensor(:,138))
  call loop_QV_A(G2(:,:,:,144),wf(:,-4),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,89),ZERO,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-5),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,121),ZERO,G4(:,:,:,97))
  call loop_QW_A(G4(:,:,:,97),wf(:,39),G4(:,:,:,98))
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,127),ZERO,G5tensor(:,53))
  call loop_QV_A(G2(:,:,:,144),wf(:,-5),G2(:,:,:,147))
  call loop_Q_A(G2(:,:,:,147),Q(:,105),ZERO,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-4),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,121),ZERO,G4(:,:,:,99))
  call loop_QW_A(G4(:,:,:,99),wf(:,39),G4(:,:,:,100))
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,127),ZERO,G5tensor(:,54))
  call loop_QV_A(G1(:,:,:,24),wf(:,3),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,57),ZERO,G2(:,:,:,148))
  call loop_QV_A(G2(:,:,:,148),wf(:,-6),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,121),ZERO,G3(:,:,:,249))
  call loop_QW_A(G3(:,:,:,249),wf(:,39),G3(:,:,:,250))
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,127),ZERO,G4tensor(:,139))
  call loop_QV_A(G1(:,:,:,24),wf(:,-5),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,41),ZERO,G2(:,:,:,150))
  call loop_QV_A(G2(:,:,:,150),wf(:,9),G2(:,:,:,151))
  call loop_Q_A(G2(:,:,:,151),Q(:,121),ZERO,G3(:,:,:,251))
  call loop_QW_A(G3(:,:,:,251),wf(:,39),G3(:,:,:,252))
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,127),ZERO,G4tensor(:,140))
  call loop_QV_A(G2(:,:,:,150),wf(:,-4),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,57),ZERO,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,-6),G3(:,:,:,254))
  call loop_Q_A(G3(:,:,:,254),Q(:,121),ZERO,G4(:,:,:,101))
  call loop_QW_A(G4(:,:,:,101),wf(:,39),G4(:,:,:,102))
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,127),ZERO,G5tensor(:,55))
  call loop_QV_A(G2(:,:,:,150),wf(:,-6),G2(:,:,:,153))
  call loop_Q_A(G2(:,:,:,153),Q(:,105),ZERO,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-4),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,121),ZERO,G4(:,:,:,103))
  call loop_QW_A(G4(:,:,:,103),wf(:,39),G4(:,:,:,104))
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,127),ZERO,G5tensor(:,56))
  call loop_QV_A(G1(:,:,:,24),wf(:,9),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,89),ZERO,G2(:,:,:,154))
  call loop_QV_A(G2(:,:,:,154),wf(:,-5),G2(:,:,:,155))
  call loop_Q_A(G2(:,:,:,155),Q(:,121),ZERO,G3(:,:,:,257))
  call loop_QW_A(G3(:,:,:,257),wf(:,39),G3(:,:,:,258))
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,141))
  call loop_QV_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,25),ZERO,G2(:,:,:,156))
  call loop_QV_A(G2(:,:,:,156),wf(:,12),G2(:,:,:,157))
  call loop_Q_A(G2(:,:,:,157),Q(:,121),ZERO,G3(:,:,:,259))
  call loop_QW_A(G3(:,:,:,259),wf(:,39),G3(:,:,:,260))
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,127),ZERO,G4tensor(:,142))
  call loop_QV_A(G2(:,:,:,156),wf(:,-5),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,57),ZERO,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,-6),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,121),ZERO,G4(:,:,:,105))
  call loop_QW_A(G4(:,:,:,105),wf(:,39),G4(:,:,:,106))
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,127),ZERO,G5tensor(:,57))
  call loop_QV_A(G2(:,:,:,156),wf(:,-6),G2(:,:,:,159))
  call loop_Q_A(G2(:,:,:,159),Q(:,89),ZERO,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-5),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,121),ZERO,G4(:,:,:,107))
  call loop_QW_A(G4(:,:,:,107),wf(:,39),G4(:,:,:,108))
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,127),ZERO,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,24),wf(:,12),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,105),ZERO,G2(:,:,:,160))
  call loop_QV_A(G2(:,:,:,160),wf(:,-4),G2(:,:,:,161))
  call loop_Q_A(G2(:,:,:,161),Q(:,121),ZERO,G3(:,:,:,265))
  call loop_QW_A(G3(:,:,:,265),wf(:,39),G3(:,:,:,266))
  call check_last_Q_A(l_switch,G3(:,:,:,266),Q(:,127),ZERO,G4tensor(:,143))
  call loop_QW_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,9),MT,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,-6),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,73),MT,G2(:,:,:,162))
  call loop_QV_A(G2(:,:,:,162),wf(:,3),G2(:,:,:,163))
  call loop_Q_A(G2(:,:,:,163),Q(:,121),MT,G3(:,:,:,267))
  call loop_QW_A(G3(:,:,:,267),wf(:,39),G3(:,:,:,268))
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,127),MB,G4tensor(:,144))
  call loop_QV_A(G2(:,:,:,162),wf(:,-4),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,89),MT,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-5),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,121),MT,G4(:,:,:,109))
  call loop_QW_A(G4(:,:,:,109),wf(:,39),G4(:,:,:,110))
  call check_last_Q_A(l_switch,G4(:,:,:,110),Q(:,127),MB,G5tensor(:,59))
  call loop_QV_A(G2(:,:,:,162),wf(:,-5),G2(:,:,:,165))
  call loop_Q_A(G2(:,:,:,165),Q(:,105),MT,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,-4),G3(:,:,:,272))
  call loop_Q_A(G3(:,:,:,272),Q(:,121),MT,G4(:,:,:,111))
  call loop_QW_A(G4(:,:,:,111),wf(:,39),G4(:,:,:,112))
  call check_last_Q_A(l_switch,G4(:,:,:,112),Q(:,127),MB,G5tensor(:,60))
  call loop_QV_A(G1(:,:,:,31),wf(:,3),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,57),MT,G2(:,:,:,166))
  call loop_QV_A(G2(:,:,:,166),wf(:,-6),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,121),MT,G3(:,:,:,273))
  call loop_QW_A(G3(:,:,:,273),wf(:,39),G3(:,:,:,274))
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,127),MB,G4tensor(:,145))
  call loop_QV_A(G1(:,:,:,31),wf(:,-5),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,41),MT,G2(:,:,:,168))
  call loop_QV_A(G2(:,:,:,168),wf(:,9),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,121),MT,G3(:,:,:,275))
  call loop_QW_A(G3(:,:,:,275),wf(:,39),G3(:,:,:,276))
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,127),MB,G4tensor(:,146))
  call loop_QV_A(G2(:,:,:,168),wf(:,-4),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,57),MT,G3(:,:,:,277))
  call loop_QV_A(G3(:,:,:,277),wf(:,-6),G3(:,:,:,278))
  call loop_Q_A(G3(:,:,:,278),Q(:,121),MT,G4(:,:,:,113))
  call loop_QW_A(G4(:,:,:,113),wf(:,39),G4(:,:,:,114))
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,127),MB,G5tensor(:,61))
  call loop_QV_A(G2(:,:,:,168),wf(:,-6),G2(:,:,:,171))
  call loop_Q_A(G2(:,:,:,171),Q(:,105),MT,G3(:,:,:,279))
  call loop_QV_A(G3(:,:,:,279),wf(:,-4),G3(:,:,:,280))
  call loop_Q_A(G3(:,:,:,280),Q(:,121),MT,G4(:,:,:,115))
  call loop_QW_A(G4(:,:,:,115),wf(:,39),G4(:,:,:,116))
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,127),MB,G5tensor(:,62))
  call loop_QV_A(G1(:,:,:,31),wf(:,9),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,89),MT,G2(:,:,:,172))
  call loop_QV_A(G2(:,:,:,172),wf(:,-5),G2(:,:,:,173))
  call loop_Q_A(G2(:,:,:,173),Q(:,121),MT,G3(:,:,:,281))
  call loop_QW_A(G3(:,:,:,281),wf(:,39),G3(:,:,:,282))
  call check_last_Q_A(l_switch,G3(:,:,:,282),Q(:,127),MB,G4tensor(:,147))
  call loop_QV_A(G1(:,:,:,31),wf(:,-4),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,25),MT,G2(:,:,:,174))
  call loop_QV_A(G2(:,:,:,174),wf(:,12),G2(:,:,:,175))
  call loop_Q_A(G2(:,:,:,175),Q(:,121),MT,G3(:,:,:,283))
  call loop_QW_A(G3(:,:,:,283),wf(:,39),G3(:,:,:,284))
  call check_last_Q_A(l_switch,G3(:,:,:,284),Q(:,127),MB,G4tensor(:,148))
  call loop_QV_A(G2(:,:,:,174),wf(:,-5),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,57),MT,G3(:,:,:,285))
  call loop_QV_A(G3(:,:,:,285),wf(:,-6),G3(:,:,:,286))
  call loop_Q_A(G3(:,:,:,286),Q(:,121),MT,G4(:,:,:,117))
  call loop_QW_A(G4(:,:,:,117),wf(:,39),G4(:,:,:,118))
  call check_last_Q_A(l_switch,G4(:,:,:,118),Q(:,127),MB,G5tensor(:,63))
  call loop_QV_A(G2(:,:,:,174),wf(:,-6),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,89),MT,G3(:,:,:,287))
  call loop_QV_A(G3(:,:,:,287),wf(:,-5),G3(:,:,:,288))
  call loop_Q_A(G3(:,:,:,288),Q(:,121),MT,G4(:,:,:,119))
  call loop_QW_A(G4(:,:,:,119),wf(:,39),G4(:,:,:,120))
  call check_last_Q_A(l_switch,G4(:,:,:,120),Q(:,127),MB,G5tensor(:,64))
  call loop_QV_A(G1(:,:,:,31),wf(:,12),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,105),MT,G2(:,:,:,178))
  call loop_QV_A(G2(:,:,:,178),wf(:,-4),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,121),MT,G3(:,:,:,289))
  call loop_QW_A(G3(:,:,:,289),wf(:,39),G3(:,:,:,290))
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,127),MB,G4tensor(:,149))
  call loop_AW_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,9),ZERO,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-6),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,73),ZERO,G2(:,:,:,180))
  call loop_AV_Q(G2(:,:,:,180),wf(:,3),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,121),ZERO,G3(:,:,:,291))
  call loop_AW_Q(G3(:,:,:,291),wf(:,39),G3(:,:,:,292))
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,127),ZERO,G4tensor(:,150))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-4),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,89),ZERO,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,-5),G3(:,:,:,294))
  call loop_A_Q(G3(:,:,:,294),Q(:,121),ZERO,G4(:,:,:,121))
  call loop_AW_Q(G4(:,:,:,121),wf(:,39),G4(:,:,:,122))
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,65))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-5),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,105),ZERO,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,-4),G3(:,:,:,296))
  call loop_A_Q(G3(:,:,:,296),Q(:,121),ZERO,G4(:,:,:,123))
  call loop_AW_Q(G4(:,:,:,123),wf(:,39),G4(:,:,:,124))
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,127),ZERO,G5tensor(:,66))
  call loop_AV_Q(G1(:,:,:,38),wf(:,3),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,57),ZERO,G2(:,:,:,184))
  call loop_AV_Q(G2(:,:,:,184),wf(:,-6),G2(:,:,:,185))
  call loop_A_Q(G2(:,:,:,185),Q(:,121),ZERO,G3(:,:,:,297))
  call loop_AW_Q(G3(:,:,:,297),wf(:,39),G3(:,:,:,298))
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,151))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-5),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,41),ZERO,G2(:,:,:,186))
  call loop_AV_Q(G2(:,:,:,186),wf(:,9),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,121),ZERO,G3(:,:,:,299))
  call loop_AW_Q(G3(:,:,:,299),wf(:,39),G3(:,:,:,300))
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,127),ZERO,G4tensor(:,152))
  call loop_AV_Q(G2(:,:,:,186),wf(:,-4),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,57),ZERO,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-6),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,121),ZERO,G4(:,:,:,125))
  call loop_AW_Q(G4(:,:,:,125),wf(:,39),G4(:,:,:,126))
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,127),ZERO,G5tensor(:,67))
  call loop_AV_Q(G2(:,:,:,186),wf(:,-6),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,105),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,-4),G3(:,:,:,304))
  call loop_A_Q(G3(:,:,:,304),Q(:,121),ZERO,G4(:,:,:,127))
  call loop_AW_Q(G4(:,:,:,127),wf(:,39),G4(:,:,:,128))
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),ZERO,G5tensor(:,68))
  call loop_AV_Q(G1(:,:,:,38),wf(:,9),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,89),ZERO,G2(:,:,:,190))
  call loop_AV_Q(G2(:,:,:,190),wf(:,-5),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,121),ZERO,G3(:,:,:,305))
  call loop_AW_Q(G3(:,:,:,305),wf(:,39),G3(:,:,:,306))
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,127),ZERO,G4tensor(:,153))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-4),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,25),ZERO,G2(:,:,:,192))
  call loop_AV_Q(G2(:,:,:,192),wf(:,12),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,121),ZERO,G3(:,:,:,307))
  call loop_AW_Q(G3(:,:,:,307),wf(:,39),G3(:,:,:,308))
  call check_last_A_Q(l_switch,G3(:,:,:,308),Q(:,127),ZERO,G4tensor(:,154))
  call loop_AV_Q(G2(:,:,:,192),wf(:,-5),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,57),ZERO,G3(:,:,:,309))
  call loop_AV_Q(G3(:,:,:,309),wf(:,-6),G3(:,:,:,310))
  call loop_A_Q(G3(:,:,:,310),Q(:,121),ZERO,G4(:,:,:,129))
  call loop_AW_Q(G4(:,:,:,129),wf(:,39),G4(:,:,:,130))
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,127),ZERO,G5tensor(:,69))
  call loop_AV_Q(G2(:,:,:,192),wf(:,-6),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,89),ZERO,G3(:,:,:,311))
  call loop_AV_Q(G3(:,:,:,311),wf(:,-5),G3(:,:,:,312))
  call loop_A_Q(G3(:,:,:,312),Q(:,121),ZERO,G4(:,:,:,131))
  call loop_AW_Q(G4(:,:,:,131),wf(:,39),G4(:,:,:,132))
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,70))
  call loop_AV_Q(G1(:,:,:,38),wf(:,12),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,105),ZERO,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-4),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,121),ZERO,G3(:,:,:,313))
  call loop_AW_Q(G3(:,:,:,313),wf(:,39),G3(:,:,:,314))
  call check_last_A_Q(l_switch,G3(:,:,:,314),Q(:,127),ZERO,G4tensor(:,155))
  call loop_AW_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,9),MB,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-6),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,73),MB,G2(:,:,:,198))
  call loop_AV_Q(G2(:,:,:,198),wf(:,3),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,121),MB,G3(:,:,:,315))
  call loop_AW_Q(G3(:,:,:,315),wf(:,39),G3(:,:,:,316))
  call check_last_A_Q(l_switch,G3(:,:,:,316),Q(:,127),MT,G4tensor(:,156))
  call loop_AV_Q(G2(:,:,:,198),wf(:,-4),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,89),MB,G3(:,:,:,317))
  call loop_AV_Q(G3(:,:,:,317),wf(:,-5),G3(:,:,:,318))
  call loop_A_Q(G3(:,:,:,318),Q(:,121),MB,G4(:,:,:,133))
  call loop_AW_Q(G4(:,:,:,133),wf(:,39),G4(:,:,:,134))
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),MT,G5tensor(:,71))
  call loop_AV_Q(G2(:,:,:,198),wf(:,-5),G2(:,:,:,201))
  call loop_A_Q(G2(:,:,:,201),Q(:,105),MB,G3(:,:,:,319))
  call loop_AV_Q(G3(:,:,:,319),wf(:,-4),G3(:,:,:,320))
  call loop_A_Q(G3(:,:,:,320),Q(:,121),MB,G4(:,:,:,135))
  call loop_AW_Q(G4(:,:,:,135),wf(:,39),G4(:,:,:,136))
  call check_last_A_Q(l_switch,G4(:,:,:,136),Q(:,127),MT,G5tensor(:,72))
  call loop_AV_Q(G1(:,:,:,45),wf(:,3),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,57),MB,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-6),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,121),MB,G3(:,:,:,321))
  call loop_AW_Q(G3(:,:,:,321),wf(:,39),G3(:,:,:,322))
  call check_last_A_Q(l_switch,G3(:,:,:,322),Q(:,127),MT,G4tensor(:,157))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-5),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,41),MB,G2(:,:,:,204))
  call loop_AV_Q(G2(:,:,:,204),wf(:,9),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,121),MB,G3(:,:,:,323))
  call loop_AW_Q(G3(:,:,:,323),wf(:,39),G3(:,:,:,324))
  call check_last_A_Q(l_switch,G3(:,:,:,324),Q(:,127),MT,G4tensor(:,158))
  call loop_AV_Q(G2(:,:,:,204),wf(:,-4),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,57),MB,G3(:,:,:,325))
  call loop_AV_Q(G3(:,:,:,325),wf(:,-6),G3(:,:,:,326))
  call loop_A_Q(G3(:,:,:,326),Q(:,121),MB,G4(:,:,:,137))
  call loop_AW_Q(G4(:,:,:,137),wf(:,39),G4(:,:,:,138))
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,127),MT,G5tensor(:,73))
  call loop_AV_Q(G2(:,:,:,204),wf(:,-6),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,105),MB,G3(:,:,:,327))
  call loop_AV_Q(G3(:,:,:,327),wf(:,-4),G3(:,:,:,328))
  call loop_A_Q(G3(:,:,:,328),Q(:,121),MB,G4(:,:,:,139))
  call loop_AW_Q(G4(:,:,:,139),wf(:,39),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,127),MT,G5tensor(:,74))
  call loop_AV_Q(G1(:,:,:,45),wf(:,9),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,89),MB,G2(:,:,:,208))
  call loop_AV_Q(G2(:,:,:,208),wf(:,-5),G2(:,:,:,209))
  call loop_A_Q(G2(:,:,:,209),Q(:,121),MB,G3(:,:,:,329))
  call loop_AW_Q(G3(:,:,:,329),wf(:,39),G3(:,:,:,330))
  call check_last_A_Q(l_switch,G3(:,:,:,330),Q(:,127),MT,G4tensor(:,159))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-4),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,25),MB,G2(:,:,:,210))
  call loop_AV_Q(G2(:,:,:,210),wf(:,12),G2(:,:,:,211))
  call loop_A_Q(G2(:,:,:,211),Q(:,121),MB,G3(:,:,:,331))
  call loop_AW_Q(G3(:,:,:,331),wf(:,39),G3(:,:,:,332))
  call check_last_A_Q(l_switch,G3(:,:,:,332),Q(:,127),MT,G4tensor(:,160))
  call loop_AV_Q(G2(:,:,:,210),wf(:,-5),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,57),MB,G3(:,:,:,333))
  call loop_AV_Q(G3(:,:,:,333),wf(:,-6),G3(:,:,:,334))
  call loop_A_Q(G3(:,:,:,334),Q(:,121),MB,G4(:,:,:,141))
  call loop_AW_Q(G4(:,:,:,141),wf(:,39),G4(:,:,:,142))
  call check_last_A_Q(l_switch,G4(:,:,:,142),Q(:,127),MT,G5tensor(:,75))
  call loop_AV_Q(G2(:,:,:,210),wf(:,-6),G2(:,:,:,213))
  call loop_A_Q(G2(:,:,:,213),Q(:,89),MB,G3(:,:,:,335))
  call loop_AV_Q(G3(:,:,:,335),wf(:,-5),G3(:,:,:,336))
  call loop_A_Q(G3(:,:,:,336),Q(:,121),MB,G4(:,:,:,143))
  call loop_AW_Q(G4(:,:,:,143),wf(:,39),G4(:,:,:,144))
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,127),MT,G5tensor(:,76))
  call loop_AV_Q(G1(:,:,:,45),wf(:,12),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,105),MB,G2(:,:,:,214))
  call loop_AV_Q(G2(:,:,:,214),wf(:,-4),G2(:,:,:,215))
  call loop_A_Q(G2(:,:,:,215),Q(:,121),MB,G3(:,:,:,337))
  call loop_AW_Q(G3(:,:,:,337),wf(:,39),G3(:,:,:,338))
  call check_last_A_Q(l_switch,G3(:,:,:,338),Q(:,127),MT,G4tensor(:,161))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(44)) * den(55)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(44) * den(55)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(15)) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,36),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(15) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,36),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(15)) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,87),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(15) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,87),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(13) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,37),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,37),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(12) * den(115)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,1),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(12)) * den(115)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,1),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(13) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,88),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(13)) * den(115)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,88),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,38),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,38),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,89),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,89),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,39),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,39),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(14) * den(116)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,2),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(14)) * den(116)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,2),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(16) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,90),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(16)) * den(116)) * TI2_call(4,momenta_17,masses2_10,G4tensor(:,90),T4sum(1:70,19))
  M(2) = M(2) + (f(45) * den(52)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,3),T4sum(1:70,31))
  M(1) = M(1) + (f(45) * den(52)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,19),T4sum(1:70,33))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,41),T5sum(1:126,10))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,21),T5sum(1:126,10))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,42),T5sum(1:126,10))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,22),T5sum(1:126,10))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_42,masses2_11,G5tensor(:,5),T5sum(1:126,12))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,43),T5sum(1:126,10))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,23),T5sum(1:126,10))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,44),T5sum(1:126,10))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_42,masses2_19,G5tensor(:,24),T5sum(1:126,10))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_42,masses2_11,G5tensor(:,6),T5sum(1:126,12))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,46),T5sum(1:126,22))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,26),T5sum(1:126,22))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,47),T5sum(1:126,22))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,27),T5sum(1:126,22))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_44,masses2_11,G5tensor(:,8),T5sum(1:126,24))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,48),T5sum(1:126,22))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,28),T5sum(1:126,22))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,49),T5sum(1:126,22))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_44,masses2_19,G5tensor(:,29),T5sum(1:126,22))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_44,masses2_11,G5tensor(:,9),T5sum(1:126,24))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,13),T5sum(1:126,31))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,33),T5sum(1:126,31))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,14),T5sum(1:126,31))
  M(1) = M(1) + (-f(17) * den(4)) * TI2_call(5,momenta_40,masses2_11,G5tensor(:,1),T5sum(1:126,33))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,34),T5sum(1:126,31))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,17),T5sum(1:126,31))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,37),T5sum(1:126,31))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,19),T5sum(1:126,31))
  M(1) = M(1) + (-f(19) * den(7)) * TI2_call(5,momenta_40,masses2_11,G5tensor(:,3),T5sum(1:126,33))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_40,masses2_19,G5tensor(:,39),T5sum(1:126,31))
  M(2) = M(2) + (f(20) * den(4)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,15),T5sum(1:126,34))
  M(1) = M(1) + (f(20) * den(4)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,35),T5sum(1:126,34))
  M(2) = M(2) + (-f(18) * den(4)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,16),T5sum(1:126,34))
  M(2) = M(2) + (-f(17) * den(4)) * TI2_call(5,momenta_39,masses2_11,G5tensor(:,2),T5sum(1:126,36))
  M(1) = M(1) + (-f(18) * den(4)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,36),T5sum(1:126,34))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,18),T5sum(1:126,34))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,38),T5sum(1:126,34))
  M(2) = M(2) + (-f(21) * den(7)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,20),T5sum(1:126,34))
  M(2) = M(2) + (-f(19) * den(7)) * TI2_call(5,momenta_39,masses2_11,G5tensor(:,4),T5sum(1:126,36))
  M(1) = M(1) + (-f(21) * den(7)) * TI2_call(5,momenta_39,masses2_19,G5tensor(:,40),T5sum(1:126,34))
  M(1) = M(1) + (-(CI*f(15)) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(13) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(13)) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(12) * den(125)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(12)) * den(125)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(13)) * den(125)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(126)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(14)) * den(126)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(16) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(126)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(15)) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(13) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(13)) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(12) * den(127)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(12)) * den(127)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(13) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(13)) * den(127)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(128)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(14)) * den(128)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(16) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(128)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (f(20) * den(98)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,91),T4sum(1:70,35))
  M(2) = M(2) + (f(20) * den(98)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,40),T4sum(1:70,35))
  M(1) = M(1) + (-f(18) * den(98)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,91),T4sum(1:70,35))
  M(2) = M(2) + (-f(18) * den(98)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,40),T4sum(1:70,35))
  M(2) = M(2) + (-f(17) * den(98)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,4),T4sum(1:70,31))
  M(1) = M(1) + (-f(21) * den(99)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,92),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(99)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,41),T4sum(1:70,35))
  M(1) = M(1) + (-f(21) * den(99)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,93),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(99)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,42),T4sum(1:70,35))
  M(2) = M(2) + (-f(19) * den(99)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,5),T4sum(1:70,31))
  M(2) = M(2) + (f(20) * den(98)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,114),T4sum(1:70,36))
  M(1) = M(1) + (f(20) * den(98)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,63),T4sum(1:70,36))
  M(2) = M(2) + (-f(18) * den(98)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,114),T4sum(1:70,36))
  M(1) = M(1) + (-f(18) * den(98)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,63),T4sum(1:70,36))
  M(1) = M(1) + (-f(17) * den(98)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(2) = M(2) + (-f(21) * den(99)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,115),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(99)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,64),T4sum(1:70,36))
  M(2) = M(2) + (-f(21) * den(99)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,116),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(99)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,65),T4sum(1:70,36))
  M(1) = M(1) + (-f(19) * den(99)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(1) = M(1) + (f(20) * den(100)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,94),T4sum(1:70,35))
  M(2) = M(2) + (f(20) * den(100)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,43),T4sum(1:70,35))
  M(1) = M(1) + (-f(18) * den(100)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,94),T4sum(1:70,35))
  M(2) = M(2) + (-f(18) * den(100)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,43),T4sum(1:70,35))
  M(2) = M(2) + (-f(17) * den(100)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,6),T4sum(1:70,31))
  M(1) = M(1) + (-f(21) * den(101)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,95),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(101)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,44),T4sum(1:70,35))
  M(1) = M(1) + (-f(21) * den(101)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,96),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(101)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,45),T4sum(1:70,35))
  M(2) = M(2) + (-f(19) * den(101)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,7),T4sum(1:70,31))
  M(2) = M(2) + (f(20) * den(100)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,117),T4sum(1:70,36))
  M(1) = M(1) + (f(20) * den(100)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,66),T4sum(1:70,36))
  M(2) = M(2) + (-f(18) * den(100)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,117),T4sum(1:70,36))
  M(1) = M(1) + (-f(18) * den(100)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,66),T4sum(1:70,36))
  M(1) = M(1) + (-f(17) * den(100)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(2) = M(2) + (-f(21) * den(101)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,118),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(101)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,67),T4sum(1:70,36))
  M(2) = M(2) + (-f(21) * den(101)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,119),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(101)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,68),T4sum(1:70,36))
  M(1) = M(1) + (-f(19) * den(101)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,23),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(23)) * den(130)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,138),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(23) * den(130)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,138),T4sum(1:70,40))
  M(1) = M(1) + (-(CI*f(22)) * den(130)) * TI2_call(4,momenta_7,masses2_8,G4tensor(:,144),T4sum(1:70,41))
  M(2) = M(2) + (CI*f(22) * den(130)) * TI2_call(4,momenta_7,masses2_8,G4tensor(:,144),T4sum(1:70,41))
  M(1) = M(1) + (-(CI*f(23)) * den(130)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,150),T4sum(1:70,40))
  M(2) = M(2) + (CI*f(23) * den(130)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,150),T4sum(1:70,40))
  M(1) = M(1) + (-(CI*f(22)) * den(130)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,156),T4sum(1:70,42))
  M(2) = M(2) + (CI*f(22) * den(130)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,156),T4sum(1:70,42))
  M(1) = M(1) + (-(CI*f(23)) * den(130)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,139),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(23) * den(130)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,139),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(22)) * den(130)) * TI2_call(4,momenta_6,masses2_8,G4tensor(:,145),T4sum(1:70,44))
  M(2) = M(2) + (CI*f(22) * den(130)) * TI2_call(4,momenta_6,masses2_8,G4tensor(:,145),T4sum(1:70,44))
  M(1) = M(1) + (-(CI*f(23)) * den(130)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,151),T4sum(1:70,43))
  M(2) = M(2) + (CI*f(23) * den(130)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,151),T4sum(1:70,43))
  M(1) = M(1) + (-(CI*f(22)) * den(130)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,157),T4sum(1:70,45))
  M(2) = M(2) + (CI*f(22) * den(130)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,157),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(23) * den(132)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,140),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(23)) * den(132)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,140),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(22) * den(132)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,146),T4sum(1:70,50))
  M(2) = M(2) + (-(CI*f(22)) * den(132)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,146),T4sum(1:70,50))
  M(1) = M(1) + (CI*f(23) * den(132)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,152),T4sum(1:70,49))
  M(2) = M(2) + (-(CI*f(23)) * den(132)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,152),T4sum(1:70,49))
  M(1) = M(1) + (CI*f(22) * den(132)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,158),T4sum(1:70,51))
  M(2) = M(2) + (-(CI*f(22)) * den(132)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,158),T4sum(1:70,51))
  M(1) = M(1) + (CI*f(23) * den(132)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,141),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(23)) * den(132)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,141),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(22) * den(132)) * TI2_call(4,momenta_8,masses2_8,G4tensor(:,147),T4sum(1:70,53))
  M(2) = M(2) + (-(CI*f(22)) * den(132)) * TI2_call(4,momenta_8,masses2_8,G4tensor(:,147),T4sum(1:70,53))
  M(1) = M(1) + (CI*f(23) * den(132)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,153),T4sum(1:70,52))
  M(2) = M(2) + (-(CI*f(23)) * den(132)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,153),T4sum(1:70,52))
  M(1) = M(1) + (CI*f(22) * den(132)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,159),T4sum(1:70,54))
  M(2) = M(2) + (-(CI*f(22)) * den(132)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,159),T4sum(1:70,54))
  M(1) = M(1) + (CI*f(26) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(26)) * den(73)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(37)) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(37) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(37)) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(37) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(35) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(35)) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(35) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(35)) * den(133)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(34) * den(133)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(34)) * den(133)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(31)) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(31) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(31)) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(31) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(31)) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(31) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(31)) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(31) * den(74)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(30)) * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(30) * den(74)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(23)) * den(134)) * TI2_call(4,momenta_16,masses2_10,G4tensor(:,137),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(23) * den(134)) * TI2_call(4,momenta_16,masses2_10,G4tensor(:,137),T4sum(1:70,55))
  M(1) = M(1) + (-(CI*f(23)) * den(134)) * TI2_call(4,momenta_16,masses2_10,G4tensor(:,86),T4sum(1:70,55))
  M(2) = M(2) + (CI*f(23) * den(134)) * TI2_call(4,momenta_16,masses2_10,G4tensor(:,86),T4sum(1:70,55))
  M(1) = M(1) + (-(CI*f(22)) * den(134)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,35),T4sum(1:70,57))
  M(2) = M(2) + (CI*f(22) * den(134)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,35),T4sum(1:70,57))
  M(1) = M(1) + (-(CI*f(23)) * den(134)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,142),T4sum(1:70,58))
  M(2) = M(2) + (CI*f(23) * den(134)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,142),T4sum(1:70,58))
  M(1) = M(1) + (-(CI*f(22)) * den(134)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,148),T4sum(1:70,59))
  M(2) = M(2) + (CI*f(22) * den(134)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,148),T4sum(1:70,59))
  M(1) = M(1) + (-(CI*f(23)) * den(134)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,154),T4sum(1:70,58))
  M(2) = M(2) + (CI*f(23) * den(134)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,154),T4sum(1:70,58))
  M(1) = M(1) + (-(CI*f(22)) * den(134)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,160),T4sum(1:70,60))
  M(2) = M(2) + (CI*f(22) * den(134)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,160),T4sum(1:70,60))
  M(1) = M(1) + (-(CI*f(23)) * den(134)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,143),T4sum(1:70,61))
  M(2) = M(2) + (CI*f(23) * den(134)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,143),T4sum(1:70,61))
  M(1) = M(1) + (-(CI*f(22)) * den(134)) * TI2_call(4,momenta_9,masses2_8,G4tensor(:,149),T4sum(1:70,62))
  M(2) = M(2) + (CI*f(22) * den(134)) * TI2_call(4,momenta_9,masses2_8,G4tensor(:,149),T4sum(1:70,62))
  M(1) = M(1) + (-(CI*f(23)) * den(134)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,155),T4sum(1:70,61))
  M(2) = M(2) + (CI*f(23) * den(134)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,155),T4sum(1:70,61))
  M(1) = M(1) + (-(CI*f(22)) * den(134)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,161),T4sum(1:70,63))
  M(2) = M(2) + (CI*f(22) * den(134)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,161),T4sum(1:70,63))
  M(2) = M(2) + (-f(27) * den(66)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,8),T4sum(1:70,31))
  M(1) = M(1) + (f(42) * den(102)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,97),T4sum(1:70,35))
  M(2) = M(2) + (f(42) * den(102)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,46),T4sum(1:70,35))
  M(1) = M(1) + (-f(40) * den(102)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,97),T4sum(1:70,35))
  M(2) = M(2) + (-f(40) * den(102)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,46),T4sum(1:70,35))
  M(2) = M(2) + (-f(39) * den(102)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,9),T4sum(1:70,31))
  M(1) = M(1) + (f(33) * den(69)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,98),T4sum(1:70,35))
  M(2) = M(2) + (f(33) * den(69)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,47),T4sum(1:70,35))
  M(1) = M(1) + (f(33) * den(69)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,99),T4sum(1:70,35))
  M(2) = M(2) + (f(33) * den(69)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,48),T4sum(1:70,35))
  M(2) = M(2) + (f(32) * den(69)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,10),T4sum(1:70,31))
  M(1) = M(1) + (-f(27) * den(66)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,24),T4sum(1:70,33))
  M(2) = M(2) + (f(42) * den(102)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,120),T4sum(1:70,36))
  M(1) = M(1) + (f(42) * den(102)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,69),T4sum(1:70,36))
  M(2) = M(2) + (-f(40) * den(102)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,120),T4sum(1:70,36))
  M(1) = M(1) + (-f(40) * den(102)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,69),T4sum(1:70,36))
  M(1) = M(1) + (-f(39) * den(102)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,25),T4sum(1:70,33))
  M(2) = M(2) + (f(33) * den(69)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,121),T4sum(1:70,36))
  M(1) = M(1) + (f(33) * den(69)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,70),T4sum(1:70,36))
  M(2) = M(2) + (f(33) * den(69)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,122),T4sum(1:70,36))
  M(1) = M(1) + (f(33) * den(69)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,71),T4sum(1:70,36))
  M(1) = M(1) + (f(32) * den(69)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,26),T4sum(1:70,33))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_27,masses2_19,G5tensor(:,55),T5sum(1:126,37))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_27,masses2_17,G5tensor(:,61),T5sum(1:126,38))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_27,masses2_19,G5tensor(:,67),T5sum(1:126,37))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_27,masses2_12,G5tensor(:,73),T5sum(1:126,39))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_29,masses2_19,G5tensor(:,53),T5sum(1:126,40))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_29,masses2_17,G5tensor(:,59),T5sum(1:126,41))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_29,masses2_19,G5tensor(:,65),T5sum(1:126,40))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_29,masses2_12,G5tensor(:,71),T5sum(1:126,42))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_25,masses2_19,G5tensor(:,57),T5sum(1:126,43))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_25,masses2_17,G5tensor(:,63),T5sum(1:126,44))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_25,masses2_19,G5tensor(:,69),T5sum(1:126,43))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_25,masses2_12,G5tensor(:,75),T5sum(1:126,45))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_30,masses2_19,G5tensor(:,54),T5sum(1:126,49))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_30,masses2_17,G5tensor(:,60),T5sum(1:126,50))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_30,masses2_19,G5tensor(:,66),T5sum(1:126,49))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_30,masses2_12,G5tensor(:,72),T5sum(1:126,51))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_41,masses2_19,G5tensor(:,45),T5sum(1:126,52))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_41,masses2_19,G5tensor(:,25),T5sum(1:126,52))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_41,masses2_13,G5tensor(:,7),T5sum(1:126,54))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_26,masses2_19,G5tensor(:,58),T5sum(1:126,55))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_26,masses2_17,G5tensor(:,64),T5sum(1:126,56))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_26,masses2_19,G5tensor(:,70),T5sum(1:126,55))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_26,masses2_12,G5tensor(:,76),T5sum(1:126,57))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_28,masses2_19,G5tensor(:,56),T5sum(1:126,61))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_28,masses2_17,G5tensor(:,62),T5sum(1:126,62))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_28,masses2_19,G5tensor(:,68),T5sum(1:126,61))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_28,masses2_12,G5tensor(:,74),T5sum(1:126,63))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_43,masses2_19,G5tensor(:,50),T5sum(1:126,64))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_43,masses2_19,G5tensor(:,30),T5sum(1:126,64))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_43,masses2_13,G5tensor(:,10),T5sum(1:126,66))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_37,masses2_19,G5tensor(:,31),T5sum(1:126,67))
  M(2) = M(2) + (f(24) * den(28)) * TI2_call(5,momenta_37,masses2_14,G5tensor(:,11),T5sum(1:126,68))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_37,masses2_19,G5tensor(:,51),T5sum(1:126,67))
  M(1) = M(1) + (f(25) * den(28)) * TI2_call(5,momenta_38,masses2_19,G5tensor(:,32),T5sum(1:126,70))
  M(1) = M(1) + (f(24) * den(28)) * TI2_call(5,momenta_38,masses2_14,G5tensor(:,12),T5sum(1:126,71))
  M(2) = M(2) + (f(25) * den(28)) * TI2_call(5,momenta_38,masses2_19,G5tensor(:,52),T5sum(1:126,70))
  M(1) = M(1) + (CI*f(37) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(37)) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(37) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(37)) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(35)) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(35) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(34)) * den(141)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(34) * den(141)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(35)) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(35) * den(141)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(36)) * den(142)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(36) * den(142)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(38)) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(142)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(36)) * den(143)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(36) * den(143)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(38)) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(143)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(1) = M(1) + (-f(42) * den(103)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,100),T4sum(1:70,35))
  M(2) = M(2) + (-f(42) * den(103)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,49),T4sum(1:70,35))
  M(1) = M(1) + (f(40) * den(103)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,100),T4sum(1:70,35))
  M(2) = M(2) + (f(40) * den(103)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,49),T4sum(1:70,35))
  M(2) = M(2) + (f(39) * den(103)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,11),T4sum(1:70,31))
  M(1) = M(1) + (f(43) * den(104)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,101),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(104)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,50),T4sum(1:70,35))
  M(1) = M(1) + (f(43) * den(104)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,102),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(104)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,51),T4sum(1:70,35))
  M(2) = M(2) + (f(41) * den(104)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,12),T4sum(1:70,31))
  M(2) = M(2) + (-f(42) * den(103)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,123),T4sum(1:70,36))
  M(1) = M(1) + (-f(42) * den(103)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,72),T4sum(1:70,36))
  M(2) = M(2) + (f(40) * den(103)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,123),T4sum(1:70,36))
  M(1) = M(1) + (f(40) * den(103)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,72),T4sum(1:70,36))
  M(1) = M(1) + (f(39) * den(103)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,27),T4sum(1:70,33))
  M(2) = M(2) + (f(43) * den(104)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,124),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(104)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,73),T4sum(1:70,36))
  M(2) = M(2) + (f(43) * den(104)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,125),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(104)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,74),T4sum(1:70,36))
  M(1) = M(1) + (f(41) * den(104)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,28),T4sum(1:70,33))
  M(1) = M(1) + (f(43) * den(105)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,103),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(105)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,52),T4sum(1:70,35))
  M(1) = M(1) + (f(43) * den(105)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,104),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(105)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,53),T4sum(1:70,35))
  M(2) = M(2) + (f(41) * den(105)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,13),T4sum(1:70,31))
  M(2) = M(2) + (f(43) * den(105)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,126),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(105)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,75),T4sum(1:70,36))
  M(2) = M(2) + (f(43) * den(105)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,127),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(105)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,76),T4sum(1:70,36))
  M(1) = M(1) + (f(41) * den(105)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,29),T4sum(1:70,33))
  M(1) = M(1) + (CI*f(37) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(37)) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(37) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(37)) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(35)) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(35) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(34)) * den(150)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(34) * den(150)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(35)) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(35) * den(150)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,33),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(36)) * den(151)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(36) * den(151)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(38)) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(151)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,34),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(38)) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,35),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(36)) * den(152)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(36) * den(152)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(38)) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(38) * den(152)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,9))
  M(1) = M(1) + (-f(42) * den(106)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,105),T4sum(1:70,35))
  M(2) = M(2) + (-f(42) * den(106)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,54),T4sum(1:70,35))
  M(1) = M(1) + (f(40) * den(106)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,105),T4sum(1:70,35))
  M(2) = M(2) + (f(40) * den(106)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,54),T4sum(1:70,35))
  M(2) = M(2) + (f(39) * den(106)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,14),T4sum(1:70,31))
  M(1) = M(1) + (f(43) * den(107)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,106),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(107)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,55),T4sum(1:70,35))
  M(1) = M(1) + (f(43) * den(107)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,107),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(107)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,56),T4sum(1:70,35))
  M(2) = M(2) + (f(41) * den(107)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,15),T4sum(1:70,31))
  M(2) = M(2) + (-f(42) * den(106)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,128),T4sum(1:70,36))
  M(1) = M(1) + (-f(42) * den(106)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,77),T4sum(1:70,36))
  M(2) = M(2) + (f(40) * den(106)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,128),T4sum(1:70,36))
  M(1) = M(1) + (f(40) * den(106)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,77),T4sum(1:70,36))
  M(1) = M(1) + (f(39) * den(106)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,30),T4sum(1:70,33))
  M(2) = M(2) + (f(43) * den(107)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,129),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(107)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,78),T4sum(1:70,36))
  M(2) = M(2) + (f(43) * den(107)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,130),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(107)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,79),T4sum(1:70,36))
  M(1) = M(1) + (f(41) * den(107)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,31),T4sum(1:70,33))
  M(1) = M(1) + (f(43) * den(108)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,108),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(108)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,57),T4sum(1:70,35))
  M(1) = M(1) + (f(43) * den(108)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,109),T4sum(1:70,35))
  M(2) = M(2) + (f(43) * den(108)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,58),T4sum(1:70,35))
  M(2) = M(2) + (f(41) * den(108)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,16),T4sum(1:70,31))
  M(2) = M(2) + (f(43) * den(108)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,131),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(108)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,80),T4sum(1:70,36))
  M(2) = M(2) + (f(43) * den(108)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,132),T4sum(1:70,36))
  M(1) = M(1) + (f(43) * den(108)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,81),T4sum(1:70,36))
  M(1) = M(1) + (f(41) * den(108)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,32),T4sum(1:70,33))
  M(1) = M(1) + (CI*f(16) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,36),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,59),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,59),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,37),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(157)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(14)) * den(157)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(16) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,60),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(157)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,60),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,38),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,61),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,61),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(16) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(158)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(14)) * den(158)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(16) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,62),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(16)) * den(158)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,62),T3sum(1:35,9))
  M(1) = M(1) + (-f(21) * den(109)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,110),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(109)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,59),T4sum(1:70,35))
  M(1) = M(1) + (-f(21) * den(109)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,111),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(109)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,60),T4sum(1:70,35))
  M(2) = M(2) + (-f(19) * den(109)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,17),T4sum(1:70,31))
  M(2) = M(2) + (-f(21) * den(109)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,133),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(109)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,82),T4sum(1:70,36))
  M(2) = M(2) + (-f(21) * den(109)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,134),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(109)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,83),T4sum(1:70,36))
  M(1) = M(1) + (-f(19) * den(109)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,33),T4sum(1:70,33))
  M(1) = M(1) + (-f(21) * den(110)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,112),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(110)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,61),T4sum(1:70,35))
  M(1) = M(1) + (-f(21) * den(110)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,113),T4sum(1:70,35))
  M(2) = M(2) + (-f(21) * den(110)) * TI2_call(4,momenta_18,masses2_10,G4tensor(:,62),T4sum(1:70,35))
  M(2) = M(2) + (-f(19) * den(110)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,18),T4sum(1:70,31))
  M(2) = M(2) + (-f(21) * den(110)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,135),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(110)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,84),T4sum(1:70,36))
  M(2) = M(2) + (-f(21) * den(110)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,136),T4sum(1:70,36))
  M(1) = M(1) + (-f(21) * den(110)) * TI2_call(4,momenta_19,masses2_10,G4tensor(:,85),T4sum(1:70,36))
  M(1) = M(1) + (-f(19) * den(110)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,34),T4sum(1:70,33))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_3_ppllllj2_nenexeexggg_1_/**/REALKIND
