
module ol_vamp_3_ppllllj2_eeexexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_eeexexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_eeexexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_eeexexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_eeexexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,5) :: G0
  complex(REALKIND), dimension(4,5,4,32) :: G1
  complex(REALKIND), dimension(4,15,4,256) :: G2
  complex(REALKIND), dimension(4,35,4,312) :: G3
  complex(REALKIND), dimension(4,70,4,128) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,164,128))
    allocate(G4tensorhel(70,208,128))
    allocate(G5tensorhel(126,88,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,32),MB,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,12),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,112),MB,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,94),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,127),MB,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,129),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,127),MB,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,130),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,127),MB,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,1),wf(:,131),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,127),MB,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,132),G2(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,127),MB,G3tensor(:,5))
  call loop_AV_Q(G2(:,:,:,1),wf(:,133),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,127),MB,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,134),G2(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,127),MB,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,1),wf(:,135),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,127),MB,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,136),G2(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,127),MB,G3tensor(:,9))
  call loop_AS_Q(G2(:,:,:,1),wf(:,110),G2(:,:,:,11),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,127),MB,G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,1),wf(:,137),G2(:,:,:,12))
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,127),MB,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,138),G2(:,:,:,13),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,127),MB,G3tensor(:,12))
  call loop_AV_Q(G2(:,:,:,1),wf(:,139),G2(:,:,:,14))
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,127),MB,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,140),G2(:,:,:,15),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,127),MB,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,1),wf(:,141),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),MB,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,1),wf(:,142),G2(:,:,:,17))
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),MB,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,143),G2(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),MB,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,144),G2(:,:,:,19),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),MB,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,1),wf(:,145),G2(:,:,:,20))
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),MB,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,146),G2(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,127),MB,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,1),wf(:,147),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,127),MB,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,148),G2(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),MB,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,1),wf(:,149),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),MB,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,150),G2(:,:,:,25),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),MB,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,1),wf(:,151),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,127),MB,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,152),G2(:,:,:,27),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MB,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,1),wf(:,153),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MB,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,154),G2(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MB,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,1),wf(:,155),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,156),G2(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MB,G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,1),wf(:,157),G2(:,:,:,32))
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MB,G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,1),wf(:,158),G2(:,:,:,33))
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MB,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,159),G2(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,127),MB,G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,160),G2(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,127),MB,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,42),MB,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,12),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,122),MB,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),MB,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,9),G3(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),MB,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-4),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,58),MB,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,-6),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,122),MB,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,1),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),MB,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,9),G4(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),MB,G5tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,6),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,42),MB,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,12),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,122),MB,G3(:,:,:,6))
  call loop_AV_Q(G3(:,:,:,6),wf(:,1),G3(:,:,:,7))
  call check_last_A_Q(l_switch,G3(:,:,:,7),Q(:,127),MB,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,6),wf(:,9),G3(:,:,:,8),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MB,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,58),MB,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,-6),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,122),MB,G4(:,:,:,4))
  call loop_AV_Q(G4(:,:,:,4),wf(:,1),G4(:,:,:,5))
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,127),MB,G5tensor(:,3))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,9),G4(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),MB,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,48),MB,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-6),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,112),MB,G3(:,:,:,11))
  call loop_AS_Q(G3(:,:,:,11),wf(:,94),G3(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),MB,G4tensor(:,5))
  call loop_AV_Q(G3(:,:,:,11),wf(:,129),G3(:,:,:,13))
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,127),MB,G4tensor(:,6))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,130),G3(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),MB,G4tensor(:,7))
  call loop_AV_Q(G3(:,:,:,11),wf(:,131),G3(:,:,:,15))
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,127),MB,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,132),G3(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),MB,G4tensor(:,9))
  call loop_AV_Q(G3(:,:,:,11),wf(:,133),G3(:,:,:,17))
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,127),MB,G4tensor(:,10))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,134),G3(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,127),MB,G4tensor(:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,135),G3(:,:,:,19))
  call check_last_A_Q(l_switch,G3(:,:,:,19),Q(:,127),MB,G4tensor(:,12))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,136),G3(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,127),MB,G4tensor(:,13))
  call loop_AS_Q(G3(:,:,:,11),wf(:,110),G3(:,:,:,21),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),MB,G4tensor(:,14))
  call loop_AV_Q(G3(:,:,:,11),wf(:,137),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),MB,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,138),G3(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),MB,G4tensor(:,16))
  call loop_AV_Q(G3(:,:,:,11),wf(:,139),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MB,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,140),G3(:,:,:,25),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),MB,G4tensor(:,18))
  call loop_AV_Q(G3(:,:,:,11),wf(:,141),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),MB,G4tensor(:,19))
  call loop_AV_Q(G3(:,:,:,11),wf(:,142),G3(:,:,:,27))
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),MB,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,143),G3(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),MB,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,144),G3(:,:,:,29),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),MB,G4tensor(:,22))
  call loop_AV_Q(G3(:,:,:,11),wf(:,145),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),MB,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,146),G3(:,:,:,31),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),MB,G4tensor(:,24))
  call loop_AV_Q(G3(:,:,:,11),wf(:,147),G3(:,:,:,32))
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),MB,G4tensor(:,25))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,148),G3(:,:,:,33),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,127),MB,G4tensor(:,26))
  call loop_AV_Q(G3(:,:,:,11),wf(:,149),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,127),MB,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,150),G3(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,127),MB,G4tensor(:,28))
  call loop_AV_Q(G3(:,:,:,11),wf(:,151),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,127),MB,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,152),G3(:,:,:,37),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,37),Q(:,127),MB,G4tensor(:,30))
  call loop_AV_Q(G3(:,:,:,11),wf(:,153),G3(:,:,:,38))
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MB,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,154),G3(:,:,:,39),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,39),Q(:,127),MB,G4tensor(:,32))
  call loop_AV_Q(G3(:,:,:,11),wf(:,155),G3(:,:,:,40))
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,127),MB,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,156),G3(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,127),MB,G4tensor(:,34))
  call loop_AV_Q(G3(:,:,:,11),wf(:,157),G3(:,:,:,42))
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,127),MB,G4tensor(:,35))
  call loop_AV_Q(G3(:,:,:,11),wf(:,158),G3(:,:,:,43))
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,127),MB,G4tensor(:,36))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,159),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),MB,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,11),wf(:,160),G3(:,:,:,45),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),MB,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,42),wf(:,2),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,58),MB,G3(:,:,:,46))
  call loop_AV_Q(G3(:,:,:,46),wf(:,-6),G3(:,:,:,47))
  call loop_A_Q(G3(:,:,:,47),Q(:,122),MB,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,1),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),MB,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,9),G4(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,127),MB,G5tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,6),G2(:,:,:,45),gZd)
  call loop_A_Q(G2(:,:,:,45),Q(:,58),MB,G3(:,:,:,48))
  call loop_AV_Q(G3(:,:,:,48),wf(:,-6),G3(:,:,:,49))
  call loop_A_Q(G3(:,:,:,49),Q(:,122),MB,G4(:,:,:,10))
  call loop_AV_Q(G4(:,:,:,10),wf(:,1),G4(:,:,:,11))
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,127),MB,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,9),G4(:,:,:,12),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),MB,G5tensor(:,8))
  call loop_AV_Q(G2(:,:,:,42),wf(:,46),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,57),MB,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,-6),G3(:,:,:,51))
  call loop_A_Q(G3(:,:,:,51),Q(:,121),MB,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,47),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),MB,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,50),G4(:,:,:,15),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,127),MB,G5tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,53),G2(:,:,:,47),gZd)
  call loop_A_Q(G2(:,:,:,47),Q(:,57),MB,G3(:,:,:,52))
  call loop_AV_Q(G3(:,:,:,52),wf(:,-6),G3(:,:,:,53))
  call loop_A_Q(G3(:,:,:,53),Q(:,121),MB,G4(:,:,:,16))
  call loop_AV_Q(G4(:,:,:,16),wf(:,47),G4(:,:,:,17))
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,127),MB,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,50),G4(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),MB,G5tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,46),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,41),MB,G2(:,:,:,48))
  call loop_AV_Q(G2(:,:,:,48),wf(:,12),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,121),MB,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,47),G3(:,:,:,55))
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,127),MB,G4tensor(:,39))
  call loop_AZ_Q(G3(:,:,:,54),wf(:,50),G3(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,127),MB,G4tensor(:,40))
  call loop_AV_Q(G2(:,:,:,48),wf(:,-4),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,57),MB,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-6),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,121),MB,G4(:,:,:,19))
  call loop_AV_Q(G4(:,:,:,19),wf(:,47),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MB,G5tensor(:,13))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,50),G4(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,21),Q(:,127),MB,G5tensor(:,14))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,53),G1(:,:,:,7),gZd)
  call loop_A_Q(G1(:,:,:,7),Q(:,41),MB,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,12),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,121),MB,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,47),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MB,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,59),wf(:,50),G3(:,:,:,61),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),MB,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-4),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,57),MB,G3(:,:,:,62))
  call loop_AV_Q(G3(:,:,:,62),wf(:,-6),G3(:,:,:,63))
  call loop_A_Q(G3(:,:,:,63),Q(:,121),MB,G4(:,:,:,22))
  call loop_AV_Q(G4(:,:,:,22),wf(:,47),G4(:,:,:,23))
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,127),MB,G5tensor(:,15))
  call loop_AZ_Q(G4(:,:,:,22),wf(:,50),G4(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MB,G5tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,32),MB,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,12),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,112),MB,G2(:,:,:,54))
  call loop_QS_A(G2(:,:,:,54),wf(:,94),G2(:,:,:,55),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),MB,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,54),wf(:,129),G2(:,:,:,56))
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,54),wf(:,130),G2(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),MB,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,54),wf(:,131),G2(:,:,:,58))
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,127),MB,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,54),wf(:,132),G2(:,:,:,59),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,59),Q(:,127),MB,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,54),wf(:,133),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,127),MB,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,54),wf(:,134),G2(:,:,:,61),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,61),Q(:,127),MB,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,54),wf(:,135),G2(:,:,:,62))
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,127),MB,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,54),wf(:,136),G2(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,63),Q(:,127),MB,G3tensor(:,43))
  call loop_QS_A(G2(:,:,:,54),wf(:,110),G2(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,127),MB,G3tensor(:,44))
  call loop_QV_A(G2(:,:,:,54),wf(:,137),G2(:,:,:,65))
  call check_last_Q_A(l_switch,G2(:,:,:,65),Q(:,127),MB,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,54),wf(:,138),G2(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,127),MB,G3tensor(:,46))
  call loop_QV_A(G2(:,:,:,54),wf(:,139),G2(:,:,:,67))
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,127),MB,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,54),wf(:,140),G2(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,127),MB,G3tensor(:,48))
  call loop_QV_A(G2(:,:,:,54),wf(:,141),G2(:,:,:,69))
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,127),MB,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,54),wf(:,142),G2(:,:,:,70))
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,127),MB,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,54),wf(:,143),G2(:,:,:,71),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,127),MB,G3tensor(:,51))
  call loop_QZ_A(G2(:,:,:,54),wf(:,144),G2(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,127),MB,G3tensor(:,52))
  call loop_QV_A(G2(:,:,:,54),wf(:,145),G2(:,:,:,73))
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,127),MB,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,54),wf(:,146),G2(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,127),MB,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,54),wf(:,147),G2(:,:,:,75))
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,127),MB,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,54),wf(:,148),G2(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,127),MB,G3tensor(:,56))
  call loop_QV_A(G2(:,:,:,54),wf(:,149),G2(:,:,:,77))
  call check_last_Q_A(l_switch,G2(:,:,:,77),Q(:,127),MB,G3tensor(:,57))
  call loop_QZ_A(G2(:,:,:,54),wf(:,150),G2(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,127),MB,G3tensor(:,58))
  call loop_QV_A(G2(:,:,:,54),wf(:,151),G2(:,:,:,79))
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,127),MB,G3tensor(:,59))
  call loop_QZ_A(G2(:,:,:,54),wf(:,152),G2(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,127),MB,G3tensor(:,60))
  call loop_QV_A(G2(:,:,:,54),wf(:,153),G2(:,:,:,81))
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,61))
  call loop_QZ_A(G2(:,:,:,54),wf(:,154),G2(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,127),MB,G3tensor(:,62))
  call loop_QV_A(G2(:,:,:,54),wf(:,155),G2(:,:,:,83))
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,63))
  call loop_QZ_A(G2(:,:,:,54),wf(:,156),G2(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,127),MB,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,54),wf(:,157),G2(:,:,:,85))
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,127),MB,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,54),wf(:,158),G2(:,:,:,86))
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,127),MB,G3tensor(:,66))
  call loop_QZ_A(G2(:,:,:,54),wf(:,159),G2(:,:,:,87),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,127),MB,G3tensor(:,67))
  call loop_QZ_A(G2(:,:,:,54),wf(:,160),G2(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,127),MB,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,8),wf(:,2),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,42),MB,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,12),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,122),MB,G3(:,:,:,64))
  call loop_QV_A(G3(:,:,:,64),wf(:,1),G3(:,:,:,65))
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,127),MB,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,64),wf(:,9),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),MB,G4tensor(:,44))
  call loop_QV_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,58),MB,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-6),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,122),MB,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,1),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,127),MB,G5tensor(:,17))
  call loop_QZ_A(G4(:,:,:,25),wf(:,9),G4(:,:,:,27),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,27),Q(:,127),MB,G5tensor(:,18))
  call loop_QZ_A(G1(:,:,:,8),wf(:,6),G1(:,:,:,11),gZd)
  call loop_Q_A(G1(:,:,:,11),Q(:,42),MB,G2(:,:,:,92))
  call loop_QV_A(G2(:,:,:,92),wf(:,12),G2(:,:,:,93))
  call loop_Q_A(G2(:,:,:,93),Q(:,122),MB,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,1),G3(:,:,:,70))
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),MB,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,69),wf(:,9),G3(:,:,:,71),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,71),Q(:,127),MB,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,92),wf(:,-4),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,58),MB,G3(:,:,:,72))
  call loop_QV_A(G3(:,:,:,72),wf(:,-6),G3(:,:,:,73))
  call loop_Q_A(G3(:,:,:,73),Q(:,122),MB,G4(:,:,:,28))
  call loop_QV_A(G4(:,:,:,28),wf(:,1),G4(:,:,:,29))
  call check_last_Q_A(l_switch,G4(:,:,:,29),Q(:,127),MB,G5tensor(:,19))
  call loop_QZ_A(G4(:,:,:,28),wf(:,9),G4(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,127),MB,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,8),wf(:,-4),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,48),MB,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,-6),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,112),MB,G3(:,:,:,74))
  call loop_QS_A(G3(:,:,:,74),wf(:,94),G3(:,:,:,75),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,127),MB,G4tensor(:,47))
  call loop_QV_A(G3(:,:,:,74),wf(:,129),G3(:,:,:,76))
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,127),MB,G4tensor(:,48))
  call loop_QZ_A(G3(:,:,:,74),wf(:,130),G3(:,:,:,77),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,77),Q(:,127),MB,G4tensor(:,49))
  call loop_QV_A(G3(:,:,:,74),wf(:,131),G3(:,:,:,78))
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,127),MB,G4tensor(:,50))
  call loop_QZ_A(G3(:,:,:,74),wf(:,132),G3(:,:,:,79),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,79),Q(:,127),MB,G4tensor(:,51))
  call loop_QV_A(G3(:,:,:,74),wf(:,133),G3(:,:,:,80))
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),MB,G4tensor(:,52))
  call loop_QZ_A(G3(:,:,:,74),wf(:,134),G3(:,:,:,81),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,127),MB,G4tensor(:,53))
  call loop_QV_A(G3(:,:,:,74),wf(:,135),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),MB,G4tensor(:,54))
  call loop_QZ_A(G3(:,:,:,74),wf(:,136),G3(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,127),MB,G4tensor(:,55))
  call loop_QS_A(G3(:,:,:,74),wf(:,110),G3(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),MB,G4tensor(:,56))
  call loop_QV_A(G3(:,:,:,74),wf(:,137),G3(:,:,:,85))
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,127),MB,G4tensor(:,57))
  call loop_QZ_A(G3(:,:,:,74),wf(:,138),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,127),MB,G4tensor(:,58))
  call loop_QV_A(G3(:,:,:,74),wf(:,139),G3(:,:,:,87))
  call check_last_Q_A(l_switch,G3(:,:,:,87),Q(:,127),MB,G4tensor(:,59))
  call loop_QZ_A(G3(:,:,:,74),wf(:,140),G3(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,127),MB,G4tensor(:,60))
  call loop_QV_A(G3(:,:,:,74),wf(:,141),G3(:,:,:,89))
  call check_last_Q_A(l_switch,G3(:,:,:,89),Q(:,127),MB,G4tensor(:,61))
  call loop_QV_A(G3(:,:,:,74),wf(:,142),G3(:,:,:,90))
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,127),MB,G4tensor(:,62))
  call loop_QZ_A(G3(:,:,:,74),wf(:,143),G3(:,:,:,91),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,91),Q(:,127),MB,G4tensor(:,63))
  call loop_QZ_A(G3(:,:,:,74),wf(:,144),G3(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),MB,G4tensor(:,64))
  call loop_QV_A(G3(:,:,:,74),wf(:,145),G3(:,:,:,93))
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,127),MB,G4tensor(:,65))
  call loop_QZ_A(G3(:,:,:,74),wf(:,146),G3(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,127),MB,G4tensor(:,66))
  call loop_QV_A(G3(:,:,:,74),wf(:,147),G3(:,:,:,95))
  call check_last_Q_A(l_switch,G3(:,:,:,95),Q(:,127),MB,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,74),wf(:,148),G3(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,127),MB,G4tensor(:,68))
  call loop_QV_A(G3(:,:,:,74),wf(:,149),G3(:,:,:,97))
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,127),MB,G4tensor(:,69))
  call loop_QZ_A(G3(:,:,:,74),wf(:,150),G3(:,:,:,98),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),MB,G4tensor(:,70))
  call loop_QV_A(G3(:,:,:,74),wf(:,151),G3(:,:,:,99))
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,127),MB,G4tensor(:,71))
  call loop_QZ_A(G3(:,:,:,74),wf(:,152),G3(:,:,:,100),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,127),MB,G4tensor(:,72))
  call loop_QV_A(G3(:,:,:,74),wf(:,153),G3(:,:,:,101))
  call check_last_Q_A(l_switch,G3(:,:,:,101),Q(:,127),MB,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,74),wf(:,154),G3(:,:,:,102),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,102),Q(:,127),MB,G4tensor(:,74))
  call loop_QV_A(G3(:,:,:,74),wf(:,155),G3(:,:,:,103))
  call check_last_Q_A(l_switch,G3(:,:,:,103),Q(:,127),MB,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,74),wf(:,156),G3(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,127),MB,G4tensor(:,76))
  call loop_QV_A(G3(:,:,:,74),wf(:,157),G3(:,:,:,105))
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,127),MB,G4tensor(:,77))
  call loop_QV_A(G3(:,:,:,74),wf(:,158),G3(:,:,:,106))
  call check_last_Q_A(l_switch,G3(:,:,:,106),Q(:,127),MB,G4tensor(:,78))
  call loop_QZ_A(G3(:,:,:,74),wf(:,159),G3(:,:,:,107),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,107),Q(:,127),MB,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,74),wf(:,160),G3(:,:,:,108),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,127),MB,G4tensor(:,80))
  call loop_QV_A(G2(:,:,:,95),wf(:,2),G2(:,:,:,97))
  call loop_Q_A(G2(:,:,:,97),Q(:,58),MB,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,-6),G3(:,:,:,110))
  call loop_Q_A(G3(:,:,:,110),Q(:,122),MB,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,1),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),MB,G5tensor(:,21))
  call loop_QZ_A(G4(:,:,:,31),wf(:,9),G4(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,33),Q(:,127),MB,G5tensor(:,22))
  call loop_QZ_A(G2(:,:,:,95),wf(:,6),G2(:,:,:,98),gZd)
  call loop_Q_A(G2(:,:,:,98),Q(:,58),MB,G3(:,:,:,111))
  call loop_QV_A(G3(:,:,:,111),wf(:,-6),G3(:,:,:,112))
  call loop_Q_A(G3(:,:,:,112),Q(:,122),MB,G4(:,:,:,34))
  call loop_QV_A(G4(:,:,:,34),wf(:,1),G4(:,:,:,35))
  call check_last_Q_A(l_switch,G4(:,:,:,35),Q(:,127),MB,G5tensor(:,23))
  call loop_QZ_A(G4(:,:,:,34),wf(:,9),G4(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,127),MB,G5tensor(:,24))
  call loop_QV_A(G2(:,:,:,95),wf(:,46),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,57),MB,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-6),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,121),MB,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,47),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),MB,G5tensor(:,25))
  call loop_QZ_A(G4(:,:,:,37),wf(:,50),G4(:,:,:,39),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,39),Q(:,127),MB,G5tensor(:,26))
  call loop_QZ_A(G2(:,:,:,95),wf(:,53),G2(:,:,:,100),gZd)
  call loop_Q_A(G2(:,:,:,100),Q(:,57),MB,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,-6),G3(:,:,:,116))
  call loop_Q_A(G3(:,:,:,116),Q(:,121),MB,G4(:,:,:,40))
  call loop_QV_A(G4(:,:,:,40),wf(:,47),G4(:,:,:,41))
  call check_last_Q_A(l_switch,G4(:,:,:,41),Q(:,127),MB,G5tensor(:,27))
  call loop_QZ_A(G4(:,:,:,40),wf(:,50),G4(:,:,:,42),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),MB,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,8),wf(:,46),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,41),MB,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,12),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,121),MB,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,47),G3(:,:,:,118))
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,127),MB,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,117),wf(:,50),G3(:,:,:,119),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,119),Q(:,127),MB,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,101),wf(:,-4),G2(:,:,:,103))
  call loop_Q_A(G2(:,:,:,103),Q(:,57),MB,G3(:,:,:,120))
  call loop_QV_A(G3(:,:,:,120),wf(:,-6),G3(:,:,:,121))
  call loop_Q_A(G3(:,:,:,121),Q(:,121),MB,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,47),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),MB,G5tensor(:,29))
  call loop_QZ_A(G4(:,:,:,43),wf(:,50),G4(:,:,:,45),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,45),Q(:,127),MB,G5tensor(:,30))
  call loop_QZ_A(G1(:,:,:,8),wf(:,53),G1(:,:,:,14),gZd)
  call loop_Q_A(G1(:,:,:,14),Q(:,41),MB,G2(:,:,:,104))
  call loop_QV_A(G2(:,:,:,104),wf(:,12),G2(:,:,:,105))
  call loop_Q_A(G2(:,:,:,105),Q(:,121),MB,G3(:,:,:,122))
  call loop_QV_A(G3(:,:,:,122),wf(:,47),G3(:,:,:,123))
  call check_last_Q_A(l_switch,G3(:,:,:,123),Q(:,127),MB,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,122),wf(:,50),G3(:,:,:,124),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,127),MB,G4tensor(:,84))
  call loop_QV_A(G2(:,:,:,104),wf(:,-4),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,57),MB,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-6),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,121),MB,G4(:,:,:,46))
  call loop_QV_A(G4(:,:,:,46),wf(:,47),G4(:,:,:,47))
  call check_last_Q_A(l_switch,G4(:,:,:,47),Q(:,127),MB,G5tensor(:,31))
  call loop_QZ_A(G4(:,:,:,46),wf(:,50),G4(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,127),MB,G5tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,-5),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,32),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,2),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,42),ZERO,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,12),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,122),ZERO,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,1),G3(:,:,:,128))
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,127),wf(:,9),G3(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,129),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,127),wf(:,9),G3(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,130),Q(:,127),ZERO,G4tensor(:,87))
  call loop_QV_A(G2(:,:,:,107),wf(:,-4),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,58),ZERO,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-6),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,122),ZERO,G4(:,:,:,49))
  call loop_QV_A(G4(:,:,:,49),wf(:,1),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),ZERO,G5tensor(:,33))
  call loop_QZ_A(G4(:,:,:,49),wf(:,9),G4(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,51),Q(:,127),ZERO,G5tensor(:,34))
  call loop_QZ_A(G4(:,:,:,49),wf(:,9),G4(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,127),ZERO,G5tensor(:,35))
  call loop_QZ_A(G1(:,:,:,15),wf(:,6),G1(:,:,:,17),gZu)
  call loop_Q_A(G1(:,:,:,17),Q(:,42),ZERO,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,12),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,122),ZERO,G3(:,:,:,133))
  call loop_QV_A(G3(:,:,:,133),wf(:,1),G3(:,:,:,134))
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,127),ZERO,G4tensor(:,88))
  call loop_QZ_A(G3(:,:,:,133),wf(:,9),G3(:,:,:,135),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,135),Q(:,127),ZERO,G4tensor(:,89))
  call loop_QV_A(G2(:,:,:,110),wf(:,-4),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,58),ZERO,G3(:,:,:,136))
  call loop_QV_A(G3(:,:,:,136),wf(:,-6),G3(:,:,:,137))
  call loop_Q_A(G3(:,:,:,137),Q(:,122),ZERO,G4(:,:,:,53))
  call loop_QV_A(G4(:,:,:,53),wf(:,1),G4(:,:,:,54))
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),ZERO,G5tensor(:,36))
  call loop_QZ_A(G4(:,:,:,53),wf(:,9),G4(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,55),Q(:,127),ZERO,G5tensor(:,37))
  call loop_QZ_A(G1(:,:,:,15),wf(:,6),G1(:,:,:,18),gZd)
  call loop_Q_A(G1(:,:,:,18),Q(:,42),ZERO,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,12),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,122),ZERO,G3(:,:,:,138))
  call loop_QV_A(G3(:,:,:,138),wf(:,1),G3(:,:,:,139))
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,127),ZERO,G4tensor(:,90))
  call loop_QZ_A(G3(:,:,:,138),wf(:,9),G3(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),ZERO,G4tensor(:,91))
  call loop_QV_A(G2(:,:,:,113),wf(:,-4),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,58),ZERO,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,-6),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,122),ZERO,G4(:,:,:,56))
  call loop_QV_A(G4(:,:,:,56),wf(:,1),G4(:,:,:,57))
  call check_last_Q_A(l_switch,G4(:,:,:,57),Q(:,127),ZERO,G5tensor(:,38))
  call loop_QZ_A(G4(:,:,:,56),wf(:,9),G4(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,127),ZERO,G5tensor(:,39))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,48),ZERO,G2(:,:,:,116))
  call loop_QV_A(G2(:,:,:,116),wf(:,2),G2(:,:,:,117))
  call loop_Q_A(G2(:,:,:,117),Q(:,58),ZERO,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-6),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,122),ZERO,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,1),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),ZERO,G5tensor(:,40))
  call loop_QZ_A(G4(:,:,:,59),wf(:,9),G4(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,61),Q(:,127),ZERO,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,59),wf(:,9),G4(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),ZERO,G5tensor(:,42))
  call loop_QZ_A(G2(:,:,:,116),wf(:,6),G2(:,:,:,118),gZu)
  call loop_Q_A(G2(:,:,:,118),Q(:,58),ZERO,G3(:,:,:,145))
  call loop_QV_A(G3(:,:,:,145),wf(:,-6),G3(:,:,:,146))
  call loop_Q_A(G3(:,:,:,146),Q(:,122),ZERO,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,1),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,127),ZERO,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,63),wf(:,9),G4(:,:,:,65),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,65),Q(:,127),ZERO,G5tensor(:,44))
  call loop_QZ_A(G2(:,:,:,116),wf(:,6),G2(:,:,:,119),gZd)
  call loop_Q_A(G2(:,:,:,119),Q(:,58),ZERO,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,-6),G3(:,:,:,148))
  call loop_Q_A(G3(:,:,:,148),Q(:,122),ZERO,G4(:,:,:,66))
  call loop_QV_A(G4(:,:,:,66),wf(:,1),G4(:,:,:,67))
  call check_last_Q_A(l_switch,G4(:,:,:,67),Q(:,127),ZERO,G5tensor(:,45))
  call loop_QZ_A(G4(:,:,:,66),wf(:,9),G4(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),ZERO,G5tensor(:,46))
  call loop_QV_A(G2(:,:,:,116),wf(:,-6),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,112),ZERO,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,129),G3(:,:,:,150))
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,127),ZERO,G4tensor(:,92))
  call loop_QZ_A(G3(:,:,:,149),wf(:,130),G3(:,:,:,151),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,151),Q(:,127),ZERO,G4tensor(:,93))
  call loop_QZ_A(G3(:,:,:,149),wf(:,130),G3(:,:,:,152),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),ZERO,G4tensor(:,94))
  call loop_QV_A(G3(:,:,:,149),wf(:,131),G3(:,:,:,153))
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,127),ZERO,G4tensor(:,95))
  call loop_QZ_A(G3(:,:,:,149),wf(:,132),G3(:,:,:,154),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,127),ZERO,G4tensor(:,96))
  call loop_QZ_A(G3(:,:,:,149),wf(:,132),G3(:,:,:,155),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,127),ZERO,G4tensor(:,97))
  call loop_QV_A(G3(:,:,:,149),wf(:,133),G3(:,:,:,156))
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,127),ZERO,G4tensor(:,98))
  call loop_QZ_A(G3(:,:,:,149),wf(:,134),G3(:,:,:,157),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,157),Q(:,127),ZERO,G4tensor(:,99))
  call loop_QZ_A(G3(:,:,:,149),wf(:,134),G3(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,127),ZERO,G4tensor(:,100))
  call loop_QV_A(G3(:,:,:,149),wf(:,135),G3(:,:,:,159))
  call check_last_Q_A(l_switch,G3(:,:,:,159),Q(:,127),ZERO,G4tensor(:,101))
  call loop_QZ_A(G3(:,:,:,149),wf(:,136),G3(:,:,:,160),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,160),Q(:,127),ZERO,G4tensor(:,102))
  call loop_QZ_A(G3(:,:,:,149),wf(:,136),G3(:,:,:,161),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,161),Q(:,127),ZERO,G4tensor(:,103))
  call loop_QV_A(G3(:,:,:,149),wf(:,137),G3(:,:,:,162))
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,127),ZERO,G4tensor(:,104))
  call loop_QZ_A(G3(:,:,:,149),wf(:,138),G3(:,:,:,163),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,163),Q(:,127),ZERO,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,149),wf(:,138),G3(:,:,:,164),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,127),ZERO,G4tensor(:,106))
  call loop_QV_A(G3(:,:,:,149),wf(:,139),G3(:,:,:,165))
  call check_last_Q_A(l_switch,G3(:,:,:,165),Q(:,127),ZERO,G4tensor(:,107))
  call loop_QZ_A(G3(:,:,:,149),wf(:,140),G3(:,:,:,166),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,166),Q(:,127),ZERO,G4tensor(:,108))
  call loop_QZ_A(G3(:,:,:,149),wf(:,140),G3(:,:,:,167),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,167),Q(:,127),ZERO,G4tensor(:,109))
  call loop_QV_A(G3(:,:,:,149),wf(:,141),G3(:,:,:,168))
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,127),ZERO,G4tensor(:,110))
  call loop_QV_A(G3(:,:,:,149),wf(:,142),G3(:,:,:,169))
  call check_last_Q_A(l_switch,G3(:,:,:,169),Q(:,127),ZERO,G4tensor(:,111))
  call loop_QZ_A(G3(:,:,:,149),wf(:,143),G3(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),ZERO,G4tensor(:,112))
  call loop_QZ_A(G3(:,:,:,149),wf(:,143),G3(:,:,:,171),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,171),Q(:,127),ZERO,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,149),wf(:,144),G3(:,:,:,172),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,127),ZERO,G4tensor(:,114))
  call loop_QZ_A(G3(:,:,:,149),wf(:,144),G3(:,:,:,173),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,173),Q(:,127),ZERO,G4tensor(:,115))
  call loop_QV_A(G3(:,:,:,149),wf(:,145),G3(:,:,:,174))
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,127),ZERO,G4tensor(:,116))
  call loop_QZ_A(G3(:,:,:,149),wf(:,146),G3(:,:,:,175),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,175),Q(:,127),ZERO,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,149),wf(:,146),G3(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),ZERO,G4tensor(:,118))
  call loop_QV_A(G3(:,:,:,149),wf(:,147),G3(:,:,:,177))
  call check_last_Q_A(l_switch,G3(:,:,:,177),Q(:,127),ZERO,G4tensor(:,119))
  call loop_QZ_A(G3(:,:,:,149),wf(:,148),G3(:,:,:,178),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,127),ZERO,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,149),wf(:,148),G3(:,:,:,179),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,179),Q(:,127),ZERO,G4tensor(:,121))
  call loop_QV_A(G3(:,:,:,149),wf(:,149),G3(:,:,:,180))
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,127),ZERO,G4tensor(:,122))
  call loop_QZ_A(G3(:,:,:,149),wf(:,150),G3(:,:,:,181),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,181),Q(:,127),ZERO,G4tensor(:,123))
  call loop_QZ_A(G3(:,:,:,149),wf(:,150),G3(:,:,:,182),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,127),ZERO,G4tensor(:,124))
  call loop_QV_A(G3(:,:,:,149),wf(:,151),G3(:,:,:,183))
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,127),ZERO,G4tensor(:,125))
  call loop_QZ_A(G3(:,:,:,149),wf(:,152),G3(:,:,:,184),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,184),Q(:,127),ZERO,G4tensor(:,126))
  call loop_QZ_A(G3(:,:,:,149),wf(:,152),G3(:,:,:,185),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,185),Q(:,127),ZERO,G4tensor(:,127))
  call loop_QV_A(G3(:,:,:,149),wf(:,153),G3(:,:,:,186))
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),ZERO,G4tensor(:,128))
  call loop_QZ_A(G3(:,:,:,149),wf(:,154),G3(:,:,:,187),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,187),Q(:,127),ZERO,G4tensor(:,129))
  call loop_QZ_A(G3(:,:,:,149),wf(:,154),G3(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),ZERO,G4tensor(:,130))
  call loop_QV_A(G3(:,:,:,149),wf(:,155),G3(:,:,:,189))
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),ZERO,G4tensor(:,131))
  call loop_QZ_A(G3(:,:,:,149),wf(:,156),G3(:,:,:,190),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),ZERO,G4tensor(:,132))
  call loop_QZ_A(G3(:,:,:,149),wf(:,156),G3(:,:,:,191),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,191),Q(:,127),ZERO,G4tensor(:,133))
  call loop_QV_A(G3(:,:,:,149),wf(:,157),G3(:,:,:,192))
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,127),ZERO,G4tensor(:,134))
  call loop_QV_A(G3(:,:,:,149),wf(:,158),G3(:,:,:,193))
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,127),ZERO,G4tensor(:,135))
  call loop_QZ_A(G3(:,:,:,149),wf(:,159),G3(:,:,:,194),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,136))
  call loop_QZ_A(G3(:,:,:,149),wf(:,159),G3(:,:,:,195),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,195),Q(:,127),ZERO,G4tensor(:,137))
  call loop_QZ_A(G3(:,:,:,149),wf(:,160),G3(:,:,:,196),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,127),ZERO,G4tensor(:,138))
  call loop_QZ_A(G3(:,:,:,149),wf(:,160),G3(:,:,:,197),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,197),Q(:,127),ZERO,G4tensor(:,139))
  call loop_QV_A(G2(:,:,:,116),wf(:,46),G2(:,:,:,121))
  call loop_Q_A(G2(:,:,:,121),Q(:,57),ZERO,G3(:,:,:,198))
  call loop_QV_A(G3(:,:,:,198),wf(:,-6),G3(:,:,:,199))
  call loop_Q_A(G3(:,:,:,199),Q(:,121),ZERO,G4(:,:,:,69))
  call loop_QV_A(G4(:,:,:,69),wf(:,47),G4(:,:,:,70))
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,127),ZERO,G5tensor(:,47))
  call loop_QZ_A(G4(:,:,:,69),wf(:,50),G4(:,:,:,71),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,71),Q(:,127),ZERO,G5tensor(:,48))
  call loop_QZ_A(G4(:,:,:,69),wf(:,50),G4(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),ZERO,G5tensor(:,49))
  call loop_QZ_A(G2(:,:,:,116),wf(:,53),G2(:,:,:,122),gZu)
  call loop_Q_A(G2(:,:,:,122),Q(:,57),ZERO,G3(:,:,:,200))
  call loop_QV_A(G3(:,:,:,200),wf(:,-6),G3(:,:,:,201))
  call loop_Q_A(G3(:,:,:,201),Q(:,121),ZERO,G4(:,:,:,73))
  call loop_QV_A(G4(:,:,:,73),wf(:,47),G4(:,:,:,74))
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,50))
  call loop_QZ_A(G4(:,:,:,73),wf(:,50),G4(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,75),Q(:,127),ZERO,G5tensor(:,51))
  call loop_QZ_A(G2(:,:,:,116),wf(:,53),G2(:,:,:,123),gZd)
  call loop_Q_A(G2(:,:,:,123),Q(:,57),ZERO,G3(:,:,:,202))
  call loop_QV_A(G3(:,:,:,202),wf(:,-6),G3(:,:,:,203))
  call loop_Q_A(G3(:,:,:,203),Q(:,121),ZERO,G4(:,:,:,76))
  call loop_QV_A(G4(:,:,:,76),wf(:,47),G4(:,:,:,77))
  call check_last_Q_A(l_switch,G4(:,:,:,77),Q(:,127),ZERO,G5tensor(:,52))
  call loop_QZ_A(G4(:,:,:,76),wf(:,50),G4(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),ZERO,G5tensor(:,53))
  call loop_QV_A(G1(:,:,:,15),wf(:,12),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,112),ZERO,G2(:,:,:,124))
  call loop_QV_A(G2(:,:,:,124),wf(:,129),G2(:,:,:,125))
  call check_last_Q_A(l_switch,G2(:,:,:,125),Q(:,127),ZERO,G3tensor(:,69))
  call loop_QZ_A(G2(:,:,:,124),wf(:,130),G2(:,:,:,126),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,126),Q(:,127),ZERO,G3tensor(:,70))
  call loop_QZ_A(G2(:,:,:,124),wf(:,130),G2(:,:,:,127),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,127),Q(:,127),ZERO,G3tensor(:,71))
  call loop_QV_A(G2(:,:,:,124),wf(:,131),G2(:,:,:,128))
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,127),ZERO,G3tensor(:,72))
  call loop_QZ_A(G2(:,:,:,124),wf(:,132),G2(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,127),ZERO,G3tensor(:,73))
  call loop_QZ_A(G2(:,:,:,124),wf(:,132),G2(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,74))
  call loop_QV_A(G2(:,:,:,124),wf(:,133),G2(:,:,:,131))
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,75))
  call loop_QZ_A(G2(:,:,:,124),wf(:,134),G2(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,76))
  call loop_QZ_A(G2(:,:,:,124),wf(:,134),G2(:,:,:,133),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,77))
  call loop_QV_A(G2(:,:,:,124),wf(:,135),G2(:,:,:,134))
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,78))
  call loop_QZ_A(G2(:,:,:,124),wf(:,136),G2(:,:,:,135),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,79))
  call loop_QZ_A(G2(:,:,:,124),wf(:,136),G2(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,80))
  call loop_QV_A(G2(:,:,:,124),wf(:,137),G2(:,:,:,137))
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,81))
  call loop_QZ_A(G2(:,:,:,124),wf(:,138),G2(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,82))
  call loop_QZ_A(G2(:,:,:,124),wf(:,138),G2(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,83))
  call loop_QV_A(G2(:,:,:,124),wf(:,139),G2(:,:,:,140))
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,127),ZERO,G3tensor(:,84))
  call loop_QZ_A(G2(:,:,:,124),wf(:,140),G2(:,:,:,141),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,85))
  call loop_QZ_A(G2(:,:,:,124),wf(:,140),G2(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,127),ZERO,G3tensor(:,86))
  call loop_QV_A(G2(:,:,:,124),wf(:,141),G2(:,:,:,143))
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,127),ZERO,G3tensor(:,87))
  call loop_QV_A(G2(:,:,:,124),wf(:,142),G2(:,:,:,144))
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,127),ZERO,G3tensor(:,88))
  call loop_QZ_A(G2(:,:,:,124),wf(:,143),G2(:,:,:,145),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,89))
  call loop_QZ_A(G2(:,:,:,124),wf(:,143),G2(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,127),ZERO,G3tensor(:,90))
  call loop_QZ_A(G2(:,:,:,124),wf(:,144),G2(:,:,:,147),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,127),ZERO,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,124),wf(:,144),G2(:,:,:,148),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,127),ZERO,G3tensor(:,92))
  call loop_QV_A(G2(:,:,:,124),wf(:,145),G2(:,:,:,149))
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,127),ZERO,G3tensor(:,93))
  call loop_QZ_A(G2(:,:,:,124),wf(:,146),G2(:,:,:,150),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,127),ZERO,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,124),wf(:,146),G2(:,:,:,151),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,127),ZERO,G3tensor(:,95))
  call loop_QV_A(G2(:,:,:,124),wf(:,147),G2(:,:,:,152))
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,127),ZERO,G3tensor(:,96))
  call loop_QZ_A(G2(:,:,:,124),wf(:,148),G2(:,:,:,153),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,153),Q(:,127),ZERO,G3tensor(:,97))
  call loop_QZ_A(G2(:,:,:,124),wf(:,148),G2(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,127),ZERO,G3tensor(:,98))
  call loop_QV_A(G2(:,:,:,124),wf(:,149),G2(:,:,:,155))
  call check_last_Q_A(l_switch,G2(:,:,:,155),Q(:,127),ZERO,G3tensor(:,99))
  call loop_QZ_A(G2(:,:,:,124),wf(:,150),G2(:,:,:,156),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,127),ZERO,G3tensor(:,100))
  call loop_QZ_A(G2(:,:,:,124),wf(:,150),G2(:,:,:,157),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,157),Q(:,127),ZERO,G3tensor(:,101))
  call loop_QV_A(G2(:,:,:,124),wf(:,151),G2(:,:,:,158))
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,127),ZERO,G3tensor(:,102))
  call loop_QZ_A(G2(:,:,:,124),wf(:,152),G2(:,:,:,159),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,159),Q(:,127),ZERO,G3tensor(:,103))
  call loop_QZ_A(G2(:,:,:,124),wf(:,152),G2(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,127),ZERO,G3tensor(:,104))
  call loop_QV_A(G2(:,:,:,124),wf(:,153),G2(:,:,:,161))
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,127),ZERO,G3tensor(:,105))
  call loop_QZ_A(G2(:,:,:,124),wf(:,154),G2(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,162),Q(:,127),ZERO,G3tensor(:,106))
  call loop_QZ_A(G2(:,:,:,124),wf(:,154),G2(:,:,:,163),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,163),Q(:,127),ZERO,G3tensor(:,107))
  call loop_QV_A(G2(:,:,:,124),wf(:,155),G2(:,:,:,164))
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,127),ZERO,G3tensor(:,108))
  call loop_QZ_A(G2(:,:,:,124),wf(:,156),G2(:,:,:,165),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,165),Q(:,127),ZERO,G3tensor(:,109))
  call loop_QZ_A(G2(:,:,:,124),wf(:,156),G2(:,:,:,166),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,127),ZERO,G3tensor(:,110))
  call loop_QV_A(G2(:,:,:,124),wf(:,157),G2(:,:,:,167))
  call check_last_Q_A(l_switch,G2(:,:,:,167),Q(:,127),ZERO,G3tensor(:,111))
  call loop_QV_A(G2(:,:,:,124),wf(:,158),G2(:,:,:,168))
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,127),ZERO,G3tensor(:,112))
  call loop_QZ_A(G2(:,:,:,124),wf(:,159),G2(:,:,:,169),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,169),Q(:,127),ZERO,G3tensor(:,113))
  call loop_QZ_A(G2(:,:,:,124),wf(:,159),G2(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,170),Q(:,127),ZERO,G3tensor(:,114))
  call loop_QZ_A(G2(:,:,:,124),wf(:,160),G2(:,:,:,171),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,171),Q(:,127),ZERO,G3tensor(:,115))
  call loop_QZ_A(G2(:,:,:,124),wf(:,160),G2(:,:,:,172),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,172),Q(:,127),ZERO,G3tensor(:,116))
  call loop_QV_A(G1(:,:,:,15),wf(:,46),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,41),ZERO,G2(:,:,:,173))
  call loop_QV_A(G2(:,:,:,173),wf(:,12),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,121),ZERO,G3(:,:,:,204))
  call loop_QV_A(G3(:,:,:,204),wf(:,47),G3(:,:,:,205))
  call check_last_Q_A(l_switch,G3(:,:,:,205),Q(:,127),ZERO,G4tensor(:,140))
  call loop_QZ_A(G3(:,:,:,204),wf(:,50),G3(:,:,:,206),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,127),ZERO,G4tensor(:,141))
  call loop_QZ_A(G3(:,:,:,204),wf(:,50),G3(:,:,:,207),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,207),Q(:,127),ZERO,G4tensor(:,142))
  call loop_QV_A(G2(:,:,:,173),wf(:,-4),G2(:,:,:,175))
  call loop_Q_A(G2(:,:,:,175),Q(:,57),ZERO,G3(:,:,:,208))
  call loop_QV_A(G3(:,:,:,208),wf(:,-6),G3(:,:,:,209))
  call loop_Q_A(G3(:,:,:,209),Q(:,121),ZERO,G4(:,:,:,79))
  call loop_QV_A(G4(:,:,:,79),wf(:,47),G4(:,:,:,80))
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,54))
  call loop_QZ_A(G4(:,:,:,79),wf(:,50),G4(:,:,:,81),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,81),Q(:,127),ZERO,G5tensor(:,55))
  call loop_QZ_A(G4(:,:,:,79),wf(:,50),G4(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,127),ZERO,G5tensor(:,56))
  call loop_QZ_A(G1(:,:,:,15),wf(:,53),G1(:,:,:,22),gZu)
  call loop_Q_A(G1(:,:,:,22),Q(:,41),ZERO,G2(:,:,:,176))
  call loop_QV_A(G2(:,:,:,176),wf(:,12),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,121),ZERO,G3(:,:,:,210))
  call loop_QV_A(G3(:,:,:,210),wf(:,47),G3(:,:,:,211))
  call check_last_Q_A(l_switch,G3(:,:,:,211),Q(:,127),ZERO,G4tensor(:,143))
  call loop_QZ_A(G3(:,:,:,210),wf(:,50),G3(:,:,:,212),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,127),ZERO,G4tensor(:,144))
  call loop_QV_A(G2(:,:,:,176),wf(:,-4),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,57),ZERO,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-6),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,121),ZERO,G4(:,:,:,83))
  call loop_QV_A(G4(:,:,:,83),wf(:,47),G4(:,:,:,84))
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,57))
  call loop_QZ_A(G4(:,:,:,83),wf(:,50),G4(:,:,:,85),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,85),Q(:,127),ZERO,G5tensor(:,58))
  call loop_QZ_A(G1(:,:,:,15),wf(:,53),G1(:,:,:,23),gZd)
  call loop_Q_A(G1(:,:,:,23),Q(:,41),ZERO,G2(:,:,:,179))
  call loop_QV_A(G2(:,:,:,179),wf(:,12),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,121),ZERO,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,47),G3(:,:,:,216))
  call check_last_Q_A(l_switch,G3(:,:,:,216),Q(:,127),ZERO,G4tensor(:,145))
  call loop_QZ_A(G3(:,:,:,215),wf(:,50),G3(:,:,:,217),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,217),Q(:,127),ZERO,G4tensor(:,146))
  call loop_QV_A(G2(:,:,:,179),wf(:,-4),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,57),ZERO,G3(:,:,:,218))
  call loop_QV_A(G3(:,:,:,218),wf(:,-6),G3(:,:,:,219))
  call loop_Q_A(G3(:,:,:,219),Q(:,121),ZERO,G4(:,:,:,86))
  call loop_QV_A(G4(:,:,:,86),wf(:,47),G4(:,:,:,87))
  call check_last_Q_A(l_switch,G4(:,:,:,87),Q(:,127),ZERO,G5tensor(:,59))
  call loop_QZ_A(G4(:,:,:,86),wf(:,50),G4(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,32),ZERO,G1(:,:,:,24))
  call loop_AV_Q(G1(:,:,:,24),wf(:,2),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,42),ZERO,G2(:,:,:,182))
  call loop_AV_Q(G2(:,:,:,182),wf(:,12),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,122),ZERO,G3(:,:,:,220))
  call loop_AV_Q(G3(:,:,:,220),wf(:,1),G3(:,:,:,221))
  call check_last_A_Q(l_switch,G3(:,:,:,221),Q(:,127),ZERO,G4tensor(:,147))
  call loop_AZ_Q(G3(:,:,:,220),wf(:,9),G3(:,:,:,222),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,222),Q(:,127),ZERO,G4tensor(:,148))
  call loop_AZ_Q(G3(:,:,:,220),wf(:,9),G3(:,:,:,223),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,223),Q(:,127),ZERO,G4tensor(:,149))
  call loop_AV_Q(G2(:,:,:,182),wf(:,-4),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,58),ZERO,G3(:,:,:,224))
  call loop_AV_Q(G3(:,:,:,224),wf(:,-6),G3(:,:,:,225))
  call loop_A_Q(G3(:,:,:,225),Q(:,122),ZERO,G4(:,:,:,89))
  call loop_AV_Q(G4(:,:,:,89),wf(:,1),G4(:,:,:,90))
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,61))
  call loop_AZ_Q(G4(:,:,:,89),wf(:,9),G4(:,:,:,91),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,91),Q(:,127),ZERO,G5tensor(:,62))
  call loop_AZ_Q(G4(:,:,:,89),wf(:,9),G4(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,127),ZERO,G5tensor(:,63))
  call loop_AZ_Q(G1(:,:,:,24),wf(:,6),G1(:,:,:,26),gZu)
  call loop_A_Q(G1(:,:,:,26),Q(:,42),ZERO,G2(:,:,:,185))
  call loop_AV_Q(G2(:,:,:,185),wf(:,12),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,122),ZERO,G3(:,:,:,226))
  call loop_AV_Q(G3(:,:,:,226),wf(:,1),G3(:,:,:,227))
  call check_last_A_Q(l_switch,G3(:,:,:,227),Q(:,127),ZERO,G4tensor(:,150))
  call loop_AZ_Q(G3(:,:,:,226),wf(:,9),G3(:,:,:,228),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,127),ZERO,G4tensor(:,151))
  call loop_AV_Q(G2(:,:,:,185),wf(:,-4),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,58),ZERO,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,-6),G3(:,:,:,230))
  call loop_A_Q(G3(:,:,:,230),Q(:,122),ZERO,G4(:,:,:,93))
  call loop_AV_Q(G4(:,:,:,93),wf(:,1),G4(:,:,:,94))
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,127),ZERO,G5tensor(:,64))
  call loop_AZ_Q(G4(:,:,:,93),wf(:,9),G4(:,:,:,95),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,95),Q(:,127),ZERO,G5tensor(:,65))
  call loop_AZ_Q(G1(:,:,:,24),wf(:,6),G1(:,:,:,27),gZd)
  call loop_A_Q(G1(:,:,:,27),Q(:,42),ZERO,G2(:,:,:,188))
  call loop_AV_Q(G2(:,:,:,188),wf(:,12),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,122),ZERO,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,1),G3(:,:,:,232))
  call check_last_A_Q(l_switch,G3(:,:,:,232),Q(:,127),ZERO,G4tensor(:,152))
  call loop_AZ_Q(G3(:,:,:,231),wf(:,9),G3(:,:,:,233),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,233),Q(:,127),ZERO,G4tensor(:,153))
  call loop_AV_Q(G2(:,:,:,188),wf(:,-4),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,58),ZERO,G3(:,:,:,234))
  call loop_AV_Q(G3(:,:,:,234),wf(:,-6),G3(:,:,:,235))
  call loop_A_Q(G3(:,:,:,235),Q(:,122),ZERO,G4(:,:,:,96))
  call loop_AV_Q(G4(:,:,:,96),wf(:,1),G4(:,:,:,97))
  call check_last_A_Q(l_switch,G4(:,:,:,97),Q(:,127),ZERO,G5tensor(:,66))
  call loop_AZ_Q(G4(:,:,:,96),wf(:,9),G4(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),ZERO,G5tensor(:,67))
  call loop_AV_Q(G1(:,:,:,24),wf(:,-4),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,48),ZERO,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,2),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,58),ZERO,G3(:,:,:,236))
  call loop_AV_Q(G3(:,:,:,236),wf(:,-6),G3(:,:,:,237))
  call loop_A_Q(G3(:,:,:,237),Q(:,122),ZERO,G4(:,:,:,99))
  call loop_AV_Q(G4(:,:,:,99),wf(:,1),G4(:,:,:,100))
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,127),ZERO,G5tensor(:,68))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,9),G4(:,:,:,101),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,101),Q(:,127),ZERO,G5tensor(:,69))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,9),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),ZERO,G5tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,191),wf(:,6),G2(:,:,:,193),gZu)
  call loop_A_Q(G2(:,:,:,193),Q(:,58),ZERO,G3(:,:,:,238))
  call loop_AV_Q(G3(:,:,:,238),wf(:,-6),G3(:,:,:,239))
  call loop_A_Q(G3(:,:,:,239),Q(:,122),ZERO,G4(:,:,:,103))
  call loop_AV_Q(G4(:,:,:,103),wf(:,1),G4(:,:,:,104))
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),ZERO,G5tensor(:,71))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,9),G4(:,:,:,105),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,105),Q(:,127),ZERO,G5tensor(:,72))
  call loop_AZ_Q(G2(:,:,:,191),wf(:,6),G2(:,:,:,194),gZd)
  call loop_A_Q(G2(:,:,:,194),Q(:,58),ZERO,G3(:,:,:,240))
  call loop_AV_Q(G3(:,:,:,240),wf(:,-6),G3(:,:,:,241))
  call loop_A_Q(G3(:,:,:,241),Q(:,122),ZERO,G4(:,:,:,106))
  call loop_AV_Q(G4(:,:,:,106),wf(:,1),G4(:,:,:,107))
  call check_last_A_Q(l_switch,G4(:,:,:,107),Q(:,127),ZERO,G5tensor(:,73))
  call loop_AZ_Q(G4(:,:,:,106),wf(:,9),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),ZERO,G5tensor(:,74))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-6),G2(:,:,:,195))
  call loop_A_Q(G2(:,:,:,195),Q(:,112),ZERO,G3(:,:,:,242))
  call loop_AV_Q(G3(:,:,:,242),wf(:,129),G3(:,:,:,243))
  call check_last_A_Q(l_switch,G3(:,:,:,243),Q(:,127),ZERO,G4tensor(:,154))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,130),G3(:,:,:,244),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,244),Q(:,127),ZERO,G4tensor(:,155))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,130),G3(:,:,:,245),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,245),Q(:,127),ZERO,G4tensor(:,156))
  call loop_AV_Q(G3(:,:,:,242),wf(:,131),G3(:,:,:,246))
  call check_last_A_Q(l_switch,G3(:,:,:,246),Q(:,127),ZERO,G4tensor(:,157))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,132),G3(:,:,:,247),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,247),Q(:,127),ZERO,G4tensor(:,158))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,132),G3(:,:,:,248),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,248),Q(:,127),ZERO,G4tensor(:,159))
  call loop_AV_Q(G3(:,:,:,242),wf(:,133),G3(:,:,:,249))
  call check_last_A_Q(l_switch,G3(:,:,:,249),Q(:,127),ZERO,G4tensor(:,160))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,134),G3(:,:,:,250),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,250),Q(:,127),ZERO,G4tensor(:,161))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,134),G3(:,:,:,251),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,251),Q(:,127),ZERO,G4tensor(:,162))
  call loop_AV_Q(G3(:,:,:,242),wf(:,135),G3(:,:,:,252))
  call check_last_A_Q(l_switch,G3(:,:,:,252),Q(:,127),ZERO,G4tensor(:,163))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,136),G3(:,:,:,253),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,253),Q(:,127),ZERO,G4tensor(:,164))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,136),G3(:,:,:,254),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,127),ZERO,G4tensor(:,165))
  call loop_AV_Q(G3(:,:,:,242),wf(:,137),G3(:,:,:,255))
  call check_last_A_Q(l_switch,G3(:,:,:,255),Q(:,127),ZERO,G4tensor(:,166))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,138),G3(:,:,:,256),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,127),ZERO,G4tensor(:,167))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,138),G3(:,:,:,257),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,257),Q(:,127),ZERO,G4tensor(:,168))
  call loop_AV_Q(G3(:,:,:,242),wf(:,139),G3(:,:,:,258))
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,169))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,140),G3(:,:,:,259),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,259),Q(:,127),ZERO,G4tensor(:,170))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,140),G3(:,:,:,260),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),ZERO,G4tensor(:,171))
  call loop_AV_Q(G3(:,:,:,242),wf(:,141),G3(:,:,:,261))
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),ZERO,G4tensor(:,172))
  call loop_AV_Q(G3(:,:,:,242),wf(:,142),G3(:,:,:,262))
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,173))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,143),G3(:,:,:,263),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,263),Q(:,127),ZERO,G4tensor(:,174))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,143),G3(:,:,:,264),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,127),ZERO,G4tensor(:,175))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,144),G3(:,:,:,265),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,265),Q(:,127),ZERO,G4tensor(:,176))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,144),G3(:,:,:,266),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,266),Q(:,127),ZERO,G4tensor(:,177))
  call loop_AV_Q(G3(:,:,:,242),wf(:,145),G3(:,:,:,267))
  call check_last_A_Q(l_switch,G3(:,:,:,267),Q(:,127),ZERO,G4tensor(:,178))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,146),G3(:,:,:,268),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,268),Q(:,127),ZERO,G4tensor(:,179))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,146),G3(:,:,:,269),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,269),Q(:,127),ZERO,G4tensor(:,180))
  call loop_AV_Q(G3(:,:,:,242),wf(:,147),G3(:,:,:,270))
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,127),ZERO,G4tensor(:,181))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,148),G3(:,:,:,271),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,271),Q(:,127),ZERO,G4tensor(:,182))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,148),G3(:,:,:,272),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,127),ZERO,G4tensor(:,183))
  call loop_AV_Q(G3(:,:,:,242),wf(:,149),G3(:,:,:,273))
  call check_last_A_Q(l_switch,G3(:,:,:,273),Q(:,127),ZERO,G4tensor(:,184))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,150),G3(:,:,:,274),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,274),Q(:,127),ZERO,G4tensor(:,185))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,150),G3(:,:,:,275),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,275),Q(:,127),ZERO,G4tensor(:,186))
  call loop_AV_Q(G3(:,:,:,242),wf(:,151),G3(:,:,:,276))
  call check_last_A_Q(l_switch,G3(:,:,:,276),Q(:,127),ZERO,G4tensor(:,187))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,152),G3(:,:,:,277),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,277),Q(:,127),ZERO,G4tensor(:,188))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,152),G3(:,:,:,278),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,127),ZERO,G4tensor(:,189))
  call loop_AV_Q(G3(:,:,:,242),wf(:,153),G3(:,:,:,279))
  call check_last_A_Q(l_switch,G3(:,:,:,279),Q(:,127),ZERO,G4tensor(:,190))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,154),G3(:,:,:,280),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,280),Q(:,127),ZERO,G4tensor(:,191))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,154),G3(:,:,:,281),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,281),Q(:,127),ZERO,G4tensor(:,192))
  call loop_AV_Q(G3(:,:,:,242),wf(:,155),G3(:,:,:,282))
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,127),ZERO,G4tensor(:,193))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,156),G3(:,:,:,283),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,283),Q(:,127),ZERO,G4tensor(:,194))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,156),G3(:,:,:,284),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,284),Q(:,127),ZERO,G4tensor(:,195))
  call loop_AV_Q(G3(:,:,:,242),wf(:,157),G3(:,:,:,285))
  call check_last_A_Q(l_switch,G3(:,:,:,285),Q(:,127),ZERO,G4tensor(:,196))
  call loop_AV_Q(G3(:,:,:,242),wf(:,158),G3(:,:,:,286))
  call check_last_A_Q(l_switch,G3(:,:,:,286),Q(:,127),ZERO,G4tensor(:,197))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,159),G3(:,:,:,287),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,287),Q(:,127),ZERO,G4tensor(:,198))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,159),G3(:,:,:,288),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,127),ZERO,G4tensor(:,199))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,160),G3(:,:,:,289),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,289),Q(:,127),ZERO,G4tensor(:,200))
  call loop_AZ_Q(G3(:,:,:,242),wf(:,160),G3(:,:,:,290),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,290),Q(:,127),ZERO,G4tensor(:,201))
  call loop_AV_Q(G2(:,:,:,191),wf(:,46),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,57),ZERO,G3(:,:,:,291))
  call loop_AV_Q(G3(:,:,:,291),wf(:,-6),G3(:,:,:,292))
  call loop_A_Q(G3(:,:,:,292),Q(:,121),ZERO,G4(:,:,:,109))
  call loop_AV_Q(G4(:,:,:,109),wf(:,47),G4(:,:,:,110))
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,127),ZERO,G5tensor(:,75))
  call loop_AZ_Q(G4(:,:,:,109),wf(:,50),G4(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,111),Q(:,127),ZERO,G5tensor(:,76))
  call loop_AZ_Q(G4(:,:,:,109),wf(:,50),G4(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,127),ZERO,G5tensor(:,77))
  call loop_AZ_Q(G2(:,:,:,191),wf(:,53),G2(:,:,:,197),gZu)
  call loop_A_Q(G2(:,:,:,197),Q(:,57),ZERO,G3(:,:,:,293))
  call loop_AV_Q(G3(:,:,:,293),wf(:,-6),G3(:,:,:,294))
  call loop_A_Q(G3(:,:,:,294),Q(:,121),ZERO,G4(:,:,:,113))
  call loop_AV_Q(G4(:,:,:,113),wf(:,47),G4(:,:,:,114))
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,127),ZERO,G5tensor(:,78))
  call loop_AZ_Q(G4(:,:,:,113),wf(:,50),G4(:,:,:,115),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,115),Q(:,127),ZERO,G5tensor(:,79))
  call loop_AZ_Q(G2(:,:,:,191),wf(:,53),G2(:,:,:,198),gZd)
  call loop_A_Q(G2(:,:,:,198),Q(:,57),ZERO,G3(:,:,:,295))
  call loop_AV_Q(G3(:,:,:,295),wf(:,-6),G3(:,:,:,296))
  call loop_A_Q(G3(:,:,:,296),Q(:,121),ZERO,G4(:,:,:,116))
  call loop_AV_Q(G4(:,:,:,116),wf(:,47),G4(:,:,:,117))
  call check_last_A_Q(l_switch,G4(:,:,:,117),Q(:,127),ZERO,G5tensor(:,80))
  call loop_AZ_Q(G4(:,:,:,116),wf(:,50),G4(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,118),Q(:,127),ZERO,G5tensor(:,81))
  call loop_AV_Q(G1(:,:,:,24),wf(:,12),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,112),ZERO,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,129),G2(:,:,:,200))
  call check_last_A_Q(l_switch,G2(:,:,:,200),Q(:,127),ZERO,G3tensor(:,117))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,130),G2(:,:,:,201),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,201),Q(:,127),ZERO,G3tensor(:,118))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,130),G2(:,:,:,202),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,202),Q(:,127),ZERO,G3tensor(:,119))
  call loop_AV_Q(G2(:,:,:,199),wf(:,131),G2(:,:,:,203))
  call check_last_A_Q(l_switch,G2(:,:,:,203),Q(:,127),ZERO,G3tensor(:,120))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,132),G2(:,:,:,204),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,127),ZERO,G3tensor(:,121))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,132),G2(:,:,:,205),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,205),Q(:,127),ZERO,G3tensor(:,122))
  call loop_AV_Q(G2(:,:,:,199),wf(:,133),G2(:,:,:,206))
  call check_last_A_Q(l_switch,G2(:,:,:,206),Q(:,127),ZERO,G3tensor(:,123))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,134),G2(:,:,:,207),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,207),Q(:,127),ZERO,G3tensor(:,124))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,134),G2(:,:,:,208),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,127),ZERO,G3tensor(:,125))
  call loop_AV_Q(G2(:,:,:,199),wf(:,135),G2(:,:,:,209))
  call check_last_A_Q(l_switch,G2(:,:,:,209),Q(:,127),ZERO,G3tensor(:,126))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,136),G2(:,:,:,210),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,127),ZERO,G3tensor(:,127))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,136),G2(:,:,:,211),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,211),Q(:,127),ZERO,G3tensor(:,128))
  call loop_AV_Q(G2(:,:,:,199),wf(:,137),G2(:,:,:,212))
  call check_last_A_Q(l_switch,G2(:,:,:,212),Q(:,127),ZERO,G3tensor(:,129))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,138),G2(:,:,:,213),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,213),Q(:,127),ZERO,G3tensor(:,130))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,138),G2(:,:,:,214),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,127),ZERO,G3tensor(:,131))
  call loop_AV_Q(G2(:,:,:,199),wf(:,139),G2(:,:,:,215))
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,127),ZERO,G3tensor(:,132))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,140),G2(:,:,:,216),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,216),Q(:,127),ZERO,G3tensor(:,133))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,140),G2(:,:,:,217),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,217),Q(:,127),ZERO,G3tensor(:,134))
  call loop_AV_Q(G2(:,:,:,199),wf(:,141),G2(:,:,:,218))
  call check_last_A_Q(l_switch,G2(:,:,:,218),Q(:,127),ZERO,G3tensor(:,135))
  call loop_AV_Q(G2(:,:,:,199),wf(:,142),G2(:,:,:,219))
  call check_last_A_Q(l_switch,G2(:,:,:,219),Q(:,127),ZERO,G3tensor(:,136))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,143),G2(:,:,:,220),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,220),Q(:,127),ZERO,G3tensor(:,137))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,143),G2(:,:,:,221),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,221),Q(:,127),ZERO,G3tensor(:,138))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,144),G2(:,:,:,222),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,222),Q(:,127),ZERO,G3tensor(:,139))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,144),G2(:,:,:,223),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,223),Q(:,127),ZERO,G3tensor(:,140))
  call loop_AV_Q(G2(:,:,:,199),wf(:,145),G2(:,:,:,224))
  call check_last_A_Q(l_switch,G2(:,:,:,224),Q(:,127),ZERO,G3tensor(:,141))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,146),G2(:,:,:,225),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,225),Q(:,127),ZERO,G3tensor(:,142))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,146),G2(:,:,:,226),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,226),Q(:,127),ZERO,G3tensor(:,143))
  call loop_AV_Q(G2(:,:,:,199),wf(:,147),G2(:,:,:,227))
  call check_last_A_Q(l_switch,G2(:,:,:,227),Q(:,127),ZERO,G3tensor(:,144))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,148),G2(:,:,:,228),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,127),ZERO,G3tensor(:,145))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,148),G2(:,:,:,229),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,229),Q(:,127),ZERO,G3tensor(:,146))
  call loop_AV_Q(G2(:,:,:,199),wf(:,149),G2(:,:,:,230))
  call check_last_A_Q(l_switch,G2(:,:,:,230),Q(:,127),ZERO,G3tensor(:,147))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,150),G2(:,:,:,231),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,231),Q(:,127),ZERO,G3tensor(:,148))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,150),G2(:,:,:,232),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,232),Q(:,127),ZERO,G3tensor(:,149))
  call loop_AV_Q(G2(:,:,:,199),wf(:,151),G2(:,:,:,233))
  call check_last_A_Q(l_switch,G2(:,:,:,233),Q(:,127),ZERO,G3tensor(:,150))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,152),G2(:,:,:,234),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,234),Q(:,127),ZERO,G3tensor(:,151))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,152),G2(:,:,:,235),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,235),Q(:,127),ZERO,G3tensor(:,152))
  call loop_AV_Q(G2(:,:,:,199),wf(:,153),G2(:,:,:,236))
  call check_last_A_Q(l_switch,G2(:,:,:,236),Q(:,127),ZERO,G3tensor(:,153))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,154),G2(:,:,:,237),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,237),Q(:,127),ZERO,G3tensor(:,154))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,154),G2(:,:,:,238),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,238),Q(:,127),ZERO,G3tensor(:,155))
  call loop_AV_Q(G2(:,:,:,199),wf(:,155),G2(:,:,:,239))
  call check_last_A_Q(l_switch,G2(:,:,:,239),Q(:,127),ZERO,G3tensor(:,156))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,156),G2(:,:,:,240),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,240),Q(:,127),ZERO,G3tensor(:,157))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,156),G2(:,:,:,241),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,241),Q(:,127),ZERO,G3tensor(:,158))
  call loop_AV_Q(G2(:,:,:,199),wf(:,157),G2(:,:,:,242))
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,127),ZERO,G3tensor(:,159))
  call loop_AV_Q(G2(:,:,:,199),wf(:,158),G2(:,:,:,243))
  call check_last_A_Q(l_switch,G2(:,:,:,243),Q(:,127),ZERO,G3tensor(:,160))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,159),G2(:,:,:,244),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,244),Q(:,127),ZERO,G3tensor(:,161))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,159),G2(:,:,:,245),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,245),Q(:,127),ZERO,G3tensor(:,162))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,160),G2(:,:,:,246),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,246),Q(:,127),ZERO,G3tensor(:,163))
  call loop_AZ_Q(G2(:,:,:,199),wf(:,160),G2(:,:,:,247),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,247),Q(:,127),ZERO,G3tensor(:,164))
  call loop_AV_Q(G1(:,:,:,24),wf(:,46),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,41),ZERO,G2(:,:,:,248))
  call loop_AV_Q(G2(:,:,:,248),wf(:,12),G2(:,:,:,249))
  call loop_A_Q(G2(:,:,:,249),Q(:,121),ZERO,G3(:,:,:,297))
  call loop_AV_Q(G3(:,:,:,297),wf(:,47),G3(:,:,:,298))
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,202))
  call loop_AZ_Q(G3(:,:,:,297),wf(:,50),G3(:,:,:,299),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,299),Q(:,127),ZERO,G4tensor(:,203))
  call loop_AZ_Q(G3(:,:,:,297),wf(:,50),G3(:,:,:,300),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,127),ZERO,G4tensor(:,204))
  call loop_AV_Q(G2(:,:,:,248),wf(:,-4),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,57),ZERO,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-6),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,121),ZERO,G4(:,:,:,119))
  call loop_AV_Q(G4(:,:,:,119),wf(:,47),G4(:,:,:,120))
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,127),ZERO,G5tensor(:,82))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,50),G4(:,:,:,121),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,121),Q(:,127),ZERO,G5tensor(:,83))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,50),G4(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,84))
  call loop_AZ_Q(G1(:,:,:,24),wf(:,53),G1(:,:,:,31),gZu)
  call loop_A_Q(G1(:,:,:,31),Q(:,41),ZERO,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,12),G2(:,:,:,252))
  call loop_A_Q(G2(:,:,:,252),Q(:,121),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,47),G3(:,:,:,304))
  call check_last_A_Q(l_switch,G3(:,:,:,304),Q(:,127),ZERO,G4tensor(:,205))
  call loop_AZ_Q(G3(:,:,:,303),wf(:,50),G3(:,:,:,305),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,305),Q(:,127),ZERO,G4tensor(:,206))
  call loop_AV_Q(G2(:,:,:,251),wf(:,-4),G2(:,:,:,253))
  call loop_A_Q(G2(:,:,:,253),Q(:,57),ZERO,G3(:,:,:,306))
  call loop_AV_Q(G3(:,:,:,306),wf(:,-6),G3(:,:,:,307))
  call loop_A_Q(G3(:,:,:,307),Q(:,121),ZERO,G4(:,:,:,123))
  call loop_AV_Q(G4(:,:,:,123),wf(:,47),G4(:,:,:,124))
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,127),ZERO,G5tensor(:,85))
  call loop_AZ_Q(G4(:,:,:,123),wf(:,50),G4(:,:,:,125),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,125),Q(:,127),ZERO,G5tensor(:,86))
  call loop_AZ_Q(G1(:,:,:,24),wf(:,53),G1(:,:,:,32),gZd)
  call loop_A_Q(G1(:,:,:,32),Q(:,41),ZERO,G2(:,:,:,254))
  call loop_AV_Q(G2(:,:,:,254),wf(:,12),G2(:,:,:,255))
  call loop_A_Q(G2(:,:,:,255),Q(:,121),ZERO,G3(:,:,:,308))
  call loop_AV_Q(G3(:,:,:,308),wf(:,47),G3(:,:,:,309))
  call check_last_A_Q(l_switch,G3(:,:,:,309),Q(:,127),ZERO,G4tensor(:,207))
  call loop_AZ_Q(G3(:,:,:,308),wf(:,50),G3(:,:,:,310),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,310),Q(:,127),ZERO,G4tensor(:,208))
  call loop_AV_Q(G2(:,:,:,254),wf(:,-4),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,57),ZERO,G3(:,:,:,311))
  call loop_AV_Q(G3(:,:,:,311),wf(:,-6),G3(:,:,:,312))
  call loop_A_Q(G3(:,:,:,312),Q(:,121),ZERO,G4(:,:,:,126))
  call loop_AV_Q(G4(:,:,:,126),wf(:,47),G4(:,:,:,127))
  call check_last_A_Q(l_switch,G4(:,:,:,127),Q(:,127),ZERO,G5tensor(:,87))
  call loop_AZ_Q(G4(:,:,:,126),wf(:,50),G4(:,:,:,128),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),ZERO,G5tensor(:,88))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(25)) * den(97)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(25) * den(97)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,1),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(25)) * den(97)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(25) * den(97)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(12) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,85),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(12)) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,85),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(12) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,147),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(12)) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,147),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(8) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,85),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(8)) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,85),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(7) * den(202)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,43),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(7)) * den(202)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,43),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(8) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,147),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(8)) * den(202)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,147),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(7) * den(202)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,1),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(7)) * den(202)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,1),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(14)) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,88),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(14) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,88),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(14)) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,150),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(14) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,150),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,90),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(11)) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,90),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(9) * den(203)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,45),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(9)) * den(203)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,45),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(11) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,152),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(11)) * den(203)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,152),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(9) * den(203)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,3),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(9)) * den(203)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,3),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(14)) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,86),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(14) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,86),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(14)) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,148),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(14) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,148),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,87),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(11)) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,87),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(9) * den(204)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,44),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(9)) * den(204)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,44),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(11) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,149),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(11)) * den(204)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,149),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(9) * den(204)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,2),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(9)) * den(204)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,2),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(15) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,89),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(15)) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,89),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(15) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,151),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(15)) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,151),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(15) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,91),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(15)) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,91),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(13) * den(205)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,46),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(13)) * den(205)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,46),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(15) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,153),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(15)) * den(205)) * TI2_call(4,momenta_21,masses2_6,G4tensor(:,153),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(13) * den(205)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,4),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(13)) * den(205)) * TI2_call(4,momenta_21,masses2_4,G4tensor(:,4),T4sum(1:70,12))
  M(1) = M(1) + (-f(26) * den(95)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,47),T4sum(1:70,29))
  M(2) = M(2) + (-f(26) * den(95)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,5),T4sum(1:70,29))
  M(1) = M(1) + (f(21) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,40),T5sum(1:126,16))
  M(2) = M(2) + (f(21) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,68),T5sum(1:126,16))
  M(1) = M(1) + (f(17) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,40),T5sum(1:126,16))
  M(1) = M(1) + (f(16) * den(4)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,21),T5sum(1:126,18))
  M(2) = M(2) + (f(17) * den(4)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,68),T5sum(1:126,16))
  M(2) = M(2) + (f(16) * den(4)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,5),T5sum(1:126,18))
  M(1) = M(1) + (-f(23) * den(7)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,43),T5sum(1:126,16))
  M(2) = M(2) + (-f(23) * den(7)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,71),T5sum(1:126,16))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,45),T5sum(1:126,16))
  M(1) = M(1) + (f(18) * den(7)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,23),T5sum(1:126,18))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,73),T5sum(1:126,16))
  M(2) = M(2) + (f(18) * den(7)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,7),T5sum(1:126,18))
  M(1) = M(1) + (-f(23) * den(10)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,41),T5sum(1:126,16))
  M(2) = M(2) + (-f(23) * den(10)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,69),T5sum(1:126,16))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,42),T5sum(1:126,16))
  M(1) = M(1) + (f(18) * den(10)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,22),T5sum(1:126,18))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,70),T5sum(1:126,16))
  M(2) = M(2) + (f(18) * den(10)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,6),T5sum(1:126,18))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,44),T5sum(1:126,16))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,72),T5sum(1:126,16))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,46),T5sum(1:126,16))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,24),T5sum(1:126,18))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_48,masses2_9,G5tensor(:,74),T5sum(1:126,16))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_48,masses2_7,G5tensor(:,8),T5sum(1:126,18))
  M(2) = M(2) + (f(21) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,61),T5sum(1:126,28))
  M(1) = M(1) + (f(21) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,33),T5sum(1:126,28))
  M(2) = M(2) + (f(17) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,61),T5sum(1:126,28))
  M(2) = M(2) + (f(16) * den(4)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,1),T5sum(1:126,30))
  M(1) = M(1) + (f(17) * den(4)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,33),T5sum(1:126,28))
  M(1) = M(1) + (f(16) * den(4)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,17),T5sum(1:126,30))
  M(2) = M(2) + (-f(23) * den(7)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,64),T5sum(1:126,28))
  M(1) = M(1) + (-f(23) * den(7)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,36),T5sum(1:126,28))
  M(2) = M(2) + (f(20) * den(7)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,66),T5sum(1:126,28))
  M(2) = M(2) + (f(18) * den(7)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,3),T5sum(1:126,30))
  M(1) = M(1) + (f(20) * den(7)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,38),T5sum(1:126,28))
  M(1) = M(1) + (f(18) * den(7)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,19),T5sum(1:126,30))
  M(2) = M(2) + (-f(23) * den(10)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,62),T5sum(1:126,28))
  M(1) = M(1) + (-f(23) * den(10)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,34),T5sum(1:126,28))
  M(2) = M(2) + (f(20) * den(10)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,63),T5sum(1:126,28))
  M(2) = M(2) + (f(18) * den(10)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,2),T5sum(1:126,30))
  M(1) = M(1) + (f(20) * den(10)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,35),T5sum(1:126,28))
  M(1) = M(1) + (f(18) * den(10)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,18),T5sum(1:126,30))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,65),T5sum(1:126,28))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,37),T5sum(1:126,28))
  M(2) = M(2) + (f(24) * den(12)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,67),T5sum(1:126,28))
  M(2) = M(2) + (f(22) * den(12)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,4),T5sum(1:126,30))
  M(1) = M(1) + (f(24) * den(12)) * TI2_call(5,momenta_46,masses2_9,G5tensor(:,39),T5sum(1:126,28))
  M(1) = M(1) + (f(22) * den(12)) * TI2_call(5,momenta_46,masses2_7,G5tensor(:,20),T5sum(1:126,30))
  M(1) = M(1) + (-(CI*f(14)) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,69),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(218)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(218)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(218)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,117),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(218)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(218)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,2),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,70),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,70),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,118),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,118),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,71),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,71),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(219)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(219)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,37),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,119),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(219)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,119),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(219)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(219)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,3),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(14)) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,72),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(220)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(220)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,38),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(220)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,120),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(220)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(220)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,4),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,73),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,73),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,121),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,121),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,74),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,74),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(221)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(221)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,39),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,122),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(221)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,122),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(221)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(221)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,5),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(14)) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,75),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(222)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(222)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,40),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(222)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,123),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(222)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(222)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,6),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,76),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,76),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,124),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,124),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,77),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,77),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(223)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(223)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,41),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,125),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(223)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,125),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(223)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(223)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(14)) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,126),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,126),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,78),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(224)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(224)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,42),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,126),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(224)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,126),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(224)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(224)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,79),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,79),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,127),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,127),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,80),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,80),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(225)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(225)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,43),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,128),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(225)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,128),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(225)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(225)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,4))
  M(1) = M(1) + (-f(23) * den(165)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,92),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(165)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,154),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(165)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,92),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(165)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,48),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(165)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,154),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(165)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,6),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(167)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,93),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(167)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,155),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(167)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,94),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(167)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,49),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(167)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,156),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(167)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,7),T4sum(1:70,29))
  M(1) = M(1) + (-f(23) * den(168)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,95),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(168)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,157),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(168)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,95),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(168)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,50),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(168)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,157),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(168)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,8),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(169)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,96),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(169)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,158),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(169)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,97),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(169)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,51),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(169)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,159),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(169)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,9),T4sum(1:70,29))
  M(1) = M(1) + (-f(23) * den(170)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,98),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(170)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,160),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(170)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,98),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(170)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,52),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(170)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,160),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(170)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,10),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(171)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,99),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(171)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,161),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(171)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,100),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(171)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,53),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(171)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,162),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(171)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,11),T4sum(1:70,29))
  M(1) = M(1) + (-f(23) * den(172)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,101),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(172)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,163),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(172)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,101),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(172)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,54),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(172)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,163),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(172)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,12),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(173)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,102),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(173)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,164),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(173)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,103),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(173)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,55),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(173)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,165),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(173)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,13),T4sum(1:70,29))
  M(1) = M(1) + (CI*f(25) * den(119)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(25)) * den(119)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(25) * den(119)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(25)) * den(119)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,44),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(12)) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,202),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(12) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,202),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(12)) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,140),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(12) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,140),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(8)) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,202),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(8) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,202),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(7)) * den(238)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,39),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(7) * den(238)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,39),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(8)) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,140),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(8) * den(238)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,140),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(7)) * den(238)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,81),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(7) * den(238)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,81),T4sum(1:70,48))
  M(1) = M(1) + (CI*f(14) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,203),T4sum(1:70,46))
  M(2) = M(2) + (-(CI*f(14)) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,203),T4sum(1:70,46))
  M(1) = M(1) + (CI*f(14) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,141),T4sum(1:70,46))
  M(2) = M(2) + (-(CI*f(14)) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,141),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,204),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(11) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,204),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(9)) * den(239)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,40),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(9) * den(239)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,40),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(11)) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,142),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(11) * den(239)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,142),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(9)) * den(239)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,82),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(9) * den(239)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,82),T4sum(1:70,48))
  M(1) = M(1) + (CI*f(14) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,205),T4sum(1:70,46))
  M(2) = M(2) + (-(CI*f(14)) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,205),T4sum(1:70,46))
  M(1) = M(1) + (CI*f(14) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,143),T4sum(1:70,46))
  M(2) = M(2) + (-(CI*f(14)) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,143),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,207),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(11) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,207),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(9)) * den(240)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,41),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(9) * den(240)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,41),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(11)) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,145),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(11) * den(240)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,145),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(9)) * den(240)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,83),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(9) * den(240)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,83),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,206),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,206),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,144),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,144),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,208),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,208),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,42),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,42),T4sum(1:70,48))
  M(1) = M(1) + (-(CI*f(15)) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,146),T4sum(1:70,46))
  M(2) = M(2) + (CI*f(15) * den(241)) * TI2_call(4,momenta_20,masses2_6,G4tensor(:,146),T4sum(1:70,46))
  M(1) = M(1) + (-(CI*f(13)) * den(241)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,84),T4sum(1:70,48))
  M(2) = M(2) + (CI*f(13) * den(241)) * TI2_call(4,momenta_20,masses2_4,G4tensor(:,84),T4sum(1:70,48))
  M(1) = M(1) + (f(26) * den(117)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,56),T4sum(1:70,29))
  M(2) = M(2) + (f(26) * den(117)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,14),T4sum(1:70,29))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,47),T5sum(1:126,46))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,75),T5sum(1:126,46))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,47),T5sum(1:126,46))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,25),T5sum(1:126,48))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,75),T5sum(1:126,46))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,9),T5sum(1:126,48))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,48),T5sum(1:126,46))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,76),T5sum(1:126,46))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,49),T5sum(1:126,46))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,26),T5sum(1:126,48))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,77),T5sum(1:126,46))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,10),T5sum(1:126,48))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,50),T5sum(1:126,46))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,78),T5sum(1:126,46))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,52),T5sum(1:126,46))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,27),T5sum(1:126,48))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,80),T5sum(1:126,46))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,11),T5sum(1:126,48))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,51),T5sum(1:126,46))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,79),T5sum(1:126,46))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,53),T5sum(1:126,46))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,28),T5sum(1:126,48))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_47,masses2_9,G5tensor(:,81),T5sum(1:126,46))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_47,masses2_7,G5tensor(:,12),T5sum(1:126,48))
  M(2) = M(2) + (-f(21) * den(42)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,82),T5sum(1:126,58))
  M(1) = M(1) + (-f(21) * den(42)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,54),T5sum(1:126,58))
  M(2) = M(2) + (-f(17) * den(42)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,82),T5sum(1:126,58))
  M(2) = M(2) + (-f(16) * den(42)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,13),T5sum(1:126,60))
  M(1) = M(1) + (-f(17) * den(42)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,54),T5sum(1:126,58))
  M(1) = M(1) + (-f(16) * den(42)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,29),T5sum(1:126,60))
  M(2) = M(2) + (f(23) * den(45)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,83),T5sum(1:126,58))
  M(1) = M(1) + (f(23) * den(45)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,55),T5sum(1:126,58))
  M(2) = M(2) + (-f(20) * den(45)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,84),T5sum(1:126,58))
  M(2) = M(2) + (-f(18) * den(45)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,14),T5sum(1:126,60))
  M(1) = M(1) + (-f(20) * den(45)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,56),T5sum(1:126,58))
  M(1) = M(1) + (-f(18) * den(45)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,30),T5sum(1:126,60))
  M(2) = M(2) + (f(23) * den(48)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,85),T5sum(1:126,58))
  M(1) = M(1) + (f(23) * den(48)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,57),T5sum(1:126,58))
  M(2) = M(2) + (-f(20) * den(48)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,87),T5sum(1:126,58))
  M(2) = M(2) + (-f(18) * den(48)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,15),T5sum(1:126,60))
  M(1) = M(1) + (-f(20) * den(48)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,59),T5sum(1:126,58))
  M(1) = M(1) + (-f(18) * den(48)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,31),T5sum(1:126,60))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,86),T5sum(1:126,58))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,58),T5sum(1:126,58))
  M(2) = M(2) + (-f(24) * den(50)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,88),T5sum(1:126,58))
  M(2) = M(2) + (-f(22) * den(50)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,16),T5sum(1:126,60))
  M(1) = M(1) + (-f(24) * den(50)) * TI2_call(5,momenta_45,masses2_9,G5tensor(:,60),T5sum(1:126,58))
  M(1) = M(1) + (-f(22) * den(50)) * TI2_call(5,momenta_45,masses2_7,G5tensor(:,32),T5sum(1:126,60))
  M(1) = M(1) + (CI*f(14) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,129),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,129),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,81),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(254)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(254)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,45),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,129),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(254)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,129),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(254)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(254)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,82),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,82),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,130),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,130),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,83),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,83),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,46),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,131),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(255)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,131),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(255)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,132),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,132),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,84),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(256)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(256)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,47),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,132),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(256)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,132),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(256)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(256)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,13),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,85),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,85),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,133),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,133),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,86),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,86),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,48),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,134),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(257)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,134),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(257)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,14),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,135),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,135),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,87),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(258)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(258)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,49),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,135),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(258)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,135),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(258)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(258)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,136),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,136),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,88),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,50),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,136),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(259)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,136),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(259)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,89),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,89),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,137),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,137),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,90),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,90),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(260)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(260)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,51),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,138),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(260)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,138),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(260)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(260)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,17),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,91),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,91),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,139),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,139),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,92),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,92),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(261)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(261)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,52),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,140),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(261)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,140),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(261)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(261)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,18),T3sum(1:35,4))
  M(1) = M(1) + (f(23) * den(174)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,104),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(174)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,166),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(174)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,104),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(174)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,57),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(174)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,166),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(174)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,15),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(175)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,105),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(175)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,167),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(175)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,106),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(175)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,58),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(175)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,168),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(175)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,16),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(176)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,107),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(176)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,169),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(176)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,107),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(176)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,59),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(176)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,169),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(176)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,17),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(177)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,108),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(177)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,170),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(177)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,109),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(177)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,60),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(177)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,171),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(177)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,18),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(178)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,110),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(178)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,172),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(178)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,110),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(178)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,61),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(178)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,172),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(178)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,19),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(179)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,111),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(179)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,173),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(179)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,111),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(179)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,62),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(179)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,173),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(179)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,20),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(180)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,112),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(180)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,174),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(180)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,113),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(180)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,63),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(180)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,175),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(180)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,21),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(181)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,114),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(181)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,176),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(181)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,115),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(181)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,64),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(181)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,177),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(181)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,22),T4sum(1:70,29))
  M(1) = M(1) + (CI*f(14) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,141),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,141),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,93),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(278)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(278)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,53),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,141),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(278)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,141),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(278)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(278)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,19),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,94),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,94),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,142),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,142),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,95),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,95),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,54),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,143),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(279)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,143),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(279)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,20),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,144),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,144),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,96),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(280)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(280)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,55),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,144),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(280)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,144),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(280)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(280)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,21),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,97),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,97),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,145),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,145),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,98),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,98),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,56),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,146),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(281)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,146),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(281)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,22),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,147),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,147),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,99),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(282)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(282)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,57),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,147),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(282)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,147),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(282)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(282)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,23),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,100),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,100),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,148),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,148),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,101),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,101),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,58),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,149),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(283)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,149),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(283)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,24),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(14) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,150),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(14)) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,150),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(11)) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,102),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(284)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(284)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,59),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(11)) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,150),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(11) * den(284)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,150),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(284)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(9) * den(284)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,103),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,103),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,151),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,151),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(15)) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,104),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,104),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(285)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(285)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,60),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(15)) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,152),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(15) * den(285)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,152),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(13)) * den(285)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(13) * den(285)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,4))
  M(1) = M(1) + (f(23) * den(182)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,116),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(182)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,178),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(182)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,116),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(182)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,65),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(182)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,178),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(182)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,23),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(183)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,117),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(183)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,179),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(183)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,118),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(183)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,66),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(183)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,180),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(183)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,24),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(184)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,119),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(184)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,181),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(184)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,119),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(184)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,67),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(184)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,181),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(184)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,25),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(185)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,120),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(185)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,182),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(185)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,121),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(185)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,68),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(185)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,183),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(185)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,26),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(186)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,122),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(186)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,184),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(186)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,122),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(186)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,69),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(186)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,184),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(186)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,27),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(187)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,123),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(187)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,185),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(187)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,124),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(187)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,70),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(187)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,186),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(187)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,28),T4sum(1:70,29))
  M(1) = M(1) + (f(23) * den(188)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,125),T4sum(1:70,34))
  M(2) = M(2) + (f(23) * den(188)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,187),T4sum(1:70,34))
  M(1) = M(1) + (-f(20) * den(188)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,125),T4sum(1:70,34))
  M(1) = M(1) + (-f(18) * den(188)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,71),T4sum(1:70,29))
  M(2) = M(2) + (-f(20) * den(188)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,187),T4sum(1:70,34))
  M(2) = M(2) + (-f(18) * den(188)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,29),T4sum(1:70,29))
  M(1) = M(1) + (-f(24) * den(189)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,126),T4sum(1:70,34))
  M(2) = M(2) + (-f(24) * den(189)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,188),T4sum(1:70,34))
  M(1) = M(1) + (-f(24) * den(189)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,127),T4sum(1:70,34))
  M(1) = M(1) + (-f(22) * den(189)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,72),T4sum(1:70,29))
  M(2) = M(2) + (-f(24) * den(189)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,189),T4sum(1:70,34))
  M(2) = M(2) + (-f(22) * den(189)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,30),T4sum(1:70,29))
  M(1) = M(1) + (-(CI*f(14)) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,153),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,153),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,105),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(302)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(302)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,61),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,153),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(302)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,153),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(302)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(302)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,106),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,106),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,154),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,154),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,107),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(303)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(303)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,62),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,155),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(303)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,155),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(303)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(303)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(14)) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,156),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,156),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,108),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(304)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(304)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,63),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,156),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(304)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,156),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(304)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(304)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,109),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,109),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,157),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,157),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,110),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,110),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(305)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(305)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,64),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,158),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(305)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,158),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(305)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(305)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(14)) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,159),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,159),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,111),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(306)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(306)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,65),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,159),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(306)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,159),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(306)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(306)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,31),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(14)) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(14)) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,160),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(14) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,160),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(11) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,112),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(307)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(307)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,66),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(11) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,160),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(11)) * den(307)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,160),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(307)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(9)) * den(307)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,32),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,113),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,161),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,161),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,114),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(308)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(308)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,67),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,162),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(308)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,162),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(308)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(308)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,33),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,115),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,163),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,163),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(15) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,116),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(309)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(309)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,68),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(15) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,164),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(309)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,164),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(13) * den(309)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(13)) * den(309)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,34),T3sum(1:35,4))
  M(1) = M(1) + (-f(23) * den(190)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,128),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(190)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,190),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(190)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,128),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(190)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,73),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(190)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,190),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(190)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,31),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(191)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,129),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(191)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,191),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(191)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,130),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(191)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,74),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(191)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,192),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(191)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,32),T4sum(1:70,29))
  M(1) = M(1) + (-f(23) * den(192)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,131),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(192)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,193),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(192)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,131),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(192)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,75),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(192)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,193),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(192)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,33),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(193)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,132),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(193)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,194),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(193)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,133),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(193)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,76),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(193)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,195),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(193)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,34),T4sum(1:70,29))
  M(1) = M(1) + (-f(23) * den(194)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,134),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(194)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,196),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(194)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,134),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(194)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,77),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(194)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,196),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(194)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,35),T4sum(1:70,29))
  M(1) = M(1) + (-f(23) * den(195)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,135),T4sum(1:70,34))
  M(2) = M(2) + (-f(23) * den(195)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,197),T4sum(1:70,34))
  M(1) = M(1) + (f(20) * den(195)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,135),T4sum(1:70,34))
  M(1) = M(1) + (f(18) * den(195)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,78),T4sum(1:70,29))
  M(2) = M(2) + (f(20) * den(195)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,197),T4sum(1:70,34))
  M(2) = M(2) + (f(18) * den(195)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,36),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(196)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,136),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(196)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,198),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(196)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,137),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(196)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,79),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(196)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,199),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(196)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,37),T4sum(1:70,29))
  M(1) = M(1) + (f(24) * den(197)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,138),T4sum(1:70,34))
  M(2) = M(2) + (f(24) * den(197)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,200),T4sum(1:70,34))
  M(1) = M(1) + (f(24) * den(197)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,139),T4sum(1:70,34))
  M(1) = M(1) + (f(22) * den(197)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,80),T4sum(1:70,29))
  M(2) = M(2) + (f(24) * den(197)) * TI2_call(4,momenta_22,masses2_6,G4tensor(:,201),T4sum(1:70,34))
  M(2) = M(2) + (f(22) * den(197)) * TI2_call(4,momenta_22,masses2_4,G4tensor(:,38),T4sum(1:70,29))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_3_ppllllj2_eeexexggg_1_/**/REALKIND
