
module ol_vamp_2_ppllllj2_nmnmxeexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nmnmxeexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nmnmxeexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nmnmxeexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nmnmxeexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,8) :: G0
  complex(REALKIND), dimension(4,5,4,44) :: G1
  complex(REALKIND), dimension(4,15,4,187) :: G2
  complex(REALKIND), dimension(4,35,4,280) :: G3
  complex(REALKIND), dimension(4,70,4,134) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,58,128))
    allocate(G4tensorhel(70,126,128))
    allocate(G5tensorhel(126,72,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,32),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,44),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,9),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,124),ZERO,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),ZERO,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,127),ZERO,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-4),G2(:,:,:,3))
  call loop_A_Q(G2(:,:,:,3),Q(:,60),ZERO,G3(:,:,:,4))
  call loop_AV_Q(G3(:,:,:,4),wf(:,-6),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,124),ZERO,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),ZERO,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,127),ZERO,G5tensor(:,2))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,7),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,44),ZERO,G2(:,:,:,4))
  call loop_AV_Q(G2(:,:,:,4),wf(:,9),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,124),ZERO,G3(:,:,:,6))
  call loop_AZ_Q(G3(:,:,:,6),wf(:,4),G3(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,7),Q(:,127),ZERO,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,4),wf(:,-4),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,60),ZERO,G3(:,:,:,8))
  call loop_AV_Q(G3(:,:,:,8),wf(:,-6),G3(:,:,:,9))
  call loop_A_Q(G3(:,:,:,9),Q(:,124),ZERO,G4(:,:,:,4))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,4),G4(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,127),ZERO,G5tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,7),G1(:,:,:,4),gZd)
  call loop_A_Q(G1(:,:,:,4),Q(:,44),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,9),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,124),ZERO,G3(:,:,:,10))
  call loop_AZ_Q(G3(:,:,:,10),wf(:,4),G3(:,:,:,11),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,127),ZERO,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-4),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,60),ZERO,G3(:,:,:,12))
  call loop_AV_Q(G3(:,:,:,12),wf(:,-6),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,124),ZERO,G4(:,:,:,6))
  call loop_AZ_Q(G4(:,:,:,6),wf(:,4),G4(:,:,:,7),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,7),Q(:,127),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,48),ZERO,G2(:,:,:,10))
  call loop_AV_Q(G2(:,:,:,10),wf(:,2),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,60),ZERO,G3(:,:,:,14))
  call loop_AV_Q(G3(:,:,:,14),wf(:,-6),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,124),ZERO,G4(:,:,:,8))
  call loop_AZ_Q(G4(:,:,:,8),wf(:,4),G4(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,127),ZERO,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,8),wf(:,4),G4(:,:,:,10),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),ZERO,G5tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,10),wf(:,7),G2(:,:,:,12),gZu)
  call loop_A_Q(G2(:,:,:,12),Q(:,60),ZERO,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,-6),G3(:,:,:,17))
  call loop_A_Q(G3(:,:,:,17),Q(:,124),ZERO,G4(:,:,:,11))
  call loop_AZ_Q(G4(:,:,:,11),wf(:,4),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),ZERO,G5tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,10),wf(:,7),G2(:,:,:,13),gZd)
  call loop_A_Q(G2(:,:,:,13),Q(:,60),ZERO,G3(:,:,:,18))
  call loop_AV_Q(G3(:,:,:,18),wf(:,-6),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,124),ZERO,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,4),G4(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),ZERO,G5tensor(:,8))
  call loop_AV_Q(G2(:,:,:,10),wf(:,-6),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,112),ZERO,G3(:,:,:,20))
  call loop_AV_Q(G3(:,:,:,20),wf(:,61),G3(:,:,:,21))
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,127),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,62),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,127),ZERO,G4tensor(:,6))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,62),G3(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),ZERO,G4tensor(:,7))
  call loop_AV_Q(G3(:,:,:,20),wf(:,63),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),ZERO,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,64),G3(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),ZERO,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,64),G3(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),ZERO,G4tensor(:,10))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,65),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),ZERO,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,65),G3(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),ZERO,G4tensor(:,12))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,66),G3(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),ZERO,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,66),G3(:,:,:,30),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),ZERO,G4tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,9),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,112),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,61),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,127),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,62),G2(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,17),Q(:,127),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,62),G2(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,127),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,15),wf(:,63),G2(:,:,:,19))
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,127),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,64),G2(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,127),ZERO,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,64),G2(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,127),ZERO,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,65),G2(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,127),ZERO,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,65),G2(:,:,:,23),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,127),ZERO,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,66),G2(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,127),ZERO,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,66),G2(:,:,:,25),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,127),ZERO,G3tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,12),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,112),MT,G2(:,:,:,26))
  call loop_AS_Q(G2(:,:,:,26),wf(:,45),G2(:,:,:,27),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,127),MT,G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,26),wf(:,61),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,127),MT,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,62),G2(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,13))
  call loop_AV_Q(G2(:,:,:,26),wf(:,63),G2(:,:,:,30))
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,64),G2(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,65),G2(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,26),wf(:,66),G2(:,:,:,33),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,7),wf(:,2),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,28),MT,G2(:,:,:,34))
  call loop_AV_Q(G2(:,:,:,34),wf(:,12),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,124),MT,G3(:,:,:,31))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,4),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),MT,G4tensor(:,15))
  call loop_AV_Q(G2(:,:,:,34),wf(:,-6),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,92),MT,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,-5),G3(:,:,:,34))
  call loop_A_Q(G3(:,:,:,34),Q(:,124),MT,G4(:,:,:,15))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,4),G4(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),MT,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,34),wf(:,-5),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,60),MT,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,-6),G3(:,:,:,36))
  call loop_A_Q(G3(:,:,:,36),Q(:,124),MT,G4(:,:,:,17))
  call loop_AZ_Q(G4(:,:,:,17),wf(:,4),G4(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,127),MT,G5tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,7),G1(:,:,:,10),gZu)
  call loop_A_Q(G1(:,:,:,10),Q(:,28),MT,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,12),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,124),MT,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,4),G3(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MT,G4tensor(:,16))
  call loop_AV_Q(G2(:,:,:,38),wf(:,-6),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,92),MT,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-5),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,124),MT,G4(:,:,:,19))
  call loop_AZ_Q(G4(:,:,:,19),wf(:,4),G4(:,:,:,20),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,38),wf(:,-5),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,60),MT,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,-6),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,124),MT,G4(:,:,:,21))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,4),G4(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,127),MT,G5tensor(:,12))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-5),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,48),MT,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-6),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,112),MT,G3(:,:,:,43))
  call loop_AS_Q(G3(:,:,:,43),wf(:,45),G3(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,127),MT,G4tensor(:,17))
  call loop_AV_Q(G3(:,:,:,43),wf(:,61),G3(:,:,:,45))
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,127),MT,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,62),G3(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,127),MT,G4tensor(:,19))
  call loop_AV_Q(G3(:,:,:,43),wf(:,63),G3(:,:,:,47))
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,127),MT,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,64),G3(:,:,:,48),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,127),MT,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,65),G3(:,:,:,49),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,127),MT,G4tensor(:,22))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,66),G3(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,127),MT,G4tensor(:,23))
  call loop_AV_Q(G2(:,:,:,42),wf(:,2),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,60),MT,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,-6),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,124),MT,G4(:,:,:,23))
  call loop_AZ_Q(G4(:,:,:,23),wf(:,4),G4(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,42),wf(:,7),G2(:,:,:,45),gZu)
  call loop_A_Q(G2(:,:,:,45),Q(:,60),MT,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-6),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,124),MT,G4(:,:,:,25))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,4),G4(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,127),MT,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-6),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,80),MT,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,-5),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,112),MT,G3(:,:,:,55))
  call loop_AS_Q(G3(:,:,:,55),wf(:,45),G3(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,127),MT,G4tensor(:,24))
  call loop_AV_Q(G3(:,:,:,55),wf(:,61),G3(:,:,:,57))
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,127),MT,G4tensor(:,25))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,62),G3(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,26))
  call loop_AV_Q(G3(:,:,:,55),wf(:,63),G3(:,:,:,59))
  call check_last_A_Q(l_switch,G3(:,:,:,59),Q(:,127),MT,G4tensor(:,27))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,64),G3(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,127),MT,G4tensor(:,28))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,65),G3(:,:,:,61),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,61),Q(:,127),MT,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,55),wf(:,66),G3(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,127),MT,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,46),wf(:,2),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,92),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-5),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,124),MT,G4(:,:,:,27))
  call loop_AZ_Q(G4(:,:,:,27),wf(:,4),G4(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,127),MT,G5tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,46),wf(:,7),G2(:,:,:,49),gZu)
  call loop_A_Q(G2(:,:,:,49),Q(:,92),MT,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-5),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,124),MT,G4(:,:,:,29))
  call loop_AZ_Q(G4(:,:,:,29),wf(:,4),G4(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,127),MT,G5tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,16),MT,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,12),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,112),MT,G2(:,:,:,50))
  call loop_QS_A(G2(:,:,:,50),wf(:,45),G2(:,:,:,51),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,127),MT,G3tensor(:,18))
  call loop_QV_A(G2(:,:,:,50),wf(:,61),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,127),MT,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,50),wf(:,62),G2(:,:,:,53),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,53),Q(:,127),MT,G3tensor(:,20))
  call loop_QV_A(G2(:,:,:,50),wf(:,63),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,127),MT,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,50),wf(:,64),G2(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,55),Q(:,127),MT,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,50),wf(:,65),G2(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,127),MT,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,50),wf(:,66),G2(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,57),Q(:,127),MT,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,13),wf(:,2),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,28),MT,G2(:,:,:,58))
  call loop_QV_A(G2(:,:,:,58),wf(:,12),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,124),MT,G3(:,:,:,67))
  call loop_QZ_A(G3(:,:,:,67),wf(:,4),G3(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,127),MT,G4tensor(:,31))
  call loop_QV_A(G2(:,:,:,58),wf(:,-6),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,92),MT,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-5),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,124),MT,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,4),G4(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),MT,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,58),wf(:,-5),G2(:,:,:,61))
  call loop_Q_A(G2(:,:,:,61),Q(:,60),MT,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-6),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,124),MT,G4(:,:,:,33))
  call loop_QZ_A(G4(:,:,:,33),wf(:,4),G4(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,127),MT,G5tensor(:,18))
  call loop_QZ_A(G1(:,:,:,13),wf(:,7),G1(:,:,:,16),gZu)
  call loop_Q_A(G1(:,:,:,16),Q(:,28),MT,G2(:,:,:,62))
  call loop_QV_A(G2(:,:,:,62),wf(:,12),G2(:,:,:,63))
  call loop_Q_A(G2(:,:,:,63),Q(:,124),MT,G3(:,:,:,73))
  call loop_QZ_A(G3(:,:,:,73),wf(:,4),G3(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,127),MT,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,62),wf(:,-6),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,92),MT,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,-5),G3(:,:,:,76))
  call loop_Q_A(G3(:,:,:,76),Q(:,124),MT,G4(:,:,:,35))
  call loop_QZ_A(G4(:,:,:,35),wf(:,4),G4(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,127),MT,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,62),wf(:,-5),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,60),MT,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-6),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,124),MT,G4(:,:,:,37))
  call loop_QZ_A(G4(:,:,:,37),wf(:,4),G4(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,127),MT,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,48),MT,G2(:,:,:,66))
  call loop_QV_A(G2(:,:,:,66),wf(:,-6),G2(:,:,:,67))
  call loop_Q_A(G2(:,:,:,67),Q(:,112),MT,G3(:,:,:,79))
  call loop_QS_A(G3(:,:,:,79),wf(:,45),G3(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),MT,G4tensor(:,33))
  call loop_QV_A(G3(:,:,:,79),wf(:,61),G3(:,:,:,81))
  call check_last_Q_A(l_switch,G3(:,:,:,81),Q(:,127),MT,G4tensor(:,34))
  call loop_QZ_A(G3(:,:,:,79),wf(:,62),G3(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,127),MT,G4tensor(:,35))
  call loop_QV_A(G3(:,:,:,79),wf(:,63),G3(:,:,:,83))
  call check_last_Q_A(l_switch,G3(:,:,:,83),Q(:,127),MT,G4tensor(:,36))
  call loop_QZ_A(G3(:,:,:,79),wf(:,64),G3(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,127),MT,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,79),wf(:,65),G3(:,:,:,85),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,127),MT,G4tensor(:,38))
  call loop_QZ_A(G3(:,:,:,79),wf(:,66),G3(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,127),MT,G4tensor(:,39))
  call loop_QV_A(G2(:,:,:,66),wf(:,2),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,60),MT,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-6),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,124),MT,G4(:,:,:,39))
  call loop_QZ_A(G4(:,:,:,39),wf(:,4),G4(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,127),MT,G5tensor(:,21))
  call loop_QZ_A(G2(:,:,:,66),wf(:,7),G2(:,:,:,69),gZu)
  call loop_Q_A(G2(:,:,:,69),Q(:,60),MT,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-6),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,124),MT,G4(:,:,:,41))
  call loop_QZ_A(G4(:,:,:,41),wf(:,4),G4(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,127),MT,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,13),wf(:,-6),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,80),MT,G2(:,:,:,70))
  call loop_QV_A(G2(:,:,:,70),wf(:,-5),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,112),MT,G3(:,:,:,91))
  call loop_QS_A(G3(:,:,:,91),wf(:,45),G3(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,127),MT,G4tensor(:,40))
  call loop_QV_A(G3(:,:,:,91),wf(:,61),G3(:,:,:,93))
  call check_last_Q_A(l_switch,G3(:,:,:,93),Q(:,127),MT,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,91),wf(:,62),G3(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,94),Q(:,127),MT,G4tensor(:,42))
  call loop_QV_A(G3(:,:,:,91),wf(:,63),G3(:,:,:,95))
  call check_last_Q_A(l_switch,G3(:,:,:,95),Q(:,127),MT,G4tensor(:,43))
  call loop_QZ_A(G3(:,:,:,91),wf(:,64),G3(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,127),MT,G4tensor(:,44))
  call loop_QZ_A(G3(:,:,:,91),wf(:,65),G3(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,127),MT,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,91),wf(:,66),G3(:,:,:,98),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,127),MT,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,70),wf(:,2),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,92),MT,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-5),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,124),MT,G4(:,:,:,43))
  call loop_QZ_A(G4(:,:,:,43),wf(:,4),G4(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,127),MT,G5tensor(:,23))
  call loop_QZ_A(G2(:,:,:,70),wf(:,7),G2(:,:,:,73),gZu)
  call loop_Q_A(G2(:,:,:,73),Q(:,92),MT,G3(:,:,:,101))
  call loop_QV_A(G3(:,:,:,101),wf(:,-5),G3(:,:,:,102))
  call loop_Q_A(G3(:,:,:,102),Q(:,124),MT,G4(:,:,:,45))
  call loop_QZ_A(G4(:,:,:,45),wf(:,4),G4(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,127),MT,G5tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,12),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,112),MB,G2(:,:,:,74))
  call loop_AS_Q(G2(:,:,:,74),wf(:,45),G2(:,:,:,75),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,127),MB,G3tensor(:,25))
  call loop_AV_Q(G2(:,:,:,74),wf(:,61),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,127),MB,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,62),G2(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,127),MB,G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,74),wf(:,63),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,127),MB,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,64),G2(:,:,:,79),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,127),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,65),G2(:,:,:,80),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,127),MB,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,66),G2(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,127),MB,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,19),wf(:,2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,28),MB,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,12),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,124),MB,G3(:,:,:,103))
  call loop_AZ_Q(G3(:,:,:,103),wf(:,4),G3(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,127),MB,G4tensor(:,47))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-6),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,92),MB,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,-5),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,124),MB,G4(:,:,:,47))
  call loop_AZ_Q(G4(:,:,:,47),wf(:,4),G4(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,127),MB,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-5),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,60),MB,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-6),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,124),MB,G4(:,:,:,49))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,4),G4(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,127),MB,G5tensor(:,26))
  call loop_AZ_Q(G1(:,:,:,19),wf(:,7),G1(:,:,:,22),gZd)
  call loop_A_Q(G1(:,:,:,22),Q(:,28),MB,G2(:,:,:,86))
  call loop_AV_Q(G2(:,:,:,86),wf(:,12),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,124),MB,G3(:,:,:,109))
  call loop_AZ_Q(G3(:,:,:,109),wf(:,4),G3(:,:,:,110),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),MB,G4tensor(:,48))
  call loop_AV_Q(G2(:,:,:,86),wf(:,-6),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,92),MB,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-5),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,124),MB,G4(:,:,:,51))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,4),G4(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,127),MB,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,86),wf(:,-5),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,60),MB,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,-6),G3(:,:,:,114))
  call loop_A_Q(G3(:,:,:,114),Q(:,124),MB,G4(:,:,:,53))
  call loop_AZ_Q(G4(:,:,:,53),wf(:,4),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,127),MB,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,48),MB,G2(:,:,:,90))
  call loop_AV_Q(G2(:,:,:,90),wf(:,-6),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,112),MB,G3(:,:,:,115))
  call loop_AS_Q(G3(:,:,:,115),wf(:,45),G3(:,:,:,116),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),MB,G4tensor(:,49))
  call loop_AV_Q(G3(:,:,:,115),wf(:,61),G3(:,:,:,117))
  call check_last_A_Q(l_switch,G3(:,:,:,117),Q(:,127),MB,G4tensor(:,50))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,62),G3(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,127),MB,G4tensor(:,51))
  call loop_AV_Q(G3(:,:,:,115),wf(:,63),G3(:,:,:,119))
  call check_last_A_Q(l_switch,G3(:,:,:,119),Q(:,127),MB,G4tensor(:,52))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,64),G3(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,127),MB,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,65),G3(:,:,:,121),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,121),Q(:,127),MB,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,66),G3(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),MB,G4tensor(:,55))
  call loop_AV_Q(G2(:,:,:,90),wf(:,2),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,60),MB,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-6),G3(:,:,:,124))
  call loop_A_Q(G3(:,:,:,124),Q(:,124),MB,G4(:,:,:,55))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,4),G4(:,:,:,56),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,127),MB,G5tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,90),wf(:,7),G2(:,:,:,93),gZd)
  call loop_A_Q(G2(:,:,:,93),Q(:,60),MB,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-6),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,124),MB,G4(:,:,:,57))
  call loop_AZ_Q(G4(:,:,:,57),wf(:,4),G4(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,127),MB,G5tensor(:,30))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-6),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,80),MB,G2(:,:,:,94))
  call loop_AV_Q(G2(:,:,:,94),wf(:,-5),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,112),MB,G3(:,:,:,127))
  call loop_AS_Q(G3(:,:,:,127),wf(:,45),G3(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,127),MB,G4tensor(:,56))
  call loop_AV_Q(G3(:,:,:,127),wf(:,61),G3(:,:,:,129))
  call check_last_A_Q(l_switch,G3(:,:,:,129),Q(:,127),MB,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,62),G3(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,127),MB,G4tensor(:,58))
  call loop_AV_Q(G3(:,:,:,127),wf(:,63),G3(:,:,:,131))
  call check_last_A_Q(l_switch,G3(:,:,:,131),Q(:,127),MB,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,64),G3(:,:,:,132),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,127),MB,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,65),G3(:,:,:,133),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,133),Q(:,127),MB,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,66),G3(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,127),MB,G4tensor(:,62))
  call loop_AV_Q(G2(:,:,:,94),wf(:,2),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,92),MB,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-5),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,124),MB,G4(:,:,:,59))
  call loop_AZ_Q(G4(:,:,:,59),wf(:,4),G4(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,127),MB,G5tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,94),wf(:,7),G2(:,:,:,97),gZd)
  call loop_A_Q(G2(:,:,:,97),Q(:,92),MB,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,-5),G3(:,:,:,138))
  call loop_A_Q(G3(:,:,:,138),Q(:,124),MB,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,4),G4(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,16),MB,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,12),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,112),MB,G2(:,:,:,98))
  call loop_QS_A(G2(:,:,:,98),wf(:,45),G2(:,:,:,99),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,127),MB,G3tensor(:,32))
  call loop_QV_A(G2(:,:,:,98),wf(:,61),G2(:,:,:,100))
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,127),MB,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,98),wf(:,62),G2(:,:,:,101),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,127),MB,G3tensor(:,34))
  call loop_QV_A(G2(:,:,:,98),wf(:,63),G2(:,:,:,102))
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,127),MB,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,98),wf(:,64),G2(:,:,:,103),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,98),wf(:,65),G2(:,:,:,104),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,127),MB,G3tensor(:,37))
  call loop_QZ_A(G2(:,:,:,98),wf(:,66),G2(:,:,:,105),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,127),MB,G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,25),wf(:,2),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,28),MB,G2(:,:,:,106))
  call loop_QV_A(G2(:,:,:,106),wf(:,12),G2(:,:,:,107))
  call loop_Q_A(G2(:,:,:,107),Q(:,124),MB,G3(:,:,:,139))
  call loop_QZ_A(G3(:,:,:,139),wf(:,4),G3(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),MB,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,106),wf(:,-6),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,92),MB,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,-5),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,124),MB,G4(:,:,:,63))
  call loop_QZ_A(G4(:,:,:,63),wf(:,4),G4(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,127),MB,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,106),wf(:,-5),G2(:,:,:,109))
  call loop_Q_A(G2(:,:,:,109),Q(:,60),MB,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-6),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,124),MB,G4(:,:,:,65))
  call loop_QZ_A(G4(:,:,:,65),wf(:,4),G4(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,127),MB,G5tensor(:,34))
  call loop_QZ_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,28),gZd)
  call loop_Q_A(G1(:,:,:,28),Q(:,28),MB,G2(:,:,:,110))
  call loop_QV_A(G2(:,:,:,110),wf(:,12),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,124),MB,G3(:,:,:,145))
  call loop_QZ_A(G3(:,:,:,145),wf(:,4),G3(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,127),MB,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,110),wf(:,-6),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,92),MB,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,-5),G3(:,:,:,148))
  call loop_Q_A(G3(:,:,:,148),Q(:,124),MB,G4(:,:,:,67))
  call loop_QZ_A(G4(:,:,:,67),wf(:,4),G4(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),MB,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,110),wf(:,-5),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,60),MB,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,-6),G3(:,:,:,150))
  call loop_Q_A(G3(:,:,:,150),Q(:,124),MB,G4(:,:,:,69))
  call loop_QZ_A(G4(:,:,:,69),wf(:,4),G4(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,127),MB,G5tensor(:,36))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,48),MB,G2(:,:,:,114))
  call loop_QV_A(G2(:,:,:,114),wf(:,-6),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,112),MB,G3(:,:,:,151))
  call loop_QS_A(G3(:,:,:,151),wf(:,45),G3(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),MB,G4tensor(:,65))
  call loop_QV_A(G3(:,:,:,151),wf(:,61),G3(:,:,:,153))
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,127),MB,G4tensor(:,66))
  call loop_QZ_A(G3(:,:,:,151),wf(:,62),G3(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,127),MB,G4tensor(:,67))
  call loop_QV_A(G3(:,:,:,151),wf(:,63),G3(:,:,:,155))
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,127),MB,G4tensor(:,68))
  call loop_QZ_A(G3(:,:,:,151),wf(:,64),G3(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,127),MB,G4tensor(:,69))
  call loop_QZ_A(G3(:,:,:,151),wf(:,65),G3(:,:,:,157),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,157),Q(:,127),MB,G4tensor(:,70))
  call loop_QZ_A(G3(:,:,:,151),wf(:,66),G3(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,127),MB,G4tensor(:,71))
  call loop_QV_A(G2(:,:,:,114),wf(:,2),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,60),MB,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-6),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,124),MB,G4(:,:,:,71))
  call loop_QZ_A(G4(:,:,:,71),wf(:,4),G4(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),MB,G5tensor(:,37))
  call loop_QZ_A(G2(:,:,:,114),wf(:,7),G2(:,:,:,117),gZd)
  call loop_Q_A(G2(:,:,:,117),Q(:,60),MB,G3(:,:,:,161))
  call loop_QV_A(G3(:,:,:,161),wf(:,-6),G3(:,:,:,162))
  call loop_Q_A(G3(:,:,:,162),Q(:,124),MB,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,4),G4(:,:,:,74),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),MB,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,25),wf(:,-6),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,80),MB,G2(:,:,:,118))
  call loop_QV_A(G2(:,:,:,118),wf(:,-5),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,112),MB,G3(:,:,:,163))
  call loop_QS_A(G3(:,:,:,163),wf(:,45),G3(:,:,:,164),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,127),MB,G4tensor(:,72))
  call loop_QV_A(G3(:,:,:,163),wf(:,61),G3(:,:,:,165))
  call check_last_Q_A(l_switch,G3(:,:,:,165),Q(:,127),MB,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,163),wf(:,62),G3(:,:,:,166),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,166),Q(:,127),MB,G4tensor(:,74))
  call loop_QV_A(G3(:,:,:,163),wf(:,63),G3(:,:,:,167))
  call check_last_Q_A(l_switch,G3(:,:,:,167),Q(:,127),MB,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,163),wf(:,64),G3(:,:,:,168),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,168),Q(:,127),MB,G4tensor(:,76))
  call loop_QZ_A(G3(:,:,:,163),wf(:,65),G3(:,:,:,169),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,169),Q(:,127),MB,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,163),wf(:,66),G3(:,:,:,170),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),MB,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,118),wf(:,2),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,92),MB,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-5),G3(:,:,:,172))
  call loop_Q_A(G3(:,:,:,172),Q(:,124),MB,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,4),G4(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,127),MB,G5tensor(:,39))
  call loop_QZ_A(G2(:,:,:,118),wf(:,7),G2(:,:,:,121),gZd)
  call loop_Q_A(G2(:,:,:,121),Q(:,92),MB,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-5),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,124),MB,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,4),G4(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),MB,G5tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,2),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,28),ZERO,G2(:,:,:,122))
  call loop_QV_A(G2(:,:,:,122),wf(:,12),G2(:,:,:,123))
  call loop_Q_A(G2(:,:,:,123),Q(:,124),ZERO,G3(:,:,:,175))
  call loop_QZ_A(G3(:,:,:,175),wf(:,4),G3(:,:,:,176),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),ZERO,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,175),wf(:,4),G3(:,:,:,177),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,177),Q(:,127),ZERO,G4tensor(:,80))
  call loop_QV_A(G2(:,:,:,122),wf(:,-6),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,92),ZERO,G3(:,:,:,178))
  call loop_QV_A(G3(:,:,:,178),wf(:,-5),G3(:,:,:,179))
  call loop_Q_A(G3(:,:,:,179),Q(:,124),ZERO,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,4),G4(:,:,:,80),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,79),wf(:,4),G4(:,:,:,81),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,81),Q(:,127),ZERO,G5tensor(:,42))
  call loop_QV_A(G2(:,:,:,122),wf(:,-5),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,60),ZERO,G3(:,:,:,180))
  call loop_QV_A(G3(:,:,:,180),wf(:,-6),G3(:,:,:,181))
  call loop_Q_A(G3(:,:,:,181),Q(:,124),ZERO,G4(:,:,:,82))
  call loop_QZ_A(G4(:,:,:,82),wf(:,4),G4(:,:,:,83),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,83),Q(:,127),ZERO,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,82),wf(:,4),G4(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,44))
  call loop_QZ_A(G1(:,:,:,31),wf(:,7),G1(:,:,:,33),gZu)
  call loop_Q_A(G1(:,:,:,33),Q(:,28),ZERO,G2(:,:,:,126))
  call loop_QV_A(G2(:,:,:,126),wf(:,12),G2(:,:,:,127))
  call loop_Q_A(G2(:,:,:,127),Q(:,124),ZERO,G3(:,:,:,182))
  call loop_QZ_A(G3(:,:,:,182),wf(:,4),G3(:,:,:,183),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,127),ZERO,G4tensor(:,81))
  call loop_QV_A(G2(:,:,:,126),wf(:,-6),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,92),ZERO,G3(:,:,:,184))
  call loop_QV_A(G3(:,:,:,184),wf(:,-5),G3(:,:,:,185))
  call loop_Q_A(G3(:,:,:,185),Q(:,124),ZERO,G4(:,:,:,85))
  call loop_QZ_A(G4(:,:,:,85),wf(:,4),G4(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,126),wf(:,-5),G2(:,:,:,129))
  call loop_Q_A(G2(:,:,:,129),Q(:,60),ZERO,G3(:,:,:,186))
  call loop_QV_A(G3(:,:,:,186),wf(:,-6),G3(:,:,:,187))
  call loop_Q_A(G3(:,:,:,187),Q(:,124),ZERO,G4(:,:,:,87))
  call loop_QZ_A(G4(:,:,:,87),wf(:,4),G4(:,:,:,88),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,46))
  call loop_QZ_A(G1(:,:,:,31),wf(:,7),G1(:,:,:,34),gZd)
  call loop_Q_A(G1(:,:,:,34),Q(:,28),ZERO,G2(:,:,:,130))
  call loop_QV_A(G2(:,:,:,130),wf(:,12),G2(:,:,:,131))
  call loop_Q_A(G2(:,:,:,131),Q(:,124),ZERO,G3(:,:,:,188))
  call loop_QZ_A(G3(:,:,:,188),wf(:,4),G3(:,:,:,189),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),ZERO,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,130),wf(:,-6),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,92),ZERO,G3(:,:,:,190))
  call loop_QV_A(G3(:,:,:,190),wf(:,-5),G3(:,:,:,191))
  call loop_Q_A(G3(:,:,:,191),Q(:,124),ZERO,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,4),G4(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,130),wf(:,-5),G2(:,:,:,133))
  call loop_Q_A(G2(:,:,:,133),Q(:,60),ZERO,G3(:,:,:,192))
  call loop_QV_A(G3(:,:,:,192),wf(:,-6),G3(:,:,:,193))
  call loop_Q_A(G3(:,:,:,193),Q(:,124),ZERO,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,4),G4(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),ZERO,G5tensor(:,48))
  call loop_QV_A(G1(:,:,:,31),wf(:,-5),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,48),ZERO,G2(:,:,:,134))
  call loop_QV_A(G2(:,:,:,134),wf(:,2),G2(:,:,:,135))
  call loop_Q_A(G2(:,:,:,135),Q(:,60),ZERO,G3(:,:,:,194))
  call loop_QV_A(G3(:,:,:,194),wf(:,-6),G3(:,:,:,195))
  call loop_Q_A(G3(:,:,:,195),Q(:,124),ZERO,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,4),G4(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,127),ZERO,G5tensor(:,49))
  call loop_QZ_A(G4(:,:,:,93),wf(:,4),G4(:,:,:,95),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,95),Q(:,127),ZERO,G5tensor(:,50))
  call loop_QZ_A(G2(:,:,:,134),wf(:,7),G2(:,:,:,136),gZu)
  call loop_Q_A(G2(:,:,:,136),Q(:,60),ZERO,G3(:,:,:,196))
  call loop_QV_A(G3(:,:,:,196),wf(:,-6),G3(:,:,:,197))
  call loop_Q_A(G3(:,:,:,197),Q(:,124),ZERO,G4(:,:,:,96))
  call loop_QZ_A(G4(:,:,:,96),wf(:,4),G4(:,:,:,97),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,97),Q(:,127),ZERO,G5tensor(:,51))
  call loop_QZ_A(G2(:,:,:,134),wf(:,7),G2(:,:,:,137),gZd)
  call loop_Q_A(G2(:,:,:,137),Q(:,60),ZERO,G3(:,:,:,198))
  call loop_QV_A(G3(:,:,:,198),wf(:,-6),G3(:,:,:,199))
  call loop_Q_A(G3(:,:,:,199),Q(:,124),ZERO,G4(:,:,:,98))
  call loop_QZ_A(G4(:,:,:,98),wf(:,4),G4(:,:,:,99),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,99),Q(:,127),ZERO,G5tensor(:,52))
  call loop_QV_A(G2(:,:,:,134),wf(:,-6),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,112),ZERO,G3(:,:,:,200))
  call loop_QV_A(G3(:,:,:,200),wf(:,61),G3(:,:,:,201))
  call check_last_Q_A(l_switch,G3(:,:,:,201),Q(:,127),ZERO,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,200),wf(:,62),G3(:,:,:,202),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,127),ZERO,G4tensor(:,84))
  call loop_QZ_A(G3(:,:,:,200),wf(:,62),G3(:,:,:,203),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,203),Q(:,127),ZERO,G4tensor(:,85))
  call loop_QV_A(G3(:,:,:,200),wf(:,63),G3(:,:,:,204))
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,127),ZERO,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,200),wf(:,64),G3(:,:,:,205),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,205),Q(:,127),ZERO,G4tensor(:,87))
  call loop_QZ_A(G3(:,:,:,200),wf(:,64),G3(:,:,:,206),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,127),ZERO,G4tensor(:,88))
  call loop_QZ_A(G3(:,:,:,200),wf(:,65),G3(:,:,:,207),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,207),Q(:,127),ZERO,G4tensor(:,89))
  call loop_QZ_A(G3(:,:,:,200),wf(:,65),G3(:,:,:,208),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,208),Q(:,127),ZERO,G4tensor(:,90))
  call loop_QZ_A(G3(:,:,:,200),wf(:,66),G3(:,:,:,209),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,209),Q(:,127),ZERO,G4tensor(:,91))
  call loop_QZ_A(G3(:,:,:,200),wf(:,66),G3(:,:,:,210),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,210),Q(:,127),ZERO,G4tensor(:,92))
  call loop_QV_A(G1(:,:,:,31),wf(:,-6),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,80),ZERO,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,2),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,92),ZERO,G3(:,:,:,211))
  call loop_QV_A(G3(:,:,:,211),wf(:,-5),G3(:,:,:,212))
  call loop_Q_A(G3(:,:,:,212),Q(:,124),ZERO,G4(:,:,:,100))
  call loop_QZ_A(G4(:,:,:,100),wf(:,4),G4(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,101),Q(:,127),ZERO,G5tensor(:,53))
  call loop_QZ_A(G4(:,:,:,100),wf(:,4),G4(:,:,:,102),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,127),ZERO,G5tensor(:,54))
  call loop_QZ_A(G2(:,:,:,139),wf(:,7),G2(:,:,:,141),gZu)
  call loop_Q_A(G2(:,:,:,141),Q(:,92),ZERO,G3(:,:,:,213))
  call loop_QV_A(G3(:,:,:,213),wf(:,-5),G3(:,:,:,214))
  call loop_Q_A(G3(:,:,:,214),Q(:,124),ZERO,G4(:,:,:,103))
  call loop_QZ_A(G4(:,:,:,103),wf(:,4),G4(:,:,:,104),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,127),ZERO,G5tensor(:,55))
  call loop_QZ_A(G2(:,:,:,139),wf(:,7),G2(:,:,:,142),gZd)
  call loop_Q_A(G2(:,:,:,142),Q(:,92),ZERO,G3(:,:,:,215))
  call loop_QV_A(G3(:,:,:,215),wf(:,-5),G3(:,:,:,216))
  call loop_Q_A(G3(:,:,:,216),Q(:,124),ZERO,G4(:,:,:,105))
  call loop_QZ_A(G4(:,:,:,105),wf(:,4),G4(:,:,:,106),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,127),ZERO,G5tensor(:,56))
  call loop_QV_A(G2(:,:,:,139),wf(:,-5),G2(:,:,:,143))
  call loop_Q_A(G2(:,:,:,143),Q(:,112),ZERO,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,61),G3(:,:,:,218))
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,127),ZERO,G4tensor(:,93))
  call loop_QZ_A(G3(:,:,:,217),wf(:,62),G3(:,:,:,219),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,219),Q(:,127),ZERO,G4tensor(:,94))
  call loop_QZ_A(G3(:,:,:,217),wf(:,62),G3(:,:,:,220),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,220),Q(:,127),ZERO,G4tensor(:,95))
  call loop_QV_A(G3(:,:,:,217),wf(:,63),G3(:,:,:,221))
  call check_last_Q_A(l_switch,G3(:,:,:,221),Q(:,127),ZERO,G4tensor(:,96))
  call loop_QZ_A(G3(:,:,:,217),wf(:,64),G3(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,127),ZERO,G4tensor(:,97))
  call loop_QZ_A(G3(:,:,:,217),wf(:,64),G3(:,:,:,223),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,223),Q(:,127),ZERO,G4tensor(:,98))
  call loop_QZ_A(G3(:,:,:,217),wf(:,65),G3(:,:,:,224),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,127),ZERO,G4tensor(:,99))
  call loop_QZ_A(G3(:,:,:,217),wf(:,65),G3(:,:,:,225),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,127),ZERO,G4tensor(:,100))
  call loop_QZ_A(G3(:,:,:,217),wf(:,66),G3(:,:,:,226),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,226),Q(:,127),ZERO,G4tensor(:,101))
  call loop_QZ_A(G3(:,:,:,217),wf(:,66),G3(:,:,:,227),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,227),Q(:,127),ZERO,G4tensor(:,102))
  call loop_QV_A(G1(:,:,:,31),wf(:,12),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,112),ZERO,G2(:,:,:,144))
  call loop_QV_A(G2(:,:,:,144),wf(:,61),G2(:,:,:,145))
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,144),wf(:,62),G2(:,:,:,146),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,127),ZERO,G3tensor(:,40))
  call loop_QZ_A(G2(:,:,:,144),wf(:,62),G2(:,:,:,147),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,127),ZERO,G3tensor(:,41))
  call loop_QV_A(G2(:,:,:,144),wf(:,63),G2(:,:,:,148))
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,127),ZERO,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,144),wf(:,64),G2(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,127),ZERO,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,144),wf(:,64),G2(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,127),ZERO,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,144),wf(:,65),G2(:,:,:,151),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,127),ZERO,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,144),wf(:,65),G2(:,:,:,152),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,127),ZERO,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,144),wf(:,66),G2(:,:,:,153),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,153),Q(:,127),ZERO,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,144),wf(:,66),G2(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,127),ZERO,G3tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,16),ZERO,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,2),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,28),ZERO,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,12),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,124),ZERO,G3(:,:,:,228))
  call loop_AZ_Q(G3(:,:,:,228),wf(:,4),G3(:,:,:,229),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,229),Q(:,127),ZERO,G4tensor(:,103))
  call loop_AZ_Q(G3(:,:,:,228),wf(:,4),G3(:,:,:,230),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,230),Q(:,127),ZERO,G4tensor(:,104))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-6),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,92),ZERO,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-5),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,124),ZERO,G4(:,:,:,107))
  call loop_AZ_Q(G4(:,:,:,107),wf(:,4),G4(:,:,:,108),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),ZERO,G5tensor(:,57))
  call loop_AZ_Q(G4(:,:,:,107),wf(:,4),G4(:,:,:,109),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,109),Q(:,127),ZERO,G5tensor(:,58))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-5),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,60),ZERO,G3(:,:,:,233))
  call loop_AV_Q(G3(:,:,:,233),wf(:,-6),G3(:,:,:,234))
  call loop_A_Q(G3(:,:,:,234),Q(:,124),ZERO,G4(:,:,:,110))
  call loop_AZ_Q(G4(:,:,:,110),wf(:,4),G4(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,111),Q(:,127),ZERO,G5tensor(:,59))
  call loop_AZ_Q(G4(:,:,:,110),wf(:,4),G4(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,127),ZERO,G5tensor(:,60))
  call loop_AZ_Q(G1(:,:,:,38),wf(:,7),G1(:,:,:,40),gZu)
  call loop_A_Q(G1(:,:,:,40),Q(:,28),ZERO,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,12),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,124),ZERO,G3(:,:,:,235))
  call loop_AZ_Q(G3(:,:,:,235),wf(:,4),G3(:,:,:,236),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,127),ZERO,G4tensor(:,105))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-6),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,92),ZERO,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-5),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,124),ZERO,G4(:,:,:,113))
  call loop_AZ_Q(G4(:,:,:,113),wf(:,4),G4(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,127),ZERO,G5tensor(:,61))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,60),ZERO,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-6),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,124),ZERO,G4(:,:,:,115))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,4),G4(:,:,:,116),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,127),ZERO,G5tensor(:,62))
  call loop_AZ_Q(G1(:,:,:,38),wf(:,7),G1(:,:,:,41),gZd)
  call loop_A_Q(G1(:,:,:,41),Q(:,28),ZERO,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,12),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,124),ZERO,G3(:,:,:,241))
  call loop_AZ_Q(G3(:,:,:,241),wf(:,4),G3(:,:,:,242),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,127),ZERO,G4tensor(:,106))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-6),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,92),ZERO,G3(:,:,:,243))
  call loop_AV_Q(G3(:,:,:,243),wf(:,-5),G3(:,:,:,244))
  call loop_A_Q(G3(:,:,:,244),Q(:,124),ZERO,G4(:,:,:,117))
  call loop_AZ_Q(G4(:,:,:,117),wf(:,4),G4(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,118),Q(:,127),ZERO,G5tensor(:,63))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-5),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,60),ZERO,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,-6),G3(:,:,:,246))
  call loop_A_Q(G3(:,:,:,246),Q(:,124),ZERO,G4(:,:,:,119))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,4),G4(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,127),ZERO,G5tensor(:,64))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-5),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,48),ZERO,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,2),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,60),ZERO,G3(:,:,:,247))
  call loop_AV_Q(G3(:,:,:,247),wf(:,-6),G3(:,:,:,248))
  call loop_A_Q(G3(:,:,:,248),Q(:,124),ZERO,G4(:,:,:,121))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,4),G4(:,:,:,122),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,65))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,4),G4(:,:,:,123),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,123),Q(:,127),ZERO,G5tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,167),wf(:,7),G2(:,:,:,169),gZu)
  call loop_A_Q(G2(:,:,:,169),Q(:,60),ZERO,G3(:,:,:,249))
  call loop_AV_Q(G3(:,:,:,249),wf(:,-6),G3(:,:,:,250))
  call loop_A_Q(G3(:,:,:,250),Q(:,124),ZERO,G4(:,:,:,124))
  call loop_AZ_Q(G4(:,:,:,124),wf(:,4),G4(:,:,:,125),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,125),Q(:,127),ZERO,G5tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,167),wf(:,7),G2(:,:,:,170),gZd)
  call loop_A_Q(G2(:,:,:,170),Q(:,60),ZERO,G3(:,:,:,251))
  call loop_AV_Q(G3(:,:,:,251),wf(:,-6),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,124),ZERO,G4(:,:,:,126))
  call loop_AZ_Q(G4(:,:,:,126),wf(:,4),G4(:,:,:,127),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,127),Q(:,127),ZERO,G5tensor(:,68))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-6),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,112),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,61),G3(:,:,:,254))
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,127),ZERO,G4tensor(:,107))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,62),G3(:,:,:,255),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,255),Q(:,127),ZERO,G4tensor(:,108))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,62),G3(:,:,:,256),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,127),ZERO,G4tensor(:,109))
  call loop_AV_Q(G3(:,:,:,253),wf(:,63),G3(:,:,:,257))
  call check_last_A_Q(l_switch,G3(:,:,:,257),Q(:,127),ZERO,G4tensor(:,110))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,64),G3(:,:,:,258),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,127),ZERO,G4tensor(:,111))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,64),G3(:,:,:,259),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,259),Q(:,127),ZERO,G4tensor(:,112))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,65),G3(:,:,:,260),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),ZERO,G4tensor(:,113))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,65),G3(:,:,:,261),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),ZERO,G4tensor(:,114))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,66),G3(:,:,:,262),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,115))
  call loop_AZ_Q(G3(:,:,:,253),wf(:,66),G3(:,:,:,263),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,263),Q(:,127),ZERO,G4tensor(:,116))
  call loop_AV_Q(G1(:,:,:,38),wf(:,-6),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,80),ZERO,G2(:,:,:,172))
  call loop_AV_Q(G2(:,:,:,172),wf(:,2),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,92),ZERO,G3(:,:,:,264))
  call loop_AV_Q(G3(:,:,:,264),wf(:,-5),G3(:,:,:,265))
  call loop_A_Q(G3(:,:,:,265),Q(:,124),ZERO,G4(:,:,:,128))
  call loop_AZ_Q(G4(:,:,:,128),wf(:,4),G4(:,:,:,129),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,129),Q(:,127),ZERO,G5tensor(:,69))
  call loop_AZ_Q(G4(:,:,:,128),wf(:,4),G4(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,130),Q(:,127),ZERO,G5tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,172),wf(:,7),G2(:,:,:,174),gZu)
  call loop_A_Q(G2(:,:,:,174),Q(:,92),ZERO,G3(:,:,:,266))
  call loop_AV_Q(G3(:,:,:,266),wf(:,-5),G3(:,:,:,267))
  call loop_A_Q(G3(:,:,:,267),Q(:,124),ZERO,G4(:,:,:,131))
  call loop_AZ_Q(G4(:,:,:,131),wf(:,4),G4(:,:,:,132),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,71))
  call loop_AZ_Q(G2(:,:,:,172),wf(:,7),G2(:,:,:,175),gZd)
  call loop_A_Q(G2(:,:,:,175),Q(:,92),ZERO,G3(:,:,:,268))
  call loop_AV_Q(G3(:,:,:,268),wf(:,-5),G3(:,:,:,269))
  call loop_A_Q(G3(:,:,:,269),Q(:,124),ZERO,G4(:,:,:,133))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,4),G4(:,:,:,134),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,72))
  call loop_AV_Q(G2(:,:,:,172),wf(:,-5),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,112),ZERO,G3(:,:,:,270))
  call loop_AV_Q(G3(:,:,:,270),wf(:,61),G3(:,:,:,271))
  call check_last_A_Q(l_switch,G3(:,:,:,271),Q(:,127),ZERO,G4tensor(:,117))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,62),G3(:,:,:,272),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,127),ZERO,G4tensor(:,118))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,62),G3(:,:,:,273),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,273),Q(:,127),ZERO,G4tensor(:,119))
  call loop_AV_Q(G3(:,:,:,270),wf(:,63),G3(:,:,:,274))
  call check_last_A_Q(l_switch,G3(:,:,:,274),Q(:,127),ZERO,G4tensor(:,120))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,64),G3(:,:,:,275),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,275),Q(:,127),ZERO,G4tensor(:,121))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,64),G3(:,:,:,276),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,276),Q(:,127),ZERO,G4tensor(:,122))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,65),G3(:,:,:,277),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,277),Q(:,127),ZERO,G4tensor(:,123))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,65),G3(:,:,:,278),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,127),ZERO,G4tensor(:,124))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,66),G3(:,:,:,279),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,279),Q(:,127),ZERO,G4tensor(:,125))
  call loop_AZ_Q(G3(:,:,:,270),wf(:,66),G3(:,:,:,280),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,280),Q(:,127),ZERO,G4tensor(:,126))
  call loop_AV_Q(G1(:,:,:,38),wf(:,12),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,112),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,61),G2(:,:,:,178))
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,127),ZERO,G3tensor(:,49))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,62),G2(:,:,:,179),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,179),Q(:,127),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,62),G2(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,127),ZERO,G3tensor(:,51))
  call loop_AV_Q(G2(:,:,:,177),wf(:,63),G2(:,:,:,181))
  call check_last_A_Q(l_switch,G2(:,:,:,181),Q(:,127),ZERO,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,64),G2(:,:,:,182),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,127),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,64),G2(:,:,:,183),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,183),Q(:,127),ZERO,G3tensor(:,54))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,65),G2(:,:,:,184),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,127),ZERO,G3tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,65),G2(:,:,:,185),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,127),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,66),G2(:,:,:,186),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,127),ZERO,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,177),wf(:,66),G2(:,:,:,187),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,127),ZERO,G3tensor(:,58))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(9) * den(66)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,1),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(9)) * den(66)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,1),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(7)) * den(66)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,2),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(7) * den(66)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,2),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(10)) * den(67)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,3),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(10) * den(67)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,3),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(10)) * den(67)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,4),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(10) * den(67)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,4),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(18)) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(18) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(18)) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(18) * den(36)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(16)) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(16) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(16)) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(16) * den(36)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(9)) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,79),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(9) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,79),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,31),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,31),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(9)) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,103),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(9) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,103),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,15),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(7) * den(68)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,15),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(7) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,80),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,80),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(6) * den(68)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,63),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(6)) * den(68)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,63),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(7) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,104),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(7)) * den(68)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,104),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(6) * den(68)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,47),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(6)) * den(68)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,47),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(10) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,81),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(10)) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,81),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(8) * den(69)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,32),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(8)) * den(69)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,32),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(10) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,105),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(10)) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,105),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(8) * den(69)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,16),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(8)) * den(69)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,16),T4sum(1:70,20))
  M(1) = M(1) + (CI*f(10) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,82),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(10)) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,82),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(8) * den(69)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,64),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(8)) * den(69)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,64),T4sum(1:70,21))
  M(1) = M(1) + (CI*f(10) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,106),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(10)) * den(69)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,106),T4sum(1:70,19))
  M(1) = M(1) + (CI*f(8) * den(69)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,48),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(8)) * den(69)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,48),T4sum(1:70,21))
  M(1) = M(1) + (f(19) * den(33)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,17),T4sum(1:70,30))
  M(2) = M(2) + (f(19) * den(33)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,33),T4sum(1:70,30))
  M(1) = M(1) + (f(17) * den(33)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,49),T4sum(1:70,31))
  M(2) = M(2) + (f(17) * den(33)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,65),T4sum(1:70,31))
  M(2) = M(2) + (f(19) * den(33)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,24),T4sum(1:70,32))
  M(1) = M(1) + (f(19) * den(33)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,40),T4sum(1:70,32))
  M(2) = M(2) + (f(17) * den(33)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,56),T4sum(1:70,33))
  M(1) = M(1) + (f(17) * den(33)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,72),T4sum(1:70,33))
  M(1) = M(1) + (f(14) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,65),T5sum(1:126,10))
  M(1) = M(1) + (f(12) * den(4)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,13),T5sum(1:126,11))
  M(2) = M(2) + (f(14) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,49),T5sum(1:126,10))
  M(2) = M(2) + (f(12) * den(4)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,21),T5sum(1:126,11))
  M(1) = M(1) + (-f(12) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,66),T5sum(1:126,10))
  M(1) = M(1) + (-f(11) * den(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,29),T5sum(1:126,12))
  M(2) = M(2) + (-f(12) * den(4)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,50),T5sum(1:126,10))
  M(2) = M(2) + (-f(11) * den(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,37),T5sum(1:126,12))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,67),T5sum(1:126,10))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,14),T5sum(1:126,11))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,51),T5sum(1:126,10))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,22),T5sum(1:126,11))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,68),T5sum(1:126,10))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,30),T5sum(1:126,12))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_24,masses2_9,G5tensor(:,52),T5sum(1:126,10))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,38),T5sum(1:126,12))
  M(2) = M(2) + (f(14) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,5),T5sum(1:126,16))
  M(2) = M(2) + (-f(12) * den(4)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,6),T5sum(1:126,16))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,7),T5sum(1:126,16))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,8),T5sum(1:126,16))
  M(2) = M(2) + (f(14) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,69),T5sum(1:126,22))
  M(2) = M(2) + (f(12) * den(4)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,15),T5sum(1:126,23))
  M(1) = M(1) + (f(14) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,53),T5sum(1:126,22))
  M(1) = M(1) + (f(12) * den(4)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,23),T5sum(1:126,23))
  M(2) = M(2) + (-f(12) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,70),T5sum(1:126,22))
  M(2) = M(2) + (-f(11) * den(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,31),T5sum(1:126,24))
  M(1) = M(1) + (-f(12) * den(4)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,54),T5sum(1:126,22))
  M(1) = M(1) + (-f(11) * den(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,39),T5sum(1:126,24))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,71),T5sum(1:126,22))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,16),T5sum(1:126,23))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,55),T5sum(1:126,22))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,24),T5sum(1:126,23))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,72),T5sum(1:126,22))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,32),T5sum(1:126,24))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,56),T5sum(1:126,22))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,40),T5sum(1:126,24))
  M(2) = M(2) + (f(14) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,1),T5sum(1:126,28))
  M(2) = M(2) + (-f(12) * den(4)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,2),T5sum(1:126,28))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,3),T5sum(1:126,28))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,4),T5sum(1:126,28))
  M(1) = M(1) + (f(14) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,41),T5sum(1:126,31))
  M(1) = M(1) + (f(12) * den(4)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,17),T5sum(1:126,32))
  M(2) = M(2) + (f(14) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,57),T5sum(1:126,31))
  M(2) = M(2) + (f(12) * den(4)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,9),T5sum(1:126,32))
  M(1) = M(1) + (-f(12) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,42),T5sum(1:126,31))
  M(1) = M(1) + (-f(11) * den(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,33),T5sum(1:126,33))
  M(2) = M(2) + (-f(12) * den(4)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,58),T5sum(1:126,31))
  M(2) = M(2) + (-f(11) * den(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,25),T5sum(1:126,33))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,45),T5sum(1:126,31))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,19),T5sum(1:126,32))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,61),T5sum(1:126,31))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,11),T5sum(1:126,32))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,47),T5sum(1:126,31))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,35),T5sum(1:126,33))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_23,masses2_9,G5tensor(:,63),T5sum(1:126,31))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,27),T5sum(1:126,33))
  M(2) = M(2) + (f(14) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,43),T5sum(1:126,34))
  M(2) = M(2) + (f(12) * den(4)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,18),T5sum(1:126,35))
  M(1) = M(1) + (f(14) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,59),T5sum(1:126,34))
  M(1) = M(1) + (f(12) * den(4)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,10),T5sum(1:126,35))
  M(2) = M(2) + (-f(12) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,44),T5sum(1:126,34))
  M(2) = M(2) + (-f(11) * den(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,34),T5sum(1:126,36))
  M(1) = M(1) + (-f(12) * den(4)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,60),T5sum(1:126,34))
  M(1) = M(1) + (-f(11) * den(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,26),T5sum(1:126,36))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,46),T5sum(1:126,34))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,20),T5sum(1:126,35))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,62),T5sum(1:126,34))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,12),T5sum(1:126,35))
  M(2) = M(2) + (-f(15) * den(7)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,48),T5sum(1:126,34))
  M(2) = M(2) + (-f(13) * den(7)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,36),T5sum(1:126,36))
  M(1) = M(1) + (-f(15) * den(7)) * TI2_call(5,momenta_22,masses2_9,G5tensor(:,64),T5sum(1:126,34))
  M(1) = M(1) + (-f(13) * den(7)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,28),T5sum(1:126,36))
  M(1) = M(1) + (CI*f(9) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,1),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(9)) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,1),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(7)) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,1),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(7) * den(74)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,1),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,2),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,2),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,3),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(75)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,3),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(9) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,4),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(9)) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,4),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(7)) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,4),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(7) * den(76)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,4),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(77)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,5),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(77)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,5),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(77)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,6),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(77)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,6),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(9)) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(9) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(7)) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(7) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(9) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(7)) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(7) * den(78)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(7) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(7)) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(6) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(6)) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(7) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(7)) * den(78)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(6) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(6)) * den(78)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,40),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(79)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(79)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(79)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(9)) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(9) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(7)) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(7) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(9) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(7)) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(7) * den(80)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(7) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(7)) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(6) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(6)) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(7) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(7)) * den(80)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(6) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(6)) * den(80)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(81)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(81)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(81)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(2) = M(2) + (f(14) * den(57)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,5),T4sum(1:70,34))
  M(2) = M(2) + (-f(12) * den(57)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,5),T4sum(1:70,34))
  M(2) = M(2) + (-f(15) * den(59)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,6),T4sum(1:70,34))
  M(2) = M(2) + (-f(15) * den(59)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,7),T4sum(1:70,34))
  M(1) = M(1) + (f(14) * den(57)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,107),T4sum(1:70,35))
  M(1) = M(1) + (f(12) * den(57)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,18),T4sum(1:70,30))
  M(2) = M(2) + (f(14) * den(57)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,83),T4sum(1:70,35))
  M(2) = M(2) + (f(12) * den(57)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,34),T4sum(1:70,30))
  M(1) = M(1) + (-f(12) * den(57)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,107),T4sum(1:70,35))
  M(1) = M(1) + (-f(11) * den(57)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,50),T4sum(1:70,31))
  M(2) = M(2) + (-f(12) * den(57)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,83),T4sum(1:70,35))
  M(2) = M(2) + (-f(11) * den(57)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,66),T4sum(1:70,31))
  M(1) = M(1) + (-f(15) * den(59)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,108),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(59)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,19),T4sum(1:70,30))
  M(2) = M(2) + (-f(15) * den(59)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,84),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(59)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,35),T4sum(1:70,30))
  M(1) = M(1) + (-f(15) * den(59)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,109),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(59)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,51),T4sum(1:70,31))
  M(2) = M(2) + (-f(15) * den(59)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,85),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(59)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,67),T4sum(1:70,31))
  M(2) = M(2) + (f(14) * den(57)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,117),T4sum(1:70,36))
  M(2) = M(2) + (f(12) * den(57)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,25),T4sum(1:70,32))
  M(1) = M(1) + (f(14) * den(57)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,93),T4sum(1:70,36))
  M(1) = M(1) + (f(12) * den(57)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,41),T4sum(1:70,32))
  M(2) = M(2) + (-f(12) * den(57)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,117),T4sum(1:70,36))
  M(2) = M(2) + (-f(11) * den(57)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,57),T4sum(1:70,33))
  M(1) = M(1) + (-f(12) * den(57)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,93),T4sum(1:70,36))
  M(1) = M(1) + (-f(11) * den(57)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,73),T4sum(1:70,33))
  M(2) = M(2) + (-f(15) * den(59)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,118),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(59)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,26),T4sum(1:70,32))
  M(1) = M(1) + (-f(15) * den(59)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,94),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(59)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,42),T4sum(1:70,32))
  M(2) = M(2) + (-f(15) * den(59)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,119),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(59)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,58),T4sum(1:70,33))
  M(1) = M(1) + (-f(15) * den(59)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,95),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(59)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,74),T4sum(1:70,33))
  M(2) = M(2) + (f(14) * den(60)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,8),T4sum(1:70,34))
  M(2) = M(2) + (-f(12) * den(60)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,8),T4sum(1:70,34))
  M(2) = M(2) + (-f(15) * den(61)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,9),T4sum(1:70,34))
  M(2) = M(2) + (-f(15) * den(61)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,10),T4sum(1:70,34))
  M(1) = M(1) + (f(14) * den(60)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,110),T4sum(1:70,35))
  M(1) = M(1) + (f(12) * den(60)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,20),T4sum(1:70,30))
  M(2) = M(2) + (f(14) * den(60)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,86),T4sum(1:70,35))
  M(2) = M(2) + (f(12) * den(60)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,36),T4sum(1:70,30))
  M(1) = M(1) + (-f(12) * den(60)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,110),T4sum(1:70,35))
  M(1) = M(1) + (-f(11) * den(60)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,52),T4sum(1:70,31))
  M(2) = M(2) + (-f(12) * den(60)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,86),T4sum(1:70,35))
  M(2) = M(2) + (-f(11) * den(60)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,68),T4sum(1:70,31))
  M(1) = M(1) + (-f(15) * den(61)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,111),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(61)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,21),T4sum(1:70,30))
  M(2) = M(2) + (-f(15) * den(61)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,87),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(61)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,37),T4sum(1:70,30))
  M(1) = M(1) + (-f(15) * den(61)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,112),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(61)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,53),T4sum(1:70,31))
  M(2) = M(2) + (-f(15) * den(61)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,88),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(61)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,69),T4sum(1:70,31))
  M(2) = M(2) + (f(14) * den(60)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,120),T4sum(1:70,36))
  M(2) = M(2) + (f(12) * den(60)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,27),T4sum(1:70,32))
  M(1) = M(1) + (f(14) * den(60)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,96),T4sum(1:70,36))
  M(1) = M(1) + (f(12) * den(60)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,43),T4sum(1:70,32))
  M(2) = M(2) + (-f(12) * den(60)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,120),T4sum(1:70,36))
  M(2) = M(2) + (-f(11) * den(60)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,59),T4sum(1:70,33))
  M(1) = M(1) + (-f(12) * den(60)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,96),T4sum(1:70,36))
  M(1) = M(1) + (-f(11) * den(60)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,75),T4sum(1:70,33))
  M(2) = M(2) + (-f(15) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,121),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(61)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,28),T4sum(1:70,32))
  M(1) = M(1) + (-f(15) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,97),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(61)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,44),T4sum(1:70,32))
  M(2) = M(2) + (-f(15) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,122),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(61)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,60),T4sum(1:70,33))
  M(1) = M(1) + (-f(15) * den(61)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,98),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(61)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,76),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(10)) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,7),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,7),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,8),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(84)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,8),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,9),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,9),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(10)) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,10),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(10) * den(85)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,10),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(10) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(86)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(86)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(86)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(8)) * den(87)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(10) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(10) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(10)) * den(87)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(8) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(8)) * den(87)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(2) = M(2) + (-f(15) * den(62)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,11),T4sum(1:70,34))
  M(2) = M(2) + (-f(15) * den(62)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,12),T4sum(1:70,34))
  M(1) = M(1) + (-f(15) * den(62)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,113),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(62)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,22),T4sum(1:70,30))
  M(2) = M(2) + (-f(15) * den(62)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,89),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(62)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,38),T4sum(1:70,30))
  M(1) = M(1) + (-f(15) * den(62)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,114),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(62)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,54),T4sum(1:70,31))
  M(2) = M(2) + (-f(15) * den(62)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,90),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(62)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,70),T4sum(1:70,31))
  M(2) = M(2) + (-f(15) * den(62)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,123),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(62)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,29),T4sum(1:70,32))
  M(1) = M(1) + (-f(15) * den(62)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,99),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(62)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,45),T4sum(1:70,32))
  M(2) = M(2) + (-f(15) * den(62)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,124),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(62)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,61),T4sum(1:70,33))
  M(1) = M(1) + (-f(15) * den(62)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,100),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(62)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,77),T4sum(1:70,33))
  M(2) = M(2) + (-f(15) * den(63)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,13),T4sum(1:70,34))
  M(2) = M(2) + (-f(15) * den(63)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,14),T4sum(1:70,34))
  M(1) = M(1) + (-f(15) * den(63)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,115),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(63)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,23),T4sum(1:70,30))
  M(2) = M(2) + (-f(15) * den(63)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,91),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(63)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,39),T4sum(1:70,30))
  M(1) = M(1) + (-f(15) * den(63)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,116),T4sum(1:70,35))
  M(1) = M(1) + (-f(13) * den(63)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,55),T4sum(1:70,31))
  M(2) = M(2) + (-f(15) * den(63)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,92),T4sum(1:70,35))
  M(2) = M(2) + (-f(13) * den(63)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,71),T4sum(1:70,31))
  M(2) = M(2) + (-f(15) * den(63)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,125),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(63)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,30),T4sum(1:70,32))
  M(1) = M(1) + (-f(15) * den(63)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,101),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(63)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,46),T4sum(1:70,32))
  M(2) = M(2) + (-f(15) * den(63)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,126),T4sum(1:70,36))
  M(2) = M(2) + (-f(13) * den(63)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,62),T4sum(1:70,33))
  M(1) = M(1) + (-f(15) * den(63)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,102),T4sum(1:70,36))
  M(1) = M(1) + (-f(13) * den(63)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,78),T4sum(1:70,33))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_ppllllj2_nmnmxeexggg_1_/**/REALKIND
