
module ol_vamp_2_ppllllj2_nenenexnexggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppllllj2_nenenexnexggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppllllj2_nenenexnexggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppllllj2_nenenexnexggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppllllj2_nenenexnexggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,15) :: G0
  complex(REALKIND), dimension(4,5,4,96) :: G1
  complex(REALKIND), dimension(4,15,4,342) :: G2
  complex(REALKIND), dimension(4,35,4,508) :: G3
  complex(REALKIND), dimension(4,70,4,224) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,72,128))
    allocate(G4tensorhel(70,208,128))
    allocate(G5tensorhel(126,112,128))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,16),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,9),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,112),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,46),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,127),MT,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,69),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,127),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,70),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,127),MT,G3tensor(:,3))
  call loop_AS_Q(G2(:,:,:,1),wf(:,59),G2(:,:,:,5),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,127),MT,G3tensor(:,4))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,71),G2(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,127),MT,G3tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,72),G2(:,:,:,7),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,127),MT,G3tensor(:,6))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,73),G2(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,127),MT,G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,74),G2(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,127),MT,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,75),G2(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,127),MT,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,76),G2(:,:,:,11),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,127),MT,G3tensor(:,10))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,26),MT,G2(:,:,:,12))
  call loop_AV_Q(G2(:,:,:,12),wf(:,9),G2(:,:,:,13))
  call loop_A_Q(G2(:,:,:,13),Q(:,122),MT,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,4),G3(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,127),MT,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-6),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,90),MT,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,-5),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,122),MT,G4(:,:,:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,4),G4(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,127),MT,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,12),wf(:,-5),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,58),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-6),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,122),MT,G4(:,:,:,3))
  call loop_AZ_Q(G4(:,:,:,3),wf(:,4),G4(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,127),MT,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,48),MT,G2(:,:,:,16))
  call loop_AV_Q(G2(:,:,:,16),wf(:,-6),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,112),MT,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,46),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,127),MT,G4tensor(:,2))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,69),G3(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,127),MT,G4tensor(:,3))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,70),G3(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,127),MT,G4tensor(:,4))
  call loop_AS_Q(G3(:,:,:,7),wf(:,59),G3(:,:,:,11),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,11),Q(:,127),MT,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,71),G3(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,127),MT,G4tensor(:,6))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,72),G3(:,:,:,13),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,13),Q(:,127),MT,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,73),G3(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,127),MT,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,74),G3(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,127),MT,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,75),G3(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,127),MT,G4tensor(:,10))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,76),G3(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,127),MT,G4tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,5),G2(:,:,:,18),gZu)
  call loop_A_Q(G2(:,:,:,18),Q(:,58),MT,G3(:,:,:,18))
  call loop_AV_Q(G3(:,:,:,18),wf(:,-6),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,122),MT,G4(:,:,:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,4),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,127),MT,G5tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,16),wf(:,26),G2(:,:,:,19),gZu)
  call loop_A_Q(G2(:,:,:,19),Q(:,57),MT,G3(:,:,:,20))
  call loop_AV_Q(G3(:,:,:,20),wf(:,-6),G3(:,:,:,21))
  call loop_A_Q(G3(:,:,:,21),Q(:,121),MT,G4(:,:,:,7))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,27),G4(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,127),MT,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-6),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,80),MT,G2(:,:,:,20))
  call loop_AV_Q(G2(:,:,:,20),wf(:,-5),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,112),MT,G3(:,:,:,22))
  call loop_AS_Q(G3(:,:,:,22),wf(:,46),G3(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,127),MT,G4tensor(:,12))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,69),G3(:,:,:,24),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,127),MT,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,70),G3(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,127),MT,G4tensor(:,14))
  call loop_AS_Q(G3(:,:,:,22),wf(:,59),G3(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,127),MT,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,71),G3(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,27),Q(:,127),MT,G4tensor(:,16))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,72),G3(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,127),MT,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,73),G3(:,:,:,29),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,29),Q(:,127),MT,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,74),G3(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,127),MT,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,75),G3(:,:,:,31),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,127),MT,G4tensor(:,20))
  call loop_AZ_Q(G3(:,:,:,22),wf(:,76),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,127),MT,G4tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,5),G2(:,:,:,22),gZu)
  call loop_A_Q(G2(:,:,:,22),Q(:,90),MT,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,-5),G3(:,:,:,34))
  call loop_A_Q(G3(:,:,:,34),Q(:,122),MT,G4(:,:,:,9))
  call loop_AZ_Q(G4(:,:,:,9),wf(:,4),G4(:,:,:,10),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,127),MT,G5tensor(:,5))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,26),G2(:,:,:,23),gZu)
  call loop_A_Q(G2(:,:,:,23),Q(:,89),MT,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,-5),G3(:,:,:,36))
  call loop_A_Q(G3(:,:,:,36),Q(:,121),MT,G4(:,:,:,11))
  call loop_AZ_Q(G4(:,:,:,11),wf(:,27),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,127),MT,G5tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,26),G1(:,:,:,6),gZu)
  call loop_A_Q(G1(:,:,:,6),Q(:,25),MT,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,9),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,121),MT,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,27),G3(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,127),MT,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-5),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,57),MT,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-6),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,121),MT,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,27),G4(:,:,:,14),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,127),MT,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-6),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,89),MT,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,-5),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,121),MT,G4(:,:,:,15))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,27),G4(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,127),MT,G5tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,16),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,9),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,112),MT,G2(:,:,:,28))
  call loop_QS_A(G2(:,:,:,28),wf(:,46),G2(:,:,:,29),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,127),MT,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,28),wf(:,69),G2(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,127),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,28),wf(:,70),G2(:,:,:,31),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,31),Q(:,127),MT,G3tensor(:,13))
  call loop_QS_A(G2(:,:,:,28),wf(:,59),G2(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,127),MT,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,28),wf(:,71),G2(:,:,:,33),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,127),MT,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,28),wf(:,72),G2(:,:,:,34),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,127),MT,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,28),wf(:,73),G2(:,:,:,35),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,127),MT,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,28),wf(:,74),G2(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,127),MT,G3tensor(:,18))
  call loop_QZ_A(G2(:,:,:,28),wf(:,75),G2(:,:,:,37),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,127),MT,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,28),wf(:,76),G2(:,:,:,38),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,127),MT,G3tensor(:,20))
  call loop_QZ_A(G1(:,:,:,7),wf(:,5),G1(:,:,:,9),gZu)
  call loop_Q_A(G1(:,:,:,9),Q(:,26),MT,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,9),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,122),MT,G3(:,:,:,43))
  call loop_QZ_A(G3(:,:,:,43),wf(:,4),G3(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,127),MT,G4tensor(:,23))
  call loop_QV_A(G2(:,:,:,39),wf(:,-6),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,90),MT,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,122),MT,G4(:,:,:,17))
  call loop_QZ_A(G4(:,:,:,17),wf(:,4),G4(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,127),MT,G5tensor(:,9))
  call loop_QV_A(G2(:,:,:,39),wf(:,-5),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,58),MT,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-6),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,122),MT,G4(:,:,:,19))
  call loop_QZ_A(G4(:,:,:,19),wf(:,4),G4(:,:,:,20),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,127),MT,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,7),wf(:,-5),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,48),MT,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,-6),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,112),MT,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,46),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,127),MT,G4tensor(:,24))
  call loop_QZ_A(G3(:,:,:,49),wf(:,69),G3(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,51),Q(:,127),MT,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,49),wf(:,70),G3(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,127),MT,G4tensor(:,26))
  call loop_QS_A(G3(:,:,:,49),wf(:,59),G3(:,:,:,53),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,53),Q(:,127),MT,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,49),wf(:,71),G3(:,:,:,54),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,127),MT,G4tensor(:,28))
  call loop_QZ_A(G3(:,:,:,49),wf(:,72),G3(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,127),MT,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,49),wf(:,73),G3(:,:,:,56),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,56),Q(:,127),MT,G4tensor(:,30))
  call loop_QZ_A(G3(:,:,:,49),wf(:,74),G3(:,:,:,57),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,127),MT,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,49),wf(:,75),G3(:,:,:,58),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,127),MT,G4tensor(:,32))
  call loop_QZ_A(G3(:,:,:,49),wf(:,76),G3(:,:,:,59),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,59),Q(:,127),MT,G4tensor(:,33))
  call loop_QZ_A(G2(:,:,:,43),wf(:,5),G2(:,:,:,45),gZu)
  call loop_Q_A(G2(:,:,:,45),Q(:,58),MT,G3(:,:,:,60))
  call loop_QV_A(G3(:,:,:,60),wf(:,-6),G3(:,:,:,61))
  call loop_Q_A(G3(:,:,:,61),Q(:,122),MT,G4(:,:,:,21))
  call loop_QZ_A(G4(:,:,:,21),wf(:,4),G4(:,:,:,22),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,127),MT,G5tensor(:,11))
  call loop_QZ_A(G2(:,:,:,43),wf(:,26),G2(:,:,:,46),gZu)
  call loop_Q_A(G2(:,:,:,46),Q(:,57),MT,G3(:,:,:,62))
  call loop_QV_A(G3(:,:,:,62),wf(:,-6),G3(:,:,:,63))
  call loop_Q_A(G3(:,:,:,63),Q(:,121),MT,G4(:,:,:,23))
  call loop_QZ_A(G4(:,:,:,23),wf(:,27),G4(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,127),MT,G5tensor(:,12))
  call loop_QV_A(G1(:,:,:,7),wf(:,-6),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,80),MT,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,112),MT,G3(:,:,:,64))
  call loop_QS_A(G3(:,:,:,64),wf(:,46),G3(:,:,:,65),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,127),MT,G4tensor(:,34))
  call loop_QZ_A(G3(:,:,:,64),wf(:,69),G3(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,127),MT,G4tensor(:,35))
  call loop_QZ_A(G3(:,:,:,64),wf(:,70),G3(:,:,:,67),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,67),Q(:,127),MT,G4tensor(:,36))
  call loop_QS_A(G3(:,:,:,64),wf(:,59),G3(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,127),MT,G4tensor(:,37))
  call loop_QZ_A(G3(:,:,:,64),wf(:,71),G3(:,:,:,69),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,69),Q(:,127),MT,G4tensor(:,38))
  call loop_QZ_A(G3(:,:,:,64),wf(:,72),G3(:,:,:,70),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,127),MT,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,64),wf(:,73),G3(:,:,:,71),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,71),Q(:,127),MT,G4tensor(:,40))
  call loop_QZ_A(G3(:,:,:,64),wf(:,74),G3(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,127),MT,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,64),wf(:,75),G3(:,:,:,73),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,73),Q(:,127),MT,G4tensor(:,42))
  call loop_QZ_A(G3(:,:,:,64),wf(:,76),G3(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,127),MT,G4tensor(:,43))
  call loop_QZ_A(G2(:,:,:,47),wf(:,5),G2(:,:,:,49),gZu)
  call loop_Q_A(G2(:,:,:,49),Q(:,90),MT,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,-5),G3(:,:,:,76))
  call loop_Q_A(G3(:,:,:,76),Q(:,122),MT,G4(:,:,:,25))
  call loop_QZ_A(G4(:,:,:,25),wf(:,4),G4(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,127),MT,G5tensor(:,13))
  call loop_QZ_A(G2(:,:,:,47),wf(:,26),G2(:,:,:,50),gZu)
  call loop_Q_A(G2(:,:,:,50),Q(:,89),MT,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-5),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,121),MT,G4(:,:,:,27))
  call loop_QZ_A(G4(:,:,:,27),wf(:,27),G4(:,:,:,28),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,127),MT,G5tensor(:,14))
  call loop_QZ_A(G1(:,:,:,7),wf(:,26),G1(:,:,:,12),gZu)
  call loop_Q_A(G1(:,:,:,12),Q(:,25),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,9),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,121),MT,G3(:,:,:,79))
  call loop_QZ_A(G3(:,:,:,79),wf(:,27),G3(:,:,:,80),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,127),MT,G4tensor(:,44))
  call loop_QV_A(G2(:,:,:,51),wf(:,-5),G2(:,:,:,53))
  call loop_Q_A(G2(:,:,:,53),Q(:,57),MT,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-6),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,121),MT,G4(:,:,:,29))
  call loop_QZ_A(G4(:,:,:,29),wf(:,27),G4(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,127),MT,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,51),wf(:,-6),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,89),MT,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,-5),G3(:,:,:,84))
  call loop_Q_A(G3(:,:,:,84),Q(:,121),MT,G4(:,:,:,31))
  call loop_QZ_A(G4(:,:,:,31),wf(:,27),G4(:,:,:,32),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,127),MT,G5tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,16),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,9),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,112),MB,G2(:,:,:,55))
  call loop_AS_Q(G2(:,:,:,55),wf(:,46),G2(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,127),MB,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,69),G2(:,:,:,57),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,127),MB,G3tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,70),G2(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,127),MB,G3tensor(:,23))
  call loop_AS_Q(G2(:,:,:,55),wf(:,59),G2(:,:,:,59),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,127),MB,G3tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,71),G2(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,127),MB,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,72),G2(:,:,:,61),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,61),Q(:,127),MB,G3tensor(:,26))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,73),G2(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,127),MB,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,74),G2(:,:,:,63),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,127),MB,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,75),G2(:,:,:,64),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,127),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,76),G2(:,:,:,65),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,127),MB,G3tensor(:,30))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,5),G1(:,:,:,15),gZd)
  call loop_A_Q(G1(:,:,:,15),Q(:,26),MB,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,9),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,122),MB,G3(:,:,:,85))
  call loop_AZ_Q(G3(:,:,:,85),wf(:,4),G3(:,:,:,86),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,127),MB,G4tensor(:,45))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-6),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,90),MB,G3(:,:,:,87))
  call loop_AV_Q(G3(:,:,:,87),wf(:,-5),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,122),MB,G4(:,:,:,33))
  call loop_AZ_Q(G4(:,:,:,33),wf(:,4),G4(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,127),MB,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-5),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,58),MB,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-6),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,122),MB,G4(:,:,:,35))
  call loop_AZ_Q(G4(:,:,:,35),wf(:,4),G4(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,127),MB,G5tensor(:,18))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-5),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,48),MB,G2(:,:,:,70))
  call loop_AV_Q(G2(:,:,:,70),wf(:,-6),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,112),MB,G3(:,:,:,91))
  call loop_AS_Q(G3(:,:,:,91),wf(:,46),G3(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,127),MB,G4tensor(:,46))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,69),G3(:,:,:,93),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,93),Q(:,127),MB,G4tensor(:,47))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,70),G3(:,:,:,94),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,127),MB,G4tensor(:,48))
  call loop_AS_Q(G3(:,:,:,91),wf(:,59),G3(:,:,:,95),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,127),MB,G4tensor(:,49))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,71),G3(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,127),MB,G4tensor(:,50))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,72),G3(:,:,:,97),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,97),Q(:,127),MB,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,73),G3(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,127),MB,G4tensor(:,52))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,74),G3(:,:,:,99),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,99),Q(:,127),MB,G4tensor(:,53))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,75),G3(:,:,:,100),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,127),MB,G4tensor(:,54))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,76),G3(:,:,:,101),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,101),Q(:,127),MB,G4tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,70),wf(:,5),G2(:,:,:,72),gZd)
  call loop_A_Q(G2(:,:,:,72),Q(:,58),MB,G3(:,:,:,102))
  call loop_AV_Q(G3(:,:,:,102),wf(:,-6),G3(:,:,:,103))
  call loop_A_Q(G3(:,:,:,103),Q(:,122),MB,G4(:,:,:,37))
  call loop_AZ_Q(G4(:,:,:,37),wf(:,4),G4(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,127),MB,G5tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,70),wf(:,26),G2(:,:,:,73),gZd)
  call loop_A_Q(G2(:,:,:,73),Q(:,57),MB,G3(:,:,:,104))
  call loop_AV_Q(G3(:,:,:,104),wf(:,-6),G3(:,:,:,105))
  call loop_A_Q(G3(:,:,:,105),Q(:,121),MB,G4(:,:,:,39))
  call loop_AZ_Q(G4(:,:,:,39),wf(:,27),G4(:,:,:,40),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,127),MB,G5tensor(:,20))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-6),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,80),MB,G2(:,:,:,74))
  call loop_AV_Q(G2(:,:,:,74),wf(:,-5),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,112),MB,G3(:,:,:,106))
  call loop_AS_Q(G3(:,:,:,106),wf(:,46),G3(:,:,:,107),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,107),Q(:,127),MB,G4tensor(:,56))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,69),G3(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,127),MB,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,70),G3(:,:,:,109),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,109),Q(:,127),MB,G4tensor(:,58))
  call loop_AS_Q(G3(:,:,:,106),wf(:,59),G3(:,:,:,110),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,127),MB,G4tensor(:,59))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,71),G3(:,:,:,111),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,111),Q(:,127),MB,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,72),G3(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,112),Q(:,127),MB,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,73),G3(:,:,:,113),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,113),Q(:,127),MB,G4tensor(:,62))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,74),G3(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,127),MB,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,75),G3(:,:,:,115),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,115),Q(:,127),MB,G4tensor(:,64))
  call loop_AZ_Q(G3(:,:,:,106),wf(:,76),G3(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,127),MB,G4tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,5),G2(:,:,:,76),gZd)
  call loop_A_Q(G2(:,:,:,76),Q(:,90),MB,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,-5),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,122),MB,G4(:,:,:,41))
  call loop_AZ_Q(G4(:,:,:,41),wf(:,4),G4(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,127),MB,G5tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,74),wf(:,26),G2(:,:,:,77),gZd)
  call loop_A_Q(G2(:,:,:,77),Q(:,89),MB,G3(:,:,:,119))
  call loop_AV_Q(G3(:,:,:,119),wf(:,-5),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,121),MB,G4(:,:,:,43))
  call loop_AZ_Q(G4(:,:,:,43),wf(:,27),G4(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,127),MB,G5tensor(:,22))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,26),G1(:,:,:,18),gZd)
  call loop_A_Q(G1(:,:,:,18),Q(:,25),MB,G2(:,:,:,78))
  call loop_AV_Q(G2(:,:,:,78),wf(:,9),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,121),MB,G3(:,:,:,121))
  call loop_AZ_Q(G3(:,:,:,121),wf(:,27),G3(:,:,:,122),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,127),MB,G4tensor(:,66))
  call loop_AV_Q(G2(:,:,:,78),wf(:,-5),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,57),MB,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-6),G3(:,:,:,124))
  call loop_A_Q(G3(:,:,:,124),Q(:,121),MB,G4(:,:,:,45))
  call loop_AZ_Q(G4(:,:,:,45),wf(:,27),G4(:,:,:,46),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,127),MB,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,78),wf(:,-6),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,89),MB,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-5),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,121),MB,G4(:,:,:,47))
  call loop_AZ_Q(G4(:,:,:,47),wf(:,27),G4(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,127),MB,G5tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,16),MB,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,9),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,112),MB,G2(:,:,:,82))
  call loop_QS_A(G2(:,:,:,82),wf(:,46),G2(:,:,:,83),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,127),MB,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,82),wf(:,69),G2(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,127),MB,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,82),wf(:,70),G2(:,:,:,85),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,127),MB,G3tensor(:,33))
  call loop_QS_A(G2(:,:,:,82),wf(:,59),G2(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,127),MB,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,82),wf(:,71),G2(:,:,:,87),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,127),MB,G3tensor(:,35))
  call loop_QZ_A(G2(:,:,:,82),wf(:,72),G2(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,127),MB,G3tensor(:,36))
  call loop_QZ_A(G2(:,:,:,82),wf(:,73),G2(:,:,:,89),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,127),MB,G3tensor(:,37))
  call loop_QZ_A(G2(:,:,:,82),wf(:,74),G2(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,127),MB,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,82),wf(:,75),G2(:,:,:,91),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,127),MB,G3tensor(:,39))
  call loop_QZ_A(G2(:,:,:,82),wf(:,76),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,127),MB,G3tensor(:,40))
  call loop_QZ_A(G1(:,:,:,19),wf(:,5),G1(:,:,:,21),gZd)
  call loop_Q_A(G1(:,:,:,21),Q(:,26),MB,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,9),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,122),MB,G3(:,:,:,127))
  call loop_QZ_A(G3(:,:,:,127),wf(:,4),G3(:,:,:,128),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,128),Q(:,127),MB,G4tensor(:,67))
  call loop_QV_A(G2(:,:,:,93),wf(:,-6),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,90),MB,G3(:,:,:,129))
  call loop_QV_A(G3(:,:,:,129),wf(:,-5),G3(:,:,:,130))
  call loop_Q_A(G3(:,:,:,130),Q(:,122),MB,G4(:,:,:,49))
  call loop_QZ_A(G4(:,:,:,49),wf(:,4),G4(:,:,:,50),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,127),MB,G5tensor(:,25))
  call loop_QV_A(G2(:,:,:,93),wf(:,-5),G2(:,:,:,96))
  call loop_Q_A(G2(:,:,:,96),Q(:,58),MB,G3(:,:,:,131))
  call loop_QV_A(G3(:,:,:,131),wf(:,-6),G3(:,:,:,132))
  call loop_Q_A(G3(:,:,:,132),Q(:,122),MB,G4(:,:,:,51))
  call loop_QZ_A(G4(:,:,:,51),wf(:,4),G4(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,127),MB,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,48),MB,G2(:,:,:,97))
  call loop_QV_A(G2(:,:,:,97),wf(:,-6),G2(:,:,:,98))
  call loop_Q_A(G2(:,:,:,98),Q(:,112),MB,G3(:,:,:,133))
  call loop_QS_A(G3(:,:,:,133),wf(:,46),G3(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,127),MB,G4tensor(:,68))
  call loop_QZ_A(G3(:,:,:,133),wf(:,69),G3(:,:,:,135),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,135),Q(:,127),MB,G4tensor(:,69))
  call loop_QZ_A(G3(:,:,:,133),wf(:,70),G3(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,136),Q(:,127),MB,G4tensor(:,70))
  call loop_QS_A(G3(:,:,:,133),wf(:,59),G3(:,:,:,137),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,137),Q(:,127),MB,G4tensor(:,71))
  call loop_QZ_A(G3(:,:,:,133),wf(:,71),G3(:,:,:,138),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,127),MB,G4tensor(:,72))
  call loop_QZ_A(G3(:,:,:,133),wf(:,72),G3(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,139),Q(:,127),MB,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,133),wf(:,73),G3(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,127),MB,G4tensor(:,74))
  call loop_QZ_A(G3(:,:,:,133),wf(:,74),G3(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,141),Q(:,127),MB,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,133),wf(:,75),G3(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,127),MB,G4tensor(:,76))
  call loop_QZ_A(G3(:,:,:,133),wf(:,76),G3(:,:,:,143),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,143),Q(:,127),MB,G4tensor(:,77))
  call loop_QZ_A(G2(:,:,:,97),wf(:,5),G2(:,:,:,99),gZd)
  call loop_Q_A(G2(:,:,:,99),Q(:,58),MB,G3(:,:,:,144))
  call loop_QV_A(G3(:,:,:,144),wf(:,-6),G3(:,:,:,145))
  call loop_Q_A(G3(:,:,:,145),Q(:,122),MB,G4(:,:,:,53))
  call loop_QZ_A(G4(:,:,:,53),wf(:,4),G4(:,:,:,54),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,127),MB,G5tensor(:,27))
  call loop_QZ_A(G2(:,:,:,97),wf(:,26),G2(:,:,:,100),gZd)
  call loop_Q_A(G2(:,:,:,100),Q(:,57),MB,G3(:,:,:,146))
  call loop_QV_A(G3(:,:,:,146),wf(:,-6),G3(:,:,:,147))
  call loop_Q_A(G3(:,:,:,147),Q(:,121),MB,G4(:,:,:,55))
  call loop_QZ_A(G4(:,:,:,55),wf(:,27),G4(:,:,:,56),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,127),MB,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,19),wf(:,-6),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,80),MB,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_Q_A(G2(:,:,:,102),Q(:,112),MB,G3(:,:,:,148))
  call loop_QS_A(G3(:,:,:,148),wf(:,46),G3(:,:,:,149),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,149),Q(:,127),MB,G4tensor(:,78))
  call loop_QZ_A(G3(:,:,:,148),wf(:,69),G3(:,:,:,150),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,127),MB,G4tensor(:,79))
  call loop_QZ_A(G3(:,:,:,148),wf(:,70),G3(:,:,:,151),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,151),Q(:,127),MB,G4tensor(:,80))
  call loop_QS_A(G3(:,:,:,148),wf(:,59),G3(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,152),Q(:,127),MB,G4tensor(:,81))
  call loop_QZ_A(G3(:,:,:,148),wf(:,71),G3(:,:,:,153),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,153),Q(:,127),MB,G4tensor(:,82))
  call loop_QZ_A(G3(:,:,:,148),wf(:,72),G3(:,:,:,154),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,127),MB,G4tensor(:,83))
  call loop_QZ_A(G3(:,:,:,148),wf(:,73),G3(:,:,:,155),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,155),Q(:,127),MB,G4tensor(:,84))
  call loop_QZ_A(G3(:,:,:,148),wf(:,74),G3(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,127),MB,G4tensor(:,85))
  call loop_QZ_A(G3(:,:,:,148),wf(:,75),G3(:,:,:,157),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,157),Q(:,127),MB,G4tensor(:,86))
  call loop_QZ_A(G3(:,:,:,148),wf(:,76),G3(:,:,:,158),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,127),MB,G4tensor(:,87))
  call loop_QZ_A(G2(:,:,:,101),wf(:,5),G2(:,:,:,103),gZd)
  call loop_Q_A(G2(:,:,:,103),Q(:,90),MB,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-5),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,122),MB,G4(:,:,:,57))
  call loop_QZ_A(G4(:,:,:,57),wf(:,4),G4(:,:,:,58),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,127),MB,G5tensor(:,29))
  call loop_QZ_A(G2(:,:,:,101),wf(:,26),G2(:,:,:,104),gZd)
  call loop_Q_A(G2(:,:,:,104),Q(:,89),MB,G3(:,:,:,161))
  call loop_QV_A(G3(:,:,:,161),wf(:,-5),G3(:,:,:,162))
  call loop_Q_A(G3(:,:,:,162),Q(:,121),MB,G4(:,:,:,59))
  call loop_QZ_A(G4(:,:,:,59),wf(:,27),G4(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,127),MB,G5tensor(:,30))
  call loop_QZ_A(G1(:,:,:,19),wf(:,26),G1(:,:,:,24),gZd)
  call loop_Q_A(G1(:,:,:,24),Q(:,25),MB,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,9),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,121),MB,G3(:,:,:,163))
  call loop_QZ_A(G3(:,:,:,163),wf(:,27),G3(:,:,:,164),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,127),MB,G4tensor(:,88))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,107))
  call loop_Q_A(G2(:,:,:,107),Q(:,57),MB,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-6),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,121),MB,G4(:,:,:,61))
  call loop_QZ_A(G4(:,:,:,61),wf(:,27),G4(:,:,:,62),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,127),MB,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,105),wf(:,-6),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,89),MB,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,-5),G3(:,:,:,168))
  call loop_Q_A(G3(:,:,:,168),Q(:,121),MB,G4(:,:,:,63))
  call loop_QZ_A(G4(:,:,:,63),wf(:,27),G4(:,:,:,64),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,127),MB,G5tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,16),ZERO,G1(:,:,:,25))
  call loop_QZ_A(G1(:,:,:,25),wf(:,5),G1(:,:,:,26),gZu)
  call loop_Q_A(G1(:,:,:,26),Q(:,26),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,9),G2(:,:,:,110))
  call loop_Q_A(G2(:,:,:,110),Q(:,122),ZERO,G3(:,:,:,169))
  call loop_QZ_A(G3(:,:,:,169),wf(:,4),G3(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,127),ZERO,G4tensor(:,89))
  call loop_QV_A(G2(:,:,:,109),wf(:,-6),G2(:,:,:,111))
  call loop_Q_A(G2(:,:,:,111),Q(:,90),ZERO,G3(:,:,:,171))
  call loop_QV_A(G3(:,:,:,171),wf(:,-5),G3(:,:,:,172))
  call loop_Q_A(G3(:,:,:,172),Q(:,122),ZERO,G4(:,:,:,65))
  call loop_QZ_A(G4(:,:,:,65),wf(:,4),G4(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,127),ZERO,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,109),wf(:,-5),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,58),ZERO,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-6),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,122),ZERO,G4(:,:,:,67))
  call loop_QZ_A(G4(:,:,:,67),wf(:,4),G4(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,127),ZERO,G5tensor(:,34))
  call loop_QZ_A(G1(:,:,:,25),wf(:,5),G1(:,:,:,27),gZd)
  call loop_Q_A(G1(:,:,:,27),Q(:,26),ZERO,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,9),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,122),ZERO,G3(:,:,:,175))
  call loop_QZ_A(G3(:,:,:,175),wf(:,4),G3(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,127),ZERO,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,113),wf(:,-6),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,90),ZERO,G3(:,:,:,177))
  call loop_QV_A(G3(:,:,:,177),wf(:,-5),G3(:,:,:,178))
  call loop_Q_A(G3(:,:,:,178),Q(:,122),ZERO,G4(:,:,:,69))
  call loop_QZ_A(G4(:,:,:,69),wf(:,4),G4(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,127),ZERO,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,113),wf(:,-5),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,58),ZERO,G3(:,:,:,179))
  call loop_QV_A(G3(:,:,:,179),wf(:,-6),G3(:,:,:,180))
  call loop_Q_A(G3(:,:,:,180),Q(:,122),ZERO,G4(:,:,:,71))
  call loop_QZ_A(G4(:,:,:,71),wf(:,4),G4(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,127),ZERO,G5tensor(:,36))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,48),ZERO,G2(:,:,:,117))
  call loop_QZ_A(G2(:,:,:,117),wf(:,5),G2(:,:,:,118),gZu)
  call loop_Q_A(G2(:,:,:,118),Q(:,58),ZERO,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-6),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,122),ZERO,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,4),G4(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,127),ZERO,G5tensor(:,37))
  call loop_QZ_A(G2(:,:,:,117),wf(:,5),G2(:,:,:,119),gZd)
  call loop_Q_A(G2(:,:,:,119),Q(:,58),ZERO,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-6),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,122),ZERO,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,4),G4(:,:,:,76),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,127),ZERO,G5tensor(:,38))
  call loop_QV_A(G2(:,:,:,117),wf(:,-6),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,112),ZERO,G3(:,:,:,185))
  call loop_QZ_A(G3(:,:,:,185),wf(:,69),G3(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,127),ZERO,G4tensor(:,91))
  call loop_QZ_A(G3(:,:,:,185),wf(:,69),G3(:,:,:,187),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,187),Q(:,127),ZERO,G4tensor(:,92))
  call loop_QZ_A(G3(:,:,:,185),wf(:,70),G3(:,:,:,188),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,127),ZERO,G4tensor(:,93))
  call loop_QZ_A(G3(:,:,:,185),wf(:,70),G3(:,:,:,189),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,127),ZERO,G4tensor(:,94))
  call loop_QZ_A(G3(:,:,:,185),wf(:,71),G3(:,:,:,190),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,127),ZERO,G4tensor(:,95))
  call loop_QZ_A(G3(:,:,:,185),wf(:,71),G3(:,:,:,191),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,191),Q(:,127),ZERO,G4tensor(:,96))
  call loop_QZ_A(G3(:,:,:,185),wf(:,72),G3(:,:,:,192),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,192),Q(:,127),ZERO,G4tensor(:,97))
  call loop_QZ_A(G3(:,:,:,185),wf(:,72),G3(:,:,:,193),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,127),ZERO,G4tensor(:,98))
  call loop_QZ_A(G3(:,:,:,185),wf(:,73),G3(:,:,:,194),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,194),Q(:,127),ZERO,G4tensor(:,99))
  call loop_QZ_A(G3(:,:,:,185),wf(:,73),G3(:,:,:,195),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,195),Q(:,127),ZERO,G4tensor(:,100))
  call loop_QZ_A(G3(:,:,:,185),wf(:,74),G3(:,:,:,196),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,196),Q(:,127),ZERO,G4tensor(:,101))
  call loop_QZ_A(G3(:,:,:,185),wf(:,74),G3(:,:,:,197),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,197),Q(:,127),ZERO,G4tensor(:,102))
  call loop_QZ_A(G3(:,:,:,185),wf(:,75),G3(:,:,:,198),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,127),ZERO,G4tensor(:,103))
  call loop_QZ_A(G3(:,:,:,185),wf(:,75),G3(:,:,:,199),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,199),Q(:,127),ZERO,G4tensor(:,104))
  call loop_QZ_A(G3(:,:,:,185),wf(:,76),G3(:,:,:,200),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,200),Q(:,127),ZERO,G4tensor(:,105))
  call loop_QZ_A(G3(:,:,:,185),wf(:,76),G3(:,:,:,201),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,201),Q(:,127),ZERO,G4tensor(:,106))
  call loop_QZ_A(G2(:,:,:,117),wf(:,26),G2(:,:,:,121),gZu)
  call loop_Q_A(G2(:,:,:,121),Q(:,57),ZERO,G3(:,:,:,202))
  call loop_QV_A(G3(:,:,:,202),wf(:,-6),G3(:,:,:,203))
  call loop_Q_A(G3(:,:,:,203),Q(:,121),ZERO,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,27),G4(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,127),ZERO,G5tensor(:,39))
  call loop_QZ_A(G2(:,:,:,117),wf(:,26),G2(:,:,:,122),gZd)
  call loop_Q_A(G2(:,:,:,122),Q(:,57),ZERO,G3(:,:,:,204))
  call loop_QV_A(G3(:,:,:,204),wf(:,-6),G3(:,:,:,205))
  call loop_Q_A(G3(:,:,:,205),Q(:,121),ZERO,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,27),G4(:,:,:,80),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,127),ZERO,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,25),wf(:,-6),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,80),ZERO,G2(:,:,:,123))
  call loop_QZ_A(G2(:,:,:,123),wf(:,5),G2(:,:,:,124),gZu)
  call loop_Q_A(G2(:,:,:,124),Q(:,90),ZERO,G3(:,:,:,206))
  call loop_QV_A(G3(:,:,:,206),wf(:,-5),G3(:,:,:,207))
  call loop_Q_A(G3(:,:,:,207),Q(:,122),ZERO,G4(:,:,:,81))
  call loop_QZ_A(G4(:,:,:,81),wf(:,4),G4(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,127),ZERO,G5tensor(:,41))
  call loop_QZ_A(G2(:,:,:,123),wf(:,5),G2(:,:,:,125),gZd)
  call loop_Q_A(G2(:,:,:,125),Q(:,90),ZERO,G3(:,:,:,208))
  call loop_QV_A(G3(:,:,:,208),wf(:,-5),G3(:,:,:,209))
  call loop_Q_A(G3(:,:,:,209),Q(:,122),ZERO,G4(:,:,:,83))
  call loop_QZ_A(G4(:,:,:,83),wf(:,4),G4(:,:,:,84),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,127),ZERO,G5tensor(:,42))
  call loop_QV_A(G2(:,:,:,123),wf(:,-5),G2(:,:,:,126))
  call loop_Q_A(G2(:,:,:,126),Q(:,112),ZERO,G3(:,:,:,210))
  call loop_QZ_A(G3(:,:,:,210),wf(:,69),G3(:,:,:,211),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,211),Q(:,127),ZERO,G4tensor(:,107))
  call loop_QZ_A(G3(:,:,:,210),wf(:,69),G3(:,:,:,212),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,127),ZERO,G4tensor(:,108))
  call loop_QZ_A(G3(:,:,:,210),wf(:,70),G3(:,:,:,213),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,213),Q(:,127),ZERO,G4tensor(:,109))
  call loop_QZ_A(G3(:,:,:,210),wf(:,70),G3(:,:,:,214),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,214),Q(:,127),ZERO,G4tensor(:,110))
  call loop_QZ_A(G3(:,:,:,210),wf(:,71),G3(:,:,:,215),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,215),Q(:,127),ZERO,G4tensor(:,111))
  call loop_QZ_A(G3(:,:,:,210),wf(:,71),G3(:,:,:,216),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,216),Q(:,127),ZERO,G4tensor(:,112))
  call loop_QZ_A(G3(:,:,:,210),wf(:,72),G3(:,:,:,217),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,217),Q(:,127),ZERO,G4tensor(:,113))
  call loop_QZ_A(G3(:,:,:,210),wf(:,72),G3(:,:,:,218),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,127),ZERO,G4tensor(:,114))
  call loop_QZ_A(G3(:,:,:,210),wf(:,73),G3(:,:,:,219),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,219),Q(:,127),ZERO,G4tensor(:,115))
  call loop_QZ_A(G3(:,:,:,210),wf(:,73),G3(:,:,:,220),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,220),Q(:,127),ZERO,G4tensor(:,116))
  call loop_QZ_A(G3(:,:,:,210),wf(:,74),G3(:,:,:,221),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,221),Q(:,127),ZERO,G4tensor(:,117))
  call loop_QZ_A(G3(:,:,:,210),wf(:,74),G3(:,:,:,222),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,127),ZERO,G4tensor(:,118))
  call loop_QZ_A(G3(:,:,:,210),wf(:,75),G3(:,:,:,223),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,223),Q(:,127),ZERO,G4tensor(:,119))
  call loop_QZ_A(G3(:,:,:,210),wf(:,75),G3(:,:,:,224),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,127),ZERO,G4tensor(:,120))
  call loop_QZ_A(G3(:,:,:,210),wf(:,76),G3(:,:,:,225),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,127),ZERO,G4tensor(:,121))
  call loop_QZ_A(G3(:,:,:,210),wf(:,76),G3(:,:,:,226),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,226),Q(:,127),ZERO,G4tensor(:,122))
  call loop_QZ_A(G2(:,:,:,123),wf(:,26),G2(:,:,:,127),gZu)
  call loop_Q_A(G2(:,:,:,127),Q(:,89),ZERO,G3(:,:,:,227))
  call loop_QV_A(G3(:,:,:,227),wf(:,-5),G3(:,:,:,228))
  call loop_Q_A(G3(:,:,:,228),Q(:,121),ZERO,G4(:,:,:,85))
  call loop_QZ_A(G4(:,:,:,85),wf(:,27),G4(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,127),ZERO,G5tensor(:,43))
  call loop_QZ_A(G2(:,:,:,123),wf(:,26),G2(:,:,:,128),gZd)
  call loop_Q_A(G2(:,:,:,128),Q(:,89),ZERO,G3(:,:,:,229))
  call loop_QV_A(G3(:,:,:,229),wf(:,-5),G3(:,:,:,230))
  call loop_Q_A(G3(:,:,:,230),Q(:,121),ZERO,G4(:,:,:,87))
  call loop_QZ_A(G4(:,:,:,87),wf(:,27),G4(:,:,:,88),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,127),ZERO,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,25),wf(:,9),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,112),ZERO,G2(:,:,:,129))
  call loop_QZ_A(G2(:,:,:,129),wf(:,69),G2(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,127),ZERO,G3tensor(:,41))
  call loop_QZ_A(G2(:,:,:,129),wf(:,69),G2(:,:,:,131),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,127),ZERO,G3tensor(:,42))
  call loop_QZ_A(G2(:,:,:,129),wf(:,70),G2(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,127),ZERO,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,129),wf(:,70),G2(:,:,:,133),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,127),ZERO,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,129),wf(:,71),G2(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,127),ZERO,G3tensor(:,45))
  call loop_QZ_A(G2(:,:,:,129),wf(:,71),G2(:,:,:,135),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,127),ZERO,G3tensor(:,46))
  call loop_QZ_A(G2(:,:,:,129),wf(:,72),G2(:,:,:,136),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,127),ZERO,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,129),wf(:,72),G2(:,:,:,137),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,127),ZERO,G3tensor(:,48))
  call loop_QZ_A(G2(:,:,:,129),wf(:,73),G2(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,127),ZERO,G3tensor(:,49))
  call loop_QZ_A(G2(:,:,:,129),wf(:,73),G2(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,127),ZERO,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,129),wf(:,74),G2(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,127),ZERO,G3tensor(:,51))
  call loop_QZ_A(G2(:,:,:,129),wf(:,74),G2(:,:,:,141),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,127),ZERO,G3tensor(:,52))
  call loop_QZ_A(G2(:,:,:,129),wf(:,75),G2(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,127),ZERO,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,129),wf(:,75),G2(:,:,:,143),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,127),ZERO,G3tensor(:,54))
  call loop_QZ_A(G2(:,:,:,129),wf(:,76),G2(:,:,:,144),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,127),ZERO,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,129),wf(:,76),G2(:,:,:,145),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,127),ZERO,G3tensor(:,56))
  call loop_QZ_A(G1(:,:,:,25),wf(:,26),G1(:,:,:,31),gZu)
  call loop_Q_A(G1(:,:,:,31),Q(:,25),ZERO,G2(:,:,:,146))
  call loop_QV_A(G2(:,:,:,146),wf(:,9),G2(:,:,:,147))
  call loop_Q_A(G2(:,:,:,147),Q(:,121),ZERO,G3(:,:,:,231))
  call loop_QZ_A(G3(:,:,:,231),wf(:,27),G3(:,:,:,232),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,127),ZERO,G4tensor(:,123))
  call loop_QV_A(G2(:,:,:,146),wf(:,-5),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,57),ZERO,G3(:,:,:,233))
  call loop_QV_A(G3(:,:,:,233),wf(:,-6),G3(:,:,:,234))
  call loop_Q_A(G3(:,:,:,234),Q(:,121),ZERO,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,27),G4(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,127),ZERO,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,146),wf(:,-6),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,89),ZERO,G3(:,:,:,235))
  call loop_QV_A(G3(:,:,:,235),wf(:,-5),G3(:,:,:,236))
  call loop_Q_A(G3(:,:,:,236),Q(:,121),ZERO,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,27),G4(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,127),ZERO,G5tensor(:,46))
  call loop_QZ_A(G1(:,:,:,25),wf(:,26),G1(:,:,:,32),gZd)
  call loop_Q_A(G1(:,:,:,32),Q(:,25),ZERO,G2(:,:,:,150))
  call loop_QV_A(G2(:,:,:,150),wf(:,9),G2(:,:,:,151))
  call loop_Q_A(G2(:,:,:,151),Q(:,121),ZERO,G3(:,:,:,237))
  call loop_QZ_A(G3(:,:,:,237),wf(:,27),G3(:,:,:,238),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,238),Q(:,127),ZERO,G4tensor(:,124))
  call loop_QV_A(G2(:,:,:,150),wf(:,-5),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,57),ZERO,G3(:,:,:,239))
  call loop_QV_A(G3(:,:,:,239),wf(:,-6),G3(:,:,:,240))
  call loop_Q_A(G3(:,:,:,240),Q(:,121),ZERO,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,27),G4(:,:,:,94),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,127),ZERO,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,150),wf(:,-6),G2(:,:,:,153))
  call loop_Q_A(G2(:,:,:,153),Q(:,89),ZERO,G3(:,:,:,241))
  call loop_QV_A(G3(:,:,:,241),wf(:,-5),G3(:,:,:,242))
  call loop_Q_A(G3(:,:,:,242),Q(:,121),ZERO,G4(:,:,:,95))
  call loop_QZ_A(G4(:,:,:,95),wf(:,27),G4(:,:,:,96),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,127),ZERO,G5tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,16),ZERO,G1(:,:,:,33))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,5),G1(:,:,:,34),gZu)
  call loop_A_Q(G1(:,:,:,34),Q(:,26),ZERO,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,9),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,122),ZERO,G3(:,:,:,243))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,4),G3(:,:,:,244),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,244),Q(:,127),ZERO,G4tensor(:,125))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-6),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,90),ZERO,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,-5),G3(:,:,:,246))
  call loop_A_Q(G3(:,:,:,246),Q(:,122),ZERO,G4(:,:,:,97))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,4),G4(:,:,:,98),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,127),ZERO,G5tensor(:,49))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-5),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,58),ZERO,G3(:,:,:,247))
  call loop_AV_Q(G3(:,:,:,247),wf(:,-6),G3(:,:,:,248))
  call loop_A_Q(G3(:,:,:,248),Q(:,122),ZERO,G4(:,:,:,99))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,4),G4(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,127),ZERO,G5tensor(:,50))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,5),G1(:,:,:,35),gZd)
  call loop_A_Q(G1(:,:,:,35),Q(:,26),ZERO,G2(:,:,:,158))
  call loop_AV_Q(G2(:,:,:,158),wf(:,9),G2(:,:,:,159))
  call loop_A_Q(G2(:,:,:,159),Q(:,122),ZERO,G3(:,:,:,249))
  call loop_AZ_Q(G3(:,:,:,249),wf(:,4),G3(:,:,:,250),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,250),Q(:,127),ZERO,G4tensor(:,126))
  call loop_AV_Q(G2(:,:,:,158),wf(:,-6),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,90),ZERO,G3(:,:,:,251))
  call loop_AV_Q(G3(:,:,:,251),wf(:,-5),G3(:,:,:,252))
  call loop_A_Q(G3(:,:,:,252),Q(:,122),ZERO,G4(:,:,:,101))
  call loop_AZ_Q(G4(:,:,:,101),wf(:,4),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,127),ZERO,G5tensor(:,51))
  call loop_AV_Q(G2(:,:,:,158),wf(:,-5),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,58),ZERO,G3(:,:,:,253))
  call loop_AV_Q(G3(:,:,:,253),wf(:,-6),G3(:,:,:,254))
  call loop_A_Q(G3(:,:,:,254),Q(:,122),ZERO,G4(:,:,:,103))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,4),G4(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,127),ZERO,G5tensor(:,52))
  call loop_AV_Q(G1(:,:,:,33),wf(:,-5),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,48),ZERO,G2(:,:,:,162))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,5),G2(:,:,:,163),gZu)
  call loop_A_Q(G2(:,:,:,163),Q(:,58),ZERO,G3(:,:,:,255))
  call loop_AV_Q(G3(:,:,:,255),wf(:,-6),G3(:,:,:,256))
  call loop_A_Q(G3(:,:,:,256),Q(:,122),ZERO,G4(:,:,:,105))
  call loop_AZ_Q(G4(:,:,:,105),wf(:,4),G4(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,127),ZERO,G5tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,5),G2(:,:,:,164),gZd)
  call loop_A_Q(G2(:,:,:,164),Q(:,58),ZERO,G3(:,:,:,257))
  call loop_AV_Q(G3(:,:,:,257),wf(:,-6),G3(:,:,:,258))
  call loop_A_Q(G3(:,:,:,258),Q(:,122),ZERO,G4(:,:,:,107))
  call loop_AZ_Q(G4(:,:,:,107),wf(:,4),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,127),ZERO,G5tensor(:,54))
  call loop_AV_Q(G2(:,:,:,162),wf(:,-6),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,112),ZERO,G3(:,:,:,259))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,69),G3(:,:,:,260),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,260),Q(:,127),ZERO,G4tensor(:,127))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,69),G3(:,:,:,261),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,261),Q(:,127),ZERO,G4tensor(:,128))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,70),G3(:,:,:,262),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,127),ZERO,G4tensor(:,129))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,70),G3(:,:,:,263),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,263),Q(:,127),ZERO,G4tensor(:,130))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,71),G3(:,:,:,264),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,264),Q(:,127),ZERO,G4tensor(:,131))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,71),G3(:,:,:,265),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,265),Q(:,127),ZERO,G4tensor(:,132))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,72),G3(:,:,:,266),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,266),Q(:,127),ZERO,G4tensor(:,133))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,72),G3(:,:,:,267),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,267),Q(:,127),ZERO,G4tensor(:,134))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,73),G3(:,:,:,268),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,268),Q(:,127),ZERO,G4tensor(:,135))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,73),G3(:,:,:,269),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,269),Q(:,127),ZERO,G4tensor(:,136))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,74),G3(:,:,:,270),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,270),Q(:,127),ZERO,G4tensor(:,137))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,74),G3(:,:,:,271),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,271),Q(:,127),ZERO,G4tensor(:,138))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,75),G3(:,:,:,272),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,272),Q(:,127),ZERO,G4tensor(:,139))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,75),G3(:,:,:,273),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,273),Q(:,127),ZERO,G4tensor(:,140))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,76),G3(:,:,:,274),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,274),Q(:,127),ZERO,G4tensor(:,141))
  call loop_AZ_Q(G3(:,:,:,259),wf(:,76),G3(:,:,:,275),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,275),Q(:,127),ZERO,G4tensor(:,142))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,26),G2(:,:,:,166),gZu)
  call loop_A_Q(G2(:,:,:,166),Q(:,57),ZERO,G3(:,:,:,276))
  call loop_AV_Q(G3(:,:,:,276),wf(:,-6),G3(:,:,:,277))
  call loop_A_Q(G3(:,:,:,277),Q(:,121),ZERO,G4(:,:,:,109))
  call loop_AZ_Q(G4(:,:,:,109),wf(:,27),G4(:,:,:,110),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,127),ZERO,G5tensor(:,55))
  call loop_AZ_Q(G2(:,:,:,162),wf(:,26),G2(:,:,:,167),gZd)
  call loop_A_Q(G2(:,:,:,167),Q(:,57),ZERO,G3(:,:,:,278))
  call loop_AV_Q(G3(:,:,:,278),wf(:,-6),G3(:,:,:,279))
  call loop_A_Q(G3(:,:,:,279),Q(:,121),ZERO,G4(:,:,:,111))
  call loop_AZ_Q(G4(:,:,:,111),wf(:,27),G4(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,127),ZERO,G5tensor(:,56))
  call loop_AV_Q(G1(:,:,:,33),wf(:,-6),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,80),ZERO,G2(:,:,:,168))
  call loop_AZ_Q(G2(:,:,:,168),wf(:,5),G2(:,:,:,169),gZu)
  call loop_A_Q(G2(:,:,:,169),Q(:,90),ZERO,G3(:,:,:,280))
  call loop_AV_Q(G3(:,:,:,280),wf(:,-5),G3(:,:,:,281))
  call loop_A_Q(G3(:,:,:,281),Q(:,122),ZERO,G4(:,:,:,113))
  call loop_AZ_Q(G4(:,:,:,113),wf(:,4),G4(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,127),ZERO,G5tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,168),wf(:,5),G2(:,:,:,170),gZd)
  call loop_A_Q(G2(:,:,:,170),Q(:,90),ZERO,G3(:,:,:,282))
  call loop_AV_Q(G3(:,:,:,282),wf(:,-5),G3(:,:,:,283))
  call loop_A_Q(G3(:,:,:,283),Q(:,122),ZERO,G4(:,:,:,115))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,4),G4(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,127),ZERO,G5tensor(:,58))
  call loop_AV_Q(G2(:,:,:,168),wf(:,-5),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,112),ZERO,G3(:,:,:,284))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,69),G3(:,:,:,285),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,285),Q(:,127),ZERO,G4tensor(:,143))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,69),G3(:,:,:,286),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,286),Q(:,127),ZERO,G4tensor(:,144))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,70),G3(:,:,:,287),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,287),Q(:,127),ZERO,G4tensor(:,145))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,70),G3(:,:,:,288),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,288),Q(:,127),ZERO,G4tensor(:,146))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,71),G3(:,:,:,289),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,289),Q(:,127),ZERO,G4tensor(:,147))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,71),G3(:,:,:,290),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,290),Q(:,127),ZERO,G4tensor(:,148))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,72),G3(:,:,:,291),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,291),Q(:,127),ZERO,G4tensor(:,149))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,72),G3(:,:,:,292),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,292),Q(:,127),ZERO,G4tensor(:,150))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,73),G3(:,:,:,293),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,293),Q(:,127),ZERO,G4tensor(:,151))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,73),G3(:,:,:,294),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,127),ZERO,G4tensor(:,152))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,74),G3(:,:,:,295),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,295),Q(:,127),ZERO,G4tensor(:,153))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,74),G3(:,:,:,296),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,296),Q(:,127),ZERO,G4tensor(:,154))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,75),G3(:,:,:,297),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,297),Q(:,127),ZERO,G4tensor(:,155))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,75),G3(:,:,:,298),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,127),ZERO,G4tensor(:,156))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,76),G3(:,:,:,299),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,299),Q(:,127),ZERO,G4tensor(:,157))
  call loop_AZ_Q(G3(:,:,:,284),wf(:,76),G3(:,:,:,300),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,300),Q(:,127),ZERO,G4tensor(:,158))
  call loop_AZ_Q(G2(:,:,:,168),wf(:,26),G2(:,:,:,172),gZu)
  call loop_A_Q(G2(:,:,:,172),Q(:,89),ZERO,G3(:,:,:,301))
  call loop_AV_Q(G3(:,:,:,301),wf(:,-5),G3(:,:,:,302))
  call loop_A_Q(G3(:,:,:,302),Q(:,121),ZERO,G4(:,:,:,117))
  call loop_AZ_Q(G4(:,:,:,117),wf(:,27),G4(:,:,:,118),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,118),Q(:,127),ZERO,G5tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,168),wf(:,26),G2(:,:,:,173),gZd)
  call loop_A_Q(G2(:,:,:,173),Q(:,89),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,-5),G3(:,:,:,304))
  call loop_A_Q(G3(:,:,:,304),Q(:,121),ZERO,G4(:,:,:,119))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,27),G4(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,127),ZERO,G5tensor(:,60))
  call loop_AV_Q(G1(:,:,:,33),wf(:,9),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,112),ZERO,G2(:,:,:,174))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,69),G2(:,:,:,175),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,175),Q(:,127),ZERO,G3tensor(:,57))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,69),G2(:,:,:,176),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,176),Q(:,127),ZERO,G3tensor(:,58))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,70),G2(:,:,:,177),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,177),Q(:,127),ZERO,G3tensor(:,59))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,70),G2(:,:,:,178),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,127),ZERO,G3tensor(:,60))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,71),G2(:,:,:,179),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,179),Q(:,127),ZERO,G3tensor(:,61))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,71),G2(:,:,:,180),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,127),ZERO,G3tensor(:,62))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,72),G2(:,:,:,181),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,181),Q(:,127),ZERO,G3tensor(:,63))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,72),G2(:,:,:,182),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,127),ZERO,G3tensor(:,64))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,73),G2(:,:,:,183),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,183),Q(:,127),ZERO,G3tensor(:,65))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,73),G2(:,:,:,184),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,184),Q(:,127),ZERO,G3tensor(:,66))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,74),G2(:,:,:,185),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,185),Q(:,127),ZERO,G3tensor(:,67))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,74),G2(:,:,:,186),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,127),ZERO,G3tensor(:,68))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,75),G2(:,:,:,187),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,127),ZERO,G3tensor(:,69))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,75),G2(:,:,:,188),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,127),ZERO,G3tensor(:,70))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,76),G2(:,:,:,189),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,189),Q(:,127),ZERO,G3tensor(:,71))
  call loop_AZ_Q(G2(:,:,:,174),wf(:,76),G2(:,:,:,190),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,127),ZERO,G3tensor(:,72))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,26),G1(:,:,:,39),gZu)
  call loop_A_Q(G1(:,:,:,39),Q(:,25),ZERO,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,9),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,121),ZERO,G3(:,:,:,305))
  call loop_AZ_Q(G3(:,:,:,305),wf(:,27),G3(:,:,:,306),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,306),Q(:,127),ZERO,G4tensor(:,159))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-5),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,57),ZERO,G3(:,:,:,307))
  call loop_AV_Q(G3(:,:,:,307),wf(:,-6),G3(:,:,:,308))
  call loop_A_Q(G3(:,:,:,308),Q(:,121),ZERO,G4(:,:,:,121))
  call loop_AZ_Q(G4(:,:,:,121),wf(:,27),G4(:,:,:,122),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,122),Q(:,127),ZERO,G5tensor(:,61))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-6),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,89),ZERO,G3(:,:,:,309))
  call loop_AV_Q(G3(:,:,:,309),wf(:,-5),G3(:,:,:,310))
  call loop_A_Q(G3(:,:,:,310),Q(:,121),ZERO,G4(:,:,:,123))
  call loop_AZ_Q(G4(:,:,:,123),wf(:,27),G4(:,:,:,124),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,124),Q(:,127),ZERO,G5tensor(:,62))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,26),G1(:,:,:,40),gZd)
  call loop_A_Q(G1(:,:,:,40),Q(:,25),ZERO,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,9),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,121),ZERO,G3(:,:,:,311))
  call loop_AZ_Q(G3(:,:,:,311),wf(:,27),G3(:,:,:,312),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,312),Q(:,127),ZERO,G4tensor(:,160))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-5),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,57),ZERO,G3(:,:,:,313))
  call loop_AV_Q(G3(:,:,:,313),wf(:,-6),G3(:,:,:,314))
  call loop_A_Q(G3(:,:,:,314),Q(:,121),ZERO,G4(:,:,:,125))
  call loop_AZ_Q(G4(:,:,:,125),wf(:,27),G4(:,:,:,126),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,126),Q(:,127),ZERO,G5tensor(:,63))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-6),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,89),ZERO,G3(:,:,:,315))
  call loop_AV_Q(G3(:,:,:,315),wf(:,-5),G3(:,:,:,316))
  call loop_A_Q(G3(:,:,:,316),Q(:,121),ZERO,G4(:,:,:,127))
  call loop_AZ_Q(G4(:,:,:,127),wf(:,27),G4(:,:,:,128),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,128),Q(:,127),ZERO,G5tensor(:,64))
  call loop_QZ_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,8),gZu)
  call loop_Q_A(G0(:,:,:,8),Q(:,9),ZERO,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,-6),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,73),ZERO,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,3),G2(:,:,:,200))
  call loop_Q_A(G2(:,:,:,200),Q(:,121),ZERO,G3(:,:,:,317))
  call loop_QZ_A(G3(:,:,:,317),wf(:,27),G3(:,:,:,318),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,318),Q(:,127),ZERO,G4tensor(:,161))
  call loop_QV_A(G2(:,:,:,199),wf(:,-4),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,89),ZERO,G3(:,:,:,319))
  call loop_QV_A(G3(:,:,:,319),wf(:,-5),G3(:,:,:,320))
  call loop_Q_A(G3(:,:,:,320),Q(:,121),ZERO,G4(:,:,:,129))
  call loop_QZ_A(G4(:,:,:,129),wf(:,27),G4(:,:,:,130),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,127),ZERO,G5tensor(:,65))
  call loop_QV_A(G2(:,:,:,199),wf(:,-5),G2(:,:,:,202))
  call loop_Q_A(G2(:,:,:,202),Q(:,105),ZERO,G3(:,:,:,321))
  call loop_QV_A(G3(:,:,:,321),wf(:,-4),G3(:,:,:,322))
  call loop_Q_A(G3(:,:,:,322),Q(:,121),ZERO,G4(:,:,:,131))
  call loop_QZ_A(G4(:,:,:,131),wf(:,27),G4(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,127),ZERO,G5tensor(:,66))
  call loop_QV_A(G1(:,:,:,41),wf(:,3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,57),ZERO,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,-6),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,121),ZERO,G3(:,:,:,323))
  call loop_QZ_A(G3(:,:,:,323),wf(:,27),G3(:,:,:,324),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,324),Q(:,127),ZERO,G4tensor(:,162))
  call loop_QV_A(G1(:,:,:,41),wf(:,-5),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,41),ZERO,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,7),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,121),ZERO,G3(:,:,:,325))
  call loop_QZ_A(G3(:,:,:,325),wf(:,27),G3(:,:,:,326),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,326),Q(:,127),ZERO,G4tensor(:,163))
  call loop_QV_A(G2(:,:,:,205),wf(:,-4),G2(:,:,:,207))
  call loop_Q_A(G2(:,:,:,207),Q(:,57),ZERO,G3(:,:,:,327))
  call loop_QV_A(G3(:,:,:,327),wf(:,-6),G3(:,:,:,328))
  call loop_Q_A(G3(:,:,:,328),Q(:,121),ZERO,G4(:,:,:,133))
  call loop_QZ_A(G4(:,:,:,133),wf(:,27),G4(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,127),ZERO,G5tensor(:,67))
  call loop_QV_A(G2(:,:,:,205),wf(:,-6),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,105),ZERO,G3(:,:,:,329))
  call loop_QV_A(G3(:,:,:,329),wf(:,-4),G3(:,:,:,330))
  call loop_Q_A(G3(:,:,:,330),Q(:,121),ZERO,G4(:,:,:,135))
  call loop_QZ_A(G4(:,:,:,135),wf(:,27),G4(:,:,:,136),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,127),ZERO,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,41),wf(:,7),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,89),ZERO,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,-5),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,121),ZERO,G3(:,:,:,331))
  call loop_QZ_A(G3(:,:,:,331),wf(:,27),G3(:,:,:,332),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,332),Q(:,127),ZERO,G4tensor(:,164))
  call loop_QV_A(G1(:,:,:,41),wf(:,-4),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,25),ZERO,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,9),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,121),ZERO,G3(:,:,:,333))
  call loop_QZ_A(G3(:,:,:,333),wf(:,27),G3(:,:,:,334),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,334),Q(:,127),ZERO,G4tensor(:,165))
  call loop_QV_A(G2(:,:,:,211),wf(:,-5),G2(:,:,:,213))
  call loop_Q_A(G2(:,:,:,213),Q(:,57),ZERO,G3(:,:,:,335))
  call loop_QV_A(G3(:,:,:,335),wf(:,-6),G3(:,:,:,336))
  call loop_Q_A(G3(:,:,:,336),Q(:,121),ZERO,G4(:,:,:,137))
  call loop_QZ_A(G4(:,:,:,137),wf(:,27),G4(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,127),ZERO,G5tensor(:,69))
  call loop_QV_A(G2(:,:,:,211),wf(:,-6),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,89),ZERO,G3(:,:,:,337))
  call loop_QV_A(G3(:,:,:,337),wf(:,-5),G3(:,:,:,338))
  call loop_Q_A(G3(:,:,:,338),Q(:,121),ZERO,G4(:,:,:,139))
  call loop_QZ_A(G4(:,:,:,139),wf(:,27),G4(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,127),ZERO,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,41),wf(:,9),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,105),ZERO,G2(:,:,:,215))
  call loop_QV_A(G2(:,:,:,215),wf(:,-4),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,121),ZERO,G3(:,:,:,339))
  call loop_QZ_A(G3(:,:,:,339),wf(:,27),G3(:,:,:,340),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,340),Q(:,127),ZERO,G4tensor(:,166))
  call loop_QZ_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,9),gZu)
  call loop_Q_A(G0(:,:,:,9),Q(:,9),MT,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,-6),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,73),MT,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,3),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,121),MT,G3(:,:,:,341))
  call loop_QZ_A(G3(:,:,:,341),wf(:,27),G3(:,:,:,342),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,127),MT,G4tensor(:,167))
  call loop_QV_A(G2(:,:,:,217),wf(:,-4),G2(:,:,:,219))
  call loop_Q_A(G2(:,:,:,219),Q(:,89),MT,G3(:,:,:,343))
  call loop_QV_A(G3(:,:,:,343),wf(:,-5),G3(:,:,:,344))
  call loop_Q_A(G3(:,:,:,344),Q(:,121),MT,G4(:,:,:,141))
  call loop_QZ_A(G4(:,:,:,141),wf(:,27),G4(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,127),MT,G5tensor(:,71))
  call loop_QV_A(G2(:,:,:,217),wf(:,-5),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,105),MT,G3(:,:,:,345))
  call loop_QV_A(G3(:,:,:,345),wf(:,-4),G3(:,:,:,346))
  call loop_Q_A(G3(:,:,:,346),Q(:,121),MT,G4(:,:,:,143))
  call loop_QZ_A(G4(:,:,:,143),wf(:,27),G4(:,:,:,144),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,127),MT,G5tensor(:,72))
  call loop_QV_A(G1(:,:,:,48),wf(:,3),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,57),MT,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,-6),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,121),MT,G3(:,:,:,347))
  call loop_QZ_A(G3(:,:,:,347),wf(:,27),G3(:,:,:,348),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,348),Q(:,127),MT,G4tensor(:,168))
  call loop_QV_A(G1(:,:,:,48),wf(:,-5),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,41),MT,G2(:,:,:,223))
  call loop_QV_A(G2(:,:,:,223),wf(:,7),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,121),MT,G3(:,:,:,349))
  call loop_QZ_A(G3(:,:,:,349),wf(:,27),G3(:,:,:,350),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,350),Q(:,127),MT,G4tensor(:,169))
  call loop_QV_A(G2(:,:,:,223),wf(:,-4),G2(:,:,:,225))
  call loop_Q_A(G2(:,:,:,225),Q(:,57),MT,G3(:,:,:,351))
  call loop_QV_A(G3(:,:,:,351),wf(:,-6),G3(:,:,:,352))
  call loop_Q_A(G3(:,:,:,352),Q(:,121),MT,G4(:,:,:,145))
  call loop_QZ_A(G4(:,:,:,145),wf(:,27),G4(:,:,:,146),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,146),Q(:,127),MT,G5tensor(:,73))
  call loop_QV_A(G2(:,:,:,223),wf(:,-6),G2(:,:,:,226))
  call loop_Q_A(G2(:,:,:,226),Q(:,105),MT,G3(:,:,:,353))
  call loop_QV_A(G3(:,:,:,353),wf(:,-4),G3(:,:,:,354))
  call loop_Q_A(G3(:,:,:,354),Q(:,121),MT,G4(:,:,:,147))
  call loop_QZ_A(G4(:,:,:,147),wf(:,27),G4(:,:,:,148),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,148),Q(:,127),MT,G5tensor(:,74))
  call loop_QV_A(G1(:,:,:,48),wf(:,7),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,89),MT,G2(:,:,:,227))
  call loop_QV_A(G2(:,:,:,227),wf(:,-5),G2(:,:,:,228))
  call loop_Q_A(G2(:,:,:,228),Q(:,121),MT,G3(:,:,:,355))
  call loop_QZ_A(G3(:,:,:,355),wf(:,27),G3(:,:,:,356),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,356),Q(:,127),MT,G4tensor(:,170))
  call loop_QV_A(G1(:,:,:,48),wf(:,-4),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,25),MT,G2(:,:,:,229))
  call loop_QV_A(G2(:,:,:,229),wf(:,9),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,121),MT,G3(:,:,:,357))
  call loop_QZ_A(G3(:,:,:,357),wf(:,27),G3(:,:,:,358),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,358),Q(:,127),MT,G4tensor(:,171))
  call loop_QV_A(G2(:,:,:,229),wf(:,-5),G2(:,:,:,231))
  call loop_Q_A(G2(:,:,:,231),Q(:,57),MT,G3(:,:,:,359))
  call loop_QV_A(G3(:,:,:,359),wf(:,-6),G3(:,:,:,360))
  call loop_Q_A(G3(:,:,:,360),Q(:,121),MT,G4(:,:,:,149))
  call loop_QZ_A(G4(:,:,:,149),wf(:,27),G4(:,:,:,150),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,150),Q(:,127),MT,G5tensor(:,75))
  call loop_QV_A(G2(:,:,:,229),wf(:,-6),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,89),MT,G3(:,:,:,361))
  call loop_QV_A(G3(:,:,:,361),wf(:,-5),G3(:,:,:,362))
  call loop_Q_A(G3(:,:,:,362),Q(:,121),MT,G4(:,:,:,151))
  call loop_QZ_A(G4(:,:,:,151),wf(:,27),G4(:,:,:,152),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,152),Q(:,127),MT,G5tensor(:,76))
  call loop_QV_A(G1(:,:,:,48),wf(:,9),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,105),MT,G2(:,:,:,233))
  call loop_QV_A(G2(:,:,:,233),wf(:,-4),G2(:,:,:,234))
  call loop_Q_A(G2(:,:,:,234),Q(:,121),MT,G3(:,:,:,363))
  call loop_QZ_A(G3(:,:,:,363),wf(:,27),G3(:,:,:,364),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,364),Q(:,127),MT,G4tensor(:,172))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,26),G0(:,:,:,10),gZu)
  call loop_A_Q(G0(:,:,:,10),Q(:,9),ZERO,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-6),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,73),ZERO,G2(:,:,:,235))
  call loop_AV_Q(G2(:,:,:,235),wf(:,3),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,121),ZERO,G3(:,:,:,365))
  call loop_AZ_Q(G3(:,:,:,365),wf(:,27),G3(:,:,:,366),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,366),Q(:,127),ZERO,G4tensor(:,173))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-4),G2(:,:,:,237))
  call loop_A_Q(G2(:,:,:,237),Q(:,89),ZERO,G3(:,:,:,367))
  call loop_AV_Q(G3(:,:,:,367),wf(:,-5),G3(:,:,:,368))
  call loop_A_Q(G3(:,:,:,368),Q(:,121),ZERO,G4(:,:,:,153))
  call loop_AZ_Q(G4(:,:,:,153),wf(:,27),G4(:,:,:,154),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,154),Q(:,127),ZERO,G5tensor(:,77))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-5),G2(:,:,:,238))
  call loop_A_Q(G2(:,:,:,238),Q(:,105),ZERO,G3(:,:,:,369))
  call loop_AV_Q(G3(:,:,:,369),wf(:,-4),G3(:,:,:,370))
  call loop_A_Q(G3(:,:,:,370),Q(:,121),ZERO,G4(:,:,:,155))
  call loop_AZ_Q(G4(:,:,:,155),wf(:,27),G4(:,:,:,156),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,156),Q(:,127),ZERO,G5tensor(:,78))
  call loop_AV_Q(G1(:,:,:,55),wf(:,3),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,57),ZERO,G2(:,:,:,239))
  call loop_AV_Q(G2(:,:,:,239),wf(:,-6),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,121),ZERO,G3(:,:,:,371))
  call loop_AZ_Q(G3(:,:,:,371),wf(:,27),G3(:,:,:,372),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,372),Q(:,127),ZERO,G4tensor(:,174))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,41),ZERO,G2(:,:,:,241))
  call loop_AV_Q(G2(:,:,:,241),wf(:,7),G2(:,:,:,242))
  call loop_A_Q(G2(:,:,:,242),Q(:,121),ZERO,G3(:,:,:,373))
  call loop_AZ_Q(G3(:,:,:,373),wf(:,27),G3(:,:,:,374),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,374),Q(:,127),ZERO,G4tensor(:,175))
  call loop_AV_Q(G2(:,:,:,241),wf(:,-4),G2(:,:,:,243))
  call loop_A_Q(G2(:,:,:,243),Q(:,57),ZERO,G3(:,:,:,375))
  call loop_AV_Q(G3(:,:,:,375),wf(:,-6),G3(:,:,:,376))
  call loop_A_Q(G3(:,:,:,376),Q(:,121),ZERO,G4(:,:,:,157))
  call loop_AZ_Q(G4(:,:,:,157),wf(:,27),G4(:,:,:,158),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,158),Q(:,127),ZERO,G5tensor(:,79))
  call loop_AV_Q(G2(:,:,:,241),wf(:,-6),G2(:,:,:,244))
  call loop_A_Q(G2(:,:,:,244),Q(:,105),ZERO,G3(:,:,:,377))
  call loop_AV_Q(G3(:,:,:,377),wf(:,-4),G3(:,:,:,378))
  call loop_A_Q(G3(:,:,:,378),Q(:,121),ZERO,G4(:,:,:,159))
  call loop_AZ_Q(G4(:,:,:,159),wf(:,27),G4(:,:,:,160),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,160),Q(:,127),ZERO,G5tensor(:,80))
  call loop_AV_Q(G1(:,:,:,55),wf(:,7),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,89),ZERO,G2(:,:,:,245))
  call loop_AV_Q(G2(:,:,:,245),wf(:,-5),G2(:,:,:,246))
  call loop_A_Q(G2(:,:,:,246),Q(:,121),ZERO,G3(:,:,:,379))
  call loop_AZ_Q(G3(:,:,:,379),wf(:,27),G3(:,:,:,380),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,380),Q(:,127),ZERO,G4tensor(:,176))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-4),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,25),ZERO,G2(:,:,:,247))
  call loop_AV_Q(G2(:,:,:,247),wf(:,9),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,121),ZERO,G3(:,:,:,381))
  call loop_AZ_Q(G3(:,:,:,381),wf(:,27),G3(:,:,:,382),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,382),Q(:,127),ZERO,G4tensor(:,177))
  call loop_AV_Q(G2(:,:,:,247),wf(:,-5),G2(:,:,:,249))
  call loop_A_Q(G2(:,:,:,249),Q(:,57),ZERO,G3(:,:,:,383))
  call loop_AV_Q(G3(:,:,:,383),wf(:,-6),G3(:,:,:,384))
  call loop_A_Q(G3(:,:,:,384),Q(:,121),ZERO,G4(:,:,:,161))
  call loop_AZ_Q(G4(:,:,:,161),wf(:,27),G4(:,:,:,162),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,162),Q(:,127),ZERO,G5tensor(:,81))
  call loop_AV_Q(G2(:,:,:,247),wf(:,-6),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,89),ZERO,G3(:,:,:,385))
  call loop_AV_Q(G3(:,:,:,385),wf(:,-5),G3(:,:,:,386))
  call loop_A_Q(G3(:,:,:,386),Q(:,121),ZERO,G4(:,:,:,163))
  call loop_AZ_Q(G4(:,:,:,163),wf(:,27),G4(:,:,:,164),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,164),Q(:,127),ZERO,G5tensor(:,82))
  call loop_AV_Q(G1(:,:,:,55),wf(:,9),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,105),ZERO,G2(:,:,:,251))
  call loop_AV_Q(G2(:,:,:,251),wf(:,-4),G2(:,:,:,252))
  call loop_A_Q(G2(:,:,:,252),Q(:,121),ZERO,G3(:,:,:,387))
  call loop_AZ_Q(G3(:,:,:,387),wf(:,27),G3(:,:,:,388),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,388),Q(:,127),ZERO,G4tensor(:,178))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,26),G0(:,:,:,11),gZu)
  call loop_A_Q(G0(:,:,:,11),Q(:,9),MT,G1(:,:,:,62))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-6),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,73),MT,G2(:,:,:,253))
  call loop_AV_Q(G2(:,:,:,253),wf(:,3),G2(:,:,:,254))
  call loop_A_Q(G2(:,:,:,254),Q(:,121),MT,G3(:,:,:,389))
  call loop_AZ_Q(G3(:,:,:,389),wf(:,27),G3(:,:,:,390),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,390),Q(:,127),MT,G4tensor(:,179))
  call loop_AV_Q(G2(:,:,:,253),wf(:,-4),G2(:,:,:,255))
  call loop_A_Q(G2(:,:,:,255),Q(:,89),MT,G3(:,:,:,391))
  call loop_AV_Q(G3(:,:,:,391),wf(:,-5),G3(:,:,:,392))
  call loop_A_Q(G3(:,:,:,392),Q(:,121),MT,G4(:,:,:,165))
  call loop_AZ_Q(G4(:,:,:,165),wf(:,27),G4(:,:,:,166),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,166),Q(:,127),MT,G5tensor(:,83))
  call loop_AV_Q(G2(:,:,:,253),wf(:,-5),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,105),MT,G3(:,:,:,393))
  call loop_AV_Q(G3(:,:,:,393),wf(:,-4),G3(:,:,:,394))
  call loop_A_Q(G3(:,:,:,394),Q(:,121),MT,G4(:,:,:,167))
  call loop_AZ_Q(G4(:,:,:,167),wf(:,27),G4(:,:,:,168),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,168),Q(:,127),MT,G5tensor(:,84))
  call loop_AV_Q(G1(:,:,:,62),wf(:,3),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,57),MT,G2(:,:,:,257))
  call loop_AV_Q(G2(:,:,:,257),wf(:,-6),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,121),MT,G3(:,:,:,395))
  call loop_AZ_Q(G3(:,:,:,395),wf(:,27),G3(:,:,:,396),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,396),Q(:,127),MT,G4tensor(:,180))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-5),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,41),MT,G2(:,:,:,259))
  call loop_AV_Q(G2(:,:,:,259),wf(:,7),G2(:,:,:,260))
  call loop_A_Q(G2(:,:,:,260),Q(:,121),MT,G3(:,:,:,397))
  call loop_AZ_Q(G3(:,:,:,397),wf(:,27),G3(:,:,:,398),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,398),Q(:,127),MT,G4tensor(:,181))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-4),G2(:,:,:,261))
  call loop_A_Q(G2(:,:,:,261),Q(:,57),MT,G3(:,:,:,399))
  call loop_AV_Q(G3(:,:,:,399),wf(:,-6),G3(:,:,:,400))
  call loop_A_Q(G3(:,:,:,400),Q(:,121),MT,G4(:,:,:,169))
  call loop_AZ_Q(G4(:,:,:,169),wf(:,27),G4(:,:,:,170),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,170),Q(:,127),MT,G5tensor(:,85))
  call loop_AV_Q(G2(:,:,:,259),wf(:,-6),G2(:,:,:,262))
  call loop_A_Q(G2(:,:,:,262),Q(:,105),MT,G3(:,:,:,401))
  call loop_AV_Q(G3(:,:,:,401),wf(:,-4),G3(:,:,:,402))
  call loop_A_Q(G3(:,:,:,402),Q(:,121),MT,G4(:,:,:,171))
  call loop_AZ_Q(G4(:,:,:,171),wf(:,27),G4(:,:,:,172),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,172),Q(:,127),MT,G5tensor(:,86))
  call loop_AV_Q(G1(:,:,:,62),wf(:,7),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,89),MT,G2(:,:,:,263))
  call loop_AV_Q(G2(:,:,:,263),wf(:,-5),G2(:,:,:,264))
  call loop_A_Q(G2(:,:,:,264),Q(:,121),MT,G3(:,:,:,403))
  call loop_AZ_Q(G3(:,:,:,403),wf(:,27),G3(:,:,:,404),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,404),Q(:,127),MT,G4tensor(:,182))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-4),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,25),MT,G2(:,:,:,265))
  call loop_AV_Q(G2(:,:,:,265),wf(:,9),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,121),MT,G3(:,:,:,405))
  call loop_AZ_Q(G3(:,:,:,405),wf(:,27),G3(:,:,:,406),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,406),Q(:,127),MT,G4tensor(:,183))
  call loop_AV_Q(G2(:,:,:,265),wf(:,-5),G2(:,:,:,267))
  call loop_A_Q(G2(:,:,:,267),Q(:,57),MT,G3(:,:,:,407))
  call loop_AV_Q(G3(:,:,:,407),wf(:,-6),G3(:,:,:,408))
  call loop_A_Q(G3(:,:,:,408),Q(:,121),MT,G4(:,:,:,173))
  call loop_AZ_Q(G4(:,:,:,173),wf(:,27),G4(:,:,:,174),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,174),Q(:,127),MT,G5tensor(:,87))
  call loop_AV_Q(G2(:,:,:,265),wf(:,-6),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,89),MT,G3(:,:,:,409))
  call loop_AV_Q(G3(:,:,:,409),wf(:,-5),G3(:,:,:,410))
  call loop_A_Q(G3(:,:,:,410),Q(:,121),MT,G4(:,:,:,175))
  call loop_AZ_Q(G4(:,:,:,175),wf(:,27),G4(:,:,:,176),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,176),Q(:,127),MT,G5tensor(:,88))
  call loop_AV_Q(G1(:,:,:,62),wf(:,9),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,105),MT,G2(:,:,:,269))
  call loop_AV_Q(G2(:,:,:,269),wf(:,-4),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,121),MT,G3(:,:,:,411))
  call loop_AZ_Q(G3(:,:,:,411),wf(:,27),G3(:,:,:,412),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,412),Q(:,127),MT,G4tensor(:,184))
  call loop_QZ_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,12),gZd)
  call loop_Q_A(G0(:,:,:,12),Q(:,9),ZERO,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,-6),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,73),ZERO,G2(:,:,:,271))
  call loop_QV_A(G2(:,:,:,271),wf(:,3),G2(:,:,:,272))
  call loop_Q_A(G2(:,:,:,272),Q(:,121),ZERO,G3(:,:,:,413))
  call loop_QZ_A(G3(:,:,:,413),wf(:,27),G3(:,:,:,414),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,414),Q(:,127),ZERO,G4tensor(:,185))
  call loop_QV_A(G2(:,:,:,271),wf(:,-4),G2(:,:,:,273))
  call loop_Q_A(G2(:,:,:,273),Q(:,89),ZERO,G3(:,:,:,415))
  call loop_QV_A(G3(:,:,:,415),wf(:,-5),G3(:,:,:,416))
  call loop_Q_A(G3(:,:,:,416),Q(:,121),ZERO,G4(:,:,:,177))
  call loop_QZ_A(G4(:,:,:,177),wf(:,27),G4(:,:,:,178),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,178),Q(:,127),ZERO,G5tensor(:,89))
  call loop_QV_A(G2(:,:,:,271),wf(:,-5),G2(:,:,:,274))
  call loop_Q_A(G2(:,:,:,274),Q(:,105),ZERO,G3(:,:,:,417))
  call loop_QV_A(G3(:,:,:,417),wf(:,-4),G3(:,:,:,418))
  call loop_Q_A(G3(:,:,:,418),Q(:,121),ZERO,G4(:,:,:,179))
  call loop_QZ_A(G4(:,:,:,179),wf(:,27),G4(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,180),Q(:,127),ZERO,G5tensor(:,90))
  call loop_QV_A(G1(:,:,:,69),wf(:,3),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,57),ZERO,G2(:,:,:,275))
  call loop_QV_A(G2(:,:,:,275),wf(:,-6),G2(:,:,:,276))
  call loop_Q_A(G2(:,:,:,276),Q(:,121),ZERO,G3(:,:,:,419))
  call loop_QZ_A(G3(:,:,:,419),wf(:,27),G3(:,:,:,420),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,420),Q(:,127),ZERO,G4tensor(:,186))
  call loop_QV_A(G1(:,:,:,69),wf(:,-5),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,41),ZERO,G2(:,:,:,277))
  call loop_QV_A(G2(:,:,:,277),wf(:,7),G2(:,:,:,278))
  call loop_Q_A(G2(:,:,:,278),Q(:,121),ZERO,G3(:,:,:,421))
  call loop_QZ_A(G3(:,:,:,421),wf(:,27),G3(:,:,:,422),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,422),Q(:,127),ZERO,G4tensor(:,187))
  call loop_QV_A(G2(:,:,:,277),wf(:,-4),G2(:,:,:,279))
  call loop_Q_A(G2(:,:,:,279),Q(:,57),ZERO,G3(:,:,:,423))
  call loop_QV_A(G3(:,:,:,423),wf(:,-6),G3(:,:,:,424))
  call loop_Q_A(G3(:,:,:,424),Q(:,121),ZERO,G4(:,:,:,181))
  call loop_QZ_A(G4(:,:,:,181),wf(:,27),G4(:,:,:,182),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,182),Q(:,127),ZERO,G5tensor(:,91))
  call loop_QV_A(G2(:,:,:,277),wf(:,-6),G2(:,:,:,280))
  call loop_Q_A(G2(:,:,:,280),Q(:,105),ZERO,G3(:,:,:,425))
  call loop_QV_A(G3(:,:,:,425),wf(:,-4),G3(:,:,:,426))
  call loop_Q_A(G3(:,:,:,426),Q(:,121),ZERO,G4(:,:,:,183))
  call loop_QZ_A(G4(:,:,:,183),wf(:,27),G4(:,:,:,184),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,184),Q(:,127),ZERO,G5tensor(:,92))
  call loop_QV_A(G1(:,:,:,69),wf(:,7),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,89),ZERO,G2(:,:,:,281))
  call loop_QV_A(G2(:,:,:,281),wf(:,-5),G2(:,:,:,282))
  call loop_Q_A(G2(:,:,:,282),Q(:,121),ZERO,G3(:,:,:,427))
  call loop_QZ_A(G3(:,:,:,427),wf(:,27),G3(:,:,:,428),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,428),Q(:,127),ZERO,G4tensor(:,188))
  call loop_QV_A(G1(:,:,:,69),wf(:,-4),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,25),ZERO,G2(:,:,:,283))
  call loop_QV_A(G2(:,:,:,283),wf(:,9),G2(:,:,:,284))
  call loop_Q_A(G2(:,:,:,284),Q(:,121),ZERO,G3(:,:,:,429))
  call loop_QZ_A(G3(:,:,:,429),wf(:,27),G3(:,:,:,430),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,430),Q(:,127),ZERO,G4tensor(:,189))
  call loop_QV_A(G2(:,:,:,283),wf(:,-5),G2(:,:,:,285))
  call loop_Q_A(G2(:,:,:,285),Q(:,57),ZERO,G3(:,:,:,431))
  call loop_QV_A(G3(:,:,:,431),wf(:,-6),G3(:,:,:,432))
  call loop_Q_A(G3(:,:,:,432),Q(:,121),ZERO,G4(:,:,:,185))
  call loop_QZ_A(G4(:,:,:,185),wf(:,27),G4(:,:,:,186),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,186),Q(:,127),ZERO,G5tensor(:,93))
  call loop_QV_A(G2(:,:,:,283),wf(:,-6),G2(:,:,:,286))
  call loop_Q_A(G2(:,:,:,286),Q(:,89),ZERO,G3(:,:,:,433))
  call loop_QV_A(G3(:,:,:,433),wf(:,-5),G3(:,:,:,434))
  call loop_Q_A(G3(:,:,:,434),Q(:,121),ZERO,G4(:,:,:,187))
  call loop_QZ_A(G4(:,:,:,187),wf(:,27),G4(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,188),Q(:,127),ZERO,G5tensor(:,94))
  call loop_QV_A(G1(:,:,:,69),wf(:,9),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,105),ZERO,G2(:,:,:,287))
  call loop_QV_A(G2(:,:,:,287),wf(:,-4),G2(:,:,:,288))
  call loop_Q_A(G2(:,:,:,288),Q(:,121),ZERO,G3(:,:,:,435))
  call loop_QZ_A(G3(:,:,:,435),wf(:,27),G3(:,:,:,436),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,436),Q(:,127),ZERO,G4tensor(:,190))
  call loop_QZ_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,13),gZd)
  call loop_Q_A(G0(:,:,:,13),Q(:,9),MB,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,-6),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,73),MB,G2(:,:,:,289))
  call loop_QV_A(G2(:,:,:,289),wf(:,3),G2(:,:,:,290))
  call loop_Q_A(G2(:,:,:,290),Q(:,121),MB,G3(:,:,:,437))
  call loop_QZ_A(G3(:,:,:,437),wf(:,27),G3(:,:,:,438),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,438),Q(:,127),MB,G4tensor(:,191))
  call loop_QV_A(G2(:,:,:,289),wf(:,-4),G2(:,:,:,291))
  call loop_Q_A(G2(:,:,:,291),Q(:,89),MB,G3(:,:,:,439))
  call loop_QV_A(G3(:,:,:,439),wf(:,-5),G3(:,:,:,440))
  call loop_Q_A(G3(:,:,:,440),Q(:,121),MB,G4(:,:,:,189))
  call loop_QZ_A(G4(:,:,:,189),wf(:,27),G4(:,:,:,190),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,190),Q(:,127),MB,G5tensor(:,95))
  call loop_QV_A(G2(:,:,:,289),wf(:,-5),G2(:,:,:,292))
  call loop_Q_A(G2(:,:,:,292),Q(:,105),MB,G3(:,:,:,441))
  call loop_QV_A(G3(:,:,:,441),wf(:,-4),G3(:,:,:,442))
  call loop_Q_A(G3(:,:,:,442),Q(:,121),MB,G4(:,:,:,191))
  call loop_QZ_A(G4(:,:,:,191),wf(:,27),G4(:,:,:,192),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,192),Q(:,127),MB,G5tensor(:,96))
  call loop_QV_A(G1(:,:,:,76),wf(:,3),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,57),MB,G2(:,:,:,293))
  call loop_QV_A(G2(:,:,:,293),wf(:,-6),G2(:,:,:,294))
  call loop_Q_A(G2(:,:,:,294),Q(:,121),MB,G3(:,:,:,443))
  call loop_QZ_A(G3(:,:,:,443),wf(:,27),G3(:,:,:,444),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,444),Q(:,127),MB,G4tensor(:,192))
  call loop_QV_A(G1(:,:,:,76),wf(:,-5),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,41),MB,G2(:,:,:,295))
  call loop_QV_A(G2(:,:,:,295),wf(:,7),G2(:,:,:,296))
  call loop_Q_A(G2(:,:,:,296),Q(:,121),MB,G3(:,:,:,445))
  call loop_QZ_A(G3(:,:,:,445),wf(:,27),G3(:,:,:,446),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,446),Q(:,127),MB,G4tensor(:,193))
  call loop_QV_A(G2(:,:,:,295),wf(:,-4),G2(:,:,:,297))
  call loop_Q_A(G2(:,:,:,297),Q(:,57),MB,G3(:,:,:,447))
  call loop_QV_A(G3(:,:,:,447),wf(:,-6),G3(:,:,:,448))
  call loop_Q_A(G3(:,:,:,448),Q(:,121),MB,G4(:,:,:,193))
  call loop_QZ_A(G4(:,:,:,193),wf(:,27),G4(:,:,:,194),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,194),Q(:,127),MB,G5tensor(:,97))
  call loop_QV_A(G2(:,:,:,295),wf(:,-6),G2(:,:,:,298))
  call loop_Q_A(G2(:,:,:,298),Q(:,105),MB,G3(:,:,:,449))
  call loop_QV_A(G3(:,:,:,449),wf(:,-4),G3(:,:,:,450))
  call loop_Q_A(G3(:,:,:,450),Q(:,121),MB,G4(:,:,:,195))
  call loop_QZ_A(G4(:,:,:,195),wf(:,27),G4(:,:,:,196),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,196),Q(:,127),MB,G5tensor(:,98))
  call loop_QV_A(G1(:,:,:,76),wf(:,7),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,89),MB,G2(:,:,:,299))
  call loop_QV_A(G2(:,:,:,299),wf(:,-5),G2(:,:,:,300))
  call loop_Q_A(G2(:,:,:,300),Q(:,121),MB,G3(:,:,:,451))
  call loop_QZ_A(G3(:,:,:,451),wf(:,27),G3(:,:,:,452),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,452),Q(:,127),MB,G4tensor(:,194))
  call loop_QV_A(G1(:,:,:,76),wf(:,-4),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,25),MB,G2(:,:,:,301))
  call loop_QV_A(G2(:,:,:,301),wf(:,9),G2(:,:,:,302))
  call loop_Q_A(G2(:,:,:,302),Q(:,121),MB,G3(:,:,:,453))
  call loop_QZ_A(G3(:,:,:,453),wf(:,27),G3(:,:,:,454),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,454),Q(:,127),MB,G4tensor(:,195))
  call loop_QV_A(G2(:,:,:,301),wf(:,-5),G2(:,:,:,303))
  call loop_Q_A(G2(:,:,:,303),Q(:,57),MB,G3(:,:,:,455))
  call loop_QV_A(G3(:,:,:,455),wf(:,-6),G3(:,:,:,456))
  call loop_Q_A(G3(:,:,:,456),Q(:,121),MB,G4(:,:,:,197))
  call loop_QZ_A(G4(:,:,:,197),wf(:,27),G4(:,:,:,198),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,198),Q(:,127),MB,G5tensor(:,99))
  call loop_QV_A(G2(:,:,:,301),wf(:,-6),G2(:,:,:,304))
  call loop_Q_A(G2(:,:,:,304),Q(:,89),MB,G3(:,:,:,457))
  call loop_QV_A(G3(:,:,:,457),wf(:,-5),G3(:,:,:,458))
  call loop_Q_A(G3(:,:,:,458),Q(:,121),MB,G4(:,:,:,199))
  call loop_QZ_A(G4(:,:,:,199),wf(:,27),G4(:,:,:,200),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,200),Q(:,127),MB,G5tensor(:,100))
  call loop_QV_A(G1(:,:,:,76),wf(:,9),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,105),MB,G2(:,:,:,305))
  call loop_QV_A(G2(:,:,:,305),wf(:,-4),G2(:,:,:,306))
  call loop_Q_A(G2(:,:,:,306),Q(:,121),MB,G3(:,:,:,459))
  call loop_QZ_A(G3(:,:,:,459),wf(:,27),G3(:,:,:,460),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,460),Q(:,127),MB,G4tensor(:,196))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,26),G0(:,:,:,14),gZd)
  call loop_A_Q(G0(:,:,:,14),Q(:,9),ZERO,G1(:,:,:,83))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-6),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,73),ZERO,G2(:,:,:,307))
  call loop_AV_Q(G2(:,:,:,307),wf(:,3),G2(:,:,:,308))
  call loop_A_Q(G2(:,:,:,308),Q(:,121),ZERO,G3(:,:,:,461))
  call loop_AZ_Q(G3(:,:,:,461),wf(:,27),G3(:,:,:,462),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,462),Q(:,127),ZERO,G4tensor(:,197))
  call loop_AV_Q(G2(:,:,:,307),wf(:,-4),G2(:,:,:,309))
  call loop_A_Q(G2(:,:,:,309),Q(:,89),ZERO,G3(:,:,:,463))
  call loop_AV_Q(G3(:,:,:,463),wf(:,-5),G3(:,:,:,464))
  call loop_A_Q(G3(:,:,:,464),Q(:,121),ZERO,G4(:,:,:,201))
  call loop_AZ_Q(G4(:,:,:,201),wf(:,27),G4(:,:,:,202),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,202),Q(:,127),ZERO,G5tensor(:,101))
  call loop_AV_Q(G2(:,:,:,307),wf(:,-5),G2(:,:,:,310))
  call loop_A_Q(G2(:,:,:,310),Q(:,105),ZERO,G3(:,:,:,465))
  call loop_AV_Q(G3(:,:,:,465),wf(:,-4),G3(:,:,:,466))
  call loop_A_Q(G3(:,:,:,466),Q(:,121),ZERO,G4(:,:,:,203))
  call loop_AZ_Q(G4(:,:,:,203),wf(:,27),G4(:,:,:,204),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,204),Q(:,127),ZERO,G5tensor(:,102))
  call loop_AV_Q(G1(:,:,:,83),wf(:,3),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,57),ZERO,G2(:,:,:,311))
  call loop_AV_Q(G2(:,:,:,311),wf(:,-6),G2(:,:,:,312))
  call loop_A_Q(G2(:,:,:,312),Q(:,121),ZERO,G3(:,:,:,467))
  call loop_AZ_Q(G3(:,:,:,467),wf(:,27),G3(:,:,:,468),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,468),Q(:,127),ZERO,G4tensor(:,198))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-5),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,41),ZERO,G2(:,:,:,313))
  call loop_AV_Q(G2(:,:,:,313),wf(:,7),G2(:,:,:,314))
  call loop_A_Q(G2(:,:,:,314),Q(:,121),ZERO,G3(:,:,:,469))
  call loop_AZ_Q(G3(:,:,:,469),wf(:,27),G3(:,:,:,470),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,470),Q(:,127),ZERO,G4tensor(:,199))
  call loop_AV_Q(G2(:,:,:,313),wf(:,-4),G2(:,:,:,315))
  call loop_A_Q(G2(:,:,:,315),Q(:,57),ZERO,G3(:,:,:,471))
  call loop_AV_Q(G3(:,:,:,471),wf(:,-6),G3(:,:,:,472))
  call loop_A_Q(G3(:,:,:,472),Q(:,121),ZERO,G4(:,:,:,205))
  call loop_AZ_Q(G4(:,:,:,205),wf(:,27),G4(:,:,:,206),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,206),Q(:,127),ZERO,G5tensor(:,103))
  call loop_AV_Q(G2(:,:,:,313),wf(:,-6),G2(:,:,:,316))
  call loop_A_Q(G2(:,:,:,316),Q(:,105),ZERO,G3(:,:,:,473))
  call loop_AV_Q(G3(:,:,:,473),wf(:,-4),G3(:,:,:,474))
  call loop_A_Q(G3(:,:,:,474),Q(:,121),ZERO,G4(:,:,:,207))
  call loop_AZ_Q(G4(:,:,:,207),wf(:,27),G4(:,:,:,208),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,208),Q(:,127),ZERO,G5tensor(:,104))
  call loop_AV_Q(G1(:,:,:,83),wf(:,7),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,89),ZERO,G2(:,:,:,317))
  call loop_AV_Q(G2(:,:,:,317),wf(:,-5),G2(:,:,:,318))
  call loop_A_Q(G2(:,:,:,318),Q(:,121),ZERO,G3(:,:,:,475))
  call loop_AZ_Q(G3(:,:,:,475),wf(:,27),G3(:,:,:,476),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,476),Q(:,127),ZERO,G4tensor(:,200))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-4),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,25),ZERO,G2(:,:,:,319))
  call loop_AV_Q(G2(:,:,:,319),wf(:,9),G2(:,:,:,320))
  call loop_A_Q(G2(:,:,:,320),Q(:,121),ZERO,G3(:,:,:,477))
  call loop_AZ_Q(G3(:,:,:,477),wf(:,27),G3(:,:,:,478),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,478),Q(:,127),ZERO,G4tensor(:,201))
  call loop_AV_Q(G2(:,:,:,319),wf(:,-5),G2(:,:,:,321))
  call loop_A_Q(G2(:,:,:,321),Q(:,57),ZERO,G3(:,:,:,479))
  call loop_AV_Q(G3(:,:,:,479),wf(:,-6),G3(:,:,:,480))
  call loop_A_Q(G3(:,:,:,480),Q(:,121),ZERO,G4(:,:,:,209))
  call loop_AZ_Q(G4(:,:,:,209),wf(:,27),G4(:,:,:,210),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,210),Q(:,127),ZERO,G5tensor(:,105))
  call loop_AV_Q(G2(:,:,:,319),wf(:,-6),G2(:,:,:,322))
  call loop_A_Q(G2(:,:,:,322),Q(:,89),ZERO,G3(:,:,:,481))
  call loop_AV_Q(G3(:,:,:,481),wf(:,-5),G3(:,:,:,482))
  call loop_A_Q(G3(:,:,:,482),Q(:,121),ZERO,G4(:,:,:,211))
  call loop_AZ_Q(G4(:,:,:,211),wf(:,27),G4(:,:,:,212),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,212),Q(:,127),ZERO,G5tensor(:,106))
  call loop_AV_Q(G1(:,:,:,83),wf(:,9),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,105),ZERO,G2(:,:,:,323))
  call loop_AV_Q(G2(:,:,:,323),wf(:,-4),G2(:,:,:,324))
  call loop_A_Q(G2(:,:,:,324),Q(:,121),ZERO,G3(:,:,:,483))
  call loop_AZ_Q(G3(:,:,:,483),wf(:,27),G3(:,:,:,484),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,484),Q(:,127),ZERO,G4tensor(:,202))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,26),G0(:,:,:,15),gZd)
  call loop_A_Q(G0(:,:,:,15),Q(:,9),MB,G1(:,:,:,90))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-6),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,73),MB,G2(:,:,:,325))
  call loop_AV_Q(G2(:,:,:,325),wf(:,3),G2(:,:,:,326))
  call loop_A_Q(G2(:,:,:,326),Q(:,121),MB,G3(:,:,:,485))
  call loop_AZ_Q(G3(:,:,:,485),wf(:,27),G3(:,:,:,486),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,486),Q(:,127),MB,G4tensor(:,203))
  call loop_AV_Q(G2(:,:,:,325),wf(:,-4),G2(:,:,:,327))
  call loop_A_Q(G2(:,:,:,327),Q(:,89),MB,G3(:,:,:,487))
  call loop_AV_Q(G3(:,:,:,487),wf(:,-5),G3(:,:,:,488))
  call loop_A_Q(G3(:,:,:,488),Q(:,121),MB,G4(:,:,:,213))
  call loop_AZ_Q(G4(:,:,:,213),wf(:,27),G4(:,:,:,214),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,214),Q(:,127),MB,G5tensor(:,107))
  call loop_AV_Q(G2(:,:,:,325),wf(:,-5),G2(:,:,:,328))
  call loop_A_Q(G2(:,:,:,328),Q(:,105),MB,G3(:,:,:,489))
  call loop_AV_Q(G3(:,:,:,489),wf(:,-4),G3(:,:,:,490))
  call loop_A_Q(G3(:,:,:,490),Q(:,121),MB,G4(:,:,:,215))
  call loop_AZ_Q(G4(:,:,:,215),wf(:,27),G4(:,:,:,216),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,216),Q(:,127),MB,G5tensor(:,108))
  call loop_AV_Q(G1(:,:,:,90),wf(:,3),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,57),MB,G2(:,:,:,329))
  call loop_AV_Q(G2(:,:,:,329),wf(:,-6),G2(:,:,:,330))
  call loop_A_Q(G2(:,:,:,330),Q(:,121),MB,G3(:,:,:,491))
  call loop_AZ_Q(G3(:,:,:,491),wf(:,27),G3(:,:,:,492),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,492),Q(:,127),MB,G4tensor(:,204))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-5),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,41),MB,G2(:,:,:,331))
  call loop_AV_Q(G2(:,:,:,331),wf(:,7),G2(:,:,:,332))
  call loop_A_Q(G2(:,:,:,332),Q(:,121),MB,G3(:,:,:,493))
  call loop_AZ_Q(G3(:,:,:,493),wf(:,27),G3(:,:,:,494),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,494),Q(:,127),MB,G4tensor(:,205))
  call loop_AV_Q(G2(:,:,:,331),wf(:,-4),G2(:,:,:,333))
  call loop_A_Q(G2(:,:,:,333),Q(:,57),MB,G3(:,:,:,495))
  call loop_AV_Q(G3(:,:,:,495),wf(:,-6),G3(:,:,:,496))
  call loop_A_Q(G3(:,:,:,496),Q(:,121),MB,G4(:,:,:,217))
  call loop_AZ_Q(G4(:,:,:,217),wf(:,27),G4(:,:,:,218),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,218),Q(:,127),MB,G5tensor(:,109))
  call loop_AV_Q(G2(:,:,:,331),wf(:,-6),G2(:,:,:,334))
  call loop_A_Q(G2(:,:,:,334),Q(:,105),MB,G3(:,:,:,497))
  call loop_AV_Q(G3(:,:,:,497),wf(:,-4),G3(:,:,:,498))
  call loop_A_Q(G3(:,:,:,498),Q(:,121),MB,G4(:,:,:,219))
  call loop_AZ_Q(G4(:,:,:,219),wf(:,27),G4(:,:,:,220),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,220),Q(:,127),MB,G5tensor(:,110))
  call loop_AV_Q(G1(:,:,:,90),wf(:,7),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,89),MB,G2(:,:,:,335))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-5),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,121),MB,G3(:,:,:,499))
  call loop_AZ_Q(G3(:,:,:,499),wf(:,27),G3(:,:,:,500),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,500),Q(:,127),MB,G4tensor(:,206))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-4),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,25),MB,G2(:,:,:,337))
  call loop_AV_Q(G2(:,:,:,337),wf(:,9),G2(:,:,:,338))
  call loop_A_Q(G2(:,:,:,338),Q(:,121),MB,G3(:,:,:,501))
  call loop_AZ_Q(G3(:,:,:,501),wf(:,27),G3(:,:,:,502),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,502),Q(:,127),MB,G4tensor(:,207))
  call loop_AV_Q(G2(:,:,:,337),wf(:,-5),G2(:,:,:,339))
  call loop_A_Q(G2(:,:,:,339),Q(:,57),MB,G3(:,:,:,503))
  call loop_AV_Q(G3(:,:,:,503),wf(:,-6),G3(:,:,:,504))
  call loop_A_Q(G3(:,:,:,504),Q(:,121),MB,G4(:,:,:,221))
  call loop_AZ_Q(G4(:,:,:,221),wf(:,27),G4(:,:,:,222),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,222),Q(:,127),MB,G5tensor(:,111))
  call loop_AV_Q(G2(:,:,:,337),wf(:,-6),G2(:,:,:,340))
  call loop_A_Q(G2(:,:,:,340),Q(:,89),MB,G3(:,:,:,505))
  call loop_AV_Q(G3(:,:,:,505),wf(:,-5),G3(:,:,:,506))
  call loop_A_Q(G3(:,:,:,506),Q(:,121),MB,G4(:,:,:,223))
  call loop_AZ_Q(G4(:,:,:,223),wf(:,27),G4(:,:,:,224),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,224),Q(:,127),MB,G5tensor(:,112))
  call loop_AV_Q(G1(:,:,:,90),wf(:,9),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,105),MB,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-4),G2(:,:,:,342))
  call loop_A_Q(G2(:,:,:,342),Q(:,121),MB,G3(:,:,:,507))
  call loop_AZ_Q(G3(:,:,:,507),wf(:,27),G3(:,:,:,508),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,508),Q(:,127),MB,G4tensor(:,208))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(11) * den(39)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(39)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,1),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(11) * den(39)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(11)) * den(39)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(9) * den(39)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(39)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,21),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(9) * den(39)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(9)) * den(39)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,31),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,89),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,89),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,23),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,23),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,125),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,125),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,1),T4sum(1:70,20))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_17,masses2_5,G4tensor(:,1),T4sum(1:70,20))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,90),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,90),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,67),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,67),T4sum(1:70,21))
  M(1) = M(1) + (-(CI*f(6)) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,126),T4sum(1:70,19))
  M(2) = M(2) + (CI*f(6) * den(88)) * TI2_call(4,momenta_17,masses2_6,G4tensor(:,126),T4sum(1:70,19))
  M(1) = M(1) + (-(CI*f(5)) * den(88)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,45),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(5) * den(88)) * TI2_call(4,momenta_17,masses2_4,G4tensor(:,45),T4sum(1:70,21))
  M(1) = M(1) + (-f(12) * den(36)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,2),T4sum(1:70,30))
  M(2) = M(2) + (-f(12) * den(36)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,24),T4sum(1:70,30))
  M(1) = M(1) + (-f(10) * den(36)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,46),T4sum(1:70,31))
  M(2) = M(2) + (-f(10) * den(36)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,68),T4sum(1:70,31))
  M(2) = M(2) + (-f(12) * den(36)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,12),T4sum(1:70,32))
  M(1) = M(1) + (-f(12) * den(36)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,34),T4sum(1:70,32))
  M(2) = M(2) + (-f(10) * den(36)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,56),T4sum(1:70,33))
  M(1) = M(1) + (-f(10) * den(36)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,78),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,53),T5sum(1:126,10))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,3),T5sum(1:126,11))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,37),T5sum(1:126,10))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_42,masses2_8,G5tensor(:,11),T5sum(1:126,11))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,54),T5sum(1:126,10))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_42,masses2_7,G5tensor(:,19),T5sum(1:126,12))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_42,masses2_9,G5tensor(:,38),T5sum(1:126,10))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_42,masses2_7,G5tensor(:,27),T5sum(1:126,12))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,57),T5sum(1:126,22))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,5),T5sum(1:126,23))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,41),T5sum(1:126,22))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_44,masses2_8,G5tensor(:,13),T5sum(1:126,23))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,58),T5sum(1:126,22))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_44,masses2_7,G5tensor(:,21),T5sum(1:126,24))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_44,masses2_9,G5tensor(:,42),T5sum(1:126,22))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_44,masses2_7,G5tensor(:,29),T5sum(1:126,24))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,33),T5sum(1:126,31))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,9),T5sum(1:126,32))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,49),T5sum(1:126,31))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_40,masses2_8,G5tensor(:,1),T5sum(1:126,32))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,35),T5sum(1:126,31))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_40,masses2_7,G5tensor(:,25),T5sum(1:126,33))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_40,masses2_9,G5tensor(:,51),T5sum(1:126,31))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_40,masses2_7,G5tensor(:,17),T5sum(1:126,33))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,34),T5sum(1:126,34))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,10),T5sum(1:126,35))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,50),T5sum(1:126,34))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_39,masses2_8,G5tensor(:,2),T5sum(1:126,35))
  M(2) = M(2) + (f(8) * den(4)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,36),T5sum(1:126,34))
  M(2) = M(2) + (f(7) * den(4)) * TI2_call(5,momenta_39,masses2_7,G5tensor(:,26),T5sum(1:126,36))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(5,momenta_39,masses2_9,G5tensor(:,52),T5sum(1:126,34))
  M(1) = M(1) + (f(7) * den(4)) * TI2_call(5,momenta_39,masses2_7,G5tensor(:,18),T5sum(1:126,36))
  M(1) = M(1) + (-(CI*f(6)) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,41),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,57),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(93)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,2),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,42),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,32),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(93)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,58),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(93)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,22),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,43),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(94)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(94)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,13),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,59),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,59),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(94)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(94)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,3),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(94)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(94)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,33),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,60),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(94)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,60),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(94)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(94)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,6))
  M(1) = M(1) + (f(8) * den(78)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,127),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(78)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,3),T4sum(1:70,30))
  M(2) = M(2) + (f(8) * den(78)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,91),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(78)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,25),T4sum(1:70,30))
  M(1) = M(1) + (f(8) * den(78)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,128),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(78)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,47),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(78)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,92),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(78)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,69),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(78)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,143),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(78)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,13),T4sum(1:70,32))
  M(1) = M(1) + (f(8) * den(78)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,107),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(78)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,35),T4sum(1:70,32))
  M(2) = M(2) + (f(8) * den(78)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,144),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(78)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,57),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(78)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,108),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(78)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,79),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(79)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,129),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(79)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,4),T4sum(1:70,30))
  M(2) = M(2) + (f(8) * den(79)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,93),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(79)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,26),T4sum(1:70,30))
  M(1) = M(1) + (f(8) * den(79)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,130),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(79)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,48),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(79)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,94),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(79)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,70),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(79)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,145),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(79)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,14),T4sum(1:70,32))
  M(1) = M(1) + (f(8) * den(79)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,109),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(79)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,36),T4sum(1:70,32))
  M(2) = M(2) + (f(8) * den(79)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,146),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(79)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,58),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(79)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,110),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(79)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,80),T4sum(1:70,33))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,161),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,161),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,167),T4sum(1:70,41))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,167),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,173),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,173),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,179),T4sum(1:70,41))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,179),T4sum(1:70,41))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,185),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,185),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,191),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,191),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,197),T4sum(1:70,40))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_7,masses2_6,G4tensor(:,197),T4sum(1:70,40))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,203),T4sum(1:70,42))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,203),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,174),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,174),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,180),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,180),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,162),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,162),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,168),T4sum(1:70,44))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,168),T4sum(1:70,44))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,198),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,198),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,204),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,204),T4sum(1:70,45))
  M(1) = M(1) + (CI*f(6) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,186),T4sum(1:70,43))
  M(2) = M(2) + (-(CI*f(6)) * den(95)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,186),T4sum(1:70,43))
  M(1) = M(1) + (CI*f(5) * den(95)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,192),T4sum(1:70,45))
  M(2) = M(2) + (-(CI*f(5)) * den(95)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,192),T4sum(1:70,45))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,163),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,163),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,169),T4sum(1:70,50))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,169),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,175),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,175),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,181),T4sum(1:70,50))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,181),T4sum(1:70,50))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,187),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,187),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,193),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,193),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,199),T4sum(1:70,49))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,199),T4sum(1:70,49))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,205),T4sum(1:70,51))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,205),T4sum(1:70,51))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,176),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,176),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,182),T4sum(1:70,53))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,182),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,164),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,164),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,170),T4sum(1:70,53))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,170),T4sum(1:70,53))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,200),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,200),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,206),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,206),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(6)) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,188),T4sum(1:70,52))
  M(2) = M(2) + (CI*f(6) * den(96)) * TI2_call(4,momenta_8,masses2_6,G4tensor(:,188),T4sum(1:70,52))
  M(1) = M(1) + (-(CI*f(5)) * den(96)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,194),T4sum(1:70,54))
  M(2) = M(2) + (CI*f(5) * den(96)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,194),T4sum(1:70,54))
  M(1) = M(1) + (-(CI*f(11)) * den(54)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(54)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,4),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(11)) * den(54)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(11) * den(54)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(9)) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(9)) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(9) * den(54)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,34),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,159),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,159),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,22),T4sum(1:70,56))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,22),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,123),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,123),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,44),T4sum(1:70,56))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_16,masses2_5,G4tensor(:,44),T4sum(1:70,56))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,160),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,160),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,66),T4sum(1:70,57))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,66),T4sum(1:70,57))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,124),T4sum(1:70,55))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_16,masses2_6,G4tensor(:,124),T4sum(1:70,55))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,88),T4sum(1:70,57))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_16,masses2_4,G4tensor(:,88),T4sum(1:70,57))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,165),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,165),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,171),T4sum(1:70,59))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,171),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,177),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,177),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,183),T4sum(1:70,59))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,183),T4sum(1:70,59))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,189),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,189),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,195),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,195),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,201),T4sum(1:70,58))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,201),T4sum(1:70,58))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,207),T4sum(1:70,60))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,207),T4sum(1:70,60))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,178),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,178),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,184),T4sum(1:70,62))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,184),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,166),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,166),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,172),T4sum(1:70,62))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,172),T4sum(1:70,62))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,202),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,202),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,208),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,208),T4sum(1:70,63))
  M(1) = M(1) + (CI*f(6) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,190),T4sum(1:70,61))
  M(2) = M(2) + (-(CI*f(6)) * den(97)) * TI2_call(4,momenta_9,masses2_6,G4tensor(:,190),T4sum(1:70,61))
  M(1) = M(1) + (CI*f(5) * den(97)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,196),T4sum(1:70,63))
  M(2) = M(2) + (-(CI*f(5)) * den(97)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,196),T4sum(1:70,63))
  M(1) = M(1) + (f(12) * den(51)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,5),T4sum(1:70,30))
  M(2) = M(2) + (f(12) * den(51)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,27),T4sum(1:70,30))
  M(1) = M(1) + (f(10) * den(51)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,49),T4sum(1:70,31))
  M(2) = M(2) + (f(10) * den(51)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,71),T4sum(1:70,31))
  M(2) = M(2) + (f(12) * den(51)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,15),T4sum(1:70,32))
  M(1) = M(1) + (f(12) * den(51)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,37),T4sum(1:70,32))
  M(2) = M(2) + (f(10) * den(51)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,59),T4sum(1:70,33))
  M(1) = M(1) + (f(10) * den(51)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,81),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,67),T5sum(1:126,37))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,73),T5sum(1:126,38))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,79),T5sum(1:126,37))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,85),T5sum(1:126,38))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,91),T5sum(1:126,37))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,97),T5sum(1:126,39))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_27,masses2_9,G5tensor(:,103),T5sum(1:126,37))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,109),T5sum(1:126,39))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,77),T5sum(1:126,40))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,83),T5sum(1:126,41))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,65),T5sum(1:126,40))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_29,masses2_8,G5tensor(:,71),T5sum(1:126,41))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,101),T5sum(1:126,40))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,107),T5sum(1:126,42))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_29,masses2_9,G5tensor(:,89),T5sum(1:126,40))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_29,masses2_7,G5tensor(:,95),T5sum(1:126,42))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,81),T5sum(1:126,43))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,87),T5sum(1:126,44))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,69),T5sum(1:126,43))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,75),T5sum(1:126,44))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,105),T5sum(1:126,43))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,111),T5sum(1:126,45))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_25,masses2_9,G5tensor(:,93),T5sum(1:126,43))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,99),T5sum(1:126,45))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,66),T5sum(1:126,49))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,72),T5sum(1:126,50))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,78),T5sum(1:126,49))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_30,masses2_8,G5tensor(:,84),T5sum(1:126,50))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,90),T5sum(1:126,49))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,96),T5sum(1:126,51))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_30,masses2_9,G5tensor(:,102),T5sum(1:126,49))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_30,masses2_7,G5tensor(:,108),T5sum(1:126,51))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,55),T5sum(1:126,52))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,4),T5sum(1:126,53))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,39),T5sum(1:126,52))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_41,masses2_8,G5tensor(:,12),T5sum(1:126,53))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,56),T5sum(1:126,52))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_41,masses2_7,G5tensor(:,20),T5sum(1:126,54))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_41,masses2_9,G5tensor(:,40),T5sum(1:126,52))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_41,masses2_7,G5tensor(:,28),T5sum(1:126,54))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,82),T5sum(1:126,55))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,88),T5sum(1:126,56))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,70),T5sum(1:126,55))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,76),T5sum(1:126,56))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,106),T5sum(1:126,55))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,112),T5sum(1:126,57))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_26,masses2_9,G5tensor(:,94),T5sum(1:126,55))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,100),T5sum(1:126,57))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,68),T5sum(1:126,61))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,74),T5sum(1:126,62))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,80),T5sum(1:126,61))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_28,masses2_8,G5tensor(:,86),T5sum(1:126,62))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,92),T5sum(1:126,61))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,98),T5sum(1:126,63))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_28,masses2_9,G5tensor(:,104),T5sum(1:126,61))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_28,masses2_7,G5tensor(:,110),T5sum(1:126,63))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,59),T5sum(1:126,64))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,6),T5sum(1:126,65))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,43),T5sum(1:126,64))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_43,masses2_8,G5tensor(:,14),T5sum(1:126,65))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,60),T5sum(1:126,64))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_43,masses2_7,G5tensor(:,22),T5sum(1:126,66))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_43,masses2_9,G5tensor(:,44),T5sum(1:126,64))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_43,masses2_7,G5tensor(:,30),T5sum(1:126,66))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,61),T5sum(1:126,67))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,7),T5sum(1:126,68))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,45),T5sum(1:126,67))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_37,masses2_8,G5tensor(:,15),T5sum(1:126,68))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,63),T5sum(1:126,67))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,23),T5sum(1:126,69))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_37,masses2_9,G5tensor(:,47),T5sum(1:126,67))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_37,masses2_7,G5tensor(:,31),T5sum(1:126,69))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,62),T5sum(1:126,70))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,8),T5sum(1:126,71))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,46),T5sum(1:126,70))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_38,masses2_8,G5tensor(:,16),T5sum(1:126,71))
  M(2) = M(2) + (-f(8) * den(19)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,64),T5sum(1:126,70))
  M(2) = M(2) + (-f(7) * den(19)) * TI2_call(5,momenta_38,masses2_7,G5tensor(:,24),T5sum(1:126,72))
  M(1) = M(1) + (-f(8) * den(19)) * TI2_call(5,momenta_38,masses2_9,G5tensor(:,48),T5sum(1:126,70))
  M(1) = M(1) + (-f(7) * den(19)) * TI2_call(5,momenta_38,masses2_7,G5tensor(:,32),T5sum(1:126,72))
  M(1) = M(1) + (CI*f(6) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(102)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(102)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,15),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,61),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,61),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(102)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(102)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,5),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(102)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(102)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,35),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,62),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(102)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,62),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(102)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(102)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(103)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(103)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,16),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,63),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,63),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(103)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(103)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,6),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,48),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(103)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(103)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,36),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,64),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(103)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,64),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(103)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(103)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(1) = M(1) + (-f(8) * den(80)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,131),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,6),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(80)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,95),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(80)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,28),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(80)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,132),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,50),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(80)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,96),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(80)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,72),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(80)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,147),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(80)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,16),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(80)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,111),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,38),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(80)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,148),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(80)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,60),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(80)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,112),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(80)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,82),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(81)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,133),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(81)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,7),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(81)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,97),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(81)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,29),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(81)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,134),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(81)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,51),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(81)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,98),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(81)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,73),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(81)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,149),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(81)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,17),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(81)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,113),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(81)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,39),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(81)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,150),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(81)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,61),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(81)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,114),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(81)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,83),T4sum(1:70,33))
  M(1) = M(1) + (CI*f(6) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(108)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(108)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,17),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,65),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,65),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(108)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(108)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(108)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(108)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,37),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,66),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(108)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,66),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(108)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(108)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(109)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(109)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,18),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,67),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,67),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(109)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(109)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(6) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(109)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(109)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,38),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(6) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,68),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(6)) * den(109)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,68),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(109)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(109)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(1) = M(1) + (-f(8) * den(82)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,135),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(82)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,8),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(82)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,99),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(82)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,30),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(82)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,136),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(82)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,52),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(82)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,100),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(82)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,74),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(82)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,151),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(82)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,18),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(82)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,115),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(82)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,40),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(82)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,152),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(82)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,62),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(82)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,116),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(82)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,84),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(83)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,137),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,9),T4sum(1:70,30))
  M(2) = M(2) + (-f(8) * den(83)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,101),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(83)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,31),T4sum(1:70,30))
  M(1) = M(1) + (-f(8) * den(83)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,138),T4sum(1:70,35))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,53),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(83)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,102),T4sum(1:70,35))
  M(2) = M(2) + (-f(7) * den(83)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,75),T4sum(1:70,31))
  M(2) = M(2) + (-f(8) * den(83)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,153),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(83)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,19),T4sum(1:70,32))
  M(1) = M(1) + (-f(8) * den(83)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,117),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,41),T4sum(1:70,32))
  M(2) = M(2) + (-f(8) * den(83)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,154),T4sum(1:70,36))
  M(2) = M(2) + (-f(7) * den(83)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,63),T4sum(1:70,33))
  M(1) = M(1) + (-f(8) * den(83)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,118),T4sum(1:70,36))
  M(1) = M(1) + (-f(7) * den(83)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,85),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(6)) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(114)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(114)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,69),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,69),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(114)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(114)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(114)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(114)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,39),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,70),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(114)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,70),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(114)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(114)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,55),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(115)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,71),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,71),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(115)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(6)) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,56),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(115)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,40),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(6)) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,72),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(115)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,72),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(115)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(1) = M(1) + (f(8) * den(84)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,139),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(84)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,10),T4sum(1:70,30))
  M(2) = M(2) + (f(8) * den(84)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,103),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(84)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,32),T4sum(1:70,30))
  M(1) = M(1) + (f(8) * den(84)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,140),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(84)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,54),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(84)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,104),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(84)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,76),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(84)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,155),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(84)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,20),T4sum(1:70,32))
  M(1) = M(1) + (f(8) * den(84)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,119),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(84)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,42),T4sum(1:70,32))
  M(2) = M(2) + (f(8) * den(84)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,156),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(84)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,64),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(84)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,120),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(84)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,86),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(85)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,141),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(85)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,11),T4sum(1:70,30))
  M(2) = M(2) + (f(8) * den(85)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,105),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(85)) * TI2_call(4,momenta_18,masses2_5,G4tensor(:,33),T4sum(1:70,30))
  M(1) = M(1) + (f(8) * den(85)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,142),T4sum(1:70,35))
  M(1) = M(1) + (f(7) * den(85)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,55),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(85)) * TI2_call(4,momenta_18,masses2_6,G4tensor(:,106),T4sum(1:70,35))
  M(2) = M(2) + (f(7) * den(85)) * TI2_call(4,momenta_18,masses2_4,G4tensor(:,77),T4sum(1:70,31))
  M(2) = M(2) + (f(8) * den(85)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,157),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(85)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,21),T4sum(1:70,32))
  M(1) = M(1) + (f(8) * den(85)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,121),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(85)) * TI2_call(4,momenta_19,masses2_5,G4tensor(:,43),T4sum(1:70,32))
  M(2) = M(2) + (f(8) * den(85)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,158),T4sum(1:70,36))
  M(2) = M(2) + (f(7) * den(85)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,65),T4sum(1:70,33))
  M(1) = M(1) + (f(8) * den(85)) * TI2_call(4,momenta_19,masses2_6,G4tensor(:,122),T4sum(1:70,36))
  M(1) = M(1) + (f(7) * den(85)) * TI2_call(4,momenta_19,masses2_4,G4tensor(:,87),T4sum(1:70,33))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_2_ppllllj2_nenenexnexggg_1_/**/REALKIND
